/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "sds_gui_fi/SdsPhoneService.h"
#include "sds_gui_fi/SdsPhoneServiceConst.h"
#include "sds_gui_fi/SdsPhoneServiceDBus.h"
#include "sds_gui_fi/SdsPhoneServiceJson.h"
#include "sds_gui_fi/SdsPhoneServiceProxy.h"

#include "asf/dbus/DBusDaemonProxy.h"
#include "asf/dbus/DBusPropertiesProxyWrapper.h"
#include "asf/dbus/DBusProxyDelegate.h"
#include "asf/dbus/DBusMessage.h"

namespace sds_gui_fi {
namespace SdsPhoneService {

DEFINE_CLASS_LOGGER("/sds_gui_fi/sds_gui_fi/SdsPhoneService", SdsPhoneServiceProxy);

class SdsPhoneServiceProxyCallback : public ::asf::dbus::DBusProxyCallback {
public:

    SdsPhoneServiceProxyCallback(uint16 functionId, void* callback) :
        ::asf::dbus::DBusProxyCallback (functionId, callback)
    {}

    bool processMessage (::asf::dbus::DBusMessage &message) {
        const ::boost::shared_ptr< SdsPhoneServiceProxy >& proxyShared = ::boost::static_pointer_cast< SdsPhoneServiceProxy >(message.getDBusProxyShared()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        switch (_functionId) {
            case ID_SpokenDigits:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SpokenDigitsSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "SpokenDigits", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<SpokenDigitsSignal> payload = ::boost::static_pointer_cast<SpokenDigitsSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((SpokenDigitsCallbackIF*) _callback)->onSpokenDigitsSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_SmsContent:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SmsContentSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "SmsContent", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<SmsContentSignal> payload = ::boost::static_pointer_cast<SmsContentSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((SmsContentCallbackIF*) _callback)->onSmsContentSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_UserWordUpdate:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), UserWordUpdateSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "UserWordUpdate", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<UserWordUpdateSignal> payload = ::boost::static_pointer_cast<UserWordUpdateSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((UserWordUpdateCallbackIF*) _callback)->onUserWordUpdateSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_PhoneBookPhonetization:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), PhoneBookPhonetizationSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "PhoneBookPhonetization", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<PhoneBookPhonetizationSignal> payload = ::boost::static_pointer_cast<PhoneBookPhonetizationSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((PhoneBookPhonetizationCallbackIF*) _callback)->onPhoneBookPhonetizationSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_VoiceTagAction:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), VoiceTagActionError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "VoiceTagAction", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<VoiceTagActionError> payload = ::boost::static_pointer_cast<VoiceTagActionError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((VoiceTagActionCallbackIF*) _callback)->onVoiceTagActionError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), VoiceTagActionResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "VoiceTagAction", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<VoiceTagActionResponse> payload = ::boost::static_pointer_cast<VoiceTagActionResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((VoiceTagActionCallbackIF*) _callback)->onVoiceTagActionResponse (proxyShared, payload);
                        return true;
                    }
                }
            default:
            LOG_FATAL ("Received an invalid functionId, proxy=%p", message.getProxy());
        }
        LOG_FATAL("Receveid an invalid message, proxy=%p", message.getProxy());
        return false;
    }

    bool onServiceUnavailable (const ::boost::shared_ptr< ::asf::core::Proxy >& baseProxy) {
        switch (_functionId) {
            case ID_SpokenDigits: {
                ::boost::shared_ptr< SpokenDigitsError > payload = ::boost::shared_ptr< SpokenDigitsError >
                (new SpokenDigitsError(DBUS_ERROR_NO_SERVER, "The DBus service SdsPhoneService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SpokenDigits", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<SdsPhoneServiceProxy> proxyShared = ::boost::static_pointer_cast<SdsPhoneServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SpokenDigitsCallbackIF*) _callback)->onSpokenDigitsError (proxyShared,payload);
                return true;
            }
            break;
            case ID_SmsContent: {
                ::boost::shared_ptr< SmsContentError > payload = ::boost::shared_ptr< SmsContentError >
                (new SmsContentError(DBUS_ERROR_NO_SERVER, "The DBus service SdsPhoneService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SmsContent", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<SdsPhoneServiceProxy> proxyShared = ::boost::static_pointer_cast<SdsPhoneServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SmsContentCallbackIF*) _callback)->onSmsContentError (proxyShared,payload);
                return true;
            }
            break;
            case ID_UserWordUpdate: {
                ::boost::shared_ptr< UserWordUpdateError > payload = ::boost::shared_ptr< UserWordUpdateError >
                (new UserWordUpdateError(DBUS_ERROR_NO_SERVER, "The DBus service SdsPhoneService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "UserWordUpdate", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<SdsPhoneServiceProxy> proxyShared = ::boost::static_pointer_cast<SdsPhoneServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((UserWordUpdateCallbackIF*) _callback)->onUserWordUpdateError (proxyShared,payload);
                return true;
            }
            break;
            case ID_PhoneBookPhonetization: {
                ::boost::shared_ptr< PhoneBookPhonetizationError > payload = ::boost::shared_ptr< PhoneBookPhonetizationError >
                (new PhoneBookPhonetizationError(DBUS_ERROR_NO_SERVER, "The DBus service SdsPhoneService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "PhoneBookPhonetization", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<SdsPhoneServiceProxy> proxyShared = ::boost::static_pointer_cast<SdsPhoneServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((PhoneBookPhonetizationCallbackIF*) _callback)->onPhoneBookPhonetizationError (proxyShared,payload);
                return true;
            }
            break;
            case ID_VoiceTagAction: {
                ::boost::shared_ptr< VoiceTagActionError > payload = ::boost::shared_ptr< VoiceTagActionError >
                (new VoiceTagActionError(DBUS_ERROR_NO_SERVER, "The DBus service SdsPhoneService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "VoiceTagAction", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<SdsPhoneServiceProxy> proxyShared = ::boost::static_pointer_cast<SdsPhoneServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((VoiceTagActionCallbackIF*) _callback)->onVoiceTagActionError (proxyShared,payload);
                return true;
            }
            break;
            default:
                break;
        }
        return false;
    }

    static ::asf::core::Logger&_logger;
};

::asf::core::Logger& SdsPhoneServiceProxyCallback::_logger (SdsPhoneServiceProxy::_logger);

SdsPhoneServiceProxy::SdsPhoneServiceProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable) :
    ::asf::dbus::DBusProxy(portName, "sds_gui_fi.SdsPhoneService", serviceAvailable, _logger) {
}

SdsPhoneServiceProxy::~SdsPhoneServiceProxy()
{
    sendDeregisterAll();
    ::asf::dbus::DBusConnector::getConnector(getConnectorOptions())->deregisterProxyDelegate(_dbusProxyDelegate);
}

// static
::boost::shared_ptr< SdsPhoneServiceProxy > SdsPhoneServiceProxy::createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable) {
    ::boost::shared_ptr< Proxy > proxyReuse = ::asf::dbus::DBusConnector::getProxy(portName, serviceAvailable);
    if(proxyReuse) {
        LOG_INFO_STATIC ("createProxy, reuse existing proxy");
        return ::boost::static_pointer_cast<SdsPhoneServiceProxy>(proxyReuse); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
    }
    LOG_INFO_STATIC ("createProxy, create new proxy");
    ::boost::shared_ptr< SdsPhoneServiceProxy > proxyNew(new SdsPhoneServiceProxy(portName, serviceAvailable));
    ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew);
    proxyNew->createHelperProxies(false);
    return proxyNew;
}

act_t SdsPhoneServiceProxy::addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const {
    SdsPhoneServiceProxyCallback* callback = new SdsPhoneServiceProxyCallback(methodId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->addMethodCallback (serial, memberName, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

act_t SdsPhoneServiceProxy::addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const {
    SdsPhoneServiceProxyCallback* callback = new SdsPhoneServiceProxyCallback(signalId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->registerSignalCallback (signal, reinterpret_cast<act_t>(callback), ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


void SdsPhoneServiceProxy::sendDeregisterAll () const
{
    sendSpokenDigitsDeregisterAll();
    sendSmsContentDeregisterAll();
    sendUserWordUpdateDeregisterAll();
    sendPhoneBookPhonetizationDeregisterAll();
}

act_t SdsPhoneServiceProxy::sendSpokenDigitsRegister(SpokenDigitsCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "SpokenDigits");
    act_t act = addSignalCallback(ID_SpokenDigits, "SpokenDigits", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "SpokenDigits", &cb, act);
    return act;
}

bool SdsPhoneServiceProxy::sendSpokenDigitsDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("SpokenDigits", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "SpokenDigits", act, static_cast<int>(rv));
    return rv;
}

void SdsPhoneServiceProxy::sendSpokenDigitsDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "SpokenDigits");
    _dbusProxyDelegate->deregisterSignalCallback("SpokenDigits", 0, _dbusDaemonProxy.get(), false);
}

act_t SdsPhoneServiceProxy::sendSmsContentRegister(SmsContentCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "SmsContent");
    act_t act = addSignalCallback(ID_SmsContent, "SmsContent", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "SmsContent", &cb, act);
    return act;
}

bool SdsPhoneServiceProxy::sendSmsContentDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("SmsContent", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "SmsContent", act, static_cast<int>(rv));
    return rv;
}

void SdsPhoneServiceProxy::sendSmsContentDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "SmsContent");
    _dbusProxyDelegate->deregisterSignalCallback("SmsContent", 0, _dbusDaemonProxy.get(), false);
}

act_t SdsPhoneServiceProxy::sendUserWordUpdateRegister(UserWordUpdateCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "UserWordUpdate");
    act_t act = addSignalCallback(ID_UserWordUpdate, "UserWordUpdate", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "UserWordUpdate", &cb, act);
    return act;
}

bool SdsPhoneServiceProxy::sendUserWordUpdateDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("UserWordUpdate", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "UserWordUpdate", act, static_cast<int>(rv));
    return rv;
}

void SdsPhoneServiceProxy::sendUserWordUpdateDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "UserWordUpdate");
    _dbusProxyDelegate->deregisterSignalCallback("UserWordUpdate", 0, _dbusDaemonProxy.get(), false);
}

act_t SdsPhoneServiceProxy::sendPhoneBookPhonetizationRegister(PhoneBookPhonetizationCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "PhoneBookPhonetization");
    act_t act = addSignalCallback(ID_PhoneBookPhonetization, "PhoneBookPhonetization", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "PhoneBookPhonetization", &cb, act);
    return act;
}

bool SdsPhoneServiceProxy::sendPhoneBookPhonetizationDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("PhoneBookPhonetization", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "PhoneBookPhonetization", act, static_cast<int>(rv));
    return rv;
}

void SdsPhoneServiceProxy::sendPhoneBookPhonetizationDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "PhoneBookPhonetization");
    _dbusProxyDelegate->deregisterSignalCallback("PhoneBookPhonetization", 0, _dbusDaemonProxy.get(), false);
}

act_t SdsPhoneServiceProxy::sendVoiceTagActionRequest(VoiceTagActionCallbackIF& cb, UserWordAction userAction, uint32 uniqueContactID, uint32 phoneProfileID) const {
    VoiceTagActionRequest* payload = new VoiceTagActionRequest();
    CHECK_ALLOCATION(payload);
    payload->setUserAction(userAction);
    payload->setUniqueContactID(uniqueContactID);
    payload->setPhoneProfileID(phoneProfileID);
    DBUS_MESSAGE_CALL(dbusMessage, "VoiceTagAction", VoiceTagActionRequest, payload, true)
    act_t act = addMethodCallback(ID_VoiceTagAction, dbusMessage.getUniqueSerial(), "VoiceTagAction", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "VoiceTagAction", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

} // namespace SdsPhoneService
} // namespace sds_gui_fi
