/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/Types.h"
#include "asf/stream/json.h"
#include "sds_gui_fi/SdsPhoneService.h"
#include "sds_gui_fi/SdsPhoneServiceConst.h"
#include "sds_gui_fi/SdsPhoneServiceJson.h"
#include "sds_gui_fi/SdsPhoneServiceJsonPrivate.h"
#include "yajl/yajl_gen.h"
#include <cstddef>
#include <cstring>
#include <string>
#include <vector>

using namespace ::asf::stream::json;


// Json serialization of "UserWordList"

void serializeJson (const ::sds_gui_fi::SdsPhoneService::UserWordList& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasUserWordProfileID()) {
        yajl_gen_string(g, (const unsigned char*)  "userWordProfileID" , 17);
        yajl_gen_integer(g, (long long)value.getUserWordProfileID());
    }
    if (!isSparse || value.hasPhoneUWID()) {
        yajl_gen_string(g, (const unsigned char*)  "phoneUWID" , 9);
        yajl_gen_array_open(g);
        const ::std::vector< uint32 >& o1 = value.getPhoneUWID();
        {
            ::std::vector< uint32 >::const_iterator o0;
            for (o0 = o1.begin(); o0 != o1.end(); ++o0) {
                yajl_gen_integer(g, (long long)(*o0));
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::sds_gui_fi::SdsPhoneService::UserWordList& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "VoiceTagActionRequest"

void serializeJson (const ::sds_gui_fi::SdsPhoneService::VoiceTagActionRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasUserAction()) {
        yajl_gen_string(g, (const unsigned char*)  "userAction" , 10);
        const char* s = ::sds_gui_fi::SdsPhoneService::UserWordAction_Name(value.getUserAction());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getUserAction());
    }
    if (!isSparse || value.hasUniqueContactID()) {
        yajl_gen_string(g, (const unsigned char*)  "uniqueContactID" , 15);
        yajl_gen_integer(g, (long long)value.getUniqueContactID());
    }
    if (!isSparse || value.hasPhoneProfileID()) {
        yajl_gen_string(g, (const unsigned char*)  "phoneProfileID" , 14);
        yajl_gen_integer(g, (long long)value.getPhoneProfileID());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::sds_gui_fi::SdsPhoneService::VoiceTagActionRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SpokenDigitsSignal"

void serializeJson (const ::sds_gui_fi::SdsPhoneService::SpokenDigitsSignal& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasDigits()) {
        yajl_gen_string(g, (const unsigned char*)  "digits" , 6);
        const char *s = value.getDigits().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::sds_gui_fi::SdsPhoneService::SpokenDigitsSignal& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SmsContentSignal"

void serializeJson (const ::sds_gui_fi::SdsPhoneService::SmsContentSignal& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasFirstLastSMS()) {
        yajl_gen_string(g, (const unsigned char*)  "firstLastSMS" , 12);
        const char* s = ::sds_gui_fi::SdsPhoneService::FirstLastSMS_Name(value.getFirstLastSMS());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getFirstLastSMS());
    }
    if (!isSparse || value.hasMessage()) {
        yajl_gen_string(g, (const unsigned char*)  "message" , 7);
        const char *s = value.getMessage().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::sds_gui_fi::SdsPhoneService::SmsContentSignal& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "UserWordUpdateSignal"

void serializeJson (const ::sds_gui_fi::SdsPhoneService::UserWordUpdateSignal& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasUserWordLists()) {
        yajl_gen_string(g, (const unsigned char*)  "userWordLists" , 13);
        yajl_gen_array_open(g);
        const ::std::vector< ::sds_gui_fi::SdsPhoneService::UserWordList >& o3 = value.getUserWordLists();
        {
            ::std::vector< ::sds_gui_fi::SdsPhoneService::UserWordList >::const_iterator o2;
            for (o2 = o3.begin(); o2 != o3.end(); ++o2) {
                serializeJson((*o2), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::sds_gui_fi::SdsPhoneService::UserWordUpdateSignal& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "PhoneBookPhonetizationSignal"

void serializeJson (const ::sds_gui_fi::SdsPhoneService::PhoneBookPhonetizationSignal& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasPhoneBookPhonetizationStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "phoneBookPhonetizationStatus" , 28);
        const char* s = ::sds_gui_fi::SdsPhoneService::PhoneBookPhonetization_Name(value.getPhoneBookPhonetizationStatus());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getPhoneBookPhonetizationStatus());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::sds_gui_fi::SdsPhoneService::PhoneBookPhonetizationSignal& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

using namespace ::asf::stream::json;

namespace sds_gui_fi {
namespace SdsPhoneService {

std::ostream& operator<<(std::ostream& o, const ::sds_gui_fi::SdsPhoneService::UserWordList& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SdsPhoneService
} // namespace sds_gui_fi
using namespace ::asf::stream::json;

namespace sds_gui_fi {
namespace SdsPhoneService {

std::ostream& operator<<(std::ostream& o, const ::sds_gui_fi::SdsPhoneService::VoiceTagActionRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SdsPhoneService
} // namespace sds_gui_fi
using namespace ::asf::stream::json;

namespace sds_gui_fi {
namespace SdsPhoneService {

std::ostream& operator<<(std::ostream& o, const ::sds_gui_fi::SdsPhoneService::SpokenDigitsSignal& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SdsPhoneService
} // namespace sds_gui_fi
using namespace ::asf::stream::json;

namespace sds_gui_fi {
namespace SdsPhoneService {

std::ostream& operator<<(std::ostream& o, const ::sds_gui_fi::SdsPhoneService::SmsContentSignal& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SdsPhoneService
} // namespace sds_gui_fi
using namespace ::asf::stream::json;

namespace sds_gui_fi {
namespace SdsPhoneService {

std::ostream& operator<<(std::ostream& o, const ::sds_gui_fi::SdsPhoneService::UserWordUpdateSignal& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SdsPhoneService
} // namespace sds_gui_fi
using namespace ::asf::stream::json;

namespace sds_gui_fi {
namespace SdsPhoneService {

std::ostream& operator<<(std::ostream& o, const ::sds_gui_fi::SdsPhoneService::PhoneBookPhonetizationSignal& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SdsPhoneService
} // namespace sds_gui_fi

