/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef SDS_GUI_FI_SDSGUISERVICESTUB_H
#define SDS_GUI_FI_SDSGUISERVICESTUB_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusStub.h"
#include "asf/dbus/DBusVariant.h"
#include "boost/shared_ptr.hpp"
#include "sds_gui_fi/SdsGuiService.h"
#include "sds_gui_fi/SdsGuiServiceConst.h"
#include <string>

namespace sds_gui_fi {
namespace SdsGuiService {

class SdsGuiServiceStubDelegate;

class SdsGuiServiceStub : public ::asf::dbus::DBusStub
{
public:

    /**
     * Create an instance of the SdsGuiServiceStub
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     */
    SdsGuiServiceStub (const std::string& portName);

    /**
     * Create an instance of the SdsGuiServiceStub
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     * @param objectPath the dbus object path, see
     * http://dbus.freedesktop.org/doc/dbus-specification.html#message-protocol-marshaling-object-path
     */
    SdsGuiServiceStub (const std::string& portName, const std::string& objectPath);

    virtual ~SdsGuiServiceStub();

    // signal 'ActivateAudioDeviceTag'

    /**
     * Raise the signal 'ActivateAudioDeviceTag' and send an update message to
     * registered clients.
     *
     * <b>Documentation of 'ActivateAudioDeviceTag'</b>:
     *
     * If the meaning of "ActivateAudioDeviceTag" isn't clear, then there should be a description here.
     *
     * @param deviceTag If the meaning of "deviceTag" isn't clear, then there should be a description here.
     *
     * @param audioSource If the meaning of "audioSource" isn't clear, then there should be a description here.
     */
    void sendActivateAudioDeviceTagSignal(uint32 deviceTag, AudioSource audioSource);

    // signal 'ActivateAudioSource'

    /**
     * Raise the signal 'ActivateAudioSource' and send an update message to
     * registered clients.
     *
     * <b>Documentation of 'ActivateAudioSource'</b>:
     *
     * If the meaning of "ActivateAudioSource" isn't clear, then there should be a description here.
     *
     * @param audioSource If the meaning of "audioSource" isn't clear, then there should be a description here.
     */
    void sendActivateAudioSourceSignal(AudioSource audioSource);

    // signal 'SpokenDigits'

    /**
     * Raise the signal 'SpokenDigits' and send an update message to
     * registered clients.
     *
     * <b>Documentation of 'SpokenDigits'</b>:
     *
     * OBSOLETE -> use SpokenDigits broadcast from sds_gui_fi::SdsPhoneService
     *
     * @param digits If the meaning of "digits" isn't clear, then there should be a description here.
     */
    void sendSpokenDigitsSignal(const ::std::string& digits);

    // signal 'Event'

    /**
     * Raise the signal 'Event' and send an update message to registered
     * clients.
     *
     * <b>Documentation of 'Event'</b>:
     *
     * If the meaning of "Event" isn't clear, then there should be a description here.
     *
     * @param guiEvent If the meaning of "guiEvent" isn't clear, then there should be a description here.
     */
    void sendEventSignal(Event guiEvent);

    // signal 'EarlyPromptFinished'

    /**
     * Raise the signal 'EarlyPromptFinished' and send an update message to
     * registered clients.
     *
     * <b>Documentation of 'EarlyPromptFinished'</b>:
     *
     * If the meaning of "EarlyPromptFinished" isn't clear, then there should be a description here.
     */
    void sendEarlyPromptFinishedSignal();

    // signal 'EarlyPromptTerminated'

    /**
     * Raise the signal 'EarlyPromptTerminated' and send an update message to
     * registered clients.
     *
     * <b>Documentation of 'EarlyPromptTerminated'</b>:
     *
     * If the meaning of "EarlyPromptTerminated" isn't clear, then there should be a description here.
     */
    void sendEarlyPromptTerminatedSignal();

    // property 'sdsStatus'

    /**
     * The method onSdsStatusGet() is called by ASF when a client invokes the
     * read method for the property 'sdsStatus'. The onSdsStatusGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'sdsStatus'</b>:
     *
     * OBSOLETE -> use sdsStatus attribute from sds_gui_fi::PopUpService
     */
    virtual void onSdsStatusGet(const ::boost::shared_ptr< SdsStatusGet >& payload);

    /**
     * Sends back the update to a previous onSdsStatusGet().
     *
     * <b>Documentation of 'sdsStatus'</b>:
     *
     * OBSOLETE -> use sdsStatus attribute from sds_gui_fi::PopUpService
     *
     * @param act Identifies a previous invocation of onSdsStatusGet(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendSdsStatusGetUpdate(SpeechInputState sdsStatus, act_t act = 0);

    /**
     * Set the value of the property 'sdsStatus' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'sdsStatus'</b>:
     *
     * OBSOLETE -> use sdsStatus attribute from sds_gui_fi::PopUpService
     */
    void setSdsStatus(SpeechInputState sdsStatus);

    /**
     * Returns the current value of the property 'sdsStatus'.
     *
     * <b>Documentation of 'sdsStatus'</b>:
     *
     * OBSOLETE -> use sdsStatus attribute from sds_gui_fi::PopUpService
     */
    SpeechInputState getSdsStatus() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendSdsStatusUpdate().
     *
     * <b>Documentation of 'sdsStatus'</b>:
     *
     * OBSOLETE -> use sdsStatus attribute from sds_gui_fi::PopUpService
     */
    void sendSdsStatusUpdate();

    // property 'HighPrioAppStatus'

    /**
     * The method onHighPrioAppStatusGet() is called by ASF when a client
     * invokes the read method for the property 'HighPrioAppStatus'. The
     * onHighPrioAppStatusGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'HighPrioAppStatus'</b>:
     *
     * If the meaning of "HighPrioAppStatus" isn't clear, then there should be a description here.
     */
    virtual void onHighPrioAppStatusGet(const ::boost::shared_ptr< HighPrioAppStatusGet >& payload);

    /**
     * Sends back the update to a previous onHighPrioAppStatusGet().
     *
     * <b>Documentation of 'HighPrioAppStatus'</b>:
     *
     * If the meaning of "HighPrioAppStatus" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of
     * onHighPrioAppStatusGet(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendHighPrioAppStatusGetUpdate(bool highPrioAppStatus, act_t act = 0);

    /**
     * The method onHighPrioAppStatusSet() is called by ASF when a client
     * invokes the write method for the property 'HighPrioAppStatus'. The
     * onHighPrioAppStatusSet() method set property value to the given
     * parameter HighPrioAppStatus by default. If this default behavior
     * doesn't match your needs feel free to override this method.
     *
     * <b>Documentation of 'HighPrioAppStatus'</b>:
     *
     * If the meaning of "HighPrioAppStatus" isn't clear, then there should be a description here.
     */
    virtual void onHighPrioAppStatusSet(const ::boost::shared_ptr< HighPrioAppStatusSet >& payload);

    /**
     * Sends back the update to a previous onHighPrioAppStatusSet().
     *
     * <b>Documentation of 'HighPrioAppStatus'</b>:
     *
     * If the meaning of "HighPrioAppStatus" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of
     * onHighPrioAppStatusSet(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendHighPrioAppStatusSetUpdate(act_t act = 0);

    /**
     * Set the value of the property 'HighPrioAppStatus' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'HighPrioAppStatus'</b>:
     *
     * If the meaning of "HighPrioAppStatus" isn't clear, then there should be a description here.
     */
    void setHighPrioAppStatus(bool highPrioAppStatus);

    /**
     * Returns the current value of the property 'HighPrioAppStatus'.
     *
     * <b>Documentation of 'HighPrioAppStatus'</b>:
     *
     * If the meaning of "HighPrioAppStatus" isn't clear, then there should be a description here.
     */
    bool getHighPrioAppStatus() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendHighPrioAppStatusUpdate().
     *
     * <b>Documentation of 'HighPrioAppStatus'</b>:
     *
     * If the meaning of "HighPrioAppStatus" isn't clear, then there should be a description here.
     */
    void sendHighPrioAppStatusUpdate();

    // method 'pttPress'

    /**
     * The method onPttPress() is called by ASF when a client invokes the
     * method 'pttPress'. A subclass has to implement this method and send
     * back a response to the client either with the sendPttPress() or
     * sendPttPressError() method. Do not invoke this method on your own.
     *
     * <b>Documentation of 'pttPress'</b>:
     *
     * If the meaning of "pttPress" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onPttPressRequest (const ::boost::shared_ptr< PttPressRequest >& request) = 0;

    /**
     * The method sendPttPressResponse() sends a response of a previous method
     * invocation of 'pttPress' back to the client.
     *
     * <b>Documentation of 'pttPress'</b>:
     *
     * If the meaning of "pttPress" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onPttPress(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendPttPressResponse (act_t act = 0);

    /**
     * The method sendPttPressError() sends an error response of a previous
     * method invocation of 'pttPress' back to the client.
     *
     * <b>Documentation of 'pttPress'</b>:
     *
     * If the meaning of "pttPress" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onPttPress(). If the act
     * is not specified, i.e. the most recent invocation will be answered. In
     * case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendPttPressError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'startSessionContext'

    /**
     * The method onStartSessionContext() is called by ASF when a client
     * invokes the method 'startSessionContext'. A subclass has to implement
     * this method and send back a response to the client either with the
     * sendStartSessionContext() or sendStartSessionContextError() method. Do
     * not invoke this method on your own.
     *
     * <b>Documentation of 'startSessionContext'</b>:
     *
     * If the meaning of "startSessionContext" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onStartSessionContextRequest (const ::boost::shared_ptr< StartSessionContextRequest >& request) = 0;

    /**
     * The method sendStartSessionContextResponse() sends a response of a
     * previous method invocation of 'startSessionContext' back to the client.
     *
     * <b>Documentation of 'startSessionContext'</b>:
     *
     * If the meaning of "startSessionContext" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onStartSessionContext(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendStartSessionContextResponse (act_t act = 0);

    /**
     * The method sendStartSessionContextError() sends an error response of a
     * previous method invocation of 'startSessionContext' back to the client.
     *
     * <b>Documentation of 'startSessionContext'</b>:
     *
     * If the meaning of "startSessionContext" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onStartSessionContext().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendStartSessionContextError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'ManualOperation'

    /**
     * The method onManualOperation() is called by ASF when a client invokes
     * the method 'ManualOperation'. A subclass has to implement this method
     * and send back a response to the client either with the
     * sendManualOperation() or sendManualOperationError() method. Do not
     * invoke this method on your own.
     *
     * <b>Documentation of 'ManualOperation'</b>:
     *
     * If the meaning of "ManualOperation" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onManualOperationRequest (const ::boost::shared_ptr< ManualOperationRequest >& request) = 0;

    /**
     * The method sendManualOperationResponse() sends a response of a previous
     * method invocation of 'ManualOperation' back to the client.
     *
     * <b>Documentation of 'ManualOperation'</b>:
     *
     * If the meaning of "ManualOperation" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onManualOperation(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendManualOperationResponse (act_t act = 0);

    /**
     * The method sendManualOperationError() sends an error response of a
     * previous method invocation of 'ManualOperation' back to the client.
     *
     * <b>Documentation of 'ManualOperation'</b>:
     *
     * If the meaning of "ManualOperation" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onManualOperation(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendManualOperationError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'TestModeUpdate'

    /**
     * The method onTestModeUpdate() is called by ASF when a client invokes
     * the method 'TestModeUpdate'. A subclass has to implement this method
     * and send back a response to the client either with the
     * sendTestModeUpdate() or sendTestModeUpdateError() method. Do not invoke
     * this method on your own.
     *
     * <b>Documentation of 'TestModeUpdate'</b>:
     *
     * If the meaning of "TestModeUpdate" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onTestModeUpdateRequest (const ::boost::shared_ptr< TestModeUpdateRequest >& request) = 0;

    /**
     * The method sendTestModeUpdateResponse() sends a response of a previous
     * method invocation of 'TestModeUpdate' back to the client.
     *
     * <b>Documentation of 'TestModeUpdate'</b>:
     *
     * If the meaning of "TestModeUpdate" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onTestModeUpdate(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendTestModeUpdateResponse (act_t act = 0);

    /**
     * The method sendTestModeUpdateError() sends an error response of a
     * previous method invocation of 'TestModeUpdate' back to the client.
     *
     * <b>Documentation of 'TestModeUpdate'</b>:
     *
     * If the meaning of "TestModeUpdate" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onTestModeUpdate(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendTestModeUpdateError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'BackPress'

    /**
     * The method onBackPress() is called by ASF when a client invokes the
     * method 'BackPress'. A subclass has to implement this method and send
     * back a response to the client either with the sendBackPress() or
     * sendBackPressError() method. Do not invoke this method on your own.
     *
     * <b>Documentation of 'BackPress'</b>:
     *
     * If the meaning of "BackPress" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onBackPressRequest (const ::boost::shared_ptr< BackPressRequest >& request) = 0;

    /**
     * The method sendBackPressResponse() sends a response of a previous
     * method invocation of 'BackPress' back to the client.
     *
     * <b>Documentation of 'BackPress'</b>:
     *
     * If the meaning of "BackPress" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onBackPress(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendBackPressResponse (act_t act = 0);

    /**
     * The method sendBackPressError() sends an error response of a previous
     * method invocation of 'BackPress' back to the client.
     *
     * <b>Documentation of 'BackPress'</b>:
     *
     * If the meaning of "BackPress" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onBackPress(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendBackPressError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'AbortSession'

    /**
     * The method onAbortSession() is called by ASF when a client invokes the
     * method 'AbortSession'. A subclass has to implement this method and send
     * back a response to the client either with the sendAbortSession() or
     * sendAbortSessionError() method. Do not invoke this method on your own.
     *
     * <b>Documentation of 'AbortSession'</b>:
     *
     * If the meaning of "AbortSession" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onAbortSessionRequest (const ::boost::shared_ptr< AbortSessionRequest >& request) = 0;

    /**
     * The method sendAbortSessionResponse() sends a response of a previous
     * method invocation of 'AbortSession' back to the client.
     *
     * <b>Documentation of 'AbortSession'</b>:
     *
     * If the meaning of "AbortSession" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onAbortSession(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendAbortSessionResponse (act_t act = 0);

    /**
     * The method sendAbortSessionError() sends an error response of a
     * previous method invocation of 'AbortSession' back to the client.
     *
     * <b>Documentation of 'AbortSession'</b>:
     *
     * If the meaning of "AbortSession" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onAbortSession(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendAbortSessionError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'StopSession'

    /**
     * The method onStopSession() is called by ASF when a client invokes the
     * method 'StopSession'. A subclass has to implement this method and send
     * back a response to the client either with the sendStopSession() or
     * sendStopSessionError() method. Do not invoke this method on your own.
     *
     * <b>Documentation of 'StopSession'</b>:
     *
     * If the meaning of "StopSession" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onStopSessionRequest (const ::boost::shared_ptr< StopSessionRequest >& request) = 0;

    /**
     * The method sendStopSessionResponse() sends a response of a previous
     * method invocation of 'StopSession' back to the client.
     *
     * <b>Documentation of 'StopSession'</b>:
     *
     * If the meaning of "StopSession" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onStopSession(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendStopSessionResponse (act_t act = 0);

    /**
     * The method sendStopSessionError() sends an error response of a previous
     * method invocation of 'StopSession' back to the client.
     *
     * <b>Documentation of 'StopSession'</b>:
     *
     * If the meaning of "StopSession" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onStopSession(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendStopSessionError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'PauseSession'

    /**
     * The method onPauseSession() is called by ASF when a client invokes the
     * method 'PauseSession'. A subclass has to implement this method and send
     * back a response to the client either with the sendPauseSession() or
     * sendPauseSessionError() method. Do not invoke this method on your own.
     *
     * <b>Documentation of 'PauseSession'</b>:
     *
     * If the meaning of "PauseSession" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onPauseSessionRequest (const ::boost::shared_ptr< PauseSessionRequest >& request) = 0;

    /**
     * The method sendPauseSessionResponse() sends a response of a previous
     * method invocation of 'PauseSession' back to the client.
     *
     * <b>Documentation of 'PauseSession'</b>:
     *
     * If the meaning of "PauseSession" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onPauseSession(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendPauseSessionResponse (act_t act = 0);

    /**
     * The method sendPauseSessionError() sends an error response of a
     * previous method invocation of 'PauseSession' back to the client.
     *
     * <b>Documentation of 'PauseSession'</b>:
     *
     * If the meaning of "PauseSession" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onPauseSession(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendPauseSessionError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'ResumeSession'

    /**
     * The method onResumeSession() is called by ASF when a client invokes the
     * method 'ResumeSession'. A subclass has to implement this method and
     * send back a response to the client either with the sendResumeSession()
     * or sendResumeSessionError() method. Do not invoke this method on your
     * own.
     *
     * <b>Documentation of 'ResumeSession'</b>:
     *
     * If the meaning of "ResumeSession" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onResumeSessionRequest (const ::boost::shared_ptr< ResumeSessionRequest >& request) = 0;

    /**
     * The method sendResumeSessionResponse() sends a response of a previous
     * method invocation of 'ResumeSession' back to the client.
     *
     * <b>Documentation of 'ResumeSession'</b>:
     *
     * If the meaning of "ResumeSession" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onResumeSession(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendResumeSessionResponse (act_t act = 0);

    /**
     * The method sendResumeSessionError() sends an error response of a
     * previous method invocation of 'ResumeSession' back to the client.
     *
     * <b>Documentation of 'ResumeSession'</b>:
     *
     * If the meaning of "ResumeSession" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onResumeSession(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendResumeSessionError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'settingsCommand'

    /**
     * The method onSettingsCommand() is called by ASF when a client invokes
     * the method 'settingsCommand'. A subclass has to implement this method
     * and send back a response to the client either with the
     * sendSettingsCommand() or sendSettingsCommandError() method. Do not
     * invoke this method on your own.
     *
     * <b>Documentation of 'settingsCommand'</b>:
     *
     * If the meaning of "settingsCommand" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onSettingsCommandRequest (const ::boost::shared_ptr< SettingsCommandRequest >& request) = 0;

    /**
     * The method sendSettingsCommandResponse() sends a response of a previous
     * method invocation of 'settingsCommand' back to the client.
     *
     * <b>Documentation of 'settingsCommand'</b>:
     *
     * If the meaning of "settingsCommand" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onSettingsCommand(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendSettingsCommandResponse (act_t act = 0);

    /**
     * The method sendSettingsCommandError() sends an error response of a
     * previous method invocation of 'settingsCommand' back to the client.
     *
     * <b>Documentation of 'settingsCommand'</b>:
     *
     * If the meaning of "settingsCommand" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onSettingsCommand(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendSettingsCommandError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'StartEarlyHandling'

    /**
     * The method onStartEarlyHandling() is called by ASF when a client
     * invokes the method 'StartEarlyHandling'. A subclass has to implement
     * this method and send back a response to the client either with the
     * sendStartEarlyHandling() or sendStartEarlyHandlingError() method. Do
     * not invoke this method on your own.
     *
     * <b>Documentation of 'StartEarlyHandling'</b>:
     *
     * If the meaning of "StartEarlyHandling" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onStartEarlyHandlingRequest (const ::boost::shared_ptr< StartEarlyHandlingRequest >& request) = 0;

    /**
     * The method sendStartEarlyHandlingResponse() sends a response of a
     * previous method invocation of 'StartEarlyHandling' back to the client.
     *
     * <b>Documentation of 'StartEarlyHandling'</b>:
     *
     * If the meaning of "StartEarlyHandling" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onStartEarlyHandling(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendStartEarlyHandlingResponse (act_t act = 0);

    /**
     * The method sendStartEarlyHandlingError() sends an error response of a
     * previous method invocation of 'StartEarlyHandling' back to the client.
     *
     * <b>Documentation of 'StartEarlyHandling'</b>:
     *
     * If the meaning of "StartEarlyHandling" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onStartEarlyHandling().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendStartEarlyHandlingError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'StopEarlyHandling'

    /**
     * The method onStopEarlyHandling() is called by ASF when a client invokes
     * the method 'StopEarlyHandling'. A subclass has to implement this method
     * and send back a response to the client either with the
     * sendStopEarlyHandling() or sendStopEarlyHandlingError() method. Do not
     * invoke this method on your own.
     *
     * <b>Documentation of 'StopEarlyHandling'</b>:
     *
     * If the meaning of "StopEarlyHandling" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onStopEarlyHandlingRequest (const ::boost::shared_ptr< StopEarlyHandlingRequest >& request) = 0;

    /**
     * The method sendStopEarlyHandlingResponse() sends a response of a
     * previous method invocation of 'StopEarlyHandling' back to the client.
     *
     * <b>Documentation of 'StopEarlyHandling'</b>:
     *
     * If the meaning of "StopEarlyHandling" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onStopEarlyHandling(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendStopEarlyHandlingResponse (act_t act = 0);

    /**
     * The method sendStopEarlyHandlingError() sends an error response of a
     * previous method invocation of 'StopEarlyHandling' back to the client.
     *
     * <b>Documentation of 'StopEarlyHandling'</b>:
     *
     * If the meaning of "StopEarlyHandling" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onStopEarlyHandling().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendStopEarlyHandlingError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'helpCommand'

    /**
     * The method onHelpCommand() is called by ASF when a client invokes the
     * method 'helpCommand'. A subclass has to implement this method and send
     * back a response to the client either with the sendHelpCommand() or
     * sendHelpCommandError() method. Do not invoke this method on your own.
     *
     * <b>Documentation of 'helpCommand'</b>:
     *
     * If the meaning of "helpCommand" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onHelpCommandRequest (const ::boost::shared_ptr< HelpCommandRequest >& request) = 0;

    /**
     * The method sendHelpCommandResponse() sends a response of a previous
     * method invocation of 'helpCommand' back to the client.
     *
     * <b>Documentation of 'helpCommand'</b>:
     *
     * If the meaning of "helpCommand" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onHelpCommand(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendHelpCommandResponse (act_t act = 0);

    /**
     * The method sendHelpCommandError() sends an error response of a previous
     * method invocation of 'helpCommand' back to the client.
     *
     * <b>Documentation of 'helpCommand'</b>:
     *
     * If the meaning of "helpCommand" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onHelpCommand(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendHelpCommandError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'CursorIndexForInitialFocus'

    /**
     * The method onCursorIndexForInitialFocus() is called by ASF when a
     * client invokes the method 'CursorIndexForInitialFocus'. A subclass has
     * to implement this method and send back a response to the client either
     * with the sendCursorIndexForInitialFocus() or
     * sendCursorIndexForInitialFocusError() method. Do not invoke this method
     * on your own.
     *
     * <b>Documentation of 'CursorIndexForInitialFocus'</b>:
     *
     * If the meaning of "CursorIndexForInitialFocus" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onCursorIndexForInitialFocusRequest (const ::boost::shared_ptr< CursorIndexForInitialFocusRequest >& request) = 0;

    /**
     * The method sendCursorIndexForInitialFocusResponse() sends a response of
     * a previous method invocation of 'CursorIndexForInitialFocus' back to
     * the client.
     *
     * <b>Documentation of 'CursorIndexForInitialFocus'</b>:
     *
     * If the meaning of "CursorIndexForInitialFocus" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onCursorIndexForInitialFocus(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendCursorIndexForInitialFocusResponse (act_t act = 0);

    /**
     * The method sendCursorIndexForInitialFocusError() sends an error
     * response of a previous method invocation of
     * 'CursorIndexForInitialFocus' back to the client.
     *
     * <b>Documentation of 'CursorIndexForInitialFocus'</b>:
     *
     * If the meaning of "CursorIndexForInitialFocus" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onCursorIndexForInitialFocus(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendCursorIndexForInitialFocusError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

private:
    void onGetAll(std::map<std::basic_string<char>, ::asf::dbus::DBusVariant>&) const;

    SdsStatusUpdate _sdsStatusProperty;

    HighPrioAppStatusUpdate _HighPrioAppStatusProperty;

    friend class SdsGuiServiceStubDelegate;

    DECLARE_CLASS_LOGGER();
};

} // namespace SdsGuiService
} // namespace sds_gui_fi

#endif // SDS_GUI_FI_SDSGUISERVICESTUB_H
