/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusStubDelegate.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "sds_gui_fi/SdsGuiService.h"
#include "sds_gui_fi/SdsGuiServiceConst.h"
#include "sds_gui_fi/SdsGuiServiceDBus.h"
#include "sds_gui_fi/SdsGuiServiceJson.h"
#include "sds_gui_fi/SdsGuiServiceStub.h"
#include <string>

#include "asf/dbus/DBusMessage.h"

namespace sds_gui_fi {
namespace SdsGuiService {

DEFINE_CLASS_LOGGER("/sds_gui_fi/sds_gui_fi/SdsGuiService", SdsGuiServiceStub);

static ::asf::dbus::DBusUtils::stringEntry methodsTable[] = {
    { 8, "pttPress", 0 },
    { 9, "BackPress", 4 },
    { 11, "StopSession", 6 },
    { 11, "helpCommand", 12 },
    { 12, "AbortSession", 5 },
    { 12, "PauseSession", 7 },
    { 13, "ResumeSession", 8 },
    { 14, "TestModeUpdate", 3 },
    { 15, "ManualOperation", 2 },
    { 15, "settingsCommand", 9 },
    { 17, "StopEarlyHandling", 11 },
    { 18, "StartEarlyHandling", 10 },
    { 19, "startSessionContext", 1 },
    { 26, "CursorIndexForInitialFocus", 13 },
};

static ::asf::dbus::DBusUtils::stringEntry propertiesTable[] = {
    { 9, "sdsStatus", 0 },
    { 17, "HighPrioAppStatus", 1 },
};

class SdsGuiServiceStubDelegate : public ::asf::dbus::DBusStubDelegate {
public:

    SdsGuiServiceStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger) :
        ::asf::dbus::DBusStubDelegate( stub, logger),
        _logger(logger)
    {}

    SdsGuiServiceStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger, const std::string& objectPath) :
        ::asf::dbus::DBusStubDelegate( stub, logger, objectPath),
        _logger(logger) {}

    SdsGuiServiceStubDelegate(::asf::dbus::DBusStub* stub,
                               ::asf::core::Logger& logger,
                               ::asf::dbus::DBusConnector& connector,
                               const std::string& objectPath)
        : ::asf::dbus::DBusStubDelegate(
              stub, logger, connector, objectPath, "sds_gui_fi.SdsGuiService"),
          _logger(logger) {}

    virtual ~SdsGuiServiceStubDelegate() {}

    virtual void process(::asf::core::ServiceMessage& msg);

    const char* introspect() const;

    virtual void getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties);

    virtual void setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act);

    virtual void getProperty(const ::std::string& property, const act_t& act);

private:

    ::asf::core::Logger& _logger;

};

void SdsGuiServiceStubDelegate::process(::asf::core::ServiceMessage& msg) {
    ::asf::dbus::DBusMessage& message = static_cast< ::asf::dbus::DBusMessage& >(msg);
    LOG_DEBUG_STUB("Entering process(memberName='%s')", message.getMemberName().c_str());

    unsigned int methodIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (message.getMemberName().c_str(), message.getMemberName().length(), methodsTable, 14, methodIndex)) {
        switch (methodIndex) {
        case 0: {

            // method 'pttPress'

            LOG_DEBUG_STUB("process method '%s'", "pttPress");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), PttPressRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "PttPress", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< PttPressRequest > payload = ::boost::static_pointer_cast<PttPressRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<SdsGuiServiceStub*>(getStub())->onPttPressRequest(payload);
            return;
        }
        case 1: {

            // method 'startSessionContext'

            LOG_DEBUG_STUB("process method '%s'", "startSessionContext");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), StartSessionContextRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "StartSessionContext", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< StartSessionContextRequest > payload = ::boost::static_pointer_cast<StartSessionContextRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<SdsGuiServiceStub*>(getStub())->onStartSessionContextRequest(payload);
            return;
        }
        case 2: {

            // method 'ManualOperation'

            LOG_DEBUG_STUB("process method '%s'", "ManualOperation");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ManualOperationRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "ManualOperation", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< ManualOperationRequest > payload = ::boost::static_pointer_cast<ManualOperationRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<SdsGuiServiceStub*>(getStub())->onManualOperationRequest(payload);
            return;
        }
        case 3: {

            // method 'TestModeUpdate'

            LOG_DEBUG_STUB("process method '%s'", "TestModeUpdate");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), TestModeUpdateRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "TestModeUpdate", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< TestModeUpdateRequest > payload = ::boost::static_pointer_cast<TestModeUpdateRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<SdsGuiServiceStub*>(getStub())->onTestModeUpdateRequest(payload);
            return;
        }
        case 4: {

            // method 'BackPress'

            LOG_DEBUG_STUB("process method '%s'", "BackPress");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), BackPressRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "BackPress", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< BackPressRequest > payload = ::boost::static_pointer_cast<BackPressRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<SdsGuiServiceStub*>(getStub())->onBackPressRequest(payload);
            return;
        }
        case 5: {

            // method 'AbortSession'

            LOG_DEBUG_STUB("process method '%s'", "AbortSession");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), AbortSessionRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "AbortSession", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< AbortSessionRequest > payload = ::boost::static_pointer_cast<AbortSessionRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<SdsGuiServiceStub*>(getStub())->onAbortSessionRequest(payload);
            return;
        }
        case 6: {

            // method 'StopSession'

            LOG_DEBUG_STUB("process method '%s'", "StopSession");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), StopSessionRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "StopSession", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< StopSessionRequest > payload = ::boost::static_pointer_cast<StopSessionRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<SdsGuiServiceStub*>(getStub())->onStopSessionRequest(payload);
            return;
        }
        case 7: {

            // method 'PauseSession'

            LOG_DEBUG_STUB("process method '%s'", "PauseSession");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), PauseSessionRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "PauseSession", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< PauseSessionRequest > payload = ::boost::static_pointer_cast<PauseSessionRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<SdsGuiServiceStub*>(getStub())->onPauseSessionRequest(payload);
            return;
        }
        case 8: {

            // method 'ResumeSession'

            LOG_DEBUG_STUB("process method '%s'", "ResumeSession");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ResumeSessionRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "ResumeSession", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< ResumeSessionRequest > payload = ::boost::static_pointer_cast<ResumeSessionRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<SdsGuiServiceStub*>(getStub())->onResumeSessionRequest(payload);
            return;
        }
        case 9: {

            // method 'settingsCommand'

            LOG_DEBUG_STUB("process method '%s'", "settingsCommand");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SettingsCommandRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "SettingsCommand", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< SettingsCommandRequest > payload = ::boost::static_pointer_cast<SettingsCommandRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<SdsGuiServiceStub*>(getStub())->onSettingsCommandRequest(payload);
            return;
        }
        case 10: {

            // method 'StartEarlyHandling'

            LOG_DEBUG_STUB("process method '%s'", "StartEarlyHandling");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), StartEarlyHandlingRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "StartEarlyHandling", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< StartEarlyHandlingRequest > payload = ::boost::static_pointer_cast<StartEarlyHandlingRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<SdsGuiServiceStub*>(getStub())->onStartEarlyHandlingRequest(payload);
            return;
        }
        case 11: {

            // method 'StopEarlyHandling'

            LOG_DEBUG_STUB("process method '%s'", "StopEarlyHandling");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), StopEarlyHandlingRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "StopEarlyHandling", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< StopEarlyHandlingRequest > payload = ::boost::static_pointer_cast<StopEarlyHandlingRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<SdsGuiServiceStub*>(getStub())->onStopEarlyHandlingRequest(payload);
            return;
        }
        case 12: {

            // method 'helpCommand'

            LOG_DEBUG_STUB("process method '%s'", "helpCommand");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), HelpCommandRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "HelpCommand", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< HelpCommandRequest > payload = ::boost::static_pointer_cast<HelpCommandRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<SdsGuiServiceStub*>(getStub())->onHelpCommandRequest(payload);
            return;
        }
        case 13: {

            // method 'CursorIndexForInitialFocus'

            LOG_DEBUG_STUB("process method '%s'", "CursorIndexForInitialFocus");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), CursorIndexForInitialFocusRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "CursorIndexForInitialFocus", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< CursorIndexForInitialFocusRequest > payload = ::boost::static_pointer_cast<CursorIndexForInitialFocusRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<SdsGuiServiceStub*>(getStub())->onCursorIndexForInitialFocusRequest(payload);
            return;
        }
        default:
            break;
        }
    }
    LOG_FATAL_STUB("can't process message %s", message.getMemberName().c_str());
}

const char* SdsGuiServiceStubDelegate::introspect() const {
    return     "<interface name=\"sds_gui_fi.SdsGuiService\">\n"
            "    <property access=\"read\" name=\"sdsStatus\" type=\"u\"/>\n"
            "    <property access=\"readwrite\" name=\"HighPrioAppStatus\" type=\"b\"/>\n"
            "    <method name=\"pttPress\">\n"
            "      <arg direction=\"in\" name=\"pttPressType\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>pttPressType = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"startSessionContext\">\n"
            "      <arg direction=\"in\" name=\"startupContextType\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>startupContextType = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"ManualOperation\">\n"
            "      <arg direction=\"in\" name=\"operationType\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>operationType = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"value\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>value = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"TestModeUpdate\">\n"
            "      <arg direction=\"in\" name=\"tModesentence\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>tModesentence = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"BackPress\"/>\n"
            "    <method name=\"AbortSession\"/>\n"
            "    <method name=\"StopSession\"/>\n"
            "    <method name=\"PauseSession\"/>\n"
            "    <method name=\"ResumeSession\"/>\n"
            "    <method name=\"settingsCommand\"/>\n"
            "    <method name=\"StartEarlyHandling\"/>\n"
            "    <method name=\"StopEarlyHandling\"/>\n"
            "    <method name=\"helpCommand\"/>\n"
            "    <method name=\"CursorIndexForInitialFocus\">\n"
            "      <arg direction=\"in\" name=\"index\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>index = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <signal name=\"ActivateAudioDeviceTag\">\n"
            "      <arg direction=\"out\" name=\"deviceTag\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>deviceTag = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"audioSource\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>audioSource = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </signal>\n"
            "    <signal name=\"ActivateAudioSource\">\n"
            "      <arg direction=\"out\" name=\"audioSource\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>audioSource = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </signal>\n"
            "    <signal name=\"SpokenDigits\">\n"
            "      <doc>\n"
            "        <line>SpokenDigits = OBSOLETE -> use SpokenDigits broadcast from sds_gui_fi::SdsPhoneService</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"digits\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>digits = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </signal>\n"
            "    <signal name=\"Event\">\n"
            "      <arg direction=\"out\" name=\"guiEvent\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>guiEvent = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </signal>\n"
            "    <signal name=\"EarlyPromptFinished\"/>\n"
            "    <signal name=\"EarlyPromptTerminated\"/>\n"
            "</interface>\n";
}

void SdsGuiServiceStubDelegate::getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) {
    (static_cast<SdsGuiServiceStub*>(getStub()))->onGetAll (properties);
}

void SdsGuiServiceStubDelegate::setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act) {
    unsigned int propertyIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (property.c_str(), property.length(), propertiesTable, 2, propertyIndex)) {
        switch (propertyIndex) {
        case 0: {
            LOG_DEBUG_STUB("process property '%s'", "sdsStatus");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 1: {
            LOG_DEBUG_STUB("process property '%s'", "HighPrioAppStatus");
            ::boost::shared_ptr< HighPrioAppStatusSet > payload(new HighPrioAppStatusSet());
            payload->setAct(act);
            deserializeDBus(const_cast< ::asf::dbus::DBusVariant& >(value).getReadIterator(), *payload);
            static_cast<SdsGuiServiceStub*>(getStub())->onHighPrioAppStatusSet (payload);
            return;
        }
        default:
            break;
        }
    }
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendSetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

void SdsGuiServiceStubDelegate::getProperty(const ::std::string& property, const act_t& act) {
    unsigned int propertyIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (property.c_str(), property.length(), propertiesTable, 2, propertyIndex)) {
        switch (propertyIndex) {
        case 0: {
            LOG_DEBUG_STUB("process property '%s'", "sdsStatus");
            ::boost::shared_ptr< SdsStatusGet > payload(new SdsStatusGet());
            payload->setAct(act);
            static_cast<SdsGuiServiceStub*>(getStub())->onSdsStatusGet (payload);
            return;
        }
        case 1: {
            LOG_DEBUG_STUB("process property '%s'", "HighPrioAppStatus");
            ::boost::shared_ptr< HighPrioAppStatusGet > payload(new HighPrioAppStatusGet());
            payload->setAct(act);
            static_cast<SdsGuiServiceStub*>(getStub())->onHighPrioAppStatusGet (payload);
            return;
        }
        default:
            break;
        }
    }
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendGetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

SdsGuiServiceStub::SdsGuiServiceStub (const std::string& portName) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new SdsGuiServiceStubDelegate(this, _logger);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

SdsGuiServiceStub::SdsGuiServiceStub (const std::string& portName, const std::string& objectPath) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new SdsGuiServiceStubDelegate(this, _logger, objectPath);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

SdsGuiServiceStub::~SdsGuiServiceStub() {
    delete _stubDelegate;
}

void SdsGuiServiceStub::sendActivateAudioDeviceTagSignal(uint32 deviceTag, AudioSource audioSource) {
    if (_stubDelegate->isConnected()) {
        ActivateAudioDeviceTagSignal* payload = new ActivateAudioDeviceTagSignal(deviceTag, audioSource);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "ActivateAudioDeviceTag", ActivateAudioDeviceTagSignal, payload)
        LOG_INFO ("-> send%sSignal", "ActivateAudioDeviceTag");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "ActivateAudioDeviceTag");
    }
}

void SdsGuiServiceStub::sendActivateAudioSourceSignal(AudioSource audioSource) {
    if (_stubDelegate->isConnected()) {
        ActivateAudioSourceSignal* payload = new ActivateAudioSourceSignal(audioSource);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "ActivateAudioSource", ActivateAudioSourceSignal, payload)
        LOG_INFO ("-> send%sSignal", "ActivateAudioSource");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "ActivateAudioSource");
    }
}

void SdsGuiServiceStub::sendSpokenDigitsSignal(const ::std::string& digits) {
    if (_stubDelegate->isConnected()) {
        SpokenDigitsSignal* payload = new SpokenDigitsSignal(digits);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "SpokenDigits", SpokenDigitsSignal, payload)
        LOG_INFO ("-> send%sSignal", "SpokenDigits");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "SpokenDigits");
    }
}

void SdsGuiServiceStub::sendEventSignal(Event guiEvent) {
    if (_stubDelegate->isConnected()) {
        EventSignal* payload = new EventSignal(guiEvent);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "Event", EventSignal, payload)
        LOG_INFO ("-> send%sSignal", "Event");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "Event");
    }
}

void SdsGuiServiceStub::sendEarlyPromptFinishedSignal() {
    if (_stubDelegate->isConnected()) {
        EarlyPromptFinishedSignal* payload = new EarlyPromptFinishedSignal;
        DBUS_MESSAGE_SIGNAL(dbusMessage, "EarlyPromptFinished", EarlyPromptFinishedSignal, payload)
        LOG_INFO ("-> send%sSignal", "EarlyPromptFinished");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "EarlyPromptFinished");
    }
}

void SdsGuiServiceStub::sendEarlyPromptTerminatedSignal() {
    if (_stubDelegate->isConnected()) {
        EarlyPromptTerminatedSignal* payload = new EarlyPromptTerminatedSignal;
        DBUS_MESSAGE_SIGNAL(dbusMessage, "EarlyPromptTerminated", EarlyPromptTerminatedSignal, payload)
        LOG_INFO ("-> send%sSignal", "EarlyPromptTerminated");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "EarlyPromptTerminated");
    }
}

void SdsGuiServiceStub::sendSdsStatusUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        SdsStatusUpdate payload(_sdsStatusProperty);

        LOG_INFO ("-> send%s", "SdsStatusUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("sdsStatus", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("sds_gui_fi.SdsGuiService", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "SdsStatusUpdate");
    }
}

void SdsGuiServiceStub::onSdsStatusGet(const ::boost::shared_ptr< SdsStatusGet >& sdsStatus) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "SdsStatusGet", sdsStatus->getAct());
    sendSdsStatusGetUpdate(_sdsStatusProperty.getSdsStatus(), sdsStatus->getAct());
}

void SdsGuiServiceStub::sendSdsStatusGetUpdate(SpeechInputState sdsStatus, act_t act) {
    ::asf::dbus::DBusVariant variant;
    SdsStatusGet payload(sdsStatus);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "SdsStatusGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void SdsGuiServiceStub::setSdsStatus(SpeechInputState sdsStatus) {
    if(sdsStatus!=_sdsStatusProperty.getSdsStatus()) {
        _sdsStatusProperty.setSdsStatus(sdsStatus);
        sendSdsStatusUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

SpeechInputState SdsGuiServiceStub::getSdsStatus() const {
    return _sdsStatusProperty.getSdsStatus();
}

void SdsGuiServiceStub::sendHighPrioAppStatusUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        HighPrioAppStatusUpdate payload(_HighPrioAppStatusProperty);

        LOG_INFO ("-> send%s", "HighPrioAppStatusUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("HighPrioAppStatus", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("sds_gui_fi.SdsGuiService", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "HighPrioAppStatusUpdate");
    }
}

void SdsGuiServiceStub::onHighPrioAppStatusGet(const ::boost::shared_ptr< HighPrioAppStatusGet >& highPrioAppStatus) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "HighPrioAppStatusGet", highPrioAppStatus->getAct());
    sendHighPrioAppStatusGetUpdate(_HighPrioAppStatusProperty.getHighPrioAppStatus(), highPrioAppStatus->getAct());
}

void SdsGuiServiceStub::sendHighPrioAppStatusGetUpdate(bool highPrioAppStatus, act_t act) {
    ::asf::dbus::DBusVariant variant;
    HighPrioAppStatusGet payload(highPrioAppStatus);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "HighPrioAppStatusGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void SdsGuiServiceStub::onHighPrioAppStatusSet(const ::boost::shared_ptr< HighPrioAppStatusSet >& highPrioAppStatus) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "HighPrioAppStatusSet", highPrioAppStatus->getAct());
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(*highPrioAppStatus, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }
    setHighPrioAppStatus (highPrioAppStatus->getHighPrioAppStatus());
    sendHighPrioAppStatusSetUpdate(highPrioAppStatus->getAct());
}

void SdsGuiServiceStub::sendHighPrioAppStatusSetUpdate(act_t act) {
    LOG_INFO ("-> send%s, act=%" PRIuPTR, "HighPrioAppStatusSetUpdate", act);
    _stubDelegate->sendSetResponse(act);
}

void SdsGuiServiceStub::setHighPrioAppStatus(bool highPrioAppStatus) {
    if(highPrioAppStatus!=_HighPrioAppStatusProperty.getHighPrioAppStatus()) {
        _HighPrioAppStatusProperty.setHighPrioAppStatus(highPrioAppStatus);
        sendHighPrioAppStatusUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

bool SdsGuiServiceStub::getHighPrioAppStatus() const {
    return _HighPrioAppStatusProperty.getHighPrioAppStatus();
}

void  SdsGuiServiceStub::sendPttPressResponse (act_t act) {
    PttPressResponse* payload = new PttPressResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "pttPress", PttPressResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "PttPress", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  SdsGuiServiceStub::sendPttPressError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    PttPressError* payload = new PttPressError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "pttPress", PttPressError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "PttPress", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  SdsGuiServiceStub::sendStartSessionContextResponse (act_t act) {
    StartSessionContextResponse* payload = new StartSessionContextResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "startSessionContext", StartSessionContextResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "StartSessionContext", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  SdsGuiServiceStub::sendStartSessionContextError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    StartSessionContextError* payload = new StartSessionContextError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "startSessionContext", StartSessionContextError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "StartSessionContext", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  SdsGuiServiceStub::sendManualOperationResponse (act_t act) {
    ManualOperationResponse* payload = new ManualOperationResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "ManualOperation", ManualOperationResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "ManualOperation", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  SdsGuiServiceStub::sendManualOperationError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    ManualOperationError* payload = new ManualOperationError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "ManualOperation", ManualOperationError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "ManualOperation", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  SdsGuiServiceStub::sendTestModeUpdateResponse (act_t act) {
    TestModeUpdateResponse* payload = new TestModeUpdateResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "TestModeUpdate", TestModeUpdateResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "TestModeUpdate", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  SdsGuiServiceStub::sendTestModeUpdateError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    TestModeUpdateError* payload = new TestModeUpdateError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "TestModeUpdate", TestModeUpdateError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "TestModeUpdate", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  SdsGuiServiceStub::sendBackPressResponse (act_t act) {
    BackPressResponse* payload = new BackPressResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "BackPress", BackPressResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "BackPress", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  SdsGuiServiceStub::sendBackPressError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    BackPressError* payload = new BackPressError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "BackPress", BackPressError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "BackPress", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  SdsGuiServiceStub::sendAbortSessionResponse (act_t act) {
    AbortSessionResponse* payload = new AbortSessionResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "AbortSession", AbortSessionResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "AbortSession", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  SdsGuiServiceStub::sendAbortSessionError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    AbortSessionError* payload = new AbortSessionError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "AbortSession", AbortSessionError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "AbortSession", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  SdsGuiServiceStub::sendStopSessionResponse (act_t act) {
    StopSessionResponse* payload = new StopSessionResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "StopSession", StopSessionResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "StopSession", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  SdsGuiServiceStub::sendStopSessionError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    StopSessionError* payload = new StopSessionError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "StopSession", StopSessionError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "StopSession", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  SdsGuiServiceStub::sendPauseSessionResponse (act_t act) {
    PauseSessionResponse* payload = new PauseSessionResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "PauseSession", PauseSessionResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "PauseSession", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  SdsGuiServiceStub::sendPauseSessionError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    PauseSessionError* payload = new PauseSessionError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "PauseSession", PauseSessionError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "PauseSession", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  SdsGuiServiceStub::sendResumeSessionResponse (act_t act) {
    ResumeSessionResponse* payload = new ResumeSessionResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "ResumeSession", ResumeSessionResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "ResumeSession", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  SdsGuiServiceStub::sendResumeSessionError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    ResumeSessionError* payload = new ResumeSessionError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "ResumeSession", ResumeSessionError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "ResumeSession", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  SdsGuiServiceStub::sendSettingsCommandResponse (act_t act) {
    SettingsCommandResponse* payload = new SettingsCommandResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "settingsCommand", SettingsCommandResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "SettingsCommand", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  SdsGuiServiceStub::sendSettingsCommandError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    SettingsCommandError* payload = new SettingsCommandError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "settingsCommand", SettingsCommandError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "SettingsCommand", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  SdsGuiServiceStub::sendStartEarlyHandlingResponse (act_t act) {
    StartEarlyHandlingResponse* payload = new StartEarlyHandlingResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "StartEarlyHandling", StartEarlyHandlingResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "StartEarlyHandling", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  SdsGuiServiceStub::sendStartEarlyHandlingError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    StartEarlyHandlingError* payload = new StartEarlyHandlingError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "StartEarlyHandling", StartEarlyHandlingError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "StartEarlyHandling", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  SdsGuiServiceStub::sendStopEarlyHandlingResponse (act_t act) {
    StopEarlyHandlingResponse* payload = new StopEarlyHandlingResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "StopEarlyHandling", StopEarlyHandlingResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "StopEarlyHandling", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  SdsGuiServiceStub::sendStopEarlyHandlingError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    StopEarlyHandlingError* payload = new StopEarlyHandlingError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "StopEarlyHandling", StopEarlyHandlingError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "StopEarlyHandling", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  SdsGuiServiceStub::sendHelpCommandResponse (act_t act) {
    HelpCommandResponse* payload = new HelpCommandResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "helpCommand", HelpCommandResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "HelpCommand", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  SdsGuiServiceStub::sendHelpCommandError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    HelpCommandError* payload = new HelpCommandError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "helpCommand", HelpCommandError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "HelpCommand", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  SdsGuiServiceStub::sendCursorIndexForInitialFocusResponse (act_t act) {
    CursorIndexForInitialFocusResponse* payload = new CursorIndexForInitialFocusResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "CursorIndexForInitialFocus", CursorIndexForInitialFocusResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "CursorIndexForInitialFocus", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  SdsGuiServiceStub::sendCursorIndexForInitialFocusError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    CursorIndexForInitialFocusError* payload = new CursorIndexForInitialFocusError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "CursorIndexForInitialFocus", CursorIndexForInitialFocusError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "CursorIndexForInitialFocus", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void SdsGuiServiceStub::onGetAll(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) const {

    //property 'sdsStatus'
    {
        ::asf::dbus::DBusVariant variant;
        SdsStatusGet payload(_sdsStatusProperty.getSdsStatus());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("sdsStatus", variant));
    }

    //property 'HighPrioAppStatus'
    {
        ::asf::dbus::DBusVariant variant;
        HighPrioAppStatusGet payload(_HighPrioAppStatusProperty.getHighPrioAppStatus());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("HighPrioAppStatus", variant));
    }
}

} // namespace SdsGuiService
} // namespace sds_gui_fi
