/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "sds_gui_fi/SdsGuiService.h"
#include "sds_gui_fi/SdsGuiServiceConst.h"
#include "sds_gui_fi/SdsGuiServiceDBus.h"
#include "sds_gui_fi/SdsGuiServiceJson.h"
#include "sds_gui_fi/SdsGuiServiceProxy.h"
#include <string>

#include "asf/dbus/DBusDaemonProxy.h"
#include "asf/dbus/DBusPropertiesProxyWrapper.h"
#include "asf/dbus/DBusProxyDelegate.h"
#include "asf/dbus/DBusMessage.h"

namespace sds_gui_fi {
namespace SdsGuiService {

DEFINE_CLASS_LOGGER("/sds_gui_fi/sds_gui_fi/SdsGuiService", SdsGuiServiceProxy);

class SdsGuiServiceProxyCallback : public ::asf::dbus::DBusProxyCallback {
public:

    SdsGuiServiceProxyCallback(uint16 functionId, void* callback) :
        ::asf::dbus::DBusProxyCallback (functionId, callback)
    {}

    bool processMessage (::asf::dbus::DBusMessage &message) {
        const ::boost::shared_ptr< SdsGuiServiceProxy >& proxyShared = ::boost::static_pointer_cast< SdsGuiServiceProxy >(message.getDBusProxyShared()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        switch (_functionId) {
            case ID_ActivateAudioDeviceTag:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ActivateAudioDeviceTagSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "ActivateAudioDeviceTag", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<ActivateAudioDeviceTagSignal> payload = ::boost::static_pointer_cast<ActivateAudioDeviceTagSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((ActivateAudioDeviceTagCallbackIF*) _callback)->onActivateAudioDeviceTagSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_ActivateAudioSource:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ActivateAudioSourceSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "ActivateAudioSource", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<ActivateAudioSourceSignal> payload = ::boost::static_pointer_cast<ActivateAudioSourceSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((ActivateAudioSourceCallbackIF*) _callback)->onActivateAudioSourceSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_SpokenDigits:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SpokenDigitsSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "SpokenDigits", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<SpokenDigitsSignal> payload = ::boost::static_pointer_cast<SpokenDigitsSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((SpokenDigitsCallbackIF*) _callback)->onSpokenDigitsSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_Event:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), EventSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Event", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<EventSignal> payload = ::boost::static_pointer_cast<EventSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((EventCallbackIF*) _callback)->onEventSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_EarlyPromptFinished:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), EarlyPromptFinishedSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "EarlyPromptFinished", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<EarlyPromptFinishedSignal> payload = ::boost::static_pointer_cast<EarlyPromptFinishedSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((EarlyPromptFinishedCallbackIF*) _callback)->onEarlyPromptFinishedSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_EarlyPromptTerminated:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), EarlyPromptTerminatedSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "EarlyPromptTerminated", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<EarlyPromptTerminatedSignal> payload = ::boost::static_pointer_cast<EarlyPromptTerminatedSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((EarlyPromptTerminatedCallbackIF*) _callback)->onEarlyPromptTerminatedSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_sdsStatus:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SdsStatusError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "SdsStatus", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SdsStatusError> payload = ::boost::static_pointer_cast<SdsStatusError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((SdsStatusCallbackIF*) _callback)->onSdsStatusError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SdsStatusUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "SdsStatus", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SdsStatusUpdate> payload = ::boost::static_pointer_cast<SdsStatusUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((SdsStatusCallbackIF*) _callback)->onSdsStatusUpdate(proxyShared, payload);
                        proxyShared->_sdsStatus = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_HighPrioAppStatus:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), HighPrioAppStatusError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "HighPrioAppStatus", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<HighPrioAppStatusError> payload = ::boost::static_pointer_cast<HighPrioAppStatusError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((HighPrioAppStatusCallbackIF*) _callback)->onHighPrioAppStatusError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), HighPrioAppStatusUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "HighPrioAppStatus", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<HighPrioAppStatusUpdate> payload = ::boost::static_pointer_cast<HighPrioAppStatusUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((HighPrioAppStatusCallbackIF*) _callback)->onHighPrioAppStatusUpdate(proxyShared, payload);
                        proxyShared->_highPrioAppStatus = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_pttPress:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), PttPressError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "PttPress", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<PttPressError> payload = ::boost::static_pointer_cast<PttPressError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((PttPressCallbackIF*) _callback)->onPttPressError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), PttPressResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "PttPress", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<PttPressResponse> payload = ::boost::static_pointer_cast<PttPressResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((PttPressCallbackIF*) _callback)->onPttPressResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_startSessionContext:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), StartSessionContextError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "StartSessionContext", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<StartSessionContextError> payload = ::boost::static_pointer_cast<StartSessionContextError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((StartSessionContextCallbackIF*) _callback)->onStartSessionContextError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), StartSessionContextResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "StartSessionContext", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<StartSessionContextResponse> payload = ::boost::static_pointer_cast<StartSessionContextResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((StartSessionContextCallbackIF*) _callback)->onStartSessionContextResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_ManualOperation:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), ManualOperationError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "ManualOperation", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ManualOperationError> payload = ::boost::static_pointer_cast<ManualOperationError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ManualOperationCallbackIF*) _callback)->onManualOperationError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ManualOperationResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "ManualOperation", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ManualOperationResponse> payload = ::boost::static_pointer_cast<ManualOperationResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ManualOperationCallbackIF*) _callback)->onManualOperationResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_TestModeUpdate:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), TestModeUpdateError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "TestModeUpdate", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<TestModeUpdateError> payload = ::boost::static_pointer_cast<TestModeUpdateError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((TestModeUpdateCallbackIF*) _callback)->onTestModeUpdateError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), TestModeUpdateResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "TestModeUpdate", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<TestModeUpdateResponse> payload = ::boost::static_pointer_cast<TestModeUpdateResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((TestModeUpdateCallbackIF*) _callback)->onTestModeUpdateResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_BackPress:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), BackPressError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "BackPress", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<BackPressError> payload = ::boost::static_pointer_cast<BackPressError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((BackPressCallbackIF*) _callback)->onBackPressError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), BackPressResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "BackPress", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<BackPressResponse> payload = ::boost::static_pointer_cast<BackPressResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((BackPressCallbackIF*) _callback)->onBackPressResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_AbortSession:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), AbortSessionError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "AbortSession", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<AbortSessionError> payload = ::boost::static_pointer_cast<AbortSessionError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((AbortSessionCallbackIF*) _callback)->onAbortSessionError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), AbortSessionResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "AbortSession", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<AbortSessionResponse> payload = ::boost::static_pointer_cast<AbortSessionResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((AbortSessionCallbackIF*) _callback)->onAbortSessionResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_StopSession:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), StopSessionError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "StopSession", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<StopSessionError> payload = ::boost::static_pointer_cast<StopSessionError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((StopSessionCallbackIF*) _callback)->onStopSessionError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), StopSessionResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "StopSession", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<StopSessionResponse> payload = ::boost::static_pointer_cast<StopSessionResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((StopSessionCallbackIF*) _callback)->onStopSessionResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_PauseSession:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), PauseSessionError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "PauseSession", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<PauseSessionError> payload = ::boost::static_pointer_cast<PauseSessionError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((PauseSessionCallbackIF*) _callback)->onPauseSessionError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), PauseSessionResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "PauseSession", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<PauseSessionResponse> payload = ::boost::static_pointer_cast<PauseSessionResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((PauseSessionCallbackIF*) _callback)->onPauseSessionResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_ResumeSession:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), ResumeSessionError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "ResumeSession", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ResumeSessionError> payload = ::boost::static_pointer_cast<ResumeSessionError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ResumeSessionCallbackIF*) _callback)->onResumeSessionError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ResumeSessionResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "ResumeSession", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ResumeSessionResponse> payload = ::boost::static_pointer_cast<ResumeSessionResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ResumeSessionCallbackIF*) _callback)->onResumeSessionResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_settingsCommand:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), SettingsCommandError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SettingsCommand", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SettingsCommandError> payload = ::boost::static_pointer_cast<SettingsCommandError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SettingsCommandCallbackIF*) _callback)->onSettingsCommandError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SettingsCommandResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "SettingsCommand", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SettingsCommandResponse> payload = ::boost::static_pointer_cast<SettingsCommandResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SettingsCommandCallbackIF*) _callback)->onSettingsCommandResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_StartEarlyHandling:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), StartEarlyHandlingError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "StartEarlyHandling", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<StartEarlyHandlingError> payload = ::boost::static_pointer_cast<StartEarlyHandlingError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((StartEarlyHandlingCallbackIF*) _callback)->onStartEarlyHandlingError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), StartEarlyHandlingResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "StartEarlyHandling", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<StartEarlyHandlingResponse> payload = ::boost::static_pointer_cast<StartEarlyHandlingResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((StartEarlyHandlingCallbackIF*) _callback)->onStartEarlyHandlingResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_StopEarlyHandling:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), StopEarlyHandlingError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "StopEarlyHandling", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<StopEarlyHandlingError> payload = ::boost::static_pointer_cast<StopEarlyHandlingError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((StopEarlyHandlingCallbackIF*) _callback)->onStopEarlyHandlingError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), StopEarlyHandlingResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "StopEarlyHandling", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<StopEarlyHandlingResponse> payload = ::boost::static_pointer_cast<StopEarlyHandlingResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((StopEarlyHandlingCallbackIF*) _callback)->onStopEarlyHandlingResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_helpCommand:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), HelpCommandError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "HelpCommand", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<HelpCommandError> payload = ::boost::static_pointer_cast<HelpCommandError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((HelpCommandCallbackIF*) _callback)->onHelpCommandError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), HelpCommandResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "HelpCommand", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<HelpCommandResponse> payload = ::boost::static_pointer_cast<HelpCommandResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((HelpCommandCallbackIF*) _callback)->onHelpCommandResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_CursorIndexForInitialFocus:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), CursorIndexForInitialFocusError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "CursorIndexForInitialFocus", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<CursorIndexForInitialFocusError> payload = ::boost::static_pointer_cast<CursorIndexForInitialFocusError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((CursorIndexForInitialFocusCallbackIF*) _callback)->onCursorIndexForInitialFocusError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), CursorIndexForInitialFocusResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "CursorIndexForInitialFocus", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<CursorIndexForInitialFocusResponse> payload = ::boost::static_pointer_cast<CursorIndexForInitialFocusResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((CursorIndexForInitialFocusCallbackIF*) _callback)->onCursorIndexForInitialFocusResponse (proxyShared, payload);
                        return true;
                    }
                }
            default:
            LOG_FATAL ("Received an invalid functionId, proxy=%p", message.getProxy());
        }
        LOG_FATAL("Receveid an invalid message, proxy=%p", message.getProxy());
        return false;
    }

    bool onServiceUnavailable (const ::boost::shared_ptr< ::asf::core::Proxy >& baseProxy) {
        switch (_functionId) {
            case ID_ActivateAudioDeviceTag: {
                ::boost::shared_ptr< ActivateAudioDeviceTagError > payload = ::boost::shared_ptr< ActivateAudioDeviceTagError >
                (new ActivateAudioDeviceTagError(DBUS_ERROR_NO_SERVER, "The DBus service SdsGuiService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ActivateAudioDeviceTag", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<SdsGuiServiceProxy> proxyShared = ::boost::static_pointer_cast<SdsGuiServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ActivateAudioDeviceTagCallbackIF*) _callback)->onActivateAudioDeviceTagError (proxyShared,payload);
                return true;
            }
            break;
            case ID_ActivateAudioSource: {
                ::boost::shared_ptr< ActivateAudioSourceError > payload = ::boost::shared_ptr< ActivateAudioSourceError >
                (new ActivateAudioSourceError(DBUS_ERROR_NO_SERVER, "The DBus service SdsGuiService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ActivateAudioSource", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<SdsGuiServiceProxy> proxyShared = ::boost::static_pointer_cast<SdsGuiServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ActivateAudioSourceCallbackIF*) _callback)->onActivateAudioSourceError (proxyShared,payload);
                return true;
            }
            break;
            case ID_SpokenDigits: {
                ::boost::shared_ptr< SpokenDigitsError > payload = ::boost::shared_ptr< SpokenDigitsError >
                (new SpokenDigitsError(DBUS_ERROR_NO_SERVER, "The DBus service SdsGuiService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SpokenDigits", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<SdsGuiServiceProxy> proxyShared = ::boost::static_pointer_cast<SdsGuiServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SpokenDigitsCallbackIF*) _callback)->onSpokenDigitsError (proxyShared,payload);
                return true;
            }
            break;
            case ID_Event: {
                ::boost::shared_ptr< EventError > payload = ::boost::shared_ptr< EventError >
                (new EventError(DBUS_ERROR_NO_SERVER, "The DBus service SdsGuiService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Event", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<SdsGuiServiceProxy> proxyShared = ::boost::static_pointer_cast<SdsGuiServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((EventCallbackIF*) _callback)->onEventError (proxyShared,payload);
                return true;
            }
            break;
            case ID_EarlyPromptFinished: {
                ::boost::shared_ptr< EarlyPromptFinishedError > payload = ::boost::shared_ptr< EarlyPromptFinishedError >
                (new EarlyPromptFinishedError(DBUS_ERROR_NO_SERVER, "The DBus service SdsGuiService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "EarlyPromptFinished", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<SdsGuiServiceProxy> proxyShared = ::boost::static_pointer_cast<SdsGuiServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((EarlyPromptFinishedCallbackIF*) _callback)->onEarlyPromptFinishedError (proxyShared,payload);
                return true;
            }
            break;
            case ID_EarlyPromptTerminated: {
                ::boost::shared_ptr< EarlyPromptTerminatedError > payload = ::boost::shared_ptr< EarlyPromptTerminatedError >
                (new EarlyPromptTerminatedError(DBUS_ERROR_NO_SERVER, "The DBus service SdsGuiService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "EarlyPromptTerminated", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<SdsGuiServiceProxy> proxyShared = ::boost::static_pointer_cast<SdsGuiServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((EarlyPromptTerminatedCallbackIF*) _callback)->onEarlyPromptTerminatedError (proxyShared,payload);
                return true;
            }
            break;
            case ID_sdsStatus: {
                ::boost::shared_ptr< SdsStatusError > payload = ::boost::shared_ptr< SdsStatusError >
                (new SdsStatusError(DBUS_ERROR_NO_SERVER, "The DBus service SdsGuiService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SdsStatus", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<SdsGuiServiceProxy> proxyShared = ::boost::static_pointer_cast<SdsGuiServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SdsStatusCallbackIF*) _callback)->onSdsStatusError (proxyShared,payload);
                return true;
            }
            break;
            case ID_HighPrioAppStatus: {
                ::boost::shared_ptr< HighPrioAppStatusError > payload = ::boost::shared_ptr< HighPrioAppStatusError >
                (new HighPrioAppStatusError(DBUS_ERROR_NO_SERVER, "The DBus service SdsGuiService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "HighPrioAppStatus", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<SdsGuiServiceProxy> proxyShared = ::boost::static_pointer_cast<SdsGuiServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((HighPrioAppStatusCallbackIF*) _callback)->onHighPrioAppStatusError (proxyShared,payload);
                return true;
            }
            break;
            case ID_pttPress: {
                ::boost::shared_ptr< PttPressError > payload = ::boost::shared_ptr< PttPressError >
                (new PttPressError(DBUS_ERROR_NO_SERVER, "The DBus service SdsGuiService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "PttPress", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<SdsGuiServiceProxy> proxyShared = ::boost::static_pointer_cast<SdsGuiServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((PttPressCallbackIF*) _callback)->onPttPressError (proxyShared,payload);
                return true;
            }
            break;
            case ID_startSessionContext: {
                ::boost::shared_ptr< StartSessionContextError > payload = ::boost::shared_ptr< StartSessionContextError >
                (new StartSessionContextError(DBUS_ERROR_NO_SERVER, "The DBus service SdsGuiService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "StartSessionContext", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<SdsGuiServiceProxy> proxyShared = ::boost::static_pointer_cast<SdsGuiServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((StartSessionContextCallbackIF*) _callback)->onStartSessionContextError (proxyShared,payload);
                return true;
            }
            break;
            case ID_ManualOperation: {
                ::boost::shared_ptr< ManualOperationError > payload = ::boost::shared_ptr< ManualOperationError >
                (new ManualOperationError(DBUS_ERROR_NO_SERVER, "The DBus service SdsGuiService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ManualOperation", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<SdsGuiServiceProxy> proxyShared = ::boost::static_pointer_cast<SdsGuiServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ManualOperationCallbackIF*) _callback)->onManualOperationError (proxyShared,payload);
                return true;
            }
            break;
            case ID_TestModeUpdate: {
                ::boost::shared_ptr< TestModeUpdateError > payload = ::boost::shared_ptr< TestModeUpdateError >
                (new TestModeUpdateError(DBUS_ERROR_NO_SERVER, "The DBus service SdsGuiService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "TestModeUpdate", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<SdsGuiServiceProxy> proxyShared = ::boost::static_pointer_cast<SdsGuiServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((TestModeUpdateCallbackIF*) _callback)->onTestModeUpdateError (proxyShared,payload);
                return true;
            }
            break;
            case ID_BackPress: {
                ::boost::shared_ptr< BackPressError > payload = ::boost::shared_ptr< BackPressError >
                (new BackPressError(DBUS_ERROR_NO_SERVER, "The DBus service SdsGuiService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "BackPress", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<SdsGuiServiceProxy> proxyShared = ::boost::static_pointer_cast<SdsGuiServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((BackPressCallbackIF*) _callback)->onBackPressError (proxyShared,payload);
                return true;
            }
            break;
            case ID_AbortSession: {
                ::boost::shared_ptr< AbortSessionError > payload = ::boost::shared_ptr< AbortSessionError >
                (new AbortSessionError(DBUS_ERROR_NO_SERVER, "The DBus service SdsGuiService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "AbortSession", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<SdsGuiServiceProxy> proxyShared = ::boost::static_pointer_cast<SdsGuiServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((AbortSessionCallbackIF*) _callback)->onAbortSessionError (proxyShared,payload);
                return true;
            }
            break;
            case ID_StopSession: {
                ::boost::shared_ptr< StopSessionError > payload = ::boost::shared_ptr< StopSessionError >
                (new StopSessionError(DBUS_ERROR_NO_SERVER, "The DBus service SdsGuiService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "StopSession", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<SdsGuiServiceProxy> proxyShared = ::boost::static_pointer_cast<SdsGuiServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((StopSessionCallbackIF*) _callback)->onStopSessionError (proxyShared,payload);
                return true;
            }
            break;
            case ID_PauseSession: {
                ::boost::shared_ptr< PauseSessionError > payload = ::boost::shared_ptr< PauseSessionError >
                (new PauseSessionError(DBUS_ERROR_NO_SERVER, "The DBus service SdsGuiService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "PauseSession", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<SdsGuiServiceProxy> proxyShared = ::boost::static_pointer_cast<SdsGuiServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((PauseSessionCallbackIF*) _callback)->onPauseSessionError (proxyShared,payload);
                return true;
            }
            break;
            case ID_ResumeSession: {
                ::boost::shared_ptr< ResumeSessionError > payload = ::boost::shared_ptr< ResumeSessionError >
                (new ResumeSessionError(DBUS_ERROR_NO_SERVER, "The DBus service SdsGuiService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ResumeSession", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<SdsGuiServiceProxy> proxyShared = ::boost::static_pointer_cast<SdsGuiServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ResumeSessionCallbackIF*) _callback)->onResumeSessionError (proxyShared,payload);
                return true;
            }
            break;
            case ID_settingsCommand: {
                ::boost::shared_ptr< SettingsCommandError > payload = ::boost::shared_ptr< SettingsCommandError >
                (new SettingsCommandError(DBUS_ERROR_NO_SERVER, "The DBus service SdsGuiService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SettingsCommand", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<SdsGuiServiceProxy> proxyShared = ::boost::static_pointer_cast<SdsGuiServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SettingsCommandCallbackIF*) _callback)->onSettingsCommandError (proxyShared,payload);
                return true;
            }
            break;
            case ID_StartEarlyHandling: {
                ::boost::shared_ptr< StartEarlyHandlingError > payload = ::boost::shared_ptr< StartEarlyHandlingError >
                (new StartEarlyHandlingError(DBUS_ERROR_NO_SERVER, "The DBus service SdsGuiService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "StartEarlyHandling", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<SdsGuiServiceProxy> proxyShared = ::boost::static_pointer_cast<SdsGuiServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((StartEarlyHandlingCallbackIF*) _callback)->onStartEarlyHandlingError (proxyShared,payload);
                return true;
            }
            break;
            case ID_StopEarlyHandling: {
                ::boost::shared_ptr< StopEarlyHandlingError > payload = ::boost::shared_ptr< StopEarlyHandlingError >
                (new StopEarlyHandlingError(DBUS_ERROR_NO_SERVER, "The DBus service SdsGuiService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "StopEarlyHandling", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<SdsGuiServiceProxy> proxyShared = ::boost::static_pointer_cast<SdsGuiServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((StopEarlyHandlingCallbackIF*) _callback)->onStopEarlyHandlingError (proxyShared,payload);
                return true;
            }
            break;
            case ID_helpCommand: {
                ::boost::shared_ptr< HelpCommandError > payload = ::boost::shared_ptr< HelpCommandError >
                (new HelpCommandError(DBUS_ERROR_NO_SERVER, "The DBus service SdsGuiService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "HelpCommand", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<SdsGuiServiceProxy> proxyShared = ::boost::static_pointer_cast<SdsGuiServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((HelpCommandCallbackIF*) _callback)->onHelpCommandError (proxyShared,payload);
                return true;
            }
            break;
            case ID_CursorIndexForInitialFocus: {
                ::boost::shared_ptr< CursorIndexForInitialFocusError > payload = ::boost::shared_ptr< CursorIndexForInitialFocusError >
                (new CursorIndexForInitialFocusError(DBUS_ERROR_NO_SERVER, "The DBus service SdsGuiService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "CursorIndexForInitialFocus", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<SdsGuiServiceProxy> proxyShared = ::boost::static_pointer_cast<SdsGuiServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((CursorIndexForInitialFocusCallbackIF*) _callback)->onCursorIndexForInitialFocusError (proxyShared,payload);
                return true;
            }
            break;
            default:
                break;
        }
        return false;
    }

    static ::asf::core::Logger&_logger;
};

::asf::core::Logger& SdsGuiServiceProxyCallback::_logger (SdsGuiServiceProxy::_logger);

SdsGuiServiceProxy::SdsGuiServiceProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable) :
    ::asf::dbus::DBusProxy(portName, "sds_gui_fi.SdsGuiService", serviceAvailable, _logger) {
}

SdsGuiServiceProxy::~SdsGuiServiceProxy()
{
    sendDeregisterAll();
    ::asf::dbus::DBusConnector::getConnector(getConnectorOptions())->deregisterProxyDelegate(_dbusProxyDelegate);
}

// static
::boost::shared_ptr< SdsGuiServiceProxy > SdsGuiServiceProxy::createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable) {
    ::boost::shared_ptr< Proxy > proxyReuse = ::asf::dbus::DBusConnector::getProxy(portName, serviceAvailable);
    if(proxyReuse) {
        LOG_INFO_STATIC ("createProxy, reuse existing proxy");
        return ::boost::static_pointer_cast<SdsGuiServiceProxy>(proxyReuse); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
    }
    LOG_INFO_STATIC ("createProxy, create new proxy");
    ::boost::shared_ptr< SdsGuiServiceProxy > proxyNew(new SdsGuiServiceProxy(portName, serviceAvailable));
    ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew);
    proxyNew->createHelperProxies(true);
    return proxyNew;
}

act_t SdsGuiServiceProxy::addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const {
    SdsGuiServiceProxyCallback* callback = new SdsGuiServiceProxyCallback(methodId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->addMethodCallback (serial, memberName, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

act_t SdsGuiServiceProxy::addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const {
    SdsGuiServiceProxyCallback* callback = new SdsGuiServiceProxyCallback(signalId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->registerSignalCallback (signal, reinterpret_cast<act_t>(callback), ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void SdsGuiServiceProxy::clearAllProperties ()
{
    _sdsStatus = ::asf::core::nullable< SdsStatusUpdate >();
    _highPrioAppStatus = ::asf::core::nullable< HighPrioAppStatusUpdate >();
}

void SdsGuiServiceProxy::sendDeregisterAll () const
{
    sendSdsStatusDeregisterAll();
    sendHighPrioAppStatusDeregisterAll();
    sendActivateAudioDeviceTagDeregisterAll();
    sendActivateAudioSourceDeregisterAll();
    sendSpokenDigitsDeregisterAll();
    sendEventDeregisterAll();
    sendEarlyPromptFinishedDeregisterAll();
    sendEarlyPromptTerminatedDeregisterAll();
}

act_t SdsGuiServiceProxy::sendActivateAudioDeviceTagRegister(ActivateAudioDeviceTagCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "ActivateAudioDeviceTag");
    act_t act = addSignalCallback(ID_ActivateAudioDeviceTag, "ActivateAudioDeviceTag", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "ActivateAudioDeviceTag", &cb, act);
    return act;
}

bool SdsGuiServiceProxy::sendActivateAudioDeviceTagDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("ActivateAudioDeviceTag", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "ActivateAudioDeviceTag", act, static_cast<int>(rv));
    return rv;
}

void SdsGuiServiceProxy::sendActivateAudioDeviceTagDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "ActivateAudioDeviceTag");
    _dbusProxyDelegate->deregisterSignalCallback("ActivateAudioDeviceTag", 0, _dbusDaemonProxy.get(), false);
}

act_t SdsGuiServiceProxy::sendActivateAudioSourceRegister(ActivateAudioSourceCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "ActivateAudioSource");
    act_t act = addSignalCallback(ID_ActivateAudioSource, "ActivateAudioSource", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "ActivateAudioSource", &cb, act);
    return act;
}

bool SdsGuiServiceProxy::sendActivateAudioSourceDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("ActivateAudioSource", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "ActivateAudioSource", act, static_cast<int>(rv));
    return rv;
}

void SdsGuiServiceProxy::sendActivateAudioSourceDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "ActivateAudioSource");
    _dbusProxyDelegate->deregisterSignalCallback("ActivateAudioSource", 0, _dbusDaemonProxy.get(), false);
}

act_t SdsGuiServiceProxy::sendSpokenDigitsRegister(SpokenDigitsCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "SpokenDigits");
    act_t act = addSignalCallback(ID_SpokenDigits, "SpokenDigits", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "SpokenDigits", &cb, act);
    return act;
}

bool SdsGuiServiceProxy::sendSpokenDigitsDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("SpokenDigits", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "SpokenDigits", act, static_cast<int>(rv));
    return rv;
}

void SdsGuiServiceProxy::sendSpokenDigitsDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "SpokenDigits");
    _dbusProxyDelegate->deregisterSignalCallback("SpokenDigits", 0, _dbusDaemonProxy.get(), false);
}

act_t SdsGuiServiceProxy::sendEventRegister(EventCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "Event");
    act_t act = addSignalCallback(ID_Event, "Event", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "Event", &cb, act);
    return act;
}

bool SdsGuiServiceProxy::sendEventDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("Event", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "Event", act, static_cast<int>(rv));
    return rv;
}

void SdsGuiServiceProxy::sendEventDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "Event");
    _dbusProxyDelegate->deregisterSignalCallback("Event", 0, _dbusDaemonProxy.get(), false);
}

act_t SdsGuiServiceProxy::sendEarlyPromptFinishedRegister(EarlyPromptFinishedCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "EarlyPromptFinished");
    act_t act = addSignalCallback(ID_EarlyPromptFinished, "EarlyPromptFinished", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "EarlyPromptFinished", &cb, act);
    return act;
}

bool SdsGuiServiceProxy::sendEarlyPromptFinishedDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("EarlyPromptFinished", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "EarlyPromptFinished", act, static_cast<int>(rv));
    return rv;
}

void SdsGuiServiceProxy::sendEarlyPromptFinishedDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "EarlyPromptFinished");
    _dbusProxyDelegate->deregisterSignalCallback("EarlyPromptFinished", 0, _dbusDaemonProxy.get(), false);
}

act_t SdsGuiServiceProxy::sendEarlyPromptTerminatedRegister(EarlyPromptTerminatedCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "EarlyPromptTerminated");
    act_t act = addSignalCallback(ID_EarlyPromptTerminated, "EarlyPromptTerminated", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "EarlyPromptTerminated", &cb, act);
    return act;
}

bool SdsGuiServiceProxy::sendEarlyPromptTerminatedDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("EarlyPromptTerminated", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "EarlyPromptTerminated", act, static_cast<int>(rv));
    return rv;
}

void SdsGuiServiceProxy::sendEarlyPromptTerminatedDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "EarlyPromptTerminated");
    _dbusProxyDelegate->deregisterSignalCallback("EarlyPromptTerminated", 0, _dbusDaemonProxy.get(), false);
}

act_t SdsGuiServiceProxy::sendSdsStatusRegister(SdsStatusCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_sdsStatus, "sdsStatus", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "SdsStatus", &cb, act);
    return act;
}

bool SdsGuiServiceProxy::sendSdsStatusDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("sdsStatus", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "SdsStatus", act, static_cast<int>(rv));
    return rv;
}

act_t SdsGuiServiceProxy::sendSdsStatusGet(SdsStatusCallbackIF& cb) {
    SdsGuiServiceProxyCallback* callback = new SdsGuiServiceProxyCallback(ID_sdsStatus, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "SdsStatus", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("sdsStatus", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


SpeechInputState SdsGuiServiceProxy::getSdsStatus() const {
    return _sdsStatus.get().getSdsStatus();
}

bool SdsGuiServiceProxy::hasSdsStatus() const {
    return _sdsStatus.hasValue();
}

void SdsGuiServiceProxy::sendSdsStatusDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "SdsStatus");
    _dbusProxyDelegate->deregisterSignalCallback("sdsStatus", 0, _dbusDaemonProxy.get(), true);
}

act_t SdsGuiServiceProxy::sendHighPrioAppStatusRegister(HighPrioAppStatusCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_HighPrioAppStatus, "HighPrioAppStatus", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "HighPrioAppStatus", &cb, act);
    return act;
}

bool SdsGuiServiceProxy::sendHighPrioAppStatusDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("HighPrioAppStatus", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "HighPrioAppStatus", act, static_cast<int>(rv));
    return rv;
}

act_t SdsGuiServiceProxy::sendHighPrioAppStatusGet(HighPrioAppStatusCallbackIF& cb) {
    SdsGuiServiceProxyCallback* callback = new SdsGuiServiceProxyCallback(ID_HighPrioAppStatus, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "HighPrioAppStatus", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("HighPrioAppStatus", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void SdsGuiServiceProxy::sendHighPrioAppStatusSet(bool highPrioAppStatus) {
    HighPrioAppStatusSet parameter(highPrioAppStatus);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet()", "HighPrioAppStatus");
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "HighPrioAppStatus", propertyContent);
}

act_t SdsGuiServiceProxy::sendHighPrioAppStatusSet(HighPrioAppStatusCallbackIF& cb, bool highPrioAppStatus) {
    SdsGuiServiceProxyCallback* callback = new SdsGuiServiceProxyCallback(ID_HighPrioAppStatus, &cb);
    HighPrioAppStatusSet parameter(highPrioAppStatus);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet(cb=%p), returning act=%" PRIuPTR, "HighPrioAppStatus", &cb, reinterpret_cast<act_t>(callback));
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "HighPrioAppStatus", propertyContent, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

bool SdsGuiServiceProxy::getHighPrioAppStatus() const {
    return _highPrioAppStatus.get().getHighPrioAppStatus();
}

bool SdsGuiServiceProxy::hasHighPrioAppStatus() const {
    return _highPrioAppStatus.hasValue();
}

void SdsGuiServiceProxy::sendHighPrioAppStatusDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "HighPrioAppStatus");
    _dbusProxyDelegate->deregisterSignalCallback("HighPrioAppStatus", 0, _dbusDaemonProxy.get(), true);
}

act_t SdsGuiServiceProxy::sendPttPressRequest(PttPressCallbackIF& cb, KeyState pttPressType) const {
    PttPressRequest* payload = new PttPressRequest();
    CHECK_ALLOCATION(payload);
    payload->setPttPressType(pttPressType);
    DBUS_MESSAGE_CALL(dbusMessage, "pttPress", PttPressRequest, payload, true)
    act_t act = addMethodCallback(ID_pttPress, dbusMessage.getUniqueSerial(), "pttPress", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "PttPress", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t SdsGuiServiceProxy::sendStartSessionContextRequest(StartSessionContextCallbackIF& cb, ContextType startupContextType) const {
    StartSessionContextRequest* payload = new StartSessionContextRequest();
    CHECK_ALLOCATION(payload);
    payload->setStartupContextType(startupContextType);
    DBUS_MESSAGE_CALL(dbusMessage, "startSessionContext", StartSessionContextRequest, payload, true)
    act_t act = addMethodCallback(ID_startSessionContext, dbusMessage.getUniqueSerial(), "startSessionContext", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "StartSessionContext", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t SdsGuiServiceProxy::sendManualOperationRequest(ManualOperationCallbackIF& cb, OperationType operationType, uint32 value) const {
    ManualOperationRequest* payload = new ManualOperationRequest();
    CHECK_ALLOCATION(payload);
    payload->setOperationType(operationType);
    payload->setValue(value);
    DBUS_MESSAGE_CALL(dbusMessage, "ManualOperation", ManualOperationRequest, payload, true)
    act_t act = addMethodCallback(ID_ManualOperation, dbusMessage.getUniqueSerial(), "ManualOperation", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "ManualOperation", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t SdsGuiServiceProxy::sendTestModeUpdateRequest(TestModeUpdateCallbackIF& cb, const ::std::string& tModesentence) const {
    TestModeUpdateRequest* payload = new TestModeUpdateRequest();
    CHECK_ALLOCATION(payload);
    payload->setTModesentence(tModesentence);
    DBUS_MESSAGE_CALL(dbusMessage, "TestModeUpdate", TestModeUpdateRequest, payload, true)
    act_t act = addMethodCallback(ID_TestModeUpdate, dbusMessage.getUniqueSerial(), "TestModeUpdate", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "TestModeUpdate", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t SdsGuiServiceProxy::sendBackPressRequest(BackPressCallbackIF& cb) const {
    BackPressRequest* payload = new BackPressRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "BackPress", BackPressRequest, payload, true)
    act_t act = addMethodCallback(ID_BackPress, dbusMessage.getUniqueSerial(), "BackPress", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "BackPress", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t SdsGuiServiceProxy::sendAbortSessionRequest(AbortSessionCallbackIF& cb) const {
    AbortSessionRequest* payload = new AbortSessionRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "AbortSession", AbortSessionRequest, payload, true)
    act_t act = addMethodCallback(ID_AbortSession, dbusMessage.getUniqueSerial(), "AbortSession", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "AbortSession", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t SdsGuiServiceProxy::sendStopSessionRequest(StopSessionCallbackIF& cb) const {
    StopSessionRequest* payload = new StopSessionRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "StopSession", StopSessionRequest, payload, true)
    act_t act = addMethodCallback(ID_StopSession, dbusMessage.getUniqueSerial(), "StopSession", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "StopSession", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t SdsGuiServiceProxy::sendPauseSessionRequest(PauseSessionCallbackIF& cb) const {
    PauseSessionRequest* payload = new PauseSessionRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "PauseSession", PauseSessionRequest, payload, true)
    act_t act = addMethodCallback(ID_PauseSession, dbusMessage.getUniqueSerial(), "PauseSession", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "PauseSession", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t SdsGuiServiceProxy::sendResumeSessionRequest(ResumeSessionCallbackIF& cb) const {
    ResumeSessionRequest* payload = new ResumeSessionRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "ResumeSession", ResumeSessionRequest, payload, true)
    act_t act = addMethodCallback(ID_ResumeSession, dbusMessage.getUniqueSerial(), "ResumeSession", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "ResumeSession", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t SdsGuiServiceProxy::sendSettingsCommandRequest(SettingsCommandCallbackIF& cb) const {
    SettingsCommandRequest* payload = new SettingsCommandRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "settingsCommand", SettingsCommandRequest, payload, true)
    act_t act = addMethodCallback(ID_settingsCommand, dbusMessage.getUniqueSerial(), "settingsCommand", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "SettingsCommand", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t SdsGuiServiceProxy::sendStartEarlyHandlingRequest(StartEarlyHandlingCallbackIF& cb) const {
    StartEarlyHandlingRequest* payload = new StartEarlyHandlingRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "StartEarlyHandling", StartEarlyHandlingRequest, payload, true)
    act_t act = addMethodCallback(ID_StartEarlyHandling, dbusMessage.getUniqueSerial(), "StartEarlyHandling", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "StartEarlyHandling", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t SdsGuiServiceProxy::sendStopEarlyHandlingRequest(StopEarlyHandlingCallbackIF& cb) const {
    StopEarlyHandlingRequest* payload = new StopEarlyHandlingRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "StopEarlyHandling", StopEarlyHandlingRequest, payload, true)
    act_t act = addMethodCallback(ID_StopEarlyHandling, dbusMessage.getUniqueSerial(), "StopEarlyHandling", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "StopEarlyHandling", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t SdsGuiServiceProxy::sendHelpCommandRequest(HelpCommandCallbackIF& cb) const {
    HelpCommandRequest* payload = new HelpCommandRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "helpCommand", HelpCommandRequest, payload, true)
    act_t act = addMethodCallback(ID_helpCommand, dbusMessage.getUniqueSerial(), "helpCommand", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "HelpCommand", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t SdsGuiServiceProxy::sendCursorIndexForInitialFocusRequest(CursorIndexForInitialFocusCallbackIF& cb, uint32 index) const {
    CursorIndexForInitialFocusRequest* payload = new CursorIndexForInitialFocusRequest();
    CHECK_ALLOCATION(payload);
    payload->setIndex(index);
    DBUS_MESSAGE_CALL(dbusMessage, "CursorIndexForInitialFocus", CursorIndexForInitialFocusRequest, payload, true)
    act_t act = addMethodCallback(ID_CursorIndexForInitialFocus, dbusMessage.getUniqueSerial(), "CursorIndexForInitialFocus", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "CursorIndexForInitialFocus", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

} // namespace SdsGuiService
} // namespace sds_gui_fi
