/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusTypesJson.h"
#include "boost/shared_ptr.hpp"
#include "sds_gui_fi/SdsDiagnosisService.h"
#include "sds_gui_fi/SdsDiagnosisServiceDBus.h"
#include "sds_gui_fi/SdsDiagnosisServiceJson.h"
#include "sds_gui_fi/SdsDiagnosisServiceProxy.h"

#include "asf/dbus/DBusDaemonProxy.h"
#include "asf/dbus/DBusPropertiesProxyWrapper.h"
#include "asf/dbus/DBusProxyDelegate.h"
#include "asf/dbus/DBusMessage.h"

namespace sds_gui_fi {
namespace SdsDiagnosisService {

DEFINE_CLASS_LOGGER("/sds_gui_fi/sds_gui_fi/SdsDiagnosisService", SdsDiagnosisServiceProxy);

class SdsDiagnosisServiceProxyCallback : public ::asf::dbus::DBusProxyCallback {
public:

    SdsDiagnosisServiceProxyCallback(uint16 functionId, void* callback) :
        ::asf::dbus::DBusProxyCallback (functionId, callback)
    {}

    bool processMessage (::asf::dbus::DBusMessage &message) {
        const ::boost::shared_ptr< SdsDiagnosisServiceProxy >& proxyShared = ::boost::static_pointer_cast< SdsDiagnosisServiceProxy >(message.getDBusProxyShared()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        switch (_functionId) {
            case ID_ExtendedSDSLoggingDataUpdate:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ExtendedSDSLoggingDataUpdateSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "ExtendedSDSLoggingDataUpdate", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<ExtendedSDSLoggingDataUpdateSignal> payload = ::boost::static_pointer_cast<ExtendedSDSLoggingDataUpdateSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((ExtendedSDSLoggingDataUpdateCallbackIF*) _callback)->onExtendedSDSLoggingDataUpdateSignal (proxyShared, payload);
                    return true;
                }
                break;
            default:
            LOG_FATAL ("Received an invalid functionId, proxy=%p", message.getProxy());
        }
        LOG_FATAL("Receveid an invalid message, proxy=%p", message.getProxy());
        return false;
    }

    bool onServiceUnavailable (const ::boost::shared_ptr< ::asf::core::Proxy >& baseProxy) {
        switch (_functionId) {
            case ID_ExtendedSDSLoggingDataUpdate: {
                ::boost::shared_ptr< ExtendedSDSLoggingDataUpdateError > payload = ::boost::shared_ptr< ExtendedSDSLoggingDataUpdateError >
                (new ExtendedSDSLoggingDataUpdateError(DBUS_ERROR_NO_SERVER, "The DBus service SdsDiagnosisService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ExtendedSDSLoggingDataUpdate", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<SdsDiagnosisServiceProxy> proxyShared = ::boost::static_pointer_cast<SdsDiagnosisServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ExtendedSDSLoggingDataUpdateCallbackIF*) _callback)->onExtendedSDSLoggingDataUpdateError (proxyShared,payload);
                return true;
            }
            break;
            default:
                break;
        }
        return false;
    }

    static ::asf::core::Logger&_logger;
};

::asf::core::Logger& SdsDiagnosisServiceProxyCallback::_logger (SdsDiagnosisServiceProxy::_logger);

SdsDiagnosisServiceProxy::SdsDiagnosisServiceProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable) :
    ::asf::dbus::DBusProxy(portName, "sds_gui_fi.SdsDiagnosisService", serviceAvailable, _logger) {
}

SdsDiagnosisServiceProxy::~SdsDiagnosisServiceProxy()
{
    sendDeregisterAll();
    ::asf::dbus::DBusConnector::getConnector(getConnectorOptions())->deregisterProxyDelegate(_dbusProxyDelegate);
}

// static
::boost::shared_ptr< SdsDiagnosisServiceProxy > SdsDiagnosisServiceProxy::createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable) {
    ::boost::shared_ptr< Proxy > proxyReuse = ::asf::dbus::DBusConnector::getProxy(portName, serviceAvailable);
    if(proxyReuse) {
        LOG_INFO_STATIC ("createProxy, reuse existing proxy");
        return ::boost::static_pointer_cast<SdsDiagnosisServiceProxy>(proxyReuse); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
    }
    LOG_INFO_STATIC ("createProxy, create new proxy");
    ::boost::shared_ptr< SdsDiagnosisServiceProxy > proxyNew(new SdsDiagnosisServiceProxy(portName, serviceAvailable));
    ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew);
    proxyNew->createHelperProxies(false);
    return proxyNew;
}

act_t SdsDiagnosisServiceProxy::addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const {
    SdsDiagnosisServiceProxyCallback* callback = new SdsDiagnosisServiceProxyCallback(methodId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->addMethodCallback (serial, memberName, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

act_t SdsDiagnosisServiceProxy::addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const {
    SdsDiagnosisServiceProxyCallback* callback = new SdsDiagnosisServiceProxyCallback(signalId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->registerSignalCallback (signal, reinterpret_cast<act_t>(callback), ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


void SdsDiagnosisServiceProxy::sendDeregisterAll () const
{
    sendExtendedSDSLoggingDataUpdateDeregisterAll();
}

act_t SdsDiagnosisServiceProxy::sendExtendedSDSLoggingDataUpdateRegister(ExtendedSDSLoggingDataUpdateCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "ExtendedSDSLoggingDataUpdate");
    act_t act = addSignalCallback(ID_ExtendedSDSLoggingDataUpdate, "ExtendedSDSLoggingDataUpdate", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "ExtendedSDSLoggingDataUpdate", &cb, act);
    return act;
}

bool SdsDiagnosisServiceProxy::sendExtendedSDSLoggingDataUpdateDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("ExtendedSDSLoggingDataUpdate", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "ExtendedSDSLoggingDataUpdate", act, static_cast<int>(rv));
    return rv;
}

void SdsDiagnosisServiceProxy::sendExtendedSDSLoggingDataUpdateDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "ExtendedSDSLoggingDataUpdate");
    _dbusProxyDelegate->deregisterSignalCallback("ExtendedSDSLoggingDataUpdate", 0, _dbusDaemonProxy.get(), false);
}

} // namespace SdsDiagnosisService
} // namespace sds_gui_fi
