/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef SDS_GUI_FI_SDSDATAHANDOVERSERVICESTUB_H
#define SDS_GUI_FI_SDSDATAHANDOVERSERVICESTUB_H

#include "asf/core/Logger.h"
#include "asf/dbus/DBusStub.h"
#include "asf/dbus/DBusVariant.h"
#include "boost/shared_ptr.hpp"
#include "sds_gui_fi/SdsDataHandoverService.h"

namespace sds_gui_fi {
namespace SdsDataHandoverService {

class SdsDataHandoverServiceStubDelegate;

class SdsDataHandoverServiceStub : public ::asf::dbus::DBusStub
{
public:

    /**
     * Create an instance of the SdsDataHandoverServiceStub
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     */
    SdsDataHandoverServiceStub (const std::string& portName);

    /**
     * Create an instance of the SdsDataHandoverServiceStub
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     * @param objectPath the dbus object path, see
     * http://dbus.freedesktop.org/doc/dbus-specification.html#message-protocol-marshaling-object-path
     */
    SdsDataHandoverServiceStub (const std::string& portName, const std::string& objectPath);

    virtual ~SdsDataHandoverServiceStub();

    // property 'SendHandoverData'

    /**
     * The method onSendHandoverDataGet() is called by ASF when a client
     * invokes the read method for the property 'SendHandoverData'. The
     * onSendHandoverDataGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'SendHandoverData'</b>:
     *
     * If the meaning of "SendHandoverData" isn't clear, then there should be a description here.
     */
    virtual void onSendHandoverDataGet(const ::boost::shared_ptr< SendHandoverDataGet >& payload);

    /**
     * Sends back the update to a previous onSendHandoverDataGet().
     *
     * <b>Documentation of 'SendHandoverData'</b>:
     *
     * If the meaning of "SendHandoverData" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of onSendHandoverDataGet().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendSendHandoverDataGetUpdate(bool sendHandoverData, act_t act = 0);

    /**
     * The method onSendHandoverDataSet() is called by ASF when a client
     * invokes the write method for the property 'SendHandoverData'. The
     * onSendHandoverDataSet() method set property value to the given
     * parameter SendHandoverData by default. If this default behavior doesn't
     * match your needs feel free to override this method.
     *
     * <b>Documentation of 'SendHandoverData'</b>:
     *
     * If the meaning of "SendHandoverData" isn't clear, then there should be a description here.
     */
    virtual void onSendHandoverDataSet(const ::boost::shared_ptr< SendHandoverDataSet >& payload);

    /**
     * Sends back the update to a previous onSendHandoverDataSet().
     *
     * <b>Documentation of 'SendHandoverData'</b>:
     *
     * If the meaning of "SendHandoverData" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of onSendHandoverDataSet().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendSendHandoverDataSetUpdate(act_t act = 0);

    /**
     * Set the value of the property 'SendHandoverData' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'SendHandoverData'</b>:
     *
     * If the meaning of "SendHandoverData" isn't clear, then there should be a description here.
     */
    void setSendHandoverData(bool sendHandoverData);

    /**
     * Returns the current value of the property 'SendHandoverData'.
     *
     * <b>Documentation of 'SendHandoverData'</b>:
     *
     * If the meaning of "SendHandoverData" isn't clear, then there should be a description here.
     */
    bool getSendHandoverData() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendSendHandoverDataUpdate().
     *
     * <b>Documentation of 'SendHandoverData'</b>:
     *
     * If the meaning of "SendHandoverData" isn't clear, then there should be a description here.
     */
    void sendSendHandoverDataUpdate();

    // method 'DataHandover'

    /**
     * The method onDataHandover() is called by ASF when a client invokes the
     * method 'DataHandover'. A subclass has to implement this method and send
     * back a response to the client either with the sendDataHandover() or
     * sendDataHandoverError() method. Do not invoke this method on your own.
     *
     * <b>Documentation of 'DataHandover'</b>:
     *
     * If the meaning of "DataHandover" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onDataHandoverRequest (const ::boost::shared_ptr< DataHandoverRequest >& request) = 0;

    /**
     * The method sendDataHandoverResponse() sends a response of a previous
     * method invocation of 'DataHandover' back to the client.
     *
     * <b>Documentation of 'DataHandover'</b>:
     *
     * If the meaning of "DataHandover" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onDataHandover(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendDataHandoverResponse (act_t act = 0);

    /**
     * The method sendDataHandoverError() sends an error response of a
     * previous method invocation of 'DataHandover' back to the client.
     *
     * <b>Documentation of 'DataHandover'</b>:
     *
     * If the meaning of "DataHandover" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onDataHandover(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendDataHandoverError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

private:
    void onGetAll(std::map<std::basic_string<char>, ::asf::dbus::DBusVariant>&) const;

    SendHandoverDataUpdate _SendHandoverDataProperty;

    friend class SdsDataHandoverServiceStubDelegate;

    DECLARE_CLASS_LOGGER();
};

} // namespace SdsDataHandoverService
} // namespace sds_gui_fi

#endif // SDS_GUI_FI_SDSDATAHANDOVERSERVICESTUB_H
