/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/dbus/DBusStubDelegate.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "sds_gui_fi/SdsDataHandoverService.h"
#include "sds_gui_fi/SdsDataHandoverServiceDBus.h"
#include "sds_gui_fi/SdsDataHandoverServiceJson.h"
#include "sds_gui_fi/SdsDataHandoverServiceStub.h"

#include "asf/dbus/DBusMessage.h"

namespace sds_gui_fi {
namespace SdsDataHandoverService {

DEFINE_CLASS_LOGGER("/sds_gui_fi/sds_gui_fi/SdsDataHandoverService", SdsDataHandoverServiceStub);

static ::asf::dbus::DBusUtils::stringEntry methodsTable[] = {
    { 12, "DataHandover", 0 },
};

static ::asf::dbus::DBusUtils::stringEntry propertiesTable[] = {
    { 16, "SendHandoverData", 0 },
};

class SdsDataHandoverServiceStubDelegate : public ::asf::dbus::DBusStubDelegate {
public:

    SdsDataHandoverServiceStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger) :
        ::asf::dbus::DBusStubDelegate( stub, logger),
        _logger(logger)
    {}

    SdsDataHandoverServiceStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger, const std::string& objectPath) :
        ::asf::dbus::DBusStubDelegate( stub, logger, objectPath),
        _logger(logger) {}

    SdsDataHandoverServiceStubDelegate(::asf::dbus::DBusStub* stub,
                               ::asf::core::Logger& logger,
                               ::asf::dbus::DBusConnector& connector,
                               const std::string& objectPath)
        : ::asf::dbus::DBusStubDelegate(
              stub, logger, connector, objectPath, "sds_gui_fi.SdsDataHandoverService"),
          _logger(logger) {}

    virtual ~SdsDataHandoverServiceStubDelegate() {}

    virtual void process(::asf::core::ServiceMessage& msg);

    const char* introspect() const;

    virtual void getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties);

    virtual void setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act);

    virtual void getProperty(const ::std::string& property, const act_t& act);

private:

    ::asf::core::Logger& _logger;

};

void SdsDataHandoverServiceStubDelegate::process(::asf::core::ServiceMessage& msg) {
    ::asf::dbus::DBusMessage& message = static_cast< ::asf::dbus::DBusMessage& >(msg);
    LOG_DEBUG_STUB("Entering process(memberName='%s')", message.getMemberName().c_str());

    unsigned int methodIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (message.getMemberName().c_str(), message.getMemberName().length(), methodsTable, 1, methodIndex)) {
        switch (methodIndex) {
        case 0: {

            // method 'DataHandover'

            LOG_DEBUG_STUB("process method '%s'", "DataHandover");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), DataHandoverRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "DataHandover", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< DataHandoverRequest > payload = ::boost::static_pointer_cast<DataHandoverRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<SdsDataHandoverServiceStub*>(getStub())->onDataHandoverRequest(payload);
            return;
        }
        default:
            break;
        }
    }
    LOG_FATAL_STUB("can't process message %s", message.getMemberName().c_str());
}

const char* SdsDataHandoverServiceStubDelegate::introspect() const {
    return     "<interface name=\"sds_gui_fi.SdsDataHandoverService\">\n"
            "    <property access=\"readwrite\" name=\"SendHandoverData\" type=\"b\"/>\n"
            "    <method name=\"DataHandover\">\n"
            "      <arg direction=\"in\" name=\"screenType\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>screenType = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"screenState\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>screenState = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"data\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>data = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "</interface>\n";
}

void SdsDataHandoverServiceStubDelegate::getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) {
    (static_cast<SdsDataHandoverServiceStub*>(getStub()))->onGetAll (properties);
}

void SdsDataHandoverServiceStubDelegate::setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act) {
    unsigned int propertyIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (property.c_str(), property.length(), propertiesTable, 1, propertyIndex)) {
        switch (propertyIndex) {
        case 0: {
            LOG_DEBUG_STUB("process property '%s'", "SendHandoverData");
            ::boost::shared_ptr< SendHandoverDataSet > payload(new SendHandoverDataSet());
            payload->setAct(act);
            deserializeDBus(const_cast< ::asf::dbus::DBusVariant& >(value).getReadIterator(), *payload);
            static_cast<SdsDataHandoverServiceStub*>(getStub())->onSendHandoverDataSet (payload);
            return;
        }
        default:
            break;
        }
    }
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendSetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

void SdsDataHandoverServiceStubDelegate::getProperty(const ::std::string& property, const act_t& act) {
    unsigned int propertyIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (property.c_str(), property.length(), propertiesTable, 1, propertyIndex)) {
        switch (propertyIndex) {
        case 0: {
            LOG_DEBUG_STUB("process property '%s'", "SendHandoverData");
            ::boost::shared_ptr< SendHandoverDataGet > payload(new SendHandoverDataGet());
            payload->setAct(act);
            static_cast<SdsDataHandoverServiceStub*>(getStub())->onSendHandoverDataGet (payload);
            return;
        }
        default:
            break;
        }
    }
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendGetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

SdsDataHandoverServiceStub::SdsDataHandoverServiceStub (const std::string& portName) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new SdsDataHandoverServiceStubDelegate(this, _logger);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

SdsDataHandoverServiceStub::SdsDataHandoverServiceStub (const std::string& portName, const std::string& objectPath) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new SdsDataHandoverServiceStubDelegate(this, _logger, objectPath);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

SdsDataHandoverServiceStub::~SdsDataHandoverServiceStub() {
    delete _stubDelegate;
}

void SdsDataHandoverServiceStub::sendSendHandoverDataUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        SendHandoverDataUpdate payload(_SendHandoverDataProperty);

        LOG_INFO ("-> send%s", "SendHandoverDataUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("SendHandoverData", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("sds_gui_fi.SdsDataHandoverService", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "SendHandoverDataUpdate");
    }
}

void SdsDataHandoverServiceStub::onSendHandoverDataGet(const ::boost::shared_ptr< SendHandoverDataGet >& sendHandoverData) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "SendHandoverDataGet", sendHandoverData->getAct());
    sendSendHandoverDataGetUpdate(_SendHandoverDataProperty.getSendHandoverData(), sendHandoverData->getAct());
}

void SdsDataHandoverServiceStub::sendSendHandoverDataGetUpdate(bool sendHandoverData, act_t act) {
    ::asf::dbus::DBusVariant variant;
    SendHandoverDataGet payload(sendHandoverData);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "SendHandoverDataGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void SdsDataHandoverServiceStub::onSendHandoverDataSet(const ::boost::shared_ptr< SendHandoverDataSet >& sendHandoverData) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "SendHandoverDataSet", sendHandoverData->getAct());
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(*sendHandoverData, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }
    setSendHandoverData (sendHandoverData->getSendHandoverData());
    sendSendHandoverDataSetUpdate(sendHandoverData->getAct());
}

void SdsDataHandoverServiceStub::sendSendHandoverDataSetUpdate(act_t act) {
    LOG_INFO ("-> send%s, act=%" PRIuPTR, "SendHandoverDataSetUpdate", act);
    _stubDelegate->sendSetResponse(act);
}

void SdsDataHandoverServiceStub::setSendHandoverData(bool sendHandoverData) {
    if(sendHandoverData!=_SendHandoverDataProperty.getSendHandoverData()) {
        _SendHandoverDataProperty.setSendHandoverData(sendHandoverData);
        sendSendHandoverDataUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

bool SdsDataHandoverServiceStub::getSendHandoverData() const {
    return _SendHandoverDataProperty.getSendHandoverData();
}

void  SdsDataHandoverServiceStub::sendDataHandoverResponse (act_t act) {
    DataHandoverResponse* payload = new DataHandoverResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "DataHandover", DataHandoverResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "DataHandover", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  SdsDataHandoverServiceStub::sendDataHandoverError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    DataHandoverError* payload = new DataHandoverError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "DataHandover", DataHandoverError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "DataHandover", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void SdsDataHandoverServiceStub::onGetAll(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) const {

    //property 'SendHandoverData'
    {
        ::asf::dbus::DBusVariant variant;
        SendHandoverDataGet payload(_SendHandoverDataProperty.getSendHandoverData());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("SendHandoverData", variant));
    }
}

} // namespace SdsDataHandoverService
} // namespace sds_gui_fi
