/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef SDS_GUI_FI_SDSDATAHANDOVERSERVICEPROXY_H
#define SDS_GUI_FI_SDSDATAHANDOVERSERVICEPROXY_H

#include "asf/core/Logger.h"
#include "asf/core/nullable.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusProxy.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "com/bosch/cm/asf/lang/dbus/Connectors.h"
#include "sds_gui_fi/SdsDataHandoverService.h"
#include "sds_gui_fi/SdsDataHandoverServiceConst.h"
#include <dbus/dbus.h>
#include <string>

namespace sds_gui_fi {
namespace SdsDataHandoverService {

class SdsDataHandoverServiceProxy;

class DataHandoverCallbackIF {
public:
    virtual ~DataHandoverCallbackIF() {}

    virtual void onDataHandoverError(const ::boost::shared_ptr< SdsDataHandoverServiceProxy >& proxy, const ::boost::shared_ptr< DataHandoverError >& error) = 0;

    virtual void onDataHandoverResponse(const ::boost::shared_ptr< SdsDataHandoverServiceProxy >& proxy, const ::boost::shared_ptr< DataHandoverResponse >& response) = 0;
};

class SendHandoverDataCallbackIF {
public:
    virtual ~SendHandoverDataCallbackIF() {}

    virtual void onSendHandoverDataError(const ::boost::shared_ptr< SdsDataHandoverServiceProxy >& proxy, const ::boost::shared_ptr< SendHandoverDataError >& error) = 0;

    virtual void onSendHandoverDataUpdate(const ::boost::shared_ptr< SdsDataHandoverServiceProxy >& proxy, const ::boost::shared_ptr< SendHandoverDataUpdate >& update) = 0;
};


/**
 * SdsDataHandoverServiceProxy is the client side representation of the
 * D-Bus service interface 'sds_gui_fi.SdsDataHandoverService' (specified
 * in file sds_gui_fi_.xml).
 *
 * If the meaning of "sds_gui_fi.SdsDataHandoverService" isn't clear, then there should be a description here.
 */
class SdsDataHandoverServiceProxy : public ::asf::dbus::DBusProxy
{
public:
    /**
     * Create a new instance of SdsDataHandoverServiceProxy.
     */
    static ::boost::shared_ptr< SdsDataHandoverServiceProxy > createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    /**
     * Create a new instance of SdsDataHandoverServiceProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @deprecated use the createProxy() method with the parameter
     * ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector instead.
     */
    static ::boost::shared_ptr< SdsDataHandoverServiceProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        ::DBusBusType busType,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector connectorOptions;
        connectorOptions.setBusType(::asf::dbus::DBusUtils::toOptions(busType).getBusType());
        return createProxy(portName, busName, objectPath, connectorOptions, serviceAvailable);
    }

    /**
     * Create a new instance of SdsDataHandoverServiceProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     */
    static ::boost::shared_ptr< SdsDataHandoverServiceProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        const ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector& connectorOptions,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        LOG_INFO_STATIC ("createProxy, create new proxy");
        ::boost::shared_ptr< SdsDataHandoverServiceProxy > proxyNew(new SdsDataHandoverServiceProxy(portName, serviceAvailable));
        ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew, busName, objectPath, connectorOptions);
        proxyNew->createHelperProxies(true);
        return proxyNew;
    }

    virtual ~SdsDataHandoverServiceProxy ();



    // Property 'SendHandoverData'

    /**
     * Notify on the property 'SendHandoverData'. This method registers for
     * property changes by D-Bus service.
     *
     * <b>Documentation of 'SendHandoverData'</b>:
     *
     * If the meaning of "SendHandoverData" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSendHandoverDataRegister(SendHandoverDataCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'SendHandoverData'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'SendHandoverData'</b>:
     *
     * If the meaning of "SendHandoverData" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendSendHandoverDataRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendSendHandoverDataDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'SendHandoverData'.
     */
    void sendSendHandoverDataDeregisterAll() const;

    /**
     * Request the value of the property 'SendHandoverData' from the D-Bus
     * server. This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'SendHandoverData'</b>:
     *
     * If the meaning of "SendHandoverData" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSendHandoverDataGet(SendHandoverDataCallbackIF& cb);

    /**
     * Set the value of the property 'SendHandoverData'. This method sends a
     * Set message to the D-Bus server.
     *
     * @deprecated use the sendSendHandoverDataSet(SendHandoverDataCallbackIF&
     * cb, bool sendHandoverData) method instead.
     *
     * <b>Documentation of 'SendHandoverData'</b>:
     *
     * If the meaning of "SendHandoverData" isn't clear, then there should be a description here.
     */
    void sendSendHandoverDataSet(bool sendHandoverData);

    /**
     * Set the value of the property 'SendHandoverData'. This method sends a
     * Set message to the D-Bus server.
     *
     * <b>Documentation of 'SendHandoverData'</b>:
     *
     * If the meaning of "SendHandoverData" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Set message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSendHandoverDataSet(SendHandoverDataCallbackIF& cb, bool sendHandoverData);

    /**
     * Returns the current value of the property 'SendHandoverData' (as known
     * by the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasSendHandoverData() returns true.
     *
     * @return the previously received value of the property 'SendHandoverData'.
     */
    bool getSendHandoverData() const;

    /**
     * Determines whether a status message for the property 'SendHandoverData'
     * was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasSendHandoverData() const;


    // Method 'DataHandover'

    /**
     * Call the method 'DataHandover'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'DataHandover'</b>:
     *
     * If the meaning of "DataHandover" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param screenType If the meaning of "screenType" isn't clear, then there should be a description here.
     *
     * @param screenState If the meaning of "screenState" isn't clear, then there should be a description here.
     *
     * @param data If the meaning of "data" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDataHandoverRequest(DataHandoverCallbackIF& cb, ScreenType screenType, ScreenState screenState, const ::std::string& data) const;

    /**
     * Release all property and signal notifications.
     */
    void sendDeregisterAll () const;

private:

    SdsDataHandoverServiceProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    act_t addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const;

    act_t addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const;

    virtual void clearAllProperties ();

    // Property 'SendHandoverData'

    ::asf::core::nullable< SendHandoverDataUpdate > _sendHandoverData;

    DECLARE_CLASS_LOGGER();

    friend class SdsDataHandoverServiceProxyCallback;
};

} // namespace SdsDataHandoverService
} // namespace sds_gui_fi

#endif // SDS_GUI_FI_SDSDATAHANDOVERSERVICEPROXY_H
