/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "sds_gui_fi/SdsDataHandoverService.h"
#include "sds_gui_fi/SdsDataHandoverServiceConst.h"
#include "sds_gui_fi/SdsDataHandoverServiceDBus.h"
#include "sds_gui_fi/SdsDataHandoverServiceJson.h"
#include "sds_gui_fi/SdsDataHandoverServiceProxy.h"
#include <string>

#include "asf/dbus/DBusDaemonProxy.h"
#include "asf/dbus/DBusPropertiesProxyWrapper.h"
#include "asf/dbus/DBusProxyDelegate.h"
#include "asf/dbus/DBusMessage.h"

namespace sds_gui_fi {
namespace SdsDataHandoverService {

DEFINE_CLASS_LOGGER("/sds_gui_fi/sds_gui_fi/SdsDataHandoverService", SdsDataHandoverServiceProxy);

class SdsDataHandoverServiceProxyCallback : public ::asf::dbus::DBusProxyCallback {
public:

    SdsDataHandoverServiceProxyCallback(uint16 functionId, void* callback) :
        ::asf::dbus::DBusProxyCallback (functionId, callback)
    {}

    bool processMessage (::asf::dbus::DBusMessage &message) {
        const ::boost::shared_ptr< SdsDataHandoverServiceProxy >& proxyShared = ::boost::static_pointer_cast< SdsDataHandoverServiceProxy >(message.getDBusProxyShared()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        switch (_functionId) {
            case ID_SendHandoverData:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SendHandoverDataError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "SendHandoverData", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SendHandoverDataError> payload = ::boost::static_pointer_cast<SendHandoverDataError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((SendHandoverDataCallbackIF*) _callback)->onSendHandoverDataError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SendHandoverDataUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "SendHandoverData", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SendHandoverDataUpdate> payload = ::boost::static_pointer_cast<SendHandoverDataUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((SendHandoverDataCallbackIF*) _callback)->onSendHandoverDataUpdate(proxyShared, payload);
                        proxyShared->_sendHandoverData = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_DataHandover:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), DataHandoverError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "DataHandover", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<DataHandoverError> payload = ::boost::static_pointer_cast<DataHandoverError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((DataHandoverCallbackIF*) _callback)->onDataHandoverError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), DataHandoverResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "DataHandover", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<DataHandoverResponse> payload = ::boost::static_pointer_cast<DataHandoverResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((DataHandoverCallbackIF*) _callback)->onDataHandoverResponse (proxyShared, payload);
                        return true;
                    }
                }
            default:
            LOG_FATAL ("Received an invalid functionId, proxy=%p", message.getProxy());
        }
        LOG_FATAL("Receveid an invalid message, proxy=%p", message.getProxy());
        return false;
    }

    bool onServiceUnavailable (const ::boost::shared_ptr< ::asf::core::Proxy >& baseProxy) {
        switch (_functionId) {
            case ID_SendHandoverData: {
                ::boost::shared_ptr< SendHandoverDataError > payload = ::boost::shared_ptr< SendHandoverDataError >
                (new SendHandoverDataError(DBUS_ERROR_NO_SERVER, "The DBus service SdsDataHandoverService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SendHandoverData", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<SdsDataHandoverServiceProxy> proxyShared = ::boost::static_pointer_cast<SdsDataHandoverServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SendHandoverDataCallbackIF*) _callback)->onSendHandoverDataError (proxyShared,payload);
                return true;
            }
            break;
            case ID_DataHandover: {
                ::boost::shared_ptr< DataHandoverError > payload = ::boost::shared_ptr< DataHandoverError >
                (new DataHandoverError(DBUS_ERROR_NO_SERVER, "The DBus service SdsDataHandoverService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "DataHandover", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<SdsDataHandoverServiceProxy> proxyShared = ::boost::static_pointer_cast<SdsDataHandoverServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((DataHandoverCallbackIF*) _callback)->onDataHandoverError (proxyShared,payload);
                return true;
            }
            break;
            default:
                break;
        }
        return false;
    }

    static ::asf::core::Logger&_logger;
};

::asf::core::Logger& SdsDataHandoverServiceProxyCallback::_logger (SdsDataHandoverServiceProxy::_logger);

SdsDataHandoverServiceProxy::SdsDataHandoverServiceProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable) :
    ::asf::dbus::DBusProxy(portName, "sds_gui_fi.SdsDataHandoverService", serviceAvailable, _logger) {
}

SdsDataHandoverServiceProxy::~SdsDataHandoverServiceProxy()
{
    sendDeregisterAll();
    ::asf::dbus::DBusConnector::getConnector(getConnectorOptions())->deregisterProxyDelegate(_dbusProxyDelegate);
}

// static
::boost::shared_ptr< SdsDataHandoverServiceProxy > SdsDataHandoverServiceProxy::createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable) {
    ::boost::shared_ptr< Proxy > proxyReuse = ::asf::dbus::DBusConnector::getProxy(portName, serviceAvailable);
    if(proxyReuse) {
        LOG_INFO_STATIC ("createProxy, reuse existing proxy");
        return ::boost::static_pointer_cast<SdsDataHandoverServiceProxy>(proxyReuse); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
    }
    LOG_INFO_STATIC ("createProxy, create new proxy");
    ::boost::shared_ptr< SdsDataHandoverServiceProxy > proxyNew(new SdsDataHandoverServiceProxy(portName, serviceAvailable));
    ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew);
    proxyNew->createHelperProxies(true);
    return proxyNew;
}

act_t SdsDataHandoverServiceProxy::addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const {
    SdsDataHandoverServiceProxyCallback* callback = new SdsDataHandoverServiceProxyCallback(methodId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->addMethodCallback (serial, memberName, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

act_t SdsDataHandoverServiceProxy::addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const {
    SdsDataHandoverServiceProxyCallback* callback = new SdsDataHandoverServiceProxyCallback(signalId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->registerSignalCallback (signal, reinterpret_cast<act_t>(callback), ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void SdsDataHandoverServiceProxy::clearAllProperties ()
{
    _sendHandoverData = ::asf::core::nullable< SendHandoverDataUpdate >();
}

void SdsDataHandoverServiceProxy::sendDeregisterAll () const
{
    sendSendHandoverDataDeregisterAll();
}

act_t SdsDataHandoverServiceProxy::sendSendHandoverDataRegister(SendHandoverDataCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_SendHandoverData, "SendHandoverData", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "SendHandoverData", &cb, act);
    return act;
}

bool SdsDataHandoverServiceProxy::sendSendHandoverDataDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("SendHandoverData", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "SendHandoverData", act, static_cast<int>(rv));
    return rv;
}

act_t SdsDataHandoverServiceProxy::sendSendHandoverDataGet(SendHandoverDataCallbackIF& cb) {
    SdsDataHandoverServiceProxyCallback* callback = new SdsDataHandoverServiceProxyCallback(ID_SendHandoverData, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "SendHandoverData", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("SendHandoverData", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void SdsDataHandoverServiceProxy::sendSendHandoverDataSet(bool sendHandoverData) {
    SendHandoverDataSet parameter(sendHandoverData);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet()", "SendHandoverData");
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "SendHandoverData", propertyContent);
}

act_t SdsDataHandoverServiceProxy::sendSendHandoverDataSet(SendHandoverDataCallbackIF& cb, bool sendHandoverData) {
    SdsDataHandoverServiceProxyCallback* callback = new SdsDataHandoverServiceProxyCallback(ID_SendHandoverData, &cb);
    SendHandoverDataSet parameter(sendHandoverData);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet(cb=%p), returning act=%" PRIuPTR, "SendHandoverData", &cb, reinterpret_cast<act_t>(callback));
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "SendHandoverData", propertyContent, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

bool SdsDataHandoverServiceProxy::getSendHandoverData() const {
    return _sendHandoverData.get().getSendHandoverData();
}

bool SdsDataHandoverServiceProxy::hasSendHandoverData() const {
    return _sendHandoverData.hasValue();
}

void SdsDataHandoverServiceProxy::sendSendHandoverDataDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "SendHandoverData");
    _dbusProxyDelegate->deregisterSignalCallback("SendHandoverData", 0, _dbusDaemonProxy.get(), true);
}

act_t SdsDataHandoverServiceProxy::sendDataHandoverRequest(DataHandoverCallbackIF& cb, ScreenType screenType, ScreenState screenState, const ::std::string& data) const {
    DataHandoverRequest* payload = new DataHandoverRequest();
    CHECK_ALLOCATION(payload);
    payload->setScreenType(screenType);
    payload->setScreenState(screenState);
    payload->setData(data);
    DBUS_MESSAGE_CALL(dbusMessage, "DataHandover", DataHandoverRequest, payload, true)
    act_t act = addMethodCallback(ID_DataHandover, dbusMessage.getUniqueSerial(), "DataHandover", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "DataHandover", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

} // namespace SdsDataHandoverService
} // namespace sds_gui_fi
