/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusStubDelegate.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "sds_gui_fi/PopUpService.h"
#include "sds_gui_fi/PopUpServiceConst.h"
#include "sds_gui_fi/PopUpServiceDBus.h"
#include "sds_gui_fi/PopUpServiceJson.h"
#include "sds_gui_fi/PopUpServiceStub.h"
#include <string>
#include <vector>

#include "asf/dbus/DBusMessage.h"

namespace sds_gui_fi {
namespace PopUpService {

DEFINE_CLASS_LOGGER("/sds_gui_fi/sds_gui_fi/PopUpService", PopUpServiceStub);


static ::asf::dbus::DBusUtils::stringEntry propertiesTable[] = {
    { 8, "screenID", 0 },
    { 9, "sdsStatus", 1 },
    { 15, "microphoneLevel", 2 },
};

class PopUpServiceStubDelegate : public ::asf::dbus::DBusStubDelegate {
public:

    PopUpServiceStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger) :
        ::asf::dbus::DBusStubDelegate( stub, logger),
        _logger(logger)
    {}

    PopUpServiceStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger, const std::string& objectPath) :
        ::asf::dbus::DBusStubDelegate( stub, logger, objectPath),
        _logger(logger) {}

    PopUpServiceStubDelegate(::asf::dbus::DBusStub* stub,
                               ::asf::core::Logger& logger,
                               ::asf::dbus::DBusConnector& connector,
                               const std::string& objectPath)
        : ::asf::dbus::DBusStubDelegate(
              stub, logger, connector, objectPath, "sds_gui_fi.PopUpService"),
          _logger(logger) {}

    virtual ~PopUpServiceStubDelegate() {}

    virtual void process(::asf::core::ServiceMessage& msg);

    const char* introspect() const;

    virtual void getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties);

    virtual void setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act);

    virtual void getProperty(const ::std::string& property, const act_t& act);

private:

    ::asf::core::Logger& _logger;

};

void PopUpServiceStubDelegate::process(::asf::core::ServiceMessage& msg) {
    ::asf::dbus::DBusMessage& message = static_cast< ::asf::dbus::DBusMessage& >(msg);
    LOG_DEBUG_STUB("Entering process(memberName='%s')", message.getMemberName().c_str());

    LOG_FATAL_STUB("can't process message %s", message.getMemberName().c_str());
}

const char* PopUpServiceStubDelegate::introspect() const {
    return     "<interface name=\"sds_gui_fi.PopUpService\">\n"
            "    <property access=\"read\" name=\"screenID\" type=\"s\"/>\n"
            "    <property access=\"read\" name=\"sdsStatus\" type=\"u\"/>\n"
            "    <property access=\"read\" name=\"microphoneLevel\" type=\"u\"/>\n"
            "    <signal name=\"PopupRequestClose\"/>\n"
            "    <signal name=\"PopupRequest\">\n"
            "      <arg direction=\"out\" name=\"layout\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>layout = The layout type of the popup.</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"header\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>header = The headline string. Can contain line breaks.</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"speechInputState\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>speechInputState = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"textFields\" type=\"a(ssu)\">\n"
            "        <doc>\n"
            "          <line>textFields = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"pageNumber\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>pageNumber = The current page number of the list in the popup.</line>\n"
            "          <line>Values start at 0 for the first page.</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"numberOfPages\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>numberOfPages = The number of pages of the list in the popup.</line>\n"
            "          <line>Value 0 means that the feature is not used.</line>\n"
            "          <line>Values starting at 1 indicate a valid number of pages.</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"selectableCommandPointerIndex\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>selectableCommandPointerIndex = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"nextPreviousOption\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>nextPreviousOption = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"speakableList\" type=\"b\">\n"
            "        <doc>\n"
            "          <line>speakableList = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </signal>\n"
            "</interface>\n";
}

void PopUpServiceStubDelegate::getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) {
    (static_cast<PopUpServiceStub*>(getStub()))->onGetAll (properties);
}

void PopUpServiceStubDelegate::setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act) {
    unsigned int propertyIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (property.c_str(), property.length(), propertiesTable, 3, propertyIndex)) {
        switch (propertyIndex) {
        case 0: {
            LOG_DEBUG_STUB("process property '%s'", "screenID");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 1: {
            LOG_DEBUG_STUB("process property '%s'", "sdsStatus");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 2: {
            LOG_DEBUG_STUB("process property '%s'", "microphoneLevel");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        default:
            break;
        }
    }
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendSetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

void PopUpServiceStubDelegate::getProperty(const ::std::string& property, const act_t& act) {
    unsigned int propertyIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (property.c_str(), property.length(), propertiesTable, 3, propertyIndex)) {
        switch (propertyIndex) {
        case 0: {
            LOG_DEBUG_STUB("process property '%s'", "screenID");
            ::boost::shared_ptr< ScreenIDGet > payload(new ScreenIDGet());
            payload->setAct(act);
            static_cast<PopUpServiceStub*>(getStub())->onScreenIDGet (payload);
            return;
        }
        case 1: {
            LOG_DEBUG_STUB("process property '%s'", "sdsStatus");
            ::boost::shared_ptr< SdsStatusGet > payload(new SdsStatusGet());
            payload->setAct(act);
            static_cast<PopUpServiceStub*>(getStub())->onSdsStatusGet (payload);
            return;
        }
        case 2: {
            LOG_DEBUG_STUB("process property '%s'", "microphoneLevel");
            ::boost::shared_ptr< MicrophoneLevelGet > payload(new MicrophoneLevelGet());
            payload->setAct(act);
            static_cast<PopUpServiceStub*>(getStub())->onMicrophoneLevelGet (payload);
            return;
        }
        default:
            break;
        }
    }
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendGetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

PopUpServiceStub::PopUpServiceStub (const std::string& portName) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new PopUpServiceStubDelegate(this, _logger);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

PopUpServiceStub::PopUpServiceStub (const std::string& portName, const std::string& objectPath) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new PopUpServiceStubDelegate(this, _logger, objectPath);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

PopUpServiceStub::~PopUpServiceStub() {
    delete _stubDelegate;
}

void PopUpServiceStub::sendPopupRequestCloseSignal() {
    if (_stubDelegate->isConnected()) {
        PopupRequestCloseSignal* payload = new PopupRequestCloseSignal;
        DBUS_MESSAGE_SIGNAL(dbusMessage, "PopupRequestClose", PopupRequestCloseSignal, payload)
        LOG_INFO ("-> send%sSignal", "PopupRequestClose");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "PopupRequestClose");
    }
}

void PopUpServiceStub::sendPopupRequestSignal(const ::std::string& layout, const ::std::string& header, SpeechInputState speechInputState, const ::std::vector< TextField >& textFields, uint32 pageNumber, uint32 numberOfPages, uint32 selectableCommandPointerIndex, NextPreviousOption nextPreviousOption, bool speakableList) {
    if (_stubDelegate->isConnected()) {
        PopupRequestSignal* payload = new PopupRequestSignal(layout, header, speechInputState, textFields, pageNumber, numberOfPages, selectableCommandPointerIndex, nextPreviousOption, speakableList);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "PopupRequest", PopupRequestSignal, payload)
        LOG_INFO ("-> send%sSignal", "PopupRequest");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "PopupRequest");
    }
}

void PopUpServiceStub::sendScreenIDUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        ScreenIDUpdate payload(_screenIDProperty);

        LOG_INFO ("-> send%s", "ScreenIDUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("screenID", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("sds_gui_fi.PopUpService", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "ScreenIDUpdate");
    }
}

void PopUpServiceStub::onScreenIDGet(const ::boost::shared_ptr< ScreenIDGet >& screenID) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "ScreenIDGet", screenID->getAct());
    sendScreenIDGetUpdate(_screenIDProperty.getScreenID(), screenID->getAct());
}

void PopUpServiceStub::sendScreenIDGetUpdate(const ::std::string& screenID, act_t act) {
    ::asf::dbus::DBusVariant variant;
    ScreenIDGet payload(screenID);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "ScreenIDGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void PopUpServiceStub::setScreenID(const ::std::string& screenID) {
    if(screenID!=_screenIDProperty.getScreenID()) {
        _screenIDProperty.setScreenID(screenID);
        sendScreenIDUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::string& PopUpServiceStub::getScreenID() const {
    return _screenIDProperty.getScreenID();
}

::std::string& PopUpServiceStub::getScreenIDMutable() {
    return _screenIDProperty.getScreenIDMutable();
}

void PopUpServiceStub::sendSdsStatusUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        SdsStatusUpdate payload(_sdsStatusProperty);

        LOG_INFO ("-> send%s", "SdsStatusUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("sdsStatus", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("sds_gui_fi.PopUpService", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "SdsStatusUpdate");
    }
}

void PopUpServiceStub::onSdsStatusGet(const ::boost::shared_ptr< SdsStatusGet >& sdsStatus) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "SdsStatusGet", sdsStatus->getAct());
    sendSdsStatusGetUpdate(_sdsStatusProperty.getSdsStatus(), sdsStatus->getAct());
}

void PopUpServiceStub::sendSdsStatusGetUpdate(SpeechInputState sdsStatus, act_t act) {
    ::asf::dbus::DBusVariant variant;
    SdsStatusGet payload(sdsStatus);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "SdsStatusGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void PopUpServiceStub::setSdsStatus(SpeechInputState sdsStatus) {
    if(sdsStatus!=_sdsStatusProperty.getSdsStatus()) {
        _sdsStatusProperty.setSdsStatus(sdsStatus);
        sendSdsStatusUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

SpeechInputState PopUpServiceStub::getSdsStatus() const {
    return _sdsStatusProperty.getSdsStatus();
}

void PopUpServiceStub::sendMicrophoneLevelUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        MicrophoneLevelUpdate payload(_microphoneLevelProperty);

        LOG_INFO ("-> send%s", "MicrophoneLevelUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("microphoneLevel", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("sds_gui_fi.PopUpService", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "MicrophoneLevelUpdate");
    }
}

void PopUpServiceStub::onMicrophoneLevelGet(const ::boost::shared_ptr< MicrophoneLevelGet >& microphoneLevel) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "MicrophoneLevelGet", microphoneLevel->getAct());
    sendMicrophoneLevelGetUpdate(_microphoneLevelProperty.getMicrophoneLevel(), microphoneLevel->getAct());
}

void PopUpServiceStub::sendMicrophoneLevelGetUpdate(uint32 microphoneLevel, act_t act) {
    ::asf::dbus::DBusVariant variant;
    MicrophoneLevelGet payload(microphoneLevel);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "MicrophoneLevelGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void PopUpServiceStub::setMicrophoneLevel(uint32 microphoneLevel) {
    if(microphoneLevel!=_microphoneLevelProperty.getMicrophoneLevel()) {
        _microphoneLevelProperty.setMicrophoneLevel(microphoneLevel);
        sendMicrophoneLevelUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint32 PopUpServiceStub::getMicrophoneLevel() const {
    return _microphoneLevelProperty.getMicrophoneLevel();
}

void PopUpServiceStub::onGetAll(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) const {

    //property 'screenID'
    {
        ::asf::dbus::DBusVariant variant;
        ScreenIDGet payload(_screenIDProperty.getScreenID());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("screenID", variant));
    }

    //property 'sdsStatus'
    {
        ::asf::dbus::DBusVariant variant;
        SdsStatusGet payload(_sdsStatusProperty.getSdsStatus());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("sdsStatus", variant));
    }

    //property 'microphoneLevel'
    {
        ::asf::dbus::DBusVariant variant;
        MicrophoneLevelGet payload(_microphoneLevelProperty.getMicrophoneLevel());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("microphoneLevel", variant));
    }
}

} // namespace PopUpService
} // namespace sds_gui_fi
