/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusTypesJson.h"
#include "boost/shared_ptr.hpp"
#include "sds_gui_fi/PopUpService.h"
#include "sds_gui_fi/PopUpServiceConst.h"
#include "sds_gui_fi/PopUpServiceDBus.h"
#include "sds_gui_fi/PopUpServiceJson.h"
#include "sds_gui_fi/PopUpServiceProxy.h"
#include <string>

#include "asf/dbus/DBusDaemonProxy.h"
#include "asf/dbus/DBusPropertiesProxyWrapper.h"
#include "asf/dbus/DBusProxyDelegate.h"
#include "asf/dbus/DBusMessage.h"

namespace sds_gui_fi {
namespace PopUpService {

DEFINE_CLASS_LOGGER("/sds_gui_fi/sds_gui_fi/PopUpService", PopUpServiceProxy);

class PopUpServiceProxyCallback : public ::asf::dbus::DBusProxyCallback {
public:

    PopUpServiceProxyCallback(uint16 functionId, void* callback) :
        ::asf::dbus::DBusProxyCallback (functionId, callback)
    {}

    bool processMessage (::asf::dbus::DBusMessage &message) {
        const ::boost::shared_ptr< PopUpServiceProxy >& proxyShared = ::boost::static_pointer_cast< PopUpServiceProxy >(message.getDBusProxyShared()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        switch (_functionId) {
            case ID_PopupRequestClose:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), PopupRequestCloseSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "PopupRequestClose", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<PopupRequestCloseSignal> payload = ::boost::static_pointer_cast<PopupRequestCloseSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((PopupRequestCloseCallbackIF*) _callback)->onPopupRequestCloseSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_PopupRequest:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), PopupRequestSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "PopupRequest", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<PopupRequestSignal> payload = ::boost::static_pointer_cast<PopupRequestSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((PopupRequestCallbackIF*) _callback)->onPopupRequestSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_screenID:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ScreenIDError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "ScreenID", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ScreenIDError> payload = ::boost::static_pointer_cast<ScreenIDError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((ScreenIDCallbackIF*) _callback)->onScreenIDError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ScreenIDUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "ScreenID", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ScreenIDUpdate> payload = ::boost::static_pointer_cast<ScreenIDUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((ScreenIDCallbackIF*) _callback)->onScreenIDUpdate(proxyShared, payload);
                        proxyShared->_screenID = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_sdsStatus:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SdsStatusError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "SdsStatus", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SdsStatusError> payload = ::boost::static_pointer_cast<SdsStatusError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((SdsStatusCallbackIF*) _callback)->onSdsStatusError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SdsStatusUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "SdsStatus", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SdsStatusUpdate> payload = ::boost::static_pointer_cast<SdsStatusUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((SdsStatusCallbackIF*) _callback)->onSdsStatusUpdate(proxyShared, payload);
                        proxyShared->_sdsStatus = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_microphoneLevel:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), MicrophoneLevelError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "MicrophoneLevel", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<MicrophoneLevelError> payload = ::boost::static_pointer_cast<MicrophoneLevelError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((MicrophoneLevelCallbackIF*) _callback)->onMicrophoneLevelError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), MicrophoneLevelUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "MicrophoneLevel", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<MicrophoneLevelUpdate> payload = ::boost::static_pointer_cast<MicrophoneLevelUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((MicrophoneLevelCallbackIF*) _callback)->onMicrophoneLevelUpdate(proxyShared, payload);
                        proxyShared->_microphoneLevel = *payload.get();
                        return true;
                    }
                }
                break;
            default:
            LOG_FATAL ("Received an invalid functionId, proxy=%p", message.getProxy());
        }
        LOG_FATAL("Receveid an invalid message, proxy=%p", message.getProxy());
        return false;
    }

    bool onServiceUnavailable (const ::boost::shared_ptr< ::asf::core::Proxy >& baseProxy) {
        switch (_functionId) {
            case ID_PopupRequestClose: {
                ::boost::shared_ptr< PopupRequestCloseError > payload = ::boost::shared_ptr< PopupRequestCloseError >
                (new PopupRequestCloseError(DBUS_ERROR_NO_SERVER, "The DBus service PopUpService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "PopupRequestClose", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<PopUpServiceProxy> proxyShared = ::boost::static_pointer_cast<PopUpServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((PopupRequestCloseCallbackIF*) _callback)->onPopupRequestCloseError (proxyShared,payload);
                return true;
            }
            break;
            case ID_PopupRequest: {
                ::boost::shared_ptr< PopupRequestError > payload = ::boost::shared_ptr< PopupRequestError >
                (new PopupRequestError(DBUS_ERROR_NO_SERVER, "The DBus service PopUpService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "PopupRequest", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<PopUpServiceProxy> proxyShared = ::boost::static_pointer_cast<PopUpServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((PopupRequestCallbackIF*) _callback)->onPopupRequestError (proxyShared,payload);
                return true;
            }
            break;
            case ID_screenID: {
                ::boost::shared_ptr< ScreenIDError > payload = ::boost::shared_ptr< ScreenIDError >
                (new ScreenIDError(DBUS_ERROR_NO_SERVER, "The DBus service PopUpService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ScreenID", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<PopUpServiceProxy> proxyShared = ::boost::static_pointer_cast<PopUpServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ScreenIDCallbackIF*) _callback)->onScreenIDError (proxyShared,payload);
                return true;
            }
            break;
            case ID_sdsStatus: {
                ::boost::shared_ptr< SdsStatusError > payload = ::boost::shared_ptr< SdsStatusError >
                (new SdsStatusError(DBUS_ERROR_NO_SERVER, "The DBus service PopUpService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SdsStatus", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<PopUpServiceProxy> proxyShared = ::boost::static_pointer_cast<PopUpServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SdsStatusCallbackIF*) _callback)->onSdsStatusError (proxyShared,payload);
                return true;
            }
            break;
            case ID_microphoneLevel: {
                ::boost::shared_ptr< MicrophoneLevelError > payload = ::boost::shared_ptr< MicrophoneLevelError >
                (new MicrophoneLevelError(DBUS_ERROR_NO_SERVER, "The DBus service PopUpService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "MicrophoneLevel", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<PopUpServiceProxy> proxyShared = ::boost::static_pointer_cast<PopUpServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((MicrophoneLevelCallbackIF*) _callback)->onMicrophoneLevelError (proxyShared,payload);
                return true;
            }
            break;
            default:
                break;
        }
        return false;
    }

    static ::asf::core::Logger&_logger;
};

::asf::core::Logger& PopUpServiceProxyCallback::_logger (PopUpServiceProxy::_logger);

PopUpServiceProxy::PopUpServiceProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable) :
    ::asf::dbus::DBusProxy(portName, "sds_gui_fi.PopUpService", serviceAvailable, _logger) {
}

PopUpServiceProxy::~PopUpServiceProxy()
{
    sendDeregisterAll();
    ::asf::dbus::DBusConnector::getConnector(getConnectorOptions())->deregisterProxyDelegate(_dbusProxyDelegate);
}

// static
::boost::shared_ptr< PopUpServiceProxy > PopUpServiceProxy::createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable) {
    ::boost::shared_ptr< Proxy > proxyReuse = ::asf::dbus::DBusConnector::getProxy(portName, serviceAvailable);
    if(proxyReuse) {
        LOG_INFO_STATIC ("createProxy, reuse existing proxy");
        return ::boost::static_pointer_cast<PopUpServiceProxy>(proxyReuse); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
    }
    LOG_INFO_STATIC ("createProxy, create new proxy");
    ::boost::shared_ptr< PopUpServiceProxy > proxyNew(new PopUpServiceProxy(portName, serviceAvailable));
    ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew);
    proxyNew->createHelperProxies(true);
    return proxyNew;
}

act_t PopUpServiceProxy::addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const {
    PopUpServiceProxyCallback* callback = new PopUpServiceProxyCallback(methodId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->addMethodCallback (serial, memberName, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

act_t PopUpServiceProxy::addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const {
    PopUpServiceProxyCallback* callback = new PopUpServiceProxyCallback(signalId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->registerSignalCallback (signal, reinterpret_cast<act_t>(callback), ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void PopUpServiceProxy::clearAllProperties ()
{
    _screenID = ::asf::core::nullable< ScreenIDUpdate >();
    _sdsStatus = ::asf::core::nullable< SdsStatusUpdate >();
    _microphoneLevel = ::asf::core::nullable< MicrophoneLevelUpdate >();
}

void PopUpServiceProxy::sendDeregisterAll () const
{
    sendScreenIDDeregisterAll();
    sendSdsStatusDeregisterAll();
    sendMicrophoneLevelDeregisterAll();
    sendPopupRequestCloseDeregisterAll();
    sendPopupRequestDeregisterAll();
}

act_t PopUpServiceProxy::sendPopupRequestCloseRegister(PopupRequestCloseCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "PopupRequestClose");
    act_t act = addSignalCallback(ID_PopupRequestClose, "PopupRequestClose", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "PopupRequestClose", &cb, act);
    return act;
}

bool PopUpServiceProxy::sendPopupRequestCloseDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("PopupRequestClose", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "PopupRequestClose", act, static_cast<int>(rv));
    return rv;
}

void PopUpServiceProxy::sendPopupRequestCloseDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "PopupRequestClose");
    _dbusProxyDelegate->deregisterSignalCallback("PopupRequestClose", 0, _dbusDaemonProxy.get(), false);
}

act_t PopUpServiceProxy::sendPopupRequestRegister(PopupRequestCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "PopupRequest");
    act_t act = addSignalCallback(ID_PopupRequest, "PopupRequest", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "PopupRequest", &cb, act);
    return act;
}

bool PopUpServiceProxy::sendPopupRequestDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("PopupRequest", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "PopupRequest", act, static_cast<int>(rv));
    return rv;
}

void PopUpServiceProxy::sendPopupRequestDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "PopupRequest");
    _dbusProxyDelegate->deregisterSignalCallback("PopupRequest", 0, _dbusDaemonProxy.get(), false);
}

act_t PopUpServiceProxy::sendScreenIDRegister(ScreenIDCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_screenID, "screenID", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "ScreenID", &cb, act);
    return act;
}

bool PopUpServiceProxy::sendScreenIDDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("screenID", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "ScreenID", act, static_cast<int>(rv));
    return rv;
}

act_t PopUpServiceProxy::sendScreenIDGet(ScreenIDCallbackIF& cb) {
    PopUpServiceProxyCallback* callback = new PopUpServiceProxyCallback(ID_screenID, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "ScreenID", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("screenID", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::string& PopUpServiceProxy::getScreenID() const {
    return _screenID.get().getScreenID();
}

bool PopUpServiceProxy::hasScreenID() const {
    return _screenID.hasValue();
}

void PopUpServiceProxy::sendScreenIDDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "ScreenID");
    _dbusProxyDelegate->deregisterSignalCallback("screenID", 0, _dbusDaemonProxy.get(), true);
}

act_t PopUpServiceProxy::sendSdsStatusRegister(SdsStatusCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_sdsStatus, "sdsStatus", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "SdsStatus", &cb, act);
    return act;
}

bool PopUpServiceProxy::sendSdsStatusDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("sdsStatus", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "SdsStatus", act, static_cast<int>(rv));
    return rv;
}

act_t PopUpServiceProxy::sendSdsStatusGet(SdsStatusCallbackIF& cb) {
    PopUpServiceProxyCallback* callback = new PopUpServiceProxyCallback(ID_sdsStatus, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "SdsStatus", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("sdsStatus", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


SpeechInputState PopUpServiceProxy::getSdsStatus() const {
    return _sdsStatus.get().getSdsStatus();
}

bool PopUpServiceProxy::hasSdsStatus() const {
    return _sdsStatus.hasValue();
}

void PopUpServiceProxy::sendSdsStatusDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "SdsStatus");
    _dbusProxyDelegate->deregisterSignalCallback("sdsStatus", 0, _dbusDaemonProxy.get(), true);
}

act_t PopUpServiceProxy::sendMicrophoneLevelRegister(MicrophoneLevelCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_microphoneLevel, "microphoneLevel", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "MicrophoneLevel", &cb, act);
    return act;
}

bool PopUpServiceProxy::sendMicrophoneLevelDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("microphoneLevel", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "MicrophoneLevel", act, static_cast<int>(rv));
    return rv;
}

act_t PopUpServiceProxy::sendMicrophoneLevelGet(MicrophoneLevelCallbackIF& cb) {
    PopUpServiceProxyCallback* callback = new PopUpServiceProxyCallback(ID_microphoneLevel, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "MicrophoneLevel", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("microphoneLevel", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


uint32 PopUpServiceProxy::getMicrophoneLevel() const {
    return _microphoneLevel.get().getMicrophoneLevel();
}

bool PopUpServiceProxy::hasMicrophoneLevel() const {
    return _microphoneLevel.hasValue();
}

void PopUpServiceProxy::sendMicrophoneLevelDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "MicrophoneLevel");
    _dbusProxyDelegate->deregisterSignalCallback("microphoneLevel", 0, _dbusDaemonProxy.get(), true);
}

} // namespace PopUpService
} // namespace sds_gui_fi
