/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef SDS_DAB_FI_SDSDABSERVICESTUB_H
#define SDS_DAB_FI_SDSDABSERVICESTUB_H

#include "asf/core/Logger.h"
#include "asf/dbus/DBusStub.h"
#include "asf/dbus/DBusVariant.h"
#include "boost/shared_ptr.hpp"
#include "sds_dab_fi/SdsDabService.h"

namespace sds_dab_fi {
namespace SdsDabService {

class SdsDabServiceStubDelegate;

class SdsDabServiceStub : public ::asf::dbus::DBusStub
{
public:

    /**
     * Create an instance of the SdsDabServiceStub
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     */
    SdsDabServiceStub (const std::string& portName);

    /**
     * Create an instance of the SdsDabServiceStub
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     * @param objectPath the dbus object path, see
     * http://dbus.freedesktop.org/doc/dbus-specification.html#message-protocol-marshaling-object-path
     */
    SdsDabServiceStub (const std::string& portName, const std::string& objectPath);

    virtual ~SdsDabServiceStub();

    // signal 'ProcessingFinished'

    /**
     * Raise the signal 'ProcessingFinished' and send an update message to
     * registered clients.
     *
     * <b>Documentation of 'ProcessingFinished'</b>:
     *
     * If the meaning of "ProcessingFinished" isn't clear, then there should be a description here.
     */
    void sendProcessingFinishedSignal();

    // signal 'ProcessingInterrupted'

    /**
     * Raise the signal 'ProcessingInterrupted' and send an update message to
     * registered clients.
     *
     * <b>Documentation of 'ProcessingInterrupted'</b>:
     *
     * If the meaning of "ProcessingInterrupted" isn't clear, then there should be a description here.
     */
    void sendProcessingInterruptedSignal();

    // method 'storeDabChannelNames'

    /**
     * The method onStoreDabChannelNames() is called by ASF when a client
     * invokes the method 'storeDabChannelNames'. A subclass has to implement
     * this method and send back a response to the client either with the
     * sendStoreDabChannelNames() or sendStoreDabChannelNamesError() method.
     * Do not invoke this method on your own.
     *
     * <b>Documentation of 'storeDabChannelNames'</b>:
     *
     * If the meaning of "storeDabChannelNames" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onStoreDabChannelNamesRequest (const ::boost::shared_ptr< StoreDabChannelNamesRequest >& request) = 0;

    /**
     * The method sendStoreDabChannelNamesResponse() sends a response of a
     * previous method invocation of 'storeDabChannelNames' back to the
     * client.
     *
     * <b>Documentation of 'storeDabChannelNames'</b>:
     *
     * If the meaning of "storeDabChannelNames" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onStoreDabChannelNames(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendStoreDabChannelNamesResponse (act_t act = 0);

    /**
     * The method sendStoreDabChannelNamesError() sends an error response of a
     * previous method invocation of 'storeDabChannelNames' back to the
     * client.
     *
     * <b>Documentation of 'storeDabChannelNames'</b>:
     *
     * If the meaning of "storeDabChannelNames" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onStoreDabChannelNames(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendStoreDabChannelNamesError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

private:
    void onGetAll(std::map<std::basic_string<char>, ::asf::dbus::DBusVariant>&) const;

    friend class SdsDabServiceStubDelegate;

    DECLARE_CLASS_LOGGER();
};

} // namespace SdsDabService
} // namespace sds_dab_fi

#endif // SDS_DAB_FI_SDSDABSERVICESTUB_H
