/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/dbus/DBusStubDelegate.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "sds_dab_fi/SdsDabService.h"
#include "sds_dab_fi/SdsDabServiceDBus.h"
#include "sds_dab_fi/SdsDabServiceJson.h"
#include "sds_dab_fi/SdsDabServiceStub.h"

#include "asf/dbus/DBusMessage.h"

namespace sds_dab_fi {
namespace SdsDabService {

DEFINE_CLASS_LOGGER("/sds_dab_fi/sds_dab_fi/SdsDabService", SdsDabServiceStub);

static ::asf::dbus::DBusUtils::stringEntry methodsTable[] = {
    { 20, "storeDabChannelNames", 0 },
};


class SdsDabServiceStubDelegate : public ::asf::dbus::DBusStubDelegate {
public:

    SdsDabServiceStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger) :
        ::asf::dbus::DBusStubDelegate( stub, logger),
        _logger(logger)
    {}

    SdsDabServiceStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger, const std::string& objectPath) :
        ::asf::dbus::DBusStubDelegate( stub, logger, objectPath),
        _logger(logger) {}

    SdsDabServiceStubDelegate(::asf::dbus::DBusStub* stub,
                               ::asf::core::Logger& logger,
                               ::asf::dbus::DBusConnector& connector,
                               const std::string& objectPath)
        : ::asf::dbus::DBusStubDelegate(
              stub, logger, connector, objectPath, "sds_dab_fi.SdsDabService"),
          _logger(logger) {}

    virtual ~SdsDabServiceStubDelegate() {}

    virtual void process(::asf::core::ServiceMessage& msg);

    const char* introspect() const;

    virtual void getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties);

    virtual void setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act);

    virtual void getProperty(const ::std::string& property, const act_t& act);

private:

    ::asf::core::Logger& _logger;

};

void SdsDabServiceStubDelegate::process(::asf::core::ServiceMessage& msg) {
    ::asf::dbus::DBusMessage& message = static_cast< ::asf::dbus::DBusMessage& >(msg);
    LOG_DEBUG_STUB("Entering process(memberName='%s')", message.getMemberName().c_str());

    unsigned int methodIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (message.getMemberName().c_str(), message.getMemberName().length(), methodsTable, 1, methodIndex)) {
        switch (methodIndex) {
        case 0: {

            // method 'storeDabChannelNames'

            LOG_DEBUG_STUB("process method '%s'", "storeDabChannelNames");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), StoreDabChannelNamesRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "StoreDabChannelNames", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< StoreDabChannelNamesRequest > payload = ::boost::static_pointer_cast<StoreDabChannelNamesRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<SdsDabServiceStub*>(getStub())->onStoreDabChannelNamesRequest(payload);
            return;
        }
        default:
            break;
        }
    }
    LOG_FATAL_STUB("can't process message %s", message.getMemberName().c_str());
}

const char* SdsDabServiceStubDelegate::introspect() const {
    return     "<interface name=\"sds_dab_fi.SdsDabService\">\n"
            "    <method name=\"storeDabChannelNames\">\n"
            "      <arg direction=\"in\" name=\"channelList\" type=\"a(uyqss)\">\n"
            "        <doc>\n"
            "          <line>channelList = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <signal name=\"ProcessingFinished\"/>\n"
            "    <signal name=\"ProcessingInterrupted\"/>\n"
            "</interface>\n";
}

void SdsDabServiceStubDelegate::getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) {
    (static_cast<SdsDabServiceStub*>(getStub()))->onGetAll (properties);
}

void SdsDabServiceStubDelegate::setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act) {
    ((void)value);  // to get rid of unused variable warning
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendSetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

void SdsDabServiceStubDelegate::getProperty(const ::std::string& property, const act_t& act) {
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendGetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

SdsDabServiceStub::SdsDabServiceStub (const std::string& portName) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new SdsDabServiceStubDelegate(this, _logger);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

SdsDabServiceStub::SdsDabServiceStub (const std::string& portName, const std::string& objectPath) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new SdsDabServiceStubDelegate(this, _logger, objectPath);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

SdsDabServiceStub::~SdsDabServiceStub() {
    delete _stubDelegate;
}

void SdsDabServiceStub::sendProcessingFinishedSignal() {
    if (_stubDelegate->isConnected()) {
        ProcessingFinishedSignal* payload = new ProcessingFinishedSignal;
        DBUS_MESSAGE_SIGNAL(dbusMessage, "ProcessingFinished", ProcessingFinishedSignal, payload)
        LOG_INFO ("-> send%sSignal", "ProcessingFinished");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "ProcessingFinished");
    }
}

void SdsDabServiceStub::sendProcessingInterruptedSignal() {
    if (_stubDelegate->isConnected()) {
        ProcessingInterruptedSignal* payload = new ProcessingInterruptedSignal;
        DBUS_MESSAGE_SIGNAL(dbusMessage, "ProcessingInterrupted", ProcessingInterruptedSignal, payload)
        LOG_INFO ("-> send%sSignal", "ProcessingInterrupted");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "ProcessingInterrupted");
    }
}

void  SdsDabServiceStub::sendStoreDabChannelNamesResponse (act_t act) {
    StoreDabChannelNamesResponse* payload = new StoreDabChannelNamesResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "storeDabChannelNames", StoreDabChannelNamesResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "StoreDabChannelNames", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  SdsDabServiceStub::sendStoreDabChannelNamesError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    StoreDabChannelNamesError* payload = new StoreDabChannelNamesError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "storeDabChannelNames", StoreDabChannelNamesError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "StoreDabChannelNames", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void SdsDabServiceStub::onGetAll(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) const {
    ((void)properties);  // to get rid of unused variable warning
}

} // namespace SdsDabService
} // namespace sds_dab_fi
