/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef SDS_DAB_FI_SDSDABSERVICEPROXY_H
#define SDS_DAB_FI_SDSDABSERVICEPROXY_H

#include "asf/core/Logger.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusProxy.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "com/bosch/cm/asf/lang/dbus/Connectors.h"
#include "sds_dab_fi/SdsDabService.h"
#include <dbus/dbus.h>
#include <vector>

namespace sds_dab_fi {
namespace SdsDabService {

class SdsDabServiceProxy;

class ProcessingFinishedCallbackIF {
public:
    virtual ~ProcessingFinishedCallbackIF() {}

    virtual void onProcessingFinishedError(const ::boost::shared_ptr< SdsDabServiceProxy >& proxy, const ::boost::shared_ptr< ProcessingFinishedError >& error) = 0;

    virtual void onProcessingFinishedSignal(const ::boost::shared_ptr< SdsDabServiceProxy >& proxy, const ::boost::shared_ptr< ProcessingFinishedSignal >& signal) = 0;
};

class ProcessingInterruptedCallbackIF {
public:
    virtual ~ProcessingInterruptedCallbackIF() {}

    virtual void onProcessingInterruptedError(const ::boost::shared_ptr< SdsDabServiceProxy >& proxy, const ::boost::shared_ptr< ProcessingInterruptedError >& error) = 0;

    virtual void onProcessingInterruptedSignal(const ::boost::shared_ptr< SdsDabServiceProxy >& proxy, const ::boost::shared_ptr< ProcessingInterruptedSignal >& signal) = 0;
};

class StoreDabChannelNamesCallbackIF {
public:
    virtual ~StoreDabChannelNamesCallbackIF() {}

    virtual void onStoreDabChannelNamesError(const ::boost::shared_ptr< SdsDabServiceProxy >& proxy, const ::boost::shared_ptr< StoreDabChannelNamesError >& error) = 0;

    virtual void onStoreDabChannelNamesResponse(const ::boost::shared_ptr< SdsDabServiceProxy >& proxy, const ::boost::shared_ptr< StoreDabChannelNamesResponse >& response) = 0;
};


/**
 * SdsDabServiceProxy is the client side representation of the D-Bus
 * service interface 'sds_dab_fi.SdsDabService' (specified in file
 * sds_dab_fi_.xml).
 *
 * If the meaning of "sds_dab_fi.SdsDabService" isn't clear, then there should be a description here.
 */
class SdsDabServiceProxy : public ::asf::dbus::DBusProxy
{
public:
    /**
     * Create a new instance of SdsDabServiceProxy.
     */
    static ::boost::shared_ptr< SdsDabServiceProxy > createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    /**
     * Create a new instance of SdsDabServiceProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @deprecated use the createProxy() method with the parameter
     * ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector instead.
     */
    static ::boost::shared_ptr< SdsDabServiceProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        ::DBusBusType busType,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector connectorOptions;
        connectorOptions.setBusType(::asf::dbus::DBusUtils::toOptions(busType).getBusType());
        return createProxy(portName, busName, objectPath, connectorOptions, serviceAvailable);
    }

    /**
     * Create a new instance of SdsDabServiceProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     */
    static ::boost::shared_ptr< SdsDabServiceProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        const ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector& connectorOptions,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        LOG_INFO_STATIC ("createProxy, create new proxy");
        ::boost::shared_ptr< SdsDabServiceProxy > proxyNew(new SdsDabServiceProxy(portName, serviceAvailable));
        ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew, busName, objectPath, connectorOptions);
        proxyNew->createHelperProxies(false);
        return proxyNew;
    }

    virtual ~SdsDabServiceProxy ();


    // Signal 'ProcessingFinished'

    /**
     * Notify on the signal 'ProcessingFinished'. This method registers for
     * signal changes by D-Bus service.
     *
     * <b>Documentation of 'ProcessingFinished'</b>:
     *
     * If the meaning of "ProcessingFinished" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendProcessingFinishedRegister(ProcessingFinishedCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'ProcessingFinished'. This method
     * deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'ProcessingFinished'</b>:
     *
     * If the meaning of "ProcessingFinished" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendProcessingFinishedRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendProcessingFinishedDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal 'ProcessingFinished'.
     */
    void sendProcessingFinishedDeregisterAll () const;

    // Signal 'ProcessingInterrupted'

    /**
     * Notify on the signal 'ProcessingInterrupted'. This method registers for
     * signal changes by D-Bus service.
     *
     * <b>Documentation of 'ProcessingInterrupted'</b>:
     *
     * If the meaning of "ProcessingInterrupted" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendProcessingInterruptedRegister(ProcessingInterruptedCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'ProcessingInterrupted'. This method
     * deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'ProcessingInterrupted'</b>:
     *
     * If the meaning of "ProcessingInterrupted" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendProcessingInterruptedRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendProcessingInterruptedDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal 'ProcessingInterrupted'.
     */
    void sendProcessingInterruptedDeregisterAll () const;



    // Method 'storeDabChannelNames'

    /**
     * Call the method 'storeDabChannelNames'. This method sends a message to
     * the D-Bus server.
     *
     * <b>Documentation of 'storeDabChannelNames'</b>:
     *
     * If the meaning of "storeDabChannelNames" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param channelList If the meaning of "channelList" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendStoreDabChannelNamesRequest(StoreDabChannelNamesCallbackIF& cb, const ::std::vector< DABChannelItem >& channelList) const;

    /**
     * Release all property and signal notifications.
     */
    void sendDeregisterAll () const;

private:

    SdsDabServiceProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    act_t addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const;

    act_t addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const;


    DECLARE_CLASS_LOGGER();

    friend class SdsDabServiceProxyCallback;
};

} // namespace SdsDabService
} // namespace sds_dab_fi

#endif // SDS_DAB_FI_SDSDABSERVICEPROXY_H
