/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "sds_dab_fi/SdsDabService.h"
#include "sds_dab_fi/SdsDabServiceDBus.h"
#include "sds_dab_fi/SdsDabServiceJson.h"
#include "sds_dab_fi/SdsDabServiceProxy.h"
#include <vector>

#include "asf/dbus/DBusDaemonProxy.h"
#include "asf/dbus/DBusPropertiesProxyWrapper.h"
#include "asf/dbus/DBusProxyDelegate.h"
#include "asf/dbus/DBusMessage.h"

namespace sds_dab_fi {
namespace SdsDabService {

DEFINE_CLASS_LOGGER("/sds_dab_fi/sds_dab_fi/SdsDabService", SdsDabServiceProxy);

class SdsDabServiceProxyCallback : public ::asf::dbus::DBusProxyCallback {
public:

    SdsDabServiceProxyCallback(uint16 functionId, void* callback) :
        ::asf::dbus::DBusProxyCallback (functionId, callback)
    {}

    bool processMessage (::asf::dbus::DBusMessage &message) {
        const ::boost::shared_ptr< SdsDabServiceProxy >& proxyShared = ::boost::static_pointer_cast< SdsDabServiceProxy >(message.getDBusProxyShared()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        switch (_functionId) {
            case ID_ProcessingFinished:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ProcessingFinishedSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "ProcessingFinished", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<ProcessingFinishedSignal> payload = ::boost::static_pointer_cast<ProcessingFinishedSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((ProcessingFinishedCallbackIF*) _callback)->onProcessingFinishedSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_ProcessingInterrupted:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ProcessingInterruptedSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "ProcessingInterrupted", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<ProcessingInterruptedSignal> payload = ::boost::static_pointer_cast<ProcessingInterruptedSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((ProcessingInterruptedCallbackIF*) _callback)->onProcessingInterruptedSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_storeDabChannelNames:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), StoreDabChannelNamesError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "StoreDabChannelNames", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<StoreDabChannelNamesError> payload = ::boost::static_pointer_cast<StoreDabChannelNamesError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((StoreDabChannelNamesCallbackIF*) _callback)->onStoreDabChannelNamesError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), StoreDabChannelNamesResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "StoreDabChannelNames", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<StoreDabChannelNamesResponse> payload = ::boost::static_pointer_cast<StoreDabChannelNamesResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((StoreDabChannelNamesCallbackIF*) _callback)->onStoreDabChannelNamesResponse (proxyShared, payload);
                        return true;
                    }
                }
            default:
            LOG_FATAL ("Received an invalid functionId, proxy=%p", message.getProxy());
        }
        LOG_FATAL("Receveid an invalid message, proxy=%p", message.getProxy());
        return false;
    }

    bool onServiceUnavailable (const ::boost::shared_ptr< ::asf::core::Proxy >& baseProxy) {
        switch (_functionId) {
            case ID_ProcessingFinished: {
                ::boost::shared_ptr< ProcessingFinishedError > payload = ::boost::shared_ptr< ProcessingFinishedError >
                (new ProcessingFinishedError(DBUS_ERROR_NO_SERVER, "The DBus service SdsDabService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ProcessingFinished", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<SdsDabServiceProxy> proxyShared = ::boost::static_pointer_cast<SdsDabServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ProcessingFinishedCallbackIF*) _callback)->onProcessingFinishedError (proxyShared,payload);
                return true;
            }
            break;
            case ID_ProcessingInterrupted: {
                ::boost::shared_ptr< ProcessingInterruptedError > payload = ::boost::shared_ptr< ProcessingInterruptedError >
                (new ProcessingInterruptedError(DBUS_ERROR_NO_SERVER, "The DBus service SdsDabService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ProcessingInterrupted", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<SdsDabServiceProxy> proxyShared = ::boost::static_pointer_cast<SdsDabServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ProcessingInterruptedCallbackIF*) _callback)->onProcessingInterruptedError (proxyShared,payload);
                return true;
            }
            break;
            case ID_storeDabChannelNames: {
                ::boost::shared_ptr< StoreDabChannelNamesError > payload = ::boost::shared_ptr< StoreDabChannelNamesError >
                (new StoreDabChannelNamesError(DBUS_ERROR_NO_SERVER, "The DBus service SdsDabService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "StoreDabChannelNames", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<SdsDabServiceProxy> proxyShared = ::boost::static_pointer_cast<SdsDabServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((StoreDabChannelNamesCallbackIF*) _callback)->onStoreDabChannelNamesError (proxyShared,payload);
                return true;
            }
            break;
            default:
                break;
        }
        return false;
    }

    static ::asf::core::Logger&_logger;
};

::asf::core::Logger& SdsDabServiceProxyCallback::_logger (SdsDabServiceProxy::_logger);

SdsDabServiceProxy::SdsDabServiceProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable) :
    ::asf::dbus::DBusProxy(portName, "sds_dab_fi.SdsDabService", serviceAvailable, _logger) {
}

SdsDabServiceProxy::~SdsDabServiceProxy()
{
    sendDeregisterAll();
    ::asf::dbus::DBusConnector::getConnector(getConnectorOptions())->deregisterProxyDelegate(_dbusProxyDelegate);
}

// static
::boost::shared_ptr< SdsDabServiceProxy > SdsDabServiceProxy::createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable) {
    ::boost::shared_ptr< Proxy > proxyReuse = ::asf::dbus::DBusConnector::getProxy(portName, serviceAvailable);
    if(proxyReuse) {
        LOG_INFO_STATIC ("createProxy, reuse existing proxy");
        return ::boost::static_pointer_cast<SdsDabServiceProxy>(proxyReuse); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
    }
    LOG_INFO_STATIC ("createProxy, create new proxy");
    ::boost::shared_ptr< SdsDabServiceProxy > proxyNew(new SdsDabServiceProxy(portName, serviceAvailable));
    ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew);
    proxyNew->createHelperProxies(false);
    return proxyNew;
}

act_t SdsDabServiceProxy::addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const {
    SdsDabServiceProxyCallback* callback = new SdsDabServiceProxyCallback(methodId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->addMethodCallback (serial, memberName, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

act_t SdsDabServiceProxy::addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const {
    SdsDabServiceProxyCallback* callback = new SdsDabServiceProxyCallback(signalId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->registerSignalCallback (signal, reinterpret_cast<act_t>(callback), ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


void SdsDabServiceProxy::sendDeregisterAll () const
{
    sendProcessingFinishedDeregisterAll();
    sendProcessingInterruptedDeregisterAll();
}

act_t SdsDabServiceProxy::sendProcessingFinishedRegister(ProcessingFinishedCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "ProcessingFinished");
    act_t act = addSignalCallback(ID_ProcessingFinished, "ProcessingFinished", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "ProcessingFinished", &cb, act);
    return act;
}

bool SdsDabServiceProxy::sendProcessingFinishedDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("ProcessingFinished", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "ProcessingFinished", act, static_cast<int>(rv));
    return rv;
}

void SdsDabServiceProxy::sendProcessingFinishedDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "ProcessingFinished");
    _dbusProxyDelegate->deregisterSignalCallback("ProcessingFinished", 0, _dbusDaemonProxy.get(), false);
}

act_t SdsDabServiceProxy::sendProcessingInterruptedRegister(ProcessingInterruptedCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "ProcessingInterrupted");
    act_t act = addSignalCallback(ID_ProcessingInterrupted, "ProcessingInterrupted", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "ProcessingInterrupted", &cb, act);
    return act;
}

bool SdsDabServiceProxy::sendProcessingInterruptedDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("ProcessingInterrupted", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "ProcessingInterrupted", act, static_cast<int>(rv));
    return rv;
}

void SdsDabServiceProxy::sendProcessingInterruptedDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "ProcessingInterrupted");
    _dbusProxyDelegate->deregisterSignalCallback("ProcessingInterrupted", 0, _dbusDaemonProxy.get(), false);
}

act_t SdsDabServiceProxy::sendStoreDabChannelNamesRequest(StoreDabChannelNamesCallbackIF& cb, const ::std::vector< DABChannelItem >& channelList) const {
    StoreDabChannelNamesRequest* payload = new StoreDabChannelNamesRequest();
    CHECK_ALLOCATION(payload);
    payload->setChannelList(channelList);
    DBUS_MESSAGE_CALL(dbusMessage, "storeDabChannelNames", StoreDabChannelNamesRequest, payload, true)
    act_t act = addMethodCallback(ID_storeDabChannelNames, dbusMessage.getUniqueSerial(), "storeDabChannelNames", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "StoreDabChannelNames", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

} // namespace SdsDabService
} // namespace sds_dab_fi
