#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef SDS_APP_FI_SDSAPPSERVICE_H
#define SDS_APP_FI_SDSAPPSERVICE_H

#include "asf/core/Logger.h"
#include "asf/core/Payload.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "asf/core/VersionCheck.h"
#include "asf/dbus/DBusTypes.h"
#include <cstddef>
#include <cstring>
#include <string>
#include <vector>

/**
 * If the meaning of "sds_app_fi.SdsAppService" isn't clear, then there should be a description here.
 */

namespace sds_app_fi {
namespace SdsAppService {

// method IDs
static const uint16 ID_storeAppNames = 0;
static const uint16 ID_getAppNamesList = 1;

// signal IDs

// property IDs

ASF_GENERATOR_VERSION_CHECK_DECLARE

// forward declarations
class PhonemeDataList;

class AppDataList;

class AppList;

class StoreAppNamesRequest;

class GetAppNamesListResponse;

// type definitions
/**
 * If the meaning of "storeAppNames" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage StoreAppNamesResponse;

/**
 * If the meaning of "StoreAppNamesError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError StoreAppNamesError;

/**
 * If the meaning of "getAppNamesList" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage GetAppNamesListRequest;

/**
 * If the meaning of "GetAppNamesListError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError GetAppNamesListError;


/**
 * If the meaning of "PhonemeDataList" isn't clear, then there should be a description here.
 */
class PhonemeDataList {
public:

    /**
     * Default constructor
     */
    inline  PhonemeDataList ();

    /**
     * Copy constructor
     */
    inline  PhonemeDataList (const PhonemeDataList &rhs);

    /**
     * All fields constructor
     */
    inline  PhonemeDataList (const ::std::string& phoneme_, const ::std::string& isoLangCode_);

    /**
     * Destructor
     */
    inline  ~PhonemeDataList();

    /**
     * Assignment operator
     */
    inline PhonemeDataList& operator = (const PhonemeDataList& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PhonemeDataList& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PhonemeDataList& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PhonemeDataList& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PhonemeDataList& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "phoneme"

    static const int kPhoneme = 0;

    /**
     * Clears the field "phoneme".
     *
     * The field will be set to its default value. The hasPhoneme()
     * method will return false.
     */
    inline void clearPhoneme();

    /**
     * Checks whether the field "phoneme" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPhoneme()). Otherwise it will return false.
     */
    inline bool hasPhoneme () const;

    /**
     * Returns the value of the member "phoneme".
     *
     * If the meaning of "phoneme" isn't clear, then there should be a description here.
     *
     * @return The value of the field "phoneme"
     */
    inline const ::std::string& getPhoneme () const;

    /**
     * Retrieves the value of the field "phoneme" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "phoneme".
     */
    inline ::std::string& getPhonemeMutable ();

    /**
     * Sets the value of the member "phoneme".
     *
     * If the meaning of "phoneme" isn't clear, then there should be a description here.
     *
     * @param phoneme The value which will be set
     */
    inline void setPhoneme (const ::std::string& phoneme_);

    /**
     * Sets the value of the member "phoneme".
     *
     * If the meaning of "phoneme" isn't clear, then there should be a description here.
     *
     * @param phoneme The value which will be set
     */
    inline void setPhoneme (const char* phoneme_);

    /**
     * Sets the value of the member "phoneme".
     *
     * If the meaning of "phoneme" isn't clear, then there should be a description here.
     *
     * @param phoneme The value which will be set
     */
    inline void setPhoneme (const char* value, size_t size);

    // API of field "isoLangCode"

    static const int kIsoLangCode = 1;

    /**
     * Clears the field "isoLangCode".
     *
     * The field will be set to its default value. The hasIsoLangCode()
     * method will return false.
     */
    inline void clearIsoLangCode();

    /**
     * Checks whether the field "isoLangCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setIsoLangCode()). Otherwise it will return false.
     */
    inline bool hasIsoLangCode () const;

    /**
     * Returns the value of the member "isoLangCode".
     *
     * If the meaning of "isoLangCode" isn't clear, then there should be a description here.
     *
     * @return The value of the field "isoLangCode"
     */
    inline const ::std::string& getIsoLangCode () const;

    /**
     * Retrieves the value of the field "isoLangCode" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "isoLangCode".
     */
    inline ::std::string& getIsoLangCodeMutable ();

    /**
     * Sets the value of the member "isoLangCode".
     *
     * If the meaning of "isoLangCode" isn't clear, then there should be a description here.
     *
     * @param isoLangCode The value which will be set
     */
    inline void setIsoLangCode (const ::std::string& isoLangCode_);

    /**
     * Sets the value of the member "isoLangCode".
     *
     * If the meaning of "isoLangCode" isn't clear, then there should be a description here.
     *
     * @param isoLangCode The value which will be set
     */
    inline void setIsoLangCode (const char* isoLangCode_);

    /**
     * Sets the value of the member "isoLangCode".
     *
     * If the meaning of "isoLangCode" isn't clear, then there should be a description here.
     *
     * @param isoLangCode The value which will be set
     */
    inline void setIsoLangCode (const char* value, size_t size);

    static const PhonemeDataList &getDefaultInstance();

private:

    inline void set_has_phoneme ();

    inline void clear_has_phoneme ();

    inline void set_has_isoLangCode ();

    inline void clear_has_isoLangCode ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _phoneme;

    ::std::string _isoLangCode;

};

/**
 * If the meaning of "AppDataList" isn't clear, then there should be a description here.
 */
class AppDataList {
public:

    /**
     * Default constructor
     */
    inline  AppDataList ();

    /**
     * Copy constructor
     */
    inline  AppDataList (const AppDataList &rhs);

    /**
     * All fields constructor
     */
    inline  AppDataList (uint32 appID_, const ::std::string& appName_, const ::std::vector< PhonemeDataList >& phonemeData_);

    /**
     * Destructor
     */
    inline  ~AppDataList();

    /**
     * Assignment operator
     */
    inline AppDataList& operator = (const AppDataList& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AppDataList& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AppDataList& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AppDataList& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AppDataList& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "appID"

    static const int kAppID = 0;

    /**
     * Clears the field "appID".
     *
     * The field will be set to its default value. The hasAppID()
     * method will return false.
     */
    inline void clearAppID();

    /**
     * Checks whether the field "appID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAppID()). Otherwise it will return false.
     */
    inline bool hasAppID () const;

    /**
     * Returns the value of the member "appID".
     *
     * If the meaning of "appID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "appID"
     */
    inline uint32 getAppID () const;

    /**
     * Sets the value of the member "appID".
     *
     * If the meaning of "appID" isn't clear, then there should be a description here.
     *
     * @param appID The value which will be set
     */
    inline void setAppID (uint32 appID_);

    // API of field "appName"

    static const int kAppName = 1;

    /**
     * Clears the field "appName".
     *
     * The field will be set to its default value. The hasAppName()
     * method will return false.
     */
    inline void clearAppName();

    /**
     * Checks whether the field "appName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAppName()). Otherwise it will return false.
     */
    inline bool hasAppName () const;

    /**
     * Returns the value of the member "appName".
     *
     * If the meaning of "appName" isn't clear, then there should be a description here.
     *
     * @return The value of the field "appName"
     */
    inline const ::std::string& getAppName () const;

    /**
     * Retrieves the value of the field "appName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "appName".
     */
    inline ::std::string& getAppNameMutable ();

    /**
     * Sets the value of the member "appName".
     *
     * If the meaning of "appName" isn't clear, then there should be a description here.
     *
     * @param appName The value which will be set
     */
    inline void setAppName (const ::std::string& appName_);

    /**
     * Sets the value of the member "appName".
     *
     * If the meaning of "appName" isn't clear, then there should be a description here.
     *
     * @param appName The value which will be set
     */
    inline void setAppName (const char* appName_);

    /**
     * Sets the value of the member "appName".
     *
     * If the meaning of "appName" isn't clear, then there should be a description here.
     *
     * @param appName The value which will be set
     */
    inline void setAppName (const char* value, size_t size);

    // API of field "phonemeData"

    static const int kPhonemeData = 2;

    /**
     * Clears the field "phonemeData".
     *
     * The field will be set to its default value. The hasPhonemeData()
     * method will return false.
     */
    inline void clearPhonemeData();

    /**
     * Checks whether the field "phonemeData" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPhonemeData()). Otherwise it will return false.
     */
    inline bool hasPhonemeData () const;

    /**
     * Returns the value of the member "phonemeData".
     *
     * If the meaning of "phonemeData" isn't clear, then there should be a description here.
     *
     * @return The value of the field "phonemeData"
     */
    inline const ::std::vector< PhonemeDataList >& getPhonemeData () const;

    /**
     * Retrieves the value of the field "phonemeData" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "phonemeData".
     */
    inline ::std::vector< PhonemeDataList >& getPhonemeDataMutable ();

    /**
     * Sets the value of the member "phonemeData".
     *
     * If the meaning of "phonemeData" isn't clear, then there should be a description here.
     *
     * @param phonemeData The value which will be set
     */
    inline void setPhonemeData (const ::std::vector< PhonemeDataList >& phonemeData_);

    static const AppDataList &getDefaultInstance();

private:

    static const ::std::vector< PhonemeDataList >& getPhonemeDataListList_DefaultInstance ();

    inline void set_has_appID ();

    inline void clear_has_appID ();

    inline void set_has_appName ();

    inline void clear_has_appName ();

    inline void set_has_phonemeData ();

    inline void clear_has_phonemeData ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint32 _appID;

    ::std::string _appName;

    ::std::vector< PhonemeDataList > _phonemeData;

};

/**
 * If the meaning of "AppList" isn't clear, then there should be a description here.
 */
class AppList {
public:

    /**
     * Default constructor
     */
    inline  AppList ();

    /**
     * Copy constructor
     */
    inline  AppList (const AppList &rhs);

    /**
     * All fields constructor
     */
    inline  AppList (const ::std::vector< AppDataList >& appDetails_, uint32 checksum_);

    /**
     * Destructor
     */
    inline  ~AppList();

    /**
     * Assignment operator
     */
    inline AppList& operator = (const AppList& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AppList& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AppList& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AppList& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AppList& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "appDetails"

    static const int kAppDetails = 0;

    /**
     * Clears the field "appDetails".
     *
     * The field will be set to its default value. The hasAppDetails()
     * method will return false.
     */
    inline void clearAppDetails();

    /**
     * Checks whether the field "appDetails" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAppDetails()). Otherwise it will return false.
     */
    inline bool hasAppDetails () const;

    /**
     * Returns the value of the member "appDetails".
     *
     * If the meaning of "appDetails" isn't clear, then there should be a description here.
     *
     * @return The value of the field "appDetails"
     */
    inline const ::std::vector< AppDataList >& getAppDetails () const;

    /**
     * Retrieves the value of the field "appDetails" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "appDetails".
     */
    inline ::std::vector< AppDataList >& getAppDetailsMutable ();

    /**
     * Sets the value of the member "appDetails".
     *
     * If the meaning of "appDetails" isn't clear, then there should be a description here.
     *
     * @param appDetails The value which will be set
     */
    inline void setAppDetails (const ::std::vector< AppDataList >& appDetails_);

    // API of field "checksum"

    static const int kChecksum = 1;

    /**
     * Clears the field "checksum".
     *
     * The field will be set to its default value. The hasChecksum()
     * method will return false.
     */
    inline void clearChecksum();

    /**
     * Checks whether the field "checksum" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setChecksum()). Otherwise it will return false.
     */
    inline bool hasChecksum () const;

    /**
     * Returns the value of the member "checksum".
     *
     * If the meaning of "checksum" isn't clear, then there should be a description here.
     *
     * @return The value of the field "checksum"
     */
    inline uint32 getChecksum () const;

    /**
     * Sets the value of the member "checksum".
     *
     * If the meaning of "checksum" isn't clear, then there should be a description here.
     *
     * @param checksum The value which will be set
     */
    inline void setChecksum (uint32 checksum_);

    static const AppList &getDefaultInstance();

private:

    static const ::std::vector< AppDataList >& getAppDataListList_DefaultInstance ();

    inline void set_has_appDetails ();

    inline void clear_has_appDetails ();

    inline void set_has_checksum ();

    inline void clear_has_checksum ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::vector< AppDataList > _appDetails;

    uint32 _checksum;

};

/**
 * If the meaning of "storeAppNames" isn't clear, then there should be a description here.
 */
class StoreAppNamesRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  StoreAppNamesRequest ();

    /**
     * Copy constructor
     */
    inline  StoreAppNamesRequest (const StoreAppNamesRequest &rhs);

    /**
     * All fields constructor
     */
    inline  StoreAppNamesRequest (const AppList& appList_);

    /**
     * Destructor
     */
    inline virtual  ~StoreAppNamesRequest();

    /**
     * Assignment operator
     */
    inline StoreAppNamesRequest& operator = (const StoreAppNamesRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const StoreAppNamesRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const StoreAppNamesRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const StoreAppNamesRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const StoreAppNamesRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "appList"

    static const int kAppList = 0;

    /**
     * Clears the field "appList".
     *
     * The field will be set to its default value. The hasAppList()
     * method will return false.
     */
    inline void clearAppList();

    /**
     * Checks whether the field "appList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAppList()). Otherwise it will return false.
     */
    inline bool hasAppList () const;

    /**
     * Returns the value of the member "appList".
     *
     * If the meaning of "appList" isn't clear, then there should be a description here.
     *
     * @return The value of the field "appList"
     */
    inline const AppList& getAppList () const;

    /**
     * Retrieves the value of the field "appList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "appList".
     */
    inline AppList& getAppListMutable ();

    /**
     * Sets the value of the member "appList".
     *
     * If the meaning of "appList" isn't clear, then there should be a description here.
     *
     * @param appList The value which will be set
     */
    inline void setAppList (const AppList& appList_);

    static const StoreAppNamesRequest &getDefaultInstance();

private:

    inline void set_has_appList ();

    inline void clear_has_appList ();

    uint32 _has_bits_[ (1 + 31) / 32];

    AppList _appList;

};

/**
 * If the meaning of "getAppNamesList" isn't clear, then there should be a description here.
 */
class GetAppNamesListResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetAppNamesListResponse ();

    /**
     * Copy constructor
     */
    inline  GetAppNamesListResponse (const GetAppNamesListResponse &rhs);

    /**
     * All fields constructor
     */
    inline  GetAppNamesListResponse (const ::std::vector< ::std::string >& appNameList_);

    /**
     * Destructor
     */
    inline virtual  ~GetAppNamesListResponse();

    /**
     * Assignment operator
     */
    inline GetAppNamesListResponse& operator = (const GetAppNamesListResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetAppNamesListResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetAppNamesListResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetAppNamesListResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetAppNamesListResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "appNameList"

    static const int kAppNameList = 0;

    /**
     * Clears the field "appNameList".
     *
     * The field will be set to its default value. The hasAppNameList()
     * method will return false.
     */
    inline void clearAppNameList();

    /**
     * Checks whether the field "appNameList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAppNameList()). Otherwise it will return false.
     */
    inline bool hasAppNameList () const;

    /**
     * Returns the value of the member "appNameList".
     *
     * If the meaning of "appNameList" isn't clear, then there should be a description here.
     *
     * @return The value of the field "appNameList"
     */
    inline const ::std::vector< ::std::string >& getAppNameList () const;

    /**
     * Retrieves the value of the field "appNameList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "appNameList".
     */
    inline ::std::vector< ::std::string >& getAppNameListMutable ();

    /**
     * Sets the value of the member "appNameList".
     *
     * If the meaning of "appNameList" isn't clear, then there should be a description here.
     *
     * @param appNameList The value which will be set
     */
    inline void setAppNameList (const ::std::vector< ::std::string >& appNameList_);

    static const GetAppNamesListResponse &getDefaultInstance();

private:

    static const ::std::vector< ::std::string >& getStringList_DefaultInstance ();

    inline void set_has_appNameList ();

    inline void clear_has_appNameList ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< ::std::string > _appNameList;

};

inline  PhonemeDataList::PhonemeDataList ()  :
    _phoneme (),
    _isoLangCode ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  PhonemeDataList::PhonemeDataList (const PhonemeDataList &rhs)  :
    _phoneme (),
    _isoLangCode ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  PhonemeDataList::PhonemeDataList (const ::std::string& phoneme_, const ::std::string& isoLangCode_)  :
    _phoneme (phoneme_),
    _isoLangCode (isoLangCode_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (phoneme_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (isoLangCode_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  PhonemeDataList::~PhonemeDataList() {
}

inline PhonemeDataList& PhonemeDataList::operator = (const PhonemeDataList& rhs) {
    if( this != &rhs ) {
        if (rhs.hasPhoneme()) {
            setPhoneme(rhs.getPhoneme());
        } else {
            clearPhoneme();
        }
        if (rhs.hasIsoLangCode()) {
            setIsoLangCode(rhs.getIsoLangCode());
        } else {
            clearIsoLangCode();
        }
    }
    return *this;
}

inline bool PhonemeDataList::operator == (const PhonemeDataList& rhs) const {
    return (((!hasPhoneme() && !rhs.hasPhoneme()) || getPhoneme() == rhs.getPhoneme()) &&
        ((!hasIsoLangCode() && !rhs.hasIsoLangCode()) || getIsoLangCode() == rhs.getIsoLangCode()));
}

inline bool PhonemeDataList::operator != (const PhonemeDataList& rhs) const {
    return ! (*this == rhs);
}

inline bool PhonemeDataList::operator < (const PhonemeDataList& rhs) const {
    if (hasPhoneme() || rhs.hasPhoneme()) {
        if (getPhoneme() < rhs.getPhoneme()) return true;
        if (getPhoneme() > rhs.getPhoneme()) return false;
    }
    if (hasIsoLangCode() || rhs.hasIsoLangCode()) {
        if (getIsoLangCode() < rhs.getIsoLangCode()) return true;
        if (getIsoLangCode() > rhs.getIsoLangCode()) return false;
    }
    return false;
}

inline bool PhonemeDataList::operator > (const PhonemeDataList& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void PhonemeDataList::clear() {
    clearPhoneme();
    clearIsoLangCode();
}

inline void PhonemeDataList::clearPhoneme() {
    if (hasPhoneme()) {
         clear_has_phoneme();
        _phoneme.clear();
     }
}

inline bool PhonemeDataList::hasPhoneme () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& PhonemeDataList::getPhoneme () const {
    return _phoneme;
}

inline ::std::string& PhonemeDataList::getPhonemeMutable () {
    set_has_phoneme();
    return _phoneme;
}

inline void PhonemeDataList::setPhoneme (const ::std::string& phoneme_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (phoneme_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_phoneme();
    this->_phoneme = phoneme_;
}

inline void PhonemeDataList::setPhoneme (const char* phoneme_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (phoneme_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_phoneme();
    this->_phoneme.assign(phoneme_);
}

inline void PhonemeDataList::setPhoneme (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_phoneme();
    this->_phoneme.assign(value, size);
}

inline void PhonemeDataList::clearIsoLangCode() {
    if (hasIsoLangCode()) {
         clear_has_isoLangCode();
        _isoLangCode.clear();
     }
}

inline bool PhonemeDataList::hasIsoLangCode () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& PhonemeDataList::getIsoLangCode () const {
    return _isoLangCode;
}

inline ::std::string& PhonemeDataList::getIsoLangCodeMutable () {
    set_has_isoLangCode();
    return _isoLangCode;
}

inline void PhonemeDataList::setIsoLangCode (const ::std::string& isoLangCode_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (isoLangCode_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_isoLangCode();
    this->_isoLangCode = isoLangCode_;
}

inline void PhonemeDataList::setIsoLangCode (const char* isoLangCode_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (isoLangCode_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_isoLangCode();
    this->_isoLangCode.assign(isoLangCode_);
}

inline void PhonemeDataList::setIsoLangCode (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_isoLangCode();
    this->_isoLangCode.assign(value, size);
}

inline void PhonemeDataList::set_has_phoneme () {
    _has_bits_[0] |= 1u << 0;
}

inline void PhonemeDataList::clear_has_phoneme () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void PhonemeDataList::set_has_isoLangCode () {
    _has_bits_[0] |= 1u << 1;
}

inline void PhonemeDataList::clear_has_isoLangCode () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  AppDataList::AppDataList ()  :
    _appID (0u),
    _appName (),
    _phonemeData ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  AppDataList::AppDataList (const AppDataList &rhs)  :
    _appID (0u),
    _appName (),
    _phonemeData ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  AppDataList::AppDataList (uint32 appID_, const ::std::string& appName_, const ::std::vector< PhonemeDataList >& phonemeData_)  :
    _appID (appID_),
    _appName (appName_),
    _phonemeData (phonemeData_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (appName_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  AppDataList::~AppDataList() {
}

inline AppDataList& AppDataList::operator = (const AppDataList& rhs) {
    if( this != &rhs ) {
        if (rhs.hasAppID()) {
            setAppID(rhs.getAppID());
        } else {
            clearAppID();
        }
        if (rhs.hasAppName()) {
            setAppName(rhs.getAppName());
        } else {
            clearAppName();
        }
        if (rhs.hasPhonemeData()) {
            setPhonemeData(rhs.getPhonemeData());
        } else {
            clearPhonemeData();
        }
    }
    return *this;
}

inline bool AppDataList::operator == (const AppDataList& rhs) const {
    return (((!hasAppID() && !rhs.hasAppID()) || getAppID() == rhs.getAppID()) &&
        ((!hasAppName() && !rhs.hasAppName()) || getAppName() == rhs.getAppName()) &&
        ((!hasPhonemeData() && !rhs.hasPhonemeData()) || getPhonemeData() == rhs.getPhonemeData()));
}

inline bool AppDataList::operator != (const AppDataList& rhs) const {
    return ! (*this == rhs);
}

inline bool AppDataList::operator < (const AppDataList& rhs) const {
    if (hasAppID() || rhs.hasAppID()) {
        if (getAppID() < rhs.getAppID()) return true;
        if (getAppID() > rhs.getAppID()) return false;
    }
    if (hasAppName() || rhs.hasAppName()) {
        if (getAppName() < rhs.getAppName()) return true;
        if (getAppName() > rhs.getAppName()) return false;
    }
    if (hasPhonemeData() || rhs.hasPhonemeData()) {
        if (getPhonemeData() < rhs.getPhonemeData()) return true;
        if (getPhonemeData() > rhs.getPhonemeData()) return false;
    }
    return false;
}

inline bool AppDataList::operator > (const AppDataList& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void AppDataList::clear() {
    clearAppID();
    clearAppName();
    clearPhonemeData();
}

inline void AppDataList::clearAppID() {
    if (hasAppID()) {
         clear_has_appID();
        _appID = 0u;
     }
}

inline bool AppDataList::hasAppID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 AppDataList::getAppID () const {
    return _appID;
}

inline void AppDataList::setAppID (uint32 appID_) {
    set_has_appID();
    this->_appID = appID_;
}

inline void AppDataList::clearAppName() {
    if (hasAppName()) {
         clear_has_appName();
        _appName.clear();
     }
}

inline bool AppDataList::hasAppName () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& AppDataList::getAppName () const {
    return _appName;
}

inline ::std::string& AppDataList::getAppNameMutable () {
    set_has_appName();
    return _appName;
}

inline void AppDataList::setAppName (const ::std::string& appName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (appName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_appName();
    this->_appName = appName_;
}

inline void AppDataList::setAppName (const char* appName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (appName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_appName();
    this->_appName.assign(appName_);
}

inline void AppDataList::setAppName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_appName();
    this->_appName.assign(value, size);
}

inline void AppDataList::clearPhonemeData() {
    if (hasPhonemeData()) {
         clear_has_phonemeData();
        _phonemeData.clear();
     }
}

inline bool AppDataList::hasPhonemeData () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::vector< PhonemeDataList >& AppDataList::getPhonemeData () const {
    return _phonemeData;
}

inline ::std::vector< PhonemeDataList >& AppDataList::getPhonemeDataMutable () {
    set_has_phonemeData();
    return _phonemeData;
}

inline void AppDataList::setPhonemeData (const ::std::vector< PhonemeDataList >& phonemeData_) {
    set_has_phonemeData();
    this->_phonemeData = phonemeData_;
}

inline void AppDataList::set_has_appID () {
    _has_bits_[0] |= 1u << 0;
}

inline void AppDataList::clear_has_appID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void AppDataList::set_has_appName () {
    _has_bits_[0] |= 1u << 1;
}

inline void AppDataList::clear_has_appName () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void AppDataList::set_has_phonemeData () {
    _has_bits_[0] |= 1u << 2;
}

inline void AppDataList::clear_has_phonemeData () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  AppList::AppList ()  :
    _appDetails (),
    _checksum (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  AppList::AppList (const AppList &rhs)  :
    _appDetails (),
    _checksum (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  AppList::AppList (const ::std::vector< AppDataList >& appDetails_, uint32 checksum_)  :
    _appDetails (appDetails_),
    _checksum (checksum_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  AppList::~AppList() {
}

inline AppList& AppList::operator = (const AppList& rhs) {
    if( this != &rhs ) {
        if (rhs.hasAppDetails()) {
            setAppDetails(rhs.getAppDetails());
        } else {
            clearAppDetails();
        }
        if (rhs.hasChecksum()) {
            setChecksum(rhs.getChecksum());
        } else {
            clearChecksum();
        }
    }
    return *this;
}

inline bool AppList::operator == (const AppList& rhs) const {
    return (((!hasAppDetails() && !rhs.hasAppDetails()) || getAppDetails() == rhs.getAppDetails()) &&
        ((!hasChecksum() && !rhs.hasChecksum()) || getChecksum() == rhs.getChecksum()));
}

inline bool AppList::operator != (const AppList& rhs) const {
    return ! (*this == rhs);
}

inline bool AppList::operator < (const AppList& rhs) const {
    if (hasAppDetails() || rhs.hasAppDetails()) {
        if (getAppDetails() < rhs.getAppDetails()) return true;
        if (getAppDetails() > rhs.getAppDetails()) return false;
    }
    if (hasChecksum() || rhs.hasChecksum()) {
        if (getChecksum() < rhs.getChecksum()) return true;
        if (getChecksum() > rhs.getChecksum()) return false;
    }
    return false;
}

inline bool AppList::operator > (const AppList& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void AppList::clear() {
    clearAppDetails();
    clearChecksum();
}

inline void AppList::clearAppDetails() {
    if (hasAppDetails()) {
         clear_has_appDetails();
        _appDetails.clear();
     }
}

inline bool AppList::hasAppDetails () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< AppDataList >& AppList::getAppDetails () const {
    return _appDetails;
}

inline ::std::vector< AppDataList >& AppList::getAppDetailsMutable () {
    set_has_appDetails();
    return _appDetails;
}

inline void AppList::setAppDetails (const ::std::vector< AppDataList >& appDetails_) {
    set_has_appDetails();
    this->_appDetails = appDetails_;
}

inline void AppList::clearChecksum() {
    if (hasChecksum()) {
         clear_has_checksum();
        _checksum = 0u;
     }
}

inline bool AppList::hasChecksum () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 AppList::getChecksum () const {
    return _checksum;
}

inline void AppList::setChecksum (uint32 checksum_) {
    set_has_checksum();
    this->_checksum = checksum_;
}

inline void AppList::set_has_appDetails () {
    _has_bits_[0] |= 1u << 0;
}

inline void AppList::clear_has_appDetails () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void AppList::set_has_checksum () {
    _has_bits_[0] |= 1u << 1;
}

inline void AppList::clear_has_checksum () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  StoreAppNamesRequest::StoreAppNamesRequest ()  :
    _appList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  StoreAppNamesRequest::StoreAppNamesRequest (const StoreAppNamesRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _appList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  StoreAppNamesRequest::StoreAppNamesRequest (const AppList& appList_)  :
    _appList (appList_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  StoreAppNamesRequest::~StoreAppNamesRequest() {
}

inline StoreAppNamesRequest& StoreAppNamesRequest::operator = (const StoreAppNamesRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasAppList()) {
            setAppList(rhs.getAppList());
        } else {
            clearAppList();
        }
    }
    return *this;
}

inline bool StoreAppNamesRequest::operator == (const StoreAppNamesRequest& rhs) const {
    return (((!hasAppList() && !rhs.hasAppList()) || getAppList() == rhs.getAppList()));
}

inline bool StoreAppNamesRequest::operator != (const StoreAppNamesRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool StoreAppNamesRequest::operator < (const StoreAppNamesRequest& rhs) const {
    if (hasAppList() || rhs.hasAppList()) {
        if (getAppList() < rhs.getAppList()) return true;
        if (getAppList() > rhs.getAppList()) return false;
    }
    return false;
}

inline ::asf::core::Payload* StoreAppNamesRequest::clone() {
    return new StoreAppNamesRequest(*this);
}

inline bool StoreAppNamesRequest::operator > (const StoreAppNamesRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void StoreAppNamesRequest::clear() {
    clearAppList();
}

inline void StoreAppNamesRequest::clearAppList() {
    if (hasAppList()) {
         clear_has_appList();
        _appList.clear();
     }
}

inline bool StoreAppNamesRequest::hasAppList () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const AppList& StoreAppNamesRequest::getAppList () const {
    return _appList;
}

inline AppList& StoreAppNamesRequest::getAppListMutable () {
    set_has_appList();
    return _appList;
}

inline void StoreAppNamesRequest::setAppList (const AppList& appList_) {
    set_has_appList();
    this->_appList = appList_;
}

inline void StoreAppNamesRequest::set_has_appList () {
    _has_bits_[0] |= 1u << 0;
}

inline void StoreAppNamesRequest::clear_has_appList () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  GetAppNamesListResponse::GetAppNamesListResponse ()  :
    _appNameList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetAppNamesListResponse::GetAppNamesListResponse (const GetAppNamesListResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _appNameList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetAppNamesListResponse::GetAppNamesListResponse (const ::std::vector< ::std::string >& appNameList_)  :
    _appNameList (appNameList_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetAppNamesListResponse::~GetAppNamesListResponse() {
}

inline GetAppNamesListResponse& GetAppNamesListResponse::operator = (const GetAppNamesListResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasAppNameList()) {
            setAppNameList(rhs.getAppNameList());
        } else {
            clearAppNameList();
        }
    }
    return *this;
}

inline bool GetAppNamesListResponse::operator == (const GetAppNamesListResponse& rhs) const {
    return (((!hasAppNameList() && !rhs.hasAppNameList()) || getAppNameList() == rhs.getAppNameList()));
}

inline bool GetAppNamesListResponse::operator != (const GetAppNamesListResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool GetAppNamesListResponse::operator < (const GetAppNamesListResponse& rhs) const {
    if (hasAppNameList() || rhs.hasAppNameList()) {
        if (getAppNameList() < rhs.getAppNameList()) return true;
        if (getAppNameList() > rhs.getAppNameList()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetAppNamesListResponse::clone() {
    return new GetAppNamesListResponse(*this);
}

inline bool GetAppNamesListResponse::operator > (const GetAppNamesListResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetAppNamesListResponse::clear() {
    clearAppNameList();
}

inline void GetAppNamesListResponse::clearAppNameList() {
    if (hasAppNameList()) {
         clear_has_appNameList();
        _appNameList.clear();
     }
}

inline bool GetAppNamesListResponse::hasAppNameList () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< ::std::string >& GetAppNamesListResponse::getAppNameList () const {
    return _appNameList;
}

inline ::std::vector< ::std::string >& GetAppNamesListResponse::getAppNameListMutable () {
    set_has_appNameList();
    return _appNameList;
}

inline void GetAppNamesListResponse::setAppNameList (const ::std::vector< ::std::string >& appNameList_) {
    set_has_appNameList();
    this->_appNameList = appNameList_;
}

inline void GetAppNamesListResponse::set_has_appNameList () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetAppNamesListResponse::clear_has_appNameList () {
    _has_bits_[0] &= ~ (1u << 0);
}

} // namespace SdsAppService
} // namespace sds_app_fi

#endif // SDS_APP_FI_SDSAPPSERVICE_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
