#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef SDS_AM_FI_SDSAMSERVICE_H
#define SDS_AM_FI_SDSAMSERVICE_H

#include "asf/core/Logger.h"
#include "asf/core/Payload.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "asf/core/VersionCheck.h"
#include "asf/dbus/DBusTypes.h"
#include <cstddef>
#include <cstring>
#include <string>
#include <vector>

/**
 * If the meaning of "sds_am_fi.SdsAmService" isn't clear, then there should be a description here.
 */

namespace sds_am_fi {
namespace SdsAmService {

// method IDs
static const uint16 ID_storeHDChannelNames = 0;

// signal IDs
static const uint16 ID_ProcessingFinished = 1;
static const uint16 ID_ProcessingInterrupted = 2;

// property IDs

ASF_GENERATOR_VERSION_CHECK_DECLARE

// forward declarations
class AMChannelItem;

class StoreHDChannelNamesRequest;

// type definitions
/**
 * If the meaning of "storeHDChannelNames" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage StoreHDChannelNamesResponse;

/**
 * If the meaning of "StoreHDChannelNamesError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError StoreHDChannelNamesError;

/**
 * If the meaning of "ProcessingFinished" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage ProcessingFinishedSignal;

/**
 * If the meaning of "ProcessingFinishedError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ProcessingFinishedError;

/**
 * If the meaning of "ProcessingInterrupted" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage ProcessingInterruptedSignal;

/**
 * If the meaning of "ProcessingInterruptedError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ProcessingInterruptedError;


/**
 * If the meaning of "AMChannelItem" isn't clear, then there should be a description here.
 */
class AMChannelItem {
public:

    /**
     * Default constructor
     */
    inline  AMChannelItem ();

    /**
     * Copy constructor
     */
    inline  AMChannelItem (const AMChannelItem &rhs);

    /**
     * All fields constructor
     */
    inline  AMChannelItem (uint32 objectID_, uint32 frequency_, const ::std::string& stationName_, uint32 audioProgram_);

    /**
     * Destructor
     */
    inline  ~AMChannelItem();

    /**
     * Assignment operator
     */
    inline AMChannelItem& operator = (const AMChannelItem& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AMChannelItem& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AMChannelItem& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AMChannelItem& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AMChannelItem& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "objectID"

    static const int kObjectID = 0;

    /**
     * Clears the field "objectID".
     *
     * The field will be set to its default value. The hasObjectID()
     * method will return false.
     */
    inline void clearObjectID();

    /**
     * Checks whether the field "objectID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setObjectID()). Otherwise it will return false.
     */
    inline bool hasObjectID () const;

    /**
     * Returns the value of the member "objectID".
     *
     * If the meaning of "objectID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "objectID"
     */
    inline uint32 getObjectID () const;

    /**
     * Sets the value of the member "objectID".
     *
     * If the meaning of "objectID" isn't clear, then there should be a description here.
     *
     * @param objectID The value which will be set
     */
    inline void setObjectID (uint32 objectID_);

    // API of field "frequency"

    static const int kFrequency = 1;

    /**
     * Clears the field "frequency".
     *
     * The field will be set to its default value. The hasFrequency()
     * method will return false.
     */
    inline void clearFrequency();

    /**
     * Checks whether the field "frequency" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFrequency()). Otherwise it will return false.
     */
    inline bool hasFrequency () const;

    /**
     * Returns the value of the member "frequency".
     *
     * If the meaning of "frequency" isn't clear, then there should be a description here.
     *
     * @return The value of the field "frequency"
     */
    inline uint32 getFrequency () const;

    /**
     * Sets the value of the member "frequency".
     *
     * If the meaning of "frequency" isn't clear, then there should be a description here.
     *
     * @param frequency The value which will be set
     */
    inline void setFrequency (uint32 frequency_);

    // API of field "stationName"

    static const int kStationName = 2;

    /**
     * Clears the field "stationName".
     *
     * The field will be set to its default value. The hasStationName()
     * method will return false.
     */
    inline void clearStationName();

    /**
     * Checks whether the field "stationName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStationName()). Otherwise it will return false.
     */
    inline bool hasStationName () const;

    /**
     * Returns the value of the member "stationName".
     *
     * If the meaning of "stationName" isn't clear, then there should be a description here.
     *
     * @return The value of the field "stationName"
     */
    inline const ::std::string& getStationName () const;

    /**
     * Retrieves the value of the field "stationName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "stationName".
     */
    inline ::std::string& getStationNameMutable ();

    /**
     * Sets the value of the member "stationName".
     *
     * If the meaning of "stationName" isn't clear, then there should be a description here.
     *
     * @param stationName The value which will be set
     */
    inline void setStationName (const ::std::string& stationName_);

    /**
     * Sets the value of the member "stationName".
     *
     * If the meaning of "stationName" isn't clear, then there should be a description here.
     *
     * @param stationName The value which will be set
     */
    inline void setStationName (const char* stationName_);

    /**
     * Sets the value of the member "stationName".
     *
     * If the meaning of "stationName" isn't clear, then there should be a description here.
     *
     * @param stationName The value which will be set
     */
    inline void setStationName (const char* value, size_t size);

    // API of field "audioProgram"

    static const int kAudioProgram = 3;

    /**
     * Clears the field "audioProgram".
     *
     * The field will be set to its default value. The hasAudioProgram()
     * method will return false.
     */
    inline void clearAudioProgram();

    /**
     * Checks whether the field "audioProgram" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAudioProgram()). Otherwise it will return false.
     */
    inline bool hasAudioProgram () const;

    /**
     * Returns the value of the member "audioProgram".
     *
     * If the meaning of "audioProgram" isn't clear, then there should be a description here.
     *
     * @return The value of the field "audioProgram"
     */
    inline uint32 getAudioProgram () const;

    /**
     * Sets the value of the member "audioProgram".
     *
     * If the meaning of "audioProgram" isn't clear, then there should be a description here.
     *
     * @param audioProgram The value which will be set
     */
    inline void setAudioProgram (uint32 audioProgram_);

    static const AMChannelItem &getDefaultInstance();

private:

    inline void set_has_objectID ();

    inline void clear_has_objectID ();

    inline void set_has_frequency ();

    inline void clear_has_frequency ();

    inline void set_has_stationName ();

    inline void clear_has_stationName ();

    inline void set_has_audioProgram ();

    inline void clear_has_audioProgram ();

    uint32 _has_bits_[ (4 + 31) / 32];

    uint32 _objectID;

    uint32 _frequency;

    ::std::string _stationName;

    uint32 _audioProgram;

};

/**
 * If the meaning of "storeHDChannelNames" isn't clear, then there should be a description here.
 */
class StoreHDChannelNamesRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  StoreHDChannelNamesRequest ();

    /**
     * Copy constructor
     */
    inline  StoreHDChannelNamesRequest (const StoreHDChannelNamesRequest &rhs);

    /**
     * All fields constructor
     */
    inline  StoreHDChannelNamesRequest (const ::std::vector< AMChannelItem >& channelList_);

    /**
     * Destructor
     */
    inline virtual  ~StoreHDChannelNamesRequest();

    /**
     * Assignment operator
     */
    inline StoreHDChannelNamesRequest& operator = (const StoreHDChannelNamesRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const StoreHDChannelNamesRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const StoreHDChannelNamesRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const StoreHDChannelNamesRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const StoreHDChannelNamesRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "channelList"

    static const int kChannelList = 0;

    /**
     * Clears the field "channelList".
     *
     * The field will be set to its default value. The hasChannelList()
     * method will return false.
     */
    inline void clearChannelList();

    /**
     * Checks whether the field "channelList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setChannelList()). Otherwise it will return false.
     */
    inline bool hasChannelList () const;

    /**
     * Returns the value of the member "channelList".
     *
     * If the meaning of "channelList" isn't clear, then there should be a description here.
     *
     * @return The value of the field "channelList"
     */
    inline const ::std::vector< AMChannelItem >& getChannelList () const;

    /**
     * Retrieves the value of the field "channelList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "channelList".
     */
    inline ::std::vector< AMChannelItem >& getChannelListMutable ();

    /**
     * Sets the value of the member "channelList".
     *
     * If the meaning of "channelList" isn't clear, then there should be a description here.
     *
     * @param channelList The value which will be set
     */
    inline void setChannelList (const ::std::vector< AMChannelItem >& channelList_);

    static const StoreHDChannelNamesRequest &getDefaultInstance();

private:

    static const ::std::vector< AMChannelItem >& getAMChannelItemList_DefaultInstance ();

    inline void set_has_channelList ();

    inline void clear_has_channelList ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< AMChannelItem > _channelList;

};

inline  AMChannelItem::AMChannelItem ()  :
    _objectID (0u),
    _frequency (0u),
    _stationName (),
    _audioProgram (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  AMChannelItem::AMChannelItem (const AMChannelItem &rhs)  :
    _objectID (0u),
    _frequency (0u),
    _stationName (),
    _audioProgram (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  AMChannelItem::AMChannelItem (uint32 objectID_, uint32 frequency_, const ::std::string& stationName_, uint32 audioProgram_)  :
    _objectID (objectID_),
    _frequency (frequency_),
    _stationName (stationName_),
    _audioProgram (audioProgram_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (stationName_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  AMChannelItem::~AMChannelItem() {
}

inline AMChannelItem& AMChannelItem::operator = (const AMChannelItem& rhs) {
    if( this != &rhs ) {
        if (rhs.hasObjectID()) {
            setObjectID(rhs.getObjectID());
        } else {
            clearObjectID();
        }
        if (rhs.hasFrequency()) {
            setFrequency(rhs.getFrequency());
        } else {
            clearFrequency();
        }
        if (rhs.hasStationName()) {
            setStationName(rhs.getStationName());
        } else {
            clearStationName();
        }
        if (rhs.hasAudioProgram()) {
            setAudioProgram(rhs.getAudioProgram());
        } else {
            clearAudioProgram();
        }
    }
    return *this;
}

inline bool AMChannelItem::operator == (const AMChannelItem& rhs) const {
    return (((!hasObjectID() && !rhs.hasObjectID()) || getObjectID() == rhs.getObjectID()) &&
        ((!hasFrequency() && !rhs.hasFrequency()) || getFrequency() == rhs.getFrequency()) &&
        ((!hasStationName() && !rhs.hasStationName()) || getStationName() == rhs.getStationName()) &&
        ((!hasAudioProgram() && !rhs.hasAudioProgram()) || getAudioProgram() == rhs.getAudioProgram()));
}

inline bool AMChannelItem::operator != (const AMChannelItem& rhs) const {
    return ! (*this == rhs);
}

inline bool AMChannelItem::operator < (const AMChannelItem& rhs) const {
    if (hasObjectID() || rhs.hasObjectID()) {
        if (getObjectID() < rhs.getObjectID()) return true;
        if (getObjectID() > rhs.getObjectID()) return false;
    }
    if (hasFrequency() || rhs.hasFrequency()) {
        if (getFrequency() < rhs.getFrequency()) return true;
        if (getFrequency() > rhs.getFrequency()) return false;
    }
    if (hasStationName() || rhs.hasStationName()) {
        if (getStationName() < rhs.getStationName()) return true;
        if (getStationName() > rhs.getStationName()) return false;
    }
    if (hasAudioProgram() || rhs.hasAudioProgram()) {
        if (getAudioProgram() < rhs.getAudioProgram()) return true;
        if (getAudioProgram() > rhs.getAudioProgram()) return false;
    }
    return false;
}

inline bool AMChannelItem::operator > (const AMChannelItem& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void AMChannelItem::clear() {
    clearObjectID();
    clearFrequency();
    clearStationName();
    clearAudioProgram();
}

inline void AMChannelItem::clearObjectID() {
    if (hasObjectID()) {
         clear_has_objectID();
        _objectID = 0u;
     }
}

inline bool AMChannelItem::hasObjectID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 AMChannelItem::getObjectID () const {
    return _objectID;
}

inline void AMChannelItem::setObjectID (uint32 objectID_) {
    set_has_objectID();
    this->_objectID = objectID_;
}

inline void AMChannelItem::clearFrequency() {
    if (hasFrequency()) {
         clear_has_frequency();
        _frequency = 0u;
     }
}

inline bool AMChannelItem::hasFrequency () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 AMChannelItem::getFrequency () const {
    return _frequency;
}

inline void AMChannelItem::setFrequency (uint32 frequency_) {
    set_has_frequency();
    this->_frequency = frequency_;
}

inline void AMChannelItem::clearStationName() {
    if (hasStationName()) {
         clear_has_stationName();
        _stationName.clear();
     }
}

inline bool AMChannelItem::hasStationName () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::string& AMChannelItem::getStationName () const {
    return _stationName;
}

inline ::std::string& AMChannelItem::getStationNameMutable () {
    set_has_stationName();
    return _stationName;
}

inline void AMChannelItem::setStationName (const ::std::string& stationName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (stationName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_stationName();
    this->_stationName = stationName_;
}

inline void AMChannelItem::setStationName (const char* stationName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (stationName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_stationName();
    this->_stationName.assign(stationName_);
}

inline void AMChannelItem::setStationName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_stationName();
    this->_stationName.assign(value, size);
}

inline void AMChannelItem::clearAudioProgram() {
    if (hasAudioProgram()) {
         clear_has_audioProgram();
        _audioProgram = 0u;
     }
}

inline bool AMChannelItem::hasAudioProgram () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint32 AMChannelItem::getAudioProgram () const {
    return _audioProgram;
}

inline void AMChannelItem::setAudioProgram (uint32 audioProgram_) {
    set_has_audioProgram();
    this->_audioProgram = audioProgram_;
}

inline void AMChannelItem::set_has_objectID () {
    _has_bits_[0] |= 1u << 0;
}

inline void AMChannelItem::clear_has_objectID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void AMChannelItem::set_has_frequency () {
    _has_bits_[0] |= 1u << 1;
}

inline void AMChannelItem::clear_has_frequency () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void AMChannelItem::set_has_stationName () {
    _has_bits_[0] |= 1u << 2;
}

inline void AMChannelItem::clear_has_stationName () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void AMChannelItem::set_has_audioProgram () {
    _has_bits_[0] |= 1u << 3;
}

inline void AMChannelItem::clear_has_audioProgram () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  StoreHDChannelNamesRequest::StoreHDChannelNamesRequest ()  :
    _channelList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  StoreHDChannelNamesRequest::StoreHDChannelNamesRequest (const StoreHDChannelNamesRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _channelList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  StoreHDChannelNamesRequest::StoreHDChannelNamesRequest (const ::std::vector< AMChannelItem >& channelList_)  :
    _channelList (channelList_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  StoreHDChannelNamesRequest::~StoreHDChannelNamesRequest() {
}

inline StoreHDChannelNamesRequest& StoreHDChannelNamesRequest::operator = (const StoreHDChannelNamesRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasChannelList()) {
            setChannelList(rhs.getChannelList());
        } else {
            clearChannelList();
        }
    }
    return *this;
}

inline bool StoreHDChannelNamesRequest::operator == (const StoreHDChannelNamesRequest& rhs) const {
    return (((!hasChannelList() && !rhs.hasChannelList()) || getChannelList() == rhs.getChannelList()));
}

inline bool StoreHDChannelNamesRequest::operator != (const StoreHDChannelNamesRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool StoreHDChannelNamesRequest::operator < (const StoreHDChannelNamesRequest& rhs) const {
    if (hasChannelList() || rhs.hasChannelList()) {
        if (getChannelList() < rhs.getChannelList()) return true;
        if (getChannelList() > rhs.getChannelList()) return false;
    }
    return false;
}

inline ::asf::core::Payload* StoreHDChannelNamesRequest::clone() {
    return new StoreHDChannelNamesRequest(*this);
}

inline bool StoreHDChannelNamesRequest::operator > (const StoreHDChannelNamesRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void StoreHDChannelNamesRequest::clear() {
    clearChannelList();
}

inline void StoreHDChannelNamesRequest::clearChannelList() {
    if (hasChannelList()) {
         clear_has_channelList();
        _channelList.clear();
     }
}

inline bool StoreHDChannelNamesRequest::hasChannelList () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< AMChannelItem >& StoreHDChannelNamesRequest::getChannelList () const {
    return _channelList;
}

inline ::std::vector< AMChannelItem >& StoreHDChannelNamesRequest::getChannelListMutable () {
    set_has_channelList();
    return _channelList;
}

inline void StoreHDChannelNamesRequest::setChannelList (const ::std::vector< AMChannelItem >& channelList_) {
    set_has_channelList();
    this->_channelList = channelList_;
}

inline void StoreHDChannelNamesRequest::set_has_channelList () {
    _has_bits_[0] |= 1u << 0;
}

inline void StoreHDChannelNamesRequest::clear_has_channelList () {
    _has_bits_[0] &= ~ (1u << 0);
}

} // namespace SdsAmService
} // namespace sds_am_fi

#endif // SDS_AM_FI_SDSAMSERVICE_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
