/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusStubDelegate.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "fcswupdatesrv/FcSwUpdateSrv.h"
#include "fcswupdatesrv/FcSwUpdateSrvConst.h"
#include "fcswupdatesrv/FcSwUpdateSrvDBus.h"
#include "fcswupdatesrv/FcSwUpdateSrvJson.h"
#include "fcswupdatesrv/FcSwUpdateSrvStub.h"
#include <string>

#include "asf/dbus/DBusMessage.h"

namespace fcswupdatesrv {
namespace FcSwUpdateSrv {

DEFINE_CLASS_LOGGER("/fcswupdatesrv/fcswupdatesrv/FcSwUpdateSrv", FcSwUpdateSrvStub);

static ::asf::dbus::DBusUtils::stringEntry methodsTable[] = {
    { 8, "ApplyDoc", 10 },
    { 9, "ApplyLock", 11 },
    { 9, "UpdateEnd", 14 },
    { 11, "HandleError", 17 },
    { 11, "UpdateAbort", 15 },
    { 11, "UpdateEnter", 1 },
    { 13, "GetUpdateFile", 9 },
    { 14, "GetTargetState", 22 },
    { 14, "VerifyChecksum", 27 },
    { 15, "RegisterBgLocks", 28 },
    { 16, "GetUpdateHistory", 18 },
    { 16, "ModifyReleaseDoc", 8 },
    { 16, "SetUpdateOptions", 7 },
    { 16, "UpdateGetSources", 3 },
    { 17, "EnterRecoveryMode", 26 },
    { 17, "GetCacheDirectory", 25 },
    { 17, "UpdateAbortDevice", 16 },
    { 18, "GetDeviceStateList", 6 },
    { 18, "RetryFailedModules", 13 },
    { 18, "UpdateSelectSource", 4 },
    { 19, "StoreHistoryToStick", 0 },
    { 19, "UpdateSelectRelease", 5 },
    { 20, "DeleteHistoryRequest", 21 },
    { 20, "SetAllowRecoveryMode", 24 },
    { 20, "SetVersionBackDocAck", 23 },
    { 22, "GetUpdateHistoryScoped", 19 },
    { 22, "UpdateSetReleaseFilter", 2 },
    { 24, "GetUpdateHistoryDetailed", 20 },
    { 25, "UpdateSelectReleaseByFile", 12 },
};

static ::asf::dbus::DBusUtils::stringEntry propertiesTable[] = {
    { 10, "ReleaseDoc", 3 },
    { 11, "UpdateState", 0 },
    { 12, "BgLocksState", 12 },
    { 12, "UpdateErrors", 7 },
    { 12, "UpdateResult", 6 },
    { 13, "PreReleaseDoc", 4 },
    { 13, "ReleaseFilter", 2 },
    { 13, "UpdateSources", 1 },
    { 14, "UpdateProgress", 5 },
    { 15, "CustomerUpdates", 8 },
    { 17, "UpdateBgImageInfo", 11 },
    { 18, "VersionBackDocInfo", 9 },
    { 24, "AvailableCustomerUpdates", 10 },
};

class FcSwUpdateSrvStubDelegate : public ::asf::dbus::DBusStubDelegate {
public:

    FcSwUpdateSrvStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger) :
        ::asf::dbus::DBusStubDelegate( stub, logger),
        _logger(logger)
    {}

    FcSwUpdateSrvStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger, const std::string& objectPath) :
        ::asf::dbus::DBusStubDelegate( stub, logger, objectPath),
        _logger(logger) {}

    FcSwUpdateSrvStubDelegate(::asf::dbus::DBusStub* stub,
                               ::asf::core::Logger& logger,
                               ::asf::dbus::DBusConnector& connector,
                               const std::string& objectPath)
        : ::asf::dbus::DBusStubDelegate(
              stub, logger, connector, objectPath, "fcswupdatesrv.FcSwUpdateSrv"),
          _logger(logger) {}

    virtual ~FcSwUpdateSrvStubDelegate() {}

    virtual void process(::asf::core::ServiceMessage& msg);

    const char* introspect() const;

    virtual void getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties);

    virtual void setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act);

    virtual void getProperty(const ::std::string& property, const act_t& act);

private:

    ::asf::core::Logger& _logger;

};

void FcSwUpdateSrvStubDelegate::process(::asf::core::ServiceMessage& msg) {
    ::asf::dbus::DBusMessage& message = static_cast< ::asf::dbus::DBusMessage& >(msg);
    LOG_DEBUG_STUB("Entering process(memberName='%s')", message.getMemberName().c_str());

    unsigned int methodIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (message.getMemberName().c_str(), message.getMemberName().length(), methodsTable, 29, methodIndex)) {
        switch (methodIndex) {
        case 0: {

            // method 'StoreHistoryToStick'

            LOG_DEBUG_STUB("process method '%s'", "StoreHistoryToStick");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), StoreHistoryToStickRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "StoreHistoryToStick", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< StoreHistoryToStickRequest > payload = ::boost::static_pointer_cast<StoreHistoryToStickRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<FcSwUpdateSrvStub*>(getStub())->onStoreHistoryToStickRequest(payload);
            return;
        }
        case 1: {

            // method 'UpdateEnter'

            LOG_DEBUG_STUB("process method '%s'", "UpdateEnter");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), UpdateEnterRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "UpdateEnter", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< UpdateEnterRequest > payload = ::boost::static_pointer_cast<UpdateEnterRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<FcSwUpdateSrvStub*>(getStub())->onUpdateEnterRequest(payload);
            return;
        }
        case 2: {

            // method 'UpdateSetReleaseFilter'

            LOG_DEBUG_STUB("process method '%s'", "UpdateSetReleaseFilter");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), UpdateSetReleaseFilterRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "UpdateSetReleaseFilter", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< UpdateSetReleaseFilterRequest > payload = ::boost::static_pointer_cast<UpdateSetReleaseFilterRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<FcSwUpdateSrvStub*>(getStub())->onUpdateSetReleaseFilterRequest(payload);
            return;
        }
        case 3: {

            // method 'UpdateGetSources'

            LOG_DEBUG_STUB("process method '%s'", "UpdateGetSources");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), UpdateGetSourcesRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "UpdateGetSources", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< UpdateGetSourcesRequest > payload = ::boost::static_pointer_cast<UpdateGetSourcesRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<FcSwUpdateSrvStub*>(getStub())->onUpdateGetSourcesRequest(payload);
            return;
        }
        case 4: {

            // method 'UpdateSelectSource'

            LOG_DEBUG_STUB("process method '%s'", "UpdateSelectSource");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), UpdateSelectSourceRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "UpdateSelectSource", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< UpdateSelectSourceRequest > payload = ::boost::static_pointer_cast<UpdateSelectSourceRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<FcSwUpdateSrvStub*>(getStub())->onUpdateSelectSourceRequest(payload);
            return;
        }
        case 5: {

            // method 'UpdateSelectRelease'

            LOG_DEBUG_STUB("process method '%s'", "UpdateSelectRelease");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), UpdateSelectReleaseRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "UpdateSelectRelease", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< UpdateSelectReleaseRequest > payload = ::boost::static_pointer_cast<UpdateSelectReleaseRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<FcSwUpdateSrvStub*>(getStub())->onUpdateSelectReleaseRequest(payload);
            return;
        }
        case 6: {

            // method 'GetDeviceStateList'

            LOG_DEBUG_STUB("process method '%s'", "GetDeviceStateList");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GetDeviceStateListRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "GetDeviceStateList", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< GetDeviceStateListRequest > payload = ::boost::static_pointer_cast<GetDeviceStateListRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<FcSwUpdateSrvStub*>(getStub())->onGetDeviceStateListRequest(payload);
            return;
        }
        case 7: {

            // method 'SetUpdateOptions'

            LOG_DEBUG_STUB("process method '%s'", "SetUpdateOptions");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SetUpdateOptionsRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "SetUpdateOptions", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< SetUpdateOptionsRequest > payload = ::boost::static_pointer_cast<SetUpdateOptionsRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<FcSwUpdateSrvStub*>(getStub())->onSetUpdateOptionsRequest(payload);
            return;
        }
        case 8: {

            // method 'ModifyReleaseDoc'

            LOG_DEBUG_STUB("process method '%s'", "ModifyReleaseDoc");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ModifyReleaseDocRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "ModifyReleaseDoc", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< ModifyReleaseDocRequest > payload = ::boost::static_pointer_cast<ModifyReleaseDocRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<FcSwUpdateSrvStub*>(getStub())->onModifyReleaseDocRequest(payload);
            return;
        }
        case 9: {

            // method 'GetUpdateFile'

            LOG_DEBUG_STUB("process method '%s'", "GetUpdateFile");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GetUpdateFileRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "GetUpdateFile", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< GetUpdateFileRequest > payload = ::boost::static_pointer_cast<GetUpdateFileRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<FcSwUpdateSrvStub*>(getStub())->onGetUpdateFileRequest(payload);
            return;
        }
        case 10: {

            // method 'ApplyDoc'

            LOG_DEBUG_STUB("process method '%s'", "ApplyDoc");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ApplyDocRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "ApplyDoc", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< ApplyDocRequest > payload = ::boost::static_pointer_cast<ApplyDocRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<FcSwUpdateSrvStub*>(getStub())->onApplyDocRequest(payload);
            return;
        }
        case 11: {

            // method 'ApplyLock'

            LOG_DEBUG_STUB("process method '%s'", "ApplyLock");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ApplyLockRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "ApplyLock", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< ApplyLockRequest > payload = ::boost::static_pointer_cast<ApplyLockRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<FcSwUpdateSrvStub*>(getStub())->onApplyLockRequest(payload);
            return;
        }
        case 12: {

            // method 'UpdateSelectReleaseByFile'

            LOG_DEBUG_STUB("process method '%s'", "UpdateSelectReleaseByFile");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), UpdateSelectReleaseByFileRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "UpdateSelectReleaseByFile", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< UpdateSelectReleaseByFileRequest > payload = ::boost::static_pointer_cast<UpdateSelectReleaseByFileRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<FcSwUpdateSrvStub*>(getStub())->onUpdateSelectReleaseByFileRequest(payload);
            return;
        }
        case 13: {

            // method 'RetryFailedModules'

            LOG_DEBUG_STUB("process method '%s'", "RetryFailedModules");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RetryFailedModulesRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "RetryFailedModules", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< RetryFailedModulesRequest > payload = ::boost::static_pointer_cast<RetryFailedModulesRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<FcSwUpdateSrvStub*>(getStub())->onRetryFailedModulesRequest(payload);
            return;
        }
        case 14: {

            // method 'UpdateEnd'

            LOG_DEBUG_STUB("process method '%s'", "UpdateEnd");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), UpdateEndRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "UpdateEnd", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< UpdateEndRequest > payload = ::boost::static_pointer_cast<UpdateEndRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<FcSwUpdateSrvStub*>(getStub())->onUpdateEndRequest(payload);
            return;
        }
        case 15: {

            // method 'UpdateAbort'

            LOG_DEBUG_STUB("process method '%s'", "UpdateAbort");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), UpdateAbortRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "UpdateAbort", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< UpdateAbortRequest > payload = ::boost::static_pointer_cast<UpdateAbortRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<FcSwUpdateSrvStub*>(getStub())->onUpdateAbortRequest(payload);
            return;
        }
        case 16: {

            // method 'UpdateAbortDevice'

            LOG_DEBUG_STUB("process method '%s'", "UpdateAbortDevice");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), UpdateAbortDeviceRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "UpdateAbortDevice", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< UpdateAbortDeviceRequest > payload = ::boost::static_pointer_cast<UpdateAbortDeviceRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<FcSwUpdateSrvStub*>(getStub())->onUpdateAbortDeviceRequest(payload);
            return;
        }
        case 17: {

            // method 'HandleError'

            LOG_DEBUG_STUB("process method '%s'", "HandleError");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), HandleErrorRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "HandleError", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< HandleErrorRequest > payload = ::boost::static_pointer_cast<HandleErrorRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<FcSwUpdateSrvStub*>(getStub())->onHandleErrorRequest(payload);
            return;
        }
        case 18: {

            // method 'GetUpdateHistory'

            LOG_DEBUG_STUB("process method '%s'", "GetUpdateHistory");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GetUpdateHistoryRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "GetUpdateHistory", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< GetUpdateHistoryRequest > payload = ::boost::static_pointer_cast<GetUpdateHistoryRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<FcSwUpdateSrvStub*>(getStub())->onGetUpdateHistoryRequest(payload);
            return;
        }
        case 19: {

            // method 'GetUpdateHistoryScoped'

            LOG_DEBUG_STUB("process method '%s'", "GetUpdateHistoryScoped");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GetUpdateHistoryScopedRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "GetUpdateHistoryScoped", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< GetUpdateHistoryScopedRequest > payload = ::boost::static_pointer_cast<GetUpdateHistoryScopedRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<FcSwUpdateSrvStub*>(getStub())->onGetUpdateHistoryScopedRequest(payload);
            return;
        }
        case 20: {

            // method 'GetUpdateHistoryDetailed'

            LOG_DEBUG_STUB("process method '%s'", "GetUpdateHistoryDetailed");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GetUpdateHistoryDetailedRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "GetUpdateHistoryDetailed", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< GetUpdateHistoryDetailedRequest > payload = ::boost::static_pointer_cast<GetUpdateHistoryDetailedRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<FcSwUpdateSrvStub*>(getStub())->onGetUpdateHistoryDetailedRequest(payload);
            return;
        }
        case 21: {

            // method 'DeleteHistoryRequest'

            LOG_DEBUG_STUB("process method '%s'", "DeleteHistoryRequest");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), DeleteHistoryRequestRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "DeleteHistoryRequest", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< DeleteHistoryRequestRequest > payload = ::boost::static_pointer_cast<DeleteHistoryRequestRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<FcSwUpdateSrvStub*>(getStub())->onDeleteHistoryRequestRequest(payload);
            return;
        }
        case 22: {

            // method 'GetTargetState'

            LOG_DEBUG_STUB("process method '%s'", "GetTargetState");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GetTargetStateRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "GetTargetState", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< GetTargetStateRequest > payload = ::boost::static_pointer_cast<GetTargetStateRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<FcSwUpdateSrvStub*>(getStub())->onGetTargetStateRequest(payload);
            return;
        }
        case 23: {

            // method 'SetVersionBackDocAck'

            LOG_DEBUG_STUB("process method '%s'", "SetVersionBackDocAck");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SetVersionBackDocAckRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "SetVersionBackDocAck", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< SetVersionBackDocAckRequest > payload = ::boost::static_pointer_cast<SetVersionBackDocAckRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<FcSwUpdateSrvStub*>(getStub())->onSetVersionBackDocAckRequest(payload);
            return;
        }
        case 24: {

            // method 'SetAllowRecoveryMode'

            LOG_DEBUG_STUB("process method '%s'", "SetAllowRecoveryMode");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SetAllowRecoveryModeRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "SetAllowRecoveryMode", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< SetAllowRecoveryModeRequest > payload = ::boost::static_pointer_cast<SetAllowRecoveryModeRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<FcSwUpdateSrvStub*>(getStub())->onSetAllowRecoveryModeRequest(payload);
            return;
        }
        case 25: {

            // method 'GetCacheDirectory'

            LOG_DEBUG_STUB("process method '%s'", "GetCacheDirectory");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GetCacheDirectoryRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "GetCacheDirectory", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< GetCacheDirectoryRequest > payload = ::boost::static_pointer_cast<GetCacheDirectoryRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<FcSwUpdateSrvStub*>(getStub())->onGetCacheDirectoryRequest(payload);
            return;
        }
        case 26: {

            // method 'EnterRecoveryMode'

            LOG_DEBUG_STUB("process method '%s'", "EnterRecoveryMode");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), EnterRecoveryModeRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "EnterRecoveryMode", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< EnterRecoveryModeRequest > payload = ::boost::static_pointer_cast<EnterRecoveryModeRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<FcSwUpdateSrvStub*>(getStub())->onEnterRecoveryModeRequest(payload);
            return;
        }
        case 27: {

            // method 'VerifyChecksum'

            LOG_DEBUG_STUB("process method '%s'", "VerifyChecksum");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), VerifyChecksumRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "VerifyChecksum", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< VerifyChecksumRequest > payload = ::boost::static_pointer_cast<VerifyChecksumRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<FcSwUpdateSrvStub*>(getStub())->onVerifyChecksumRequest(payload);
            return;
        }
        case 28: {

            // method 'RegisterBgLocks'

            LOG_DEBUG_STUB("process method '%s'", "RegisterBgLocks");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RegisterBgLocksRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "RegisterBgLocks", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< RegisterBgLocksRequest > payload = ::boost::static_pointer_cast<RegisterBgLocksRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<FcSwUpdateSrvStub*>(getStub())->onRegisterBgLocksRequest(payload);
            return;
        }
        default:
            break;
        }
    }
    LOG_FATAL_STUB("can't process message %s", message.getMemberName().c_str());
}

const char* FcSwUpdateSrvStubDelegate::introspect() const {
    return     "<interface name=\"fcswupdatesrv.FcSwUpdateSrv\">\n"
            "    <property access=\"readwrite\" name=\"UpdateState\" type=\"(ssusuuubbbbbbbss)\"/>\n"
            "    <property access=\"readwrite\" name=\"UpdateSources\" type=\"(a(ssub))\"/>\n"
            "    <property access=\"readwrite\" name=\"ReleaseFilter\" type=\"(u)\"/>\n"
            "    <property access=\"readwrite\" name=\"ReleaseDoc\" type=\"(suuuubba(sa(ssa(sbssstuay)u)u)a(su))\"/>\n"
            "    <property access=\"readwrite\" name=\"PreReleaseDoc\" type=\"(b)\"/>\n"
            "    <property access=\"readwrite\" name=\"UpdateProgress\" type=\"(sssssssssuuuuuuuyyyuuu)\"/>\n"
            "    <property access=\"readwrite\" name=\"UpdateResult\" type=\"(bs(qyyyyut)ua(sa(ssa(sbssstuay)u)u))\"/>\n"
            "    <property access=\"readwrite\" name=\"UpdateErrors\" type=\"(au)\"/>\n"
            "    <property access=\"readwrite\" name=\"CustomerUpdates\" type=\"(bba(sssb))\"/>\n"
            "    <property access=\"readwrite\" name=\"VersionBackDocInfo\" type=\"(qb)\"/>\n"
            "    <property access=\"readwrite\" name=\"AvailableCustomerUpdates\" type=\"(ua(sssb))\"/>\n"
            "    <property access=\"readwrite\" name=\"UpdateBgImageInfo\" type=\"(ss)\"/>\n"
            "    <property access=\"readwrite\" name=\"BgLocksState\" type=\"((as)(as))\"/>\n"
            "    <method name=\"StoreHistoryToStick\">\n"
            "      <arg direction=\"in\" name=\"sinceFactoryReset\" type=\"b\">\n"
            "        <doc>\n"
            "          <line>sinceFactoryReset = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"writeToAllSticks\" type=\"b\">\n"
            "        <doc>\n"
            "          <line>writeToAllSticks = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"bOk\" type=\"b\">\n"
            "        <doc>\n"
            "          <line>bOk = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"enResult\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>enResult = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"UpdateEnter\">\n"
            "      <arg direction=\"in\" name=\"enUser\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>enUser = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"bOk\" type=\"b\">\n"
            "        <doc>\n"
            "          <line>bOk = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"UpdateSetReleaseFilter\">\n"
            "      <arg direction=\"in\" name=\"filter\" type=\"(u)\">\n"
            "        <doc>\n"
            "          <line>filter = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"bOk\" type=\"b\">\n"
            "        <doc>\n"
            "          <line>bOk = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"resFilter\" type=\"(u)\">\n"
            "        <doc>\n"
            "          <line>resFilter = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"UpdateGetSources\">\n"
            "      <arg direction=\"out\" name=\"bOk\" type=\"b\">\n"
            "        <doc>\n"
            "          <line>bOk = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"sources\" type=\"(a(ssub))\">\n"
            "        <doc>\n"
            "          <line>sources = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"UpdateSelectSource\">\n"
            "      <arg direction=\"in\" name=\"sourceIndex\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>sourceIndex = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"bOk\" type=\"b\">\n"
            "        <doc>\n"
            "          <line>bOk = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"releaseInfos\" type=\"(ua(ss))\">\n"
            "        <doc>\n"
            "          <line>releaseInfos = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"UpdateSelectRelease\">\n"
            "      <arg direction=\"in\" name=\"releaseIndex\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>releaseIndex = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"bOk\" type=\"b\">\n"
            "        <doc>\n"
            "          <line>bOk = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"enErrorId\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>enErrorId = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"GetDeviceStateList\">\n"
            "      <arg direction=\"out\" name=\"bOk\" type=\"b\">\n"
            "        <doc>\n"
            "          <line>bOk = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"deviceStates\" type=\"(a(sssb))\">\n"
            "        <doc>\n"
            "          <line>deviceStates = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"SetUpdateOptions\">\n"
            "      <arg direction=\"in\" name=\"enOption\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>enOption = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"bOk\" type=\"b\">\n"
            "        <doc>\n"
            "          <line>bOk = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"enOptionRes\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>enOptionRes = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"ModifyReleaseDoc\">\n"
            "      <arg direction=\"in\" name=\"enModifyAction\" type=\"(uuuu)\">\n"
            "        <doc>\n"
            "          <line>enModifyAction = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"bOk\" type=\"b\">\n"
            "        <doc>\n"
            "          <line>bOk = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"enModifyActionRes\" type=\"(uuuu)\">\n"
            "        <doc>\n"
            "          <line>enModifyActionRes = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"GetUpdateFile\">\n"
            "      <arg direction=\"out\" name=\"bOk\" type=\"b\">\n"
            "        <doc>\n"
            "          <line>bOk = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"enResult\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>enResult = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"ApplyDoc\">\n"
            "      <arg direction=\"out\" name=\"bOk\" type=\"b\">\n"
            "        <doc>\n"
            "          <line>bOk = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"ApplyLock\">\n"
            "      <arg direction=\"out\" name=\"bOk\" type=\"b\">\n"
            "        <doc>\n"
            "          <line>bOk = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"UpdateSelectReleaseByFile\">\n"
            "      <arg direction=\"in\" name=\"releaseAccess\" type=\"(sssb(u)ubb)\">\n"
            "        <doc>\n"
            "          <line>releaseAccess = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"bOk\" type=\"b\">\n"
            "        <doc>\n"
            "          <line>bOk = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"enErrorId\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>enErrorId = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"RetryFailedModules\">\n"
            "      <arg direction=\"out\" name=\"bOk\" type=\"b\">\n"
            "        <doc>\n"
            "          <line>bOk = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"UpdateEnd\">\n"
            "      <arg direction=\"out\" name=\"bOk\" type=\"b\">\n"
            "        <doc>\n"
            "          <line>bOk = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"UpdateAbort\">\n"
            "      <arg direction=\"in\" name=\"bDeviceOnly\" type=\"b\">\n"
            "        <doc>\n"
            "          <line>bDeviceOnly = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"bOk\" type=\"b\">\n"
            "        <doc>\n"
            "          <line>bOk = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"UpdateAbortDevice\">\n"
            "      <arg direction=\"in\" name=\"refKey\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>refKey = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"bOk\" type=\"b\">\n"
            "        <doc>\n"
            "          <line>bOk = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"rAbortDeviceRes\" type=\"(bs)\">\n"
            "        <doc>\n"
            "          <line>rAbortDeviceRes = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"HandleError\">\n"
            "      <arg direction=\"in\" name=\"enMode\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>enMode = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"bOk\" type=\"b\">\n"
            "        <doc>\n"
            "          <line>bOk = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"GetUpdateHistory\">\n"
            "      <arg direction=\"out\" name=\"bOk\" type=\"b\">\n"
            "        <doc>\n"
            "          <line>bOk = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"logs\" type=\"(a(s(qyyyyut)sa(sa(ssa(sbssstuay)u)u)tbuu))\">\n"
            "        <doc>\n"
            "          <line>logs = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"GetUpdateHistoryScoped\">\n"
            "      <arg direction=\"in\" name=\"enScope\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>enScope = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"indexStart\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>indexStart = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"numEntriesMax\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>numEntriesMax = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"bOk\" type=\"b\">\n"
            "        <doc>\n"
            "          <line>bOk = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"enScopeRes\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>enScopeRes = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"logs\" type=\"(a(s(qyyyyut)sa(sa(ssa(sbssstuay)u)u)tbuu))\">\n"
            "        <doc>\n"
            "          <line>logs = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"numberOfUpdates\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>numberOfUpdates = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"numberOfUpdatesSinceDelivery\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>numberOfUpdatesSinceDelivery = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"numberOfUpateLogs\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>numberOfUpateLogs = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"GetUpdateHistoryDetailed\">\n"
            "      <arg direction=\"in\" name=\"request\" type=\"(uuuu)\">\n"
            "        <doc>\n"
            "          <line>request = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"bOk\" type=\"b\">\n"
            "        <doc>\n"
            "          <line>bOk = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"result\" type=\"(u(a(s(qyyyyut)sa(sa(ssa(sbssstuay)u)u)tbuu))uuuu)\">\n"
            "        <doc>\n"
            "          <line>result = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"DeleteHistoryRequest\">\n"
            "      <arg direction=\"in\" name=\"sinceFactoryResetOnly\" type=\"b\">\n"
            "        <doc>\n"
            "          <line>sinceFactoryResetOnly = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"bOk\" type=\"b\">\n"
            "        <doc>\n"
            "          <line>bOk = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"GetTargetState\">\n"
            "      <arg direction=\"in\" name=\"enUpdateType\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>enUpdateType = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"bOk\" type=\"b\">\n"
            "        <doc>\n"
            "          <line>bOk = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"targetState\" type=\"(usa(sa(ssa(sbssstuay)u)u))\">\n"
            "        <doc>\n"
            "          <line>targetState = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"SetVersionBackDocAck\">\n"
            "      <arg direction=\"in\" name=\"ack\" type=\"q\">\n"
            "        <doc>\n"
            "          <line>ack = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"bOk\" type=\"b\">\n"
            "        <doc>\n"
            "          <line>bOk = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"info\" type=\"(qb)\">\n"
            "        <doc>\n"
            "          <line>info = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"SetAllowRecoveryMode\">\n"
            "      <arg direction=\"in\" name=\"allow\" type=\"b\">\n"
            "        <doc>\n"
            "          <line>allow = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"bOk\" type=\"b\">\n"
            "        <doc>\n"
            "          <line>bOk = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"GetCacheDirectory\">\n"
            "      <doc>\n"
            "        <line>GetCacheDirectory = Request for a directory to store cache-data</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"request\" type=\"(u)\">\n"
            "        <doc>\n"
            "          <line>request = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"bOk\" type=\"b\">\n"
            "        <doc>\n"
            "          <line>bOk = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"directory\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>directory = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"EnterRecoveryMode\">\n"
            "      <arg direction=\"out\" name=\"bOk\" type=\"b\">\n"
            "        <doc>\n"
            "          <line>bOk = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"VerifyChecksum\">\n"
            "      <arg direction=\"in\" name=\"verifyRequest\" type=\"(us)\">\n"
            "        <doc>\n"
            "          <line>verifyRequest = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"bOk\" type=\"b\">\n"
            "        <doc>\n"
            "          <line>bOk = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"verifyResult\" type=\"(ussu)\">\n"
            "        <doc>\n"
            "          <line>verifyResult = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"RegisterBgLocks\">\n"
            "      <doc>\n"
            "        <line>RegisterBgLocks = User configures, which bg-locks will be requested before passing them</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"locks\" type=\"(as)\">\n"
            "        <doc>\n"
            "          <line>locks = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"mode\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>mode (of type tenLockRegisterMode) = Description missing</line>\n"
            "          <line>enum[Overwrite (0), Add (1), Remove (2)]</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"bOk\" type=\"b\">\n"
            "        <doc>\n"
            "          <line>bOk = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "</interface>\n";
}

void FcSwUpdateSrvStubDelegate::getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) {
    (static_cast<FcSwUpdateSrvStub*>(getStub()))->onGetAll (properties);
}

void FcSwUpdateSrvStubDelegate::setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act) {
    unsigned int propertyIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (property.c_str(), property.length(), propertiesTable, 13, propertyIndex)) {
        switch (propertyIndex) {
        case 0: {
            LOG_DEBUG_STUB("process property '%s'", "UpdateState");
            ::boost::shared_ptr< UpdateStateSet > payload(new UpdateStateSet());
            payload->setAct(act);
            deserializeDBus(const_cast< ::asf::dbus::DBusVariant& >(value).getReadIterator(), *payload);
            static_cast<FcSwUpdateSrvStub*>(getStub())->onUpdateStateSet (payload);
            return;
        }
        case 1: {
            LOG_DEBUG_STUB("process property '%s'", "UpdateSources");
            ::boost::shared_ptr< UpdateSourcesSet > payload(new UpdateSourcesSet());
            payload->setAct(act);
            deserializeDBus(const_cast< ::asf::dbus::DBusVariant& >(value).getReadIterator(), *payload);
            static_cast<FcSwUpdateSrvStub*>(getStub())->onUpdateSourcesSet (payload);
            return;
        }
        case 2: {
            LOG_DEBUG_STUB("process property '%s'", "ReleaseFilter");
            ::boost::shared_ptr< ReleaseFilterSet > payload(new ReleaseFilterSet());
            payload->setAct(act);
            deserializeDBus(const_cast< ::asf::dbus::DBusVariant& >(value).getReadIterator(), *payload);
            static_cast<FcSwUpdateSrvStub*>(getStub())->onReleaseFilterSet (payload);
            return;
        }
        case 3: {
            LOG_DEBUG_STUB("process property '%s'", "ReleaseDoc");
            ::boost::shared_ptr< ReleaseDocSet > payload(new ReleaseDocSet());
            payload->setAct(act);
            deserializeDBus(const_cast< ::asf::dbus::DBusVariant& >(value).getReadIterator(), *payload);
            static_cast<FcSwUpdateSrvStub*>(getStub())->onReleaseDocSet (payload);
            return;
        }
        case 4: {
            LOG_DEBUG_STUB("process property '%s'", "PreReleaseDoc");
            ::boost::shared_ptr< PreReleaseDocSet > payload(new PreReleaseDocSet());
            payload->setAct(act);
            deserializeDBus(const_cast< ::asf::dbus::DBusVariant& >(value).getReadIterator(), *payload);
            static_cast<FcSwUpdateSrvStub*>(getStub())->onPreReleaseDocSet (payload);
            return;
        }
        case 5: {
            LOG_DEBUG_STUB("process property '%s'", "UpdateProgress");
            ::boost::shared_ptr< UpdateProgressSet > payload(new UpdateProgressSet());
            payload->setAct(act);
            deserializeDBus(const_cast< ::asf::dbus::DBusVariant& >(value).getReadIterator(), *payload);
            static_cast<FcSwUpdateSrvStub*>(getStub())->onUpdateProgressSet (payload);
            return;
        }
        case 6: {
            LOG_DEBUG_STUB("process property '%s'", "UpdateResult");
            ::boost::shared_ptr< UpdateResultSet > payload(new UpdateResultSet());
            payload->setAct(act);
            deserializeDBus(const_cast< ::asf::dbus::DBusVariant& >(value).getReadIterator(), *payload);
            static_cast<FcSwUpdateSrvStub*>(getStub())->onUpdateResultSet (payload);
            return;
        }
        case 7: {
            LOG_DEBUG_STUB("process property '%s'", "UpdateErrors");
            ::boost::shared_ptr< UpdateErrorsSet > payload(new UpdateErrorsSet());
            payload->setAct(act);
            deserializeDBus(const_cast< ::asf::dbus::DBusVariant& >(value).getReadIterator(), *payload);
            static_cast<FcSwUpdateSrvStub*>(getStub())->onUpdateErrorsSet (payload);
            return;
        }
        case 8: {
            LOG_DEBUG_STUB("process property '%s'", "CustomerUpdates");
            ::boost::shared_ptr< CustomerUpdatesSet > payload(new CustomerUpdatesSet());
            payload->setAct(act);
            deserializeDBus(const_cast< ::asf::dbus::DBusVariant& >(value).getReadIterator(), *payload);
            static_cast<FcSwUpdateSrvStub*>(getStub())->onCustomerUpdatesSet (payload);
            return;
        }
        case 9: {
            LOG_DEBUG_STUB("process property '%s'", "VersionBackDocInfo");
            ::boost::shared_ptr< VersionBackDocInfoSet > payload(new VersionBackDocInfoSet());
            payload->setAct(act);
            deserializeDBus(const_cast< ::asf::dbus::DBusVariant& >(value).getReadIterator(), *payload);
            static_cast<FcSwUpdateSrvStub*>(getStub())->onVersionBackDocInfoSet (payload);
            return;
        }
        case 10: {
            LOG_DEBUG_STUB("process property '%s'", "AvailableCustomerUpdates");
            ::boost::shared_ptr< AvailableCustomerUpdatesSet > payload(new AvailableCustomerUpdatesSet());
            payload->setAct(act);
            deserializeDBus(const_cast< ::asf::dbus::DBusVariant& >(value).getReadIterator(), *payload);
            static_cast<FcSwUpdateSrvStub*>(getStub())->onAvailableCustomerUpdatesSet (payload);
            return;
        }
        case 11: {
            LOG_DEBUG_STUB("process property '%s'", "UpdateBgImageInfo");
            ::boost::shared_ptr< UpdateBgImageInfoSet > payload(new UpdateBgImageInfoSet());
            payload->setAct(act);
            deserializeDBus(const_cast< ::asf::dbus::DBusVariant& >(value).getReadIterator(), *payload);
            static_cast<FcSwUpdateSrvStub*>(getStub())->onUpdateBgImageInfoSet (payload);
            return;
        }
        case 12: {
            LOG_DEBUG_STUB("process property '%s'", "BgLocksState");
            ::boost::shared_ptr< BgLocksStateSet > payload(new BgLocksStateSet());
            payload->setAct(act);
            deserializeDBus(const_cast< ::asf::dbus::DBusVariant& >(value).getReadIterator(), *payload);
            static_cast<FcSwUpdateSrvStub*>(getStub())->onBgLocksStateSet (payload);
            return;
        }
        default:
            break;
        }
    }
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendSetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

void FcSwUpdateSrvStubDelegate::getProperty(const ::std::string& property, const act_t& act) {
    unsigned int propertyIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (property.c_str(), property.length(), propertiesTable, 13, propertyIndex)) {
        switch (propertyIndex) {
        case 0: {
            LOG_DEBUG_STUB("process property '%s'", "UpdateState");
            ::boost::shared_ptr< UpdateStateGet > payload(new UpdateStateGet());
            payload->setAct(act);
            static_cast<FcSwUpdateSrvStub*>(getStub())->onUpdateStateGet (payload);
            return;
        }
        case 1: {
            LOG_DEBUG_STUB("process property '%s'", "UpdateSources");
            ::boost::shared_ptr< UpdateSourcesGet > payload(new UpdateSourcesGet());
            payload->setAct(act);
            static_cast<FcSwUpdateSrvStub*>(getStub())->onUpdateSourcesGet (payload);
            return;
        }
        case 2: {
            LOG_DEBUG_STUB("process property '%s'", "ReleaseFilter");
            ::boost::shared_ptr< ReleaseFilterGet > payload(new ReleaseFilterGet());
            payload->setAct(act);
            static_cast<FcSwUpdateSrvStub*>(getStub())->onReleaseFilterGet (payload);
            return;
        }
        case 3: {
            LOG_DEBUG_STUB("process property '%s'", "ReleaseDoc");
            ::boost::shared_ptr< ReleaseDocGet > payload(new ReleaseDocGet());
            payload->setAct(act);
            static_cast<FcSwUpdateSrvStub*>(getStub())->onReleaseDocGet (payload);
            return;
        }
        case 4: {
            LOG_DEBUG_STUB("process property '%s'", "PreReleaseDoc");
            ::boost::shared_ptr< PreReleaseDocGet > payload(new PreReleaseDocGet());
            payload->setAct(act);
            static_cast<FcSwUpdateSrvStub*>(getStub())->onPreReleaseDocGet (payload);
            return;
        }
        case 5: {
            LOG_DEBUG_STUB("process property '%s'", "UpdateProgress");
            ::boost::shared_ptr< UpdateProgressGet > payload(new UpdateProgressGet());
            payload->setAct(act);
            static_cast<FcSwUpdateSrvStub*>(getStub())->onUpdateProgressGet (payload);
            return;
        }
        case 6: {
            LOG_DEBUG_STUB("process property '%s'", "UpdateResult");
            ::boost::shared_ptr< UpdateResultGet > payload(new UpdateResultGet());
            payload->setAct(act);
            static_cast<FcSwUpdateSrvStub*>(getStub())->onUpdateResultGet (payload);
            return;
        }
        case 7: {
            LOG_DEBUG_STUB("process property '%s'", "UpdateErrors");
            ::boost::shared_ptr< UpdateErrorsGet > payload(new UpdateErrorsGet());
            payload->setAct(act);
            static_cast<FcSwUpdateSrvStub*>(getStub())->onUpdateErrorsGet (payload);
            return;
        }
        case 8: {
            LOG_DEBUG_STUB("process property '%s'", "CustomerUpdates");
            ::boost::shared_ptr< CustomerUpdatesGet > payload(new CustomerUpdatesGet());
            payload->setAct(act);
            static_cast<FcSwUpdateSrvStub*>(getStub())->onCustomerUpdatesGet (payload);
            return;
        }
        case 9: {
            LOG_DEBUG_STUB("process property '%s'", "VersionBackDocInfo");
            ::boost::shared_ptr< VersionBackDocInfoGet > payload(new VersionBackDocInfoGet());
            payload->setAct(act);
            static_cast<FcSwUpdateSrvStub*>(getStub())->onVersionBackDocInfoGet (payload);
            return;
        }
        case 10: {
            LOG_DEBUG_STUB("process property '%s'", "AvailableCustomerUpdates");
            ::boost::shared_ptr< AvailableCustomerUpdatesGet > payload(new AvailableCustomerUpdatesGet());
            payload->setAct(act);
            static_cast<FcSwUpdateSrvStub*>(getStub())->onAvailableCustomerUpdatesGet (payload);
            return;
        }
        case 11: {
            LOG_DEBUG_STUB("process property '%s'", "UpdateBgImageInfo");
            ::boost::shared_ptr< UpdateBgImageInfoGet > payload(new UpdateBgImageInfoGet());
            payload->setAct(act);
            static_cast<FcSwUpdateSrvStub*>(getStub())->onUpdateBgImageInfoGet (payload);
            return;
        }
        case 12: {
            LOG_DEBUG_STUB("process property '%s'", "BgLocksState");
            ::boost::shared_ptr< BgLocksStateGet > payload(new BgLocksStateGet());
            payload->setAct(act);
            static_cast<FcSwUpdateSrvStub*>(getStub())->onBgLocksStateGet (payload);
            return;
        }
        default:
            break;
        }
    }
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendGetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

FcSwUpdateSrvStub::FcSwUpdateSrvStub (const std::string& portName) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new FcSwUpdateSrvStubDelegate(this, _logger);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

FcSwUpdateSrvStub::FcSwUpdateSrvStub (const std::string& portName, const std::string& objectPath) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new FcSwUpdateSrvStubDelegate(this, _logger, objectPath);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

FcSwUpdateSrvStub::~FcSwUpdateSrvStub() {
    delete _stubDelegate;
}

void FcSwUpdateSrvStub::sendUpdateStateUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        UpdateStateUpdate payload(_UpdateStateProperty);

        LOG_INFO ("-> send%s", "UpdateStateUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("UpdateState", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("fcswupdatesrv.FcSwUpdateSrv", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "UpdateStateUpdate");
    }
}

void FcSwUpdateSrvStub::onUpdateStateGet(const ::boost::shared_ptr< UpdateStateGet >& updateState) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "UpdateStateGet", updateState->getAct());
    sendUpdateStateGetUpdate(_UpdateStateProperty.getUpdateState(), updateState->getAct());
}

void FcSwUpdateSrvStub::sendUpdateStateGetUpdate(const trUpdState& updateState, act_t act) {
    ::asf::dbus::DBusVariant variant;
    UpdateStateGet payload(updateState);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "UpdateStateGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void FcSwUpdateSrvStub::onUpdateStateSet(const ::boost::shared_ptr< UpdateStateSet >& updateState) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "UpdateStateSet", updateState->getAct());
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(*updateState, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }
    setUpdateState (updateState->getUpdateState());
    sendUpdateStateSetUpdate(updateState->getAct());
}

void FcSwUpdateSrvStub::sendUpdateStateSetUpdate(act_t act) {
    LOG_INFO ("-> send%s, act=%" PRIuPTR, "UpdateStateSetUpdate", act);
    _stubDelegate->sendSetResponse(act);
}

void FcSwUpdateSrvStub::setUpdateState(const trUpdState& updateState) {
    if(updateState!=_UpdateStateProperty.getUpdateState()) {
        _UpdateStateProperty.setUpdateState(updateState);
        sendUpdateStateUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const trUpdState& FcSwUpdateSrvStub::getUpdateState() const {
    return _UpdateStateProperty.getUpdateState();
}

trUpdState& FcSwUpdateSrvStub::getUpdateStateMutable() {
    return _UpdateStateProperty.getUpdateStateMutable();
}

void FcSwUpdateSrvStub::sendUpdateSourcesUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        UpdateSourcesUpdate payload(_UpdateSourcesProperty);

        LOG_INFO ("-> send%s", "UpdateSourcesUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("UpdateSources", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("fcswupdatesrv.FcSwUpdateSrv", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "UpdateSourcesUpdate");
    }
}

void FcSwUpdateSrvStub::onUpdateSourcesGet(const ::boost::shared_ptr< UpdateSourcesGet >& updateSources) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "UpdateSourcesGet", updateSources->getAct());
    sendUpdateSourcesGetUpdate(_UpdateSourcesProperty.getUpdateSources(), updateSources->getAct());
}

void FcSwUpdateSrvStub::sendUpdateSourcesGetUpdate(const trUpdSources& updateSources, act_t act) {
    ::asf::dbus::DBusVariant variant;
    UpdateSourcesGet payload(updateSources);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "UpdateSourcesGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void FcSwUpdateSrvStub::onUpdateSourcesSet(const ::boost::shared_ptr< UpdateSourcesSet >& updateSources) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "UpdateSourcesSet", updateSources->getAct());
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(*updateSources, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }
    setUpdateSources (updateSources->getUpdateSources());
    sendUpdateSourcesSetUpdate(updateSources->getAct());
}

void FcSwUpdateSrvStub::sendUpdateSourcesSetUpdate(act_t act) {
    LOG_INFO ("-> send%s, act=%" PRIuPTR, "UpdateSourcesSetUpdate", act);
    _stubDelegate->sendSetResponse(act);
}

void FcSwUpdateSrvStub::setUpdateSources(const trUpdSources& updateSources) {
    if(updateSources!=_UpdateSourcesProperty.getUpdateSources()) {
        _UpdateSourcesProperty.setUpdateSources(updateSources);
        sendUpdateSourcesUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const trUpdSources& FcSwUpdateSrvStub::getUpdateSources() const {
    return _UpdateSourcesProperty.getUpdateSources();
}

trUpdSources& FcSwUpdateSrvStub::getUpdateSourcesMutable() {
    return _UpdateSourcesProperty.getUpdateSourcesMutable();
}

void FcSwUpdateSrvStub::sendReleaseFilterUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        ReleaseFilterUpdate payload(_ReleaseFilterProperty);

        LOG_INFO ("-> send%s", "ReleaseFilterUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("ReleaseFilter", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("fcswupdatesrv.FcSwUpdateSrv", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "ReleaseFilterUpdate");
    }
}

void FcSwUpdateSrvStub::onReleaseFilterGet(const ::boost::shared_ptr< ReleaseFilterGet >& releaseFilter) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "ReleaseFilterGet", releaseFilter->getAct());
    sendReleaseFilterGetUpdate(_ReleaseFilterProperty.getReleaseFilter(), releaseFilter->getAct());
}

void FcSwUpdateSrvStub::sendReleaseFilterGetUpdate(const trReleaseFilter& releaseFilter, act_t act) {
    ::asf::dbus::DBusVariant variant;
    ReleaseFilterGet payload(releaseFilter);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "ReleaseFilterGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void FcSwUpdateSrvStub::onReleaseFilterSet(const ::boost::shared_ptr< ReleaseFilterSet >& releaseFilter) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "ReleaseFilterSet", releaseFilter->getAct());
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(*releaseFilter, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }
    setReleaseFilter (releaseFilter->getReleaseFilter());
    sendReleaseFilterSetUpdate(releaseFilter->getAct());
}

void FcSwUpdateSrvStub::sendReleaseFilterSetUpdate(act_t act) {
    LOG_INFO ("-> send%s, act=%" PRIuPTR, "ReleaseFilterSetUpdate", act);
    _stubDelegate->sendSetResponse(act);
}

void FcSwUpdateSrvStub::setReleaseFilter(const trReleaseFilter& releaseFilter) {
    if(releaseFilter!=_ReleaseFilterProperty.getReleaseFilter()) {
        _ReleaseFilterProperty.setReleaseFilter(releaseFilter);
        sendReleaseFilterUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const trReleaseFilter& FcSwUpdateSrvStub::getReleaseFilter() const {
    return _ReleaseFilterProperty.getReleaseFilter();
}

trReleaseFilter& FcSwUpdateSrvStub::getReleaseFilterMutable() {
    return _ReleaseFilterProperty.getReleaseFilterMutable();
}

void FcSwUpdateSrvStub::sendReleaseDocUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        ReleaseDocUpdate payload(_ReleaseDocProperty);

        LOG_INFO ("-> send%s", "ReleaseDocUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("ReleaseDoc", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("fcswupdatesrv.FcSwUpdateSrv", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "ReleaseDocUpdate");
    }
}

void FcSwUpdateSrvStub::onReleaseDocGet(const ::boost::shared_ptr< ReleaseDocGet >& releaseDoc) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "ReleaseDocGet", releaseDoc->getAct());
    sendReleaseDocGetUpdate(_ReleaseDocProperty.getReleaseDoc(), releaseDoc->getAct());
}

void FcSwUpdateSrvStub::sendReleaseDocGetUpdate(const trReleaseDoc& releaseDoc, act_t act) {
    ::asf::dbus::DBusVariant variant;
    ReleaseDocGet payload(releaseDoc);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "ReleaseDocGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void FcSwUpdateSrvStub::onReleaseDocSet(const ::boost::shared_ptr< ReleaseDocSet >& releaseDoc) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "ReleaseDocSet", releaseDoc->getAct());
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(*releaseDoc, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }
    setReleaseDoc (releaseDoc->getReleaseDoc());
    sendReleaseDocSetUpdate(releaseDoc->getAct());
}

void FcSwUpdateSrvStub::sendReleaseDocSetUpdate(act_t act) {
    LOG_INFO ("-> send%s, act=%" PRIuPTR, "ReleaseDocSetUpdate", act);
    _stubDelegate->sendSetResponse(act);
}

void FcSwUpdateSrvStub::setReleaseDoc(const trReleaseDoc& releaseDoc) {
    if(releaseDoc!=_ReleaseDocProperty.getReleaseDoc()) {
        _ReleaseDocProperty.setReleaseDoc(releaseDoc);
        sendReleaseDocUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const trReleaseDoc& FcSwUpdateSrvStub::getReleaseDoc() const {
    return _ReleaseDocProperty.getReleaseDoc();
}

trReleaseDoc& FcSwUpdateSrvStub::getReleaseDocMutable() {
    return _ReleaseDocProperty.getReleaseDocMutable();
}

void FcSwUpdateSrvStub::sendPreReleaseDocUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        PreReleaseDocUpdate payload(_PreReleaseDocProperty);

        LOG_INFO ("-> send%s", "PreReleaseDocUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("PreReleaseDoc", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("fcswupdatesrv.FcSwUpdateSrv", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "PreReleaseDocUpdate");
    }
}

void FcSwUpdateSrvStub::onPreReleaseDocGet(const ::boost::shared_ptr< PreReleaseDocGet >& preReleaseDoc) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "PreReleaseDocGet", preReleaseDoc->getAct());
    sendPreReleaseDocGetUpdate(_PreReleaseDocProperty.getPreReleaseDoc(), preReleaseDoc->getAct());
}

void FcSwUpdateSrvStub::sendPreReleaseDocGetUpdate(const trPreReleaseDoc& preReleaseDoc, act_t act) {
    ::asf::dbus::DBusVariant variant;
    PreReleaseDocGet payload(preReleaseDoc);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "PreReleaseDocGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void FcSwUpdateSrvStub::onPreReleaseDocSet(const ::boost::shared_ptr< PreReleaseDocSet >& preReleaseDoc) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "PreReleaseDocSet", preReleaseDoc->getAct());
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(*preReleaseDoc, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }
    setPreReleaseDoc (preReleaseDoc->getPreReleaseDoc());
    sendPreReleaseDocSetUpdate(preReleaseDoc->getAct());
}

void FcSwUpdateSrvStub::sendPreReleaseDocSetUpdate(act_t act) {
    LOG_INFO ("-> send%s, act=%" PRIuPTR, "PreReleaseDocSetUpdate", act);
    _stubDelegate->sendSetResponse(act);
}

void FcSwUpdateSrvStub::setPreReleaseDoc(const trPreReleaseDoc& preReleaseDoc) {
    if(preReleaseDoc!=_PreReleaseDocProperty.getPreReleaseDoc()) {
        _PreReleaseDocProperty.setPreReleaseDoc(preReleaseDoc);
        sendPreReleaseDocUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const trPreReleaseDoc& FcSwUpdateSrvStub::getPreReleaseDoc() const {
    return _PreReleaseDocProperty.getPreReleaseDoc();
}

trPreReleaseDoc& FcSwUpdateSrvStub::getPreReleaseDocMutable() {
    return _PreReleaseDocProperty.getPreReleaseDocMutable();
}

void FcSwUpdateSrvStub::sendUpdateProgressUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        UpdateProgressUpdate payload(_UpdateProgressProperty);

        LOG_INFO ("-> send%s", "UpdateProgressUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("UpdateProgress", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("fcswupdatesrv.FcSwUpdateSrv", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "UpdateProgressUpdate");
    }
}

void FcSwUpdateSrvStub::onUpdateProgressGet(const ::boost::shared_ptr< UpdateProgressGet >& updateProgress) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "UpdateProgressGet", updateProgress->getAct());
    sendUpdateProgressGetUpdate(_UpdateProgressProperty.getUpdateProgress(), updateProgress->getAct());
}

void FcSwUpdateSrvStub::sendUpdateProgressGetUpdate(const trUpdProgress& updateProgress, act_t act) {
    ::asf::dbus::DBusVariant variant;
    UpdateProgressGet payload(updateProgress);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "UpdateProgressGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void FcSwUpdateSrvStub::onUpdateProgressSet(const ::boost::shared_ptr< UpdateProgressSet >& updateProgress) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "UpdateProgressSet", updateProgress->getAct());
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(*updateProgress, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }
    setUpdateProgress (updateProgress->getUpdateProgress());
    sendUpdateProgressSetUpdate(updateProgress->getAct());
}

void FcSwUpdateSrvStub::sendUpdateProgressSetUpdate(act_t act) {
    LOG_INFO ("-> send%s, act=%" PRIuPTR, "UpdateProgressSetUpdate", act);
    _stubDelegate->sendSetResponse(act);
}

void FcSwUpdateSrvStub::setUpdateProgress(const trUpdProgress& updateProgress) {
    if(updateProgress!=_UpdateProgressProperty.getUpdateProgress()) {
        _UpdateProgressProperty.setUpdateProgress(updateProgress);
        sendUpdateProgressUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const trUpdProgress& FcSwUpdateSrvStub::getUpdateProgress() const {
    return _UpdateProgressProperty.getUpdateProgress();
}

trUpdProgress& FcSwUpdateSrvStub::getUpdateProgressMutable() {
    return _UpdateProgressProperty.getUpdateProgressMutable();
}

void FcSwUpdateSrvStub::sendUpdateResultUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        UpdateResultUpdate payload(_UpdateResultProperty);

        LOG_INFO ("-> send%s", "UpdateResultUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("UpdateResult", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("fcswupdatesrv.FcSwUpdateSrv", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "UpdateResultUpdate");
    }
}

void FcSwUpdateSrvStub::onUpdateResultGet(const ::boost::shared_ptr< UpdateResultGet >& updateResult) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "UpdateResultGet", updateResult->getAct());
    sendUpdateResultGetUpdate(_UpdateResultProperty.getUpdateResult(), updateResult->getAct());
}

void FcSwUpdateSrvStub::sendUpdateResultGetUpdate(const trResult& updateResult, act_t act) {
    ::asf::dbus::DBusVariant variant;
    UpdateResultGet payload(updateResult);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "UpdateResultGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void FcSwUpdateSrvStub::onUpdateResultSet(const ::boost::shared_ptr< UpdateResultSet >& updateResult) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "UpdateResultSet", updateResult->getAct());
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(*updateResult, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }
    setUpdateResult (updateResult->getUpdateResult());
    sendUpdateResultSetUpdate(updateResult->getAct());
}

void FcSwUpdateSrvStub::sendUpdateResultSetUpdate(act_t act) {
    LOG_INFO ("-> send%s, act=%" PRIuPTR, "UpdateResultSetUpdate", act);
    _stubDelegate->sendSetResponse(act);
}

void FcSwUpdateSrvStub::setUpdateResult(const trResult& updateResult) {
    if(updateResult!=_UpdateResultProperty.getUpdateResult()) {
        _UpdateResultProperty.setUpdateResult(updateResult);
        sendUpdateResultUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const trResult& FcSwUpdateSrvStub::getUpdateResult() const {
    return _UpdateResultProperty.getUpdateResult();
}

trResult& FcSwUpdateSrvStub::getUpdateResultMutable() {
    return _UpdateResultProperty.getUpdateResultMutable();
}

void FcSwUpdateSrvStub::sendUpdateErrorsUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        UpdateErrorsUpdate payload(_UpdateErrorsProperty);

        LOG_INFO ("-> send%s", "UpdateErrorsUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("UpdateErrors", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("fcswupdatesrv.FcSwUpdateSrv", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "UpdateErrorsUpdate");
    }
}

void FcSwUpdateSrvStub::onUpdateErrorsGet(const ::boost::shared_ptr< UpdateErrorsGet >& updateErrors) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "UpdateErrorsGet", updateErrors->getAct());
    sendUpdateErrorsGetUpdate(_UpdateErrorsProperty.getUpdateErrors(), updateErrors->getAct());
}

void FcSwUpdateSrvStub::sendUpdateErrorsGetUpdate(const trErrorIds& updateErrors, act_t act) {
    ::asf::dbus::DBusVariant variant;
    UpdateErrorsGet payload(updateErrors);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "UpdateErrorsGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void FcSwUpdateSrvStub::onUpdateErrorsSet(const ::boost::shared_ptr< UpdateErrorsSet >& updateErrors) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "UpdateErrorsSet", updateErrors->getAct());
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(*updateErrors, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }
    setUpdateErrors (updateErrors->getUpdateErrors());
    sendUpdateErrorsSetUpdate(updateErrors->getAct());
}

void FcSwUpdateSrvStub::sendUpdateErrorsSetUpdate(act_t act) {
    LOG_INFO ("-> send%s, act=%" PRIuPTR, "UpdateErrorsSetUpdate", act);
    _stubDelegate->sendSetResponse(act);
}

void FcSwUpdateSrvStub::setUpdateErrors(const trErrorIds& updateErrors) {
    if(updateErrors!=_UpdateErrorsProperty.getUpdateErrors()) {
        _UpdateErrorsProperty.setUpdateErrors(updateErrors);
        sendUpdateErrorsUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const trErrorIds& FcSwUpdateSrvStub::getUpdateErrors() const {
    return _UpdateErrorsProperty.getUpdateErrors();
}

trErrorIds& FcSwUpdateSrvStub::getUpdateErrorsMutable() {
    return _UpdateErrorsProperty.getUpdateErrorsMutable();
}

void FcSwUpdateSrvStub::sendCustomerUpdatesUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        CustomerUpdatesUpdate payload(_CustomerUpdatesProperty);

        LOG_INFO ("-> send%s", "CustomerUpdatesUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("CustomerUpdates", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("fcswupdatesrv.FcSwUpdateSrv", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "CustomerUpdatesUpdate");
    }
}

void FcSwUpdateSrvStub::onCustomerUpdatesGet(const ::boost::shared_ptr< CustomerUpdatesGet >& customerUpdates) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "CustomerUpdatesGet", customerUpdates->getAct());
    sendCustomerUpdatesGetUpdate(_CustomerUpdatesProperty.getCustomerUpdates(), customerUpdates->getAct());
}

void FcSwUpdateSrvStub::sendCustomerUpdatesGetUpdate(const trInstalledCustomerUpdates& customerUpdates, act_t act) {
    ::asf::dbus::DBusVariant variant;
    CustomerUpdatesGet payload(customerUpdates);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "CustomerUpdatesGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void FcSwUpdateSrvStub::onCustomerUpdatesSet(const ::boost::shared_ptr< CustomerUpdatesSet >& customerUpdates) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "CustomerUpdatesSet", customerUpdates->getAct());
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(*customerUpdates, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }
    setCustomerUpdates (customerUpdates->getCustomerUpdates());
    sendCustomerUpdatesSetUpdate(customerUpdates->getAct());
}

void FcSwUpdateSrvStub::sendCustomerUpdatesSetUpdate(act_t act) {
    LOG_INFO ("-> send%s, act=%" PRIuPTR, "CustomerUpdatesSetUpdate", act);
    _stubDelegate->sendSetResponse(act);
}

void FcSwUpdateSrvStub::setCustomerUpdates(const trInstalledCustomerUpdates& customerUpdates) {
    if(customerUpdates!=_CustomerUpdatesProperty.getCustomerUpdates()) {
        _CustomerUpdatesProperty.setCustomerUpdates(customerUpdates);
        sendCustomerUpdatesUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const trInstalledCustomerUpdates& FcSwUpdateSrvStub::getCustomerUpdates() const {
    return _CustomerUpdatesProperty.getCustomerUpdates();
}

trInstalledCustomerUpdates& FcSwUpdateSrvStub::getCustomerUpdatesMutable() {
    return _CustomerUpdatesProperty.getCustomerUpdatesMutable();
}

void FcSwUpdateSrvStub::sendVersionBackDocInfoUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        VersionBackDocInfoUpdate payload(_VersionBackDocInfoProperty);

        LOG_INFO ("-> send%s", "VersionBackDocInfoUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("VersionBackDocInfo", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("fcswupdatesrv.FcSwUpdateSrv", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "VersionBackDocInfoUpdate");
    }
}

void FcSwUpdateSrvStub::onVersionBackDocInfoGet(const ::boost::shared_ptr< VersionBackDocInfoGet >& versionBackDocInfo) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "VersionBackDocInfoGet", versionBackDocInfo->getAct());
    sendVersionBackDocInfoGetUpdate(_VersionBackDocInfoProperty.getVersionBackDocInfo(), versionBackDocInfo->getAct());
}

void FcSwUpdateSrvStub::sendVersionBackDocInfoGetUpdate(const trVersionBackDocInfo& versionBackDocInfo, act_t act) {
    ::asf::dbus::DBusVariant variant;
    VersionBackDocInfoGet payload(versionBackDocInfo);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "VersionBackDocInfoGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void FcSwUpdateSrvStub::onVersionBackDocInfoSet(const ::boost::shared_ptr< VersionBackDocInfoSet >& versionBackDocInfo) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "VersionBackDocInfoSet", versionBackDocInfo->getAct());
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(*versionBackDocInfo, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }
    setVersionBackDocInfo (versionBackDocInfo->getVersionBackDocInfo());
    sendVersionBackDocInfoSetUpdate(versionBackDocInfo->getAct());
}

void FcSwUpdateSrvStub::sendVersionBackDocInfoSetUpdate(act_t act) {
    LOG_INFO ("-> send%s, act=%" PRIuPTR, "VersionBackDocInfoSetUpdate", act);
    _stubDelegate->sendSetResponse(act);
}

void FcSwUpdateSrvStub::setVersionBackDocInfo(const trVersionBackDocInfo& versionBackDocInfo) {
    if(versionBackDocInfo!=_VersionBackDocInfoProperty.getVersionBackDocInfo()) {
        _VersionBackDocInfoProperty.setVersionBackDocInfo(versionBackDocInfo);
        sendVersionBackDocInfoUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const trVersionBackDocInfo& FcSwUpdateSrvStub::getVersionBackDocInfo() const {
    return _VersionBackDocInfoProperty.getVersionBackDocInfo();
}

trVersionBackDocInfo& FcSwUpdateSrvStub::getVersionBackDocInfoMutable() {
    return _VersionBackDocInfoProperty.getVersionBackDocInfoMutable();
}

void FcSwUpdateSrvStub::sendAvailableCustomerUpdatesUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        AvailableCustomerUpdatesUpdate payload(_AvailableCustomerUpdatesProperty);

        LOG_INFO ("-> send%s", "AvailableCustomerUpdatesUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("AvailableCustomerUpdates", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("fcswupdatesrv.FcSwUpdateSrv", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "AvailableCustomerUpdatesUpdate");
    }
}

void FcSwUpdateSrvStub::onAvailableCustomerUpdatesGet(const ::boost::shared_ptr< AvailableCustomerUpdatesGet >& availableCustomerUpdates) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "AvailableCustomerUpdatesGet", availableCustomerUpdates->getAct());
    sendAvailableCustomerUpdatesGetUpdate(_AvailableCustomerUpdatesProperty.getAvailableCustomerUpdates(), availableCustomerUpdates->getAct());
}

void FcSwUpdateSrvStub::sendAvailableCustomerUpdatesGetUpdate(const trAvailableCustomerUpdates& availableCustomerUpdates, act_t act) {
    ::asf::dbus::DBusVariant variant;
    AvailableCustomerUpdatesGet payload(availableCustomerUpdates);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "AvailableCustomerUpdatesGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void FcSwUpdateSrvStub::onAvailableCustomerUpdatesSet(const ::boost::shared_ptr< AvailableCustomerUpdatesSet >& availableCustomerUpdates) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "AvailableCustomerUpdatesSet", availableCustomerUpdates->getAct());
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(*availableCustomerUpdates, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }
    setAvailableCustomerUpdates (availableCustomerUpdates->getAvailableCustomerUpdates());
    sendAvailableCustomerUpdatesSetUpdate(availableCustomerUpdates->getAct());
}

void FcSwUpdateSrvStub::sendAvailableCustomerUpdatesSetUpdate(act_t act) {
    LOG_INFO ("-> send%s, act=%" PRIuPTR, "AvailableCustomerUpdatesSetUpdate", act);
    _stubDelegate->sendSetResponse(act);
}

void FcSwUpdateSrvStub::setAvailableCustomerUpdates(const trAvailableCustomerUpdates& availableCustomerUpdates) {
    if(availableCustomerUpdates!=_AvailableCustomerUpdatesProperty.getAvailableCustomerUpdates()) {
        _AvailableCustomerUpdatesProperty.setAvailableCustomerUpdates(availableCustomerUpdates);
        sendAvailableCustomerUpdatesUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const trAvailableCustomerUpdates& FcSwUpdateSrvStub::getAvailableCustomerUpdates() const {
    return _AvailableCustomerUpdatesProperty.getAvailableCustomerUpdates();
}

trAvailableCustomerUpdates& FcSwUpdateSrvStub::getAvailableCustomerUpdatesMutable() {
    return _AvailableCustomerUpdatesProperty.getAvailableCustomerUpdatesMutable();
}

void FcSwUpdateSrvStub::sendUpdateBgImageInfoUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        UpdateBgImageInfoUpdate payload(_UpdateBgImageInfoProperty);

        LOG_INFO ("-> send%s", "UpdateBgImageInfoUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("UpdateBgImageInfo", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("fcswupdatesrv.FcSwUpdateSrv", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "UpdateBgImageInfoUpdate");
    }
}

void FcSwUpdateSrvStub::onUpdateBgImageInfoGet(const ::boost::shared_ptr< UpdateBgImageInfoGet >& updateBgImageInfo) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "UpdateBgImageInfoGet", updateBgImageInfo->getAct());
    sendUpdateBgImageInfoGetUpdate(_UpdateBgImageInfoProperty.getUpdateBgImageInfo(), updateBgImageInfo->getAct());
}

void FcSwUpdateSrvStub::sendUpdateBgImageInfoGetUpdate(const trBgImageInfo& updateBgImageInfo, act_t act) {
    ::asf::dbus::DBusVariant variant;
    UpdateBgImageInfoGet payload(updateBgImageInfo);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "UpdateBgImageInfoGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void FcSwUpdateSrvStub::onUpdateBgImageInfoSet(const ::boost::shared_ptr< UpdateBgImageInfoSet >& updateBgImageInfo) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "UpdateBgImageInfoSet", updateBgImageInfo->getAct());
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(*updateBgImageInfo, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }
    setUpdateBgImageInfo (updateBgImageInfo->getUpdateBgImageInfo());
    sendUpdateBgImageInfoSetUpdate(updateBgImageInfo->getAct());
}

void FcSwUpdateSrvStub::sendUpdateBgImageInfoSetUpdate(act_t act) {
    LOG_INFO ("-> send%s, act=%" PRIuPTR, "UpdateBgImageInfoSetUpdate", act);
    _stubDelegate->sendSetResponse(act);
}

void FcSwUpdateSrvStub::setUpdateBgImageInfo(const trBgImageInfo& updateBgImageInfo) {
    if(updateBgImageInfo!=_UpdateBgImageInfoProperty.getUpdateBgImageInfo()) {
        _UpdateBgImageInfoProperty.setUpdateBgImageInfo(updateBgImageInfo);
        sendUpdateBgImageInfoUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const trBgImageInfo& FcSwUpdateSrvStub::getUpdateBgImageInfo() const {
    return _UpdateBgImageInfoProperty.getUpdateBgImageInfo();
}

trBgImageInfo& FcSwUpdateSrvStub::getUpdateBgImageInfoMutable() {
    return _UpdateBgImageInfoProperty.getUpdateBgImageInfoMutable();
}

void FcSwUpdateSrvStub::sendBgLocksStateUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        BgLocksStateUpdate payload(_BgLocksStateProperty);

        LOG_INFO ("-> send%s", "BgLocksStateUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("BgLocksState", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("fcswupdatesrv.FcSwUpdateSrv", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "BgLocksStateUpdate");
    }
}

void FcSwUpdateSrvStub::onBgLocksStateGet(const ::boost::shared_ptr< BgLocksStateGet >& bgLocksState) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "BgLocksStateGet", bgLocksState->getAct());
    sendBgLocksStateGetUpdate(_BgLocksStateProperty.getBgLocksState(), bgLocksState->getAct());
}

void FcSwUpdateSrvStub::sendBgLocksStateGetUpdate(const trBgLocksState& bgLocksState, act_t act) {
    ::asf::dbus::DBusVariant variant;
    BgLocksStateGet payload(bgLocksState);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "BgLocksStateGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void FcSwUpdateSrvStub::onBgLocksStateSet(const ::boost::shared_ptr< BgLocksStateSet >& bgLocksState) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "BgLocksStateSet", bgLocksState->getAct());
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(*bgLocksState, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }
    setBgLocksState (bgLocksState->getBgLocksState());
    sendBgLocksStateSetUpdate(bgLocksState->getAct());
}

void FcSwUpdateSrvStub::sendBgLocksStateSetUpdate(act_t act) {
    LOG_INFO ("-> send%s, act=%" PRIuPTR, "BgLocksStateSetUpdate", act);
    _stubDelegate->sendSetResponse(act);
}

void FcSwUpdateSrvStub::setBgLocksState(const trBgLocksState& bgLocksState) {
    if(bgLocksState!=_BgLocksStateProperty.getBgLocksState()) {
        _BgLocksStateProperty.setBgLocksState(bgLocksState);
        sendBgLocksStateUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const trBgLocksState& FcSwUpdateSrvStub::getBgLocksState() const {
    return _BgLocksStateProperty.getBgLocksState();
}

trBgLocksState& FcSwUpdateSrvStub::getBgLocksStateMutable() {
    return _BgLocksStateProperty.getBgLocksStateMutable();
}

void  FcSwUpdateSrvStub::sendStoreHistoryToStickResponse (bool bOk, tenStoreHistoryResult enResult, act_t act) {
    StoreHistoryToStickResponse* payload = new StoreHistoryToStickResponse(bOk, enResult);
    DBUS_MESSAGE_REPLY(dbusMessage, "StoreHistoryToStick", StoreHistoryToStickResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "StoreHistoryToStick", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  FcSwUpdateSrvStub::sendStoreHistoryToStickError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    StoreHistoryToStickError* payload = new StoreHistoryToStickError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "StoreHistoryToStick", StoreHistoryToStickError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "StoreHistoryToStick", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  FcSwUpdateSrvStub::sendUpdateEnterResponse (bool bOk, act_t act) {
    UpdateEnterResponse* payload = new UpdateEnterResponse(bOk);
    DBUS_MESSAGE_REPLY(dbusMessage, "UpdateEnter", UpdateEnterResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "UpdateEnter", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  FcSwUpdateSrvStub::sendUpdateEnterError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    UpdateEnterError* payload = new UpdateEnterError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "UpdateEnter", UpdateEnterError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "UpdateEnter", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  FcSwUpdateSrvStub::sendUpdateSetReleaseFilterResponse (bool bOk, const trReleaseFilter& resFilter, act_t act) {
    UpdateSetReleaseFilterResponse* payload = new UpdateSetReleaseFilterResponse(bOk, resFilter);
    DBUS_MESSAGE_REPLY(dbusMessage, "UpdateSetReleaseFilter", UpdateSetReleaseFilterResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "UpdateSetReleaseFilter", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  FcSwUpdateSrvStub::sendUpdateSetReleaseFilterError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    UpdateSetReleaseFilterError* payload = new UpdateSetReleaseFilterError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "UpdateSetReleaseFilter", UpdateSetReleaseFilterError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "UpdateSetReleaseFilter", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  FcSwUpdateSrvStub::sendUpdateGetSourcesResponse (bool bOk, const trUpdSources& sources, act_t act) {
    UpdateGetSourcesResponse* payload = new UpdateGetSourcesResponse(bOk, sources);
    DBUS_MESSAGE_REPLY(dbusMessage, "UpdateGetSources", UpdateGetSourcesResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "UpdateGetSources", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  FcSwUpdateSrvStub::sendUpdateGetSourcesError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    UpdateGetSourcesError* payload = new UpdateGetSourcesError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "UpdateGetSources", UpdateGetSourcesError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "UpdateGetSources", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  FcSwUpdateSrvStub::sendUpdateSelectSourceResponse (bool bOk, const trReleaseInfos& releaseInfos, act_t act) {
    UpdateSelectSourceResponse* payload = new UpdateSelectSourceResponse(bOk, releaseInfos);
    DBUS_MESSAGE_REPLY(dbusMessage, "UpdateSelectSource", UpdateSelectSourceResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "UpdateSelectSource", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  FcSwUpdateSrvStub::sendUpdateSelectSourceError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    UpdateSelectSourceError* payload = new UpdateSelectSourceError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "UpdateSelectSource", UpdateSelectSourceError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "UpdateSelectSource", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  FcSwUpdateSrvStub::sendUpdateSelectReleaseResponse (bool bOk, tenErrorId enErrorId, act_t act) {
    UpdateSelectReleaseResponse* payload = new UpdateSelectReleaseResponse(bOk, enErrorId);
    DBUS_MESSAGE_REPLY(dbusMessage, "UpdateSelectRelease", UpdateSelectReleaseResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "UpdateSelectRelease", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  FcSwUpdateSrvStub::sendUpdateSelectReleaseError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    UpdateSelectReleaseError* payload = new UpdateSelectReleaseError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "UpdateSelectRelease", UpdateSelectReleaseError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "UpdateSelectRelease", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  FcSwUpdateSrvStub::sendGetDeviceStateListResponse (bool bOk, const trDeviceStates& deviceStates, act_t act) {
    GetDeviceStateListResponse* payload = new GetDeviceStateListResponse(bOk, deviceStates);
    DBUS_MESSAGE_REPLY(dbusMessage, "GetDeviceStateList", GetDeviceStateListResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "GetDeviceStateList", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  FcSwUpdateSrvStub::sendGetDeviceStateListError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    GetDeviceStateListError* payload = new GetDeviceStateListError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "GetDeviceStateList", GetDeviceStateListError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "GetDeviceStateList", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  FcSwUpdateSrvStub::sendSetUpdateOptionsResponse (bool bOk, tenUpdOptions enOptionRes, act_t act) {
    SetUpdateOptionsResponse* payload = new SetUpdateOptionsResponse(bOk, enOptionRes);
    DBUS_MESSAGE_REPLY(dbusMessage, "SetUpdateOptions", SetUpdateOptionsResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "SetUpdateOptions", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  FcSwUpdateSrvStub::sendSetUpdateOptionsError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    SetUpdateOptionsError* payload = new SetUpdateOptionsError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "SetUpdateOptions", SetUpdateOptionsError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "SetUpdateOptions", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  FcSwUpdateSrvStub::sendModifyReleaseDocResponse (bool bOk, const trModifyAction& enModifyActionRes, act_t act) {
    ModifyReleaseDocResponse* payload = new ModifyReleaseDocResponse(bOk, enModifyActionRes);
    DBUS_MESSAGE_REPLY(dbusMessage, "ModifyReleaseDoc", ModifyReleaseDocResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "ModifyReleaseDoc", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  FcSwUpdateSrvStub::sendModifyReleaseDocError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    ModifyReleaseDocError* payload = new ModifyReleaseDocError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "ModifyReleaseDoc", ModifyReleaseDocError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "ModifyReleaseDoc", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  FcSwUpdateSrvStub::sendGetUpdateFileResponse (bool bOk, tenGetUpdateFileResult enResult, act_t act) {
    GetUpdateFileResponse* payload = new GetUpdateFileResponse(bOk, enResult);
    DBUS_MESSAGE_REPLY(dbusMessage, "GetUpdateFile", GetUpdateFileResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "GetUpdateFile", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  FcSwUpdateSrvStub::sendGetUpdateFileError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    GetUpdateFileError* payload = new GetUpdateFileError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "GetUpdateFile", GetUpdateFileError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "GetUpdateFile", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  FcSwUpdateSrvStub::sendApplyDocResponse (bool bOk, act_t act) {
    ApplyDocResponse* payload = new ApplyDocResponse(bOk);
    DBUS_MESSAGE_REPLY(dbusMessage, "ApplyDoc", ApplyDocResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "ApplyDoc", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  FcSwUpdateSrvStub::sendApplyDocError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    ApplyDocError* payload = new ApplyDocError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "ApplyDoc", ApplyDocError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "ApplyDoc", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  FcSwUpdateSrvStub::sendApplyLockResponse (bool bOk, act_t act) {
    ApplyLockResponse* payload = new ApplyLockResponse(bOk);
    DBUS_MESSAGE_REPLY(dbusMessage, "ApplyLock", ApplyLockResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "ApplyLock", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  FcSwUpdateSrvStub::sendApplyLockError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    ApplyLockError* payload = new ApplyLockError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "ApplyLock", ApplyLockError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "ApplyLock", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  FcSwUpdateSrvStub::sendUpdateSelectReleaseByFileResponse (bool bOk, tenErrorId enErrorId, act_t act) {
    UpdateSelectReleaseByFileResponse* payload = new UpdateSelectReleaseByFileResponse(bOk, enErrorId);
    DBUS_MESSAGE_REPLY(dbusMessage, "UpdateSelectReleaseByFile", UpdateSelectReleaseByFileResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "UpdateSelectReleaseByFile", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  FcSwUpdateSrvStub::sendUpdateSelectReleaseByFileError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    UpdateSelectReleaseByFileError* payload = new UpdateSelectReleaseByFileError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "UpdateSelectReleaseByFile", UpdateSelectReleaseByFileError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "UpdateSelectReleaseByFile", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  FcSwUpdateSrvStub::sendRetryFailedModulesResponse (bool bOk, act_t act) {
    RetryFailedModulesResponse* payload = new RetryFailedModulesResponse(bOk);
    DBUS_MESSAGE_REPLY(dbusMessage, "RetryFailedModules", RetryFailedModulesResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "RetryFailedModules", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  FcSwUpdateSrvStub::sendRetryFailedModulesError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    RetryFailedModulesError* payload = new RetryFailedModulesError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "RetryFailedModules", RetryFailedModulesError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "RetryFailedModules", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  FcSwUpdateSrvStub::sendUpdateEndResponse (bool bOk, act_t act) {
    UpdateEndResponse* payload = new UpdateEndResponse(bOk);
    DBUS_MESSAGE_REPLY(dbusMessage, "UpdateEnd", UpdateEndResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "UpdateEnd", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  FcSwUpdateSrvStub::sendUpdateEndError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    UpdateEndError* payload = new UpdateEndError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "UpdateEnd", UpdateEndError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "UpdateEnd", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  FcSwUpdateSrvStub::sendUpdateAbortResponse (bool bOk, act_t act) {
    UpdateAbortResponse* payload = new UpdateAbortResponse(bOk);
    DBUS_MESSAGE_REPLY(dbusMessage, "UpdateAbort", UpdateAbortResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "UpdateAbort", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  FcSwUpdateSrvStub::sendUpdateAbortError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    UpdateAbortError* payload = new UpdateAbortError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "UpdateAbort", UpdateAbortError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "UpdateAbort", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  FcSwUpdateSrvStub::sendUpdateAbortDeviceResponse (bool bOk, const trAbortDeviceRes& rAbortDeviceRes, act_t act) {
    UpdateAbortDeviceResponse* payload = new UpdateAbortDeviceResponse(bOk, rAbortDeviceRes);
    DBUS_MESSAGE_REPLY(dbusMessage, "UpdateAbortDevice", UpdateAbortDeviceResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "UpdateAbortDevice", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  FcSwUpdateSrvStub::sendUpdateAbortDeviceError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    UpdateAbortDeviceError* payload = new UpdateAbortDeviceError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "UpdateAbortDevice", UpdateAbortDeviceError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "UpdateAbortDevice", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  FcSwUpdateSrvStub::sendHandleErrorResponse (bool bOk, act_t act) {
    HandleErrorResponse* payload = new HandleErrorResponse(bOk);
    DBUS_MESSAGE_REPLY(dbusMessage, "HandleError", HandleErrorResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "HandleError", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  FcSwUpdateSrvStub::sendHandleErrorError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    HandleErrorError* payload = new HandleErrorError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "HandleError", HandleErrorError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "HandleError", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  FcSwUpdateSrvStub::sendGetUpdateHistoryResponse (bool bOk, const trUpdLogs& logs, act_t act) {
    GetUpdateHistoryResponse* payload = new GetUpdateHistoryResponse(bOk, logs);
    DBUS_MESSAGE_REPLY(dbusMessage, "GetUpdateHistory", GetUpdateHistoryResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "GetUpdateHistory", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  FcSwUpdateSrvStub::sendGetUpdateHistoryError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    GetUpdateHistoryError* payload = new GetUpdateHistoryError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "GetUpdateHistory", GetUpdateHistoryError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "GetUpdateHistory", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  FcSwUpdateSrvStub::sendGetUpdateHistoryScopedResponse (bool bOk, tenHistoryScope enScopeRes, const trUpdLogs& logs, uint32 numberOfUpdates, uint32 numberOfUpdatesSinceDelivery, uint32 numberOfUpateLogs, act_t act) {
    GetUpdateHistoryScopedResponse* payload = new GetUpdateHistoryScopedResponse(bOk, enScopeRes, logs, numberOfUpdates, numberOfUpdatesSinceDelivery, numberOfUpateLogs);
    DBUS_MESSAGE_REPLY(dbusMessage, "GetUpdateHistoryScoped", GetUpdateHistoryScopedResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "GetUpdateHistoryScoped", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  FcSwUpdateSrvStub::sendGetUpdateHistoryScopedError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    GetUpdateHistoryScopedError* payload = new GetUpdateHistoryScopedError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "GetUpdateHistoryScoped", GetUpdateHistoryScopedError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "GetUpdateHistoryScoped", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  FcSwUpdateSrvStub::sendGetUpdateHistoryDetailedResponse (bool bOk, const trGetUpdateHistoryDetailed& result, act_t act) {
    GetUpdateHistoryDetailedResponse* payload = new GetUpdateHistoryDetailedResponse(bOk, result);
    DBUS_MESSAGE_REPLY(dbusMessage, "GetUpdateHistoryDetailed", GetUpdateHistoryDetailedResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "GetUpdateHistoryDetailed", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  FcSwUpdateSrvStub::sendGetUpdateHistoryDetailedError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    GetUpdateHistoryDetailedError* payload = new GetUpdateHistoryDetailedError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "GetUpdateHistoryDetailed", GetUpdateHistoryDetailedError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "GetUpdateHistoryDetailed", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  FcSwUpdateSrvStub::sendDeleteHistoryRequestResponse (bool bOk, act_t act) {
    DeleteHistoryRequestResponse* payload = new DeleteHistoryRequestResponse(bOk);
    DBUS_MESSAGE_REPLY(dbusMessage, "DeleteHistoryRequest", DeleteHistoryRequestResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "DeleteHistoryRequest", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  FcSwUpdateSrvStub::sendDeleteHistoryRequestError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    DeleteHistoryRequestError* payload = new DeleteHistoryRequestError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "DeleteHistoryRequest", DeleteHistoryRequestError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "DeleteHistoryRequest", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  FcSwUpdateSrvStub::sendGetTargetStateResponse (bool bOk, const trTartgetState& targetState, act_t act) {
    GetTargetStateResponse* payload = new GetTargetStateResponse(bOk, targetState);
    DBUS_MESSAGE_REPLY(dbusMessage, "GetTargetState", GetTargetStateResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "GetTargetState", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  FcSwUpdateSrvStub::sendGetTargetStateError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    GetTargetStateError* payload = new GetTargetStateError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "GetTargetState", GetTargetStateError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "GetTargetState", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  FcSwUpdateSrvStub::sendSetVersionBackDocAckResponse (bool bOk, const trVersionBackDocInfo& info, act_t act) {
    SetVersionBackDocAckResponse* payload = new SetVersionBackDocAckResponse(bOk, info);
    DBUS_MESSAGE_REPLY(dbusMessage, "SetVersionBackDocAck", SetVersionBackDocAckResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "SetVersionBackDocAck", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  FcSwUpdateSrvStub::sendSetVersionBackDocAckError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    SetVersionBackDocAckError* payload = new SetVersionBackDocAckError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "SetVersionBackDocAck", SetVersionBackDocAckError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "SetVersionBackDocAck", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  FcSwUpdateSrvStub::sendSetAllowRecoveryModeResponse (bool bOk, act_t act) {
    SetAllowRecoveryModeResponse* payload = new SetAllowRecoveryModeResponse(bOk);
    DBUS_MESSAGE_REPLY(dbusMessage, "SetAllowRecoveryMode", SetAllowRecoveryModeResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "SetAllowRecoveryMode", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  FcSwUpdateSrvStub::sendSetAllowRecoveryModeError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    SetAllowRecoveryModeError* payload = new SetAllowRecoveryModeError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "SetAllowRecoveryMode", SetAllowRecoveryModeError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "SetAllowRecoveryMode", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  FcSwUpdateSrvStub::sendGetCacheDirectoryResponse (bool bOk, const ::std::string& directory, act_t act) {
    GetCacheDirectoryResponse* payload = new GetCacheDirectoryResponse(bOk, directory);
    DBUS_MESSAGE_REPLY(dbusMessage, "GetCacheDirectory", GetCacheDirectoryResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "GetCacheDirectory", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  FcSwUpdateSrvStub::sendGetCacheDirectoryError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    GetCacheDirectoryError* payload = new GetCacheDirectoryError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "GetCacheDirectory", GetCacheDirectoryError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "GetCacheDirectory", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  FcSwUpdateSrvStub::sendEnterRecoveryModeResponse (bool bOk, act_t act) {
    EnterRecoveryModeResponse* payload = new EnterRecoveryModeResponse(bOk);
    DBUS_MESSAGE_REPLY(dbusMessage, "EnterRecoveryMode", EnterRecoveryModeResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "EnterRecoveryMode", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  FcSwUpdateSrvStub::sendEnterRecoveryModeError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    EnterRecoveryModeError* payload = new EnterRecoveryModeError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "EnterRecoveryMode", EnterRecoveryModeError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "EnterRecoveryMode", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  FcSwUpdateSrvStub::sendVerifyChecksumResponse (bool bOk, const trVerifyChecksumResult& verifyResult, act_t act) {
    VerifyChecksumResponse* payload = new VerifyChecksumResponse(bOk, verifyResult);
    DBUS_MESSAGE_REPLY(dbusMessage, "VerifyChecksum", VerifyChecksumResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "VerifyChecksum", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  FcSwUpdateSrvStub::sendVerifyChecksumError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    VerifyChecksumError* payload = new VerifyChecksumError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "VerifyChecksum", VerifyChecksumError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "VerifyChecksum", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  FcSwUpdateSrvStub::sendRegisterBgLocksResponse (bool bOk, act_t act) {
    RegisterBgLocksResponse* payload = new RegisterBgLocksResponse(bOk);
    DBUS_MESSAGE_REPLY(dbusMessage, "RegisterBgLocks", RegisterBgLocksResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "RegisterBgLocks", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  FcSwUpdateSrvStub::sendRegisterBgLocksError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    RegisterBgLocksError* payload = new RegisterBgLocksError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "RegisterBgLocks", RegisterBgLocksError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "RegisterBgLocks", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void FcSwUpdateSrvStub::onGetAll(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) const {

    //property 'UpdateState'
    {
        ::asf::dbus::DBusVariant variant;
        UpdateStateGet payload(_UpdateStateProperty.getUpdateState());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("UpdateState", variant));
    }

    //property 'UpdateSources'
    {
        ::asf::dbus::DBusVariant variant;
        UpdateSourcesGet payload(_UpdateSourcesProperty.getUpdateSources());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("UpdateSources", variant));
    }

    //property 'ReleaseFilter'
    {
        ::asf::dbus::DBusVariant variant;
        ReleaseFilterGet payload(_ReleaseFilterProperty.getReleaseFilter());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("ReleaseFilter", variant));
    }

    //property 'ReleaseDoc'
    {
        ::asf::dbus::DBusVariant variant;
        ReleaseDocGet payload(_ReleaseDocProperty.getReleaseDoc());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("ReleaseDoc", variant));
    }

    //property 'PreReleaseDoc'
    {
        ::asf::dbus::DBusVariant variant;
        PreReleaseDocGet payload(_PreReleaseDocProperty.getPreReleaseDoc());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("PreReleaseDoc", variant));
    }

    //property 'UpdateProgress'
    {
        ::asf::dbus::DBusVariant variant;
        UpdateProgressGet payload(_UpdateProgressProperty.getUpdateProgress());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("UpdateProgress", variant));
    }

    //property 'UpdateResult'
    {
        ::asf::dbus::DBusVariant variant;
        UpdateResultGet payload(_UpdateResultProperty.getUpdateResult());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("UpdateResult", variant));
    }

    //property 'UpdateErrors'
    {
        ::asf::dbus::DBusVariant variant;
        UpdateErrorsGet payload(_UpdateErrorsProperty.getUpdateErrors());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("UpdateErrors", variant));
    }

    //property 'CustomerUpdates'
    {
        ::asf::dbus::DBusVariant variant;
        CustomerUpdatesGet payload(_CustomerUpdatesProperty.getCustomerUpdates());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("CustomerUpdates", variant));
    }

    //property 'VersionBackDocInfo'
    {
        ::asf::dbus::DBusVariant variant;
        VersionBackDocInfoGet payload(_VersionBackDocInfoProperty.getVersionBackDocInfo());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("VersionBackDocInfo", variant));
    }

    //property 'AvailableCustomerUpdates'
    {
        ::asf::dbus::DBusVariant variant;
        AvailableCustomerUpdatesGet payload(_AvailableCustomerUpdatesProperty.getAvailableCustomerUpdates());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("AvailableCustomerUpdates", variant));
    }

    //property 'UpdateBgImageInfo'
    {
        ::asf::dbus::DBusVariant variant;
        UpdateBgImageInfoGet payload(_UpdateBgImageInfoProperty.getUpdateBgImageInfo());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("UpdateBgImageInfo", variant));
    }

    //property 'BgLocksState'
    {
        ::asf::dbus::DBusVariant variant;
        BgLocksStateGet payload(_BgLocksStateProperty.getBgLocksState());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("BgLocksState", variant));
    }
}

} // namespace FcSwUpdateSrv
} // namespace fcswupdatesrv
