/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/Types.h"
#include "asf/stream/json.h"
#include "fcswupdatesrv/FcSwUpdateSrv.h"
#include "fcswupdatesrv/FcSwUpdateSrvConst.h"
#include "fcswupdatesrv/FcSwUpdateSrvJson.h"
#include "fcswupdatesrv/FcSwUpdateSrvJsonPrivate.h"
#include "yajl/yajl_gen.h"
#include <cstddef>
#include <cstring>
#include <string>
#include <vector>

using namespace ::asf::stream::json;


// Json serialization of "trUpdSource"

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::trUpdSource& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasSourceName()) {
        yajl_gen_string(g, (const unsigned char*)  "sourceName" , 10);
        const char *s = value.getSourceName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasSourcePath()) {
        yajl_gen_string(g, (const unsigned char*)  "sourcePath" , 10);
        const char *s = value.getSourcePath().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasEnSourceType()) {
        yajl_gen_string(g, (const unsigned char*)  "enSourceType" , 12);
        const char* s = ::fcswupdatesrv::FcSwUpdateSrv::tenSourceType_Name(value.getEnSourceType());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getEnSourceType());
    }
    if (!isSparse || value.hasBAvailable()) {
        yajl_gen_string(g, (const unsigned char*)  "bAvailable" , 10);
        yajl_gen_bool(g, (bool)value.getBAvailable());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::trUpdSource& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "trUpdSources"

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::trUpdSources& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasSources()) {
        yajl_gen_string(g, (const unsigned char*)  "sources" , 7);
        yajl_gen_array_open(g);
        const ::std::vector< ::fcswupdatesrv::FcSwUpdateSrv::trUpdSource >& o1 = value.getSources();
        {
            ::std::vector< ::fcswupdatesrv::FcSwUpdateSrv::trUpdSource >::const_iterator o0;
            for (o0 = o1.begin(); o0 != o1.end(); ++o0) {
                serializeJson((*o0), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::trUpdSources& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "trSelectReleaseRes"

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::trSelectReleaseRes& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasBOk()) {
        yajl_gen_string(g, (const unsigned char*)  "bOk" , 3);
        yajl_gen_bool(g, (bool)value.getBOk());
    }
    if (!isSparse || value.hasEnErrorId()) {
        yajl_gen_string(g, (const unsigned char*)  "enErrorId" , 9);
        const char* s = ::fcswupdatesrv::FcSwUpdateSrv::tenErrorId_Name(value.getEnErrorId());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getEnErrorId());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::trSelectReleaseRes& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "trReleaseInfo"

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::trReleaseInfo& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasName()) {
        yajl_gen_string(g, (const unsigned char*)  "name" , 4);
        const char *s = value.getName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasInfo()) {
        yajl_gen_string(g, (const unsigned char*)  "info" , 4);
        const char *s = value.getInfo().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::trReleaseInfo& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "trReleaseAccess"

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::trReleaseAccess& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasMountPoint()) {
        yajl_gen_string(g, (const unsigned char*)  "mountPoint" , 10);
        const char *s = value.getMountPoint().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasPath()) {
        yajl_gen_string(g, (const unsigned char*)  "path" , 4);
        const char *s = value.getPath().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasFile()) {
        yajl_gen_string(g, (const unsigned char*)  "file" , 4);
        const char *s = value.getFile().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasUseExtendedOptions()) {
        yajl_gen_string(g, (const unsigned char*)  "useExtendedOptions" , 18);
        yajl_gen_bool(g, (bool)value.getUseExtendedOptions());
    }
    if (!isSparse || value.hasReleaseFilter()) {
        yajl_gen_string(g, (const unsigned char*)  "releaseFilter" , 13);
        serializeJson(value.getReleaseFilter(), g, options);
    }
    if (!isSparse || value.hasUpdateOption()) {
        yajl_gen_string(g, (const unsigned char*)  "updateOption" , 12);
        const char* s = ::fcswupdatesrv::FcSwUpdateSrv::tenUpdOptions_Name(value.getUpdateOption());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getUpdateOption());
    }
    if (!isSparse || value.hasDoApply()) {
        yajl_gen_string(g, (const unsigned char*)  "doApply" , 7);
        yajl_gen_bool(g, (bool)value.getDoApply());
    }
    if (!isSparse || value.hasPostImageInstallationMode()) {
        yajl_gen_string(g, (const unsigned char*)  "postImageInstallationMode" , 25);
        yajl_gen_bool(g, (bool)value.getPostImageInstallationMode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::trReleaseAccess& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "trReleaseInfos"

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::trReleaseInfos& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasEnErrorId()) {
        yajl_gen_string(g, (const unsigned char*)  "enErrorId" , 9);
        const char* s = ::fcswupdatesrv::FcSwUpdateSrv::tenErrorId_Name(value.getEnErrorId());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getEnErrorId());
    }
    if (!isSparse || value.hasReleaseInfos()) {
        yajl_gen_string(g, (const unsigned char*)  "releaseInfos" , 12);
        yajl_gen_array_open(g);
        const ::std::vector< ::fcswupdatesrv::FcSwUpdateSrv::trReleaseInfo >& o3 = value.getReleaseInfos();
        {
            ::std::vector< ::fcswupdatesrv::FcSwUpdateSrv::trReleaseInfo >::const_iterator o2;
            for (o2 = o3.begin(); o2 != o3.end(); ++o2) {
                serializeJson((*o2), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::trReleaseInfos& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "trDeviceState"

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::trDeviceState& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasName()) {
        yajl_gen_string(g, (const unsigned char*)  "name" , 4);
        const char *s = value.getName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasHwIndex()) {
        yajl_gen_string(g, (const unsigned char*)  "hwIndex" , 7);
        const char *s = value.getHwIndex().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasInfo()) {
        yajl_gen_string(g, (const unsigned char*)  "info" , 4);
        const char *s = value.getInfo().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasBReady()) {
        yajl_gen_string(g, (const unsigned char*)  "bReady" , 6);
        yajl_gen_bool(g, (bool)value.getBReady());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::trDeviceState& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "trDeviceStates"

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::trDeviceStates& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasDeviceStates()) {
        yajl_gen_string(g, (const unsigned char*)  "deviceStates" , 12);
        yajl_gen_array_open(g);
        const ::std::vector< ::fcswupdatesrv::FcSwUpdateSrv::trDeviceState >& o5 = value.getDeviceStates();
        {
            ::std::vector< ::fcswupdatesrv::FcSwUpdateSrv::trDeviceState >::const_iterator o4;
            for (o4 = o5.begin(); o4 != o5.end(); ++o4) {
                serializeJson((*o4), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::trDeviceStates& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "trUpdState"

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::trUpdState& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasTrain()) {
        yajl_gen_string(g, (const unsigned char*)  "train" , 5);
        const char *s = value.getTrain().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasSourceSwTrain()) {
        yajl_gen_string(g, (const unsigned char*)  "sourceSwTrain" , 13);
        const char *s = value.getSourceSwTrain().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasU32EstimatedUpdateTimeSec()) {
        yajl_gen_string(g, (const unsigned char*)  "u32EstimatedUpdateTimeSec" , 25);
        yajl_gen_integer(g, (long long)value.getU32EstimatedUpdateTimeSec());
    }
    if (!isSparse || value.hasMuVersion()) {
        yajl_gen_string(g, (const unsigned char*)  "muVersion" , 9);
        const char *s = value.getMuVersion().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasEnState()) {
        yajl_gen_string(g, (const unsigned char*)  "enState" , 7);
        const char* s = ::fcswupdatesrv::FcSwUpdateSrv::tenUpdState_Name(value.getEnState());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getEnState());
    }
    if (!isSparse || value.hasEnUser()) {
        yajl_gen_string(g, (const unsigned char*)  "enUser" , 6);
        const char* s = ::fcswupdatesrv::FcSwUpdateSrv::tenUser_Name(value.getEnUser());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getEnUser());
    }
    if (!isSparse || value.hasEnSourceType()) {
        yajl_gen_string(g, (const unsigned char*)  "enSourceType" , 12);
        const char* s = ::fcswupdatesrv::FcSwUpdateSrv::tenSourceType_Name(value.getEnSourceType());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getEnSourceType());
    }
    if (!isSparse || value.hasBHasEngineeringOptions()) {
        yajl_gen_string(g, (const unsigned char*)  "bHasEngineeringOptions" , 22);
        yajl_gen_bool(g, (bool)value.getBHasEngineeringOptions());
    }
    if (!isSparse || value.hasBCustomSupported()) {
        yajl_gen_string(g, (const unsigned char*)  "bCustomSupported" , 16);
        yajl_gen_bool(g, (bool)value.getBCustomSupported());
    }
    if (!isSparse || value.hasBCustomAvail()) {
        yajl_gen_string(g, (const unsigned char*)  "bCustomAvail" , 12);
        yajl_gen_bool(g, (bool)value.getBCustomAvail());
    }
    if (!isSparse || value.hasBInterruptible()) {
        yajl_gen_string(g, (const unsigned char*)  "bInterruptible" , 14);
        yajl_gen_bool(g, (bool)value.getBInterruptible());
    }
    if (!isSparse || value.hasBDevicesReady()) {
        yajl_gen_string(g, (const unsigned char*)  "bDevicesReady" , 13);
        yajl_gen_bool(g, (bool)value.getBDevicesReady());
    }
    if (!isSparse || value.hasHasValidTrain()) {
        yajl_gen_string(g, (const unsigned char*)  "hasValidTrain" , 13);
        yajl_gen_bool(g, (bool)value.getHasValidTrain());
    }
    if (!isSparse || value.hasBAllowRecoveryMode()) {
        yajl_gen_string(g, (const unsigned char*)  "bAllowRecoveryMode" , 18);
        yajl_gen_bool(g, (bool)value.getBAllowRecoveryMode());
    }
    if (!isSparse || value.hasHeadUnitId()) {
        yajl_gen_string(g, (const unsigned char*)  "headUnitId" , 10);
        const char *s = value.getHeadUnitId().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasOverallCISSWVer()) {
        yajl_gen_string(g, (const unsigned char*)  "overallCISSWVer" , 15);
        const char *s = value.getOverallCISSWVer().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::trUpdState& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "trSubModuleData"

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::trSubModuleData& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasName()) {
        yajl_gen_string(g, (const unsigned char*)  "name" , 4);
        const char *s = value.getName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasBSelected()) {
        yajl_gen_string(g, (const unsigned char*)  "bSelected" , 9);
        yajl_gen_bool(g, (bool)value.getBSelected());
    }
    if (!isSparse || value.hasInfo()) {
        yajl_gen_string(g, (const unsigned char*)  "info" , 4);
        const char *s = value.getInfo().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasToVersion()) {
        yajl_gen_string(g, (const unsigned char*)  "toVersion" , 9);
        const char *s = value.getToVersion().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasFromVersion()) {
        yajl_gen_string(g, (const unsigned char*)  "fromVersion" , 11);
        const char *s = value.getFromVersion().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasSizeBytes()) {
        yajl_gen_string(g, (const unsigned char*)  "sizeBytes" , 9);
        char buffer[21];
        ::asf::stream::json::ulltoa ((uint64_t)value.getSizeBytes(), buffer);
        yajl_gen_number(g, buffer, strlen (buffer));
    }
    if (!isSparse || value.hasEnScope()) {
        yajl_gen_string(g, (const unsigned char*)  "enScope" , 7);
        const char* s = ::fcswupdatesrv::FcSwUpdateSrv::tenScope_Name(value.getEnScope());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getEnScope());
    }
    if (!isSparse || value.hasCompatInfo()) {
        yajl_gen_string(g, (const unsigned char*)  "compatInfo" , 10);
        yajl_gen_array_open(g);
        const ::std::vector< uint8 >& o7 = value.getCompatInfo();
        {
            ::std::vector< uint8 >::const_iterator o6;
            for (o6 = o7.begin(); o6 != o7.end(); ++o6) {
                yajl_gen_integer(g, (long long)(*o6));
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::trSubModuleData& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "trModuleData"

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::trModuleData& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasName()) {
        yajl_gen_string(g, (const unsigned char*)  "name" , 4);
        const char *s = value.getName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasHwIndex()) {
        yajl_gen_string(g, (const unsigned char*)  "hwIndex" , 7);
        const char *s = value.getHwIndex().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasSubModules()) {
        yajl_gen_string(g, (const unsigned char*)  "subModules" , 10);
        yajl_gen_array_open(g);
        const ::std::vector< ::fcswupdatesrv::FcSwUpdateSrv::trSubModuleData >& o9 = value.getSubModules();
        {
            ::std::vector< ::fcswupdatesrv::FcSwUpdateSrv::trSubModuleData >::const_iterator o8;
            for (o8 = o9.begin(); o8 != o9.end(); ++o8) {
                serializeJson((*o8), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    if (!isSparse || value.hasEnScope()) {
        yajl_gen_string(g, (const unsigned char*)  "enScope" , 7);
        const char* s = ::fcswupdatesrv::FcSwUpdateSrv::tenScope_Name(value.getEnScope());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getEnScope());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::trModuleData& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "trDeviceData"

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::trDeviceData& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasName()) {
        yajl_gen_string(g, (const unsigned char*)  "name" , 4);
        const char *s = value.getName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasModules()) {
        yajl_gen_string(g, (const unsigned char*)  "modules" , 7);
        yajl_gen_array_open(g);
        const ::std::vector< ::fcswupdatesrv::FcSwUpdateSrv::trModuleData >& o11 = value.getModules();
        {
            ::std::vector< ::fcswupdatesrv::FcSwUpdateSrv::trModuleData >::const_iterator o10;
            for (o10 = o11.begin(); o10 != o11.end(); ++o10) {
                serializeJson((*o10), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    if (!isSparse || value.hasEnScope()) {
        yajl_gen_string(g, (const unsigned char*)  "enScope" , 7);
        const char* s = ::fcswupdatesrv::FcSwUpdateSrv::tenScope_Name(value.getEnScope());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getEnScope());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::trDeviceData& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "trTartgetState"

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::trTartgetState& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasFilter()) {
        yajl_gen_string(g, (const unsigned char*)  "filter" , 6);
        const char* s = ::fcswupdatesrv::FcSwUpdateSrv::tenUpdType_Name(value.getFilter());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getFilter());
    }
    if (!isSparse || value.hasName()) {
        yajl_gen_string(g, (const unsigned char*)  "name" , 4);
        const char *s = value.getName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasDevices()) {
        yajl_gen_string(g, (const unsigned char*)  "devices" , 7);
        yajl_gen_array_open(g);
        const ::std::vector< ::fcswupdatesrv::FcSwUpdateSrv::trDeviceData >& o13 = value.getDevices();
        {
            ::std::vector< ::fcswupdatesrv::FcSwUpdateSrv::trDeviceData >::const_iterator o12;
            for (o12 = o13.begin(); o12 != o13.end(); ++o12) {
                serializeJson((*o12), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::trTartgetState& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "trConfigProblem"

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::trConfigProblem& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasModuleName()) {
        yajl_gen_string(g, (const unsigned char*)  "moduleName" , 10);
        const char *s = value.getModuleName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasEnErrorId()) {
        yajl_gen_string(g, (const unsigned char*)  "enErrorId" , 9);
        const char* s = ::fcswupdatesrv::FcSwUpdateSrv::tenErrorId_Name(value.getEnErrorId());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getEnErrorId());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::trConfigProblem& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "trReleaseFilter"

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::trReleaseFilter& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasEnUpgradeDirectionFilter()) {
        yajl_gen_string(g, (const unsigned char*)  "enUpgradeDirectionFilter" , 24);
        const char* s = ::fcswupdatesrv::FcSwUpdateSrv::tenUpdOptions_Name(value.getEnUpgradeDirectionFilter());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getEnUpgradeDirectionFilter());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::trReleaseFilter& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "trReleaseDoc"

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::trReleaseDoc& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasName()) {
        yajl_gen_string(g, (const unsigned char*)  "name" , 4);
        const char *s = value.getName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasEnUpdateDirection()) {
        yajl_gen_string(g, (const unsigned char*)  "enUpdateDirection" , 17);
        const char* s = ::fcswupdatesrv::FcSwUpdateSrv::tenUpdateDirection_Name(value.getEnUpdateDirection());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getEnUpdateDirection());
    }
    if (!isSparse || value.hasEnSourceType()) {
        yajl_gen_string(g, (const unsigned char*)  "enSourceType" , 12);
        const char* s = ::fcswupdatesrv::FcSwUpdateSrv::tenSourceType_Name(value.getEnSourceType());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getEnSourceType());
    }
    if (!isSparse || value.hasU32EstimatedUpdateTimeSec()) {
        yajl_gen_string(g, (const unsigned char*)  "u32EstimatedUpdateTimeSec" , 25);
        yajl_gen_integer(g, (long long)value.getU32EstimatedUpdateTimeSec());
    }
    if (!isSparse || value.hasEnUpdOptions()) {
        yajl_gen_string(g, (const unsigned char*)  "enUpdOptions" , 12);
        const char* s = ::fcswupdatesrv::FcSwUpdateSrv::tenUpdOptions_Name(value.getEnUpdOptions());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getEnUpdOptions());
    }
    if (!isSparse || value.hasBNeedsFlashing()) {
        yajl_gen_string(g, (const unsigned char*)  "bNeedsFlashing" , 14);
        yajl_gen_bool(g, (bool)value.getBNeedsFlashing());
    }
    if (!isSparse || value.hasBIsDeltaUpdate()) {
        yajl_gen_string(g, (const unsigned char*)  "bIsDeltaUpdate" , 14);
        yajl_gen_bool(g, (bool)value.getBIsDeltaUpdate());
    }
    if (!isSparse || value.hasDevices()) {
        yajl_gen_string(g, (const unsigned char*)  "devices" , 7);
        yajl_gen_array_open(g);
        const ::std::vector< ::fcswupdatesrv::FcSwUpdateSrv::trDeviceData >& o15 = value.getDevices();
        {
            ::std::vector< ::fcswupdatesrv::FcSwUpdateSrv::trDeviceData >::const_iterator o14;
            for (o14 = o15.begin(); o14 != o15.end(); ++o14) {
                serializeJson((*o14), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    if (!isSparse || value.hasProblems()) {
        yajl_gen_string(g, (const unsigned char*)  "problems" , 8);
        yajl_gen_array_open(g);
        const ::std::vector< ::fcswupdatesrv::FcSwUpdateSrv::trConfigProblem >& o17 = value.getProblems();
        {
            ::std::vector< ::fcswupdatesrv::FcSwUpdateSrv::trConfigProblem >::const_iterator o16;
            for (o16 = o17.begin(); o16 != o17.end(); ++o16) {
                serializeJson((*o16), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::trReleaseDoc& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "trPreReleaseDoc"

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::trPreReleaseDoc& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasBFoundRelease()) {
        yajl_gen_string(g, (const unsigned char*)  "bFoundRelease" , 13);
        yajl_gen_bool(g, (bool)value.getBFoundRelease());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::trPreReleaseDoc& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "trModifyAction"

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::trModifyAction& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU32DeviceIndex()) {
        yajl_gen_string(g, (const unsigned char*)  "u32DeviceIndex" , 14);
        yajl_gen_integer(g, (long long)value.getU32DeviceIndex());
    }
    if (!isSparse || value.hasU32ModuleIndex()) {
        yajl_gen_string(g, (const unsigned char*)  "u32ModuleIndex" , 14);
        yajl_gen_integer(g, (long long)value.getU32ModuleIndex());
    }
    if (!isSparse || value.hasU32SubModuleIndex()) {
        yajl_gen_string(g, (const unsigned char*)  "u32SubModuleIndex" , 17);
        yajl_gen_integer(g, (long long)value.getU32SubModuleIndex());
    }
    if (!isSparse || value.hasEnUpdAction()) {
        yajl_gen_string(g, (const unsigned char*)  "enUpdAction" , 11);
        const char* s = ::fcswupdatesrv::FcSwUpdateSrv::tenModifyAction_Name(value.getEnUpdAction());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getEnUpdAction());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::trModifyAction& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "trUpdProgress"

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::trUpdProgress& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasTrain()) {
        yajl_gen_string(g, (const unsigned char*)  "train" , 5);
        const char *s = value.getTrain().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasDeviceName()) {
        yajl_gen_string(g, (const unsigned char*)  "deviceName" , 10);
        const char *s = value.getDeviceName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasModuleName()) {
        yajl_gen_string(g, (const unsigned char*)  "moduleName" , 10);
        const char *s = value.getModuleName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasSubModuleName()) {
        yajl_gen_string(g, (const unsigned char*)  "subModuleName" , 13);
        const char *s = value.getSubModuleName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasRefKey()) {
        yajl_gen_string(g, (const unsigned char*)  "refKey" , 6);
        const char *s = value.getRefKey().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasSource()) {
        yajl_gen_string(g, (const unsigned char*)  "source" , 6);
        const char *s = value.getSource().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasLine1()) {
        yajl_gen_string(g, (const unsigned char*)  "line1" , 5);
        const char *s = value.getLine1().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasLine2()) {
        yajl_gen_string(g, (const unsigned char*)  "line2" , 5);
        const char *s = value.getLine2().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasLuaCmd()) {
        yajl_gen_string(g, (const unsigned char*)  "luaCmd" , 6);
        const char *s = value.getLuaCmd().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasU32Retries()) {
        yajl_gen_string(g, (const unsigned char*)  "u32Retries" , 10);
        yajl_gen_integer(g, (long long)value.getU32Retries());
    }
    if (!isSparse || value.hasU32NumAll()) {
        yajl_gen_string(g, (const unsigned char*)  "u32NumAll" , 9);
        yajl_gen_integer(g, (long long)value.getU32NumAll());
    }
    if (!isSparse || value.hasU32NumComplete()) {
        yajl_gen_string(g, (const unsigned char*)  "u32NumComplete" , 14);
        yajl_gen_integer(g, (long long)value.getU32NumComplete());
    }
    if (!isSparse || value.hasU32NumRunning()) {
        yajl_gen_string(g, (const unsigned char*)  "u32NumRunning" , 13);
        yajl_gen_integer(g, (long long)value.getU32NumRunning());
    }
    if (!isSparse || value.hasU32NumNotApplicable()) {
        yajl_gen_string(g, (const unsigned char*)  "u32NumNotApplicable" , 19);
        yajl_gen_integer(g, (long long)value.getU32NumNotApplicable());
    }
    if (!isSparse || value.hasU32NumFailed()) {
        yajl_gen_string(g, (const unsigned char*)  "u32NumFailed" , 12);
        yajl_gen_integer(g, (long long)value.getU32NumFailed());
    }
    if (!isSparse || value.hasU32NumRemaining()) {
        yajl_gen_string(g, (const unsigned char*)  "u32NumRemaining" , 15);
        yajl_gen_integer(g, (long long)value.getU32NumRemaining());
    }
    if (!isSparse || value.hasU8SubModulePercentComplete()) {
        yajl_gen_string(g, (const unsigned char*)  "u8SubModulePercentComplete" , 26);
        yajl_gen_integer(g, (long long)value.getU8SubModulePercentComplete());
    }
    if (!isSparse || value.hasU8ReleasePercentComplete()) {
        yajl_gen_string(g, (const unsigned char*)  "u8ReleasePercentComplete" , 24);
        yajl_gen_integer(g, (long long)value.getU8ReleasePercentComplete());
    }
    if (!isSparse || value.hasU8ReleasePercentCompleteForPhase()) {
        yajl_gen_string(g, (const unsigned char*)  "u8ReleasePercentCompleteForPhase" , 32);
        yajl_gen_integer(g, (long long)value.getU8ReleasePercentCompleteForPhase());
    }
    if (!isSparse || value.hasU32EstimatedUpdateTimeSec()) {
        yajl_gen_string(g, (const unsigned char*)  "u32EstimatedUpdateTimeSec" , 25);
        yajl_gen_integer(g, (long long)value.getU32EstimatedUpdateTimeSec());
    }
    if (!isSparse || value.hasU32EstimatedUpdateTimeSecForPhase()) {
        yajl_gen_string(g, (const unsigned char*)  "u32EstimatedUpdateTimeSecForPhase" , 33);
        yajl_gen_integer(g, (long long)value.getU32EstimatedUpdateTimeSecForPhase());
    }
    if (!isSparse || value.hasU32EstimatedCurrentModuleUpdateTimeSec()) {
        yajl_gen_string(g, (const unsigned char*)  "u32EstimatedCurrentModuleUpdateTimeSec" , 38);
        yajl_gen_integer(g, (long long)value.getU32EstimatedCurrentModuleUpdateTimeSec());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::trUpdProgress& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "trAbortDeviceRes"

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::trAbortDeviceRes& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasAbortSuccess()) {
        yajl_gen_string(g, (const unsigned char*)  "abortSuccess" , 12);
        yajl_gen_bool(g, (bool)value.getAbortSuccess());
    }
    if (!isSparse || value.hasRefKey()) {
        yajl_gen_string(g, (const unsigned char*)  "refKey" , 6);
        const char *s = value.getRefKey().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::trAbortDeviceRes& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "trTimeDate"

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::trTimeDate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasYear()) {
        yajl_gen_string(g, (const unsigned char*)  "year" , 4);
        yajl_gen_integer(g, (long long)value.getYear());
    }
    if (!isSparse || value.hasMonth()) {
        yajl_gen_string(g, (const unsigned char*)  "month" , 5);
        yajl_gen_integer(g, (long long)value.getMonth());
    }
    if (!isSparse || value.hasDay()) {
        yajl_gen_string(g, (const unsigned char*)  "day" , 3);
        yajl_gen_integer(g, (long long)value.getDay());
    }
    if (!isSparse || value.hasHour()) {
        yajl_gen_string(g, (const unsigned char*)  "hour" , 4);
        yajl_gen_integer(g, (long long)value.getHour());
    }
    if (!isSparse || value.hasMinute()) {
        yajl_gen_string(g, (const unsigned char*)  "minute" , 6);
        yajl_gen_integer(g, (long long)value.getMinute());
    }
    if (!isSparse || value.hasSeconds()) {
        yajl_gen_string(g, (const unsigned char*)  "seconds" , 7);
        yajl_gen_integer(g, (long long)value.getSeconds());
    }
    if (!isSparse || value.hasUtc()) {
        yajl_gen_string(g, (const unsigned char*)  "utc" , 3);
        char buffer[21];
        ::asf::stream::json::ulltoa ((uint64_t)value.getUtc(), buffer);
        yajl_gen_number(g, buffer, strlen (buffer));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::trTimeDate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "trResult"

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::trResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasBOk()) {
        yajl_gen_string(g, (const unsigned char*)  "bOk" , 3);
        yajl_gen_bool(g, (bool)value.getBOk());
    }
    if (!isSparse || value.hasName()) {
        yajl_gen_string(g, (const unsigned char*)  "name" , 4);
        const char *s = value.getName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasTimeDate()) {
        yajl_gen_string(g, (const unsigned char*)  "timeDate" , 8);
        serializeJson(value.getTimeDate(), g, options);
    }
    if (!isSparse || value.hasCounterKilometers()) {
        yajl_gen_string(g, (const unsigned char*)  "counterKilometers" , 17);
        yajl_gen_integer(g, (long long)value.getCounterKilometers());
    }
    if (!isSparse || value.hasDevices()) {
        yajl_gen_string(g, (const unsigned char*)  "devices" , 7);
        yajl_gen_array_open(g);
        const ::std::vector< ::fcswupdatesrv::FcSwUpdateSrv::trDeviceData >& o19 = value.getDevices();
        {
            ::std::vector< ::fcswupdatesrv::FcSwUpdateSrv::trDeviceData >::const_iterator o18;
            for (o18 = o19.begin(); o18 != o19.end(); ++o18) {
                serializeJson((*o18), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::trResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "trErrorIds"

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::trErrorIds& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasErrorIds()) {
        yajl_gen_string(g, (const unsigned char*)  "errorIds" , 8);
        yajl_gen_array_open(g);
        const ::std::vector< ::fcswupdatesrv::FcSwUpdateSrv::tenErrorId >& o21 = value.getErrorIds();
        {
            ::std::vector< ::fcswupdatesrv::FcSwUpdateSrv::tenErrorId >::const_iterator o20;
            for (o20 = o21.begin(); o20 != o21.end(); ++o20) {
                const char* s = ::fcswupdatesrv::FcSwUpdateSrv::tenErrorId_Name((*o20));
                if (s != NULL)
                    yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
                else
                    yajl_gen_integer(g, (long long)(*o20));
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::trErrorIds& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "trGetCacheDirectory"

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::trGetCacheDirectory& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasDirRequest()) {
        yajl_gen_string(g, (const unsigned char*)  "dirRequest" , 10);
        const char* s = ::fcswupdatesrv::FcSwUpdateSrv::tenCacheDirRequest_Name(value.getDirRequest());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getDirRequest());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::trGetCacheDirectory& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "trUpdLog"

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::trUpdLog& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasName()) {
        yajl_gen_string(g, (const unsigned char*)  "name" , 4);
        const char *s = value.getName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasTimeDate()) {
        yajl_gen_string(g, (const unsigned char*)  "timeDate" , 8);
        serializeJson(value.getTimeDate(), g, options);
    }
    if (!isSparse || value.hasUpdateType()) {
        yajl_gen_string(g, (const unsigned char*)  "updateType" , 10);
        const char *s = value.getUpdateType().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasDevices()) {
        yajl_gen_string(g, (const unsigned char*)  "devices" , 7);
        yajl_gen_array_open(g);
        const ::std::vector< ::fcswupdatesrv::FcSwUpdateSrv::trDeviceData >& o23 = value.getDevices();
        {
            ::std::vector< ::fcswupdatesrv::FcSwUpdateSrv::trDeviceData >::const_iterator o22;
            for (o22 = o23.begin(); o22 != o23.end(); ++o22) {
                serializeJson((*o22), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    if (!isSparse || value.hasSize()) {
        yajl_gen_string(g, (const unsigned char*)  "size" , 4);
        char buffer[21];
        ::asf::stream::json::ulltoa ((uint64_t)value.getSize(), buffer);
        yajl_gen_number(g, buffer, strlen (buffer));
    }
    if (!isSparse || value.hasSuccess()) {
        yajl_gen_string(g, (const unsigned char*)  "success" , 7);
        yajl_gen_bool(g, (bool)value.getSuccess());
    }
    if (!isSparse || value.hasCounterKilometers()) {
        yajl_gen_string(g, (const unsigned char*)  "counterKilometers" , 17);
        yajl_gen_integer(g, (long long)value.getCounterKilometers());
    }
    if (!isSparse || value.hasIndex()) {
        yajl_gen_string(g, (const unsigned char*)  "index" , 5);
        yajl_gen_integer(g, (long long)value.getIndex());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::trUpdLog& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "trUpdLogs"

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::trUpdLogs& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasUpdateLogs()) {
        yajl_gen_string(g, (const unsigned char*)  "updateLogs" , 10);
        yajl_gen_array_open(g);
        const ::std::vector< ::fcswupdatesrv::FcSwUpdateSrv::trUpdLog >& o25 = value.getUpdateLogs();
        {
            ::std::vector< ::fcswupdatesrv::FcSwUpdateSrv::trUpdLog >::const_iterator o24;
            for (o24 = o25.begin(); o24 != o25.end(); ++o24) {
                serializeJson((*o24), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::trUpdLogs& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "trUpdateMedia"

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::trUpdateMedia& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasBCustomerMediaPresent()) {
        yajl_gen_string(g, (const unsigned char*)  "bCustomerMediaPresent" , 21);
        yajl_gen_bool(g, (bool)value.getBCustomerMediaPresent());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::trUpdateMedia& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "trVersionBackDocInfo"

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::trVersionBackDocInfo& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU16Key()) {
        yajl_gen_string(g, (const unsigned char*)  "u16Key" , 6);
        yajl_gen_integer(g, (long long)value.getU16Key());
    }
    if (!isSparse || value.hasAckOk()) {
        yajl_gen_string(g, (const unsigned char*)  "ackOk" , 5);
        yajl_gen_bool(g, (bool)value.getAckOk());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::trVersionBackDocInfo& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "trCustomerUpdate"

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::trCustomerUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasDevice()) {
        yajl_gen_string(g, (const unsigned char*)  "device" , 6);
        const char *s = value.getDevice().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasName()) {
        yajl_gen_string(g, (const unsigned char*)  "name" , 4);
        const char *s = value.getName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasVers()) {
        yajl_gen_string(g, (const unsigned char*)  "vers" , 4);
        const char *s = value.getVers().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasBOk()) {
        yajl_gen_string(g, (const unsigned char*)  "bOk" , 3);
        yajl_gen_bool(g, (bool)value.getBOk());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::trCustomerUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "trAvailableCustomerUpdates"

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::trAvailableCustomerUpdates& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasEnErrorId()) {
        yajl_gen_string(g, (const unsigned char*)  "enErrorId" , 9);
        const char* s = ::fcswupdatesrv::FcSwUpdateSrv::tenErrorId_Name(value.getEnErrorId());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getEnErrorId());
    }
    if (!isSparse || value.hasUpdates()) {
        yajl_gen_string(g, (const unsigned char*)  "updates" , 7);
        yajl_gen_array_open(g);
        const ::std::vector< ::fcswupdatesrv::FcSwUpdateSrv::trCustomerUpdate >& o27 = value.getUpdates();
        {
            ::std::vector< ::fcswupdatesrv::FcSwUpdateSrv::trCustomerUpdate >::const_iterator o26;
            for (o26 = o27.begin(); o26 != o27.end(); ++o26) {
                serializeJson((*o26), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::trAvailableCustomerUpdates& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "trInstalledCustomerUpdates"

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::trInstalledCustomerUpdates& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasBUpdateExists()) {
        yajl_gen_string(g, (const unsigned char*)  "bUpdateExists" , 13);
        yajl_gen_bool(g, (bool)value.getBUpdateExists());
    }
    if (!isSparse || value.hasBHasFailedUpdate()) {
        yajl_gen_string(g, (const unsigned char*)  "bHasFailedUpdate" , 16);
        yajl_gen_bool(g, (bool)value.getBHasFailedUpdate());
    }
    if (!isSparse || value.hasUpdates()) {
        yajl_gen_string(g, (const unsigned char*)  "updates" , 7);
        yajl_gen_array_open(g);
        const ::std::vector< ::fcswupdatesrv::FcSwUpdateSrv::trCustomerUpdate >& o29 = value.getUpdates();
        {
            ::std::vector< ::fcswupdatesrv::FcSwUpdateSrv::trCustomerUpdate >::const_iterator o28;
            for (o28 = o29.begin(); o28 != o29.end(); ++o28) {
                serializeJson((*o28), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::trInstalledCustomerUpdates& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "trCustomerUpdates"

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::trCustomerUpdates& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasUpdates()) {
        yajl_gen_string(g, (const unsigned char*)  "updates" , 7);
        yajl_gen_array_open(g);
        const ::std::vector< ::fcswupdatesrv::FcSwUpdateSrv::trCustomerUpdate >& o31 = value.getUpdates();
        {
            ::std::vector< ::fcswupdatesrv::FcSwUpdateSrv::trCustomerUpdate >::const_iterator o30;
            for (o30 = o31.begin(); o30 != o31.end(); ++o30) {
                serializeJson((*o30), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::trCustomerUpdates& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "trBgImageInfo"

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::trBgImageInfo& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasImgDirPath()) {
        yajl_gen_string(g, (const unsigned char*)  "imgDirPath" , 10);
        const char *s = value.getImgDirPath().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasImgName()) {
        yajl_gen_string(g, (const unsigned char*)  "imgName" , 7);
        const char *s = value.getImgName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::trBgImageInfo& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "trFontInfo"

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::trFontInfo& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasFontName()) {
        yajl_gen_string(g, (const unsigned char*)  "fontName" , 8);
        const char *s = value.getFontName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasFontSrcLocation()) {
        yajl_gen_string(g, (const unsigned char*)  "fontSrcLocation" , 15);
        const char *s = value.getFontSrcLocation().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasCheckSum()) {
        yajl_gen_string(g, (const unsigned char*)  "checkSum" , 8);
        const char *s = value.getCheckSum().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::trFontInfo& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "trDisplayVariant"

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::trDisplayVariant& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasEnDisplayVariant()) {
        yajl_gen_string(g, (const unsigned char*)  "enDisplayVariant" , 16);
        const char* s = ::fcswupdatesrv::FcSwUpdateSrv::tenDisplayVariant_Name(value.getEnDisplayVariant());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getEnDisplayVariant());
    }
    if (!isSparse || value.hasWidth()) {
        yajl_gen_string(g, (const unsigned char*)  "width" , 5);
        yajl_gen_integer(g, (long long)value.getWidth());
    }
    if (!isSparse || value.hasHeight()) {
        yajl_gen_string(g, (const unsigned char*)  "height" , 6);
        yajl_gen_integer(g, (long long)value.getHeight());
    }
    if (!isSparse || value.hasAspectRatio()) {
        yajl_gen_string(g, (const unsigned char*)  "aspectRatio" , 11);
        const char *s = value.getAspectRatio().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::trDisplayVariant& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "trVerifyChecksumResult"

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::trVerifyChecksumResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasEnType()) {
        yajl_gen_string(g, (const unsigned char*)  "enType" , 6);
        const char* s = ::fcswupdatesrv::FcSwUpdateSrv::tenVerifyType_Name(value.getEnType());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getEnType());
    }
    if (!isSparse || value.hasArea()) {
        yajl_gen_string(g, (const unsigned char*)  "area" , 4);
        const char *s = value.getArea().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasChecksum()) {
        yajl_gen_string(g, (const unsigned char*)  "checksum" , 8);
        const char *s = value.getChecksum().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasEnResult()) {
        yajl_gen_string(g, (const unsigned char*)  "enResult" , 8);
        const char* s = ::fcswupdatesrv::FcSwUpdateSrv::tenVerifyResult_Name(value.getEnResult());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getEnResult());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::trVerifyChecksumResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "trVerifyChecksumRequest"

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::trVerifyChecksumRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasEnVerifyType()) {
        yajl_gen_string(g, (const unsigned char*)  "enVerifyType" , 12);
        const char* s = ::fcswupdatesrv::FcSwUpdateSrv::tenVerifyType_Name(value.getEnVerifyType());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getEnVerifyType());
    }
    if (!isSparse || value.hasArea()) {
        yajl_gen_string(g, (const unsigned char*)  "area" , 4);
        const char *s = value.getArea().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::trVerifyChecksumRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "trGetUpdateHistoryDetailedRequest"

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::trGetUpdateHistoryDetailedRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasEnScope()) {
        yajl_gen_string(g, (const unsigned char*)  "enScope" , 7);
        const char* s = ::fcswupdatesrv::FcSwUpdateSrv::tenHistoryScope_Name(value.getEnScope());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getEnScope());
    }
    if (!isSparse || value.hasIndexStart()) {
        yajl_gen_string(g, (const unsigned char*)  "indexStart" , 10);
        yajl_gen_integer(g, (long long)value.getIndexStart());
    }
    if (!isSparse || value.hasNumEntriesMax()) {
        yajl_gen_string(g, (const unsigned char*)  "numEntriesMax" , 13);
        yajl_gen_integer(g, (long long)value.getNumEntriesMax());
    }
    if (!isSparse || value.hasEnFormat()) {
        yajl_gen_string(g, (const unsigned char*)  "enFormat" , 8);
        const char* s = ::fcswupdatesrv::FcSwUpdateSrv::tenHistoryFormat_Name(value.getEnFormat());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getEnFormat());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::trGetUpdateHistoryDetailedRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "trGetUpdateHistoryDetailed"

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::trGetUpdateHistoryDetailed& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasEnScope()) {
        yajl_gen_string(g, (const unsigned char*)  "enScope" , 7);
        const char* s = ::fcswupdatesrv::FcSwUpdateSrv::tenHistoryScope_Name(value.getEnScope());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getEnScope());
    }
    if (!isSparse || value.hasLogs()) {
        yajl_gen_string(g, (const unsigned char*)  "logs" , 4);
        serializeJson(value.getLogs(), g, options);
    }
    if (!isSparse || value.hasNumberOfUpdates()) {
        yajl_gen_string(g, (const unsigned char*)  "numberOfUpdates" , 15);
        yajl_gen_integer(g, (long long)value.getNumberOfUpdates());
    }
    if (!isSparse || value.hasNumberOfUpdatesSinceDelivery()) {
        yajl_gen_string(g, (const unsigned char*)  "numberOfUpdatesSinceDelivery" , 28);
        yajl_gen_integer(g, (long long)value.getNumberOfUpdatesSinceDelivery());
    }
    if (!isSparse || value.hasNumberOfUpateLogs()) {
        yajl_gen_string(g, (const unsigned char*)  "numberOfUpateLogs" , 17);
        yajl_gen_integer(g, (long long)value.getNumberOfUpateLogs());
    }
    if (!isSparse || value.hasEnFormat()) {
        yajl_gen_string(g, (const unsigned char*)  "enFormat" , 8);
        const char* s = ::fcswupdatesrv::FcSwUpdateSrv::tenHistoryFormat_Name(value.getEnFormat());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getEnFormat());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::trGetUpdateHistoryDetailed& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "trBgLocks"

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::trBgLocks& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasLocks()) {
        yajl_gen_string(g, (const unsigned char*)  "locks" , 5);
        yajl_gen_array_open(g);
        const ::std::vector< ::std::string >& o33 = value.getLocks();
        {
            ::std::vector< ::std::string >::const_iterator o32;
            for (o32 = o33.begin(); o32 != o33.end(); ++o32) {
                const char *s = (*o32).c_str();
                genStringAndCheck(g, (const unsigned char*) s , strlen(s));
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::trBgLocks& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "trBgLocksState"

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::trBgLocksState& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasRegisteredLocks()) {
        yajl_gen_string(g, (const unsigned char*)  "registeredLocks" , 15);
        serializeJson(value.getRegisteredLocks(), g, options);
    }
    if (!isSparse || value.hasPendingLocks()) {
        yajl_gen_string(g, (const unsigned char*)  "pendingLocks" , 12);
        serializeJson(value.getPendingLocks(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::trBgLocksState& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "StoreHistoryToStickRequest"

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::StoreHistoryToStickRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasSinceFactoryReset()) {
        yajl_gen_string(g, (const unsigned char*)  "sinceFactoryReset" , 17);
        yajl_gen_bool(g, (bool)value.getSinceFactoryReset());
    }
    if (!isSparse || value.hasWriteToAllSticks()) {
        yajl_gen_string(g, (const unsigned char*)  "writeToAllSticks" , 16);
        yajl_gen_bool(g, (bool)value.getWriteToAllSticks());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::StoreHistoryToStickRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "StoreHistoryToStickResponse"

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::StoreHistoryToStickResponse& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasBOk()) {
        yajl_gen_string(g, (const unsigned char*)  "bOk" , 3);
        yajl_gen_bool(g, (bool)value.getBOk());
    }
    if (!isSparse || value.hasEnResult()) {
        yajl_gen_string(g, (const unsigned char*)  "enResult" , 8);
        const char* s = ::fcswupdatesrv::FcSwUpdateSrv::tenStoreHistoryResult_Name(value.getEnResult());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getEnResult());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::StoreHistoryToStickResponse& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "UpdateEnterRequest"

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::UpdateEnterRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasEnUser()) {
        yajl_gen_string(g, (const unsigned char*)  "enUser" , 6);
        const char* s = ::fcswupdatesrv::FcSwUpdateSrv::tenUser_Name(value.getEnUser());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getEnUser());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::UpdateEnterRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "UpdateEnterResponse"

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::UpdateEnterResponse& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasBOk()) {
        yajl_gen_string(g, (const unsigned char*)  "bOk" , 3);
        yajl_gen_bool(g, (bool)value.getBOk());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::UpdateEnterResponse& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "UpdateSetReleaseFilterRequest"

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::UpdateSetReleaseFilterRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasFilter()) {
        yajl_gen_string(g, (const unsigned char*)  "filter" , 6);
        serializeJson(value.getFilter(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::UpdateSetReleaseFilterRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "UpdateSetReleaseFilterResponse"

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::UpdateSetReleaseFilterResponse& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasBOk()) {
        yajl_gen_string(g, (const unsigned char*)  "bOk" , 3);
        yajl_gen_bool(g, (bool)value.getBOk());
    }
    if (!isSparse || value.hasResFilter()) {
        yajl_gen_string(g, (const unsigned char*)  "resFilter" , 9);
        serializeJson(value.getResFilter(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::UpdateSetReleaseFilterResponse& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "UpdateGetSourcesResponse"

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::UpdateGetSourcesResponse& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasBOk()) {
        yajl_gen_string(g, (const unsigned char*)  "bOk" , 3);
        yajl_gen_bool(g, (bool)value.getBOk());
    }
    if (!isSparse || value.hasSources()) {
        yajl_gen_string(g, (const unsigned char*)  "sources" , 7);
        serializeJson(value.getSources(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::UpdateGetSourcesResponse& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "UpdateSelectSourceRequest"

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::UpdateSelectSourceRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasSourceIndex()) {
        yajl_gen_string(g, (const unsigned char*)  "sourceIndex" , 11);
        yajl_gen_integer(g, (long long)value.getSourceIndex());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::UpdateSelectSourceRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "UpdateSelectSourceResponse"

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::UpdateSelectSourceResponse& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasBOk()) {
        yajl_gen_string(g, (const unsigned char*)  "bOk" , 3);
        yajl_gen_bool(g, (bool)value.getBOk());
    }
    if (!isSparse || value.hasReleaseInfos()) {
        yajl_gen_string(g, (const unsigned char*)  "releaseInfos" , 12);
        serializeJson(value.getReleaseInfos(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::UpdateSelectSourceResponse& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "UpdateSelectReleaseRequest"

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::UpdateSelectReleaseRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasReleaseIndex()) {
        yajl_gen_string(g, (const unsigned char*)  "releaseIndex" , 12);
        yajl_gen_integer(g, (long long)value.getReleaseIndex());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::UpdateSelectReleaseRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "UpdateSelectReleaseResponse"

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::UpdateSelectReleaseResponse& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasBOk()) {
        yajl_gen_string(g, (const unsigned char*)  "bOk" , 3);
        yajl_gen_bool(g, (bool)value.getBOk());
    }
    if (!isSparse || value.hasEnErrorId()) {
        yajl_gen_string(g, (const unsigned char*)  "enErrorId" , 9);
        const char* s = ::fcswupdatesrv::FcSwUpdateSrv::tenErrorId_Name(value.getEnErrorId());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getEnErrorId());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::UpdateSelectReleaseResponse& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GetDeviceStateListResponse"

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::GetDeviceStateListResponse& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasBOk()) {
        yajl_gen_string(g, (const unsigned char*)  "bOk" , 3);
        yajl_gen_bool(g, (bool)value.getBOk());
    }
    if (!isSparse || value.hasDeviceStates()) {
        yajl_gen_string(g, (const unsigned char*)  "deviceStates" , 12);
        serializeJson(value.getDeviceStates(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::GetDeviceStateListResponse& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetUpdateOptionsRequest"

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::SetUpdateOptionsRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasEnOption()) {
        yajl_gen_string(g, (const unsigned char*)  "enOption" , 8);
        const char* s = ::fcswupdatesrv::FcSwUpdateSrv::tenUpdOptions_Name(value.getEnOption());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getEnOption());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::SetUpdateOptionsRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetUpdateOptionsResponse"

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::SetUpdateOptionsResponse& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasBOk()) {
        yajl_gen_string(g, (const unsigned char*)  "bOk" , 3);
        yajl_gen_bool(g, (bool)value.getBOk());
    }
    if (!isSparse || value.hasEnOptionRes()) {
        yajl_gen_string(g, (const unsigned char*)  "enOptionRes" , 11);
        const char* s = ::fcswupdatesrv::FcSwUpdateSrv::tenUpdOptions_Name(value.getEnOptionRes());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getEnOptionRes());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::SetUpdateOptionsResponse& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ModifyReleaseDocRequest"

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::ModifyReleaseDocRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasEnModifyAction()) {
        yajl_gen_string(g, (const unsigned char*)  "enModifyAction" , 14);
        serializeJson(value.getEnModifyAction(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::ModifyReleaseDocRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ModifyReleaseDocResponse"

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::ModifyReleaseDocResponse& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasBOk()) {
        yajl_gen_string(g, (const unsigned char*)  "bOk" , 3);
        yajl_gen_bool(g, (bool)value.getBOk());
    }
    if (!isSparse || value.hasEnModifyActionRes()) {
        yajl_gen_string(g, (const unsigned char*)  "enModifyActionRes" , 17);
        serializeJson(value.getEnModifyActionRes(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::ModifyReleaseDocResponse& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GetUpdateFileResponse"

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::GetUpdateFileResponse& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasBOk()) {
        yajl_gen_string(g, (const unsigned char*)  "bOk" , 3);
        yajl_gen_bool(g, (bool)value.getBOk());
    }
    if (!isSparse || value.hasEnResult()) {
        yajl_gen_string(g, (const unsigned char*)  "enResult" , 8);
        const char* s = ::fcswupdatesrv::FcSwUpdateSrv::tenGetUpdateFileResult_Name(value.getEnResult());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getEnResult());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::GetUpdateFileResponse& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ApplyDocResponse"

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::ApplyDocResponse& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasBOk()) {
        yajl_gen_string(g, (const unsigned char*)  "bOk" , 3);
        yajl_gen_bool(g, (bool)value.getBOk());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::ApplyDocResponse& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ApplyLockResponse"

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::ApplyLockResponse& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasBOk()) {
        yajl_gen_string(g, (const unsigned char*)  "bOk" , 3);
        yajl_gen_bool(g, (bool)value.getBOk());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::ApplyLockResponse& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "UpdateSelectReleaseByFileRequest"

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::UpdateSelectReleaseByFileRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasReleaseAccess()) {
        yajl_gen_string(g, (const unsigned char*)  "releaseAccess" , 13);
        serializeJson(value.getReleaseAccess(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::UpdateSelectReleaseByFileRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "UpdateSelectReleaseByFileResponse"

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::UpdateSelectReleaseByFileResponse& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasBOk()) {
        yajl_gen_string(g, (const unsigned char*)  "bOk" , 3);
        yajl_gen_bool(g, (bool)value.getBOk());
    }
    if (!isSparse || value.hasEnErrorId()) {
        yajl_gen_string(g, (const unsigned char*)  "enErrorId" , 9);
        const char* s = ::fcswupdatesrv::FcSwUpdateSrv::tenErrorId_Name(value.getEnErrorId());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getEnErrorId());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::UpdateSelectReleaseByFileResponse& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "RetryFailedModulesResponse"

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::RetryFailedModulesResponse& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasBOk()) {
        yajl_gen_string(g, (const unsigned char*)  "bOk" , 3);
        yajl_gen_bool(g, (bool)value.getBOk());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::RetryFailedModulesResponse& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "UpdateEndResponse"

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::UpdateEndResponse& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasBOk()) {
        yajl_gen_string(g, (const unsigned char*)  "bOk" , 3);
        yajl_gen_bool(g, (bool)value.getBOk());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::UpdateEndResponse& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "UpdateAbortRequest"

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::UpdateAbortRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasBDeviceOnly()) {
        yajl_gen_string(g, (const unsigned char*)  "bDeviceOnly" , 11);
        yajl_gen_bool(g, (bool)value.getBDeviceOnly());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::UpdateAbortRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "UpdateAbortResponse"

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::UpdateAbortResponse& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasBOk()) {
        yajl_gen_string(g, (const unsigned char*)  "bOk" , 3);
        yajl_gen_bool(g, (bool)value.getBOk());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::UpdateAbortResponse& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "UpdateAbortDeviceRequest"

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::UpdateAbortDeviceRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasRefKey()) {
        yajl_gen_string(g, (const unsigned char*)  "refKey" , 6);
        const char *s = value.getRefKey().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::UpdateAbortDeviceRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "UpdateAbortDeviceResponse"

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::UpdateAbortDeviceResponse& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasBOk()) {
        yajl_gen_string(g, (const unsigned char*)  "bOk" , 3);
        yajl_gen_bool(g, (bool)value.getBOk());
    }
    if (!isSparse || value.hasRAbortDeviceRes()) {
        yajl_gen_string(g, (const unsigned char*)  "rAbortDeviceRes" , 15);
        serializeJson(value.getRAbortDeviceRes(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::UpdateAbortDeviceResponse& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "HandleErrorRequest"

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::HandleErrorRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasEnMode()) {
        yajl_gen_string(g, (const unsigned char*)  "enMode" , 6);
        const char* s = ::fcswupdatesrv::FcSwUpdateSrv::tenErrorHandlingMode_Name(value.getEnMode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getEnMode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::HandleErrorRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "HandleErrorResponse"

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::HandleErrorResponse& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasBOk()) {
        yajl_gen_string(g, (const unsigned char*)  "bOk" , 3);
        yajl_gen_bool(g, (bool)value.getBOk());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::HandleErrorResponse& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GetUpdateHistoryResponse"

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::GetUpdateHistoryResponse& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasBOk()) {
        yajl_gen_string(g, (const unsigned char*)  "bOk" , 3);
        yajl_gen_bool(g, (bool)value.getBOk());
    }
    if (!isSparse || value.hasLogs()) {
        yajl_gen_string(g, (const unsigned char*)  "logs" , 4);
        serializeJson(value.getLogs(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::GetUpdateHistoryResponse& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GetUpdateHistoryScopedRequest"

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::GetUpdateHistoryScopedRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasEnScope()) {
        yajl_gen_string(g, (const unsigned char*)  "enScope" , 7);
        const char* s = ::fcswupdatesrv::FcSwUpdateSrv::tenHistoryScope_Name(value.getEnScope());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getEnScope());
    }
    if (!isSparse || value.hasIndexStart()) {
        yajl_gen_string(g, (const unsigned char*)  "indexStart" , 10);
        yajl_gen_integer(g, (long long)value.getIndexStart());
    }
    if (!isSparse || value.hasNumEntriesMax()) {
        yajl_gen_string(g, (const unsigned char*)  "numEntriesMax" , 13);
        yajl_gen_integer(g, (long long)value.getNumEntriesMax());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::GetUpdateHistoryScopedRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GetUpdateHistoryScopedResponse"

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::GetUpdateHistoryScopedResponse& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasBOk()) {
        yajl_gen_string(g, (const unsigned char*)  "bOk" , 3);
        yajl_gen_bool(g, (bool)value.getBOk());
    }
    if (!isSparse || value.hasEnScopeRes()) {
        yajl_gen_string(g, (const unsigned char*)  "enScopeRes" , 10);
        const char* s = ::fcswupdatesrv::FcSwUpdateSrv::tenHistoryScope_Name(value.getEnScopeRes());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getEnScopeRes());
    }
    if (!isSparse || value.hasLogs()) {
        yajl_gen_string(g, (const unsigned char*)  "logs" , 4);
        serializeJson(value.getLogs(), g, options);
    }
    if (!isSparse || value.hasNumberOfUpdates()) {
        yajl_gen_string(g, (const unsigned char*)  "numberOfUpdates" , 15);
        yajl_gen_integer(g, (long long)value.getNumberOfUpdates());
    }
    if (!isSparse || value.hasNumberOfUpdatesSinceDelivery()) {
        yajl_gen_string(g, (const unsigned char*)  "numberOfUpdatesSinceDelivery" , 28);
        yajl_gen_integer(g, (long long)value.getNumberOfUpdatesSinceDelivery());
    }
    if (!isSparse || value.hasNumberOfUpateLogs()) {
        yajl_gen_string(g, (const unsigned char*)  "numberOfUpateLogs" , 17);
        yajl_gen_integer(g, (long long)value.getNumberOfUpateLogs());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::GetUpdateHistoryScopedResponse& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GetUpdateHistoryDetailedRequest"

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::GetUpdateHistoryDetailedRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasRequest()) {
        yajl_gen_string(g, (const unsigned char*)  "request" , 7);
        serializeJson(value.getRequest(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::GetUpdateHistoryDetailedRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GetUpdateHistoryDetailedResponse"

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::GetUpdateHistoryDetailedResponse& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasBOk()) {
        yajl_gen_string(g, (const unsigned char*)  "bOk" , 3);
        yajl_gen_bool(g, (bool)value.getBOk());
    }
    if (!isSparse || value.hasResult()) {
        yajl_gen_string(g, (const unsigned char*)  "result" , 6);
        serializeJson(value.getResult(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::GetUpdateHistoryDetailedResponse& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DeleteHistoryRequestRequest"

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::DeleteHistoryRequestRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasSinceFactoryResetOnly()) {
        yajl_gen_string(g, (const unsigned char*)  "sinceFactoryResetOnly" , 21);
        yajl_gen_bool(g, (bool)value.getSinceFactoryResetOnly());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::DeleteHistoryRequestRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DeleteHistoryRequestResponse"

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::DeleteHistoryRequestResponse& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasBOk()) {
        yajl_gen_string(g, (const unsigned char*)  "bOk" , 3);
        yajl_gen_bool(g, (bool)value.getBOk());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::DeleteHistoryRequestResponse& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GetTargetStateRequest"

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::GetTargetStateRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasEnUpdateType()) {
        yajl_gen_string(g, (const unsigned char*)  "enUpdateType" , 12);
        const char* s = ::fcswupdatesrv::FcSwUpdateSrv::tenUpdType_Name(value.getEnUpdateType());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getEnUpdateType());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::GetTargetStateRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GetTargetStateResponse"

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::GetTargetStateResponse& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasBOk()) {
        yajl_gen_string(g, (const unsigned char*)  "bOk" , 3);
        yajl_gen_bool(g, (bool)value.getBOk());
    }
    if (!isSparse || value.hasTargetState()) {
        yajl_gen_string(g, (const unsigned char*)  "targetState" , 11);
        serializeJson(value.getTargetState(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::GetTargetStateResponse& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetVersionBackDocAckRequest"

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::SetVersionBackDocAckRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasAck()) {
        yajl_gen_string(g, (const unsigned char*)  "ack" , 3);
        yajl_gen_integer(g, (long long)value.getAck());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::SetVersionBackDocAckRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetVersionBackDocAckResponse"

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::SetVersionBackDocAckResponse& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasBOk()) {
        yajl_gen_string(g, (const unsigned char*)  "bOk" , 3);
        yajl_gen_bool(g, (bool)value.getBOk());
    }
    if (!isSparse || value.hasInfo()) {
        yajl_gen_string(g, (const unsigned char*)  "info" , 4);
        serializeJson(value.getInfo(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::SetVersionBackDocAckResponse& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetAllowRecoveryModeRequest"

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::SetAllowRecoveryModeRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasAllow()) {
        yajl_gen_string(g, (const unsigned char*)  "allow" , 5);
        yajl_gen_bool(g, (bool)value.getAllow());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::SetAllowRecoveryModeRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetAllowRecoveryModeResponse"

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::SetAllowRecoveryModeResponse& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasBOk()) {
        yajl_gen_string(g, (const unsigned char*)  "bOk" , 3);
        yajl_gen_bool(g, (bool)value.getBOk());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::SetAllowRecoveryModeResponse& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GetCacheDirectoryRequest"

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::GetCacheDirectoryRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasRequest()) {
        yajl_gen_string(g, (const unsigned char*)  "request" , 7);
        serializeJson(value.getRequest(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::GetCacheDirectoryRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GetCacheDirectoryResponse"

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::GetCacheDirectoryResponse& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasBOk()) {
        yajl_gen_string(g, (const unsigned char*)  "bOk" , 3);
        yajl_gen_bool(g, (bool)value.getBOk());
    }
    if (!isSparse || value.hasDirectory()) {
        yajl_gen_string(g, (const unsigned char*)  "directory" , 9);
        const char *s = value.getDirectory().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::GetCacheDirectoryResponse& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "EnterRecoveryModeResponse"

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::EnterRecoveryModeResponse& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasBOk()) {
        yajl_gen_string(g, (const unsigned char*)  "bOk" , 3);
        yajl_gen_bool(g, (bool)value.getBOk());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::EnterRecoveryModeResponse& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "VerifyChecksumRequest"

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::VerifyChecksumRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasVerifyRequest()) {
        yajl_gen_string(g, (const unsigned char*)  "verifyRequest" , 13);
        serializeJson(value.getVerifyRequest(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::VerifyChecksumRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "VerifyChecksumResponse"

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::VerifyChecksumResponse& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasBOk()) {
        yajl_gen_string(g, (const unsigned char*)  "bOk" , 3);
        yajl_gen_bool(g, (bool)value.getBOk());
    }
    if (!isSparse || value.hasVerifyResult()) {
        yajl_gen_string(g, (const unsigned char*)  "verifyResult" , 12);
        serializeJson(value.getVerifyResult(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::VerifyChecksumResponse& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "RegisterBgLocksRequest"

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::RegisterBgLocksRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasLocks()) {
        yajl_gen_string(g, (const unsigned char*)  "locks" , 5);
        serializeJson(value.getLocks(), g, options);
    }
    if (!isSparse || value.hasMode()) {
        yajl_gen_string(g, (const unsigned char*)  "mode" , 4);
        const char* s = ::fcswupdatesrv::FcSwUpdateSrv::tenLockRegisterMode_Name(value.getMode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getMode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::RegisterBgLocksRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "RegisterBgLocksResponse"

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::RegisterBgLocksResponse& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasBOk()) {
        yajl_gen_string(g, (const unsigned char*)  "bOk" , 3);
        yajl_gen_bool(g, (bool)value.getBOk());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::RegisterBgLocksResponse& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "UpdateStateUpdate"

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::UpdateStateUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasUpdateState()) {
        yajl_gen_string(g, (const unsigned char*)  "UpdateState" , 11);
        serializeJson(value.getUpdateState(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::UpdateStateUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "UpdateStateRegister"

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::UpdateStateRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::UpdateStateRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "UpdateSourcesUpdate"

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::UpdateSourcesUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasUpdateSources()) {
        yajl_gen_string(g, (const unsigned char*)  "UpdateSources" , 13);
        serializeJson(value.getUpdateSources(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::UpdateSourcesUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "UpdateSourcesRegister"

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::UpdateSourcesRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::UpdateSourcesRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ReleaseFilterUpdate"

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::ReleaseFilterUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasReleaseFilter()) {
        yajl_gen_string(g, (const unsigned char*)  "ReleaseFilter" , 13);
        serializeJson(value.getReleaseFilter(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::ReleaseFilterUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ReleaseFilterRegister"

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::ReleaseFilterRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::ReleaseFilterRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ReleaseDocUpdate"

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::ReleaseDocUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasReleaseDoc()) {
        yajl_gen_string(g, (const unsigned char*)  "ReleaseDoc" , 10);
        serializeJson(value.getReleaseDoc(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::ReleaseDocUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ReleaseDocRegister"

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::ReleaseDocRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::ReleaseDocRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "PreReleaseDocUpdate"

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::PreReleaseDocUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasPreReleaseDoc()) {
        yajl_gen_string(g, (const unsigned char*)  "PreReleaseDoc" , 13);
        serializeJson(value.getPreReleaseDoc(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::PreReleaseDocUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "PreReleaseDocRegister"

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::PreReleaseDocRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::PreReleaseDocRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "UpdateProgressUpdate"

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::UpdateProgressUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasUpdateProgress()) {
        yajl_gen_string(g, (const unsigned char*)  "UpdateProgress" , 14);
        serializeJson(value.getUpdateProgress(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::UpdateProgressUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "UpdateProgressRegister"

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::UpdateProgressRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::UpdateProgressRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "UpdateResultUpdate"

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::UpdateResultUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasUpdateResult()) {
        yajl_gen_string(g, (const unsigned char*)  "UpdateResult" , 12);
        serializeJson(value.getUpdateResult(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::UpdateResultUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "UpdateResultRegister"

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::UpdateResultRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::UpdateResultRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "UpdateErrorsUpdate"

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::UpdateErrorsUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasUpdateErrors()) {
        yajl_gen_string(g, (const unsigned char*)  "UpdateErrors" , 12);
        serializeJson(value.getUpdateErrors(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::UpdateErrorsUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "UpdateErrorsRegister"

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::UpdateErrorsRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::UpdateErrorsRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "CustomerUpdatesUpdate"

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::CustomerUpdatesUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasCustomerUpdates()) {
        yajl_gen_string(g, (const unsigned char*)  "CustomerUpdates" , 15);
        serializeJson(value.getCustomerUpdates(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::CustomerUpdatesUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "CustomerUpdatesRegister"

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::CustomerUpdatesRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::CustomerUpdatesRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "VersionBackDocInfoUpdate"

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::VersionBackDocInfoUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasVersionBackDocInfo()) {
        yajl_gen_string(g, (const unsigned char*)  "VersionBackDocInfo" , 18);
        serializeJson(value.getVersionBackDocInfo(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::VersionBackDocInfoUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "VersionBackDocInfoRegister"

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::VersionBackDocInfoRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::VersionBackDocInfoRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "AvailableCustomerUpdatesUpdate"

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::AvailableCustomerUpdatesUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasAvailableCustomerUpdates()) {
        yajl_gen_string(g, (const unsigned char*)  "AvailableCustomerUpdates" , 24);
        serializeJson(value.getAvailableCustomerUpdates(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::AvailableCustomerUpdatesUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "AvailableCustomerUpdatesRegister"

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::AvailableCustomerUpdatesRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::AvailableCustomerUpdatesRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "UpdateBgImageInfoUpdate"

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::UpdateBgImageInfoUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasUpdateBgImageInfo()) {
        yajl_gen_string(g, (const unsigned char*)  "UpdateBgImageInfo" , 17);
        serializeJson(value.getUpdateBgImageInfo(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::UpdateBgImageInfoUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "UpdateBgImageInfoRegister"

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::UpdateBgImageInfoRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::UpdateBgImageInfoRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "BgLocksStateUpdate"

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::BgLocksStateUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasBgLocksState()) {
        yajl_gen_string(g, (const unsigned char*)  "BgLocksState" , 12);
        serializeJson(value.getBgLocksState(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::BgLocksStateUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "BgLocksStateRegister"

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::BgLocksStateRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::fcswupdatesrv::FcSwUpdateSrv::BgLocksStateRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

using namespace ::asf::stream::json;

namespace fcswupdatesrv {
namespace FcSwUpdateSrv {

std::ostream& operator<<(std::ostream& o, const ::fcswupdatesrv::FcSwUpdateSrv::trUpdSource& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace FcSwUpdateSrv
} // namespace fcswupdatesrv
using namespace ::asf::stream::json;

namespace fcswupdatesrv {
namespace FcSwUpdateSrv {

std::ostream& operator<<(std::ostream& o, const ::fcswupdatesrv::FcSwUpdateSrv::trUpdSources& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace FcSwUpdateSrv
} // namespace fcswupdatesrv
using namespace ::asf::stream::json;

namespace fcswupdatesrv {
namespace FcSwUpdateSrv {

std::ostream& operator<<(std::ostream& o, const ::fcswupdatesrv::FcSwUpdateSrv::trSelectReleaseRes& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace FcSwUpdateSrv
} // namespace fcswupdatesrv
using namespace ::asf::stream::json;

namespace fcswupdatesrv {
namespace FcSwUpdateSrv {

std::ostream& operator<<(std::ostream& o, const ::fcswupdatesrv::FcSwUpdateSrv::trReleaseInfo& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace FcSwUpdateSrv
} // namespace fcswupdatesrv
using namespace ::asf::stream::json;

namespace fcswupdatesrv {
namespace FcSwUpdateSrv {

std::ostream& operator<<(std::ostream& o, const ::fcswupdatesrv::FcSwUpdateSrv::trReleaseAccess& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace FcSwUpdateSrv
} // namespace fcswupdatesrv
using namespace ::asf::stream::json;

namespace fcswupdatesrv {
namespace FcSwUpdateSrv {

std::ostream& operator<<(std::ostream& o, const ::fcswupdatesrv::FcSwUpdateSrv::trReleaseInfos& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace FcSwUpdateSrv
} // namespace fcswupdatesrv
using namespace ::asf::stream::json;

namespace fcswupdatesrv {
namespace FcSwUpdateSrv {

std::ostream& operator<<(std::ostream& o, const ::fcswupdatesrv::FcSwUpdateSrv::trDeviceState& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace FcSwUpdateSrv
} // namespace fcswupdatesrv
using namespace ::asf::stream::json;

namespace fcswupdatesrv {
namespace FcSwUpdateSrv {

std::ostream& operator<<(std::ostream& o, const ::fcswupdatesrv::FcSwUpdateSrv::trDeviceStates& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace FcSwUpdateSrv
} // namespace fcswupdatesrv
using namespace ::asf::stream::json;

namespace fcswupdatesrv {
namespace FcSwUpdateSrv {

std::ostream& operator<<(std::ostream& o, const ::fcswupdatesrv::FcSwUpdateSrv::trUpdState& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace FcSwUpdateSrv
} // namespace fcswupdatesrv
using namespace ::asf::stream::json;

namespace fcswupdatesrv {
namespace FcSwUpdateSrv {

std::ostream& operator<<(std::ostream& o, const ::fcswupdatesrv::FcSwUpdateSrv::trSubModuleData& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace FcSwUpdateSrv
} // namespace fcswupdatesrv
using namespace ::asf::stream::json;

namespace fcswupdatesrv {
namespace FcSwUpdateSrv {

std::ostream& operator<<(std::ostream& o, const ::fcswupdatesrv::FcSwUpdateSrv::trModuleData& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace FcSwUpdateSrv
} // namespace fcswupdatesrv
using namespace ::asf::stream::json;

namespace fcswupdatesrv {
namespace FcSwUpdateSrv {

std::ostream& operator<<(std::ostream& o, const ::fcswupdatesrv::FcSwUpdateSrv::trDeviceData& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace FcSwUpdateSrv
} // namespace fcswupdatesrv
using namespace ::asf::stream::json;

namespace fcswupdatesrv {
namespace FcSwUpdateSrv {

std::ostream& operator<<(std::ostream& o, const ::fcswupdatesrv::FcSwUpdateSrv::trTartgetState& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace FcSwUpdateSrv
} // namespace fcswupdatesrv
using namespace ::asf::stream::json;

namespace fcswupdatesrv {
namespace FcSwUpdateSrv {

std::ostream& operator<<(std::ostream& o, const ::fcswupdatesrv::FcSwUpdateSrv::trConfigProblem& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace FcSwUpdateSrv
} // namespace fcswupdatesrv
using namespace ::asf::stream::json;

namespace fcswupdatesrv {
namespace FcSwUpdateSrv {

std::ostream& operator<<(std::ostream& o, const ::fcswupdatesrv::FcSwUpdateSrv::trReleaseFilter& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace FcSwUpdateSrv
} // namespace fcswupdatesrv
using namespace ::asf::stream::json;

namespace fcswupdatesrv {
namespace FcSwUpdateSrv {

std::ostream& operator<<(std::ostream& o, const ::fcswupdatesrv::FcSwUpdateSrv::trReleaseDoc& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace FcSwUpdateSrv
} // namespace fcswupdatesrv
using namespace ::asf::stream::json;

namespace fcswupdatesrv {
namespace FcSwUpdateSrv {

std::ostream& operator<<(std::ostream& o, const ::fcswupdatesrv::FcSwUpdateSrv::trPreReleaseDoc& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace FcSwUpdateSrv
} // namespace fcswupdatesrv
using namespace ::asf::stream::json;

namespace fcswupdatesrv {
namespace FcSwUpdateSrv {

std::ostream& operator<<(std::ostream& o, const ::fcswupdatesrv::FcSwUpdateSrv::trModifyAction& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace FcSwUpdateSrv
} // namespace fcswupdatesrv
using namespace ::asf::stream::json;

namespace fcswupdatesrv {
namespace FcSwUpdateSrv {

std::ostream& operator<<(std::ostream& o, const ::fcswupdatesrv::FcSwUpdateSrv::trUpdProgress& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace FcSwUpdateSrv
} // namespace fcswupdatesrv
using namespace ::asf::stream::json;

namespace fcswupdatesrv {
namespace FcSwUpdateSrv {

std::ostream& operator<<(std::ostream& o, const ::fcswupdatesrv::FcSwUpdateSrv::trAbortDeviceRes& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace FcSwUpdateSrv
} // namespace fcswupdatesrv
using namespace ::asf::stream::json;

namespace fcswupdatesrv {
namespace FcSwUpdateSrv {

std::ostream& operator<<(std::ostream& o, const ::fcswupdatesrv::FcSwUpdateSrv::trTimeDate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace FcSwUpdateSrv
} // namespace fcswupdatesrv
using namespace ::asf::stream::json;

namespace fcswupdatesrv {
namespace FcSwUpdateSrv {

std::ostream& operator<<(std::ostream& o, const ::fcswupdatesrv::FcSwUpdateSrv::trResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace FcSwUpdateSrv
} // namespace fcswupdatesrv
using namespace ::asf::stream::json;

namespace fcswupdatesrv {
namespace FcSwUpdateSrv {

std::ostream& operator<<(std::ostream& o, const ::fcswupdatesrv::FcSwUpdateSrv::trErrorIds& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace FcSwUpdateSrv
} // namespace fcswupdatesrv
using namespace ::asf::stream::json;

namespace fcswupdatesrv {
namespace FcSwUpdateSrv {

std::ostream& operator<<(std::ostream& o, const ::fcswupdatesrv::FcSwUpdateSrv::trGetCacheDirectory& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace FcSwUpdateSrv
} // namespace fcswupdatesrv
using namespace ::asf::stream::json;

namespace fcswupdatesrv {
namespace FcSwUpdateSrv {

std::ostream& operator<<(std::ostream& o, const ::fcswupdatesrv::FcSwUpdateSrv::trUpdLog& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace FcSwUpdateSrv
} // namespace fcswupdatesrv
using namespace ::asf::stream::json;

namespace fcswupdatesrv {
namespace FcSwUpdateSrv {

std::ostream& operator<<(std::ostream& o, const ::fcswupdatesrv::FcSwUpdateSrv::trUpdLogs& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace FcSwUpdateSrv
} // namespace fcswupdatesrv
using namespace ::asf::stream::json;

namespace fcswupdatesrv {
namespace FcSwUpdateSrv {

std::ostream& operator<<(std::ostream& o, const ::fcswupdatesrv::FcSwUpdateSrv::trUpdateMedia& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace FcSwUpdateSrv
} // namespace fcswupdatesrv
using namespace ::asf::stream::json;

namespace fcswupdatesrv {
namespace FcSwUpdateSrv {

std::ostream& operator<<(std::ostream& o, const ::fcswupdatesrv::FcSwUpdateSrv::trVersionBackDocInfo& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace FcSwUpdateSrv
} // namespace fcswupdatesrv
using namespace ::asf::stream::json;

namespace fcswupdatesrv {
namespace FcSwUpdateSrv {

std::ostream& operator<<(std::ostream& o, const ::fcswupdatesrv::FcSwUpdateSrv::trCustomerUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace FcSwUpdateSrv
} // namespace fcswupdatesrv
using namespace ::asf::stream::json;

namespace fcswupdatesrv {
namespace FcSwUpdateSrv {

std::ostream& operator<<(std::ostream& o, const ::fcswupdatesrv::FcSwUpdateSrv::trAvailableCustomerUpdates& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace FcSwUpdateSrv
} // namespace fcswupdatesrv
using namespace ::asf::stream::json;

namespace fcswupdatesrv {
namespace FcSwUpdateSrv {

std::ostream& operator<<(std::ostream& o, const ::fcswupdatesrv::FcSwUpdateSrv::trInstalledCustomerUpdates& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace FcSwUpdateSrv
} // namespace fcswupdatesrv
using namespace ::asf::stream::json;

namespace fcswupdatesrv {
namespace FcSwUpdateSrv {

std::ostream& operator<<(std::ostream& o, const ::fcswupdatesrv::FcSwUpdateSrv::trCustomerUpdates& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace FcSwUpdateSrv
} // namespace fcswupdatesrv
using namespace ::asf::stream::json;

namespace fcswupdatesrv {
namespace FcSwUpdateSrv {

std::ostream& operator<<(std::ostream& o, const ::fcswupdatesrv::FcSwUpdateSrv::trBgImageInfo& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace FcSwUpdateSrv
} // namespace fcswupdatesrv
using namespace ::asf::stream::json;

namespace fcswupdatesrv {
namespace FcSwUpdateSrv {

std::ostream& operator<<(std::ostream& o, const ::fcswupdatesrv::FcSwUpdateSrv::trFontInfo& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace FcSwUpdateSrv
} // namespace fcswupdatesrv
using namespace ::asf::stream::json;

namespace fcswupdatesrv {
namespace FcSwUpdateSrv {

std::ostream& operator<<(std::ostream& o, const ::fcswupdatesrv::FcSwUpdateSrv::trDisplayVariant& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace FcSwUpdateSrv
} // namespace fcswupdatesrv
using namespace ::asf::stream::json;

namespace fcswupdatesrv {
namespace FcSwUpdateSrv {

std::ostream& operator<<(std::ostream& o, const ::fcswupdatesrv::FcSwUpdateSrv::trVerifyChecksumResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace FcSwUpdateSrv
} // namespace fcswupdatesrv
using namespace ::asf::stream::json;

namespace fcswupdatesrv {
namespace FcSwUpdateSrv {

std::ostream& operator<<(std::ostream& o, const ::fcswupdatesrv::FcSwUpdateSrv::trVerifyChecksumRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace FcSwUpdateSrv
} // namespace fcswupdatesrv
using namespace ::asf::stream::json;

namespace fcswupdatesrv {
namespace FcSwUpdateSrv {

std::ostream& operator<<(std::ostream& o, const ::fcswupdatesrv::FcSwUpdateSrv::trGetUpdateHistoryDetailedRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace FcSwUpdateSrv
} // namespace fcswupdatesrv
using namespace ::asf::stream::json;

namespace fcswupdatesrv {
namespace FcSwUpdateSrv {

std::ostream& operator<<(std::ostream& o, const ::fcswupdatesrv::FcSwUpdateSrv::trGetUpdateHistoryDetailed& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace FcSwUpdateSrv
} // namespace fcswupdatesrv
using namespace ::asf::stream::json;

namespace fcswupdatesrv {
namespace FcSwUpdateSrv {

std::ostream& operator<<(std::ostream& o, const ::fcswupdatesrv::FcSwUpdateSrv::trBgLocks& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace FcSwUpdateSrv
} // namespace fcswupdatesrv
using namespace ::asf::stream::json;

namespace fcswupdatesrv {
namespace FcSwUpdateSrv {

std::ostream& operator<<(std::ostream& o, const ::fcswupdatesrv::FcSwUpdateSrv::trBgLocksState& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace FcSwUpdateSrv
} // namespace fcswupdatesrv
using namespace ::asf::stream::json;

namespace fcswupdatesrv {
namespace FcSwUpdateSrv {

std::ostream& operator<<(std::ostream& o, const ::fcswupdatesrv::FcSwUpdateSrv::StoreHistoryToStickRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace FcSwUpdateSrv
} // namespace fcswupdatesrv
using namespace ::asf::stream::json;

namespace fcswupdatesrv {
namespace FcSwUpdateSrv {

std::ostream& operator<<(std::ostream& o, const ::fcswupdatesrv::FcSwUpdateSrv::StoreHistoryToStickResponse& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace FcSwUpdateSrv
} // namespace fcswupdatesrv
using namespace ::asf::stream::json;

namespace fcswupdatesrv {
namespace FcSwUpdateSrv {

std::ostream& operator<<(std::ostream& o, const ::fcswupdatesrv::FcSwUpdateSrv::UpdateEnterRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace FcSwUpdateSrv
} // namespace fcswupdatesrv
using namespace ::asf::stream::json;

namespace fcswupdatesrv {
namespace FcSwUpdateSrv {

std::ostream& operator<<(std::ostream& o, const ::fcswupdatesrv::FcSwUpdateSrv::UpdateEnterResponse& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace FcSwUpdateSrv
} // namespace fcswupdatesrv
using namespace ::asf::stream::json;

namespace fcswupdatesrv {
namespace FcSwUpdateSrv {

std::ostream& operator<<(std::ostream& o, const ::fcswupdatesrv::FcSwUpdateSrv::UpdateSetReleaseFilterRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace FcSwUpdateSrv
} // namespace fcswupdatesrv
using namespace ::asf::stream::json;

namespace fcswupdatesrv {
namespace FcSwUpdateSrv {

std::ostream& operator<<(std::ostream& o, const ::fcswupdatesrv::FcSwUpdateSrv::UpdateSetReleaseFilterResponse& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace FcSwUpdateSrv
} // namespace fcswupdatesrv
using namespace ::asf::stream::json;

namespace fcswupdatesrv {
namespace FcSwUpdateSrv {

std::ostream& operator<<(std::ostream& o, const ::fcswupdatesrv::FcSwUpdateSrv::UpdateGetSourcesResponse& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace FcSwUpdateSrv
} // namespace fcswupdatesrv
using namespace ::asf::stream::json;

namespace fcswupdatesrv {
namespace FcSwUpdateSrv {

std::ostream& operator<<(std::ostream& o, const ::fcswupdatesrv::FcSwUpdateSrv::UpdateSelectSourceRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace FcSwUpdateSrv
} // namespace fcswupdatesrv
using namespace ::asf::stream::json;

namespace fcswupdatesrv {
namespace FcSwUpdateSrv {

std::ostream& operator<<(std::ostream& o, const ::fcswupdatesrv::FcSwUpdateSrv::UpdateSelectSourceResponse& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace FcSwUpdateSrv
} // namespace fcswupdatesrv
using namespace ::asf::stream::json;

namespace fcswupdatesrv {
namespace FcSwUpdateSrv {

std::ostream& operator<<(std::ostream& o, const ::fcswupdatesrv::FcSwUpdateSrv::UpdateSelectReleaseRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace FcSwUpdateSrv
} // namespace fcswupdatesrv
using namespace ::asf::stream::json;

namespace fcswupdatesrv {
namespace FcSwUpdateSrv {

std::ostream& operator<<(std::ostream& o, const ::fcswupdatesrv::FcSwUpdateSrv::UpdateSelectReleaseResponse& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace FcSwUpdateSrv
} // namespace fcswupdatesrv
using namespace ::asf::stream::json;

namespace fcswupdatesrv {
namespace FcSwUpdateSrv {

std::ostream& operator<<(std::ostream& o, const ::fcswupdatesrv::FcSwUpdateSrv::GetDeviceStateListResponse& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace FcSwUpdateSrv
} // namespace fcswupdatesrv
using namespace ::asf::stream::json;

namespace fcswupdatesrv {
namespace FcSwUpdateSrv {

std::ostream& operator<<(std::ostream& o, const ::fcswupdatesrv::FcSwUpdateSrv::SetUpdateOptionsRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace FcSwUpdateSrv
} // namespace fcswupdatesrv
using namespace ::asf::stream::json;

namespace fcswupdatesrv {
namespace FcSwUpdateSrv {

std::ostream& operator<<(std::ostream& o, const ::fcswupdatesrv::FcSwUpdateSrv::SetUpdateOptionsResponse& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace FcSwUpdateSrv
} // namespace fcswupdatesrv
using namespace ::asf::stream::json;

namespace fcswupdatesrv {
namespace FcSwUpdateSrv {

std::ostream& operator<<(std::ostream& o, const ::fcswupdatesrv::FcSwUpdateSrv::ModifyReleaseDocRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace FcSwUpdateSrv
} // namespace fcswupdatesrv
using namespace ::asf::stream::json;

namespace fcswupdatesrv {
namespace FcSwUpdateSrv {

std::ostream& operator<<(std::ostream& o, const ::fcswupdatesrv::FcSwUpdateSrv::ModifyReleaseDocResponse& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace FcSwUpdateSrv
} // namespace fcswupdatesrv
using namespace ::asf::stream::json;

namespace fcswupdatesrv {
namespace FcSwUpdateSrv {

std::ostream& operator<<(std::ostream& o, const ::fcswupdatesrv::FcSwUpdateSrv::GetUpdateFileResponse& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace FcSwUpdateSrv
} // namespace fcswupdatesrv
using namespace ::asf::stream::json;

namespace fcswupdatesrv {
namespace FcSwUpdateSrv {

std::ostream& operator<<(std::ostream& o, const ::fcswupdatesrv::FcSwUpdateSrv::ApplyDocResponse& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace FcSwUpdateSrv
} // namespace fcswupdatesrv
using namespace ::asf::stream::json;

namespace fcswupdatesrv {
namespace FcSwUpdateSrv {

std::ostream& operator<<(std::ostream& o, const ::fcswupdatesrv::FcSwUpdateSrv::ApplyLockResponse& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace FcSwUpdateSrv
} // namespace fcswupdatesrv
using namespace ::asf::stream::json;

namespace fcswupdatesrv {
namespace FcSwUpdateSrv {

std::ostream& operator<<(std::ostream& o, const ::fcswupdatesrv::FcSwUpdateSrv::UpdateSelectReleaseByFileRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace FcSwUpdateSrv
} // namespace fcswupdatesrv
using namespace ::asf::stream::json;

namespace fcswupdatesrv {
namespace FcSwUpdateSrv {

std::ostream& operator<<(std::ostream& o, const ::fcswupdatesrv::FcSwUpdateSrv::UpdateSelectReleaseByFileResponse& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace FcSwUpdateSrv
} // namespace fcswupdatesrv
using namespace ::asf::stream::json;

namespace fcswupdatesrv {
namespace FcSwUpdateSrv {

std::ostream& operator<<(std::ostream& o, const ::fcswupdatesrv::FcSwUpdateSrv::RetryFailedModulesResponse& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace FcSwUpdateSrv
} // namespace fcswupdatesrv
using namespace ::asf::stream::json;

namespace fcswupdatesrv {
namespace FcSwUpdateSrv {

std::ostream& operator<<(std::ostream& o, const ::fcswupdatesrv::FcSwUpdateSrv::UpdateEndResponse& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace FcSwUpdateSrv
} // namespace fcswupdatesrv
using namespace ::asf::stream::json;

namespace fcswupdatesrv {
namespace FcSwUpdateSrv {

std::ostream& operator<<(std::ostream& o, const ::fcswupdatesrv::FcSwUpdateSrv::UpdateAbortRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace FcSwUpdateSrv
} // namespace fcswupdatesrv
using namespace ::asf::stream::json;

namespace fcswupdatesrv {
namespace FcSwUpdateSrv {

std::ostream& operator<<(std::ostream& o, const ::fcswupdatesrv::FcSwUpdateSrv::UpdateAbortResponse& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace FcSwUpdateSrv
} // namespace fcswupdatesrv
using namespace ::asf::stream::json;

namespace fcswupdatesrv {
namespace FcSwUpdateSrv {

std::ostream& operator<<(std::ostream& o, const ::fcswupdatesrv::FcSwUpdateSrv::UpdateAbortDeviceRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace FcSwUpdateSrv
} // namespace fcswupdatesrv
using namespace ::asf::stream::json;

namespace fcswupdatesrv {
namespace FcSwUpdateSrv {

std::ostream& operator<<(std::ostream& o, const ::fcswupdatesrv::FcSwUpdateSrv::UpdateAbortDeviceResponse& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace FcSwUpdateSrv
} // namespace fcswupdatesrv
using namespace ::asf::stream::json;

namespace fcswupdatesrv {
namespace FcSwUpdateSrv {

std::ostream& operator<<(std::ostream& o, const ::fcswupdatesrv::FcSwUpdateSrv::HandleErrorRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace FcSwUpdateSrv
} // namespace fcswupdatesrv
using namespace ::asf::stream::json;

namespace fcswupdatesrv {
namespace FcSwUpdateSrv {

std::ostream& operator<<(std::ostream& o, const ::fcswupdatesrv::FcSwUpdateSrv::HandleErrorResponse& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace FcSwUpdateSrv
} // namespace fcswupdatesrv
using namespace ::asf::stream::json;

namespace fcswupdatesrv {
namespace FcSwUpdateSrv {

std::ostream& operator<<(std::ostream& o, const ::fcswupdatesrv::FcSwUpdateSrv::GetUpdateHistoryResponse& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace FcSwUpdateSrv
} // namespace fcswupdatesrv
using namespace ::asf::stream::json;

namespace fcswupdatesrv {
namespace FcSwUpdateSrv {

std::ostream& operator<<(std::ostream& o, const ::fcswupdatesrv::FcSwUpdateSrv::GetUpdateHistoryScopedRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace FcSwUpdateSrv
} // namespace fcswupdatesrv
using namespace ::asf::stream::json;

namespace fcswupdatesrv {
namespace FcSwUpdateSrv {

std::ostream& operator<<(std::ostream& o, const ::fcswupdatesrv::FcSwUpdateSrv::GetUpdateHistoryScopedResponse& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace FcSwUpdateSrv
} // namespace fcswupdatesrv
using namespace ::asf::stream::json;

namespace fcswupdatesrv {
namespace FcSwUpdateSrv {

std::ostream& operator<<(std::ostream& o, const ::fcswupdatesrv::FcSwUpdateSrv::GetUpdateHistoryDetailedRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace FcSwUpdateSrv
} // namespace fcswupdatesrv
using namespace ::asf::stream::json;

namespace fcswupdatesrv {
namespace FcSwUpdateSrv {

std::ostream& operator<<(std::ostream& o, const ::fcswupdatesrv::FcSwUpdateSrv::GetUpdateHistoryDetailedResponse& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace FcSwUpdateSrv
} // namespace fcswupdatesrv
using namespace ::asf::stream::json;

namespace fcswupdatesrv {
namespace FcSwUpdateSrv {

std::ostream& operator<<(std::ostream& o, const ::fcswupdatesrv::FcSwUpdateSrv::DeleteHistoryRequestRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace FcSwUpdateSrv
} // namespace fcswupdatesrv
using namespace ::asf::stream::json;

namespace fcswupdatesrv {
namespace FcSwUpdateSrv {

std::ostream& operator<<(std::ostream& o, const ::fcswupdatesrv::FcSwUpdateSrv::DeleteHistoryRequestResponse& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace FcSwUpdateSrv
} // namespace fcswupdatesrv
using namespace ::asf::stream::json;

namespace fcswupdatesrv {
namespace FcSwUpdateSrv {

std::ostream& operator<<(std::ostream& o, const ::fcswupdatesrv::FcSwUpdateSrv::GetTargetStateRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace FcSwUpdateSrv
} // namespace fcswupdatesrv
using namespace ::asf::stream::json;

namespace fcswupdatesrv {
namespace FcSwUpdateSrv {

std::ostream& operator<<(std::ostream& o, const ::fcswupdatesrv::FcSwUpdateSrv::GetTargetStateResponse& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace FcSwUpdateSrv
} // namespace fcswupdatesrv
using namespace ::asf::stream::json;

namespace fcswupdatesrv {
namespace FcSwUpdateSrv {

std::ostream& operator<<(std::ostream& o, const ::fcswupdatesrv::FcSwUpdateSrv::SetVersionBackDocAckRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace FcSwUpdateSrv
} // namespace fcswupdatesrv
using namespace ::asf::stream::json;

namespace fcswupdatesrv {
namespace FcSwUpdateSrv {

std::ostream& operator<<(std::ostream& o, const ::fcswupdatesrv::FcSwUpdateSrv::SetVersionBackDocAckResponse& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace FcSwUpdateSrv
} // namespace fcswupdatesrv
using namespace ::asf::stream::json;

namespace fcswupdatesrv {
namespace FcSwUpdateSrv {

std::ostream& operator<<(std::ostream& o, const ::fcswupdatesrv::FcSwUpdateSrv::SetAllowRecoveryModeRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace FcSwUpdateSrv
} // namespace fcswupdatesrv
using namespace ::asf::stream::json;

namespace fcswupdatesrv {
namespace FcSwUpdateSrv {

std::ostream& operator<<(std::ostream& o, const ::fcswupdatesrv::FcSwUpdateSrv::SetAllowRecoveryModeResponse& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace FcSwUpdateSrv
} // namespace fcswupdatesrv
using namespace ::asf::stream::json;

namespace fcswupdatesrv {
namespace FcSwUpdateSrv {

std::ostream& operator<<(std::ostream& o, const ::fcswupdatesrv::FcSwUpdateSrv::GetCacheDirectoryRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace FcSwUpdateSrv
} // namespace fcswupdatesrv
using namespace ::asf::stream::json;

namespace fcswupdatesrv {
namespace FcSwUpdateSrv {

std::ostream& operator<<(std::ostream& o, const ::fcswupdatesrv::FcSwUpdateSrv::GetCacheDirectoryResponse& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace FcSwUpdateSrv
} // namespace fcswupdatesrv
using namespace ::asf::stream::json;

namespace fcswupdatesrv {
namespace FcSwUpdateSrv {

std::ostream& operator<<(std::ostream& o, const ::fcswupdatesrv::FcSwUpdateSrv::EnterRecoveryModeResponse& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace FcSwUpdateSrv
} // namespace fcswupdatesrv
using namespace ::asf::stream::json;

namespace fcswupdatesrv {
namespace FcSwUpdateSrv {

std::ostream& operator<<(std::ostream& o, const ::fcswupdatesrv::FcSwUpdateSrv::VerifyChecksumRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace FcSwUpdateSrv
} // namespace fcswupdatesrv
using namespace ::asf::stream::json;

namespace fcswupdatesrv {
namespace FcSwUpdateSrv {

std::ostream& operator<<(std::ostream& o, const ::fcswupdatesrv::FcSwUpdateSrv::VerifyChecksumResponse& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace FcSwUpdateSrv
} // namespace fcswupdatesrv
using namespace ::asf::stream::json;

namespace fcswupdatesrv {
namespace FcSwUpdateSrv {

std::ostream& operator<<(std::ostream& o, const ::fcswupdatesrv::FcSwUpdateSrv::RegisterBgLocksRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace FcSwUpdateSrv
} // namespace fcswupdatesrv
using namespace ::asf::stream::json;

namespace fcswupdatesrv {
namespace FcSwUpdateSrv {

std::ostream& operator<<(std::ostream& o, const ::fcswupdatesrv::FcSwUpdateSrv::RegisterBgLocksResponse& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace FcSwUpdateSrv
} // namespace fcswupdatesrv
using namespace ::asf::stream::json;

namespace fcswupdatesrv {
namespace FcSwUpdateSrv {

std::ostream& operator<<(std::ostream& o, const ::fcswupdatesrv::FcSwUpdateSrv::UpdateStateUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace FcSwUpdateSrv
} // namespace fcswupdatesrv
using namespace ::asf::stream::json;

namespace fcswupdatesrv {
namespace FcSwUpdateSrv {

std::ostream& operator<<(std::ostream& o, const ::fcswupdatesrv::FcSwUpdateSrv::UpdateStateRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace FcSwUpdateSrv
} // namespace fcswupdatesrv
using namespace ::asf::stream::json;

namespace fcswupdatesrv {
namespace FcSwUpdateSrv {

std::ostream& operator<<(std::ostream& o, const ::fcswupdatesrv::FcSwUpdateSrv::UpdateSourcesUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace FcSwUpdateSrv
} // namespace fcswupdatesrv
using namespace ::asf::stream::json;

namespace fcswupdatesrv {
namespace FcSwUpdateSrv {

std::ostream& operator<<(std::ostream& o, const ::fcswupdatesrv::FcSwUpdateSrv::UpdateSourcesRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace FcSwUpdateSrv
} // namespace fcswupdatesrv
using namespace ::asf::stream::json;

namespace fcswupdatesrv {
namespace FcSwUpdateSrv {

std::ostream& operator<<(std::ostream& o, const ::fcswupdatesrv::FcSwUpdateSrv::ReleaseFilterUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace FcSwUpdateSrv
} // namespace fcswupdatesrv
using namespace ::asf::stream::json;

namespace fcswupdatesrv {
namespace FcSwUpdateSrv {

std::ostream& operator<<(std::ostream& o, const ::fcswupdatesrv::FcSwUpdateSrv::ReleaseFilterRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace FcSwUpdateSrv
} // namespace fcswupdatesrv
using namespace ::asf::stream::json;

namespace fcswupdatesrv {
namespace FcSwUpdateSrv {

std::ostream& operator<<(std::ostream& o, const ::fcswupdatesrv::FcSwUpdateSrv::ReleaseDocUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace FcSwUpdateSrv
} // namespace fcswupdatesrv
using namespace ::asf::stream::json;

namespace fcswupdatesrv {
namespace FcSwUpdateSrv {

std::ostream& operator<<(std::ostream& o, const ::fcswupdatesrv::FcSwUpdateSrv::ReleaseDocRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace FcSwUpdateSrv
} // namespace fcswupdatesrv
using namespace ::asf::stream::json;

namespace fcswupdatesrv {
namespace FcSwUpdateSrv {

std::ostream& operator<<(std::ostream& o, const ::fcswupdatesrv::FcSwUpdateSrv::PreReleaseDocUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace FcSwUpdateSrv
} // namespace fcswupdatesrv
using namespace ::asf::stream::json;

namespace fcswupdatesrv {
namespace FcSwUpdateSrv {

std::ostream& operator<<(std::ostream& o, const ::fcswupdatesrv::FcSwUpdateSrv::PreReleaseDocRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace FcSwUpdateSrv
} // namespace fcswupdatesrv
using namespace ::asf::stream::json;

namespace fcswupdatesrv {
namespace FcSwUpdateSrv {

std::ostream& operator<<(std::ostream& o, const ::fcswupdatesrv::FcSwUpdateSrv::UpdateProgressUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace FcSwUpdateSrv
} // namespace fcswupdatesrv
using namespace ::asf::stream::json;

namespace fcswupdatesrv {
namespace FcSwUpdateSrv {

std::ostream& operator<<(std::ostream& o, const ::fcswupdatesrv::FcSwUpdateSrv::UpdateProgressRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace FcSwUpdateSrv
} // namespace fcswupdatesrv
using namespace ::asf::stream::json;

namespace fcswupdatesrv {
namespace FcSwUpdateSrv {

std::ostream& operator<<(std::ostream& o, const ::fcswupdatesrv::FcSwUpdateSrv::UpdateResultUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace FcSwUpdateSrv
} // namespace fcswupdatesrv
using namespace ::asf::stream::json;

namespace fcswupdatesrv {
namespace FcSwUpdateSrv {

std::ostream& operator<<(std::ostream& o, const ::fcswupdatesrv::FcSwUpdateSrv::UpdateResultRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace FcSwUpdateSrv
} // namespace fcswupdatesrv
using namespace ::asf::stream::json;

namespace fcswupdatesrv {
namespace FcSwUpdateSrv {

std::ostream& operator<<(std::ostream& o, const ::fcswupdatesrv::FcSwUpdateSrv::UpdateErrorsUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace FcSwUpdateSrv
} // namespace fcswupdatesrv
using namespace ::asf::stream::json;

namespace fcswupdatesrv {
namespace FcSwUpdateSrv {

std::ostream& operator<<(std::ostream& o, const ::fcswupdatesrv::FcSwUpdateSrv::UpdateErrorsRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace FcSwUpdateSrv
} // namespace fcswupdatesrv
using namespace ::asf::stream::json;

namespace fcswupdatesrv {
namespace FcSwUpdateSrv {

std::ostream& operator<<(std::ostream& o, const ::fcswupdatesrv::FcSwUpdateSrv::CustomerUpdatesUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace FcSwUpdateSrv
} // namespace fcswupdatesrv
using namespace ::asf::stream::json;

namespace fcswupdatesrv {
namespace FcSwUpdateSrv {

std::ostream& operator<<(std::ostream& o, const ::fcswupdatesrv::FcSwUpdateSrv::CustomerUpdatesRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace FcSwUpdateSrv
} // namespace fcswupdatesrv
using namespace ::asf::stream::json;

namespace fcswupdatesrv {
namespace FcSwUpdateSrv {

std::ostream& operator<<(std::ostream& o, const ::fcswupdatesrv::FcSwUpdateSrv::VersionBackDocInfoUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace FcSwUpdateSrv
} // namespace fcswupdatesrv
using namespace ::asf::stream::json;

namespace fcswupdatesrv {
namespace FcSwUpdateSrv {

std::ostream& operator<<(std::ostream& o, const ::fcswupdatesrv::FcSwUpdateSrv::VersionBackDocInfoRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace FcSwUpdateSrv
} // namespace fcswupdatesrv
using namespace ::asf::stream::json;

namespace fcswupdatesrv {
namespace FcSwUpdateSrv {

std::ostream& operator<<(std::ostream& o, const ::fcswupdatesrv::FcSwUpdateSrv::AvailableCustomerUpdatesUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace FcSwUpdateSrv
} // namespace fcswupdatesrv
using namespace ::asf::stream::json;

namespace fcswupdatesrv {
namespace FcSwUpdateSrv {

std::ostream& operator<<(std::ostream& o, const ::fcswupdatesrv::FcSwUpdateSrv::AvailableCustomerUpdatesRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace FcSwUpdateSrv
} // namespace fcswupdatesrv
using namespace ::asf::stream::json;

namespace fcswupdatesrv {
namespace FcSwUpdateSrv {

std::ostream& operator<<(std::ostream& o, const ::fcswupdatesrv::FcSwUpdateSrv::UpdateBgImageInfoUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace FcSwUpdateSrv
} // namespace fcswupdatesrv
using namespace ::asf::stream::json;

namespace fcswupdatesrv {
namespace FcSwUpdateSrv {

std::ostream& operator<<(std::ostream& o, const ::fcswupdatesrv::FcSwUpdateSrv::UpdateBgImageInfoRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace FcSwUpdateSrv
} // namespace fcswupdatesrv
using namespace ::asf::stream::json;

namespace fcswupdatesrv {
namespace FcSwUpdateSrv {

std::ostream& operator<<(std::ostream& o, const ::fcswupdatesrv::FcSwUpdateSrv::BgLocksStateUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace FcSwUpdateSrv
} // namespace fcswupdatesrv
using namespace ::asf::stream::json;

namespace fcswupdatesrv {
namespace FcSwUpdateSrv {

std::ostream& operator<<(std::ostream& o, const ::fcswupdatesrv::FcSwUpdateSrv::BgLocksStateRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace FcSwUpdateSrv
} // namespace fcswupdatesrv

