#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef FCSWUPDATESRV_FCSWUPDATESRV_H
#define FCSWUPDATESRV_FCSWUPDATESRV_H

#include "asf/core/Logger.h"
#include "asf/core/Payload.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "asf/core/VersionCheck.h"
#include "asf/dbus/DBusTypes.h"
#include "fcswupdatesrv/FcSwUpdateSrvConst.h"
#include <cstddef>
#include <cstring>
#include <string>
#include <vector>

/**
 * If the meaning of "fcswupdatesrv.FcSwUpdateSrv" isn't clear, then there should be a description here.
 */

namespace fcswupdatesrv {
namespace FcSwUpdateSrv {

// method IDs
static const uint16 ID_StoreHistoryToStick = 0;
static const uint16 ID_UpdateEnter = 1;
static const uint16 ID_UpdateSetReleaseFilter = 2;
static const uint16 ID_UpdateGetSources = 3;
static const uint16 ID_UpdateSelectSource = 4;
static const uint16 ID_UpdateSelectRelease = 5;
static const uint16 ID_GetDeviceStateList = 6;
static const uint16 ID_SetUpdateOptions = 7;
static const uint16 ID_ModifyReleaseDoc = 8;
static const uint16 ID_GetUpdateFile = 9;
static const uint16 ID_ApplyDoc = 10;
static const uint16 ID_ApplyLock = 11;
static const uint16 ID_UpdateSelectReleaseByFile = 12;
static const uint16 ID_RetryFailedModules = 13;
static const uint16 ID_UpdateEnd = 14;
static const uint16 ID_UpdateAbort = 15;
static const uint16 ID_UpdateAbortDevice = 16;
static const uint16 ID_HandleError = 17;
static const uint16 ID_GetUpdateHistory = 18;
static const uint16 ID_GetUpdateHistoryScoped = 19;
static const uint16 ID_GetUpdateHistoryDetailed = 20;
static const uint16 ID_DeleteHistoryRequest = 21;
static const uint16 ID_GetTargetState = 22;
static const uint16 ID_SetVersionBackDocAck = 23;
static const uint16 ID_SetAllowRecoveryMode = 24;
static const uint16 ID_GetCacheDirectory = 25;
static const uint16 ID_EnterRecoveryMode = 26;
static const uint16 ID_VerifyChecksum = 27;
static const uint16 ID_RegisterBgLocks = 28;

// signal IDs

// property IDs
static const uint16 ID_UpdateState = 29;
static const uint16 ID_UpdateSources = 30;
static const uint16 ID_ReleaseFilter = 31;
static const uint16 ID_ReleaseDoc = 32;
static const uint16 ID_PreReleaseDoc = 33;
static const uint16 ID_UpdateProgress = 34;
static const uint16 ID_UpdateResult = 35;
static const uint16 ID_UpdateErrors = 36;
static const uint16 ID_CustomerUpdates = 37;
static const uint16 ID_VersionBackDocInfo = 38;
static const uint16 ID_AvailableCustomerUpdates = 39;
static const uint16 ID_UpdateBgImageInfo = 40;
static const uint16 ID_BgLocksState = 41;

ASF_GENERATOR_VERSION_CHECK_DECLARE

static const int VERSION_MAJOR = 0;

static const int VERSION_MINOR = 1;

static const int VERSION_PATCH = 0;

// forward declarations
class trUpdSource;

class trUpdSources;

class trSelectReleaseRes;

class trReleaseInfo;

class trReleaseFilter;

class trReleaseAccess;

class trReleaseInfos;

class trDeviceState;

class trDeviceStates;

class trUpdState;

class trSubModuleData;

class trModuleData;

class trDeviceData;

class trTartgetState;

class trConfigProblem;

class trReleaseDoc;

class trPreReleaseDoc;

class trModifyAction;

class trUpdProgress;

class trAbortDeviceRes;

class trTimeDate;

class trResult;

class trErrorIds;

class trGetCacheDirectory;

class trUpdLog;

class trUpdLogs;

class trUpdateMedia;

class trVersionBackDocInfo;

class trCustomerUpdate;

class trAvailableCustomerUpdates;

class trInstalledCustomerUpdates;

class trCustomerUpdates;

class trBgImageInfo;

class trFontInfo;

class trDisplayVariant;

class trVerifyChecksumResult;

class trVerifyChecksumRequest;

class trGetUpdateHistoryDetailedRequest;

class trGetUpdateHistoryDetailed;

class trBgLocks;

class trBgLocksState;

class StoreHistoryToStickRequest;

class StoreHistoryToStickResponse;

class UpdateEnterRequest;

class UpdateEnterResponse;

class UpdateSetReleaseFilterRequest;

class UpdateSetReleaseFilterResponse;

class UpdateGetSourcesResponse;

class UpdateSelectSourceRequest;

class UpdateSelectSourceResponse;

class UpdateSelectReleaseRequest;

class UpdateSelectReleaseResponse;

class GetDeviceStateListResponse;

class SetUpdateOptionsRequest;

class SetUpdateOptionsResponse;

class ModifyReleaseDocRequest;

class ModifyReleaseDocResponse;

class GetUpdateFileResponse;

class ApplyDocResponse;

class ApplyLockResponse;

class UpdateSelectReleaseByFileRequest;

class UpdateSelectReleaseByFileResponse;

class RetryFailedModulesResponse;

class UpdateEndResponse;

class UpdateAbortRequest;

class UpdateAbortResponse;

class UpdateAbortDeviceRequest;

class UpdateAbortDeviceResponse;

class HandleErrorRequest;

class HandleErrorResponse;

class GetUpdateHistoryResponse;

class GetUpdateHistoryScopedRequest;

class GetUpdateHistoryScopedResponse;

class GetUpdateHistoryDetailedRequest;

class GetUpdateHistoryDetailedResponse;

class DeleteHistoryRequestRequest;

class DeleteHistoryRequestResponse;

class GetTargetStateRequest;

class GetTargetStateResponse;

class SetVersionBackDocAckRequest;

class SetVersionBackDocAckResponse;

class SetAllowRecoveryModeRequest;

class SetAllowRecoveryModeResponse;

class GetCacheDirectoryRequest;

class GetCacheDirectoryResponse;

class EnterRecoveryModeResponse;

class VerifyChecksumRequest;

class VerifyChecksumResponse;

class RegisterBgLocksRequest;

class RegisterBgLocksResponse;

class UpdateStateUpdate;

class UpdateStateRegister;

class UpdateSourcesUpdate;

class UpdateSourcesRegister;

class ReleaseFilterUpdate;

class ReleaseFilterRegister;

class ReleaseDocUpdate;

class ReleaseDocRegister;

class PreReleaseDocUpdate;

class PreReleaseDocRegister;

class UpdateProgressUpdate;

class UpdateProgressRegister;

class UpdateResultUpdate;

class UpdateResultRegister;

class UpdateErrorsUpdate;

class UpdateErrorsRegister;

class CustomerUpdatesUpdate;

class CustomerUpdatesRegister;

class VersionBackDocInfoUpdate;

class VersionBackDocInfoRegister;

class AvailableCustomerUpdatesUpdate;

class AvailableCustomerUpdatesRegister;

class UpdateBgImageInfoUpdate;

class UpdateBgImageInfoRegister;

class BgLocksStateUpdate;

class BgLocksStateRegister;

// type definitions
/**
 * If the meaning of "StoreHistoryToStickError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError StoreHistoryToStickError;

/**
 * If the meaning of "UpdateEnterError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError UpdateEnterError;

/**
 * If the meaning of "UpdateSetReleaseFilterError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError UpdateSetReleaseFilterError;

/**
 * If the meaning of "UpdateGetSources" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage UpdateGetSourcesRequest;

/**
 * If the meaning of "UpdateGetSourcesError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError UpdateGetSourcesError;

/**
 * If the meaning of "UpdateSelectSourceError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError UpdateSelectSourceError;

/**
 * If the meaning of "UpdateSelectReleaseError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError UpdateSelectReleaseError;

/**
 * If the meaning of "GetDeviceStateList" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage GetDeviceStateListRequest;

/**
 * If the meaning of "GetDeviceStateListError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError GetDeviceStateListError;

/**
 * If the meaning of "SetUpdateOptionsError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SetUpdateOptionsError;

/**
 * If the meaning of "ModifyReleaseDocError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ModifyReleaseDocError;

/**
 * If the meaning of "GetUpdateFile" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage GetUpdateFileRequest;

/**
 * If the meaning of "GetUpdateFileError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError GetUpdateFileError;

/**
 * If the meaning of "ApplyDoc" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage ApplyDocRequest;

/**
 * If the meaning of "ApplyDocError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ApplyDocError;

/**
 * If the meaning of "ApplyLock" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage ApplyLockRequest;

/**
 * If the meaning of "ApplyLockError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ApplyLockError;

/**
 * If the meaning of "UpdateSelectReleaseByFileError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError UpdateSelectReleaseByFileError;

/**
 * If the meaning of "RetryFailedModules" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage RetryFailedModulesRequest;

/**
 * If the meaning of "RetryFailedModulesError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError RetryFailedModulesError;

/**
 * If the meaning of "UpdateEnd" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage UpdateEndRequest;

/**
 * If the meaning of "UpdateEndError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError UpdateEndError;

/**
 * If the meaning of "UpdateAbortError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError UpdateAbortError;

/**
 * If the meaning of "UpdateAbortDeviceError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError UpdateAbortDeviceError;

/**
 * If the meaning of "HandleErrorError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError HandleErrorError;

/**
 * If the meaning of "GetUpdateHistory" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage GetUpdateHistoryRequest;

/**
 * If the meaning of "GetUpdateHistoryError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError GetUpdateHistoryError;

/**
 * If the meaning of "GetUpdateHistoryScopedError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError GetUpdateHistoryScopedError;

/**
 * If the meaning of "GetUpdateHistoryDetailedError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError GetUpdateHistoryDetailedError;

/**
 * If the meaning of "DeleteHistoryRequestError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError DeleteHistoryRequestError;

/**
 * If the meaning of "GetTargetStateError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError GetTargetStateError;

/**
 * If the meaning of "SetVersionBackDocAckError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SetVersionBackDocAckError;

/**
 * If the meaning of "SetAllowRecoveryModeError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SetAllowRecoveryModeError;

/**
 * If the meaning of "GetCacheDirectoryError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError GetCacheDirectoryError;

/**
 * If the meaning of "EnterRecoveryMode" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage EnterRecoveryModeRequest;

/**
 * If the meaning of "EnterRecoveryModeError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError EnterRecoveryModeError;

/**
 * If the meaning of "VerifyChecksumError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError VerifyChecksumError;

/**
 * If the meaning of "RegisterBgLocksError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError RegisterBgLocksError;

/**
 * If the meaning of "UpdateState" isn't clear, then there should be a description here.
 */
typedef UpdateStateUpdate UpdateStateSet;

/**
 * If the meaning of "UpdateState" isn't clear, then there should be a description here.
 */
typedef UpdateStateUpdate UpdateStateGet;

/**
 * If the meaning of "UpdateStateError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError UpdateStateError;

/**
 * If the meaning of "UpdateSources" isn't clear, then there should be a description here.
 */
typedef UpdateSourcesUpdate UpdateSourcesSet;

/**
 * If the meaning of "UpdateSources" isn't clear, then there should be a description here.
 */
typedef UpdateSourcesUpdate UpdateSourcesGet;

/**
 * If the meaning of "UpdateSourcesError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError UpdateSourcesError;

/**
 * If the meaning of "ReleaseFilter" isn't clear, then there should be a description here.
 */
typedef ReleaseFilterUpdate ReleaseFilterSet;

/**
 * If the meaning of "ReleaseFilter" isn't clear, then there should be a description here.
 */
typedef ReleaseFilterUpdate ReleaseFilterGet;

/**
 * If the meaning of "ReleaseFilterError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ReleaseFilterError;

/**
 * If the meaning of "ReleaseDoc" isn't clear, then there should be a description here.
 */
typedef ReleaseDocUpdate ReleaseDocSet;

/**
 * If the meaning of "ReleaseDoc" isn't clear, then there should be a description here.
 */
typedef ReleaseDocUpdate ReleaseDocGet;

/**
 * If the meaning of "ReleaseDocError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ReleaseDocError;

/**
 * If the meaning of "PreReleaseDoc" isn't clear, then there should be a description here.
 */
typedef PreReleaseDocUpdate PreReleaseDocSet;

/**
 * If the meaning of "PreReleaseDoc" isn't clear, then there should be a description here.
 */
typedef PreReleaseDocUpdate PreReleaseDocGet;

/**
 * If the meaning of "PreReleaseDocError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError PreReleaseDocError;

/**
 * If the meaning of "UpdateProgress" isn't clear, then there should be a description here.
 */
typedef UpdateProgressUpdate UpdateProgressSet;

/**
 * If the meaning of "UpdateProgress" isn't clear, then there should be a description here.
 */
typedef UpdateProgressUpdate UpdateProgressGet;

/**
 * If the meaning of "UpdateProgressError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError UpdateProgressError;

/**
 * If the meaning of "UpdateResult" isn't clear, then there should be a description here.
 */
typedef UpdateResultUpdate UpdateResultSet;

/**
 * If the meaning of "UpdateResult" isn't clear, then there should be a description here.
 */
typedef UpdateResultUpdate UpdateResultGet;

/**
 * If the meaning of "UpdateResultError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError UpdateResultError;

/**
 * If the meaning of "UpdateErrors" isn't clear, then there should be a description here.
 */
typedef UpdateErrorsUpdate UpdateErrorsSet;

/**
 * If the meaning of "UpdateErrors" isn't clear, then there should be a description here.
 */
typedef UpdateErrorsUpdate UpdateErrorsGet;

/**
 * If the meaning of "UpdateErrorsError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError UpdateErrorsError;

/**
 * If the meaning of "CustomerUpdates" isn't clear, then there should be a description here.
 */
typedef CustomerUpdatesUpdate CustomerUpdatesSet;

/**
 * If the meaning of "CustomerUpdates" isn't clear, then there should be a description here.
 */
typedef CustomerUpdatesUpdate CustomerUpdatesGet;

/**
 * If the meaning of "CustomerUpdatesError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError CustomerUpdatesError;

/**
 * If the meaning of "VersionBackDocInfo" isn't clear, then there should be a description here.
 */
typedef VersionBackDocInfoUpdate VersionBackDocInfoSet;

/**
 * If the meaning of "VersionBackDocInfo" isn't clear, then there should be a description here.
 */
typedef VersionBackDocInfoUpdate VersionBackDocInfoGet;

/**
 * If the meaning of "VersionBackDocInfoError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError VersionBackDocInfoError;

/**
 * If the meaning of "AvailableCustomerUpdates" isn't clear, then there should be a description here.
 */
typedef AvailableCustomerUpdatesUpdate AvailableCustomerUpdatesSet;

/**
 * If the meaning of "AvailableCustomerUpdates" isn't clear, then there should be a description here.
 */
typedef AvailableCustomerUpdatesUpdate AvailableCustomerUpdatesGet;

/**
 * If the meaning of "AvailableCustomerUpdatesError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError AvailableCustomerUpdatesError;

/**
 * If the meaning of "UpdateBgImageInfo" isn't clear, then there should be a description here.
 */
typedef UpdateBgImageInfoUpdate UpdateBgImageInfoSet;

/**
 * If the meaning of "UpdateBgImageInfo" isn't clear, then there should be a description here.
 */
typedef UpdateBgImageInfoUpdate UpdateBgImageInfoGet;

/**
 * If the meaning of "UpdateBgImageInfoError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError UpdateBgImageInfoError;

/**
 * If the meaning of "BgLocksState" isn't clear, then there should be a description here.
 */
typedef BgLocksStateUpdate BgLocksStateSet;

/**
 * If the meaning of "BgLocksState" isn't clear, then there should be a description here.
 */
typedef BgLocksStateUpdate BgLocksStateGet;

/**
 * If the meaning of "BgLocksStateError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError BgLocksStateError;


/**
 * If the meaning of "trUpdSource" isn't clear, then there should be a description here.
 */
class trUpdSource {
public:

    /**
     * Default constructor
     */
    inline  trUpdSource ();

    /**
     * Copy constructor
     */
    inline  trUpdSource (const trUpdSource &rhs);

    /**
     * All fields constructor
     */
    inline  trUpdSource (const ::std::string& sourceName_, const ::std::string& sourcePath_, tenSourceType enSourceType_, bool bAvailable_);

    /**
     * Destructor
     */
    inline  ~trUpdSource();

    /**
     * Assignment operator
     */
    inline trUpdSource& operator = (const trUpdSource& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const trUpdSource& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const trUpdSource& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const trUpdSource& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const trUpdSource& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "sourceName"

    static const int kSourceName = 0;

    /**
     * Clears the field "sourceName".
     *
     * The field will be set to its default value. The hasSourceName()
     * method will return false.
     */
    inline void clearSourceName();

    /**
     * Checks whether the field "sourceName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSourceName()). Otherwise it will return false.
     */
    inline bool hasSourceName () const;

    /**
     * Returns the value of the member "sourceName".
     *
     * If the meaning of "sourceName" isn't clear, then there should be a description here.
     *
     * @return The value of the field "sourceName"
     */
    inline const ::std::string& getSourceName () const;

    /**
     * Retrieves the value of the field "sourceName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sourceName".
     */
    inline ::std::string& getSourceNameMutable ();

    /**
     * Sets the value of the member "sourceName".
     *
     * If the meaning of "sourceName" isn't clear, then there should be a description here.
     *
     * @param sourceName The value which will be set
     */
    inline void setSourceName (const ::std::string& sourceName_);

    /**
     * Sets the value of the member "sourceName".
     *
     * If the meaning of "sourceName" isn't clear, then there should be a description here.
     *
     * @param sourceName The value which will be set
     */
    inline void setSourceName (const char* sourceName_);

    /**
     * Sets the value of the member "sourceName".
     *
     * If the meaning of "sourceName" isn't clear, then there should be a description here.
     *
     * @param sourceName The value which will be set
     */
    inline void setSourceName (const char* value, size_t size);

    // API of field "sourcePath"

    static const int kSourcePath = 1;

    /**
     * Clears the field "sourcePath".
     *
     * The field will be set to its default value. The hasSourcePath()
     * method will return false.
     */
    inline void clearSourcePath();

    /**
     * Checks whether the field "sourcePath" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSourcePath()). Otherwise it will return false.
     */
    inline bool hasSourcePath () const;

    /**
     * Returns the value of the member "sourcePath".
     *
     * If the meaning of "sourcePath" isn't clear, then there should be a description here.
     *
     * @return The value of the field "sourcePath"
     */
    inline const ::std::string& getSourcePath () const;

    /**
     * Retrieves the value of the field "sourcePath" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sourcePath".
     */
    inline ::std::string& getSourcePathMutable ();

    /**
     * Sets the value of the member "sourcePath".
     *
     * If the meaning of "sourcePath" isn't clear, then there should be a description here.
     *
     * @param sourcePath The value which will be set
     */
    inline void setSourcePath (const ::std::string& sourcePath_);

    /**
     * Sets the value of the member "sourcePath".
     *
     * If the meaning of "sourcePath" isn't clear, then there should be a description here.
     *
     * @param sourcePath The value which will be set
     */
    inline void setSourcePath (const char* sourcePath_);

    /**
     * Sets the value of the member "sourcePath".
     *
     * If the meaning of "sourcePath" isn't clear, then there should be a description here.
     *
     * @param sourcePath The value which will be set
     */
    inline void setSourcePath (const char* value, size_t size);

    // API of field "enSourceType"

    static const int kEnSourceType = 2;

    /**
     * Clears the field "enSourceType".
     *
     * The field will be set to its default value. The hasEnSourceType()
     * method will return false.
     */
    inline void clearEnSourceType();

    /**
     * Checks whether the field "enSourceType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEnSourceType()). Otherwise it will return false.
     */
    inline bool hasEnSourceType () const;

    /**
     * Returns the value of the member "enSourceType".
     *
     * If the meaning of "enSourceType" isn't clear, then there should be a description here.
     *
     * @return The value of the field "enSourceType"
     */
    inline tenSourceType getEnSourceType () const;

    /**
     * Sets the value of the member "enSourceType".
     *
     * If the meaning of "enSourceType" isn't clear, then there should be a description here.
     *
     * @param enSourceType The value which will be set
     */
    inline void setEnSourceType (tenSourceType enSourceType_);

    // API of field "bAvailable"

    static const int kBAvailable = 3;

    /**
     * Clears the field "bAvailable".
     *
     * The field will be set to its default value. The hasBAvailable()
     * method will return false.
     */
    inline void clearBAvailable();

    /**
     * Checks whether the field "bAvailable" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBAvailable()). Otherwise it will return false.
     */
    inline bool hasBAvailable () const;

    /**
     * Returns the value of the member "bAvailable".
     *
     * If the meaning of "bAvailable" isn't clear, then there should be a description here.
     *
     * @return The value of the field "bAvailable"
     */
    inline bool getBAvailable () const;

    /**
     * Sets the value of the member "bAvailable".
     *
     * If the meaning of "bAvailable" isn't clear, then there should be a description here.
     *
     * @param bAvailable The value which will be set
     */
    inline void setBAvailable (bool bAvailable_);

    static const trUpdSource &getDefaultInstance();

private:

    inline void set_has_sourceName ();

    inline void clear_has_sourceName ();

    inline void set_has_sourcePath ();

    inline void clear_has_sourcePath ();

    inline void set_has_enSourceType ();

    inline void clear_has_enSourceType ();

    inline void set_has_bAvailable ();

    inline void clear_has_bAvailable ();

    uint32 _has_bits_[ (4 + 31) / 32];

    ::std::string _sourceName;

    ::std::string _sourcePath;

    tenSourceType _enSourceType;

    bool _bAvailable;

};

/**
 * If the meaning of "trUpdSources" isn't clear, then there should be a description here.
 */
class trUpdSources {
public:

    /**
     * Default constructor
     */
    inline  trUpdSources ();

    /**
     * Copy constructor
     */
    inline  trUpdSources (const trUpdSources &rhs);

    /**
     * All fields constructor
     */
    inline  trUpdSources (const ::std::vector< trUpdSource >& sources_);

    /**
     * Destructor
     */
    inline  ~trUpdSources();

    /**
     * Assignment operator
     */
    inline trUpdSources& operator = (const trUpdSources& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const trUpdSources& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const trUpdSources& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const trUpdSources& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const trUpdSources& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "sources"

    static const int kSources = 0;

    /**
     * Clears the field "sources".
     *
     * The field will be set to its default value. The hasSources()
     * method will return false.
     */
    inline void clearSources();

    /**
     * Checks whether the field "sources" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSources()). Otherwise it will return false.
     */
    inline bool hasSources () const;

    /**
     * Returns the value of the member "sources".
     *
     * If the meaning of "sources" isn't clear, then there should be a description here.
     *
     * @return The value of the field "sources"
     */
    inline const ::std::vector< trUpdSource >& getSources () const;

    /**
     * Retrieves the value of the field "sources" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sources".
     */
    inline ::std::vector< trUpdSource >& getSourcesMutable ();

    /**
     * Sets the value of the member "sources".
     *
     * If the meaning of "sources" isn't clear, then there should be a description here.
     *
     * @param sources The value which will be set
     */
    inline void setSources (const ::std::vector< trUpdSource >& sources_);

    static const trUpdSources &getDefaultInstance();

private:

    static const ::std::vector< trUpdSource >& getTrUpdSourceList_DefaultInstance ();

    inline void set_has_sources ();

    inline void clear_has_sources ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< trUpdSource > _sources;

};

/**
 * If the meaning of "trSelectReleaseRes" isn't clear, then there should be a description here.
 */
class trSelectReleaseRes {
public:

    /**
     * Default constructor
     */
    inline  trSelectReleaseRes ();

    /**
     * Copy constructor
     */
    inline  trSelectReleaseRes (const trSelectReleaseRes &rhs);

    /**
     * All fields constructor
     */
    inline  trSelectReleaseRes (bool bOk_, tenErrorId enErrorId_);

    /**
     * Destructor
     */
    inline  ~trSelectReleaseRes();

    /**
     * Assignment operator
     */
    inline trSelectReleaseRes& operator = (const trSelectReleaseRes& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const trSelectReleaseRes& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const trSelectReleaseRes& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const trSelectReleaseRes& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const trSelectReleaseRes& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bOk"

    static const int kBOk = 0;

    /**
     * Clears the field "bOk".
     *
     * The field will be set to its default value. The hasBOk()
     * method will return false.
     */
    inline void clearBOk();

    /**
     * Checks whether the field "bOk" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBOk()). Otherwise it will return false.
     */
    inline bool hasBOk () const;

    /**
     * Returns the value of the member "bOk".
     *
     * If the meaning of "bOk" isn't clear, then there should be a description here.
     *
     * @return The value of the field "bOk"
     */
    inline bool getBOk () const;

    /**
     * Sets the value of the member "bOk".
     *
     * If the meaning of "bOk" isn't clear, then there should be a description here.
     *
     * @param bOk The value which will be set
     */
    inline void setBOk (bool bOk_);

    // API of field "enErrorId"

    static const int kEnErrorId = 1;

    /**
     * Clears the field "enErrorId".
     *
     * The field will be set to its default value. The hasEnErrorId()
     * method will return false.
     */
    inline void clearEnErrorId();

    /**
     * Checks whether the field "enErrorId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEnErrorId()). Otherwise it will return false.
     */
    inline bool hasEnErrorId () const;

    /**
     * Returns the value of the member "enErrorId".
     *
     * If the meaning of "enErrorId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "enErrorId"
     */
    inline tenErrorId getEnErrorId () const;

    /**
     * Sets the value of the member "enErrorId".
     *
     * If the meaning of "enErrorId" isn't clear, then there should be a description here.
     *
     * @param enErrorId The value which will be set
     */
    inline void setEnErrorId (tenErrorId enErrorId_);

    static const trSelectReleaseRes &getDefaultInstance();

private:

    inline void set_has_bOk ();

    inline void clear_has_bOk ();

    inline void set_has_enErrorId ();

    inline void clear_has_enErrorId ();

    uint32 _has_bits_[ (2 + 31) / 32];

    bool _bOk;

    tenErrorId _enErrorId;

};

/**
 * If the meaning of "trReleaseInfo" isn't clear, then there should be a description here.
 */
class trReleaseInfo {
public:

    /**
     * Default constructor
     */
    inline  trReleaseInfo ();

    /**
     * Copy constructor
     */
    inline  trReleaseInfo (const trReleaseInfo &rhs);

    /**
     * All fields constructor
     */
    inline  trReleaseInfo (const ::std::string& name_, const ::std::string& info_);

    /**
     * Destructor
     */
    inline  ~trReleaseInfo();

    /**
     * Assignment operator
     */
    inline trReleaseInfo& operator = (const trReleaseInfo& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const trReleaseInfo& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const trReleaseInfo& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const trReleaseInfo& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const trReleaseInfo& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "name"

    static const int kName = 0;

    /**
     * Clears the field "name".
     *
     * The field will be set to its default value. The hasName()
     * method will return false.
     */
    inline void clearName();

    /**
     * Checks whether the field "name" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setName()). Otherwise it will return false.
     */
    inline bool hasName () const;

    /**
     * Returns the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @return The value of the field "name"
     */
    inline const ::std::string& getName () const;

    /**
     * Retrieves the value of the field "name" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "name".
     */
    inline ::std::string& getNameMutable ();

    /**
     * Sets the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param name The value which will be set
     */
    inline void setName (const ::std::string& name_);

    /**
     * Sets the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param name The value which will be set
     */
    inline void setName (const char* name_);

    /**
     * Sets the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param name The value which will be set
     */
    inline void setName (const char* value, size_t size);

    // API of field "info"

    static const int kInfo = 1;

    /**
     * Clears the field "info".
     *
     * The field will be set to its default value. The hasInfo()
     * method will return false.
     */
    inline void clearInfo();

    /**
     * Checks whether the field "info" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setInfo()). Otherwise it will return false.
     */
    inline bool hasInfo () const;

    /**
     * Returns the value of the member "info".
     *
     * If the meaning of "info" isn't clear, then there should be a description here.
     *
     * @return The value of the field "info"
     */
    inline const ::std::string& getInfo () const;

    /**
     * Retrieves the value of the field "info" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "info".
     */
    inline ::std::string& getInfoMutable ();

    /**
     * Sets the value of the member "info".
     *
     * If the meaning of "info" isn't clear, then there should be a description here.
     *
     * @param info The value which will be set
     */
    inline void setInfo (const ::std::string& info_);

    /**
     * Sets the value of the member "info".
     *
     * If the meaning of "info" isn't clear, then there should be a description here.
     *
     * @param info The value which will be set
     */
    inline void setInfo (const char* info_);

    /**
     * Sets the value of the member "info".
     *
     * If the meaning of "info" isn't clear, then there should be a description here.
     *
     * @param info The value which will be set
     */
    inline void setInfo (const char* value, size_t size);

    static const trReleaseInfo &getDefaultInstance();

private:

    inline void set_has_name ();

    inline void clear_has_name ();

    inline void set_has_info ();

    inline void clear_has_info ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _name;

    ::std::string _info;

};

/**
 * If the meaning of "trReleaseFilter" isn't clear, then there should be a description here.
 */
class trReleaseFilter {
public:

    /**
     * Default constructor
     */
    inline  trReleaseFilter ();

    /**
     * Copy constructor
     */
    inline  trReleaseFilter (const trReleaseFilter &rhs);

    /**
     * All fields constructor
     */
    inline  trReleaseFilter (tenUpdOptions enUpgradeDirectionFilter_);

    /**
     * Destructor
     */
    inline  ~trReleaseFilter();

    /**
     * Assignment operator
     */
    inline trReleaseFilter& operator = (const trReleaseFilter& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const trReleaseFilter& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const trReleaseFilter& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const trReleaseFilter& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const trReleaseFilter& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "enUpgradeDirectionFilter"

    static const int kEnUpgradeDirectionFilter = 0;

    /**
     * Clears the field "enUpgradeDirectionFilter".
     *
     * The field will be set to its default value. The hasEnUpgradeDirectionFilter()
     * method will return false.
     */
    inline void clearEnUpgradeDirectionFilter();

    /**
     * Checks whether the field "enUpgradeDirectionFilter" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEnUpgradeDirectionFilter()). Otherwise it will return false.
     */
    inline bool hasEnUpgradeDirectionFilter () const;

    /**
     * Returns the value of the member "enUpgradeDirectionFilter".
     *
     * If the meaning of "enUpgradeDirectionFilter" isn't clear, then there should be a description here.
     *
     * @return The value of the field "enUpgradeDirectionFilter"
     */
    inline tenUpdOptions getEnUpgradeDirectionFilter () const;

    /**
     * Sets the value of the member "enUpgradeDirectionFilter".
     *
     * If the meaning of "enUpgradeDirectionFilter" isn't clear, then there should be a description here.
     *
     * @param enUpgradeDirectionFilter The value which will be set
     */
    inline void setEnUpgradeDirectionFilter (tenUpdOptions enUpgradeDirectionFilter_);

    static const trReleaseFilter &getDefaultInstance();

private:

    inline void set_has_enUpgradeDirectionFilter ();

    inline void clear_has_enUpgradeDirectionFilter ();

    uint32 _has_bits_[ (1 + 31) / 32];

    tenUpdOptions _enUpgradeDirectionFilter;

};

/**
 * If the meaning of "trReleaseAccess" isn't clear, then there should be a description here.
 */
class trReleaseAccess {
public:

    /**
     * Default constructor
     */
    inline  trReleaseAccess ();

    /**
     * Copy constructor
     */
    inline  trReleaseAccess (const trReleaseAccess &rhs);

    /**
     * All fields constructor
     */
    inline  trReleaseAccess (const ::std::string& mountPoint_, const ::std::string& path_, const ::std::string& file_, bool useExtendedOptions_, const trReleaseFilter& releaseFilter_, tenUpdOptions updateOption_, bool doApply_, bool postImageInstallationMode_);

    /**
     * Destructor
     */
    inline  ~trReleaseAccess();

    /**
     * Assignment operator
     */
    inline trReleaseAccess& operator = (const trReleaseAccess& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const trReleaseAccess& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const trReleaseAccess& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const trReleaseAccess& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const trReleaseAccess& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "mountPoint"

    static const int kMountPoint = 0;

    /**
     * Clears the field "mountPoint".
     *
     * The field will be set to its default value. The hasMountPoint()
     * method will return false.
     */
    inline void clearMountPoint();

    /**
     * Checks whether the field "mountPoint" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMountPoint()). Otherwise it will return false.
     */
    inline bool hasMountPoint () const;

    /**
     * Returns the value of the member "mountPoint".
     *
     * If the meaning of "mountPoint" isn't clear, then there should be a description here.
     *
     * @return The value of the field "mountPoint"
     */
    inline const ::std::string& getMountPoint () const;

    /**
     * Retrieves the value of the field "mountPoint" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "mountPoint".
     */
    inline ::std::string& getMountPointMutable ();

    /**
     * Sets the value of the member "mountPoint".
     *
     * If the meaning of "mountPoint" isn't clear, then there should be a description here.
     *
     * @param mountPoint The value which will be set
     */
    inline void setMountPoint (const ::std::string& mountPoint_);

    /**
     * Sets the value of the member "mountPoint".
     *
     * If the meaning of "mountPoint" isn't clear, then there should be a description here.
     *
     * @param mountPoint The value which will be set
     */
    inline void setMountPoint (const char* mountPoint_);

    /**
     * Sets the value of the member "mountPoint".
     *
     * If the meaning of "mountPoint" isn't clear, then there should be a description here.
     *
     * @param mountPoint The value which will be set
     */
    inline void setMountPoint (const char* value, size_t size);

    // API of field "path"

    static const int kPath = 1;

    /**
     * Clears the field "path".
     *
     * The field will be set to its default value. The hasPath()
     * method will return false.
     */
    inline void clearPath();

    /**
     * Checks whether the field "path" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPath()). Otherwise it will return false.
     */
    inline bool hasPath () const;

    /**
     * Returns the value of the member "path".
     *
     * If the meaning of "path" isn't clear, then there should be a description here.
     *
     * @return The value of the field "path"
     */
    inline const ::std::string& getPath () const;

    /**
     * Retrieves the value of the field "path" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "path".
     */
    inline ::std::string& getPathMutable ();

    /**
     * Sets the value of the member "path".
     *
     * If the meaning of "path" isn't clear, then there should be a description here.
     *
     * @param path The value which will be set
     */
    inline void setPath (const ::std::string& path_);

    /**
     * Sets the value of the member "path".
     *
     * If the meaning of "path" isn't clear, then there should be a description here.
     *
     * @param path The value which will be set
     */
    inline void setPath (const char* path_);

    /**
     * Sets the value of the member "path".
     *
     * If the meaning of "path" isn't clear, then there should be a description here.
     *
     * @param path The value which will be set
     */
    inline void setPath (const char* value, size_t size);

    // API of field "file"

    static const int kFile = 2;

    /**
     * Clears the field "file".
     *
     * The field will be set to its default value. The hasFile()
     * method will return false.
     */
    inline void clearFile();

    /**
     * Checks whether the field "file" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFile()). Otherwise it will return false.
     */
    inline bool hasFile () const;

    /**
     * Returns the value of the member "file".
     *
     * If the meaning of "file" isn't clear, then there should be a description here.
     *
     * @return The value of the field "file"
     */
    inline const ::std::string& getFile () const;

    /**
     * Retrieves the value of the field "file" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "file".
     */
    inline ::std::string& getFileMutable ();

    /**
     * Sets the value of the member "file".
     *
     * If the meaning of "file" isn't clear, then there should be a description here.
     *
     * @param file The value which will be set
     */
    inline void setFile (const ::std::string& file_);

    /**
     * Sets the value of the member "file".
     *
     * If the meaning of "file" isn't clear, then there should be a description here.
     *
     * @param file The value which will be set
     */
    inline void setFile (const char* file_);

    /**
     * Sets the value of the member "file".
     *
     * If the meaning of "file" isn't clear, then there should be a description here.
     *
     * @param file The value which will be set
     */
    inline void setFile (const char* value, size_t size);

    // API of field "useExtendedOptions"

    static const int kUseExtendedOptions = 3;

    /**
     * Clears the field "useExtendedOptions".
     *
     * The field will be set to its default value. The hasUseExtendedOptions()
     * method will return false.
     */
    inline void clearUseExtendedOptions();

    /**
     * Checks whether the field "useExtendedOptions" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setUseExtendedOptions()). Otherwise it will return false.
     */
    inline bool hasUseExtendedOptions () const;

    /**
     * Returns the value of the member "useExtendedOptions".
     *
     * If the meaning of "useExtendedOptions" isn't clear, then there should be a description here.
     *
     * @return The value of the field "useExtendedOptions"
     */
    inline bool getUseExtendedOptions () const;

    /**
     * Sets the value of the member "useExtendedOptions".
     *
     * If the meaning of "useExtendedOptions" isn't clear, then there should be a description here.
     *
     * @param useExtendedOptions The value which will be set
     */
    inline void setUseExtendedOptions (bool useExtendedOptions_);

    // API of field "releaseFilter"

    static const int kReleaseFilter = 4;

    /**
     * Clears the field "releaseFilter".
     *
     * The field will be set to its default value. The hasReleaseFilter()
     * method will return false.
     */
    inline void clearReleaseFilter();

    /**
     * Checks whether the field "releaseFilter" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setReleaseFilter()). Otherwise it will return false.
     */
    inline bool hasReleaseFilter () const;

    /**
     * Returns the value of the member "releaseFilter".
     *
     * If the meaning of "releaseFilter" isn't clear, then there should be a description here.
     *
     * @return The value of the field "releaseFilter"
     */
    inline const trReleaseFilter& getReleaseFilter () const;

    /**
     * Retrieves the value of the field "releaseFilter" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "releaseFilter".
     */
    inline trReleaseFilter& getReleaseFilterMutable ();

    /**
     * Sets the value of the member "releaseFilter".
     *
     * If the meaning of "releaseFilter" isn't clear, then there should be a description here.
     *
     * @param releaseFilter The value which will be set
     */
    inline void setReleaseFilter (const trReleaseFilter& releaseFilter_);

    // API of field "updateOption"

    static const int kUpdateOption = 5;

    /**
     * Clears the field "updateOption".
     *
     * The field will be set to its default value. The hasUpdateOption()
     * method will return false.
     */
    inline void clearUpdateOption();

    /**
     * Checks whether the field "updateOption" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setUpdateOption()). Otherwise it will return false.
     */
    inline bool hasUpdateOption () const;

    /**
     * Returns the value of the member "updateOption".
     *
     * If the meaning of "updateOption" isn't clear, then there should be a description here.
     *
     * @return The value of the field "updateOption"
     */
    inline tenUpdOptions getUpdateOption () const;

    /**
     * Sets the value of the member "updateOption".
     *
     * If the meaning of "updateOption" isn't clear, then there should be a description here.
     *
     * @param updateOption The value which will be set
     */
    inline void setUpdateOption (tenUpdOptions updateOption_);

    // API of field "doApply"

    static const int kDoApply = 6;

    /**
     * Clears the field "doApply".
     *
     * The field will be set to its default value. The hasDoApply()
     * method will return false.
     */
    inline void clearDoApply();

    /**
     * Checks whether the field "doApply" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDoApply()). Otherwise it will return false.
     */
    inline bool hasDoApply () const;

    /**
     * Returns the value of the member "doApply".
     *
     * If the meaning of "doApply" isn't clear, then there should be a description here.
     *
     * @return The value of the field "doApply"
     */
    inline bool getDoApply () const;

    /**
     * Sets the value of the member "doApply".
     *
     * If the meaning of "doApply" isn't clear, then there should be a description here.
     *
     * @param doApply The value which will be set
     */
    inline void setDoApply (bool doApply_);

    // API of field "postImageInstallationMode"

    static const int kPostImageInstallationMode = 7;

    /**
     * Clears the field "postImageInstallationMode".
     *
     * The field will be set to its default value. The hasPostImageInstallationMode()
     * method will return false.
     */
    inline void clearPostImageInstallationMode();

    /**
     * Checks whether the field "postImageInstallationMode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPostImageInstallationMode()). Otherwise it will return false.
     */
    inline bool hasPostImageInstallationMode () const;

    /**
     * Returns the value of the member "postImageInstallationMode".
     *
     * If the meaning of "postImageInstallationMode" isn't clear, then there should be a description here.
     *
     * @return The value of the field "postImageInstallationMode"
     */
    inline bool getPostImageInstallationMode () const;

    /**
     * Sets the value of the member "postImageInstallationMode".
     *
     * If the meaning of "postImageInstallationMode" isn't clear, then there should be a description here.
     *
     * @param postImageInstallationMode The value which will be set
     */
    inline void setPostImageInstallationMode (bool postImageInstallationMode_);

    static const trReleaseAccess &getDefaultInstance();

private:

    inline void set_has_mountPoint ();

    inline void clear_has_mountPoint ();

    inline void set_has_path ();

    inline void clear_has_path ();

    inline void set_has_file ();

    inline void clear_has_file ();

    inline void set_has_useExtendedOptions ();

    inline void clear_has_useExtendedOptions ();

    inline void set_has_releaseFilter ();

    inline void clear_has_releaseFilter ();

    inline void set_has_updateOption ();

    inline void clear_has_updateOption ();

    inline void set_has_doApply ();

    inline void clear_has_doApply ();

    inline void set_has_postImageInstallationMode ();

    inline void clear_has_postImageInstallationMode ();

    uint32 _has_bits_[ (8 + 31) / 32];

    ::std::string _mountPoint;

    ::std::string _path;

    ::std::string _file;

    bool _useExtendedOptions;

    trReleaseFilter _releaseFilter;

    tenUpdOptions _updateOption;

    bool _doApply;

    bool _postImageInstallationMode;

};

/**
 * If the meaning of "trReleaseInfos" isn't clear, then there should be a description here.
 */
class trReleaseInfos {
public:

    /**
     * Default constructor
     */
    inline  trReleaseInfos ();

    /**
     * Copy constructor
     */
    inline  trReleaseInfos (const trReleaseInfos &rhs);

    /**
     * All fields constructor
     */
    inline  trReleaseInfos (tenErrorId enErrorId_, const ::std::vector< trReleaseInfo >& releaseInfos_);

    /**
     * Destructor
     */
    inline  ~trReleaseInfos();

    /**
     * Assignment operator
     */
    inline trReleaseInfos& operator = (const trReleaseInfos& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const trReleaseInfos& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const trReleaseInfos& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const trReleaseInfos& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const trReleaseInfos& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "enErrorId"

    static const int kEnErrorId = 0;

    /**
     * Clears the field "enErrorId".
     *
     * The field will be set to its default value. The hasEnErrorId()
     * method will return false.
     */
    inline void clearEnErrorId();

    /**
     * Checks whether the field "enErrorId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEnErrorId()). Otherwise it will return false.
     */
    inline bool hasEnErrorId () const;

    /**
     * Returns the value of the member "enErrorId".
     *
     * If the meaning of "enErrorId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "enErrorId"
     */
    inline tenErrorId getEnErrorId () const;

    /**
     * Sets the value of the member "enErrorId".
     *
     * If the meaning of "enErrorId" isn't clear, then there should be a description here.
     *
     * @param enErrorId The value which will be set
     */
    inline void setEnErrorId (tenErrorId enErrorId_);

    // API of field "releaseInfos"

    static const int kReleaseInfos = 1;

    /**
     * Clears the field "releaseInfos".
     *
     * The field will be set to its default value. The hasReleaseInfos()
     * method will return false.
     */
    inline void clearReleaseInfos();

    /**
     * Checks whether the field "releaseInfos" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setReleaseInfos()). Otherwise it will return false.
     */
    inline bool hasReleaseInfos () const;

    /**
     * Returns the value of the member "releaseInfos".
     *
     * If the meaning of "releaseInfos" isn't clear, then there should be a description here.
     *
     * @return The value of the field "releaseInfos"
     */
    inline const ::std::vector< trReleaseInfo >& getReleaseInfos () const;

    /**
     * Retrieves the value of the field "releaseInfos" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "releaseInfos".
     */
    inline ::std::vector< trReleaseInfo >& getReleaseInfosMutable ();

    /**
     * Sets the value of the member "releaseInfos".
     *
     * If the meaning of "releaseInfos" isn't clear, then there should be a description here.
     *
     * @param releaseInfos The value which will be set
     */
    inline void setReleaseInfos (const ::std::vector< trReleaseInfo >& releaseInfos_);

    static const trReleaseInfos &getDefaultInstance();

private:

    static const ::std::vector< trReleaseInfo >& getTrReleaseInfoList_DefaultInstance ();

    inline void set_has_enErrorId ();

    inline void clear_has_enErrorId ();

    inline void set_has_releaseInfos ();

    inline void clear_has_releaseInfos ();

    uint32 _has_bits_[ (2 + 31) / 32];

    tenErrorId _enErrorId;

    ::std::vector< trReleaseInfo > _releaseInfos;

};

/**
 * If the meaning of "trDeviceState" isn't clear, then there should be a description here.
 */
class trDeviceState {
public:

    /**
     * Default constructor
     */
    inline  trDeviceState ();

    /**
     * Copy constructor
     */
    inline  trDeviceState (const trDeviceState &rhs);

    /**
     * All fields constructor
     */
    inline  trDeviceState (const ::std::string& name_, const ::std::string& hwIndex_, const ::std::string& info_, bool bReady_);

    /**
     * Destructor
     */
    inline  ~trDeviceState();

    /**
     * Assignment operator
     */
    inline trDeviceState& operator = (const trDeviceState& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const trDeviceState& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const trDeviceState& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const trDeviceState& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const trDeviceState& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "name"

    static const int kName = 0;

    /**
     * Clears the field "name".
     *
     * The field will be set to its default value. The hasName()
     * method will return false.
     */
    inline void clearName();

    /**
     * Checks whether the field "name" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setName()). Otherwise it will return false.
     */
    inline bool hasName () const;

    /**
     * Returns the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @return The value of the field "name"
     */
    inline const ::std::string& getName () const;

    /**
     * Retrieves the value of the field "name" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "name".
     */
    inline ::std::string& getNameMutable ();

    /**
     * Sets the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param name The value which will be set
     */
    inline void setName (const ::std::string& name_);

    /**
     * Sets the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param name The value which will be set
     */
    inline void setName (const char* name_);

    /**
     * Sets the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param name The value which will be set
     */
    inline void setName (const char* value, size_t size);

    // API of field "hwIndex"

    static const int kHwIndex = 1;

    /**
     * Clears the field "hwIndex".
     *
     * The field will be set to its default value. The hasHwIndex()
     * method will return false.
     */
    inline void clearHwIndex();

    /**
     * Checks whether the field "hwIndex" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setHwIndex()). Otherwise it will return false.
     */
    inline bool hasHwIndex () const;

    /**
     * Returns the value of the member "hwIndex".
     *
     * If the meaning of "hwIndex" isn't clear, then there should be a description here.
     *
     * @return The value of the field "hwIndex"
     */
    inline const ::std::string& getHwIndex () const;

    /**
     * Retrieves the value of the field "hwIndex" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "hwIndex".
     */
    inline ::std::string& getHwIndexMutable ();

    /**
     * Sets the value of the member "hwIndex".
     *
     * If the meaning of "hwIndex" isn't clear, then there should be a description here.
     *
     * @param hwIndex The value which will be set
     */
    inline void setHwIndex (const ::std::string& hwIndex_);

    /**
     * Sets the value of the member "hwIndex".
     *
     * If the meaning of "hwIndex" isn't clear, then there should be a description here.
     *
     * @param hwIndex The value which will be set
     */
    inline void setHwIndex (const char* hwIndex_);

    /**
     * Sets the value of the member "hwIndex".
     *
     * If the meaning of "hwIndex" isn't clear, then there should be a description here.
     *
     * @param hwIndex The value which will be set
     */
    inline void setHwIndex (const char* value, size_t size);

    // API of field "info"

    static const int kInfo = 2;

    /**
     * Clears the field "info".
     *
     * The field will be set to its default value. The hasInfo()
     * method will return false.
     */
    inline void clearInfo();

    /**
     * Checks whether the field "info" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setInfo()). Otherwise it will return false.
     */
    inline bool hasInfo () const;

    /**
     * Returns the value of the member "info".
     *
     * If the meaning of "info" isn't clear, then there should be a description here.
     *
     * @return The value of the field "info"
     */
    inline const ::std::string& getInfo () const;

    /**
     * Retrieves the value of the field "info" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "info".
     */
    inline ::std::string& getInfoMutable ();

    /**
     * Sets the value of the member "info".
     *
     * If the meaning of "info" isn't clear, then there should be a description here.
     *
     * @param info The value which will be set
     */
    inline void setInfo (const ::std::string& info_);

    /**
     * Sets the value of the member "info".
     *
     * If the meaning of "info" isn't clear, then there should be a description here.
     *
     * @param info The value which will be set
     */
    inline void setInfo (const char* info_);

    /**
     * Sets the value of the member "info".
     *
     * If the meaning of "info" isn't clear, then there should be a description here.
     *
     * @param info The value which will be set
     */
    inline void setInfo (const char* value, size_t size);

    // API of field "bReady"

    static const int kBReady = 3;

    /**
     * Clears the field "bReady".
     *
     * The field will be set to its default value. The hasBReady()
     * method will return false.
     */
    inline void clearBReady();

    /**
     * Checks whether the field "bReady" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBReady()). Otherwise it will return false.
     */
    inline bool hasBReady () const;

    /**
     * Returns the value of the member "bReady".
     *
     * If the meaning of "bReady" isn't clear, then there should be a description here.
     *
     * @return The value of the field "bReady"
     */
    inline bool getBReady () const;

    /**
     * Sets the value of the member "bReady".
     *
     * If the meaning of "bReady" isn't clear, then there should be a description here.
     *
     * @param bReady The value which will be set
     */
    inline void setBReady (bool bReady_);

    static const trDeviceState &getDefaultInstance();

private:

    inline void set_has_name ();

    inline void clear_has_name ();

    inline void set_has_hwIndex ();

    inline void clear_has_hwIndex ();

    inline void set_has_info ();

    inline void clear_has_info ();

    inline void set_has_bReady ();

    inline void clear_has_bReady ();

    uint32 _has_bits_[ (4 + 31) / 32];

    ::std::string _name;

    ::std::string _hwIndex;

    ::std::string _info;

    bool _bReady;

};

/**
 * If the meaning of "trDeviceStates" isn't clear, then there should be a description here.
 */
class trDeviceStates {
public:

    /**
     * Default constructor
     */
    inline  trDeviceStates ();

    /**
     * Copy constructor
     */
    inline  trDeviceStates (const trDeviceStates &rhs);

    /**
     * All fields constructor
     */
    inline  trDeviceStates (const ::std::vector< trDeviceState >& deviceStates_);

    /**
     * Destructor
     */
    inline  ~trDeviceStates();

    /**
     * Assignment operator
     */
    inline trDeviceStates& operator = (const trDeviceStates& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const trDeviceStates& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const trDeviceStates& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const trDeviceStates& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const trDeviceStates& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "deviceStates"

    static const int kDeviceStates = 0;

    /**
     * Clears the field "deviceStates".
     *
     * The field will be set to its default value. The hasDeviceStates()
     * method will return false.
     */
    inline void clearDeviceStates();

    /**
     * Checks whether the field "deviceStates" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceStates()). Otherwise it will return false.
     */
    inline bool hasDeviceStates () const;

    /**
     * Returns the value of the member "deviceStates".
     *
     * If the meaning of "deviceStates" isn't clear, then there should be a description here.
     *
     * @return The value of the field "deviceStates"
     */
    inline const ::std::vector< trDeviceState >& getDeviceStates () const;

    /**
     * Retrieves the value of the field "deviceStates" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "deviceStates".
     */
    inline ::std::vector< trDeviceState >& getDeviceStatesMutable ();

    /**
     * Sets the value of the member "deviceStates".
     *
     * If the meaning of "deviceStates" isn't clear, then there should be a description here.
     *
     * @param deviceStates The value which will be set
     */
    inline void setDeviceStates (const ::std::vector< trDeviceState >& deviceStates_);

    static const trDeviceStates &getDefaultInstance();

private:

    static const ::std::vector< trDeviceState >& getTrDeviceStateList_DefaultInstance ();

    inline void set_has_deviceStates ();

    inline void clear_has_deviceStates ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< trDeviceState > _deviceStates;

};

/**
 * If the meaning of "trUpdState" isn't clear, then there should be a description here.
 */
class trUpdState {
public:

    /**
     * Default constructor
     */
    inline  trUpdState ();

    /**
     * Copy constructor
     */
    inline  trUpdState (const trUpdState &rhs);

    /**
     * All fields constructor
     */
    inline  trUpdState (const ::std::string& train_, const ::std::string& sourceSwTrain_, uint32 u32EstimatedUpdateTimeSec_, const ::std::string& muVersion_, tenUpdState enState_, tenUser enUser_, tenSourceType enSourceType_, bool bHasEngineeringOptions_, bool bCustomSupported_, bool bCustomAvail_, bool bInterruptible_, bool bDevicesReady_, bool hasValidTrain_, bool bAllowRecoveryMode_, const ::std::string& headUnitId_, const ::std::string& overallCISSWVer_);

    /**
     * Destructor
     */
    inline  ~trUpdState();

    /**
     * Assignment operator
     */
    inline trUpdState& operator = (const trUpdState& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const trUpdState& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const trUpdState& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const trUpdState& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const trUpdState& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "train"

    static const int kTrain = 0;

    /**
     * Clears the field "train".
     *
     * The field will be set to its default value. The hasTrain()
     * method will return false.
     */
    inline void clearTrain();

    /**
     * Checks whether the field "train" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTrain()). Otherwise it will return false.
     */
    inline bool hasTrain () const;

    /**
     * Returns the value of the member "train".
     *
     * If the meaning of "train" isn't clear, then there should be a description here.
     *
     * @return The value of the field "train"
     */
    inline const ::std::string& getTrain () const;

    /**
     * Retrieves the value of the field "train" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "train".
     */
    inline ::std::string& getTrainMutable ();

    /**
     * Sets the value of the member "train".
     *
     * If the meaning of "train" isn't clear, then there should be a description here.
     *
     * @param train The value which will be set
     */
    inline void setTrain (const ::std::string& train_);

    /**
     * Sets the value of the member "train".
     *
     * If the meaning of "train" isn't clear, then there should be a description here.
     *
     * @param train The value which will be set
     */
    inline void setTrain (const char* train_);

    /**
     * Sets the value of the member "train".
     *
     * If the meaning of "train" isn't clear, then there should be a description here.
     *
     * @param train The value which will be set
     */
    inline void setTrain (const char* value, size_t size);

    // API of field "sourceSwTrain"

    static const int kSourceSwTrain = 1;

    /**
     * Clears the field "sourceSwTrain".
     *
     * The field will be set to its default value. The hasSourceSwTrain()
     * method will return false.
     */
    inline void clearSourceSwTrain();

    /**
     * Checks whether the field "sourceSwTrain" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSourceSwTrain()). Otherwise it will return false.
     */
    inline bool hasSourceSwTrain () const;

    /**
     * Returns the value of the member "sourceSwTrain".
     *
     * If the meaning of "sourceSwTrain" isn't clear, then there should be a description here.
     *
     * @return The value of the field "sourceSwTrain"
     */
    inline const ::std::string& getSourceSwTrain () const;

    /**
     * Retrieves the value of the field "sourceSwTrain" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sourceSwTrain".
     */
    inline ::std::string& getSourceSwTrainMutable ();

    /**
     * Sets the value of the member "sourceSwTrain".
     *
     * If the meaning of "sourceSwTrain" isn't clear, then there should be a description here.
     *
     * @param sourceSwTrain The value which will be set
     */
    inline void setSourceSwTrain (const ::std::string& sourceSwTrain_);

    /**
     * Sets the value of the member "sourceSwTrain".
     *
     * If the meaning of "sourceSwTrain" isn't clear, then there should be a description here.
     *
     * @param sourceSwTrain The value which will be set
     */
    inline void setSourceSwTrain (const char* sourceSwTrain_);

    /**
     * Sets the value of the member "sourceSwTrain".
     *
     * If the meaning of "sourceSwTrain" isn't clear, then there should be a description here.
     *
     * @param sourceSwTrain The value which will be set
     */
    inline void setSourceSwTrain (const char* value, size_t size);

    // API of field "u32EstimatedUpdateTimeSec"

    static const int kU32EstimatedUpdateTimeSec = 2;

    /**
     * Clears the field "u32EstimatedUpdateTimeSec".
     *
     * The field will be set to its default value. The hasU32EstimatedUpdateTimeSec()
     * method will return false.
     */
    inline void clearU32EstimatedUpdateTimeSec();

    /**
     * Checks whether the field "u32EstimatedUpdateTimeSec" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32EstimatedUpdateTimeSec()). Otherwise it will return false.
     */
    inline bool hasU32EstimatedUpdateTimeSec () const;

    /**
     * Returns the value of the member "u32EstimatedUpdateTimeSec".
     *
     * If the meaning of "u32EstimatedUpdateTimeSec" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u32EstimatedUpdateTimeSec"
     */
    inline uint32 getU32EstimatedUpdateTimeSec () const;

    /**
     * Sets the value of the member "u32EstimatedUpdateTimeSec".
     *
     * If the meaning of "u32EstimatedUpdateTimeSec" isn't clear, then there should be a description here.
     *
     * @param u32EstimatedUpdateTimeSec The value which will be set
     */
    inline void setU32EstimatedUpdateTimeSec (uint32 u32EstimatedUpdateTimeSec_);

    // API of field "muVersion"

    static const int kMuVersion = 3;

    /**
     * Clears the field "muVersion".
     *
     * The field will be set to its default value. The hasMuVersion()
     * method will return false.
     */
    inline void clearMuVersion();

    /**
     * Checks whether the field "muVersion" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMuVersion()). Otherwise it will return false.
     */
    inline bool hasMuVersion () const;

    /**
     * Returns the value of the member "muVersion".
     *
     * If the meaning of "muVersion" isn't clear, then there should be a description here.
     *
     * @return The value of the field "muVersion"
     */
    inline const ::std::string& getMuVersion () const;

    /**
     * Retrieves the value of the field "muVersion" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "muVersion".
     */
    inline ::std::string& getMuVersionMutable ();

    /**
     * Sets the value of the member "muVersion".
     *
     * If the meaning of "muVersion" isn't clear, then there should be a description here.
     *
     * @param muVersion The value which will be set
     */
    inline void setMuVersion (const ::std::string& muVersion_);

    /**
     * Sets the value of the member "muVersion".
     *
     * If the meaning of "muVersion" isn't clear, then there should be a description here.
     *
     * @param muVersion The value which will be set
     */
    inline void setMuVersion (const char* muVersion_);

    /**
     * Sets the value of the member "muVersion".
     *
     * If the meaning of "muVersion" isn't clear, then there should be a description here.
     *
     * @param muVersion The value which will be set
     */
    inline void setMuVersion (const char* value, size_t size);

    // API of field "enState"

    static const int kEnState = 4;

    /**
     * Clears the field "enState".
     *
     * The field will be set to its default value. The hasEnState()
     * method will return false.
     */
    inline void clearEnState();

    /**
     * Checks whether the field "enState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEnState()). Otherwise it will return false.
     */
    inline bool hasEnState () const;

    /**
     * Returns the value of the member "enState".
     *
     * If the meaning of "enState" isn't clear, then there should be a description here.
     *
     * @return The value of the field "enState"
     */
    inline tenUpdState getEnState () const;

    /**
     * Sets the value of the member "enState".
     *
     * If the meaning of "enState" isn't clear, then there should be a description here.
     *
     * @param enState The value which will be set
     */
    inline void setEnState (tenUpdState enState_);

    // API of field "enUser"

    static const int kEnUser = 5;

    /**
     * Clears the field "enUser".
     *
     * The field will be set to its default value. The hasEnUser()
     * method will return false.
     */
    inline void clearEnUser();

    /**
     * Checks whether the field "enUser" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEnUser()). Otherwise it will return false.
     */
    inline bool hasEnUser () const;

    /**
     * Returns the value of the member "enUser".
     *
     * If the meaning of "enUser" isn't clear, then there should be a description here.
     *
     * @return The value of the field "enUser"
     */
    inline tenUser getEnUser () const;

    /**
     * Sets the value of the member "enUser".
     *
     * If the meaning of "enUser" isn't clear, then there should be a description here.
     *
     * @param enUser The value which will be set
     */
    inline void setEnUser (tenUser enUser_);

    // API of field "enSourceType"

    static const int kEnSourceType = 6;

    /**
     * Clears the field "enSourceType".
     *
     * The field will be set to its default value. The hasEnSourceType()
     * method will return false.
     */
    inline void clearEnSourceType();

    /**
     * Checks whether the field "enSourceType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEnSourceType()). Otherwise it will return false.
     */
    inline bool hasEnSourceType () const;

    /**
     * Returns the value of the member "enSourceType".
     *
     * If the meaning of "enSourceType" isn't clear, then there should be a description here.
     *
     * @return The value of the field "enSourceType"
     */
    inline tenSourceType getEnSourceType () const;

    /**
     * Sets the value of the member "enSourceType".
     *
     * If the meaning of "enSourceType" isn't clear, then there should be a description here.
     *
     * @param enSourceType The value which will be set
     */
    inline void setEnSourceType (tenSourceType enSourceType_);

    // API of field "bHasEngineeringOptions"

    static const int kBHasEngineeringOptions = 7;

    /**
     * Clears the field "bHasEngineeringOptions".
     *
     * The field will be set to its default value. The hasBHasEngineeringOptions()
     * method will return false.
     */
    inline void clearBHasEngineeringOptions();

    /**
     * Checks whether the field "bHasEngineeringOptions" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBHasEngineeringOptions()). Otherwise it will return false.
     */
    inline bool hasBHasEngineeringOptions () const;

    /**
     * Returns the value of the member "bHasEngineeringOptions".
     *
     * If the meaning of "bHasEngineeringOptions" isn't clear, then there should be a description here.
     *
     * @return The value of the field "bHasEngineeringOptions"
     */
    inline bool getBHasEngineeringOptions () const;

    /**
     * Sets the value of the member "bHasEngineeringOptions".
     *
     * If the meaning of "bHasEngineeringOptions" isn't clear, then there should be a description here.
     *
     * @param bHasEngineeringOptions The value which will be set
     */
    inline void setBHasEngineeringOptions (bool bHasEngineeringOptions_);

    // API of field "bCustomSupported"

    static const int kBCustomSupported = 8;

    /**
     * Clears the field "bCustomSupported".
     *
     * The field will be set to its default value. The hasBCustomSupported()
     * method will return false.
     */
    inline void clearBCustomSupported();

    /**
     * Checks whether the field "bCustomSupported" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBCustomSupported()). Otherwise it will return false.
     */
    inline bool hasBCustomSupported () const;

    /**
     * Returns the value of the member "bCustomSupported".
     *
     * If the meaning of "bCustomSupported" isn't clear, then there should be a description here.
     *
     * @return The value of the field "bCustomSupported"
     */
    inline bool getBCustomSupported () const;

    /**
     * Sets the value of the member "bCustomSupported".
     *
     * If the meaning of "bCustomSupported" isn't clear, then there should be a description here.
     *
     * @param bCustomSupported The value which will be set
     */
    inline void setBCustomSupported (bool bCustomSupported_);

    // API of field "bCustomAvail"

    static const int kBCustomAvail = 9;

    /**
     * Clears the field "bCustomAvail".
     *
     * The field will be set to its default value. The hasBCustomAvail()
     * method will return false.
     */
    inline void clearBCustomAvail();

    /**
     * Checks whether the field "bCustomAvail" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBCustomAvail()). Otherwise it will return false.
     */
    inline bool hasBCustomAvail () const;

    /**
     * Returns the value of the member "bCustomAvail".
     *
     * If the meaning of "bCustomAvail" isn't clear, then there should be a description here.
     *
     * @return The value of the field "bCustomAvail"
     */
    inline bool getBCustomAvail () const;

    /**
     * Sets the value of the member "bCustomAvail".
     *
     * If the meaning of "bCustomAvail" isn't clear, then there should be a description here.
     *
     * @param bCustomAvail The value which will be set
     */
    inline void setBCustomAvail (bool bCustomAvail_);

    // API of field "bInterruptible"

    static const int kBInterruptible = 10;

    /**
     * Clears the field "bInterruptible".
     *
     * The field will be set to its default value. The hasBInterruptible()
     * method will return false.
     */
    inline void clearBInterruptible();

    /**
     * Checks whether the field "bInterruptible" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBInterruptible()). Otherwise it will return false.
     */
    inline bool hasBInterruptible () const;

    /**
     * Returns the value of the member "bInterruptible".
     *
     * If the meaning of "bInterruptible" isn't clear, then there should be a description here.
     *
     * @return The value of the field "bInterruptible"
     */
    inline bool getBInterruptible () const;

    /**
     * Sets the value of the member "bInterruptible".
     *
     * If the meaning of "bInterruptible" isn't clear, then there should be a description here.
     *
     * @param bInterruptible The value which will be set
     */
    inline void setBInterruptible (bool bInterruptible_);

    // API of field "bDevicesReady"

    static const int kBDevicesReady = 11;

    /**
     * Clears the field "bDevicesReady".
     *
     * The field will be set to its default value. The hasBDevicesReady()
     * method will return false.
     */
    inline void clearBDevicesReady();

    /**
     * Checks whether the field "bDevicesReady" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBDevicesReady()). Otherwise it will return false.
     */
    inline bool hasBDevicesReady () const;

    /**
     * Returns the value of the member "bDevicesReady".
     *
     * If the meaning of "bDevicesReady" isn't clear, then there should be a description here.
     *
     * @return The value of the field "bDevicesReady"
     */
    inline bool getBDevicesReady () const;

    /**
     * Sets the value of the member "bDevicesReady".
     *
     * If the meaning of "bDevicesReady" isn't clear, then there should be a description here.
     *
     * @param bDevicesReady The value which will be set
     */
    inline void setBDevicesReady (bool bDevicesReady_);

    // API of field "hasValidTrain"

    static const int kHasValidTrain = 12;

    /**
     * Clears the field "hasValidTrain".
     *
     * The field will be set to its default value. The hasHasValidTrain()
     * method will return false.
     */
    inline void clearHasValidTrain();

    /**
     * Checks whether the field "hasValidTrain" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setHasValidTrain()). Otherwise it will return false.
     */
    inline bool hasHasValidTrain () const;

    /**
     * Returns the value of the member "hasValidTrain".
     *
     * If the meaning of "hasValidTrain" isn't clear, then there should be a description here.
     *
     * @return The value of the field "hasValidTrain"
     */
    inline bool getHasValidTrain () const;

    /**
     * Sets the value of the member "hasValidTrain".
     *
     * If the meaning of "hasValidTrain" isn't clear, then there should be a description here.
     *
     * @param hasValidTrain The value which will be set
     */
    inline void setHasValidTrain (bool hasValidTrain_);

    // API of field "bAllowRecoveryMode"

    static const int kBAllowRecoveryMode = 13;

    /**
     * Clears the field "bAllowRecoveryMode".
     *
     * The field will be set to its default value. The hasBAllowRecoveryMode()
     * method will return false.
     */
    inline void clearBAllowRecoveryMode();

    /**
     * Checks whether the field "bAllowRecoveryMode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBAllowRecoveryMode()). Otherwise it will return false.
     */
    inline bool hasBAllowRecoveryMode () const;

    /**
     * Returns the value of the member "bAllowRecoveryMode".
     *
     * If the meaning of "bAllowRecoveryMode" isn't clear, then there should be a description here.
     *
     * @return The value of the field "bAllowRecoveryMode"
     */
    inline bool getBAllowRecoveryMode () const;

    /**
     * Sets the value of the member "bAllowRecoveryMode".
     *
     * If the meaning of "bAllowRecoveryMode" isn't clear, then there should be a description here.
     *
     * @param bAllowRecoveryMode The value which will be set
     */
    inline void setBAllowRecoveryMode (bool bAllowRecoveryMode_);

    // API of field "headUnitId"

    static const int kHeadUnitId = 14;

    /**
     * Clears the field "headUnitId".
     *
     * The field will be set to its default value. The hasHeadUnitId()
     * method will return false.
     */
    inline void clearHeadUnitId();

    /**
     * Checks whether the field "headUnitId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setHeadUnitId()). Otherwise it will return false.
     */
    inline bool hasHeadUnitId () const;

    /**
     * Returns the value of the member "headUnitId".
     *
     * If the meaning of "headUnitId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "headUnitId"
     */
    inline const ::std::string& getHeadUnitId () const;

    /**
     * Retrieves the value of the field "headUnitId" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "headUnitId".
     */
    inline ::std::string& getHeadUnitIdMutable ();

    /**
     * Sets the value of the member "headUnitId".
     *
     * If the meaning of "headUnitId" isn't clear, then there should be a description here.
     *
     * @param headUnitId The value which will be set
     */
    inline void setHeadUnitId (const ::std::string& headUnitId_);

    /**
     * Sets the value of the member "headUnitId".
     *
     * If the meaning of "headUnitId" isn't clear, then there should be a description here.
     *
     * @param headUnitId The value which will be set
     */
    inline void setHeadUnitId (const char* headUnitId_);

    /**
     * Sets the value of the member "headUnitId".
     *
     * If the meaning of "headUnitId" isn't clear, then there should be a description here.
     *
     * @param headUnitId The value which will be set
     */
    inline void setHeadUnitId (const char* value, size_t size);

    // API of field "overallCISSWVer"

    static const int kOverallCISSWVer = 15;

    /**
     * Clears the field "overallCISSWVer".
     *
     * The field will be set to its default value. The hasOverallCISSWVer()
     * method will return false.
     */
    inline void clearOverallCISSWVer();

    /**
     * Checks whether the field "overallCISSWVer" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOverallCISSWVer()). Otherwise it will return false.
     */
    inline bool hasOverallCISSWVer () const;

    /**
     * Returns the value of the member "overallCISSWVer".
     *
     * If the meaning of "overallCISSWVer" isn't clear, then there should be a description here.
     *
     * @return The value of the field "overallCISSWVer"
     */
    inline const ::std::string& getOverallCISSWVer () const;

    /**
     * Retrieves the value of the field "overallCISSWVer" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "overallCISSWVer".
     */
    inline ::std::string& getOverallCISSWVerMutable ();

    /**
     * Sets the value of the member "overallCISSWVer".
     *
     * If the meaning of "overallCISSWVer" isn't clear, then there should be a description here.
     *
     * @param overallCISSWVer The value which will be set
     */
    inline void setOverallCISSWVer (const ::std::string& overallCISSWVer_);

    /**
     * Sets the value of the member "overallCISSWVer".
     *
     * If the meaning of "overallCISSWVer" isn't clear, then there should be a description here.
     *
     * @param overallCISSWVer The value which will be set
     */
    inline void setOverallCISSWVer (const char* overallCISSWVer_);

    /**
     * Sets the value of the member "overallCISSWVer".
     *
     * If the meaning of "overallCISSWVer" isn't clear, then there should be a description here.
     *
     * @param overallCISSWVer The value which will be set
     */
    inline void setOverallCISSWVer (const char* value, size_t size);

    static const trUpdState &getDefaultInstance();

private:

    inline void set_has_train ();

    inline void clear_has_train ();

    inline void set_has_sourceSwTrain ();

    inline void clear_has_sourceSwTrain ();

    inline void set_has_u32EstimatedUpdateTimeSec ();

    inline void clear_has_u32EstimatedUpdateTimeSec ();

    inline void set_has_muVersion ();

    inline void clear_has_muVersion ();

    inline void set_has_enState ();

    inline void clear_has_enState ();

    inline void set_has_enUser ();

    inline void clear_has_enUser ();

    inline void set_has_enSourceType ();

    inline void clear_has_enSourceType ();

    inline void set_has_bHasEngineeringOptions ();

    inline void clear_has_bHasEngineeringOptions ();

    inline void set_has_bCustomSupported ();

    inline void clear_has_bCustomSupported ();

    inline void set_has_bCustomAvail ();

    inline void clear_has_bCustomAvail ();

    inline void set_has_bInterruptible ();

    inline void clear_has_bInterruptible ();

    inline void set_has_bDevicesReady ();

    inline void clear_has_bDevicesReady ();

    inline void set_has_hasValidTrain ();

    inline void clear_has_hasValidTrain ();

    inline void set_has_bAllowRecoveryMode ();

    inline void clear_has_bAllowRecoveryMode ();

    inline void set_has_headUnitId ();

    inline void clear_has_headUnitId ();

    inline void set_has_overallCISSWVer ();

    inline void clear_has_overallCISSWVer ();

    uint32 _has_bits_[ (16 + 31) / 32];

    ::std::string _train;

    ::std::string _sourceSwTrain;

    uint32 _u32EstimatedUpdateTimeSec;

    ::std::string _muVersion;

    tenUpdState _enState;

    tenUser _enUser;

    tenSourceType _enSourceType;

    bool _bHasEngineeringOptions;

    bool _bCustomSupported;

    bool _bCustomAvail;

    bool _bInterruptible;

    bool _bDevicesReady;

    bool _hasValidTrain;

    bool _bAllowRecoveryMode;

    ::std::string _headUnitId;

    ::std::string _overallCISSWVer;

};

/**
 * If the meaning of "trSubModuleData" isn't clear, then there should be a description here.
 */
class trSubModuleData {
public:

    /**
     * Default constructor
     */
    inline  trSubModuleData ();

    /**
     * Copy constructor
     */
    inline  trSubModuleData (const trSubModuleData &rhs);

    /**
     * All fields constructor
     */
    inline  trSubModuleData (const ::std::string& name_, bool bSelected_, const ::std::string& info_, const ::std::string& toVersion_, const ::std::string& fromVersion_, uint64 sizeBytes_, tenScope enScope_, const ::std::vector< uint8 >& compatInfo_);

    /**
     * Destructor
     */
    inline  ~trSubModuleData();

    /**
     * Assignment operator
     */
    inline trSubModuleData& operator = (const trSubModuleData& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const trSubModuleData& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const trSubModuleData& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const trSubModuleData& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const trSubModuleData& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "name"

    static const int kName = 0;

    /**
     * Clears the field "name".
     *
     * The field will be set to its default value. The hasName()
     * method will return false.
     */
    inline void clearName();

    /**
     * Checks whether the field "name" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setName()). Otherwise it will return false.
     */
    inline bool hasName () const;

    /**
     * Returns the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @return The value of the field "name"
     */
    inline const ::std::string& getName () const;

    /**
     * Retrieves the value of the field "name" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "name".
     */
    inline ::std::string& getNameMutable ();

    /**
     * Sets the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param name The value which will be set
     */
    inline void setName (const ::std::string& name_);

    /**
     * Sets the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param name The value which will be set
     */
    inline void setName (const char* name_);

    /**
     * Sets the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param name The value which will be set
     */
    inline void setName (const char* value, size_t size);

    // API of field "bSelected"

    static const int kBSelected = 1;

    /**
     * Clears the field "bSelected".
     *
     * The field will be set to its default value. The hasBSelected()
     * method will return false.
     */
    inline void clearBSelected();

    /**
     * Checks whether the field "bSelected" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBSelected()). Otherwise it will return false.
     */
    inline bool hasBSelected () const;

    /**
     * Returns the value of the member "bSelected".
     *
     * If the meaning of "bSelected" isn't clear, then there should be a description here.
     *
     * @return The value of the field "bSelected"
     */
    inline bool getBSelected () const;

    /**
     * Sets the value of the member "bSelected".
     *
     * If the meaning of "bSelected" isn't clear, then there should be a description here.
     *
     * @param bSelected The value which will be set
     */
    inline void setBSelected (bool bSelected_);

    // API of field "info"

    static const int kInfo = 2;

    /**
     * Clears the field "info".
     *
     * The field will be set to its default value. The hasInfo()
     * method will return false.
     */
    inline void clearInfo();

    /**
     * Checks whether the field "info" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setInfo()). Otherwise it will return false.
     */
    inline bool hasInfo () const;

    /**
     * Returns the value of the member "info".
     *
     * If the meaning of "info" isn't clear, then there should be a description here.
     *
     * @return The value of the field "info"
     */
    inline const ::std::string& getInfo () const;

    /**
     * Retrieves the value of the field "info" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "info".
     */
    inline ::std::string& getInfoMutable ();

    /**
     * Sets the value of the member "info".
     *
     * If the meaning of "info" isn't clear, then there should be a description here.
     *
     * @param info The value which will be set
     */
    inline void setInfo (const ::std::string& info_);

    /**
     * Sets the value of the member "info".
     *
     * If the meaning of "info" isn't clear, then there should be a description here.
     *
     * @param info The value which will be set
     */
    inline void setInfo (const char* info_);

    /**
     * Sets the value of the member "info".
     *
     * If the meaning of "info" isn't clear, then there should be a description here.
     *
     * @param info The value which will be set
     */
    inline void setInfo (const char* value, size_t size);

    // API of field "toVersion"

    static const int kToVersion = 3;

    /**
     * Clears the field "toVersion".
     *
     * The field will be set to its default value. The hasToVersion()
     * method will return false.
     */
    inline void clearToVersion();

    /**
     * Checks whether the field "toVersion" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setToVersion()). Otherwise it will return false.
     */
    inline bool hasToVersion () const;

    /**
     * Returns the value of the member "toVersion".
     *
     * If the meaning of "toVersion" isn't clear, then there should be a description here.
     *
     * @return The value of the field "toVersion"
     */
    inline const ::std::string& getToVersion () const;

    /**
     * Retrieves the value of the field "toVersion" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "toVersion".
     */
    inline ::std::string& getToVersionMutable ();

    /**
     * Sets the value of the member "toVersion".
     *
     * If the meaning of "toVersion" isn't clear, then there should be a description here.
     *
     * @param toVersion The value which will be set
     */
    inline void setToVersion (const ::std::string& toVersion_);

    /**
     * Sets the value of the member "toVersion".
     *
     * If the meaning of "toVersion" isn't clear, then there should be a description here.
     *
     * @param toVersion The value which will be set
     */
    inline void setToVersion (const char* toVersion_);

    /**
     * Sets the value of the member "toVersion".
     *
     * If the meaning of "toVersion" isn't clear, then there should be a description here.
     *
     * @param toVersion The value which will be set
     */
    inline void setToVersion (const char* value, size_t size);

    // API of field "fromVersion"

    static const int kFromVersion = 4;

    /**
     * Clears the field "fromVersion".
     *
     * The field will be set to its default value. The hasFromVersion()
     * method will return false.
     */
    inline void clearFromVersion();

    /**
     * Checks whether the field "fromVersion" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFromVersion()). Otherwise it will return false.
     */
    inline bool hasFromVersion () const;

    /**
     * Returns the value of the member "fromVersion".
     *
     * If the meaning of "fromVersion" isn't clear, then there should be a description here.
     *
     * @return The value of the field "fromVersion"
     */
    inline const ::std::string& getFromVersion () const;

    /**
     * Retrieves the value of the field "fromVersion" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "fromVersion".
     */
    inline ::std::string& getFromVersionMutable ();

    /**
     * Sets the value of the member "fromVersion".
     *
     * If the meaning of "fromVersion" isn't clear, then there should be a description here.
     *
     * @param fromVersion The value which will be set
     */
    inline void setFromVersion (const ::std::string& fromVersion_);

    /**
     * Sets the value of the member "fromVersion".
     *
     * If the meaning of "fromVersion" isn't clear, then there should be a description here.
     *
     * @param fromVersion The value which will be set
     */
    inline void setFromVersion (const char* fromVersion_);

    /**
     * Sets the value of the member "fromVersion".
     *
     * If the meaning of "fromVersion" isn't clear, then there should be a description here.
     *
     * @param fromVersion The value which will be set
     */
    inline void setFromVersion (const char* value, size_t size);

    // API of field "sizeBytes"

    static const int kSizeBytes = 5;

    /**
     * Clears the field "sizeBytes".
     *
     * The field will be set to its default value. The hasSizeBytes()
     * method will return false.
     */
    inline void clearSizeBytes();

    /**
     * Checks whether the field "sizeBytes" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSizeBytes()). Otherwise it will return false.
     */
    inline bool hasSizeBytes () const;

    /**
     * Returns the value of the member "sizeBytes".
     *
     * If the meaning of "sizeBytes" isn't clear, then there should be a description here.
     *
     * @return The value of the field "sizeBytes"
     */
    inline uint64 getSizeBytes () const;

    /**
     * Sets the value of the member "sizeBytes".
     *
     * If the meaning of "sizeBytes" isn't clear, then there should be a description here.
     *
     * @param sizeBytes The value which will be set
     */
    inline void setSizeBytes (uint64 sizeBytes_);

    // API of field "enScope"

    static const int kEnScope = 6;

    /**
     * Clears the field "enScope".
     *
     * The field will be set to its default value. The hasEnScope()
     * method will return false.
     */
    inline void clearEnScope();

    /**
     * Checks whether the field "enScope" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEnScope()). Otherwise it will return false.
     */
    inline bool hasEnScope () const;

    /**
     * Returns the value of the member "enScope".
     *
     * If the meaning of "enScope" isn't clear, then there should be a description here.
     *
     * @return The value of the field "enScope"
     */
    inline tenScope getEnScope () const;

    /**
     * Sets the value of the member "enScope".
     *
     * If the meaning of "enScope" isn't clear, then there should be a description here.
     *
     * @param enScope The value which will be set
     */
    inline void setEnScope (tenScope enScope_);

    // API of field "compatInfo"

    static const int kCompatInfo = 7;

    /**
     * Clears the field "compatInfo".
     *
     * The field will be set to its default value. The hasCompatInfo()
     * method will return false.
     */
    inline void clearCompatInfo();

    /**
     * Checks whether the field "compatInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCompatInfo()). Otherwise it will return false.
     */
    inline bool hasCompatInfo () const;

    /**
     * Returns the value of the member "compatInfo".
     *
     * If the meaning of "compatInfo" isn't clear, then there should be a description here.
     *
     * @return The value of the field "compatInfo"
     */
    inline const ::std::vector< uint8 >& getCompatInfo () const;

    /**
     * Retrieves the value of the field "compatInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "compatInfo".
     */
    inline ::std::vector< uint8 >& getCompatInfoMutable ();

    /**
     * Sets the value of the member "compatInfo".
     *
     * If the meaning of "compatInfo" isn't clear, then there should be a description here.
     *
     * @param compatInfo The value which will be set
     */
    inline void setCompatInfo (const ::std::vector< uint8 >& compatInfo_);

    static const trSubModuleData &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_name ();

    inline void clear_has_name ();

    inline void set_has_bSelected ();

    inline void clear_has_bSelected ();

    inline void set_has_info ();

    inline void clear_has_info ();

    inline void set_has_toVersion ();

    inline void clear_has_toVersion ();

    inline void set_has_fromVersion ();

    inline void clear_has_fromVersion ();

    inline void set_has_sizeBytes ();

    inline void clear_has_sizeBytes ();

    inline void set_has_enScope ();

    inline void clear_has_enScope ();

    inline void set_has_compatInfo ();

    inline void clear_has_compatInfo ();

    uint32 _has_bits_[ (8 + 31) / 32];

    ::std::string _name;

    bool _bSelected;

    ::std::string _info;

    ::std::string _toVersion;

    ::std::string _fromVersion;

    uint64 _sizeBytes;

    tenScope _enScope;

    ::std::vector< uint8 > _compatInfo;

};

/**
 * If the meaning of "trModuleData" isn't clear, then there should be a description here.
 */
class trModuleData {
public:

    /**
     * Default constructor
     */
    inline  trModuleData ();

    /**
     * Copy constructor
     */
    inline  trModuleData (const trModuleData &rhs);

    /**
     * All fields constructor
     */
    inline  trModuleData (const ::std::string& name_, const ::std::string& hwIndex_, const ::std::vector< trSubModuleData >& subModules_, tenScope enScope_);

    /**
     * Destructor
     */
    inline  ~trModuleData();

    /**
     * Assignment operator
     */
    inline trModuleData& operator = (const trModuleData& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const trModuleData& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const trModuleData& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const trModuleData& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const trModuleData& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "name"

    static const int kName = 0;

    /**
     * Clears the field "name".
     *
     * The field will be set to its default value. The hasName()
     * method will return false.
     */
    inline void clearName();

    /**
     * Checks whether the field "name" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setName()). Otherwise it will return false.
     */
    inline bool hasName () const;

    /**
     * Returns the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @return The value of the field "name"
     */
    inline const ::std::string& getName () const;

    /**
     * Retrieves the value of the field "name" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "name".
     */
    inline ::std::string& getNameMutable ();

    /**
     * Sets the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param name The value which will be set
     */
    inline void setName (const ::std::string& name_);

    /**
     * Sets the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param name The value which will be set
     */
    inline void setName (const char* name_);

    /**
     * Sets the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param name The value which will be set
     */
    inline void setName (const char* value, size_t size);

    // API of field "hwIndex"

    static const int kHwIndex = 1;

    /**
     * Clears the field "hwIndex".
     *
     * The field will be set to its default value. The hasHwIndex()
     * method will return false.
     */
    inline void clearHwIndex();

    /**
     * Checks whether the field "hwIndex" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setHwIndex()). Otherwise it will return false.
     */
    inline bool hasHwIndex () const;

    /**
     * Returns the value of the member "hwIndex".
     *
     * If the meaning of "hwIndex" isn't clear, then there should be a description here.
     *
     * @return The value of the field "hwIndex"
     */
    inline const ::std::string& getHwIndex () const;

    /**
     * Retrieves the value of the field "hwIndex" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "hwIndex".
     */
    inline ::std::string& getHwIndexMutable ();

    /**
     * Sets the value of the member "hwIndex".
     *
     * If the meaning of "hwIndex" isn't clear, then there should be a description here.
     *
     * @param hwIndex The value which will be set
     */
    inline void setHwIndex (const ::std::string& hwIndex_);

    /**
     * Sets the value of the member "hwIndex".
     *
     * If the meaning of "hwIndex" isn't clear, then there should be a description here.
     *
     * @param hwIndex The value which will be set
     */
    inline void setHwIndex (const char* hwIndex_);

    /**
     * Sets the value of the member "hwIndex".
     *
     * If the meaning of "hwIndex" isn't clear, then there should be a description here.
     *
     * @param hwIndex The value which will be set
     */
    inline void setHwIndex (const char* value, size_t size);

    // API of field "subModules"

    static const int kSubModules = 2;

    /**
     * Clears the field "subModules".
     *
     * The field will be set to its default value. The hasSubModules()
     * method will return false.
     */
    inline void clearSubModules();

    /**
     * Checks whether the field "subModules" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSubModules()). Otherwise it will return false.
     */
    inline bool hasSubModules () const;

    /**
     * Returns the value of the member "subModules".
     *
     * If the meaning of "subModules" isn't clear, then there should be a description here.
     *
     * @return The value of the field "subModules"
     */
    inline const ::std::vector< trSubModuleData >& getSubModules () const;

    /**
     * Retrieves the value of the field "subModules" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "subModules".
     */
    inline ::std::vector< trSubModuleData >& getSubModulesMutable ();

    /**
     * Sets the value of the member "subModules".
     *
     * If the meaning of "subModules" isn't clear, then there should be a description here.
     *
     * @param subModules The value which will be set
     */
    inline void setSubModules (const ::std::vector< trSubModuleData >& subModules_);

    // API of field "enScope"

    static const int kEnScope = 3;

    /**
     * Clears the field "enScope".
     *
     * The field will be set to its default value. The hasEnScope()
     * method will return false.
     */
    inline void clearEnScope();

    /**
     * Checks whether the field "enScope" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEnScope()). Otherwise it will return false.
     */
    inline bool hasEnScope () const;

    /**
     * Returns the value of the member "enScope".
     *
     * If the meaning of "enScope" isn't clear, then there should be a description here.
     *
     * @return The value of the field "enScope"
     */
    inline tenScope getEnScope () const;

    /**
     * Sets the value of the member "enScope".
     *
     * If the meaning of "enScope" isn't clear, then there should be a description here.
     *
     * @param enScope The value which will be set
     */
    inline void setEnScope (tenScope enScope_);

    static const trModuleData &getDefaultInstance();

private:

    static const ::std::vector< trSubModuleData >& getTrSubModuleDataList_DefaultInstance ();

    inline void set_has_name ();

    inline void clear_has_name ();

    inline void set_has_hwIndex ();

    inline void clear_has_hwIndex ();

    inline void set_has_subModules ();

    inline void clear_has_subModules ();

    inline void set_has_enScope ();

    inline void clear_has_enScope ();

    uint32 _has_bits_[ (4 + 31) / 32];

    ::std::string _name;

    ::std::string _hwIndex;

    ::std::vector< trSubModuleData > _subModules;

    tenScope _enScope;

};

/**
 * If the meaning of "trDeviceData" isn't clear, then there should be a description here.
 */
class trDeviceData {
public:

    /**
     * Default constructor
     */
    inline  trDeviceData ();

    /**
     * Copy constructor
     */
    inline  trDeviceData (const trDeviceData &rhs);

    /**
     * All fields constructor
     */
    inline  trDeviceData (const ::std::string& name_, const ::std::vector< trModuleData >& modules_, tenScope enScope_);

    /**
     * Destructor
     */
    inline  ~trDeviceData();

    /**
     * Assignment operator
     */
    inline trDeviceData& operator = (const trDeviceData& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const trDeviceData& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const trDeviceData& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const trDeviceData& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const trDeviceData& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "name"

    static const int kName = 0;

    /**
     * Clears the field "name".
     *
     * The field will be set to its default value. The hasName()
     * method will return false.
     */
    inline void clearName();

    /**
     * Checks whether the field "name" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setName()). Otherwise it will return false.
     */
    inline bool hasName () const;

    /**
     * Returns the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @return The value of the field "name"
     */
    inline const ::std::string& getName () const;

    /**
     * Retrieves the value of the field "name" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "name".
     */
    inline ::std::string& getNameMutable ();

    /**
     * Sets the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param name The value which will be set
     */
    inline void setName (const ::std::string& name_);

    /**
     * Sets the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param name The value which will be set
     */
    inline void setName (const char* name_);

    /**
     * Sets the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param name The value which will be set
     */
    inline void setName (const char* value, size_t size);

    // API of field "modules"

    static const int kModules = 1;

    /**
     * Clears the field "modules".
     *
     * The field will be set to its default value. The hasModules()
     * method will return false.
     */
    inline void clearModules();

    /**
     * Checks whether the field "modules" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setModules()). Otherwise it will return false.
     */
    inline bool hasModules () const;

    /**
     * Returns the value of the member "modules".
     *
     * If the meaning of "modules" isn't clear, then there should be a description here.
     *
     * @return The value of the field "modules"
     */
    inline const ::std::vector< trModuleData >& getModules () const;

    /**
     * Retrieves the value of the field "modules" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "modules".
     */
    inline ::std::vector< trModuleData >& getModulesMutable ();

    /**
     * Sets the value of the member "modules".
     *
     * If the meaning of "modules" isn't clear, then there should be a description here.
     *
     * @param modules The value which will be set
     */
    inline void setModules (const ::std::vector< trModuleData >& modules_);

    // API of field "enScope"

    static const int kEnScope = 2;

    /**
     * Clears the field "enScope".
     *
     * The field will be set to its default value. The hasEnScope()
     * method will return false.
     */
    inline void clearEnScope();

    /**
     * Checks whether the field "enScope" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEnScope()). Otherwise it will return false.
     */
    inline bool hasEnScope () const;

    /**
     * Returns the value of the member "enScope".
     *
     * If the meaning of "enScope" isn't clear, then there should be a description here.
     *
     * @return The value of the field "enScope"
     */
    inline tenScope getEnScope () const;

    /**
     * Sets the value of the member "enScope".
     *
     * If the meaning of "enScope" isn't clear, then there should be a description here.
     *
     * @param enScope The value which will be set
     */
    inline void setEnScope (tenScope enScope_);

    static const trDeviceData &getDefaultInstance();

private:

    static const ::std::vector< trModuleData >& getTrModuleDataList_DefaultInstance ();

    inline void set_has_name ();

    inline void clear_has_name ();

    inline void set_has_modules ();

    inline void clear_has_modules ();

    inline void set_has_enScope ();

    inline void clear_has_enScope ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::std::string _name;

    ::std::vector< trModuleData > _modules;

    tenScope _enScope;

};

/**
 * If the meaning of "trTartgetState" isn't clear, then there should be a description here.
 */
class trTartgetState {
public:

    /**
     * Default constructor
     */
    inline  trTartgetState ();

    /**
     * Copy constructor
     */
    inline  trTartgetState (const trTartgetState &rhs);

    /**
     * All fields constructor
     */
    inline  trTartgetState (tenUpdType filter_, const ::std::string& name_, const ::std::vector< trDeviceData >& devices_);

    /**
     * Destructor
     */
    inline  ~trTartgetState();

    /**
     * Assignment operator
     */
    inline trTartgetState& operator = (const trTartgetState& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const trTartgetState& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const trTartgetState& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const trTartgetState& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const trTartgetState& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "filter"

    static const int kFilter = 0;

    /**
     * Clears the field "filter".
     *
     * The field will be set to its default value. The hasFilter()
     * method will return false.
     */
    inline void clearFilter();

    /**
     * Checks whether the field "filter" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFilter()). Otherwise it will return false.
     */
    inline bool hasFilter () const;

    /**
     * Returns the value of the member "filter".
     *
     * If the meaning of "filter" isn't clear, then there should be a description here.
     *
     * @return The value of the field "filter"
     */
    inline tenUpdType getFilter () const;

    /**
     * Sets the value of the member "filter".
     *
     * If the meaning of "filter" isn't clear, then there should be a description here.
     *
     * @param filter The value which will be set
     */
    inline void setFilter (tenUpdType filter_);

    // API of field "name"

    static const int kName = 1;

    /**
     * Clears the field "name".
     *
     * The field will be set to its default value. The hasName()
     * method will return false.
     */
    inline void clearName();

    /**
     * Checks whether the field "name" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setName()). Otherwise it will return false.
     */
    inline bool hasName () const;

    /**
     * Returns the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @return The value of the field "name"
     */
    inline const ::std::string& getName () const;

    /**
     * Retrieves the value of the field "name" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "name".
     */
    inline ::std::string& getNameMutable ();

    /**
     * Sets the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param name The value which will be set
     */
    inline void setName (const ::std::string& name_);

    /**
     * Sets the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param name The value which will be set
     */
    inline void setName (const char* name_);

    /**
     * Sets the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param name The value which will be set
     */
    inline void setName (const char* value, size_t size);

    // API of field "devices"

    static const int kDevices = 2;

    /**
     * Clears the field "devices".
     *
     * The field will be set to its default value. The hasDevices()
     * method will return false.
     */
    inline void clearDevices();

    /**
     * Checks whether the field "devices" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDevices()). Otherwise it will return false.
     */
    inline bool hasDevices () const;

    /**
     * Returns the value of the member "devices".
     *
     * If the meaning of "devices" isn't clear, then there should be a description here.
     *
     * @return The value of the field "devices"
     */
    inline const ::std::vector< trDeviceData >& getDevices () const;

    /**
     * Retrieves the value of the field "devices" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "devices".
     */
    inline ::std::vector< trDeviceData >& getDevicesMutable ();

    /**
     * Sets the value of the member "devices".
     *
     * If the meaning of "devices" isn't clear, then there should be a description here.
     *
     * @param devices The value which will be set
     */
    inline void setDevices (const ::std::vector< trDeviceData >& devices_);

    static const trTartgetState &getDefaultInstance();

private:

    static const ::std::vector< trDeviceData >& getTrDeviceDataList_DefaultInstance ();

    inline void set_has_filter ();

    inline void clear_has_filter ();

    inline void set_has_name ();

    inline void clear_has_name ();

    inline void set_has_devices ();

    inline void clear_has_devices ();

    uint32 _has_bits_[ (3 + 31) / 32];

    tenUpdType _filter;

    ::std::string _name;

    ::std::vector< trDeviceData > _devices;

};

/**
 * If the meaning of "trConfigProblem" isn't clear, then there should be a description here.
 */
class trConfigProblem {
public:

    /**
     * Default constructor
     */
    inline  trConfigProblem ();

    /**
     * Copy constructor
     */
    inline  trConfigProblem (const trConfigProblem &rhs);

    /**
     * All fields constructor
     */
    inline  trConfigProblem (const ::std::string& moduleName_, tenErrorId enErrorId_);

    /**
     * Destructor
     */
    inline  ~trConfigProblem();

    /**
     * Assignment operator
     */
    inline trConfigProblem& operator = (const trConfigProblem& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const trConfigProblem& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const trConfigProblem& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const trConfigProblem& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const trConfigProblem& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "moduleName"

    static const int kModuleName = 0;

    /**
     * Clears the field "moduleName".
     *
     * The field will be set to its default value. The hasModuleName()
     * method will return false.
     */
    inline void clearModuleName();

    /**
     * Checks whether the field "moduleName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setModuleName()). Otherwise it will return false.
     */
    inline bool hasModuleName () const;

    /**
     * Returns the value of the member "moduleName".
     *
     * If the meaning of "moduleName" isn't clear, then there should be a description here.
     *
     * @return The value of the field "moduleName"
     */
    inline const ::std::string& getModuleName () const;

    /**
     * Retrieves the value of the field "moduleName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "moduleName".
     */
    inline ::std::string& getModuleNameMutable ();

    /**
     * Sets the value of the member "moduleName".
     *
     * If the meaning of "moduleName" isn't clear, then there should be a description here.
     *
     * @param moduleName The value which will be set
     */
    inline void setModuleName (const ::std::string& moduleName_);

    /**
     * Sets the value of the member "moduleName".
     *
     * If the meaning of "moduleName" isn't clear, then there should be a description here.
     *
     * @param moduleName The value which will be set
     */
    inline void setModuleName (const char* moduleName_);

    /**
     * Sets the value of the member "moduleName".
     *
     * If the meaning of "moduleName" isn't clear, then there should be a description here.
     *
     * @param moduleName The value which will be set
     */
    inline void setModuleName (const char* value, size_t size);

    // API of field "enErrorId"

    static const int kEnErrorId = 1;

    /**
     * Clears the field "enErrorId".
     *
     * The field will be set to its default value. The hasEnErrorId()
     * method will return false.
     */
    inline void clearEnErrorId();

    /**
     * Checks whether the field "enErrorId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEnErrorId()). Otherwise it will return false.
     */
    inline bool hasEnErrorId () const;

    /**
     * Returns the value of the member "enErrorId".
     *
     * If the meaning of "enErrorId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "enErrorId"
     */
    inline tenErrorId getEnErrorId () const;

    /**
     * Sets the value of the member "enErrorId".
     *
     * If the meaning of "enErrorId" isn't clear, then there should be a description here.
     *
     * @param enErrorId The value which will be set
     */
    inline void setEnErrorId (tenErrorId enErrorId_);

    static const trConfigProblem &getDefaultInstance();

private:

    inline void set_has_moduleName ();

    inline void clear_has_moduleName ();

    inline void set_has_enErrorId ();

    inline void clear_has_enErrorId ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _moduleName;

    tenErrorId _enErrorId;

};

/**
 * If the meaning of "trReleaseDoc" isn't clear, then there should be a description here.
 */
class trReleaseDoc {
public:

    /**
     * Default constructor
     */
    inline  trReleaseDoc ();

    /**
     * Copy constructor
     */
    inline  trReleaseDoc (const trReleaseDoc &rhs);

    /**
     * All fields constructor
     */
    inline  trReleaseDoc (const ::std::string& name_, tenUpdateDirection enUpdateDirection_, tenSourceType enSourceType_, uint32 u32EstimatedUpdateTimeSec_, tenUpdOptions enUpdOptions_, bool bNeedsFlashing_, bool bIsDeltaUpdate_, const ::std::vector< trDeviceData >& devices_, const ::std::vector< trConfigProblem >& problems_);

    /**
     * Destructor
     */
    inline  ~trReleaseDoc();

    /**
     * Assignment operator
     */
    inline trReleaseDoc& operator = (const trReleaseDoc& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const trReleaseDoc& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const trReleaseDoc& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const trReleaseDoc& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const trReleaseDoc& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "name"

    static const int kName = 0;

    /**
     * Clears the field "name".
     *
     * The field will be set to its default value. The hasName()
     * method will return false.
     */
    inline void clearName();

    /**
     * Checks whether the field "name" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setName()). Otherwise it will return false.
     */
    inline bool hasName () const;

    /**
     * Returns the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @return The value of the field "name"
     */
    inline const ::std::string& getName () const;

    /**
     * Retrieves the value of the field "name" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "name".
     */
    inline ::std::string& getNameMutable ();

    /**
     * Sets the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param name The value which will be set
     */
    inline void setName (const ::std::string& name_);

    /**
     * Sets the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param name The value which will be set
     */
    inline void setName (const char* name_);

    /**
     * Sets the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param name The value which will be set
     */
    inline void setName (const char* value, size_t size);

    // API of field "enUpdateDirection"

    static const int kEnUpdateDirection = 1;

    /**
     * Clears the field "enUpdateDirection".
     *
     * The field will be set to its default value. The hasEnUpdateDirection()
     * method will return false.
     */
    inline void clearEnUpdateDirection();

    /**
     * Checks whether the field "enUpdateDirection" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEnUpdateDirection()). Otherwise it will return false.
     */
    inline bool hasEnUpdateDirection () const;

    /**
     * Returns the value of the member "enUpdateDirection".
     *
     * If the meaning of "enUpdateDirection" isn't clear, then there should be a description here.
     *
     * @return The value of the field "enUpdateDirection"
     */
    inline tenUpdateDirection getEnUpdateDirection () const;

    /**
     * Sets the value of the member "enUpdateDirection".
     *
     * If the meaning of "enUpdateDirection" isn't clear, then there should be a description here.
     *
     * @param enUpdateDirection The value which will be set
     */
    inline void setEnUpdateDirection (tenUpdateDirection enUpdateDirection_);

    // API of field "enSourceType"

    static const int kEnSourceType = 2;

    /**
     * Clears the field "enSourceType".
     *
     * The field will be set to its default value. The hasEnSourceType()
     * method will return false.
     */
    inline void clearEnSourceType();

    /**
     * Checks whether the field "enSourceType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEnSourceType()). Otherwise it will return false.
     */
    inline bool hasEnSourceType () const;

    /**
     * Returns the value of the member "enSourceType".
     *
     * If the meaning of "enSourceType" isn't clear, then there should be a description here.
     *
     * @return The value of the field "enSourceType"
     */
    inline tenSourceType getEnSourceType () const;

    /**
     * Sets the value of the member "enSourceType".
     *
     * If the meaning of "enSourceType" isn't clear, then there should be a description here.
     *
     * @param enSourceType The value which will be set
     */
    inline void setEnSourceType (tenSourceType enSourceType_);

    // API of field "u32EstimatedUpdateTimeSec"

    static const int kU32EstimatedUpdateTimeSec = 3;

    /**
     * Clears the field "u32EstimatedUpdateTimeSec".
     *
     * The field will be set to its default value. The hasU32EstimatedUpdateTimeSec()
     * method will return false.
     */
    inline void clearU32EstimatedUpdateTimeSec();

    /**
     * Checks whether the field "u32EstimatedUpdateTimeSec" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32EstimatedUpdateTimeSec()). Otherwise it will return false.
     */
    inline bool hasU32EstimatedUpdateTimeSec () const;

    /**
     * Returns the value of the member "u32EstimatedUpdateTimeSec".
     *
     * If the meaning of "u32EstimatedUpdateTimeSec" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u32EstimatedUpdateTimeSec"
     */
    inline uint32 getU32EstimatedUpdateTimeSec () const;

    /**
     * Sets the value of the member "u32EstimatedUpdateTimeSec".
     *
     * If the meaning of "u32EstimatedUpdateTimeSec" isn't clear, then there should be a description here.
     *
     * @param u32EstimatedUpdateTimeSec The value which will be set
     */
    inline void setU32EstimatedUpdateTimeSec (uint32 u32EstimatedUpdateTimeSec_);

    // API of field "enUpdOptions"

    static const int kEnUpdOptions = 4;

    /**
     * Clears the field "enUpdOptions".
     *
     * The field will be set to its default value. The hasEnUpdOptions()
     * method will return false.
     */
    inline void clearEnUpdOptions();

    /**
     * Checks whether the field "enUpdOptions" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEnUpdOptions()). Otherwise it will return false.
     */
    inline bool hasEnUpdOptions () const;

    /**
     * Returns the value of the member "enUpdOptions".
     *
     * If the meaning of "enUpdOptions" isn't clear, then there should be a description here.
     *
     * @return The value of the field "enUpdOptions"
     */
    inline tenUpdOptions getEnUpdOptions () const;

    /**
     * Sets the value of the member "enUpdOptions".
     *
     * If the meaning of "enUpdOptions" isn't clear, then there should be a description here.
     *
     * @param enUpdOptions The value which will be set
     */
    inline void setEnUpdOptions (tenUpdOptions enUpdOptions_);

    // API of field "bNeedsFlashing"

    static const int kBNeedsFlashing = 5;

    /**
     * Clears the field "bNeedsFlashing".
     *
     * The field will be set to its default value. The hasBNeedsFlashing()
     * method will return false.
     */
    inline void clearBNeedsFlashing();

    /**
     * Checks whether the field "bNeedsFlashing" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBNeedsFlashing()). Otherwise it will return false.
     */
    inline bool hasBNeedsFlashing () const;

    /**
     * Returns the value of the member "bNeedsFlashing".
     *
     * If the meaning of "bNeedsFlashing" isn't clear, then there should be a description here.
     *
     * @return The value of the field "bNeedsFlashing"
     */
    inline bool getBNeedsFlashing () const;

    /**
     * Sets the value of the member "bNeedsFlashing".
     *
     * If the meaning of "bNeedsFlashing" isn't clear, then there should be a description here.
     *
     * @param bNeedsFlashing The value which will be set
     */
    inline void setBNeedsFlashing (bool bNeedsFlashing_);

    // API of field "bIsDeltaUpdate"

    static const int kBIsDeltaUpdate = 6;

    /**
     * Clears the field "bIsDeltaUpdate".
     *
     * The field will be set to its default value. The hasBIsDeltaUpdate()
     * method will return false.
     */
    inline void clearBIsDeltaUpdate();

    /**
     * Checks whether the field "bIsDeltaUpdate" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBIsDeltaUpdate()). Otherwise it will return false.
     */
    inline bool hasBIsDeltaUpdate () const;

    /**
     * Returns the value of the member "bIsDeltaUpdate".
     *
     * If the meaning of "bIsDeltaUpdate" isn't clear, then there should be a description here.
     *
     * @return The value of the field "bIsDeltaUpdate"
     */
    inline bool getBIsDeltaUpdate () const;

    /**
     * Sets the value of the member "bIsDeltaUpdate".
     *
     * If the meaning of "bIsDeltaUpdate" isn't clear, then there should be a description here.
     *
     * @param bIsDeltaUpdate The value which will be set
     */
    inline void setBIsDeltaUpdate (bool bIsDeltaUpdate_);

    // API of field "devices"

    static const int kDevices = 7;

    /**
     * Clears the field "devices".
     *
     * The field will be set to its default value. The hasDevices()
     * method will return false.
     */
    inline void clearDevices();

    /**
     * Checks whether the field "devices" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDevices()). Otherwise it will return false.
     */
    inline bool hasDevices () const;

    /**
     * Returns the value of the member "devices".
     *
     * If the meaning of "devices" isn't clear, then there should be a description here.
     *
     * @return The value of the field "devices"
     */
    inline const ::std::vector< trDeviceData >& getDevices () const;

    /**
     * Retrieves the value of the field "devices" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "devices".
     */
    inline ::std::vector< trDeviceData >& getDevicesMutable ();

    /**
     * Sets the value of the member "devices".
     *
     * If the meaning of "devices" isn't clear, then there should be a description here.
     *
     * @param devices The value which will be set
     */
    inline void setDevices (const ::std::vector< trDeviceData >& devices_);

    // API of field "problems"

    static const int kProblems = 8;

    /**
     * Clears the field "problems".
     *
     * The field will be set to its default value. The hasProblems()
     * method will return false.
     */
    inline void clearProblems();

    /**
     * Checks whether the field "problems" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setProblems()). Otherwise it will return false.
     */
    inline bool hasProblems () const;

    /**
     * Returns the value of the member "problems".
     *
     * If the meaning of "problems" isn't clear, then there should be a description here.
     *
     * @return The value of the field "problems"
     */
    inline const ::std::vector< trConfigProblem >& getProblems () const;

    /**
     * Retrieves the value of the field "problems" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "problems".
     */
    inline ::std::vector< trConfigProblem >& getProblemsMutable ();

    /**
     * Sets the value of the member "problems".
     *
     * If the meaning of "problems" isn't clear, then there should be a description here.
     *
     * @param problems The value which will be set
     */
    inline void setProblems (const ::std::vector< trConfigProblem >& problems_);

    static const trReleaseDoc &getDefaultInstance();

private:

    static const ::std::vector< trDeviceData >& getTrDeviceDataList_DefaultInstance ();

    static const ::std::vector< trConfigProblem >& getTrConfigProblemList_DefaultInstance ();

    inline void set_has_name ();

    inline void clear_has_name ();

    inline void set_has_enUpdateDirection ();

    inline void clear_has_enUpdateDirection ();

    inline void set_has_enSourceType ();

    inline void clear_has_enSourceType ();

    inline void set_has_u32EstimatedUpdateTimeSec ();

    inline void clear_has_u32EstimatedUpdateTimeSec ();

    inline void set_has_enUpdOptions ();

    inline void clear_has_enUpdOptions ();

    inline void set_has_bNeedsFlashing ();

    inline void clear_has_bNeedsFlashing ();

    inline void set_has_bIsDeltaUpdate ();

    inline void clear_has_bIsDeltaUpdate ();

    inline void set_has_devices ();

    inline void clear_has_devices ();

    inline void set_has_problems ();

    inline void clear_has_problems ();

    uint32 _has_bits_[ (9 + 31) / 32];

    ::std::string _name;

    tenUpdateDirection _enUpdateDirection;

    tenSourceType _enSourceType;

    uint32 _u32EstimatedUpdateTimeSec;

    tenUpdOptions _enUpdOptions;

    bool _bNeedsFlashing;

    bool _bIsDeltaUpdate;

    ::std::vector< trDeviceData > _devices;

    ::std::vector< trConfigProblem > _problems;

};

/**
 * If the meaning of "trPreReleaseDoc" isn't clear, then there should be a description here.
 */
class trPreReleaseDoc {
public:

    /**
     * Default constructor
     */
    inline  trPreReleaseDoc ();

    /**
     * Copy constructor
     */
    inline  trPreReleaseDoc (const trPreReleaseDoc &rhs);

    /**
     * All fields constructor
     */
    inline  trPreReleaseDoc (bool bFoundRelease_);

    /**
     * Destructor
     */
    inline  ~trPreReleaseDoc();

    /**
     * Assignment operator
     */
    inline trPreReleaseDoc& operator = (const trPreReleaseDoc& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const trPreReleaseDoc& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const trPreReleaseDoc& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const trPreReleaseDoc& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const trPreReleaseDoc& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bFoundRelease"

    static const int kBFoundRelease = 0;

    /**
     * Clears the field "bFoundRelease".
     *
     * The field will be set to its default value. The hasBFoundRelease()
     * method will return false.
     */
    inline void clearBFoundRelease();

    /**
     * Checks whether the field "bFoundRelease" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBFoundRelease()). Otherwise it will return false.
     */
    inline bool hasBFoundRelease () const;

    /**
     * Returns the value of the member "bFoundRelease".
     *
     * If the meaning of "bFoundRelease" isn't clear, then there should be a description here.
     *
     * @return The value of the field "bFoundRelease"
     */
    inline bool getBFoundRelease () const;

    /**
     * Sets the value of the member "bFoundRelease".
     *
     * If the meaning of "bFoundRelease" isn't clear, then there should be a description here.
     *
     * @param bFoundRelease The value which will be set
     */
    inline void setBFoundRelease (bool bFoundRelease_);

    static const trPreReleaseDoc &getDefaultInstance();

private:

    inline void set_has_bFoundRelease ();

    inline void clear_has_bFoundRelease ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _bFoundRelease;

};

/**
 * If the meaning of "trModifyAction" isn't clear, then there should be a description here.
 */
class trModifyAction {
public:

    /**
     * Default constructor
     */
    inline  trModifyAction ();

    /**
     * Copy constructor
     */
    inline  trModifyAction (const trModifyAction &rhs);

    /**
     * All fields constructor
     */
    inline  trModifyAction (uint32 u32DeviceIndex_, uint32 u32ModuleIndex_, uint32 u32SubModuleIndex_, tenModifyAction enUpdAction_);

    /**
     * Destructor
     */
    inline  ~trModifyAction();

    /**
     * Assignment operator
     */
    inline trModifyAction& operator = (const trModifyAction& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const trModifyAction& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const trModifyAction& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const trModifyAction& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const trModifyAction& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u32DeviceIndex"

    static const int kU32DeviceIndex = 0;

    /**
     * Clears the field "u32DeviceIndex".
     *
     * The field will be set to its default value. The hasU32DeviceIndex()
     * method will return false.
     */
    inline void clearU32DeviceIndex();

    /**
     * Checks whether the field "u32DeviceIndex" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32DeviceIndex()). Otherwise it will return false.
     */
    inline bool hasU32DeviceIndex () const;

    /**
     * Returns the value of the member "u32DeviceIndex".
     *
     * If the meaning of "u32DeviceIndex" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u32DeviceIndex"
     */
    inline uint32 getU32DeviceIndex () const;

    /**
     * Sets the value of the member "u32DeviceIndex".
     *
     * If the meaning of "u32DeviceIndex" isn't clear, then there should be a description here.
     *
     * @param u32DeviceIndex The value which will be set
     */
    inline void setU32DeviceIndex (uint32 u32DeviceIndex_);

    // API of field "u32ModuleIndex"

    static const int kU32ModuleIndex = 1;

    /**
     * Clears the field "u32ModuleIndex".
     *
     * The field will be set to its default value. The hasU32ModuleIndex()
     * method will return false.
     */
    inline void clearU32ModuleIndex();

    /**
     * Checks whether the field "u32ModuleIndex" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32ModuleIndex()). Otherwise it will return false.
     */
    inline bool hasU32ModuleIndex () const;

    /**
     * Returns the value of the member "u32ModuleIndex".
     *
     * If the meaning of "u32ModuleIndex" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u32ModuleIndex"
     */
    inline uint32 getU32ModuleIndex () const;

    /**
     * Sets the value of the member "u32ModuleIndex".
     *
     * If the meaning of "u32ModuleIndex" isn't clear, then there should be a description here.
     *
     * @param u32ModuleIndex The value which will be set
     */
    inline void setU32ModuleIndex (uint32 u32ModuleIndex_);

    // API of field "u32SubModuleIndex"

    static const int kU32SubModuleIndex = 2;

    /**
     * Clears the field "u32SubModuleIndex".
     *
     * The field will be set to its default value. The hasU32SubModuleIndex()
     * method will return false.
     */
    inline void clearU32SubModuleIndex();

    /**
     * Checks whether the field "u32SubModuleIndex" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32SubModuleIndex()). Otherwise it will return false.
     */
    inline bool hasU32SubModuleIndex () const;

    /**
     * Returns the value of the member "u32SubModuleIndex".
     *
     * If the meaning of "u32SubModuleIndex" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u32SubModuleIndex"
     */
    inline uint32 getU32SubModuleIndex () const;

    /**
     * Sets the value of the member "u32SubModuleIndex".
     *
     * If the meaning of "u32SubModuleIndex" isn't clear, then there should be a description here.
     *
     * @param u32SubModuleIndex The value which will be set
     */
    inline void setU32SubModuleIndex (uint32 u32SubModuleIndex_);

    // API of field "enUpdAction"

    static const int kEnUpdAction = 3;

    /**
     * Clears the field "enUpdAction".
     *
     * The field will be set to its default value. The hasEnUpdAction()
     * method will return false.
     */
    inline void clearEnUpdAction();

    /**
     * Checks whether the field "enUpdAction" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEnUpdAction()). Otherwise it will return false.
     */
    inline bool hasEnUpdAction () const;

    /**
     * Returns the value of the member "enUpdAction".
     *
     * If the meaning of "enUpdAction" isn't clear, then there should be a description here.
     *
     * @return The value of the field "enUpdAction"
     */
    inline tenModifyAction getEnUpdAction () const;

    /**
     * Sets the value of the member "enUpdAction".
     *
     * If the meaning of "enUpdAction" isn't clear, then there should be a description here.
     *
     * @param enUpdAction The value which will be set
     */
    inline void setEnUpdAction (tenModifyAction enUpdAction_);

    static const trModifyAction &getDefaultInstance();

private:

    inline void set_has_u32DeviceIndex ();

    inline void clear_has_u32DeviceIndex ();

    inline void set_has_u32ModuleIndex ();

    inline void clear_has_u32ModuleIndex ();

    inline void set_has_u32SubModuleIndex ();

    inline void clear_has_u32SubModuleIndex ();

    inline void set_has_enUpdAction ();

    inline void clear_has_enUpdAction ();

    uint32 _has_bits_[ (4 + 31) / 32];

    uint32 _u32DeviceIndex;

    uint32 _u32ModuleIndex;

    uint32 _u32SubModuleIndex;

    tenModifyAction _enUpdAction;

};

/**
 * If the meaning of "trUpdProgress" isn't clear, then there should be a description here.
 */
class trUpdProgress {
public:

    /**
     * Default constructor
     */
    inline  trUpdProgress ();

    /**
     * Copy constructor
     */
    inline  trUpdProgress (const trUpdProgress &rhs);

    /**
     * All fields constructor
     */
    inline  trUpdProgress (const ::std::string& train_, const ::std::string& deviceName_, const ::std::string& moduleName_, const ::std::string& subModuleName_, const ::std::string& refKey_, const ::std::string& source_, const ::std::string& line1_, const ::std::string& line2_, const ::std::string& luaCmd_, uint32 u32Retries_, uint32 u32NumAll_, uint32 u32NumComplete_, uint32 u32NumRunning_, uint32 u32NumNotApplicable_, uint32 u32NumFailed_, uint32 u32NumRemaining_, uint8 u8SubModulePercentComplete_, uint8 u8ReleasePercentComplete_, uint8 u8ReleasePercentCompleteForPhase_, uint32 u32EstimatedUpdateTimeSec_, uint32 u32EstimatedUpdateTimeSecForPhase_, uint32 u32EstimatedCurrentModuleUpdateTimeSec_);

    /**
     * Destructor
     */
    inline  ~trUpdProgress();

    /**
     * Assignment operator
     */
    inline trUpdProgress& operator = (const trUpdProgress& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const trUpdProgress& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const trUpdProgress& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const trUpdProgress& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const trUpdProgress& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "train"

    static const int kTrain = 0;

    /**
     * Clears the field "train".
     *
     * The field will be set to its default value. The hasTrain()
     * method will return false.
     */
    inline void clearTrain();

    /**
     * Checks whether the field "train" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTrain()). Otherwise it will return false.
     */
    inline bool hasTrain () const;

    /**
     * Returns the value of the member "train".
     *
     * If the meaning of "train" isn't clear, then there should be a description here.
     *
     * @return The value of the field "train"
     */
    inline const ::std::string& getTrain () const;

    /**
     * Retrieves the value of the field "train" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "train".
     */
    inline ::std::string& getTrainMutable ();

    /**
     * Sets the value of the member "train".
     *
     * If the meaning of "train" isn't clear, then there should be a description here.
     *
     * @param train The value which will be set
     */
    inline void setTrain (const ::std::string& train_);

    /**
     * Sets the value of the member "train".
     *
     * If the meaning of "train" isn't clear, then there should be a description here.
     *
     * @param train The value which will be set
     */
    inline void setTrain (const char* train_);

    /**
     * Sets the value of the member "train".
     *
     * If the meaning of "train" isn't clear, then there should be a description here.
     *
     * @param train The value which will be set
     */
    inline void setTrain (const char* value, size_t size);

    // API of field "deviceName"

    static const int kDeviceName = 1;

    /**
     * Clears the field "deviceName".
     *
     * The field will be set to its default value. The hasDeviceName()
     * method will return false.
     */
    inline void clearDeviceName();

    /**
     * Checks whether the field "deviceName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceName()). Otherwise it will return false.
     */
    inline bool hasDeviceName () const;

    /**
     * Returns the value of the member "deviceName".
     *
     * If the meaning of "deviceName" isn't clear, then there should be a description here.
     *
     * @return The value of the field "deviceName"
     */
    inline const ::std::string& getDeviceName () const;

    /**
     * Retrieves the value of the field "deviceName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "deviceName".
     */
    inline ::std::string& getDeviceNameMutable ();

    /**
     * Sets the value of the member "deviceName".
     *
     * If the meaning of "deviceName" isn't clear, then there should be a description here.
     *
     * @param deviceName The value which will be set
     */
    inline void setDeviceName (const ::std::string& deviceName_);

    /**
     * Sets the value of the member "deviceName".
     *
     * If the meaning of "deviceName" isn't clear, then there should be a description here.
     *
     * @param deviceName The value which will be set
     */
    inline void setDeviceName (const char* deviceName_);

    /**
     * Sets the value of the member "deviceName".
     *
     * If the meaning of "deviceName" isn't clear, then there should be a description here.
     *
     * @param deviceName The value which will be set
     */
    inline void setDeviceName (const char* value, size_t size);

    // API of field "moduleName"

    static const int kModuleName = 2;

    /**
     * Clears the field "moduleName".
     *
     * The field will be set to its default value. The hasModuleName()
     * method will return false.
     */
    inline void clearModuleName();

    /**
     * Checks whether the field "moduleName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setModuleName()). Otherwise it will return false.
     */
    inline bool hasModuleName () const;

    /**
     * Returns the value of the member "moduleName".
     *
     * If the meaning of "moduleName" isn't clear, then there should be a description here.
     *
     * @return The value of the field "moduleName"
     */
    inline const ::std::string& getModuleName () const;

    /**
     * Retrieves the value of the field "moduleName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "moduleName".
     */
    inline ::std::string& getModuleNameMutable ();

    /**
     * Sets the value of the member "moduleName".
     *
     * If the meaning of "moduleName" isn't clear, then there should be a description here.
     *
     * @param moduleName The value which will be set
     */
    inline void setModuleName (const ::std::string& moduleName_);

    /**
     * Sets the value of the member "moduleName".
     *
     * If the meaning of "moduleName" isn't clear, then there should be a description here.
     *
     * @param moduleName The value which will be set
     */
    inline void setModuleName (const char* moduleName_);

    /**
     * Sets the value of the member "moduleName".
     *
     * If the meaning of "moduleName" isn't clear, then there should be a description here.
     *
     * @param moduleName The value which will be set
     */
    inline void setModuleName (const char* value, size_t size);

    // API of field "subModuleName"

    static const int kSubModuleName = 3;

    /**
     * Clears the field "subModuleName".
     *
     * The field will be set to its default value. The hasSubModuleName()
     * method will return false.
     */
    inline void clearSubModuleName();

    /**
     * Checks whether the field "subModuleName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSubModuleName()). Otherwise it will return false.
     */
    inline bool hasSubModuleName () const;

    /**
     * Returns the value of the member "subModuleName".
     *
     * If the meaning of "subModuleName" isn't clear, then there should be a description here.
     *
     * @return The value of the field "subModuleName"
     */
    inline const ::std::string& getSubModuleName () const;

    /**
     * Retrieves the value of the field "subModuleName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "subModuleName".
     */
    inline ::std::string& getSubModuleNameMutable ();

    /**
     * Sets the value of the member "subModuleName".
     *
     * If the meaning of "subModuleName" isn't clear, then there should be a description here.
     *
     * @param subModuleName The value which will be set
     */
    inline void setSubModuleName (const ::std::string& subModuleName_);

    /**
     * Sets the value of the member "subModuleName".
     *
     * If the meaning of "subModuleName" isn't clear, then there should be a description here.
     *
     * @param subModuleName The value which will be set
     */
    inline void setSubModuleName (const char* subModuleName_);

    /**
     * Sets the value of the member "subModuleName".
     *
     * If the meaning of "subModuleName" isn't clear, then there should be a description here.
     *
     * @param subModuleName The value which will be set
     */
    inline void setSubModuleName (const char* value, size_t size);

    // API of field "refKey"

    static const int kRefKey = 4;

    /**
     * Clears the field "refKey".
     *
     * The field will be set to its default value. The hasRefKey()
     * method will return false.
     */
    inline void clearRefKey();

    /**
     * Checks whether the field "refKey" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRefKey()). Otherwise it will return false.
     */
    inline bool hasRefKey () const;

    /**
     * Returns the value of the member "refKey".
     *
     * If the meaning of "refKey" isn't clear, then there should be a description here.
     *
     * @return The value of the field "refKey"
     */
    inline const ::std::string& getRefKey () const;

    /**
     * Retrieves the value of the field "refKey" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "refKey".
     */
    inline ::std::string& getRefKeyMutable ();

    /**
     * Sets the value of the member "refKey".
     *
     * If the meaning of "refKey" isn't clear, then there should be a description here.
     *
     * @param refKey The value which will be set
     */
    inline void setRefKey (const ::std::string& refKey_);

    /**
     * Sets the value of the member "refKey".
     *
     * If the meaning of "refKey" isn't clear, then there should be a description here.
     *
     * @param refKey The value which will be set
     */
    inline void setRefKey (const char* refKey_);

    /**
     * Sets the value of the member "refKey".
     *
     * If the meaning of "refKey" isn't clear, then there should be a description here.
     *
     * @param refKey The value which will be set
     */
    inline void setRefKey (const char* value, size_t size);

    // API of field "source"

    static const int kSource = 5;

    /**
     * Clears the field "source".
     *
     * The field will be set to its default value. The hasSource()
     * method will return false.
     */
    inline void clearSource();

    /**
     * Checks whether the field "source" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSource()). Otherwise it will return false.
     */
    inline bool hasSource () const;

    /**
     * Returns the value of the member "source".
     *
     * If the meaning of "source" isn't clear, then there should be a description here.
     *
     * @return The value of the field "source"
     */
    inline const ::std::string& getSource () const;

    /**
     * Retrieves the value of the field "source" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "source".
     */
    inline ::std::string& getSourceMutable ();

    /**
     * Sets the value of the member "source".
     *
     * If the meaning of "source" isn't clear, then there should be a description here.
     *
     * @param source The value which will be set
     */
    inline void setSource (const ::std::string& source_);

    /**
     * Sets the value of the member "source".
     *
     * If the meaning of "source" isn't clear, then there should be a description here.
     *
     * @param source The value which will be set
     */
    inline void setSource (const char* source_);

    /**
     * Sets the value of the member "source".
     *
     * If the meaning of "source" isn't clear, then there should be a description here.
     *
     * @param source The value which will be set
     */
    inline void setSource (const char* value, size_t size);

    // API of field "line1"

    static const int kLine1 = 6;

    /**
     * Clears the field "line1".
     *
     * The field will be set to its default value. The hasLine1()
     * method will return false.
     */
    inline void clearLine1();

    /**
     * Checks whether the field "line1" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLine1()). Otherwise it will return false.
     */
    inline bool hasLine1 () const;

    /**
     * Returns the value of the member "line1".
     *
     * If the meaning of "line1" isn't clear, then there should be a description here.
     *
     * @return The value of the field "line1"
     */
    inline const ::std::string& getLine1 () const;

    /**
     * Retrieves the value of the field "line1" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "line1".
     */
    inline ::std::string& getLine1Mutable ();

    /**
     * Sets the value of the member "line1".
     *
     * If the meaning of "line1" isn't clear, then there should be a description here.
     *
     * @param line1 The value which will be set
     */
    inline void setLine1 (const ::std::string& line1_);

    /**
     * Sets the value of the member "line1".
     *
     * If the meaning of "line1" isn't clear, then there should be a description here.
     *
     * @param line1 The value which will be set
     */
    inline void setLine1 (const char* line1_);

    /**
     * Sets the value of the member "line1".
     *
     * If the meaning of "line1" isn't clear, then there should be a description here.
     *
     * @param line1 The value which will be set
     */
    inline void setLine1 (const char* value, size_t size);

    // API of field "line2"

    static const int kLine2 = 7;

    /**
     * Clears the field "line2".
     *
     * The field will be set to its default value. The hasLine2()
     * method will return false.
     */
    inline void clearLine2();

    /**
     * Checks whether the field "line2" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLine2()). Otherwise it will return false.
     */
    inline bool hasLine2 () const;

    /**
     * Returns the value of the member "line2".
     *
     * If the meaning of "line2" isn't clear, then there should be a description here.
     *
     * @return The value of the field "line2"
     */
    inline const ::std::string& getLine2 () const;

    /**
     * Retrieves the value of the field "line2" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "line2".
     */
    inline ::std::string& getLine2Mutable ();

    /**
     * Sets the value of the member "line2".
     *
     * If the meaning of "line2" isn't clear, then there should be a description here.
     *
     * @param line2 The value which will be set
     */
    inline void setLine2 (const ::std::string& line2_);

    /**
     * Sets the value of the member "line2".
     *
     * If the meaning of "line2" isn't clear, then there should be a description here.
     *
     * @param line2 The value which will be set
     */
    inline void setLine2 (const char* line2_);

    /**
     * Sets the value of the member "line2".
     *
     * If the meaning of "line2" isn't clear, then there should be a description here.
     *
     * @param line2 The value which will be set
     */
    inline void setLine2 (const char* value, size_t size);

    // API of field "luaCmd"

    static const int kLuaCmd = 8;

    /**
     * Clears the field "luaCmd".
     *
     * The field will be set to its default value. The hasLuaCmd()
     * method will return false.
     */
    inline void clearLuaCmd();

    /**
     * Checks whether the field "luaCmd" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLuaCmd()). Otherwise it will return false.
     */
    inline bool hasLuaCmd () const;

    /**
     * Returns the value of the member "luaCmd".
     *
     * If the meaning of "luaCmd" isn't clear, then there should be a description here.
     *
     * @return The value of the field "luaCmd"
     */
    inline const ::std::string& getLuaCmd () const;

    /**
     * Retrieves the value of the field "luaCmd" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "luaCmd".
     */
    inline ::std::string& getLuaCmdMutable ();

    /**
     * Sets the value of the member "luaCmd".
     *
     * If the meaning of "luaCmd" isn't clear, then there should be a description here.
     *
     * @param luaCmd The value which will be set
     */
    inline void setLuaCmd (const ::std::string& luaCmd_);

    /**
     * Sets the value of the member "luaCmd".
     *
     * If the meaning of "luaCmd" isn't clear, then there should be a description here.
     *
     * @param luaCmd The value which will be set
     */
    inline void setLuaCmd (const char* luaCmd_);

    /**
     * Sets the value of the member "luaCmd".
     *
     * If the meaning of "luaCmd" isn't clear, then there should be a description here.
     *
     * @param luaCmd The value which will be set
     */
    inline void setLuaCmd (const char* value, size_t size);

    // API of field "u32Retries"

    static const int kU32Retries = 9;

    /**
     * Clears the field "u32Retries".
     *
     * The field will be set to its default value. The hasU32Retries()
     * method will return false.
     */
    inline void clearU32Retries();

    /**
     * Checks whether the field "u32Retries" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32Retries()). Otherwise it will return false.
     */
    inline bool hasU32Retries () const;

    /**
     * Returns the value of the member "u32Retries".
     *
     * If the meaning of "u32Retries" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u32Retries"
     */
    inline uint32 getU32Retries () const;

    /**
     * Sets the value of the member "u32Retries".
     *
     * If the meaning of "u32Retries" isn't clear, then there should be a description here.
     *
     * @param u32Retries The value which will be set
     */
    inline void setU32Retries (uint32 u32Retries_);

    // API of field "u32NumAll"

    static const int kU32NumAll = 10;

    /**
     * Clears the field "u32NumAll".
     *
     * The field will be set to its default value. The hasU32NumAll()
     * method will return false.
     */
    inline void clearU32NumAll();

    /**
     * Checks whether the field "u32NumAll" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32NumAll()). Otherwise it will return false.
     */
    inline bool hasU32NumAll () const;

    /**
     * Returns the value of the member "u32NumAll".
     *
     * If the meaning of "u32NumAll" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u32NumAll"
     */
    inline uint32 getU32NumAll () const;

    /**
     * Sets the value of the member "u32NumAll".
     *
     * If the meaning of "u32NumAll" isn't clear, then there should be a description here.
     *
     * @param u32NumAll The value which will be set
     */
    inline void setU32NumAll (uint32 u32NumAll_);

    // API of field "u32NumComplete"

    static const int kU32NumComplete = 11;

    /**
     * Clears the field "u32NumComplete".
     *
     * The field will be set to its default value. The hasU32NumComplete()
     * method will return false.
     */
    inline void clearU32NumComplete();

    /**
     * Checks whether the field "u32NumComplete" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32NumComplete()). Otherwise it will return false.
     */
    inline bool hasU32NumComplete () const;

    /**
     * Returns the value of the member "u32NumComplete".
     *
     * If the meaning of "u32NumComplete" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u32NumComplete"
     */
    inline uint32 getU32NumComplete () const;

    /**
     * Sets the value of the member "u32NumComplete".
     *
     * If the meaning of "u32NumComplete" isn't clear, then there should be a description here.
     *
     * @param u32NumComplete The value which will be set
     */
    inline void setU32NumComplete (uint32 u32NumComplete_);

    // API of field "u32NumRunning"

    static const int kU32NumRunning = 12;

    /**
     * Clears the field "u32NumRunning".
     *
     * The field will be set to its default value. The hasU32NumRunning()
     * method will return false.
     */
    inline void clearU32NumRunning();

    /**
     * Checks whether the field "u32NumRunning" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32NumRunning()). Otherwise it will return false.
     */
    inline bool hasU32NumRunning () const;

    /**
     * Returns the value of the member "u32NumRunning".
     *
     * If the meaning of "u32NumRunning" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u32NumRunning"
     */
    inline uint32 getU32NumRunning () const;

    /**
     * Sets the value of the member "u32NumRunning".
     *
     * If the meaning of "u32NumRunning" isn't clear, then there should be a description here.
     *
     * @param u32NumRunning The value which will be set
     */
    inline void setU32NumRunning (uint32 u32NumRunning_);

    // API of field "u32NumNotApplicable"

    static const int kU32NumNotApplicable = 13;

    /**
     * Clears the field "u32NumNotApplicable".
     *
     * The field will be set to its default value. The hasU32NumNotApplicable()
     * method will return false.
     */
    inline void clearU32NumNotApplicable();

    /**
     * Checks whether the field "u32NumNotApplicable" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32NumNotApplicable()). Otherwise it will return false.
     */
    inline bool hasU32NumNotApplicable () const;

    /**
     * Returns the value of the member "u32NumNotApplicable".
     *
     * If the meaning of "u32NumNotApplicable" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u32NumNotApplicable"
     */
    inline uint32 getU32NumNotApplicable () const;

    /**
     * Sets the value of the member "u32NumNotApplicable".
     *
     * If the meaning of "u32NumNotApplicable" isn't clear, then there should be a description here.
     *
     * @param u32NumNotApplicable The value which will be set
     */
    inline void setU32NumNotApplicable (uint32 u32NumNotApplicable_);

    // API of field "u32NumFailed"

    static const int kU32NumFailed = 14;

    /**
     * Clears the field "u32NumFailed".
     *
     * The field will be set to its default value. The hasU32NumFailed()
     * method will return false.
     */
    inline void clearU32NumFailed();

    /**
     * Checks whether the field "u32NumFailed" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32NumFailed()). Otherwise it will return false.
     */
    inline bool hasU32NumFailed () const;

    /**
     * Returns the value of the member "u32NumFailed".
     *
     * If the meaning of "u32NumFailed" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u32NumFailed"
     */
    inline uint32 getU32NumFailed () const;

    /**
     * Sets the value of the member "u32NumFailed".
     *
     * If the meaning of "u32NumFailed" isn't clear, then there should be a description here.
     *
     * @param u32NumFailed The value which will be set
     */
    inline void setU32NumFailed (uint32 u32NumFailed_);

    // API of field "u32NumRemaining"

    static const int kU32NumRemaining = 15;

    /**
     * Clears the field "u32NumRemaining".
     *
     * The field will be set to its default value. The hasU32NumRemaining()
     * method will return false.
     */
    inline void clearU32NumRemaining();

    /**
     * Checks whether the field "u32NumRemaining" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32NumRemaining()). Otherwise it will return false.
     */
    inline bool hasU32NumRemaining () const;

    /**
     * Returns the value of the member "u32NumRemaining".
     *
     * If the meaning of "u32NumRemaining" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u32NumRemaining"
     */
    inline uint32 getU32NumRemaining () const;

    /**
     * Sets the value of the member "u32NumRemaining".
     *
     * If the meaning of "u32NumRemaining" isn't clear, then there should be a description here.
     *
     * @param u32NumRemaining The value which will be set
     */
    inline void setU32NumRemaining (uint32 u32NumRemaining_);

    // API of field "u8SubModulePercentComplete"

    static const int kU8SubModulePercentComplete = 16;

    /**
     * Clears the field "u8SubModulePercentComplete".
     *
     * The field will be set to its default value. The hasU8SubModulePercentComplete()
     * method will return false.
     */
    inline void clearU8SubModulePercentComplete();

    /**
     * Checks whether the field "u8SubModulePercentComplete" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8SubModulePercentComplete()). Otherwise it will return false.
     */
    inline bool hasU8SubModulePercentComplete () const;

    /**
     * Returns the value of the member "u8SubModulePercentComplete".
     *
     * If the meaning of "u8SubModulePercentComplete" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u8SubModulePercentComplete"
     */
    inline uint8 getU8SubModulePercentComplete () const;

    /**
     * Sets the value of the member "u8SubModulePercentComplete".
     *
     * If the meaning of "u8SubModulePercentComplete" isn't clear, then there should be a description here.
     *
     * @param u8SubModulePercentComplete The value which will be set
     */
    inline void setU8SubModulePercentComplete (uint8 u8SubModulePercentComplete_);

    // API of field "u8ReleasePercentComplete"

    static const int kU8ReleasePercentComplete = 17;

    /**
     * Clears the field "u8ReleasePercentComplete".
     *
     * The field will be set to its default value. The hasU8ReleasePercentComplete()
     * method will return false.
     */
    inline void clearU8ReleasePercentComplete();

    /**
     * Checks whether the field "u8ReleasePercentComplete" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8ReleasePercentComplete()). Otherwise it will return false.
     */
    inline bool hasU8ReleasePercentComplete () const;

    /**
     * Returns the value of the member "u8ReleasePercentComplete".
     *
     * If the meaning of "u8ReleasePercentComplete" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u8ReleasePercentComplete"
     */
    inline uint8 getU8ReleasePercentComplete () const;

    /**
     * Sets the value of the member "u8ReleasePercentComplete".
     *
     * If the meaning of "u8ReleasePercentComplete" isn't clear, then there should be a description here.
     *
     * @param u8ReleasePercentComplete The value which will be set
     */
    inline void setU8ReleasePercentComplete (uint8 u8ReleasePercentComplete_);

    // API of field "u8ReleasePercentCompleteForPhase"

    static const int kU8ReleasePercentCompleteForPhase = 18;

    /**
     * Clears the field "u8ReleasePercentCompleteForPhase".
     *
     * The field will be set to its default value. The hasU8ReleasePercentCompleteForPhase()
     * method will return false.
     */
    inline void clearU8ReleasePercentCompleteForPhase();

    /**
     * Checks whether the field "u8ReleasePercentCompleteForPhase" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8ReleasePercentCompleteForPhase()). Otherwise it will return false.
     */
    inline bool hasU8ReleasePercentCompleteForPhase () const;

    /**
     * Returns the value of the member "u8ReleasePercentCompleteForPhase".
     *
     * If the meaning of "u8ReleasePercentCompleteForPhase" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u8ReleasePercentCompleteForPhase"
     */
    inline uint8 getU8ReleasePercentCompleteForPhase () const;

    /**
     * Sets the value of the member "u8ReleasePercentCompleteForPhase".
     *
     * If the meaning of "u8ReleasePercentCompleteForPhase" isn't clear, then there should be a description here.
     *
     * @param u8ReleasePercentCompleteForPhase The value which will be set
     */
    inline void setU8ReleasePercentCompleteForPhase (uint8 u8ReleasePercentCompleteForPhase_);

    // API of field "u32EstimatedUpdateTimeSec"

    static const int kU32EstimatedUpdateTimeSec = 19;

    /**
     * Clears the field "u32EstimatedUpdateTimeSec".
     *
     * The field will be set to its default value. The hasU32EstimatedUpdateTimeSec()
     * method will return false.
     */
    inline void clearU32EstimatedUpdateTimeSec();

    /**
     * Checks whether the field "u32EstimatedUpdateTimeSec" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32EstimatedUpdateTimeSec()). Otherwise it will return false.
     */
    inline bool hasU32EstimatedUpdateTimeSec () const;

    /**
     * Returns the value of the member "u32EstimatedUpdateTimeSec".
     *
     * If the meaning of "u32EstimatedUpdateTimeSec" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u32EstimatedUpdateTimeSec"
     */
    inline uint32 getU32EstimatedUpdateTimeSec () const;

    /**
     * Sets the value of the member "u32EstimatedUpdateTimeSec".
     *
     * If the meaning of "u32EstimatedUpdateTimeSec" isn't clear, then there should be a description here.
     *
     * @param u32EstimatedUpdateTimeSec The value which will be set
     */
    inline void setU32EstimatedUpdateTimeSec (uint32 u32EstimatedUpdateTimeSec_);

    // API of field "u32EstimatedUpdateTimeSecForPhase"

    static const int kU32EstimatedUpdateTimeSecForPhase = 20;

    /**
     * Clears the field "u32EstimatedUpdateTimeSecForPhase".
     *
     * The field will be set to its default value. The hasU32EstimatedUpdateTimeSecForPhase()
     * method will return false.
     */
    inline void clearU32EstimatedUpdateTimeSecForPhase();

    /**
     * Checks whether the field "u32EstimatedUpdateTimeSecForPhase" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32EstimatedUpdateTimeSecForPhase()). Otherwise it will return false.
     */
    inline bool hasU32EstimatedUpdateTimeSecForPhase () const;

    /**
     * Returns the value of the member "u32EstimatedUpdateTimeSecForPhase".
     *
     * If the meaning of "u32EstimatedUpdateTimeSecForPhase" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u32EstimatedUpdateTimeSecForPhase"
     */
    inline uint32 getU32EstimatedUpdateTimeSecForPhase () const;

    /**
     * Sets the value of the member "u32EstimatedUpdateTimeSecForPhase".
     *
     * If the meaning of "u32EstimatedUpdateTimeSecForPhase" isn't clear, then there should be a description here.
     *
     * @param u32EstimatedUpdateTimeSecForPhase The value which will be set
     */
    inline void setU32EstimatedUpdateTimeSecForPhase (uint32 u32EstimatedUpdateTimeSecForPhase_);

    // API of field "u32EstimatedCurrentModuleUpdateTimeSec"

    static const int kU32EstimatedCurrentModuleUpdateTimeSec = 21;

    /**
     * Clears the field "u32EstimatedCurrentModuleUpdateTimeSec".
     *
     * The field will be set to its default value. The hasU32EstimatedCurrentModuleUpdateTimeSec()
     * method will return false.
     */
    inline void clearU32EstimatedCurrentModuleUpdateTimeSec();

    /**
     * Checks whether the field "u32EstimatedCurrentModuleUpdateTimeSec" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32EstimatedCurrentModuleUpdateTimeSec()). Otherwise it will return false.
     */
    inline bool hasU32EstimatedCurrentModuleUpdateTimeSec () const;

    /**
     * Returns the value of the member "u32EstimatedCurrentModuleUpdateTimeSec".
     *
     * If the meaning of "u32EstimatedCurrentModuleUpdateTimeSec" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u32EstimatedCurrentModuleUpdateTimeSec"
     */
    inline uint32 getU32EstimatedCurrentModuleUpdateTimeSec () const;

    /**
     * Sets the value of the member "u32EstimatedCurrentModuleUpdateTimeSec".
     *
     * If the meaning of "u32EstimatedCurrentModuleUpdateTimeSec" isn't clear, then there should be a description here.
     *
     * @param u32EstimatedCurrentModuleUpdateTimeSec The value which will be set
     */
    inline void setU32EstimatedCurrentModuleUpdateTimeSec (uint32 u32EstimatedCurrentModuleUpdateTimeSec_);

    static const trUpdProgress &getDefaultInstance();

private:

    inline void set_has_train ();

    inline void clear_has_train ();

    inline void set_has_deviceName ();

    inline void clear_has_deviceName ();

    inline void set_has_moduleName ();

    inline void clear_has_moduleName ();

    inline void set_has_subModuleName ();

    inline void clear_has_subModuleName ();

    inline void set_has_refKey ();

    inline void clear_has_refKey ();

    inline void set_has_source ();

    inline void clear_has_source ();

    inline void set_has_line1 ();

    inline void clear_has_line1 ();

    inline void set_has_line2 ();

    inline void clear_has_line2 ();

    inline void set_has_luaCmd ();

    inline void clear_has_luaCmd ();

    inline void set_has_u32Retries ();

    inline void clear_has_u32Retries ();

    inline void set_has_u32NumAll ();

    inline void clear_has_u32NumAll ();

    inline void set_has_u32NumComplete ();

    inline void clear_has_u32NumComplete ();

    inline void set_has_u32NumRunning ();

    inline void clear_has_u32NumRunning ();

    inline void set_has_u32NumNotApplicable ();

    inline void clear_has_u32NumNotApplicable ();

    inline void set_has_u32NumFailed ();

    inline void clear_has_u32NumFailed ();

    inline void set_has_u32NumRemaining ();

    inline void clear_has_u32NumRemaining ();

    inline void set_has_u8SubModulePercentComplete ();

    inline void clear_has_u8SubModulePercentComplete ();

    inline void set_has_u8ReleasePercentComplete ();

    inline void clear_has_u8ReleasePercentComplete ();

    inline void set_has_u8ReleasePercentCompleteForPhase ();

    inline void clear_has_u8ReleasePercentCompleteForPhase ();

    inline void set_has_u32EstimatedUpdateTimeSec ();

    inline void clear_has_u32EstimatedUpdateTimeSec ();

    inline void set_has_u32EstimatedUpdateTimeSecForPhase ();

    inline void clear_has_u32EstimatedUpdateTimeSecForPhase ();

    inline void set_has_u32EstimatedCurrentModuleUpdateTimeSec ();

    inline void clear_has_u32EstimatedCurrentModuleUpdateTimeSec ();

    uint32 _has_bits_[ (22 + 31) / 32];

    ::std::string _train;

    ::std::string _deviceName;

    ::std::string _moduleName;

    ::std::string _subModuleName;

    ::std::string _refKey;

    ::std::string _source;

    ::std::string _line1;

    ::std::string _line2;

    ::std::string _luaCmd;

    uint32 _u32Retries;

    uint32 _u32NumAll;

    uint32 _u32NumComplete;

    uint32 _u32NumRunning;

    uint32 _u32NumNotApplicable;

    uint32 _u32NumFailed;

    uint32 _u32NumRemaining;

    uint8 _u8SubModulePercentComplete;

    uint8 _u8ReleasePercentComplete;

    uint8 _u8ReleasePercentCompleteForPhase;

    uint32 _u32EstimatedUpdateTimeSec;

    uint32 _u32EstimatedUpdateTimeSecForPhase;

    uint32 _u32EstimatedCurrentModuleUpdateTimeSec;

};

/**
 * If the meaning of "trAbortDeviceRes" isn't clear, then there should be a description here.
 */
class trAbortDeviceRes {
public:

    /**
     * Default constructor
     */
    inline  trAbortDeviceRes ();

    /**
     * Copy constructor
     */
    inline  trAbortDeviceRes (const trAbortDeviceRes &rhs);

    /**
     * All fields constructor
     */
    inline  trAbortDeviceRes (bool abortSuccess_, const ::std::string& refKey_);

    /**
     * Destructor
     */
    inline  ~trAbortDeviceRes();

    /**
     * Assignment operator
     */
    inline trAbortDeviceRes& operator = (const trAbortDeviceRes& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const trAbortDeviceRes& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const trAbortDeviceRes& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const trAbortDeviceRes& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const trAbortDeviceRes& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "abortSuccess"

    static const int kAbortSuccess = 0;

    /**
     * Clears the field "abortSuccess".
     *
     * The field will be set to its default value. The hasAbortSuccess()
     * method will return false.
     */
    inline void clearAbortSuccess();

    /**
     * Checks whether the field "abortSuccess" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAbortSuccess()). Otherwise it will return false.
     */
    inline bool hasAbortSuccess () const;

    /**
     * Returns the value of the member "abortSuccess".
     *
     * If the meaning of "abortSuccess" isn't clear, then there should be a description here.
     *
     * @return The value of the field "abortSuccess"
     */
    inline bool getAbortSuccess () const;

    /**
     * Sets the value of the member "abortSuccess".
     *
     * If the meaning of "abortSuccess" isn't clear, then there should be a description here.
     *
     * @param abortSuccess The value which will be set
     */
    inline void setAbortSuccess (bool abortSuccess_);

    // API of field "refKey"

    static const int kRefKey = 1;

    /**
     * Clears the field "refKey".
     *
     * The field will be set to its default value. The hasRefKey()
     * method will return false.
     */
    inline void clearRefKey();

    /**
     * Checks whether the field "refKey" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRefKey()). Otherwise it will return false.
     */
    inline bool hasRefKey () const;

    /**
     * Returns the value of the member "refKey".
     *
     * If the meaning of "refKey" isn't clear, then there should be a description here.
     *
     * @return The value of the field "refKey"
     */
    inline const ::std::string& getRefKey () const;

    /**
     * Retrieves the value of the field "refKey" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "refKey".
     */
    inline ::std::string& getRefKeyMutable ();

    /**
     * Sets the value of the member "refKey".
     *
     * If the meaning of "refKey" isn't clear, then there should be a description here.
     *
     * @param refKey The value which will be set
     */
    inline void setRefKey (const ::std::string& refKey_);

    /**
     * Sets the value of the member "refKey".
     *
     * If the meaning of "refKey" isn't clear, then there should be a description here.
     *
     * @param refKey The value which will be set
     */
    inline void setRefKey (const char* refKey_);

    /**
     * Sets the value of the member "refKey".
     *
     * If the meaning of "refKey" isn't clear, then there should be a description here.
     *
     * @param refKey The value which will be set
     */
    inline void setRefKey (const char* value, size_t size);

    static const trAbortDeviceRes &getDefaultInstance();

private:

    inline void set_has_abortSuccess ();

    inline void clear_has_abortSuccess ();

    inline void set_has_refKey ();

    inline void clear_has_refKey ();

    uint32 _has_bits_[ (2 + 31) / 32];

    bool _abortSuccess;

    ::std::string _refKey;

};

/**
 * If the meaning of "trTimeDate" isn't clear, then there should be a description here.
 */
class trTimeDate {
public:

    /**
     * Default constructor
     */
    inline  trTimeDate ();

    /**
     * Copy constructor
     */
    inline  trTimeDate (const trTimeDate &rhs);

    /**
     * All fields constructor
     */
    inline  trTimeDate (uint16 year_, uint8 month_, uint8 day_, uint8 hour_, uint8 minute_, uint32 seconds_, uint64 utc_);

    /**
     * Destructor
     */
    inline  ~trTimeDate();

    /**
     * Assignment operator
     */
    inline trTimeDate& operator = (const trTimeDate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const trTimeDate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const trTimeDate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const trTimeDate& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const trTimeDate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "year"

    static const int kYear = 0;

    /**
     * Clears the field "year".
     *
     * The field will be set to its default value. The hasYear()
     * method will return false.
     */
    inline void clearYear();

    /**
     * Checks whether the field "year" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setYear()). Otherwise it will return false.
     */
    inline bool hasYear () const;

    /**
     * Returns the value of the member "year".
     *
     * If the meaning of "year" isn't clear, then there should be a description here.
     *
     * @return The value of the field "year"
     */
    inline uint16 getYear () const;

    /**
     * Sets the value of the member "year".
     *
     * If the meaning of "year" isn't clear, then there should be a description here.
     *
     * @param year The value which will be set
     */
    inline void setYear (uint16 year_);

    // API of field "month"

    static const int kMonth = 1;

    /**
     * Clears the field "month".
     *
     * The field will be set to its default value. The hasMonth()
     * method will return false.
     */
    inline void clearMonth();

    /**
     * Checks whether the field "month" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMonth()). Otherwise it will return false.
     */
    inline bool hasMonth () const;

    /**
     * Returns the value of the member "month".
     *
     * If the meaning of "month" isn't clear, then there should be a description here.
     *
     * @return The value of the field "month"
     */
    inline uint8 getMonth () const;

    /**
     * Sets the value of the member "month".
     *
     * If the meaning of "month" isn't clear, then there should be a description here.
     *
     * @param month The value which will be set
     */
    inline void setMonth (uint8 month_);

    // API of field "day"

    static const int kDay = 2;

    /**
     * Clears the field "day".
     *
     * The field will be set to its default value. The hasDay()
     * method will return false.
     */
    inline void clearDay();

    /**
     * Checks whether the field "day" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDay()). Otherwise it will return false.
     */
    inline bool hasDay () const;

    /**
     * Returns the value of the member "day".
     *
     * If the meaning of "day" isn't clear, then there should be a description here.
     *
     * @return The value of the field "day"
     */
    inline uint8 getDay () const;

    /**
     * Sets the value of the member "day".
     *
     * If the meaning of "day" isn't clear, then there should be a description here.
     *
     * @param day The value which will be set
     */
    inline void setDay (uint8 day_);

    // API of field "hour"

    static const int kHour = 3;

    /**
     * Clears the field "hour".
     *
     * The field will be set to its default value. The hasHour()
     * method will return false.
     */
    inline void clearHour();

    /**
     * Checks whether the field "hour" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setHour()). Otherwise it will return false.
     */
    inline bool hasHour () const;

    /**
     * Returns the value of the member "hour".
     *
     * If the meaning of "hour" isn't clear, then there should be a description here.
     *
     * @return The value of the field "hour"
     */
    inline uint8 getHour () const;

    /**
     * Sets the value of the member "hour".
     *
     * If the meaning of "hour" isn't clear, then there should be a description here.
     *
     * @param hour The value which will be set
     */
    inline void setHour (uint8 hour_);

    // API of field "minute"

    static const int kMinute = 4;

    /**
     * Clears the field "minute".
     *
     * The field will be set to its default value. The hasMinute()
     * method will return false.
     */
    inline void clearMinute();

    /**
     * Checks whether the field "minute" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMinute()). Otherwise it will return false.
     */
    inline bool hasMinute () const;

    /**
     * Returns the value of the member "minute".
     *
     * If the meaning of "minute" isn't clear, then there should be a description here.
     *
     * @return The value of the field "minute"
     */
    inline uint8 getMinute () const;

    /**
     * Sets the value of the member "minute".
     *
     * If the meaning of "minute" isn't clear, then there should be a description here.
     *
     * @param minute The value which will be set
     */
    inline void setMinute (uint8 minute_);

    // API of field "seconds"

    static const int kSeconds = 5;

    /**
     * Clears the field "seconds".
     *
     * The field will be set to its default value. The hasSeconds()
     * method will return false.
     */
    inline void clearSeconds();

    /**
     * Checks whether the field "seconds" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSeconds()). Otherwise it will return false.
     */
    inline bool hasSeconds () const;

    /**
     * Returns the value of the member "seconds".
     *
     * If the meaning of "seconds" isn't clear, then there should be a description here.
     *
     * @return The value of the field "seconds"
     */
    inline uint32 getSeconds () const;

    /**
     * Sets the value of the member "seconds".
     *
     * If the meaning of "seconds" isn't clear, then there should be a description here.
     *
     * @param seconds The value which will be set
     */
    inline void setSeconds (uint32 seconds_);

    // API of field "utc"

    static const int kUtc = 6;

    /**
     * Clears the field "utc".
     *
     * The field will be set to its default value. The hasUtc()
     * method will return false.
     */
    inline void clearUtc();

    /**
     * Checks whether the field "utc" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setUtc()). Otherwise it will return false.
     */
    inline bool hasUtc () const;

    /**
     * Returns the value of the member "utc".
     *
     * If the meaning of "utc" isn't clear, then there should be a description here.
     *
     * @return The value of the field "utc"
     */
    inline uint64 getUtc () const;

    /**
     * Sets the value of the member "utc".
     *
     * If the meaning of "utc" isn't clear, then there should be a description here.
     *
     * @param utc The value which will be set
     */
    inline void setUtc (uint64 utc_);

    static const trTimeDate &getDefaultInstance();

private:

    inline void set_has_year ();

    inline void clear_has_year ();

    inline void set_has_month ();

    inline void clear_has_month ();

    inline void set_has_day ();

    inline void clear_has_day ();

    inline void set_has_hour ();

    inline void clear_has_hour ();

    inline void set_has_minute ();

    inline void clear_has_minute ();

    inline void set_has_seconds ();

    inline void clear_has_seconds ();

    inline void set_has_utc ();

    inline void clear_has_utc ();

    uint32 _has_bits_[ (7 + 31) / 32];

    uint16 _year;

    uint8 _month;

    uint8 _day;

    uint8 _hour;

    uint8 _minute;

    uint32 _seconds;

    uint64 _utc;

};

/**
 * If the meaning of "trResult" isn't clear, then there should be a description here.
 */
class trResult {
public:

    /**
     * Default constructor
     */
    inline  trResult ();

    /**
     * Copy constructor
     */
    inline  trResult (const trResult &rhs);

    /**
     * All fields constructor
     */
    inline  trResult (bool bOk_, const ::std::string& name_, const trTimeDate& timeDate_, uint32 counterKilometers_, const ::std::vector< trDeviceData >& devices_);

    /**
     * Destructor
     */
    inline  ~trResult();

    /**
     * Assignment operator
     */
    inline trResult& operator = (const trResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const trResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const trResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const trResult& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const trResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bOk"

    static const int kBOk = 0;

    /**
     * Clears the field "bOk".
     *
     * The field will be set to its default value. The hasBOk()
     * method will return false.
     */
    inline void clearBOk();

    /**
     * Checks whether the field "bOk" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBOk()). Otherwise it will return false.
     */
    inline bool hasBOk () const;

    /**
     * Returns the value of the member "bOk".
     *
     * If the meaning of "bOk" isn't clear, then there should be a description here.
     *
     * @return The value of the field "bOk"
     */
    inline bool getBOk () const;

    /**
     * Sets the value of the member "bOk".
     *
     * If the meaning of "bOk" isn't clear, then there should be a description here.
     *
     * @param bOk The value which will be set
     */
    inline void setBOk (bool bOk_);

    // API of field "name"

    static const int kName = 1;

    /**
     * Clears the field "name".
     *
     * The field will be set to its default value. The hasName()
     * method will return false.
     */
    inline void clearName();

    /**
     * Checks whether the field "name" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setName()). Otherwise it will return false.
     */
    inline bool hasName () const;

    /**
     * Returns the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @return The value of the field "name"
     */
    inline const ::std::string& getName () const;

    /**
     * Retrieves the value of the field "name" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "name".
     */
    inline ::std::string& getNameMutable ();

    /**
     * Sets the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param name The value which will be set
     */
    inline void setName (const ::std::string& name_);

    /**
     * Sets the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param name The value which will be set
     */
    inline void setName (const char* name_);

    /**
     * Sets the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param name The value which will be set
     */
    inline void setName (const char* value, size_t size);

    // API of field "timeDate"

    static const int kTimeDate = 2;

    /**
     * Clears the field "timeDate".
     *
     * The field will be set to its default value. The hasTimeDate()
     * method will return false.
     */
    inline void clearTimeDate();

    /**
     * Checks whether the field "timeDate" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTimeDate()). Otherwise it will return false.
     */
    inline bool hasTimeDate () const;

    /**
     * Returns the value of the member "timeDate".
     *
     * If the meaning of "timeDate" isn't clear, then there should be a description here.
     *
     * @return The value of the field "timeDate"
     */
    inline const trTimeDate& getTimeDate () const;

    /**
     * Retrieves the value of the field "timeDate" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "timeDate".
     */
    inline trTimeDate& getTimeDateMutable ();

    /**
     * Sets the value of the member "timeDate".
     *
     * If the meaning of "timeDate" isn't clear, then there should be a description here.
     *
     * @param timeDate The value which will be set
     */
    inline void setTimeDate (const trTimeDate& timeDate_);

    // API of field "counterKilometers"

    static const int kCounterKilometers = 3;

    /**
     * Clears the field "counterKilometers".
     *
     * The field will be set to its default value. The hasCounterKilometers()
     * method will return false.
     */
    inline void clearCounterKilometers();

    /**
     * Checks whether the field "counterKilometers" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCounterKilometers()). Otherwise it will return false.
     */
    inline bool hasCounterKilometers () const;

    /**
     * Returns the value of the member "counterKilometers".
     *
     * If the meaning of "counterKilometers" isn't clear, then there should be a description here.
     *
     * @return The value of the field "counterKilometers"
     */
    inline uint32 getCounterKilometers () const;

    /**
     * Sets the value of the member "counterKilometers".
     *
     * If the meaning of "counterKilometers" isn't clear, then there should be a description here.
     *
     * @param counterKilometers The value which will be set
     */
    inline void setCounterKilometers (uint32 counterKilometers_);

    // API of field "devices"

    static const int kDevices = 4;

    /**
     * Clears the field "devices".
     *
     * The field will be set to its default value. The hasDevices()
     * method will return false.
     */
    inline void clearDevices();

    /**
     * Checks whether the field "devices" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDevices()). Otherwise it will return false.
     */
    inline bool hasDevices () const;

    /**
     * Returns the value of the member "devices".
     *
     * If the meaning of "devices" isn't clear, then there should be a description here.
     *
     * @return The value of the field "devices"
     */
    inline const ::std::vector< trDeviceData >& getDevices () const;

    /**
     * Retrieves the value of the field "devices" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "devices".
     */
    inline ::std::vector< trDeviceData >& getDevicesMutable ();

    /**
     * Sets the value of the member "devices".
     *
     * If the meaning of "devices" isn't clear, then there should be a description here.
     *
     * @param devices The value which will be set
     */
    inline void setDevices (const ::std::vector< trDeviceData >& devices_);

    static const trResult &getDefaultInstance();

private:

    static const ::std::vector< trDeviceData >& getTrDeviceDataList_DefaultInstance ();

    inline void set_has_bOk ();

    inline void clear_has_bOk ();

    inline void set_has_name ();

    inline void clear_has_name ();

    inline void set_has_timeDate ();

    inline void clear_has_timeDate ();

    inline void set_has_counterKilometers ();

    inline void clear_has_counterKilometers ();

    inline void set_has_devices ();

    inline void clear_has_devices ();

    uint32 _has_bits_[ (5 + 31) / 32];

    bool _bOk;

    ::std::string _name;

    trTimeDate _timeDate;

    uint32 _counterKilometers;

    ::std::vector< trDeviceData > _devices;

};

/**
 * If the meaning of "trErrorIds" isn't clear, then there should be a description here.
 */
class trErrorIds {
public:

    /**
     * Default constructor
     */
    inline  trErrorIds ();

    /**
     * Copy constructor
     */
    inline  trErrorIds (const trErrorIds &rhs);

    /**
     * All fields constructor
     */
    inline  trErrorIds (const ::std::vector< tenErrorId >& errorIds_);

    /**
     * Destructor
     */
    inline  ~trErrorIds();

    /**
     * Assignment operator
     */
    inline trErrorIds& operator = (const trErrorIds& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const trErrorIds& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const trErrorIds& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const trErrorIds& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const trErrorIds& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "errorIds"

    static const int kErrorIds = 0;

    /**
     * Clears the field "errorIds".
     *
     * The field will be set to its default value. The hasErrorIds()
     * method will return false.
     */
    inline void clearErrorIds();

    /**
     * Checks whether the field "errorIds" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorIds()). Otherwise it will return false.
     */
    inline bool hasErrorIds () const;

    /**
     * Returns the value of the member "errorIds".
     *
     * If the meaning of "errorIds" isn't clear, then there should be a description here.
     *
     * @return The value of the field "errorIds"
     */
    inline const ::std::vector< tenErrorId >& getErrorIds () const;

    /**
     * Retrieves the value of the field "errorIds" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "errorIds".
     */
    inline ::std::vector< tenErrorId >& getErrorIdsMutable ();

    /**
     * Sets the value of the member "errorIds".
     *
     * If the meaning of "errorIds" isn't clear, then there should be a description here.
     *
     * @param errorIds The value which will be set
     */
    inline void setErrorIds (const ::std::vector< tenErrorId >& errorIds_);

    static const trErrorIds &getDefaultInstance();

private:

    static const ::std::vector< tenErrorId >& getTenErrorIdList_DefaultInstance ();

    inline void set_has_errorIds ();

    inline void clear_has_errorIds ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< tenErrorId > _errorIds;

};

/**
 * If the meaning of "trGetCacheDirectory" isn't clear, then there should be a description here.
 */
class trGetCacheDirectory {
public:

    /**
     * Default constructor
     */
    inline  trGetCacheDirectory ();

    /**
     * Copy constructor
     */
    inline  trGetCacheDirectory (const trGetCacheDirectory &rhs);

    /**
     * All fields constructor
     */
    inline  trGetCacheDirectory (tenCacheDirRequest dirRequest_);

    /**
     * Destructor
     */
    inline  ~trGetCacheDirectory();

    /**
     * Assignment operator
     */
    inline trGetCacheDirectory& operator = (const trGetCacheDirectory& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const trGetCacheDirectory& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const trGetCacheDirectory& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const trGetCacheDirectory& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const trGetCacheDirectory& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "dirRequest"

    static const int kDirRequest = 0;

    /**
     * Clears the field "dirRequest".
     *
     * The field will be set to its default value. The hasDirRequest()
     * method will return false.
     */
    inline void clearDirRequest();

    /**
     * Checks whether the field "dirRequest" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDirRequest()). Otherwise it will return false.
     */
    inline bool hasDirRequest () const;

    /**
     * Returns the value of the member "dirRequest".
     *
     * If the meaning of "dirRequest" isn't clear, then there should be a description here.
     *
     * @return The value of the field "dirRequest"
     */
    inline tenCacheDirRequest getDirRequest () const;

    /**
     * Sets the value of the member "dirRequest".
     *
     * If the meaning of "dirRequest" isn't clear, then there should be a description here.
     *
     * @param dirRequest The value which will be set
     */
    inline void setDirRequest (tenCacheDirRequest dirRequest_);

    static const trGetCacheDirectory &getDefaultInstance();

private:

    inline void set_has_dirRequest ();

    inline void clear_has_dirRequest ();

    uint32 _has_bits_[ (1 + 31) / 32];

    tenCacheDirRequest _dirRequest;

};

/**
 * If the meaning of "trUpdLog" isn't clear, then there should be a description here.
 */
class trUpdLog {
public:

    /**
     * Default constructor
     */
    inline  trUpdLog ();

    /**
     * Copy constructor
     */
    inline  trUpdLog (const trUpdLog &rhs);

    /**
     * All fields constructor
     */
    inline  trUpdLog (const ::std::string& name_, const trTimeDate& timeDate_, const ::std::string& updateType_, const ::std::vector< trDeviceData >& devices_, uint64 size_, bool success_, uint32 counterKilometers_, uint32 index_);

    /**
     * Destructor
     */
    inline  ~trUpdLog();

    /**
     * Assignment operator
     */
    inline trUpdLog& operator = (const trUpdLog& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const trUpdLog& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const trUpdLog& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const trUpdLog& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const trUpdLog& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "name"

    static const int kName = 0;

    /**
     * Clears the field "name".
     *
     * The field will be set to its default value. The hasName()
     * method will return false.
     */
    inline void clearName();

    /**
     * Checks whether the field "name" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setName()). Otherwise it will return false.
     */
    inline bool hasName () const;

    /**
     * Returns the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @return The value of the field "name"
     */
    inline const ::std::string& getName () const;

    /**
     * Retrieves the value of the field "name" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "name".
     */
    inline ::std::string& getNameMutable ();

    /**
     * Sets the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param name The value which will be set
     */
    inline void setName (const ::std::string& name_);

    /**
     * Sets the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param name The value which will be set
     */
    inline void setName (const char* name_);

    /**
     * Sets the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param name The value which will be set
     */
    inline void setName (const char* value, size_t size);

    // API of field "timeDate"

    static const int kTimeDate = 1;

    /**
     * Clears the field "timeDate".
     *
     * The field will be set to its default value. The hasTimeDate()
     * method will return false.
     */
    inline void clearTimeDate();

    /**
     * Checks whether the field "timeDate" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTimeDate()). Otherwise it will return false.
     */
    inline bool hasTimeDate () const;

    /**
     * Returns the value of the member "timeDate".
     *
     * If the meaning of "timeDate" isn't clear, then there should be a description here.
     *
     * @return The value of the field "timeDate"
     */
    inline const trTimeDate& getTimeDate () const;

    /**
     * Retrieves the value of the field "timeDate" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "timeDate".
     */
    inline trTimeDate& getTimeDateMutable ();

    /**
     * Sets the value of the member "timeDate".
     *
     * If the meaning of "timeDate" isn't clear, then there should be a description here.
     *
     * @param timeDate The value which will be set
     */
    inline void setTimeDate (const trTimeDate& timeDate_);

    // API of field "updateType"

    static const int kUpdateType = 2;

    /**
     * Clears the field "updateType".
     *
     * The field will be set to its default value. The hasUpdateType()
     * method will return false.
     */
    inline void clearUpdateType();

    /**
     * Checks whether the field "updateType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setUpdateType()). Otherwise it will return false.
     */
    inline bool hasUpdateType () const;

    /**
     * Returns the value of the member "updateType".
     *
     * If the meaning of "updateType" isn't clear, then there should be a description here.
     *
     * @return The value of the field "updateType"
     */
    inline const ::std::string& getUpdateType () const;

    /**
     * Retrieves the value of the field "updateType" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "updateType".
     */
    inline ::std::string& getUpdateTypeMutable ();

    /**
     * Sets the value of the member "updateType".
     *
     * If the meaning of "updateType" isn't clear, then there should be a description here.
     *
     * @param updateType The value which will be set
     */
    inline void setUpdateType (const ::std::string& updateType_);

    /**
     * Sets the value of the member "updateType".
     *
     * If the meaning of "updateType" isn't clear, then there should be a description here.
     *
     * @param updateType The value which will be set
     */
    inline void setUpdateType (const char* updateType_);

    /**
     * Sets the value of the member "updateType".
     *
     * If the meaning of "updateType" isn't clear, then there should be a description here.
     *
     * @param updateType The value which will be set
     */
    inline void setUpdateType (const char* value, size_t size);

    // API of field "devices"

    static const int kDevices = 3;

    /**
     * Clears the field "devices".
     *
     * The field will be set to its default value. The hasDevices()
     * method will return false.
     */
    inline void clearDevices();

    /**
     * Checks whether the field "devices" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDevices()). Otherwise it will return false.
     */
    inline bool hasDevices () const;

    /**
     * Returns the value of the member "devices".
     *
     * If the meaning of "devices" isn't clear, then there should be a description here.
     *
     * @return The value of the field "devices"
     */
    inline const ::std::vector< trDeviceData >& getDevices () const;

    /**
     * Retrieves the value of the field "devices" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "devices".
     */
    inline ::std::vector< trDeviceData >& getDevicesMutable ();

    /**
     * Sets the value of the member "devices".
     *
     * If the meaning of "devices" isn't clear, then there should be a description here.
     *
     * @param devices The value which will be set
     */
    inline void setDevices (const ::std::vector< trDeviceData >& devices_);

    // API of field "size"

    static const int kSize = 4;

    /**
     * Clears the field "size".
     *
     * The field will be set to its default value. The hasSize()
     * method will return false.
     */
    inline void clearSize();

    /**
     * Checks whether the field "size" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSize()). Otherwise it will return false.
     */
    inline bool hasSize () const;

    /**
     * Returns the value of the member "size".
     *
     * If the meaning of "size" isn't clear, then there should be a description here.
     *
     * @return The value of the field "size"
     */
    inline uint64 getSize () const;

    /**
     * Sets the value of the member "size".
     *
     * If the meaning of "size" isn't clear, then there should be a description here.
     *
     * @param size The value which will be set
     */
    inline void setSize (uint64 size_);

    // API of field "success"

    static const int kSuccess = 5;

    /**
     * Clears the field "success".
     *
     * The field will be set to its default value. The hasSuccess()
     * method will return false.
     */
    inline void clearSuccess();

    /**
     * Checks whether the field "success" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSuccess()). Otherwise it will return false.
     */
    inline bool hasSuccess () const;

    /**
     * Returns the value of the member "success".
     *
     * If the meaning of "success" isn't clear, then there should be a description here.
     *
     * @return The value of the field "success"
     */
    inline bool getSuccess () const;

    /**
     * Sets the value of the member "success".
     *
     * If the meaning of "success" isn't clear, then there should be a description here.
     *
     * @param success The value which will be set
     */
    inline void setSuccess (bool success_);

    // API of field "counterKilometers"

    static const int kCounterKilometers = 6;

    /**
     * Clears the field "counterKilometers".
     *
     * The field will be set to its default value. The hasCounterKilometers()
     * method will return false.
     */
    inline void clearCounterKilometers();

    /**
     * Checks whether the field "counterKilometers" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCounterKilometers()). Otherwise it will return false.
     */
    inline bool hasCounterKilometers () const;

    /**
     * Returns the value of the member "counterKilometers".
     *
     * If the meaning of "counterKilometers" isn't clear, then there should be a description here.
     *
     * @return The value of the field "counterKilometers"
     */
    inline uint32 getCounterKilometers () const;

    /**
     * Sets the value of the member "counterKilometers".
     *
     * If the meaning of "counterKilometers" isn't clear, then there should be a description here.
     *
     * @param counterKilometers The value which will be set
     */
    inline void setCounterKilometers (uint32 counterKilometers_);

    // API of field "index"

    static const int kIndex = 7;

    /**
     * Clears the field "index".
     *
     * The field will be set to its default value. The hasIndex()
     * method will return false.
     */
    inline void clearIndex();

    /**
     * Checks whether the field "index" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setIndex()). Otherwise it will return false.
     */
    inline bool hasIndex () const;

    /**
     * Returns the value of the member "index".
     *
     * If the meaning of "index" isn't clear, then there should be a description here.
     *
     * @return The value of the field "index"
     */
    inline uint32 getIndex () const;

    /**
     * Sets the value of the member "index".
     *
     * If the meaning of "index" isn't clear, then there should be a description here.
     *
     * @param index The value which will be set
     */
    inline void setIndex (uint32 index_);

    static const trUpdLog &getDefaultInstance();

private:

    static const ::std::vector< trDeviceData >& getTrDeviceDataList_DefaultInstance ();

    inline void set_has_name ();

    inline void clear_has_name ();

    inline void set_has_timeDate ();

    inline void clear_has_timeDate ();

    inline void set_has_updateType ();

    inline void clear_has_updateType ();

    inline void set_has_devices ();

    inline void clear_has_devices ();

    inline void set_has_size ();

    inline void clear_has_size ();

    inline void set_has_success ();

    inline void clear_has_success ();

    inline void set_has_counterKilometers ();

    inline void clear_has_counterKilometers ();

    inline void set_has_index ();

    inline void clear_has_index ();

    uint32 _has_bits_[ (8 + 31) / 32];

    ::std::string _name;

    trTimeDate _timeDate;

    ::std::string _updateType;

    ::std::vector< trDeviceData > _devices;

    uint64 _size;

    bool _success;

    uint32 _counterKilometers;

    uint32 _index;

};

/**
 * If the meaning of "trUpdLogs" isn't clear, then there should be a description here.
 */
class trUpdLogs {
public:

    /**
     * Default constructor
     */
    inline  trUpdLogs ();

    /**
     * Copy constructor
     */
    inline  trUpdLogs (const trUpdLogs &rhs);

    /**
     * All fields constructor
     */
    inline  trUpdLogs (const ::std::vector< trUpdLog >& updateLogs_);

    /**
     * Destructor
     */
    inline  ~trUpdLogs();

    /**
     * Assignment operator
     */
    inline trUpdLogs& operator = (const trUpdLogs& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const trUpdLogs& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const trUpdLogs& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const trUpdLogs& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const trUpdLogs& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "updateLogs"

    static const int kUpdateLogs = 0;

    /**
     * Clears the field "updateLogs".
     *
     * The field will be set to its default value. The hasUpdateLogs()
     * method will return false.
     */
    inline void clearUpdateLogs();

    /**
     * Checks whether the field "updateLogs" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setUpdateLogs()). Otherwise it will return false.
     */
    inline bool hasUpdateLogs () const;

    /**
     * Returns the value of the member "updateLogs".
     *
     * If the meaning of "updateLogs" isn't clear, then there should be a description here.
     *
     * @return The value of the field "updateLogs"
     */
    inline const ::std::vector< trUpdLog >& getUpdateLogs () const;

    /**
     * Retrieves the value of the field "updateLogs" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "updateLogs".
     */
    inline ::std::vector< trUpdLog >& getUpdateLogsMutable ();

    /**
     * Sets the value of the member "updateLogs".
     *
     * If the meaning of "updateLogs" isn't clear, then there should be a description here.
     *
     * @param updateLogs The value which will be set
     */
    inline void setUpdateLogs (const ::std::vector< trUpdLog >& updateLogs_);

    static const trUpdLogs &getDefaultInstance();

private:

    static const ::std::vector< trUpdLog >& getTrUpdLogList_DefaultInstance ();

    inline void set_has_updateLogs ();

    inline void clear_has_updateLogs ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< trUpdLog > _updateLogs;

};

/**
 * If the meaning of "trUpdateMedia" isn't clear, then there should be a description here.
 */
class trUpdateMedia {
public:

    /**
     * Default constructor
     */
    inline  trUpdateMedia ();

    /**
     * Copy constructor
     */
    inline  trUpdateMedia (const trUpdateMedia &rhs);

    /**
     * All fields constructor
     */
    inline  trUpdateMedia (bool bCustomerMediaPresent_);

    /**
     * Destructor
     */
    inline  ~trUpdateMedia();

    /**
     * Assignment operator
     */
    inline trUpdateMedia& operator = (const trUpdateMedia& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const trUpdateMedia& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const trUpdateMedia& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const trUpdateMedia& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const trUpdateMedia& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bCustomerMediaPresent"

    static const int kBCustomerMediaPresent = 0;

    /**
     * Clears the field "bCustomerMediaPresent".
     *
     * The field will be set to its default value. The hasBCustomerMediaPresent()
     * method will return false.
     */
    inline void clearBCustomerMediaPresent();

    /**
     * Checks whether the field "bCustomerMediaPresent" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBCustomerMediaPresent()). Otherwise it will return false.
     */
    inline bool hasBCustomerMediaPresent () const;

    /**
     * Returns the value of the member "bCustomerMediaPresent".
     *
     * If the meaning of "bCustomerMediaPresent" isn't clear, then there should be a description here.
     *
     * @return The value of the field "bCustomerMediaPresent"
     */
    inline bool getBCustomerMediaPresent () const;

    /**
     * Sets the value of the member "bCustomerMediaPresent".
     *
     * If the meaning of "bCustomerMediaPresent" isn't clear, then there should be a description here.
     *
     * @param bCustomerMediaPresent The value which will be set
     */
    inline void setBCustomerMediaPresent (bool bCustomerMediaPresent_);

    static const trUpdateMedia &getDefaultInstance();

private:

    inline void set_has_bCustomerMediaPresent ();

    inline void clear_has_bCustomerMediaPresent ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _bCustomerMediaPresent;

};

/**
 * If the meaning of "trVersionBackDocInfo" isn't clear, then there should be a description here.
 */
class trVersionBackDocInfo {
public:

    /**
     * Default constructor
     */
    inline  trVersionBackDocInfo ();

    /**
     * Copy constructor
     */
    inline  trVersionBackDocInfo (const trVersionBackDocInfo &rhs);

    /**
     * All fields constructor
     */
    inline  trVersionBackDocInfo (uint16 u16Key_, bool ackOk_);

    /**
     * Destructor
     */
    inline  ~trVersionBackDocInfo();

    /**
     * Assignment operator
     */
    inline trVersionBackDocInfo& operator = (const trVersionBackDocInfo& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const trVersionBackDocInfo& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const trVersionBackDocInfo& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const trVersionBackDocInfo& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const trVersionBackDocInfo& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u16Key"

    static const int kU16Key = 0;

    /**
     * Clears the field "u16Key".
     *
     * The field will be set to its default value. The hasU16Key()
     * method will return false.
     */
    inline void clearU16Key();

    /**
     * Checks whether the field "u16Key" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16Key()). Otherwise it will return false.
     */
    inline bool hasU16Key () const;

    /**
     * Returns the value of the member "u16Key".
     *
     * If the meaning of "u16Key" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u16Key"
     */
    inline uint16 getU16Key () const;

    /**
     * Sets the value of the member "u16Key".
     *
     * If the meaning of "u16Key" isn't clear, then there should be a description here.
     *
     * @param u16Key The value which will be set
     */
    inline void setU16Key (uint16 u16Key_);

    // API of field "ackOk"

    static const int kAckOk = 1;

    /**
     * Clears the field "ackOk".
     *
     * The field will be set to its default value. The hasAckOk()
     * method will return false.
     */
    inline void clearAckOk();

    /**
     * Checks whether the field "ackOk" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAckOk()). Otherwise it will return false.
     */
    inline bool hasAckOk () const;

    /**
     * Returns the value of the member "ackOk".
     *
     * If the meaning of "ackOk" isn't clear, then there should be a description here.
     *
     * @return The value of the field "ackOk"
     */
    inline bool getAckOk () const;

    /**
     * Sets the value of the member "ackOk".
     *
     * If the meaning of "ackOk" isn't clear, then there should be a description here.
     *
     * @param ackOk The value which will be set
     */
    inline void setAckOk (bool ackOk_);

    static const trVersionBackDocInfo &getDefaultInstance();

private:

    inline void set_has_u16Key ();

    inline void clear_has_u16Key ();

    inline void set_has_ackOk ();

    inline void clear_has_ackOk ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint16 _u16Key;

    bool _ackOk;

};

/**
 * If the meaning of "trCustomerUpdate" isn't clear, then there should be a description here.
 */
class trCustomerUpdate {
public:

    /**
     * Default constructor
     */
    inline  trCustomerUpdate ();

    /**
     * Copy constructor
     */
    inline  trCustomerUpdate (const trCustomerUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  trCustomerUpdate (const ::std::string& device_, const ::std::string& name_, const ::std::string& vers_, bool bOk_);

    /**
     * Destructor
     */
    inline  ~trCustomerUpdate();

    /**
     * Assignment operator
     */
    inline trCustomerUpdate& operator = (const trCustomerUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const trCustomerUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const trCustomerUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const trCustomerUpdate& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const trCustomerUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "device"

    static const int kDevice = 0;

    /**
     * Clears the field "device".
     *
     * The field will be set to its default value. The hasDevice()
     * method will return false.
     */
    inline void clearDevice();

    /**
     * Checks whether the field "device" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDevice()). Otherwise it will return false.
     */
    inline bool hasDevice () const;

    /**
     * Returns the value of the member "device".
     *
     * If the meaning of "device" isn't clear, then there should be a description here.
     *
     * @return The value of the field "device"
     */
    inline const ::std::string& getDevice () const;

    /**
     * Retrieves the value of the field "device" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "device".
     */
    inline ::std::string& getDeviceMutable ();

    /**
     * Sets the value of the member "device".
     *
     * If the meaning of "device" isn't clear, then there should be a description here.
     *
     * @param device The value which will be set
     */
    inline void setDevice (const ::std::string& device_);

    /**
     * Sets the value of the member "device".
     *
     * If the meaning of "device" isn't clear, then there should be a description here.
     *
     * @param device The value which will be set
     */
    inline void setDevice (const char* device_);

    /**
     * Sets the value of the member "device".
     *
     * If the meaning of "device" isn't clear, then there should be a description here.
     *
     * @param device The value which will be set
     */
    inline void setDevice (const char* value, size_t size);

    // API of field "name"

    static const int kName = 1;

    /**
     * Clears the field "name".
     *
     * The field will be set to its default value. The hasName()
     * method will return false.
     */
    inline void clearName();

    /**
     * Checks whether the field "name" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setName()). Otherwise it will return false.
     */
    inline bool hasName () const;

    /**
     * Returns the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @return The value of the field "name"
     */
    inline const ::std::string& getName () const;

    /**
     * Retrieves the value of the field "name" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "name".
     */
    inline ::std::string& getNameMutable ();

    /**
     * Sets the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param name The value which will be set
     */
    inline void setName (const ::std::string& name_);

    /**
     * Sets the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param name The value which will be set
     */
    inline void setName (const char* name_);

    /**
     * Sets the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param name The value which will be set
     */
    inline void setName (const char* value, size_t size);

    // API of field "vers"

    static const int kVers = 2;

    /**
     * Clears the field "vers".
     *
     * The field will be set to its default value. The hasVers()
     * method will return false.
     */
    inline void clearVers();

    /**
     * Checks whether the field "vers" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setVers()). Otherwise it will return false.
     */
    inline bool hasVers () const;

    /**
     * Returns the value of the member "vers".
     *
     * If the meaning of "vers" isn't clear, then there should be a description here.
     *
     * @return The value of the field "vers"
     */
    inline const ::std::string& getVers () const;

    /**
     * Retrieves the value of the field "vers" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "vers".
     */
    inline ::std::string& getVersMutable ();

    /**
     * Sets the value of the member "vers".
     *
     * If the meaning of "vers" isn't clear, then there should be a description here.
     *
     * @param vers The value which will be set
     */
    inline void setVers (const ::std::string& vers_);

    /**
     * Sets the value of the member "vers".
     *
     * If the meaning of "vers" isn't clear, then there should be a description here.
     *
     * @param vers The value which will be set
     */
    inline void setVers (const char* vers_);

    /**
     * Sets the value of the member "vers".
     *
     * If the meaning of "vers" isn't clear, then there should be a description here.
     *
     * @param vers The value which will be set
     */
    inline void setVers (const char* value, size_t size);

    // API of field "bOk"

    static const int kBOk = 3;

    /**
     * Clears the field "bOk".
     *
     * The field will be set to its default value. The hasBOk()
     * method will return false.
     */
    inline void clearBOk();

    /**
     * Checks whether the field "bOk" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBOk()). Otherwise it will return false.
     */
    inline bool hasBOk () const;

    /**
     * Returns the value of the member "bOk".
     *
     * If the meaning of "bOk" isn't clear, then there should be a description here.
     *
     * @return The value of the field "bOk"
     */
    inline bool getBOk () const;

    /**
     * Sets the value of the member "bOk".
     *
     * If the meaning of "bOk" isn't clear, then there should be a description here.
     *
     * @param bOk The value which will be set
     */
    inline void setBOk (bool bOk_);

    static const trCustomerUpdate &getDefaultInstance();

private:

    inline void set_has_device ();

    inline void clear_has_device ();

    inline void set_has_name ();

    inline void clear_has_name ();

    inline void set_has_vers ();

    inline void clear_has_vers ();

    inline void set_has_bOk ();

    inline void clear_has_bOk ();

    uint32 _has_bits_[ (4 + 31) / 32];

    ::std::string _device;

    ::std::string _name;

    ::std::string _vers;

    bool _bOk;

};

/**
 * If the meaning of "trAvailableCustomerUpdates" isn't clear, then there should be a description here.
 */
class trAvailableCustomerUpdates {
public:

    /**
     * Default constructor
     */
    inline  trAvailableCustomerUpdates ();

    /**
     * Copy constructor
     */
    inline  trAvailableCustomerUpdates (const trAvailableCustomerUpdates &rhs);

    /**
     * All fields constructor
     */
    inline  trAvailableCustomerUpdates (tenErrorId enErrorId_, const ::std::vector< trCustomerUpdate >& updates_);

    /**
     * Destructor
     */
    inline  ~trAvailableCustomerUpdates();

    /**
     * Assignment operator
     */
    inline trAvailableCustomerUpdates& operator = (const trAvailableCustomerUpdates& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const trAvailableCustomerUpdates& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const trAvailableCustomerUpdates& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const trAvailableCustomerUpdates& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const trAvailableCustomerUpdates& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "enErrorId"

    static const int kEnErrorId = 0;

    /**
     * Clears the field "enErrorId".
     *
     * The field will be set to its default value. The hasEnErrorId()
     * method will return false.
     */
    inline void clearEnErrorId();

    /**
     * Checks whether the field "enErrorId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEnErrorId()). Otherwise it will return false.
     */
    inline bool hasEnErrorId () const;

    /**
     * Returns the value of the member "enErrorId".
     *
     * If the meaning of "enErrorId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "enErrorId"
     */
    inline tenErrorId getEnErrorId () const;

    /**
     * Sets the value of the member "enErrorId".
     *
     * If the meaning of "enErrorId" isn't clear, then there should be a description here.
     *
     * @param enErrorId The value which will be set
     */
    inline void setEnErrorId (tenErrorId enErrorId_);

    // API of field "updates"

    static const int kUpdates = 1;

    /**
     * Clears the field "updates".
     *
     * The field will be set to its default value. The hasUpdates()
     * method will return false.
     */
    inline void clearUpdates();

    /**
     * Checks whether the field "updates" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setUpdates()). Otherwise it will return false.
     */
    inline bool hasUpdates () const;

    /**
     * Returns the value of the member "updates".
     *
     * If the meaning of "updates" isn't clear, then there should be a description here.
     *
     * @return The value of the field "updates"
     */
    inline const ::std::vector< trCustomerUpdate >& getUpdates () const;

    /**
     * Retrieves the value of the field "updates" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "updates".
     */
    inline ::std::vector< trCustomerUpdate >& getUpdatesMutable ();

    /**
     * Sets the value of the member "updates".
     *
     * If the meaning of "updates" isn't clear, then there should be a description here.
     *
     * @param updates The value which will be set
     */
    inline void setUpdates (const ::std::vector< trCustomerUpdate >& updates_);

    static const trAvailableCustomerUpdates &getDefaultInstance();

private:

    static const ::std::vector< trCustomerUpdate >& getTrCustomerUpdateList_DefaultInstance ();

    inline void set_has_enErrorId ();

    inline void clear_has_enErrorId ();

    inline void set_has_updates ();

    inline void clear_has_updates ();

    uint32 _has_bits_[ (2 + 31) / 32];

    tenErrorId _enErrorId;

    ::std::vector< trCustomerUpdate > _updates;

};

/**
 * If the meaning of "trInstalledCustomerUpdates" isn't clear, then there should be a description here.
 */
class trInstalledCustomerUpdates {
public:

    /**
     * Default constructor
     */
    inline  trInstalledCustomerUpdates ();

    /**
     * Copy constructor
     */
    inline  trInstalledCustomerUpdates (const trInstalledCustomerUpdates &rhs);

    /**
     * All fields constructor
     */
    inline  trInstalledCustomerUpdates (bool bUpdateExists_, bool bHasFailedUpdate_, const ::std::vector< trCustomerUpdate >& updates_);

    /**
     * Destructor
     */
    inline  ~trInstalledCustomerUpdates();

    /**
     * Assignment operator
     */
    inline trInstalledCustomerUpdates& operator = (const trInstalledCustomerUpdates& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const trInstalledCustomerUpdates& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const trInstalledCustomerUpdates& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const trInstalledCustomerUpdates& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const trInstalledCustomerUpdates& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bUpdateExists"

    static const int kBUpdateExists = 0;

    /**
     * Clears the field "bUpdateExists".
     *
     * The field will be set to its default value. The hasBUpdateExists()
     * method will return false.
     */
    inline void clearBUpdateExists();

    /**
     * Checks whether the field "bUpdateExists" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBUpdateExists()). Otherwise it will return false.
     */
    inline bool hasBUpdateExists () const;

    /**
     * Returns the value of the member "bUpdateExists".
     *
     * If the meaning of "bUpdateExists" isn't clear, then there should be a description here.
     *
     * @return The value of the field "bUpdateExists"
     */
    inline bool getBUpdateExists () const;

    /**
     * Sets the value of the member "bUpdateExists".
     *
     * If the meaning of "bUpdateExists" isn't clear, then there should be a description here.
     *
     * @param bUpdateExists The value which will be set
     */
    inline void setBUpdateExists (bool bUpdateExists_);

    // API of field "bHasFailedUpdate"

    static const int kBHasFailedUpdate = 1;

    /**
     * Clears the field "bHasFailedUpdate".
     *
     * The field will be set to its default value. The hasBHasFailedUpdate()
     * method will return false.
     */
    inline void clearBHasFailedUpdate();

    /**
     * Checks whether the field "bHasFailedUpdate" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBHasFailedUpdate()). Otherwise it will return false.
     */
    inline bool hasBHasFailedUpdate () const;

    /**
     * Returns the value of the member "bHasFailedUpdate".
     *
     * If the meaning of "bHasFailedUpdate" isn't clear, then there should be a description here.
     *
     * @return The value of the field "bHasFailedUpdate"
     */
    inline bool getBHasFailedUpdate () const;

    /**
     * Sets the value of the member "bHasFailedUpdate".
     *
     * If the meaning of "bHasFailedUpdate" isn't clear, then there should be a description here.
     *
     * @param bHasFailedUpdate The value which will be set
     */
    inline void setBHasFailedUpdate (bool bHasFailedUpdate_);

    // API of field "updates"

    static const int kUpdates = 2;

    /**
     * Clears the field "updates".
     *
     * The field will be set to its default value. The hasUpdates()
     * method will return false.
     */
    inline void clearUpdates();

    /**
     * Checks whether the field "updates" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setUpdates()). Otherwise it will return false.
     */
    inline bool hasUpdates () const;

    /**
     * Returns the value of the member "updates".
     *
     * If the meaning of "updates" isn't clear, then there should be a description here.
     *
     * @return The value of the field "updates"
     */
    inline const ::std::vector< trCustomerUpdate >& getUpdates () const;

    /**
     * Retrieves the value of the field "updates" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "updates".
     */
    inline ::std::vector< trCustomerUpdate >& getUpdatesMutable ();

    /**
     * Sets the value of the member "updates".
     *
     * If the meaning of "updates" isn't clear, then there should be a description here.
     *
     * @param updates The value which will be set
     */
    inline void setUpdates (const ::std::vector< trCustomerUpdate >& updates_);

    static const trInstalledCustomerUpdates &getDefaultInstance();

private:

    static const ::std::vector< trCustomerUpdate >& getTrCustomerUpdateList_DefaultInstance ();

    inline void set_has_bUpdateExists ();

    inline void clear_has_bUpdateExists ();

    inline void set_has_bHasFailedUpdate ();

    inline void clear_has_bHasFailedUpdate ();

    inline void set_has_updates ();

    inline void clear_has_updates ();

    uint32 _has_bits_[ (3 + 31) / 32];

    bool _bUpdateExists;

    bool _bHasFailedUpdate;

    ::std::vector< trCustomerUpdate > _updates;

};

/**
 * If the meaning of "trCustomerUpdates" isn't clear, then there should be a description here.
 */
class trCustomerUpdates {
public:

    /**
     * Default constructor
     */
    inline  trCustomerUpdates ();

    /**
     * Copy constructor
     */
    inline  trCustomerUpdates (const trCustomerUpdates &rhs);

    /**
     * All fields constructor
     */
    inline  trCustomerUpdates (const ::std::vector< trCustomerUpdate >& updates_);

    /**
     * Destructor
     */
    inline  ~trCustomerUpdates();

    /**
     * Assignment operator
     */
    inline trCustomerUpdates& operator = (const trCustomerUpdates& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const trCustomerUpdates& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const trCustomerUpdates& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const trCustomerUpdates& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const trCustomerUpdates& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "updates"

    static const int kUpdates = 0;

    /**
     * Clears the field "updates".
     *
     * The field will be set to its default value. The hasUpdates()
     * method will return false.
     */
    inline void clearUpdates();

    /**
     * Checks whether the field "updates" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setUpdates()). Otherwise it will return false.
     */
    inline bool hasUpdates () const;

    /**
     * Returns the value of the member "updates".
     *
     * If the meaning of "updates" isn't clear, then there should be a description here.
     *
     * @return The value of the field "updates"
     */
    inline const ::std::vector< trCustomerUpdate >& getUpdates () const;

    /**
     * Retrieves the value of the field "updates" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "updates".
     */
    inline ::std::vector< trCustomerUpdate >& getUpdatesMutable ();

    /**
     * Sets the value of the member "updates".
     *
     * If the meaning of "updates" isn't clear, then there should be a description here.
     *
     * @param updates The value which will be set
     */
    inline void setUpdates (const ::std::vector< trCustomerUpdate >& updates_);

    static const trCustomerUpdates &getDefaultInstance();

private:

    static const ::std::vector< trCustomerUpdate >& getTrCustomerUpdateList_DefaultInstance ();

    inline void set_has_updates ();

    inline void clear_has_updates ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< trCustomerUpdate > _updates;

};

/**
 * If the meaning of "trBgImageInfo" isn't clear, then there should be a description here.
 */
class trBgImageInfo {
public:

    /**
     * Default constructor
     */
    inline  trBgImageInfo ();

    /**
     * Copy constructor
     */
    inline  trBgImageInfo (const trBgImageInfo &rhs);

    /**
     * All fields constructor
     */
    inline  trBgImageInfo (const ::std::string& imgDirPath_, const ::std::string& imgName_);

    /**
     * Destructor
     */
    inline  ~trBgImageInfo();

    /**
     * Assignment operator
     */
    inline trBgImageInfo& operator = (const trBgImageInfo& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const trBgImageInfo& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const trBgImageInfo& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const trBgImageInfo& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const trBgImageInfo& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "imgDirPath"

    static const int kImgDirPath = 0;

    /**
     * Clears the field "imgDirPath".
     *
     * The field will be set to its default value. The hasImgDirPath()
     * method will return false.
     */
    inline void clearImgDirPath();

    /**
     * Checks whether the field "imgDirPath" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setImgDirPath()). Otherwise it will return false.
     */
    inline bool hasImgDirPath () const;

    /**
     * Returns the value of the member "imgDirPath".
     *
     * If the meaning of "imgDirPath" isn't clear, then there should be a description here.
     *
     * @return The value of the field "imgDirPath"
     */
    inline const ::std::string& getImgDirPath () const;

    /**
     * Retrieves the value of the field "imgDirPath" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "imgDirPath".
     */
    inline ::std::string& getImgDirPathMutable ();

    /**
     * Sets the value of the member "imgDirPath".
     *
     * If the meaning of "imgDirPath" isn't clear, then there should be a description here.
     *
     * @param imgDirPath The value which will be set
     */
    inline void setImgDirPath (const ::std::string& imgDirPath_);

    /**
     * Sets the value of the member "imgDirPath".
     *
     * If the meaning of "imgDirPath" isn't clear, then there should be a description here.
     *
     * @param imgDirPath The value which will be set
     */
    inline void setImgDirPath (const char* imgDirPath_);

    /**
     * Sets the value of the member "imgDirPath".
     *
     * If the meaning of "imgDirPath" isn't clear, then there should be a description here.
     *
     * @param imgDirPath The value which will be set
     */
    inline void setImgDirPath (const char* value, size_t size);

    // API of field "imgName"

    static const int kImgName = 1;

    /**
     * Clears the field "imgName".
     *
     * The field will be set to its default value. The hasImgName()
     * method will return false.
     */
    inline void clearImgName();

    /**
     * Checks whether the field "imgName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setImgName()). Otherwise it will return false.
     */
    inline bool hasImgName () const;

    /**
     * Returns the value of the member "imgName".
     *
     * If the meaning of "imgName" isn't clear, then there should be a description here.
     *
     * @return The value of the field "imgName"
     */
    inline const ::std::string& getImgName () const;

    /**
     * Retrieves the value of the field "imgName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "imgName".
     */
    inline ::std::string& getImgNameMutable ();

    /**
     * Sets the value of the member "imgName".
     *
     * If the meaning of "imgName" isn't clear, then there should be a description here.
     *
     * @param imgName The value which will be set
     */
    inline void setImgName (const ::std::string& imgName_);

    /**
     * Sets the value of the member "imgName".
     *
     * If the meaning of "imgName" isn't clear, then there should be a description here.
     *
     * @param imgName The value which will be set
     */
    inline void setImgName (const char* imgName_);

    /**
     * Sets the value of the member "imgName".
     *
     * If the meaning of "imgName" isn't clear, then there should be a description here.
     *
     * @param imgName The value which will be set
     */
    inline void setImgName (const char* value, size_t size);

    static const trBgImageInfo &getDefaultInstance();

private:

    inline void set_has_imgDirPath ();

    inline void clear_has_imgDirPath ();

    inline void set_has_imgName ();

    inline void clear_has_imgName ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _imgDirPath;

    ::std::string _imgName;

};

/**
 * If the meaning of "trFontInfo" isn't clear, then there should be a description here.
 */
class trFontInfo {
public:

    /**
     * Default constructor
     */
    inline  trFontInfo ();

    /**
     * Copy constructor
     */
    inline  trFontInfo (const trFontInfo &rhs);

    /**
     * All fields constructor
     */
    inline  trFontInfo (const ::std::string& fontName_, const ::std::string& fontSrcLocation_, const ::std::string& checkSum_);

    /**
     * Destructor
     */
    inline  ~trFontInfo();

    /**
     * Assignment operator
     */
    inline trFontInfo& operator = (const trFontInfo& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const trFontInfo& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const trFontInfo& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const trFontInfo& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const trFontInfo& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "fontName"

    static const int kFontName = 0;

    /**
     * Clears the field "fontName".
     *
     * The field will be set to its default value. The hasFontName()
     * method will return false.
     */
    inline void clearFontName();

    /**
     * Checks whether the field "fontName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFontName()). Otherwise it will return false.
     */
    inline bool hasFontName () const;

    /**
     * Returns the value of the member "fontName".
     *
     * If the meaning of "fontName" isn't clear, then there should be a description here.
     *
     * @return The value of the field "fontName"
     */
    inline const ::std::string& getFontName () const;

    /**
     * Retrieves the value of the field "fontName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "fontName".
     */
    inline ::std::string& getFontNameMutable ();

    /**
     * Sets the value of the member "fontName".
     *
     * If the meaning of "fontName" isn't clear, then there should be a description here.
     *
     * @param fontName The value which will be set
     */
    inline void setFontName (const ::std::string& fontName_);

    /**
     * Sets the value of the member "fontName".
     *
     * If the meaning of "fontName" isn't clear, then there should be a description here.
     *
     * @param fontName The value which will be set
     */
    inline void setFontName (const char* fontName_);

    /**
     * Sets the value of the member "fontName".
     *
     * If the meaning of "fontName" isn't clear, then there should be a description here.
     *
     * @param fontName The value which will be set
     */
    inline void setFontName (const char* value, size_t size);

    // API of field "fontSrcLocation"

    static const int kFontSrcLocation = 1;

    /**
     * Clears the field "fontSrcLocation".
     *
     * The field will be set to its default value. The hasFontSrcLocation()
     * method will return false.
     */
    inline void clearFontSrcLocation();

    /**
     * Checks whether the field "fontSrcLocation" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFontSrcLocation()). Otherwise it will return false.
     */
    inline bool hasFontSrcLocation () const;

    /**
     * Returns the value of the member "fontSrcLocation".
     *
     * If the meaning of "fontSrcLocation" isn't clear, then there should be a description here.
     *
     * @return The value of the field "fontSrcLocation"
     */
    inline const ::std::string& getFontSrcLocation () const;

    /**
     * Retrieves the value of the field "fontSrcLocation" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "fontSrcLocation".
     */
    inline ::std::string& getFontSrcLocationMutable ();

    /**
     * Sets the value of the member "fontSrcLocation".
     *
     * If the meaning of "fontSrcLocation" isn't clear, then there should be a description here.
     *
     * @param fontSrcLocation The value which will be set
     */
    inline void setFontSrcLocation (const ::std::string& fontSrcLocation_);

    /**
     * Sets the value of the member "fontSrcLocation".
     *
     * If the meaning of "fontSrcLocation" isn't clear, then there should be a description here.
     *
     * @param fontSrcLocation The value which will be set
     */
    inline void setFontSrcLocation (const char* fontSrcLocation_);

    /**
     * Sets the value of the member "fontSrcLocation".
     *
     * If the meaning of "fontSrcLocation" isn't clear, then there should be a description here.
     *
     * @param fontSrcLocation The value which will be set
     */
    inline void setFontSrcLocation (const char* value, size_t size);

    // API of field "checkSum"

    static const int kCheckSum = 2;

    /**
     * Clears the field "checkSum".
     *
     * The field will be set to its default value. The hasCheckSum()
     * method will return false.
     */
    inline void clearCheckSum();

    /**
     * Checks whether the field "checkSum" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCheckSum()). Otherwise it will return false.
     */
    inline bool hasCheckSum () const;

    /**
     * Returns the value of the member "checkSum".
     *
     * If the meaning of "checkSum" isn't clear, then there should be a description here.
     *
     * @return The value of the field "checkSum"
     */
    inline const ::std::string& getCheckSum () const;

    /**
     * Retrieves the value of the field "checkSum" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "checkSum".
     */
    inline ::std::string& getCheckSumMutable ();

    /**
     * Sets the value of the member "checkSum".
     *
     * If the meaning of "checkSum" isn't clear, then there should be a description here.
     *
     * @param checkSum The value which will be set
     */
    inline void setCheckSum (const ::std::string& checkSum_);

    /**
     * Sets the value of the member "checkSum".
     *
     * If the meaning of "checkSum" isn't clear, then there should be a description here.
     *
     * @param checkSum The value which will be set
     */
    inline void setCheckSum (const char* checkSum_);

    /**
     * Sets the value of the member "checkSum".
     *
     * If the meaning of "checkSum" isn't clear, then there should be a description here.
     *
     * @param checkSum The value which will be set
     */
    inline void setCheckSum (const char* value, size_t size);

    static const trFontInfo &getDefaultInstance();

private:

    inline void set_has_fontName ();

    inline void clear_has_fontName ();

    inline void set_has_fontSrcLocation ();

    inline void clear_has_fontSrcLocation ();

    inline void set_has_checkSum ();

    inline void clear_has_checkSum ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::std::string _fontName;

    ::std::string _fontSrcLocation;

    ::std::string _checkSum;

};

/**
 * If the meaning of "trDisplayVariant" isn't clear, then there should be a description here.
 */
class trDisplayVariant {
public:

    /**
     * Default constructor
     */
    inline  trDisplayVariant ();

    /**
     * Copy constructor
     */
    inline  trDisplayVariant (const trDisplayVariant &rhs);

    /**
     * All fields constructor
     */
    inline  trDisplayVariant (tenDisplayVariant enDisplayVariant_, uint32 width_, uint32 height_, const ::std::string& aspectRatio_);

    /**
     * Destructor
     */
    inline  ~trDisplayVariant();

    /**
     * Assignment operator
     */
    inline trDisplayVariant& operator = (const trDisplayVariant& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const trDisplayVariant& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const trDisplayVariant& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const trDisplayVariant& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const trDisplayVariant& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "enDisplayVariant"

    static const int kEnDisplayVariant = 0;

    /**
     * Clears the field "enDisplayVariant".
     *
     * The field will be set to its default value. The hasEnDisplayVariant()
     * method will return false.
     */
    inline void clearEnDisplayVariant();

    /**
     * Checks whether the field "enDisplayVariant" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEnDisplayVariant()). Otherwise it will return false.
     */
    inline bool hasEnDisplayVariant () const;

    /**
     * Returns the value of the member "enDisplayVariant".
     *
     * If the meaning of "enDisplayVariant" isn't clear, then there should be a description here.
     *
     * @return The value of the field "enDisplayVariant"
     */
    inline tenDisplayVariant getEnDisplayVariant () const;

    /**
     * Sets the value of the member "enDisplayVariant".
     *
     * If the meaning of "enDisplayVariant" isn't clear, then there should be a description here.
     *
     * @param enDisplayVariant The value which will be set
     */
    inline void setEnDisplayVariant (tenDisplayVariant enDisplayVariant_);

    // API of field "width"

    static const int kWidth = 1;

    /**
     * Clears the field "width".
     *
     * The field will be set to its default value. The hasWidth()
     * method will return false.
     */
    inline void clearWidth();

    /**
     * Checks whether the field "width" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setWidth()). Otherwise it will return false.
     */
    inline bool hasWidth () const;

    /**
     * Returns the value of the member "width".
     *
     * If the meaning of "width" isn't clear, then there should be a description here.
     *
     * @return The value of the field "width"
     */
    inline uint32 getWidth () const;

    /**
     * Sets the value of the member "width".
     *
     * If the meaning of "width" isn't clear, then there should be a description here.
     *
     * @param width The value which will be set
     */
    inline void setWidth (uint32 width_);

    // API of field "height"

    static const int kHeight = 2;

    /**
     * Clears the field "height".
     *
     * The field will be set to its default value. The hasHeight()
     * method will return false.
     */
    inline void clearHeight();

    /**
     * Checks whether the field "height" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setHeight()). Otherwise it will return false.
     */
    inline bool hasHeight () const;

    /**
     * Returns the value of the member "height".
     *
     * If the meaning of "height" isn't clear, then there should be a description here.
     *
     * @return The value of the field "height"
     */
    inline uint32 getHeight () const;

    /**
     * Sets the value of the member "height".
     *
     * If the meaning of "height" isn't clear, then there should be a description here.
     *
     * @param height The value which will be set
     */
    inline void setHeight (uint32 height_);

    // API of field "aspectRatio"

    static const int kAspectRatio = 3;

    /**
     * Clears the field "aspectRatio".
     *
     * The field will be set to its default value. The hasAspectRatio()
     * method will return false.
     */
    inline void clearAspectRatio();

    /**
     * Checks whether the field "aspectRatio" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAspectRatio()). Otherwise it will return false.
     */
    inline bool hasAspectRatio () const;

    /**
     * Returns the value of the member "aspectRatio".
     *
     * If the meaning of "aspectRatio" isn't clear, then there should be a description here.
     *
     * @return The value of the field "aspectRatio"
     */
    inline const ::std::string& getAspectRatio () const;

    /**
     * Retrieves the value of the field "aspectRatio" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "aspectRatio".
     */
    inline ::std::string& getAspectRatioMutable ();

    /**
     * Sets the value of the member "aspectRatio".
     *
     * If the meaning of "aspectRatio" isn't clear, then there should be a description here.
     *
     * @param aspectRatio The value which will be set
     */
    inline void setAspectRatio (const ::std::string& aspectRatio_);

    /**
     * Sets the value of the member "aspectRatio".
     *
     * If the meaning of "aspectRatio" isn't clear, then there should be a description here.
     *
     * @param aspectRatio The value which will be set
     */
    inline void setAspectRatio (const char* aspectRatio_);

    /**
     * Sets the value of the member "aspectRatio".
     *
     * If the meaning of "aspectRatio" isn't clear, then there should be a description here.
     *
     * @param aspectRatio The value which will be set
     */
    inline void setAspectRatio (const char* value, size_t size);

    static const trDisplayVariant &getDefaultInstance();

private:

    inline void set_has_enDisplayVariant ();

    inline void clear_has_enDisplayVariant ();

    inline void set_has_width ();

    inline void clear_has_width ();

    inline void set_has_height ();

    inline void clear_has_height ();

    inline void set_has_aspectRatio ();

    inline void clear_has_aspectRatio ();

    uint32 _has_bits_[ (4 + 31) / 32];

    tenDisplayVariant _enDisplayVariant;

    uint32 _width;

    uint32 _height;

    ::std::string _aspectRatio;

};

/**
 * If the meaning of "trVerifyChecksumResult" isn't clear, then there should be a description here.
 */
class trVerifyChecksumResult {
public:

    /**
     * Default constructor
     */
    inline  trVerifyChecksumResult ();

    /**
     * Copy constructor
     */
    inline  trVerifyChecksumResult (const trVerifyChecksumResult &rhs);

    /**
     * All fields constructor
     */
    inline  trVerifyChecksumResult (tenVerifyType enType_, const ::std::string& area_, const ::std::string& checksum_, tenVerifyResult enResult_);

    /**
     * Destructor
     */
    inline  ~trVerifyChecksumResult();

    /**
     * Assignment operator
     */
    inline trVerifyChecksumResult& operator = (const trVerifyChecksumResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const trVerifyChecksumResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const trVerifyChecksumResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const trVerifyChecksumResult& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const trVerifyChecksumResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "enType"

    static const int kEnType = 0;

    /**
     * Clears the field "enType".
     *
     * The field will be set to its default value. The hasEnType()
     * method will return false.
     */
    inline void clearEnType();

    /**
     * Checks whether the field "enType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEnType()). Otherwise it will return false.
     */
    inline bool hasEnType () const;

    /**
     * Returns the value of the member "enType".
     *
     * If the meaning of "enType" isn't clear, then there should be a description here.
     *
     * @return The value of the field "enType"
     */
    inline tenVerifyType getEnType () const;

    /**
     * Sets the value of the member "enType".
     *
     * If the meaning of "enType" isn't clear, then there should be a description here.
     *
     * @param enType The value which will be set
     */
    inline void setEnType (tenVerifyType enType_);

    // API of field "area"

    static const int kArea = 1;

    /**
     * Clears the field "area".
     *
     * The field will be set to its default value. The hasArea()
     * method will return false.
     */
    inline void clearArea();

    /**
     * Checks whether the field "area" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setArea()). Otherwise it will return false.
     */
    inline bool hasArea () const;

    /**
     * Returns the value of the member "area".
     *
     * If the meaning of "area" isn't clear, then there should be a description here.
     *
     * @return The value of the field "area"
     */
    inline const ::std::string& getArea () const;

    /**
     * Retrieves the value of the field "area" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "area".
     */
    inline ::std::string& getAreaMutable ();

    /**
     * Sets the value of the member "area".
     *
     * If the meaning of "area" isn't clear, then there should be a description here.
     *
     * @param area The value which will be set
     */
    inline void setArea (const ::std::string& area_);

    /**
     * Sets the value of the member "area".
     *
     * If the meaning of "area" isn't clear, then there should be a description here.
     *
     * @param area The value which will be set
     */
    inline void setArea (const char* area_);

    /**
     * Sets the value of the member "area".
     *
     * If the meaning of "area" isn't clear, then there should be a description here.
     *
     * @param area The value which will be set
     */
    inline void setArea (const char* value, size_t size);

    // API of field "checksum"

    static const int kChecksum = 2;

    /**
     * Clears the field "checksum".
     *
     * The field will be set to its default value. The hasChecksum()
     * method will return false.
     */
    inline void clearChecksum();

    /**
     * Checks whether the field "checksum" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setChecksum()). Otherwise it will return false.
     */
    inline bool hasChecksum () const;

    /**
     * Returns the value of the member "checksum".
     *
     * If the meaning of "checksum" isn't clear, then there should be a description here.
     *
     * @return The value of the field "checksum"
     */
    inline const ::std::string& getChecksum () const;

    /**
     * Retrieves the value of the field "checksum" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "checksum".
     */
    inline ::std::string& getChecksumMutable ();

    /**
     * Sets the value of the member "checksum".
     *
     * If the meaning of "checksum" isn't clear, then there should be a description here.
     *
     * @param checksum The value which will be set
     */
    inline void setChecksum (const ::std::string& checksum_);

    /**
     * Sets the value of the member "checksum".
     *
     * If the meaning of "checksum" isn't clear, then there should be a description here.
     *
     * @param checksum The value which will be set
     */
    inline void setChecksum (const char* checksum_);

    /**
     * Sets the value of the member "checksum".
     *
     * If the meaning of "checksum" isn't clear, then there should be a description here.
     *
     * @param checksum The value which will be set
     */
    inline void setChecksum (const char* value, size_t size);

    // API of field "enResult"

    static const int kEnResult = 3;

    /**
     * Clears the field "enResult".
     *
     * The field will be set to its default value. The hasEnResult()
     * method will return false.
     */
    inline void clearEnResult();

    /**
     * Checks whether the field "enResult" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEnResult()). Otherwise it will return false.
     */
    inline bool hasEnResult () const;

    /**
     * Returns the value of the member "enResult".
     *
     * If the meaning of "enResult" isn't clear, then there should be a description here.
     *
     * @return The value of the field "enResult"
     */
    inline tenVerifyResult getEnResult () const;

    /**
     * Sets the value of the member "enResult".
     *
     * If the meaning of "enResult" isn't clear, then there should be a description here.
     *
     * @param enResult The value which will be set
     */
    inline void setEnResult (tenVerifyResult enResult_);

    static const trVerifyChecksumResult &getDefaultInstance();

private:

    inline void set_has_enType ();

    inline void clear_has_enType ();

    inline void set_has_area ();

    inline void clear_has_area ();

    inline void set_has_checksum ();

    inline void clear_has_checksum ();

    inline void set_has_enResult ();

    inline void clear_has_enResult ();

    uint32 _has_bits_[ (4 + 31) / 32];

    tenVerifyType _enType;

    ::std::string _area;

    ::std::string _checksum;

    tenVerifyResult _enResult;

};

/**
 * If the meaning of "trVerifyChecksumRequest" isn't clear, then there should be a description here.
 */
class trVerifyChecksumRequest {
public:

    /**
     * Default constructor
     */
    inline  trVerifyChecksumRequest ();

    /**
     * Copy constructor
     */
    inline  trVerifyChecksumRequest (const trVerifyChecksumRequest &rhs);

    /**
     * All fields constructor
     */
    inline  trVerifyChecksumRequest (tenVerifyType enVerifyType_, const ::std::string& area_);

    /**
     * Destructor
     */
    inline  ~trVerifyChecksumRequest();

    /**
     * Assignment operator
     */
    inline trVerifyChecksumRequest& operator = (const trVerifyChecksumRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const trVerifyChecksumRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const trVerifyChecksumRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const trVerifyChecksumRequest& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const trVerifyChecksumRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "enVerifyType"

    static const int kEnVerifyType = 0;

    /**
     * Clears the field "enVerifyType".
     *
     * The field will be set to its default value. The hasEnVerifyType()
     * method will return false.
     */
    inline void clearEnVerifyType();

    /**
     * Checks whether the field "enVerifyType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEnVerifyType()). Otherwise it will return false.
     */
    inline bool hasEnVerifyType () const;

    /**
     * Returns the value of the member "enVerifyType".
     *
     * If the meaning of "enVerifyType" isn't clear, then there should be a description here.
     *
     * @return The value of the field "enVerifyType"
     */
    inline tenVerifyType getEnVerifyType () const;

    /**
     * Sets the value of the member "enVerifyType".
     *
     * If the meaning of "enVerifyType" isn't clear, then there should be a description here.
     *
     * @param enVerifyType The value which will be set
     */
    inline void setEnVerifyType (tenVerifyType enVerifyType_);

    // API of field "area"

    static const int kArea = 1;

    /**
     * Clears the field "area".
     *
     * The field will be set to its default value. The hasArea()
     * method will return false.
     */
    inline void clearArea();

    /**
     * Checks whether the field "area" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setArea()). Otherwise it will return false.
     */
    inline bool hasArea () const;

    /**
     * Returns the value of the member "area".
     *
     * If the meaning of "area" isn't clear, then there should be a description here.
     *
     * @return The value of the field "area"
     */
    inline const ::std::string& getArea () const;

    /**
     * Retrieves the value of the field "area" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "area".
     */
    inline ::std::string& getAreaMutable ();

    /**
     * Sets the value of the member "area".
     *
     * If the meaning of "area" isn't clear, then there should be a description here.
     *
     * @param area The value which will be set
     */
    inline void setArea (const ::std::string& area_);

    /**
     * Sets the value of the member "area".
     *
     * If the meaning of "area" isn't clear, then there should be a description here.
     *
     * @param area The value which will be set
     */
    inline void setArea (const char* area_);

    /**
     * Sets the value of the member "area".
     *
     * If the meaning of "area" isn't clear, then there should be a description here.
     *
     * @param area The value which will be set
     */
    inline void setArea (const char* value, size_t size);

    static const trVerifyChecksumRequest &getDefaultInstance();

private:

    inline void set_has_enVerifyType ();

    inline void clear_has_enVerifyType ();

    inline void set_has_area ();

    inline void clear_has_area ();

    uint32 _has_bits_[ (2 + 31) / 32];

    tenVerifyType _enVerifyType;

    ::std::string _area;

};

/**
 * If the meaning of "trGetUpdateHistoryDetailedRequest" isn't clear, then there should be a description here.
 */
class trGetUpdateHistoryDetailedRequest {
public:

    /**
     * Default constructor
     */
    inline  trGetUpdateHistoryDetailedRequest ();

    /**
     * Copy constructor
     */
    inline  trGetUpdateHistoryDetailedRequest (const trGetUpdateHistoryDetailedRequest &rhs);

    /**
     * All fields constructor
     */
    inline  trGetUpdateHistoryDetailedRequest (tenHistoryScope enScope_, uint32 indexStart_, uint32 numEntriesMax_, tenHistoryFormat enFormat_);

    /**
     * Destructor
     */
    inline  ~trGetUpdateHistoryDetailedRequest();

    /**
     * Assignment operator
     */
    inline trGetUpdateHistoryDetailedRequest& operator = (const trGetUpdateHistoryDetailedRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const trGetUpdateHistoryDetailedRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const trGetUpdateHistoryDetailedRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const trGetUpdateHistoryDetailedRequest& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const trGetUpdateHistoryDetailedRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "enScope"

    static const int kEnScope = 0;

    /**
     * Clears the field "enScope".
     *
     * The field will be set to its default value. The hasEnScope()
     * method will return false.
     */
    inline void clearEnScope();

    /**
     * Checks whether the field "enScope" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEnScope()). Otherwise it will return false.
     */
    inline bool hasEnScope () const;

    /**
     * Returns the value of the member "enScope".
     *
     * If the meaning of "enScope" isn't clear, then there should be a description here.
     *
     * @return The value of the field "enScope"
     */
    inline tenHistoryScope getEnScope () const;

    /**
     * Sets the value of the member "enScope".
     *
     * If the meaning of "enScope" isn't clear, then there should be a description here.
     *
     * @param enScope The value which will be set
     */
    inline void setEnScope (tenHistoryScope enScope_);

    // API of field "indexStart"

    static const int kIndexStart = 1;

    /**
     * Clears the field "indexStart".
     *
     * The field will be set to its default value. The hasIndexStart()
     * method will return false.
     */
    inline void clearIndexStart();

    /**
     * Checks whether the field "indexStart" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setIndexStart()). Otherwise it will return false.
     */
    inline bool hasIndexStart () const;

    /**
     * Returns the value of the member "indexStart".
     *
     * If the meaning of "indexStart" isn't clear, then there should be a description here.
     *
     * @return The value of the field "indexStart"
     */
    inline uint32 getIndexStart () const;

    /**
     * Sets the value of the member "indexStart".
     *
     * If the meaning of "indexStart" isn't clear, then there should be a description here.
     *
     * @param indexStart The value which will be set
     */
    inline void setIndexStart (uint32 indexStart_);

    // API of field "numEntriesMax"

    static const int kNumEntriesMax = 2;

    /**
     * Clears the field "numEntriesMax".
     *
     * The field will be set to its default value. The hasNumEntriesMax()
     * method will return false.
     */
    inline void clearNumEntriesMax();

    /**
     * Checks whether the field "numEntriesMax" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setNumEntriesMax()). Otherwise it will return false.
     */
    inline bool hasNumEntriesMax () const;

    /**
     * Returns the value of the member "numEntriesMax".
     *
     * If the meaning of "numEntriesMax" isn't clear, then there should be a description here.
     *
     * @return The value of the field "numEntriesMax"
     */
    inline uint32 getNumEntriesMax () const;

    /**
     * Sets the value of the member "numEntriesMax".
     *
     * If the meaning of "numEntriesMax" isn't clear, then there should be a description here.
     *
     * @param numEntriesMax The value which will be set
     */
    inline void setNumEntriesMax (uint32 numEntriesMax_);

    // API of field "enFormat"

    static const int kEnFormat = 3;

    /**
     * Clears the field "enFormat".
     *
     * The field will be set to its default value. The hasEnFormat()
     * method will return false.
     */
    inline void clearEnFormat();

    /**
     * Checks whether the field "enFormat" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEnFormat()). Otherwise it will return false.
     */
    inline bool hasEnFormat () const;

    /**
     * Returns the value of the member "enFormat".
     *
     * If the meaning of "enFormat" isn't clear, then there should be a description here.
     *
     * @return The value of the field "enFormat"
     */
    inline tenHistoryFormat getEnFormat () const;

    /**
     * Sets the value of the member "enFormat".
     *
     * If the meaning of "enFormat" isn't clear, then there should be a description here.
     *
     * @param enFormat The value which will be set
     */
    inline void setEnFormat (tenHistoryFormat enFormat_);

    static const trGetUpdateHistoryDetailedRequest &getDefaultInstance();

private:

    inline void set_has_enScope ();

    inline void clear_has_enScope ();

    inline void set_has_indexStart ();

    inline void clear_has_indexStart ();

    inline void set_has_numEntriesMax ();

    inline void clear_has_numEntriesMax ();

    inline void set_has_enFormat ();

    inline void clear_has_enFormat ();

    uint32 _has_bits_[ (4 + 31) / 32];

    tenHistoryScope _enScope;

    uint32 _indexStart;

    uint32 _numEntriesMax;

    tenHistoryFormat _enFormat;

};

/**
 * If the meaning of "trGetUpdateHistoryDetailed" isn't clear, then there should be a description here.
 */
class trGetUpdateHistoryDetailed {
public:

    /**
     * Default constructor
     */
    inline  trGetUpdateHistoryDetailed ();

    /**
     * Copy constructor
     */
    inline  trGetUpdateHistoryDetailed (const trGetUpdateHistoryDetailed &rhs);

    /**
     * All fields constructor
     */
    inline  trGetUpdateHistoryDetailed (tenHistoryScope enScope_, const trUpdLogs& logs_, uint32 numberOfUpdates_, uint32 numberOfUpdatesSinceDelivery_, uint32 numberOfUpateLogs_, tenHistoryFormat enFormat_);

    /**
     * Destructor
     */
    inline  ~trGetUpdateHistoryDetailed();

    /**
     * Assignment operator
     */
    inline trGetUpdateHistoryDetailed& operator = (const trGetUpdateHistoryDetailed& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const trGetUpdateHistoryDetailed& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const trGetUpdateHistoryDetailed& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const trGetUpdateHistoryDetailed& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const trGetUpdateHistoryDetailed& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "enScope"

    static const int kEnScope = 0;

    /**
     * Clears the field "enScope".
     *
     * The field will be set to its default value. The hasEnScope()
     * method will return false.
     */
    inline void clearEnScope();

    /**
     * Checks whether the field "enScope" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEnScope()). Otherwise it will return false.
     */
    inline bool hasEnScope () const;

    /**
     * Returns the value of the member "enScope".
     *
     * If the meaning of "enScope" isn't clear, then there should be a description here.
     *
     * @return The value of the field "enScope"
     */
    inline tenHistoryScope getEnScope () const;

    /**
     * Sets the value of the member "enScope".
     *
     * If the meaning of "enScope" isn't clear, then there should be a description here.
     *
     * @param enScope The value which will be set
     */
    inline void setEnScope (tenHistoryScope enScope_);

    // API of field "logs"

    static const int kLogs = 1;

    /**
     * Clears the field "logs".
     *
     * The field will be set to its default value. The hasLogs()
     * method will return false.
     */
    inline void clearLogs();

    /**
     * Checks whether the field "logs" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLogs()). Otherwise it will return false.
     */
    inline bool hasLogs () const;

    /**
     * Returns the value of the member "logs".
     *
     * If the meaning of "logs" isn't clear, then there should be a description here.
     *
     * @return The value of the field "logs"
     */
    inline const trUpdLogs& getLogs () const;

    /**
     * Retrieves the value of the field "logs" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "logs".
     */
    inline trUpdLogs& getLogsMutable ();

    /**
     * Sets the value of the member "logs".
     *
     * If the meaning of "logs" isn't clear, then there should be a description here.
     *
     * @param logs The value which will be set
     */
    inline void setLogs (const trUpdLogs& logs_);

    // API of field "numberOfUpdates"

    static const int kNumberOfUpdates = 2;

    /**
     * Clears the field "numberOfUpdates".
     *
     * The field will be set to its default value. The hasNumberOfUpdates()
     * method will return false.
     */
    inline void clearNumberOfUpdates();

    /**
     * Checks whether the field "numberOfUpdates" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setNumberOfUpdates()). Otherwise it will return false.
     */
    inline bool hasNumberOfUpdates () const;

    /**
     * Returns the value of the member "numberOfUpdates".
     *
     * If the meaning of "numberOfUpdates" isn't clear, then there should be a description here.
     *
     * @return The value of the field "numberOfUpdates"
     */
    inline uint32 getNumberOfUpdates () const;

    /**
     * Sets the value of the member "numberOfUpdates".
     *
     * If the meaning of "numberOfUpdates" isn't clear, then there should be a description here.
     *
     * @param numberOfUpdates The value which will be set
     */
    inline void setNumberOfUpdates (uint32 numberOfUpdates_);

    // API of field "numberOfUpdatesSinceDelivery"

    static const int kNumberOfUpdatesSinceDelivery = 3;

    /**
     * Clears the field "numberOfUpdatesSinceDelivery".
     *
     * The field will be set to its default value. The hasNumberOfUpdatesSinceDelivery()
     * method will return false.
     */
    inline void clearNumberOfUpdatesSinceDelivery();

    /**
     * Checks whether the field "numberOfUpdatesSinceDelivery" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setNumberOfUpdatesSinceDelivery()). Otherwise it will return false.
     */
    inline bool hasNumberOfUpdatesSinceDelivery () const;

    /**
     * Returns the value of the member "numberOfUpdatesSinceDelivery".
     *
     * If the meaning of "numberOfUpdatesSinceDelivery" isn't clear, then there should be a description here.
     *
     * @return The value of the field "numberOfUpdatesSinceDelivery"
     */
    inline uint32 getNumberOfUpdatesSinceDelivery () const;

    /**
     * Sets the value of the member "numberOfUpdatesSinceDelivery".
     *
     * If the meaning of "numberOfUpdatesSinceDelivery" isn't clear, then there should be a description here.
     *
     * @param numberOfUpdatesSinceDelivery The value which will be set
     */
    inline void setNumberOfUpdatesSinceDelivery (uint32 numberOfUpdatesSinceDelivery_);

    // API of field "numberOfUpateLogs"

    static const int kNumberOfUpateLogs = 4;

    /**
     * Clears the field "numberOfUpateLogs".
     *
     * The field will be set to its default value. The hasNumberOfUpateLogs()
     * method will return false.
     */
    inline void clearNumberOfUpateLogs();

    /**
     * Checks whether the field "numberOfUpateLogs" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setNumberOfUpateLogs()). Otherwise it will return false.
     */
    inline bool hasNumberOfUpateLogs () const;

    /**
     * Returns the value of the member "numberOfUpateLogs".
     *
     * If the meaning of "numberOfUpateLogs" isn't clear, then there should be a description here.
     *
     * @return The value of the field "numberOfUpateLogs"
     */
    inline uint32 getNumberOfUpateLogs () const;

    /**
     * Sets the value of the member "numberOfUpateLogs".
     *
     * If the meaning of "numberOfUpateLogs" isn't clear, then there should be a description here.
     *
     * @param numberOfUpateLogs The value which will be set
     */
    inline void setNumberOfUpateLogs (uint32 numberOfUpateLogs_);

    // API of field "enFormat"

    static const int kEnFormat = 5;

    /**
     * Clears the field "enFormat".
     *
     * The field will be set to its default value. The hasEnFormat()
     * method will return false.
     */
    inline void clearEnFormat();

    /**
     * Checks whether the field "enFormat" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEnFormat()). Otherwise it will return false.
     */
    inline bool hasEnFormat () const;

    /**
     * Returns the value of the member "enFormat".
     *
     * If the meaning of "enFormat" isn't clear, then there should be a description here.
     *
     * @return The value of the field "enFormat"
     */
    inline tenHistoryFormat getEnFormat () const;

    /**
     * Sets the value of the member "enFormat".
     *
     * If the meaning of "enFormat" isn't clear, then there should be a description here.
     *
     * @param enFormat The value which will be set
     */
    inline void setEnFormat (tenHistoryFormat enFormat_);

    static const trGetUpdateHistoryDetailed &getDefaultInstance();

private:

    inline void set_has_enScope ();

    inline void clear_has_enScope ();

    inline void set_has_logs ();

    inline void clear_has_logs ();

    inline void set_has_numberOfUpdates ();

    inline void clear_has_numberOfUpdates ();

    inline void set_has_numberOfUpdatesSinceDelivery ();

    inline void clear_has_numberOfUpdatesSinceDelivery ();

    inline void set_has_numberOfUpateLogs ();

    inline void clear_has_numberOfUpateLogs ();

    inline void set_has_enFormat ();

    inline void clear_has_enFormat ();

    uint32 _has_bits_[ (6 + 31) / 32];

    tenHistoryScope _enScope;

    trUpdLogs _logs;

    uint32 _numberOfUpdates;

    uint32 _numberOfUpdatesSinceDelivery;

    uint32 _numberOfUpateLogs;

    tenHistoryFormat _enFormat;

};

/**
 * If the meaning of "trBgLocks" isn't clear, then there should be a description here.
 */
class trBgLocks {
public:

    /**
     * Default constructor
     */
    inline  trBgLocks ();

    /**
     * Copy constructor
     */
    inline  trBgLocks (const trBgLocks &rhs);

    /**
     * All fields constructor
     */
    inline  trBgLocks (const ::std::vector< ::std::string >& locks_);

    /**
     * Destructor
     */
    inline  ~trBgLocks();

    /**
     * Assignment operator
     */
    inline trBgLocks& operator = (const trBgLocks& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const trBgLocks& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const trBgLocks& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const trBgLocks& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const trBgLocks& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "locks"

    static const int kLocks = 0;

    /**
     * Clears the field "locks".
     *
     * The field will be set to its default value. The hasLocks()
     * method will return false.
     */
    inline void clearLocks();

    /**
     * Checks whether the field "locks" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLocks()). Otherwise it will return false.
     */
    inline bool hasLocks () const;

    /**
     * Returns the value of the member "locks".
     *
     * If the meaning of "locks" isn't clear, then there should be a description here.
     *
     * @return The value of the field "locks"
     */
    inline const ::std::vector< ::std::string >& getLocks () const;

    /**
     * Retrieves the value of the field "locks" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "locks".
     */
    inline ::std::vector< ::std::string >& getLocksMutable ();

    /**
     * Sets the value of the member "locks".
     *
     * If the meaning of "locks" isn't clear, then there should be a description here.
     *
     * @param locks The value which will be set
     */
    inline void setLocks (const ::std::vector< ::std::string >& locks_);

    static const trBgLocks &getDefaultInstance();

private:

    static const ::std::vector< ::std::string >& getStringList_DefaultInstance ();

    inline void set_has_locks ();

    inline void clear_has_locks ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< ::std::string > _locks;

};

/**
 * registeredLocks: list of locks the user wants to handle
 *     pendingLocks: list of locks that swupdate want to pass but that are registered by client
 */
class trBgLocksState {
public:

    /**
     * Default constructor
     */
    inline  trBgLocksState ();

    /**
     * Copy constructor
     */
    inline  trBgLocksState (const trBgLocksState &rhs);

    /**
     * All fields constructor
     */
    inline  trBgLocksState (const trBgLocks& registeredLocks_, const trBgLocks& pendingLocks_);

    /**
     * Destructor
     */
    inline  ~trBgLocksState();

    /**
     * Assignment operator
     */
    inline trBgLocksState& operator = (const trBgLocksState& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const trBgLocksState& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const trBgLocksState& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const trBgLocksState& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const trBgLocksState& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "registeredLocks"

    static const int kRegisteredLocks = 0;

    /**
     * Clears the field "registeredLocks".
     *
     * The field will be set to its default value. The hasRegisteredLocks()
     * method will return false.
     */
    inline void clearRegisteredLocks();

    /**
     * Checks whether the field "registeredLocks" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRegisteredLocks()). Otherwise it will return false.
     */
    inline bool hasRegisteredLocks () const;

    /**
     * Returns the value of the member "registeredLocks".
     *
     * If the meaning of "registeredLocks" isn't clear, then there should be a description here.
     *
     * @return The value of the field "registeredLocks"
     */
    inline const trBgLocks& getRegisteredLocks () const;

    /**
     * Retrieves the value of the field "registeredLocks" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "registeredLocks".
     */
    inline trBgLocks& getRegisteredLocksMutable ();

    /**
     * Sets the value of the member "registeredLocks".
     *
     * If the meaning of "registeredLocks" isn't clear, then there should be a description here.
     *
     * @param registeredLocks The value which will be set
     */
    inline void setRegisteredLocks (const trBgLocks& registeredLocks_);

    // API of field "pendingLocks"

    static const int kPendingLocks = 1;

    /**
     * Clears the field "pendingLocks".
     *
     * The field will be set to its default value. The hasPendingLocks()
     * method will return false.
     */
    inline void clearPendingLocks();

    /**
     * Checks whether the field "pendingLocks" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPendingLocks()). Otherwise it will return false.
     */
    inline bool hasPendingLocks () const;

    /**
     * Returns the value of the member "pendingLocks".
     *
     * If the meaning of "pendingLocks" isn't clear, then there should be a description here.
     *
     * @return The value of the field "pendingLocks"
     */
    inline const trBgLocks& getPendingLocks () const;

    /**
     * Retrieves the value of the field "pendingLocks" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "pendingLocks".
     */
    inline trBgLocks& getPendingLocksMutable ();

    /**
     * Sets the value of the member "pendingLocks".
     *
     * If the meaning of "pendingLocks" isn't clear, then there should be a description here.
     *
     * @param pendingLocks The value which will be set
     */
    inline void setPendingLocks (const trBgLocks& pendingLocks_);

    static const trBgLocksState &getDefaultInstance();

private:

    inline void set_has_registeredLocks ();

    inline void clear_has_registeredLocks ();

    inline void set_has_pendingLocks ();

    inline void clear_has_pendingLocks ();

    uint32 _has_bits_[ (2 + 31) / 32];

    trBgLocks _registeredLocks;

    trBgLocks _pendingLocks;

};

/**
 * If the meaning of "StoreHistoryToStick" isn't clear, then there should be a description here.
 */
class StoreHistoryToStickRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  StoreHistoryToStickRequest ();

    /**
     * Copy constructor
     */
    inline  StoreHistoryToStickRequest (const StoreHistoryToStickRequest &rhs);

    /**
     * All fields constructor
     */
    inline  StoreHistoryToStickRequest (bool sinceFactoryReset_, bool writeToAllSticks_);

    /**
     * Destructor
     */
    inline virtual  ~StoreHistoryToStickRequest();

    /**
     * Assignment operator
     */
    inline StoreHistoryToStickRequest& operator = (const StoreHistoryToStickRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const StoreHistoryToStickRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const StoreHistoryToStickRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const StoreHistoryToStickRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const StoreHistoryToStickRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "sinceFactoryReset"

    static const int kSinceFactoryReset = 0;

    /**
     * Clears the field "sinceFactoryReset".
     *
     * The field will be set to its default value. The hasSinceFactoryReset()
     * method will return false.
     */
    inline void clearSinceFactoryReset();

    /**
     * Checks whether the field "sinceFactoryReset" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSinceFactoryReset()). Otherwise it will return false.
     */
    inline bool hasSinceFactoryReset () const;

    /**
     * Returns the value of the member "sinceFactoryReset".
     *
     * If the meaning of "sinceFactoryReset" isn't clear, then there should be a description here.
     *
     * @return The value of the field "sinceFactoryReset"
     */
    inline bool getSinceFactoryReset () const;

    /**
     * Sets the value of the member "sinceFactoryReset".
     *
     * If the meaning of "sinceFactoryReset" isn't clear, then there should be a description here.
     *
     * @param sinceFactoryReset The value which will be set
     */
    inline void setSinceFactoryReset (bool sinceFactoryReset_);

    // API of field "writeToAllSticks"

    static const int kWriteToAllSticks = 1;

    /**
     * Clears the field "writeToAllSticks".
     *
     * The field will be set to its default value. The hasWriteToAllSticks()
     * method will return false.
     */
    inline void clearWriteToAllSticks();

    /**
     * Checks whether the field "writeToAllSticks" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setWriteToAllSticks()). Otherwise it will return false.
     */
    inline bool hasWriteToAllSticks () const;

    /**
     * Returns the value of the member "writeToAllSticks".
     *
     * If the meaning of "writeToAllSticks" isn't clear, then there should be a description here.
     *
     * @return The value of the field "writeToAllSticks"
     */
    inline bool getWriteToAllSticks () const;

    /**
     * Sets the value of the member "writeToAllSticks".
     *
     * If the meaning of "writeToAllSticks" isn't clear, then there should be a description here.
     *
     * @param writeToAllSticks The value which will be set
     */
    inline void setWriteToAllSticks (bool writeToAllSticks_);

    static const StoreHistoryToStickRequest &getDefaultInstance();

private:

    inline void set_has_sinceFactoryReset ();

    inline void clear_has_sinceFactoryReset ();

    inline void set_has_writeToAllSticks ();

    inline void clear_has_writeToAllSticks ();

    uint32 _has_bits_[ (2 + 31) / 32];

    bool _sinceFactoryReset;

    bool _writeToAllSticks;

};

/**
 * If the meaning of "StoreHistoryToStick" isn't clear, then there should be a description here.
 */
class StoreHistoryToStickResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  StoreHistoryToStickResponse ();

    /**
     * Copy constructor
     */
    inline  StoreHistoryToStickResponse (const StoreHistoryToStickResponse &rhs);

    /**
     * All fields constructor
     */
    inline  StoreHistoryToStickResponse (bool bOk_, tenStoreHistoryResult enResult_);

    /**
     * Destructor
     */
    inline virtual  ~StoreHistoryToStickResponse();

    /**
     * Assignment operator
     */
    inline StoreHistoryToStickResponse& operator = (const StoreHistoryToStickResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const StoreHistoryToStickResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const StoreHistoryToStickResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const StoreHistoryToStickResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const StoreHistoryToStickResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bOk"

    static const int kBOk = 0;

    /**
     * Clears the field "bOk".
     *
     * The field will be set to its default value. The hasBOk()
     * method will return false.
     */
    inline void clearBOk();

    /**
     * Checks whether the field "bOk" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBOk()). Otherwise it will return false.
     */
    inline bool hasBOk () const;

    /**
     * Returns the value of the member "bOk".
     *
     * If the meaning of "bOk" isn't clear, then there should be a description here.
     *
     * @return The value of the field "bOk"
     */
    inline bool getBOk () const;

    /**
     * Sets the value of the member "bOk".
     *
     * If the meaning of "bOk" isn't clear, then there should be a description here.
     *
     * @param bOk The value which will be set
     */
    inline void setBOk (bool bOk_);

    // API of field "enResult"

    static const int kEnResult = 1;

    /**
     * Clears the field "enResult".
     *
     * The field will be set to its default value. The hasEnResult()
     * method will return false.
     */
    inline void clearEnResult();

    /**
     * Checks whether the field "enResult" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEnResult()). Otherwise it will return false.
     */
    inline bool hasEnResult () const;

    /**
     * Returns the value of the member "enResult".
     *
     * If the meaning of "enResult" isn't clear, then there should be a description here.
     *
     * @return The value of the field "enResult"
     */
    inline tenStoreHistoryResult getEnResult () const;

    /**
     * Sets the value of the member "enResult".
     *
     * If the meaning of "enResult" isn't clear, then there should be a description here.
     *
     * @param enResult The value which will be set
     */
    inline void setEnResult (tenStoreHistoryResult enResult_);

    static const StoreHistoryToStickResponse &getDefaultInstance();

private:

    inline void set_has_bOk ();

    inline void clear_has_bOk ();

    inline void set_has_enResult ();

    inline void clear_has_enResult ();

    uint32 _has_bits_[ (2 + 31) / 32];

    bool _bOk;

    tenStoreHistoryResult _enResult;

};

/**
 * If the meaning of "UpdateEnter" isn't clear, then there should be a description here.
 */
class UpdateEnterRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  UpdateEnterRequest ();

    /**
     * Copy constructor
     */
    inline  UpdateEnterRequest (const UpdateEnterRequest &rhs);

    /**
     * All fields constructor
     */
    inline  UpdateEnterRequest (tenUser enUser_);

    /**
     * Destructor
     */
    inline virtual  ~UpdateEnterRequest();

    /**
     * Assignment operator
     */
    inline UpdateEnterRequest& operator = (const UpdateEnterRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const UpdateEnterRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const UpdateEnterRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const UpdateEnterRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const UpdateEnterRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "enUser"

    static const int kEnUser = 0;

    /**
     * Clears the field "enUser".
     *
     * The field will be set to its default value. The hasEnUser()
     * method will return false.
     */
    inline void clearEnUser();

    /**
     * Checks whether the field "enUser" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEnUser()). Otherwise it will return false.
     */
    inline bool hasEnUser () const;

    /**
     * Returns the value of the member "enUser".
     *
     * If the meaning of "enUser" isn't clear, then there should be a description here.
     *
     * @return The value of the field "enUser"
     */
    inline tenUser getEnUser () const;

    /**
     * Sets the value of the member "enUser".
     *
     * If the meaning of "enUser" isn't clear, then there should be a description here.
     *
     * @param enUser The value which will be set
     */
    inline void setEnUser (tenUser enUser_);

    static const UpdateEnterRequest &getDefaultInstance();

private:

    inline void set_has_enUser ();

    inline void clear_has_enUser ();

    uint32 _has_bits_[ (1 + 31) / 32];

    tenUser _enUser;

};

/**
 * If the meaning of "UpdateEnter" isn't clear, then there should be a description here.
 */
class UpdateEnterResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  UpdateEnterResponse ();

    /**
     * Copy constructor
     */
    inline  UpdateEnterResponse (const UpdateEnterResponse &rhs);

    /**
     * All fields constructor
     */
    inline  UpdateEnterResponse (bool bOk_);

    /**
     * Destructor
     */
    inline virtual  ~UpdateEnterResponse();

    /**
     * Assignment operator
     */
    inline UpdateEnterResponse& operator = (const UpdateEnterResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const UpdateEnterResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const UpdateEnterResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const UpdateEnterResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const UpdateEnterResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bOk"

    static const int kBOk = 0;

    /**
     * Clears the field "bOk".
     *
     * The field will be set to its default value. The hasBOk()
     * method will return false.
     */
    inline void clearBOk();

    /**
     * Checks whether the field "bOk" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBOk()). Otherwise it will return false.
     */
    inline bool hasBOk () const;

    /**
     * Returns the value of the member "bOk".
     *
     * If the meaning of "bOk" isn't clear, then there should be a description here.
     *
     * @return The value of the field "bOk"
     */
    inline bool getBOk () const;

    /**
     * Sets the value of the member "bOk".
     *
     * If the meaning of "bOk" isn't clear, then there should be a description here.
     *
     * @param bOk The value which will be set
     */
    inline void setBOk (bool bOk_);

    static const UpdateEnterResponse &getDefaultInstance();

private:

    inline void set_has_bOk ();

    inline void clear_has_bOk ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _bOk;

};

/**
 * If the meaning of "UpdateSetReleaseFilter" isn't clear, then there should be a description here.
 */
class UpdateSetReleaseFilterRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  UpdateSetReleaseFilterRequest ();

    /**
     * Copy constructor
     */
    inline  UpdateSetReleaseFilterRequest (const UpdateSetReleaseFilterRequest &rhs);

    /**
     * All fields constructor
     */
    inline  UpdateSetReleaseFilterRequest (const trReleaseFilter& filter_);

    /**
     * Destructor
     */
    inline virtual  ~UpdateSetReleaseFilterRequest();

    /**
     * Assignment operator
     */
    inline UpdateSetReleaseFilterRequest& operator = (const UpdateSetReleaseFilterRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const UpdateSetReleaseFilterRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const UpdateSetReleaseFilterRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const UpdateSetReleaseFilterRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const UpdateSetReleaseFilterRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "filter"

    static const int kFilter = 0;

    /**
     * Clears the field "filter".
     *
     * The field will be set to its default value. The hasFilter()
     * method will return false.
     */
    inline void clearFilter();

    /**
     * Checks whether the field "filter" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFilter()). Otherwise it will return false.
     */
    inline bool hasFilter () const;

    /**
     * Returns the value of the member "filter".
     *
     * If the meaning of "filter" isn't clear, then there should be a description here.
     *
     * @return The value of the field "filter"
     */
    inline const trReleaseFilter& getFilter () const;

    /**
     * Retrieves the value of the field "filter" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "filter".
     */
    inline trReleaseFilter& getFilterMutable ();

    /**
     * Sets the value of the member "filter".
     *
     * If the meaning of "filter" isn't clear, then there should be a description here.
     *
     * @param filter The value which will be set
     */
    inline void setFilter (const trReleaseFilter& filter_);

    static const UpdateSetReleaseFilterRequest &getDefaultInstance();

private:

    inline void set_has_filter ();

    inline void clear_has_filter ();

    uint32 _has_bits_[ (1 + 31) / 32];

    trReleaseFilter _filter;

};

/**
 * If the meaning of "UpdateSetReleaseFilter" isn't clear, then there should be a description here.
 */
class UpdateSetReleaseFilterResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  UpdateSetReleaseFilterResponse ();

    /**
     * Copy constructor
     */
    inline  UpdateSetReleaseFilterResponse (const UpdateSetReleaseFilterResponse &rhs);

    /**
     * All fields constructor
     */
    inline  UpdateSetReleaseFilterResponse (bool bOk_, const trReleaseFilter& resFilter_);

    /**
     * Destructor
     */
    inline virtual  ~UpdateSetReleaseFilterResponse();

    /**
     * Assignment operator
     */
    inline UpdateSetReleaseFilterResponse& operator = (const UpdateSetReleaseFilterResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const UpdateSetReleaseFilterResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const UpdateSetReleaseFilterResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const UpdateSetReleaseFilterResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const UpdateSetReleaseFilterResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bOk"

    static const int kBOk = 0;

    /**
     * Clears the field "bOk".
     *
     * The field will be set to its default value. The hasBOk()
     * method will return false.
     */
    inline void clearBOk();

    /**
     * Checks whether the field "bOk" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBOk()). Otherwise it will return false.
     */
    inline bool hasBOk () const;

    /**
     * Returns the value of the member "bOk".
     *
     * If the meaning of "bOk" isn't clear, then there should be a description here.
     *
     * @return The value of the field "bOk"
     */
    inline bool getBOk () const;

    /**
     * Sets the value of the member "bOk".
     *
     * If the meaning of "bOk" isn't clear, then there should be a description here.
     *
     * @param bOk The value which will be set
     */
    inline void setBOk (bool bOk_);

    // API of field "resFilter"

    static const int kResFilter = 1;

    /**
     * Clears the field "resFilter".
     *
     * The field will be set to its default value. The hasResFilter()
     * method will return false.
     */
    inline void clearResFilter();

    /**
     * Checks whether the field "resFilter" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResFilter()). Otherwise it will return false.
     */
    inline bool hasResFilter () const;

    /**
     * Returns the value of the member "resFilter".
     *
     * If the meaning of "resFilter" isn't clear, then there should be a description here.
     *
     * @return The value of the field "resFilter"
     */
    inline const trReleaseFilter& getResFilter () const;

    /**
     * Retrieves the value of the field "resFilter" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "resFilter".
     */
    inline trReleaseFilter& getResFilterMutable ();

    /**
     * Sets the value of the member "resFilter".
     *
     * If the meaning of "resFilter" isn't clear, then there should be a description here.
     *
     * @param resFilter The value which will be set
     */
    inline void setResFilter (const trReleaseFilter& resFilter_);

    static const UpdateSetReleaseFilterResponse &getDefaultInstance();

private:

    inline void set_has_bOk ();

    inline void clear_has_bOk ();

    inline void set_has_resFilter ();

    inline void clear_has_resFilter ();

    uint32 _has_bits_[ (2 + 31) / 32];

    bool _bOk;

    trReleaseFilter _resFilter;

};

/**
 * If the meaning of "UpdateGetSources" isn't clear, then there should be a description here.
 */
class UpdateGetSourcesResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  UpdateGetSourcesResponse ();

    /**
     * Copy constructor
     */
    inline  UpdateGetSourcesResponse (const UpdateGetSourcesResponse &rhs);

    /**
     * All fields constructor
     */
    inline  UpdateGetSourcesResponse (bool bOk_, const trUpdSources& sources_);

    /**
     * Destructor
     */
    inline virtual  ~UpdateGetSourcesResponse();

    /**
     * Assignment operator
     */
    inline UpdateGetSourcesResponse& operator = (const UpdateGetSourcesResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const UpdateGetSourcesResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const UpdateGetSourcesResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const UpdateGetSourcesResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const UpdateGetSourcesResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bOk"

    static const int kBOk = 0;

    /**
     * Clears the field "bOk".
     *
     * The field will be set to its default value. The hasBOk()
     * method will return false.
     */
    inline void clearBOk();

    /**
     * Checks whether the field "bOk" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBOk()). Otherwise it will return false.
     */
    inline bool hasBOk () const;

    /**
     * Returns the value of the member "bOk".
     *
     * If the meaning of "bOk" isn't clear, then there should be a description here.
     *
     * @return The value of the field "bOk"
     */
    inline bool getBOk () const;

    /**
     * Sets the value of the member "bOk".
     *
     * If the meaning of "bOk" isn't clear, then there should be a description here.
     *
     * @param bOk The value which will be set
     */
    inline void setBOk (bool bOk_);

    // API of field "sources"

    static const int kSources = 1;

    /**
     * Clears the field "sources".
     *
     * The field will be set to its default value. The hasSources()
     * method will return false.
     */
    inline void clearSources();

    /**
     * Checks whether the field "sources" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSources()). Otherwise it will return false.
     */
    inline bool hasSources () const;

    /**
     * Returns the value of the member "sources".
     *
     * If the meaning of "sources" isn't clear, then there should be a description here.
     *
     * @return The value of the field "sources"
     */
    inline const trUpdSources& getSources () const;

    /**
     * Retrieves the value of the field "sources" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sources".
     */
    inline trUpdSources& getSourcesMutable ();

    /**
     * Sets the value of the member "sources".
     *
     * If the meaning of "sources" isn't clear, then there should be a description here.
     *
     * @param sources The value which will be set
     */
    inline void setSources (const trUpdSources& sources_);

    static const UpdateGetSourcesResponse &getDefaultInstance();

private:

    inline void set_has_bOk ();

    inline void clear_has_bOk ();

    inline void set_has_sources ();

    inline void clear_has_sources ();

    uint32 _has_bits_[ (2 + 31) / 32];

    bool _bOk;

    trUpdSources _sources;

};

/**
 * If the meaning of "UpdateSelectSource" isn't clear, then there should be a description here.
 */
class UpdateSelectSourceRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  UpdateSelectSourceRequest ();

    /**
     * Copy constructor
     */
    inline  UpdateSelectSourceRequest (const UpdateSelectSourceRequest &rhs);

    /**
     * All fields constructor
     */
    inline  UpdateSelectSourceRequest (uint32 sourceIndex_);

    /**
     * Destructor
     */
    inline virtual  ~UpdateSelectSourceRequest();

    /**
     * Assignment operator
     */
    inline UpdateSelectSourceRequest& operator = (const UpdateSelectSourceRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const UpdateSelectSourceRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const UpdateSelectSourceRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const UpdateSelectSourceRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const UpdateSelectSourceRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "sourceIndex"

    static const int kSourceIndex = 0;

    /**
     * Clears the field "sourceIndex".
     *
     * The field will be set to its default value. The hasSourceIndex()
     * method will return false.
     */
    inline void clearSourceIndex();

    /**
     * Checks whether the field "sourceIndex" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSourceIndex()). Otherwise it will return false.
     */
    inline bool hasSourceIndex () const;

    /**
     * Returns the value of the member "sourceIndex".
     *
     * If the meaning of "sourceIndex" isn't clear, then there should be a description here.
     *
     * @return The value of the field "sourceIndex"
     */
    inline uint32 getSourceIndex () const;

    /**
     * Sets the value of the member "sourceIndex".
     *
     * If the meaning of "sourceIndex" isn't clear, then there should be a description here.
     *
     * @param sourceIndex The value which will be set
     */
    inline void setSourceIndex (uint32 sourceIndex_);

    static const UpdateSelectSourceRequest &getDefaultInstance();

private:

    inline void set_has_sourceIndex ();

    inline void clear_has_sourceIndex ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _sourceIndex;

};

/**
 * If the meaning of "UpdateSelectSource" isn't clear, then there should be a description here.
 */
class UpdateSelectSourceResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  UpdateSelectSourceResponse ();

    /**
     * Copy constructor
     */
    inline  UpdateSelectSourceResponse (const UpdateSelectSourceResponse &rhs);

    /**
     * All fields constructor
     */
    inline  UpdateSelectSourceResponse (bool bOk_, const trReleaseInfos& releaseInfos_);

    /**
     * Destructor
     */
    inline virtual  ~UpdateSelectSourceResponse();

    /**
     * Assignment operator
     */
    inline UpdateSelectSourceResponse& operator = (const UpdateSelectSourceResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const UpdateSelectSourceResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const UpdateSelectSourceResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const UpdateSelectSourceResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const UpdateSelectSourceResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bOk"

    static const int kBOk = 0;

    /**
     * Clears the field "bOk".
     *
     * The field will be set to its default value. The hasBOk()
     * method will return false.
     */
    inline void clearBOk();

    /**
     * Checks whether the field "bOk" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBOk()). Otherwise it will return false.
     */
    inline bool hasBOk () const;

    /**
     * Returns the value of the member "bOk".
     *
     * If the meaning of "bOk" isn't clear, then there should be a description here.
     *
     * @return The value of the field "bOk"
     */
    inline bool getBOk () const;

    /**
     * Sets the value of the member "bOk".
     *
     * If the meaning of "bOk" isn't clear, then there should be a description here.
     *
     * @param bOk The value which will be set
     */
    inline void setBOk (bool bOk_);

    // API of field "releaseInfos"

    static const int kReleaseInfos = 1;

    /**
     * Clears the field "releaseInfos".
     *
     * The field will be set to its default value. The hasReleaseInfos()
     * method will return false.
     */
    inline void clearReleaseInfos();

    /**
     * Checks whether the field "releaseInfos" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setReleaseInfos()). Otherwise it will return false.
     */
    inline bool hasReleaseInfos () const;

    /**
     * Returns the value of the member "releaseInfos".
     *
     * If the meaning of "releaseInfos" isn't clear, then there should be a description here.
     *
     * @return The value of the field "releaseInfos"
     */
    inline const trReleaseInfos& getReleaseInfos () const;

    /**
     * Retrieves the value of the field "releaseInfos" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "releaseInfos".
     */
    inline trReleaseInfos& getReleaseInfosMutable ();

    /**
     * Sets the value of the member "releaseInfos".
     *
     * If the meaning of "releaseInfos" isn't clear, then there should be a description here.
     *
     * @param releaseInfos The value which will be set
     */
    inline void setReleaseInfos (const trReleaseInfos& releaseInfos_);

    static const UpdateSelectSourceResponse &getDefaultInstance();

private:

    inline void set_has_bOk ();

    inline void clear_has_bOk ();

    inline void set_has_releaseInfos ();

    inline void clear_has_releaseInfos ();

    uint32 _has_bits_[ (2 + 31) / 32];

    bool _bOk;

    trReleaseInfos _releaseInfos;

};

/**
 * If the meaning of "UpdateSelectRelease" isn't clear, then there should be a description here.
 */
class UpdateSelectReleaseRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  UpdateSelectReleaseRequest ();

    /**
     * Copy constructor
     */
    inline  UpdateSelectReleaseRequest (const UpdateSelectReleaseRequest &rhs);

    /**
     * All fields constructor
     */
    inline  UpdateSelectReleaseRequest (uint32 releaseIndex_);

    /**
     * Destructor
     */
    inline virtual  ~UpdateSelectReleaseRequest();

    /**
     * Assignment operator
     */
    inline UpdateSelectReleaseRequest& operator = (const UpdateSelectReleaseRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const UpdateSelectReleaseRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const UpdateSelectReleaseRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const UpdateSelectReleaseRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const UpdateSelectReleaseRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "releaseIndex"

    static const int kReleaseIndex = 0;

    /**
     * Clears the field "releaseIndex".
     *
     * The field will be set to its default value. The hasReleaseIndex()
     * method will return false.
     */
    inline void clearReleaseIndex();

    /**
     * Checks whether the field "releaseIndex" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setReleaseIndex()). Otherwise it will return false.
     */
    inline bool hasReleaseIndex () const;

    /**
     * Returns the value of the member "releaseIndex".
     *
     * If the meaning of "releaseIndex" isn't clear, then there should be a description here.
     *
     * @return The value of the field "releaseIndex"
     */
    inline uint32 getReleaseIndex () const;

    /**
     * Sets the value of the member "releaseIndex".
     *
     * If the meaning of "releaseIndex" isn't clear, then there should be a description here.
     *
     * @param releaseIndex The value which will be set
     */
    inline void setReleaseIndex (uint32 releaseIndex_);

    static const UpdateSelectReleaseRequest &getDefaultInstance();

private:

    inline void set_has_releaseIndex ();

    inline void clear_has_releaseIndex ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _releaseIndex;

};

/**
 * If the meaning of "UpdateSelectRelease" isn't clear, then there should be a description here.
 */
class UpdateSelectReleaseResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  UpdateSelectReleaseResponse ();

    /**
     * Copy constructor
     */
    inline  UpdateSelectReleaseResponse (const UpdateSelectReleaseResponse &rhs);

    /**
     * All fields constructor
     */
    inline  UpdateSelectReleaseResponse (bool bOk_, tenErrorId enErrorId_);

    /**
     * Destructor
     */
    inline virtual  ~UpdateSelectReleaseResponse();

    /**
     * Assignment operator
     */
    inline UpdateSelectReleaseResponse& operator = (const UpdateSelectReleaseResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const UpdateSelectReleaseResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const UpdateSelectReleaseResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const UpdateSelectReleaseResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const UpdateSelectReleaseResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bOk"

    static const int kBOk = 0;

    /**
     * Clears the field "bOk".
     *
     * The field will be set to its default value. The hasBOk()
     * method will return false.
     */
    inline void clearBOk();

    /**
     * Checks whether the field "bOk" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBOk()). Otherwise it will return false.
     */
    inline bool hasBOk () const;

    /**
     * Returns the value of the member "bOk".
     *
     * If the meaning of "bOk" isn't clear, then there should be a description here.
     *
     * @return The value of the field "bOk"
     */
    inline bool getBOk () const;

    /**
     * Sets the value of the member "bOk".
     *
     * If the meaning of "bOk" isn't clear, then there should be a description here.
     *
     * @param bOk The value which will be set
     */
    inline void setBOk (bool bOk_);

    // API of field "enErrorId"

    static const int kEnErrorId = 1;

    /**
     * Clears the field "enErrorId".
     *
     * The field will be set to its default value. The hasEnErrorId()
     * method will return false.
     */
    inline void clearEnErrorId();

    /**
     * Checks whether the field "enErrorId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEnErrorId()). Otherwise it will return false.
     */
    inline bool hasEnErrorId () const;

    /**
     * Returns the value of the member "enErrorId".
     *
     * If the meaning of "enErrorId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "enErrorId"
     */
    inline tenErrorId getEnErrorId () const;

    /**
     * Sets the value of the member "enErrorId".
     *
     * If the meaning of "enErrorId" isn't clear, then there should be a description here.
     *
     * @param enErrorId The value which will be set
     */
    inline void setEnErrorId (tenErrorId enErrorId_);

    static const UpdateSelectReleaseResponse &getDefaultInstance();

private:

    inline void set_has_bOk ();

    inline void clear_has_bOk ();

    inline void set_has_enErrorId ();

    inline void clear_has_enErrorId ();

    uint32 _has_bits_[ (2 + 31) / 32];

    bool _bOk;

    tenErrorId _enErrorId;

};

/**
 * If the meaning of "GetDeviceStateList" isn't clear, then there should be a description here.
 */
class GetDeviceStateListResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetDeviceStateListResponse ();

    /**
     * Copy constructor
     */
    inline  GetDeviceStateListResponse (const GetDeviceStateListResponse &rhs);

    /**
     * All fields constructor
     */
    inline  GetDeviceStateListResponse (bool bOk_, const trDeviceStates& deviceStates_);

    /**
     * Destructor
     */
    inline virtual  ~GetDeviceStateListResponse();

    /**
     * Assignment operator
     */
    inline GetDeviceStateListResponse& operator = (const GetDeviceStateListResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetDeviceStateListResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetDeviceStateListResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetDeviceStateListResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetDeviceStateListResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bOk"

    static const int kBOk = 0;

    /**
     * Clears the field "bOk".
     *
     * The field will be set to its default value. The hasBOk()
     * method will return false.
     */
    inline void clearBOk();

    /**
     * Checks whether the field "bOk" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBOk()). Otherwise it will return false.
     */
    inline bool hasBOk () const;

    /**
     * Returns the value of the member "bOk".
     *
     * If the meaning of "bOk" isn't clear, then there should be a description here.
     *
     * @return The value of the field "bOk"
     */
    inline bool getBOk () const;

    /**
     * Sets the value of the member "bOk".
     *
     * If the meaning of "bOk" isn't clear, then there should be a description here.
     *
     * @param bOk The value which will be set
     */
    inline void setBOk (bool bOk_);

    // API of field "deviceStates"

    static const int kDeviceStates = 1;

    /**
     * Clears the field "deviceStates".
     *
     * The field will be set to its default value. The hasDeviceStates()
     * method will return false.
     */
    inline void clearDeviceStates();

    /**
     * Checks whether the field "deviceStates" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceStates()). Otherwise it will return false.
     */
    inline bool hasDeviceStates () const;

    /**
     * Returns the value of the member "deviceStates".
     *
     * If the meaning of "deviceStates" isn't clear, then there should be a description here.
     *
     * @return The value of the field "deviceStates"
     */
    inline const trDeviceStates& getDeviceStates () const;

    /**
     * Retrieves the value of the field "deviceStates" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "deviceStates".
     */
    inline trDeviceStates& getDeviceStatesMutable ();

    /**
     * Sets the value of the member "deviceStates".
     *
     * If the meaning of "deviceStates" isn't clear, then there should be a description here.
     *
     * @param deviceStates The value which will be set
     */
    inline void setDeviceStates (const trDeviceStates& deviceStates_);

    static const GetDeviceStateListResponse &getDefaultInstance();

private:

    inline void set_has_bOk ();

    inline void clear_has_bOk ();

    inline void set_has_deviceStates ();

    inline void clear_has_deviceStates ();

    uint32 _has_bits_[ (2 + 31) / 32];

    bool _bOk;

    trDeviceStates _deviceStates;

};

/**
 * If the meaning of "SetUpdateOptions" isn't clear, then there should be a description here.
 */
class SetUpdateOptionsRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetUpdateOptionsRequest ();

    /**
     * Copy constructor
     */
    inline  SetUpdateOptionsRequest (const SetUpdateOptionsRequest &rhs);

    /**
     * All fields constructor
     */
    inline  SetUpdateOptionsRequest (tenUpdOptions enOption_);

    /**
     * Destructor
     */
    inline virtual  ~SetUpdateOptionsRequest();

    /**
     * Assignment operator
     */
    inline SetUpdateOptionsRequest& operator = (const SetUpdateOptionsRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetUpdateOptionsRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetUpdateOptionsRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetUpdateOptionsRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetUpdateOptionsRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "enOption"

    static const int kEnOption = 0;

    /**
     * Clears the field "enOption".
     *
     * The field will be set to its default value. The hasEnOption()
     * method will return false.
     */
    inline void clearEnOption();

    /**
     * Checks whether the field "enOption" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEnOption()). Otherwise it will return false.
     */
    inline bool hasEnOption () const;

    /**
     * Returns the value of the member "enOption".
     *
     * If the meaning of "enOption" isn't clear, then there should be a description here.
     *
     * @return The value of the field "enOption"
     */
    inline tenUpdOptions getEnOption () const;

    /**
     * Sets the value of the member "enOption".
     *
     * If the meaning of "enOption" isn't clear, then there should be a description here.
     *
     * @param enOption The value which will be set
     */
    inline void setEnOption (tenUpdOptions enOption_);

    static const SetUpdateOptionsRequest &getDefaultInstance();

private:

    inline void set_has_enOption ();

    inline void clear_has_enOption ();

    uint32 _has_bits_[ (1 + 31) / 32];

    tenUpdOptions _enOption;

};

/**
 * If the meaning of "SetUpdateOptions" isn't clear, then there should be a description here.
 */
class SetUpdateOptionsResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetUpdateOptionsResponse ();

    /**
     * Copy constructor
     */
    inline  SetUpdateOptionsResponse (const SetUpdateOptionsResponse &rhs);

    /**
     * All fields constructor
     */
    inline  SetUpdateOptionsResponse (bool bOk_, tenUpdOptions enOptionRes_);

    /**
     * Destructor
     */
    inline virtual  ~SetUpdateOptionsResponse();

    /**
     * Assignment operator
     */
    inline SetUpdateOptionsResponse& operator = (const SetUpdateOptionsResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetUpdateOptionsResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetUpdateOptionsResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetUpdateOptionsResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetUpdateOptionsResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bOk"

    static const int kBOk = 0;

    /**
     * Clears the field "bOk".
     *
     * The field will be set to its default value. The hasBOk()
     * method will return false.
     */
    inline void clearBOk();

    /**
     * Checks whether the field "bOk" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBOk()). Otherwise it will return false.
     */
    inline bool hasBOk () const;

    /**
     * Returns the value of the member "bOk".
     *
     * If the meaning of "bOk" isn't clear, then there should be a description here.
     *
     * @return The value of the field "bOk"
     */
    inline bool getBOk () const;

    /**
     * Sets the value of the member "bOk".
     *
     * If the meaning of "bOk" isn't clear, then there should be a description here.
     *
     * @param bOk The value which will be set
     */
    inline void setBOk (bool bOk_);

    // API of field "enOptionRes"

    static const int kEnOptionRes = 1;

    /**
     * Clears the field "enOptionRes".
     *
     * The field will be set to its default value. The hasEnOptionRes()
     * method will return false.
     */
    inline void clearEnOptionRes();

    /**
     * Checks whether the field "enOptionRes" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEnOptionRes()). Otherwise it will return false.
     */
    inline bool hasEnOptionRes () const;

    /**
     * Returns the value of the member "enOptionRes".
     *
     * If the meaning of "enOptionRes" isn't clear, then there should be a description here.
     *
     * @return The value of the field "enOptionRes"
     */
    inline tenUpdOptions getEnOptionRes () const;

    /**
     * Sets the value of the member "enOptionRes".
     *
     * If the meaning of "enOptionRes" isn't clear, then there should be a description here.
     *
     * @param enOptionRes The value which will be set
     */
    inline void setEnOptionRes (tenUpdOptions enOptionRes_);

    static const SetUpdateOptionsResponse &getDefaultInstance();

private:

    inline void set_has_bOk ();

    inline void clear_has_bOk ();

    inline void set_has_enOptionRes ();

    inline void clear_has_enOptionRes ();

    uint32 _has_bits_[ (2 + 31) / 32];

    bool _bOk;

    tenUpdOptions _enOptionRes;

};

/**
 * If the meaning of "ModifyReleaseDoc" isn't clear, then there should be a description here.
 */
class ModifyReleaseDocRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ModifyReleaseDocRequest ();

    /**
     * Copy constructor
     */
    inline  ModifyReleaseDocRequest (const ModifyReleaseDocRequest &rhs);

    /**
     * All fields constructor
     */
    inline  ModifyReleaseDocRequest (const trModifyAction& enModifyAction_);

    /**
     * Destructor
     */
    inline virtual  ~ModifyReleaseDocRequest();

    /**
     * Assignment operator
     */
    inline ModifyReleaseDocRequest& operator = (const ModifyReleaseDocRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ModifyReleaseDocRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ModifyReleaseDocRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ModifyReleaseDocRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ModifyReleaseDocRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "enModifyAction"

    static const int kEnModifyAction = 0;

    /**
     * Clears the field "enModifyAction".
     *
     * The field will be set to its default value. The hasEnModifyAction()
     * method will return false.
     */
    inline void clearEnModifyAction();

    /**
     * Checks whether the field "enModifyAction" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEnModifyAction()). Otherwise it will return false.
     */
    inline bool hasEnModifyAction () const;

    /**
     * Returns the value of the member "enModifyAction".
     *
     * If the meaning of "enModifyAction" isn't clear, then there should be a description here.
     *
     * @return The value of the field "enModifyAction"
     */
    inline const trModifyAction& getEnModifyAction () const;

    /**
     * Retrieves the value of the field "enModifyAction" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "enModifyAction".
     */
    inline trModifyAction& getEnModifyActionMutable ();

    /**
     * Sets the value of the member "enModifyAction".
     *
     * If the meaning of "enModifyAction" isn't clear, then there should be a description here.
     *
     * @param enModifyAction The value which will be set
     */
    inline void setEnModifyAction (const trModifyAction& enModifyAction_);

    static const ModifyReleaseDocRequest &getDefaultInstance();

private:

    inline void set_has_enModifyAction ();

    inline void clear_has_enModifyAction ();

    uint32 _has_bits_[ (1 + 31) / 32];

    trModifyAction _enModifyAction;

};

/**
 * If the meaning of "ModifyReleaseDoc" isn't clear, then there should be a description here.
 */
class ModifyReleaseDocResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ModifyReleaseDocResponse ();

    /**
     * Copy constructor
     */
    inline  ModifyReleaseDocResponse (const ModifyReleaseDocResponse &rhs);

    /**
     * All fields constructor
     */
    inline  ModifyReleaseDocResponse (bool bOk_, const trModifyAction& enModifyActionRes_);

    /**
     * Destructor
     */
    inline virtual  ~ModifyReleaseDocResponse();

    /**
     * Assignment operator
     */
    inline ModifyReleaseDocResponse& operator = (const ModifyReleaseDocResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ModifyReleaseDocResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ModifyReleaseDocResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ModifyReleaseDocResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ModifyReleaseDocResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bOk"

    static const int kBOk = 0;

    /**
     * Clears the field "bOk".
     *
     * The field will be set to its default value. The hasBOk()
     * method will return false.
     */
    inline void clearBOk();

    /**
     * Checks whether the field "bOk" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBOk()). Otherwise it will return false.
     */
    inline bool hasBOk () const;

    /**
     * Returns the value of the member "bOk".
     *
     * If the meaning of "bOk" isn't clear, then there should be a description here.
     *
     * @return The value of the field "bOk"
     */
    inline bool getBOk () const;

    /**
     * Sets the value of the member "bOk".
     *
     * If the meaning of "bOk" isn't clear, then there should be a description here.
     *
     * @param bOk The value which will be set
     */
    inline void setBOk (bool bOk_);

    // API of field "enModifyActionRes"

    static const int kEnModifyActionRes = 1;

    /**
     * Clears the field "enModifyActionRes".
     *
     * The field will be set to its default value. The hasEnModifyActionRes()
     * method will return false.
     */
    inline void clearEnModifyActionRes();

    /**
     * Checks whether the field "enModifyActionRes" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEnModifyActionRes()). Otherwise it will return false.
     */
    inline bool hasEnModifyActionRes () const;

    /**
     * Returns the value of the member "enModifyActionRes".
     *
     * If the meaning of "enModifyActionRes" isn't clear, then there should be a description here.
     *
     * @return The value of the field "enModifyActionRes"
     */
    inline const trModifyAction& getEnModifyActionRes () const;

    /**
     * Retrieves the value of the field "enModifyActionRes" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "enModifyActionRes".
     */
    inline trModifyAction& getEnModifyActionResMutable ();

    /**
     * Sets the value of the member "enModifyActionRes".
     *
     * If the meaning of "enModifyActionRes" isn't clear, then there should be a description here.
     *
     * @param enModifyActionRes The value which will be set
     */
    inline void setEnModifyActionRes (const trModifyAction& enModifyActionRes_);

    static const ModifyReleaseDocResponse &getDefaultInstance();

private:

    inline void set_has_bOk ();

    inline void clear_has_bOk ();

    inline void set_has_enModifyActionRes ();

    inline void clear_has_enModifyActionRes ();

    uint32 _has_bits_[ (2 + 31) / 32];

    bool _bOk;

    trModifyAction _enModifyActionRes;

};

/**
 * If the meaning of "GetUpdateFile" isn't clear, then there should be a description here.
 */
class GetUpdateFileResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetUpdateFileResponse ();

    /**
     * Copy constructor
     */
    inline  GetUpdateFileResponse (const GetUpdateFileResponse &rhs);

    /**
     * All fields constructor
     */
    inline  GetUpdateFileResponse (bool bOk_, tenGetUpdateFileResult enResult_);

    /**
     * Destructor
     */
    inline virtual  ~GetUpdateFileResponse();

    /**
     * Assignment operator
     */
    inline GetUpdateFileResponse& operator = (const GetUpdateFileResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetUpdateFileResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetUpdateFileResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetUpdateFileResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetUpdateFileResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bOk"

    static const int kBOk = 0;

    /**
     * Clears the field "bOk".
     *
     * The field will be set to its default value. The hasBOk()
     * method will return false.
     */
    inline void clearBOk();

    /**
     * Checks whether the field "bOk" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBOk()). Otherwise it will return false.
     */
    inline bool hasBOk () const;

    /**
     * Returns the value of the member "bOk".
     *
     * If the meaning of "bOk" isn't clear, then there should be a description here.
     *
     * @return The value of the field "bOk"
     */
    inline bool getBOk () const;

    /**
     * Sets the value of the member "bOk".
     *
     * If the meaning of "bOk" isn't clear, then there should be a description here.
     *
     * @param bOk The value which will be set
     */
    inline void setBOk (bool bOk_);

    // API of field "enResult"

    static const int kEnResult = 1;

    /**
     * Clears the field "enResult".
     *
     * The field will be set to its default value. The hasEnResult()
     * method will return false.
     */
    inline void clearEnResult();

    /**
     * Checks whether the field "enResult" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEnResult()). Otherwise it will return false.
     */
    inline bool hasEnResult () const;

    /**
     * Returns the value of the member "enResult".
     *
     * If the meaning of "enResult" isn't clear, then there should be a description here.
     *
     * @return The value of the field "enResult"
     */
    inline tenGetUpdateFileResult getEnResult () const;

    /**
     * Sets the value of the member "enResult".
     *
     * If the meaning of "enResult" isn't clear, then there should be a description here.
     *
     * @param enResult The value which will be set
     */
    inline void setEnResult (tenGetUpdateFileResult enResult_);

    static const GetUpdateFileResponse &getDefaultInstance();

private:

    inline void set_has_bOk ();

    inline void clear_has_bOk ();

    inline void set_has_enResult ();

    inline void clear_has_enResult ();

    uint32 _has_bits_[ (2 + 31) / 32];

    bool _bOk;

    tenGetUpdateFileResult _enResult;

};

/**
 * If the meaning of "ApplyDoc" isn't clear, then there should be a description here.
 */
class ApplyDocResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ApplyDocResponse ();

    /**
     * Copy constructor
     */
    inline  ApplyDocResponse (const ApplyDocResponse &rhs);

    /**
     * All fields constructor
     */
    inline  ApplyDocResponse (bool bOk_);

    /**
     * Destructor
     */
    inline virtual  ~ApplyDocResponse();

    /**
     * Assignment operator
     */
    inline ApplyDocResponse& operator = (const ApplyDocResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ApplyDocResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ApplyDocResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ApplyDocResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ApplyDocResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bOk"

    static const int kBOk = 0;

    /**
     * Clears the field "bOk".
     *
     * The field will be set to its default value. The hasBOk()
     * method will return false.
     */
    inline void clearBOk();

    /**
     * Checks whether the field "bOk" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBOk()). Otherwise it will return false.
     */
    inline bool hasBOk () const;

    /**
     * Returns the value of the member "bOk".
     *
     * If the meaning of "bOk" isn't clear, then there should be a description here.
     *
     * @return The value of the field "bOk"
     */
    inline bool getBOk () const;

    /**
     * Sets the value of the member "bOk".
     *
     * If the meaning of "bOk" isn't clear, then there should be a description here.
     *
     * @param bOk The value which will be set
     */
    inline void setBOk (bool bOk_);

    static const ApplyDocResponse &getDefaultInstance();

private:

    inline void set_has_bOk ();

    inline void clear_has_bOk ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _bOk;

};

/**
 * If the meaning of "ApplyLock" isn't clear, then there should be a description here.
 */
class ApplyLockResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ApplyLockResponse ();

    /**
     * Copy constructor
     */
    inline  ApplyLockResponse (const ApplyLockResponse &rhs);

    /**
     * All fields constructor
     */
    inline  ApplyLockResponse (bool bOk_);

    /**
     * Destructor
     */
    inline virtual  ~ApplyLockResponse();

    /**
     * Assignment operator
     */
    inline ApplyLockResponse& operator = (const ApplyLockResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ApplyLockResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ApplyLockResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ApplyLockResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ApplyLockResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bOk"

    static const int kBOk = 0;

    /**
     * Clears the field "bOk".
     *
     * The field will be set to its default value. The hasBOk()
     * method will return false.
     */
    inline void clearBOk();

    /**
     * Checks whether the field "bOk" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBOk()). Otherwise it will return false.
     */
    inline bool hasBOk () const;

    /**
     * Returns the value of the member "bOk".
     *
     * If the meaning of "bOk" isn't clear, then there should be a description here.
     *
     * @return The value of the field "bOk"
     */
    inline bool getBOk () const;

    /**
     * Sets the value of the member "bOk".
     *
     * If the meaning of "bOk" isn't clear, then there should be a description here.
     *
     * @param bOk The value which will be set
     */
    inline void setBOk (bool bOk_);

    static const ApplyLockResponse &getDefaultInstance();

private:

    inline void set_has_bOk ();

    inline void clear_has_bOk ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _bOk;

};

/**
 * If the meaning of "UpdateSelectReleaseByFile" isn't clear, then there should be a description here.
 */
class UpdateSelectReleaseByFileRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  UpdateSelectReleaseByFileRequest ();

    /**
     * Copy constructor
     */
    inline  UpdateSelectReleaseByFileRequest (const UpdateSelectReleaseByFileRequest &rhs);

    /**
     * All fields constructor
     */
    inline  UpdateSelectReleaseByFileRequest (const trReleaseAccess& releaseAccess_);

    /**
     * Destructor
     */
    inline virtual  ~UpdateSelectReleaseByFileRequest();

    /**
     * Assignment operator
     */
    inline UpdateSelectReleaseByFileRequest& operator = (const UpdateSelectReleaseByFileRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const UpdateSelectReleaseByFileRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const UpdateSelectReleaseByFileRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const UpdateSelectReleaseByFileRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const UpdateSelectReleaseByFileRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "releaseAccess"

    static const int kReleaseAccess = 0;

    /**
     * Clears the field "releaseAccess".
     *
     * The field will be set to its default value. The hasReleaseAccess()
     * method will return false.
     */
    inline void clearReleaseAccess();

    /**
     * Checks whether the field "releaseAccess" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setReleaseAccess()). Otherwise it will return false.
     */
    inline bool hasReleaseAccess () const;

    /**
     * Returns the value of the member "releaseAccess".
     *
     * If the meaning of "releaseAccess" isn't clear, then there should be a description here.
     *
     * @return The value of the field "releaseAccess"
     */
    inline const trReleaseAccess& getReleaseAccess () const;

    /**
     * Retrieves the value of the field "releaseAccess" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "releaseAccess".
     */
    inline trReleaseAccess& getReleaseAccessMutable ();

    /**
     * Sets the value of the member "releaseAccess".
     *
     * If the meaning of "releaseAccess" isn't clear, then there should be a description here.
     *
     * @param releaseAccess The value which will be set
     */
    inline void setReleaseAccess (const trReleaseAccess& releaseAccess_);

    static const UpdateSelectReleaseByFileRequest &getDefaultInstance();

private:

    inline void set_has_releaseAccess ();

    inline void clear_has_releaseAccess ();

    uint32 _has_bits_[ (1 + 31) / 32];

    trReleaseAccess _releaseAccess;

};

/**
 * If the meaning of "UpdateSelectReleaseByFile" isn't clear, then there should be a description here.
 */
class UpdateSelectReleaseByFileResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  UpdateSelectReleaseByFileResponse ();

    /**
     * Copy constructor
     */
    inline  UpdateSelectReleaseByFileResponse (const UpdateSelectReleaseByFileResponse &rhs);

    /**
     * All fields constructor
     */
    inline  UpdateSelectReleaseByFileResponse (bool bOk_, tenErrorId enErrorId_);

    /**
     * Destructor
     */
    inline virtual  ~UpdateSelectReleaseByFileResponse();

    /**
     * Assignment operator
     */
    inline UpdateSelectReleaseByFileResponse& operator = (const UpdateSelectReleaseByFileResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const UpdateSelectReleaseByFileResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const UpdateSelectReleaseByFileResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const UpdateSelectReleaseByFileResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const UpdateSelectReleaseByFileResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bOk"

    static const int kBOk = 0;

    /**
     * Clears the field "bOk".
     *
     * The field will be set to its default value. The hasBOk()
     * method will return false.
     */
    inline void clearBOk();

    /**
     * Checks whether the field "bOk" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBOk()). Otherwise it will return false.
     */
    inline bool hasBOk () const;

    /**
     * Returns the value of the member "bOk".
     *
     * If the meaning of "bOk" isn't clear, then there should be a description here.
     *
     * @return The value of the field "bOk"
     */
    inline bool getBOk () const;

    /**
     * Sets the value of the member "bOk".
     *
     * If the meaning of "bOk" isn't clear, then there should be a description here.
     *
     * @param bOk The value which will be set
     */
    inline void setBOk (bool bOk_);

    // API of field "enErrorId"

    static const int kEnErrorId = 1;

    /**
     * Clears the field "enErrorId".
     *
     * The field will be set to its default value. The hasEnErrorId()
     * method will return false.
     */
    inline void clearEnErrorId();

    /**
     * Checks whether the field "enErrorId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEnErrorId()). Otherwise it will return false.
     */
    inline bool hasEnErrorId () const;

    /**
     * Returns the value of the member "enErrorId".
     *
     * If the meaning of "enErrorId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "enErrorId"
     */
    inline tenErrorId getEnErrorId () const;

    /**
     * Sets the value of the member "enErrorId".
     *
     * If the meaning of "enErrorId" isn't clear, then there should be a description here.
     *
     * @param enErrorId The value which will be set
     */
    inline void setEnErrorId (tenErrorId enErrorId_);

    static const UpdateSelectReleaseByFileResponse &getDefaultInstance();

private:

    inline void set_has_bOk ();

    inline void clear_has_bOk ();

    inline void set_has_enErrorId ();

    inline void clear_has_enErrorId ();

    uint32 _has_bits_[ (2 + 31) / 32];

    bool _bOk;

    tenErrorId _enErrorId;

};

/**
 * If the meaning of "RetryFailedModules" isn't clear, then there should be a description here.
 */
class RetryFailedModulesResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RetryFailedModulesResponse ();

    /**
     * Copy constructor
     */
    inline  RetryFailedModulesResponse (const RetryFailedModulesResponse &rhs);

    /**
     * All fields constructor
     */
    inline  RetryFailedModulesResponse (bool bOk_);

    /**
     * Destructor
     */
    inline virtual  ~RetryFailedModulesResponse();

    /**
     * Assignment operator
     */
    inline RetryFailedModulesResponse& operator = (const RetryFailedModulesResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RetryFailedModulesResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RetryFailedModulesResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RetryFailedModulesResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RetryFailedModulesResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bOk"

    static const int kBOk = 0;

    /**
     * Clears the field "bOk".
     *
     * The field will be set to its default value. The hasBOk()
     * method will return false.
     */
    inline void clearBOk();

    /**
     * Checks whether the field "bOk" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBOk()). Otherwise it will return false.
     */
    inline bool hasBOk () const;

    /**
     * Returns the value of the member "bOk".
     *
     * If the meaning of "bOk" isn't clear, then there should be a description here.
     *
     * @return The value of the field "bOk"
     */
    inline bool getBOk () const;

    /**
     * Sets the value of the member "bOk".
     *
     * If the meaning of "bOk" isn't clear, then there should be a description here.
     *
     * @param bOk The value which will be set
     */
    inline void setBOk (bool bOk_);

    static const RetryFailedModulesResponse &getDefaultInstance();

private:

    inline void set_has_bOk ();

    inline void clear_has_bOk ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _bOk;

};

/**
 * If the meaning of "UpdateEnd" isn't clear, then there should be a description here.
 */
class UpdateEndResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  UpdateEndResponse ();

    /**
     * Copy constructor
     */
    inline  UpdateEndResponse (const UpdateEndResponse &rhs);

    /**
     * All fields constructor
     */
    inline  UpdateEndResponse (bool bOk_);

    /**
     * Destructor
     */
    inline virtual  ~UpdateEndResponse();

    /**
     * Assignment operator
     */
    inline UpdateEndResponse& operator = (const UpdateEndResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const UpdateEndResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const UpdateEndResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const UpdateEndResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const UpdateEndResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bOk"

    static const int kBOk = 0;

    /**
     * Clears the field "bOk".
     *
     * The field will be set to its default value. The hasBOk()
     * method will return false.
     */
    inline void clearBOk();

    /**
     * Checks whether the field "bOk" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBOk()). Otherwise it will return false.
     */
    inline bool hasBOk () const;

    /**
     * Returns the value of the member "bOk".
     *
     * If the meaning of "bOk" isn't clear, then there should be a description here.
     *
     * @return The value of the field "bOk"
     */
    inline bool getBOk () const;

    /**
     * Sets the value of the member "bOk".
     *
     * If the meaning of "bOk" isn't clear, then there should be a description here.
     *
     * @param bOk The value which will be set
     */
    inline void setBOk (bool bOk_);

    static const UpdateEndResponse &getDefaultInstance();

private:

    inline void set_has_bOk ();

    inline void clear_has_bOk ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _bOk;

};

/**
 * If the meaning of "UpdateAbort" isn't clear, then there should be a description here.
 */
class UpdateAbortRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  UpdateAbortRequest ();

    /**
     * Copy constructor
     */
    inline  UpdateAbortRequest (const UpdateAbortRequest &rhs);

    /**
     * All fields constructor
     */
    inline  UpdateAbortRequest (bool bDeviceOnly_);

    /**
     * Destructor
     */
    inline virtual  ~UpdateAbortRequest();

    /**
     * Assignment operator
     */
    inline UpdateAbortRequest& operator = (const UpdateAbortRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const UpdateAbortRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const UpdateAbortRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const UpdateAbortRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const UpdateAbortRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bDeviceOnly"

    static const int kBDeviceOnly = 0;

    /**
     * Clears the field "bDeviceOnly".
     *
     * The field will be set to its default value. The hasBDeviceOnly()
     * method will return false.
     */
    inline void clearBDeviceOnly();

    /**
     * Checks whether the field "bDeviceOnly" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBDeviceOnly()). Otherwise it will return false.
     */
    inline bool hasBDeviceOnly () const;

    /**
     * Returns the value of the member "bDeviceOnly".
     *
     * If the meaning of "bDeviceOnly" isn't clear, then there should be a description here.
     *
     * @return The value of the field "bDeviceOnly"
     */
    inline bool getBDeviceOnly () const;

    /**
     * Sets the value of the member "bDeviceOnly".
     *
     * If the meaning of "bDeviceOnly" isn't clear, then there should be a description here.
     *
     * @param bDeviceOnly The value which will be set
     */
    inline void setBDeviceOnly (bool bDeviceOnly_);

    static const UpdateAbortRequest &getDefaultInstance();

private:

    inline void set_has_bDeviceOnly ();

    inline void clear_has_bDeviceOnly ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _bDeviceOnly;

};

/**
 * If the meaning of "UpdateAbort" isn't clear, then there should be a description here.
 */
class UpdateAbortResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  UpdateAbortResponse ();

    /**
     * Copy constructor
     */
    inline  UpdateAbortResponse (const UpdateAbortResponse &rhs);

    /**
     * All fields constructor
     */
    inline  UpdateAbortResponse (bool bOk_);

    /**
     * Destructor
     */
    inline virtual  ~UpdateAbortResponse();

    /**
     * Assignment operator
     */
    inline UpdateAbortResponse& operator = (const UpdateAbortResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const UpdateAbortResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const UpdateAbortResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const UpdateAbortResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const UpdateAbortResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bOk"

    static const int kBOk = 0;

    /**
     * Clears the field "bOk".
     *
     * The field will be set to its default value. The hasBOk()
     * method will return false.
     */
    inline void clearBOk();

    /**
     * Checks whether the field "bOk" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBOk()). Otherwise it will return false.
     */
    inline bool hasBOk () const;

    /**
     * Returns the value of the member "bOk".
     *
     * If the meaning of "bOk" isn't clear, then there should be a description here.
     *
     * @return The value of the field "bOk"
     */
    inline bool getBOk () const;

    /**
     * Sets the value of the member "bOk".
     *
     * If the meaning of "bOk" isn't clear, then there should be a description here.
     *
     * @param bOk The value which will be set
     */
    inline void setBOk (bool bOk_);

    static const UpdateAbortResponse &getDefaultInstance();

private:

    inline void set_has_bOk ();

    inline void clear_has_bOk ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _bOk;

};

/**
 * If the meaning of "UpdateAbortDevice" isn't clear, then there should be a description here.
 */
class UpdateAbortDeviceRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  UpdateAbortDeviceRequest ();

    /**
     * Copy constructor
     */
    inline  UpdateAbortDeviceRequest (const UpdateAbortDeviceRequest &rhs);

    /**
     * All fields constructor
     */
    inline  UpdateAbortDeviceRequest (const ::std::string& refKey_);

    /**
     * Destructor
     */
    inline virtual  ~UpdateAbortDeviceRequest();

    /**
     * Assignment operator
     */
    inline UpdateAbortDeviceRequest& operator = (const UpdateAbortDeviceRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const UpdateAbortDeviceRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const UpdateAbortDeviceRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const UpdateAbortDeviceRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const UpdateAbortDeviceRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "refKey"

    static const int kRefKey = 0;

    /**
     * Clears the field "refKey".
     *
     * The field will be set to its default value. The hasRefKey()
     * method will return false.
     */
    inline void clearRefKey();

    /**
     * Checks whether the field "refKey" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRefKey()). Otherwise it will return false.
     */
    inline bool hasRefKey () const;

    /**
     * Returns the value of the member "refKey".
     *
     * If the meaning of "refKey" isn't clear, then there should be a description here.
     *
     * @return The value of the field "refKey"
     */
    inline const ::std::string& getRefKey () const;

    /**
     * Retrieves the value of the field "refKey" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "refKey".
     */
    inline ::std::string& getRefKeyMutable ();

    /**
     * Sets the value of the member "refKey".
     *
     * If the meaning of "refKey" isn't clear, then there should be a description here.
     *
     * @param refKey The value which will be set
     */
    inline void setRefKey (const ::std::string& refKey_);

    /**
     * Sets the value of the member "refKey".
     *
     * If the meaning of "refKey" isn't clear, then there should be a description here.
     *
     * @param refKey The value which will be set
     */
    inline void setRefKey (const char* refKey_);

    /**
     * Sets the value of the member "refKey".
     *
     * If the meaning of "refKey" isn't clear, then there should be a description here.
     *
     * @param refKey The value which will be set
     */
    inline void setRefKey (const char* value, size_t size);

    static const UpdateAbortDeviceRequest &getDefaultInstance();

private:

    inline void set_has_refKey ();

    inline void clear_has_refKey ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _refKey;

};

/**
 * If the meaning of "UpdateAbortDevice" isn't clear, then there should be a description here.
 */
class UpdateAbortDeviceResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  UpdateAbortDeviceResponse ();

    /**
     * Copy constructor
     */
    inline  UpdateAbortDeviceResponse (const UpdateAbortDeviceResponse &rhs);

    /**
     * All fields constructor
     */
    inline  UpdateAbortDeviceResponse (bool bOk_, const trAbortDeviceRes& rAbortDeviceRes_);

    /**
     * Destructor
     */
    inline virtual  ~UpdateAbortDeviceResponse();

    /**
     * Assignment operator
     */
    inline UpdateAbortDeviceResponse& operator = (const UpdateAbortDeviceResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const UpdateAbortDeviceResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const UpdateAbortDeviceResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const UpdateAbortDeviceResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const UpdateAbortDeviceResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bOk"

    static const int kBOk = 0;

    /**
     * Clears the field "bOk".
     *
     * The field will be set to its default value. The hasBOk()
     * method will return false.
     */
    inline void clearBOk();

    /**
     * Checks whether the field "bOk" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBOk()). Otherwise it will return false.
     */
    inline bool hasBOk () const;

    /**
     * Returns the value of the member "bOk".
     *
     * If the meaning of "bOk" isn't clear, then there should be a description here.
     *
     * @return The value of the field "bOk"
     */
    inline bool getBOk () const;

    /**
     * Sets the value of the member "bOk".
     *
     * If the meaning of "bOk" isn't clear, then there should be a description here.
     *
     * @param bOk The value which will be set
     */
    inline void setBOk (bool bOk_);

    // API of field "rAbortDeviceRes"

    static const int kRAbortDeviceRes = 1;

    /**
     * Clears the field "rAbortDeviceRes".
     *
     * The field will be set to its default value. The hasRAbortDeviceRes()
     * method will return false.
     */
    inline void clearRAbortDeviceRes();

    /**
     * Checks whether the field "rAbortDeviceRes" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRAbortDeviceRes()). Otherwise it will return false.
     */
    inline bool hasRAbortDeviceRes () const;

    /**
     * Returns the value of the member "rAbortDeviceRes".
     *
     * If the meaning of "rAbortDeviceRes" isn't clear, then there should be a description here.
     *
     * @return The value of the field "rAbortDeviceRes"
     */
    inline const trAbortDeviceRes& getRAbortDeviceRes () const;

    /**
     * Retrieves the value of the field "rAbortDeviceRes" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "rAbortDeviceRes".
     */
    inline trAbortDeviceRes& getRAbortDeviceResMutable ();

    /**
     * Sets the value of the member "rAbortDeviceRes".
     *
     * If the meaning of "rAbortDeviceRes" isn't clear, then there should be a description here.
     *
     * @param rAbortDeviceRes The value which will be set
     */
    inline void setRAbortDeviceRes (const trAbortDeviceRes& rAbortDeviceRes_);

    static const UpdateAbortDeviceResponse &getDefaultInstance();

private:

    inline void set_has_bOk ();

    inline void clear_has_bOk ();

    inline void set_has_rAbortDeviceRes ();

    inline void clear_has_rAbortDeviceRes ();

    uint32 _has_bits_[ (2 + 31) / 32];

    bool _bOk;

    trAbortDeviceRes _rAbortDeviceRes;

};

/**
 * If the meaning of "HandleError" isn't clear, then there should be a description here.
 */
class HandleErrorRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  HandleErrorRequest ();

    /**
     * Copy constructor
     */
    inline  HandleErrorRequest (const HandleErrorRequest &rhs);

    /**
     * All fields constructor
     */
    inline  HandleErrorRequest (tenErrorHandlingMode enMode_);

    /**
     * Destructor
     */
    inline virtual  ~HandleErrorRequest();

    /**
     * Assignment operator
     */
    inline HandleErrorRequest& operator = (const HandleErrorRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const HandleErrorRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const HandleErrorRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const HandleErrorRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const HandleErrorRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "enMode"

    static const int kEnMode = 0;

    /**
     * Clears the field "enMode".
     *
     * The field will be set to its default value. The hasEnMode()
     * method will return false.
     */
    inline void clearEnMode();

    /**
     * Checks whether the field "enMode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEnMode()). Otherwise it will return false.
     */
    inline bool hasEnMode () const;

    /**
     * Returns the value of the member "enMode".
     *
     * If the meaning of "enMode" isn't clear, then there should be a description here.
     *
     * @return The value of the field "enMode"
     */
    inline tenErrorHandlingMode getEnMode () const;

    /**
     * Sets the value of the member "enMode".
     *
     * If the meaning of "enMode" isn't clear, then there should be a description here.
     *
     * @param enMode The value which will be set
     */
    inline void setEnMode (tenErrorHandlingMode enMode_);

    static const HandleErrorRequest &getDefaultInstance();

private:

    inline void set_has_enMode ();

    inline void clear_has_enMode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    tenErrorHandlingMode _enMode;

};

/**
 * If the meaning of "HandleError" isn't clear, then there should be a description here.
 */
class HandleErrorResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  HandleErrorResponse ();

    /**
     * Copy constructor
     */
    inline  HandleErrorResponse (const HandleErrorResponse &rhs);

    /**
     * All fields constructor
     */
    inline  HandleErrorResponse (bool bOk_);

    /**
     * Destructor
     */
    inline virtual  ~HandleErrorResponse();

    /**
     * Assignment operator
     */
    inline HandleErrorResponse& operator = (const HandleErrorResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const HandleErrorResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const HandleErrorResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const HandleErrorResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const HandleErrorResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bOk"

    static const int kBOk = 0;

    /**
     * Clears the field "bOk".
     *
     * The field will be set to its default value. The hasBOk()
     * method will return false.
     */
    inline void clearBOk();

    /**
     * Checks whether the field "bOk" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBOk()). Otherwise it will return false.
     */
    inline bool hasBOk () const;

    /**
     * Returns the value of the member "bOk".
     *
     * If the meaning of "bOk" isn't clear, then there should be a description here.
     *
     * @return The value of the field "bOk"
     */
    inline bool getBOk () const;

    /**
     * Sets the value of the member "bOk".
     *
     * If the meaning of "bOk" isn't clear, then there should be a description here.
     *
     * @param bOk The value which will be set
     */
    inline void setBOk (bool bOk_);

    static const HandleErrorResponse &getDefaultInstance();

private:

    inline void set_has_bOk ();

    inline void clear_has_bOk ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _bOk;

};

/**
 * If the meaning of "GetUpdateHistory" isn't clear, then there should be a description here.
 */
class GetUpdateHistoryResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetUpdateHistoryResponse ();

    /**
     * Copy constructor
     */
    inline  GetUpdateHistoryResponse (const GetUpdateHistoryResponse &rhs);

    /**
     * All fields constructor
     */
    inline  GetUpdateHistoryResponse (bool bOk_, const trUpdLogs& logs_);

    /**
     * Destructor
     */
    inline virtual  ~GetUpdateHistoryResponse();

    /**
     * Assignment operator
     */
    inline GetUpdateHistoryResponse& operator = (const GetUpdateHistoryResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetUpdateHistoryResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetUpdateHistoryResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetUpdateHistoryResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetUpdateHistoryResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bOk"

    static const int kBOk = 0;

    /**
     * Clears the field "bOk".
     *
     * The field will be set to its default value. The hasBOk()
     * method will return false.
     */
    inline void clearBOk();

    /**
     * Checks whether the field "bOk" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBOk()). Otherwise it will return false.
     */
    inline bool hasBOk () const;

    /**
     * Returns the value of the member "bOk".
     *
     * If the meaning of "bOk" isn't clear, then there should be a description here.
     *
     * @return The value of the field "bOk"
     */
    inline bool getBOk () const;

    /**
     * Sets the value of the member "bOk".
     *
     * If the meaning of "bOk" isn't clear, then there should be a description here.
     *
     * @param bOk The value which will be set
     */
    inline void setBOk (bool bOk_);

    // API of field "logs"

    static const int kLogs = 1;

    /**
     * Clears the field "logs".
     *
     * The field will be set to its default value. The hasLogs()
     * method will return false.
     */
    inline void clearLogs();

    /**
     * Checks whether the field "logs" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLogs()). Otherwise it will return false.
     */
    inline bool hasLogs () const;

    /**
     * Returns the value of the member "logs".
     *
     * If the meaning of "logs" isn't clear, then there should be a description here.
     *
     * @return The value of the field "logs"
     */
    inline const trUpdLogs& getLogs () const;

    /**
     * Retrieves the value of the field "logs" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "logs".
     */
    inline trUpdLogs& getLogsMutable ();

    /**
     * Sets the value of the member "logs".
     *
     * If the meaning of "logs" isn't clear, then there should be a description here.
     *
     * @param logs The value which will be set
     */
    inline void setLogs (const trUpdLogs& logs_);

    static const GetUpdateHistoryResponse &getDefaultInstance();

private:

    inline void set_has_bOk ();

    inline void clear_has_bOk ();

    inline void set_has_logs ();

    inline void clear_has_logs ();

    uint32 _has_bits_[ (2 + 31) / 32];

    bool _bOk;

    trUpdLogs _logs;

};

/**
 * If the meaning of "GetUpdateHistoryScoped" isn't clear, then there should be a description here.
 */
class GetUpdateHistoryScopedRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetUpdateHistoryScopedRequest ();

    /**
     * Copy constructor
     */
    inline  GetUpdateHistoryScopedRequest (const GetUpdateHistoryScopedRequest &rhs);

    /**
     * All fields constructor
     */
    inline  GetUpdateHistoryScopedRequest (tenHistoryScope enScope_, uint32 indexStart_, uint32 numEntriesMax_);

    /**
     * Destructor
     */
    inline virtual  ~GetUpdateHistoryScopedRequest();

    /**
     * Assignment operator
     */
    inline GetUpdateHistoryScopedRequest& operator = (const GetUpdateHistoryScopedRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetUpdateHistoryScopedRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetUpdateHistoryScopedRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetUpdateHistoryScopedRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetUpdateHistoryScopedRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "enScope"

    static const int kEnScope = 0;

    /**
     * Clears the field "enScope".
     *
     * The field will be set to its default value. The hasEnScope()
     * method will return false.
     */
    inline void clearEnScope();

    /**
     * Checks whether the field "enScope" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEnScope()). Otherwise it will return false.
     */
    inline bool hasEnScope () const;

    /**
     * Returns the value of the member "enScope".
     *
     * If the meaning of "enScope" isn't clear, then there should be a description here.
     *
     * @return The value of the field "enScope"
     */
    inline tenHistoryScope getEnScope () const;

    /**
     * Sets the value of the member "enScope".
     *
     * If the meaning of "enScope" isn't clear, then there should be a description here.
     *
     * @param enScope The value which will be set
     */
    inline void setEnScope (tenHistoryScope enScope_);

    // API of field "indexStart"

    static const int kIndexStart = 1;

    /**
     * Clears the field "indexStart".
     *
     * The field will be set to its default value. The hasIndexStart()
     * method will return false.
     */
    inline void clearIndexStart();

    /**
     * Checks whether the field "indexStart" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setIndexStart()). Otherwise it will return false.
     */
    inline bool hasIndexStart () const;

    /**
     * Returns the value of the member "indexStart".
     *
     * If the meaning of "indexStart" isn't clear, then there should be a description here.
     *
     * @return The value of the field "indexStart"
     */
    inline uint32 getIndexStart () const;

    /**
     * Sets the value of the member "indexStart".
     *
     * If the meaning of "indexStart" isn't clear, then there should be a description here.
     *
     * @param indexStart The value which will be set
     */
    inline void setIndexStart (uint32 indexStart_);

    // API of field "numEntriesMax"

    static const int kNumEntriesMax = 2;

    /**
     * Clears the field "numEntriesMax".
     *
     * The field will be set to its default value. The hasNumEntriesMax()
     * method will return false.
     */
    inline void clearNumEntriesMax();

    /**
     * Checks whether the field "numEntriesMax" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setNumEntriesMax()). Otherwise it will return false.
     */
    inline bool hasNumEntriesMax () const;

    /**
     * Returns the value of the member "numEntriesMax".
     *
     * If the meaning of "numEntriesMax" isn't clear, then there should be a description here.
     *
     * @return The value of the field "numEntriesMax"
     */
    inline uint32 getNumEntriesMax () const;

    /**
     * Sets the value of the member "numEntriesMax".
     *
     * If the meaning of "numEntriesMax" isn't clear, then there should be a description here.
     *
     * @param numEntriesMax The value which will be set
     */
    inline void setNumEntriesMax (uint32 numEntriesMax_);

    static const GetUpdateHistoryScopedRequest &getDefaultInstance();

private:

    inline void set_has_enScope ();

    inline void clear_has_enScope ();

    inline void set_has_indexStart ();

    inline void clear_has_indexStart ();

    inline void set_has_numEntriesMax ();

    inline void clear_has_numEntriesMax ();

    uint32 _has_bits_[ (3 + 31) / 32];

    tenHistoryScope _enScope;

    uint32 _indexStart;

    uint32 _numEntriesMax;

};

/**
 * If the meaning of "GetUpdateHistoryScoped" isn't clear, then there should be a description here.
 */
class GetUpdateHistoryScopedResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetUpdateHistoryScopedResponse ();

    /**
     * Copy constructor
     */
    inline  GetUpdateHistoryScopedResponse (const GetUpdateHistoryScopedResponse &rhs);

    /**
     * All fields constructor
     */
    inline  GetUpdateHistoryScopedResponse (bool bOk_, tenHistoryScope enScopeRes_, const trUpdLogs& logs_, uint32 numberOfUpdates_, uint32 numberOfUpdatesSinceDelivery_, uint32 numberOfUpateLogs_);

    /**
     * Destructor
     */
    inline virtual  ~GetUpdateHistoryScopedResponse();

    /**
     * Assignment operator
     */
    inline GetUpdateHistoryScopedResponse& operator = (const GetUpdateHistoryScopedResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetUpdateHistoryScopedResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetUpdateHistoryScopedResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetUpdateHistoryScopedResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetUpdateHistoryScopedResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bOk"

    static const int kBOk = 0;

    /**
     * Clears the field "bOk".
     *
     * The field will be set to its default value. The hasBOk()
     * method will return false.
     */
    inline void clearBOk();

    /**
     * Checks whether the field "bOk" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBOk()). Otherwise it will return false.
     */
    inline bool hasBOk () const;

    /**
     * Returns the value of the member "bOk".
     *
     * If the meaning of "bOk" isn't clear, then there should be a description here.
     *
     * @return The value of the field "bOk"
     */
    inline bool getBOk () const;

    /**
     * Sets the value of the member "bOk".
     *
     * If the meaning of "bOk" isn't clear, then there should be a description here.
     *
     * @param bOk The value which will be set
     */
    inline void setBOk (bool bOk_);

    // API of field "enScopeRes"

    static const int kEnScopeRes = 1;

    /**
     * Clears the field "enScopeRes".
     *
     * The field will be set to its default value. The hasEnScopeRes()
     * method will return false.
     */
    inline void clearEnScopeRes();

    /**
     * Checks whether the field "enScopeRes" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEnScopeRes()). Otherwise it will return false.
     */
    inline bool hasEnScopeRes () const;

    /**
     * Returns the value of the member "enScopeRes".
     *
     * If the meaning of "enScopeRes" isn't clear, then there should be a description here.
     *
     * @return The value of the field "enScopeRes"
     */
    inline tenHistoryScope getEnScopeRes () const;

    /**
     * Sets the value of the member "enScopeRes".
     *
     * If the meaning of "enScopeRes" isn't clear, then there should be a description here.
     *
     * @param enScopeRes The value which will be set
     */
    inline void setEnScopeRes (tenHistoryScope enScopeRes_);

    // API of field "logs"

    static const int kLogs = 2;

    /**
     * Clears the field "logs".
     *
     * The field will be set to its default value. The hasLogs()
     * method will return false.
     */
    inline void clearLogs();

    /**
     * Checks whether the field "logs" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLogs()). Otherwise it will return false.
     */
    inline bool hasLogs () const;

    /**
     * Returns the value of the member "logs".
     *
     * If the meaning of "logs" isn't clear, then there should be a description here.
     *
     * @return The value of the field "logs"
     */
    inline const trUpdLogs& getLogs () const;

    /**
     * Retrieves the value of the field "logs" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "logs".
     */
    inline trUpdLogs& getLogsMutable ();

    /**
     * Sets the value of the member "logs".
     *
     * If the meaning of "logs" isn't clear, then there should be a description here.
     *
     * @param logs The value which will be set
     */
    inline void setLogs (const trUpdLogs& logs_);

    // API of field "numberOfUpdates"

    static const int kNumberOfUpdates = 3;

    /**
     * Clears the field "numberOfUpdates".
     *
     * The field will be set to its default value. The hasNumberOfUpdates()
     * method will return false.
     */
    inline void clearNumberOfUpdates();

    /**
     * Checks whether the field "numberOfUpdates" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setNumberOfUpdates()). Otherwise it will return false.
     */
    inline bool hasNumberOfUpdates () const;

    /**
     * Returns the value of the member "numberOfUpdates".
     *
     * If the meaning of "numberOfUpdates" isn't clear, then there should be a description here.
     *
     * @return The value of the field "numberOfUpdates"
     */
    inline uint32 getNumberOfUpdates () const;

    /**
     * Sets the value of the member "numberOfUpdates".
     *
     * If the meaning of "numberOfUpdates" isn't clear, then there should be a description here.
     *
     * @param numberOfUpdates The value which will be set
     */
    inline void setNumberOfUpdates (uint32 numberOfUpdates_);

    // API of field "numberOfUpdatesSinceDelivery"

    static const int kNumberOfUpdatesSinceDelivery = 4;

    /**
     * Clears the field "numberOfUpdatesSinceDelivery".
     *
     * The field will be set to its default value. The hasNumberOfUpdatesSinceDelivery()
     * method will return false.
     */
    inline void clearNumberOfUpdatesSinceDelivery();

    /**
     * Checks whether the field "numberOfUpdatesSinceDelivery" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setNumberOfUpdatesSinceDelivery()). Otherwise it will return false.
     */
    inline bool hasNumberOfUpdatesSinceDelivery () const;

    /**
     * Returns the value of the member "numberOfUpdatesSinceDelivery".
     *
     * If the meaning of "numberOfUpdatesSinceDelivery" isn't clear, then there should be a description here.
     *
     * @return The value of the field "numberOfUpdatesSinceDelivery"
     */
    inline uint32 getNumberOfUpdatesSinceDelivery () const;

    /**
     * Sets the value of the member "numberOfUpdatesSinceDelivery".
     *
     * If the meaning of "numberOfUpdatesSinceDelivery" isn't clear, then there should be a description here.
     *
     * @param numberOfUpdatesSinceDelivery The value which will be set
     */
    inline void setNumberOfUpdatesSinceDelivery (uint32 numberOfUpdatesSinceDelivery_);

    // API of field "numberOfUpateLogs"

    static const int kNumberOfUpateLogs = 5;

    /**
     * Clears the field "numberOfUpateLogs".
     *
     * The field will be set to its default value. The hasNumberOfUpateLogs()
     * method will return false.
     */
    inline void clearNumberOfUpateLogs();

    /**
     * Checks whether the field "numberOfUpateLogs" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setNumberOfUpateLogs()). Otherwise it will return false.
     */
    inline bool hasNumberOfUpateLogs () const;

    /**
     * Returns the value of the member "numberOfUpateLogs".
     *
     * If the meaning of "numberOfUpateLogs" isn't clear, then there should be a description here.
     *
     * @return The value of the field "numberOfUpateLogs"
     */
    inline uint32 getNumberOfUpateLogs () const;

    /**
     * Sets the value of the member "numberOfUpateLogs".
     *
     * If the meaning of "numberOfUpateLogs" isn't clear, then there should be a description here.
     *
     * @param numberOfUpateLogs The value which will be set
     */
    inline void setNumberOfUpateLogs (uint32 numberOfUpateLogs_);

    static const GetUpdateHistoryScopedResponse &getDefaultInstance();

private:

    inline void set_has_bOk ();

    inline void clear_has_bOk ();

    inline void set_has_enScopeRes ();

    inline void clear_has_enScopeRes ();

    inline void set_has_logs ();

    inline void clear_has_logs ();

    inline void set_has_numberOfUpdates ();

    inline void clear_has_numberOfUpdates ();

    inline void set_has_numberOfUpdatesSinceDelivery ();

    inline void clear_has_numberOfUpdatesSinceDelivery ();

    inline void set_has_numberOfUpateLogs ();

    inline void clear_has_numberOfUpateLogs ();

    uint32 _has_bits_[ (6 + 31) / 32];

    bool _bOk;

    tenHistoryScope _enScopeRes;

    trUpdLogs _logs;

    uint32 _numberOfUpdates;

    uint32 _numberOfUpdatesSinceDelivery;

    uint32 _numberOfUpateLogs;

};

/**
 * If the meaning of "GetUpdateHistoryDetailed" isn't clear, then there should be a description here.
 */
class GetUpdateHistoryDetailedRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetUpdateHistoryDetailedRequest ();

    /**
     * Copy constructor
     */
    inline  GetUpdateHistoryDetailedRequest (const GetUpdateHistoryDetailedRequest &rhs);

    /**
     * All fields constructor
     */
    inline  GetUpdateHistoryDetailedRequest (const trGetUpdateHistoryDetailedRequest& request_);

    /**
     * Destructor
     */
    inline virtual  ~GetUpdateHistoryDetailedRequest();

    /**
     * Assignment operator
     */
    inline GetUpdateHistoryDetailedRequest& operator = (const GetUpdateHistoryDetailedRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetUpdateHistoryDetailedRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetUpdateHistoryDetailedRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetUpdateHistoryDetailedRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetUpdateHistoryDetailedRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "request"

    static const int kRequest = 0;

    /**
     * Clears the field "request".
     *
     * The field will be set to its default value. The hasRequest()
     * method will return false.
     */
    inline void clearRequest();

    /**
     * Checks whether the field "request" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRequest()). Otherwise it will return false.
     */
    inline bool hasRequest () const;

    /**
     * Returns the value of the member "request".
     *
     * If the meaning of "request" isn't clear, then there should be a description here.
     *
     * @return The value of the field "request"
     */
    inline const trGetUpdateHistoryDetailedRequest& getRequest () const;

    /**
     * Retrieves the value of the field "request" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "request".
     */
    inline trGetUpdateHistoryDetailedRequest& getRequestMutable ();

    /**
     * Sets the value of the member "request".
     *
     * If the meaning of "request" isn't clear, then there should be a description here.
     *
     * @param request The value which will be set
     */
    inline void setRequest (const trGetUpdateHistoryDetailedRequest& request_);

    static const GetUpdateHistoryDetailedRequest &getDefaultInstance();

private:

    inline void set_has_request ();

    inline void clear_has_request ();

    uint32 _has_bits_[ (1 + 31) / 32];

    trGetUpdateHistoryDetailedRequest _request;

};

/**
 * If the meaning of "GetUpdateHistoryDetailed" isn't clear, then there should be a description here.
 */
class GetUpdateHistoryDetailedResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetUpdateHistoryDetailedResponse ();

    /**
     * Copy constructor
     */
    inline  GetUpdateHistoryDetailedResponse (const GetUpdateHistoryDetailedResponse &rhs);

    /**
     * All fields constructor
     */
    inline  GetUpdateHistoryDetailedResponse (bool bOk_, const trGetUpdateHistoryDetailed& result_);

    /**
     * Destructor
     */
    inline virtual  ~GetUpdateHistoryDetailedResponse();

    /**
     * Assignment operator
     */
    inline GetUpdateHistoryDetailedResponse& operator = (const GetUpdateHistoryDetailedResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetUpdateHistoryDetailedResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetUpdateHistoryDetailedResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetUpdateHistoryDetailedResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetUpdateHistoryDetailedResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bOk"

    static const int kBOk = 0;

    /**
     * Clears the field "bOk".
     *
     * The field will be set to its default value. The hasBOk()
     * method will return false.
     */
    inline void clearBOk();

    /**
     * Checks whether the field "bOk" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBOk()). Otherwise it will return false.
     */
    inline bool hasBOk () const;

    /**
     * Returns the value of the member "bOk".
     *
     * If the meaning of "bOk" isn't clear, then there should be a description here.
     *
     * @return The value of the field "bOk"
     */
    inline bool getBOk () const;

    /**
     * Sets the value of the member "bOk".
     *
     * If the meaning of "bOk" isn't clear, then there should be a description here.
     *
     * @param bOk The value which will be set
     */
    inline void setBOk (bool bOk_);

    // API of field "result"

    static const int kResult = 1;

    /**
     * Clears the field "result".
     *
     * The field will be set to its default value. The hasResult()
     * method will return false.
     */
    inline void clearResult();

    /**
     * Checks whether the field "result" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResult()). Otherwise it will return false.
     */
    inline bool hasResult () const;

    /**
     * Returns the value of the member "result".
     *
     * If the meaning of "result" isn't clear, then there should be a description here.
     *
     * @return The value of the field "result"
     */
    inline const trGetUpdateHistoryDetailed& getResult () const;

    /**
     * Retrieves the value of the field "result" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "result".
     */
    inline trGetUpdateHistoryDetailed& getResultMutable ();

    /**
     * Sets the value of the member "result".
     *
     * If the meaning of "result" isn't clear, then there should be a description here.
     *
     * @param result The value which will be set
     */
    inline void setResult (const trGetUpdateHistoryDetailed& result_);

    static const GetUpdateHistoryDetailedResponse &getDefaultInstance();

private:

    inline void set_has_bOk ();

    inline void clear_has_bOk ();

    inline void set_has_result ();

    inline void clear_has_result ();

    uint32 _has_bits_[ (2 + 31) / 32];

    bool _bOk;

    trGetUpdateHistoryDetailed _result;

};

/**
 * If the meaning of "DeleteHistoryRequest" isn't clear, then there should be a description here.
 */
class DeleteHistoryRequestRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DeleteHistoryRequestRequest ();

    /**
     * Copy constructor
     */
    inline  DeleteHistoryRequestRequest (const DeleteHistoryRequestRequest &rhs);

    /**
     * All fields constructor
     */
    inline  DeleteHistoryRequestRequest (bool sinceFactoryResetOnly_);

    /**
     * Destructor
     */
    inline virtual  ~DeleteHistoryRequestRequest();

    /**
     * Assignment operator
     */
    inline DeleteHistoryRequestRequest& operator = (const DeleteHistoryRequestRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DeleteHistoryRequestRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DeleteHistoryRequestRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DeleteHistoryRequestRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DeleteHistoryRequestRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "sinceFactoryResetOnly"

    static const int kSinceFactoryResetOnly = 0;

    /**
     * Clears the field "sinceFactoryResetOnly".
     *
     * The field will be set to its default value. The hasSinceFactoryResetOnly()
     * method will return false.
     */
    inline void clearSinceFactoryResetOnly();

    /**
     * Checks whether the field "sinceFactoryResetOnly" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSinceFactoryResetOnly()). Otherwise it will return false.
     */
    inline bool hasSinceFactoryResetOnly () const;

    /**
     * Returns the value of the member "sinceFactoryResetOnly".
     *
     * If the meaning of "sinceFactoryResetOnly" isn't clear, then there should be a description here.
     *
     * @return The value of the field "sinceFactoryResetOnly"
     */
    inline bool getSinceFactoryResetOnly () const;

    /**
     * Sets the value of the member "sinceFactoryResetOnly".
     *
     * If the meaning of "sinceFactoryResetOnly" isn't clear, then there should be a description here.
     *
     * @param sinceFactoryResetOnly The value which will be set
     */
    inline void setSinceFactoryResetOnly (bool sinceFactoryResetOnly_);

    static const DeleteHistoryRequestRequest &getDefaultInstance();

private:

    inline void set_has_sinceFactoryResetOnly ();

    inline void clear_has_sinceFactoryResetOnly ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _sinceFactoryResetOnly;

};

/**
 * If the meaning of "DeleteHistoryRequest" isn't clear, then there should be a description here.
 */
class DeleteHistoryRequestResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DeleteHistoryRequestResponse ();

    /**
     * Copy constructor
     */
    inline  DeleteHistoryRequestResponse (const DeleteHistoryRequestResponse &rhs);

    /**
     * All fields constructor
     */
    inline  DeleteHistoryRequestResponse (bool bOk_);

    /**
     * Destructor
     */
    inline virtual  ~DeleteHistoryRequestResponse();

    /**
     * Assignment operator
     */
    inline DeleteHistoryRequestResponse& operator = (const DeleteHistoryRequestResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DeleteHistoryRequestResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DeleteHistoryRequestResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DeleteHistoryRequestResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DeleteHistoryRequestResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bOk"

    static const int kBOk = 0;

    /**
     * Clears the field "bOk".
     *
     * The field will be set to its default value. The hasBOk()
     * method will return false.
     */
    inline void clearBOk();

    /**
     * Checks whether the field "bOk" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBOk()). Otherwise it will return false.
     */
    inline bool hasBOk () const;

    /**
     * Returns the value of the member "bOk".
     *
     * If the meaning of "bOk" isn't clear, then there should be a description here.
     *
     * @return The value of the field "bOk"
     */
    inline bool getBOk () const;

    /**
     * Sets the value of the member "bOk".
     *
     * If the meaning of "bOk" isn't clear, then there should be a description here.
     *
     * @param bOk The value which will be set
     */
    inline void setBOk (bool bOk_);

    static const DeleteHistoryRequestResponse &getDefaultInstance();

private:

    inline void set_has_bOk ();

    inline void clear_has_bOk ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _bOk;

};

/**
 * If the meaning of "GetTargetState" isn't clear, then there should be a description here.
 */
class GetTargetStateRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetTargetStateRequest ();

    /**
     * Copy constructor
     */
    inline  GetTargetStateRequest (const GetTargetStateRequest &rhs);

    /**
     * All fields constructor
     */
    inline  GetTargetStateRequest (tenUpdType enUpdateType_);

    /**
     * Destructor
     */
    inline virtual  ~GetTargetStateRequest();

    /**
     * Assignment operator
     */
    inline GetTargetStateRequest& operator = (const GetTargetStateRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetTargetStateRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetTargetStateRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetTargetStateRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetTargetStateRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "enUpdateType"

    static const int kEnUpdateType = 0;

    /**
     * Clears the field "enUpdateType".
     *
     * The field will be set to its default value. The hasEnUpdateType()
     * method will return false.
     */
    inline void clearEnUpdateType();

    /**
     * Checks whether the field "enUpdateType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEnUpdateType()). Otherwise it will return false.
     */
    inline bool hasEnUpdateType () const;

    /**
     * Returns the value of the member "enUpdateType".
     *
     * If the meaning of "enUpdateType" isn't clear, then there should be a description here.
     *
     * @return The value of the field "enUpdateType"
     */
    inline tenUpdType getEnUpdateType () const;

    /**
     * Sets the value of the member "enUpdateType".
     *
     * If the meaning of "enUpdateType" isn't clear, then there should be a description here.
     *
     * @param enUpdateType The value which will be set
     */
    inline void setEnUpdateType (tenUpdType enUpdateType_);

    static const GetTargetStateRequest &getDefaultInstance();

private:

    inline void set_has_enUpdateType ();

    inline void clear_has_enUpdateType ();

    uint32 _has_bits_[ (1 + 31) / 32];

    tenUpdType _enUpdateType;

};

/**
 * If the meaning of "GetTargetState" isn't clear, then there should be a description here.
 */
class GetTargetStateResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetTargetStateResponse ();

    /**
     * Copy constructor
     */
    inline  GetTargetStateResponse (const GetTargetStateResponse &rhs);

    /**
     * All fields constructor
     */
    inline  GetTargetStateResponse (bool bOk_, const trTartgetState& targetState_);

    /**
     * Destructor
     */
    inline virtual  ~GetTargetStateResponse();

    /**
     * Assignment operator
     */
    inline GetTargetStateResponse& operator = (const GetTargetStateResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetTargetStateResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetTargetStateResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetTargetStateResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetTargetStateResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bOk"

    static const int kBOk = 0;

    /**
     * Clears the field "bOk".
     *
     * The field will be set to its default value. The hasBOk()
     * method will return false.
     */
    inline void clearBOk();

    /**
     * Checks whether the field "bOk" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBOk()). Otherwise it will return false.
     */
    inline bool hasBOk () const;

    /**
     * Returns the value of the member "bOk".
     *
     * If the meaning of "bOk" isn't clear, then there should be a description here.
     *
     * @return The value of the field "bOk"
     */
    inline bool getBOk () const;

    /**
     * Sets the value of the member "bOk".
     *
     * If the meaning of "bOk" isn't clear, then there should be a description here.
     *
     * @param bOk The value which will be set
     */
    inline void setBOk (bool bOk_);

    // API of field "targetState"

    static const int kTargetState = 1;

    /**
     * Clears the field "targetState".
     *
     * The field will be set to its default value. The hasTargetState()
     * method will return false.
     */
    inline void clearTargetState();

    /**
     * Checks whether the field "targetState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTargetState()). Otherwise it will return false.
     */
    inline bool hasTargetState () const;

    /**
     * Returns the value of the member "targetState".
     *
     * If the meaning of "targetState" isn't clear, then there should be a description here.
     *
     * @return The value of the field "targetState"
     */
    inline const trTartgetState& getTargetState () const;

    /**
     * Retrieves the value of the field "targetState" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "targetState".
     */
    inline trTartgetState& getTargetStateMutable ();

    /**
     * Sets the value of the member "targetState".
     *
     * If the meaning of "targetState" isn't clear, then there should be a description here.
     *
     * @param targetState The value which will be set
     */
    inline void setTargetState (const trTartgetState& targetState_);

    static const GetTargetStateResponse &getDefaultInstance();

private:

    inline void set_has_bOk ();

    inline void clear_has_bOk ();

    inline void set_has_targetState ();

    inline void clear_has_targetState ();

    uint32 _has_bits_[ (2 + 31) / 32];

    bool _bOk;

    trTartgetState _targetState;

};

/**
 * If the meaning of "SetVersionBackDocAck" isn't clear, then there should be a description here.
 */
class SetVersionBackDocAckRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetVersionBackDocAckRequest ();

    /**
     * Copy constructor
     */
    inline  SetVersionBackDocAckRequest (const SetVersionBackDocAckRequest &rhs);

    /**
     * All fields constructor
     */
    inline  SetVersionBackDocAckRequest (uint16 ack_);

    /**
     * Destructor
     */
    inline virtual  ~SetVersionBackDocAckRequest();

    /**
     * Assignment operator
     */
    inline SetVersionBackDocAckRequest& operator = (const SetVersionBackDocAckRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetVersionBackDocAckRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetVersionBackDocAckRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetVersionBackDocAckRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetVersionBackDocAckRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ack"

    static const int kAck = 0;

    /**
     * Clears the field "ack".
     *
     * The field will be set to its default value. The hasAck()
     * method will return false.
     */
    inline void clearAck();

    /**
     * Checks whether the field "ack" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAck()). Otherwise it will return false.
     */
    inline bool hasAck () const;

    /**
     * Returns the value of the member "ack".
     *
     * If the meaning of "ack" isn't clear, then there should be a description here.
     *
     * @return The value of the field "ack"
     */
    inline uint16 getAck () const;

    /**
     * Sets the value of the member "ack".
     *
     * If the meaning of "ack" isn't clear, then there should be a description here.
     *
     * @param ack The value which will be set
     */
    inline void setAck (uint16 ack_);

    static const SetVersionBackDocAckRequest &getDefaultInstance();

private:

    inline void set_has_ack ();

    inline void clear_has_ack ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _ack;

};

/**
 * If the meaning of "SetVersionBackDocAck" isn't clear, then there should be a description here.
 */
class SetVersionBackDocAckResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetVersionBackDocAckResponse ();

    /**
     * Copy constructor
     */
    inline  SetVersionBackDocAckResponse (const SetVersionBackDocAckResponse &rhs);

    /**
     * All fields constructor
     */
    inline  SetVersionBackDocAckResponse (bool bOk_, const trVersionBackDocInfo& info_);

    /**
     * Destructor
     */
    inline virtual  ~SetVersionBackDocAckResponse();

    /**
     * Assignment operator
     */
    inline SetVersionBackDocAckResponse& operator = (const SetVersionBackDocAckResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetVersionBackDocAckResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetVersionBackDocAckResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetVersionBackDocAckResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetVersionBackDocAckResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bOk"

    static const int kBOk = 0;

    /**
     * Clears the field "bOk".
     *
     * The field will be set to its default value. The hasBOk()
     * method will return false.
     */
    inline void clearBOk();

    /**
     * Checks whether the field "bOk" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBOk()). Otherwise it will return false.
     */
    inline bool hasBOk () const;

    /**
     * Returns the value of the member "bOk".
     *
     * If the meaning of "bOk" isn't clear, then there should be a description here.
     *
     * @return The value of the field "bOk"
     */
    inline bool getBOk () const;

    /**
     * Sets the value of the member "bOk".
     *
     * If the meaning of "bOk" isn't clear, then there should be a description here.
     *
     * @param bOk The value which will be set
     */
    inline void setBOk (bool bOk_);

    // API of field "info"

    static const int kInfo = 1;

    /**
     * Clears the field "info".
     *
     * The field will be set to its default value. The hasInfo()
     * method will return false.
     */
    inline void clearInfo();

    /**
     * Checks whether the field "info" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setInfo()). Otherwise it will return false.
     */
    inline bool hasInfo () const;

    /**
     * Returns the value of the member "info".
     *
     * If the meaning of "info" isn't clear, then there should be a description here.
     *
     * @return The value of the field "info"
     */
    inline const trVersionBackDocInfo& getInfo () const;

    /**
     * Retrieves the value of the field "info" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "info".
     */
    inline trVersionBackDocInfo& getInfoMutable ();

    /**
     * Sets the value of the member "info".
     *
     * If the meaning of "info" isn't clear, then there should be a description here.
     *
     * @param info The value which will be set
     */
    inline void setInfo (const trVersionBackDocInfo& info_);

    static const SetVersionBackDocAckResponse &getDefaultInstance();

private:

    inline void set_has_bOk ();

    inline void clear_has_bOk ();

    inline void set_has_info ();

    inline void clear_has_info ();

    uint32 _has_bits_[ (2 + 31) / 32];

    bool _bOk;

    trVersionBackDocInfo _info;

};

/**
 * If the meaning of "SetAllowRecoveryMode" isn't clear, then there should be a description here.
 */
class SetAllowRecoveryModeRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetAllowRecoveryModeRequest ();

    /**
     * Copy constructor
     */
    inline  SetAllowRecoveryModeRequest (const SetAllowRecoveryModeRequest &rhs);

    /**
     * All fields constructor
     */
    inline  SetAllowRecoveryModeRequest (bool allow_);

    /**
     * Destructor
     */
    inline virtual  ~SetAllowRecoveryModeRequest();

    /**
     * Assignment operator
     */
    inline SetAllowRecoveryModeRequest& operator = (const SetAllowRecoveryModeRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetAllowRecoveryModeRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetAllowRecoveryModeRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetAllowRecoveryModeRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetAllowRecoveryModeRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "allow"

    static const int kAllow = 0;

    /**
     * Clears the field "allow".
     *
     * The field will be set to its default value. The hasAllow()
     * method will return false.
     */
    inline void clearAllow();

    /**
     * Checks whether the field "allow" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAllow()). Otherwise it will return false.
     */
    inline bool hasAllow () const;

    /**
     * Returns the value of the member "allow".
     *
     * If the meaning of "allow" isn't clear, then there should be a description here.
     *
     * @return The value of the field "allow"
     */
    inline bool getAllow () const;

    /**
     * Sets the value of the member "allow".
     *
     * If the meaning of "allow" isn't clear, then there should be a description here.
     *
     * @param allow The value which will be set
     */
    inline void setAllow (bool allow_);

    static const SetAllowRecoveryModeRequest &getDefaultInstance();

private:

    inline void set_has_allow ();

    inline void clear_has_allow ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _allow;

};

/**
 * If the meaning of "SetAllowRecoveryMode" isn't clear, then there should be a description here.
 */
class SetAllowRecoveryModeResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetAllowRecoveryModeResponse ();

    /**
     * Copy constructor
     */
    inline  SetAllowRecoveryModeResponse (const SetAllowRecoveryModeResponse &rhs);

    /**
     * All fields constructor
     */
    inline  SetAllowRecoveryModeResponse (bool bOk_);

    /**
     * Destructor
     */
    inline virtual  ~SetAllowRecoveryModeResponse();

    /**
     * Assignment operator
     */
    inline SetAllowRecoveryModeResponse& operator = (const SetAllowRecoveryModeResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetAllowRecoveryModeResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetAllowRecoveryModeResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetAllowRecoveryModeResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetAllowRecoveryModeResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bOk"

    static const int kBOk = 0;

    /**
     * Clears the field "bOk".
     *
     * The field will be set to its default value. The hasBOk()
     * method will return false.
     */
    inline void clearBOk();

    /**
     * Checks whether the field "bOk" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBOk()). Otherwise it will return false.
     */
    inline bool hasBOk () const;

    /**
     * Returns the value of the member "bOk".
     *
     * If the meaning of "bOk" isn't clear, then there should be a description here.
     *
     * @return The value of the field "bOk"
     */
    inline bool getBOk () const;

    /**
     * Sets the value of the member "bOk".
     *
     * If the meaning of "bOk" isn't clear, then there should be a description here.
     *
     * @param bOk The value which will be set
     */
    inline void setBOk (bool bOk_);

    static const SetAllowRecoveryModeResponse &getDefaultInstance();

private:

    inline void set_has_bOk ();

    inline void clear_has_bOk ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _bOk;

};

/**
 * Request for a directory to store cache-data
 */
class GetCacheDirectoryRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetCacheDirectoryRequest ();

    /**
     * Copy constructor
     */
    inline  GetCacheDirectoryRequest (const GetCacheDirectoryRequest &rhs);

    /**
     * All fields constructor
     */
    inline  GetCacheDirectoryRequest (const trGetCacheDirectory& request_);

    /**
     * Destructor
     */
    inline virtual  ~GetCacheDirectoryRequest();

    /**
     * Assignment operator
     */
    inline GetCacheDirectoryRequest& operator = (const GetCacheDirectoryRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetCacheDirectoryRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetCacheDirectoryRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetCacheDirectoryRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetCacheDirectoryRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "request"

    static const int kRequest = 0;

    /**
     * Clears the field "request".
     *
     * The field will be set to its default value. The hasRequest()
     * method will return false.
     */
    inline void clearRequest();

    /**
     * Checks whether the field "request" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRequest()). Otherwise it will return false.
     */
    inline bool hasRequest () const;

    /**
     * Returns the value of the member "request".
     *
     * If the meaning of "request" isn't clear, then there should be a description here.
     *
     * @return The value of the field "request"
     */
    inline const trGetCacheDirectory& getRequest () const;

    /**
     * Retrieves the value of the field "request" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "request".
     */
    inline trGetCacheDirectory& getRequestMutable ();

    /**
     * Sets the value of the member "request".
     *
     * If the meaning of "request" isn't clear, then there should be a description here.
     *
     * @param request The value which will be set
     */
    inline void setRequest (const trGetCacheDirectory& request_);

    static const GetCacheDirectoryRequest &getDefaultInstance();

private:

    inline void set_has_request ();

    inline void clear_has_request ();

    uint32 _has_bits_[ (1 + 31) / 32];

    trGetCacheDirectory _request;

};

/**
 * Request for a directory to store cache-data
 */
class GetCacheDirectoryResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetCacheDirectoryResponse ();

    /**
     * Copy constructor
     */
    inline  GetCacheDirectoryResponse (const GetCacheDirectoryResponse &rhs);

    /**
     * All fields constructor
     */
    inline  GetCacheDirectoryResponse (bool bOk_, const ::std::string& directory_);

    /**
     * Destructor
     */
    inline virtual  ~GetCacheDirectoryResponse();

    /**
     * Assignment operator
     */
    inline GetCacheDirectoryResponse& operator = (const GetCacheDirectoryResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetCacheDirectoryResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetCacheDirectoryResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetCacheDirectoryResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetCacheDirectoryResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bOk"

    static const int kBOk = 0;

    /**
     * Clears the field "bOk".
     *
     * The field will be set to its default value. The hasBOk()
     * method will return false.
     */
    inline void clearBOk();

    /**
     * Checks whether the field "bOk" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBOk()). Otherwise it will return false.
     */
    inline bool hasBOk () const;

    /**
     * Returns the value of the member "bOk".
     *
     * If the meaning of "bOk" isn't clear, then there should be a description here.
     *
     * @return The value of the field "bOk"
     */
    inline bool getBOk () const;

    /**
     * Sets the value of the member "bOk".
     *
     * If the meaning of "bOk" isn't clear, then there should be a description here.
     *
     * @param bOk The value which will be set
     */
    inline void setBOk (bool bOk_);

    // API of field "directory"

    static const int kDirectory = 1;

    /**
     * Clears the field "directory".
     *
     * The field will be set to its default value. The hasDirectory()
     * method will return false.
     */
    inline void clearDirectory();

    /**
     * Checks whether the field "directory" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDirectory()). Otherwise it will return false.
     */
    inline bool hasDirectory () const;

    /**
     * Returns the value of the member "directory".
     *
     * If the meaning of "directory" isn't clear, then there should be a description here.
     *
     * @return The value of the field "directory"
     */
    inline const ::std::string& getDirectory () const;

    /**
     * Retrieves the value of the field "directory" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "directory".
     */
    inline ::std::string& getDirectoryMutable ();

    /**
     * Sets the value of the member "directory".
     *
     * If the meaning of "directory" isn't clear, then there should be a description here.
     *
     * @param directory The value which will be set
     */
    inline void setDirectory (const ::std::string& directory_);

    /**
     * Sets the value of the member "directory".
     *
     * If the meaning of "directory" isn't clear, then there should be a description here.
     *
     * @param directory The value which will be set
     */
    inline void setDirectory (const char* directory_);

    /**
     * Sets the value of the member "directory".
     *
     * If the meaning of "directory" isn't clear, then there should be a description here.
     *
     * @param directory The value which will be set
     */
    inline void setDirectory (const char* value, size_t size);

    static const GetCacheDirectoryResponse &getDefaultInstance();

private:

    inline void set_has_bOk ();

    inline void clear_has_bOk ();

    inline void set_has_directory ();

    inline void clear_has_directory ();

    uint32 _has_bits_[ (2 + 31) / 32];

    bool _bOk;

    ::std::string _directory;

};

/**
 * If the meaning of "EnterRecoveryMode" isn't clear, then there should be a description here.
 */
class EnterRecoveryModeResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  EnterRecoveryModeResponse ();

    /**
     * Copy constructor
     */
    inline  EnterRecoveryModeResponse (const EnterRecoveryModeResponse &rhs);

    /**
     * All fields constructor
     */
    inline  EnterRecoveryModeResponse (bool bOk_);

    /**
     * Destructor
     */
    inline virtual  ~EnterRecoveryModeResponse();

    /**
     * Assignment operator
     */
    inline EnterRecoveryModeResponse& operator = (const EnterRecoveryModeResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const EnterRecoveryModeResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const EnterRecoveryModeResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const EnterRecoveryModeResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const EnterRecoveryModeResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bOk"

    static const int kBOk = 0;

    /**
     * Clears the field "bOk".
     *
     * The field will be set to its default value. The hasBOk()
     * method will return false.
     */
    inline void clearBOk();

    /**
     * Checks whether the field "bOk" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBOk()). Otherwise it will return false.
     */
    inline bool hasBOk () const;

    /**
     * Returns the value of the member "bOk".
     *
     * If the meaning of "bOk" isn't clear, then there should be a description here.
     *
     * @return The value of the field "bOk"
     */
    inline bool getBOk () const;

    /**
     * Sets the value of the member "bOk".
     *
     * If the meaning of "bOk" isn't clear, then there should be a description here.
     *
     * @param bOk The value which will be set
     */
    inline void setBOk (bool bOk_);

    static const EnterRecoveryModeResponse &getDefaultInstance();

private:

    inline void set_has_bOk ();

    inline void clear_has_bOk ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _bOk;

};

/**
 * If the meaning of "VerifyChecksum" isn't clear, then there should be a description here.
 */
class VerifyChecksumRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  VerifyChecksumRequest ();

    /**
     * Copy constructor
     */
    inline  VerifyChecksumRequest (const VerifyChecksumRequest &rhs);

    /**
     * All fields constructor
     */
    inline  VerifyChecksumRequest (const trVerifyChecksumRequest& verifyRequest_);

    /**
     * Destructor
     */
    inline virtual  ~VerifyChecksumRequest();

    /**
     * Assignment operator
     */
    inline VerifyChecksumRequest& operator = (const VerifyChecksumRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const VerifyChecksumRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const VerifyChecksumRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const VerifyChecksumRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const VerifyChecksumRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "verifyRequest"

    static const int kVerifyRequest = 0;

    /**
     * Clears the field "verifyRequest".
     *
     * The field will be set to its default value. The hasVerifyRequest()
     * method will return false.
     */
    inline void clearVerifyRequest();

    /**
     * Checks whether the field "verifyRequest" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setVerifyRequest()). Otherwise it will return false.
     */
    inline bool hasVerifyRequest () const;

    /**
     * Returns the value of the member "verifyRequest".
     *
     * If the meaning of "verifyRequest" isn't clear, then there should be a description here.
     *
     * @return The value of the field "verifyRequest"
     */
    inline const trVerifyChecksumRequest& getVerifyRequest () const;

    /**
     * Retrieves the value of the field "verifyRequest" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "verifyRequest".
     */
    inline trVerifyChecksumRequest& getVerifyRequestMutable ();

    /**
     * Sets the value of the member "verifyRequest".
     *
     * If the meaning of "verifyRequest" isn't clear, then there should be a description here.
     *
     * @param verifyRequest The value which will be set
     */
    inline void setVerifyRequest (const trVerifyChecksumRequest& verifyRequest_);

    static const VerifyChecksumRequest &getDefaultInstance();

private:

    inline void set_has_verifyRequest ();

    inline void clear_has_verifyRequest ();

    uint32 _has_bits_[ (1 + 31) / 32];

    trVerifyChecksumRequest _verifyRequest;

};

/**
 * If the meaning of "VerifyChecksum" isn't clear, then there should be a description here.
 */
class VerifyChecksumResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  VerifyChecksumResponse ();

    /**
     * Copy constructor
     */
    inline  VerifyChecksumResponse (const VerifyChecksumResponse &rhs);

    /**
     * All fields constructor
     */
    inline  VerifyChecksumResponse (bool bOk_, const trVerifyChecksumResult& verifyResult_);

    /**
     * Destructor
     */
    inline virtual  ~VerifyChecksumResponse();

    /**
     * Assignment operator
     */
    inline VerifyChecksumResponse& operator = (const VerifyChecksumResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const VerifyChecksumResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const VerifyChecksumResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const VerifyChecksumResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const VerifyChecksumResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bOk"

    static const int kBOk = 0;

    /**
     * Clears the field "bOk".
     *
     * The field will be set to its default value. The hasBOk()
     * method will return false.
     */
    inline void clearBOk();

    /**
     * Checks whether the field "bOk" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBOk()). Otherwise it will return false.
     */
    inline bool hasBOk () const;

    /**
     * Returns the value of the member "bOk".
     *
     * If the meaning of "bOk" isn't clear, then there should be a description here.
     *
     * @return The value of the field "bOk"
     */
    inline bool getBOk () const;

    /**
     * Sets the value of the member "bOk".
     *
     * If the meaning of "bOk" isn't clear, then there should be a description here.
     *
     * @param bOk The value which will be set
     */
    inline void setBOk (bool bOk_);

    // API of field "verifyResult"

    static const int kVerifyResult = 1;

    /**
     * Clears the field "verifyResult".
     *
     * The field will be set to its default value. The hasVerifyResult()
     * method will return false.
     */
    inline void clearVerifyResult();

    /**
     * Checks whether the field "verifyResult" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setVerifyResult()). Otherwise it will return false.
     */
    inline bool hasVerifyResult () const;

    /**
     * Returns the value of the member "verifyResult".
     *
     * If the meaning of "verifyResult" isn't clear, then there should be a description here.
     *
     * @return The value of the field "verifyResult"
     */
    inline const trVerifyChecksumResult& getVerifyResult () const;

    /**
     * Retrieves the value of the field "verifyResult" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "verifyResult".
     */
    inline trVerifyChecksumResult& getVerifyResultMutable ();

    /**
     * Sets the value of the member "verifyResult".
     *
     * If the meaning of "verifyResult" isn't clear, then there should be a description here.
     *
     * @param verifyResult The value which will be set
     */
    inline void setVerifyResult (const trVerifyChecksumResult& verifyResult_);

    static const VerifyChecksumResponse &getDefaultInstance();

private:

    inline void set_has_bOk ();

    inline void clear_has_bOk ();

    inline void set_has_verifyResult ();

    inline void clear_has_verifyResult ();

    uint32 _has_bits_[ (2 + 31) / 32];

    bool _bOk;

    trVerifyChecksumResult _verifyResult;

};

/**
 * User configures, which bg-locks will be requested before passing them
 */
class RegisterBgLocksRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RegisterBgLocksRequest ();

    /**
     * Copy constructor
     */
    inline  RegisterBgLocksRequest (const RegisterBgLocksRequest &rhs);

    /**
     * All fields constructor
     */
    inline  RegisterBgLocksRequest (const trBgLocks& locks_, tenLockRegisterMode mode_);

    /**
     * Destructor
     */
    inline virtual  ~RegisterBgLocksRequest();

    /**
     * Assignment operator
     */
    inline RegisterBgLocksRequest& operator = (const RegisterBgLocksRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RegisterBgLocksRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RegisterBgLocksRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RegisterBgLocksRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RegisterBgLocksRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "locks"

    static const int kLocks = 0;

    /**
     * Clears the field "locks".
     *
     * The field will be set to its default value. The hasLocks()
     * method will return false.
     */
    inline void clearLocks();

    /**
     * Checks whether the field "locks" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLocks()). Otherwise it will return false.
     */
    inline bool hasLocks () const;

    /**
     * Returns the value of the member "locks".
     *
     * If the meaning of "locks" isn't clear, then there should be a description here.
     *
     * @return The value of the field "locks"
     */
    inline const trBgLocks& getLocks () const;

    /**
     * Retrieves the value of the field "locks" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "locks".
     */
    inline trBgLocks& getLocksMutable ();

    /**
     * Sets the value of the member "locks".
     *
     * If the meaning of "locks" isn't clear, then there should be a description here.
     *
     * @param locks The value which will be set
     */
    inline void setLocks (const trBgLocks& locks_);

    // API of field "mode"

    static const int kMode = 1;

    /**
     * Clears the field "mode".
     *
     * The field will be set to its default value. The hasMode()
     * method will return false.
     */
    inline void clearMode();

    /**
     * Checks whether the field "mode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMode()). Otherwise it will return false.
     */
    inline bool hasMode () const;

    /**
     * Returns the value of the member "mode".
     *
     * If the meaning of "mode" isn't clear, then there should be a description here.
     *
     * @return The value of the field "mode"
     */
    inline tenLockRegisterMode getMode () const;

    /**
     * Sets the value of the member "mode".
     *
     * If the meaning of "mode" isn't clear, then there should be a description here.
     *
     * @param mode The value which will be set
     */
    inline void setMode (tenLockRegisterMode mode_);

    static const RegisterBgLocksRequest &getDefaultInstance();

private:

    inline void set_has_locks ();

    inline void clear_has_locks ();

    inline void set_has_mode ();

    inline void clear_has_mode ();

    uint32 _has_bits_[ (2 + 31) / 32];

    trBgLocks _locks;

    tenLockRegisterMode _mode;

};

/**
 * User configures, which bg-locks will be requested before passing them
 */
class RegisterBgLocksResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RegisterBgLocksResponse ();

    /**
     * Copy constructor
     */
    inline  RegisterBgLocksResponse (const RegisterBgLocksResponse &rhs);

    /**
     * All fields constructor
     */
    inline  RegisterBgLocksResponse (bool bOk_);

    /**
     * Destructor
     */
    inline virtual  ~RegisterBgLocksResponse();

    /**
     * Assignment operator
     */
    inline RegisterBgLocksResponse& operator = (const RegisterBgLocksResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RegisterBgLocksResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RegisterBgLocksResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RegisterBgLocksResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RegisterBgLocksResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bOk"

    static const int kBOk = 0;

    /**
     * Clears the field "bOk".
     *
     * The field will be set to its default value. The hasBOk()
     * method will return false.
     */
    inline void clearBOk();

    /**
     * Checks whether the field "bOk" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBOk()). Otherwise it will return false.
     */
    inline bool hasBOk () const;

    /**
     * Returns the value of the member "bOk".
     *
     * If the meaning of "bOk" isn't clear, then there should be a description here.
     *
     * @return The value of the field "bOk"
     */
    inline bool getBOk () const;

    /**
     * Sets the value of the member "bOk".
     *
     * If the meaning of "bOk" isn't clear, then there should be a description here.
     *
     * @param bOk The value which will be set
     */
    inline void setBOk (bool bOk_);

    static const RegisterBgLocksResponse &getDefaultInstance();

private:

    inline void set_has_bOk ();

    inline void clear_has_bOk ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _bOk;

};

/**
 * If the meaning of "UpdateState" isn't clear, then there should be a description here.
 */
class UpdateStateUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  UpdateStateUpdate ();

    /**
     * Copy constructor
     */
    inline  UpdateStateUpdate (const UpdateStateUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  UpdateStateUpdate (const trUpdState& UpdateState_);

    /**
     * Destructor
     */
    inline virtual  ~UpdateStateUpdate();

    /**
     * Assignment operator
     */
    inline UpdateStateUpdate& operator = (const UpdateStateUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const UpdateStateUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const UpdateStateUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const UpdateStateUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const UpdateStateUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "UpdateState"

    static const int kUpdateState = 0;

    /**
     * Clears the field "UpdateState".
     *
     * The field will be set to its default value. The hasUpdateState()
     * method will return false.
     */
    inline void clearUpdateState();

    /**
     * Checks whether the field "UpdateState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setUpdateState()). Otherwise it will return false.
     */
    inline bool hasUpdateState () const;

    /**
     * Returns the value of the member "UpdateState".
     *
     * If the meaning of "UpdateState" isn't clear, then there should be a description here.
     *
     * @return The value of the field "UpdateState"
     */
    inline const trUpdState& getUpdateState () const;

    /**
     * Retrieves the value of the field "UpdateState" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "UpdateState".
     */
    inline trUpdState& getUpdateStateMutable ();

    /**
     * Sets the value of the member "UpdateState".
     *
     * If the meaning of "UpdateState" isn't clear, then there should be a description here.
     *
     * @param UpdateState The value which will be set
     */
    inline void setUpdateState (const trUpdState& UpdateState_);

    static const UpdateStateUpdate &getDefaultInstance();

private:

    inline void set_has_UpdateState ();

    inline void clear_has_UpdateState ();

    uint32 _has_bits_[ (1 + 31) / 32];

    trUpdState _UpdateState;

};

/**
 * If the meaning of "UpdateState" isn't clear, then there should be a description here.
 */
class UpdateStateRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  UpdateStateRegister ();

    /**
     * Copy constructor
     */
    inline  UpdateStateRegister (const UpdateStateRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~UpdateStateRegister();

    /**
     * Assignment operator
     */
    inline UpdateStateRegister& operator = (const UpdateStateRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const UpdateStateRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const UpdateStateRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const UpdateStateRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const UpdateStateRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const UpdateStateRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "UpdateSources" isn't clear, then there should be a description here.
 */
class UpdateSourcesUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  UpdateSourcesUpdate ();

    /**
     * Copy constructor
     */
    inline  UpdateSourcesUpdate (const UpdateSourcesUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  UpdateSourcesUpdate (const trUpdSources& UpdateSources_);

    /**
     * Destructor
     */
    inline virtual  ~UpdateSourcesUpdate();

    /**
     * Assignment operator
     */
    inline UpdateSourcesUpdate& operator = (const UpdateSourcesUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const UpdateSourcesUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const UpdateSourcesUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const UpdateSourcesUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const UpdateSourcesUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "UpdateSources"

    static const int kUpdateSources = 0;

    /**
     * Clears the field "UpdateSources".
     *
     * The field will be set to its default value. The hasUpdateSources()
     * method will return false.
     */
    inline void clearUpdateSources();

    /**
     * Checks whether the field "UpdateSources" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setUpdateSources()). Otherwise it will return false.
     */
    inline bool hasUpdateSources () const;

    /**
     * Returns the value of the member "UpdateSources".
     *
     * If the meaning of "UpdateSources" isn't clear, then there should be a description here.
     *
     * @return The value of the field "UpdateSources"
     */
    inline const trUpdSources& getUpdateSources () const;

    /**
     * Retrieves the value of the field "UpdateSources" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "UpdateSources".
     */
    inline trUpdSources& getUpdateSourcesMutable ();

    /**
     * Sets the value of the member "UpdateSources".
     *
     * If the meaning of "UpdateSources" isn't clear, then there should be a description here.
     *
     * @param UpdateSources The value which will be set
     */
    inline void setUpdateSources (const trUpdSources& UpdateSources_);

    static const UpdateSourcesUpdate &getDefaultInstance();

private:

    inline void set_has_UpdateSources ();

    inline void clear_has_UpdateSources ();

    uint32 _has_bits_[ (1 + 31) / 32];

    trUpdSources _UpdateSources;

};

/**
 * If the meaning of "UpdateSources" isn't clear, then there should be a description here.
 */
class UpdateSourcesRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  UpdateSourcesRegister ();

    /**
     * Copy constructor
     */
    inline  UpdateSourcesRegister (const UpdateSourcesRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~UpdateSourcesRegister();

    /**
     * Assignment operator
     */
    inline UpdateSourcesRegister& operator = (const UpdateSourcesRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const UpdateSourcesRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const UpdateSourcesRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const UpdateSourcesRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const UpdateSourcesRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const UpdateSourcesRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "ReleaseFilter" isn't clear, then there should be a description here.
 */
class ReleaseFilterUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ReleaseFilterUpdate ();

    /**
     * Copy constructor
     */
    inline  ReleaseFilterUpdate (const ReleaseFilterUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  ReleaseFilterUpdate (const trReleaseFilter& ReleaseFilter_);

    /**
     * Destructor
     */
    inline virtual  ~ReleaseFilterUpdate();

    /**
     * Assignment operator
     */
    inline ReleaseFilterUpdate& operator = (const ReleaseFilterUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ReleaseFilterUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ReleaseFilterUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ReleaseFilterUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ReleaseFilterUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ReleaseFilter"

    static const int kReleaseFilter = 0;

    /**
     * Clears the field "ReleaseFilter".
     *
     * The field will be set to its default value. The hasReleaseFilter()
     * method will return false.
     */
    inline void clearReleaseFilter();

    /**
     * Checks whether the field "ReleaseFilter" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setReleaseFilter()). Otherwise it will return false.
     */
    inline bool hasReleaseFilter () const;

    /**
     * Returns the value of the member "ReleaseFilter".
     *
     * If the meaning of "ReleaseFilter" isn't clear, then there should be a description here.
     *
     * @return The value of the field "ReleaseFilter"
     */
    inline const trReleaseFilter& getReleaseFilter () const;

    /**
     * Retrieves the value of the field "ReleaseFilter" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ReleaseFilter".
     */
    inline trReleaseFilter& getReleaseFilterMutable ();

    /**
     * Sets the value of the member "ReleaseFilter".
     *
     * If the meaning of "ReleaseFilter" isn't clear, then there should be a description here.
     *
     * @param ReleaseFilter The value which will be set
     */
    inline void setReleaseFilter (const trReleaseFilter& ReleaseFilter_);

    static const ReleaseFilterUpdate &getDefaultInstance();

private:

    inline void set_has_ReleaseFilter ();

    inline void clear_has_ReleaseFilter ();

    uint32 _has_bits_[ (1 + 31) / 32];

    trReleaseFilter _ReleaseFilter;

};

/**
 * If the meaning of "ReleaseFilter" isn't clear, then there should be a description here.
 */
class ReleaseFilterRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ReleaseFilterRegister ();

    /**
     * Copy constructor
     */
    inline  ReleaseFilterRegister (const ReleaseFilterRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~ReleaseFilterRegister();

    /**
     * Assignment operator
     */
    inline ReleaseFilterRegister& operator = (const ReleaseFilterRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ReleaseFilterRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ReleaseFilterRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ReleaseFilterRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ReleaseFilterRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const ReleaseFilterRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "ReleaseDoc" isn't clear, then there should be a description here.
 */
class ReleaseDocUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ReleaseDocUpdate ();

    /**
     * Copy constructor
     */
    inline  ReleaseDocUpdate (const ReleaseDocUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  ReleaseDocUpdate (const trReleaseDoc& ReleaseDoc_);

    /**
     * Destructor
     */
    inline virtual  ~ReleaseDocUpdate();

    /**
     * Assignment operator
     */
    inline ReleaseDocUpdate& operator = (const ReleaseDocUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ReleaseDocUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ReleaseDocUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ReleaseDocUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ReleaseDocUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ReleaseDoc"

    static const int kReleaseDoc = 0;

    /**
     * Clears the field "ReleaseDoc".
     *
     * The field will be set to its default value. The hasReleaseDoc()
     * method will return false.
     */
    inline void clearReleaseDoc();

    /**
     * Checks whether the field "ReleaseDoc" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setReleaseDoc()). Otherwise it will return false.
     */
    inline bool hasReleaseDoc () const;

    /**
     * Returns the value of the member "ReleaseDoc".
     *
     * If the meaning of "ReleaseDoc" isn't clear, then there should be a description here.
     *
     * @return The value of the field "ReleaseDoc"
     */
    inline const trReleaseDoc& getReleaseDoc () const;

    /**
     * Retrieves the value of the field "ReleaseDoc" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ReleaseDoc".
     */
    inline trReleaseDoc& getReleaseDocMutable ();

    /**
     * Sets the value of the member "ReleaseDoc".
     *
     * If the meaning of "ReleaseDoc" isn't clear, then there should be a description here.
     *
     * @param ReleaseDoc The value which will be set
     */
    inline void setReleaseDoc (const trReleaseDoc& ReleaseDoc_);

    static const ReleaseDocUpdate &getDefaultInstance();

private:

    inline void set_has_ReleaseDoc ();

    inline void clear_has_ReleaseDoc ();

    uint32 _has_bits_[ (1 + 31) / 32];

    trReleaseDoc _ReleaseDoc;

};

/**
 * If the meaning of "ReleaseDoc" isn't clear, then there should be a description here.
 */
class ReleaseDocRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ReleaseDocRegister ();

    /**
     * Copy constructor
     */
    inline  ReleaseDocRegister (const ReleaseDocRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~ReleaseDocRegister();

    /**
     * Assignment operator
     */
    inline ReleaseDocRegister& operator = (const ReleaseDocRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ReleaseDocRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ReleaseDocRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ReleaseDocRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ReleaseDocRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const ReleaseDocRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "PreReleaseDoc" isn't clear, then there should be a description here.
 */
class PreReleaseDocUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  PreReleaseDocUpdate ();

    /**
     * Copy constructor
     */
    inline  PreReleaseDocUpdate (const PreReleaseDocUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  PreReleaseDocUpdate (const trPreReleaseDoc& PreReleaseDoc_);

    /**
     * Destructor
     */
    inline virtual  ~PreReleaseDocUpdate();

    /**
     * Assignment operator
     */
    inline PreReleaseDocUpdate& operator = (const PreReleaseDocUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PreReleaseDocUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PreReleaseDocUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PreReleaseDocUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PreReleaseDocUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "PreReleaseDoc"

    static const int kPreReleaseDoc = 0;

    /**
     * Clears the field "PreReleaseDoc".
     *
     * The field will be set to its default value. The hasPreReleaseDoc()
     * method will return false.
     */
    inline void clearPreReleaseDoc();

    /**
     * Checks whether the field "PreReleaseDoc" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPreReleaseDoc()). Otherwise it will return false.
     */
    inline bool hasPreReleaseDoc () const;

    /**
     * Returns the value of the member "PreReleaseDoc".
     *
     * If the meaning of "PreReleaseDoc" isn't clear, then there should be a description here.
     *
     * @return The value of the field "PreReleaseDoc"
     */
    inline const trPreReleaseDoc& getPreReleaseDoc () const;

    /**
     * Retrieves the value of the field "PreReleaseDoc" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "PreReleaseDoc".
     */
    inline trPreReleaseDoc& getPreReleaseDocMutable ();

    /**
     * Sets the value of the member "PreReleaseDoc".
     *
     * If the meaning of "PreReleaseDoc" isn't clear, then there should be a description here.
     *
     * @param PreReleaseDoc The value which will be set
     */
    inline void setPreReleaseDoc (const trPreReleaseDoc& PreReleaseDoc_);

    static const PreReleaseDocUpdate &getDefaultInstance();

private:

    inline void set_has_PreReleaseDoc ();

    inline void clear_has_PreReleaseDoc ();

    uint32 _has_bits_[ (1 + 31) / 32];

    trPreReleaseDoc _PreReleaseDoc;

};

/**
 * If the meaning of "PreReleaseDoc" isn't clear, then there should be a description here.
 */
class PreReleaseDocRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  PreReleaseDocRegister ();

    /**
     * Copy constructor
     */
    inline  PreReleaseDocRegister (const PreReleaseDocRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~PreReleaseDocRegister();

    /**
     * Assignment operator
     */
    inline PreReleaseDocRegister& operator = (const PreReleaseDocRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PreReleaseDocRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PreReleaseDocRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PreReleaseDocRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PreReleaseDocRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const PreReleaseDocRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "UpdateProgress" isn't clear, then there should be a description here.
 */
class UpdateProgressUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  UpdateProgressUpdate ();

    /**
     * Copy constructor
     */
    inline  UpdateProgressUpdate (const UpdateProgressUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  UpdateProgressUpdate (const trUpdProgress& UpdateProgress_);

    /**
     * Destructor
     */
    inline virtual  ~UpdateProgressUpdate();

    /**
     * Assignment operator
     */
    inline UpdateProgressUpdate& operator = (const UpdateProgressUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const UpdateProgressUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const UpdateProgressUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const UpdateProgressUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const UpdateProgressUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "UpdateProgress"

    static const int kUpdateProgress = 0;

    /**
     * Clears the field "UpdateProgress".
     *
     * The field will be set to its default value. The hasUpdateProgress()
     * method will return false.
     */
    inline void clearUpdateProgress();

    /**
     * Checks whether the field "UpdateProgress" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setUpdateProgress()). Otherwise it will return false.
     */
    inline bool hasUpdateProgress () const;

    /**
     * Returns the value of the member "UpdateProgress".
     *
     * If the meaning of "UpdateProgress" isn't clear, then there should be a description here.
     *
     * @return The value of the field "UpdateProgress"
     */
    inline const trUpdProgress& getUpdateProgress () const;

    /**
     * Retrieves the value of the field "UpdateProgress" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "UpdateProgress".
     */
    inline trUpdProgress& getUpdateProgressMutable ();

    /**
     * Sets the value of the member "UpdateProgress".
     *
     * If the meaning of "UpdateProgress" isn't clear, then there should be a description here.
     *
     * @param UpdateProgress The value which will be set
     */
    inline void setUpdateProgress (const trUpdProgress& UpdateProgress_);

    static const UpdateProgressUpdate &getDefaultInstance();

private:

    inline void set_has_UpdateProgress ();

    inline void clear_has_UpdateProgress ();

    uint32 _has_bits_[ (1 + 31) / 32];

    trUpdProgress _UpdateProgress;

};

/**
 * If the meaning of "UpdateProgress" isn't clear, then there should be a description here.
 */
class UpdateProgressRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  UpdateProgressRegister ();

    /**
     * Copy constructor
     */
    inline  UpdateProgressRegister (const UpdateProgressRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~UpdateProgressRegister();

    /**
     * Assignment operator
     */
    inline UpdateProgressRegister& operator = (const UpdateProgressRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const UpdateProgressRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const UpdateProgressRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const UpdateProgressRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const UpdateProgressRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const UpdateProgressRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "UpdateResult" isn't clear, then there should be a description here.
 */
class UpdateResultUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  UpdateResultUpdate ();

    /**
     * Copy constructor
     */
    inline  UpdateResultUpdate (const UpdateResultUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  UpdateResultUpdate (const trResult& UpdateResult_);

    /**
     * Destructor
     */
    inline virtual  ~UpdateResultUpdate();

    /**
     * Assignment operator
     */
    inline UpdateResultUpdate& operator = (const UpdateResultUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const UpdateResultUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const UpdateResultUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const UpdateResultUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const UpdateResultUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "UpdateResult"

    static const int kUpdateResult = 0;

    /**
     * Clears the field "UpdateResult".
     *
     * The field will be set to its default value. The hasUpdateResult()
     * method will return false.
     */
    inline void clearUpdateResult();

    /**
     * Checks whether the field "UpdateResult" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setUpdateResult()). Otherwise it will return false.
     */
    inline bool hasUpdateResult () const;

    /**
     * Returns the value of the member "UpdateResult".
     *
     * If the meaning of "UpdateResult" isn't clear, then there should be a description here.
     *
     * @return The value of the field "UpdateResult"
     */
    inline const trResult& getUpdateResult () const;

    /**
     * Retrieves the value of the field "UpdateResult" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "UpdateResult".
     */
    inline trResult& getUpdateResultMutable ();

    /**
     * Sets the value of the member "UpdateResult".
     *
     * If the meaning of "UpdateResult" isn't clear, then there should be a description here.
     *
     * @param UpdateResult The value which will be set
     */
    inline void setUpdateResult (const trResult& UpdateResult_);

    static const UpdateResultUpdate &getDefaultInstance();

private:

    inline void set_has_UpdateResult ();

    inline void clear_has_UpdateResult ();

    uint32 _has_bits_[ (1 + 31) / 32];

    trResult _UpdateResult;

};

/**
 * If the meaning of "UpdateResult" isn't clear, then there should be a description here.
 */
class UpdateResultRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  UpdateResultRegister ();

    /**
     * Copy constructor
     */
    inline  UpdateResultRegister (const UpdateResultRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~UpdateResultRegister();

    /**
     * Assignment operator
     */
    inline UpdateResultRegister& operator = (const UpdateResultRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const UpdateResultRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const UpdateResultRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const UpdateResultRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const UpdateResultRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const UpdateResultRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "UpdateErrors" isn't clear, then there should be a description here.
 */
class UpdateErrorsUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  UpdateErrorsUpdate ();

    /**
     * Copy constructor
     */
    inline  UpdateErrorsUpdate (const UpdateErrorsUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  UpdateErrorsUpdate (const trErrorIds& UpdateErrors_);

    /**
     * Destructor
     */
    inline virtual  ~UpdateErrorsUpdate();

    /**
     * Assignment operator
     */
    inline UpdateErrorsUpdate& operator = (const UpdateErrorsUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const UpdateErrorsUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const UpdateErrorsUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const UpdateErrorsUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const UpdateErrorsUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "UpdateErrors"

    static const int kUpdateErrors = 0;

    /**
     * Clears the field "UpdateErrors".
     *
     * The field will be set to its default value. The hasUpdateErrors()
     * method will return false.
     */
    inline void clearUpdateErrors();

    /**
     * Checks whether the field "UpdateErrors" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setUpdateErrors()). Otherwise it will return false.
     */
    inline bool hasUpdateErrors () const;

    /**
     * Returns the value of the member "UpdateErrors".
     *
     * If the meaning of "UpdateErrors" isn't clear, then there should be a description here.
     *
     * @return The value of the field "UpdateErrors"
     */
    inline const trErrorIds& getUpdateErrors () const;

    /**
     * Retrieves the value of the field "UpdateErrors" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "UpdateErrors".
     */
    inline trErrorIds& getUpdateErrorsMutable ();

    /**
     * Sets the value of the member "UpdateErrors".
     *
     * If the meaning of "UpdateErrors" isn't clear, then there should be a description here.
     *
     * @param UpdateErrors The value which will be set
     */
    inline void setUpdateErrors (const trErrorIds& UpdateErrors_);

    static const UpdateErrorsUpdate &getDefaultInstance();

private:

    inline void set_has_UpdateErrors ();

    inline void clear_has_UpdateErrors ();

    uint32 _has_bits_[ (1 + 31) / 32];

    trErrorIds _UpdateErrors;

};

/**
 * If the meaning of "UpdateErrors" isn't clear, then there should be a description here.
 */
class UpdateErrorsRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  UpdateErrorsRegister ();

    /**
     * Copy constructor
     */
    inline  UpdateErrorsRegister (const UpdateErrorsRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~UpdateErrorsRegister();

    /**
     * Assignment operator
     */
    inline UpdateErrorsRegister& operator = (const UpdateErrorsRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const UpdateErrorsRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const UpdateErrorsRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const UpdateErrorsRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const UpdateErrorsRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const UpdateErrorsRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "CustomerUpdates" isn't clear, then there should be a description here.
 */
class CustomerUpdatesUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CustomerUpdatesUpdate ();

    /**
     * Copy constructor
     */
    inline  CustomerUpdatesUpdate (const CustomerUpdatesUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  CustomerUpdatesUpdate (const trInstalledCustomerUpdates& CustomerUpdates_);

    /**
     * Destructor
     */
    inline virtual  ~CustomerUpdatesUpdate();

    /**
     * Assignment operator
     */
    inline CustomerUpdatesUpdate& operator = (const CustomerUpdatesUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CustomerUpdatesUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CustomerUpdatesUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CustomerUpdatesUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CustomerUpdatesUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "CustomerUpdates"

    static const int kCustomerUpdates = 0;

    /**
     * Clears the field "CustomerUpdates".
     *
     * The field will be set to its default value. The hasCustomerUpdates()
     * method will return false.
     */
    inline void clearCustomerUpdates();

    /**
     * Checks whether the field "CustomerUpdates" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCustomerUpdates()). Otherwise it will return false.
     */
    inline bool hasCustomerUpdates () const;

    /**
     * Returns the value of the member "CustomerUpdates".
     *
     * If the meaning of "CustomerUpdates" isn't clear, then there should be a description here.
     *
     * @return The value of the field "CustomerUpdates"
     */
    inline const trInstalledCustomerUpdates& getCustomerUpdates () const;

    /**
     * Retrieves the value of the field "CustomerUpdates" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "CustomerUpdates".
     */
    inline trInstalledCustomerUpdates& getCustomerUpdatesMutable ();

    /**
     * Sets the value of the member "CustomerUpdates".
     *
     * If the meaning of "CustomerUpdates" isn't clear, then there should be a description here.
     *
     * @param CustomerUpdates The value which will be set
     */
    inline void setCustomerUpdates (const trInstalledCustomerUpdates& CustomerUpdates_);

    static const CustomerUpdatesUpdate &getDefaultInstance();

private:

    inline void set_has_CustomerUpdates ();

    inline void clear_has_CustomerUpdates ();

    uint32 _has_bits_[ (1 + 31) / 32];

    trInstalledCustomerUpdates _CustomerUpdates;

};

/**
 * If the meaning of "CustomerUpdates" isn't clear, then there should be a description here.
 */
class CustomerUpdatesRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CustomerUpdatesRegister ();

    /**
     * Copy constructor
     */
    inline  CustomerUpdatesRegister (const CustomerUpdatesRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~CustomerUpdatesRegister();

    /**
     * Assignment operator
     */
    inline CustomerUpdatesRegister& operator = (const CustomerUpdatesRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CustomerUpdatesRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CustomerUpdatesRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CustomerUpdatesRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CustomerUpdatesRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const CustomerUpdatesRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "VersionBackDocInfo" isn't clear, then there should be a description here.
 */
class VersionBackDocInfoUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  VersionBackDocInfoUpdate ();

    /**
     * Copy constructor
     */
    inline  VersionBackDocInfoUpdate (const VersionBackDocInfoUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  VersionBackDocInfoUpdate (const trVersionBackDocInfo& VersionBackDocInfo_);

    /**
     * Destructor
     */
    inline virtual  ~VersionBackDocInfoUpdate();

    /**
     * Assignment operator
     */
    inline VersionBackDocInfoUpdate& operator = (const VersionBackDocInfoUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const VersionBackDocInfoUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const VersionBackDocInfoUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const VersionBackDocInfoUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const VersionBackDocInfoUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "VersionBackDocInfo"

    static const int kVersionBackDocInfo = 0;

    /**
     * Clears the field "VersionBackDocInfo".
     *
     * The field will be set to its default value. The hasVersionBackDocInfo()
     * method will return false.
     */
    inline void clearVersionBackDocInfo();

    /**
     * Checks whether the field "VersionBackDocInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setVersionBackDocInfo()). Otherwise it will return false.
     */
    inline bool hasVersionBackDocInfo () const;

    /**
     * Returns the value of the member "VersionBackDocInfo".
     *
     * If the meaning of "VersionBackDocInfo" isn't clear, then there should be a description here.
     *
     * @return The value of the field "VersionBackDocInfo"
     */
    inline const trVersionBackDocInfo& getVersionBackDocInfo () const;

    /**
     * Retrieves the value of the field "VersionBackDocInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "VersionBackDocInfo".
     */
    inline trVersionBackDocInfo& getVersionBackDocInfoMutable ();

    /**
     * Sets the value of the member "VersionBackDocInfo".
     *
     * If the meaning of "VersionBackDocInfo" isn't clear, then there should be a description here.
     *
     * @param VersionBackDocInfo The value which will be set
     */
    inline void setVersionBackDocInfo (const trVersionBackDocInfo& VersionBackDocInfo_);

    static const VersionBackDocInfoUpdate &getDefaultInstance();

private:

    inline void set_has_VersionBackDocInfo ();

    inline void clear_has_VersionBackDocInfo ();

    uint32 _has_bits_[ (1 + 31) / 32];

    trVersionBackDocInfo _VersionBackDocInfo;

};

/**
 * If the meaning of "VersionBackDocInfo" isn't clear, then there should be a description here.
 */
class VersionBackDocInfoRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  VersionBackDocInfoRegister ();

    /**
     * Copy constructor
     */
    inline  VersionBackDocInfoRegister (const VersionBackDocInfoRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~VersionBackDocInfoRegister();

    /**
     * Assignment operator
     */
    inline VersionBackDocInfoRegister& operator = (const VersionBackDocInfoRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const VersionBackDocInfoRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const VersionBackDocInfoRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const VersionBackDocInfoRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const VersionBackDocInfoRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const VersionBackDocInfoRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "AvailableCustomerUpdates" isn't clear, then there should be a description here.
 */
class AvailableCustomerUpdatesUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AvailableCustomerUpdatesUpdate ();

    /**
     * Copy constructor
     */
    inline  AvailableCustomerUpdatesUpdate (const AvailableCustomerUpdatesUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  AvailableCustomerUpdatesUpdate (const trAvailableCustomerUpdates& AvailableCustomerUpdates_);

    /**
     * Destructor
     */
    inline virtual  ~AvailableCustomerUpdatesUpdate();

    /**
     * Assignment operator
     */
    inline AvailableCustomerUpdatesUpdate& operator = (const AvailableCustomerUpdatesUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AvailableCustomerUpdatesUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AvailableCustomerUpdatesUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AvailableCustomerUpdatesUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AvailableCustomerUpdatesUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "AvailableCustomerUpdates"

    static const int kAvailableCustomerUpdates = 0;

    /**
     * Clears the field "AvailableCustomerUpdates".
     *
     * The field will be set to its default value. The hasAvailableCustomerUpdates()
     * method will return false.
     */
    inline void clearAvailableCustomerUpdates();

    /**
     * Checks whether the field "AvailableCustomerUpdates" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAvailableCustomerUpdates()). Otherwise it will return false.
     */
    inline bool hasAvailableCustomerUpdates () const;

    /**
     * Returns the value of the member "AvailableCustomerUpdates".
     *
     * If the meaning of "AvailableCustomerUpdates" isn't clear, then there should be a description here.
     *
     * @return The value of the field "AvailableCustomerUpdates"
     */
    inline const trAvailableCustomerUpdates& getAvailableCustomerUpdates () const;

    /**
     * Retrieves the value of the field "AvailableCustomerUpdates" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "AvailableCustomerUpdates".
     */
    inline trAvailableCustomerUpdates& getAvailableCustomerUpdatesMutable ();

    /**
     * Sets the value of the member "AvailableCustomerUpdates".
     *
     * If the meaning of "AvailableCustomerUpdates" isn't clear, then there should be a description here.
     *
     * @param AvailableCustomerUpdates The value which will be set
     */
    inline void setAvailableCustomerUpdates (const trAvailableCustomerUpdates& AvailableCustomerUpdates_);

    static const AvailableCustomerUpdatesUpdate &getDefaultInstance();

private:

    inline void set_has_AvailableCustomerUpdates ();

    inline void clear_has_AvailableCustomerUpdates ();

    uint32 _has_bits_[ (1 + 31) / 32];

    trAvailableCustomerUpdates _AvailableCustomerUpdates;

};

/**
 * If the meaning of "AvailableCustomerUpdates" isn't clear, then there should be a description here.
 */
class AvailableCustomerUpdatesRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AvailableCustomerUpdatesRegister ();

    /**
     * Copy constructor
     */
    inline  AvailableCustomerUpdatesRegister (const AvailableCustomerUpdatesRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~AvailableCustomerUpdatesRegister();

    /**
     * Assignment operator
     */
    inline AvailableCustomerUpdatesRegister& operator = (const AvailableCustomerUpdatesRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AvailableCustomerUpdatesRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AvailableCustomerUpdatesRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AvailableCustomerUpdatesRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AvailableCustomerUpdatesRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const AvailableCustomerUpdatesRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "UpdateBgImageInfo" isn't clear, then there should be a description here.
 */
class UpdateBgImageInfoUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  UpdateBgImageInfoUpdate ();

    /**
     * Copy constructor
     */
    inline  UpdateBgImageInfoUpdate (const UpdateBgImageInfoUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  UpdateBgImageInfoUpdate (const trBgImageInfo& UpdateBgImageInfo_);

    /**
     * Destructor
     */
    inline virtual  ~UpdateBgImageInfoUpdate();

    /**
     * Assignment operator
     */
    inline UpdateBgImageInfoUpdate& operator = (const UpdateBgImageInfoUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const UpdateBgImageInfoUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const UpdateBgImageInfoUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const UpdateBgImageInfoUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const UpdateBgImageInfoUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "UpdateBgImageInfo"

    static const int kUpdateBgImageInfo = 0;

    /**
     * Clears the field "UpdateBgImageInfo".
     *
     * The field will be set to its default value. The hasUpdateBgImageInfo()
     * method will return false.
     */
    inline void clearUpdateBgImageInfo();

    /**
     * Checks whether the field "UpdateBgImageInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setUpdateBgImageInfo()). Otherwise it will return false.
     */
    inline bool hasUpdateBgImageInfo () const;

    /**
     * Returns the value of the member "UpdateBgImageInfo".
     *
     * If the meaning of "UpdateBgImageInfo" isn't clear, then there should be a description here.
     *
     * @return The value of the field "UpdateBgImageInfo"
     */
    inline const trBgImageInfo& getUpdateBgImageInfo () const;

    /**
     * Retrieves the value of the field "UpdateBgImageInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "UpdateBgImageInfo".
     */
    inline trBgImageInfo& getUpdateBgImageInfoMutable ();

    /**
     * Sets the value of the member "UpdateBgImageInfo".
     *
     * If the meaning of "UpdateBgImageInfo" isn't clear, then there should be a description here.
     *
     * @param UpdateBgImageInfo The value which will be set
     */
    inline void setUpdateBgImageInfo (const trBgImageInfo& UpdateBgImageInfo_);

    static const UpdateBgImageInfoUpdate &getDefaultInstance();

private:

    inline void set_has_UpdateBgImageInfo ();

    inline void clear_has_UpdateBgImageInfo ();

    uint32 _has_bits_[ (1 + 31) / 32];

    trBgImageInfo _UpdateBgImageInfo;

};

/**
 * If the meaning of "UpdateBgImageInfo" isn't clear, then there should be a description here.
 */
class UpdateBgImageInfoRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  UpdateBgImageInfoRegister ();

    /**
     * Copy constructor
     */
    inline  UpdateBgImageInfoRegister (const UpdateBgImageInfoRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~UpdateBgImageInfoRegister();

    /**
     * Assignment operator
     */
    inline UpdateBgImageInfoRegister& operator = (const UpdateBgImageInfoRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const UpdateBgImageInfoRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const UpdateBgImageInfoRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const UpdateBgImageInfoRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const UpdateBgImageInfoRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const UpdateBgImageInfoRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "BgLocksState" isn't clear, then there should be a description here.
 */
class BgLocksStateUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  BgLocksStateUpdate ();

    /**
     * Copy constructor
     */
    inline  BgLocksStateUpdate (const BgLocksStateUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  BgLocksStateUpdate (const trBgLocksState& BgLocksState_);

    /**
     * Destructor
     */
    inline virtual  ~BgLocksStateUpdate();

    /**
     * Assignment operator
     */
    inline BgLocksStateUpdate& operator = (const BgLocksStateUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const BgLocksStateUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const BgLocksStateUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const BgLocksStateUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const BgLocksStateUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "BgLocksState"

    static const int kBgLocksState = 0;

    /**
     * Clears the field "BgLocksState".
     *
     * The field will be set to its default value. The hasBgLocksState()
     * method will return false.
     */
    inline void clearBgLocksState();

    /**
     * Checks whether the field "BgLocksState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBgLocksState()). Otherwise it will return false.
     */
    inline bool hasBgLocksState () const;

    /**
     * Returns the value of the member "BgLocksState".
     *
     * If the meaning of "BgLocksState" isn't clear, then there should be a description here.
     *
     * @return The value of the field "BgLocksState"
     */
    inline const trBgLocksState& getBgLocksState () const;

    /**
     * Retrieves the value of the field "BgLocksState" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "BgLocksState".
     */
    inline trBgLocksState& getBgLocksStateMutable ();

    /**
     * Sets the value of the member "BgLocksState".
     *
     * If the meaning of "BgLocksState" isn't clear, then there should be a description here.
     *
     * @param BgLocksState The value which will be set
     */
    inline void setBgLocksState (const trBgLocksState& BgLocksState_);

    static const BgLocksStateUpdate &getDefaultInstance();

private:

    inline void set_has_BgLocksState ();

    inline void clear_has_BgLocksState ();

    uint32 _has_bits_[ (1 + 31) / 32];

    trBgLocksState _BgLocksState;

};

/**
 * If the meaning of "BgLocksState" isn't clear, then there should be a description here.
 */
class BgLocksStateRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  BgLocksStateRegister ();

    /**
     * Copy constructor
     */
    inline  BgLocksStateRegister (const BgLocksStateRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~BgLocksStateRegister();

    /**
     * Assignment operator
     */
    inline BgLocksStateRegister& operator = (const BgLocksStateRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const BgLocksStateRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const BgLocksStateRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const BgLocksStateRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const BgLocksStateRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const BgLocksStateRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

inline  trUpdSource::trUpdSource ()  :
    _sourceName (),
    _sourcePath (),
    _enSourceType (::fcswupdatesrv::FcSwUpdateSrv::tenSourceType__Usb),
    _bAvailable (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  trUpdSource::trUpdSource (const trUpdSource &rhs)  :
    _sourceName (),
    _sourcePath (),
    _enSourceType (::fcswupdatesrv::FcSwUpdateSrv::tenSourceType__Usb),
    _bAvailable (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  trUpdSource::trUpdSource (const ::std::string& sourceName_, const ::std::string& sourcePath_, tenSourceType enSourceType_, bool bAvailable_)  :
    _sourceName (sourceName_),
    _sourcePath (sourcePath_),
    _enSourceType (enSourceType_),
    _bAvailable (bAvailable_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sourceName_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sourcePath_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(tenSourceType_IsValid(enSourceType_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", enSourceType_, "tenSourceType", "enSourceType", "trUpdSource");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  trUpdSource::~trUpdSource() {
}

inline trUpdSource& trUpdSource::operator = (const trUpdSource& rhs) {
    if( this != &rhs ) {
        if (rhs.hasSourceName()) {
            setSourceName(rhs.getSourceName());
        } else {
            clearSourceName();
        }
        if (rhs.hasSourcePath()) {
            setSourcePath(rhs.getSourcePath());
        } else {
            clearSourcePath();
        }
        if (rhs.hasEnSourceType()) {
            setEnSourceType(rhs.getEnSourceType());
        } else {
            clearEnSourceType();
        }
        if (rhs.hasBAvailable()) {
            setBAvailable(rhs.getBAvailable());
        } else {
            clearBAvailable();
        }
    }
    return *this;
}

inline bool trUpdSource::operator == (const trUpdSource& rhs) const {
    return (((!hasSourceName() && !rhs.hasSourceName()) || getSourceName() == rhs.getSourceName()) &&
        ((!hasSourcePath() && !rhs.hasSourcePath()) || getSourcePath() == rhs.getSourcePath()) &&
        ((!hasEnSourceType() && !rhs.hasEnSourceType()) || getEnSourceType() == rhs.getEnSourceType()) &&
        ((!hasBAvailable() && !rhs.hasBAvailable()) || getBAvailable() == rhs.getBAvailable()));
}

inline bool trUpdSource::operator != (const trUpdSource& rhs) const {
    return ! (*this == rhs);
}

inline bool trUpdSource::operator < (const trUpdSource& rhs) const {
    if (hasSourceName() || rhs.hasSourceName()) {
        if (getSourceName() < rhs.getSourceName()) return true;
        if (getSourceName() > rhs.getSourceName()) return false;
    }
    if (hasSourcePath() || rhs.hasSourcePath()) {
        if (getSourcePath() < rhs.getSourcePath()) return true;
        if (getSourcePath() > rhs.getSourcePath()) return false;
    }
    if (hasEnSourceType() || rhs.hasEnSourceType()) {
        if ((uint32)getEnSourceType() < (uint32)rhs.getEnSourceType()) return true;
        if ((uint32)getEnSourceType() > (uint32)rhs.getEnSourceType()) return false;
    }
    if (hasBAvailable() || rhs.hasBAvailable()) {
        if (getBAvailable() < rhs.getBAvailable()) return true;
        if (getBAvailable() > rhs.getBAvailable()) return false;
    }
    return false;
}

inline bool trUpdSource::operator > (const trUpdSource& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void trUpdSource::clear() {
    clearSourceName();
    clearSourcePath();
    clearEnSourceType();
    clearBAvailable();
}

inline void trUpdSource::clearSourceName() {
    if (hasSourceName()) {
         clear_has_sourceName();
        _sourceName.clear();
     }
}

inline bool trUpdSource::hasSourceName () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& trUpdSource::getSourceName () const {
    return _sourceName;
}

inline ::std::string& trUpdSource::getSourceNameMutable () {
    set_has_sourceName();
    return _sourceName;
}

inline void trUpdSource::setSourceName (const ::std::string& sourceName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sourceName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sourceName();
    this->_sourceName = sourceName_;
}

inline void trUpdSource::setSourceName (const char* sourceName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sourceName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sourceName();
    this->_sourceName.assign(sourceName_);
}

inline void trUpdSource::setSourceName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sourceName();
    this->_sourceName.assign(value, size);
}

inline void trUpdSource::clearSourcePath() {
    if (hasSourcePath()) {
         clear_has_sourcePath();
        _sourcePath.clear();
     }
}

inline bool trUpdSource::hasSourcePath () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& trUpdSource::getSourcePath () const {
    return _sourcePath;
}

inline ::std::string& trUpdSource::getSourcePathMutable () {
    set_has_sourcePath();
    return _sourcePath;
}

inline void trUpdSource::setSourcePath (const ::std::string& sourcePath_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sourcePath_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sourcePath();
    this->_sourcePath = sourcePath_;
}

inline void trUpdSource::setSourcePath (const char* sourcePath_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sourcePath_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sourcePath();
    this->_sourcePath.assign(sourcePath_);
}

inline void trUpdSource::setSourcePath (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sourcePath();
    this->_sourcePath.assign(value, size);
}

inline void trUpdSource::clearEnSourceType() {
    if (hasEnSourceType()) {
         clear_has_enSourceType();
        _enSourceType = ::fcswupdatesrv::FcSwUpdateSrv::tenSourceType__Usb;
     }
}

inline bool trUpdSource::hasEnSourceType () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline tenSourceType trUpdSource::getEnSourceType () const {
    return _enSourceType;
}

inline void trUpdSource::setEnSourceType (tenSourceType enSourceType_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(tenSourceType_IsValid(enSourceType_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", enSourceType_, "tenSourceType", "enSourceType", "trUpdSource");
    }
    set_has_enSourceType();
    this->_enSourceType = enSourceType_;
}

inline void trUpdSource::clearBAvailable() {
    if (hasBAvailable()) {
         clear_has_bAvailable();
        _bAvailable = false;
     }
}

inline bool trUpdSource::hasBAvailable () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline bool trUpdSource::getBAvailable () const {
    return _bAvailable;
}

inline void trUpdSource::setBAvailable (bool bAvailable_) {
    set_has_bAvailable();
    this->_bAvailable = bAvailable_;
}

inline void trUpdSource::set_has_sourceName () {
    _has_bits_[0] |= 1u << 0;
}

inline void trUpdSource::clear_has_sourceName () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void trUpdSource::set_has_sourcePath () {
    _has_bits_[0] |= 1u << 1;
}

inline void trUpdSource::clear_has_sourcePath () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void trUpdSource::set_has_enSourceType () {
    _has_bits_[0] |= 1u << 2;
}

inline void trUpdSource::clear_has_enSourceType () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void trUpdSource::set_has_bAvailable () {
    _has_bits_[0] |= 1u << 3;
}

inline void trUpdSource::clear_has_bAvailable () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  trUpdSources::trUpdSources ()  :
    _sources ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  trUpdSources::trUpdSources (const trUpdSources &rhs)  :
    _sources ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  trUpdSources::trUpdSources (const ::std::vector< trUpdSource >& sources_)  :
    _sources (sources_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  trUpdSources::~trUpdSources() {
}

inline trUpdSources& trUpdSources::operator = (const trUpdSources& rhs) {
    if( this != &rhs ) {
        if (rhs.hasSources()) {
            setSources(rhs.getSources());
        } else {
            clearSources();
        }
    }
    return *this;
}

inline bool trUpdSources::operator == (const trUpdSources& rhs) const {
    return (((!hasSources() && !rhs.hasSources()) || getSources() == rhs.getSources()));
}

inline bool trUpdSources::operator != (const trUpdSources& rhs) const {
    return ! (*this == rhs);
}

inline bool trUpdSources::operator < (const trUpdSources& rhs) const {
    if (hasSources() || rhs.hasSources()) {
        if (getSources() < rhs.getSources()) return true;
        if (getSources() > rhs.getSources()) return false;
    }
    return false;
}

inline bool trUpdSources::operator > (const trUpdSources& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void trUpdSources::clear() {
    clearSources();
}

inline void trUpdSources::clearSources() {
    if (hasSources()) {
         clear_has_sources();
        _sources.clear();
     }
}

inline bool trUpdSources::hasSources () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< trUpdSource >& trUpdSources::getSources () const {
    return _sources;
}

inline ::std::vector< trUpdSource >& trUpdSources::getSourcesMutable () {
    set_has_sources();
    return _sources;
}

inline void trUpdSources::setSources (const ::std::vector< trUpdSource >& sources_) {
    set_has_sources();
    this->_sources = sources_;
}

inline void trUpdSources::set_has_sources () {
    _has_bits_[0] |= 1u << 0;
}

inline void trUpdSources::clear_has_sources () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  trSelectReleaseRes::trSelectReleaseRes ()  :
    _bOk (false),
    _enErrorId (::fcswupdatesrv::FcSwUpdateSrv::tenErrorId__SWL_OK)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  trSelectReleaseRes::trSelectReleaseRes (const trSelectReleaseRes &rhs)  :
    _bOk (false),
    _enErrorId (::fcswupdatesrv::FcSwUpdateSrv::tenErrorId__SWL_OK)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  trSelectReleaseRes::trSelectReleaseRes (bool bOk_, tenErrorId enErrorId_)  :
    _bOk (bOk_),
    _enErrorId (enErrorId_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(tenErrorId_IsValid(enErrorId_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", enErrorId_, "tenErrorId", "enErrorId", "trSelectReleaseRes");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  trSelectReleaseRes::~trSelectReleaseRes() {
}

inline trSelectReleaseRes& trSelectReleaseRes::operator = (const trSelectReleaseRes& rhs) {
    if( this != &rhs ) {
        if (rhs.hasBOk()) {
            setBOk(rhs.getBOk());
        } else {
            clearBOk();
        }
        if (rhs.hasEnErrorId()) {
            setEnErrorId(rhs.getEnErrorId());
        } else {
            clearEnErrorId();
        }
    }
    return *this;
}

inline bool trSelectReleaseRes::operator == (const trSelectReleaseRes& rhs) const {
    return (((!hasBOk() && !rhs.hasBOk()) || getBOk() == rhs.getBOk()) &&
        ((!hasEnErrorId() && !rhs.hasEnErrorId()) || getEnErrorId() == rhs.getEnErrorId()));
}

inline bool trSelectReleaseRes::operator != (const trSelectReleaseRes& rhs) const {
    return ! (*this == rhs);
}

inline bool trSelectReleaseRes::operator < (const trSelectReleaseRes& rhs) const {
    if (hasBOk() || rhs.hasBOk()) {
        if (getBOk() < rhs.getBOk()) return true;
        if (getBOk() > rhs.getBOk()) return false;
    }
    if (hasEnErrorId() || rhs.hasEnErrorId()) {
        if ((uint32)getEnErrorId() < (uint32)rhs.getEnErrorId()) return true;
        if ((uint32)getEnErrorId() > (uint32)rhs.getEnErrorId()) return false;
    }
    return false;
}

inline bool trSelectReleaseRes::operator > (const trSelectReleaseRes& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void trSelectReleaseRes::clear() {
    clearBOk();
    clearEnErrorId();
}

inline void trSelectReleaseRes::clearBOk() {
    if (hasBOk()) {
         clear_has_bOk();
        _bOk = false;
     }
}

inline bool trSelectReleaseRes::hasBOk () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool trSelectReleaseRes::getBOk () const {
    return _bOk;
}

inline void trSelectReleaseRes::setBOk (bool bOk_) {
    set_has_bOk();
    this->_bOk = bOk_;
}

inline void trSelectReleaseRes::clearEnErrorId() {
    if (hasEnErrorId()) {
         clear_has_enErrorId();
        _enErrorId = ::fcswupdatesrv::FcSwUpdateSrv::tenErrorId__SWL_OK;
     }
}

inline bool trSelectReleaseRes::hasEnErrorId () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline tenErrorId trSelectReleaseRes::getEnErrorId () const {
    return _enErrorId;
}

inline void trSelectReleaseRes::setEnErrorId (tenErrorId enErrorId_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(tenErrorId_IsValid(enErrorId_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", enErrorId_, "tenErrorId", "enErrorId", "trSelectReleaseRes");
    }
    set_has_enErrorId();
    this->_enErrorId = enErrorId_;
}

inline void trSelectReleaseRes::set_has_bOk () {
    _has_bits_[0] |= 1u << 0;
}

inline void trSelectReleaseRes::clear_has_bOk () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void trSelectReleaseRes::set_has_enErrorId () {
    _has_bits_[0] |= 1u << 1;
}

inline void trSelectReleaseRes::clear_has_enErrorId () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  trReleaseInfo::trReleaseInfo ()  :
    _name (),
    _info ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  trReleaseInfo::trReleaseInfo (const trReleaseInfo &rhs)  :
    _name (),
    _info ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  trReleaseInfo::trReleaseInfo (const ::std::string& name_, const ::std::string& info_)  :
    _name (name_),
    _info (info_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (name_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (info_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  trReleaseInfo::~trReleaseInfo() {
}

inline trReleaseInfo& trReleaseInfo::operator = (const trReleaseInfo& rhs) {
    if( this != &rhs ) {
        if (rhs.hasName()) {
            setName(rhs.getName());
        } else {
            clearName();
        }
        if (rhs.hasInfo()) {
            setInfo(rhs.getInfo());
        } else {
            clearInfo();
        }
    }
    return *this;
}

inline bool trReleaseInfo::operator == (const trReleaseInfo& rhs) const {
    return (((!hasName() && !rhs.hasName()) || getName() == rhs.getName()) &&
        ((!hasInfo() && !rhs.hasInfo()) || getInfo() == rhs.getInfo()));
}

inline bool trReleaseInfo::operator != (const trReleaseInfo& rhs) const {
    return ! (*this == rhs);
}

inline bool trReleaseInfo::operator < (const trReleaseInfo& rhs) const {
    if (hasName() || rhs.hasName()) {
        if (getName() < rhs.getName()) return true;
        if (getName() > rhs.getName()) return false;
    }
    if (hasInfo() || rhs.hasInfo()) {
        if (getInfo() < rhs.getInfo()) return true;
        if (getInfo() > rhs.getInfo()) return false;
    }
    return false;
}

inline bool trReleaseInfo::operator > (const trReleaseInfo& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void trReleaseInfo::clear() {
    clearName();
    clearInfo();
}

inline void trReleaseInfo::clearName() {
    if (hasName()) {
         clear_has_name();
        _name.clear();
     }
}

inline bool trReleaseInfo::hasName () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& trReleaseInfo::getName () const {
    return _name;
}

inline ::std::string& trReleaseInfo::getNameMutable () {
    set_has_name();
    return _name;
}

inline void trReleaseInfo::setName (const ::std::string& name_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (name_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_name();
    this->_name = name_;
}

inline void trReleaseInfo::setName (const char* name_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (name_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_name();
    this->_name.assign(name_);
}

inline void trReleaseInfo::setName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_name();
    this->_name.assign(value, size);
}

inline void trReleaseInfo::clearInfo() {
    if (hasInfo()) {
         clear_has_info();
        _info.clear();
     }
}

inline bool trReleaseInfo::hasInfo () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& trReleaseInfo::getInfo () const {
    return _info;
}

inline ::std::string& trReleaseInfo::getInfoMutable () {
    set_has_info();
    return _info;
}

inline void trReleaseInfo::setInfo (const ::std::string& info_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (info_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_info();
    this->_info = info_;
}

inline void trReleaseInfo::setInfo (const char* info_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (info_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_info();
    this->_info.assign(info_);
}

inline void trReleaseInfo::setInfo (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_info();
    this->_info.assign(value, size);
}

inline void trReleaseInfo::set_has_name () {
    _has_bits_[0] |= 1u << 0;
}

inline void trReleaseInfo::clear_has_name () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void trReleaseInfo::set_has_info () {
    _has_bits_[0] |= 1u << 1;
}

inline void trReleaseInfo::clear_has_info () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  trReleaseFilter::trReleaseFilter ()  :
    _enUpgradeDirectionFilter (::fcswupdatesrv::FcSwUpdateSrv::tenUpdOptions__NewOnly)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  trReleaseFilter::trReleaseFilter (const trReleaseFilter &rhs)  :
    _enUpgradeDirectionFilter (::fcswupdatesrv::FcSwUpdateSrv::tenUpdOptions__NewOnly)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  trReleaseFilter::trReleaseFilter (tenUpdOptions enUpgradeDirectionFilter_)  :
    _enUpgradeDirectionFilter (enUpgradeDirectionFilter_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(tenUpdOptions_IsValid(enUpgradeDirectionFilter_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", enUpgradeDirectionFilter_, "tenUpdOptions", "enUpgradeDirectionFilter", "trReleaseFilter");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  trReleaseFilter::~trReleaseFilter() {
}

inline trReleaseFilter& trReleaseFilter::operator = (const trReleaseFilter& rhs) {
    if( this != &rhs ) {
        if (rhs.hasEnUpgradeDirectionFilter()) {
            setEnUpgradeDirectionFilter(rhs.getEnUpgradeDirectionFilter());
        } else {
            clearEnUpgradeDirectionFilter();
        }
    }
    return *this;
}

inline bool trReleaseFilter::operator == (const trReleaseFilter& rhs) const {
    return (((!hasEnUpgradeDirectionFilter() && !rhs.hasEnUpgradeDirectionFilter()) || getEnUpgradeDirectionFilter() == rhs.getEnUpgradeDirectionFilter()));
}

inline bool trReleaseFilter::operator != (const trReleaseFilter& rhs) const {
    return ! (*this == rhs);
}

inline bool trReleaseFilter::operator < (const trReleaseFilter& rhs) const {
    if (hasEnUpgradeDirectionFilter() || rhs.hasEnUpgradeDirectionFilter()) {
        if ((uint32)getEnUpgradeDirectionFilter() < (uint32)rhs.getEnUpgradeDirectionFilter()) return true;
        if ((uint32)getEnUpgradeDirectionFilter() > (uint32)rhs.getEnUpgradeDirectionFilter()) return false;
    }
    return false;
}

inline bool trReleaseFilter::operator > (const trReleaseFilter& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void trReleaseFilter::clear() {
    clearEnUpgradeDirectionFilter();
}

inline void trReleaseFilter::clearEnUpgradeDirectionFilter() {
    if (hasEnUpgradeDirectionFilter()) {
         clear_has_enUpgradeDirectionFilter();
        _enUpgradeDirectionFilter = ::fcswupdatesrv::FcSwUpdateSrv::tenUpdOptions__NewOnly;
     }
}

inline bool trReleaseFilter::hasEnUpgradeDirectionFilter () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline tenUpdOptions trReleaseFilter::getEnUpgradeDirectionFilter () const {
    return _enUpgradeDirectionFilter;
}

inline void trReleaseFilter::setEnUpgradeDirectionFilter (tenUpdOptions enUpgradeDirectionFilter_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(tenUpdOptions_IsValid(enUpgradeDirectionFilter_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", enUpgradeDirectionFilter_, "tenUpdOptions", "enUpgradeDirectionFilter", "trReleaseFilter");
    }
    set_has_enUpgradeDirectionFilter();
    this->_enUpgradeDirectionFilter = enUpgradeDirectionFilter_;
}

inline void trReleaseFilter::set_has_enUpgradeDirectionFilter () {
    _has_bits_[0] |= 1u << 0;
}

inline void trReleaseFilter::clear_has_enUpgradeDirectionFilter () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  trReleaseAccess::trReleaseAccess ()  :
    _mountPoint (),
    _path (),
    _file (),
    _useExtendedOptions (false),
    _releaseFilter (),
    _updateOption (::fcswupdatesrv::FcSwUpdateSrv::tenUpdOptions__NewOnly),
    _doApply (false),
    _postImageInstallationMode (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  trReleaseAccess::trReleaseAccess (const trReleaseAccess &rhs)  :
    _mountPoint (),
    _path (),
    _file (),
    _useExtendedOptions (false),
    _releaseFilter (),
    _updateOption (::fcswupdatesrv::FcSwUpdateSrv::tenUpdOptions__NewOnly),
    _doApply (false),
    _postImageInstallationMode (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  trReleaseAccess::trReleaseAccess (const ::std::string& mountPoint_, const ::std::string& path_, const ::std::string& file_, bool useExtendedOptions_, const trReleaseFilter& releaseFilter_, tenUpdOptions updateOption_, bool doApply_, bool postImageInstallationMode_)  :
    _mountPoint (mountPoint_),
    _path (path_),
    _file (file_),
    _useExtendedOptions (useExtendedOptions_),
    _releaseFilter (releaseFilter_),
    _updateOption (updateOption_),
    _doApply (doApply_),
    _postImageInstallationMode (postImageInstallationMode_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (mountPoint_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (path_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (file_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(tenUpdOptions_IsValid(updateOption_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", updateOption_, "tenUpdOptions", "updateOption", "trReleaseAccess");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  trReleaseAccess::~trReleaseAccess() {
}

inline trReleaseAccess& trReleaseAccess::operator = (const trReleaseAccess& rhs) {
    if( this != &rhs ) {
        if (rhs.hasMountPoint()) {
            setMountPoint(rhs.getMountPoint());
        } else {
            clearMountPoint();
        }
        if (rhs.hasPath()) {
            setPath(rhs.getPath());
        } else {
            clearPath();
        }
        if (rhs.hasFile()) {
            setFile(rhs.getFile());
        } else {
            clearFile();
        }
        if (rhs.hasUseExtendedOptions()) {
            setUseExtendedOptions(rhs.getUseExtendedOptions());
        } else {
            clearUseExtendedOptions();
        }
        if (rhs.hasReleaseFilter()) {
            setReleaseFilter(rhs.getReleaseFilter());
        } else {
            clearReleaseFilter();
        }
        if (rhs.hasUpdateOption()) {
            setUpdateOption(rhs.getUpdateOption());
        } else {
            clearUpdateOption();
        }
        if (rhs.hasDoApply()) {
            setDoApply(rhs.getDoApply());
        } else {
            clearDoApply();
        }
        if (rhs.hasPostImageInstallationMode()) {
            setPostImageInstallationMode(rhs.getPostImageInstallationMode());
        } else {
            clearPostImageInstallationMode();
        }
    }
    return *this;
}

inline bool trReleaseAccess::operator == (const trReleaseAccess& rhs) const {
    return (((!hasMountPoint() && !rhs.hasMountPoint()) || getMountPoint() == rhs.getMountPoint()) &&
        ((!hasPath() && !rhs.hasPath()) || getPath() == rhs.getPath()) &&
        ((!hasFile() && !rhs.hasFile()) || getFile() == rhs.getFile()) &&
        ((!hasUseExtendedOptions() && !rhs.hasUseExtendedOptions()) || getUseExtendedOptions() == rhs.getUseExtendedOptions()) &&
        ((!hasReleaseFilter() && !rhs.hasReleaseFilter()) || getReleaseFilter() == rhs.getReleaseFilter()) &&
        ((!hasUpdateOption() && !rhs.hasUpdateOption()) || getUpdateOption() == rhs.getUpdateOption()) &&
        ((!hasDoApply() && !rhs.hasDoApply()) || getDoApply() == rhs.getDoApply()) &&
        ((!hasPostImageInstallationMode() && !rhs.hasPostImageInstallationMode()) || getPostImageInstallationMode() == rhs.getPostImageInstallationMode()));
}

inline bool trReleaseAccess::operator != (const trReleaseAccess& rhs) const {
    return ! (*this == rhs);
}

inline bool trReleaseAccess::operator < (const trReleaseAccess& rhs) const {
    if (hasMountPoint() || rhs.hasMountPoint()) {
        if (getMountPoint() < rhs.getMountPoint()) return true;
        if (getMountPoint() > rhs.getMountPoint()) return false;
    }
    if (hasPath() || rhs.hasPath()) {
        if (getPath() < rhs.getPath()) return true;
        if (getPath() > rhs.getPath()) return false;
    }
    if (hasFile() || rhs.hasFile()) {
        if (getFile() < rhs.getFile()) return true;
        if (getFile() > rhs.getFile()) return false;
    }
    if (hasUseExtendedOptions() || rhs.hasUseExtendedOptions()) {
        if (getUseExtendedOptions() < rhs.getUseExtendedOptions()) return true;
        if (getUseExtendedOptions() > rhs.getUseExtendedOptions()) return false;
    }
    if (hasReleaseFilter() || rhs.hasReleaseFilter()) {
        if (getReleaseFilter() < rhs.getReleaseFilter()) return true;
        if (getReleaseFilter() > rhs.getReleaseFilter()) return false;
    }
    if (hasUpdateOption() || rhs.hasUpdateOption()) {
        if ((uint32)getUpdateOption() < (uint32)rhs.getUpdateOption()) return true;
        if ((uint32)getUpdateOption() > (uint32)rhs.getUpdateOption()) return false;
    }
    if (hasDoApply() || rhs.hasDoApply()) {
        if (getDoApply() < rhs.getDoApply()) return true;
        if (getDoApply() > rhs.getDoApply()) return false;
    }
    if (hasPostImageInstallationMode() || rhs.hasPostImageInstallationMode()) {
        if (getPostImageInstallationMode() < rhs.getPostImageInstallationMode()) return true;
        if (getPostImageInstallationMode() > rhs.getPostImageInstallationMode()) return false;
    }
    return false;
}

inline bool trReleaseAccess::operator > (const trReleaseAccess& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void trReleaseAccess::clear() {
    clearMountPoint();
    clearPath();
    clearFile();
    clearUseExtendedOptions();
    clearReleaseFilter();
    clearUpdateOption();
    clearDoApply();
    clearPostImageInstallationMode();
}

inline void trReleaseAccess::clearMountPoint() {
    if (hasMountPoint()) {
         clear_has_mountPoint();
        _mountPoint.clear();
     }
}

inline bool trReleaseAccess::hasMountPoint () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& trReleaseAccess::getMountPoint () const {
    return _mountPoint;
}

inline ::std::string& trReleaseAccess::getMountPointMutable () {
    set_has_mountPoint();
    return _mountPoint;
}

inline void trReleaseAccess::setMountPoint (const ::std::string& mountPoint_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (mountPoint_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_mountPoint();
    this->_mountPoint = mountPoint_;
}

inline void trReleaseAccess::setMountPoint (const char* mountPoint_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (mountPoint_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_mountPoint();
    this->_mountPoint.assign(mountPoint_);
}

inline void trReleaseAccess::setMountPoint (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_mountPoint();
    this->_mountPoint.assign(value, size);
}

inline void trReleaseAccess::clearPath() {
    if (hasPath()) {
         clear_has_path();
        _path.clear();
     }
}

inline bool trReleaseAccess::hasPath () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& trReleaseAccess::getPath () const {
    return _path;
}

inline ::std::string& trReleaseAccess::getPathMutable () {
    set_has_path();
    return _path;
}

inline void trReleaseAccess::setPath (const ::std::string& path_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (path_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_path();
    this->_path = path_;
}

inline void trReleaseAccess::setPath (const char* path_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (path_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_path();
    this->_path.assign(path_);
}

inline void trReleaseAccess::setPath (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_path();
    this->_path.assign(value, size);
}

inline void trReleaseAccess::clearFile() {
    if (hasFile()) {
         clear_has_file();
        _file.clear();
     }
}

inline bool trReleaseAccess::hasFile () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::string& trReleaseAccess::getFile () const {
    return _file;
}

inline ::std::string& trReleaseAccess::getFileMutable () {
    set_has_file();
    return _file;
}

inline void trReleaseAccess::setFile (const ::std::string& file_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (file_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_file();
    this->_file = file_;
}

inline void trReleaseAccess::setFile (const char* file_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (file_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_file();
    this->_file.assign(file_);
}

inline void trReleaseAccess::setFile (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_file();
    this->_file.assign(value, size);
}

inline void trReleaseAccess::clearUseExtendedOptions() {
    if (hasUseExtendedOptions()) {
         clear_has_useExtendedOptions();
        _useExtendedOptions = false;
     }
}

inline bool trReleaseAccess::hasUseExtendedOptions () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline bool trReleaseAccess::getUseExtendedOptions () const {
    return _useExtendedOptions;
}

inline void trReleaseAccess::setUseExtendedOptions (bool useExtendedOptions_) {
    set_has_useExtendedOptions();
    this->_useExtendedOptions = useExtendedOptions_;
}

inline void trReleaseAccess::clearReleaseFilter() {
    if (hasReleaseFilter()) {
         clear_has_releaseFilter();
        _releaseFilter.clear();
     }
}

inline bool trReleaseAccess::hasReleaseFilter () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline const trReleaseFilter& trReleaseAccess::getReleaseFilter () const {
    return _releaseFilter;
}

inline trReleaseFilter& trReleaseAccess::getReleaseFilterMutable () {
    set_has_releaseFilter();
    return _releaseFilter;
}

inline void trReleaseAccess::setReleaseFilter (const trReleaseFilter& releaseFilter_) {
    set_has_releaseFilter();
    this->_releaseFilter = releaseFilter_;
}

inline void trReleaseAccess::clearUpdateOption() {
    if (hasUpdateOption()) {
         clear_has_updateOption();
        _updateOption = ::fcswupdatesrv::FcSwUpdateSrv::tenUpdOptions__NewOnly;
     }
}

inline bool trReleaseAccess::hasUpdateOption () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline tenUpdOptions trReleaseAccess::getUpdateOption () const {
    return _updateOption;
}

inline void trReleaseAccess::setUpdateOption (tenUpdOptions updateOption_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(tenUpdOptions_IsValid(updateOption_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", updateOption_, "tenUpdOptions", "updateOption", "trReleaseAccess");
    }
    set_has_updateOption();
    this->_updateOption = updateOption_;
}

inline void trReleaseAccess::clearDoApply() {
    if (hasDoApply()) {
         clear_has_doApply();
        _doApply = false;
     }
}

inline bool trReleaseAccess::hasDoApply () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline bool trReleaseAccess::getDoApply () const {
    return _doApply;
}

inline void trReleaseAccess::setDoApply (bool doApply_) {
    set_has_doApply();
    this->_doApply = doApply_;
}

inline void trReleaseAccess::clearPostImageInstallationMode() {
    if (hasPostImageInstallationMode()) {
         clear_has_postImageInstallationMode();
        _postImageInstallationMode = false;
     }
}

inline bool trReleaseAccess::hasPostImageInstallationMode () const {
    return (_has_bits_[0] & (1u << 7)) > 0;
}

inline bool trReleaseAccess::getPostImageInstallationMode () const {
    return _postImageInstallationMode;
}

inline void trReleaseAccess::setPostImageInstallationMode (bool postImageInstallationMode_) {
    set_has_postImageInstallationMode();
    this->_postImageInstallationMode = postImageInstallationMode_;
}

inline void trReleaseAccess::set_has_mountPoint () {
    _has_bits_[0] |= 1u << 0;
}

inline void trReleaseAccess::clear_has_mountPoint () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void trReleaseAccess::set_has_path () {
    _has_bits_[0] |= 1u << 1;
}

inline void trReleaseAccess::clear_has_path () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void trReleaseAccess::set_has_file () {
    _has_bits_[0] |= 1u << 2;
}

inline void trReleaseAccess::clear_has_file () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void trReleaseAccess::set_has_useExtendedOptions () {
    _has_bits_[0] |= 1u << 3;
}

inline void trReleaseAccess::clear_has_useExtendedOptions () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void trReleaseAccess::set_has_releaseFilter () {
    _has_bits_[0] |= 1u << 4;
}

inline void trReleaseAccess::clear_has_releaseFilter () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void trReleaseAccess::set_has_updateOption () {
    _has_bits_[0] |= 1u << 5;
}

inline void trReleaseAccess::clear_has_updateOption () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void trReleaseAccess::set_has_doApply () {
    _has_bits_[0] |= 1u << 6;
}

inline void trReleaseAccess::clear_has_doApply () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline void trReleaseAccess::set_has_postImageInstallationMode () {
    _has_bits_[0] |= 1u << 7;
}

inline void trReleaseAccess::clear_has_postImageInstallationMode () {
    _has_bits_[0] &= ~ (1u << 7);
}

inline  trReleaseInfos::trReleaseInfos ()  :
    _enErrorId (::fcswupdatesrv::FcSwUpdateSrv::tenErrorId__SWL_OK),
    _releaseInfos ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  trReleaseInfos::trReleaseInfos (const trReleaseInfos &rhs)  :
    _enErrorId (::fcswupdatesrv::FcSwUpdateSrv::tenErrorId__SWL_OK),
    _releaseInfos ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  trReleaseInfos::trReleaseInfos (tenErrorId enErrorId_, const ::std::vector< trReleaseInfo >& releaseInfos_)  :
    _enErrorId (enErrorId_),
    _releaseInfos (releaseInfos_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(tenErrorId_IsValid(enErrorId_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", enErrorId_, "tenErrorId", "enErrorId", "trReleaseInfos");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  trReleaseInfos::~trReleaseInfos() {
}

inline trReleaseInfos& trReleaseInfos::operator = (const trReleaseInfos& rhs) {
    if( this != &rhs ) {
        if (rhs.hasEnErrorId()) {
            setEnErrorId(rhs.getEnErrorId());
        } else {
            clearEnErrorId();
        }
        if (rhs.hasReleaseInfos()) {
            setReleaseInfos(rhs.getReleaseInfos());
        } else {
            clearReleaseInfos();
        }
    }
    return *this;
}

inline bool trReleaseInfos::operator == (const trReleaseInfos& rhs) const {
    return (((!hasEnErrorId() && !rhs.hasEnErrorId()) || getEnErrorId() == rhs.getEnErrorId()) &&
        ((!hasReleaseInfos() && !rhs.hasReleaseInfos()) || getReleaseInfos() == rhs.getReleaseInfos()));
}

inline bool trReleaseInfos::operator != (const trReleaseInfos& rhs) const {
    return ! (*this == rhs);
}

inline bool trReleaseInfos::operator < (const trReleaseInfos& rhs) const {
    if (hasEnErrorId() || rhs.hasEnErrorId()) {
        if ((uint32)getEnErrorId() < (uint32)rhs.getEnErrorId()) return true;
        if ((uint32)getEnErrorId() > (uint32)rhs.getEnErrorId()) return false;
    }
    if (hasReleaseInfos() || rhs.hasReleaseInfos()) {
        if (getReleaseInfos() < rhs.getReleaseInfos()) return true;
        if (getReleaseInfos() > rhs.getReleaseInfos()) return false;
    }
    return false;
}

inline bool trReleaseInfos::operator > (const trReleaseInfos& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void trReleaseInfos::clear() {
    clearEnErrorId();
    clearReleaseInfos();
}

inline void trReleaseInfos::clearEnErrorId() {
    if (hasEnErrorId()) {
         clear_has_enErrorId();
        _enErrorId = ::fcswupdatesrv::FcSwUpdateSrv::tenErrorId__SWL_OK;
     }
}

inline bool trReleaseInfos::hasEnErrorId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline tenErrorId trReleaseInfos::getEnErrorId () const {
    return _enErrorId;
}

inline void trReleaseInfos::setEnErrorId (tenErrorId enErrorId_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(tenErrorId_IsValid(enErrorId_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", enErrorId_, "tenErrorId", "enErrorId", "trReleaseInfos");
    }
    set_has_enErrorId();
    this->_enErrorId = enErrorId_;
}

inline void trReleaseInfos::clearReleaseInfos() {
    if (hasReleaseInfos()) {
         clear_has_releaseInfos();
        _releaseInfos.clear();
     }
}

inline bool trReleaseInfos::hasReleaseInfos () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::vector< trReleaseInfo >& trReleaseInfos::getReleaseInfos () const {
    return _releaseInfos;
}

inline ::std::vector< trReleaseInfo >& trReleaseInfos::getReleaseInfosMutable () {
    set_has_releaseInfos();
    return _releaseInfos;
}

inline void trReleaseInfos::setReleaseInfos (const ::std::vector< trReleaseInfo >& releaseInfos_) {
    set_has_releaseInfos();
    this->_releaseInfos = releaseInfos_;
}

inline void trReleaseInfos::set_has_enErrorId () {
    _has_bits_[0] |= 1u << 0;
}

inline void trReleaseInfos::clear_has_enErrorId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void trReleaseInfos::set_has_releaseInfos () {
    _has_bits_[0] |= 1u << 1;
}

inline void trReleaseInfos::clear_has_releaseInfos () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  trDeviceState::trDeviceState ()  :
    _name (),
    _hwIndex (),
    _info (),
    _bReady (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  trDeviceState::trDeviceState (const trDeviceState &rhs)  :
    _name (),
    _hwIndex (),
    _info (),
    _bReady (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  trDeviceState::trDeviceState (const ::std::string& name_, const ::std::string& hwIndex_, const ::std::string& info_, bool bReady_)  :
    _name (name_),
    _hwIndex (hwIndex_),
    _info (info_),
    _bReady (bReady_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (name_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (hwIndex_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (info_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  trDeviceState::~trDeviceState() {
}

inline trDeviceState& trDeviceState::operator = (const trDeviceState& rhs) {
    if( this != &rhs ) {
        if (rhs.hasName()) {
            setName(rhs.getName());
        } else {
            clearName();
        }
        if (rhs.hasHwIndex()) {
            setHwIndex(rhs.getHwIndex());
        } else {
            clearHwIndex();
        }
        if (rhs.hasInfo()) {
            setInfo(rhs.getInfo());
        } else {
            clearInfo();
        }
        if (rhs.hasBReady()) {
            setBReady(rhs.getBReady());
        } else {
            clearBReady();
        }
    }
    return *this;
}

inline bool trDeviceState::operator == (const trDeviceState& rhs) const {
    return (((!hasName() && !rhs.hasName()) || getName() == rhs.getName()) &&
        ((!hasHwIndex() && !rhs.hasHwIndex()) || getHwIndex() == rhs.getHwIndex()) &&
        ((!hasInfo() && !rhs.hasInfo()) || getInfo() == rhs.getInfo()) &&
        ((!hasBReady() && !rhs.hasBReady()) || getBReady() == rhs.getBReady()));
}

inline bool trDeviceState::operator != (const trDeviceState& rhs) const {
    return ! (*this == rhs);
}

inline bool trDeviceState::operator < (const trDeviceState& rhs) const {
    if (hasName() || rhs.hasName()) {
        if (getName() < rhs.getName()) return true;
        if (getName() > rhs.getName()) return false;
    }
    if (hasHwIndex() || rhs.hasHwIndex()) {
        if (getHwIndex() < rhs.getHwIndex()) return true;
        if (getHwIndex() > rhs.getHwIndex()) return false;
    }
    if (hasInfo() || rhs.hasInfo()) {
        if (getInfo() < rhs.getInfo()) return true;
        if (getInfo() > rhs.getInfo()) return false;
    }
    if (hasBReady() || rhs.hasBReady()) {
        if (getBReady() < rhs.getBReady()) return true;
        if (getBReady() > rhs.getBReady()) return false;
    }
    return false;
}

inline bool trDeviceState::operator > (const trDeviceState& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void trDeviceState::clear() {
    clearName();
    clearHwIndex();
    clearInfo();
    clearBReady();
}

inline void trDeviceState::clearName() {
    if (hasName()) {
         clear_has_name();
        _name.clear();
     }
}

inline bool trDeviceState::hasName () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& trDeviceState::getName () const {
    return _name;
}

inline ::std::string& trDeviceState::getNameMutable () {
    set_has_name();
    return _name;
}

inline void trDeviceState::setName (const ::std::string& name_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (name_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_name();
    this->_name = name_;
}

inline void trDeviceState::setName (const char* name_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (name_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_name();
    this->_name.assign(name_);
}

inline void trDeviceState::setName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_name();
    this->_name.assign(value, size);
}

inline void trDeviceState::clearHwIndex() {
    if (hasHwIndex()) {
         clear_has_hwIndex();
        _hwIndex.clear();
     }
}

inline bool trDeviceState::hasHwIndex () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& trDeviceState::getHwIndex () const {
    return _hwIndex;
}

inline ::std::string& trDeviceState::getHwIndexMutable () {
    set_has_hwIndex();
    return _hwIndex;
}

inline void trDeviceState::setHwIndex (const ::std::string& hwIndex_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (hwIndex_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_hwIndex();
    this->_hwIndex = hwIndex_;
}

inline void trDeviceState::setHwIndex (const char* hwIndex_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (hwIndex_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_hwIndex();
    this->_hwIndex.assign(hwIndex_);
}

inline void trDeviceState::setHwIndex (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_hwIndex();
    this->_hwIndex.assign(value, size);
}

inline void trDeviceState::clearInfo() {
    if (hasInfo()) {
         clear_has_info();
        _info.clear();
     }
}

inline bool trDeviceState::hasInfo () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::string& trDeviceState::getInfo () const {
    return _info;
}

inline ::std::string& trDeviceState::getInfoMutable () {
    set_has_info();
    return _info;
}

inline void trDeviceState::setInfo (const ::std::string& info_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (info_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_info();
    this->_info = info_;
}

inline void trDeviceState::setInfo (const char* info_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (info_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_info();
    this->_info.assign(info_);
}

inline void trDeviceState::setInfo (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_info();
    this->_info.assign(value, size);
}

inline void trDeviceState::clearBReady() {
    if (hasBReady()) {
         clear_has_bReady();
        _bReady = false;
     }
}

inline bool trDeviceState::hasBReady () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline bool trDeviceState::getBReady () const {
    return _bReady;
}

inline void trDeviceState::setBReady (bool bReady_) {
    set_has_bReady();
    this->_bReady = bReady_;
}

inline void trDeviceState::set_has_name () {
    _has_bits_[0] |= 1u << 0;
}

inline void trDeviceState::clear_has_name () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void trDeviceState::set_has_hwIndex () {
    _has_bits_[0] |= 1u << 1;
}

inline void trDeviceState::clear_has_hwIndex () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void trDeviceState::set_has_info () {
    _has_bits_[0] |= 1u << 2;
}

inline void trDeviceState::clear_has_info () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void trDeviceState::set_has_bReady () {
    _has_bits_[0] |= 1u << 3;
}

inline void trDeviceState::clear_has_bReady () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  trDeviceStates::trDeviceStates ()  :
    _deviceStates ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  trDeviceStates::trDeviceStates (const trDeviceStates &rhs)  :
    _deviceStates ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  trDeviceStates::trDeviceStates (const ::std::vector< trDeviceState >& deviceStates_)  :
    _deviceStates (deviceStates_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  trDeviceStates::~trDeviceStates() {
}

inline trDeviceStates& trDeviceStates::operator = (const trDeviceStates& rhs) {
    if( this != &rhs ) {
        if (rhs.hasDeviceStates()) {
            setDeviceStates(rhs.getDeviceStates());
        } else {
            clearDeviceStates();
        }
    }
    return *this;
}

inline bool trDeviceStates::operator == (const trDeviceStates& rhs) const {
    return (((!hasDeviceStates() && !rhs.hasDeviceStates()) || getDeviceStates() == rhs.getDeviceStates()));
}

inline bool trDeviceStates::operator != (const trDeviceStates& rhs) const {
    return ! (*this == rhs);
}

inline bool trDeviceStates::operator < (const trDeviceStates& rhs) const {
    if (hasDeviceStates() || rhs.hasDeviceStates()) {
        if (getDeviceStates() < rhs.getDeviceStates()) return true;
        if (getDeviceStates() > rhs.getDeviceStates()) return false;
    }
    return false;
}

inline bool trDeviceStates::operator > (const trDeviceStates& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void trDeviceStates::clear() {
    clearDeviceStates();
}

inline void trDeviceStates::clearDeviceStates() {
    if (hasDeviceStates()) {
         clear_has_deviceStates();
        _deviceStates.clear();
     }
}

inline bool trDeviceStates::hasDeviceStates () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< trDeviceState >& trDeviceStates::getDeviceStates () const {
    return _deviceStates;
}

inline ::std::vector< trDeviceState >& trDeviceStates::getDeviceStatesMutable () {
    set_has_deviceStates();
    return _deviceStates;
}

inline void trDeviceStates::setDeviceStates (const ::std::vector< trDeviceState >& deviceStates_) {
    set_has_deviceStates();
    this->_deviceStates = deviceStates_;
}

inline void trDeviceStates::set_has_deviceStates () {
    _has_bits_[0] |= 1u << 0;
}

inline void trDeviceStates::clear_has_deviceStates () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  trUpdState::trUpdState ()  :
    _train (),
    _sourceSwTrain (),
    _u32EstimatedUpdateTimeSec (0u),
    _muVersion (),
    _enState (::fcswupdatesrv::FcSwUpdateSrv::tenUpdState__Idle),
    _enUser (::fcswupdatesrv::FcSwUpdateSrv::tenUser__Customer),
    _enSourceType (::fcswupdatesrv::FcSwUpdateSrv::tenSourceType__Usb),
    _bHasEngineeringOptions (false),
    _bCustomSupported (false),
    _bCustomAvail (false),
    _bInterruptible (false),
    _bDevicesReady (false),
    _hasValidTrain (false),
    _bAllowRecoveryMode (false),
    _headUnitId (),
    _overallCISSWVer ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  trUpdState::trUpdState (const trUpdState &rhs)  :
    _train (),
    _sourceSwTrain (),
    _u32EstimatedUpdateTimeSec (0u),
    _muVersion (),
    _enState (::fcswupdatesrv::FcSwUpdateSrv::tenUpdState__Idle),
    _enUser (::fcswupdatesrv::FcSwUpdateSrv::tenUser__Customer),
    _enSourceType (::fcswupdatesrv::FcSwUpdateSrv::tenSourceType__Usb),
    _bHasEngineeringOptions (false),
    _bCustomSupported (false),
    _bCustomAvail (false),
    _bInterruptible (false),
    _bDevicesReady (false),
    _hasValidTrain (false),
    _bAllowRecoveryMode (false),
    _headUnitId (),
    _overallCISSWVer ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  trUpdState::trUpdState (const ::std::string& train_, const ::std::string& sourceSwTrain_, uint32 u32EstimatedUpdateTimeSec_, const ::std::string& muVersion_, tenUpdState enState_, tenUser enUser_, tenSourceType enSourceType_, bool bHasEngineeringOptions_, bool bCustomSupported_, bool bCustomAvail_, bool bInterruptible_, bool bDevicesReady_, bool hasValidTrain_, bool bAllowRecoveryMode_, const ::std::string& headUnitId_, const ::std::string& overallCISSWVer_)  :
    _train (train_),
    _sourceSwTrain (sourceSwTrain_),
    _u32EstimatedUpdateTimeSec (u32EstimatedUpdateTimeSec_),
    _muVersion (muVersion_),
    _enState (enState_),
    _enUser (enUser_),
    _enSourceType (enSourceType_),
    _bHasEngineeringOptions (bHasEngineeringOptions_),
    _bCustomSupported (bCustomSupported_),
    _bCustomAvail (bCustomAvail_),
    _bInterruptible (bInterruptible_),
    _bDevicesReady (bDevicesReady_),
    _hasValidTrain (hasValidTrain_),
    _bAllowRecoveryMode (bAllowRecoveryMode_),
    _headUnitId (headUnitId_),
    _overallCISSWVer (overallCISSWVer_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (train_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sourceSwTrain_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (muVersion_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(tenUpdState_IsValid(enState_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", enState_, "tenUpdState", "enState", "trUpdState");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(tenUser_IsValid(enUser_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", enUser_, "tenUser", "enUser", "trUpdState");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(tenSourceType_IsValid(enSourceType_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", enSourceType_, "tenSourceType", "enSourceType", "trUpdState");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (headUnitId_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (overallCISSWVer_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  trUpdState::~trUpdState() {
}

inline trUpdState& trUpdState::operator = (const trUpdState& rhs) {
    if( this != &rhs ) {
        if (rhs.hasTrain()) {
            setTrain(rhs.getTrain());
        } else {
            clearTrain();
        }
        if (rhs.hasSourceSwTrain()) {
            setSourceSwTrain(rhs.getSourceSwTrain());
        } else {
            clearSourceSwTrain();
        }
        if (rhs.hasU32EstimatedUpdateTimeSec()) {
            setU32EstimatedUpdateTimeSec(rhs.getU32EstimatedUpdateTimeSec());
        } else {
            clearU32EstimatedUpdateTimeSec();
        }
        if (rhs.hasMuVersion()) {
            setMuVersion(rhs.getMuVersion());
        } else {
            clearMuVersion();
        }
        if (rhs.hasEnState()) {
            setEnState(rhs.getEnState());
        } else {
            clearEnState();
        }
        if (rhs.hasEnUser()) {
            setEnUser(rhs.getEnUser());
        } else {
            clearEnUser();
        }
        if (rhs.hasEnSourceType()) {
            setEnSourceType(rhs.getEnSourceType());
        } else {
            clearEnSourceType();
        }
        if (rhs.hasBHasEngineeringOptions()) {
            setBHasEngineeringOptions(rhs.getBHasEngineeringOptions());
        } else {
            clearBHasEngineeringOptions();
        }
        if (rhs.hasBCustomSupported()) {
            setBCustomSupported(rhs.getBCustomSupported());
        } else {
            clearBCustomSupported();
        }
        if (rhs.hasBCustomAvail()) {
            setBCustomAvail(rhs.getBCustomAvail());
        } else {
            clearBCustomAvail();
        }
        if (rhs.hasBInterruptible()) {
            setBInterruptible(rhs.getBInterruptible());
        } else {
            clearBInterruptible();
        }
        if (rhs.hasBDevicesReady()) {
            setBDevicesReady(rhs.getBDevicesReady());
        } else {
            clearBDevicesReady();
        }
        if (rhs.hasHasValidTrain()) {
            setHasValidTrain(rhs.getHasValidTrain());
        } else {
            clearHasValidTrain();
        }
        if (rhs.hasBAllowRecoveryMode()) {
            setBAllowRecoveryMode(rhs.getBAllowRecoveryMode());
        } else {
            clearBAllowRecoveryMode();
        }
        if (rhs.hasHeadUnitId()) {
            setHeadUnitId(rhs.getHeadUnitId());
        } else {
            clearHeadUnitId();
        }
        if (rhs.hasOverallCISSWVer()) {
            setOverallCISSWVer(rhs.getOverallCISSWVer());
        } else {
            clearOverallCISSWVer();
        }
    }
    return *this;
}

inline bool trUpdState::operator == (const trUpdState& rhs) const {
    return (((!hasTrain() && !rhs.hasTrain()) || getTrain() == rhs.getTrain()) &&
        ((!hasSourceSwTrain() && !rhs.hasSourceSwTrain()) || getSourceSwTrain() == rhs.getSourceSwTrain()) &&
        ((!hasU32EstimatedUpdateTimeSec() && !rhs.hasU32EstimatedUpdateTimeSec()) || getU32EstimatedUpdateTimeSec() == rhs.getU32EstimatedUpdateTimeSec()) &&
        ((!hasMuVersion() && !rhs.hasMuVersion()) || getMuVersion() == rhs.getMuVersion()) &&
        ((!hasEnState() && !rhs.hasEnState()) || getEnState() == rhs.getEnState()) &&
        ((!hasEnUser() && !rhs.hasEnUser()) || getEnUser() == rhs.getEnUser()) &&
        ((!hasEnSourceType() && !rhs.hasEnSourceType()) || getEnSourceType() == rhs.getEnSourceType()) &&
        ((!hasBHasEngineeringOptions() && !rhs.hasBHasEngineeringOptions()) || getBHasEngineeringOptions() == rhs.getBHasEngineeringOptions()) &&
        ((!hasBCustomSupported() && !rhs.hasBCustomSupported()) || getBCustomSupported() == rhs.getBCustomSupported()) &&
        ((!hasBCustomAvail() && !rhs.hasBCustomAvail()) || getBCustomAvail() == rhs.getBCustomAvail()) &&
        ((!hasBInterruptible() && !rhs.hasBInterruptible()) || getBInterruptible() == rhs.getBInterruptible()) &&
        ((!hasBDevicesReady() && !rhs.hasBDevicesReady()) || getBDevicesReady() == rhs.getBDevicesReady()) &&
        ((!hasHasValidTrain() && !rhs.hasHasValidTrain()) || getHasValidTrain() == rhs.getHasValidTrain()) &&
        ((!hasBAllowRecoveryMode() && !rhs.hasBAllowRecoveryMode()) || getBAllowRecoveryMode() == rhs.getBAllowRecoveryMode()) &&
        ((!hasHeadUnitId() && !rhs.hasHeadUnitId()) || getHeadUnitId() == rhs.getHeadUnitId()) &&
        ((!hasOverallCISSWVer() && !rhs.hasOverallCISSWVer()) || getOverallCISSWVer() == rhs.getOverallCISSWVer()));
}

inline bool trUpdState::operator != (const trUpdState& rhs) const {
    return ! (*this == rhs);
}

inline bool trUpdState::operator < (const trUpdState& rhs) const {
    if (hasTrain() || rhs.hasTrain()) {
        if (getTrain() < rhs.getTrain()) return true;
        if (getTrain() > rhs.getTrain()) return false;
    }
    if (hasSourceSwTrain() || rhs.hasSourceSwTrain()) {
        if (getSourceSwTrain() < rhs.getSourceSwTrain()) return true;
        if (getSourceSwTrain() > rhs.getSourceSwTrain()) return false;
    }
    if (hasU32EstimatedUpdateTimeSec() || rhs.hasU32EstimatedUpdateTimeSec()) {
        if (getU32EstimatedUpdateTimeSec() < rhs.getU32EstimatedUpdateTimeSec()) return true;
        if (getU32EstimatedUpdateTimeSec() > rhs.getU32EstimatedUpdateTimeSec()) return false;
    }
    if (hasMuVersion() || rhs.hasMuVersion()) {
        if (getMuVersion() < rhs.getMuVersion()) return true;
        if (getMuVersion() > rhs.getMuVersion()) return false;
    }
    if (hasEnState() || rhs.hasEnState()) {
        if ((uint32)getEnState() < (uint32)rhs.getEnState()) return true;
        if ((uint32)getEnState() > (uint32)rhs.getEnState()) return false;
    }
    if (hasEnUser() || rhs.hasEnUser()) {
        if ((uint32)getEnUser() < (uint32)rhs.getEnUser()) return true;
        if ((uint32)getEnUser() > (uint32)rhs.getEnUser()) return false;
    }
    if (hasEnSourceType() || rhs.hasEnSourceType()) {
        if ((uint32)getEnSourceType() < (uint32)rhs.getEnSourceType()) return true;
        if ((uint32)getEnSourceType() > (uint32)rhs.getEnSourceType()) return false;
    }
    if (hasBHasEngineeringOptions() || rhs.hasBHasEngineeringOptions()) {
        if (getBHasEngineeringOptions() < rhs.getBHasEngineeringOptions()) return true;
        if (getBHasEngineeringOptions() > rhs.getBHasEngineeringOptions()) return false;
    }
    if (hasBCustomSupported() || rhs.hasBCustomSupported()) {
        if (getBCustomSupported() < rhs.getBCustomSupported()) return true;
        if (getBCustomSupported() > rhs.getBCustomSupported()) return false;
    }
    if (hasBCustomAvail() || rhs.hasBCustomAvail()) {
        if (getBCustomAvail() < rhs.getBCustomAvail()) return true;
        if (getBCustomAvail() > rhs.getBCustomAvail()) return false;
    }
    if (hasBInterruptible() || rhs.hasBInterruptible()) {
        if (getBInterruptible() < rhs.getBInterruptible()) return true;
        if (getBInterruptible() > rhs.getBInterruptible()) return false;
    }
    if (hasBDevicesReady() || rhs.hasBDevicesReady()) {
        if (getBDevicesReady() < rhs.getBDevicesReady()) return true;
        if (getBDevicesReady() > rhs.getBDevicesReady()) return false;
    }
    if (hasHasValidTrain() || rhs.hasHasValidTrain()) {
        if (getHasValidTrain() < rhs.getHasValidTrain()) return true;
        if (getHasValidTrain() > rhs.getHasValidTrain()) return false;
    }
    if (hasBAllowRecoveryMode() || rhs.hasBAllowRecoveryMode()) {
        if (getBAllowRecoveryMode() < rhs.getBAllowRecoveryMode()) return true;
        if (getBAllowRecoveryMode() > rhs.getBAllowRecoveryMode()) return false;
    }
    if (hasHeadUnitId() || rhs.hasHeadUnitId()) {
        if (getHeadUnitId() < rhs.getHeadUnitId()) return true;
        if (getHeadUnitId() > rhs.getHeadUnitId()) return false;
    }
    if (hasOverallCISSWVer() || rhs.hasOverallCISSWVer()) {
        if (getOverallCISSWVer() < rhs.getOverallCISSWVer()) return true;
        if (getOverallCISSWVer() > rhs.getOverallCISSWVer()) return false;
    }
    return false;
}

inline bool trUpdState::operator > (const trUpdState& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void trUpdState::clear() {
    clearTrain();
    clearSourceSwTrain();
    clearU32EstimatedUpdateTimeSec();
    clearMuVersion();
    clearEnState();
    clearEnUser();
    clearEnSourceType();
    clearBHasEngineeringOptions();
    clearBCustomSupported();
    clearBCustomAvail();
    clearBInterruptible();
    clearBDevicesReady();
    clearHasValidTrain();
    clearBAllowRecoveryMode();
    clearHeadUnitId();
    clearOverallCISSWVer();
}

inline void trUpdState::clearTrain() {
    if (hasTrain()) {
         clear_has_train();
        _train.clear();
     }
}

inline bool trUpdState::hasTrain () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& trUpdState::getTrain () const {
    return _train;
}

inline ::std::string& trUpdState::getTrainMutable () {
    set_has_train();
    return _train;
}

inline void trUpdState::setTrain (const ::std::string& train_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (train_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_train();
    this->_train = train_;
}

inline void trUpdState::setTrain (const char* train_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (train_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_train();
    this->_train.assign(train_);
}

inline void trUpdState::setTrain (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_train();
    this->_train.assign(value, size);
}

inline void trUpdState::clearSourceSwTrain() {
    if (hasSourceSwTrain()) {
         clear_has_sourceSwTrain();
        _sourceSwTrain.clear();
     }
}

inline bool trUpdState::hasSourceSwTrain () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& trUpdState::getSourceSwTrain () const {
    return _sourceSwTrain;
}

inline ::std::string& trUpdState::getSourceSwTrainMutable () {
    set_has_sourceSwTrain();
    return _sourceSwTrain;
}

inline void trUpdState::setSourceSwTrain (const ::std::string& sourceSwTrain_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sourceSwTrain_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sourceSwTrain();
    this->_sourceSwTrain = sourceSwTrain_;
}

inline void trUpdState::setSourceSwTrain (const char* sourceSwTrain_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sourceSwTrain_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sourceSwTrain();
    this->_sourceSwTrain.assign(sourceSwTrain_);
}

inline void trUpdState::setSourceSwTrain (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sourceSwTrain();
    this->_sourceSwTrain.assign(value, size);
}

inline void trUpdState::clearU32EstimatedUpdateTimeSec() {
    if (hasU32EstimatedUpdateTimeSec()) {
         clear_has_u32EstimatedUpdateTimeSec();
        _u32EstimatedUpdateTimeSec = 0u;
     }
}

inline bool trUpdState::hasU32EstimatedUpdateTimeSec () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint32 trUpdState::getU32EstimatedUpdateTimeSec () const {
    return _u32EstimatedUpdateTimeSec;
}

inline void trUpdState::setU32EstimatedUpdateTimeSec (uint32 u32EstimatedUpdateTimeSec_) {
    set_has_u32EstimatedUpdateTimeSec();
    this->_u32EstimatedUpdateTimeSec = u32EstimatedUpdateTimeSec_;
}

inline void trUpdState::clearMuVersion() {
    if (hasMuVersion()) {
         clear_has_muVersion();
        _muVersion.clear();
     }
}

inline bool trUpdState::hasMuVersion () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const ::std::string& trUpdState::getMuVersion () const {
    return _muVersion;
}

inline ::std::string& trUpdState::getMuVersionMutable () {
    set_has_muVersion();
    return _muVersion;
}

inline void trUpdState::setMuVersion (const ::std::string& muVersion_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (muVersion_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_muVersion();
    this->_muVersion = muVersion_;
}

inline void trUpdState::setMuVersion (const char* muVersion_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (muVersion_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_muVersion();
    this->_muVersion.assign(muVersion_);
}

inline void trUpdState::setMuVersion (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_muVersion();
    this->_muVersion.assign(value, size);
}

inline void trUpdState::clearEnState() {
    if (hasEnState()) {
         clear_has_enState();
        _enState = ::fcswupdatesrv::FcSwUpdateSrv::tenUpdState__Idle;
     }
}

inline bool trUpdState::hasEnState () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline tenUpdState trUpdState::getEnState () const {
    return _enState;
}

inline void trUpdState::setEnState (tenUpdState enState_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(tenUpdState_IsValid(enState_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", enState_, "tenUpdState", "enState", "trUpdState");
    }
    set_has_enState();
    this->_enState = enState_;
}

inline void trUpdState::clearEnUser() {
    if (hasEnUser()) {
         clear_has_enUser();
        _enUser = ::fcswupdatesrv::FcSwUpdateSrv::tenUser__Customer;
     }
}

inline bool trUpdState::hasEnUser () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline tenUser trUpdState::getEnUser () const {
    return _enUser;
}

inline void trUpdState::setEnUser (tenUser enUser_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(tenUser_IsValid(enUser_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", enUser_, "tenUser", "enUser", "trUpdState");
    }
    set_has_enUser();
    this->_enUser = enUser_;
}

inline void trUpdState::clearEnSourceType() {
    if (hasEnSourceType()) {
         clear_has_enSourceType();
        _enSourceType = ::fcswupdatesrv::FcSwUpdateSrv::tenSourceType__Usb;
     }
}

inline bool trUpdState::hasEnSourceType () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline tenSourceType trUpdState::getEnSourceType () const {
    return _enSourceType;
}

inline void trUpdState::setEnSourceType (tenSourceType enSourceType_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(tenSourceType_IsValid(enSourceType_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", enSourceType_, "tenSourceType", "enSourceType", "trUpdState");
    }
    set_has_enSourceType();
    this->_enSourceType = enSourceType_;
}

inline void trUpdState::clearBHasEngineeringOptions() {
    if (hasBHasEngineeringOptions()) {
         clear_has_bHasEngineeringOptions();
        _bHasEngineeringOptions = false;
     }
}

inline bool trUpdState::hasBHasEngineeringOptions () const {
    return (_has_bits_[0] & (1u << 7)) > 0;
}

inline bool trUpdState::getBHasEngineeringOptions () const {
    return _bHasEngineeringOptions;
}

inline void trUpdState::setBHasEngineeringOptions (bool bHasEngineeringOptions_) {
    set_has_bHasEngineeringOptions();
    this->_bHasEngineeringOptions = bHasEngineeringOptions_;
}

inline void trUpdState::clearBCustomSupported() {
    if (hasBCustomSupported()) {
         clear_has_bCustomSupported();
        _bCustomSupported = false;
     }
}

inline bool trUpdState::hasBCustomSupported () const {
    return (_has_bits_[0] & (1u << 8)) > 0;
}

inline bool trUpdState::getBCustomSupported () const {
    return _bCustomSupported;
}

inline void trUpdState::setBCustomSupported (bool bCustomSupported_) {
    set_has_bCustomSupported();
    this->_bCustomSupported = bCustomSupported_;
}

inline void trUpdState::clearBCustomAvail() {
    if (hasBCustomAvail()) {
         clear_has_bCustomAvail();
        _bCustomAvail = false;
     }
}

inline bool trUpdState::hasBCustomAvail () const {
    return (_has_bits_[0] & (1u << 9)) > 0;
}

inline bool trUpdState::getBCustomAvail () const {
    return _bCustomAvail;
}

inline void trUpdState::setBCustomAvail (bool bCustomAvail_) {
    set_has_bCustomAvail();
    this->_bCustomAvail = bCustomAvail_;
}

inline void trUpdState::clearBInterruptible() {
    if (hasBInterruptible()) {
         clear_has_bInterruptible();
        _bInterruptible = false;
     }
}

inline bool trUpdState::hasBInterruptible () const {
    return (_has_bits_[0] & (1u << 10)) > 0;
}

inline bool trUpdState::getBInterruptible () const {
    return _bInterruptible;
}

inline void trUpdState::setBInterruptible (bool bInterruptible_) {
    set_has_bInterruptible();
    this->_bInterruptible = bInterruptible_;
}

inline void trUpdState::clearBDevicesReady() {
    if (hasBDevicesReady()) {
         clear_has_bDevicesReady();
        _bDevicesReady = false;
     }
}

inline bool trUpdState::hasBDevicesReady () const {
    return (_has_bits_[0] & (1u << 11)) > 0;
}

inline bool trUpdState::getBDevicesReady () const {
    return _bDevicesReady;
}

inline void trUpdState::setBDevicesReady (bool bDevicesReady_) {
    set_has_bDevicesReady();
    this->_bDevicesReady = bDevicesReady_;
}

inline void trUpdState::clearHasValidTrain() {
    if (hasHasValidTrain()) {
         clear_has_hasValidTrain();
        _hasValidTrain = false;
     }
}

inline bool trUpdState::hasHasValidTrain () const {
    return (_has_bits_[0] & (1u << 12)) > 0;
}

inline bool trUpdState::getHasValidTrain () const {
    return _hasValidTrain;
}

inline void trUpdState::setHasValidTrain (bool hasValidTrain_) {
    set_has_hasValidTrain();
    this->_hasValidTrain = hasValidTrain_;
}

inline void trUpdState::clearBAllowRecoveryMode() {
    if (hasBAllowRecoveryMode()) {
         clear_has_bAllowRecoveryMode();
        _bAllowRecoveryMode = false;
     }
}

inline bool trUpdState::hasBAllowRecoveryMode () const {
    return (_has_bits_[0] & (1u << 13)) > 0;
}

inline bool trUpdState::getBAllowRecoveryMode () const {
    return _bAllowRecoveryMode;
}

inline void trUpdState::setBAllowRecoveryMode (bool bAllowRecoveryMode_) {
    set_has_bAllowRecoveryMode();
    this->_bAllowRecoveryMode = bAllowRecoveryMode_;
}

inline void trUpdState::clearHeadUnitId() {
    if (hasHeadUnitId()) {
         clear_has_headUnitId();
        _headUnitId.clear();
     }
}

inline bool trUpdState::hasHeadUnitId () const {
    return (_has_bits_[0] & (1u << 14)) > 0;
}

inline const ::std::string& trUpdState::getHeadUnitId () const {
    return _headUnitId;
}

inline ::std::string& trUpdState::getHeadUnitIdMutable () {
    set_has_headUnitId();
    return _headUnitId;
}

inline void trUpdState::setHeadUnitId (const ::std::string& headUnitId_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (headUnitId_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_headUnitId();
    this->_headUnitId = headUnitId_;
}

inline void trUpdState::setHeadUnitId (const char* headUnitId_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (headUnitId_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_headUnitId();
    this->_headUnitId.assign(headUnitId_);
}

inline void trUpdState::setHeadUnitId (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_headUnitId();
    this->_headUnitId.assign(value, size);
}

inline void trUpdState::clearOverallCISSWVer() {
    if (hasOverallCISSWVer()) {
         clear_has_overallCISSWVer();
        _overallCISSWVer.clear();
     }
}

inline bool trUpdState::hasOverallCISSWVer () const {
    return (_has_bits_[0] & (1u << 15)) > 0;
}

inline const ::std::string& trUpdState::getOverallCISSWVer () const {
    return _overallCISSWVer;
}

inline ::std::string& trUpdState::getOverallCISSWVerMutable () {
    set_has_overallCISSWVer();
    return _overallCISSWVer;
}

inline void trUpdState::setOverallCISSWVer (const ::std::string& overallCISSWVer_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (overallCISSWVer_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_overallCISSWVer();
    this->_overallCISSWVer = overallCISSWVer_;
}

inline void trUpdState::setOverallCISSWVer (const char* overallCISSWVer_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (overallCISSWVer_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_overallCISSWVer();
    this->_overallCISSWVer.assign(overallCISSWVer_);
}

inline void trUpdState::setOverallCISSWVer (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_overallCISSWVer();
    this->_overallCISSWVer.assign(value, size);
}

inline void trUpdState::set_has_train () {
    _has_bits_[0] |= 1u << 0;
}

inline void trUpdState::clear_has_train () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void trUpdState::set_has_sourceSwTrain () {
    _has_bits_[0] |= 1u << 1;
}

inline void trUpdState::clear_has_sourceSwTrain () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void trUpdState::set_has_u32EstimatedUpdateTimeSec () {
    _has_bits_[0] |= 1u << 2;
}

inline void trUpdState::clear_has_u32EstimatedUpdateTimeSec () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void trUpdState::set_has_muVersion () {
    _has_bits_[0] |= 1u << 3;
}

inline void trUpdState::clear_has_muVersion () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void trUpdState::set_has_enState () {
    _has_bits_[0] |= 1u << 4;
}

inline void trUpdState::clear_has_enState () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void trUpdState::set_has_enUser () {
    _has_bits_[0] |= 1u << 5;
}

inline void trUpdState::clear_has_enUser () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void trUpdState::set_has_enSourceType () {
    _has_bits_[0] |= 1u << 6;
}

inline void trUpdState::clear_has_enSourceType () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline void trUpdState::set_has_bHasEngineeringOptions () {
    _has_bits_[0] |= 1u << 7;
}

inline void trUpdState::clear_has_bHasEngineeringOptions () {
    _has_bits_[0] &= ~ (1u << 7);
}

inline void trUpdState::set_has_bCustomSupported () {
    _has_bits_[0] |= 1u << 8;
}

inline void trUpdState::clear_has_bCustomSupported () {
    _has_bits_[0] &= ~ (1u << 8);
}

inline void trUpdState::set_has_bCustomAvail () {
    _has_bits_[0] |= 1u << 9;
}

inline void trUpdState::clear_has_bCustomAvail () {
    _has_bits_[0] &= ~ (1u << 9);
}

inline void trUpdState::set_has_bInterruptible () {
    _has_bits_[0] |= 1u << 10;
}

inline void trUpdState::clear_has_bInterruptible () {
    _has_bits_[0] &= ~ (1u << 10);
}

inline void trUpdState::set_has_bDevicesReady () {
    _has_bits_[0] |= 1u << 11;
}

inline void trUpdState::clear_has_bDevicesReady () {
    _has_bits_[0] &= ~ (1u << 11);
}

inline void trUpdState::set_has_hasValidTrain () {
    _has_bits_[0] |= 1u << 12;
}

inline void trUpdState::clear_has_hasValidTrain () {
    _has_bits_[0] &= ~ (1u << 12);
}

inline void trUpdState::set_has_bAllowRecoveryMode () {
    _has_bits_[0] |= 1u << 13;
}

inline void trUpdState::clear_has_bAllowRecoveryMode () {
    _has_bits_[0] &= ~ (1u << 13);
}

inline void trUpdState::set_has_headUnitId () {
    _has_bits_[0] |= 1u << 14;
}

inline void trUpdState::clear_has_headUnitId () {
    _has_bits_[0] &= ~ (1u << 14);
}

inline void trUpdState::set_has_overallCISSWVer () {
    _has_bits_[0] |= 1u << 15;
}

inline void trUpdState::clear_has_overallCISSWVer () {
    _has_bits_[0] &= ~ (1u << 15);
}

inline  trSubModuleData::trSubModuleData ()  :
    _name (),
    _bSelected (false),
    _info (),
    _toVersion (),
    _fromVersion (),
    _sizeBytes (0u),
    _enScope (::fcswupdatesrv::FcSwUpdateSrv::tenScope__Yes),
    _compatInfo ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  trSubModuleData::trSubModuleData (const trSubModuleData &rhs)  :
    _name (),
    _bSelected (false),
    _info (),
    _toVersion (),
    _fromVersion (),
    _sizeBytes (0u),
    _enScope (::fcswupdatesrv::FcSwUpdateSrv::tenScope__Yes),
    _compatInfo ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  trSubModuleData::trSubModuleData (const ::std::string& name_, bool bSelected_, const ::std::string& info_, const ::std::string& toVersion_, const ::std::string& fromVersion_, uint64 sizeBytes_, tenScope enScope_, const ::std::vector< uint8 >& compatInfo_)  :
    _name (name_),
    _bSelected (bSelected_),
    _info (info_),
    _toVersion (toVersion_),
    _fromVersion (fromVersion_),
    _sizeBytes (sizeBytes_),
    _enScope (enScope_),
    _compatInfo (compatInfo_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (name_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (info_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (toVersion_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (fromVersion_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(tenScope_IsValid(enScope_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", enScope_, "tenScope", "enScope", "trSubModuleData");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  trSubModuleData::~trSubModuleData() {
}

inline trSubModuleData& trSubModuleData::operator = (const trSubModuleData& rhs) {
    if( this != &rhs ) {
        if (rhs.hasName()) {
            setName(rhs.getName());
        } else {
            clearName();
        }
        if (rhs.hasBSelected()) {
            setBSelected(rhs.getBSelected());
        } else {
            clearBSelected();
        }
        if (rhs.hasInfo()) {
            setInfo(rhs.getInfo());
        } else {
            clearInfo();
        }
        if (rhs.hasToVersion()) {
            setToVersion(rhs.getToVersion());
        } else {
            clearToVersion();
        }
        if (rhs.hasFromVersion()) {
            setFromVersion(rhs.getFromVersion());
        } else {
            clearFromVersion();
        }
        if (rhs.hasSizeBytes()) {
            setSizeBytes(rhs.getSizeBytes());
        } else {
            clearSizeBytes();
        }
        if (rhs.hasEnScope()) {
            setEnScope(rhs.getEnScope());
        } else {
            clearEnScope();
        }
        if (rhs.hasCompatInfo()) {
            setCompatInfo(rhs.getCompatInfo());
        } else {
            clearCompatInfo();
        }
    }
    return *this;
}

inline bool trSubModuleData::operator == (const trSubModuleData& rhs) const {
    return (((!hasName() && !rhs.hasName()) || getName() == rhs.getName()) &&
        ((!hasBSelected() && !rhs.hasBSelected()) || getBSelected() == rhs.getBSelected()) &&
        ((!hasInfo() && !rhs.hasInfo()) || getInfo() == rhs.getInfo()) &&
        ((!hasToVersion() && !rhs.hasToVersion()) || getToVersion() == rhs.getToVersion()) &&
        ((!hasFromVersion() && !rhs.hasFromVersion()) || getFromVersion() == rhs.getFromVersion()) &&
        ((!hasSizeBytes() && !rhs.hasSizeBytes()) || getSizeBytes() == rhs.getSizeBytes()) &&
        ((!hasEnScope() && !rhs.hasEnScope()) || getEnScope() == rhs.getEnScope()) &&
        ((!hasCompatInfo() && !rhs.hasCompatInfo()) || getCompatInfo() == rhs.getCompatInfo()));
}

inline bool trSubModuleData::operator != (const trSubModuleData& rhs) const {
    return ! (*this == rhs);
}

inline bool trSubModuleData::operator < (const trSubModuleData& rhs) const {
    if (hasName() || rhs.hasName()) {
        if (getName() < rhs.getName()) return true;
        if (getName() > rhs.getName()) return false;
    }
    if (hasBSelected() || rhs.hasBSelected()) {
        if (getBSelected() < rhs.getBSelected()) return true;
        if (getBSelected() > rhs.getBSelected()) return false;
    }
    if (hasInfo() || rhs.hasInfo()) {
        if (getInfo() < rhs.getInfo()) return true;
        if (getInfo() > rhs.getInfo()) return false;
    }
    if (hasToVersion() || rhs.hasToVersion()) {
        if (getToVersion() < rhs.getToVersion()) return true;
        if (getToVersion() > rhs.getToVersion()) return false;
    }
    if (hasFromVersion() || rhs.hasFromVersion()) {
        if (getFromVersion() < rhs.getFromVersion()) return true;
        if (getFromVersion() > rhs.getFromVersion()) return false;
    }
    if (hasSizeBytes() || rhs.hasSizeBytes()) {
        if (getSizeBytes() < rhs.getSizeBytes()) return true;
        if (getSizeBytes() > rhs.getSizeBytes()) return false;
    }
    if (hasEnScope() || rhs.hasEnScope()) {
        if ((uint32)getEnScope() < (uint32)rhs.getEnScope()) return true;
        if ((uint32)getEnScope() > (uint32)rhs.getEnScope()) return false;
    }
    if (hasCompatInfo() || rhs.hasCompatInfo()) {
        if (getCompatInfo() < rhs.getCompatInfo()) return true;
        if (getCompatInfo() > rhs.getCompatInfo()) return false;
    }
    return false;
}

inline bool trSubModuleData::operator > (const trSubModuleData& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void trSubModuleData::clear() {
    clearName();
    clearBSelected();
    clearInfo();
    clearToVersion();
    clearFromVersion();
    clearSizeBytes();
    clearEnScope();
    clearCompatInfo();
}

inline void trSubModuleData::clearName() {
    if (hasName()) {
         clear_has_name();
        _name.clear();
     }
}

inline bool trSubModuleData::hasName () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& trSubModuleData::getName () const {
    return _name;
}

inline ::std::string& trSubModuleData::getNameMutable () {
    set_has_name();
    return _name;
}

inline void trSubModuleData::setName (const ::std::string& name_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (name_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_name();
    this->_name = name_;
}

inline void trSubModuleData::setName (const char* name_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (name_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_name();
    this->_name.assign(name_);
}

inline void trSubModuleData::setName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_name();
    this->_name.assign(value, size);
}

inline void trSubModuleData::clearBSelected() {
    if (hasBSelected()) {
         clear_has_bSelected();
        _bSelected = false;
     }
}

inline bool trSubModuleData::hasBSelected () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline bool trSubModuleData::getBSelected () const {
    return _bSelected;
}

inline void trSubModuleData::setBSelected (bool bSelected_) {
    set_has_bSelected();
    this->_bSelected = bSelected_;
}

inline void trSubModuleData::clearInfo() {
    if (hasInfo()) {
         clear_has_info();
        _info.clear();
     }
}

inline bool trSubModuleData::hasInfo () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::string& trSubModuleData::getInfo () const {
    return _info;
}

inline ::std::string& trSubModuleData::getInfoMutable () {
    set_has_info();
    return _info;
}

inline void trSubModuleData::setInfo (const ::std::string& info_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (info_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_info();
    this->_info = info_;
}

inline void trSubModuleData::setInfo (const char* info_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (info_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_info();
    this->_info.assign(info_);
}

inline void trSubModuleData::setInfo (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_info();
    this->_info.assign(value, size);
}

inline void trSubModuleData::clearToVersion() {
    if (hasToVersion()) {
         clear_has_toVersion();
        _toVersion.clear();
     }
}

inline bool trSubModuleData::hasToVersion () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const ::std::string& trSubModuleData::getToVersion () const {
    return _toVersion;
}

inline ::std::string& trSubModuleData::getToVersionMutable () {
    set_has_toVersion();
    return _toVersion;
}

inline void trSubModuleData::setToVersion (const ::std::string& toVersion_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (toVersion_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_toVersion();
    this->_toVersion = toVersion_;
}

inline void trSubModuleData::setToVersion (const char* toVersion_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (toVersion_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_toVersion();
    this->_toVersion.assign(toVersion_);
}

inline void trSubModuleData::setToVersion (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_toVersion();
    this->_toVersion.assign(value, size);
}

inline void trSubModuleData::clearFromVersion() {
    if (hasFromVersion()) {
         clear_has_fromVersion();
        _fromVersion.clear();
     }
}

inline bool trSubModuleData::hasFromVersion () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline const ::std::string& trSubModuleData::getFromVersion () const {
    return _fromVersion;
}

inline ::std::string& trSubModuleData::getFromVersionMutable () {
    set_has_fromVersion();
    return _fromVersion;
}

inline void trSubModuleData::setFromVersion (const ::std::string& fromVersion_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (fromVersion_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_fromVersion();
    this->_fromVersion = fromVersion_;
}

inline void trSubModuleData::setFromVersion (const char* fromVersion_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (fromVersion_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_fromVersion();
    this->_fromVersion.assign(fromVersion_);
}

inline void trSubModuleData::setFromVersion (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_fromVersion();
    this->_fromVersion.assign(value, size);
}

inline void trSubModuleData::clearSizeBytes() {
    if (hasSizeBytes()) {
         clear_has_sizeBytes();
        _sizeBytes = 0u;
     }
}

inline bool trSubModuleData::hasSizeBytes () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline uint64 trSubModuleData::getSizeBytes () const {
    return _sizeBytes;
}

inline void trSubModuleData::setSizeBytes (uint64 sizeBytes_) {
    set_has_sizeBytes();
    this->_sizeBytes = sizeBytes_;
}

inline void trSubModuleData::clearEnScope() {
    if (hasEnScope()) {
         clear_has_enScope();
        _enScope = ::fcswupdatesrv::FcSwUpdateSrv::tenScope__Yes;
     }
}

inline bool trSubModuleData::hasEnScope () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline tenScope trSubModuleData::getEnScope () const {
    return _enScope;
}

inline void trSubModuleData::setEnScope (tenScope enScope_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(tenScope_IsValid(enScope_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", enScope_, "tenScope", "enScope", "trSubModuleData");
    }
    set_has_enScope();
    this->_enScope = enScope_;
}

inline void trSubModuleData::clearCompatInfo() {
    if (hasCompatInfo()) {
         clear_has_compatInfo();
        _compatInfo.clear();
     }
}

inline bool trSubModuleData::hasCompatInfo () const {
    return (_has_bits_[0] & (1u << 7)) > 0;
}

inline const ::std::vector< uint8 >& trSubModuleData::getCompatInfo () const {
    return _compatInfo;
}

inline ::std::vector< uint8 >& trSubModuleData::getCompatInfoMutable () {
    set_has_compatInfo();
    return _compatInfo;
}

inline void trSubModuleData::setCompatInfo (const ::std::vector< uint8 >& compatInfo_) {
    set_has_compatInfo();
    this->_compatInfo = compatInfo_;
}

inline void trSubModuleData::set_has_name () {
    _has_bits_[0] |= 1u << 0;
}

inline void trSubModuleData::clear_has_name () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void trSubModuleData::set_has_bSelected () {
    _has_bits_[0] |= 1u << 1;
}

inline void trSubModuleData::clear_has_bSelected () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void trSubModuleData::set_has_info () {
    _has_bits_[0] |= 1u << 2;
}

inline void trSubModuleData::clear_has_info () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void trSubModuleData::set_has_toVersion () {
    _has_bits_[0] |= 1u << 3;
}

inline void trSubModuleData::clear_has_toVersion () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void trSubModuleData::set_has_fromVersion () {
    _has_bits_[0] |= 1u << 4;
}

inline void trSubModuleData::clear_has_fromVersion () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void trSubModuleData::set_has_sizeBytes () {
    _has_bits_[0] |= 1u << 5;
}

inline void trSubModuleData::clear_has_sizeBytes () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void trSubModuleData::set_has_enScope () {
    _has_bits_[0] |= 1u << 6;
}

inline void trSubModuleData::clear_has_enScope () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline void trSubModuleData::set_has_compatInfo () {
    _has_bits_[0] |= 1u << 7;
}

inline void trSubModuleData::clear_has_compatInfo () {
    _has_bits_[0] &= ~ (1u << 7);
}

inline  trModuleData::trModuleData ()  :
    _name (),
    _hwIndex (),
    _subModules (),
    _enScope (::fcswupdatesrv::FcSwUpdateSrv::tenScope__Yes)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  trModuleData::trModuleData (const trModuleData &rhs)  :
    _name (),
    _hwIndex (),
    _subModules (),
    _enScope (::fcswupdatesrv::FcSwUpdateSrv::tenScope__Yes)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  trModuleData::trModuleData (const ::std::string& name_, const ::std::string& hwIndex_, const ::std::vector< trSubModuleData >& subModules_, tenScope enScope_)  :
    _name (name_),
    _hwIndex (hwIndex_),
    _subModules (subModules_),
    _enScope (enScope_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (name_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (hwIndex_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(tenScope_IsValid(enScope_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", enScope_, "tenScope", "enScope", "trModuleData");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  trModuleData::~trModuleData() {
}

inline trModuleData& trModuleData::operator = (const trModuleData& rhs) {
    if( this != &rhs ) {
        if (rhs.hasName()) {
            setName(rhs.getName());
        } else {
            clearName();
        }
        if (rhs.hasHwIndex()) {
            setHwIndex(rhs.getHwIndex());
        } else {
            clearHwIndex();
        }
        if (rhs.hasSubModules()) {
            setSubModules(rhs.getSubModules());
        } else {
            clearSubModules();
        }
        if (rhs.hasEnScope()) {
            setEnScope(rhs.getEnScope());
        } else {
            clearEnScope();
        }
    }
    return *this;
}

inline bool trModuleData::operator == (const trModuleData& rhs) const {
    return (((!hasName() && !rhs.hasName()) || getName() == rhs.getName()) &&
        ((!hasHwIndex() && !rhs.hasHwIndex()) || getHwIndex() == rhs.getHwIndex()) &&
        ((!hasSubModules() && !rhs.hasSubModules()) || getSubModules() == rhs.getSubModules()) &&
        ((!hasEnScope() && !rhs.hasEnScope()) || getEnScope() == rhs.getEnScope()));
}

inline bool trModuleData::operator != (const trModuleData& rhs) const {
    return ! (*this == rhs);
}

inline bool trModuleData::operator < (const trModuleData& rhs) const {
    if (hasName() || rhs.hasName()) {
        if (getName() < rhs.getName()) return true;
        if (getName() > rhs.getName()) return false;
    }
    if (hasHwIndex() || rhs.hasHwIndex()) {
        if (getHwIndex() < rhs.getHwIndex()) return true;
        if (getHwIndex() > rhs.getHwIndex()) return false;
    }
    if (hasSubModules() || rhs.hasSubModules()) {
        if (getSubModules() < rhs.getSubModules()) return true;
        if (getSubModules() > rhs.getSubModules()) return false;
    }
    if (hasEnScope() || rhs.hasEnScope()) {
        if ((uint32)getEnScope() < (uint32)rhs.getEnScope()) return true;
        if ((uint32)getEnScope() > (uint32)rhs.getEnScope()) return false;
    }
    return false;
}

inline bool trModuleData::operator > (const trModuleData& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void trModuleData::clear() {
    clearName();
    clearHwIndex();
    clearSubModules();
    clearEnScope();
}

inline void trModuleData::clearName() {
    if (hasName()) {
         clear_has_name();
        _name.clear();
     }
}

inline bool trModuleData::hasName () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& trModuleData::getName () const {
    return _name;
}

inline ::std::string& trModuleData::getNameMutable () {
    set_has_name();
    return _name;
}

inline void trModuleData::setName (const ::std::string& name_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (name_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_name();
    this->_name = name_;
}

inline void trModuleData::setName (const char* name_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (name_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_name();
    this->_name.assign(name_);
}

inline void trModuleData::setName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_name();
    this->_name.assign(value, size);
}

inline void trModuleData::clearHwIndex() {
    if (hasHwIndex()) {
         clear_has_hwIndex();
        _hwIndex.clear();
     }
}

inline bool trModuleData::hasHwIndex () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& trModuleData::getHwIndex () const {
    return _hwIndex;
}

inline ::std::string& trModuleData::getHwIndexMutable () {
    set_has_hwIndex();
    return _hwIndex;
}

inline void trModuleData::setHwIndex (const ::std::string& hwIndex_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (hwIndex_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_hwIndex();
    this->_hwIndex = hwIndex_;
}

inline void trModuleData::setHwIndex (const char* hwIndex_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (hwIndex_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_hwIndex();
    this->_hwIndex.assign(hwIndex_);
}

inline void trModuleData::setHwIndex (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_hwIndex();
    this->_hwIndex.assign(value, size);
}

inline void trModuleData::clearSubModules() {
    if (hasSubModules()) {
         clear_has_subModules();
        _subModules.clear();
     }
}

inline bool trModuleData::hasSubModules () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::vector< trSubModuleData >& trModuleData::getSubModules () const {
    return _subModules;
}

inline ::std::vector< trSubModuleData >& trModuleData::getSubModulesMutable () {
    set_has_subModules();
    return _subModules;
}

inline void trModuleData::setSubModules (const ::std::vector< trSubModuleData >& subModules_) {
    set_has_subModules();
    this->_subModules = subModules_;
}

inline void trModuleData::clearEnScope() {
    if (hasEnScope()) {
         clear_has_enScope();
        _enScope = ::fcswupdatesrv::FcSwUpdateSrv::tenScope__Yes;
     }
}

inline bool trModuleData::hasEnScope () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline tenScope trModuleData::getEnScope () const {
    return _enScope;
}

inline void trModuleData::setEnScope (tenScope enScope_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(tenScope_IsValid(enScope_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", enScope_, "tenScope", "enScope", "trModuleData");
    }
    set_has_enScope();
    this->_enScope = enScope_;
}

inline void trModuleData::set_has_name () {
    _has_bits_[0] |= 1u << 0;
}

inline void trModuleData::clear_has_name () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void trModuleData::set_has_hwIndex () {
    _has_bits_[0] |= 1u << 1;
}

inline void trModuleData::clear_has_hwIndex () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void trModuleData::set_has_subModules () {
    _has_bits_[0] |= 1u << 2;
}

inline void trModuleData::clear_has_subModules () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void trModuleData::set_has_enScope () {
    _has_bits_[0] |= 1u << 3;
}

inline void trModuleData::clear_has_enScope () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  trDeviceData::trDeviceData ()  :
    _name (),
    _modules (),
    _enScope (::fcswupdatesrv::FcSwUpdateSrv::tenScope__Yes)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  trDeviceData::trDeviceData (const trDeviceData &rhs)  :
    _name (),
    _modules (),
    _enScope (::fcswupdatesrv::FcSwUpdateSrv::tenScope__Yes)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  trDeviceData::trDeviceData (const ::std::string& name_, const ::std::vector< trModuleData >& modules_, tenScope enScope_)  :
    _name (name_),
    _modules (modules_),
    _enScope (enScope_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (name_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(tenScope_IsValid(enScope_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", enScope_, "tenScope", "enScope", "trDeviceData");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  trDeviceData::~trDeviceData() {
}

inline trDeviceData& trDeviceData::operator = (const trDeviceData& rhs) {
    if( this != &rhs ) {
        if (rhs.hasName()) {
            setName(rhs.getName());
        } else {
            clearName();
        }
        if (rhs.hasModules()) {
            setModules(rhs.getModules());
        } else {
            clearModules();
        }
        if (rhs.hasEnScope()) {
            setEnScope(rhs.getEnScope());
        } else {
            clearEnScope();
        }
    }
    return *this;
}

inline bool trDeviceData::operator == (const trDeviceData& rhs) const {
    return (((!hasName() && !rhs.hasName()) || getName() == rhs.getName()) &&
        ((!hasModules() && !rhs.hasModules()) || getModules() == rhs.getModules()) &&
        ((!hasEnScope() && !rhs.hasEnScope()) || getEnScope() == rhs.getEnScope()));
}

inline bool trDeviceData::operator != (const trDeviceData& rhs) const {
    return ! (*this == rhs);
}

inline bool trDeviceData::operator < (const trDeviceData& rhs) const {
    if (hasName() || rhs.hasName()) {
        if (getName() < rhs.getName()) return true;
        if (getName() > rhs.getName()) return false;
    }
    if (hasModules() || rhs.hasModules()) {
        if (getModules() < rhs.getModules()) return true;
        if (getModules() > rhs.getModules()) return false;
    }
    if (hasEnScope() || rhs.hasEnScope()) {
        if ((uint32)getEnScope() < (uint32)rhs.getEnScope()) return true;
        if ((uint32)getEnScope() > (uint32)rhs.getEnScope()) return false;
    }
    return false;
}

inline bool trDeviceData::operator > (const trDeviceData& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void trDeviceData::clear() {
    clearName();
    clearModules();
    clearEnScope();
}

inline void trDeviceData::clearName() {
    if (hasName()) {
         clear_has_name();
        _name.clear();
     }
}

inline bool trDeviceData::hasName () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& trDeviceData::getName () const {
    return _name;
}

inline ::std::string& trDeviceData::getNameMutable () {
    set_has_name();
    return _name;
}

inline void trDeviceData::setName (const ::std::string& name_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (name_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_name();
    this->_name = name_;
}

inline void trDeviceData::setName (const char* name_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (name_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_name();
    this->_name.assign(name_);
}

inline void trDeviceData::setName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_name();
    this->_name.assign(value, size);
}

inline void trDeviceData::clearModules() {
    if (hasModules()) {
         clear_has_modules();
        _modules.clear();
     }
}

inline bool trDeviceData::hasModules () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::vector< trModuleData >& trDeviceData::getModules () const {
    return _modules;
}

inline ::std::vector< trModuleData >& trDeviceData::getModulesMutable () {
    set_has_modules();
    return _modules;
}

inline void trDeviceData::setModules (const ::std::vector< trModuleData >& modules_) {
    set_has_modules();
    this->_modules = modules_;
}

inline void trDeviceData::clearEnScope() {
    if (hasEnScope()) {
         clear_has_enScope();
        _enScope = ::fcswupdatesrv::FcSwUpdateSrv::tenScope__Yes;
     }
}

inline bool trDeviceData::hasEnScope () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline tenScope trDeviceData::getEnScope () const {
    return _enScope;
}

inline void trDeviceData::setEnScope (tenScope enScope_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(tenScope_IsValid(enScope_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", enScope_, "tenScope", "enScope", "trDeviceData");
    }
    set_has_enScope();
    this->_enScope = enScope_;
}

inline void trDeviceData::set_has_name () {
    _has_bits_[0] |= 1u << 0;
}

inline void trDeviceData::clear_has_name () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void trDeviceData::set_has_modules () {
    _has_bits_[0] |= 1u << 1;
}

inline void trDeviceData::clear_has_modules () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void trDeviceData::set_has_enScope () {
    _has_bits_[0] |= 1u << 2;
}

inline void trDeviceData::clear_has_enScope () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  trTartgetState::trTartgetState ()  :
    _filter (::fcswupdatesrv::FcSwUpdateSrv::tenUpdType__All),
    _name (),
    _devices ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  trTartgetState::trTartgetState (const trTartgetState &rhs)  :
    _filter (::fcswupdatesrv::FcSwUpdateSrv::tenUpdType__All),
    _name (),
    _devices ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  trTartgetState::trTartgetState (tenUpdType filter_, const ::std::string& name_, const ::std::vector< trDeviceData >& devices_)  :
    _filter (filter_),
    _name (name_),
    _devices (devices_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(tenUpdType_IsValid(filter_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", filter_, "tenUpdType", "filter", "trTartgetState");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (name_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  trTartgetState::~trTartgetState() {
}

inline trTartgetState& trTartgetState::operator = (const trTartgetState& rhs) {
    if( this != &rhs ) {
        if (rhs.hasFilter()) {
            setFilter(rhs.getFilter());
        } else {
            clearFilter();
        }
        if (rhs.hasName()) {
            setName(rhs.getName());
        } else {
            clearName();
        }
        if (rhs.hasDevices()) {
            setDevices(rhs.getDevices());
        } else {
            clearDevices();
        }
    }
    return *this;
}

inline bool trTartgetState::operator == (const trTartgetState& rhs) const {
    return (((!hasFilter() && !rhs.hasFilter()) || getFilter() == rhs.getFilter()) &&
        ((!hasName() && !rhs.hasName()) || getName() == rhs.getName()) &&
        ((!hasDevices() && !rhs.hasDevices()) || getDevices() == rhs.getDevices()));
}

inline bool trTartgetState::operator != (const trTartgetState& rhs) const {
    return ! (*this == rhs);
}

inline bool trTartgetState::operator < (const trTartgetState& rhs) const {
    if (hasFilter() || rhs.hasFilter()) {
        if ((uint32)getFilter() < (uint32)rhs.getFilter()) return true;
        if ((uint32)getFilter() > (uint32)rhs.getFilter()) return false;
    }
    if (hasName() || rhs.hasName()) {
        if (getName() < rhs.getName()) return true;
        if (getName() > rhs.getName()) return false;
    }
    if (hasDevices() || rhs.hasDevices()) {
        if (getDevices() < rhs.getDevices()) return true;
        if (getDevices() > rhs.getDevices()) return false;
    }
    return false;
}

inline bool trTartgetState::operator > (const trTartgetState& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void trTartgetState::clear() {
    clearFilter();
    clearName();
    clearDevices();
}

inline void trTartgetState::clearFilter() {
    if (hasFilter()) {
         clear_has_filter();
        _filter = ::fcswupdatesrv::FcSwUpdateSrv::tenUpdType__All;
     }
}

inline bool trTartgetState::hasFilter () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline tenUpdType trTartgetState::getFilter () const {
    return _filter;
}

inline void trTartgetState::setFilter (tenUpdType filter_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(tenUpdType_IsValid(filter_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", filter_, "tenUpdType", "filter", "trTartgetState");
    }
    set_has_filter();
    this->_filter = filter_;
}

inline void trTartgetState::clearName() {
    if (hasName()) {
         clear_has_name();
        _name.clear();
     }
}

inline bool trTartgetState::hasName () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& trTartgetState::getName () const {
    return _name;
}

inline ::std::string& trTartgetState::getNameMutable () {
    set_has_name();
    return _name;
}

inline void trTartgetState::setName (const ::std::string& name_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (name_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_name();
    this->_name = name_;
}

inline void trTartgetState::setName (const char* name_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (name_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_name();
    this->_name.assign(name_);
}

inline void trTartgetState::setName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_name();
    this->_name.assign(value, size);
}

inline void trTartgetState::clearDevices() {
    if (hasDevices()) {
         clear_has_devices();
        _devices.clear();
     }
}

inline bool trTartgetState::hasDevices () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::vector< trDeviceData >& trTartgetState::getDevices () const {
    return _devices;
}

inline ::std::vector< trDeviceData >& trTartgetState::getDevicesMutable () {
    set_has_devices();
    return _devices;
}

inline void trTartgetState::setDevices (const ::std::vector< trDeviceData >& devices_) {
    set_has_devices();
    this->_devices = devices_;
}

inline void trTartgetState::set_has_filter () {
    _has_bits_[0] |= 1u << 0;
}

inline void trTartgetState::clear_has_filter () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void trTartgetState::set_has_name () {
    _has_bits_[0] |= 1u << 1;
}

inline void trTartgetState::clear_has_name () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void trTartgetState::set_has_devices () {
    _has_bits_[0] |= 1u << 2;
}

inline void trTartgetState::clear_has_devices () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  trConfigProblem::trConfigProblem ()  :
    _moduleName (),
    _enErrorId (::fcswupdatesrv::FcSwUpdateSrv::tenErrorId__SWL_OK)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  trConfigProblem::trConfigProblem (const trConfigProblem &rhs)  :
    _moduleName (),
    _enErrorId (::fcswupdatesrv::FcSwUpdateSrv::tenErrorId__SWL_OK)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  trConfigProblem::trConfigProblem (const ::std::string& moduleName_, tenErrorId enErrorId_)  :
    _moduleName (moduleName_),
    _enErrorId (enErrorId_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (moduleName_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(tenErrorId_IsValid(enErrorId_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", enErrorId_, "tenErrorId", "enErrorId", "trConfigProblem");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  trConfigProblem::~trConfigProblem() {
}

inline trConfigProblem& trConfigProblem::operator = (const trConfigProblem& rhs) {
    if( this != &rhs ) {
        if (rhs.hasModuleName()) {
            setModuleName(rhs.getModuleName());
        } else {
            clearModuleName();
        }
        if (rhs.hasEnErrorId()) {
            setEnErrorId(rhs.getEnErrorId());
        } else {
            clearEnErrorId();
        }
    }
    return *this;
}

inline bool trConfigProblem::operator == (const trConfigProblem& rhs) const {
    return (((!hasModuleName() && !rhs.hasModuleName()) || getModuleName() == rhs.getModuleName()) &&
        ((!hasEnErrorId() && !rhs.hasEnErrorId()) || getEnErrorId() == rhs.getEnErrorId()));
}

inline bool trConfigProblem::operator != (const trConfigProblem& rhs) const {
    return ! (*this == rhs);
}

inline bool trConfigProblem::operator < (const trConfigProblem& rhs) const {
    if (hasModuleName() || rhs.hasModuleName()) {
        if (getModuleName() < rhs.getModuleName()) return true;
        if (getModuleName() > rhs.getModuleName()) return false;
    }
    if (hasEnErrorId() || rhs.hasEnErrorId()) {
        if ((uint32)getEnErrorId() < (uint32)rhs.getEnErrorId()) return true;
        if ((uint32)getEnErrorId() > (uint32)rhs.getEnErrorId()) return false;
    }
    return false;
}

inline bool trConfigProblem::operator > (const trConfigProblem& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void trConfigProblem::clear() {
    clearModuleName();
    clearEnErrorId();
}

inline void trConfigProblem::clearModuleName() {
    if (hasModuleName()) {
         clear_has_moduleName();
        _moduleName.clear();
     }
}

inline bool trConfigProblem::hasModuleName () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& trConfigProblem::getModuleName () const {
    return _moduleName;
}

inline ::std::string& trConfigProblem::getModuleNameMutable () {
    set_has_moduleName();
    return _moduleName;
}

inline void trConfigProblem::setModuleName (const ::std::string& moduleName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (moduleName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_moduleName();
    this->_moduleName = moduleName_;
}

inline void trConfigProblem::setModuleName (const char* moduleName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (moduleName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_moduleName();
    this->_moduleName.assign(moduleName_);
}

inline void trConfigProblem::setModuleName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_moduleName();
    this->_moduleName.assign(value, size);
}

inline void trConfigProblem::clearEnErrorId() {
    if (hasEnErrorId()) {
         clear_has_enErrorId();
        _enErrorId = ::fcswupdatesrv::FcSwUpdateSrv::tenErrorId__SWL_OK;
     }
}

inline bool trConfigProblem::hasEnErrorId () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline tenErrorId trConfigProblem::getEnErrorId () const {
    return _enErrorId;
}

inline void trConfigProblem::setEnErrorId (tenErrorId enErrorId_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(tenErrorId_IsValid(enErrorId_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", enErrorId_, "tenErrorId", "enErrorId", "trConfigProblem");
    }
    set_has_enErrorId();
    this->_enErrorId = enErrorId_;
}

inline void trConfigProblem::set_has_moduleName () {
    _has_bits_[0] |= 1u << 0;
}

inline void trConfigProblem::clear_has_moduleName () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void trConfigProblem::set_has_enErrorId () {
    _has_bits_[0] |= 1u << 1;
}

inline void trConfigProblem::clear_has_enErrorId () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  trReleaseDoc::trReleaseDoc ()  :
    _name (),
    _enUpdateDirection (::fcswupdatesrv::FcSwUpdateSrv::tenUpdateDirection__Upgrade),
    _enSourceType (::fcswupdatesrv::FcSwUpdateSrv::tenSourceType__Usb),
    _u32EstimatedUpdateTimeSec (0u),
    _enUpdOptions (::fcswupdatesrv::FcSwUpdateSrv::tenUpdOptions__NewOnly),
    _bNeedsFlashing (false),
    _bIsDeltaUpdate (false),
    _devices (),
    _problems ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  trReleaseDoc::trReleaseDoc (const trReleaseDoc &rhs)  :
    _name (),
    _enUpdateDirection (::fcswupdatesrv::FcSwUpdateSrv::tenUpdateDirection__Upgrade),
    _enSourceType (::fcswupdatesrv::FcSwUpdateSrv::tenSourceType__Usb),
    _u32EstimatedUpdateTimeSec (0u),
    _enUpdOptions (::fcswupdatesrv::FcSwUpdateSrv::tenUpdOptions__NewOnly),
    _bNeedsFlashing (false),
    _bIsDeltaUpdate (false),
    _devices (),
    _problems ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  trReleaseDoc::trReleaseDoc (const ::std::string& name_, tenUpdateDirection enUpdateDirection_, tenSourceType enSourceType_, uint32 u32EstimatedUpdateTimeSec_, tenUpdOptions enUpdOptions_, bool bNeedsFlashing_, bool bIsDeltaUpdate_, const ::std::vector< trDeviceData >& devices_, const ::std::vector< trConfigProblem >& problems_)  :
    _name (name_),
    _enUpdateDirection (enUpdateDirection_),
    _enSourceType (enSourceType_),
    _u32EstimatedUpdateTimeSec (u32EstimatedUpdateTimeSec_),
    _enUpdOptions (enUpdOptions_),
    _bNeedsFlashing (bNeedsFlashing_),
    _bIsDeltaUpdate (bIsDeltaUpdate_),
    _devices (devices_),
    _problems (problems_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (name_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(tenUpdateDirection_IsValid(enUpdateDirection_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", enUpdateDirection_, "tenUpdateDirection", "enUpdateDirection", "trReleaseDoc");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(tenSourceType_IsValid(enSourceType_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", enSourceType_, "tenSourceType", "enSourceType", "trReleaseDoc");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(tenUpdOptions_IsValid(enUpdOptions_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", enUpdOptions_, "tenUpdOptions", "enUpdOptions", "trReleaseDoc");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  trReleaseDoc::~trReleaseDoc() {
}

inline trReleaseDoc& trReleaseDoc::operator = (const trReleaseDoc& rhs) {
    if( this != &rhs ) {
        if (rhs.hasName()) {
            setName(rhs.getName());
        } else {
            clearName();
        }
        if (rhs.hasEnUpdateDirection()) {
            setEnUpdateDirection(rhs.getEnUpdateDirection());
        } else {
            clearEnUpdateDirection();
        }
        if (rhs.hasEnSourceType()) {
            setEnSourceType(rhs.getEnSourceType());
        } else {
            clearEnSourceType();
        }
        if (rhs.hasU32EstimatedUpdateTimeSec()) {
            setU32EstimatedUpdateTimeSec(rhs.getU32EstimatedUpdateTimeSec());
        } else {
            clearU32EstimatedUpdateTimeSec();
        }
        if (rhs.hasEnUpdOptions()) {
            setEnUpdOptions(rhs.getEnUpdOptions());
        } else {
            clearEnUpdOptions();
        }
        if (rhs.hasBNeedsFlashing()) {
            setBNeedsFlashing(rhs.getBNeedsFlashing());
        } else {
            clearBNeedsFlashing();
        }
        if (rhs.hasBIsDeltaUpdate()) {
            setBIsDeltaUpdate(rhs.getBIsDeltaUpdate());
        } else {
            clearBIsDeltaUpdate();
        }
        if (rhs.hasDevices()) {
            setDevices(rhs.getDevices());
        } else {
            clearDevices();
        }
        if (rhs.hasProblems()) {
            setProblems(rhs.getProblems());
        } else {
            clearProblems();
        }
    }
    return *this;
}

inline bool trReleaseDoc::operator == (const trReleaseDoc& rhs) const {
    return (((!hasName() && !rhs.hasName()) || getName() == rhs.getName()) &&
        ((!hasEnUpdateDirection() && !rhs.hasEnUpdateDirection()) || getEnUpdateDirection() == rhs.getEnUpdateDirection()) &&
        ((!hasEnSourceType() && !rhs.hasEnSourceType()) || getEnSourceType() == rhs.getEnSourceType()) &&
        ((!hasU32EstimatedUpdateTimeSec() && !rhs.hasU32EstimatedUpdateTimeSec()) || getU32EstimatedUpdateTimeSec() == rhs.getU32EstimatedUpdateTimeSec()) &&
        ((!hasEnUpdOptions() && !rhs.hasEnUpdOptions()) || getEnUpdOptions() == rhs.getEnUpdOptions()) &&
        ((!hasBNeedsFlashing() && !rhs.hasBNeedsFlashing()) || getBNeedsFlashing() == rhs.getBNeedsFlashing()) &&
        ((!hasBIsDeltaUpdate() && !rhs.hasBIsDeltaUpdate()) || getBIsDeltaUpdate() == rhs.getBIsDeltaUpdate()) &&
        ((!hasDevices() && !rhs.hasDevices()) || getDevices() == rhs.getDevices()) &&
        ((!hasProblems() && !rhs.hasProblems()) || getProblems() == rhs.getProblems()));
}

inline bool trReleaseDoc::operator != (const trReleaseDoc& rhs) const {
    return ! (*this == rhs);
}

inline bool trReleaseDoc::operator < (const trReleaseDoc& rhs) const {
    if (hasName() || rhs.hasName()) {
        if (getName() < rhs.getName()) return true;
        if (getName() > rhs.getName()) return false;
    }
    if (hasEnUpdateDirection() || rhs.hasEnUpdateDirection()) {
        if ((uint32)getEnUpdateDirection() < (uint32)rhs.getEnUpdateDirection()) return true;
        if ((uint32)getEnUpdateDirection() > (uint32)rhs.getEnUpdateDirection()) return false;
    }
    if (hasEnSourceType() || rhs.hasEnSourceType()) {
        if ((uint32)getEnSourceType() < (uint32)rhs.getEnSourceType()) return true;
        if ((uint32)getEnSourceType() > (uint32)rhs.getEnSourceType()) return false;
    }
    if (hasU32EstimatedUpdateTimeSec() || rhs.hasU32EstimatedUpdateTimeSec()) {
        if (getU32EstimatedUpdateTimeSec() < rhs.getU32EstimatedUpdateTimeSec()) return true;
        if (getU32EstimatedUpdateTimeSec() > rhs.getU32EstimatedUpdateTimeSec()) return false;
    }
    if (hasEnUpdOptions() || rhs.hasEnUpdOptions()) {
        if ((uint32)getEnUpdOptions() < (uint32)rhs.getEnUpdOptions()) return true;
        if ((uint32)getEnUpdOptions() > (uint32)rhs.getEnUpdOptions()) return false;
    }
    if (hasBNeedsFlashing() || rhs.hasBNeedsFlashing()) {
        if (getBNeedsFlashing() < rhs.getBNeedsFlashing()) return true;
        if (getBNeedsFlashing() > rhs.getBNeedsFlashing()) return false;
    }
    if (hasBIsDeltaUpdate() || rhs.hasBIsDeltaUpdate()) {
        if (getBIsDeltaUpdate() < rhs.getBIsDeltaUpdate()) return true;
        if (getBIsDeltaUpdate() > rhs.getBIsDeltaUpdate()) return false;
    }
    if (hasDevices() || rhs.hasDevices()) {
        if (getDevices() < rhs.getDevices()) return true;
        if (getDevices() > rhs.getDevices()) return false;
    }
    if (hasProblems() || rhs.hasProblems()) {
        if (getProblems() < rhs.getProblems()) return true;
        if (getProblems() > rhs.getProblems()) return false;
    }
    return false;
}

inline bool trReleaseDoc::operator > (const trReleaseDoc& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void trReleaseDoc::clear() {
    clearName();
    clearEnUpdateDirection();
    clearEnSourceType();
    clearU32EstimatedUpdateTimeSec();
    clearEnUpdOptions();
    clearBNeedsFlashing();
    clearBIsDeltaUpdate();
    clearDevices();
    clearProblems();
}

inline void trReleaseDoc::clearName() {
    if (hasName()) {
         clear_has_name();
        _name.clear();
     }
}

inline bool trReleaseDoc::hasName () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& trReleaseDoc::getName () const {
    return _name;
}

inline ::std::string& trReleaseDoc::getNameMutable () {
    set_has_name();
    return _name;
}

inline void trReleaseDoc::setName (const ::std::string& name_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (name_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_name();
    this->_name = name_;
}

inline void trReleaseDoc::setName (const char* name_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (name_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_name();
    this->_name.assign(name_);
}

inline void trReleaseDoc::setName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_name();
    this->_name.assign(value, size);
}

inline void trReleaseDoc::clearEnUpdateDirection() {
    if (hasEnUpdateDirection()) {
         clear_has_enUpdateDirection();
        _enUpdateDirection = ::fcswupdatesrv::FcSwUpdateSrv::tenUpdateDirection__Upgrade;
     }
}

inline bool trReleaseDoc::hasEnUpdateDirection () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline tenUpdateDirection trReleaseDoc::getEnUpdateDirection () const {
    return _enUpdateDirection;
}

inline void trReleaseDoc::setEnUpdateDirection (tenUpdateDirection enUpdateDirection_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(tenUpdateDirection_IsValid(enUpdateDirection_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", enUpdateDirection_, "tenUpdateDirection", "enUpdateDirection", "trReleaseDoc");
    }
    set_has_enUpdateDirection();
    this->_enUpdateDirection = enUpdateDirection_;
}

inline void trReleaseDoc::clearEnSourceType() {
    if (hasEnSourceType()) {
         clear_has_enSourceType();
        _enSourceType = ::fcswupdatesrv::FcSwUpdateSrv::tenSourceType__Usb;
     }
}

inline bool trReleaseDoc::hasEnSourceType () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline tenSourceType trReleaseDoc::getEnSourceType () const {
    return _enSourceType;
}

inline void trReleaseDoc::setEnSourceType (tenSourceType enSourceType_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(tenSourceType_IsValid(enSourceType_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", enSourceType_, "tenSourceType", "enSourceType", "trReleaseDoc");
    }
    set_has_enSourceType();
    this->_enSourceType = enSourceType_;
}

inline void trReleaseDoc::clearU32EstimatedUpdateTimeSec() {
    if (hasU32EstimatedUpdateTimeSec()) {
         clear_has_u32EstimatedUpdateTimeSec();
        _u32EstimatedUpdateTimeSec = 0u;
     }
}

inline bool trReleaseDoc::hasU32EstimatedUpdateTimeSec () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint32 trReleaseDoc::getU32EstimatedUpdateTimeSec () const {
    return _u32EstimatedUpdateTimeSec;
}

inline void trReleaseDoc::setU32EstimatedUpdateTimeSec (uint32 u32EstimatedUpdateTimeSec_) {
    set_has_u32EstimatedUpdateTimeSec();
    this->_u32EstimatedUpdateTimeSec = u32EstimatedUpdateTimeSec_;
}

inline void trReleaseDoc::clearEnUpdOptions() {
    if (hasEnUpdOptions()) {
         clear_has_enUpdOptions();
        _enUpdOptions = ::fcswupdatesrv::FcSwUpdateSrv::tenUpdOptions__NewOnly;
     }
}

inline bool trReleaseDoc::hasEnUpdOptions () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline tenUpdOptions trReleaseDoc::getEnUpdOptions () const {
    return _enUpdOptions;
}

inline void trReleaseDoc::setEnUpdOptions (tenUpdOptions enUpdOptions_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(tenUpdOptions_IsValid(enUpdOptions_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", enUpdOptions_, "tenUpdOptions", "enUpdOptions", "trReleaseDoc");
    }
    set_has_enUpdOptions();
    this->_enUpdOptions = enUpdOptions_;
}

inline void trReleaseDoc::clearBNeedsFlashing() {
    if (hasBNeedsFlashing()) {
         clear_has_bNeedsFlashing();
        _bNeedsFlashing = false;
     }
}

inline bool trReleaseDoc::hasBNeedsFlashing () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline bool trReleaseDoc::getBNeedsFlashing () const {
    return _bNeedsFlashing;
}

inline void trReleaseDoc::setBNeedsFlashing (bool bNeedsFlashing_) {
    set_has_bNeedsFlashing();
    this->_bNeedsFlashing = bNeedsFlashing_;
}

inline void trReleaseDoc::clearBIsDeltaUpdate() {
    if (hasBIsDeltaUpdate()) {
         clear_has_bIsDeltaUpdate();
        _bIsDeltaUpdate = false;
     }
}

inline bool trReleaseDoc::hasBIsDeltaUpdate () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline bool trReleaseDoc::getBIsDeltaUpdate () const {
    return _bIsDeltaUpdate;
}

inline void trReleaseDoc::setBIsDeltaUpdate (bool bIsDeltaUpdate_) {
    set_has_bIsDeltaUpdate();
    this->_bIsDeltaUpdate = bIsDeltaUpdate_;
}

inline void trReleaseDoc::clearDevices() {
    if (hasDevices()) {
         clear_has_devices();
        _devices.clear();
     }
}

inline bool trReleaseDoc::hasDevices () const {
    return (_has_bits_[0] & (1u << 7)) > 0;
}

inline const ::std::vector< trDeviceData >& trReleaseDoc::getDevices () const {
    return _devices;
}

inline ::std::vector< trDeviceData >& trReleaseDoc::getDevicesMutable () {
    set_has_devices();
    return _devices;
}

inline void trReleaseDoc::setDevices (const ::std::vector< trDeviceData >& devices_) {
    set_has_devices();
    this->_devices = devices_;
}

inline void trReleaseDoc::clearProblems() {
    if (hasProblems()) {
         clear_has_problems();
        _problems.clear();
     }
}

inline bool trReleaseDoc::hasProblems () const {
    return (_has_bits_[0] & (1u << 8)) > 0;
}

inline const ::std::vector< trConfigProblem >& trReleaseDoc::getProblems () const {
    return _problems;
}

inline ::std::vector< trConfigProblem >& trReleaseDoc::getProblemsMutable () {
    set_has_problems();
    return _problems;
}

inline void trReleaseDoc::setProblems (const ::std::vector< trConfigProblem >& problems_) {
    set_has_problems();
    this->_problems = problems_;
}

inline void trReleaseDoc::set_has_name () {
    _has_bits_[0] |= 1u << 0;
}

inline void trReleaseDoc::clear_has_name () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void trReleaseDoc::set_has_enUpdateDirection () {
    _has_bits_[0] |= 1u << 1;
}

inline void trReleaseDoc::clear_has_enUpdateDirection () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void trReleaseDoc::set_has_enSourceType () {
    _has_bits_[0] |= 1u << 2;
}

inline void trReleaseDoc::clear_has_enSourceType () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void trReleaseDoc::set_has_u32EstimatedUpdateTimeSec () {
    _has_bits_[0] |= 1u << 3;
}

inline void trReleaseDoc::clear_has_u32EstimatedUpdateTimeSec () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void trReleaseDoc::set_has_enUpdOptions () {
    _has_bits_[0] |= 1u << 4;
}

inline void trReleaseDoc::clear_has_enUpdOptions () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void trReleaseDoc::set_has_bNeedsFlashing () {
    _has_bits_[0] |= 1u << 5;
}

inline void trReleaseDoc::clear_has_bNeedsFlashing () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void trReleaseDoc::set_has_bIsDeltaUpdate () {
    _has_bits_[0] |= 1u << 6;
}

inline void trReleaseDoc::clear_has_bIsDeltaUpdate () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline void trReleaseDoc::set_has_devices () {
    _has_bits_[0] |= 1u << 7;
}

inline void trReleaseDoc::clear_has_devices () {
    _has_bits_[0] &= ~ (1u << 7);
}

inline void trReleaseDoc::set_has_problems () {
    _has_bits_[0] |= 1u << 8;
}

inline void trReleaseDoc::clear_has_problems () {
    _has_bits_[0] &= ~ (1u << 8);
}

inline  trPreReleaseDoc::trPreReleaseDoc ()  :
    _bFoundRelease (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  trPreReleaseDoc::trPreReleaseDoc (const trPreReleaseDoc &rhs)  :
    _bFoundRelease (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  trPreReleaseDoc::trPreReleaseDoc (bool bFoundRelease_)  :
    _bFoundRelease (bFoundRelease_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  trPreReleaseDoc::~trPreReleaseDoc() {
}

inline trPreReleaseDoc& trPreReleaseDoc::operator = (const trPreReleaseDoc& rhs) {
    if( this != &rhs ) {
        if (rhs.hasBFoundRelease()) {
            setBFoundRelease(rhs.getBFoundRelease());
        } else {
            clearBFoundRelease();
        }
    }
    return *this;
}

inline bool trPreReleaseDoc::operator == (const trPreReleaseDoc& rhs) const {
    return (((!hasBFoundRelease() && !rhs.hasBFoundRelease()) || getBFoundRelease() == rhs.getBFoundRelease()));
}

inline bool trPreReleaseDoc::operator != (const trPreReleaseDoc& rhs) const {
    return ! (*this == rhs);
}

inline bool trPreReleaseDoc::operator < (const trPreReleaseDoc& rhs) const {
    if (hasBFoundRelease() || rhs.hasBFoundRelease()) {
        if (getBFoundRelease() < rhs.getBFoundRelease()) return true;
        if (getBFoundRelease() > rhs.getBFoundRelease()) return false;
    }
    return false;
}

inline bool trPreReleaseDoc::operator > (const trPreReleaseDoc& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void trPreReleaseDoc::clear() {
    clearBFoundRelease();
}

inline void trPreReleaseDoc::clearBFoundRelease() {
    if (hasBFoundRelease()) {
         clear_has_bFoundRelease();
        _bFoundRelease = false;
     }
}

inline bool trPreReleaseDoc::hasBFoundRelease () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool trPreReleaseDoc::getBFoundRelease () const {
    return _bFoundRelease;
}

inline void trPreReleaseDoc::setBFoundRelease (bool bFoundRelease_) {
    set_has_bFoundRelease();
    this->_bFoundRelease = bFoundRelease_;
}

inline void trPreReleaseDoc::set_has_bFoundRelease () {
    _has_bits_[0] |= 1u << 0;
}

inline void trPreReleaseDoc::clear_has_bFoundRelease () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  trModifyAction::trModifyAction ()  :
    _u32DeviceIndex (0u),
    _u32ModuleIndex (0u),
    _u32SubModuleIndex (0u),
    _enUpdAction (::fcswupdatesrv::FcSwUpdateSrv::tenModifyAction__Activate)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  trModifyAction::trModifyAction (const trModifyAction &rhs)  :
    _u32DeviceIndex (0u),
    _u32ModuleIndex (0u),
    _u32SubModuleIndex (0u),
    _enUpdAction (::fcswupdatesrv::FcSwUpdateSrv::tenModifyAction__Activate)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  trModifyAction::trModifyAction (uint32 u32DeviceIndex_, uint32 u32ModuleIndex_, uint32 u32SubModuleIndex_, tenModifyAction enUpdAction_)  :
    _u32DeviceIndex (u32DeviceIndex_),
    _u32ModuleIndex (u32ModuleIndex_),
    _u32SubModuleIndex (u32SubModuleIndex_),
    _enUpdAction (enUpdAction_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(tenModifyAction_IsValid(enUpdAction_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", enUpdAction_, "tenModifyAction", "enUpdAction", "trModifyAction");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  trModifyAction::~trModifyAction() {
}

inline trModifyAction& trModifyAction::operator = (const trModifyAction& rhs) {
    if( this != &rhs ) {
        if (rhs.hasU32DeviceIndex()) {
            setU32DeviceIndex(rhs.getU32DeviceIndex());
        } else {
            clearU32DeviceIndex();
        }
        if (rhs.hasU32ModuleIndex()) {
            setU32ModuleIndex(rhs.getU32ModuleIndex());
        } else {
            clearU32ModuleIndex();
        }
        if (rhs.hasU32SubModuleIndex()) {
            setU32SubModuleIndex(rhs.getU32SubModuleIndex());
        } else {
            clearU32SubModuleIndex();
        }
        if (rhs.hasEnUpdAction()) {
            setEnUpdAction(rhs.getEnUpdAction());
        } else {
            clearEnUpdAction();
        }
    }
    return *this;
}

inline bool trModifyAction::operator == (const trModifyAction& rhs) const {
    return (((!hasU32DeviceIndex() && !rhs.hasU32DeviceIndex()) || getU32DeviceIndex() == rhs.getU32DeviceIndex()) &&
        ((!hasU32ModuleIndex() && !rhs.hasU32ModuleIndex()) || getU32ModuleIndex() == rhs.getU32ModuleIndex()) &&
        ((!hasU32SubModuleIndex() && !rhs.hasU32SubModuleIndex()) || getU32SubModuleIndex() == rhs.getU32SubModuleIndex()) &&
        ((!hasEnUpdAction() && !rhs.hasEnUpdAction()) || getEnUpdAction() == rhs.getEnUpdAction()));
}

inline bool trModifyAction::operator != (const trModifyAction& rhs) const {
    return ! (*this == rhs);
}

inline bool trModifyAction::operator < (const trModifyAction& rhs) const {
    if (hasU32DeviceIndex() || rhs.hasU32DeviceIndex()) {
        if (getU32DeviceIndex() < rhs.getU32DeviceIndex()) return true;
        if (getU32DeviceIndex() > rhs.getU32DeviceIndex()) return false;
    }
    if (hasU32ModuleIndex() || rhs.hasU32ModuleIndex()) {
        if (getU32ModuleIndex() < rhs.getU32ModuleIndex()) return true;
        if (getU32ModuleIndex() > rhs.getU32ModuleIndex()) return false;
    }
    if (hasU32SubModuleIndex() || rhs.hasU32SubModuleIndex()) {
        if (getU32SubModuleIndex() < rhs.getU32SubModuleIndex()) return true;
        if (getU32SubModuleIndex() > rhs.getU32SubModuleIndex()) return false;
    }
    if (hasEnUpdAction() || rhs.hasEnUpdAction()) {
        if ((uint32)getEnUpdAction() < (uint32)rhs.getEnUpdAction()) return true;
        if ((uint32)getEnUpdAction() > (uint32)rhs.getEnUpdAction()) return false;
    }
    return false;
}

inline bool trModifyAction::operator > (const trModifyAction& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void trModifyAction::clear() {
    clearU32DeviceIndex();
    clearU32ModuleIndex();
    clearU32SubModuleIndex();
    clearEnUpdAction();
}

inline void trModifyAction::clearU32DeviceIndex() {
    if (hasU32DeviceIndex()) {
         clear_has_u32DeviceIndex();
        _u32DeviceIndex = 0u;
     }
}

inline bool trModifyAction::hasU32DeviceIndex () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 trModifyAction::getU32DeviceIndex () const {
    return _u32DeviceIndex;
}

inline void trModifyAction::setU32DeviceIndex (uint32 u32DeviceIndex_) {
    set_has_u32DeviceIndex();
    this->_u32DeviceIndex = u32DeviceIndex_;
}

inline void trModifyAction::clearU32ModuleIndex() {
    if (hasU32ModuleIndex()) {
         clear_has_u32ModuleIndex();
        _u32ModuleIndex = 0u;
     }
}

inline bool trModifyAction::hasU32ModuleIndex () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 trModifyAction::getU32ModuleIndex () const {
    return _u32ModuleIndex;
}

inline void trModifyAction::setU32ModuleIndex (uint32 u32ModuleIndex_) {
    set_has_u32ModuleIndex();
    this->_u32ModuleIndex = u32ModuleIndex_;
}

inline void trModifyAction::clearU32SubModuleIndex() {
    if (hasU32SubModuleIndex()) {
         clear_has_u32SubModuleIndex();
        _u32SubModuleIndex = 0u;
     }
}

inline bool trModifyAction::hasU32SubModuleIndex () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint32 trModifyAction::getU32SubModuleIndex () const {
    return _u32SubModuleIndex;
}

inline void trModifyAction::setU32SubModuleIndex (uint32 u32SubModuleIndex_) {
    set_has_u32SubModuleIndex();
    this->_u32SubModuleIndex = u32SubModuleIndex_;
}

inline void trModifyAction::clearEnUpdAction() {
    if (hasEnUpdAction()) {
         clear_has_enUpdAction();
        _enUpdAction = ::fcswupdatesrv::FcSwUpdateSrv::tenModifyAction__Activate;
     }
}

inline bool trModifyAction::hasEnUpdAction () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline tenModifyAction trModifyAction::getEnUpdAction () const {
    return _enUpdAction;
}

inline void trModifyAction::setEnUpdAction (tenModifyAction enUpdAction_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(tenModifyAction_IsValid(enUpdAction_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", enUpdAction_, "tenModifyAction", "enUpdAction", "trModifyAction");
    }
    set_has_enUpdAction();
    this->_enUpdAction = enUpdAction_;
}

inline void trModifyAction::set_has_u32DeviceIndex () {
    _has_bits_[0] |= 1u << 0;
}

inline void trModifyAction::clear_has_u32DeviceIndex () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void trModifyAction::set_has_u32ModuleIndex () {
    _has_bits_[0] |= 1u << 1;
}

inline void trModifyAction::clear_has_u32ModuleIndex () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void trModifyAction::set_has_u32SubModuleIndex () {
    _has_bits_[0] |= 1u << 2;
}

inline void trModifyAction::clear_has_u32SubModuleIndex () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void trModifyAction::set_has_enUpdAction () {
    _has_bits_[0] |= 1u << 3;
}

inline void trModifyAction::clear_has_enUpdAction () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  trUpdProgress::trUpdProgress ()  :
    _train (),
    _deviceName (),
    _moduleName (),
    _subModuleName (),
    _refKey (),
    _source (),
    _line1 (),
    _line2 (),
    _luaCmd (),
    _u32Retries (0u),
    _u32NumAll (0u),
    _u32NumComplete (0u),
    _u32NumRunning (0u),
    _u32NumNotApplicable (0u),
    _u32NumFailed (0u),
    _u32NumRemaining (0u),
    _u8SubModulePercentComplete (0u),
    _u8ReleasePercentComplete (0u),
    _u8ReleasePercentCompleteForPhase (0u),
    _u32EstimatedUpdateTimeSec (0u),
    _u32EstimatedUpdateTimeSecForPhase (0u),
    _u32EstimatedCurrentModuleUpdateTimeSec (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  trUpdProgress::trUpdProgress (const trUpdProgress &rhs)  :
    _train (),
    _deviceName (),
    _moduleName (),
    _subModuleName (),
    _refKey (),
    _source (),
    _line1 (),
    _line2 (),
    _luaCmd (),
    _u32Retries (0u),
    _u32NumAll (0u),
    _u32NumComplete (0u),
    _u32NumRunning (0u),
    _u32NumNotApplicable (0u),
    _u32NumFailed (0u),
    _u32NumRemaining (0u),
    _u8SubModulePercentComplete (0u),
    _u8ReleasePercentComplete (0u),
    _u8ReleasePercentCompleteForPhase (0u),
    _u32EstimatedUpdateTimeSec (0u),
    _u32EstimatedUpdateTimeSecForPhase (0u),
    _u32EstimatedCurrentModuleUpdateTimeSec (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  trUpdProgress::trUpdProgress (const ::std::string& train_, const ::std::string& deviceName_, const ::std::string& moduleName_, const ::std::string& subModuleName_, const ::std::string& refKey_, const ::std::string& source_, const ::std::string& line1_, const ::std::string& line2_, const ::std::string& luaCmd_, uint32 u32Retries_, uint32 u32NumAll_, uint32 u32NumComplete_, uint32 u32NumRunning_, uint32 u32NumNotApplicable_, uint32 u32NumFailed_, uint32 u32NumRemaining_, uint8 u8SubModulePercentComplete_, uint8 u8ReleasePercentComplete_, uint8 u8ReleasePercentCompleteForPhase_, uint32 u32EstimatedUpdateTimeSec_, uint32 u32EstimatedUpdateTimeSecForPhase_, uint32 u32EstimatedCurrentModuleUpdateTimeSec_)  :
    _train (train_),
    _deviceName (deviceName_),
    _moduleName (moduleName_),
    _subModuleName (subModuleName_),
    _refKey (refKey_),
    _source (source_),
    _line1 (line1_),
    _line2 (line2_),
    _luaCmd (luaCmd_),
    _u32Retries (u32Retries_),
    _u32NumAll (u32NumAll_),
    _u32NumComplete (u32NumComplete_),
    _u32NumRunning (u32NumRunning_),
    _u32NumNotApplicable (u32NumNotApplicable_),
    _u32NumFailed (u32NumFailed_),
    _u32NumRemaining (u32NumRemaining_),
    _u8SubModulePercentComplete (u8SubModulePercentComplete_),
    _u8ReleasePercentComplete (u8ReleasePercentComplete_),
    _u8ReleasePercentCompleteForPhase (u8ReleasePercentCompleteForPhase_),
    _u32EstimatedUpdateTimeSec (u32EstimatedUpdateTimeSec_),
    _u32EstimatedUpdateTimeSecForPhase (u32EstimatedUpdateTimeSecForPhase_),
    _u32EstimatedCurrentModuleUpdateTimeSec (u32EstimatedCurrentModuleUpdateTimeSec_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (train_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (deviceName_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (moduleName_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (subModuleName_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (refKey_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (source_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (line1_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (line2_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (luaCmd_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  trUpdProgress::~trUpdProgress() {
}

inline trUpdProgress& trUpdProgress::operator = (const trUpdProgress& rhs) {
    if( this != &rhs ) {
        if (rhs.hasTrain()) {
            setTrain(rhs.getTrain());
        } else {
            clearTrain();
        }
        if (rhs.hasDeviceName()) {
            setDeviceName(rhs.getDeviceName());
        } else {
            clearDeviceName();
        }
        if (rhs.hasModuleName()) {
            setModuleName(rhs.getModuleName());
        } else {
            clearModuleName();
        }
        if (rhs.hasSubModuleName()) {
            setSubModuleName(rhs.getSubModuleName());
        } else {
            clearSubModuleName();
        }
        if (rhs.hasRefKey()) {
            setRefKey(rhs.getRefKey());
        } else {
            clearRefKey();
        }
        if (rhs.hasSource()) {
            setSource(rhs.getSource());
        } else {
            clearSource();
        }
        if (rhs.hasLine1()) {
            setLine1(rhs.getLine1());
        } else {
            clearLine1();
        }
        if (rhs.hasLine2()) {
            setLine2(rhs.getLine2());
        } else {
            clearLine2();
        }
        if (rhs.hasLuaCmd()) {
            setLuaCmd(rhs.getLuaCmd());
        } else {
            clearLuaCmd();
        }
        if (rhs.hasU32Retries()) {
            setU32Retries(rhs.getU32Retries());
        } else {
            clearU32Retries();
        }
        if (rhs.hasU32NumAll()) {
            setU32NumAll(rhs.getU32NumAll());
        } else {
            clearU32NumAll();
        }
        if (rhs.hasU32NumComplete()) {
            setU32NumComplete(rhs.getU32NumComplete());
        } else {
            clearU32NumComplete();
        }
        if (rhs.hasU32NumRunning()) {
            setU32NumRunning(rhs.getU32NumRunning());
        } else {
            clearU32NumRunning();
        }
        if (rhs.hasU32NumNotApplicable()) {
            setU32NumNotApplicable(rhs.getU32NumNotApplicable());
        } else {
            clearU32NumNotApplicable();
        }
        if (rhs.hasU32NumFailed()) {
            setU32NumFailed(rhs.getU32NumFailed());
        } else {
            clearU32NumFailed();
        }
        if (rhs.hasU32NumRemaining()) {
            setU32NumRemaining(rhs.getU32NumRemaining());
        } else {
            clearU32NumRemaining();
        }
        if (rhs.hasU8SubModulePercentComplete()) {
            setU8SubModulePercentComplete(rhs.getU8SubModulePercentComplete());
        } else {
            clearU8SubModulePercentComplete();
        }
        if (rhs.hasU8ReleasePercentComplete()) {
            setU8ReleasePercentComplete(rhs.getU8ReleasePercentComplete());
        } else {
            clearU8ReleasePercentComplete();
        }
        if (rhs.hasU8ReleasePercentCompleteForPhase()) {
            setU8ReleasePercentCompleteForPhase(rhs.getU8ReleasePercentCompleteForPhase());
        } else {
            clearU8ReleasePercentCompleteForPhase();
        }
        if (rhs.hasU32EstimatedUpdateTimeSec()) {
            setU32EstimatedUpdateTimeSec(rhs.getU32EstimatedUpdateTimeSec());
        } else {
            clearU32EstimatedUpdateTimeSec();
        }
        if (rhs.hasU32EstimatedUpdateTimeSecForPhase()) {
            setU32EstimatedUpdateTimeSecForPhase(rhs.getU32EstimatedUpdateTimeSecForPhase());
        } else {
            clearU32EstimatedUpdateTimeSecForPhase();
        }
        if (rhs.hasU32EstimatedCurrentModuleUpdateTimeSec()) {
            setU32EstimatedCurrentModuleUpdateTimeSec(rhs.getU32EstimatedCurrentModuleUpdateTimeSec());
        } else {
            clearU32EstimatedCurrentModuleUpdateTimeSec();
        }
    }
    return *this;
}

inline bool trUpdProgress::operator == (const trUpdProgress& rhs) const {
    return (((!hasTrain() && !rhs.hasTrain()) || getTrain() == rhs.getTrain()) &&
        ((!hasDeviceName() && !rhs.hasDeviceName()) || getDeviceName() == rhs.getDeviceName()) &&
        ((!hasModuleName() && !rhs.hasModuleName()) || getModuleName() == rhs.getModuleName()) &&
        ((!hasSubModuleName() && !rhs.hasSubModuleName()) || getSubModuleName() == rhs.getSubModuleName()) &&
        ((!hasRefKey() && !rhs.hasRefKey()) || getRefKey() == rhs.getRefKey()) &&
        ((!hasSource() && !rhs.hasSource()) || getSource() == rhs.getSource()) &&
        ((!hasLine1() && !rhs.hasLine1()) || getLine1() == rhs.getLine1()) &&
        ((!hasLine2() && !rhs.hasLine2()) || getLine2() == rhs.getLine2()) &&
        ((!hasLuaCmd() && !rhs.hasLuaCmd()) || getLuaCmd() == rhs.getLuaCmd()) &&
        ((!hasU32Retries() && !rhs.hasU32Retries()) || getU32Retries() == rhs.getU32Retries()) &&
        ((!hasU32NumAll() && !rhs.hasU32NumAll()) || getU32NumAll() == rhs.getU32NumAll()) &&
        ((!hasU32NumComplete() && !rhs.hasU32NumComplete()) || getU32NumComplete() == rhs.getU32NumComplete()) &&
        ((!hasU32NumRunning() && !rhs.hasU32NumRunning()) || getU32NumRunning() == rhs.getU32NumRunning()) &&
        ((!hasU32NumNotApplicable() && !rhs.hasU32NumNotApplicable()) || getU32NumNotApplicable() == rhs.getU32NumNotApplicable()) &&
        ((!hasU32NumFailed() && !rhs.hasU32NumFailed()) || getU32NumFailed() == rhs.getU32NumFailed()) &&
        ((!hasU32NumRemaining() && !rhs.hasU32NumRemaining()) || getU32NumRemaining() == rhs.getU32NumRemaining()) &&
        ((!hasU8SubModulePercentComplete() && !rhs.hasU8SubModulePercentComplete()) || getU8SubModulePercentComplete() == rhs.getU8SubModulePercentComplete()) &&
        ((!hasU8ReleasePercentComplete() && !rhs.hasU8ReleasePercentComplete()) || getU8ReleasePercentComplete() == rhs.getU8ReleasePercentComplete()) &&
        ((!hasU8ReleasePercentCompleteForPhase() && !rhs.hasU8ReleasePercentCompleteForPhase()) || getU8ReleasePercentCompleteForPhase() == rhs.getU8ReleasePercentCompleteForPhase()) &&
        ((!hasU32EstimatedUpdateTimeSec() && !rhs.hasU32EstimatedUpdateTimeSec()) || getU32EstimatedUpdateTimeSec() == rhs.getU32EstimatedUpdateTimeSec()) &&
        ((!hasU32EstimatedUpdateTimeSecForPhase() && !rhs.hasU32EstimatedUpdateTimeSecForPhase()) || getU32EstimatedUpdateTimeSecForPhase() == rhs.getU32EstimatedUpdateTimeSecForPhase()) &&
        ((!hasU32EstimatedCurrentModuleUpdateTimeSec() && !rhs.hasU32EstimatedCurrentModuleUpdateTimeSec()) || getU32EstimatedCurrentModuleUpdateTimeSec() == rhs.getU32EstimatedCurrentModuleUpdateTimeSec()));
}

inline bool trUpdProgress::operator != (const trUpdProgress& rhs) const {
    return ! (*this == rhs);
}

inline bool trUpdProgress::operator < (const trUpdProgress& rhs) const {
    if (hasTrain() || rhs.hasTrain()) {
        if (getTrain() < rhs.getTrain()) return true;
        if (getTrain() > rhs.getTrain()) return false;
    }
    if (hasDeviceName() || rhs.hasDeviceName()) {
        if (getDeviceName() < rhs.getDeviceName()) return true;
        if (getDeviceName() > rhs.getDeviceName()) return false;
    }
    if (hasModuleName() || rhs.hasModuleName()) {
        if (getModuleName() < rhs.getModuleName()) return true;
        if (getModuleName() > rhs.getModuleName()) return false;
    }
    if (hasSubModuleName() || rhs.hasSubModuleName()) {
        if (getSubModuleName() < rhs.getSubModuleName()) return true;
        if (getSubModuleName() > rhs.getSubModuleName()) return false;
    }
    if (hasRefKey() || rhs.hasRefKey()) {
        if (getRefKey() < rhs.getRefKey()) return true;
        if (getRefKey() > rhs.getRefKey()) return false;
    }
    if (hasSource() || rhs.hasSource()) {
        if (getSource() < rhs.getSource()) return true;
        if (getSource() > rhs.getSource()) return false;
    }
    if (hasLine1() || rhs.hasLine1()) {
        if (getLine1() < rhs.getLine1()) return true;
        if (getLine1() > rhs.getLine1()) return false;
    }
    if (hasLine2() || rhs.hasLine2()) {
        if (getLine2() < rhs.getLine2()) return true;
        if (getLine2() > rhs.getLine2()) return false;
    }
    if (hasLuaCmd() || rhs.hasLuaCmd()) {
        if (getLuaCmd() < rhs.getLuaCmd()) return true;
        if (getLuaCmd() > rhs.getLuaCmd()) return false;
    }
    if (hasU32Retries() || rhs.hasU32Retries()) {
        if (getU32Retries() < rhs.getU32Retries()) return true;
        if (getU32Retries() > rhs.getU32Retries()) return false;
    }
    if (hasU32NumAll() || rhs.hasU32NumAll()) {
        if (getU32NumAll() < rhs.getU32NumAll()) return true;
        if (getU32NumAll() > rhs.getU32NumAll()) return false;
    }
    if (hasU32NumComplete() || rhs.hasU32NumComplete()) {
        if (getU32NumComplete() < rhs.getU32NumComplete()) return true;
        if (getU32NumComplete() > rhs.getU32NumComplete()) return false;
    }
    if (hasU32NumRunning() || rhs.hasU32NumRunning()) {
        if (getU32NumRunning() < rhs.getU32NumRunning()) return true;
        if (getU32NumRunning() > rhs.getU32NumRunning()) return false;
    }
    if (hasU32NumNotApplicable() || rhs.hasU32NumNotApplicable()) {
        if (getU32NumNotApplicable() < rhs.getU32NumNotApplicable()) return true;
        if (getU32NumNotApplicable() > rhs.getU32NumNotApplicable()) return false;
    }
    if (hasU32NumFailed() || rhs.hasU32NumFailed()) {
        if (getU32NumFailed() < rhs.getU32NumFailed()) return true;
        if (getU32NumFailed() > rhs.getU32NumFailed()) return false;
    }
    if (hasU32NumRemaining() || rhs.hasU32NumRemaining()) {
        if (getU32NumRemaining() < rhs.getU32NumRemaining()) return true;
        if (getU32NumRemaining() > rhs.getU32NumRemaining()) return false;
    }
    if (hasU8SubModulePercentComplete() || rhs.hasU8SubModulePercentComplete()) {
        if (getU8SubModulePercentComplete() < rhs.getU8SubModulePercentComplete()) return true;
        if (getU8SubModulePercentComplete() > rhs.getU8SubModulePercentComplete()) return false;
    }
    if (hasU8ReleasePercentComplete() || rhs.hasU8ReleasePercentComplete()) {
        if (getU8ReleasePercentComplete() < rhs.getU8ReleasePercentComplete()) return true;
        if (getU8ReleasePercentComplete() > rhs.getU8ReleasePercentComplete()) return false;
    }
    if (hasU8ReleasePercentCompleteForPhase() || rhs.hasU8ReleasePercentCompleteForPhase()) {
        if (getU8ReleasePercentCompleteForPhase() < rhs.getU8ReleasePercentCompleteForPhase()) return true;
        if (getU8ReleasePercentCompleteForPhase() > rhs.getU8ReleasePercentCompleteForPhase()) return false;
    }
    if (hasU32EstimatedUpdateTimeSec() || rhs.hasU32EstimatedUpdateTimeSec()) {
        if (getU32EstimatedUpdateTimeSec() < rhs.getU32EstimatedUpdateTimeSec()) return true;
        if (getU32EstimatedUpdateTimeSec() > rhs.getU32EstimatedUpdateTimeSec()) return false;
    }
    if (hasU32EstimatedUpdateTimeSecForPhase() || rhs.hasU32EstimatedUpdateTimeSecForPhase()) {
        if (getU32EstimatedUpdateTimeSecForPhase() < rhs.getU32EstimatedUpdateTimeSecForPhase()) return true;
        if (getU32EstimatedUpdateTimeSecForPhase() > rhs.getU32EstimatedUpdateTimeSecForPhase()) return false;
    }
    if (hasU32EstimatedCurrentModuleUpdateTimeSec() || rhs.hasU32EstimatedCurrentModuleUpdateTimeSec()) {
        if (getU32EstimatedCurrentModuleUpdateTimeSec() < rhs.getU32EstimatedCurrentModuleUpdateTimeSec()) return true;
        if (getU32EstimatedCurrentModuleUpdateTimeSec() > rhs.getU32EstimatedCurrentModuleUpdateTimeSec()) return false;
    }
    return false;
}

inline bool trUpdProgress::operator > (const trUpdProgress& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void trUpdProgress::clear() {
    clearTrain();
    clearDeviceName();
    clearModuleName();
    clearSubModuleName();
    clearRefKey();
    clearSource();
    clearLine1();
    clearLine2();
    clearLuaCmd();
    clearU32Retries();
    clearU32NumAll();
    clearU32NumComplete();
    clearU32NumRunning();
    clearU32NumNotApplicable();
    clearU32NumFailed();
    clearU32NumRemaining();
    clearU8SubModulePercentComplete();
    clearU8ReleasePercentComplete();
    clearU8ReleasePercentCompleteForPhase();
    clearU32EstimatedUpdateTimeSec();
    clearU32EstimatedUpdateTimeSecForPhase();
    clearU32EstimatedCurrentModuleUpdateTimeSec();
}

inline void trUpdProgress::clearTrain() {
    if (hasTrain()) {
         clear_has_train();
        _train.clear();
     }
}

inline bool trUpdProgress::hasTrain () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& trUpdProgress::getTrain () const {
    return _train;
}

inline ::std::string& trUpdProgress::getTrainMutable () {
    set_has_train();
    return _train;
}

inline void trUpdProgress::setTrain (const ::std::string& train_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (train_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_train();
    this->_train = train_;
}

inline void trUpdProgress::setTrain (const char* train_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (train_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_train();
    this->_train.assign(train_);
}

inline void trUpdProgress::setTrain (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_train();
    this->_train.assign(value, size);
}

inline void trUpdProgress::clearDeviceName() {
    if (hasDeviceName()) {
         clear_has_deviceName();
        _deviceName.clear();
     }
}

inline bool trUpdProgress::hasDeviceName () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& trUpdProgress::getDeviceName () const {
    return _deviceName;
}

inline ::std::string& trUpdProgress::getDeviceNameMutable () {
    set_has_deviceName();
    return _deviceName;
}

inline void trUpdProgress::setDeviceName (const ::std::string& deviceName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (deviceName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_deviceName();
    this->_deviceName = deviceName_;
}

inline void trUpdProgress::setDeviceName (const char* deviceName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (deviceName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_deviceName();
    this->_deviceName.assign(deviceName_);
}

inline void trUpdProgress::setDeviceName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_deviceName();
    this->_deviceName.assign(value, size);
}

inline void trUpdProgress::clearModuleName() {
    if (hasModuleName()) {
         clear_has_moduleName();
        _moduleName.clear();
     }
}

inline bool trUpdProgress::hasModuleName () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::string& trUpdProgress::getModuleName () const {
    return _moduleName;
}

inline ::std::string& trUpdProgress::getModuleNameMutable () {
    set_has_moduleName();
    return _moduleName;
}

inline void trUpdProgress::setModuleName (const ::std::string& moduleName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (moduleName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_moduleName();
    this->_moduleName = moduleName_;
}

inline void trUpdProgress::setModuleName (const char* moduleName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (moduleName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_moduleName();
    this->_moduleName.assign(moduleName_);
}

inline void trUpdProgress::setModuleName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_moduleName();
    this->_moduleName.assign(value, size);
}

inline void trUpdProgress::clearSubModuleName() {
    if (hasSubModuleName()) {
         clear_has_subModuleName();
        _subModuleName.clear();
     }
}

inline bool trUpdProgress::hasSubModuleName () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const ::std::string& trUpdProgress::getSubModuleName () const {
    return _subModuleName;
}

inline ::std::string& trUpdProgress::getSubModuleNameMutable () {
    set_has_subModuleName();
    return _subModuleName;
}

inline void trUpdProgress::setSubModuleName (const ::std::string& subModuleName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (subModuleName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_subModuleName();
    this->_subModuleName = subModuleName_;
}

inline void trUpdProgress::setSubModuleName (const char* subModuleName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (subModuleName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_subModuleName();
    this->_subModuleName.assign(subModuleName_);
}

inline void trUpdProgress::setSubModuleName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_subModuleName();
    this->_subModuleName.assign(value, size);
}

inline void trUpdProgress::clearRefKey() {
    if (hasRefKey()) {
         clear_has_refKey();
        _refKey.clear();
     }
}

inline bool trUpdProgress::hasRefKey () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline const ::std::string& trUpdProgress::getRefKey () const {
    return _refKey;
}

inline ::std::string& trUpdProgress::getRefKeyMutable () {
    set_has_refKey();
    return _refKey;
}

inline void trUpdProgress::setRefKey (const ::std::string& refKey_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (refKey_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_refKey();
    this->_refKey = refKey_;
}

inline void trUpdProgress::setRefKey (const char* refKey_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (refKey_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_refKey();
    this->_refKey.assign(refKey_);
}

inline void trUpdProgress::setRefKey (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_refKey();
    this->_refKey.assign(value, size);
}

inline void trUpdProgress::clearSource() {
    if (hasSource()) {
         clear_has_source();
        _source.clear();
     }
}

inline bool trUpdProgress::hasSource () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline const ::std::string& trUpdProgress::getSource () const {
    return _source;
}

inline ::std::string& trUpdProgress::getSourceMutable () {
    set_has_source();
    return _source;
}

inline void trUpdProgress::setSource (const ::std::string& source_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (source_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_source();
    this->_source = source_;
}

inline void trUpdProgress::setSource (const char* source_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (source_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_source();
    this->_source.assign(source_);
}

inline void trUpdProgress::setSource (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_source();
    this->_source.assign(value, size);
}

inline void trUpdProgress::clearLine1() {
    if (hasLine1()) {
         clear_has_line1();
        _line1.clear();
     }
}

inline bool trUpdProgress::hasLine1 () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline const ::std::string& trUpdProgress::getLine1 () const {
    return _line1;
}

inline ::std::string& trUpdProgress::getLine1Mutable () {
    set_has_line1();
    return _line1;
}

inline void trUpdProgress::setLine1 (const ::std::string& line1_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (line1_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_line1();
    this->_line1 = line1_;
}

inline void trUpdProgress::setLine1 (const char* line1_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (line1_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_line1();
    this->_line1.assign(line1_);
}

inline void trUpdProgress::setLine1 (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_line1();
    this->_line1.assign(value, size);
}

inline void trUpdProgress::clearLine2() {
    if (hasLine2()) {
         clear_has_line2();
        _line2.clear();
     }
}

inline bool trUpdProgress::hasLine2 () const {
    return (_has_bits_[0] & (1u << 7)) > 0;
}

inline const ::std::string& trUpdProgress::getLine2 () const {
    return _line2;
}

inline ::std::string& trUpdProgress::getLine2Mutable () {
    set_has_line2();
    return _line2;
}

inline void trUpdProgress::setLine2 (const ::std::string& line2_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (line2_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_line2();
    this->_line2 = line2_;
}

inline void trUpdProgress::setLine2 (const char* line2_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (line2_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_line2();
    this->_line2.assign(line2_);
}

inline void trUpdProgress::setLine2 (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_line2();
    this->_line2.assign(value, size);
}

inline void trUpdProgress::clearLuaCmd() {
    if (hasLuaCmd()) {
         clear_has_luaCmd();
        _luaCmd.clear();
     }
}

inline bool trUpdProgress::hasLuaCmd () const {
    return (_has_bits_[0] & (1u << 8)) > 0;
}

inline const ::std::string& trUpdProgress::getLuaCmd () const {
    return _luaCmd;
}

inline ::std::string& trUpdProgress::getLuaCmdMutable () {
    set_has_luaCmd();
    return _luaCmd;
}

inline void trUpdProgress::setLuaCmd (const ::std::string& luaCmd_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (luaCmd_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_luaCmd();
    this->_luaCmd = luaCmd_;
}

inline void trUpdProgress::setLuaCmd (const char* luaCmd_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (luaCmd_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_luaCmd();
    this->_luaCmd.assign(luaCmd_);
}

inline void trUpdProgress::setLuaCmd (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_luaCmd();
    this->_luaCmd.assign(value, size);
}

inline void trUpdProgress::clearU32Retries() {
    if (hasU32Retries()) {
         clear_has_u32Retries();
        _u32Retries = 0u;
     }
}

inline bool trUpdProgress::hasU32Retries () const {
    return (_has_bits_[0] & (1u << 9)) > 0;
}

inline uint32 trUpdProgress::getU32Retries () const {
    return _u32Retries;
}

inline void trUpdProgress::setU32Retries (uint32 u32Retries_) {
    set_has_u32Retries();
    this->_u32Retries = u32Retries_;
}

inline void trUpdProgress::clearU32NumAll() {
    if (hasU32NumAll()) {
         clear_has_u32NumAll();
        _u32NumAll = 0u;
     }
}

inline bool trUpdProgress::hasU32NumAll () const {
    return (_has_bits_[0] & (1u << 10)) > 0;
}

inline uint32 trUpdProgress::getU32NumAll () const {
    return _u32NumAll;
}

inline void trUpdProgress::setU32NumAll (uint32 u32NumAll_) {
    set_has_u32NumAll();
    this->_u32NumAll = u32NumAll_;
}

inline void trUpdProgress::clearU32NumComplete() {
    if (hasU32NumComplete()) {
         clear_has_u32NumComplete();
        _u32NumComplete = 0u;
     }
}

inline bool trUpdProgress::hasU32NumComplete () const {
    return (_has_bits_[0] & (1u << 11)) > 0;
}

inline uint32 trUpdProgress::getU32NumComplete () const {
    return _u32NumComplete;
}

inline void trUpdProgress::setU32NumComplete (uint32 u32NumComplete_) {
    set_has_u32NumComplete();
    this->_u32NumComplete = u32NumComplete_;
}

inline void trUpdProgress::clearU32NumRunning() {
    if (hasU32NumRunning()) {
         clear_has_u32NumRunning();
        _u32NumRunning = 0u;
     }
}

inline bool trUpdProgress::hasU32NumRunning () const {
    return (_has_bits_[0] & (1u << 12)) > 0;
}

inline uint32 trUpdProgress::getU32NumRunning () const {
    return _u32NumRunning;
}

inline void trUpdProgress::setU32NumRunning (uint32 u32NumRunning_) {
    set_has_u32NumRunning();
    this->_u32NumRunning = u32NumRunning_;
}

inline void trUpdProgress::clearU32NumNotApplicable() {
    if (hasU32NumNotApplicable()) {
         clear_has_u32NumNotApplicable();
        _u32NumNotApplicable = 0u;
     }
}

inline bool trUpdProgress::hasU32NumNotApplicable () const {
    return (_has_bits_[0] & (1u << 13)) > 0;
}

inline uint32 trUpdProgress::getU32NumNotApplicable () const {
    return _u32NumNotApplicable;
}

inline void trUpdProgress::setU32NumNotApplicable (uint32 u32NumNotApplicable_) {
    set_has_u32NumNotApplicable();
    this->_u32NumNotApplicable = u32NumNotApplicable_;
}

inline void trUpdProgress::clearU32NumFailed() {
    if (hasU32NumFailed()) {
         clear_has_u32NumFailed();
        _u32NumFailed = 0u;
     }
}

inline bool trUpdProgress::hasU32NumFailed () const {
    return (_has_bits_[0] & (1u << 14)) > 0;
}

inline uint32 trUpdProgress::getU32NumFailed () const {
    return _u32NumFailed;
}

inline void trUpdProgress::setU32NumFailed (uint32 u32NumFailed_) {
    set_has_u32NumFailed();
    this->_u32NumFailed = u32NumFailed_;
}

inline void trUpdProgress::clearU32NumRemaining() {
    if (hasU32NumRemaining()) {
         clear_has_u32NumRemaining();
        _u32NumRemaining = 0u;
     }
}

inline bool trUpdProgress::hasU32NumRemaining () const {
    return (_has_bits_[0] & (1u << 15)) > 0;
}

inline uint32 trUpdProgress::getU32NumRemaining () const {
    return _u32NumRemaining;
}

inline void trUpdProgress::setU32NumRemaining (uint32 u32NumRemaining_) {
    set_has_u32NumRemaining();
    this->_u32NumRemaining = u32NumRemaining_;
}

inline void trUpdProgress::clearU8SubModulePercentComplete() {
    if (hasU8SubModulePercentComplete()) {
         clear_has_u8SubModulePercentComplete();
        _u8SubModulePercentComplete = 0u;
     }
}

inline bool trUpdProgress::hasU8SubModulePercentComplete () const {
    return (_has_bits_[0] & (1u << 16)) > 0;
}

inline uint8 trUpdProgress::getU8SubModulePercentComplete () const {
    return _u8SubModulePercentComplete;
}

inline void trUpdProgress::setU8SubModulePercentComplete (uint8 u8SubModulePercentComplete_) {
    set_has_u8SubModulePercentComplete();
    this->_u8SubModulePercentComplete = u8SubModulePercentComplete_;
}

inline void trUpdProgress::clearU8ReleasePercentComplete() {
    if (hasU8ReleasePercentComplete()) {
         clear_has_u8ReleasePercentComplete();
        _u8ReleasePercentComplete = 0u;
     }
}

inline bool trUpdProgress::hasU8ReleasePercentComplete () const {
    return (_has_bits_[0] & (1u << 17)) > 0;
}

inline uint8 trUpdProgress::getU8ReleasePercentComplete () const {
    return _u8ReleasePercentComplete;
}

inline void trUpdProgress::setU8ReleasePercentComplete (uint8 u8ReleasePercentComplete_) {
    set_has_u8ReleasePercentComplete();
    this->_u8ReleasePercentComplete = u8ReleasePercentComplete_;
}

inline void trUpdProgress::clearU8ReleasePercentCompleteForPhase() {
    if (hasU8ReleasePercentCompleteForPhase()) {
         clear_has_u8ReleasePercentCompleteForPhase();
        _u8ReleasePercentCompleteForPhase = 0u;
     }
}

inline bool trUpdProgress::hasU8ReleasePercentCompleteForPhase () const {
    return (_has_bits_[0] & (1u << 18)) > 0;
}

inline uint8 trUpdProgress::getU8ReleasePercentCompleteForPhase () const {
    return _u8ReleasePercentCompleteForPhase;
}

inline void trUpdProgress::setU8ReleasePercentCompleteForPhase (uint8 u8ReleasePercentCompleteForPhase_) {
    set_has_u8ReleasePercentCompleteForPhase();
    this->_u8ReleasePercentCompleteForPhase = u8ReleasePercentCompleteForPhase_;
}

inline void trUpdProgress::clearU32EstimatedUpdateTimeSec() {
    if (hasU32EstimatedUpdateTimeSec()) {
         clear_has_u32EstimatedUpdateTimeSec();
        _u32EstimatedUpdateTimeSec = 0u;
     }
}

inline bool trUpdProgress::hasU32EstimatedUpdateTimeSec () const {
    return (_has_bits_[0] & (1u << 19)) > 0;
}

inline uint32 trUpdProgress::getU32EstimatedUpdateTimeSec () const {
    return _u32EstimatedUpdateTimeSec;
}

inline void trUpdProgress::setU32EstimatedUpdateTimeSec (uint32 u32EstimatedUpdateTimeSec_) {
    set_has_u32EstimatedUpdateTimeSec();
    this->_u32EstimatedUpdateTimeSec = u32EstimatedUpdateTimeSec_;
}

inline void trUpdProgress::clearU32EstimatedUpdateTimeSecForPhase() {
    if (hasU32EstimatedUpdateTimeSecForPhase()) {
         clear_has_u32EstimatedUpdateTimeSecForPhase();
        _u32EstimatedUpdateTimeSecForPhase = 0u;
     }
}

inline bool trUpdProgress::hasU32EstimatedUpdateTimeSecForPhase () const {
    return (_has_bits_[0] & (1u << 20)) > 0;
}

inline uint32 trUpdProgress::getU32EstimatedUpdateTimeSecForPhase () const {
    return _u32EstimatedUpdateTimeSecForPhase;
}

inline void trUpdProgress::setU32EstimatedUpdateTimeSecForPhase (uint32 u32EstimatedUpdateTimeSecForPhase_) {
    set_has_u32EstimatedUpdateTimeSecForPhase();
    this->_u32EstimatedUpdateTimeSecForPhase = u32EstimatedUpdateTimeSecForPhase_;
}

inline void trUpdProgress::clearU32EstimatedCurrentModuleUpdateTimeSec() {
    if (hasU32EstimatedCurrentModuleUpdateTimeSec()) {
         clear_has_u32EstimatedCurrentModuleUpdateTimeSec();
        _u32EstimatedCurrentModuleUpdateTimeSec = 0u;
     }
}

inline bool trUpdProgress::hasU32EstimatedCurrentModuleUpdateTimeSec () const {
    return (_has_bits_[0] & (1u << 21)) > 0;
}

inline uint32 trUpdProgress::getU32EstimatedCurrentModuleUpdateTimeSec () const {
    return _u32EstimatedCurrentModuleUpdateTimeSec;
}

inline void trUpdProgress::setU32EstimatedCurrentModuleUpdateTimeSec (uint32 u32EstimatedCurrentModuleUpdateTimeSec_) {
    set_has_u32EstimatedCurrentModuleUpdateTimeSec();
    this->_u32EstimatedCurrentModuleUpdateTimeSec = u32EstimatedCurrentModuleUpdateTimeSec_;
}

inline void trUpdProgress::set_has_train () {
    _has_bits_[0] |= 1u << 0;
}

inline void trUpdProgress::clear_has_train () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void trUpdProgress::set_has_deviceName () {
    _has_bits_[0] |= 1u << 1;
}

inline void trUpdProgress::clear_has_deviceName () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void trUpdProgress::set_has_moduleName () {
    _has_bits_[0] |= 1u << 2;
}

inline void trUpdProgress::clear_has_moduleName () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void trUpdProgress::set_has_subModuleName () {
    _has_bits_[0] |= 1u << 3;
}

inline void trUpdProgress::clear_has_subModuleName () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void trUpdProgress::set_has_refKey () {
    _has_bits_[0] |= 1u << 4;
}

inline void trUpdProgress::clear_has_refKey () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void trUpdProgress::set_has_source () {
    _has_bits_[0] |= 1u << 5;
}

inline void trUpdProgress::clear_has_source () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void trUpdProgress::set_has_line1 () {
    _has_bits_[0] |= 1u << 6;
}

inline void trUpdProgress::clear_has_line1 () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline void trUpdProgress::set_has_line2 () {
    _has_bits_[0] |= 1u << 7;
}

inline void trUpdProgress::clear_has_line2 () {
    _has_bits_[0] &= ~ (1u << 7);
}

inline void trUpdProgress::set_has_luaCmd () {
    _has_bits_[0] |= 1u << 8;
}

inline void trUpdProgress::clear_has_luaCmd () {
    _has_bits_[0] &= ~ (1u << 8);
}

inline void trUpdProgress::set_has_u32Retries () {
    _has_bits_[0] |= 1u << 9;
}

inline void trUpdProgress::clear_has_u32Retries () {
    _has_bits_[0] &= ~ (1u << 9);
}

inline void trUpdProgress::set_has_u32NumAll () {
    _has_bits_[0] |= 1u << 10;
}

inline void trUpdProgress::clear_has_u32NumAll () {
    _has_bits_[0] &= ~ (1u << 10);
}

inline void trUpdProgress::set_has_u32NumComplete () {
    _has_bits_[0] |= 1u << 11;
}

inline void trUpdProgress::clear_has_u32NumComplete () {
    _has_bits_[0] &= ~ (1u << 11);
}

inline void trUpdProgress::set_has_u32NumRunning () {
    _has_bits_[0] |= 1u << 12;
}

inline void trUpdProgress::clear_has_u32NumRunning () {
    _has_bits_[0] &= ~ (1u << 12);
}

inline void trUpdProgress::set_has_u32NumNotApplicable () {
    _has_bits_[0] |= 1u << 13;
}

inline void trUpdProgress::clear_has_u32NumNotApplicable () {
    _has_bits_[0] &= ~ (1u << 13);
}

inline void trUpdProgress::set_has_u32NumFailed () {
    _has_bits_[0] |= 1u << 14;
}

inline void trUpdProgress::clear_has_u32NumFailed () {
    _has_bits_[0] &= ~ (1u << 14);
}

inline void trUpdProgress::set_has_u32NumRemaining () {
    _has_bits_[0] |= 1u << 15;
}

inline void trUpdProgress::clear_has_u32NumRemaining () {
    _has_bits_[0] &= ~ (1u << 15);
}

inline void trUpdProgress::set_has_u8SubModulePercentComplete () {
    _has_bits_[0] |= 1u << 16;
}

inline void trUpdProgress::clear_has_u8SubModulePercentComplete () {
    _has_bits_[0] &= ~ (1u << 16);
}

inline void trUpdProgress::set_has_u8ReleasePercentComplete () {
    _has_bits_[0] |= 1u << 17;
}

inline void trUpdProgress::clear_has_u8ReleasePercentComplete () {
    _has_bits_[0] &= ~ (1u << 17);
}

inline void trUpdProgress::set_has_u8ReleasePercentCompleteForPhase () {
    _has_bits_[0] |= 1u << 18;
}

inline void trUpdProgress::clear_has_u8ReleasePercentCompleteForPhase () {
    _has_bits_[0] &= ~ (1u << 18);
}

inline void trUpdProgress::set_has_u32EstimatedUpdateTimeSec () {
    _has_bits_[0] |= 1u << 19;
}

inline void trUpdProgress::clear_has_u32EstimatedUpdateTimeSec () {
    _has_bits_[0] &= ~ (1u << 19);
}

inline void trUpdProgress::set_has_u32EstimatedUpdateTimeSecForPhase () {
    _has_bits_[0] |= 1u << 20;
}

inline void trUpdProgress::clear_has_u32EstimatedUpdateTimeSecForPhase () {
    _has_bits_[0] &= ~ (1u << 20);
}

inline void trUpdProgress::set_has_u32EstimatedCurrentModuleUpdateTimeSec () {
    _has_bits_[0] |= 1u << 21;
}

inline void trUpdProgress::clear_has_u32EstimatedCurrentModuleUpdateTimeSec () {
    _has_bits_[0] &= ~ (1u << 21);
}

inline  trAbortDeviceRes::trAbortDeviceRes ()  :
    _abortSuccess (false),
    _refKey ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  trAbortDeviceRes::trAbortDeviceRes (const trAbortDeviceRes &rhs)  :
    _abortSuccess (false),
    _refKey ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  trAbortDeviceRes::trAbortDeviceRes (bool abortSuccess_, const ::std::string& refKey_)  :
    _abortSuccess (abortSuccess_),
    _refKey (refKey_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (refKey_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  trAbortDeviceRes::~trAbortDeviceRes() {
}

inline trAbortDeviceRes& trAbortDeviceRes::operator = (const trAbortDeviceRes& rhs) {
    if( this != &rhs ) {
        if (rhs.hasAbortSuccess()) {
            setAbortSuccess(rhs.getAbortSuccess());
        } else {
            clearAbortSuccess();
        }
        if (rhs.hasRefKey()) {
            setRefKey(rhs.getRefKey());
        } else {
            clearRefKey();
        }
    }
    return *this;
}

inline bool trAbortDeviceRes::operator == (const trAbortDeviceRes& rhs) const {
    return (((!hasAbortSuccess() && !rhs.hasAbortSuccess()) || getAbortSuccess() == rhs.getAbortSuccess()) &&
        ((!hasRefKey() && !rhs.hasRefKey()) || getRefKey() == rhs.getRefKey()));
}

inline bool trAbortDeviceRes::operator != (const trAbortDeviceRes& rhs) const {
    return ! (*this == rhs);
}

inline bool trAbortDeviceRes::operator < (const trAbortDeviceRes& rhs) const {
    if (hasAbortSuccess() || rhs.hasAbortSuccess()) {
        if (getAbortSuccess() < rhs.getAbortSuccess()) return true;
        if (getAbortSuccess() > rhs.getAbortSuccess()) return false;
    }
    if (hasRefKey() || rhs.hasRefKey()) {
        if (getRefKey() < rhs.getRefKey()) return true;
        if (getRefKey() > rhs.getRefKey()) return false;
    }
    return false;
}

inline bool trAbortDeviceRes::operator > (const trAbortDeviceRes& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void trAbortDeviceRes::clear() {
    clearAbortSuccess();
    clearRefKey();
}

inline void trAbortDeviceRes::clearAbortSuccess() {
    if (hasAbortSuccess()) {
         clear_has_abortSuccess();
        _abortSuccess = false;
     }
}

inline bool trAbortDeviceRes::hasAbortSuccess () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool trAbortDeviceRes::getAbortSuccess () const {
    return _abortSuccess;
}

inline void trAbortDeviceRes::setAbortSuccess (bool abortSuccess_) {
    set_has_abortSuccess();
    this->_abortSuccess = abortSuccess_;
}

inline void trAbortDeviceRes::clearRefKey() {
    if (hasRefKey()) {
         clear_has_refKey();
        _refKey.clear();
     }
}

inline bool trAbortDeviceRes::hasRefKey () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& trAbortDeviceRes::getRefKey () const {
    return _refKey;
}

inline ::std::string& trAbortDeviceRes::getRefKeyMutable () {
    set_has_refKey();
    return _refKey;
}

inline void trAbortDeviceRes::setRefKey (const ::std::string& refKey_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (refKey_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_refKey();
    this->_refKey = refKey_;
}

inline void trAbortDeviceRes::setRefKey (const char* refKey_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (refKey_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_refKey();
    this->_refKey.assign(refKey_);
}

inline void trAbortDeviceRes::setRefKey (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_refKey();
    this->_refKey.assign(value, size);
}

inline void trAbortDeviceRes::set_has_abortSuccess () {
    _has_bits_[0] |= 1u << 0;
}

inline void trAbortDeviceRes::clear_has_abortSuccess () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void trAbortDeviceRes::set_has_refKey () {
    _has_bits_[0] |= 1u << 1;
}

inline void trAbortDeviceRes::clear_has_refKey () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  trTimeDate::trTimeDate ()  :
    _year (0u),
    _month (0u),
    _day (0u),
    _hour (0u),
    _minute (0u),
    _seconds (0u),
    _utc (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  trTimeDate::trTimeDate (const trTimeDate &rhs)  :
    _year (0u),
    _month (0u),
    _day (0u),
    _hour (0u),
    _minute (0u),
    _seconds (0u),
    _utc (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  trTimeDate::trTimeDate (uint16 year_, uint8 month_, uint8 day_, uint8 hour_, uint8 minute_, uint32 seconds_, uint64 utc_)  :
    _year (year_),
    _month (month_),
    _day (day_),
    _hour (hour_),
    _minute (minute_),
    _seconds (seconds_),
    _utc (utc_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  trTimeDate::~trTimeDate() {
}

inline trTimeDate& trTimeDate::operator = (const trTimeDate& rhs) {
    if( this != &rhs ) {
        if (rhs.hasYear()) {
            setYear(rhs.getYear());
        } else {
            clearYear();
        }
        if (rhs.hasMonth()) {
            setMonth(rhs.getMonth());
        } else {
            clearMonth();
        }
        if (rhs.hasDay()) {
            setDay(rhs.getDay());
        } else {
            clearDay();
        }
        if (rhs.hasHour()) {
            setHour(rhs.getHour());
        } else {
            clearHour();
        }
        if (rhs.hasMinute()) {
            setMinute(rhs.getMinute());
        } else {
            clearMinute();
        }
        if (rhs.hasSeconds()) {
            setSeconds(rhs.getSeconds());
        } else {
            clearSeconds();
        }
        if (rhs.hasUtc()) {
            setUtc(rhs.getUtc());
        } else {
            clearUtc();
        }
    }
    return *this;
}

inline bool trTimeDate::operator == (const trTimeDate& rhs) const {
    return (((!hasYear() && !rhs.hasYear()) || getYear() == rhs.getYear()) &&
        ((!hasMonth() && !rhs.hasMonth()) || getMonth() == rhs.getMonth()) &&
        ((!hasDay() && !rhs.hasDay()) || getDay() == rhs.getDay()) &&
        ((!hasHour() && !rhs.hasHour()) || getHour() == rhs.getHour()) &&
        ((!hasMinute() && !rhs.hasMinute()) || getMinute() == rhs.getMinute()) &&
        ((!hasSeconds() && !rhs.hasSeconds()) || getSeconds() == rhs.getSeconds()) &&
        ((!hasUtc() && !rhs.hasUtc()) || getUtc() == rhs.getUtc()));
}

inline bool trTimeDate::operator != (const trTimeDate& rhs) const {
    return ! (*this == rhs);
}

inline bool trTimeDate::operator < (const trTimeDate& rhs) const {
    if (hasYear() || rhs.hasYear()) {
        if (getYear() < rhs.getYear()) return true;
        if (getYear() > rhs.getYear()) return false;
    }
    if (hasMonth() || rhs.hasMonth()) {
        if (getMonth() < rhs.getMonth()) return true;
        if (getMonth() > rhs.getMonth()) return false;
    }
    if (hasDay() || rhs.hasDay()) {
        if (getDay() < rhs.getDay()) return true;
        if (getDay() > rhs.getDay()) return false;
    }
    if (hasHour() || rhs.hasHour()) {
        if (getHour() < rhs.getHour()) return true;
        if (getHour() > rhs.getHour()) return false;
    }
    if (hasMinute() || rhs.hasMinute()) {
        if (getMinute() < rhs.getMinute()) return true;
        if (getMinute() > rhs.getMinute()) return false;
    }
    if (hasSeconds() || rhs.hasSeconds()) {
        if (getSeconds() < rhs.getSeconds()) return true;
        if (getSeconds() > rhs.getSeconds()) return false;
    }
    if (hasUtc() || rhs.hasUtc()) {
        if (getUtc() < rhs.getUtc()) return true;
        if (getUtc() > rhs.getUtc()) return false;
    }
    return false;
}

inline bool trTimeDate::operator > (const trTimeDate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void trTimeDate::clear() {
    clearYear();
    clearMonth();
    clearDay();
    clearHour();
    clearMinute();
    clearSeconds();
    clearUtc();
}

inline void trTimeDate::clearYear() {
    if (hasYear()) {
         clear_has_year();
        _year = 0u;
     }
}

inline bool trTimeDate::hasYear () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint16 trTimeDate::getYear () const {
    return _year;
}

inline void trTimeDate::setYear (uint16 year_) {
    set_has_year();
    this->_year = year_;
}

inline void trTimeDate::clearMonth() {
    if (hasMonth()) {
         clear_has_month();
        _month = 0u;
     }
}

inline bool trTimeDate::hasMonth () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 trTimeDate::getMonth () const {
    return _month;
}

inline void trTimeDate::setMonth (uint8 month_) {
    set_has_month();
    this->_month = month_;
}

inline void trTimeDate::clearDay() {
    if (hasDay()) {
         clear_has_day();
        _day = 0u;
     }
}

inline bool trTimeDate::hasDay () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint8 trTimeDate::getDay () const {
    return _day;
}

inline void trTimeDate::setDay (uint8 day_) {
    set_has_day();
    this->_day = day_;
}

inline void trTimeDate::clearHour() {
    if (hasHour()) {
         clear_has_hour();
        _hour = 0u;
     }
}

inline bool trTimeDate::hasHour () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint8 trTimeDate::getHour () const {
    return _hour;
}

inline void trTimeDate::setHour (uint8 hour_) {
    set_has_hour();
    this->_hour = hour_;
}

inline void trTimeDate::clearMinute() {
    if (hasMinute()) {
         clear_has_minute();
        _minute = 0u;
     }
}

inline bool trTimeDate::hasMinute () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline uint8 trTimeDate::getMinute () const {
    return _minute;
}

inline void trTimeDate::setMinute (uint8 minute_) {
    set_has_minute();
    this->_minute = minute_;
}

inline void trTimeDate::clearSeconds() {
    if (hasSeconds()) {
         clear_has_seconds();
        _seconds = 0u;
     }
}

inline bool trTimeDate::hasSeconds () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline uint32 trTimeDate::getSeconds () const {
    return _seconds;
}

inline void trTimeDate::setSeconds (uint32 seconds_) {
    set_has_seconds();
    this->_seconds = seconds_;
}

inline void trTimeDate::clearUtc() {
    if (hasUtc()) {
         clear_has_utc();
        _utc = 0u;
     }
}

inline bool trTimeDate::hasUtc () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline uint64 trTimeDate::getUtc () const {
    return _utc;
}

inline void trTimeDate::setUtc (uint64 utc_) {
    set_has_utc();
    this->_utc = utc_;
}

inline void trTimeDate::set_has_year () {
    _has_bits_[0] |= 1u << 0;
}

inline void trTimeDate::clear_has_year () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void trTimeDate::set_has_month () {
    _has_bits_[0] |= 1u << 1;
}

inline void trTimeDate::clear_has_month () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void trTimeDate::set_has_day () {
    _has_bits_[0] |= 1u << 2;
}

inline void trTimeDate::clear_has_day () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void trTimeDate::set_has_hour () {
    _has_bits_[0] |= 1u << 3;
}

inline void trTimeDate::clear_has_hour () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void trTimeDate::set_has_minute () {
    _has_bits_[0] |= 1u << 4;
}

inline void trTimeDate::clear_has_minute () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void trTimeDate::set_has_seconds () {
    _has_bits_[0] |= 1u << 5;
}

inline void trTimeDate::clear_has_seconds () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void trTimeDate::set_has_utc () {
    _has_bits_[0] |= 1u << 6;
}

inline void trTimeDate::clear_has_utc () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline  trResult::trResult ()  :
    _bOk (false),
    _name (),
    _timeDate (),
    _counterKilometers (0u),
    _devices ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  trResult::trResult (const trResult &rhs)  :
    _bOk (false),
    _name (),
    _timeDate (),
    _counterKilometers (0u),
    _devices ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  trResult::trResult (bool bOk_, const ::std::string& name_, const trTimeDate& timeDate_, uint32 counterKilometers_, const ::std::vector< trDeviceData >& devices_)  :
    _bOk (bOk_),
    _name (name_),
    _timeDate (timeDate_),
    _counterKilometers (counterKilometers_),
    _devices (devices_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (name_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  trResult::~trResult() {
}

inline trResult& trResult::operator = (const trResult& rhs) {
    if( this != &rhs ) {
        if (rhs.hasBOk()) {
            setBOk(rhs.getBOk());
        } else {
            clearBOk();
        }
        if (rhs.hasName()) {
            setName(rhs.getName());
        } else {
            clearName();
        }
        if (rhs.hasTimeDate()) {
            setTimeDate(rhs.getTimeDate());
        } else {
            clearTimeDate();
        }
        if (rhs.hasCounterKilometers()) {
            setCounterKilometers(rhs.getCounterKilometers());
        } else {
            clearCounterKilometers();
        }
        if (rhs.hasDevices()) {
            setDevices(rhs.getDevices());
        } else {
            clearDevices();
        }
    }
    return *this;
}

inline bool trResult::operator == (const trResult& rhs) const {
    return (((!hasBOk() && !rhs.hasBOk()) || getBOk() == rhs.getBOk()) &&
        ((!hasName() && !rhs.hasName()) || getName() == rhs.getName()) &&
        ((!hasTimeDate() && !rhs.hasTimeDate()) || getTimeDate() == rhs.getTimeDate()) &&
        ((!hasCounterKilometers() && !rhs.hasCounterKilometers()) || getCounterKilometers() == rhs.getCounterKilometers()) &&
        ((!hasDevices() && !rhs.hasDevices()) || getDevices() == rhs.getDevices()));
}

inline bool trResult::operator != (const trResult& rhs) const {
    return ! (*this == rhs);
}

inline bool trResult::operator < (const trResult& rhs) const {
    if (hasBOk() || rhs.hasBOk()) {
        if (getBOk() < rhs.getBOk()) return true;
        if (getBOk() > rhs.getBOk()) return false;
    }
    if (hasName() || rhs.hasName()) {
        if (getName() < rhs.getName()) return true;
        if (getName() > rhs.getName()) return false;
    }
    if (hasTimeDate() || rhs.hasTimeDate()) {
        if (getTimeDate() < rhs.getTimeDate()) return true;
        if (getTimeDate() > rhs.getTimeDate()) return false;
    }
    if (hasCounterKilometers() || rhs.hasCounterKilometers()) {
        if (getCounterKilometers() < rhs.getCounterKilometers()) return true;
        if (getCounterKilometers() > rhs.getCounterKilometers()) return false;
    }
    if (hasDevices() || rhs.hasDevices()) {
        if (getDevices() < rhs.getDevices()) return true;
        if (getDevices() > rhs.getDevices()) return false;
    }
    return false;
}

inline bool trResult::operator > (const trResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void trResult::clear() {
    clearBOk();
    clearName();
    clearTimeDate();
    clearCounterKilometers();
    clearDevices();
}

inline void trResult::clearBOk() {
    if (hasBOk()) {
         clear_has_bOk();
        _bOk = false;
     }
}

inline bool trResult::hasBOk () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool trResult::getBOk () const {
    return _bOk;
}

inline void trResult::setBOk (bool bOk_) {
    set_has_bOk();
    this->_bOk = bOk_;
}

inline void trResult::clearName() {
    if (hasName()) {
         clear_has_name();
        _name.clear();
     }
}

inline bool trResult::hasName () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& trResult::getName () const {
    return _name;
}

inline ::std::string& trResult::getNameMutable () {
    set_has_name();
    return _name;
}

inline void trResult::setName (const ::std::string& name_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (name_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_name();
    this->_name = name_;
}

inline void trResult::setName (const char* name_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (name_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_name();
    this->_name.assign(name_);
}

inline void trResult::setName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_name();
    this->_name.assign(value, size);
}

inline void trResult::clearTimeDate() {
    if (hasTimeDate()) {
         clear_has_timeDate();
        _timeDate.clear();
     }
}

inline bool trResult::hasTimeDate () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const trTimeDate& trResult::getTimeDate () const {
    return _timeDate;
}

inline trTimeDate& trResult::getTimeDateMutable () {
    set_has_timeDate();
    return _timeDate;
}

inline void trResult::setTimeDate (const trTimeDate& timeDate_) {
    set_has_timeDate();
    this->_timeDate = timeDate_;
}

inline void trResult::clearCounterKilometers() {
    if (hasCounterKilometers()) {
         clear_has_counterKilometers();
        _counterKilometers = 0u;
     }
}

inline bool trResult::hasCounterKilometers () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint32 trResult::getCounterKilometers () const {
    return _counterKilometers;
}

inline void trResult::setCounterKilometers (uint32 counterKilometers_) {
    set_has_counterKilometers();
    this->_counterKilometers = counterKilometers_;
}

inline void trResult::clearDevices() {
    if (hasDevices()) {
         clear_has_devices();
        _devices.clear();
     }
}

inline bool trResult::hasDevices () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline const ::std::vector< trDeviceData >& trResult::getDevices () const {
    return _devices;
}

inline ::std::vector< trDeviceData >& trResult::getDevicesMutable () {
    set_has_devices();
    return _devices;
}

inline void trResult::setDevices (const ::std::vector< trDeviceData >& devices_) {
    set_has_devices();
    this->_devices = devices_;
}

inline void trResult::set_has_bOk () {
    _has_bits_[0] |= 1u << 0;
}

inline void trResult::clear_has_bOk () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void trResult::set_has_name () {
    _has_bits_[0] |= 1u << 1;
}

inline void trResult::clear_has_name () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void trResult::set_has_timeDate () {
    _has_bits_[0] |= 1u << 2;
}

inline void trResult::clear_has_timeDate () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void trResult::set_has_counterKilometers () {
    _has_bits_[0] |= 1u << 3;
}

inline void trResult::clear_has_counterKilometers () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void trResult::set_has_devices () {
    _has_bits_[0] |= 1u << 4;
}

inline void trResult::clear_has_devices () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline  trErrorIds::trErrorIds ()  :
    _errorIds ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  trErrorIds::trErrorIds (const trErrorIds &rhs)  :
    _errorIds ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  trErrorIds::trErrorIds (const ::std::vector< tenErrorId >& errorIds_)  :
    _errorIds (errorIds_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  trErrorIds::~trErrorIds() {
}

inline trErrorIds& trErrorIds::operator = (const trErrorIds& rhs) {
    if( this != &rhs ) {
        if (rhs.hasErrorIds()) {
            setErrorIds(rhs.getErrorIds());
        } else {
            clearErrorIds();
        }
    }
    return *this;
}

inline bool trErrorIds::operator == (const trErrorIds& rhs) const {
    return (((!hasErrorIds() && !rhs.hasErrorIds()) || getErrorIds() == rhs.getErrorIds()));
}

inline bool trErrorIds::operator != (const trErrorIds& rhs) const {
    return ! (*this == rhs);
}

inline bool trErrorIds::operator < (const trErrorIds& rhs) const {
    if (hasErrorIds() || rhs.hasErrorIds()) {
        if (getErrorIds() < rhs.getErrorIds()) return true;
        if (getErrorIds() > rhs.getErrorIds()) return false;
    }
    return false;
}

inline bool trErrorIds::operator > (const trErrorIds& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void trErrorIds::clear() {
    clearErrorIds();
}

inline void trErrorIds::clearErrorIds() {
    if (hasErrorIds()) {
         clear_has_errorIds();
        _errorIds.clear();
     }
}

inline bool trErrorIds::hasErrorIds () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< tenErrorId >& trErrorIds::getErrorIds () const {
    return _errorIds;
}

inline ::std::vector< tenErrorId >& trErrorIds::getErrorIdsMutable () {
    set_has_errorIds();
    return _errorIds;
}

inline void trErrorIds::setErrorIds (const ::std::vector< tenErrorId >& errorIds_) {
    set_has_errorIds();
    this->_errorIds = errorIds_;
}

inline void trErrorIds::set_has_errorIds () {
    _has_bits_[0] |= 1u << 0;
}

inline void trErrorIds::clear_has_errorIds () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  trGetCacheDirectory::trGetCacheDirectory ()  :
    _dirRequest (::fcswupdatesrv::FcSwUpdateSrv::tenCacheDirRequest__AcquireAndClear)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  trGetCacheDirectory::trGetCacheDirectory (const trGetCacheDirectory &rhs)  :
    _dirRequest (::fcswupdatesrv::FcSwUpdateSrv::tenCacheDirRequest__AcquireAndClear)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  trGetCacheDirectory::trGetCacheDirectory (tenCacheDirRequest dirRequest_)  :
    _dirRequest (dirRequest_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(tenCacheDirRequest_IsValid(dirRequest_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", dirRequest_, "tenCacheDirRequest", "dirRequest", "trGetCacheDirectory");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  trGetCacheDirectory::~trGetCacheDirectory() {
}

inline trGetCacheDirectory& trGetCacheDirectory::operator = (const trGetCacheDirectory& rhs) {
    if( this != &rhs ) {
        if (rhs.hasDirRequest()) {
            setDirRequest(rhs.getDirRequest());
        } else {
            clearDirRequest();
        }
    }
    return *this;
}

inline bool trGetCacheDirectory::operator == (const trGetCacheDirectory& rhs) const {
    return (((!hasDirRequest() && !rhs.hasDirRequest()) || getDirRequest() == rhs.getDirRequest()));
}

inline bool trGetCacheDirectory::operator != (const trGetCacheDirectory& rhs) const {
    return ! (*this == rhs);
}

inline bool trGetCacheDirectory::operator < (const trGetCacheDirectory& rhs) const {
    if (hasDirRequest() || rhs.hasDirRequest()) {
        if ((uint32)getDirRequest() < (uint32)rhs.getDirRequest()) return true;
        if ((uint32)getDirRequest() > (uint32)rhs.getDirRequest()) return false;
    }
    return false;
}

inline bool trGetCacheDirectory::operator > (const trGetCacheDirectory& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void trGetCacheDirectory::clear() {
    clearDirRequest();
}

inline void trGetCacheDirectory::clearDirRequest() {
    if (hasDirRequest()) {
         clear_has_dirRequest();
        _dirRequest = ::fcswupdatesrv::FcSwUpdateSrv::tenCacheDirRequest__AcquireAndClear;
     }
}

inline bool trGetCacheDirectory::hasDirRequest () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline tenCacheDirRequest trGetCacheDirectory::getDirRequest () const {
    return _dirRequest;
}

inline void trGetCacheDirectory::setDirRequest (tenCacheDirRequest dirRequest_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(tenCacheDirRequest_IsValid(dirRequest_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", dirRequest_, "tenCacheDirRequest", "dirRequest", "trGetCacheDirectory");
    }
    set_has_dirRequest();
    this->_dirRequest = dirRequest_;
}

inline void trGetCacheDirectory::set_has_dirRequest () {
    _has_bits_[0] |= 1u << 0;
}

inline void trGetCacheDirectory::clear_has_dirRequest () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  trUpdLog::trUpdLog ()  :
    _name (),
    _timeDate (),
    _updateType (),
    _devices (),
    _size (0u),
    _success (false),
    _counterKilometers (0u),
    _index (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  trUpdLog::trUpdLog (const trUpdLog &rhs)  :
    _name (),
    _timeDate (),
    _updateType (),
    _devices (),
    _size (0u),
    _success (false),
    _counterKilometers (0u),
    _index (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  trUpdLog::trUpdLog (const ::std::string& name_, const trTimeDate& timeDate_, const ::std::string& updateType_, const ::std::vector< trDeviceData >& devices_, uint64 size_, bool success_, uint32 counterKilometers_, uint32 index_)  :
    _name (name_),
    _timeDate (timeDate_),
    _updateType (updateType_),
    _devices (devices_),
    _size (size_),
    _success (success_),
    _counterKilometers (counterKilometers_),
    _index (index_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (name_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (updateType_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  trUpdLog::~trUpdLog() {
}

inline trUpdLog& trUpdLog::operator = (const trUpdLog& rhs) {
    if( this != &rhs ) {
        if (rhs.hasName()) {
            setName(rhs.getName());
        } else {
            clearName();
        }
        if (rhs.hasTimeDate()) {
            setTimeDate(rhs.getTimeDate());
        } else {
            clearTimeDate();
        }
        if (rhs.hasUpdateType()) {
            setUpdateType(rhs.getUpdateType());
        } else {
            clearUpdateType();
        }
        if (rhs.hasDevices()) {
            setDevices(rhs.getDevices());
        } else {
            clearDevices();
        }
        if (rhs.hasSize()) {
            setSize(rhs.getSize());
        } else {
            clearSize();
        }
        if (rhs.hasSuccess()) {
            setSuccess(rhs.getSuccess());
        } else {
            clearSuccess();
        }
        if (rhs.hasCounterKilometers()) {
            setCounterKilometers(rhs.getCounterKilometers());
        } else {
            clearCounterKilometers();
        }
        if (rhs.hasIndex()) {
            setIndex(rhs.getIndex());
        } else {
            clearIndex();
        }
    }
    return *this;
}

inline bool trUpdLog::operator == (const trUpdLog& rhs) const {
    return (((!hasName() && !rhs.hasName()) || getName() == rhs.getName()) &&
        ((!hasTimeDate() && !rhs.hasTimeDate()) || getTimeDate() == rhs.getTimeDate()) &&
        ((!hasUpdateType() && !rhs.hasUpdateType()) || getUpdateType() == rhs.getUpdateType()) &&
        ((!hasDevices() && !rhs.hasDevices()) || getDevices() == rhs.getDevices()) &&
        ((!hasSize() && !rhs.hasSize()) || getSize() == rhs.getSize()) &&
        ((!hasSuccess() && !rhs.hasSuccess()) || getSuccess() == rhs.getSuccess()) &&
        ((!hasCounterKilometers() && !rhs.hasCounterKilometers()) || getCounterKilometers() == rhs.getCounterKilometers()) &&
        ((!hasIndex() && !rhs.hasIndex()) || getIndex() == rhs.getIndex()));
}

inline bool trUpdLog::operator != (const trUpdLog& rhs) const {
    return ! (*this == rhs);
}

inline bool trUpdLog::operator < (const trUpdLog& rhs) const {
    if (hasName() || rhs.hasName()) {
        if (getName() < rhs.getName()) return true;
        if (getName() > rhs.getName()) return false;
    }
    if (hasTimeDate() || rhs.hasTimeDate()) {
        if (getTimeDate() < rhs.getTimeDate()) return true;
        if (getTimeDate() > rhs.getTimeDate()) return false;
    }
    if (hasUpdateType() || rhs.hasUpdateType()) {
        if (getUpdateType() < rhs.getUpdateType()) return true;
        if (getUpdateType() > rhs.getUpdateType()) return false;
    }
    if (hasDevices() || rhs.hasDevices()) {
        if (getDevices() < rhs.getDevices()) return true;
        if (getDevices() > rhs.getDevices()) return false;
    }
    if (hasSize() || rhs.hasSize()) {
        if (getSize() < rhs.getSize()) return true;
        if (getSize() > rhs.getSize()) return false;
    }
    if (hasSuccess() || rhs.hasSuccess()) {
        if (getSuccess() < rhs.getSuccess()) return true;
        if (getSuccess() > rhs.getSuccess()) return false;
    }
    if (hasCounterKilometers() || rhs.hasCounterKilometers()) {
        if (getCounterKilometers() < rhs.getCounterKilometers()) return true;
        if (getCounterKilometers() > rhs.getCounterKilometers()) return false;
    }
    if (hasIndex() || rhs.hasIndex()) {
        if (getIndex() < rhs.getIndex()) return true;
        if (getIndex() > rhs.getIndex()) return false;
    }
    return false;
}

inline bool trUpdLog::operator > (const trUpdLog& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void trUpdLog::clear() {
    clearName();
    clearTimeDate();
    clearUpdateType();
    clearDevices();
    clearSize();
    clearSuccess();
    clearCounterKilometers();
    clearIndex();
}

inline void trUpdLog::clearName() {
    if (hasName()) {
         clear_has_name();
        _name.clear();
     }
}

inline bool trUpdLog::hasName () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& trUpdLog::getName () const {
    return _name;
}

inline ::std::string& trUpdLog::getNameMutable () {
    set_has_name();
    return _name;
}

inline void trUpdLog::setName (const ::std::string& name_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (name_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_name();
    this->_name = name_;
}

inline void trUpdLog::setName (const char* name_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (name_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_name();
    this->_name.assign(name_);
}

inline void trUpdLog::setName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_name();
    this->_name.assign(value, size);
}

inline void trUpdLog::clearTimeDate() {
    if (hasTimeDate()) {
         clear_has_timeDate();
        _timeDate.clear();
     }
}

inline bool trUpdLog::hasTimeDate () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const trTimeDate& trUpdLog::getTimeDate () const {
    return _timeDate;
}

inline trTimeDate& trUpdLog::getTimeDateMutable () {
    set_has_timeDate();
    return _timeDate;
}

inline void trUpdLog::setTimeDate (const trTimeDate& timeDate_) {
    set_has_timeDate();
    this->_timeDate = timeDate_;
}

inline void trUpdLog::clearUpdateType() {
    if (hasUpdateType()) {
         clear_has_updateType();
        _updateType.clear();
     }
}

inline bool trUpdLog::hasUpdateType () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::string& trUpdLog::getUpdateType () const {
    return _updateType;
}

inline ::std::string& trUpdLog::getUpdateTypeMutable () {
    set_has_updateType();
    return _updateType;
}

inline void trUpdLog::setUpdateType (const ::std::string& updateType_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (updateType_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_updateType();
    this->_updateType = updateType_;
}

inline void trUpdLog::setUpdateType (const char* updateType_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (updateType_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_updateType();
    this->_updateType.assign(updateType_);
}

inline void trUpdLog::setUpdateType (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_updateType();
    this->_updateType.assign(value, size);
}

inline void trUpdLog::clearDevices() {
    if (hasDevices()) {
         clear_has_devices();
        _devices.clear();
     }
}

inline bool trUpdLog::hasDevices () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const ::std::vector< trDeviceData >& trUpdLog::getDevices () const {
    return _devices;
}

inline ::std::vector< trDeviceData >& trUpdLog::getDevicesMutable () {
    set_has_devices();
    return _devices;
}

inline void trUpdLog::setDevices (const ::std::vector< trDeviceData >& devices_) {
    set_has_devices();
    this->_devices = devices_;
}

inline void trUpdLog::clearSize() {
    if (hasSize()) {
         clear_has_size();
        _size = 0u;
     }
}

inline bool trUpdLog::hasSize () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline uint64 trUpdLog::getSize () const {
    return _size;
}

inline void trUpdLog::setSize (uint64 size_) {
    set_has_size();
    this->_size = size_;
}

inline void trUpdLog::clearSuccess() {
    if (hasSuccess()) {
         clear_has_success();
        _success = false;
     }
}

inline bool trUpdLog::hasSuccess () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline bool trUpdLog::getSuccess () const {
    return _success;
}

inline void trUpdLog::setSuccess (bool success_) {
    set_has_success();
    this->_success = success_;
}

inline void trUpdLog::clearCounterKilometers() {
    if (hasCounterKilometers()) {
         clear_has_counterKilometers();
        _counterKilometers = 0u;
     }
}

inline bool trUpdLog::hasCounterKilometers () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline uint32 trUpdLog::getCounterKilometers () const {
    return _counterKilometers;
}

inline void trUpdLog::setCounterKilometers (uint32 counterKilometers_) {
    set_has_counterKilometers();
    this->_counterKilometers = counterKilometers_;
}

inline void trUpdLog::clearIndex() {
    if (hasIndex()) {
         clear_has_index();
        _index = 0u;
     }
}

inline bool trUpdLog::hasIndex () const {
    return (_has_bits_[0] & (1u << 7)) > 0;
}

inline uint32 trUpdLog::getIndex () const {
    return _index;
}

inline void trUpdLog::setIndex (uint32 index_) {
    set_has_index();
    this->_index = index_;
}

inline void trUpdLog::set_has_name () {
    _has_bits_[0] |= 1u << 0;
}

inline void trUpdLog::clear_has_name () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void trUpdLog::set_has_timeDate () {
    _has_bits_[0] |= 1u << 1;
}

inline void trUpdLog::clear_has_timeDate () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void trUpdLog::set_has_updateType () {
    _has_bits_[0] |= 1u << 2;
}

inline void trUpdLog::clear_has_updateType () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void trUpdLog::set_has_devices () {
    _has_bits_[0] |= 1u << 3;
}

inline void trUpdLog::clear_has_devices () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void trUpdLog::set_has_size () {
    _has_bits_[0] |= 1u << 4;
}

inline void trUpdLog::clear_has_size () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void trUpdLog::set_has_success () {
    _has_bits_[0] |= 1u << 5;
}

inline void trUpdLog::clear_has_success () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void trUpdLog::set_has_counterKilometers () {
    _has_bits_[0] |= 1u << 6;
}

inline void trUpdLog::clear_has_counterKilometers () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline void trUpdLog::set_has_index () {
    _has_bits_[0] |= 1u << 7;
}

inline void trUpdLog::clear_has_index () {
    _has_bits_[0] &= ~ (1u << 7);
}

inline  trUpdLogs::trUpdLogs ()  :
    _updateLogs ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  trUpdLogs::trUpdLogs (const trUpdLogs &rhs)  :
    _updateLogs ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  trUpdLogs::trUpdLogs (const ::std::vector< trUpdLog >& updateLogs_)  :
    _updateLogs (updateLogs_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  trUpdLogs::~trUpdLogs() {
}

inline trUpdLogs& trUpdLogs::operator = (const trUpdLogs& rhs) {
    if( this != &rhs ) {
        if (rhs.hasUpdateLogs()) {
            setUpdateLogs(rhs.getUpdateLogs());
        } else {
            clearUpdateLogs();
        }
    }
    return *this;
}

inline bool trUpdLogs::operator == (const trUpdLogs& rhs) const {
    return (((!hasUpdateLogs() && !rhs.hasUpdateLogs()) || getUpdateLogs() == rhs.getUpdateLogs()));
}

inline bool trUpdLogs::operator != (const trUpdLogs& rhs) const {
    return ! (*this == rhs);
}

inline bool trUpdLogs::operator < (const trUpdLogs& rhs) const {
    if (hasUpdateLogs() || rhs.hasUpdateLogs()) {
        if (getUpdateLogs() < rhs.getUpdateLogs()) return true;
        if (getUpdateLogs() > rhs.getUpdateLogs()) return false;
    }
    return false;
}

inline bool trUpdLogs::operator > (const trUpdLogs& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void trUpdLogs::clear() {
    clearUpdateLogs();
}

inline void trUpdLogs::clearUpdateLogs() {
    if (hasUpdateLogs()) {
         clear_has_updateLogs();
        _updateLogs.clear();
     }
}

inline bool trUpdLogs::hasUpdateLogs () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< trUpdLog >& trUpdLogs::getUpdateLogs () const {
    return _updateLogs;
}

inline ::std::vector< trUpdLog >& trUpdLogs::getUpdateLogsMutable () {
    set_has_updateLogs();
    return _updateLogs;
}

inline void trUpdLogs::setUpdateLogs (const ::std::vector< trUpdLog >& updateLogs_) {
    set_has_updateLogs();
    this->_updateLogs = updateLogs_;
}

inline void trUpdLogs::set_has_updateLogs () {
    _has_bits_[0] |= 1u << 0;
}

inline void trUpdLogs::clear_has_updateLogs () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  trUpdateMedia::trUpdateMedia ()  :
    _bCustomerMediaPresent (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  trUpdateMedia::trUpdateMedia (const trUpdateMedia &rhs)  :
    _bCustomerMediaPresent (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  trUpdateMedia::trUpdateMedia (bool bCustomerMediaPresent_)  :
    _bCustomerMediaPresent (bCustomerMediaPresent_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  trUpdateMedia::~trUpdateMedia() {
}

inline trUpdateMedia& trUpdateMedia::operator = (const trUpdateMedia& rhs) {
    if( this != &rhs ) {
        if (rhs.hasBCustomerMediaPresent()) {
            setBCustomerMediaPresent(rhs.getBCustomerMediaPresent());
        } else {
            clearBCustomerMediaPresent();
        }
    }
    return *this;
}

inline bool trUpdateMedia::operator == (const trUpdateMedia& rhs) const {
    return (((!hasBCustomerMediaPresent() && !rhs.hasBCustomerMediaPresent()) || getBCustomerMediaPresent() == rhs.getBCustomerMediaPresent()));
}

inline bool trUpdateMedia::operator != (const trUpdateMedia& rhs) const {
    return ! (*this == rhs);
}

inline bool trUpdateMedia::operator < (const trUpdateMedia& rhs) const {
    if (hasBCustomerMediaPresent() || rhs.hasBCustomerMediaPresent()) {
        if (getBCustomerMediaPresent() < rhs.getBCustomerMediaPresent()) return true;
        if (getBCustomerMediaPresent() > rhs.getBCustomerMediaPresent()) return false;
    }
    return false;
}

inline bool trUpdateMedia::operator > (const trUpdateMedia& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void trUpdateMedia::clear() {
    clearBCustomerMediaPresent();
}

inline void trUpdateMedia::clearBCustomerMediaPresent() {
    if (hasBCustomerMediaPresent()) {
         clear_has_bCustomerMediaPresent();
        _bCustomerMediaPresent = false;
     }
}

inline bool trUpdateMedia::hasBCustomerMediaPresent () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool trUpdateMedia::getBCustomerMediaPresent () const {
    return _bCustomerMediaPresent;
}

inline void trUpdateMedia::setBCustomerMediaPresent (bool bCustomerMediaPresent_) {
    set_has_bCustomerMediaPresent();
    this->_bCustomerMediaPresent = bCustomerMediaPresent_;
}

inline void trUpdateMedia::set_has_bCustomerMediaPresent () {
    _has_bits_[0] |= 1u << 0;
}

inline void trUpdateMedia::clear_has_bCustomerMediaPresent () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  trVersionBackDocInfo::trVersionBackDocInfo ()  :
    _u16Key (0u),
    _ackOk (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  trVersionBackDocInfo::trVersionBackDocInfo (const trVersionBackDocInfo &rhs)  :
    _u16Key (0u),
    _ackOk (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  trVersionBackDocInfo::trVersionBackDocInfo (uint16 u16Key_, bool ackOk_)  :
    _u16Key (u16Key_),
    _ackOk (ackOk_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  trVersionBackDocInfo::~trVersionBackDocInfo() {
}

inline trVersionBackDocInfo& trVersionBackDocInfo::operator = (const trVersionBackDocInfo& rhs) {
    if( this != &rhs ) {
        if (rhs.hasU16Key()) {
            setU16Key(rhs.getU16Key());
        } else {
            clearU16Key();
        }
        if (rhs.hasAckOk()) {
            setAckOk(rhs.getAckOk());
        } else {
            clearAckOk();
        }
    }
    return *this;
}

inline bool trVersionBackDocInfo::operator == (const trVersionBackDocInfo& rhs) const {
    return (((!hasU16Key() && !rhs.hasU16Key()) || getU16Key() == rhs.getU16Key()) &&
        ((!hasAckOk() && !rhs.hasAckOk()) || getAckOk() == rhs.getAckOk()));
}

inline bool trVersionBackDocInfo::operator != (const trVersionBackDocInfo& rhs) const {
    return ! (*this == rhs);
}

inline bool trVersionBackDocInfo::operator < (const trVersionBackDocInfo& rhs) const {
    if (hasU16Key() || rhs.hasU16Key()) {
        if (getU16Key() < rhs.getU16Key()) return true;
        if (getU16Key() > rhs.getU16Key()) return false;
    }
    if (hasAckOk() || rhs.hasAckOk()) {
        if (getAckOk() < rhs.getAckOk()) return true;
        if (getAckOk() > rhs.getAckOk()) return false;
    }
    return false;
}

inline bool trVersionBackDocInfo::operator > (const trVersionBackDocInfo& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void trVersionBackDocInfo::clear() {
    clearU16Key();
    clearAckOk();
}

inline void trVersionBackDocInfo::clearU16Key() {
    if (hasU16Key()) {
         clear_has_u16Key();
        _u16Key = 0u;
     }
}

inline bool trVersionBackDocInfo::hasU16Key () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint16 trVersionBackDocInfo::getU16Key () const {
    return _u16Key;
}

inline void trVersionBackDocInfo::setU16Key (uint16 u16Key_) {
    set_has_u16Key();
    this->_u16Key = u16Key_;
}

inline void trVersionBackDocInfo::clearAckOk() {
    if (hasAckOk()) {
         clear_has_ackOk();
        _ackOk = false;
     }
}

inline bool trVersionBackDocInfo::hasAckOk () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline bool trVersionBackDocInfo::getAckOk () const {
    return _ackOk;
}

inline void trVersionBackDocInfo::setAckOk (bool ackOk_) {
    set_has_ackOk();
    this->_ackOk = ackOk_;
}

inline void trVersionBackDocInfo::set_has_u16Key () {
    _has_bits_[0] |= 1u << 0;
}

inline void trVersionBackDocInfo::clear_has_u16Key () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void trVersionBackDocInfo::set_has_ackOk () {
    _has_bits_[0] |= 1u << 1;
}

inline void trVersionBackDocInfo::clear_has_ackOk () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  trCustomerUpdate::trCustomerUpdate ()  :
    _device (),
    _name (),
    _vers (),
    _bOk (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  trCustomerUpdate::trCustomerUpdate (const trCustomerUpdate &rhs)  :
    _device (),
    _name (),
    _vers (),
    _bOk (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  trCustomerUpdate::trCustomerUpdate (const ::std::string& device_, const ::std::string& name_, const ::std::string& vers_, bool bOk_)  :
    _device (device_),
    _name (name_),
    _vers (vers_),
    _bOk (bOk_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (device_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (name_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (vers_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  trCustomerUpdate::~trCustomerUpdate() {
}

inline trCustomerUpdate& trCustomerUpdate::operator = (const trCustomerUpdate& rhs) {
    if( this != &rhs ) {
        if (rhs.hasDevice()) {
            setDevice(rhs.getDevice());
        } else {
            clearDevice();
        }
        if (rhs.hasName()) {
            setName(rhs.getName());
        } else {
            clearName();
        }
        if (rhs.hasVers()) {
            setVers(rhs.getVers());
        } else {
            clearVers();
        }
        if (rhs.hasBOk()) {
            setBOk(rhs.getBOk());
        } else {
            clearBOk();
        }
    }
    return *this;
}

inline bool trCustomerUpdate::operator == (const trCustomerUpdate& rhs) const {
    return (((!hasDevice() && !rhs.hasDevice()) || getDevice() == rhs.getDevice()) &&
        ((!hasName() && !rhs.hasName()) || getName() == rhs.getName()) &&
        ((!hasVers() && !rhs.hasVers()) || getVers() == rhs.getVers()) &&
        ((!hasBOk() && !rhs.hasBOk()) || getBOk() == rhs.getBOk()));
}

inline bool trCustomerUpdate::operator != (const trCustomerUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool trCustomerUpdate::operator < (const trCustomerUpdate& rhs) const {
    if (hasDevice() || rhs.hasDevice()) {
        if (getDevice() < rhs.getDevice()) return true;
        if (getDevice() > rhs.getDevice()) return false;
    }
    if (hasName() || rhs.hasName()) {
        if (getName() < rhs.getName()) return true;
        if (getName() > rhs.getName()) return false;
    }
    if (hasVers() || rhs.hasVers()) {
        if (getVers() < rhs.getVers()) return true;
        if (getVers() > rhs.getVers()) return false;
    }
    if (hasBOk() || rhs.hasBOk()) {
        if (getBOk() < rhs.getBOk()) return true;
        if (getBOk() > rhs.getBOk()) return false;
    }
    return false;
}

inline bool trCustomerUpdate::operator > (const trCustomerUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void trCustomerUpdate::clear() {
    clearDevice();
    clearName();
    clearVers();
    clearBOk();
}

inline void trCustomerUpdate::clearDevice() {
    if (hasDevice()) {
         clear_has_device();
        _device.clear();
     }
}

inline bool trCustomerUpdate::hasDevice () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& trCustomerUpdate::getDevice () const {
    return _device;
}

inline ::std::string& trCustomerUpdate::getDeviceMutable () {
    set_has_device();
    return _device;
}

inline void trCustomerUpdate::setDevice (const ::std::string& device_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (device_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_device();
    this->_device = device_;
}

inline void trCustomerUpdate::setDevice (const char* device_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (device_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_device();
    this->_device.assign(device_);
}

inline void trCustomerUpdate::setDevice (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_device();
    this->_device.assign(value, size);
}

inline void trCustomerUpdate::clearName() {
    if (hasName()) {
         clear_has_name();
        _name.clear();
     }
}

inline bool trCustomerUpdate::hasName () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& trCustomerUpdate::getName () const {
    return _name;
}

inline ::std::string& trCustomerUpdate::getNameMutable () {
    set_has_name();
    return _name;
}

inline void trCustomerUpdate::setName (const ::std::string& name_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (name_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_name();
    this->_name = name_;
}

inline void trCustomerUpdate::setName (const char* name_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (name_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_name();
    this->_name.assign(name_);
}

inline void trCustomerUpdate::setName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_name();
    this->_name.assign(value, size);
}

inline void trCustomerUpdate::clearVers() {
    if (hasVers()) {
         clear_has_vers();
        _vers.clear();
     }
}

inline bool trCustomerUpdate::hasVers () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::string& trCustomerUpdate::getVers () const {
    return _vers;
}

inline ::std::string& trCustomerUpdate::getVersMutable () {
    set_has_vers();
    return _vers;
}

inline void trCustomerUpdate::setVers (const ::std::string& vers_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (vers_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_vers();
    this->_vers = vers_;
}

inline void trCustomerUpdate::setVers (const char* vers_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (vers_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_vers();
    this->_vers.assign(vers_);
}

inline void trCustomerUpdate::setVers (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_vers();
    this->_vers.assign(value, size);
}

inline void trCustomerUpdate::clearBOk() {
    if (hasBOk()) {
         clear_has_bOk();
        _bOk = false;
     }
}

inline bool trCustomerUpdate::hasBOk () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline bool trCustomerUpdate::getBOk () const {
    return _bOk;
}

inline void trCustomerUpdate::setBOk (bool bOk_) {
    set_has_bOk();
    this->_bOk = bOk_;
}

inline void trCustomerUpdate::set_has_device () {
    _has_bits_[0] |= 1u << 0;
}

inline void trCustomerUpdate::clear_has_device () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void trCustomerUpdate::set_has_name () {
    _has_bits_[0] |= 1u << 1;
}

inline void trCustomerUpdate::clear_has_name () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void trCustomerUpdate::set_has_vers () {
    _has_bits_[0] |= 1u << 2;
}

inline void trCustomerUpdate::clear_has_vers () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void trCustomerUpdate::set_has_bOk () {
    _has_bits_[0] |= 1u << 3;
}

inline void trCustomerUpdate::clear_has_bOk () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  trAvailableCustomerUpdates::trAvailableCustomerUpdates ()  :
    _enErrorId (::fcswupdatesrv::FcSwUpdateSrv::tenErrorId__SWL_OK),
    _updates ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  trAvailableCustomerUpdates::trAvailableCustomerUpdates (const trAvailableCustomerUpdates &rhs)  :
    _enErrorId (::fcswupdatesrv::FcSwUpdateSrv::tenErrorId__SWL_OK),
    _updates ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  trAvailableCustomerUpdates::trAvailableCustomerUpdates (tenErrorId enErrorId_, const ::std::vector< trCustomerUpdate >& updates_)  :
    _enErrorId (enErrorId_),
    _updates (updates_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(tenErrorId_IsValid(enErrorId_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", enErrorId_, "tenErrorId", "enErrorId", "trAvailableCustomerUpdates");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  trAvailableCustomerUpdates::~trAvailableCustomerUpdates() {
}

inline trAvailableCustomerUpdates& trAvailableCustomerUpdates::operator = (const trAvailableCustomerUpdates& rhs) {
    if( this != &rhs ) {
        if (rhs.hasEnErrorId()) {
            setEnErrorId(rhs.getEnErrorId());
        } else {
            clearEnErrorId();
        }
        if (rhs.hasUpdates()) {
            setUpdates(rhs.getUpdates());
        } else {
            clearUpdates();
        }
    }
    return *this;
}

inline bool trAvailableCustomerUpdates::operator == (const trAvailableCustomerUpdates& rhs) const {
    return (((!hasEnErrorId() && !rhs.hasEnErrorId()) || getEnErrorId() == rhs.getEnErrorId()) &&
        ((!hasUpdates() && !rhs.hasUpdates()) || getUpdates() == rhs.getUpdates()));
}

inline bool trAvailableCustomerUpdates::operator != (const trAvailableCustomerUpdates& rhs) const {
    return ! (*this == rhs);
}

inline bool trAvailableCustomerUpdates::operator < (const trAvailableCustomerUpdates& rhs) const {
    if (hasEnErrorId() || rhs.hasEnErrorId()) {
        if ((uint32)getEnErrorId() < (uint32)rhs.getEnErrorId()) return true;
        if ((uint32)getEnErrorId() > (uint32)rhs.getEnErrorId()) return false;
    }
    if (hasUpdates() || rhs.hasUpdates()) {
        if (getUpdates() < rhs.getUpdates()) return true;
        if (getUpdates() > rhs.getUpdates()) return false;
    }
    return false;
}

inline bool trAvailableCustomerUpdates::operator > (const trAvailableCustomerUpdates& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void trAvailableCustomerUpdates::clear() {
    clearEnErrorId();
    clearUpdates();
}

inline void trAvailableCustomerUpdates::clearEnErrorId() {
    if (hasEnErrorId()) {
         clear_has_enErrorId();
        _enErrorId = ::fcswupdatesrv::FcSwUpdateSrv::tenErrorId__SWL_OK;
     }
}

inline bool trAvailableCustomerUpdates::hasEnErrorId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline tenErrorId trAvailableCustomerUpdates::getEnErrorId () const {
    return _enErrorId;
}

inline void trAvailableCustomerUpdates::setEnErrorId (tenErrorId enErrorId_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(tenErrorId_IsValid(enErrorId_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", enErrorId_, "tenErrorId", "enErrorId", "trAvailableCustomerUpdates");
    }
    set_has_enErrorId();
    this->_enErrorId = enErrorId_;
}

inline void trAvailableCustomerUpdates::clearUpdates() {
    if (hasUpdates()) {
         clear_has_updates();
        _updates.clear();
     }
}

inline bool trAvailableCustomerUpdates::hasUpdates () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::vector< trCustomerUpdate >& trAvailableCustomerUpdates::getUpdates () const {
    return _updates;
}

inline ::std::vector< trCustomerUpdate >& trAvailableCustomerUpdates::getUpdatesMutable () {
    set_has_updates();
    return _updates;
}

inline void trAvailableCustomerUpdates::setUpdates (const ::std::vector< trCustomerUpdate >& updates_) {
    set_has_updates();
    this->_updates = updates_;
}

inline void trAvailableCustomerUpdates::set_has_enErrorId () {
    _has_bits_[0] |= 1u << 0;
}

inline void trAvailableCustomerUpdates::clear_has_enErrorId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void trAvailableCustomerUpdates::set_has_updates () {
    _has_bits_[0] |= 1u << 1;
}

inline void trAvailableCustomerUpdates::clear_has_updates () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  trInstalledCustomerUpdates::trInstalledCustomerUpdates ()  :
    _bUpdateExists (false),
    _bHasFailedUpdate (false),
    _updates ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  trInstalledCustomerUpdates::trInstalledCustomerUpdates (const trInstalledCustomerUpdates &rhs)  :
    _bUpdateExists (false),
    _bHasFailedUpdate (false),
    _updates ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  trInstalledCustomerUpdates::trInstalledCustomerUpdates (bool bUpdateExists_, bool bHasFailedUpdate_, const ::std::vector< trCustomerUpdate >& updates_)  :
    _bUpdateExists (bUpdateExists_),
    _bHasFailedUpdate (bHasFailedUpdate_),
    _updates (updates_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  trInstalledCustomerUpdates::~trInstalledCustomerUpdates() {
}

inline trInstalledCustomerUpdates& trInstalledCustomerUpdates::operator = (const trInstalledCustomerUpdates& rhs) {
    if( this != &rhs ) {
        if (rhs.hasBUpdateExists()) {
            setBUpdateExists(rhs.getBUpdateExists());
        } else {
            clearBUpdateExists();
        }
        if (rhs.hasBHasFailedUpdate()) {
            setBHasFailedUpdate(rhs.getBHasFailedUpdate());
        } else {
            clearBHasFailedUpdate();
        }
        if (rhs.hasUpdates()) {
            setUpdates(rhs.getUpdates());
        } else {
            clearUpdates();
        }
    }
    return *this;
}

inline bool trInstalledCustomerUpdates::operator == (const trInstalledCustomerUpdates& rhs) const {
    return (((!hasBUpdateExists() && !rhs.hasBUpdateExists()) || getBUpdateExists() == rhs.getBUpdateExists()) &&
        ((!hasBHasFailedUpdate() && !rhs.hasBHasFailedUpdate()) || getBHasFailedUpdate() == rhs.getBHasFailedUpdate()) &&
        ((!hasUpdates() && !rhs.hasUpdates()) || getUpdates() == rhs.getUpdates()));
}

inline bool trInstalledCustomerUpdates::operator != (const trInstalledCustomerUpdates& rhs) const {
    return ! (*this == rhs);
}

inline bool trInstalledCustomerUpdates::operator < (const trInstalledCustomerUpdates& rhs) const {
    if (hasBUpdateExists() || rhs.hasBUpdateExists()) {
        if (getBUpdateExists() < rhs.getBUpdateExists()) return true;
        if (getBUpdateExists() > rhs.getBUpdateExists()) return false;
    }
    if (hasBHasFailedUpdate() || rhs.hasBHasFailedUpdate()) {
        if (getBHasFailedUpdate() < rhs.getBHasFailedUpdate()) return true;
        if (getBHasFailedUpdate() > rhs.getBHasFailedUpdate()) return false;
    }
    if (hasUpdates() || rhs.hasUpdates()) {
        if (getUpdates() < rhs.getUpdates()) return true;
        if (getUpdates() > rhs.getUpdates()) return false;
    }
    return false;
}

inline bool trInstalledCustomerUpdates::operator > (const trInstalledCustomerUpdates& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void trInstalledCustomerUpdates::clear() {
    clearBUpdateExists();
    clearBHasFailedUpdate();
    clearUpdates();
}

inline void trInstalledCustomerUpdates::clearBUpdateExists() {
    if (hasBUpdateExists()) {
         clear_has_bUpdateExists();
        _bUpdateExists = false;
     }
}

inline bool trInstalledCustomerUpdates::hasBUpdateExists () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool trInstalledCustomerUpdates::getBUpdateExists () const {
    return _bUpdateExists;
}

inline void trInstalledCustomerUpdates::setBUpdateExists (bool bUpdateExists_) {
    set_has_bUpdateExists();
    this->_bUpdateExists = bUpdateExists_;
}

inline void trInstalledCustomerUpdates::clearBHasFailedUpdate() {
    if (hasBHasFailedUpdate()) {
         clear_has_bHasFailedUpdate();
        _bHasFailedUpdate = false;
     }
}

inline bool trInstalledCustomerUpdates::hasBHasFailedUpdate () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline bool trInstalledCustomerUpdates::getBHasFailedUpdate () const {
    return _bHasFailedUpdate;
}

inline void trInstalledCustomerUpdates::setBHasFailedUpdate (bool bHasFailedUpdate_) {
    set_has_bHasFailedUpdate();
    this->_bHasFailedUpdate = bHasFailedUpdate_;
}

inline void trInstalledCustomerUpdates::clearUpdates() {
    if (hasUpdates()) {
         clear_has_updates();
        _updates.clear();
     }
}

inline bool trInstalledCustomerUpdates::hasUpdates () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::vector< trCustomerUpdate >& trInstalledCustomerUpdates::getUpdates () const {
    return _updates;
}

inline ::std::vector< trCustomerUpdate >& trInstalledCustomerUpdates::getUpdatesMutable () {
    set_has_updates();
    return _updates;
}

inline void trInstalledCustomerUpdates::setUpdates (const ::std::vector< trCustomerUpdate >& updates_) {
    set_has_updates();
    this->_updates = updates_;
}

inline void trInstalledCustomerUpdates::set_has_bUpdateExists () {
    _has_bits_[0] |= 1u << 0;
}

inline void trInstalledCustomerUpdates::clear_has_bUpdateExists () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void trInstalledCustomerUpdates::set_has_bHasFailedUpdate () {
    _has_bits_[0] |= 1u << 1;
}

inline void trInstalledCustomerUpdates::clear_has_bHasFailedUpdate () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void trInstalledCustomerUpdates::set_has_updates () {
    _has_bits_[0] |= 1u << 2;
}

inline void trInstalledCustomerUpdates::clear_has_updates () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  trCustomerUpdates::trCustomerUpdates ()  :
    _updates ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  trCustomerUpdates::trCustomerUpdates (const trCustomerUpdates &rhs)  :
    _updates ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  trCustomerUpdates::trCustomerUpdates (const ::std::vector< trCustomerUpdate >& updates_)  :
    _updates (updates_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  trCustomerUpdates::~trCustomerUpdates() {
}

inline trCustomerUpdates& trCustomerUpdates::operator = (const trCustomerUpdates& rhs) {
    if( this != &rhs ) {
        if (rhs.hasUpdates()) {
            setUpdates(rhs.getUpdates());
        } else {
            clearUpdates();
        }
    }
    return *this;
}

inline bool trCustomerUpdates::operator == (const trCustomerUpdates& rhs) const {
    return (((!hasUpdates() && !rhs.hasUpdates()) || getUpdates() == rhs.getUpdates()));
}

inline bool trCustomerUpdates::operator != (const trCustomerUpdates& rhs) const {
    return ! (*this == rhs);
}

inline bool trCustomerUpdates::operator < (const trCustomerUpdates& rhs) const {
    if (hasUpdates() || rhs.hasUpdates()) {
        if (getUpdates() < rhs.getUpdates()) return true;
        if (getUpdates() > rhs.getUpdates()) return false;
    }
    return false;
}

inline bool trCustomerUpdates::operator > (const trCustomerUpdates& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void trCustomerUpdates::clear() {
    clearUpdates();
}

inline void trCustomerUpdates::clearUpdates() {
    if (hasUpdates()) {
         clear_has_updates();
        _updates.clear();
     }
}

inline bool trCustomerUpdates::hasUpdates () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< trCustomerUpdate >& trCustomerUpdates::getUpdates () const {
    return _updates;
}

inline ::std::vector< trCustomerUpdate >& trCustomerUpdates::getUpdatesMutable () {
    set_has_updates();
    return _updates;
}

inline void trCustomerUpdates::setUpdates (const ::std::vector< trCustomerUpdate >& updates_) {
    set_has_updates();
    this->_updates = updates_;
}

inline void trCustomerUpdates::set_has_updates () {
    _has_bits_[0] |= 1u << 0;
}

inline void trCustomerUpdates::clear_has_updates () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  trBgImageInfo::trBgImageInfo ()  :
    _imgDirPath (),
    _imgName ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  trBgImageInfo::trBgImageInfo (const trBgImageInfo &rhs)  :
    _imgDirPath (),
    _imgName ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  trBgImageInfo::trBgImageInfo (const ::std::string& imgDirPath_, const ::std::string& imgName_)  :
    _imgDirPath (imgDirPath_),
    _imgName (imgName_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (imgDirPath_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (imgName_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  trBgImageInfo::~trBgImageInfo() {
}

inline trBgImageInfo& trBgImageInfo::operator = (const trBgImageInfo& rhs) {
    if( this != &rhs ) {
        if (rhs.hasImgDirPath()) {
            setImgDirPath(rhs.getImgDirPath());
        } else {
            clearImgDirPath();
        }
        if (rhs.hasImgName()) {
            setImgName(rhs.getImgName());
        } else {
            clearImgName();
        }
    }
    return *this;
}

inline bool trBgImageInfo::operator == (const trBgImageInfo& rhs) const {
    return (((!hasImgDirPath() && !rhs.hasImgDirPath()) || getImgDirPath() == rhs.getImgDirPath()) &&
        ((!hasImgName() && !rhs.hasImgName()) || getImgName() == rhs.getImgName()));
}

inline bool trBgImageInfo::operator != (const trBgImageInfo& rhs) const {
    return ! (*this == rhs);
}

inline bool trBgImageInfo::operator < (const trBgImageInfo& rhs) const {
    if (hasImgDirPath() || rhs.hasImgDirPath()) {
        if (getImgDirPath() < rhs.getImgDirPath()) return true;
        if (getImgDirPath() > rhs.getImgDirPath()) return false;
    }
    if (hasImgName() || rhs.hasImgName()) {
        if (getImgName() < rhs.getImgName()) return true;
        if (getImgName() > rhs.getImgName()) return false;
    }
    return false;
}

inline bool trBgImageInfo::operator > (const trBgImageInfo& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void trBgImageInfo::clear() {
    clearImgDirPath();
    clearImgName();
}

inline void trBgImageInfo::clearImgDirPath() {
    if (hasImgDirPath()) {
         clear_has_imgDirPath();
        _imgDirPath.clear();
     }
}

inline bool trBgImageInfo::hasImgDirPath () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& trBgImageInfo::getImgDirPath () const {
    return _imgDirPath;
}

inline ::std::string& trBgImageInfo::getImgDirPathMutable () {
    set_has_imgDirPath();
    return _imgDirPath;
}

inline void trBgImageInfo::setImgDirPath (const ::std::string& imgDirPath_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (imgDirPath_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_imgDirPath();
    this->_imgDirPath = imgDirPath_;
}

inline void trBgImageInfo::setImgDirPath (const char* imgDirPath_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (imgDirPath_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_imgDirPath();
    this->_imgDirPath.assign(imgDirPath_);
}

inline void trBgImageInfo::setImgDirPath (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_imgDirPath();
    this->_imgDirPath.assign(value, size);
}

inline void trBgImageInfo::clearImgName() {
    if (hasImgName()) {
         clear_has_imgName();
        _imgName.clear();
     }
}

inline bool trBgImageInfo::hasImgName () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& trBgImageInfo::getImgName () const {
    return _imgName;
}

inline ::std::string& trBgImageInfo::getImgNameMutable () {
    set_has_imgName();
    return _imgName;
}

inline void trBgImageInfo::setImgName (const ::std::string& imgName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (imgName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_imgName();
    this->_imgName = imgName_;
}

inline void trBgImageInfo::setImgName (const char* imgName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (imgName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_imgName();
    this->_imgName.assign(imgName_);
}

inline void trBgImageInfo::setImgName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_imgName();
    this->_imgName.assign(value, size);
}

inline void trBgImageInfo::set_has_imgDirPath () {
    _has_bits_[0] |= 1u << 0;
}

inline void trBgImageInfo::clear_has_imgDirPath () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void trBgImageInfo::set_has_imgName () {
    _has_bits_[0] |= 1u << 1;
}

inline void trBgImageInfo::clear_has_imgName () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  trFontInfo::trFontInfo ()  :
    _fontName (),
    _fontSrcLocation (),
    _checkSum ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  trFontInfo::trFontInfo (const trFontInfo &rhs)  :
    _fontName (),
    _fontSrcLocation (),
    _checkSum ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  trFontInfo::trFontInfo (const ::std::string& fontName_, const ::std::string& fontSrcLocation_, const ::std::string& checkSum_)  :
    _fontName (fontName_),
    _fontSrcLocation (fontSrcLocation_),
    _checkSum (checkSum_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (fontName_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (fontSrcLocation_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (checkSum_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  trFontInfo::~trFontInfo() {
}

inline trFontInfo& trFontInfo::operator = (const trFontInfo& rhs) {
    if( this != &rhs ) {
        if (rhs.hasFontName()) {
            setFontName(rhs.getFontName());
        } else {
            clearFontName();
        }
        if (rhs.hasFontSrcLocation()) {
            setFontSrcLocation(rhs.getFontSrcLocation());
        } else {
            clearFontSrcLocation();
        }
        if (rhs.hasCheckSum()) {
            setCheckSum(rhs.getCheckSum());
        } else {
            clearCheckSum();
        }
    }
    return *this;
}

inline bool trFontInfo::operator == (const trFontInfo& rhs) const {
    return (((!hasFontName() && !rhs.hasFontName()) || getFontName() == rhs.getFontName()) &&
        ((!hasFontSrcLocation() && !rhs.hasFontSrcLocation()) || getFontSrcLocation() == rhs.getFontSrcLocation()) &&
        ((!hasCheckSum() && !rhs.hasCheckSum()) || getCheckSum() == rhs.getCheckSum()));
}

inline bool trFontInfo::operator != (const trFontInfo& rhs) const {
    return ! (*this == rhs);
}

inline bool trFontInfo::operator < (const trFontInfo& rhs) const {
    if (hasFontName() || rhs.hasFontName()) {
        if (getFontName() < rhs.getFontName()) return true;
        if (getFontName() > rhs.getFontName()) return false;
    }
    if (hasFontSrcLocation() || rhs.hasFontSrcLocation()) {
        if (getFontSrcLocation() < rhs.getFontSrcLocation()) return true;
        if (getFontSrcLocation() > rhs.getFontSrcLocation()) return false;
    }
    if (hasCheckSum() || rhs.hasCheckSum()) {
        if (getCheckSum() < rhs.getCheckSum()) return true;
        if (getCheckSum() > rhs.getCheckSum()) return false;
    }
    return false;
}

inline bool trFontInfo::operator > (const trFontInfo& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void trFontInfo::clear() {
    clearFontName();
    clearFontSrcLocation();
    clearCheckSum();
}

inline void trFontInfo::clearFontName() {
    if (hasFontName()) {
         clear_has_fontName();
        _fontName.clear();
     }
}

inline bool trFontInfo::hasFontName () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& trFontInfo::getFontName () const {
    return _fontName;
}

inline ::std::string& trFontInfo::getFontNameMutable () {
    set_has_fontName();
    return _fontName;
}

inline void trFontInfo::setFontName (const ::std::string& fontName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (fontName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_fontName();
    this->_fontName = fontName_;
}

inline void trFontInfo::setFontName (const char* fontName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (fontName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_fontName();
    this->_fontName.assign(fontName_);
}

inline void trFontInfo::setFontName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_fontName();
    this->_fontName.assign(value, size);
}

inline void trFontInfo::clearFontSrcLocation() {
    if (hasFontSrcLocation()) {
         clear_has_fontSrcLocation();
        _fontSrcLocation.clear();
     }
}

inline bool trFontInfo::hasFontSrcLocation () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& trFontInfo::getFontSrcLocation () const {
    return _fontSrcLocation;
}

inline ::std::string& trFontInfo::getFontSrcLocationMutable () {
    set_has_fontSrcLocation();
    return _fontSrcLocation;
}

inline void trFontInfo::setFontSrcLocation (const ::std::string& fontSrcLocation_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (fontSrcLocation_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_fontSrcLocation();
    this->_fontSrcLocation = fontSrcLocation_;
}

inline void trFontInfo::setFontSrcLocation (const char* fontSrcLocation_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (fontSrcLocation_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_fontSrcLocation();
    this->_fontSrcLocation.assign(fontSrcLocation_);
}

inline void trFontInfo::setFontSrcLocation (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_fontSrcLocation();
    this->_fontSrcLocation.assign(value, size);
}

inline void trFontInfo::clearCheckSum() {
    if (hasCheckSum()) {
         clear_has_checkSum();
        _checkSum.clear();
     }
}

inline bool trFontInfo::hasCheckSum () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::string& trFontInfo::getCheckSum () const {
    return _checkSum;
}

inline ::std::string& trFontInfo::getCheckSumMutable () {
    set_has_checkSum();
    return _checkSum;
}

inline void trFontInfo::setCheckSum (const ::std::string& checkSum_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (checkSum_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_checkSum();
    this->_checkSum = checkSum_;
}

inline void trFontInfo::setCheckSum (const char* checkSum_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (checkSum_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_checkSum();
    this->_checkSum.assign(checkSum_);
}

inline void trFontInfo::setCheckSum (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_checkSum();
    this->_checkSum.assign(value, size);
}

inline void trFontInfo::set_has_fontName () {
    _has_bits_[0] |= 1u << 0;
}

inline void trFontInfo::clear_has_fontName () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void trFontInfo::set_has_fontSrcLocation () {
    _has_bits_[0] |= 1u << 1;
}

inline void trFontInfo::clear_has_fontSrcLocation () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void trFontInfo::set_has_checkSum () {
    _has_bits_[0] |= 1u << 2;
}

inline void trFontInfo::clear_has_checkSum () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  trDisplayVariant::trDisplayVariant ()  :
    _enDisplayVariant (::fcswupdatesrv::FcSwUpdateSrv::tenDisplayVariant__Invalid),
    _width (0u),
    _height (0u),
    _aspectRatio ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  trDisplayVariant::trDisplayVariant (const trDisplayVariant &rhs)  :
    _enDisplayVariant (::fcswupdatesrv::FcSwUpdateSrv::tenDisplayVariant__Invalid),
    _width (0u),
    _height (0u),
    _aspectRatio ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  trDisplayVariant::trDisplayVariant (tenDisplayVariant enDisplayVariant_, uint32 width_, uint32 height_, const ::std::string& aspectRatio_)  :
    _enDisplayVariant (enDisplayVariant_),
    _width (width_),
    _height (height_),
    _aspectRatio (aspectRatio_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(tenDisplayVariant_IsValid(enDisplayVariant_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", enDisplayVariant_, "tenDisplayVariant", "enDisplayVariant", "trDisplayVariant");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (aspectRatio_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  trDisplayVariant::~trDisplayVariant() {
}

inline trDisplayVariant& trDisplayVariant::operator = (const trDisplayVariant& rhs) {
    if( this != &rhs ) {
        if (rhs.hasEnDisplayVariant()) {
            setEnDisplayVariant(rhs.getEnDisplayVariant());
        } else {
            clearEnDisplayVariant();
        }
        if (rhs.hasWidth()) {
            setWidth(rhs.getWidth());
        } else {
            clearWidth();
        }
        if (rhs.hasHeight()) {
            setHeight(rhs.getHeight());
        } else {
            clearHeight();
        }
        if (rhs.hasAspectRatio()) {
            setAspectRatio(rhs.getAspectRatio());
        } else {
            clearAspectRatio();
        }
    }
    return *this;
}

inline bool trDisplayVariant::operator == (const trDisplayVariant& rhs) const {
    return (((!hasEnDisplayVariant() && !rhs.hasEnDisplayVariant()) || getEnDisplayVariant() == rhs.getEnDisplayVariant()) &&
        ((!hasWidth() && !rhs.hasWidth()) || getWidth() == rhs.getWidth()) &&
        ((!hasHeight() && !rhs.hasHeight()) || getHeight() == rhs.getHeight()) &&
        ((!hasAspectRatio() && !rhs.hasAspectRatio()) || getAspectRatio() == rhs.getAspectRatio()));
}

inline bool trDisplayVariant::operator != (const trDisplayVariant& rhs) const {
    return ! (*this == rhs);
}

inline bool trDisplayVariant::operator < (const trDisplayVariant& rhs) const {
    if (hasEnDisplayVariant() || rhs.hasEnDisplayVariant()) {
        if ((uint32)getEnDisplayVariant() < (uint32)rhs.getEnDisplayVariant()) return true;
        if ((uint32)getEnDisplayVariant() > (uint32)rhs.getEnDisplayVariant()) return false;
    }
    if (hasWidth() || rhs.hasWidth()) {
        if (getWidth() < rhs.getWidth()) return true;
        if (getWidth() > rhs.getWidth()) return false;
    }
    if (hasHeight() || rhs.hasHeight()) {
        if (getHeight() < rhs.getHeight()) return true;
        if (getHeight() > rhs.getHeight()) return false;
    }
    if (hasAspectRatio() || rhs.hasAspectRatio()) {
        if (getAspectRatio() < rhs.getAspectRatio()) return true;
        if (getAspectRatio() > rhs.getAspectRatio()) return false;
    }
    return false;
}

inline bool trDisplayVariant::operator > (const trDisplayVariant& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void trDisplayVariant::clear() {
    clearEnDisplayVariant();
    clearWidth();
    clearHeight();
    clearAspectRatio();
}

inline void trDisplayVariant::clearEnDisplayVariant() {
    if (hasEnDisplayVariant()) {
         clear_has_enDisplayVariant();
        _enDisplayVariant = ::fcswupdatesrv::FcSwUpdateSrv::tenDisplayVariant__Invalid;
     }
}

inline bool trDisplayVariant::hasEnDisplayVariant () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline tenDisplayVariant trDisplayVariant::getEnDisplayVariant () const {
    return _enDisplayVariant;
}

inline void trDisplayVariant::setEnDisplayVariant (tenDisplayVariant enDisplayVariant_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(tenDisplayVariant_IsValid(enDisplayVariant_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", enDisplayVariant_, "tenDisplayVariant", "enDisplayVariant", "trDisplayVariant");
    }
    set_has_enDisplayVariant();
    this->_enDisplayVariant = enDisplayVariant_;
}

inline void trDisplayVariant::clearWidth() {
    if (hasWidth()) {
         clear_has_width();
        _width = 0u;
     }
}

inline bool trDisplayVariant::hasWidth () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 trDisplayVariant::getWidth () const {
    return _width;
}

inline void trDisplayVariant::setWidth (uint32 width_) {
    set_has_width();
    this->_width = width_;
}

inline void trDisplayVariant::clearHeight() {
    if (hasHeight()) {
         clear_has_height();
        _height = 0u;
     }
}

inline bool trDisplayVariant::hasHeight () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint32 trDisplayVariant::getHeight () const {
    return _height;
}

inline void trDisplayVariant::setHeight (uint32 height_) {
    set_has_height();
    this->_height = height_;
}

inline void trDisplayVariant::clearAspectRatio() {
    if (hasAspectRatio()) {
         clear_has_aspectRatio();
        _aspectRatio.clear();
     }
}

inline bool trDisplayVariant::hasAspectRatio () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const ::std::string& trDisplayVariant::getAspectRatio () const {
    return _aspectRatio;
}

inline ::std::string& trDisplayVariant::getAspectRatioMutable () {
    set_has_aspectRatio();
    return _aspectRatio;
}

inline void trDisplayVariant::setAspectRatio (const ::std::string& aspectRatio_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (aspectRatio_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_aspectRatio();
    this->_aspectRatio = aspectRatio_;
}

inline void trDisplayVariant::setAspectRatio (const char* aspectRatio_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (aspectRatio_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_aspectRatio();
    this->_aspectRatio.assign(aspectRatio_);
}

inline void trDisplayVariant::setAspectRatio (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_aspectRatio();
    this->_aspectRatio.assign(value, size);
}

inline void trDisplayVariant::set_has_enDisplayVariant () {
    _has_bits_[0] |= 1u << 0;
}

inline void trDisplayVariant::clear_has_enDisplayVariant () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void trDisplayVariant::set_has_width () {
    _has_bits_[0] |= 1u << 1;
}

inline void trDisplayVariant::clear_has_width () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void trDisplayVariant::set_has_height () {
    _has_bits_[0] |= 1u << 2;
}

inline void trDisplayVariant::clear_has_height () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void trDisplayVariant::set_has_aspectRatio () {
    _has_bits_[0] |= 1u << 3;
}

inline void trDisplayVariant::clear_has_aspectRatio () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  trVerifyChecksumResult::trVerifyChecksumResult ()  :
    _enType (::fcswupdatesrv::FcSwUpdateSrv::tenVerifyType__Md5Sum),
    _area (),
    _checksum (),
    _enResult (::fcswupdatesrv::FcSwUpdateSrv::tenVerifyResult__OtherError)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  trVerifyChecksumResult::trVerifyChecksumResult (const trVerifyChecksumResult &rhs)  :
    _enType (::fcswupdatesrv::FcSwUpdateSrv::tenVerifyType__Md5Sum),
    _area (),
    _checksum (),
    _enResult (::fcswupdatesrv::FcSwUpdateSrv::tenVerifyResult__OtherError)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  trVerifyChecksumResult::trVerifyChecksumResult (tenVerifyType enType_, const ::std::string& area_, const ::std::string& checksum_, tenVerifyResult enResult_)  :
    _enType (enType_),
    _area (area_),
    _checksum (checksum_),
    _enResult (enResult_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(tenVerifyType_IsValid(enType_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", enType_, "tenVerifyType", "enType", "trVerifyChecksumResult");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (area_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (checksum_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(tenVerifyResult_IsValid(enResult_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", enResult_, "tenVerifyResult", "enResult", "trVerifyChecksumResult");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  trVerifyChecksumResult::~trVerifyChecksumResult() {
}

inline trVerifyChecksumResult& trVerifyChecksumResult::operator = (const trVerifyChecksumResult& rhs) {
    if( this != &rhs ) {
        if (rhs.hasEnType()) {
            setEnType(rhs.getEnType());
        } else {
            clearEnType();
        }
        if (rhs.hasArea()) {
            setArea(rhs.getArea());
        } else {
            clearArea();
        }
        if (rhs.hasChecksum()) {
            setChecksum(rhs.getChecksum());
        } else {
            clearChecksum();
        }
        if (rhs.hasEnResult()) {
            setEnResult(rhs.getEnResult());
        } else {
            clearEnResult();
        }
    }
    return *this;
}

inline bool trVerifyChecksumResult::operator == (const trVerifyChecksumResult& rhs) const {
    return (((!hasEnType() && !rhs.hasEnType()) || getEnType() == rhs.getEnType()) &&
        ((!hasArea() && !rhs.hasArea()) || getArea() == rhs.getArea()) &&
        ((!hasChecksum() && !rhs.hasChecksum()) || getChecksum() == rhs.getChecksum()) &&
        ((!hasEnResult() && !rhs.hasEnResult()) || getEnResult() == rhs.getEnResult()));
}

inline bool trVerifyChecksumResult::operator != (const trVerifyChecksumResult& rhs) const {
    return ! (*this == rhs);
}

inline bool trVerifyChecksumResult::operator < (const trVerifyChecksumResult& rhs) const {
    if (hasEnType() || rhs.hasEnType()) {
        if ((uint32)getEnType() < (uint32)rhs.getEnType()) return true;
        if ((uint32)getEnType() > (uint32)rhs.getEnType()) return false;
    }
    if (hasArea() || rhs.hasArea()) {
        if (getArea() < rhs.getArea()) return true;
        if (getArea() > rhs.getArea()) return false;
    }
    if (hasChecksum() || rhs.hasChecksum()) {
        if (getChecksum() < rhs.getChecksum()) return true;
        if (getChecksum() > rhs.getChecksum()) return false;
    }
    if (hasEnResult() || rhs.hasEnResult()) {
        if ((uint32)getEnResult() < (uint32)rhs.getEnResult()) return true;
        if ((uint32)getEnResult() > (uint32)rhs.getEnResult()) return false;
    }
    return false;
}

inline bool trVerifyChecksumResult::operator > (const trVerifyChecksumResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void trVerifyChecksumResult::clear() {
    clearEnType();
    clearArea();
    clearChecksum();
    clearEnResult();
}

inline void trVerifyChecksumResult::clearEnType() {
    if (hasEnType()) {
         clear_has_enType();
        _enType = ::fcswupdatesrv::FcSwUpdateSrv::tenVerifyType__Md5Sum;
     }
}

inline bool trVerifyChecksumResult::hasEnType () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline tenVerifyType trVerifyChecksumResult::getEnType () const {
    return _enType;
}

inline void trVerifyChecksumResult::setEnType (tenVerifyType enType_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(tenVerifyType_IsValid(enType_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", enType_, "tenVerifyType", "enType", "trVerifyChecksumResult");
    }
    set_has_enType();
    this->_enType = enType_;
}

inline void trVerifyChecksumResult::clearArea() {
    if (hasArea()) {
         clear_has_area();
        _area.clear();
     }
}

inline bool trVerifyChecksumResult::hasArea () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& trVerifyChecksumResult::getArea () const {
    return _area;
}

inline ::std::string& trVerifyChecksumResult::getAreaMutable () {
    set_has_area();
    return _area;
}

inline void trVerifyChecksumResult::setArea (const ::std::string& area_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (area_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_area();
    this->_area = area_;
}

inline void trVerifyChecksumResult::setArea (const char* area_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (area_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_area();
    this->_area.assign(area_);
}

inline void trVerifyChecksumResult::setArea (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_area();
    this->_area.assign(value, size);
}

inline void trVerifyChecksumResult::clearChecksum() {
    if (hasChecksum()) {
         clear_has_checksum();
        _checksum.clear();
     }
}

inline bool trVerifyChecksumResult::hasChecksum () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::string& trVerifyChecksumResult::getChecksum () const {
    return _checksum;
}

inline ::std::string& trVerifyChecksumResult::getChecksumMutable () {
    set_has_checksum();
    return _checksum;
}

inline void trVerifyChecksumResult::setChecksum (const ::std::string& checksum_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (checksum_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_checksum();
    this->_checksum = checksum_;
}

inline void trVerifyChecksumResult::setChecksum (const char* checksum_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (checksum_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_checksum();
    this->_checksum.assign(checksum_);
}

inline void trVerifyChecksumResult::setChecksum (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_checksum();
    this->_checksum.assign(value, size);
}

inline void trVerifyChecksumResult::clearEnResult() {
    if (hasEnResult()) {
         clear_has_enResult();
        _enResult = ::fcswupdatesrv::FcSwUpdateSrv::tenVerifyResult__OtherError;
     }
}

inline bool trVerifyChecksumResult::hasEnResult () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline tenVerifyResult trVerifyChecksumResult::getEnResult () const {
    return _enResult;
}

inline void trVerifyChecksumResult::setEnResult (tenVerifyResult enResult_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(tenVerifyResult_IsValid(enResult_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", enResult_, "tenVerifyResult", "enResult", "trVerifyChecksumResult");
    }
    set_has_enResult();
    this->_enResult = enResult_;
}

inline void trVerifyChecksumResult::set_has_enType () {
    _has_bits_[0] |= 1u << 0;
}

inline void trVerifyChecksumResult::clear_has_enType () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void trVerifyChecksumResult::set_has_area () {
    _has_bits_[0] |= 1u << 1;
}

inline void trVerifyChecksumResult::clear_has_area () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void trVerifyChecksumResult::set_has_checksum () {
    _has_bits_[0] |= 1u << 2;
}

inline void trVerifyChecksumResult::clear_has_checksum () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void trVerifyChecksumResult::set_has_enResult () {
    _has_bits_[0] |= 1u << 3;
}

inline void trVerifyChecksumResult::clear_has_enResult () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  trVerifyChecksumRequest::trVerifyChecksumRequest ()  :
    _enVerifyType (::fcswupdatesrv::FcSwUpdateSrv::tenVerifyType__Md5Sum),
    _area ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  trVerifyChecksumRequest::trVerifyChecksumRequest (const trVerifyChecksumRequest &rhs)  :
    _enVerifyType (::fcswupdatesrv::FcSwUpdateSrv::tenVerifyType__Md5Sum),
    _area ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  trVerifyChecksumRequest::trVerifyChecksumRequest (tenVerifyType enVerifyType_, const ::std::string& area_)  :
    _enVerifyType (enVerifyType_),
    _area (area_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(tenVerifyType_IsValid(enVerifyType_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", enVerifyType_, "tenVerifyType", "enVerifyType", "trVerifyChecksumRequest");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (area_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  trVerifyChecksumRequest::~trVerifyChecksumRequest() {
}

inline trVerifyChecksumRequest& trVerifyChecksumRequest::operator = (const trVerifyChecksumRequest& rhs) {
    if( this != &rhs ) {
        if (rhs.hasEnVerifyType()) {
            setEnVerifyType(rhs.getEnVerifyType());
        } else {
            clearEnVerifyType();
        }
        if (rhs.hasArea()) {
            setArea(rhs.getArea());
        } else {
            clearArea();
        }
    }
    return *this;
}

inline bool trVerifyChecksumRequest::operator == (const trVerifyChecksumRequest& rhs) const {
    return (((!hasEnVerifyType() && !rhs.hasEnVerifyType()) || getEnVerifyType() == rhs.getEnVerifyType()) &&
        ((!hasArea() && !rhs.hasArea()) || getArea() == rhs.getArea()));
}

inline bool trVerifyChecksumRequest::operator != (const trVerifyChecksumRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool trVerifyChecksumRequest::operator < (const trVerifyChecksumRequest& rhs) const {
    if (hasEnVerifyType() || rhs.hasEnVerifyType()) {
        if ((uint32)getEnVerifyType() < (uint32)rhs.getEnVerifyType()) return true;
        if ((uint32)getEnVerifyType() > (uint32)rhs.getEnVerifyType()) return false;
    }
    if (hasArea() || rhs.hasArea()) {
        if (getArea() < rhs.getArea()) return true;
        if (getArea() > rhs.getArea()) return false;
    }
    return false;
}

inline bool trVerifyChecksumRequest::operator > (const trVerifyChecksumRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void trVerifyChecksumRequest::clear() {
    clearEnVerifyType();
    clearArea();
}

inline void trVerifyChecksumRequest::clearEnVerifyType() {
    if (hasEnVerifyType()) {
         clear_has_enVerifyType();
        _enVerifyType = ::fcswupdatesrv::FcSwUpdateSrv::tenVerifyType__Md5Sum;
     }
}

inline bool trVerifyChecksumRequest::hasEnVerifyType () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline tenVerifyType trVerifyChecksumRequest::getEnVerifyType () const {
    return _enVerifyType;
}

inline void trVerifyChecksumRequest::setEnVerifyType (tenVerifyType enVerifyType_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(tenVerifyType_IsValid(enVerifyType_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", enVerifyType_, "tenVerifyType", "enVerifyType", "trVerifyChecksumRequest");
    }
    set_has_enVerifyType();
    this->_enVerifyType = enVerifyType_;
}

inline void trVerifyChecksumRequest::clearArea() {
    if (hasArea()) {
         clear_has_area();
        _area.clear();
     }
}

inline bool trVerifyChecksumRequest::hasArea () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& trVerifyChecksumRequest::getArea () const {
    return _area;
}

inline ::std::string& trVerifyChecksumRequest::getAreaMutable () {
    set_has_area();
    return _area;
}

inline void trVerifyChecksumRequest::setArea (const ::std::string& area_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (area_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_area();
    this->_area = area_;
}

inline void trVerifyChecksumRequest::setArea (const char* area_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (area_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_area();
    this->_area.assign(area_);
}

inline void trVerifyChecksumRequest::setArea (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_area();
    this->_area.assign(value, size);
}

inline void trVerifyChecksumRequest::set_has_enVerifyType () {
    _has_bits_[0] |= 1u << 0;
}

inline void trVerifyChecksumRequest::clear_has_enVerifyType () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void trVerifyChecksumRequest::set_has_area () {
    _has_bits_[0] |= 1u << 1;
}

inline void trVerifyChecksumRequest::clear_has_area () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  trGetUpdateHistoryDetailedRequest::trGetUpdateHistoryDetailedRequest ()  :
    _enScope (::fcswupdatesrv::FcSwUpdateSrv::tenHistoryScope__All),
    _indexStart (0u),
    _numEntriesMax (0u),
    _enFormat (::fcswupdatesrv::FcSwUpdateSrv::tenHistoryFormat__Verbose)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  trGetUpdateHistoryDetailedRequest::trGetUpdateHistoryDetailedRequest (const trGetUpdateHistoryDetailedRequest &rhs)  :
    _enScope (::fcswupdatesrv::FcSwUpdateSrv::tenHistoryScope__All),
    _indexStart (0u),
    _numEntriesMax (0u),
    _enFormat (::fcswupdatesrv::FcSwUpdateSrv::tenHistoryFormat__Verbose)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  trGetUpdateHistoryDetailedRequest::trGetUpdateHistoryDetailedRequest (tenHistoryScope enScope_, uint32 indexStart_, uint32 numEntriesMax_, tenHistoryFormat enFormat_)  :
    _enScope (enScope_),
    _indexStart (indexStart_),
    _numEntriesMax (numEntriesMax_),
    _enFormat (enFormat_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(tenHistoryScope_IsValid(enScope_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", enScope_, "tenHistoryScope", "enScope", "trGetUpdateHistoryDetailedRequest");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(tenHistoryFormat_IsValid(enFormat_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", enFormat_, "tenHistoryFormat", "enFormat", "trGetUpdateHistoryDetailedRequest");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  trGetUpdateHistoryDetailedRequest::~trGetUpdateHistoryDetailedRequest() {
}

inline trGetUpdateHistoryDetailedRequest& trGetUpdateHistoryDetailedRequest::operator = (const trGetUpdateHistoryDetailedRequest& rhs) {
    if( this != &rhs ) {
        if (rhs.hasEnScope()) {
            setEnScope(rhs.getEnScope());
        } else {
            clearEnScope();
        }
        if (rhs.hasIndexStart()) {
            setIndexStart(rhs.getIndexStart());
        } else {
            clearIndexStart();
        }
        if (rhs.hasNumEntriesMax()) {
            setNumEntriesMax(rhs.getNumEntriesMax());
        } else {
            clearNumEntriesMax();
        }
        if (rhs.hasEnFormat()) {
            setEnFormat(rhs.getEnFormat());
        } else {
            clearEnFormat();
        }
    }
    return *this;
}

inline bool trGetUpdateHistoryDetailedRequest::operator == (const trGetUpdateHistoryDetailedRequest& rhs) const {
    return (((!hasEnScope() && !rhs.hasEnScope()) || getEnScope() == rhs.getEnScope()) &&
        ((!hasIndexStart() && !rhs.hasIndexStart()) || getIndexStart() == rhs.getIndexStart()) &&
        ((!hasNumEntriesMax() && !rhs.hasNumEntriesMax()) || getNumEntriesMax() == rhs.getNumEntriesMax()) &&
        ((!hasEnFormat() && !rhs.hasEnFormat()) || getEnFormat() == rhs.getEnFormat()));
}

inline bool trGetUpdateHistoryDetailedRequest::operator != (const trGetUpdateHistoryDetailedRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool trGetUpdateHistoryDetailedRequest::operator < (const trGetUpdateHistoryDetailedRequest& rhs) const {
    if (hasEnScope() || rhs.hasEnScope()) {
        if ((uint32)getEnScope() < (uint32)rhs.getEnScope()) return true;
        if ((uint32)getEnScope() > (uint32)rhs.getEnScope()) return false;
    }
    if (hasIndexStart() || rhs.hasIndexStart()) {
        if (getIndexStart() < rhs.getIndexStart()) return true;
        if (getIndexStart() > rhs.getIndexStart()) return false;
    }
    if (hasNumEntriesMax() || rhs.hasNumEntriesMax()) {
        if (getNumEntriesMax() < rhs.getNumEntriesMax()) return true;
        if (getNumEntriesMax() > rhs.getNumEntriesMax()) return false;
    }
    if (hasEnFormat() || rhs.hasEnFormat()) {
        if ((uint32)getEnFormat() < (uint32)rhs.getEnFormat()) return true;
        if ((uint32)getEnFormat() > (uint32)rhs.getEnFormat()) return false;
    }
    return false;
}

inline bool trGetUpdateHistoryDetailedRequest::operator > (const trGetUpdateHistoryDetailedRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void trGetUpdateHistoryDetailedRequest::clear() {
    clearEnScope();
    clearIndexStart();
    clearNumEntriesMax();
    clearEnFormat();
}

inline void trGetUpdateHistoryDetailedRequest::clearEnScope() {
    if (hasEnScope()) {
         clear_has_enScope();
        _enScope = ::fcswupdatesrv::FcSwUpdateSrv::tenHistoryScope__All;
     }
}

inline bool trGetUpdateHistoryDetailedRequest::hasEnScope () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline tenHistoryScope trGetUpdateHistoryDetailedRequest::getEnScope () const {
    return _enScope;
}

inline void trGetUpdateHistoryDetailedRequest::setEnScope (tenHistoryScope enScope_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(tenHistoryScope_IsValid(enScope_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", enScope_, "tenHistoryScope", "enScope", "trGetUpdateHistoryDetailedRequest");
    }
    set_has_enScope();
    this->_enScope = enScope_;
}

inline void trGetUpdateHistoryDetailedRequest::clearIndexStart() {
    if (hasIndexStart()) {
         clear_has_indexStart();
        _indexStart = 0u;
     }
}

inline bool trGetUpdateHistoryDetailedRequest::hasIndexStart () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 trGetUpdateHistoryDetailedRequest::getIndexStart () const {
    return _indexStart;
}

inline void trGetUpdateHistoryDetailedRequest::setIndexStart (uint32 indexStart_) {
    set_has_indexStart();
    this->_indexStart = indexStart_;
}

inline void trGetUpdateHistoryDetailedRequest::clearNumEntriesMax() {
    if (hasNumEntriesMax()) {
         clear_has_numEntriesMax();
        _numEntriesMax = 0u;
     }
}

inline bool trGetUpdateHistoryDetailedRequest::hasNumEntriesMax () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint32 trGetUpdateHistoryDetailedRequest::getNumEntriesMax () const {
    return _numEntriesMax;
}

inline void trGetUpdateHistoryDetailedRequest::setNumEntriesMax (uint32 numEntriesMax_) {
    set_has_numEntriesMax();
    this->_numEntriesMax = numEntriesMax_;
}

inline void trGetUpdateHistoryDetailedRequest::clearEnFormat() {
    if (hasEnFormat()) {
         clear_has_enFormat();
        _enFormat = ::fcswupdatesrv::FcSwUpdateSrv::tenHistoryFormat__Verbose;
     }
}

inline bool trGetUpdateHistoryDetailedRequest::hasEnFormat () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline tenHistoryFormat trGetUpdateHistoryDetailedRequest::getEnFormat () const {
    return _enFormat;
}

inline void trGetUpdateHistoryDetailedRequest::setEnFormat (tenHistoryFormat enFormat_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(tenHistoryFormat_IsValid(enFormat_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", enFormat_, "tenHistoryFormat", "enFormat", "trGetUpdateHistoryDetailedRequest");
    }
    set_has_enFormat();
    this->_enFormat = enFormat_;
}

inline void trGetUpdateHistoryDetailedRequest::set_has_enScope () {
    _has_bits_[0] |= 1u << 0;
}

inline void trGetUpdateHistoryDetailedRequest::clear_has_enScope () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void trGetUpdateHistoryDetailedRequest::set_has_indexStart () {
    _has_bits_[0] |= 1u << 1;
}

inline void trGetUpdateHistoryDetailedRequest::clear_has_indexStart () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void trGetUpdateHistoryDetailedRequest::set_has_numEntriesMax () {
    _has_bits_[0] |= 1u << 2;
}

inline void trGetUpdateHistoryDetailedRequest::clear_has_numEntriesMax () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void trGetUpdateHistoryDetailedRequest::set_has_enFormat () {
    _has_bits_[0] |= 1u << 3;
}

inline void trGetUpdateHistoryDetailedRequest::clear_has_enFormat () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  trGetUpdateHistoryDetailed::trGetUpdateHistoryDetailed ()  :
    _enScope (::fcswupdatesrv::FcSwUpdateSrv::tenHistoryScope__All),
    _logs (),
    _numberOfUpdates (0u),
    _numberOfUpdatesSinceDelivery (0u),
    _numberOfUpateLogs (0u),
    _enFormat (::fcswupdatesrv::FcSwUpdateSrv::tenHistoryFormat__Verbose)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  trGetUpdateHistoryDetailed::trGetUpdateHistoryDetailed (const trGetUpdateHistoryDetailed &rhs)  :
    _enScope (::fcswupdatesrv::FcSwUpdateSrv::tenHistoryScope__All),
    _logs (),
    _numberOfUpdates (0u),
    _numberOfUpdatesSinceDelivery (0u),
    _numberOfUpateLogs (0u),
    _enFormat (::fcswupdatesrv::FcSwUpdateSrv::tenHistoryFormat__Verbose)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  trGetUpdateHistoryDetailed::trGetUpdateHistoryDetailed (tenHistoryScope enScope_, const trUpdLogs& logs_, uint32 numberOfUpdates_, uint32 numberOfUpdatesSinceDelivery_, uint32 numberOfUpateLogs_, tenHistoryFormat enFormat_)  :
    _enScope (enScope_),
    _logs (logs_),
    _numberOfUpdates (numberOfUpdates_),
    _numberOfUpdatesSinceDelivery (numberOfUpdatesSinceDelivery_),
    _numberOfUpateLogs (numberOfUpateLogs_),
    _enFormat (enFormat_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(tenHistoryScope_IsValid(enScope_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", enScope_, "tenHistoryScope", "enScope", "trGetUpdateHistoryDetailed");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(tenHistoryFormat_IsValid(enFormat_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", enFormat_, "tenHistoryFormat", "enFormat", "trGetUpdateHistoryDetailed");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  trGetUpdateHistoryDetailed::~trGetUpdateHistoryDetailed() {
}

inline trGetUpdateHistoryDetailed& trGetUpdateHistoryDetailed::operator = (const trGetUpdateHistoryDetailed& rhs) {
    if( this != &rhs ) {
        if (rhs.hasEnScope()) {
            setEnScope(rhs.getEnScope());
        } else {
            clearEnScope();
        }
        if (rhs.hasLogs()) {
            setLogs(rhs.getLogs());
        } else {
            clearLogs();
        }
        if (rhs.hasNumberOfUpdates()) {
            setNumberOfUpdates(rhs.getNumberOfUpdates());
        } else {
            clearNumberOfUpdates();
        }
        if (rhs.hasNumberOfUpdatesSinceDelivery()) {
            setNumberOfUpdatesSinceDelivery(rhs.getNumberOfUpdatesSinceDelivery());
        } else {
            clearNumberOfUpdatesSinceDelivery();
        }
        if (rhs.hasNumberOfUpateLogs()) {
            setNumberOfUpateLogs(rhs.getNumberOfUpateLogs());
        } else {
            clearNumberOfUpateLogs();
        }
        if (rhs.hasEnFormat()) {
            setEnFormat(rhs.getEnFormat());
        } else {
            clearEnFormat();
        }
    }
    return *this;
}

inline bool trGetUpdateHistoryDetailed::operator == (const trGetUpdateHistoryDetailed& rhs) const {
    return (((!hasEnScope() && !rhs.hasEnScope()) || getEnScope() == rhs.getEnScope()) &&
        ((!hasLogs() && !rhs.hasLogs()) || getLogs() == rhs.getLogs()) &&
        ((!hasNumberOfUpdates() && !rhs.hasNumberOfUpdates()) || getNumberOfUpdates() == rhs.getNumberOfUpdates()) &&
        ((!hasNumberOfUpdatesSinceDelivery() && !rhs.hasNumberOfUpdatesSinceDelivery()) || getNumberOfUpdatesSinceDelivery() == rhs.getNumberOfUpdatesSinceDelivery()) &&
        ((!hasNumberOfUpateLogs() && !rhs.hasNumberOfUpateLogs()) || getNumberOfUpateLogs() == rhs.getNumberOfUpateLogs()) &&
        ((!hasEnFormat() && !rhs.hasEnFormat()) || getEnFormat() == rhs.getEnFormat()));
}

inline bool trGetUpdateHistoryDetailed::operator != (const trGetUpdateHistoryDetailed& rhs) const {
    return ! (*this == rhs);
}

inline bool trGetUpdateHistoryDetailed::operator < (const trGetUpdateHistoryDetailed& rhs) const {
    if (hasEnScope() || rhs.hasEnScope()) {
        if ((uint32)getEnScope() < (uint32)rhs.getEnScope()) return true;
        if ((uint32)getEnScope() > (uint32)rhs.getEnScope()) return false;
    }
    if (hasLogs() || rhs.hasLogs()) {
        if (getLogs() < rhs.getLogs()) return true;
        if (getLogs() > rhs.getLogs()) return false;
    }
    if (hasNumberOfUpdates() || rhs.hasNumberOfUpdates()) {
        if (getNumberOfUpdates() < rhs.getNumberOfUpdates()) return true;
        if (getNumberOfUpdates() > rhs.getNumberOfUpdates()) return false;
    }
    if (hasNumberOfUpdatesSinceDelivery() || rhs.hasNumberOfUpdatesSinceDelivery()) {
        if (getNumberOfUpdatesSinceDelivery() < rhs.getNumberOfUpdatesSinceDelivery()) return true;
        if (getNumberOfUpdatesSinceDelivery() > rhs.getNumberOfUpdatesSinceDelivery()) return false;
    }
    if (hasNumberOfUpateLogs() || rhs.hasNumberOfUpateLogs()) {
        if (getNumberOfUpateLogs() < rhs.getNumberOfUpateLogs()) return true;
        if (getNumberOfUpateLogs() > rhs.getNumberOfUpateLogs()) return false;
    }
    if (hasEnFormat() || rhs.hasEnFormat()) {
        if ((uint32)getEnFormat() < (uint32)rhs.getEnFormat()) return true;
        if ((uint32)getEnFormat() > (uint32)rhs.getEnFormat()) return false;
    }
    return false;
}

inline bool trGetUpdateHistoryDetailed::operator > (const trGetUpdateHistoryDetailed& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void trGetUpdateHistoryDetailed::clear() {
    clearEnScope();
    clearLogs();
    clearNumberOfUpdates();
    clearNumberOfUpdatesSinceDelivery();
    clearNumberOfUpateLogs();
    clearEnFormat();
}

inline void trGetUpdateHistoryDetailed::clearEnScope() {
    if (hasEnScope()) {
         clear_has_enScope();
        _enScope = ::fcswupdatesrv::FcSwUpdateSrv::tenHistoryScope__All;
     }
}

inline bool trGetUpdateHistoryDetailed::hasEnScope () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline tenHistoryScope trGetUpdateHistoryDetailed::getEnScope () const {
    return _enScope;
}

inline void trGetUpdateHistoryDetailed::setEnScope (tenHistoryScope enScope_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(tenHistoryScope_IsValid(enScope_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", enScope_, "tenHistoryScope", "enScope", "trGetUpdateHistoryDetailed");
    }
    set_has_enScope();
    this->_enScope = enScope_;
}

inline void trGetUpdateHistoryDetailed::clearLogs() {
    if (hasLogs()) {
         clear_has_logs();
        _logs.clear();
     }
}

inline bool trGetUpdateHistoryDetailed::hasLogs () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const trUpdLogs& trGetUpdateHistoryDetailed::getLogs () const {
    return _logs;
}

inline trUpdLogs& trGetUpdateHistoryDetailed::getLogsMutable () {
    set_has_logs();
    return _logs;
}

inline void trGetUpdateHistoryDetailed::setLogs (const trUpdLogs& logs_) {
    set_has_logs();
    this->_logs = logs_;
}

inline void trGetUpdateHistoryDetailed::clearNumberOfUpdates() {
    if (hasNumberOfUpdates()) {
         clear_has_numberOfUpdates();
        _numberOfUpdates = 0u;
     }
}

inline bool trGetUpdateHistoryDetailed::hasNumberOfUpdates () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint32 trGetUpdateHistoryDetailed::getNumberOfUpdates () const {
    return _numberOfUpdates;
}

inline void trGetUpdateHistoryDetailed::setNumberOfUpdates (uint32 numberOfUpdates_) {
    set_has_numberOfUpdates();
    this->_numberOfUpdates = numberOfUpdates_;
}

inline void trGetUpdateHistoryDetailed::clearNumberOfUpdatesSinceDelivery() {
    if (hasNumberOfUpdatesSinceDelivery()) {
         clear_has_numberOfUpdatesSinceDelivery();
        _numberOfUpdatesSinceDelivery = 0u;
     }
}

inline bool trGetUpdateHistoryDetailed::hasNumberOfUpdatesSinceDelivery () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint32 trGetUpdateHistoryDetailed::getNumberOfUpdatesSinceDelivery () const {
    return _numberOfUpdatesSinceDelivery;
}

inline void trGetUpdateHistoryDetailed::setNumberOfUpdatesSinceDelivery (uint32 numberOfUpdatesSinceDelivery_) {
    set_has_numberOfUpdatesSinceDelivery();
    this->_numberOfUpdatesSinceDelivery = numberOfUpdatesSinceDelivery_;
}

inline void trGetUpdateHistoryDetailed::clearNumberOfUpateLogs() {
    if (hasNumberOfUpateLogs()) {
         clear_has_numberOfUpateLogs();
        _numberOfUpateLogs = 0u;
     }
}

inline bool trGetUpdateHistoryDetailed::hasNumberOfUpateLogs () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline uint32 trGetUpdateHistoryDetailed::getNumberOfUpateLogs () const {
    return _numberOfUpateLogs;
}

inline void trGetUpdateHistoryDetailed::setNumberOfUpateLogs (uint32 numberOfUpateLogs_) {
    set_has_numberOfUpateLogs();
    this->_numberOfUpateLogs = numberOfUpateLogs_;
}

inline void trGetUpdateHistoryDetailed::clearEnFormat() {
    if (hasEnFormat()) {
         clear_has_enFormat();
        _enFormat = ::fcswupdatesrv::FcSwUpdateSrv::tenHistoryFormat__Verbose;
     }
}

inline bool trGetUpdateHistoryDetailed::hasEnFormat () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline tenHistoryFormat trGetUpdateHistoryDetailed::getEnFormat () const {
    return _enFormat;
}

inline void trGetUpdateHistoryDetailed::setEnFormat (tenHistoryFormat enFormat_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(tenHistoryFormat_IsValid(enFormat_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", enFormat_, "tenHistoryFormat", "enFormat", "trGetUpdateHistoryDetailed");
    }
    set_has_enFormat();
    this->_enFormat = enFormat_;
}

inline void trGetUpdateHistoryDetailed::set_has_enScope () {
    _has_bits_[0] |= 1u << 0;
}

inline void trGetUpdateHistoryDetailed::clear_has_enScope () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void trGetUpdateHistoryDetailed::set_has_logs () {
    _has_bits_[0] |= 1u << 1;
}

inline void trGetUpdateHistoryDetailed::clear_has_logs () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void trGetUpdateHistoryDetailed::set_has_numberOfUpdates () {
    _has_bits_[0] |= 1u << 2;
}

inline void trGetUpdateHistoryDetailed::clear_has_numberOfUpdates () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void trGetUpdateHistoryDetailed::set_has_numberOfUpdatesSinceDelivery () {
    _has_bits_[0] |= 1u << 3;
}

inline void trGetUpdateHistoryDetailed::clear_has_numberOfUpdatesSinceDelivery () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void trGetUpdateHistoryDetailed::set_has_numberOfUpateLogs () {
    _has_bits_[0] |= 1u << 4;
}

inline void trGetUpdateHistoryDetailed::clear_has_numberOfUpateLogs () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void trGetUpdateHistoryDetailed::set_has_enFormat () {
    _has_bits_[0] |= 1u << 5;
}

inline void trGetUpdateHistoryDetailed::clear_has_enFormat () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline  trBgLocks::trBgLocks ()  :
    _locks ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  trBgLocks::trBgLocks (const trBgLocks &rhs)  :
    _locks ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  trBgLocks::trBgLocks (const ::std::vector< ::std::string >& locks_)  :
    _locks (locks_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  trBgLocks::~trBgLocks() {
}

inline trBgLocks& trBgLocks::operator = (const trBgLocks& rhs) {
    if( this != &rhs ) {
        if (rhs.hasLocks()) {
            setLocks(rhs.getLocks());
        } else {
            clearLocks();
        }
    }
    return *this;
}

inline bool trBgLocks::operator == (const trBgLocks& rhs) const {
    return (((!hasLocks() && !rhs.hasLocks()) || getLocks() == rhs.getLocks()));
}

inline bool trBgLocks::operator != (const trBgLocks& rhs) const {
    return ! (*this == rhs);
}

inline bool trBgLocks::operator < (const trBgLocks& rhs) const {
    if (hasLocks() || rhs.hasLocks()) {
        if (getLocks() < rhs.getLocks()) return true;
        if (getLocks() > rhs.getLocks()) return false;
    }
    return false;
}

inline bool trBgLocks::operator > (const trBgLocks& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void trBgLocks::clear() {
    clearLocks();
}

inline void trBgLocks::clearLocks() {
    if (hasLocks()) {
         clear_has_locks();
        _locks.clear();
     }
}

inline bool trBgLocks::hasLocks () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< ::std::string >& trBgLocks::getLocks () const {
    return _locks;
}

inline ::std::vector< ::std::string >& trBgLocks::getLocksMutable () {
    set_has_locks();
    return _locks;
}

inline void trBgLocks::setLocks (const ::std::vector< ::std::string >& locks_) {
    set_has_locks();
    this->_locks = locks_;
}

inline void trBgLocks::set_has_locks () {
    _has_bits_[0] |= 1u << 0;
}

inline void trBgLocks::clear_has_locks () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  trBgLocksState::trBgLocksState ()  :
    _registeredLocks (),
    _pendingLocks ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  trBgLocksState::trBgLocksState (const trBgLocksState &rhs)  :
    _registeredLocks (),
    _pendingLocks ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  trBgLocksState::trBgLocksState (const trBgLocks& registeredLocks_, const trBgLocks& pendingLocks_)  :
    _registeredLocks (registeredLocks_),
    _pendingLocks (pendingLocks_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  trBgLocksState::~trBgLocksState() {
}

inline trBgLocksState& trBgLocksState::operator = (const trBgLocksState& rhs) {
    if( this != &rhs ) {
        if (rhs.hasRegisteredLocks()) {
            setRegisteredLocks(rhs.getRegisteredLocks());
        } else {
            clearRegisteredLocks();
        }
        if (rhs.hasPendingLocks()) {
            setPendingLocks(rhs.getPendingLocks());
        } else {
            clearPendingLocks();
        }
    }
    return *this;
}

inline bool trBgLocksState::operator == (const trBgLocksState& rhs) const {
    return (((!hasRegisteredLocks() && !rhs.hasRegisteredLocks()) || getRegisteredLocks() == rhs.getRegisteredLocks()) &&
        ((!hasPendingLocks() && !rhs.hasPendingLocks()) || getPendingLocks() == rhs.getPendingLocks()));
}

inline bool trBgLocksState::operator != (const trBgLocksState& rhs) const {
    return ! (*this == rhs);
}

inline bool trBgLocksState::operator < (const trBgLocksState& rhs) const {
    if (hasRegisteredLocks() || rhs.hasRegisteredLocks()) {
        if (getRegisteredLocks() < rhs.getRegisteredLocks()) return true;
        if (getRegisteredLocks() > rhs.getRegisteredLocks()) return false;
    }
    if (hasPendingLocks() || rhs.hasPendingLocks()) {
        if (getPendingLocks() < rhs.getPendingLocks()) return true;
        if (getPendingLocks() > rhs.getPendingLocks()) return false;
    }
    return false;
}

inline bool trBgLocksState::operator > (const trBgLocksState& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void trBgLocksState::clear() {
    clearRegisteredLocks();
    clearPendingLocks();
}

inline void trBgLocksState::clearRegisteredLocks() {
    if (hasRegisteredLocks()) {
         clear_has_registeredLocks();
        _registeredLocks.clear();
     }
}

inline bool trBgLocksState::hasRegisteredLocks () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const trBgLocks& trBgLocksState::getRegisteredLocks () const {
    return _registeredLocks;
}

inline trBgLocks& trBgLocksState::getRegisteredLocksMutable () {
    set_has_registeredLocks();
    return _registeredLocks;
}

inline void trBgLocksState::setRegisteredLocks (const trBgLocks& registeredLocks_) {
    set_has_registeredLocks();
    this->_registeredLocks = registeredLocks_;
}

inline void trBgLocksState::clearPendingLocks() {
    if (hasPendingLocks()) {
         clear_has_pendingLocks();
        _pendingLocks.clear();
     }
}

inline bool trBgLocksState::hasPendingLocks () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const trBgLocks& trBgLocksState::getPendingLocks () const {
    return _pendingLocks;
}

inline trBgLocks& trBgLocksState::getPendingLocksMutable () {
    set_has_pendingLocks();
    return _pendingLocks;
}

inline void trBgLocksState::setPendingLocks (const trBgLocks& pendingLocks_) {
    set_has_pendingLocks();
    this->_pendingLocks = pendingLocks_;
}

inline void trBgLocksState::set_has_registeredLocks () {
    _has_bits_[0] |= 1u << 0;
}

inline void trBgLocksState::clear_has_registeredLocks () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void trBgLocksState::set_has_pendingLocks () {
    _has_bits_[0] |= 1u << 1;
}

inline void trBgLocksState::clear_has_pendingLocks () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  StoreHistoryToStickRequest::StoreHistoryToStickRequest ()  :
    _sinceFactoryReset (false),
    _writeToAllSticks (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  StoreHistoryToStickRequest::StoreHistoryToStickRequest (const StoreHistoryToStickRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _sinceFactoryReset (false),
    _writeToAllSticks (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  StoreHistoryToStickRequest::StoreHistoryToStickRequest (bool sinceFactoryReset_, bool writeToAllSticks_)  :
    _sinceFactoryReset (sinceFactoryReset_),
    _writeToAllSticks (writeToAllSticks_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  StoreHistoryToStickRequest::~StoreHistoryToStickRequest() {
}

inline StoreHistoryToStickRequest& StoreHistoryToStickRequest::operator = (const StoreHistoryToStickRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSinceFactoryReset()) {
            setSinceFactoryReset(rhs.getSinceFactoryReset());
        } else {
            clearSinceFactoryReset();
        }
        if (rhs.hasWriteToAllSticks()) {
            setWriteToAllSticks(rhs.getWriteToAllSticks());
        } else {
            clearWriteToAllSticks();
        }
    }
    return *this;
}

inline bool StoreHistoryToStickRequest::operator == (const StoreHistoryToStickRequest& rhs) const {
    return (((!hasSinceFactoryReset() && !rhs.hasSinceFactoryReset()) || getSinceFactoryReset() == rhs.getSinceFactoryReset()) &&
        ((!hasWriteToAllSticks() && !rhs.hasWriteToAllSticks()) || getWriteToAllSticks() == rhs.getWriteToAllSticks()));
}

inline bool StoreHistoryToStickRequest::operator != (const StoreHistoryToStickRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool StoreHistoryToStickRequest::operator < (const StoreHistoryToStickRequest& rhs) const {
    if (hasSinceFactoryReset() || rhs.hasSinceFactoryReset()) {
        if (getSinceFactoryReset() < rhs.getSinceFactoryReset()) return true;
        if (getSinceFactoryReset() > rhs.getSinceFactoryReset()) return false;
    }
    if (hasWriteToAllSticks() || rhs.hasWriteToAllSticks()) {
        if (getWriteToAllSticks() < rhs.getWriteToAllSticks()) return true;
        if (getWriteToAllSticks() > rhs.getWriteToAllSticks()) return false;
    }
    return false;
}

inline ::asf::core::Payload* StoreHistoryToStickRequest::clone() {
    return new StoreHistoryToStickRequest(*this);
}

inline bool StoreHistoryToStickRequest::operator > (const StoreHistoryToStickRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void StoreHistoryToStickRequest::clear() {
    clearSinceFactoryReset();
    clearWriteToAllSticks();
}

inline void StoreHistoryToStickRequest::clearSinceFactoryReset() {
    if (hasSinceFactoryReset()) {
         clear_has_sinceFactoryReset();
        _sinceFactoryReset = false;
     }
}

inline bool StoreHistoryToStickRequest::hasSinceFactoryReset () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool StoreHistoryToStickRequest::getSinceFactoryReset () const {
    return _sinceFactoryReset;
}

inline void StoreHistoryToStickRequest::setSinceFactoryReset (bool sinceFactoryReset_) {
    set_has_sinceFactoryReset();
    this->_sinceFactoryReset = sinceFactoryReset_;
}

inline void StoreHistoryToStickRequest::clearWriteToAllSticks() {
    if (hasWriteToAllSticks()) {
         clear_has_writeToAllSticks();
        _writeToAllSticks = false;
     }
}

inline bool StoreHistoryToStickRequest::hasWriteToAllSticks () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline bool StoreHistoryToStickRequest::getWriteToAllSticks () const {
    return _writeToAllSticks;
}

inline void StoreHistoryToStickRequest::setWriteToAllSticks (bool writeToAllSticks_) {
    set_has_writeToAllSticks();
    this->_writeToAllSticks = writeToAllSticks_;
}

inline void StoreHistoryToStickRequest::set_has_sinceFactoryReset () {
    _has_bits_[0] |= 1u << 0;
}

inline void StoreHistoryToStickRequest::clear_has_sinceFactoryReset () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void StoreHistoryToStickRequest::set_has_writeToAllSticks () {
    _has_bits_[0] |= 1u << 1;
}

inline void StoreHistoryToStickRequest::clear_has_writeToAllSticks () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  StoreHistoryToStickResponse::StoreHistoryToStickResponse ()  :
    _bOk (false),
    _enResult (::fcswupdatesrv::FcSwUpdateSrv::tenStoreHistoryResult__Ok)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  StoreHistoryToStickResponse::StoreHistoryToStickResponse (const StoreHistoryToStickResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _bOk (false),
    _enResult (::fcswupdatesrv::FcSwUpdateSrv::tenStoreHistoryResult__Ok)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  StoreHistoryToStickResponse::StoreHistoryToStickResponse (bool bOk_, tenStoreHistoryResult enResult_)  :
    _bOk (bOk_),
    _enResult (enResult_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(tenStoreHistoryResult_IsValid(enResult_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", enResult_, "tenStoreHistoryResult", "enResult", "StoreHistoryToStickResponse");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  StoreHistoryToStickResponse::~StoreHistoryToStickResponse() {
}

inline StoreHistoryToStickResponse& StoreHistoryToStickResponse::operator = (const StoreHistoryToStickResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasBOk()) {
            setBOk(rhs.getBOk());
        } else {
            clearBOk();
        }
        if (rhs.hasEnResult()) {
            setEnResult(rhs.getEnResult());
        } else {
            clearEnResult();
        }
    }
    return *this;
}

inline bool StoreHistoryToStickResponse::operator == (const StoreHistoryToStickResponse& rhs) const {
    return (((!hasBOk() && !rhs.hasBOk()) || getBOk() == rhs.getBOk()) &&
        ((!hasEnResult() && !rhs.hasEnResult()) || getEnResult() == rhs.getEnResult()));
}

inline bool StoreHistoryToStickResponse::operator != (const StoreHistoryToStickResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool StoreHistoryToStickResponse::operator < (const StoreHistoryToStickResponse& rhs) const {
    if (hasBOk() || rhs.hasBOk()) {
        if (getBOk() < rhs.getBOk()) return true;
        if (getBOk() > rhs.getBOk()) return false;
    }
    if (hasEnResult() || rhs.hasEnResult()) {
        if ((uint32)getEnResult() < (uint32)rhs.getEnResult()) return true;
        if ((uint32)getEnResult() > (uint32)rhs.getEnResult()) return false;
    }
    return false;
}

inline ::asf::core::Payload* StoreHistoryToStickResponse::clone() {
    return new StoreHistoryToStickResponse(*this);
}

inline bool StoreHistoryToStickResponse::operator > (const StoreHistoryToStickResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void StoreHistoryToStickResponse::clear() {
    clearBOk();
    clearEnResult();
}

inline void StoreHistoryToStickResponse::clearBOk() {
    if (hasBOk()) {
         clear_has_bOk();
        _bOk = false;
     }
}

inline bool StoreHistoryToStickResponse::hasBOk () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool StoreHistoryToStickResponse::getBOk () const {
    return _bOk;
}

inline void StoreHistoryToStickResponse::setBOk (bool bOk_) {
    set_has_bOk();
    this->_bOk = bOk_;
}

inline void StoreHistoryToStickResponse::clearEnResult() {
    if (hasEnResult()) {
         clear_has_enResult();
        _enResult = ::fcswupdatesrv::FcSwUpdateSrv::tenStoreHistoryResult__Ok;
     }
}

inline bool StoreHistoryToStickResponse::hasEnResult () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline tenStoreHistoryResult StoreHistoryToStickResponse::getEnResult () const {
    return _enResult;
}

inline void StoreHistoryToStickResponse::setEnResult (tenStoreHistoryResult enResult_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(tenStoreHistoryResult_IsValid(enResult_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", enResult_, "tenStoreHistoryResult", "enResult", "StoreHistoryToStickResponse");
    }
    set_has_enResult();
    this->_enResult = enResult_;
}

inline void StoreHistoryToStickResponse::set_has_bOk () {
    _has_bits_[0] |= 1u << 0;
}

inline void StoreHistoryToStickResponse::clear_has_bOk () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void StoreHistoryToStickResponse::set_has_enResult () {
    _has_bits_[0] |= 1u << 1;
}

inline void StoreHistoryToStickResponse::clear_has_enResult () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  UpdateEnterRequest::UpdateEnterRequest ()  :
    _enUser (::fcswupdatesrv::FcSwUpdateSrv::tenUser__Customer)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  UpdateEnterRequest::UpdateEnterRequest (const UpdateEnterRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _enUser (::fcswupdatesrv::FcSwUpdateSrv::tenUser__Customer)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  UpdateEnterRequest::UpdateEnterRequest (tenUser enUser_)  :
    _enUser (enUser_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(tenUser_IsValid(enUser_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", enUser_, "tenUser", "enUser", "UpdateEnterRequest");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  UpdateEnterRequest::~UpdateEnterRequest() {
}

inline UpdateEnterRequest& UpdateEnterRequest::operator = (const UpdateEnterRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasEnUser()) {
            setEnUser(rhs.getEnUser());
        } else {
            clearEnUser();
        }
    }
    return *this;
}

inline bool UpdateEnterRequest::operator == (const UpdateEnterRequest& rhs) const {
    return (((!hasEnUser() && !rhs.hasEnUser()) || getEnUser() == rhs.getEnUser()));
}

inline bool UpdateEnterRequest::operator != (const UpdateEnterRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool UpdateEnterRequest::operator < (const UpdateEnterRequest& rhs) const {
    if (hasEnUser() || rhs.hasEnUser()) {
        if ((uint32)getEnUser() < (uint32)rhs.getEnUser()) return true;
        if ((uint32)getEnUser() > (uint32)rhs.getEnUser()) return false;
    }
    return false;
}

inline ::asf::core::Payload* UpdateEnterRequest::clone() {
    return new UpdateEnterRequest(*this);
}

inline bool UpdateEnterRequest::operator > (const UpdateEnterRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void UpdateEnterRequest::clear() {
    clearEnUser();
}

inline void UpdateEnterRequest::clearEnUser() {
    if (hasEnUser()) {
         clear_has_enUser();
        _enUser = ::fcswupdatesrv::FcSwUpdateSrv::tenUser__Customer;
     }
}

inline bool UpdateEnterRequest::hasEnUser () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline tenUser UpdateEnterRequest::getEnUser () const {
    return _enUser;
}

inline void UpdateEnterRequest::setEnUser (tenUser enUser_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(tenUser_IsValid(enUser_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", enUser_, "tenUser", "enUser", "UpdateEnterRequest");
    }
    set_has_enUser();
    this->_enUser = enUser_;
}

inline void UpdateEnterRequest::set_has_enUser () {
    _has_bits_[0] |= 1u << 0;
}

inline void UpdateEnterRequest::clear_has_enUser () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  UpdateEnterResponse::UpdateEnterResponse ()  :
    _bOk (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  UpdateEnterResponse::UpdateEnterResponse (const UpdateEnterResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _bOk (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  UpdateEnterResponse::UpdateEnterResponse (bool bOk_)  :
    _bOk (bOk_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  UpdateEnterResponse::~UpdateEnterResponse() {
}

inline UpdateEnterResponse& UpdateEnterResponse::operator = (const UpdateEnterResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasBOk()) {
            setBOk(rhs.getBOk());
        } else {
            clearBOk();
        }
    }
    return *this;
}

inline bool UpdateEnterResponse::operator == (const UpdateEnterResponse& rhs) const {
    return (((!hasBOk() && !rhs.hasBOk()) || getBOk() == rhs.getBOk()));
}

inline bool UpdateEnterResponse::operator != (const UpdateEnterResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool UpdateEnterResponse::operator < (const UpdateEnterResponse& rhs) const {
    if (hasBOk() || rhs.hasBOk()) {
        if (getBOk() < rhs.getBOk()) return true;
        if (getBOk() > rhs.getBOk()) return false;
    }
    return false;
}

inline ::asf::core::Payload* UpdateEnterResponse::clone() {
    return new UpdateEnterResponse(*this);
}

inline bool UpdateEnterResponse::operator > (const UpdateEnterResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void UpdateEnterResponse::clear() {
    clearBOk();
}

inline void UpdateEnterResponse::clearBOk() {
    if (hasBOk()) {
         clear_has_bOk();
        _bOk = false;
     }
}

inline bool UpdateEnterResponse::hasBOk () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool UpdateEnterResponse::getBOk () const {
    return _bOk;
}

inline void UpdateEnterResponse::setBOk (bool bOk_) {
    set_has_bOk();
    this->_bOk = bOk_;
}

inline void UpdateEnterResponse::set_has_bOk () {
    _has_bits_[0] |= 1u << 0;
}

inline void UpdateEnterResponse::clear_has_bOk () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  UpdateSetReleaseFilterRequest::UpdateSetReleaseFilterRequest ()  :
    _filter ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  UpdateSetReleaseFilterRequest::UpdateSetReleaseFilterRequest (const UpdateSetReleaseFilterRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _filter ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  UpdateSetReleaseFilterRequest::UpdateSetReleaseFilterRequest (const trReleaseFilter& filter_)  :
    _filter (filter_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  UpdateSetReleaseFilterRequest::~UpdateSetReleaseFilterRequest() {
}

inline UpdateSetReleaseFilterRequest& UpdateSetReleaseFilterRequest::operator = (const UpdateSetReleaseFilterRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasFilter()) {
            setFilter(rhs.getFilter());
        } else {
            clearFilter();
        }
    }
    return *this;
}

inline bool UpdateSetReleaseFilterRequest::operator == (const UpdateSetReleaseFilterRequest& rhs) const {
    return (((!hasFilter() && !rhs.hasFilter()) || getFilter() == rhs.getFilter()));
}

inline bool UpdateSetReleaseFilterRequest::operator != (const UpdateSetReleaseFilterRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool UpdateSetReleaseFilterRequest::operator < (const UpdateSetReleaseFilterRequest& rhs) const {
    if (hasFilter() || rhs.hasFilter()) {
        if (getFilter() < rhs.getFilter()) return true;
        if (getFilter() > rhs.getFilter()) return false;
    }
    return false;
}

inline ::asf::core::Payload* UpdateSetReleaseFilterRequest::clone() {
    return new UpdateSetReleaseFilterRequest(*this);
}

inline bool UpdateSetReleaseFilterRequest::operator > (const UpdateSetReleaseFilterRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void UpdateSetReleaseFilterRequest::clear() {
    clearFilter();
}

inline void UpdateSetReleaseFilterRequest::clearFilter() {
    if (hasFilter()) {
         clear_has_filter();
        _filter.clear();
     }
}

inline bool UpdateSetReleaseFilterRequest::hasFilter () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const trReleaseFilter& UpdateSetReleaseFilterRequest::getFilter () const {
    return _filter;
}

inline trReleaseFilter& UpdateSetReleaseFilterRequest::getFilterMutable () {
    set_has_filter();
    return _filter;
}

inline void UpdateSetReleaseFilterRequest::setFilter (const trReleaseFilter& filter_) {
    set_has_filter();
    this->_filter = filter_;
}

inline void UpdateSetReleaseFilterRequest::set_has_filter () {
    _has_bits_[0] |= 1u << 0;
}

inline void UpdateSetReleaseFilterRequest::clear_has_filter () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  UpdateSetReleaseFilterResponse::UpdateSetReleaseFilterResponse ()  :
    _bOk (false),
    _resFilter ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  UpdateSetReleaseFilterResponse::UpdateSetReleaseFilterResponse (const UpdateSetReleaseFilterResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _bOk (false),
    _resFilter ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  UpdateSetReleaseFilterResponse::UpdateSetReleaseFilterResponse (bool bOk_, const trReleaseFilter& resFilter_)  :
    _bOk (bOk_),
    _resFilter (resFilter_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  UpdateSetReleaseFilterResponse::~UpdateSetReleaseFilterResponse() {
}

inline UpdateSetReleaseFilterResponse& UpdateSetReleaseFilterResponse::operator = (const UpdateSetReleaseFilterResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasBOk()) {
            setBOk(rhs.getBOk());
        } else {
            clearBOk();
        }
        if (rhs.hasResFilter()) {
            setResFilter(rhs.getResFilter());
        } else {
            clearResFilter();
        }
    }
    return *this;
}

inline bool UpdateSetReleaseFilterResponse::operator == (const UpdateSetReleaseFilterResponse& rhs) const {
    return (((!hasBOk() && !rhs.hasBOk()) || getBOk() == rhs.getBOk()) &&
        ((!hasResFilter() && !rhs.hasResFilter()) || getResFilter() == rhs.getResFilter()));
}

inline bool UpdateSetReleaseFilterResponse::operator != (const UpdateSetReleaseFilterResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool UpdateSetReleaseFilterResponse::operator < (const UpdateSetReleaseFilterResponse& rhs) const {
    if (hasBOk() || rhs.hasBOk()) {
        if (getBOk() < rhs.getBOk()) return true;
        if (getBOk() > rhs.getBOk()) return false;
    }
    if (hasResFilter() || rhs.hasResFilter()) {
        if (getResFilter() < rhs.getResFilter()) return true;
        if (getResFilter() > rhs.getResFilter()) return false;
    }
    return false;
}

inline ::asf::core::Payload* UpdateSetReleaseFilterResponse::clone() {
    return new UpdateSetReleaseFilterResponse(*this);
}

inline bool UpdateSetReleaseFilterResponse::operator > (const UpdateSetReleaseFilterResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void UpdateSetReleaseFilterResponse::clear() {
    clearBOk();
    clearResFilter();
}

inline void UpdateSetReleaseFilterResponse::clearBOk() {
    if (hasBOk()) {
         clear_has_bOk();
        _bOk = false;
     }
}

inline bool UpdateSetReleaseFilterResponse::hasBOk () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool UpdateSetReleaseFilterResponse::getBOk () const {
    return _bOk;
}

inline void UpdateSetReleaseFilterResponse::setBOk (bool bOk_) {
    set_has_bOk();
    this->_bOk = bOk_;
}

inline void UpdateSetReleaseFilterResponse::clearResFilter() {
    if (hasResFilter()) {
         clear_has_resFilter();
        _resFilter.clear();
     }
}

inline bool UpdateSetReleaseFilterResponse::hasResFilter () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const trReleaseFilter& UpdateSetReleaseFilterResponse::getResFilter () const {
    return _resFilter;
}

inline trReleaseFilter& UpdateSetReleaseFilterResponse::getResFilterMutable () {
    set_has_resFilter();
    return _resFilter;
}

inline void UpdateSetReleaseFilterResponse::setResFilter (const trReleaseFilter& resFilter_) {
    set_has_resFilter();
    this->_resFilter = resFilter_;
}

inline void UpdateSetReleaseFilterResponse::set_has_bOk () {
    _has_bits_[0] |= 1u << 0;
}

inline void UpdateSetReleaseFilterResponse::clear_has_bOk () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void UpdateSetReleaseFilterResponse::set_has_resFilter () {
    _has_bits_[0] |= 1u << 1;
}

inline void UpdateSetReleaseFilterResponse::clear_has_resFilter () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  UpdateGetSourcesResponse::UpdateGetSourcesResponse ()  :
    _bOk (false),
    _sources ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  UpdateGetSourcesResponse::UpdateGetSourcesResponse (const UpdateGetSourcesResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _bOk (false),
    _sources ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  UpdateGetSourcesResponse::UpdateGetSourcesResponse (bool bOk_, const trUpdSources& sources_)  :
    _bOk (bOk_),
    _sources (sources_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  UpdateGetSourcesResponse::~UpdateGetSourcesResponse() {
}

inline UpdateGetSourcesResponse& UpdateGetSourcesResponse::operator = (const UpdateGetSourcesResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasBOk()) {
            setBOk(rhs.getBOk());
        } else {
            clearBOk();
        }
        if (rhs.hasSources()) {
            setSources(rhs.getSources());
        } else {
            clearSources();
        }
    }
    return *this;
}

inline bool UpdateGetSourcesResponse::operator == (const UpdateGetSourcesResponse& rhs) const {
    return (((!hasBOk() && !rhs.hasBOk()) || getBOk() == rhs.getBOk()) &&
        ((!hasSources() && !rhs.hasSources()) || getSources() == rhs.getSources()));
}

inline bool UpdateGetSourcesResponse::operator != (const UpdateGetSourcesResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool UpdateGetSourcesResponse::operator < (const UpdateGetSourcesResponse& rhs) const {
    if (hasBOk() || rhs.hasBOk()) {
        if (getBOk() < rhs.getBOk()) return true;
        if (getBOk() > rhs.getBOk()) return false;
    }
    if (hasSources() || rhs.hasSources()) {
        if (getSources() < rhs.getSources()) return true;
        if (getSources() > rhs.getSources()) return false;
    }
    return false;
}

inline ::asf::core::Payload* UpdateGetSourcesResponse::clone() {
    return new UpdateGetSourcesResponse(*this);
}

inline bool UpdateGetSourcesResponse::operator > (const UpdateGetSourcesResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void UpdateGetSourcesResponse::clear() {
    clearBOk();
    clearSources();
}

inline void UpdateGetSourcesResponse::clearBOk() {
    if (hasBOk()) {
         clear_has_bOk();
        _bOk = false;
     }
}

inline bool UpdateGetSourcesResponse::hasBOk () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool UpdateGetSourcesResponse::getBOk () const {
    return _bOk;
}

inline void UpdateGetSourcesResponse::setBOk (bool bOk_) {
    set_has_bOk();
    this->_bOk = bOk_;
}

inline void UpdateGetSourcesResponse::clearSources() {
    if (hasSources()) {
         clear_has_sources();
        _sources.clear();
     }
}

inline bool UpdateGetSourcesResponse::hasSources () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const trUpdSources& UpdateGetSourcesResponse::getSources () const {
    return _sources;
}

inline trUpdSources& UpdateGetSourcesResponse::getSourcesMutable () {
    set_has_sources();
    return _sources;
}

inline void UpdateGetSourcesResponse::setSources (const trUpdSources& sources_) {
    set_has_sources();
    this->_sources = sources_;
}

inline void UpdateGetSourcesResponse::set_has_bOk () {
    _has_bits_[0] |= 1u << 0;
}

inline void UpdateGetSourcesResponse::clear_has_bOk () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void UpdateGetSourcesResponse::set_has_sources () {
    _has_bits_[0] |= 1u << 1;
}

inline void UpdateGetSourcesResponse::clear_has_sources () {
    _has_bits_[0] &= ~ (1u << 