/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/cms/CmsProxyRegistry.h"
#include "asf/core/Types.h"
#include "boost/shared_ptr.hpp"
#include "fcswupdateloopbacksrv/FcSwUpdateLoopBackSrv.h"
#include "fcswupdateloopbacksrv/FcSwUpdateLoopBackSrvProxy.h"

namespace fcswupdateloopbacksrv {
namespace FcSwUpdateLoopBackSrv {

DEFINE_CLASS_LOGGER("/fcswupdateloopbacksrv/FcSwUpdateLoopBackSrv", FcSwUpdateLoopBackSrvProxy);
DEFINE_CLASS_LOGGER("/fcswupdateloopbacksrv/FcSwUpdateLoopBackSrv", FcSwUpdateLoopBackSrvClientBase);


// static
::boost::shared_ptr< FcSwUpdateLoopBackSrvProxy > FcSwUpdateLoopBackSrvProxy::createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable) {
    ::boost::shared_ptr< Proxy > proxyReuse = ::asf::cms::CmsProxyRegistry::getInstance().getProxy(portName, serviceAvailable);
    if(proxyReuse) {
        LOG_INFO_STATIC ("createProxy, reuse existing proxy");
        return ::boost::static_pointer_cast<FcSwUpdateLoopBackSrvProxy>(proxyReuse); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
    }
    // create new proxy object
    LOG_INFO_STATIC ("createProxy, create new proxy");
    ::boost::shared_ptr< FcSwUpdateLoopBackSrvProxy >  proxyNew(new FcSwUpdateLoopBackSrvProxy(portName,serviceAvailable));
    ::asf::cms::CmsProxyRegistry::getInstance().registerProxy(proxyNew);
    return proxyNew;
}

// static
::boost::shared_ptr< FcSwUpdateLoopBackSrvProxy > FcSwUpdateLoopBackSrvProxy::createProxy(const std::string& portName, const std::string& uriAddress, ::asf::core::ServiceAvailableIF& serviceAvailable) {
    // create new proxy object
    LOG_INFO_STATIC ("createProxy, create new proxy");
    ::boost::shared_ptr< FcSwUpdateLoopBackSrvProxy >  proxyNew(new FcSwUpdateLoopBackSrvProxy(portName,serviceAvailable));
    ::asf::cms::CmsProxyRegistry::getInstance().registerProxy(proxyNew, uriAddress);
    return proxyNew;
}

FcSwUpdateLoopBackSrvProxy::FcSwUpdateLoopBackSrvProxy (const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable) :
    CmsProxy(portName,serviceAvailable, "fcswupdateloopbacksrv.FcSwUpdateLoopBackSrv", _logger) {
    LOG_INFO ("Create proxy=%p, compId=%d, portName='%s'", this, _cmsProxyDelegate.getClientComponentId(), getPortName().c_str());
}

FcSwUpdateLoopBackSrvProxy::~FcSwUpdateLoopBackSrvProxy () {
    ::asf::cms::CmsProxyRegistry::getInstance().deregisterProxy(_cmsProxyDelegate.getProxyId());
}

act_t FcSwUpdateLoopBackSrvProxy::sendReceiveLoopbackMessageRequest(uint64 pMsg) {
    ::boost::shared_ptr< ReceiveLoopbackMessageRequest > para(new ReceiveLoopbackMessageRequest(pMsg));
    ::asf::cms::CmsMessage msg(::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__OnewayRequest,_cmsProxyDelegate.getServiceId(),"receiveLoopbackMessage",::asf::cms::CmsMessage::getUniqueCct(),_cmsProxyDelegate.getProxyId());
    msg.setPayload(para);

    ::asf::cms::CmsMessage::returnCct(msg.getCct());
    act_t regId = (act_t)0;
    if(_cmsProxyDelegate.request(msg)) {
        LOG_INFO ("-> send%sRequest(), returning act=%" PRIuPTR, "ReceiveLoopbackMessage", regId);
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(*para,jsonPayload);
            LOG_INFO("payload: %s", jsonPayload.c_str());
        }
    }
    return regId;
}

::asf::cms::CmsServiceStreamer* FcSwUpdateLoopBackSrvProxy::getStreamer() {
    ::asf::cms::CmsServiceStreamer* streamer=0;
    switch(_cmsProxyDelegate.getEncoding()) {
        case ::com::bosch::cm::asf::lang::cms::Connectors::Encoding__Json:
            streamer=&_streamerJson;
            break;
        case ::com::bosch::cm::asf::lang::cms::Connectors::Encoding__FastBin:
            streamer=&_streamerCmsBin;
            break;
        default:
            streamer=0;
            break;
    }
    return streamer;
}

} // namespace FcSwUpdateLoopBackSrv
} // namespace fcswupdateloopbacksrv
