/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/Application.h"
#include "asf/core/ComponentContainer.h"
#include "asf/core/ComponentDescription.h"
#include "asf/core/ContextData.h"
#include "asf/core/Logger.h"
#include "asf/core/ProvidedPort.h"
#include "asf/core/RequiredPort.h"
#include "asf/core/SignalHandler.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusImportedPort.h"
#include "com/bosch/cm/asf/lang/dbus/Connectors.h"
#include "com/bosch/cm/asf/lang/dbus/ConnectorsJson.h"
#include "excessive_write/sources/writeprofilerApp.h"
#include "excessive_write/sources/writeprofilerAppComponent.h"
#include <cstdio>
#include <string>

/**
 * If the meaning of "writeprofilerApp" isn't clear, then there should be a description here.
 */

namespace excessive_write {
namespace sources {

DEFINE_LOGGER_AND_LEVEL (_logger, "/excessive_write/sources/writeprofilerApp", Info);

/* static */ const char* writeprofilerApp::lcmManager = "lcmManager";

static const char* helpMessage =
    "--logconfig <file>     Read the logging configuration from <file>\n"
    "                       see the ASF User Guide, section 6.3. Logging API\n"
    "--help                 Print this help message\n";

bool WriteprofilerApp_enabledASFSignalHandler = false;

void importWriteprofilerApp() {
    ::asf::core::Application* app = ::asf::core::Application::getApplication();
    LOG_ASSERT_FATAL_MSG_STATIC(app, "Can't attach WriteprofilerApp, because no Application is instantiated");

    // Expression

    ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector dbusSystemConnector;
    {
        ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector __expression0;
        {
            __expression0.setBusType(::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector::BusType__System);
        }
        dbusSystemConnector = __expression0;
    }
    {
        std::string jsonPayload;
        serializeJson (dbusSystemConnector, jsonPayload);
        LOG_INFO_STATIC ("Creating connector %s (%s), configuration: %s", "dbusSystemConnector", "DBusConnector", jsonPayload.c_str());
    }
    ::boost::shared_ptr< ::asf::dbus::DBusConnector > dbusSystemConnector_(new ::asf::dbus::DBusConnector(*app, dbusSystemConnector));
    app->addStarter(dbusSystemConnector_);

    // Thread 'writeprofilerApp1'

    ::asf::core::ComponentContainerSharedPtr WriteprofilerApp1(new ::asf::core::ComponentContainer("writeprofilerApp1", ::asf::core::ThreadConfiguration(1)));
    app->addContainer (WriteprofilerApp1);

        // Component 'writeprofilerAppComponent lcmManager'

        ::boost::shared_ptr< ::asf::core::ComponentFactory< ::excessive_write::sources::writeprofilerAppComponent > > lcmManagerFactory(new ::asf::core::ComponentFactory< ::excessive_write::sources::writeprofilerAppComponent >);
        ::asf::core::ComponentDescriptionSharedPtr lcmManagerDescription(new ::asf::core::ComponentDescription(1, "lcmManager", /* immediate = */ true, /* threadBridge = */ false, lcmManagerFactory));
        WriteprofilerApp1->addComponentDescription(lcmManagerDescription);

            // Port 'ConsumerPort'

            ::asf::core::RequiredPort& lcmManager_ConsumerPort = lcmManagerDescription->addRequiredPort (::asf::core::RequiredPort ("org.genivi.NodeStateManager.Consumer", "ConsumerPort"));
            (void)lcmManager_ConsumerPort; // prevent unused variable warning

            // Port 'LifecycleControlPort'

            ::asf::core::RequiredPort& lcmManager_LifecycleControlPort = lcmManagerDescription->addRequiredPort (::asf::core::RequiredPort ("org.genivi.NodeStateManager.LifecycleControl", "LifecycleControlPort"));
            (void)lcmManager_LifecycleControlPort; // prevent unused variable warning

            // Port 'LifeCycleConsumerPort'

            ::asf::core::ProvidedPort& lcmManager_LifeCycleConsumerPort = lcmManagerDescription->addProvidedPort (::asf::core::ProvidedPort ("org.genivi.NodeStateManager.LifeCycleConsumer", "LifeCycleConsumerPort", false, false));
            (void)lcmManager_LifeCycleConsumerPort; // prevent unused variable warning

    // Expression

    ::asf::dbus::DBusImportedPort& LcmConsumer = dbusSystemConnector_->importByName (::std::string("org.genivi.NodeStateManager"), ::std::string("/org/genivi/NodeStateManager/Consumer"));
    LcmConsumer.setServiceName("org.genivi.NodeStateManager.Consumer");

    // Expression

    ::asf::dbus::DBusImportedPort& LcmLifecycleControl = dbusSystemConnector_->importByName (::std::string("org.genivi.NodeStateManager"), ::std::string("/org/genivi/NodeStateManager/LifecycleControl"));
    LcmLifecycleControl.setServiceName("org.genivi.NodeStateManager.LifecycleControl");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (lcmManager_ConsumerPort, LcmConsumer);

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (lcmManager_LifecycleControlPort, LcmLifecycleControl);

    // Expression

    dbusSystemConnector_->exportByName (lcmManager_LifeCycleConsumerPort, ::std::string("/org/genivi/NodeStateManager/LifeCycleConsumer/writeprofilerAppComponent"));


    LOG_INFO_STATIC("Starting application 'writeprofilerApp' version 1.0.0");

    app->start();
}

int executeWriteprofilerApp(int argc, char* argv[]) {
    ::asf::core::ContextData context;

    const char* logConfigFile = 0;
    std::vector<std::string> arguments;

    for (int i=1; i<argc; i++) {
        if (std::string(argv[i]) == "--logconfig" && i+1 < argc) {
            // ignore lint warning e850: modification of i inside loop is safe
            logConfigFile = argv[++i];
        } else {
            if (std::string(argv[i]) == "--help") {
                printf ("%s", helpMessage);
                exit (0);
            } else {
                arguments.push_back (argv[i]);
            }
        }
    }

    if (logConfigFile == 0) {
        ::asf::core::Logger::setupLogging ("excessive_write.sources", "writeprofilerApp");
    } else {
        ::asf::core::Logger::setupLogging ("excessive_write.sources", "writeprofilerApp", logConfigFile);
    }

    LOG_INFO_STATIC("%s ASF signal handler", WriteprofilerApp_enabledASFSignalHandler ? "Enabled" : "Disabled" );

    ::asf::core::Application* app = ::asf::core::Application::createApplication("excessive_write.sources", "writeprofilerApp", ::asf::core::Version(1, 0, 0, ""), arguments);

    LOG_ASSERT_FATAL_MSG_STATIC(app, "Can't create writeprofilerApp");

    app->enableExceptionHandler(true);

    importWriteprofilerApp();

    int exitCode = app->waitForCompletion();
    ::asf::core::Application::deleteApplication();

    return exitCode;
}

} // namespace sources
} // namespace excessive_write

int main(int argc, char* argv[]) {
    ::excessive_write::sources::WriteprofilerApp_enabledASFSignalHandler = true;
    ::asf::core::SignalHandler asfSignalHandler;
    ::boost::shared_ptr< ::asf::threading::Thread > mainThread = ::asf::threading::Thread::attach();
    return ::excessive_write::sources::executeWriteprofilerApp(argc, argv);
}

