#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef ASF_SYSTEMADAPTERFACTORYSERVICE_H
#define ASF_SYSTEMADAPTERFACTORYSERVICE_H

#include "asf/cms/CmsTypes.h"
#include "asf/core/Internal.h"
#include "asf/core/Logger.h"
#include "asf/core/Payload.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "asf/core/VersionCheck.h"
#include <cstddef>
#include <cstring>
#include <string>
#include <vector>

/**
 * If the meaning of "SystemAdapterFactoryService" isn't clear, then there should be a description here.
 */

namespace asf {
namespace SystemAdapterFactoryService {

ASF_GENERATOR_VERSION_CHECK_DECLARE

static const int VERSION_MAJOR = 0;

static const int VERSION_MINOR = 0;

static const int VERSION_PATCH = 1;

static const int REGISTER_MODULE__ID = -657851665;

static const int CREATE_SYSTEM_ADAPTER__ID = -1794388348;

// forward declarations
class RegisterModuleRequest;

class RegisterModuleResponse;

class CreateSystemAdapterRequest;

class CreateSystemAdapterResponse;

// type definitions
/**
 * If the meaning of "registerModule" isn't clear, then there should be a description here.
 */
typedef ::asf::cms::CmsTypes::BaseError RegisterModuleError;

/**
 * If the meaning of "createSystemAdapter" isn't clear, then there should be a description here.
 */
typedef ::asf::cms::CmsTypes::BaseError CreateSystemAdapterError;


/**
 * If the meaning of "registerModule" isn't clear, then there should be a description here.
 */
class RegisterModuleRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RegisterModuleRequest ();

    /**
     * Copy constructor
     */
    inline  RegisterModuleRequest (const RegisterModuleRequest &rhs);

    /**
     * All fields constructor
     */
    inline  RegisterModuleRequest (const ::std::string& moduleName_, const ::std::vector< uint32 >& iidList_);

    /**
     * Destructor
     */
    inline virtual  ~RegisterModuleRequest();

    /**
     * Assignment operator
     */
    inline RegisterModuleRequest& operator = (const RegisterModuleRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RegisterModuleRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RegisterModuleRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RegisterModuleRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RegisterModuleRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "moduleName"

    static const int kModuleName = 0;

    /**
     * Clears the field "moduleName".
     *
     * The field will be set to its default value. The hasModuleName()
     * method will return false.
     */
    inline void clearModuleName();

    /**
     * Checks whether the field "moduleName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setModuleName()). Otherwise it will return false.
     */
    inline bool hasModuleName () const;

    /**
     * Returns the value of the member "moduleName".
     *
     * If the meaning of "moduleName" isn't clear, then there should be a description here.
     *
     * @return The value of the field "moduleName"
     */
    inline const ::std::string& getModuleName () const;

    /**
     * Retrieves the value of the field "moduleName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "moduleName".
     */
    inline ::std::string& getModuleNameMutable ();

    /**
     * Sets the value of the member "moduleName".
     *
     * If the meaning of "moduleName" isn't clear, then there should be a description here.
     *
     * @param moduleName The value which will be set
     */
    inline void setModuleName (const ::std::string& moduleName_);

    /**
     * Sets the value of the member "moduleName".
     *
     * If the meaning of "moduleName" isn't clear, then there should be a description here.
     *
     * @param moduleName The value which will be set
     */
    inline void setModuleName (const char* moduleName_);

    /**
     * Sets the value of the member "moduleName".
     *
     * If the meaning of "moduleName" isn't clear, then there should be a description here.
     *
     * @param moduleName The value which will be set
     */
    inline void setModuleName (const char* value, size_t size);

    /**
     * Release the object stored in the field "moduleName".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "moduleName"
     */
    inline ::std::string* releaseModuleName();

    /**
     * Replace the field "moduleName".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceModuleName (::std::string* moduleName_);

    // API of field "iidList"

    static const int kIidList = 1;

    /**
     * Clears the field "iidList".
     *
     * The field will be set to its default value. The hasIidList()
     * method will return false.
     */
    inline void clearIidList();

    /**
     * Checks whether the field "iidList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setIidList()). Otherwise it will return false.
     */
    inline bool hasIidList () const;

    /**
     * Returns the value of the member "iidList".
     *
     * If the meaning of "iidList" isn't clear, then there should be a description here.
     *
     * @return The value of the field "iidList"
     */
    inline const ::std::vector< uint32 >& getIidList () const;

    /**
     * Retrieves the value of the field "iidList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "iidList".
     */
    inline ::std::vector< uint32 >& getIidListMutable ();

    /**
     * Sets the value of the member "iidList".
     *
     * If the meaning of "iidList" isn't clear, then there should be a description here.
     *
     * @param iidList The value which will be set
     */
    inline void setIidList (const ::std::vector< uint32 >& iidList_);

    /**
     * Release the object stored in the field "iidList".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "iidList"
     */
    inline ::std::vector< uint32 >* releaseIidList();

    /**
     * Replace the field "iidList".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceIidList (::std::vector< uint32 >* iidList_);

    static const RegisterModuleRequest &getDefaultInstance();

private:

    static const ::std::vector< uint32 >& getUint32List_DefaultInstance ();

    inline void set_has_moduleName ();

    inline void clear_has_moduleName ();

    inline void set_has_iidList ();

    inline void clear_has_iidList ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string* _moduleName;

    ::std::vector< uint32 >* _iidList;

};

/**
 * If the meaning of "registerModule" isn't clear, then there should be a description here.
 */
class RegisterModuleResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RegisterModuleResponse ();

    /**
     * Copy constructor
     */
    inline  RegisterModuleResponse (const RegisterModuleResponse &rhs);

    /**
     * All fields constructor
     */
    inline  RegisterModuleResponse (const ::std::string& moduleName_, uint32 result_);

    /**
     * Destructor
     */
    inline virtual  ~RegisterModuleResponse();

    /**
     * Assignment operator
     */
    inline RegisterModuleResponse& operator = (const RegisterModuleResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RegisterModuleResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RegisterModuleResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RegisterModuleResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RegisterModuleResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "moduleName"

    static const int kModuleName = 0;

    /**
     * Clears the field "moduleName".
     *
     * The field will be set to its default value. The hasModuleName()
     * method will return false.
     */
    inline void clearModuleName();

    /**
     * Checks whether the field "moduleName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setModuleName()). Otherwise it will return false.
     */
    inline bool hasModuleName () const;

    /**
     * Returns the value of the member "moduleName".
     *
     * If the meaning of "moduleName" isn't clear, then there should be a description here.
     *
     * @return The value of the field "moduleName"
     */
    inline const ::std::string& getModuleName () const;

    /**
     * Retrieves the value of the field "moduleName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "moduleName".
     */
    inline ::std::string& getModuleNameMutable ();

    /**
     * Sets the value of the member "moduleName".
     *
     * If the meaning of "moduleName" isn't clear, then there should be a description here.
     *
     * @param moduleName The value which will be set
     */
    inline void setModuleName (const ::std::string& moduleName_);

    /**
     * Sets the value of the member "moduleName".
     *
     * If the meaning of "moduleName" isn't clear, then there should be a description here.
     *
     * @param moduleName The value which will be set
     */
    inline void setModuleName (const char* moduleName_);

    /**
     * Sets the value of the member "moduleName".
     *
     * If the meaning of "moduleName" isn't clear, then there should be a description here.
     *
     * @param moduleName The value which will be set
     */
    inline void setModuleName (const char* value, size_t size);

    /**
     * Release the object stored in the field "moduleName".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "moduleName"
     */
    inline ::std::string* releaseModuleName();

    /**
     * Replace the field "moduleName".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceModuleName (::std::string* moduleName_);

    // API of field "result"

    static const int kResult = 1;

    /**
     * Clears the field "result".
     *
     * The field will be set to its default value. The hasResult()
     * method will return false.
     */
    inline void clearResult();

    /**
     * Checks whether the field "result" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResult()). Otherwise it will return false.
     */
    inline bool hasResult () const;

    /**
     * Returns the value of the member "result".
     *
     * If the meaning of "result" isn't clear, then there should be a description here.
     *
     * @return The value of the field "result"
     */
    inline uint32 getResult () const;

    /**
     * Sets the value of the member "result".
     *
     * If the meaning of "result" isn't clear, then there should be a description here.
     *
     * @param result The value which will be set
     */
    inline void setResult (uint32 result_);

    static const RegisterModuleResponse &getDefaultInstance();

private:

    inline void set_has_moduleName ();

    inline void clear_has_moduleName ();

    inline void set_has_result ();

    inline void clear_has_result ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string* _moduleName;

    uint32 _result;

};

/**
 * If the meaning of "createSystemAdapter" isn't clear, then there should be a description here.
 */
class CreateSystemAdapterRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CreateSystemAdapterRequest ();

    /**
     * Copy constructor
     */
    inline  CreateSystemAdapterRequest (const CreateSystemAdapterRequest &rhs);

    /**
     * All fields constructor
     */
    inline  CreateSystemAdapterRequest (uint32 iid_);

    /**
     * Destructor
     */
    inline virtual  ~CreateSystemAdapterRequest();

    /**
     * Assignment operator
     */
    inline CreateSystemAdapterRequest& operator = (const CreateSystemAdapterRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CreateSystemAdapterRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CreateSystemAdapterRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CreateSystemAdapterRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CreateSystemAdapterRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "iid"

    static const int kIid = 0;

    /**
     * Clears the field "iid".
     *
     * The field will be set to its default value. The hasIid()
     * method will return false.
     */
    inline void clearIid();

    /**
     * Checks whether the field "iid" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setIid()). Otherwise it will return false.
     */
    inline bool hasIid () const;

    /**
     * Returns the value of the member "iid".
     *
     * If the meaning of "iid" isn't clear, then there should be a description here.
     *
     * @return The value of the field "iid"
     */
    inline uint32 getIid () const;

    /**
     * Sets the value of the member "iid".
     *
     * If the meaning of "iid" isn't clear, then there should be a description here.
     *
     * @param iid The value which will be set
     */
    inline void setIid (uint32 iid_);

    static const CreateSystemAdapterRequest &getDefaultInstance();

private:

    inline void set_has_iid ();

    inline void clear_has_iid ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _iid;

};

/**
 * If the meaning of "createSystemAdapter" isn't clear, then there should be a description here.
 */
class CreateSystemAdapterResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CreateSystemAdapterResponse ();

    /**
     * Copy constructor
     */
    inline  CreateSystemAdapterResponse (const CreateSystemAdapterResponse &rhs);

    /**
     * All fields constructor
     */
    inline  CreateSystemAdapterResponse (uint32 iid_, uint32 result_);

    /**
     * Destructor
     */
    inline virtual  ~CreateSystemAdapterResponse();

    /**
     * Assignment operator
     */
    inline CreateSystemAdapterResponse& operator = (const CreateSystemAdapterResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CreateSystemAdapterResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CreateSystemAdapterResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CreateSystemAdapterResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CreateSystemAdapterResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "iid"

    static const int kIid = 0;

    /**
     * Clears the field "iid".
     *
     * The field will be set to its default value. The hasIid()
     * method will return false.
     */
    inline void clearIid();

    /**
     * Checks whether the field "iid" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setIid()). Otherwise it will return false.
     */
    inline bool hasIid () const;

    /**
     * Returns the value of the member "iid".
     *
     * If the meaning of "iid" isn't clear, then there should be a description here.
     *
     * @return The value of the field "iid"
     */
    inline uint32 getIid () const;

    /**
     * Sets the value of the member "iid".
     *
     * If the meaning of "iid" isn't clear, then there should be a description here.
     *
     * @param iid The value which will be set
     */
    inline void setIid (uint32 iid_);

    // API of field "result"

    static const int kResult = 1;

    /**
     * Clears the field "result".
     *
     * The field will be set to its default value. The hasResult()
     * method will return false.
     */
    inline void clearResult();

    /**
     * Checks whether the field "result" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResult()). Otherwise it will return false.
     */
    inline bool hasResult () const;

    /**
     * Returns the value of the member "result".
     *
     * If the meaning of "result" isn't clear, then there should be a description here.
     *
     * @return The value of the field "result"
     */
    inline uint32 getResult () const;

    /**
     * Sets the value of the member "result".
     *
     * If the meaning of "result" isn't clear, then there should be a description here.
     *
     * @param result The value which will be set
     */
    inline void setResult (uint32 result_);

    static const CreateSystemAdapterResponse &getDefaultInstance();

private:

    inline void set_has_iid ();

    inline void clear_has_iid ();

    inline void set_has_result ();

    inline void clear_has_result ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint32 _iid;

    uint32 _result;

};

inline  RegisterModuleRequest::RegisterModuleRequest ()  :
    _moduleName (NULL),
    _iidList (NULL)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RegisterModuleRequest::RegisterModuleRequest (const RegisterModuleRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _moduleName (NULL),
    _iidList (NULL)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RegisterModuleRequest::RegisterModuleRequest (const ::std::string& moduleName_, const ::std::vector< uint32 >& iidList_)  :
    _moduleName (new ::std::string(moduleName_)),
    _iidList (new ::std::vector< uint32 >(iidList_))
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (moduleName_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  RegisterModuleRequest::~RegisterModuleRequest() {
    delete _moduleName;
    delete _iidList;
}

inline RegisterModuleRequest& RegisterModuleRequest::operator = (const RegisterModuleRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasModuleName()) {
            setModuleName(rhs.getModuleName());
        } else {
            clearModuleName();
        }
        if (rhs.hasIidList()) {
            setIidList(rhs.getIidList());
        } else {
            clearIidList();
        }
    }
    return *this;
}

inline bool RegisterModuleRequest::operator == (const RegisterModuleRequest& rhs) const {
    return (((!hasModuleName() && !rhs.hasModuleName()) || getModuleName() == rhs.getModuleName()) &&
        ((!hasIidList() && !rhs.hasIidList()) || getIidList() == rhs.getIidList()));
}

inline bool RegisterModuleRequest::operator != (const RegisterModuleRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool RegisterModuleRequest::operator < (const RegisterModuleRequest& rhs) const {
    if (hasModuleName() || rhs.hasModuleName()) {
        if (getModuleName() < rhs.getModuleName()) return true;
        if (getModuleName() > rhs.getModuleName()) return false;
    }
    if (hasIidList() || rhs.hasIidList()) {
        if (getIidList() < rhs.getIidList()) return true;
        if (getIidList() > rhs.getIidList()) return false;
    }
    return false;
}

inline ::asf::core::Payload* RegisterModuleRequest::clone() {
    return new RegisterModuleRequest(*this);
}

inline bool RegisterModuleRequest::operator > (const RegisterModuleRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RegisterModuleRequest::clear() {
    clearModuleName();
    clearIidList();
}

inline void RegisterModuleRequest::clearModuleName() {
    if (hasModuleName()) {
         clear_has_moduleName();
        if (_moduleName != NULL) {
            _moduleName->clear();
        }
     }
}

inline bool RegisterModuleRequest::hasModuleName () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& RegisterModuleRequest::getModuleName () const {
    if (_moduleName == NULL) {
        return ::asf::core::theEmptyString;
    }
    return *_moduleName;
}

inline ::std::string& RegisterModuleRequest::getModuleNameMutable () {
    set_has_moduleName();
    if (_moduleName == NULL) {
        _moduleName = new ::std::string ();
        CHECK_ALLOCATION( _moduleName );
    }
    return *_moduleName;
}

inline void RegisterModuleRequest::setModuleName (const ::std::string& moduleName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (moduleName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_moduleName();
    if (this->_moduleName == NULL) {
        this->_moduleName = new ::std::string (moduleName_);
        CHECK_ALLOCATION( this->_moduleName );
    } else {
        *this->_moduleName = moduleName_;
    }
}

inline void RegisterModuleRequest::setModuleName (const char* moduleName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (moduleName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_moduleName();
    if (this->_moduleName == NULL) {
        this->_moduleName = new ::std::string (moduleName_);
        CHECK_ALLOCATION( this->_moduleName );
    } else {
        this->_moduleName->assign(moduleName_);
    }
}

inline void RegisterModuleRequest::setModuleName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_moduleName();
    if (this->_moduleName == NULL) {
        this->_moduleName = new ::std::string (value, size);
        CHECK_ALLOCATION( this->_moduleName );
    } else {
        this->_moduleName->assign(value, size);
    }
}

inline ::std::string* RegisterModuleRequest::releaseModuleName() {
    clear_has_moduleName();
    ::std::string* temp = _moduleName;
    this->_moduleName = NULL;
    return temp;
}

inline void RegisterModuleRequest::replaceModuleName (::std::string* moduleName_) {
    set_has_moduleName();
    if (this->_moduleName != moduleName_) {
        if (this->_moduleName != NULL) {
            delete this->_moduleName;
        }
        this->_moduleName = moduleName_;
    }
}

inline void RegisterModuleRequest::clearIidList() {
    if (hasIidList()) {
         clear_has_iidList();
        if (_iidList != NULL) {
            _iidList->clear();
        }
     }
}

inline bool RegisterModuleRequest::hasIidList () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::vector< uint32 >& RegisterModuleRequest::getIidList () const {
    if (_iidList == NULL) {
        return getUint32List_DefaultInstance();
    }
    return *_iidList;
}

inline ::std::vector< uint32 >& RegisterModuleRequest::getIidListMutable () {
    set_has_iidList();
    if (_iidList == NULL) {
        _iidList = new ::std::vector< uint32 > ();
        CHECK_ALLOCATION( _iidList );
    }
    return *_iidList;
}

inline void RegisterModuleRequest::setIidList (const ::std::vector< uint32 >& iidList_) {
    set_has_iidList();
    if (this->_iidList == NULL) {
        this->_iidList = new ::std::vector< uint32 > (iidList_);
        CHECK_ALLOCATION( this->_iidList );
    } else {
        *this->_iidList = iidList_;
    }
}

inline ::std::vector< uint32 >* RegisterModuleRequest::releaseIidList() {
    clear_has_iidList();
    ::std::vector< uint32 >* temp = _iidList;
    this->_iidList = NULL;
    return temp;
}

inline void RegisterModuleRequest::replaceIidList (::std::vector< uint32 >* iidList_) {
    set_has_iidList();
    if (this->_iidList != iidList_) {
        if (this->_iidList != NULL) {
            delete this->_iidList;
        }
        this->_iidList = iidList_;
    }
}

inline void RegisterModuleRequest::set_has_moduleName () {
    _has_bits_[0] |= 1u << 0;
}

inline void RegisterModuleRequest::clear_has_moduleName () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void RegisterModuleRequest::set_has_iidList () {
    _has_bits_[0] |= 1u << 1;
}

inline void RegisterModuleRequest::clear_has_iidList () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  RegisterModuleResponse::RegisterModuleResponse ()  :
    _moduleName (NULL),
    _result (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RegisterModuleResponse::RegisterModuleResponse (const RegisterModuleResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _moduleName (NULL),
    _result (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RegisterModuleResponse::RegisterModuleResponse (const ::std::string& moduleName_, uint32 result_)  :
    _moduleName (new ::std::string(moduleName_)),
    _result (result_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (moduleName_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  RegisterModuleResponse::~RegisterModuleResponse() {
    delete _moduleName;
}

inline RegisterModuleResponse& RegisterModuleResponse::operator = (const RegisterModuleResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasModuleName()) {
            setModuleName(rhs.getModuleName());
        } else {
            clearModuleName();
        }
        if (rhs.hasResult()) {
            setResult(rhs.getResult());
        } else {
            clearResult();
        }
    }
    return *this;
}

inline bool RegisterModuleResponse::operator == (const RegisterModuleResponse& rhs) const {
    return (((!hasModuleName() && !rhs.hasModuleName()) || getModuleName() == rhs.getModuleName()) &&
        ((!hasResult() && !rhs.hasResult()) || getResult() == rhs.getResult()));
}

inline bool RegisterModuleResponse::operator != (const RegisterModuleResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool RegisterModuleResponse::operator < (const RegisterModuleResponse& rhs) const {
    if (hasModuleName() || rhs.hasModuleName()) {
        if (getModuleName() < rhs.getModuleName()) return true;
        if (getModuleName() > rhs.getModuleName()) return false;
    }
    if (hasResult() || rhs.hasResult()) {
        if (getResult() < rhs.getResult()) return true;
        if (getResult() > rhs.getResult()) return false;
    }
    return false;
}

inline ::asf::core::Payload* RegisterModuleResponse::clone() {
    return new RegisterModuleResponse(*this);
}

inline bool RegisterModuleResponse::operator > (const RegisterModuleResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RegisterModuleResponse::clear() {
    clearModuleName();
    clearResult();
}

inline void RegisterModuleResponse::clearModuleName() {
    if (hasModuleName()) {
         clear_has_moduleName();
        if (_moduleName != NULL) {
            _moduleName->clear();
        }
     }
}

inline bool RegisterModuleResponse::hasModuleName () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& RegisterModuleResponse::getModuleName () const {
    if (_moduleName == NULL) {
        return ::asf::core::theEmptyString;
    }
    return *_moduleName;
}

inline ::std::string& RegisterModuleResponse::getModuleNameMutable () {
    set_has_moduleName();
    if (_moduleName == NULL) {
        _moduleName = new ::std::string ();
        CHECK_ALLOCATION( _moduleName );
    }
    return *_moduleName;
}

inline void RegisterModuleResponse::setModuleName (const ::std::string& moduleName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (moduleName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_moduleName();
    if (this->_moduleName == NULL) {
        this->_moduleName = new ::std::string (moduleName_);
        CHECK_ALLOCATION( this->_moduleName );
    } else {
        *this->_moduleName = moduleName_;
    }
}

inline void RegisterModuleResponse::setModuleName (const char* moduleName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (moduleName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_moduleName();
    if (this->_moduleName == NULL) {
        this->_moduleName = new ::std::string (moduleName_);
        CHECK_ALLOCATION( this->_moduleName );
    } else {
        this->_moduleName->assign(moduleName_);
    }
}

inline void RegisterModuleResponse::setModuleName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_moduleName();
    if (this->_moduleName == NULL) {
        this->_moduleName = new ::std::string (value, size);
        CHECK_ALLOCATION( this->_moduleName );
    } else {
        this->_moduleName->assign(value, size);
    }
}

inline ::std::string* RegisterModuleResponse::releaseModuleName() {
    clear_has_moduleName();
    ::std::string* temp = _moduleName;
    this->_moduleName = NULL;
    return temp;
}

inline void RegisterModuleResponse::replaceModuleName (::std::string* moduleName_) {
    set_has_moduleName();
    if (this->_moduleName != moduleName_) {
        if (this->_moduleName != NULL) {
            delete this->_moduleName;
        }
        this->_moduleName = moduleName_;
    }
}

inline void RegisterModuleResponse::clearResult() {
    if (hasResult()) {
         clear_has_result();
        _result = 0u;
     }
}

inline bool RegisterModuleResponse::hasResult () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 RegisterModuleResponse::getResult () const {
    return _result;
}

inline void RegisterModuleResponse::setResult (uint32 result_) {
    set_has_result();
    this->_result = result_;
}

inline void RegisterModuleResponse::set_has_moduleName () {
    _has_bits_[0] |= 1u << 0;
}

inline void RegisterModuleResponse::clear_has_moduleName () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void RegisterModuleResponse::set_has_result () {
    _has_bits_[0] |= 1u << 1;
}

inline void RegisterModuleResponse::clear_has_result () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  CreateSystemAdapterRequest::CreateSystemAdapterRequest ()  :
    _iid (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  CreateSystemAdapterRequest::CreateSystemAdapterRequest (const CreateSystemAdapterRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _iid (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  CreateSystemAdapterRequest::CreateSystemAdapterRequest (uint32 iid_)  :
    _iid (iid_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  CreateSystemAdapterRequest::~CreateSystemAdapterRequest() {
}

inline CreateSystemAdapterRequest& CreateSystemAdapterRequest::operator = (const CreateSystemAdapterRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasIid()) {
            setIid(rhs.getIid());
        } else {
            clearIid();
        }
    }
    return *this;
}

inline bool CreateSystemAdapterRequest::operator == (const CreateSystemAdapterRequest& rhs) const {
    return (((!hasIid() && !rhs.hasIid()) || getIid() == rhs.getIid()));
}

inline bool CreateSystemAdapterRequest::operator != (const CreateSystemAdapterRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool CreateSystemAdapterRequest::operator < (const CreateSystemAdapterRequest& rhs) const {
    if (hasIid() || rhs.hasIid()) {
        if (getIid() < rhs.getIid()) return true;
        if (getIid() > rhs.getIid()) return false;
    }
    return false;
}

inline ::asf::core::Payload* CreateSystemAdapterRequest::clone() {
    return new CreateSystemAdapterRequest(*this);
}

inline bool CreateSystemAdapterRequest::operator > (const CreateSystemAdapterRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void CreateSystemAdapterRequest::clear() {
    clearIid();
}

inline void CreateSystemAdapterRequest::clearIid() {
    if (hasIid()) {
         clear_has_iid();
        _iid = 0u;
     }
}

inline bool CreateSystemAdapterRequest::hasIid () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 CreateSystemAdapterRequest::getIid () const {
    return _iid;
}

inline void CreateSystemAdapterRequest::setIid (uint32 iid_) {
    set_has_iid();
    this->_iid = iid_;
}

inline void CreateSystemAdapterRequest::set_has_iid () {
    _has_bits_[0] |= 1u << 0;
}

inline void CreateSystemAdapterRequest::clear_has_iid () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  CreateSystemAdapterResponse::CreateSystemAdapterResponse ()  :
    _iid (0u),
    _result (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  CreateSystemAdapterResponse::CreateSystemAdapterResponse (const CreateSystemAdapterResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _iid (0u),
    _result (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  CreateSystemAdapterResponse::CreateSystemAdapterResponse (uint32 iid_, uint32 result_)  :
    _iid (iid_),
    _result (result_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  CreateSystemAdapterResponse::~CreateSystemAdapterResponse() {
}

inline CreateSystemAdapterResponse& CreateSystemAdapterResponse::operator = (const CreateSystemAdapterResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasIid()) {
            setIid(rhs.getIid());
        } else {
            clearIid();
        }
        if (rhs.hasResult()) {
            setResult(rhs.getResult());
        } else {
            clearResult();
        }
    }
    return *this;
}

inline bool CreateSystemAdapterResponse::operator == (const CreateSystemAdapterResponse& rhs) const {
    return (((!hasIid() && !rhs.hasIid()) || getIid() == rhs.getIid()) &&
        ((!hasResult() && !rhs.hasResult()) || getResult() == rhs.getResult()));
}

inline bool CreateSystemAdapterResponse::operator != (const CreateSystemAdapterResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool CreateSystemAdapterResponse::operator < (const CreateSystemAdapterResponse& rhs) const {
    if (hasIid() || rhs.hasIid()) {
        if (getIid() < rhs.getIid()) return true;
        if (getIid() > rhs.getIid()) return false;
    }
    if (hasResult() || rhs.hasResult()) {
        if (getResult() < rhs.getResult()) return true;
        if (getResult() > rhs.getResult()) return false;
    }
    return false;
}

inline ::asf::core::Payload* CreateSystemAdapterResponse::clone() {
    return new CreateSystemAdapterResponse(*this);
}

inline bool CreateSystemAdapterResponse::operator > (const CreateSystemAdapterResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void CreateSystemAdapterResponse::clear() {
    clearIid();
    clearResult();
}

inline void CreateSystemAdapterResponse::clearIid() {
    if (hasIid()) {
         clear_has_iid();
        _iid = 0u;
     }
}

inline bool CreateSystemAdapterResponse::hasIid () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 CreateSystemAdapterResponse::getIid () const {
    return _iid;
}

inline void CreateSystemAdapterResponse::setIid (uint32 iid_) {
    set_has_iid();
    this->_iid = iid_;
}

inline void CreateSystemAdapterResponse::clearResult() {
    if (hasResult()) {
         clear_has_result();
        _result = 0u;
     }
}

inline bool CreateSystemAdapterResponse::hasResult () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 CreateSystemAdapterResponse::getResult () const {
    return _result;
}

inline void CreateSystemAdapterResponse::setResult (uint32 result_) {
    set_has_result();
    this->_result = result_;
}

inline void CreateSystemAdapterResponse::set_has_iid () {
    _has_bits_[0] |= 1u << 0;
}

inline void CreateSystemAdapterResponse::clear_has_iid () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void CreateSystemAdapterResponse::set_has_result () {
    _has_bits_[0] |= 1u << 1;
}

inline void CreateSystemAdapterResponse::clear_has_result () {
    _has_bits_[0] &= ~ (1u << 1);
}

} // namespace SystemAdapterFactoryService
} // namespace asf

#endif // ASF_SYSTEMADAPTERFACTORYSERVICE_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
