/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusStubDelegate.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "org/bosch/cm/diagnosis/dbus/Diagnosis1/SystemSettings1.h"
#include "org/bosch/cm/diagnosis/dbus/Diagnosis1/SystemSettings1DBus.h"
#include "org/bosch/cm/diagnosis/dbus/Diagnosis1/SystemSettings1Json.h"
#include "org/bosch/cm/diagnosis/dbus/Diagnosis1/SystemSettings1Stub.h"
#include <string>
#include <vector>

#include "asf/dbus/DBusMessage.h"

namespace org {
namespace bosch {
namespace cm {
namespace diagnosis {
namespace dbus {
namespace Diagnosis1 {
namespace SystemSettings1 {

DEFINE_CLASS_LOGGER("/org/bosch/cm/diagnosis/dbus/Diagnosis1/SystemSettings1", SystemSettings1Stub);

static ::asf::dbus::DBusUtils::stringEntry methodsTable[] = {
    { 20, "ExecuteSystemSetting", 1 },
    { 20, "PrepareSystemSetting", 0 },
    { 21, "FinalizeSystemSetting", 2 },
};


class SystemSettings1StubDelegate : public ::asf::dbus::DBusStubDelegate {
public:

    SystemSettings1StubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger) :
        ::asf::dbus::DBusStubDelegate( stub, logger),
        _logger(logger)
    {}

    SystemSettings1StubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger, const std::string& objectPath) :
        ::asf::dbus::DBusStubDelegate( stub, logger, objectPath),
        _logger(logger) {}

    SystemSettings1StubDelegate(::asf::dbus::DBusStub* stub,
                               ::asf::core::Logger& logger,
                               ::asf::dbus::DBusConnector& connector,
                               const std::string& objectPath)
        : ::asf::dbus::DBusStubDelegate(
              stub, logger, connector, objectPath, "org.bosch.cm.diagnosis.dbus.Diagnosis1.SystemSettings1"),
          _logger(logger) {}

    virtual ~SystemSettings1StubDelegate() {}

    virtual void process(::asf::core::ServiceMessage& msg);

    const char* introspect() const;

    virtual void getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties);

    virtual void setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act);

    virtual void getProperty(const ::std::string& property, const act_t& act);

private:

    ::asf::core::Logger& _logger;

};

void SystemSettings1StubDelegate::process(::asf::core::ServiceMessage& msg) {
    ::asf::dbus::DBusMessage& message = static_cast< ::asf::dbus::DBusMessage& >(msg);
    LOG_DEBUG_STUB("Entering process(memberName='%s')", message.getMemberName().c_str());

    unsigned int methodIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (message.getMemberName().c_str(), message.getMemberName().length(), methodsTable, 3, methodIndex)) {
        switch (methodIndex) {
        case 0: {

            // method 'PrepareSystemSetting'

            LOG_DEBUG_STUB("process method '%s'", "PrepareSystemSetting");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), PrepareSystemSettingRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "PrepareSystemSetting", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< PrepareSystemSettingRequest > payload = ::boost::static_pointer_cast<PrepareSystemSettingRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<SystemSettings1Stub*>(getStub())->onPrepareSystemSettingRequest(payload);
            return;
        }
        case 1: {

            // method 'ExecuteSystemSetting'

            LOG_DEBUG_STUB("process method '%s'", "ExecuteSystemSetting");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ExecuteSystemSettingRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "ExecuteSystemSetting", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< ExecuteSystemSettingRequest > payload = ::boost::static_pointer_cast<ExecuteSystemSettingRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<SystemSettings1Stub*>(getStub())->onExecuteSystemSettingRequest(payload);
            return;
        }
        case 2: {

            // method 'FinalizeSystemSetting'

            LOG_DEBUG_STUB("process method '%s'", "FinalizeSystemSetting");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), FinalizeSystemSettingRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "FinalizeSystemSetting", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< FinalizeSystemSettingRequest > payload = ::boost::static_pointer_cast<FinalizeSystemSettingRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<SystemSettings1Stub*>(getStub())->onFinalizeSystemSettingRequest(payload);
            return;
        }
        default:
            break;
        }
    }
    LOG_FATAL_STUB("can't process message %s", message.getMemberName().c_str());
}

const char* SystemSettings1StubDelegate::introspect() const {
    return     "<interface name=\"org.bosch.cm.diagnosis.dbus.Diagnosis1.SystemSettings1\">\n"
            "      <doc>\n"
            "        <line>Parameter passed back</line>\n"
            "        <line>Param 1: Type - byte : parameter type</line>\n"
            "        <line>Param 2: Type - array of bytes carrying the parameter value. The length depends on parameter type</line>\n"
            "      </doc>\n"
            "      <method name=\"PrepareSystemSetting\">\n"
            "        <doc>\n"
            "          <line>Asynchronous continuation token provided by the sender. cookie must not be changed and is sent back in response signal.</line>\n"
            "        </doc>\n"
            "        <arg direction=\"in\" name=\"sysSetID\" type=\"s\"/>\n"
            "        <arg direction=\"in\" name=\"sysSetType\" type=\"s\"/>\n"
            "        <arg direction=\"in\" name=\"extendedData\" type=\"a(yay)\"/>\n"
            "        <arg direction=\"in\" name=\"cookie\" type=\"u\"/>\n"
            "        <arg direction=\"out\" name=\"sysSetID\" type=\"s\"/>\n"
            "        <arg direction=\"out\" name=\"sysSetType\" type=\"s\"/>\n"
            "        <arg direction=\"out\" name=\"extendedData\" type=\"a(yay)\"/>\n"
            "        <arg direction=\"out\" name=\"returnCode\" type=\"u\"/>\n"
            "        <arg direction=\"out\" name=\"cookie\" type=\"u\"/>\n"
            "      </method>\n"
            "      <method name=\"ExecuteSystemSetting\">\n"
            "        <doc>\n"
            "          <line>Asynchronous continuation token provided by the sender. cookie must not be changed and is sent back in response signal.</line>\n"
            "        </doc>\n"
            "        <arg direction=\"in\" name=\"sysSetID\" type=\"s\"/>\n"
            "        <arg direction=\"in\" name=\"sysSetType\" type=\"s\"/>\n"
            "        <arg direction=\"in\" name=\"extendedData\" type=\"a(yay)\"/>\n"
            "        <arg direction=\"in\" name=\"cookie\" type=\"u\"/>\n"
            "        <arg direction=\"out\" name=\"sysSetID\" type=\"s\"/>\n"
            "        <arg direction=\"out\" name=\"sysSetType\" type=\"s\"/>\n"
            "        <arg direction=\"out\" name=\"extendedData\" type=\"a(yay)\"/>\n"
            "        <arg direction=\"out\" name=\"returnCode\" type=\"u\"/>\n"
            "        <arg direction=\"out\" name=\"cookie\" type=\"u\"/>\n"
            "      </method>\n"
            "      <method name=\"FinalizeSystemSetting\">\n"
            "        <doc>\n"
            "          <line>Asynchronous continuation token provided by the sender. cookie must not be changed and is sent back in response signal.</line>\n"
            "        </doc>\n"
            "        <arg direction=\"in\" name=\"sysSetID\" type=\"s\"/>\n"
            "        <arg direction=\"in\" name=\"sysSetType\" type=\"s\"/>\n"
            "        <arg direction=\"in\" name=\"extendedData\" type=\"a(yay)\"/>\n"
            "        <arg direction=\"in\" name=\"cookie\" type=\"u\"/>\n"
            "        <arg direction=\"out\" name=\"sysSetID\" type=\"s\"/>\n"
            "        <arg direction=\"out\" name=\"sysSetType\" type=\"s\"/>\n"
            "        <arg direction=\"out\" name=\"extendedData\" type=\"a(yay)\"/>\n"
            "        <arg direction=\"out\" name=\"returnCode\" type=\"u\"/>\n"
            "        <arg direction=\"out\" name=\"cookie\" type=\"u\"/>\n"
            "      </method>\n"
            "</interface>\n";
}

void SystemSettings1StubDelegate::getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) {
    (static_cast<SystemSettings1Stub*>(getStub()))->onGetAll (properties);
}

void SystemSettings1StubDelegate::setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act) {
    ((void)value);  // to get rid of unused variable warning
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendSetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

void SystemSettings1StubDelegate::getProperty(const ::std::string& property, const act_t& act) {
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendGetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

SystemSettings1Stub::SystemSettings1Stub (const std::string& portName) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new SystemSettings1StubDelegate(this, _logger);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

SystemSettings1Stub::SystemSettings1Stub (const std::string& portName, const std::string& objectPath) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new SystemSettings1StubDelegate(this, _logger, objectPath);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

SystemSettings1Stub::~SystemSettings1Stub() {
    delete _stubDelegate;
}

void  SystemSettings1Stub::sendPrepareSystemSettingResponse (const ::std::string& sysSetID, const ::std::string& sysSetType, const ::std::vector< PrepareSystemSettingResponseExtendedDataStruct >& extendedData, uint32 returnCode, uint32 cookie, act_t act) {
    PrepareSystemSettingResponse* payload = new PrepareSystemSettingResponse(sysSetID, sysSetType, extendedData, returnCode, cookie);
    DBUS_MESSAGE_REPLY(dbusMessage, "PrepareSystemSetting", PrepareSystemSettingResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "PrepareSystemSetting", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  SystemSettings1Stub::sendPrepareSystemSettingError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    PrepareSystemSettingError* payload = new PrepareSystemSettingError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "PrepareSystemSetting", PrepareSystemSettingError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "PrepareSystemSetting", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  SystemSettings1Stub::sendExecuteSystemSettingResponse (const ::std::string& sysSetID, const ::std::string& sysSetType, const ::std::vector< ExecuteSystemSettingResponseExtendedDataStruct >& extendedData, uint32 returnCode, uint32 cookie, act_t act) {
    ExecuteSystemSettingResponse* payload = new ExecuteSystemSettingResponse(sysSetID, sysSetType, extendedData, returnCode, cookie);
    DBUS_MESSAGE_REPLY(dbusMessage, "ExecuteSystemSetting", ExecuteSystemSettingResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "ExecuteSystemSetting", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  SystemSettings1Stub::sendExecuteSystemSettingError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    ExecuteSystemSettingError* payload = new ExecuteSystemSettingError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "ExecuteSystemSetting", ExecuteSystemSettingError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "ExecuteSystemSetting", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  SystemSettings1Stub::sendFinalizeSystemSettingResponse (const ::std::string& sysSetID, const ::std::string& sysSetType, const ::std::vector< FinalizeSystemSettingResponseExtendedDataStruct >& extendedData, uint32 returnCode, uint32 cookie, act_t act) {
    FinalizeSystemSettingResponse* payload = new FinalizeSystemSettingResponse(sysSetID, sysSetType, extendedData, returnCode, cookie);
    DBUS_MESSAGE_REPLY(dbusMessage, "FinalizeSystemSetting", FinalizeSystemSettingResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "FinalizeSystemSetting", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  SystemSettings1Stub::sendFinalizeSystemSettingError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    FinalizeSystemSettingError* payload = new FinalizeSystemSettingError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "FinalizeSystemSetting", FinalizeSystemSettingError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "FinalizeSystemSetting", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void SystemSettings1Stub::onGetAll(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) const {
    ((void)properties);  // to get rid of unused variable warning
}

} // namespace SystemSettings1
} // namespace Diagnosis1
} // namespace dbus
} // namespace diagnosis
} // namespace cm
} // namespace bosch
} // namespace org
