/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef ORG_BOSCH_CM_DIAGNOSIS_DBUS_DIAGNOSIS1_SYSTEMSETTINGS1PROXY_H
#define ORG_BOSCH_CM_DIAGNOSIS_DBUS_DIAGNOSIS1_SYSTEMSETTINGS1PROXY_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusProxy.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "com/bosch/cm/asf/lang/dbus/Connectors.h"
#include "org/bosch/cm/diagnosis/dbus/Diagnosis1/SystemSettings1.h"
#include <dbus/dbus.h>
#include <string>
#include <vector>

namespace org {
namespace bosch {
namespace cm {
namespace diagnosis {
namespace dbus {
namespace Diagnosis1 {
namespace SystemSettings1 {

class SystemSettings1Proxy;

class ExecuteSystemSettingCallbackIF {
public:
    virtual ~ExecuteSystemSettingCallbackIF() {}

    virtual void onExecuteSystemSettingError(const ::boost::shared_ptr< SystemSettings1Proxy >& proxy, const ::boost::shared_ptr< ExecuteSystemSettingError >& error) = 0;

    virtual void onExecuteSystemSettingResponse(const ::boost::shared_ptr< SystemSettings1Proxy >& proxy, const ::boost::shared_ptr< ExecuteSystemSettingResponse >& response) = 0;
};

class FinalizeSystemSettingCallbackIF {
public:
    virtual ~FinalizeSystemSettingCallbackIF() {}

    virtual void onFinalizeSystemSettingError(const ::boost::shared_ptr< SystemSettings1Proxy >& proxy, const ::boost::shared_ptr< FinalizeSystemSettingError >& error) = 0;

    virtual void onFinalizeSystemSettingResponse(const ::boost::shared_ptr< SystemSettings1Proxy >& proxy, const ::boost::shared_ptr< FinalizeSystemSettingResponse >& response) = 0;
};

class PrepareSystemSettingCallbackIF {
public:
    virtual ~PrepareSystemSettingCallbackIF() {}

    virtual void onPrepareSystemSettingError(const ::boost::shared_ptr< SystemSettings1Proxy >& proxy, const ::boost::shared_ptr< PrepareSystemSettingError >& error) = 0;

    virtual void onPrepareSystemSettingResponse(const ::boost::shared_ptr< SystemSettings1Proxy >& proxy, const ::boost::shared_ptr< PrepareSystemSettingResponse >& response) = 0;
};


/**
 * SystemSettings1Proxy is the client side representation of the D-Bus
 * service interface
 * 'org.bosch.cm.diagnosis.dbus.Diagnosis1.SystemSettings1' (specified in
 * file SystemSettings1.xml).
 *
 * Parameter passed back
 * Param 1: Type - byte : parameter type
 * Param 2: Type - array of bytes carrying the parameter value. The length depends on parameter type
 */
class SystemSettings1Proxy : public ::asf::dbus::DBusProxy
{
public:
    /**
     * Create a new instance of SystemSettings1Proxy.
     */
    static ::boost::shared_ptr< SystemSettings1Proxy > createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    /**
     * Create a new instance of SystemSettings1Proxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @deprecated use the createProxy() method with the parameter
     * ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector instead.
     */
    static ::boost::shared_ptr< SystemSettings1Proxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        ::DBusBusType busType,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector connectorOptions;
        connectorOptions.setBusType(::asf::dbus::DBusUtils::toOptions(busType).getBusType());
        return createProxy(portName, busName, objectPath, connectorOptions, serviceAvailable);
    }

    /**
     * Create a new instance of SystemSettings1Proxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     */
    static ::boost::shared_ptr< SystemSettings1Proxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        const ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector& connectorOptions,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        LOG_INFO_STATIC ("createProxy, create new proxy");
        ::boost::shared_ptr< SystemSettings1Proxy > proxyNew(new SystemSettings1Proxy(portName, serviceAvailable));
        ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew, busName, objectPath, connectorOptions);
        proxyNew->createHelperProxies(false);
        return proxyNew;
    }

    virtual ~SystemSettings1Proxy ();




    // Method 'PrepareSystemSetting'

    /**
     * Call the method 'PrepareSystemSetting'. This method sends a message to
     * the D-Bus server.
     *
     * <b>Documentation of 'PrepareSystemSetting'</b>:
     *
     * Asynchronous continuation token provided by the sender. cookie must not be changed and is sent back in response signal.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param sysSetID If the meaning of "sysSetID" isn't clear, then there should be a description here.
     *
     * @param sysSetType If the meaning of "sysSetType" isn't clear, then there should be a description here.
     *
     * @param extendedData If the meaning of "extendedData" isn't clear, then there should be a description here.
     *
     * @param cookie If the meaning of "cookie" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendPrepareSystemSettingRequest(PrepareSystemSettingCallbackIF& cb, const ::std::string& sysSetID, const ::std::string& sysSetType, const ::std::vector< PrepareSystemSettingRequestExtendedDataStruct >& extendedData, uint32 cookie) const;

    // Method 'ExecuteSystemSetting'

    /**
     * Call the method 'ExecuteSystemSetting'. This method sends a message to
     * the D-Bus server.
     *
     * <b>Documentation of 'ExecuteSystemSetting'</b>:
     *
     * Asynchronous continuation token provided by the sender. cookie must not be changed and is sent back in response signal.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param sysSetID If the meaning of "sysSetID" isn't clear, then there should be a description here.
     *
     * @param sysSetType If the meaning of "sysSetType" isn't clear, then there should be a description here.
     *
     * @param extendedData If the meaning of "extendedData" isn't clear, then there should be a description here.
     *
     * @param cookie If the meaning of "cookie" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendExecuteSystemSettingRequest(ExecuteSystemSettingCallbackIF& cb, const ::std::string& sysSetID, const ::std::string& sysSetType, const ::std::vector< ExecuteSystemSettingRequestExtendedDataStruct >& extendedData, uint32 cookie) const;

    // Method 'FinalizeSystemSetting'

    /**
     * Call the method 'FinalizeSystemSetting'. This method sends a message to
     * the D-Bus server.
     *
     * <b>Documentation of 'FinalizeSystemSetting'</b>:
     *
     * Asynchronous continuation token provided by the sender. cookie must not be changed and is sent back in response signal.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param sysSetID If the meaning of "sysSetID" isn't clear, then there should be a description here.
     *
     * @param sysSetType If the meaning of "sysSetType" isn't clear, then there should be a description here.
     *
     * @param extendedData If the meaning of "extendedData" isn't clear, then there should be a description here.
     *
     * @param cookie If the meaning of "cookie" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendFinalizeSystemSettingRequest(FinalizeSystemSettingCallbackIF& cb, const ::std::string& sysSetID, const ::std::string& sysSetType, const ::std::vector< FinalizeSystemSettingRequestExtendedDataStruct >& extendedData, uint32 cookie) const;


private:

    SystemSettings1Proxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    act_t addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const;

    act_t addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const;


    DECLARE_CLASS_LOGGER();

    friend class SystemSettings1ProxyCallback;
};

} // namespace SystemSettings1
} // namespace Diagnosis1
} // namespace dbus
} // namespace diagnosis
} // namespace cm
} // namespace bosch
} // namespace org

#endif // ORG_BOSCH_CM_DIAGNOSIS_DBUS_DIAGNOSIS1_SYSTEMSETTINGS1PROXY_H
