/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusStubDelegate.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "org/bosch/cm/diagnosis/dbus/Diagnosis1/Control1.h"
#include "org/bosch/cm/diagnosis/dbus/Diagnosis1/Control1DBus.h"
#include "org/bosch/cm/diagnosis/dbus/Diagnosis1/Control1Json.h"
#include "org/bosch/cm/diagnosis/dbus/Diagnosis1/Control1Stub.h"
#include <string>
#include <vector>

#include "asf/dbus/DBusMessage.h"

namespace org {
namespace bosch {
namespace cm {
namespace diagnosis {
namespace dbus {
namespace Diagnosis1 {
namespace Control1 {

DEFINE_CLASS_LOGGER("/org/bosch/cm/diagnosis/dbus/Diagnosis1/Control1", Control1Stub);

static ::asf::dbus::DBusUtils::stringEntry methodsTable[] = {
    { 18, "StartSystemSetting", 2 },
    { 20, "GetRemoteControlMode", 1 },
    { 20, "SetRemoteControlMode", 0 },
    { 26, "RemoteExecuteSystemSetting", 4 },
    { 26, "RemotePrepareSystemSetting", 3 },
    { 27, "RemoteFinalizeSystemSetting", 5 },
};


class Control1StubDelegate : public ::asf::dbus::DBusStubDelegate {
public:

    Control1StubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger) :
        ::asf::dbus::DBusStubDelegate( stub, logger),
        _logger(logger)
    {}

    Control1StubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger, const std::string& objectPath) :
        ::asf::dbus::DBusStubDelegate( stub, logger, objectPath),
        _logger(logger) {}

    Control1StubDelegate(::asf::dbus::DBusStub* stub,
                               ::asf::core::Logger& logger,
                               ::asf::dbus::DBusConnector& connector,
                               const std::string& objectPath)
        : ::asf::dbus::DBusStubDelegate(
              stub, logger, connector, objectPath, "org.bosch.cm.diagnosis.dbus.Diagnosis1.Control1"),
          _logger(logger) {}

    virtual ~Control1StubDelegate() {}

    virtual void process(::asf::core::ServiceMessage& msg);

    const char* introspect() const;

    virtual void getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties);

    virtual void setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act);

    virtual void getProperty(const ::std::string& property, const act_t& act);

private:

    ::asf::core::Logger& _logger;

};

void Control1StubDelegate::process(::asf::core::ServiceMessage& msg) {
    ::asf::dbus::DBusMessage& message = static_cast< ::asf::dbus::DBusMessage& >(msg);
    LOG_DEBUG_STUB("Entering process(memberName='%s')", message.getMemberName().c_str());

    unsigned int methodIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (message.getMemberName().c_str(), message.getMemberName().length(), methodsTable, 6, methodIndex)) {
        switch (methodIndex) {
        case 0: {

            // method 'SetRemoteControlMode'

            LOG_DEBUG_STUB("process method '%s'", "SetRemoteControlMode");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SetRemoteControlModeRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "SetRemoteControlMode", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< SetRemoteControlModeRequest > payload = ::boost::static_pointer_cast<SetRemoteControlModeRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<Control1Stub*>(getStub())->onSetRemoteControlModeRequest(payload);
            return;
        }
        case 1: {

            // method 'GetRemoteControlMode'

            LOG_DEBUG_STUB("process method '%s'", "GetRemoteControlMode");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GetRemoteControlModeRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "GetRemoteControlMode", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< GetRemoteControlModeRequest > payload = ::boost::static_pointer_cast<GetRemoteControlModeRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<Control1Stub*>(getStub())->onGetRemoteControlModeRequest(payload);
            return;
        }
        case 2: {

            // method 'StartSystemSetting'

            LOG_DEBUG_STUB("process method '%s'", "StartSystemSetting");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), StartSystemSettingRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "StartSystemSetting", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< StartSystemSettingRequest > payload = ::boost::static_pointer_cast<StartSystemSettingRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<Control1Stub*>(getStub())->onStartSystemSettingRequest(payload);
            return;
        }
        case 3: {

            // method 'RemotePrepareSystemSetting'

            LOG_DEBUG_STUB("process method '%s'", "RemotePrepareSystemSetting");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RemotePrepareSystemSettingRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "RemotePrepareSystemSetting", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< RemotePrepareSystemSettingRequest > payload = ::boost::static_pointer_cast<RemotePrepareSystemSettingRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<Control1Stub*>(getStub())->onRemotePrepareSystemSettingRequest(payload);
            return;
        }
        case 4: {

            // method 'RemoteExecuteSystemSetting'

            LOG_DEBUG_STUB("process method '%s'", "RemoteExecuteSystemSetting");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RemoteExecuteSystemSettingRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "RemoteExecuteSystemSetting", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< RemoteExecuteSystemSettingRequest > payload = ::boost::static_pointer_cast<RemoteExecuteSystemSettingRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<Control1Stub*>(getStub())->onRemoteExecuteSystemSettingRequest(payload);
            return;
        }
        case 5: {

            // method 'RemoteFinalizeSystemSetting'

            LOG_DEBUG_STUB("process method '%s'", "RemoteFinalizeSystemSetting");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RemoteFinalizeSystemSettingRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "RemoteFinalizeSystemSetting", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< RemoteFinalizeSystemSettingRequest > payload = ::boost::static_pointer_cast<RemoteFinalizeSystemSettingRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<Control1Stub*>(getStub())->onRemoteFinalizeSystemSettingRequest(payload);
            return;
        }
        default:
            break;
        }
    }
    LOG_FATAL_STUB("can't process message %s", message.getMemberName().c_str());
}

const char* Control1StubDelegate::introspect() const {
    return     "<interface name=\"org.bosch.cm.diagnosis.dbus.Diagnosis1.Control1\">\n"
            "      <doc>\n"
            "        <line>Parameter passed back</line>\n"
            "        <line>Param 1: Type - byte : parameter type</line>\n"
            "        <line>Param 2: Type - array of bytes carrying the parameter value. The length depends on parameter type</line>\n"
            "      </doc>\n"
            "      <method name=\"SetRemoteControlMode\">\n"
            "        <doc>\n"
            "          <line>Asynchronous continuation token provided by the sender in the method call. cookie must not be changed.</line>\n"
            "        </doc>\n"
            "        <arg direction=\"in\" name=\"area\" type=\"s\"/>\n"
            "        <arg direction=\"in\" name=\"mode\" type=\"s\"/>\n"
            "        <arg direction=\"in\" name=\"cookie\" type=\"u\"/>\n"
            "        <arg direction=\"out\" name=\"area\" type=\"s\"/>\n"
            "        <arg direction=\"out\" name=\"mode\" type=\"s\"/>\n"
            "        <arg direction=\"out\" name=\"resultCode\" type=\"u\"/>\n"
            "        <arg direction=\"out\" name=\"cookie\" type=\"u\"/>\n"
            "      </method>\n"
            "      <method name=\"GetRemoteControlMode\">\n"
            "        <doc>\n"
            "          <line>Asynchronous continuation token provided by the sender in the method call. cookie must not be changed.</line>\n"
            "        </doc>\n"
            "        <arg direction=\"in\" name=\"area\" type=\"s\"/>\n"
            "        <arg direction=\"in\" name=\"cookie\" type=\"u\"/>\n"
            "        <arg direction=\"out\" name=\"area\" type=\"s\"/>\n"
            "        <arg direction=\"out\" name=\"mode\" type=\"s\"/>\n"
            "        <arg direction=\"out\" name=\"cookie\" type=\"u\"/>\n"
            "      </method>\n"
            "      <method name=\"StartSystemSetting\">\n"
            "        <doc>\n"
            "          <line>Asynchronous continuation token provided by the sender in the method call. cookie must not be changed.</line>\n"
            "        </doc>\n"
            "        <arg direction=\"in\" name=\"sysSetType\" type=\"s\"/>\n"
            "        <arg direction=\"in\" name=\"extendedData\" type=\"a(yay)\"/>\n"
            "        <arg direction=\"in\" name=\"cookie\" type=\"u\"/>\n"
            "        <arg direction=\"out\" name=\"sysSetType\" type=\"s\"/>\n"
            "        <arg direction=\"out\" name=\"extendedData\" type=\"a(yay)\"/>\n"
            "        <arg direction=\"out\" name=\"resultCode\" type=\"u\"/>\n"
            "        <arg direction=\"out\" name=\"cookie\" type=\"u\"/>\n"
            "      </method>\n"
            "      <method name=\"RemotePrepareSystemSetting\">\n"
            "        <doc>\n"
            "          <line>Asynchronous continuation token provided by the sender. cookie must not be changed and is sent back in response signal.</line>\n"
            "        </doc>\n"
            "        <arg direction=\"in\" name=\"sysSetType\" type=\"s\"/>\n"
            "        <arg direction=\"in\" name=\"extendedData\" type=\"a(yay)\"/>\n"
            "        <arg direction=\"in\" name=\"cookie\" type=\"u\"/>\n"
            "        <arg direction=\"out\" name=\"sysSetType\" type=\"s\"/>\n"
            "        <arg direction=\"out\" name=\"extendedData\" type=\"a(yay)\"/>\n"
            "        <arg direction=\"out\" name=\"resultCode\" type=\"u\"/>\n"
            "        <arg direction=\"out\" name=\"cookie\" type=\"u\"/>\n"
            "      </method>\n"
            "      <method name=\"RemoteExecuteSystemSetting\">\n"
            "        <doc>\n"
            "          <line>Asynchronous continuation token provided by the sender. cookie must not be changed and is sent back in response signal.</line>\n"
            "        </doc>\n"
            "        <arg direction=\"in\" name=\"sysSetType\" type=\"s\"/>\n"
            "        <arg direction=\"in\" name=\"extendedData\" type=\"a(yay)\"/>\n"
            "        <arg direction=\"in\" name=\"cookie\" type=\"u\"/>\n"
            "        <arg direction=\"out\" name=\"sysSetType\" type=\"s\"/>\n"
            "        <arg direction=\"out\" name=\"extendedData\" type=\"a(yay)\"/>\n"
            "        <arg direction=\"out\" name=\"resultCode\" type=\"u\"/>\n"
            "        <arg direction=\"out\" name=\"cookie\" type=\"u\"/>\n"
            "      </method>\n"
            "      <method name=\"RemoteFinalizeSystemSetting\">\n"
            "        <doc>\n"
            "          <line>Asynchronous continuation token provided by the sender. cookie must not be changed and is sent back in response signal.</line>\n"
            "        </doc>\n"
            "        <arg direction=\"in\" name=\"sysSetType\" type=\"s\"/>\n"
            "        <arg direction=\"in\" name=\"extendedData\" type=\"a(yay)\"/>\n"
            "        <arg direction=\"in\" name=\"cookie\" type=\"u\"/>\n"
            "        <arg direction=\"out\" name=\"sysSetType\" type=\"s\"/>\n"
            "        <arg direction=\"out\" name=\"extendedData\" type=\"a(yay)\"/>\n"
            "        <arg direction=\"out\" name=\"resultCode\" type=\"u\"/>\n"
            "        <arg direction=\"out\" name=\"cookie\" type=\"u\"/>\n"
            "      </method>\n"
            "</interface>\n";
}

void Control1StubDelegate::getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) {
    (static_cast<Control1Stub*>(getStub()))->onGetAll (properties);
}

void Control1StubDelegate::setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act) {
    ((void)value);  // to get rid of unused variable warning
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendSetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

void Control1StubDelegate::getProperty(const ::std::string& property, const act_t& act) {
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendGetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

Control1Stub::Control1Stub (const std::string& portName) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new Control1StubDelegate(this, _logger);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

Control1Stub::Control1Stub (const std::string& portName, const std::string& objectPath) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new Control1StubDelegate(this, _logger, objectPath);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

Control1Stub::~Control1Stub() {
    delete _stubDelegate;
}

void  Control1Stub::sendSetRemoteControlModeResponse (const ::std::string& area, const ::std::string& mode, uint32 resultCode, uint32 cookie, act_t act) {
    SetRemoteControlModeResponse* payload = new SetRemoteControlModeResponse(area, mode, resultCode, cookie);
    DBUS_MESSAGE_REPLY(dbusMessage, "SetRemoteControlMode", SetRemoteControlModeResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "SetRemoteControlMode", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  Control1Stub::sendSetRemoteControlModeError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    SetRemoteControlModeError* payload = new SetRemoteControlModeError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "SetRemoteControlMode", SetRemoteControlModeError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "SetRemoteControlMode", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  Control1Stub::sendGetRemoteControlModeResponse (const ::std::string& area, const ::std::string& mode, uint32 cookie, act_t act) {
    GetRemoteControlModeResponse* payload = new GetRemoteControlModeResponse(area, mode, cookie);
    DBUS_MESSAGE_REPLY(dbusMessage, "GetRemoteControlMode", GetRemoteControlModeResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "GetRemoteControlMode", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  Control1Stub::sendGetRemoteControlModeError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    GetRemoteControlModeError* payload = new GetRemoteControlModeError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "GetRemoteControlMode", GetRemoteControlModeError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "GetRemoteControlMode", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  Control1Stub::sendStartSystemSettingResponse (const ::std::string& sysSetType, const ::std::vector< StartSystemSettingResponseExtendedDataStruct >& extendedData, uint32 resultCode, uint32 cookie, act_t act) {
    StartSystemSettingResponse* payload = new StartSystemSettingResponse(sysSetType, extendedData, resultCode, cookie);
    DBUS_MESSAGE_REPLY(dbusMessage, "StartSystemSetting", StartSystemSettingResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "StartSystemSetting", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  Control1Stub::sendStartSystemSettingError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    StartSystemSettingError* payload = new StartSystemSettingError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "StartSystemSetting", StartSystemSettingError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "StartSystemSetting", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  Control1Stub::sendRemotePrepareSystemSettingResponse (const ::std::string& sysSetType, const ::std::vector< RemotePrepareSystemSettingResponseExtendedDataStruct >& extendedData, uint32 resultCode, uint32 cookie, act_t act) {
    RemotePrepareSystemSettingResponse* payload = new RemotePrepareSystemSettingResponse(sysSetType, extendedData, resultCode, cookie);
    DBUS_MESSAGE_REPLY(dbusMessage, "RemotePrepareSystemSetting", RemotePrepareSystemSettingResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "RemotePrepareSystemSetting", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  Control1Stub::sendRemotePrepareSystemSettingError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    RemotePrepareSystemSettingError* payload = new RemotePrepareSystemSettingError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "RemotePrepareSystemSetting", RemotePrepareSystemSettingError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "RemotePrepareSystemSetting", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  Control1Stub::sendRemoteExecuteSystemSettingResponse (const ::std::string& sysSetType, const ::std::vector< RemoteExecuteSystemSettingResponseExtendedDataStruct >& extendedData, uint32 resultCode, uint32 cookie, act_t act) {
    RemoteExecuteSystemSettingResponse* payload = new RemoteExecuteSystemSettingResponse(sysSetType, extendedData, resultCode, cookie);
    DBUS_MESSAGE_REPLY(dbusMessage, "RemoteExecuteSystemSetting", RemoteExecuteSystemSettingResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "RemoteExecuteSystemSetting", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  Control1Stub::sendRemoteExecuteSystemSettingError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    RemoteExecuteSystemSettingError* payload = new RemoteExecuteSystemSettingError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "RemoteExecuteSystemSetting", RemoteExecuteSystemSettingError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "RemoteExecuteSystemSetting", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  Control1Stub::sendRemoteFinalizeSystemSettingResponse (const ::std::string& sysSetType, const ::std::vector< RemoteFinalizeSystemSettingResponseExtendedDataStruct >& extendedData, uint32 resultCode, uint32 cookie, act_t act) {
    RemoteFinalizeSystemSettingResponse* payload = new RemoteFinalizeSystemSettingResponse(sysSetType, extendedData, resultCode, cookie);
    DBUS_MESSAGE_REPLY(dbusMessage, "RemoteFinalizeSystemSetting", RemoteFinalizeSystemSettingResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "RemoteFinalizeSystemSetting", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  Control1Stub::sendRemoteFinalizeSystemSettingError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    RemoteFinalizeSystemSettingError* payload = new RemoteFinalizeSystemSettingError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "RemoteFinalizeSystemSetting", RemoteFinalizeSystemSettingError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "RemoteFinalizeSystemSetting", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void Control1Stub::onGetAll(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) const {
    ((void)properties);  // to get rid of unused variable warning
}

} // namespace Control1
} // namespace Diagnosis1
} // namespace dbus
} // namespace diagnosis
} // namespace cm
} // namespace bosch
} // namespace org
