/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "org/bosch/cm/diagnosis/dbus/Diagnosis1/Control1.h"
#include "org/bosch/cm/diagnosis/dbus/Diagnosis1/Control1DBus.h"
#include "org/bosch/cm/diagnosis/dbus/Diagnosis1/Control1Json.h"
#include "org/bosch/cm/diagnosis/dbus/Diagnosis1/Control1Proxy.h"
#include <string>
#include <vector>

#include "asf/dbus/DBusDaemonProxy.h"
#include "asf/dbus/DBusPropertiesProxyWrapper.h"
#include "asf/dbus/DBusProxyDelegate.h"
#include "asf/dbus/DBusMessage.h"

namespace org {
namespace bosch {
namespace cm {
namespace diagnosis {
namespace dbus {
namespace Diagnosis1 {
namespace Control1 {

DEFINE_CLASS_LOGGER("/org/bosch/cm/diagnosis/dbus/Diagnosis1/Control1", Control1Proxy);

class Control1ProxyCallback : public ::asf::dbus::DBusProxyCallback {
public:

    Control1ProxyCallback(uint16 functionId, void* callback) :
        ::asf::dbus::DBusProxyCallback (functionId, callback)
    {}

    bool processMessage (::asf::dbus::DBusMessage &message) {
        const ::boost::shared_ptr< Control1Proxy >& proxyShared = ::boost::static_pointer_cast< Control1Proxy >(message.getDBusProxyShared()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        switch (_functionId) {
            case ID_SetRemoteControlMode:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), SetRemoteControlModeError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetRemoteControlMode", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SetRemoteControlModeError> payload = ::boost::static_pointer_cast<SetRemoteControlModeError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SetRemoteControlModeCallbackIF*) _callback)->onSetRemoteControlModeError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SetRemoteControlModeResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetRemoteControlMode", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SetRemoteControlModeResponse> payload = ::boost::static_pointer_cast<SetRemoteControlModeResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SetRemoteControlModeCallbackIF*) _callback)->onSetRemoteControlModeResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_GetRemoteControlMode:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), GetRemoteControlModeError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetRemoteControlMode", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GetRemoteControlModeError> payload = ::boost::static_pointer_cast<GetRemoteControlModeError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((GetRemoteControlModeCallbackIF*) _callback)->onGetRemoteControlModeError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GetRemoteControlModeResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetRemoteControlMode", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GetRemoteControlModeResponse> payload = ::boost::static_pointer_cast<GetRemoteControlModeResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((GetRemoteControlModeCallbackIF*) _callback)->onGetRemoteControlModeResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_StartSystemSetting:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), StartSystemSettingError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "StartSystemSetting", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<StartSystemSettingError> payload = ::boost::static_pointer_cast<StartSystemSettingError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((StartSystemSettingCallbackIF*) _callback)->onStartSystemSettingError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), StartSystemSettingResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "StartSystemSetting", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<StartSystemSettingResponse> payload = ::boost::static_pointer_cast<StartSystemSettingResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((StartSystemSettingCallbackIF*) _callback)->onStartSystemSettingResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_RemotePrepareSystemSetting:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), RemotePrepareSystemSettingError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "RemotePrepareSystemSetting", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RemotePrepareSystemSettingError> payload = ::boost::static_pointer_cast<RemotePrepareSystemSettingError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((RemotePrepareSystemSettingCallbackIF*) _callback)->onRemotePrepareSystemSettingError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RemotePrepareSystemSettingResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "RemotePrepareSystemSetting", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RemotePrepareSystemSettingResponse> payload = ::boost::static_pointer_cast<RemotePrepareSystemSettingResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((RemotePrepareSystemSettingCallbackIF*) _callback)->onRemotePrepareSystemSettingResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_RemoteExecuteSystemSetting:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), RemoteExecuteSystemSettingError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "RemoteExecuteSystemSetting", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RemoteExecuteSystemSettingError> payload = ::boost::static_pointer_cast<RemoteExecuteSystemSettingError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((RemoteExecuteSystemSettingCallbackIF*) _callback)->onRemoteExecuteSystemSettingError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RemoteExecuteSystemSettingResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "RemoteExecuteSystemSetting", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RemoteExecuteSystemSettingResponse> payload = ::boost::static_pointer_cast<RemoteExecuteSystemSettingResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((RemoteExecuteSystemSettingCallbackIF*) _callback)->onRemoteExecuteSystemSettingResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_RemoteFinalizeSystemSetting:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), RemoteFinalizeSystemSettingError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "RemoteFinalizeSystemSetting", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RemoteFinalizeSystemSettingError> payload = ::boost::static_pointer_cast<RemoteFinalizeSystemSettingError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((RemoteFinalizeSystemSettingCallbackIF*) _callback)->onRemoteFinalizeSystemSettingError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RemoteFinalizeSystemSettingResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "RemoteFinalizeSystemSetting", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RemoteFinalizeSystemSettingResponse> payload = ::boost::static_pointer_cast<RemoteFinalizeSystemSettingResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((RemoteFinalizeSystemSettingCallbackIF*) _callback)->onRemoteFinalizeSystemSettingResponse (proxyShared, payload);
                        return true;
                    }
                }
            default:
            LOG_FATAL ("Received an invalid functionId, proxy=%p", message.getProxy());
        }
        LOG_FATAL("Receveid an invalid message, proxy=%p", message.getProxy());
        return false;
    }

    bool onServiceUnavailable (const ::boost::shared_ptr< ::asf::core::Proxy >& baseProxy) {
        switch (_functionId) {
            case ID_SetRemoteControlMode: {
                ::boost::shared_ptr< SetRemoteControlModeError > payload = ::boost::shared_ptr< SetRemoteControlModeError >
                (new SetRemoteControlModeError(DBUS_ERROR_NO_SERVER, "The DBus service Control1 is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SetRemoteControlMode", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<Control1Proxy> proxyShared = ::boost::static_pointer_cast<Control1Proxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SetRemoteControlModeCallbackIF*) _callback)->onSetRemoteControlModeError (proxyShared,payload);
                return true;
            }
            break;
            case ID_GetRemoteControlMode: {
                ::boost::shared_ptr< GetRemoteControlModeError > payload = ::boost::shared_ptr< GetRemoteControlModeError >
                (new GetRemoteControlModeError(DBUS_ERROR_NO_SERVER, "The DBus service Control1 is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "GetRemoteControlMode", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<Control1Proxy> proxyShared = ::boost::static_pointer_cast<Control1Proxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((GetRemoteControlModeCallbackIF*) _callback)->onGetRemoteControlModeError (proxyShared,payload);
                return true;
            }
            break;
            case ID_StartSystemSetting: {
                ::boost::shared_ptr< StartSystemSettingError > payload = ::boost::shared_ptr< StartSystemSettingError >
                (new StartSystemSettingError(DBUS_ERROR_NO_SERVER, "The DBus service Control1 is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "StartSystemSetting", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<Control1Proxy> proxyShared = ::boost::static_pointer_cast<Control1Proxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((StartSystemSettingCallbackIF*) _callback)->onStartSystemSettingError (proxyShared,payload);
                return true;
            }
            break;
            case ID_RemotePrepareSystemSetting: {
                ::boost::shared_ptr< RemotePrepareSystemSettingError > payload = ::boost::shared_ptr< RemotePrepareSystemSettingError >
                (new RemotePrepareSystemSettingError(DBUS_ERROR_NO_SERVER, "The DBus service Control1 is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "RemotePrepareSystemSetting", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<Control1Proxy> proxyShared = ::boost::static_pointer_cast<Control1Proxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((RemotePrepareSystemSettingCallbackIF*) _callback)->onRemotePrepareSystemSettingError (proxyShared,payload);
                return true;
            }
            break;
            case ID_RemoteExecuteSystemSetting: {
                ::boost::shared_ptr< RemoteExecuteSystemSettingError > payload = ::boost::shared_ptr< RemoteExecuteSystemSettingError >
                (new RemoteExecuteSystemSettingError(DBUS_ERROR_NO_SERVER, "The DBus service Control1 is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "RemoteExecuteSystemSetting", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<Control1Proxy> proxyShared = ::boost::static_pointer_cast<Control1Proxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((RemoteExecuteSystemSettingCallbackIF*) _callback)->onRemoteExecuteSystemSettingError (proxyShared,payload);
                return true;
            }
            break;
            case ID_RemoteFinalizeSystemSetting: {
                ::boost::shared_ptr< RemoteFinalizeSystemSettingError > payload = ::boost::shared_ptr< RemoteFinalizeSystemSettingError >
                (new RemoteFinalizeSystemSettingError(DBUS_ERROR_NO_SERVER, "The DBus service Control1 is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "RemoteFinalizeSystemSetting", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<Control1Proxy> proxyShared = ::boost::static_pointer_cast<Control1Proxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((RemoteFinalizeSystemSettingCallbackIF*) _callback)->onRemoteFinalizeSystemSettingError (proxyShared,payload);
                return true;
            }
            break;
            default:
                break;
        }
        return false;
    }

    static ::asf::core::Logger&_logger;
};

::asf::core::Logger& Control1ProxyCallback::_logger (Control1Proxy::_logger);

Control1Proxy::Control1Proxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable) :
    ::asf::dbus::DBusProxy(portName, "org.bosch.cm.diagnosis.dbus.Diagnosis1.Control1", serviceAvailable, _logger) {
}

Control1Proxy::~Control1Proxy()
{
    ::asf::dbus::DBusConnector::getConnector(getConnectorOptions())->deregisterProxyDelegate(_dbusProxyDelegate);
}

// static
::boost::shared_ptr< Control1Proxy > Control1Proxy::createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable) {
    ::boost::shared_ptr< Proxy > proxyReuse = ::asf::dbus::DBusConnector::getProxy(portName, serviceAvailable);
    if(proxyReuse) {
        LOG_INFO_STATIC ("createProxy, reuse existing proxy");
        return ::boost::static_pointer_cast<Control1Proxy>(proxyReuse); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
    }
    LOG_INFO_STATIC ("createProxy, create new proxy");
    ::boost::shared_ptr< Control1Proxy > proxyNew(new Control1Proxy(portName, serviceAvailable));
    ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew);
    proxyNew->createHelperProxies(false);
    return proxyNew;
}

act_t Control1Proxy::addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const {
    Control1ProxyCallback* callback = new Control1ProxyCallback(methodId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->addMethodCallback (serial, memberName, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

act_t Control1Proxy::addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const {
    Control1ProxyCallback* callback = new Control1ProxyCallback(signalId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->registerSignalCallback (signal, reinterpret_cast<act_t>(callback), ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}



act_t Control1Proxy::sendSetRemoteControlModeRequest(SetRemoteControlModeCallbackIF& cb, const ::std::string& area, const ::std::string& mode, uint32 cookie) const {
    SetRemoteControlModeRequest* payload = new SetRemoteControlModeRequest();
    CHECK_ALLOCATION(payload);
    payload->setArea(area);
    payload->setMode(mode);
    payload->setCookie(cookie);
    DBUS_MESSAGE_CALL(dbusMessage, "SetRemoteControlMode", SetRemoteControlModeRequest, payload, true)
    act_t act = addMethodCallback(ID_SetRemoteControlMode, dbusMessage.getUniqueSerial(), "SetRemoteControlMode", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "SetRemoteControlMode", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t Control1Proxy::sendGetRemoteControlModeRequest(GetRemoteControlModeCallbackIF& cb, const ::std::string& area, uint32 cookie) const {
    GetRemoteControlModeRequest* payload = new GetRemoteControlModeRequest();
    CHECK_ALLOCATION(payload);
    payload->setArea(area);
    payload->setCookie(cookie);
    DBUS_MESSAGE_CALL(dbusMessage, "GetRemoteControlMode", GetRemoteControlModeRequest, payload, true)
    act_t act = addMethodCallback(ID_GetRemoteControlMode, dbusMessage.getUniqueSerial(), "GetRemoteControlMode", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "GetRemoteControlMode", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t Control1Proxy::sendStartSystemSettingRequest(StartSystemSettingCallbackIF& cb, const ::std::string& sysSetType, const ::std::vector< StartSystemSettingRequestExtendedDataStruct >& extendedData, uint32 cookie) const {
    StartSystemSettingRequest* payload = new StartSystemSettingRequest();
    CHECK_ALLOCATION(payload);
    payload->setSysSetType(sysSetType);
    payload->setExtendedData(extendedData);
    payload->setCookie(cookie);
    DBUS_MESSAGE_CALL(dbusMessage, "StartSystemSetting", StartSystemSettingRequest, payload, true)
    act_t act = addMethodCallback(ID_StartSystemSetting, dbusMessage.getUniqueSerial(), "StartSystemSetting", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "StartSystemSetting", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t Control1Proxy::sendRemotePrepareSystemSettingRequest(RemotePrepareSystemSettingCallbackIF& cb, const ::std::string& sysSetType, const ::std::vector< RemotePrepareSystemSettingRequestExtendedDataStruct >& extendedData, uint32 cookie) const {
    RemotePrepareSystemSettingRequest* payload = new RemotePrepareSystemSettingRequest();
    CHECK_ALLOCATION(payload);
    payload->setSysSetType(sysSetType);
    payload->setExtendedData(extendedData);
    payload->setCookie(cookie);
    DBUS_MESSAGE_CALL(dbusMessage, "RemotePrepareSystemSetting", RemotePrepareSystemSettingRequest, payload, true)
    act_t act = addMethodCallback(ID_RemotePrepareSystemSetting, dbusMessage.getUniqueSerial(), "RemotePrepareSystemSetting", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "RemotePrepareSystemSetting", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t Control1Proxy::sendRemoteExecuteSystemSettingRequest(RemoteExecuteSystemSettingCallbackIF& cb, const ::std::string& sysSetType, const ::std::vector< RemoteExecuteSystemSettingRequestExtendedDataStruct >& extendedData, uint32 cookie) const {
    RemoteExecuteSystemSettingRequest* payload = new RemoteExecuteSystemSettingRequest();
    CHECK_ALLOCATION(payload);
    payload->setSysSetType(sysSetType);
    payload->setExtendedData(extendedData);
    payload->setCookie(cookie);
    DBUS_MESSAGE_CALL(dbusMessage, "RemoteExecuteSystemSetting", RemoteExecuteSystemSettingRequest, payload, true)
    act_t act = addMethodCallback(ID_RemoteExecuteSystemSetting, dbusMessage.getUniqueSerial(), "RemoteExecuteSystemSetting", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "RemoteExecuteSystemSetting", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t Control1Proxy::sendRemoteFinalizeSystemSettingRequest(RemoteFinalizeSystemSettingCallbackIF& cb, const ::std::string& sysSetType, const ::std::vector< RemoteFinalizeSystemSettingRequestExtendedDataStruct >& extendedData, uint32 cookie) const {
    RemoteFinalizeSystemSettingRequest* payload = new RemoteFinalizeSystemSettingRequest();
    CHECK_ALLOCATION(payload);
    payload->setSysSetType(sysSetType);
    payload->setExtendedData(extendedData);
    payload->setCookie(cookie);
    DBUS_MESSAGE_CALL(dbusMessage, "RemoteFinalizeSystemSetting", RemoteFinalizeSystemSettingRequest, payload, true)
    act_t act = addMethodCallback(ID_RemoteFinalizeSystemSetting, dbusMessage.getUniqueSerial(), "RemoteFinalizeSystemSetting", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "RemoteFinalizeSystemSetting", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

} // namespace Control1
} // namespace Diagnosis1
} // namespace dbus
} // namespace diagnosis
} // namespace cm
} // namespace bosch
} // namespace org
