/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef COM_ADIT_DE_ALD_CHANGE_LEVELPROXY_H
#define COM_ADIT_DE_ALD_CHANGE_LEVELPROXY_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusProxy.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "com/adit/de/ALD/change_level.h"
#include "com/bosch/cm/asf/lang/dbus/Connectors.h"
#include <dbus/dbus.h>
#include <vector>

namespace com {
namespace adit {
namespace de {
namespace ALD {
namespace change_level {

class Change_levelProxy;

class ChallengeCallbackIF {
public:
    virtual ~ChallengeCallbackIF() {}

    virtual void onChallengeError(const ::boost::shared_ptr< Change_levelProxy >& proxy, const ::boost::shared_ptr< ChallengeError >& error) = 0;

    virtual void onChallengeResponse(const ::boost::shared_ptr< Change_levelProxy >& proxy, const ::boost::shared_ptr< ChallengeResponse >& response) = 0;
};

class LockDeviceCallbackIF {
public:
    virtual ~LockDeviceCallbackIF() {}

    virtual void onLockDeviceError(const ::boost::shared_ptr< Change_levelProxy >& proxy, const ::boost::shared_ptr< LockDeviceError >& error) = 0;

    virtual void onLockDeviceResponse(const ::boost::shared_ptr< Change_levelProxy >& proxy, const ::boost::shared_ptr< LockDeviceResponse >& response) = 0;
};

class ResponseCallbackIF {
public:
    virtual ~ResponseCallbackIF() {}

    virtual void onResponseError(const ::boost::shared_ptr< Change_levelProxy >& proxy, const ::boost::shared_ptr< ResponseError >& error) = 0;

    virtual void onResponseResponse(const ::boost::shared_ptr< Change_levelProxy >& proxy, const ::boost::shared_ptr< ResponseResponse >& response) = 0;
};


/**
 * Change_levelProxy is the client side representation of the D-Bus
 * service interface 'com.adit.de.ALD.change_level' (specified in file
 * AuthorizationLevelDaemon.xml).
 *
 * If the meaning of "com.adit.de.ALD.change_level" isn't clear, then there should be a description here.
 */
class Change_levelProxy : public ::asf::dbus::DBusProxy
{
public:
    /**
     * Create a new instance of Change_levelProxy.
     */
    static ::boost::shared_ptr< Change_levelProxy > createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    /**
     * Create a new instance of Change_levelProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @deprecated use the createProxy() method with the parameter
     * ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector instead.
     */
    static ::boost::shared_ptr< Change_levelProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        ::DBusBusType busType,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector connectorOptions;
        connectorOptions.setBusType(::asf::dbus::DBusUtils::toOptions(busType).getBusType());
        return createProxy(portName, busName, objectPath, connectorOptions, serviceAvailable);
    }

    /**
     * Create a new instance of Change_levelProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     */
    static ::boost::shared_ptr< Change_levelProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        const ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector& connectorOptions,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        LOG_INFO_STATIC ("createProxy, create new proxy");
        ::boost::shared_ptr< Change_levelProxy > proxyNew(new Change_levelProxy(portName, serviceAvailable));
        ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew, busName, objectPath, connectorOptions);
        proxyNew->createHelperProxies(false);
        return proxyNew;
    }

    virtual ~Change_levelProxy ();




    // Method 'Challenge'

    /**
     * Call the method 'Challenge'. This method sends a message to the D-Bus
     * server.
     *
     * <b>Documentation of 'Challenge'</b>:
     *
     * If the meaning of "Challenge" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param ecu_id If the meaning of "ecu_id" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendChallengeRequest(ChallengeCallbackIF& cb, const ::std::vector< uint8 >& ecu_id) const;

    // Method 'Response'

    /**
     * Call the method 'Response'. This method sends a message to the D-Bus
     * server.
     *
     * <b>Documentation of 'Response'</b>:
     *
     * If the meaning of "Response" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param response If the meaning of "response" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendResponseRequest(ResponseCallbackIF& cb, const ::std::vector< uint8 >& response) const;

    // Method 'LockDevice'

    /**
     * Call the method 'LockDevice'. This method sends a message to the D-Bus
     * server.
     *
     * <b>Documentation of 'LockDevice'</b>:
     *
     * If the meaning of "LockDevice" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendLockDeviceRequest(LockDeviceCallbackIF& cb) const;


private:

    Change_levelProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    act_t addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const;

    act_t addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const;


    DECLARE_CLASS_LOGGER();

    friend class Change_levelProxyCallback;
};

} // namespace change_level
} // namespace ALD
} // namespace de
} // namespace adit
} // namespace com

#endif // COM_ADIT_DE_ALD_CHANGE_LEVELPROXY_H
