/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "com/adit/de/ALD/change_level.h"
#include "com/adit/de/ALD/change_levelDBus.h"
#include "com/adit/de/ALD/change_levelJson.h"
#include "com/adit/de/ALD/change_levelProxy.h"
#include <vector>

#include "asf/dbus/DBusDaemonProxy.h"
#include "asf/dbus/DBusPropertiesProxyWrapper.h"
#include "asf/dbus/DBusProxyDelegate.h"
#include "asf/dbus/DBusMessage.h"

namespace com {
namespace adit {
namespace de {
namespace ALD {
namespace change_level {

DEFINE_CLASS_LOGGER("/com/adit/de/ALD/change_level", Change_levelProxy);

class Change_levelProxyCallback : public ::asf::dbus::DBusProxyCallback {
public:

    Change_levelProxyCallback(uint16 functionId, void* callback) :
        ::asf::dbus::DBusProxyCallback (functionId, callback)
    {}

    bool processMessage (::asf::dbus::DBusMessage &message) {
        const ::boost::shared_ptr< Change_levelProxy >& proxyShared = ::boost::static_pointer_cast< Change_levelProxy >(message.getDBusProxyShared()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        switch (_functionId) {
            case ID_Challenge:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), ChallengeError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "Challenge", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ChallengeError> payload = ::boost::static_pointer_cast<ChallengeError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ChallengeCallbackIF*) _callback)->onChallengeError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ChallengeResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "Challenge", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ChallengeResponse> payload = ::boost::static_pointer_cast<ChallengeResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ChallengeCallbackIF*) _callback)->onChallengeResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_Response:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), ResponseError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "Response", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ResponseError> payload = ::boost::static_pointer_cast<ResponseError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ResponseCallbackIF*) _callback)->onResponseError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ResponseResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "Response", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ResponseResponse> payload = ::boost::static_pointer_cast<ResponseResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ResponseCallbackIF*) _callback)->onResponseResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_LockDevice:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), LockDeviceError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "LockDevice", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<LockDeviceError> payload = ::boost::static_pointer_cast<LockDeviceError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((LockDeviceCallbackIF*) _callback)->onLockDeviceError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), LockDeviceResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "LockDevice", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<LockDeviceResponse> payload = ::boost::static_pointer_cast<LockDeviceResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((LockDeviceCallbackIF*) _callback)->onLockDeviceResponse (proxyShared, payload);
                        return true;
                    }
                }
            default:
            LOG_FATAL ("Received an invalid functionId, proxy=%p", message.getProxy());
        }
        LOG_FATAL("Receveid an invalid message, proxy=%p", message.getProxy());
        return false;
    }

    bool onServiceUnavailable (const ::boost::shared_ptr< ::asf::core::Proxy >& baseProxy) {
        switch (_functionId) {
            case ID_Challenge: {
                ::boost::shared_ptr< ChallengeError > payload = ::boost::shared_ptr< ChallengeError >
                (new ChallengeError(DBUS_ERROR_NO_SERVER, "The DBus service Change_level is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Challenge", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<Change_levelProxy> proxyShared = ::boost::static_pointer_cast<Change_levelProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ChallengeCallbackIF*) _callback)->onChallengeError (proxyShared,payload);
                return true;
            }
            break;
            case ID_Response: {
                ::boost::shared_ptr< ResponseError > payload = ::boost::shared_ptr< ResponseError >
                (new ResponseError(DBUS_ERROR_NO_SERVER, "The DBus service Change_level is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Response", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<Change_levelProxy> proxyShared = ::boost::static_pointer_cast<Change_levelProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ResponseCallbackIF*) _callback)->onResponseError (proxyShared,payload);
                return true;
            }
            break;
            case ID_LockDevice: {
                ::boost::shared_ptr< LockDeviceError > payload = ::boost::shared_ptr< LockDeviceError >
                (new LockDeviceError(DBUS_ERROR_NO_SERVER, "The DBus service Change_level is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "LockDevice", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<Change_levelProxy> proxyShared = ::boost::static_pointer_cast<Change_levelProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((LockDeviceCallbackIF*) _callback)->onLockDeviceError (proxyShared,payload);
                return true;
            }
            break;
            default:
                break;
        }
        return false;
    }

    static ::asf::core::Logger&_logger;
};

::asf::core::Logger& Change_levelProxyCallback::_logger (Change_levelProxy::_logger);

Change_levelProxy::Change_levelProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable) :
    ::asf::dbus::DBusProxy(portName, "com.adit.de.ALD.change_level", serviceAvailable, _logger) {
}

Change_levelProxy::~Change_levelProxy()
{
    ::asf::dbus::DBusConnector::getConnector(getConnectorOptions())->deregisterProxyDelegate(_dbusProxyDelegate);
}

// static
::boost::shared_ptr< Change_levelProxy > Change_levelProxy::createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable) {
    ::boost::shared_ptr< Proxy > proxyReuse = ::asf::dbus::DBusConnector::getProxy(portName, serviceAvailable);
    if(proxyReuse) {
        LOG_INFO_STATIC ("createProxy, reuse existing proxy");
        return ::boost::static_pointer_cast<Change_levelProxy>(proxyReuse); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
    }
    LOG_INFO_STATIC ("createProxy, create new proxy");
    ::boost::shared_ptr< Change_levelProxy > proxyNew(new Change_levelProxy(portName, serviceAvailable));
    ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew);
    proxyNew->createHelperProxies(false);
    return proxyNew;
}

act_t Change_levelProxy::addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const {
    Change_levelProxyCallback* callback = new Change_levelProxyCallback(methodId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->addMethodCallback (serial, memberName, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

act_t Change_levelProxy::addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const {
    Change_levelProxyCallback* callback = new Change_levelProxyCallback(signalId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->registerSignalCallback (signal, reinterpret_cast<act_t>(callback), ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}



act_t Change_levelProxy::sendChallengeRequest(ChallengeCallbackIF& cb, const ::std::vector< uint8 >& ecu_id) const {
    ChallengeRequest* payload = new ChallengeRequest();
    CHECK_ALLOCATION(payload);
    payload->setEcu_id(ecu_id);
    DBUS_MESSAGE_CALL(dbusMessage, "Challenge", ChallengeRequest, payload, true)
    act_t act = addMethodCallback(ID_Challenge, dbusMessage.getUniqueSerial(), "Challenge", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "Challenge", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t Change_levelProxy::sendResponseRequest(ResponseCallbackIF& cb, const ::std::vector< uint8 >& response) const {
    ResponseRequest* payload = new ResponseRequest();
    CHECK_ALLOCATION(payload);
    payload->setResponse(response);
    DBUS_MESSAGE_CALL(dbusMessage, "Response", ResponseRequest, payload, true)
    act_t act = addMethodCallback(ID_Response, dbusMessage.getUniqueSerial(), "Response", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "Response", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t Change_levelProxy::sendLockDeviceRequest(LockDeviceCallbackIF& cb) const {
    LockDeviceRequest* payload = new LockDeviceRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "LockDevice", LockDeviceRequest, payload, true)
    act_t act = addMethodCallback(ID_LockDevice, dbusMessage.getUniqueSerial(), "LockDevice", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "LockDevice", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

} // namespace change_level
} // namespace ALD
} // namespace de
} // namespace adit
} // namespace com
