/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef ORG_GENIVI_AUDIOMANAGER_COMMANDINTERFACESTUB_H
#define ORG_GENIVI_AUDIOMANAGER_COMMANDINTERFACESTUB_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusStub.h"
#include "asf/dbus/DBusVariant.h"
#include "boost/shared_ptr.hpp"
#include "org/genivi/audiomanager/CommandInterface.h"
#include <vector>

namespace org {
namespace genivi {
namespace audiomanager {
namespace CommandInterface {

class CommandInterfaceStubDelegate;

class CommandInterfaceStub : public ::asf::dbus::DBusStub
{
public:

    /**
     * Create an instance of the CommandInterfaceStub
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     */
    CommandInterfaceStub (const std::string& portName);

    /**
     * Create an instance of the CommandInterfaceStub
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     * @param objectPath the dbus object path, see
     * http://dbus.freedesktop.org/doc/dbus-specification.html#message-protocol-marshaling-object-path
     */
    CommandInterfaceStub (const std::string& portName, const std::string& objectPath);

    virtual ~CommandInterfaceStub();

    // signal 'NumberOfMainConnectionsChanged'

    /**
     * Raise the signal 'NumberOfMainConnectionsChanged' and send an update
     * message to registered clients.
     *
     * <b>Documentation of 'NumberOfMainConnectionsChanged'</b>:
     *
     * Signal to indicate change in the number of main connections
     */
    void sendNumberOfMainConnectionsChangedSignal();

    // signal 'SinkAdded'

    /**
     * Raise the signal 'SinkAdded' and send an update message to registered
     * clients.
     *
     * <b>Documentation of 'SinkAdded'</b>:
     *
     * New Sink type added. Refer am_SinkType_s
     *
     * @param newSink If the meaning of "newSink" isn't clear, then there should be a description here.
     */
    void sendSinkAddedSignal(const SinkAddedSignalNewSinkStruct& newSink);

    // signal 'SinkRemoved'

    /**
     * Raise the signal 'SinkRemoved' and send an update message to registered
     * clients.
     *
     * <b>Documentation of 'SinkRemoved'</b>:
     *
     * Sink ID of the removed sink
     *
     * @param removedSinkID If the meaning of "removedSinkID" isn't clear, then there should be a description here.
     */
    void sendSinkRemovedSignal(uint16 removedSinkID);

    // signal 'SourceAdded'

    /**
     * Raise the signal 'SourceAdded' and send an update message to registered
     * clients.
     *
     * <b>Documentation of 'SourceAdded'</b>:
     *
     * New Source type added. Refer am_SourceType_s
     *
     * @param newSource If the meaning of "newSource" isn't clear, then there should be a description here.
     */
    void sendSourceAddedSignal(const SourceAddedSignalNewSourceStruct& newSource);

    // signal 'SourceRemoved'

    /**
     * Raise the signal 'SourceRemoved' and send an update message to
     * registered clients.
     *
     * <b>Documentation of 'SourceRemoved'</b>:
     *
     * ID of the removed source
     *
     * @param removedSourceID If the meaning of "removedSourceID" isn't clear, then there should be a description here.
     */
    void sendSourceRemovedSignal(uint16 removedSourceID);

    // signal 'NumberOfSinkClassesChanged'

    /**
     * Raise the signal 'NumberOfSinkClassesChanged' and send an update
     * message to registered clients.
     *
     * <b>Documentation of 'NumberOfSinkClassesChanged'</b>:
     *
     * Signal to indicate that Number of Sink Classes is changed
     */
    void sendNumberOfSinkClassesChangedSignal();

    // signal 'NumberOfSourceClassesChanged'

    /**
     * Raise the signal 'NumberOfSourceClassesChanged' and send an update
     * message to registered clients.
     *
     * <b>Documentation of 'NumberOfSourceClassesChanged'</b>:
     *
     * Signal to indicate Number of Source Classes is changed
     */
    void sendNumberOfSourceClassesChangedSignal();

    // signal 'MainConnectionStateChanged'

    /**
     * Raise the signal 'MainConnectionStateChanged' and send an update
     * message to registered clients.
     *
     * <b>Documentation of 'MainConnectionStateChanged'</b>:
     *
     * Current Connection State. Refer am_ConnectionState_e
     *
     * @param connectionID If the meaning of "connectionID" isn't clear, then there should be a description here.
     *
     * @param connectionState If the meaning of "connectionState" isn't clear, then there should be a description here.
     */
    void sendMainConnectionStateChangedSignal(uint16 connectionID, int16 connectionState);

    // signal 'MainSinkSoundPropertyChanged'

    /**
     * Raise the signal 'MainSinkSoundPropertyChanged' and send an update
     * message to registered clients.
     *
     * <b>Documentation of 'MainSinkSoundPropertyChanged'</b>:
     *
     * Sound Property Changed. Refer am_MainSoundProperty_s
     *
     * @param sinkID If the meaning of "sinkID" isn't clear, then there should be a description here.
     *
     * @param SoundProperty If the meaning of "SoundProperty" isn't clear, then there should be a description here.
     */
    void sendMainSinkSoundPropertyChangedSignal(uint16 sinkID, const MainSinkSoundPropertyChangedSignalSoundPropertyStruct& soundProperty);

    // signal 'MainSourceSoundPropertyChanged'

    /**
     * Raise the signal 'MainSourceSoundPropertyChanged' and send an update
     * message to registered clients.
     *
     * <b>Documentation of 'MainSourceSoundPropertyChanged'</b>:
     *
     * Sound Property Changed. Refer am_MainSoundProperty_s
     *
     * @param sourceID If the meaning of "sourceID" isn't clear, then there should be a description here.
     *
     * @param SoundProperty If the meaning of "SoundProperty" isn't clear, then there should be a description here.
     */
    void sendMainSourceSoundPropertyChangedSignal(uint16 sourceID, const MainSourceSoundPropertyChangedSignalSoundPropertyStruct& soundProperty);

    // signal 'SinkAvailabilityChanged'

    /**
     * Raise the signal 'SinkAvailabilityChanged' and send an update message
     * to registered clients.
     *
     * <b>Documentation of 'SinkAvailabilityChanged'</b>:
     *
     * Current availability. Refer am_Availability_s
     *
     * @param sinkID If the meaning of "sinkID" isn't clear, then there should be a description here.
     *
     * @param availability If the meaning of "availability" isn't clear, then there should be a description here.
     */
    void sendSinkAvailabilityChangedSignal(uint16 sinkID, const SinkAvailabilityChangedSignalAvailabilityStruct& availability);

    // signal 'SourceAvailabilityChanged'

    /**
     * Raise the signal 'SourceAvailabilityChanged' and send an update message
     * to registered clients.
     *
     * <b>Documentation of 'SourceAvailabilityChanged'</b>:
     *
     * current availability. Refer am_Availability_s
     *
     * @param sourceID If the meaning of "sourceID" isn't clear, then there should be a description here.
     *
     * @param availability If the meaning of "availability" isn't clear, then there should be a description here.
     */
    void sendSourceAvailabilityChangedSignal(uint16 sourceID, const SourceAvailabilityChangedSignalAvailabilityStruct& availability);

    // signal 'VolumeChanged'

    /**
     * Raise the signal 'VolumeChanged' and send an update message to
     * registered clients.
     *
     * <b>Documentation of 'VolumeChanged'</b>:
     *
     * Current volume
     *
     * @param sinkID If the meaning of "sinkID" isn't clear, then there should be a description here.
     *
     * @param volume If the meaning of "volume" isn't clear, then there should be a description here.
     */
    void sendVolumeChangedSignal(uint16 sinkID, int16 volume);

    // signal 'SinkMuteStateChanged'

    /**
     * Raise the signal 'SinkMuteStateChanged' and send an update message to
     * registered clients.
     *
     * <b>Documentation of 'SinkMuteStateChanged'</b>:
     *
     * Current Mute state. Refer am_MuteState_e
     *
     * @param sinkID If the meaning of "sinkID" isn't clear, then there should be a description here.
     *
     * @param muteState If the meaning of "muteState" isn't clear, then there should be a description here.
     */
    void sendSinkMuteStateChangedSignal(uint16 sinkID, int16 muteState);

    // signal 'SystemPropertyChanged'

    /**
     * Raise the signal 'SystemPropertyChanged' and send an update message to
     * registered clients.
     *
     * <b>Documentation of 'SystemPropertyChanged'</b>:
     *
     * Changed System property. Refer am_SystemProperty_s
     *
     * @param SystemProperty If the meaning of "SystemProperty" isn't clear, then there should be a description here.
     */
    void sendSystemPropertyChangedSignal(const SystemPropertyChangedSignalSystemPropertyStruct& systemProperty);

    // signal 'TimingInformationChanged'

    /**
     * Raise the signal 'TimingInformationChanged' and send an update message
     * to registered clients.
     *
     * <b>Documentation of 'TimingInformationChanged'</b>:
     *
     * changed time (delay) in milli seconds
     *
     * @param mainConnection If the meaning of "mainConnection" isn't clear, then there should be a description here.
     *
     * @param time If the meaning of "time" isn't clear, then there should be a description here.
     */
    void sendTimingInformationChangedSignal(uint16 mainConnection, int16 time);

    // method 'Connect'

    /**
     * The method onConnect() is called by ASF when a client invokes the
     * method 'Connect'. A subclass has to implement this method and send back
     * a response to the client either with the sendConnect() or
     * sendConnectError() method. Do not invoke this method on your own.
     *
     * <b>Documentation of 'Connect'</b>:
     *
     * In case of successful connection, audio manager issues a connection ID for the current connection made
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onConnectRequest (const ::boost::shared_ptr< ConnectRequest >& request) = 0;

    /**
     * The method sendConnectResponse() sends a response of a previous method
     * invocation of 'Connect' back to the client.
     *
     * <b>Documentation of 'Connect'</b>:
     *
     * In case of successful connection, audio manager issues a connection ID for the current connection made
     *
     * @param result If the meaning of "result" isn't clear, then there should be a description here.
     *
     * @param mainConnectionID If the meaning of "mainConnectionID" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onConnect(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendConnectResponse (int16 result, uint16 mainConnectionID, act_t act = 0);

    /**
     * The method sendConnectError() sends an error response of a previous
     * method invocation of 'Connect' back to the client.
     *
     * <b>Documentation of 'Connect'</b>:
     *
     * In case of successful connection, audio manager issues a connection ID for the current connection made
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onConnect(). If the act
     * is not specified, i.e. the most recent invocation will be answered. In
     * case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendConnectError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'Disconnect'

    /**
     * The method onDisconnect() is called by ASF when a client invokes the
     * method 'Disconnect'. A subclass has to implement this method and send
     * back a response to the client either with the sendDisconnect() or
     * sendDisconnectError() method. Do not invoke this method on your own.
     *
     * <b>Documentation of 'Disconnect'</b>:
     *
     * Result of operation. Refer list of error codes.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onDisconnectRequest (const ::boost::shared_ptr< DisconnectRequest >& request) = 0;

    /**
     * The method sendDisconnectResponse() sends a response of a previous
     * method invocation of 'Disconnect' back to the client.
     *
     * <b>Documentation of 'Disconnect'</b>:
     *
     * Result of operation. Refer list of error codes.
     *
     * @param result If the meaning of "result" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onDisconnect(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendDisconnectResponse (int16 result, act_t act = 0);

    /**
     * The method sendDisconnectError() sends an error response of a previous
     * method invocation of 'Disconnect' back to the client.
     *
     * <b>Documentation of 'Disconnect'</b>:
     *
     * Result of operation. Refer list of error codes.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onDisconnect(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendDisconnectError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'SetVolume'

    /**
     * The method onSetVolume() is called by ASF when a client invokes the
     * method 'SetVolume'. A subclass has to implement this method and send
     * back a response to the client either with the sendSetVolume() or
     * sendSetVolumeError() method. Do not invoke this method on your own.
     *
     * <b>Documentation of 'SetVolume'</b>:
     *
     * Result of operation. Refer list of error codes.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onSetVolumeRequest (const ::boost::shared_ptr< SetVolumeRequest >& request) = 0;

    /**
     * The method sendSetVolumeResponse() sends a response of a previous
     * method invocation of 'SetVolume' back to the client.
     *
     * <b>Documentation of 'SetVolume'</b>:
     *
     * Result of operation. Refer list of error codes.
     *
     * @param result If the meaning of "result" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onSetVolume(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendSetVolumeResponse (int16 result, act_t act = 0);

    /**
     * The method sendSetVolumeError() sends an error response of a previous
     * method invocation of 'SetVolume' back to the client.
     *
     * <b>Documentation of 'SetVolume'</b>:
     *
     * Result of operation. Refer list of error codes.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onSetVolume(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendSetVolumeError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'SetSinkMuteState'

    /**
     * The method onSetSinkMuteState() is called by ASF when a client invokes
     * the method 'SetSinkMuteState'. A subclass has to implement this method
     * and send back a response to the client either with the
     * sendSetSinkMuteState() or sendSetSinkMuteStateError() method. Do not
     * invoke this method on your own.
     *
     * <b>Documentation of 'SetSinkMuteState'</b>:
     *
     * Result of operation. Refer list of error codes.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onSetSinkMuteStateRequest (const ::boost::shared_ptr< SetSinkMuteStateRequest >& request) = 0;

    /**
     * The method sendSetSinkMuteStateResponse() sends a response of a
     * previous method invocation of 'SetSinkMuteState' back to the client.
     *
     * <b>Documentation of 'SetSinkMuteState'</b>:
     *
     * Result of operation. Refer list of error codes.
     *
     * @param result If the meaning of "result" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onSetSinkMuteState(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendSetSinkMuteStateResponse (int16 result, act_t act = 0);

    /**
     * The method sendSetSinkMuteStateError() sends an error response of a
     * previous method invocation of 'SetSinkMuteState' back to the client.
     *
     * <b>Documentation of 'SetSinkMuteState'</b>:
     *
     * Result of operation. Refer list of error codes.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onSetSinkMuteState(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendSetSinkMuteStateError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'SetMainSinkSoundProperty'

    /**
     * The method onSetMainSinkSoundProperty() is called by ASF when a client
     * invokes the method 'SetMainSinkSoundProperty'. A subclass has to
     * implement this method and send back a response to the client either
     * with the sendSetMainSinkSoundProperty() or
     * sendSetMainSinkSoundPropertyError() method. Do not invoke this method
     * on your own.
     *
     * <b>Documentation of 'SetMainSinkSoundProperty'</b>:
     *
     * Result of operation. Refer list of error codes.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onSetMainSinkSoundPropertyRequest (const ::boost::shared_ptr< SetMainSinkSoundPropertyRequest >& request) = 0;

    /**
     * The method sendSetMainSinkSoundPropertyResponse() sends a response of a
     * previous method invocation of 'SetMainSinkSoundProperty' back to the
     * client.
     *
     * <b>Documentation of 'SetMainSinkSoundProperty'</b>:
     *
     * Result of operation. Refer list of error codes.
     *
     * @param result If the meaning of "result" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onSetMainSinkSoundProperty(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendSetMainSinkSoundPropertyResponse (int16 result, act_t act = 0);

    /**
     * The method sendSetMainSinkSoundPropertyError() sends an error response
     * of a previous method invocation of 'SetMainSinkSoundProperty' back to
     * the client.
     *
     * <b>Documentation of 'SetMainSinkSoundProperty'</b>:
     *
     * Result of operation. Refer list of error codes.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onSetMainSinkSoundProperty(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendSetMainSinkSoundPropertyError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'SetMainSourceSoundProperty'

    /**
     * The method onSetMainSourceSoundProperty() is called by ASF when a
     * client invokes the method 'SetMainSourceSoundProperty'. A subclass has
     * to implement this method and send back a response to the client either
     * with the sendSetMainSourceSoundProperty() or
     * sendSetMainSourceSoundPropertyError() method. Do not invoke this method
     * on your own.
     *
     * <b>Documentation of 'SetMainSourceSoundProperty'</b>:
     *
     * Result of operation. Refer list of error codes.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onSetMainSourceSoundPropertyRequest (const ::boost::shared_ptr< SetMainSourceSoundPropertyRequest >& request) = 0;

    /**
     * The method sendSetMainSourceSoundPropertyResponse() sends a response of
     * a previous method invocation of 'SetMainSourceSoundProperty' back to
     * the client.
     *
     * <b>Documentation of 'SetMainSourceSoundProperty'</b>:
     *
     * Result of operation. Refer list of error codes.
     *
     * @param result If the meaning of "result" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onSetMainSourceSoundProperty(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendSetMainSourceSoundPropertyResponse (int16 result, act_t act = 0);

    /**
     * The method sendSetMainSourceSoundPropertyError() sends an error
     * response of a previous method invocation of
     * 'SetMainSourceSoundProperty' back to the client.
     *
     * <b>Documentation of 'SetMainSourceSoundProperty'</b>:
     *
     * Result of operation. Refer list of error codes.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onSetMainSourceSoundProperty(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendSetMainSourceSoundPropertyError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'SetSystemProperty'

    /**
     * The method onSetSystemProperty() is called by ASF when a client invokes
     * the method 'SetSystemProperty'. A subclass has to implement this method
     * and send back a response to the client either with the
     * sendSetSystemProperty() or sendSetSystemPropertyError() method. Do not
     * invoke this method on your own.
     *
     * <b>Documentation of 'SetSystemProperty'</b>:
     *
     * Result of operation. Refer list of error codes.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onSetSystemPropertyRequest (const ::boost::shared_ptr< SetSystemPropertyRequest >& request) = 0;

    /**
     * The method sendSetSystemPropertyResponse() sends a response of a
     * previous method invocation of 'SetSystemProperty' back to the client.
     *
     * <b>Documentation of 'SetSystemProperty'</b>:
     *
     * Result of operation. Refer list of error codes.
     *
     * @param result If the meaning of "result" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onSetSystemProperty(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendSetSystemPropertyResponse (int16 result, act_t act = 0);

    /**
     * The method sendSetSystemPropertyError() sends an error response of a
     * previous method invocation of 'SetSystemProperty' back to the client.
     *
     * <b>Documentation of 'SetSystemProperty'</b>:
     *
     * Result of operation. Refer list of error codes.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onSetSystemProperty().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendSetSystemPropertyError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'GetListMainConnections'

    /**
     * The method onGetListMainConnections() is called by ASF when a client
     * invokes the method 'GetListMainConnections'. A subclass has to
     * implement this method and send back a response to the client either
     * with the sendGetListMainConnections() or
     * sendGetListMainConnectionsError() method. Do not invoke this method on
     * your own.
     *
     * <b>Documentation of 'GetListMainConnections'</b>:
     *
     * list of main connections. Refer to am_MainConnectionType_s
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onGetListMainConnectionsRequest (const ::boost::shared_ptr< GetListMainConnectionsRequest >& request) = 0;

    /**
     * The method sendGetListMainConnectionsResponse() sends a response of a
     * previous method invocation of 'GetListMainConnections' back to the
     * client.
     *
     * <b>Documentation of 'GetListMainConnections'</b>:
     *
     * list of main connections. Refer to am_MainConnectionType_s
     *
     * @param result If the meaning of "result" isn't clear, then there should be a description here.
     *
     * @param listConnections If the meaning of "listConnections" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onGetListMainConnections(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendGetListMainConnectionsResponse (int16 result, const ::std::vector< GetListMainConnectionsResponseListConnectionsStruct >& listConnections, act_t act = 0);

    /**
     * The method sendGetListMainConnectionsError() sends an error response of
     * a previous method invocation of 'GetListMainConnections' back to the
     * client.
     *
     * <b>Documentation of 'GetListMainConnections'</b>:
     *
     * list of main connections. Refer to am_MainConnectionType_s
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onGetListMainConnections(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendGetListMainConnectionsError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'GetListMainSinks'

    /**
     * The method onGetListMainSinks() is called by ASF when a client invokes
     * the method 'GetListMainSinks'. A subclass has to implement this method
     * and send back a response to the client either with the
     * sendGetListMainSinks() or sendGetListMainSinksError() method. Do not
     * invoke this method on your own.
     *
     * <b>Documentation of 'GetListMainSinks'</b>:
     *
     * List of actual sinks. Refer to am_SinkType_s
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onGetListMainSinksRequest (const ::boost::shared_ptr< GetListMainSinksRequest >& request) = 0;

    /**
     * The method sendGetListMainSinksResponse() sends a response of a
     * previous method invocation of 'GetListMainSinks' back to the client.
     *
     * <b>Documentation of 'GetListMainSinks'</b>:
     *
     * List of actual sinks. Refer to am_SinkType_s
     *
     * @param result If the meaning of "result" isn't clear, then there should be a description here.
     *
     * @param listMainSinks If the meaning of "listMainSinks" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onGetListMainSinks(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendGetListMainSinksResponse (int16 result, const ::std::vector< GetListMainSinksResponseListMainSinksStruct >& listMainSinks, act_t act = 0);

    /**
     * The method sendGetListMainSinksError() sends an error response of a
     * previous method invocation of 'GetListMainSinks' back to the client.
     *
     * <b>Documentation of 'GetListMainSinks'</b>:
     *
     * List of actual sinks. Refer to am_SinkType_s
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onGetListMainSinks(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendGetListMainSinksError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'GetListMainSources'

    /**
     * The method onGetListMainSources() is called by ASF when a client
     * invokes the method 'GetListMainSources'. A subclass has to implement
     * this method and send back a response to the client either with the
     * sendGetListMainSources() or sendGetListMainSourcesError() method. Do
     * not invoke this method on your own.
     *
     * <b>Documentation of 'GetListMainSources'</b>:
     *
     * List of actual sources. Refer to am_SourceType_s
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onGetListMainSourcesRequest (const ::boost::shared_ptr< GetListMainSourcesRequest >& request) = 0;

    /**
     * The method sendGetListMainSourcesResponse() sends a response of a
     * previous method invocation of 'GetListMainSources' back to the client.
     *
     * <b>Documentation of 'GetListMainSources'</b>:
     *
     * List of actual sources. Refer to am_SourceType_s
     *
     * @param result If the meaning of "result" isn't clear, then there should be a description here.
     *
     * @param listMainSources If the meaning of "listMainSources" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onGetListMainSources(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendGetListMainSourcesResponse (int16 result, const ::std::vector< GetListMainSourcesResponseListMainSourcesStruct >& listMainSources, act_t act = 0);

    /**
     * The method sendGetListMainSourcesError() sends an error response of a
     * previous method invocation of 'GetListMainSources' back to the client.
     *
     * <b>Documentation of 'GetListMainSources'</b>:
     *
     * List of actual sources. Refer to am_SourceType_s
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onGetListMainSources().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendGetListMainSourcesError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'GetListMainSinkSoundProperties'

    /**
     * The method onGetListMainSinkSoundProperties() is called by ASF when a
     * client invokes the method 'GetListMainSinkSoundProperties'. A subclass
     * has to implement this method and send back a response to the client
     * either with the sendGetListMainSinkSoundProperties() or
     * sendGetListMainSinkSoundPropertiesError() method. Do not invoke this
     * method on your own.
     *
     * <b>Documentation of 'GetListMainSinkSoundProperties'</b>:
     *
     * List of sound properties. Refer to am_MainSoundProperty_s
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onGetListMainSinkSoundPropertiesRequest (const ::boost::shared_ptr< GetListMainSinkSoundPropertiesRequest >& request) = 0;

    /**
     * The method sendGetListMainSinkSoundPropertiesResponse() sends a
     * response of a previous method invocation of
     * 'GetListMainSinkSoundProperties' back to the client.
     *
     * <b>Documentation of 'GetListMainSinkSoundProperties'</b>:
     *
     * List of sound properties. Refer to am_MainSoundProperty_s
     *
     * @param result If the meaning of "result" isn't clear, then there should be a description here.
     *
     * @param listSoundProperties If the meaning of "listSoundProperties" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onGetListMainSinkSoundProperties(). If the act is not specified, i.e.
     * the most recent invocation will be answered. In case multiple replies
     * are pending an act must be specified. An assertion will be thrown if no
     * or multiple method invocation could be found.
     */
    void sendGetListMainSinkSoundPropertiesResponse (int16 result, const ::std::vector< GetListMainSinkSoundPropertiesResponseListSoundPropertiesStruct >& listSoundProperties, act_t act = 0);

    /**
     * The method sendGetListMainSinkSoundPropertiesError() sends an error
     * response of a previous method invocation of
     * 'GetListMainSinkSoundProperties' back to the client.
     *
     * <b>Documentation of 'GetListMainSinkSoundProperties'</b>:
     *
     * List of sound properties. Refer to am_MainSoundProperty_s
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onGetListMainSinkSoundProperties(). If the act is not specified, i.e.
     * the most recent invocation will be answered. In case multiple replies
     * are pending an act must be specified. An assertion will be thrown if no
     * or multiple method invocation could be found.
     */
    void sendGetListMainSinkSoundPropertiesError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'GetListMainSourceSoundProperties'

    /**
     * The method onGetListMainSourceSoundProperties() is called by ASF when a
     * client invokes the method 'GetListMainSourceSoundProperties'. A
     * subclass has to implement this method and send back a response to the
     * client either with the sendGetListMainSourceSoundProperties() or
     * sendGetListMainSourceSoundPropertiesError() method. Do not invoke this
     * method on your own.
     *
     * <b>Documentation of 'GetListMainSourceSoundProperties'</b>:
     *
     * List of sound properties. Refer to am_MainSoundProperty_s
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onGetListMainSourceSoundPropertiesRequest (const ::boost::shared_ptr< GetListMainSourceSoundPropertiesRequest >& request) = 0;

    /**
     * The method sendGetListMainSourceSoundPropertiesResponse() sends a
     * response of a previous method invocation of
     * 'GetListMainSourceSoundProperties' back to the client.
     *
     * <b>Documentation of 'GetListMainSourceSoundProperties'</b>:
     *
     * List of sound properties. Refer to am_MainSoundProperty_s
     *
     * @param result If the meaning of "result" isn't clear, then there should be a description here.
     *
     * @param listSourceProperties If the meaning of "listSourceProperties" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onGetListMainSourceSoundProperties(). If the act is not specified, i.e.
     * the most recent invocation will be answered. In case multiple replies
     * are pending an act must be specified. An assertion will be thrown if no
     * or multiple method invocation could be found.
     */
    void sendGetListMainSourceSoundPropertiesResponse (int16 result, const ::std::vector< GetListMainSourceSoundPropertiesResponseListSourcePropertiesStruct >& listSourceProperties, act_t act = 0);

    /**
     * The method sendGetListMainSourceSoundPropertiesError() sends an error
     * response of a previous method invocation of
     * 'GetListMainSourceSoundProperties' back to the client.
     *
     * <b>Documentation of 'GetListMainSourceSoundProperties'</b>:
     *
     * List of sound properties. Refer to am_MainSoundProperty_s
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onGetListMainSourceSoundProperties(). If the act is not specified, i.e.
     * the most recent invocation will be answered. In case multiple replies
     * are pending an act must be specified. An assertion will be thrown if no
     * or multiple method invocation could be found.
     */
    void sendGetListMainSourceSoundPropertiesError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'GetListSourceClasses'

    /**
     * The method onGetListSourceClasses() is called by ASF when a client
     * invokes the method 'GetListSourceClasses'. A subclass has to implement
     * this method and send back a response to the client either with the
     * sendGetListSourceClasses() or sendGetListSourceClassesError() method.
     * Do not invoke this method on your own.
     *
     * <b>Documentation of 'GetListSourceClasses'</b>:
     *
     * List of source classes. Refer am_SourceClass_s
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onGetListSourceClassesRequest (const ::boost::shared_ptr< GetListSourceClassesRequest >& request) = 0;

    /**
     * The method sendGetListSourceClassesResponse() sends a response of a
     * previous method invocation of 'GetListSourceClasses' back to the
     * client.
     *
     * <b>Documentation of 'GetListSourceClasses'</b>:
     *
     * List of source classes. Refer am_SourceClass_s
     *
     * @param result If the meaning of "result" isn't clear, then there should be a description here.
     *
     * @param listSourceClasses If the meaning of "listSourceClasses" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onGetListSourceClasses(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendGetListSourceClassesResponse (int16 result, const ::std::vector< GetListSourceClassesResponseListSourceClassesStruct >& listSourceClasses, act_t act = 0);

    /**
     * The method sendGetListSourceClassesError() sends an error response of a
     * previous method invocation of 'GetListSourceClasses' back to the
     * client.
     *
     * <b>Documentation of 'GetListSourceClasses'</b>:
     *
     * List of source classes. Refer am_SourceClass_s
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onGetListSourceClasses(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendGetListSourceClassesError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'GetListSinkClasses'

    /**
     * The method onGetListSinkClasses() is called by ASF when a client
     * invokes the method 'GetListSinkClasses'. A subclass has to implement
     * this method and send back a response to the client either with the
     * sendGetListSinkClasses() or sendGetListSinkClassesError() method. Do
     * not invoke this method on your own.
     *
     * <b>Documentation of 'GetListSinkClasses'</b>:
     *
     * List of Sink Classes. Refer am_SinkClass_s
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onGetListSinkClassesRequest (const ::boost::shared_ptr< GetListSinkClassesRequest >& request) = 0;

    /**
     * The method sendGetListSinkClassesResponse() sends a response of a
     * previous method invocation of 'GetListSinkClasses' back to the client.
     *
     * <b>Documentation of 'GetListSinkClasses'</b>:
     *
     * List of Sink Classes. Refer am_SinkClass_s
     *
     * @param result If the meaning of "result" isn't clear, then there should be a description here.
     *
     * @param listSinkClasses If the meaning of "listSinkClasses" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onGetListSinkClasses(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendGetListSinkClassesResponse (int16 result, const ::std::vector< GetListSinkClassesResponseListSinkClassesStruct >& listSinkClasses, act_t act = 0);

    /**
     * The method sendGetListSinkClassesError() sends an error response of a
     * previous method invocation of 'GetListSinkClasses' back to the client.
     *
     * <b>Documentation of 'GetListSinkClasses'</b>:
     *
     * List of Sink Classes. Refer am_SinkClass_s
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onGetListSinkClasses().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendGetListSinkClassesError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'GetListSystemProperties'

    /**
     * The method onGetListSystemProperties() is called by ASF when a client
     * invokes the method 'GetListSystemProperties'. A subclass has to
     * implement this method and send back a response to the client either
     * with the sendGetListSystemProperties() or
     * sendGetListSystemPropertiesError() method. Do not invoke this method on
     * your own.
     *
     * <b>Documentation of 'GetListSystemProperties'</b>:
     *
     * List of System Properties. Refer am_SystemProperty_s
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onGetListSystemPropertiesRequest (const ::boost::shared_ptr< GetListSystemPropertiesRequest >& request) = 0;

    /**
     * The method sendGetListSystemPropertiesResponse() sends a response of a
     * previous method invocation of 'GetListSystemProperties' back to the
     * client.
     *
     * <b>Documentation of 'GetListSystemProperties'</b>:
     *
     * List of System Properties. Refer am_SystemProperty_s
     *
     * @param result If the meaning of "result" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onGetListSystemProperties(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendGetListSystemPropertiesResponse (int16 result, act_t act = 0);

    /**
     * The method sendGetListSystemPropertiesError() sends an error response
     * of a previous method invocation of 'GetListSystemProperties' back to
     * the client.
     *
     * <b>Documentation of 'GetListSystemProperties'</b>:
     *
     * List of System Properties. Refer am_SystemProperty_s
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onGetListSystemProperties(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendGetListSystemPropertiesError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'GetTimingInformation'

    /**
     * The method onGetTimingInformation() is called by ASF when a client
     * invokes the method 'GetTimingInformation'. A subclass has to implement
     * this method and send back a response to the client either with the
     * sendGetTimingInformation() or sendGetTimingInformationError() method.
     * Do not invoke this method on your own.
     *
     * <b>Documentation of 'GetTimingInformation'</b>:
     *
     * Delay in Milliseconds
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onGetTimingInformationRequest (const ::boost::shared_ptr< GetTimingInformationRequest >& request) = 0;

    /**
     * The method sendGetTimingInformationResponse() sends a response of a
     * previous method invocation of 'GetTimingInformation' back to the
     * client.
     *
     * <b>Documentation of 'GetTimingInformation'</b>:
     *
     * Delay in Milliseconds
     *
     * @param result If the meaning of "result" isn't clear, then there should be a description here.
     *
     * @param delay If the meaning of "delay" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onGetTimingInformation(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendGetTimingInformationResponse (int16 result, int16 delay, act_t act = 0);

    /**
     * The method sendGetTimingInformationError() sends an error response of a
     * previous method invocation of 'GetTimingInformation' back to the
     * client.
     *
     * <b>Documentation of 'GetTimingInformation'</b>:
     *
     * Delay in Milliseconds
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onGetTimingInformation(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendGetTimingInformationError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

private:
    void onGetAll(std::map<std::basic_string<char>, ::asf::dbus::DBusVariant>&) const;

    friend class CommandInterfaceStubDelegate;

    DECLARE_CLASS_LOGGER();
};

} // namespace CommandInterface
} // namespace audiomanager
} // namespace genivi
} // namespace org

#endif // ORG_GENIVI_AUDIOMANAGER_COMMANDINTERFACESTUB_H
