/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/Application.h"
#include "asf/core/ComponentContainer.h"
#include "asf/core/ComponentDescription.h"
#include "asf/core/ContextData.h"
#include "asf/core/Logger.h"
#include "asf/core/RequiredPort.h"
#include "asf/core/SignalHandler.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusImportedPort.h"
#include "com/bosch/cm/asf/lang/dbus/Connectors.h"
#include "com/bosch/cm/asf/lang/dbus/ConnectorsJson.h"
#include "example/echoCca/dbusAdapterClient/DBusAdapterClient.h"
#include "example/echoCca/dbusAdapterClient/DBusAdapterClientComponent.h"
#include <cstdio>
#include <string>

/**
 * If the meaning of "DBusAdapterClient" isn't clear, then there should be a description here.
 */

namespace example {
namespace echoCca {
namespace dbusAdapterClient {

DEFINE_LOGGER_AND_LEVEL (_logger, "/example/echoCca/dbusAdapterClient/DBusAdapterClient", Info);

/* static */ const char* DBusAdapterClient::dbusAdapterClient = "dbusAdapterClient";

static const char* helpMessage =
    "--logconfig <file>     Read the logging configuration from <file>\n"
    "                       see the ASF User Guide, section 6.3. Logging API\n"
    "--help                 Print this help message\n";

bool DBusAdapterClient_enabledASFSignalHandler = false;

void importDBusAdapterClient() {
    ::asf::core::Application* app = ::asf::core::Application::getApplication();
    LOG_ASSERT_FATAL_MSG_STATIC(app, "Can't attach DBusAdapterClient, because no Application is instantiated");

    // Expression

    ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector dbusConnector;
    {
        ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector __expression0;
        {
            __expression0.setBusType(::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector::BusType__Session);
        }
        dbusConnector = __expression0;
    }
    {
        std::string jsonPayload;
        serializeJson (dbusConnector, jsonPayload);
        LOG_INFO_STATIC ("Creating connector %s (%s), configuration: %s", "dbusConnector", "DBusConnector", jsonPayload.c_str());
    }
    ::boost::shared_ptr< ::asf::dbus::DBusConnector > dbusConnector_(new ::asf::dbus::DBusConnector(*app, dbusConnector));
    app->addStarter(dbusConnector_);

    // Thread 'thread1'

    ::asf::core::ComponentContainerSharedPtr Thread1(new ::asf::core::ComponentContainer("thread1", ::asf::core::ThreadConfiguration(1)));
    app->addContainer (Thread1);

        // Component 'DBusAdapterClientComponent dbusAdapterClient'

        ::boost::shared_ptr< ::asf::core::ComponentFactory< ::example::echoCca::dbusAdapterClient::DBusAdapterClientComponent > > dbusAdapterClientFactory(new ::asf::core::ComponentFactory< ::example::echoCca::dbusAdapterClient::DBusAdapterClientComponent >);
        ::asf::core::ComponentDescriptionSharedPtr dbusAdapterClientDescription(new ::asf::core::ComponentDescription(1, "dbusAdapterClient", /* immediate = */ true, /* threadBridge = */ false, dbusAdapterClientFactory));
        Thread1->addComponentDescription(dbusAdapterClientDescription);

            // Port 'echoPort'

            ::asf::core::RequiredPort& dbusAdapterClient_echoPort = dbusAdapterClientDescription->addRequiredPort (::asf::core::RequiredPort ("example.echoDBus.EchoDBusService", "echoPort"));
            (void)dbusAdapterClient_echoPort; // prevent unused variable warning

    // Expression

    ::asf::dbus::DBusImportedPort& echoImport = dbusConnector_->importByName (::std::string("example.echoCca.dbusAdapter.DBusAdapterApplication"), ::std::string("/com/bosch/cm/example/server/Echo1"));
    echoImport.setServiceName("example.echoDBus.EchoDBusService");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (dbusAdapterClient_echoPort, echoImport);


    LOG_INFO_STATIC("Starting application 'DBusAdapterClient' version 1.0.0");

    app->start();
}

int executeDBusAdapterClient(int argc, char* argv[]) {
    ::asf::core::ContextData context;

    const char* logConfigFile = 0;
    std::vector<std::string> arguments;

    for (int i=1; i<argc; i++) {
        if (std::string(argv[i]) == "--logconfig" && i+1 < argc) {
            // ignore lint warning e850: modification of i inside loop is safe
            logConfigFile = argv[++i];
        } else {
            if (std::string(argv[i]) == "--help") {
                printf ("%s", helpMessage);
                exit (0);
            } else {
                arguments.push_back (argv[i]);
            }
        }
    }

    if (logConfigFile == 0) {
        ::asf::core::Logger::setupLogging ("example.echoCca.dbusAdapterClient", "DBusAdapterClient");
    } else {
        ::asf::core::Logger::setupLogging ("example.echoCca.dbusAdapterClient", "DBusAdapterClient", logConfigFile);
    }

    LOG_INFO_STATIC("%s ASF signal handler", DBusAdapterClient_enabledASFSignalHandler ? "Enabled" : "Disabled" );

    ::asf::core::Application* app = ::asf::core::Application::createApplication("example.echoCca.dbusAdapterClient", "DBusAdapterClient", ::asf::core::Version(1, 0, 0, ""), arguments);

    LOG_ASSERT_FATAL_MSG_STATIC(app, "Can't create DBusAdapterClient");

    app->enableExceptionHandler(true);

    importDBusAdapterClient();

    int exitCode = app->waitForCompletion();
    ::asf::core::Application::deleteApplication();

    return exitCode;
}

} // namespace dbusAdapterClient
} // namespace echoCca
} // namespace example

int main(int argc, char* argv[]) {
    ::example::echoCca::dbusAdapterClient::DBusAdapterClient_enabledASFSignalHandler = true;
    ::asf::core::SignalHandler asfSignalHandler;
    ::boost::shared_ptr< ::asf::threading::Thread > mainThread = ::asf::threading::Thread::attach();
    return ::example::echoCca::dbusAdapterClient::executeDBusAdapterClient(argc, argv);
}

