/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/cca/CcaConnector.h"
#include "asf/cca/CcaImportedPort.h"
#include "asf/core/Application.h"
#include "asf/core/ComponentContainer.h"
#include "asf/core/ComponentDescription.h"
#include "asf/core/ContextData.h"
#include "asf/core/Logger.h"
#include "asf/core/ProvidedPort.h"
#include "asf/core/RequiredPort.h"
#include "asf/core/SignalHandler.h"
#include "asf/dbus/DBusConnector.h"
#include "com/bosch/cm/asf/lang/cca/Connectors.h"
#include "com/bosch/cm/asf/lang/cca/ConnectorsJson.h"
#include "com/bosch/cm/asf/lang/dbus/Connectors.h"
#include "com/bosch/cm/asf/lang/dbus/ConnectorsJson.h"
#include "example/echoCca/dbusAdapter/DBusAdapterApplication.h"
#include "example/echoCca/dbusAdapter/DBusAdapterComponent.h"
#include <cstdio>
#include <string>

/**
 * If the meaning of "DBusAdapterApplication" isn't clear, then there should be a description here.
 */

namespace example {
namespace echoCca {
namespace dbusAdapter {

DEFINE_LOGGER_AND_LEVEL (_logger, "/example/echoCca/dbusAdapter/DBusAdapterApplication", Info);

/* static */ const char* DBusAdapterApplication::dbusAdapter = "dbusAdapter";

static const char* helpMessage =
    "--logconfig <file>     Read the logging configuration from <file>\n"
    "                       see the ASF User Guide, section 6.3. Logging API\n"
    "--help                 Print this help message\n";

bool DBusAdapterApplication_enabledASFSignalHandler = false;

void importDBusAdapterApplication() {
    ::asf::core::Application* app = ::asf::core::Application::getApplication();
    LOG_ASSERT_FATAL_MSG_STATIC(app, "Can't attach DBusAdapterApplication, because no Application is instantiated");

    // Expression

    ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector dbusConnector;
    {
        ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector __expression0;
        {
            __expression0.setBusType(::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector::BusType__Session);
        }
        dbusConnector = __expression0;
    }
    {
        std::string jsonPayload;
        serializeJson (dbusConnector, jsonPayload);
        LOG_INFO_STATIC ("Creating connector %s (%s), configuration: %s", "dbusConnector", "DBusConnector", jsonPayload.c_str());
    }
    ::boost::shared_ptr< ::asf::dbus::DBusConnector > dbusConnector_(new ::asf::dbus::DBusConnector(*app, dbusConnector));
    app->addStarter(dbusConnector_);

    // Expression

    ::com::bosch::cm::asf::lang::cca::Connectors::CcaConnector ccaConnector;
    {
        ::com::bosch::cm::asf::lang::cca::Connectors::CcaConnector __expression1;
        {
            __expression1.setApplicationId(45);
        }
        ccaConnector = __expression1;
    }
    {
        std::string jsonPayload;
        serializeJson (ccaConnector, jsonPayload);
        LOG_INFO_STATIC ("Creating connector %s (%s), configuration: %s", "ccaConnector", "CcaConnector", jsonPayload.c_str());
    }
    ::boost::shared_ptr< ::asf::cca::CcaConnector > ccaConnector_(new ::asf::cca::CcaConnector(*app, ccaConnector));
    app->addStarter(ccaConnector_);

    // Thread 'thread1'

    ::asf::core::ComponentContainerSharedPtr Thread1(new ::asf::core::ComponentContainer("thread1", ::asf::core::ThreadConfiguration(1)));
    app->addContainer (Thread1);

        // Component 'DBusAdapterComponent dbusAdapter'

        ::boost::shared_ptr< ::asf::core::ComponentFactory< ::example::echoCca::dbusAdapter::DBusAdapterComponent > > dbusAdapterFactory(new ::asf::core::ComponentFactory< ::example::echoCca::dbusAdapter::DBusAdapterComponent >);
        ::asf::core::ComponentDescriptionSharedPtr dbusAdapterDescription(new ::asf::core::ComponentDescription(1, "dbusAdapter", /* immediate = */ true, /* threadBridge = */ false, dbusAdapterFactory));
        Thread1->addComponentDescription(dbusAdapterDescription);

            // Port 'echoPort'

            ::asf::core::ProvidedPort& dbusAdapter_echoPort = dbusAdapterDescription->addProvidedPort (::asf::core::ProvidedPort ("example.echoDBus.EchoDBusService", "echoPort", false, false));
            (void)dbusAdapter_echoPort; // prevent unused variable warning

            // Port 'echoFiPort'

            ::asf::core::RequiredPort& dbusAdapter_echoFiPort = dbusAdapterDescription->addRequiredPort (::asf::core::RequiredPort ("EchoFI", "echoFiPort"));
            (void)dbusAdapter_echoFiPort; // prevent unused variable warning

    // Expression

    dbusConnector_->exportByName (dbusAdapter_echoPort, ::std::string("/com/bosch/cm/example/server/Echo1"));

    // Expression

    ::asf::cca::CcaImportedPort& echoFiImport = ccaConnector_->importByName (42, 1, 0, 0);
    echoFiImport.setServiceName("EchoFI");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (dbusAdapter_echoFiPort, echoFiImport);


    LOG_INFO_STATIC("Starting application 'DBusAdapterApplication' version 1.0.0");

    app->start();
}

int executeDBusAdapterApplication(int argc, char* argv[]) {
    ::asf::core::ContextData context;

    const char* logConfigFile = 0;
    std::vector<std::string> arguments;

    for (int i=1; i<argc; i++) {
        if (std::string(argv[i]) == "--logconfig" && i+1 < argc) {
            // ignore lint warning e850: modification of i inside loop is safe
            logConfigFile = argv[++i];
        } else {
            if (std::string(argv[i]) == "--help") {
                printf ("%s", helpMessage);
                exit (0);
            } else {
                arguments.push_back (argv[i]);
            }
        }
    }

    if (logConfigFile == 0) {
        ::asf::core::Logger::setupLogging ("example.echoCca.dbusAdapter", "DBusAdapterApplication");
    } else {
        ::asf::core::Logger::setupLogging ("example.echoCca.dbusAdapter", "DBusAdapterApplication", logConfigFile);
    }

    LOG_INFO_STATIC("%s ASF signal handler", DBusAdapterApplication_enabledASFSignalHandler ? "Enabled" : "Disabled" );

    ::asf::core::Application* app = ::asf::core::Application::createApplication("example.echoCca.dbusAdapter", "DBusAdapterApplication", ::asf::core::Version(1, 0, 0, ""), arguments);

    LOG_ASSERT_FATAL_MSG_STATIC(app, "Can't create DBusAdapterApplication");

    app->enableExceptionHandler(true);

    importDBusAdapterApplication();

    int exitCode = app->waitForCompletion();
    ::asf::core::Application::deleteApplication();

    return exitCode;
}

} // namespace dbusAdapter
} // namespace echoCca
} // namespace example

int main(int argc, char* argv[]) {
    ::example::echoCca::dbusAdapter::DBusAdapterApplication_enabledASFSignalHandler = true;
    ::asf::core::SignalHandler asfSignalHandler;
    ::boost::shared_ptr< ::asf::threading::Thread > mainThread = ::asf::threading::Thread::attach();
    return ::example::echoCca::dbusAdapter::executeDBusAdapterApplication(argc, argv);
}

