/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusStubDelegate.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "org/bosch/ecnr/service.h"
#include "org/bosch/ecnr/serviceDBus.h"
#include "org/bosch/ecnr/serviceJson.h"
#include "org/bosch/ecnr/serviceStub.h"
#include <string>
#include <vector>

#include "asf/dbus/DBusMessage.h"

namespace org {
namespace bosch {
namespace ecnr {
namespace service {

DEFINE_CLASS_LOGGER("///org/bosch/ecnr/service", ServiceStub);

static ::asf::dbus::DBusUtils::stringEntry methodsTable[] = {
    { 9, "ecnrReset", 4 },
    { 11, "ecnrDestroy", 5 },
    { 13, "ecnrFrameInfo", 13 },
    { 13, "ecnrStopAudio", 12 },
    { 13, "ecnrTerminate", 6 },
    { 14, "ecnrGetVersion", 0 },
    { 14, "ecnrInitialize", 2 },
    { 14, "ecnrSetMicGain", 21 },
    { 14, "ecnrStartAudio", 10 },
    { 16, "ecnrMicClipStats", 14 },
    { 16, "ecnrRefClipStats", 15 },
    { 16, "ecnrStartItcTest", 27 },
    { 17, "ecnrRecvClipStats", 16 },
    { 17, "ecnrStartAudioExt", 11 },
    { 18, "ecnrInitializeSync", 3 },
    { 18, "ecnrSetNRCombFloor", 23 },
    { 19, "ecnrMicOutClipStats", 17 },
    { 20, "ecnrGetStatusMessage", 1 },
    { 20, "ecnrRecvOutClipStats", 18 },
    { 20, "ecnrSetConfiguration", 7 },
    { 20, "ecnrSetSendGainDelta", 20 },
    { 21, "ecnrSetNoiseReduction", 25 },
    { 21, "ecnrSetSendMuteSwitch", 19 },
    { 22, "ecnrGetEngineParameter", 26 },
    { 22, "ecnrSetPassThroughMode", 22 },
    { 23, "ecnrSetEchoCancellation", 24 },
    { 24, "ecnrGetEcnrConfiguration", 9 },
    { 24, "ecnrSetConfigurationSync", 8 },
};

static ::asf::dbus::DBusUtils::stringEntry propertiesTable[] = {
    { 11, "ecnrAsrMode", 1 },
    { 14, "ecnrAudioState", 2 },
    { 15, "ecnrAsrDataType", 3 },
    { 22, "ecnrMicLvlNtfyInterval", 0 },
};

class ServiceStubDelegate : public ::asf::dbus::DBusStubDelegate {
public:

    ServiceStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger) :
        ::asf::dbus::DBusStubDelegate( stub, logger),
        _logger(logger)
    {}

    ServiceStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger, const std::string& objectPath) :
        ::asf::dbus::DBusStubDelegate( stub, logger, objectPath),
        _logger(logger) {}

    ServiceStubDelegate(::asf::dbus::DBusStub* stub,
                               ::asf::core::Logger& logger,
                               ::asf::dbus::DBusConnector& connector,
                               const std::string& objectPath)
        : ::asf::dbus::DBusStubDelegate(
              stub, logger, connector, objectPath, "org.bosch.ecnr.service"),
          _logger(logger) {}

    virtual ~ServiceStubDelegate() {}

    virtual void process(::asf::core::ServiceMessage& msg);

    const char* introspect() const;

    virtual void getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties);

    virtual void setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act);

    virtual void getProperty(const ::std::string& property, const act_t& act);

private:

    ::asf::core::Logger& _logger;

};

void ServiceStubDelegate::process(::asf::core::ServiceMessage& msg) {
    ::asf::dbus::DBusMessage& message = static_cast< ::asf::dbus::DBusMessage& >(msg);
    LOG_DEBUG_STUB("Entering process(memberName='%s')", message.getMemberName().c_str());

    unsigned int methodIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (message.getMemberName().c_str(), message.getMemberName().length(), methodsTable, 28, methodIndex)) {
        switch (methodIndex) {
        case 0: {

            // method 'ecnrGetVersion'

            LOG_DEBUG_STUB("process method '%s'", "ecnrGetVersion");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), EcnrGetVersionRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "EcnrGetVersion", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< EcnrGetVersionRequest > payload = ::boost::static_pointer_cast<EcnrGetVersionRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ServiceStub*>(getStub())->onEcnrGetVersionRequest(payload);
            return;
        }
        case 1: {

            // method 'ecnrGetStatusMessage'

            LOG_DEBUG_STUB("process method '%s'", "ecnrGetStatusMessage");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), EcnrGetStatusMessageRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "EcnrGetStatusMessage", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< EcnrGetStatusMessageRequest > payload = ::boost::static_pointer_cast<EcnrGetStatusMessageRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ServiceStub*>(getStub())->onEcnrGetStatusMessageRequest(payload);
            return;
        }
        case 2: {

            // method 'ecnrInitialize'

            LOG_DEBUG_STUB("process method '%s'", "ecnrInitialize");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), EcnrInitializeRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "EcnrInitialize", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< EcnrInitializeRequest > payload = ::boost::static_pointer_cast<EcnrInitializeRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ServiceStub*>(getStub())->onEcnrInitializeRequest(payload);
            return;
        }
        case 3: {

            // method 'ecnrInitializeSync'

            LOG_DEBUG_STUB("process method '%s'", "ecnrInitializeSync");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), EcnrInitializeSyncRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "EcnrInitializeSync", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< EcnrInitializeSyncRequest > payload = ::boost::static_pointer_cast<EcnrInitializeSyncRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ServiceStub*>(getStub())->onEcnrInitializeSyncRequest(payload);
            return;
        }
        case 4: {

            // method 'ecnrReset'

            LOG_DEBUG_STUB("process method '%s'", "ecnrReset");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), EcnrResetRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "EcnrReset", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< EcnrResetRequest > payload = ::boost::static_pointer_cast<EcnrResetRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ServiceStub*>(getStub())->onEcnrResetRequest(payload);
            return;
        }
        case 5: {

            // method 'ecnrDestroy'

            LOG_DEBUG_STUB("process method '%s'", "ecnrDestroy");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), EcnrDestroyRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "EcnrDestroy", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< EcnrDestroyRequest > payload = ::boost::static_pointer_cast<EcnrDestroyRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ServiceStub*>(getStub())->onEcnrDestroyRequest(payload);
            return;
        }
        case 6: {

            // method 'ecnrTerminate'

            LOG_DEBUG_STUB("process method '%s'", "ecnrTerminate");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), EcnrTerminateRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "EcnrTerminate", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< EcnrTerminateRequest > payload = ::boost::static_pointer_cast<EcnrTerminateRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ServiceStub*>(getStub())->onEcnrTerminateRequest(payload);
            return;
        }
        case 7: {

            // method 'ecnrSetConfiguration'

            LOG_DEBUG_STUB("process method '%s'", "ecnrSetConfiguration");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), EcnrSetConfigurationRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "EcnrSetConfiguration", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< EcnrSetConfigurationRequest > payload = ::boost::static_pointer_cast<EcnrSetConfigurationRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ServiceStub*>(getStub())->onEcnrSetConfigurationRequest(payload);
            return;
        }
        case 8: {

            // method 'ecnrSetConfigurationSync'

            LOG_DEBUG_STUB("process method '%s'", "ecnrSetConfigurationSync");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), EcnrSetConfigurationSyncRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "EcnrSetConfigurationSync", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< EcnrSetConfigurationSyncRequest > payload = ::boost::static_pointer_cast<EcnrSetConfigurationSyncRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ServiceStub*>(getStub())->onEcnrSetConfigurationSyncRequest(payload);
            return;
        }
        case 9: {

            // method 'ecnrGetEcnrConfiguration'

            LOG_DEBUG_STUB("process method '%s'", "ecnrGetEcnrConfiguration");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), EcnrGetEcnrConfigurationRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "EcnrGetEcnrConfiguration", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< EcnrGetEcnrConfigurationRequest > payload = ::boost::static_pointer_cast<EcnrGetEcnrConfigurationRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ServiceStub*>(getStub())->onEcnrGetEcnrConfigurationRequest(payload);
            return;
        }
        case 10: {

            // method 'ecnrStartAudio'

            LOG_DEBUG_STUB("process method '%s'", "ecnrStartAudio");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), EcnrStartAudioRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "EcnrStartAudio", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< EcnrStartAudioRequest > payload = ::boost::static_pointer_cast<EcnrStartAudioRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ServiceStub*>(getStub())->onEcnrStartAudioRequest(payload);
            return;
        }
        case 11: {

            // method 'ecnrStartAudioExt'

            LOG_DEBUG_STUB("process method '%s'", "ecnrStartAudioExt");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), EcnrStartAudioExtRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "EcnrStartAudioExt", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< EcnrStartAudioExtRequest > payload = ::boost::static_pointer_cast<EcnrStartAudioExtRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ServiceStub*>(getStub())->onEcnrStartAudioExtRequest(payload);
            return;
        }
        case 12: {

            // method 'ecnrStopAudio'

            LOG_DEBUG_STUB("process method '%s'", "ecnrStopAudio");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), EcnrStopAudioRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "EcnrStopAudio", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< EcnrStopAudioRequest > payload = ::boost::static_pointer_cast<EcnrStopAudioRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ServiceStub*>(getStub())->onEcnrStopAudioRequest(payload);
            return;
        }
        case 13: {

            // method 'ecnrFrameInfo'

            LOG_DEBUG_STUB("process method '%s'", "ecnrFrameInfo");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), EcnrFrameInfoRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "EcnrFrameInfo", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< EcnrFrameInfoRequest > payload = ::boost::static_pointer_cast<EcnrFrameInfoRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ServiceStub*>(getStub())->onEcnrFrameInfoRequest(payload);
            return;
        }
        case 14: {

            // method 'ecnrMicClipStats'

            LOG_DEBUG_STUB("process method '%s'", "ecnrMicClipStats");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), EcnrMicClipStatsRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "EcnrMicClipStats", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< EcnrMicClipStatsRequest > payload = ::boost::static_pointer_cast<EcnrMicClipStatsRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ServiceStub*>(getStub())->onEcnrMicClipStatsRequest(payload);
            return;
        }
        case 15: {

            // method 'ecnrRefClipStats'

            LOG_DEBUG_STUB("process method '%s'", "ecnrRefClipStats");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), EcnrRefClipStatsRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "EcnrRefClipStats", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< EcnrRefClipStatsRequest > payload = ::boost::static_pointer_cast<EcnrRefClipStatsRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ServiceStub*>(getStub())->onEcnrRefClipStatsRequest(payload);
            return;
        }
        case 16: {

            // method 'ecnrRecvClipStats'

            LOG_DEBUG_STUB("process method '%s'", "ecnrRecvClipStats");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), EcnrRecvClipStatsRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "EcnrRecvClipStats", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< EcnrRecvClipStatsRequest > payload = ::boost::static_pointer_cast<EcnrRecvClipStatsRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ServiceStub*>(getStub())->onEcnrRecvClipStatsRequest(payload);
            return;
        }
        case 17: {

            // method 'ecnrMicOutClipStats'

            LOG_DEBUG_STUB("process method '%s'", "ecnrMicOutClipStats");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), EcnrMicOutClipStatsRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "EcnrMicOutClipStats", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< EcnrMicOutClipStatsRequest > payload = ::boost::static_pointer_cast<EcnrMicOutClipStatsRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ServiceStub*>(getStub())->onEcnrMicOutClipStatsRequest(payload);
            return;
        }
        case 18: {

            // method 'ecnrRecvOutClipStats'

            LOG_DEBUG_STUB("process method '%s'", "ecnrRecvOutClipStats");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), EcnrRecvOutClipStatsRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "EcnrRecvOutClipStats", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< EcnrRecvOutClipStatsRequest > payload = ::boost::static_pointer_cast<EcnrRecvOutClipStatsRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ServiceStub*>(getStub())->onEcnrRecvOutClipStatsRequest(payload);
            return;
        }
        case 19: {

            // method 'ecnrSetSendMuteSwitch'

            LOG_DEBUG_STUB("process method '%s'", "ecnrSetSendMuteSwitch");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), EcnrSetSendMuteSwitchRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "EcnrSetSendMuteSwitch", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< EcnrSetSendMuteSwitchRequest > payload = ::boost::static_pointer_cast<EcnrSetSendMuteSwitchRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ServiceStub*>(getStub())->onEcnrSetSendMuteSwitchRequest(payload);
            return;
        }
        case 20: {

            // method 'ecnrSetSendGainDelta'

            LOG_DEBUG_STUB("process method '%s'", "ecnrSetSendGainDelta");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), EcnrSetSendGainDeltaRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "EcnrSetSendGainDelta", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< EcnrSetSendGainDeltaRequest > payload = ::boost::static_pointer_cast<EcnrSetSendGainDeltaRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ServiceStub*>(getStub())->onEcnrSetSendGainDeltaRequest(payload);
            return;
        }
        case 21: {

            // method 'ecnrSetMicGain'

            LOG_DEBUG_STUB("process method '%s'", "ecnrSetMicGain");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), EcnrSetMicGainRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "EcnrSetMicGain", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< EcnrSetMicGainRequest > payload = ::boost::static_pointer_cast<EcnrSetMicGainRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ServiceStub*>(getStub())->onEcnrSetMicGainRequest(payload);
            return;
        }
        case 22: {

            // method 'ecnrSetPassThroughMode'

            LOG_DEBUG_STUB("process method '%s'", "ecnrSetPassThroughMode");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), EcnrSetPassThroughModeRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "EcnrSetPassThroughMode", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< EcnrSetPassThroughModeRequest > payload = ::boost::static_pointer_cast<EcnrSetPassThroughModeRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ServiceStub*>(getStub())->onEcnrSetPassThroughModeRequest(payload);
            return;
        }
        case 23: {

            // method 'ecnrSetNRCombFloor'

            LOG_DEBUG_STUB("process method '%s'", "ecnrSetNRCombFloor");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), EcnrSetNRCombFloorRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "EcnrSetNRCombFloor", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< EcnrSetNRCombFloorRequest > payload = ::boost::static_pointer_cast<EcnrSetNRCombFloorRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ServiceStub*>(getStub())->onEcnrSetNRCombFloorRequest(payload);
            return;
        }
        case 24: {

            // method 'ecnrSetEchoCancellation'

            LOG_DEBUG_STUB("process method '%s'", "ecnrSetEchoCancellation");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), EcnrSetEchoCancellationRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "EcnrSetEchoCancellation", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< EcnrSetEchoCancellationRequest > payload = ::boost::static_pointer_cast<EcnrSetEchoCancellationRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ServiceStub*>(getStub())->onEcnrSetEchoCancellationRequest(payload);
            return;
        }
        case 25: {

            // method 'ecnrSetNoiseReduction'

            LOG_DEBUG_STUB("process method '%s'", "ecnrSetNoiseReduction");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), EcnrSetNoiseReductionRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "EcnrSetNoiseReduction", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< EcnrSetNoiseReductionRequest > payload = ::boost::static_pointer_cast<EcnrSetNoiseReductionRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ServiceStub*>(getStub())->onEcnrSetNoiseReductionRequest(payload);
            return;
        }
        case 26: {

            // method 'ecnrGetEngineParameter'

            LOG_DEBUG_STUB("process method '%s'", "ecnrGetEngineParameter");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), EcnrGetEngineParameterRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "EcnrGetEngineParameter", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< EcnrGetEngineParameterRequest > payload = ::boost::static_pointer_cast<EcnrGetEngineParameterRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ServiceStub*>(getStub())->onEcnrGetEngineParameterRequest(payload);
            return;
        }
        case 27: {

            // method 'ecnrStartItcTest'

            LOG_DEBUG_STUB("process method '%s'", "ecnrStartItcTest");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), EcnrStartItcTestRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "EcnrStartItcTest", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< EcnrStartItcTestRequest > payload = ::boost::static_pointer_cast<EcnrStartItcTestRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ServiceStub*>(getStub())->onEcnrStartItcTestRequest(payload);
            return;
        }
        default:
            break;
        }
    }
    LOG_FATAL_STUB("can't process message %s", message.getMemberName().c_str());
}

const char* ServiceStubDelegate::introspect() const {
    return     "<interface name=\"org.bosch.ecnr.service\">\n"
            "      <method name=\"ecnrGetVersion\">\n"
            "        <arg direction=\"out\" name=\"Version\" type=\"au\"/>\n"
            "        <arg direction=\"out\" name=\"VersionString\" type=\"s\"/>\n"
            "        <arg direction=\"out\" name=\"VersionComment\" type=\"s\"/>\n"
            "      </method>\n"
            "      <method name=\"ecnrGetStatusMessage\">\n"
            "        <arg direction=\"in\" name=\"ecnrAppId\" type=\"y\"/>\n"
            "        <arg direction=\"out\" name=\"StatusMessage\" type=\"s\"/>\n"
            "      </method>\n"
            "      <method name=\"ecnrInitialize\">\n"
            "        <arg direction=\"in\" name=\"ecnrAppId\" type=\"y\"/>\n"
            "        <arg direction=\"in\" name=\"ecnrConfigurationId\" type=\"u\"/>\n"
            "      </method>\n"
            "      <method name=\"ecnrInitializeSync\">\n"
            "        <arg direction=\"in\" name=\"ecnrAppId\" type=\"y\"/>\n"
            "        <arg direction=\"in\" name=\"ecnrConfigurationId\" type=\"u\"/>\n"
            "        <arg direction=\"out\" name=\"InDevices\" type=\"as\"/>\n"
            "        <arg direction=\"out\" name=\"OutDevices\" type=\"as\"/>\n"
            "        <arg direction=\"out\" name=\"DeviceProperties\" type=\"au\"/>\n"
            "      </method>\n"
            "      <method name=\"ecnrReset\">\n"
            "        <arg direction=\"in\" name=\"ecnrAppId\" type=\"y\"/>\n"
            "      </method>\n"
            "      <method name=\"ecnrDestroy\">\n"
            "        <arg direction=\"in\" name=\"ecnrAppId\" type=\"y\"/>\n"
            "      </method>\n"
            "      <method name=\"ecnrTerminate\">\n"
            "        <arg direction=\"in\" name=\"ecnrAppId\" type=\"y\"/>\n"
            "      </method>\n"
            "      <method name=\"ecnrSetConfiguration\">\n"
            "        <arg direction=\"in\" name=\"ecnrAppId\" type=\"y\"/>\n"
            "        <arg direction=\"in\" name=\"ecnrConfigurationId\" type=\"u\"/>\n"
            "      </method>\n"
            "      <method name=\"ecnrSetConfigurationSync\">\n"
            "        <arg direction=\"in\" name=\"ecnrAppId\" type=\"y\"/>\n"
            "        <arg direction=\"in\" name=\"ecnrConfigurationId\" type=\"u\"/>\n"
            "        <arg direction=\"out\" name=\"InDevices\" type=\"as\"/>\n"
            "        <arg direction=\"out\" name=\"OutDevices\" type=\"as\"/>\n"
            "        <arg direction=\"out\" name=\"DeviceProperties\" type=\"au\"/>\n"
            "      </method>\n"
            "      <method name=\"ecnrGetEcnrConfiguration\">\n"
            "        <arg direction=\"out\" name=\"DatasetName\" type=\"s\"/>\n"
            "        <arg direction=\"out\" name=\"EcnrProperties\" type=\"au\"/>\n"
            "      </method>\n"
            "      <method name=\"ecnrStartAudio\">\n"
            "        <arg direction=\"in\" name=\"ecnrAppId\" type=\"y\"/>\n"
            "      </method>\n"
            "      <method name=\"ecnrStartAudioExt\">\n"
            "        <arg direction=\"in\" name=\"ecnrAppId\" type=\"y\"/>\n"
            "        <arg direction=\"in\" name=\"StartMode\" type=\"y\"/>\n"
            "      </method>\n"
            "      <method name=\"ecnrStopAudio\">\n"
            "        <arg direction=\"in\" name=\"ecnrAppId\" type=\"y\"/>\n"
            "      </method>\n"
            "      <method name=\"ecnrFrameInfo\">\n"
            "        <arg direction=\"out\" name=\"FrameCounter\" type=\"u\"/>\n"
            "        <arg direction=\"out\" name=\"VoicePresent\" type=\"i\"/>\n"
            "        <arg direction=\"out\" name=\"AboveBackgroundNoise\" type=\"i\"/>\n"
            "        <arg direction=\"out\" name=\"PercentClipping\" type=\"i\"/>\n"
            "        <arg direction=\"out\" name=\"InstantaneousSNR\" type=\"i\"/>\n"
            "        <arg direction=\"out\" name=\"SmoothVNR\" type=\"i\"/>\n"
            "        <arg direction=\"out\" name=\"ValidOutputCountdown\" type=\"i\"/>\n"
            "      </method>\n"
            "      <method name=\"ecnrMicClipStats\">\n"
            "        <arg direction=\"in\" name=\"Channel\" type=\"i\"/>\n"
            "        <arg direction=\"out\" name=\"ClipFrames\" type=\"u\"/>\n"
            "        <arg direction=\"out\" name=\"ClipCount\" type=\"u\"/>\n"
            "        <arg direction=\"out\" name=\"MaxAmp\" type=\"i\"/>\n"
            "        <arg direction=\"out\" name=\"MinAmp\" type=\"i\"/>\n"
            "      </method>\n"
            "      <method name=\"ecnrRefClipStats\">\n"
            "        <arg direction=\"out\" name=\"ClipFrames\" type=\"u\"/>\n"
            "        <arg direction=\"out\" name=\"ClipCount\" type=\"u\"/>\n"
            "        <arg direction=\"out\" name=\"MaxAmp\" type=\"i\"/>\n"
            "        <arg direction=\"out\" name=\"MinAmp\" type=\"i\"/>\n"
            "      </method>\n"
            "      <method name=\"ecnrRecvClipStats\">\n"
            "        <arg direction=\"out\" name=\"ClipFrames\" type=\"u\"/>\n"
            "        <arg direction=\"out\" name=\"ClipCount\" type=\"u\"/>\n"
            "        <arg direction=\"out\" name=\"MaxAmp\" type=\"i\"/>\n"
            "        <arg direction=\"out\" name=\"MinAmp\" type=\"i\"/>\n"
            "      </method>\n"
            "      <method name=\"ecnrMicOutClipStats\">\n"
            "        <arg direction=\"out\" name=\"ClipFrames\" type=\"u\"/>\n"
            "        <arg direction=\"out\" name=\"ClipCount\" type=\"u\"/>\n"
            "        <arg direction=\"out\" name=\"MaxAmp\" type=\"i\"/>\n"
            "        <arg direction=\"out\" name=\"MinAmp\" type=\"i\"/>\n"
            "      </method>\n"
            "      <method name=\"ecnrRecvOutClipStats\">\n"
            "        <arg direction=\"out\" name=\"ClipFrames\" type=\"u\"/>\n"
            "        <arg direction=\"out\" name=\"ClipCount\" type=\"u\"/>\n"
            "        <arg direction=\"out\" name=\"MaxAmp\" type=\"i\"/>\n"
            "        <arg direction=\"out\" name=\"MinAmp\" type=\"i\"/>\n"
            "      </method>\n"
            "      <method name=\"ecnrSetSendMuteSwitch\">\n"
            "        <arg direction=\"in\" name=\"ecnrAppId\" type=\"y\"/>\n"
            "        <arg direction=\"in\" name=\"ecnrSendMuteSwitch\" type=\"y\"/>\n"
            "      </method>\n"
            "      <method name=\"ecnrSetSendGainDelta\">\n"
            "        <arg direction=\"in\" name=\"ecnrAppId\" type=\"y\"/>\n"
            "        <arg direction=\"in\" name=\"ecnrLevel\" type=\"n\"/>\n"
            "      </method>\n"
            "      <method name=\"ecnrSetMicGain\">\n"
            "        <arg direction=\"in\" name=\"MicGainLevel\" type=\"i\"/>\n"
            "      </method>\n"
            "      <method name=\"ecnrSetPassThroughMode\">\n"
            "        <arg direction=\"in\" name=\"ecnrAppId\" type=\"y\"/>\n"
            "        <arg direction=\"in\" name=\"ecnrPassThroughMode\" type=\"y\"/>\n"
            "      </method>\n"
            "      <method name=\"ecnrSetNRCombFloor\">\n"
            "        <arg direction=\"in\" name=\"ecnrAppId\" type=\"y\"/>\n"
            "        <arg direction=\"in\" name=\"ecnrNRCombFloor\" type=\"n\"/>\n"
            "      </method>\n"
            "      <method name=\"ecnrSetEchoCancellation\">\n"
            "        <arg direction=\"in\" name=\"ecnrAppId\" type=\"y\"/>\n"
            "        <arg direction=\"in\" name=\"EcnrECState\" type=\"y\"/>\n"
            "      </method>\n"
            "      <method name=\"ecnrSetNoiseReduction\">\n"
            "        <arg direction=\"in\" name=\"ecnrAppId\" type=\"y\"/>\n"
            "        <arg direction=\"in\" name=\"EcnrNRState\" type=\"y\"/>\n"
            "      </method>\n"
            "      <method name=\"ecnrGetEngineParameter\">\n"
            "        <arg direction=\"in\" name=\"ecnrParameterId\" type=\"u\"/>\n"
            "        <arg direction=\"out\" name=\"data\" type=\"ay\"/>\n"
            "      </method>\n"
            "      <method name=\"ecnrStartItcTest\">\n"
            "        <arg direction=\"in\" name=\"ITCValue\" type=\"i\"/>\n"
            "        <arg direction=\"out\" name=\"rspITCValue\" type=\"i\"/>\n"
            "        <arg direction=\"out\" name=\"TestResult\" type=\"y\"/>\n"
            "        <arg direction=\"out\" name=\"TestErrorCode\" type=\"i\"/>\n"
            "      </method>\n"
            "      <signal name=\"ecnrAsrModeEnable\">\n"
            "        <arg direction=\"out\" name=\"StatusAsrMode\" type=\"i\"/>\n"
            "      </signal>\n"
            "      <signal name=\"ecnrAudioStatus\">\n"
            "        <arg direction=\"out\" name=\"AudioStatus\" type=\"i\"/>\n"
            "      </signal>\n"
            "      <signal name=\"ecnrMicroLevelStatus\">\n"
            "        <arg direction=\"out\" name=\"StatusMicroLevel\" type=\"u\"/>\n"
            "      </signal>\n"
            "      <property access=\"readwrite\" name=\"ecnrMicLvlNtfyInterval\" type=\"u\"/>\n"
            "      <property access=\"read\" name=\"ecnrAsrMode\" type=\"i\"/>\n"
            "      <property access=\"read\" name=\"ecnrAudioState\" type=\"i\"/>\n"
            "      <property access=\"read\" name=\"ecnrAsrDataType\" type=\"ay\"/>\n"
            "</interface>\n";
}

void ServiceStubDelegate::getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) {
    (static_cast<ServiceStub*>(getStub()))->onGetAll (properties);
}

void ServiceStubDelegate::setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act) {
    unsigned int propertyIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (property.c_str(), property.length(), propertiesTable, 4, propertyIndex)) {
        switch (propertyIndex) {
        case 0: {
            LOG_DEBUG_STUB("process property '%s'", "ecnrMicLvlNtfyInterval");
            ::boost::shared_ptr< EcnrMicLvlNtfyIntervalSet > payload(new EcnrMicLvlNtfyIntervalSet());
            payload->setAct(act);
            deserializeDBus(const_cast< ::asf::dbus::DBusVariant& >(value).getReadIterator(), *payload);
            static_cast<ServiceStub*>(getStub())->onEcnrMicLvlNtfyIntervalSet (payload);
            return;
        }
        case 1: {
            LOG_DEBUG_STUB("process property '%s'", "ecnrAsrMode");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 2: {
            LOG_DEBUG_STUB("process property '%s'", "ecnrAudioState");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 3: {
            LOG_DEBUG_STUB("process property '%s'", "ecnrAsrDataType");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        default:
            break;
        }
    }
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendSetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

void ServiceStubDelegate::getProperty(const ::std::string& property, const act_t& act) {
    unsigned int propertyIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (property.c_str(), property.length(), propertiesTable, 4, propertyIndex)) {
        switch (propertyIndex) {
        case 0: {
            LOG_DEBUG_STUB("process property '%s'", "ecnrMicLvlNtfyInterval");
            ::boost::shared_ptr< EcnrMicLvlNtfyIntervalGet > payload(new EcnrMicLvlNtfyIntervalGet());
            payload->setAct(act);
            static_cast<ServiceStub*>(getStub())->onEcnrMicLvlNtfyIntervalGet (payload);
            return;
        }
        case 1: {
            LOG_DEBUG_STUB("process property '%s'", "ecnrAsrMode");
            ::boost::shared_ptr< EcnrAsrModeGet > payload(new EcnrAsrModeGet());
            payload->setAct(act);
            static_cast<ServiceStub*>(getStub())->onEcnrAsrModeGet (payload);
            return;
        }
        case 2: {
            LOG_DEBUG_STUB("process property '%s'", "ecnrAudioState");
            ::boost::shared_ptr< EcnrAudioStateGet > payload(new EcnrAudioStateGet());
            payload->setAct(act);
            static_cast<ServiceStub*>(getStub())->onEcnrAudioStateGet (payload);
            return;
        }
        case 3: {
            LOG_DEBUG_STUB("process property '%s'", "ecnrAsrDataType");
            ::boost::shared_ptr< EcnrAsrDataTypeGet > payload(new EcnrAsrDataTypeGet());
            payload->setAct(act);
            static_cast<ServiceStub*>(getStub())->onEcnrAsrDataTypeGet (payload);
            return;
        }
        default:
            break;
        }
    }
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendGetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

ServiceStub::ServiceStub (const std::string& portName) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new ServiceStubDelegate(this, _logger);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

ServiceStub::ServiceStub (const std::string& portName, const std::string& objectPath) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new ServiceStubDelegate(this, _logger, objectPath);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

ServiceStub::~ServiceStub() {
    delete _stubDelegate;
}

void ServiceStub::sendEcnrAsrModeEnableSignal(int32 statusAsrMode) {
    if (_stubDelegate->isConnected()) {
        EcnrAsrModeEnableSignal* payload = new EcnrAsrModeEnableSignal(statusAsrMode);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "ecnrAsrModeEnable", EcnrAsrModeEnableSignal, payload)
        LOG_INFO ("-> send%sSignal", "EcnrAsrModeEnable");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "EcnrAsrModeEnable");
    }
}

void ServiceStub::sendEcnrAudioStatusSignal(int32 audioStatus) {
    if (_stubDelegate->isConnected()) {
        EcnrAudioStatusSignal* payload = new EcnrAudioStatusSignal(audioStatus);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "ecnrAudioStatus", EcnrAudioStatusSignal, payload)
        LOG_INFO ("-> send%sSignal", "EcnrAudioStatus");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "EcnrAudioStatus");
    }
}

void ServiceStub::sendEcnrMicroLevelStatusSignal(uint32 statusMicroLevel) {
    if (_stubDelegate->isConnected()) {
        EcnrMicroLevelStatusSignal* payload = new EcnrMicroLevelStatusSignal(statusMicroLevel);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "ecnrMicroLevelStatus", EcnrMicroLevelStatusSignal, payload)
        LOG_INFO ("-> send%sSignal", "EcnrMicroLevelStatus");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "EcnrMicroLevelStatus");
    }
}

void ServiceStub::sendEcnrMicLvlNtfyIntervalUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        EcnrMicLvlNtfyIntervalUpdate payload(_ecnrMicLvlNtfyIntervalProperty);

        LOG_INFO ("-> send%s", "EcnrMicLvlNtfyIntervalUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("ecnrMicLvlNtfyInterval", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.ecnr.service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "EcnrMicLvlNtfyIntervalUpdate");
    }
}

void ServiceStub::onEcnrMicLvlNtfyIntervalGet(const ::boost::shared_ptr< EcnrMicLvlNtfyIntervalGet >& ecnrMicLvlNtfyInterval) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "EcnrMicLvlNtfyIntervalGet", ecnrMicLvlNtfyInterval->getAct());
    sendEcnrMicLvlNtfyIntervalGetUpdate(_ecnrMicLvlNtfyIntervalProperty.getEcnrMicLvlNtfyInterval(), ecnrMicLvlNtfyInterval->getAct());
}

void ServiceStub::sendEcnrMicLvlNtfyIntervalGetUpdate(uint32 ecnrMicLvlNtfyInterval, act_t act) {
    ::asf::dbus::DBusVariant variant;
    EcnrMicLvlNtfyIntervalGet payload(ecnrMicLvlNtfyInterval);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "EcnrMicLvlNtfyIntervalGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ServiceStub::onEcnrMicLvlNtfyIntervalSet(const ::boost::shared_ptr< EcnrMicLvlNtfyIntervalSet >& ecnrMicLvlNtfyInterval) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "EcnrMicLvlNtfyIntervalSet", ecnrMicLvlNtfyInterval->getAct());
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(*ecnrMicLvlNtfyInterval, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }
    setEcnrMicLvlNtfyInterval (ecnrMicLvlNtfyInterval->getEcnrMicLvlNtfyInterval());
    sendEcnrMicLvlNtfyIntervalSetUpdate(ecnrMicLvlNtfyInterval->getAct());
}

void ServiceStub::sendEcnrMicLvlNtfyIntervalSetUpdate(act_t act) {
    LOG_INFO ("-> send%s, act=%" PRIuPTR, "EcnrMicLvlNtfyIntervalSetUpdate", act);
    _stubDelegate->sendSetResponse(act);
}

void ServiceStub::setEcnrMicLvlNtfyInterval(uint32 ecnrMicLvlNtfyInterval) {
    if(ecnrMicLvlNtfyInterval!=_ecnrMicLvlNtfyIntervalProperty.getEcnrMicLvlNtfyInterval()) {
        _ecnrMicLvlNtfyIntervalProperty.setEcnrMicLvlNtfyInterval(ecnrMicLvlNtfyInterval);
        sendEcnrMicLvlNtfyIntervalUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint32 ServiceStub::getEcnrMicLvlNtfyInterval() const {
    return _ecnrMicLvlNtfyIntervalProperty.getEcnrMicLvlNtfyInterval();
}

void ServiceStub::sendEcnrAsrModeUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        EcnrAsrModeUpdate payload(_ecnrAsrModeProperty);

        LOG_INFO ("-> send%s", "EcnrAsrModeUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("ecnrAsrMode", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.ecnr.service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "EcnrAsrModeUpdate");
    }
}

void ServiceStub::onEcnrAsrModeGet(const ::boost::shared_ptr< EcnrAsrModeGet >& ecnrAsrMode) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "EcnrAsrModeGet", ecnrAsrMode->getAct());
    sendEcnrAsrModeGetUpdate(_ecnrAsrModeProperty.getEcnrAsrMode(), ecnrAsrMode->getAct());
}

void ServiceStub::sendEcnrAsrModeGetUpdate(int32 ecnrAsrMode, act_t act) {
    ::asf::dbus::DBusVariant variant;
    EcnrAsrModeGet payload(ecnrAsrMode);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "EcnrAsrModeGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ServiceStub::setEcnrAsrMode(int32 ecnrAsrMode) {
    if(ecnrAsrMode!=_ecnrAsrModeProperty.getEcnrAsrMode()) {
        _ecnrAsrModeProperty.setEcnrAsrMode(ecnrAsrMode);
        sendEcnrAsrModeUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

int32 ServiceStub::getEcnrAsrMode() const {
    return _ecnrAsrModeProperty.getEcnrAsrMode();
}

void ServiceStub::sendEcnrAudioStateUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        EcnrAudioStateUpdate payload(_ecnrAudioStateProperty);

        LOG_INFO ("-> send%s", "EcnrAudioStateUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("ecnrAudioState", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.ecnr.service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "EcnrAudioStateUpdate");
    }
}

void ServiceStub::onEcnrAudioStateGet(const ::boost::shared_ptr< EcnrAudioStateGet >& ecnrAudioState) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "EcnrAudioStateGet", ecnrAudioState->getAct());
    sendEcnrAudioStateGetUpdate(_ecnrAudioStateProperty.getEcnrAudioState(), ecnrAudioState->getAct());
}

void ServiceStub::sendEcnrAudioStateGetUpdate(int32 ecnrAudioState, act_t act) {
    ::asf::dbus::DBusVariant variant;
    EcnrAudioStateGet payload(ecnrAudioState);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "EcnrAudioStateGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ServiceStub::setEcnrAudioState(int32 ecnrAudioState) {
    if(ecnrAudioState!=_ecnrAudioStateProperty.getEcnrAudioState()) {
        _ecnrAudioStateProperty.setEcnrAudioState(ecnrAudioState);
        sendEcnrAudioStateUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

int32 ServiceStub::getEcnrAudioState() const {
    return _ecnrAudioStateProperty.getEcnrAudioState();
}

void ServiceStub::sendEcnrAsrDataTypeUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        EcnrAsrDataTypeUpdate payload(_ecnrAsrDataTypeProperty);

        LOG_INFO ("-> send%s", "EcnrAsrDataTypeUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("ecnrAsrDataType", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.ecnr.service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "EcnrAsrDataTypeUpdate");
    }
}

void ServiceStub::onEcnrAsrDataTypeGet(const ::boost::shared_ptr< EcnrAsrDataTypeGet >& ecnrAsrDataType) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "EcnrAsrDataTypeGet", ecnrAsrDataType->getAct());
    sendEcnrAsrDataTypeGetUpdate(_ecnrAsrDataTypeProperty.getEcnrAsrDataType(), ecnrAsrDataType->getAct());
}

void ServiceStub::sendEcnrAsrDataTypeGetUpdate(const ::std::vector< uint8 >& ecnrAsrDataType, act_t act) {
    ::asf::dbus::DBusVariant variant;
    EcnrAsrDataTypeGet payload(ecnrAsrDataType);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "EcnrAsrDataTypeGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ServiceStub::setEcnrAsrDataType(const ::std::vector< uint8 >& ecnrAsrDataType) {
    if(ecnrAsrDataType!=_ecnrAsrDataTypeProperty.getEcnrAsrDataType()) {
        _ecnrAsrDataTypeProperty.setEcnrAsrDataType(ecnrAsrDataType);
        sendEcnrAsrDataTypeUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::vector< uint8 >& ServiceStub::getEcnrAsrDataType() const {
    return _ecnrAsrDataTypeProperty.getEcnrAsrDataType();
}

::std::vector< uint8 >& ServiceStub::getEcnrAsrDataTypeMutable() {
    return _ecnrAsrDataTypeProperty.getEcnrAsrDataTypeMutable();
}

void  ServiceStub::sendEcnrGetVersionResponse (const ::std::vector< uint32 >& version, const ::std::string& versionString, const ::std::string& versionComment, act_t act) {
    EcnrGetVersionResponse* payload = new EcnrGetVersionResponse(version, versionString, versionComment);
    DBUS_MESSAGE_REPLY(dbusMessage, "ecnrGetVersion", EcnrGetVersionResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "EcnrGetVersion", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ServiceStub::sendEcnrGetVersionError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    EcnrGetVersionError* payload = new EcnrGetVersionError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "ecnrGetVersion", EcnrGetVersionError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "EcnrGetVersion", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ServiceStub::sendEcnrGetStatusMessageResponse (const ::std::string& statusMessage, act_t act) {
    EcnrGetStatusMessageResponse* payload = new EcnrGetStatusMessageResponse(statusMessage);
    DBUS_MESSAGE_REPLY(dbusMessage, "ecnrGetStatusMessage", EcnrGetStatusMessageResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "EcnrGetStatusMessage", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ServiceStub::sendEcnrGetStatusMessageError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    EcnrGetStatusMessageError* payload = new EcnrGetStatusMessageError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "ecnrGetStatusMessage", EcnrGetStatusMessageError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "EcnrGetStatusMessage", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ServiceStub::sendEcnrInitializeResponse (act_t act) {
    EcnrInitializeResponse* payload = new EcnrInitializeResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "ecnrInitialize", EcnrInitializeResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "EcnrInitialize", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ServiceStub::sendEcnrInitializeError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    EcnrInitializeError* payload = new EcnrInitializeError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "ecnrInitialize", EcnrInitializeError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "EcnrInitialize", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ServiceStub::sendEcnrInitializeSyncResponse (const ::std::vector< ::std::string >& inDevices, const ::std::vector< ::std::string >& outDevices, const ::std::vector< uint32 >& deviceProperties, act_t act) {
    EcnrInitializeSyncResponse* payload = new EcnrInitializeSyncResponse(inDevices, outDevices, deviceProperties);
    DBUS_MESSAGE_REPLY(dbusMessage, "ecnrInitializeSync", EcnrInitializeSyncResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "EcnrInitializeSync", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ServiceStub::sendEcnrInitializeSyncError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    EcnrInitializeSyncError* payload = new EcnrInitializeSyncError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "ecnrInitializeSync", EcnrInitializeSyncError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "EcnrInitializeSync", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ServiceStub::sendEcnrResetResponse (act_t act) {
    EcnrResetResponse* payload = new EcnrResetResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "ecnrReset", EcnrResetResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "EcnrReset", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ServiceStub::sendEcnrResetError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    EcnrResetError* payload = new EcnrResetError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "ecnrReset", EcnrResetError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "EcnrReset", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ServiceStub::sendEcnrDestroyResponse (act_t act) {
    EcnrDestroyResponse* payload = new EcnrDestroyResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "ecnrDestroy", EcnrDestroyResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "EcnrDestroy", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ServiceStub::sendEcnrDestroyError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    EcnrDestroyError* payload = new EcnrDestroyError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "ecnrDestroy", EcnrDestroyError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "EcnrDestroy", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ServiceStub::sendEcnrTerminateResponse (act_t act) {
    EcnrTerminateResponse* payload = new EcnrTerminateResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "ecnrTerminate", EcnrTerminateResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "EcnrTerminate", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ServiceStub::sendEcnrTerminateError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    EcnrTerminateError* payload = new EcnrTerminateError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "ecnrTerminate", EcnrTerminateError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "EcnrTerminate", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ServiceStub::sendEcnrSetConfigurationResponse (act_t act) {
    EcnrSetConfigurationResponse* payload = new EcnrSetConfigurationResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "ecnrSetConfiguration", EcnrSetConfigurationResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "EcnrSetConfiguration", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ServiceStub::sendEcnrSetConfigurationError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    EcnrSetConfigurationError* payload = new EcnrSetConfigurationError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "ecnrSetConfiguration", EcnrSetConfigurationError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "EcnrSetConfiguration", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ServiceStub::sendEcnrSetConfigurationSyncResponse (const ::std::vector< ::std::string >& inDevices, const ::std::vector< ::std::string >& outDevices, const ::std::vector< uint32 >& deviceProperties, act_t act) {
    EcnrSetConfigurationSyncResponse* payload = new EcnrSetConfigurationSyncResponse(inDevices, outDevices, deviceProperties);
    DBUS_MESSAGE_REPLY(dbusMessage, "ecnrSetConfigurationSync", EcnrSetConfigurationSyncResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "EcnrSetConfigurationSync", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ServiceStub::sendEcnrSetConfigurationSyncError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    EcnrSetConfigurationSyncError* payload = new EcnrSetConfigurationSyncError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "ecnrSetConfigurationSync", EcnrSetConfigurationSyncError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "EcnrSetConfigurationSync", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ServiceStub::sendEcnrGetEcnrConfigurationResponse (const ::std::string& datasetName, const ::std::vector< uint32 >& ecnrProperties, act_t act) {
    EcnrGetEcnrConfigurationResponse* payload = new EcnrGetEcnrConfigurationResponse(datasetName, ecnrProperties);
    DBUS_MESSAGE_REPLY(dbusMessage, "ecnrGetEcnrConfiguration", EcnrGetEcnrConfigurationResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "EcnrGetEcnrConfiguration", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ServiceStub::sendEcnrGetEcnrConfigurationError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    EcnrGetEcnrConfigurationError* payload = new EcnrGetEcnrConfigurationError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "ecnrGetEcnrConfiguration", EcnrGetEcnrConfigurationError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "EcnrGetEcnrConfiguration", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ServiceStub::sendEcnrStartAudioResponse (act_t act) {
    EcnrStartAudioResponse* payload = new EcnrStartAudioResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "ecnrStartAudio", EcnrStartAudioResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "EcnrStartAudio", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ServiceStub::sendEcnrStartAudioError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    EcnrStartAudioError* payload = new EcnrStartAudioError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "ecnrStartAudio", EcnrStartAudioError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "EcnrStartAudio", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ServiceStub::sendEcnrStartAudioExtResponse (act_t act) {
    EcnrStartAudioExtResponse* payload = new EcnrStartAudioExtResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "ecnrStartAudioExt", EcnrStartAudioExtResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "EcnrStartAudioExt", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ServiceStub::sendEcnrStartAudioExtError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    EcnrStartAudioExtError* payload = new EcnrStartAudioExtError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "ecnrStartAudioExt", EcnrStartAudioExtError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "EcnrStartAudioExt", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ServiceStub::sendEcnrStopAudioResponse (act_t act) {
    EcnrStopAudioResponse* payload = new EcnrStopAudioResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "ecnrStopAudio", EcnrStopAudioResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "EcnrStopAudio", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ServiceStub::sendEcnrStopAudioError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    EcnrStopAudioError* payload = new EcnrStopAudioError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "ecnrStopAudio", EcnrStopAudioError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "EcnrStopAudio", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ServiceStub::sendEcnrFrameInfoResponse (uint32 frameCounter, int32 voicePresent, int32 aboveBackgroundNoise, int32 percentClipping, int32 instantaneousSNR, int32 smoothVNR, int32 validOutputCountdown, act_t act) {
    EcnrFrameInfoResponse* payload = new EcnrFrameInfoResponse(frameCounter, voicePresent, aboveBackgroundNoise, percentClipping, instantaneousSNR, smoothVNR, validOutputCountdown);
    DBUS_MESSAGE_REPLY(dbusMessage, "ecnrFrameInfo", EcnrFrameInfoResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "EcnrFrameInfo", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ServiceStub::sendEcnrFrameInfoError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    EcnrFrameInfoError* payload = new EcnrFrameInfoError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "ecnrFrameInfo", EcnrFrameInfoError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "EcnrFrameInfo", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ServiceStub::sendEcnrMicClipStatsResponse (uint32 clipFrames, uint32 clipCount, int32 maxAmp, int32 minAmp, act_t act) {
    EcnrMicClipStatsResponse* payload = new EcnrMicClipStatsResponse(clipFrames, clipCount, maxAmp, minAmp);
    DBUS_MESSAGE_REPLY(dbusMessage, "ecnrMicClipStats", EcnrMicClipStatsResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "EcnrMicClipStats", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ServiceStub::sendEcnrMicClipStatsError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    EcnrMicClipStatsError* payload = new EcnrMicClipStatsError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "ecnrMicClipStats", EcnrMicClipStatsError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "EcnrMicClipStats", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ServiceStub::sendEcnrRefClipStatsResponse (uint32 clipFrames, uint32 clipCount, int32 maxAmp, int32 minAmp, act_t act) {
    EcnrRefClipStatsResponse* payload = new EcnrRefClipStatsResponse(clipFrames, clipCount, maxAmp, minAmp);
    DBUS_MESSAGE_REPLY(dbusMessage, "ecnrRefClipStats", EcnrRefClipStatsResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "EcnrRefClipStats", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ServiceStub::sendEcnrRefClipStatsError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    EcnrRefClipStatsError* payload = new EcnrRefClipStatsError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "ecnrRefClipStats", EcnrRefClipStatsError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "EcnrRefClipStats", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ServiceStub::sendEcnrRecvClipStatsResponse (uint32 clipFrames, uint32 clipCount, int32 maxAmp, int32 minAmp, act_t act) {
    EcnrRecvClipStatsResponse* payload = new EcnrRecvClipStatsResponse(clipFrames, clipCount, maxAmp, minAmp);
    DBUS_MESSAGE_REPLY(dbusMessage, "ecnrRecvClipStats", EcnrRecvClipStatsResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "EcnrRecvClipStats", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ServiceStub::sendEcnrRecvClipStatsError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    EcnrRecvClipStatsError* payload = new EcnrRecvClipStatsError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "ecnrRecvClipStats", EcnrRecvClipStatsError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "EcnrRecvClipStats", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ServiceStub::sendEcnrMicOutClipStatsResponse (uint32 clipFrames, uint32 clipCount, int32 maxAmp, int32 minAmp, act_t act) {
    EcnrMicOutClipStatsResponse* payload = new EcnrMicOutClipStatsResponse(clipFrames, clipCount, maxAmp, minAmp);
    DBUS_MESSAGE_REPLY(dbusMessage, "ecnrMicOutClipStats", EcnrMicOutClipStatsResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "EcnrMicOutClipStats", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ServiceStub::sendEcnrMicOutClipStatsError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    EcnrMicOutClipStatsError* payload = new EcnrMicOutClipStatsError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "ecnrMicOutClipStats", EcnrMicOutClipStatsError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "EcnrMicOutClipStats", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ServiceStub::sendEcnrRecvOutClipStatsResponse (uint32 clipFrames, uint32 clipCount, int32 maxAmp, int32 minAmp, act_t act) {
    EcnrRecvOutClipStatsResponse* payload = new EcnrRecvOutClipStatsResponse(clipFrames, clipCount, maxAmp, minAmp);
    DBUS_MESSAGE_REPLY(dbusMessage, "ecnrRecvOutClipStats", EcnrRecvOutClipStatsResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "EcnrRecvOutClipStats", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ServiceStub::sendEcnrRecvOutClipStatsError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    EcnrRecvOutClipStatsError* payload = new EcnrRecvOutClipStatsError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "ecnrRecvOutClipStats", EcnrRecvOutClipStatsError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "EcnrRecvOutClipStats", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ServiceStub::sendEcnrSetSendMuteSwitchResponse (act_t act) {
    EcnrSetSendMuteSwitchResponse* payload = new EcnrSetSendMuteSwitchResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "ecnrSetSendMuteSwitch", EcnrSetSendMuteSwitchResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "EcnrSetSendMuteSwitch", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ServiceStub::sendEcnrSetSendMuteSwitchError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    EcnrSetSendMuteSwitchError* payload = new EcnrSetSendMuteSwitchError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "ecnrSetSendMuteSwitch", EcnrSetSendMuteSwitchError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "EcnrSetSendMuteSwitch", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ServiceStub::sendEcnrSetSendGainDeltaResponse (act_t act) {
    EcnrSetSendGainDeltaResponse* payload = new EcnrSetSendGainDeltaResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "ecnrSetSendGainDelta", EcnrSetSendGainDeltaResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "EcnrSetSendGainDelta", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ServiceStub::sendEcnrSetSendGainDeltaError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    EcnrSetSendGainDeltaError* payload = new EcnrSetSendGainDeltaError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "ecnrSetSendGainDelta", EcnrSetSendGainDeltaError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "EcnrSetSendGainDelta", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ServiceStub::sendEcnrSetMicGainResponse (act_t act) {
    EcnrSetMicGainResponse* payload = new EcnrSetMicGainResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "ecnrSetMicGain", EcnrSetMicGainResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "EcnrSetMicGain", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ServiceStub::sendEcnrSetMicGainError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    EcnrSetMicGainError* payload = new EcnrSetMicGainError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "ecnrSetMicGain", EcnrSetMicGainError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "EcnrSetMicGain", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ServiceStub::sendEcnrSetPassThroughModeResponse (act_t act) {
    EcnrSetPassThroughModeResponse* payload = new EcnrSetPassThroughModeResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "ecnrSetPassThroughMode", EcnrSetPassThroughModeResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "EcnrSetPassThroughMode", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ServiceStub::sendEcnrSetPassThroughModeError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    EcnrSetPassThroughModeError* payload = new EcnrSetPassThroughModeError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "ecnrSetPassThroughMode", EcnrSetPassThroughModeError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "EcnrSetPassThroughMode", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ServiceStub::sendEcnrSetNRCombFloorResponse (act_t act) {
    EcnrSetNRCombFloorResponse* payload = new EcnrSetNRCombFloorResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "ecnrSetNRCombFloor", EcnrSetNRCombFloorResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "EcnrSetNRCombFloor", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ServiceStub::sendEcnrSetNRCombFloorError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    EcnrSetNRCombFloorError* payload = new EcnrSetNRCombFloorError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "ecnrSetNRCombFloor", EcnrSetNRCombFloorError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "EcnrSetNRCombFloor", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ServiceStub::sendEcnrSetEchoCancellationResponse (act_t act) {
    EcnrSetEchoCancellationResponse* payload = new EcnrSetEchoCancellationResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "ecnrSetEchoCancellation", EcnrSetEchoCancellationResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "EcnrSetEchoCancellation", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ServiceStub::sendEcnrSetEchoCancellationError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    EcnrSetEchoCancellationError* payload = new EcnrSetEchoCancellationError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "ecnrSetEchoCancellation", EcnrSetEchoCancellationError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "EcnrSetEchoCancellation", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ServiceStub::sendEcnrSetNoiseReductionResponse (act_t act) {
    EcnrSetNoiseReductionResponse* payload = new EcnrSetNoiseReductionResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "ecnrSetNoiseReduction", EcnrSetNoiseReductionResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "EcnrSetNoiseReduction", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ServiceStub::sendEcnrSetNoiseReductionError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    EcnrSetNoiseReductionError* payload = new EcnrSetNoiseReductionError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "ecnrSetNoiseReduction", EcnrSetNoiseReductionError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "EcnrSetNoiseReduction", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ServiceStub::sendEcnrGetEngineParameterResponse (const ::std::vector< uint8 >& data, act_t act) {
    EcnrGetEngineParameterResponse* payload = new EcnrGetEngineParameterResponse(data);
    DBUS_MESSAGE_REPLY(dbusMessage, "ecnrGetEngineParameter", EcnrGetEngineParameterResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "EcnrGetEngineParameter", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ServiceStub::sendEcnrGetEngineParameterError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    EcnrGetEngineParameterError* payload = new EcnrGetEngineParameterError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "ecnrGetEngineParameter", EcnrGetEngineParameterError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "EcnrGetEngineParameter", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ServiceStub::sendEcnrStartItcTestResponse (int32 rspITCValue, uint8 testResult, int32 testErrorCode, act_t act) {
    EcnrStartItcTestResponse* payload = new EcnrStartItcTestResponse(rspITCValue, testResult, testErrorCode);
    DBUS_MESSAGE_REPLY(dbusMessage, "ecnrStartItcTest", EcnrStartItcTestResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "EcnrStartItcTest", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ServiceStub::sendEcnrStartItcTestError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    EcnrStartItcTestError* payload = new EcnrStartItcTestError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "ecnrStartItcTest", EcnrStartItcTestError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "EcnrStartItcTest", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void ServiceStub::onGetAll(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) const {

    //property 'ecnrMicLvlNtfyInterval'
    {
        ::asf::dbus::DBusVariant variant;
        EcnrMicLvlNtfyIntervalGet payload(_ecnrMicLvlNtfyIntervalProperty.getEcnrMicLvlNtfyInterval());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("ecnrMicLvlNtfyInterval", variant));
    }

    //property 'ecnrAsrMode'
    {
        ::asf::dbus::DBusVariant variant;
        EcnrAsrModeGet payload(_ecnrAsrModeProperty.getEcnrAsrMode());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("ecnrAsrMode", variant));
    }

    //property 'ecnrAudioState'
    {
        ::asf::dbus::DBusVariant variant;
        EcnrAudioStateGet payload(_ecnrAudioStateProperty.getEcnrAudioState());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("ecnrAudioState", variant));
    }

    //property 'ecnrAsrDataType'
    {
        ::asf::dbus::DBusVariant variant;
        EcnrAsrDataTypeGet payload(_ecnrAsrDataTypeProperty.getEcnrAsrDataType());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("ecnrAsrDataType", variant));
    }
}

} // namespace service
} // namespace ecnr
} // namespace bosch
} // namespace org
