#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef ORG_BOSCH_ECNR_SERVICE_H
#define ORG_BOSCH_ECNR_SERVICE_H

#include "asf/core/Logger.h"
#include "asf/core/Payload.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "asf/core/VersionCheck.h"
#include "asf/dbus/DBusTypes.h"
#include <cstddef>
#include <cstring>
#include <string>
#include <vector>

/**
 * If the meaning of "service" isn't clear, then there should be a description here.
 */

namespace org {
namespace bosch {
namespace ecnr {
namespace service {

// method IDs
static const uint16 ID_ecnrGetVersion = 0;
static const uint16 ID_ecnrGetStatusMessage = 1;
static const uint16 ID_ecnrInitialize = 2;
static const uint16 ID_ecnrInitializeSync = 3;
static const uint16 ID_ecnrReset = 4;
static const uint16 ID_ecnrDestroy = 5;
static const uint16 ID_ecnrTerminate = 6;
static const uint16 ID_ecnrSetConfiguration = 7;
static const uint16 ID_ecnrSetConfigurationSync = 8;
static const uint16 ID_ecnrGetEcnrConfiguration = 9;
static const uint16 ID_ecnrStartAudio = 10;
static const uint16 ID_ecnrStartAudioExt = 11;
static const uint16 ID_ecnrStopAudio = 12;
static const uint16 ID_ecnrFrameInfo = 13;
static const uint16 ID_ecnrMicClipStats = 14;
static const uint16 ID_ecnrRefClipStats = 15;
static const uint16 ID_ecnrRecvClipStats = 16;
static const uint16 ID_ecnrMicOutClipStats = 17;
static const uint16 ID_ecnrRecvOutClipStats = 18;
static const uint16 ID_ecnrSetSendMuteSwitch = 19;
static const uint16 ID_ecnrSetSendGainDelta = 20;
static const uint16 ID_ecnrSetMicGain = 21;
static const uint16 ID_ecnrSetPassThroughMode = 22;
static const uint16 ID_ecnrSetNRCombFloor = 23;
static const uint16 ID_ecnrSetEchoCancellation = 24;
static const uint16 ID_ecnrSetNoiseReduction = 25;
static const uint16 ID_ecnrGetEngineParameter = 26;
static const uint16 ID_ecnrStartItcTest = 27;

// signal IDs
static const uint16 ID_ecnrAsrModeEnable = 28;
static const uint16 ID_ecnrAudioStatus = 29;
static const uint16 ID_ecnrMicroLevelStatus = 30;

// property IDs
static const uint16 ID_ecnrMicLvlNtfyInterval = 31;
static const uint16 ID_ecnrAsrMode = 32;
static const uint16 ID_ecnrAudioState = 33;
static const uint16 ID_ecnrAsrDataType = 34;

ASF_GENERATOR_VERSION_CHECK_DECLARE

// forward declarations
class EcnrGetVersionResponse;

class EcnrGetStatusMessageRequest;

class EcnrGetStatusMessageResponse;

class EcnrInitializeRequest;

class EcnrInitializeSyncRequest;

class EcnrInitializeSyncResponse;

class EcnrResetRequest;

class EcnrDestroyRequest;

class EcnrTerminateRequest;

class EcnrSetConfigurationRequest;

class EcnrSetConfigurationSyncRequest;

class EcnrSetConfigurationSyncResponse;

class EcnrGetEcnrConfigurationResponse;

class EcnrStartAudioRequest;

class EcnrStartAudioExtRequest;

class EcnrStopAudioRequest;

class EcnrFrameInfoResponse;

class EcnrMicClipStatsRequest;

class EcnrMicClipStatsResponse;

class EcnrRefClipStatsResponse;

class EcnrRecvClipStatsResponse;

class EcnrMicOutClipStatsResponse;

class EcnrRecvOutClipStatsResponse;

class EcnrSetSendMuteSwitchRequest;

class EcnrSetSendGainDeltaRequest;

class EcnrSetMicGainRequest;

class EcnrSetPassThroughModeRequest;

class EcnrSetNRCombFloorRequest;

class EcnrSetEchoCancellationRequest;

class EcnrSetNoiseReductionRequest;

class EcnrGetEngineParameterRequest;

class EcnrGetEngineParameterResponse;

class EcnrStartItcTestRequest;

class EcnrStartItcTestResponse;

class EcnrMicLvlNtfyIntervalUpdate;

class EcnrMicLvlNtfyIntervalRegister;

class EcnrAsrModeUpdate;

class EcnrAsrModeRegister;

class EcnrAudioStateUpdate;

class EcnrAudioStateRegister;

class EcnrAsrDataTypeUpdate;

class EcnrAsrDataTypeRegister;

class EcnrAsrModeEnableSignal;

class EcnrAudioStatusSignal;

class EcnrMicroLevelStatusSignal;

// type definitions
/**
 * If the meaning of "EcnrGetVersionRequest" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage EcnrGetVersionRequest;

/**
 * If the meaning of "EcnrGetVersionError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError EcnrGetVersionError;

/**
 * If the meaning of "EcnrGetStatusMessageError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError EcnrGetStatusMessageError;

/**
 * If the meaning of "EcnrInitializeResponse" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage EcnrInitializeResponse;

/**
 * If the meaning of "EcnrInitializeError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError EcnrInitializeError;

/**
 * If the meaning of "EcnrInitializeSyncError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError EcnrInitializeSyncError;

/**
 * If the meaning of "EcnrResetResponse" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage EcnrResetResponse;

/**
 * If the meaning of "EcnrResetError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError EcnrResetError;

/**
 * If the meaning of "EcnrDestroyResponse" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage EcnrDestroyResponse;

/**
 * If the meaning of "EcnrDestroyError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError EcnrDestroyError;

/**
 * If the meaning of "EcnrTerminateResponse" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage EcnrTerminateResponse;

/**
 * If the meaning of "EcnrTerminateError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError EcnrTerminateError;

/**
 * If the meaning of "EcnrSetConfigurationResponse" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage EcnrSetConfigurationResponse;

/**
 * If the meaning of "EcnrSetConfigurationError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError EcnrSetConfigurationError;

/**
 * If the meaning of "EcnrSetConfigurationSyncError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError EcnrSetConfigurationSyncError;

/**
 * If the meaning of "EcnrGetEcnrConfigurationRequest" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage EcnrGetEcnrConfigurationRequest;

/**
 * If the meaning of "EcnrGetEcnrConfigurationError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError EcnrGetEcnrConfigurationError;

/**
 * If the meaning of "EcnrStartAudioResponse" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage EcnrStartAudioResponse;

/**
 * If the meaning of "EcnrStartAudioError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError EcnrStartAudioError;

/**
 * If the meaning of "EcnrStartAudioExtResponse" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage EcnrStartAudioExtResponse;

/**
 * If the meaning of "EcnrStartAudioExtError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError EcnrStartAudioExtError;

/**
 * If the meaning of "EcnrStopAudioResponse" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage EcnrStopAudioResponse;

/**
 * If the meaning of "EcnrStopAudioError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError EcnrStopAudioError;

/**
 * If the meaning of "EcnrFrameInfoRequest" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage EcnrFrameInfoRequest;

/**
 * If the meaning of "EcnrFrameInfoError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError EcnrFrameInfoError;

/**
 * If the meaning of "EcnrMicClipStatsError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError EcnrMicClipStatsError;

/**
 * If the meaning of "EcnrRefClipStatsRequest" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage EcnrRefClipStatsRequest;

/**
 * If the meaning of "EcnrRefClipStatsError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError EcnrRefClipStatsError;

/**
 * If the meaning of "EcnrRecvClipStatsRequest" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage EcnrRecvClipStatsRequest;

/**
 * If the meaning of "EcnrRecvClipStatsError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError EcnrRecvClipStatsError;

/**
 * If the meaning of "EcnrMicOutClipStatsRequest" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage EcnrMicOutClipStatsRequest;

/**
 * If the meaning of "EcnrMicOutClipStatsError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError EcnrMicOutClipStatsError;

/**
 * If the meaning of "EcnrRecvOutClipStatsRequest" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage EcnrRecvOutClipStatsRequest;

/**
 * If the meaning of "EcnrRecvOutClipStatsError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError EcnrRecvOutClipStatsError;

/**
 * If the meaning of "EcnrSetSendMuteSwitchResponse" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage EcnrSetSendMuteSwitchResponse;

/**
 * If the meaning of "EcnrSetSendMuteSwitchError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError EcnrSetSendMuteSwitchError;

/**
 * If the meaning of "EcnrSetSendGainDeltaResponse" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage EcnrSetSendGainDeltaResponse;

/**
 * If the meaning of "EcnrSetSendGainDeltaError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError EcnrSetSendGainDeltaError;

/**
 * If the meaning of "EcnrSetMicGainResponse" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage EcnrSetMicGainResponse;

/**
 * If the meaning of "EcnrSetMicGainError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError EcnrSetMicGainError;

/**
 * If the meaning of "EcnrSetPassThroughModeResponse" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage EcnrSetPassThroughModeResponse;

/**
 * If the meaning of "EcnrSetPassThroughModeError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError EcnrSetPassThroughModeError;

/**
 * If the meaning of "EcnrSetNRCombFloorResponse" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage EcnrSetNRCombFloorResponse;

/**
 * If the meaning of "EcnrSetNRCombFloorError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError EcnrSetNRCombFloorError;

/**
 * If the meaning of "EcnrSetEchoCancellationResponse" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage EcnrSetEchoCancellationResponse;

/**
 * If the meaning of "EcnrSetEchoCancellationError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError EcnrSetEchoCancellationError;

/**
 * If the meaning of "EcnrSetNoiseReductionResponse" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage EcnrSetNoiseReductionResponse;

/**
 * If the meaning of "EcnrSetNoiseReductionError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError EcnrSetNoiseReductionError;

/**
 * If the meaning of "EcnrGetEngineParameterError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError EcnrGetEngineParameterError;

/**
 * If the meaning of "EcnrStartItcTestError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError EcnrStartItcTestError;

/**
 * If the meaning of "EcnrMicLvlNtfyIntervalSet" isn't clear, then there should be a description here.
 */
typedef EcnrMicLvlNtfyIntervalUpdate EcnrMicLvlNtfyIntervalSet;

/**
 * If the meaning of "EcnrMicLvlNtfyIntervalGet" isn't clear, then there should be a description here.
 */
typedef EcnrMicLvlNtfyIntervalUpdate EcnrMicLvlNtfyIntervalGet;

/**
 * If the meaning of "EcnrMicLvlNtfyIntervalError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError EcnrMicLvlNtfyIntervalError;

/**
 * If the meaning of "EcnrAsrModeSet" isn't clear, then there should be a description here.
 */
typedef EcnrAsrModeUpdate EcnrAsrModeSet;

/**
 * If the meaning of "EcnrAsrModeGet" isn't clear, then there should be a description here.
 */
typedef EcnrAsrModeUpdate EcnrAsrModeGet;

/**
 * If the meaning of "EcnrAsrModeError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError EcnrAsrModeError;

/**
 * If the meaning of "EcnrAudioStateSet" isn't clear, then there should be a description here.
 */
typedef EcnrAudioStateUpdate EcnrAudioStateSet;

/**
 * If the meaning of "EcnrAudioStateGet" isn't clear, then there should be a description here.
 */
typedef EcnrAudioStateUpdate EcnrAudioStateGet;

/**
 * If the meaning of "EcnrAudioStateError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError EcnrAudioStateError;

/**
 * If the meaning of "EcnrAsrDataTypeSet" isn't clear, then there should be a description here.
 */
typedef EcnrAsrDataTypeUpdate EcnrAsrDataTypeSet;

/**
 * If the meaning of "EcnrAsrDataTypeGet" isn't clear, then there should be a description here.
 */
typedef EcnrAsrDataTypeUpdate EcnrAsrDataTypeGet;

/**
 * If the meaning of "EcnrAsrDataTypeError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError EcnrAsrDataTypeError;

/**
 * If the meaning of "EcnrAsrModeEnableError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError EcnrAsrModeEnableError;

/**
 * If the meaning of "EcnrAudioStatusError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError EcnrAudioStatusError;

/**
 * If the meaning of "EcnrMicroLevelStatusError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError EcnrMicroLevelStatusError;


/**
 * If the meaning of "EcnrGetVersionResponse" isn't clear, then there should be a description here.
 */
class EcnrGetVersionResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  EcnrGetVersionResponse ();

    /**
     * Copy constructor
     */
    inline  EcnrGetVersionResponse (const EcnrGetVersionResponse &rhs);

    /**
     * All fields constructor
     */
    inline  EcnrGetVersionResponse (const ::std::vector< uint32 >& Version_, const ::std::string& VersionString_, const ::std::string& VersionComment_);

    /**
     * Destructor
     */
    inline virtual  ~EcnrGetVersionResponse();

    /**
     * Assignment operator
     */
    inline EcnrGetVersionResponse& operator = (const EcnrGetVersionResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const EcnrGetVersionResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const EcnrGetVersionResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const EcnrGetVersionResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const EcnrGetVersionResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Version"

    static const int kVersion = 0;

    /**
     * Clears the field "Version".
     *
     * The field will be set to its default value. The hasVersion()
     * method will return false.
     */
    inline void clearVersion();

    /**
     * Checks whether the field "Version" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setVersion()). Otherwise it will return false.
     */
    inline bool hasVersion () const;

    /**
     * Returns the value of the member "Version".
     *
     * If the meaning of "Version" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Version"
     */
    inline const ::std::vector< uint32 >& getVersion () const;

    /**
     * Retrieves the value of the field "Version" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Version".
     */
    inline ::std::vector< uint32 >& getVersionMutable ();

    /**
     * Sets the value of the member "Version".
     *
     * If the meaning of "Version" isn't clear, then there should be a description here.
     *
     * @param Version The value which will be set
     */
    inline void setVersion (const ::std::vector< uint32 >& Version_);

    // API of field "VersionString"

    static const int kVersionString = 1;

    /**
     * Clears the field "VersionString".
     *
     * The field will be set to its default value. The hasVersionString()
     * method will return false.
     */
    inline void clearVersionString();

    /**
     * Checks whether the field "VersionString" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setVersionString()). Otherwise it will return false.
     */
    inline bool hasVersionString () const;

    /**
     * Returns the value of the member "VersionString".
     *
     * If the meaning of "VersionString" isn't clear, then there should be a description here.
     *
     * @return The value of the field "VersionString"
     */
    inline const ::std::string& getVersionString () const;

    /**
     * Retrieves the value of the field "VersionString" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "VersionString".
     */
    inline ::std::string& getVersionStringMutable ();

    /**
     * Sets the value of the member "VersionString".
     *
     * If the meaning of "VersionString" isn't clear, then there should be a description here.
     *
     * @param VersionString The value which will be set
     */
    inline void setVersionString (const ::std::string& VersionString_);

    /**
     * Sets the value of the member "VersionString".
     *
     * If the meaning of "VersionString" isn't clear, then there should be a description here.
     *
     * @param VersionString The value which will be set
     */
    inline void setVersionString (const char* VersionString_);

    /**
     * Sets the value of the member "VersionString".
     *
     * If the meaning of "VersionString" isn't clear, then there should be a description here.
     *
     * @param VersionString The value which will be set
     */
    inline void setVersionString (const char* value, size_t size);

    // API of field "VersionComment"

    static const int kVersionComment = 2;

    /**
     * Clears the field "VersionComment".
     *
     * The field will be set to its default value. The hasVersionComment()
     * method will return false.
     */
    inline void clearVersionComment();

    /**
     * Checks whether the field "VersionComment" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setVersionComment()). Otherwise it will return false.
     */
    inline bool hasVersionComment () const;

    /**
     * Returns the value of the member "VersionComment".
     *
     * If the meaning of "VersionComment" isn't clear, then there should be a description here.
     *
     * @return The value of the field "VersionComment"
     */
    inline const ::std::string& getVersionComment () const;

    /**
     * Retrieves the value of the field "VersionComment" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "VersionComment".
     */
    inline ::std::string& getVersionCommentMutable ();

    /**
     * Sets the value of the member "VersionComment".
     *
     * If the meaning of "VersionComment" isn't clear, then there should be a description here.
     *
     * @param VersionComment The value which will be set
     */
    inline void setVersionComment (const ::std::string& VersionComment_);

    /**
     * Sets the value of the member "VersionComment".
     *
     * If the meaning of "VersionComment" isn't clear, then there should be a description here.
     *
     * @param VersionComment The value which will be set
     */
    inline void setVersionComment (const char* VersionComment_);

    /**
     * Sets the value of the member "VersionComment".
     *
     * If the meaning of "VersionComment" isn't clear, then there should be a description here.
     *
     * @param VersionComment The value which will be set
     */
    inline void setVersionComment (const char* value, size_t size);

    static const EcnrGetVersionResponse &getDefaultInstance();

private:

    static const ::std::vector< uint32 >& getUint32List_DefaultInstance ();

    inline void set_has_Version ();

    inline void clear_has_Version ();

    inline void set_has_VersionString ();

    inline void clear_has_VersionString ();

    inline void set_has_VersionComment ();

    inline void clear_has_VersionComment ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::std::vector< uint32 > _Version;

    ::std::string _VersionString;

    ::std::string _VersionComment;

};

/**
 * If the meaning of "EcnrGetStatusMessageRequest" isn't clear, then there should be a description here.
 */
class EcnrGetStatusMessageRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  EcnrGetStatusMessageRequest ();

    /**
     * Copy constructor
     */
    inline  EcnrGetStatusMessageRequest (const EcnrGetStatusMessageRequest &rhs);

    /**
     * All fields constructor
     */
    inline  EcnrGetStatusMessageRequest (uint8 ecnrAppId_);

    /**
     * Destructor
     */
    inline virtual  ~EcnrGetStatusMessageRequest();

    /**
     * Assignment operator
     */
    inline EcnrGetStatusMessageRequest& operator = (const EcnrGetStatusMessageRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const EcnrGetStatusMessageRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const EcnrGetStatusMessageRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const EcnrGetStatusMessageRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const EcnrGetStatusMessageRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ecnrAppId"

    static const int kEcnrAppId = 0;

    /**
     * Clears the field "ecnrAppId".
     *
     * The field will be set to its default value. The hasEcnrAppId()
     * method will return false.
     */
    inline void clearEcnrAppId();

    /**
     * Checks whether the field "ecnrAppId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEcnrAppId()). Otherwise it will return false.
     */
    inline bool hasEcnrAppId () const;

    /**
     * Returns the value of the member "ecnrAppId".
     *
     * If the meaning of "ecnrAppId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "ecnrAppId"
     */
    inline uint8 getEcnrAppId () const;

    /**
     * Sets the value of the member "ecnrAppId".
     *
     * If the meaning of "ecnrAppId" isn't clear, then there should be a description here.
     *
     * @param ecnrAppId The value which will be set
     */
    inline void setEcnrAppId (uint8 ecnrAppId_);

    static const EcnrGetStatusMessageRequest &getDefaultInstance();

private:

    inline void set_has_ecnrAppId ();

    inline void clear_has_ecnrAppId ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _ecnrAppId;

};

/**
 * If the meaning of "EcnrGetStatusMessageResponse" isn't clear, then there should be a description here.
 */
class EcnrGetStatusMessageResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  EcnrGetStatusMessageResponse ();

    /**
     * Copy constructor
     */
    inline  EcnrGetStatusMessageResponse (const EcnrGetStatusMessageResponse &rhs);

    /**
     * All fields constructor
     */
    inline  EcnrGetStatusMessageResponse (const ::std::string& StatusMessage_);

    /**
     * Destructor
     */
    inline virtual  ~EcnrGetStatusMessageResponse();

    /**
     * Assignment operator
     */
    inline EcnrGetStatusMessageResponse& operator = (const EcnrGetStatusMessageResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const EcnrGetStatusMessageResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const EcnrGetStatusMessageResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const EcnrGetStatusMessageResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const EcnrGetStatusMessageResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "StatusMessage"

    static const int kStatusMessage = 0;

    /**
     * Clears the field "StatusMessage".
     *
     * The field will be set to its default value. The hasStatusMessage()
     * method will return false.
     */
    inline void clearStatusMessage();

    /**
     * Checks whether the field "StatusMessage" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatusMessage()). Otherwise it will return false.
     */
    inline bool hasStatusMessage () const;

    /**
     * Returns the value of the member "StatusMessage".
     *
     * If the meaning of "StatusMessage" isn't clear, then there should be a description here.
     *
     * @return The value of the field "StatusMessage"
     */
    inline const ::std::string& getStatusMessage () const;

    /**
     * Retrieves the value of the field "StatusMessage" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "StatusMessage".
     */
    inline ::std::string& getStatusMessageMutable ();

    /**
     * Sets the value of the member "StatusMessage".
     *
     * If the meaning of "StatusMessage" isn't clear, then there should be a description here.
     *
     * @param StatusMessage The value which will be set
     */
    inline void setStatusMessage (const ::std::string& StatusMessage_);

    /**
     * Sets the value of the member "StatusMessage".
     *
     * If the meaning of "StatusMessage" isn't clear, then there should be a description here.
     *
     * @param StatusMessage The value which will be set
     */
    inline void setStatusMessage (const char* StatusMessage_);

    /**
     * Sets the value of the member "StatusMessage".
     *
     * If the meaning of "StatusMessage" isn't clear, then there should be a description here.
     *
     * @param StatusMessage The value which will be set
     */
    inline void setStatusMessage (const char* value, size_t size);

    static const EcnrGetStatusMessageResponse &getDefaultInstance();

private:

    inline void set_has_StatusMessage ();

    inline void clear_has_StatusMessage ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _StatusMessage;

};

/**
 * If the meaning of "EcnrInitializeRequest" isn't clear, then there should be a description here.
 */
class EcnrInitializeRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  EcnrInitializeRequest ();

    /**
     * Copy constructor
     */
    inline  EcnrInitializeRequest (const EcnrInitializeRequest &rhs);

    /**
     * All fields constructor
     */
    inline  EcnrInitializeRequest (uint8 ecnrAppId_, uint32 ecnrConfigurationId_);

    /**
     * Destructor
     */
    inline virtual  ~EcnrInitializeRequest();

    /**
     * Assignment operator
     */
    inline EcnrInitializeRequest& operator = (const EcnrInitializeRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const EcnrInitializeRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const EcnrInitializeRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const EcnrInitializeRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const EcnrInitializeRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ecnrAppId"

    static const int kEcnrAppId = 0;

    /**
     * Clears the field "ecnrAppId".
     *
     * The field will be set to its default value. The hasEcnrAppId()
     * method will return false.
     */
    inline void clearEcnrAppId();

    /**
     * Checks whether the field "ecnrAppId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEcnrAppId()). Otherwise it will return false.
     */
    inline bool hasEcnrAppId () const;

    /**
     * Returns the value of the member "ecnrAppId".
     *
     * If the meaning of "ecnrAppId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "ecnrAppId"
     */
    inline uint8 getEcnrAppId () const;

    /**
     * Sets the value of the member "ecnrAppId".
     *
     * If the meaning of "ecnrAppId" isn't clear, then there should be a description here.
     *
     * @param ecnrAppId The value which will be set
     */
    inline void setEcnrAppId (uint8 ecnrAppId_);

    // API of field "ecnrConfigurationId"

    static const int kEcnrConfigurationId = 1;

    /**
     * Clears the field "ecnrConfigurationId".
     *
     * The field will be set to its default value. The hasEcnrConfigurationId()
     * method will return false.
     */
    inline void clearEcnrConfigurationId();

    /**
     * Checks whether the field "ecnrConfigurationId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEcnrConfigurationId()). Otherwise it will return false.
     */
    inline bool hasEcnrConfigurationId () const;

    /**
     * Returns the value of the member "ecnrConfigurationId".
     *
     * If the meaning of "ecnrConfigurationId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "ecnrConfigurationId"
     */
    inline uint32 getEcnrConfigurationId () const;

    /**
     * Sets the value of the member "ecnrConfigurationId".
     *
     * If the meaning of "ecnrConfigurationId" isn't clear, then there should be a description here.
     *
     * @param ecnrConfigurationId The value which will be set
     */
    inline void setEcnrConfigurationId (uint32 ecnrConfigurationId_);

    static const EcnrInitializeRequest &getDefaultInstance();

private:

    inline void set_has_ecnrAppId ();

    inline void clear_has_ecnrAppId ();

    inline void set_has_ecnrConfigurationId ();

    inline void clear_has_ecnrConfigurationId ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint8 _ecnrAppId;

    uint32 _ecnrConfigurationId;

};

/**
 * If the meaning of "EcnrInitializeSyncRequest" isn't clear, then there should be a description here.
 */
class EcnrInitializeSyncRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  EcnrInitializeSyncRequest ();

    /**
     * Copy constructor
     */
    inline  EcnrInitializeSyncRequest (const EcnrInitializeSyncRequest &rhs);

    /**
     * All fields constructor
     */
    inline  EcnrInitializeSyncRequest (uint8 ecnrAppId_, uint32 ecnrConfigurationId_);

    /**
     * Destructor
     */
    inline virtual  ~EcnrInitializeSyncRequest();

    /**
     * Assignment operator
     */
    inline EcnrInitializeSyncRequest& operator = (const EcnrInitializeSyncRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const EcnrInitializeSyncRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const EcnrInitializeSyncRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const EcnrInitializeSyncRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const EcnrInitializeSyncRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ecnrAppId"

    static const int kEcnrAppId = 0;

    /**
     * Clears the field "ecnrAppId".
     *
     * The field will be set to its default value. The hasEcnrAppId()
     * method will return false.
     */
    inline void clearEcnrAppId();

    /**
     * Checks whether the field "ecnrAppId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEcnrAppId()). Otherwise it will return false.
     */
    inline bool hasEcnrAppId () const;

    /**
     * Returns the value of the member "ecnrAppId".
     *
     * If the meaning of "ecnrAppId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "ecnrAppId"
     */
    inline uint8 getEcnrAppId () const;

    /**
     * Sets the value of the member "ecnrAppId".
     *
     * If the meaning of "ecnrAppId" isn't clear, then there should be a description here.
     *
     * @param ecnrAppId The value which will be set
     */
    inline void setEcnrAppId (uint8 ecnrAppId_);

    // API of field "ecnrConfigurationId"

    static const int kEcnrConfigurationId = 1;

    /**
     * Clears the field "ecnrConfigurationId".
     *
     * The field will be set to its default value. The hasEcnrConfigurationId()
     * method will return false.
     */
    inline void clearEcnrConfigurationId();

    /**
     * Checks whether the field "ecnrConfigurationId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEcnrConfigurationId()). Otherwise it will return false.
     */
    inline bool hasEcnrConfigurationId () const;

    /**
     * Returns the value of the member "ecnrConfigurationId".
     *
     * If the meaning of "ecnrConfigurationId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "ecnrConfigurationId"
     */
    inline uint32 getEcnrConfigurationId () const;

    /**
     * Sets the value of the member "ecnrConfigurationId".
     *
     * If the meaning of "ecnrConfigurationId" isn't clear, then there should be a description here.
     *
     * @param ecnrConfigurationId The value which will be set
     */
    inline void setEcnrConfigurationId (uint32 ecnrConfigurationId_);

    static const EcnrInitializeSyncRequest &getDefaultInstance();

private:

    inline void set_has_ecnrAppId ();

    inline void clear_has_ecnrAppId ();

    inline void set_has_ecnrConfigurationId ();

    inline void clear_has_ecnrConfigurationId ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint8 _ecnrAppId;

    uint32 _ecnrConfigurationId;

};

/**
 * If the meaning of "EcnrInitializeSyncResponse" isn't clear, then there should be a description here.
 */
class EcnrInitializeSyncResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  EcnrInitializeSyncResponse ();

    /**
     * Copy constructor
     */
    inline  EcnrInitializeSyncResponse (const EcnrInitializeSyncResponse &rhs);

    /**
     * All fields constructor
     */
    inline  EcnrInitializeSyncResponse (const ::std::vector< ::std::string >& InDevices_, const ::std::vector< ::std::string >& OutDevices_, const ::std::vector< uint32 >& DeviceProperties_);

    /**
     * Destructor
     */
    inline virtual  ~EcnrInitializeSyncResponse();

    /**
     * Assignment operator
     */
    inline EcnrInitializeSyncResponse& operator = (const EcnrInitializeSyncResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const EcnrInitializeSyncResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const EcnrInitializeSyncResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const EcnrInitializeSyncResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const EcnrInitializeSyncResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "InDevices"

    static const int kInDevices = 0;

    /**
     * Clears the field "InDevices".
     *
     * The field will be set to its default value. The hasInDevices()
     * method will return false.
     */
    inline void clearInDevices();

    /**
     * Checks whether the field "InDevices" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setInDevices()). Otherwise it will return false.
     */
    inline bool hasInDevices () const;

    /**
     * Returns the value of the member "InDevices".
     *
     * If the meaning of "InDevices" isn't clear, then there should be a description here.
     *
     * @return The value of the field "InDevices"
     */
    inline const ::std::vector< ::std::string >& getInDevices () const;

    /**
     * Retrieves the value of the field "InDevices" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "InDevices".
     */
    inline ::std::vector< ::std::string >& getInDevicesMutable ();

    /**
     * Sets the value of the member "InDevices".
     *
     * If the meaning of "InDevices" isn't clear, then there should be a description here.
     *
     * @param InDevices The value which will be set
     */
    inline void setInDevices (const ::std::vector< ::std::string >& InDevices_);

    // API of field "OutDevices"

    static const int kOutDevices = 1;

    /**
     * Clears the field "OutDevices".
     *
     * The field will be set to its default value. The hasOutDevices()
     * method will return false.
     */
    inline void clearOutDevices();

    /**
     * Checks whether the field "OutDevices" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOutDevices()). Otherwise it will return false.
     */
    inline bool hasOutDevices () const;

    /**
     * Returns the value of the member "OutDevices".
     *
     * If the meaning of "OutDevices" isn't clear, then there should be a description here.
     *
     * @return The value of the field "OutDevices"
     */
    inline const ::std::vector< ::std::string >& getOutDevices () const;

    /**
     * Retrieves the value of the field "OutDevices" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "OutDevices".
     */
    inline ::std::vector< ::std::string >& getOutDevicesMutable ();

    /**
     * Sets the value of the member "OutDevices".
     *
     * If the meaning of "OutDevices" isn't clear, then there should be a description here.
     *
     * @param OutDevices The value which will be set
     */
    inline void setOutDevices (const ::std::vector< ::std::string >& OutDevices_);

    // API of field "DeviceProperties"

    static const int kDeviceProperties = 2;

    /**
     * Clears the field "DeviceProperties".
     *
     * The field will be set to its default value. The hasDeviceProperties()
     * method will return false.
     */
    inline void clearDeviceProperties();

    /**
     * Checks whether the field "DeviceProperties" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceProperties()). Otherwise it will return false.
     */
    inline bool hasDeviceProperties () const;

    /**
     * Returns the value of the member "DeviceProperties".
     *
     * If the meaning of "DeviceProperties" isn't clear, then there should be a description here.
     *
     * @return The value of the field "DeviceProperties"
     */
    inline const ::std::vector< uint32 >& getDeviceProperties () const;

    /**
     * Retrieves the value of the field "DeviceProperties" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "DeviceProperties".
     */
    inline ::std::vector< uint32 >& getDevicePropertiesMutable ();

    /**
     * Sets the value of the member "DeviceProperties".
     *
     * If the meaning of "DeviceProperties" isn't clear, then there should be a description here.
     *
     * @param DeviceProperties The value which will be set
     */
    inline void setDeviceProperties (const ::std::vector< uint32 >& DeviceProperties_);

    static const EcnrInitializeSyncResponse &getDefaultInstance();

private:

    static const ::std::vector< ::std::string >& getStringList_DefaultInstance ();

    static const ::std::vector< uint32 >& getUint32List_DefaultInstance ();

    inline void set_has_InDevices ();

    inline void clear_has_InDevices ();

    inline void set_has_OutDevices ();

    inline void clear_has_OutDevices ();

    inline void set_has_DeviceProperties ();

    inline void clear_has_DeviceProperties ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::std::vector< ::std::string > _InDevices;

    ::std::vector< ::std::string > _OutDevices;

    ::std::vector< uint32 > _DeviceProperties;

};

/**
 * If the meaning of "EcnrResetRequest" isn't clear, then there should be a description here.
 */
class EcnrResetRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  EcnrResetRequest ();

    /**
     * Copy constructor
     */
    inline  EcnrResetRequest (const EcnrResetRequest &rhs);

    /**
     * All fields constructor
     */
    inline  EcnrResetRequest (uint8 ecnrAppId_);

    /**
     * Destructor
     */
    inline virtual  ~EcnrResetRequest();

    /**
     * Assignment operator
     */
    inline EcnrResetRequest& operator = (const EcnrResetRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const EcnrResetRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const EcnrResetRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const EcnrResetRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const EcnrResetRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ecnrAppId"

    static const int kEcnrAppId = 0;

    /**
     * Clears the field "ecnrAppId".
     *
     * The field will be set to its default value. The hasEcnrAppId()
     * method will return false.
     */
    inline void clearEcnrAppId();

    /**
     * Checks whether the field "ecnrAppId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEcnrAppId()). Otherwise it will return false.
     */
    inline bool hasEcnrAppId () const;

    /**
     * Returns the value of the member "ecnrAppId".
     *
     * If the meaning of "ecnrAppId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "ecnrAppId"
     */
    inline uint8 getEcnrAppId () const;

    /**
     * Sets the value of the member "ecnrAppId".
     *
     * If the meaning of "ecnrAppId" isn't clear, then there should be a description here.
     *
     * @param ecnrAppId The value which will be set
     */
    inline void setEcnrAppId (uint8 ecnrAppId_);

    static const EcnrResetRequest &getDefaultInstance();

private:

    inline void set_has_ecnrAppId ();

    inline void clear_has_ecnrAppId ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _ecnrAppId;

};

/**
 * If the meaning of "EcnrDestroyRequest" isn't clear, then there should be a description here.
 */
class EcnrDestroyRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  EcnrDestroyRequest ();

    /**
     * Copy constructor
     */
    inline  EcnrDestroyRequest (const EcnrDestroyRequest &rhs);

    /**
     * All fields constructor
     */
    inline  EcnrDestroyRequest (uint8 ecnrAppId_);

    /**
     * Destructor
     */
    inline virtual  ~EcnrDestroyRequest();

    /**
     * Assignment operator
     */
    inline EcnrDestroyRequest& operator = (const EcnrDestroyRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const EcnrDestroyRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const EcnrDestroyRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const EcnrDestroyRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const EcnrDestroyRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ecnrAppId"

    static const int kEcnrAppId = 0;

    /**
     * Clears the field "ecnrAppId".
     *
     * The field will be set to its default value. The hasEcnrAppId()
     * method will return false.
     */
    inline void clearEcnrAppId();

    /**
     * Checks whether the field "ecnrAppId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEcnrAppId()). Otherwise it will return false.
     */
    inline bool hasEcnrAppId () const;

    /**
     * Returns the value of the member "ecnrAppId".
     *
     * If the meaning of "ecnrAppId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "ecnrAppId"
     */
    inline uint8 getEcnrAppId () const;

    /**
     * Sets the value of the member "ecnrAppId".
     *
     * If the meaning of "ecnrAppId" isn't clear, then there should be a description here.
     *
     * @param ecnrAppId The value which will be set
     */
    inline void setEcnrAppId (uint8 ecnrAppId_);

    static const EcnrDestroyRequest &getDefaultInstance();

private:

    inline void set_has_ecnrAppId ();

    inline void clear_has_ecnrAppId ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _ecnrAppId;

};

/**
 * If the meaning of "EcnrTerminateRequest" isn't clear, then there should be a description here.
 */
class EcnrTerminateRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  EcnrTerminateRequest ();

    /**
     * Copy constructor
     */
    inline  EcnrTerminateRequest (const EcnrTerminateRequest &rhs);

    /**
     * All fields constructor
     */
    inline  EcnrTerminateRequest (uint8 ecnrAppId_);

    /**
     * Destructor
     */
    inline virtual  ~EcnrTerminateRequest();

    /**
     * Assignment operator
     */
    inline EcnrTerminateRequest& operator = (const EcnrTerminateRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const EcnrTerminateRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const EcnrTerminateRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const EcnrTerminateRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const EcnrTerminateRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ecnrAppId"

    static const int kEcnrAppId = 0;

    /**
     * Clears the field "ecnrAppId".
     *
     * The field will be set to its default value. The hasEcnrAppId()
     * method will return false.
     */
    inline void clearEcnrAppId();

    /**
     * Checks whether the field "ecnrAppId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEcnrAppId()). Otherwise it will return false.
     */
    inline bool hasEcnrAppId () const;

    /**
     * Returns the value of the member "ecnrAppId".
     *
     * If the meaning of "ecnrAppId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "ecnrAppId"
     */
    inline uint8 getEcnrAppId () const;

    /**
     * Sets the value of the member "ecnrAppId".
     *
     * If the meaning of "ecnrAppId" isn't clear, then there should be a description here.
     *
     * @param ecnrAppId The value which will be set
     */
    inline void setEcnrAppId (uint8 ecnrAppId_);

    static const EcnrTerminateRequest &getDefaultInstance();

private:

    inline void set_has_ecnrAppId ();

    inline void clear_has_ecnrAppId ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _ecnrAppId;

};

/**
 * If the meaning of "EcnrSetConfigurationRequest" isn't clear, then there should be a description here.
 */
class EcnrSetConfigurationRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  EcnrSetConfigurationRequest ();

    /**
     * Copy constructor
     */
    inline  EcnrSetConfigurationRequest (const EcnrSetConfigurationRequest &rhs);

    /**
     * All fields constructor
     */
    inline  EcnrSetConfigurationRequest (uint8 ecnrAppId_, uint32 ecnrConfigurationId_);

    /**
     * Destructor
     */
    inline virtual  ~EcnrSetConfigurationRequest();

    /**
     * Assignment operator
     */
    inline EcnrSetConfigurationRequest& operator = (const EcnrSetConfigurationRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const EcnrSetConfigurationRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const EcnrSetConfigurationRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const EcnrSetConfigurationRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const EcnrSetConfigurationRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ecnrAppId"

    static const int kEcnrAppId = 0;

    /**
     * Clears the field "ecnrAppId".
     *
     * The field will be set to its default value. The hasEcnrAppId()
     * method will return false.
     */
    inline void clearEcnrAppId();

    /**
     * Checks whether the field "ecnrAppId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEcnrAppId()). Otherwise it will return false.
     */
    inline bool hasEcnrAppId () const;

    /**
     * Returns the value of the member "ecnrAppId".
     *
     * If the meaning of "ecnrAppId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "ecnrAppId"
     */
    inline uint8 getEcnrAppId () const;

    /**
     * Sets the value of the member "ecnrAppId".
     *
     * If the meaning of "ecnrAppId" isn't clear, then there should be a description here.
     *
     * @param ecnrAppId The value which will be set
     */
    inline void setEcnrAppId (uint8 ecnrAppId_);

    // API of field "ecnrConfigurationId"

    static const int kEcnrConfigurationId = 1;

    /**
     * Clears the field "ecnrConfigurationId".
     *
     * The field will be set to its default value. The hasEcnrConfigurationId()
     * method will return false.
     */
    inline void clearEcnrConfigurationId();

    /**
     * Checks whether the field "ecnrConfigurationId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEcnrConfigurationId()). Otherwise it will return false.
     */
    inline bool hasEcnrConfigurationId () const;

    /**
     * Returns the value of the member "ecnrConfigurationId".
     *
     * If the meaning of "ecnrConfigurationId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "ecnrConfigurationId"
     */
    inline uint32 getEcnrConfigurationId () const;

    /**
     * Sets the value of the member "ecnrConfigurationId".
     *
     * If the meaning of "ecnrConfigurationId" isn't clear, then there should be a description here.
     *
     * @param ecnrConfigurationId The value which will be set
     */
    inline void setEcnrConfigurationId (uint32 ecnrConfigurationId_);

    static const EcnrSetConfigurationRequest &getDefaultInstance();

private:

    inline void set_has_ecnrAppId ();

    inline void clear_has_ecnrAppId ();

    inline void set_has_ecnrConfigurationId ();

    inline void clear_has_ecnrConfigurationId ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint8 _ecnrAppId;

    uint32 _ecnrConfigurationId;

};

/**
 * If the meaning of "EcnrSetConfigurationSyncRequest" isn't clear, then there should be a description here.
 */
class EcnrSetConfigurationSyncRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  EcnrSetConfigurationSyncRequest ();

    /**
     * Copy constructor
     */
    inline  EcnrSetConfigurationSyncRequest (const EcnrSetConfigurationSyncRequest &rhs);

    /**
     * All fields constructor
     */
    inline  EcnrSetConfigurationSyncRequest (uint8 ecnrAppId_, uint32 ecnrConfigurationId_);

    /**
     * Destructor
     */
    inline virtual  ~EcnrSetConfigurationSyncRequest();

    /**
     * Assignment operator
     */
    inline EcnrSetConfigurationSyncRequest& operator = (const EcnrSetConfigurationSyncRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const EcnrSetConfigurationSyncRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const EcnrSetConfigurationSyncRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const EcnrSetConfigurationSyncRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const EcnrSetConfigurationSyncRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ecnrAppId"

    static const int kEcnrAppId = 0;

    /**
     * Clears the field "ecnrAppId".
     *
     * The field will be set to its default value. The hasEcnrAppId()
     * method will return false.
     */
    inline void clearEcnrAppId();

    /**
     * Checks whether the field "ecnrAppId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEcnrAppId()). Otherwise it will return false.
     */
    inline bool hasEcnrAppId () const;

    /**
     * Returns the value of the member "ecnrAppId".
     *
     * If the meaning of "ecnrAppId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "ecnrAppId"
     */
    inline uint8 getEcnrAppId () const;

    /**
     * Sets the value of the member "ecnrAppId".
     *
     * If the meaning of "ecnrAppId" isn't clear, then there should be a description here.
     *
     * @param ecnrAppId The value which will be set
     */
    inline void setEcnrAppId (uint8 ecnrAppId_);

    // API of field "ecnrConfigurationId"

    static const int kEcnrConfigurationId = 1;

    /**
     * Clears the field "ecnrConfigurationId".
     *
     * The field will be set to its default value. The hasEcnrConfigurationId()
     * method will return false.
     */
    inline void clearEcnrConfigurationId();

    /**
     * Checks whether the field "ecnrConfigurationId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEcnrConfigurationId()). Otherwise it will return false.
     */
    inline bool hasEcnrConfigurationId () const;

    /**
     * Returns the value of the member "ecnrConfigurationId".
     *
     * If the meaning of "ecnrConfigurationId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "ecnrConfigurationId"
     */
    inline uint32 getEcnrConfigurationId () const;

    /**
     * Sets the value of the member "ecnrConfigurationId".
     *
     * If the meaning of "ecnrConfigurationId" isn't clear, then there should be a description here.
     *
     * @param ecnrConfigurationId The value which will be set
     */
    inline void setEcnrConfigurationId (uint32 ecnrConfigurationId_);

    static const EcnrSetConfigurationSyncRequest &getDefaultInstance();

private:

    inline void set_has_ecnrAppId ();

    inline void clear_has_ecnrAppId ();

    inline void set_has_ecnrConfigurationId ();

    inline void clear_has_ecnrConfigurationId ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint8 _ecnrAppId;

    uint32 _ecnrConfigurationId;

};

/**
 * If the meaning of "EcnrSetConfigurationSyncResponse" isn't clear, then there should be a description here.
 */
class EcnrSetConfigurationSyncResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  EcnrSetConfigurationSyncResponse ();

    /**
     * Copy constructor
     */
    inline  EcnrSetConfigurationSyncResponse (const EcnrSetConfigurationSyncResponse &rhs);

    /**
     * All fields constructor
     */
    inline  EcnrSetConfigurationSyncResponse (const ::std::vector< ::std::string >& InDevices_, const ::std::vector< ::std::string >& OutDevices_, const ::std::vector< uint32 >& DeviceProperties_);

    /**
     * Destructor
     */
    inline virtual  ~EcnrSetConfigurationSyncResponse();

    /**
     * Assignment operator
     */
    inline EcnrSetConfigurationSyncResponse& operator = (const EcnrSetConfigurationSyncResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const EcnrSetConfigurationSyncResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const EcnrSetConfigurationSyncResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const EcnrSetConfigurationSyncResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const EcnrSetConfigurationSyncResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "InDevices"

    static const int kInDevices = 0;

    /**
     * Clears the field "InDevices".
     *
     * The field will be set to its default value. The hasInDevices()
     * method will return false.
     */
    inline void clearInDevices();

    /**
     * Checks whether the field "InDevices" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setInDevices()). Otherwise it will return false.
     */
    inline bool hasInDevices () const;

    /**
     * Returns the value of the member "InDevices".
     *
     * If the meaning of "InDevices" isn't clear, then there should be a description here.
     *
     * @return The value of the field "InDevices"
     */
    inline const ::std::vector< ::std::string >& getInDevices () const;

    /**
     * Retrieves the value of the field "InDevices" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "InDevices".
     */
    inline ::std::vector< ::std::string >& getInDevicesMutable ();

    /**
     * Sets the value of the member "InDevices".
     *
     * If the meaning of "InDevices" isn't clear, then there should be a description here.
     *
     * @param InDevices The value which will be set
     */
    inline void setInDevices (const ::std::vector< ::std::string >& InDevices_);

    // API of field "OutDevices"

    static const int kOutDevices = 1;

    /**
     * Clears the field "OutDevices".
     *
     * The field will be set to its default value. The hasOutDevices()
     * method will return false.
     */
    inline void clearOutDevices();

    /**
     * Checks whether the field "OutDevices" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOutDevices()). Otherwise it will return false.
     */
    inline bool hasOutDevices () const;

    /**
     * Returns the value of the member "OutDevices".
     *
     * If the meaning of "OutDevices" isn't clear, then there should be a description here.
     *
     * @return The value of the field "OutDevices"
     */
    inline const ::std::vector< ::std::string >& getOutDevices () const;

    /**
     * Retrieves the value of the field "OutDevices" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "OutDevices".
     */
    inline ::std::vector< ::std::string >& getOutDevicesMutable ();

    /**
     * Sets the value of the member "OutDevices".
     *
     * If the meaning of "OutDevices" isn't clear, then there should be a description here.
     *
     * @param OutDevices The value which will be set
     */
    inline void setOutDevices (const ::std::vector< ::std::string >& OutDevices_);

    // API of field "DeviceProperties"

    static const int kDeviceProperties = 2;

    /**
     * Clears the field "DeviceProperties".
     *
     * The field will be set to its default value. The hasDeviceProperties()
     * method will return false.
     */
    inline void clearDeviceProperties();

    /**
     * Checks whether the field "DeviceProperties" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceProperties()). Otherwise it will return false.
     */
    inline bool hasDeviceProperties () const;

    /**
     * Returns the value of the member "DeviceProperties".
     *
     * If the meaning of "DeviceProperties" isn't clear, then there should be a description here.
     *
     * @return The value of the field "DeviceProperties"
     */
    inline const ::std::vector< uint32 >& getDeviceProperties () const;

    /**
     * Retrieves the value of the field "DeviceProperties" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "DeviceProperties".
     */
    inline ::std::vector< uint32 >& getDevicePropertiesMutable ();

    /**
     * Sets the value of the member "DeviceProperties".
     *
     * If the meaning of "DeviceProperties" isn't clear, then there should be a description here.
     *
     * @param DeviceProperties The value which will be set
     */
    inline void setDeviceProperties (const ::std::vector< uint32 >& DeviceProperties_);

    static const EcnrSetConfigurationSyncResponse &getDefaultInstance();

private:

    static const ::std::vector< ::std::string >& getStringList_DefaultInstance ();

    static const ::std::vector< uint32 >& getUint32List_DefaultInstance ();

    inline void set_has_InDevices ();

    inline void clear_has_InDevices ();

    inline void set_has_OutDevices ();

    inline void clear_has_OutDevices ();

    inline void set_has_DeviceProperties ();

    inline void clear_has_DeviceProperties ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::std::vector< ::std::string > _InDevices;

    ::std::vector< ::std::string > _OutDevices;

    ::std::vector< uint32 > _DeviceProperties;

};

/**
 * If the meaning of "EcnrGetEcnrConfigurationResponse" isn't clear, then there should be a description here.
 */
class EcnrGetEcnrConfigurationResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  EcnrGetEcnrConfigurationResponse ();

    /**
     * Copy constructor
     */
    inline  EcnrGetEcnrConfigurationResponse (const EcnrGetEcnrConfigurationResponse &rhs);

    /**
     * All fields constructor
     */
    inline  EcnrGetEcnrConfigurationResponse (const ::std::string& DatasetName_, const ::std::vector< uint32 >& EcnrProperties_);

    /**
     * Destructor
     */
    inline virtual  ~EcnrGetEcnrConfigurationResponse();

    /**
     * Assignment operator
     */
    inline EcnrGetEcnrConfigurationResponse& operator = (const EcnrGetEcnrConfigurationResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const EcnrGetEcnrConfigurationResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const EcnrGetEcnrConfigurationResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const EcnrGetEcnrConfigurationResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const EcnrGetEcnrConfigurationResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DatasetName"

    static const int kDatasetName = 0;

    /**
     * Clears the field "DatasetName".
     *
     * The field will be set to its default value. The hasDatasetName()
     * method will return false.
     */
    inline void clearDatasetName();

    /**
     * Checks whether the field "DatasetName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDatasetName()). Otherwise it will return false.
     */
    inline bool hasDatasetName () const;

    /**
     * Returns the value of the member "DatasetName".
     *
     * If the meaning of "DatasetName" isn't clear, then there should be a description here.
     *
     * @return The value of the field "DatasetName"
     */
    inline const ::std::string& getDatasetName () const;

    /**
     * Retrieves the value of the field "DatasetName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "DatasetName".
     */
    inline ::std::string& getDatasetNameMutable ();

    /**
     * Sets the value of the member "DatasetName".
     *
     * If the meaning of "DatasetName" isn't clear, then there should be a description here.
     *
     * @param DatasetName The value which will be set
     */
    inline void setDatasetName (const ::std::string& DatasetName_);

    /**
     * Sets the value of the member "DatasetName".
     *
     * If the meaning of "DatasetName" isn't clear, then there should be a description here.
     *
     * @param DatasetName The value which will be set
     */
    inline void setDatasetName (const char* DatasetName_);

    /**
     * Sets the value of the member "DatasetName".
     *
     * If the meaning of "DatasetName" isn't clear, then there should be a description here.
     *
     * @param DatasetName The value which will be set
     */
    inline void setDatasetName (const char* value, size_t size);

    // API of field "EcnrProperties"

    static const int kEcnrProperties = 1;

    /**
     * Clears the field "EcnrProperties".
     *
     * The field will be set to its default value. The hasEcnrProperties()
     * method will return false.
     */
    inline void clearEcnrProperties();

    /**
     * Checks whether the field "EcnrProperties" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEcnrProperties()). Otherwise it will return false.
     */
    inline bool hasEcnrProperties () const;

    /**
     * Returns the value of the member "EcnrProperties".
     *
     * If the meaning of "EcnrProperties" isn't clear, then there should be a description here.
     *
     * @return The value of the field "EcnrProperties"
     */
    inline const ::std::vector< uint32 >& getEcnrProperties () const;

    /**
     * Retrieves the value of the field "EcnrProperties" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "EcnrProperties".
     */
    inline ::std::vector< uint32 >& getEcnrPropertiesMutable ();

    /**
     * Sets the value of the member "EcnrProperties".
     *
     * If the meaning of "EcnrProperties" isn't clear, then there should be a description here.
     *
     * @param EcnrProperties The value which will be set
     */
    inline void setEcnrProperties (const ::std::vector< uint32 >& EcnrProperties_);

    static const EcnrGetEcnrConfigurationResponse &getDefaultInstance();

private:

    static const ::std::vector< uint32 >& getUint32List_DefaultInstance ();

    inline void set_has_DatasetName ();

    inline void clear_has_DatasetName ();

    inline void set_has_EcnrProperties ();

    inline void clear_has_EcnrProperties ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _DatasetName;

    ::std::vector< uint32 > _EcnrProperties;

};

/**
 * If the meaning of "EcnrStartAudioRequest" isn't clear, then there should be a description here.
 */
class EcnrStartAudioRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  EcnrStartAudioRequest ();

    /**
     * Copy constructor
     */
    inline  EcnrStartAudioRequest (const EcnrStartAudioRequest &rhs);

    /**
     * All fields constructor
     */
    inline  EcnrStartAudioRequest (uint8 ecnrAppId_);

    /**
     * Destructor
     */
    inline virtual  ~EcnrStartAudioRequest();

    /**
     * Assignment operator
     */
    inline EcnrStartAudioRequest& operator = (const EcnrStartAudioRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const EcnrStartAudioRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const EcnrStartAudioRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const EcnrStartAudioRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const EcnrStartAudioRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ecnrAppId"

    static const int kEcnrAppId = 0;

    /**
     * Clears the field "ecnrAppId".
     *
     * The field will be set to its default value. The hasEcnrAppId()
     * method will return false.
     */
    inline void clearEcnrAppId();

    /**
     * Checks whether the field "ecnrAppId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEcnrAppId()). Otherwise it will return false.
     */
    inline bool hasEcnrAppId () const;

    /**
     * Returns the value of the member "ecnrAppId".
     *
     * If the meaning of "ecnrAppId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "ecnrAppId"
     */
    inline uint8 getEcnrAppId () const;

    /**
     * Sets the value of the member "ecnrAppId".
     *
     * If the meaning of "ecnrAppId" isn't clear, then there should be a description here.
     *
     * @param ecnrAppId The value which will be set
     */
    inline void setEcnrAppId (uint8 ecnrAppId_);

    static const EcnrStartAudioRequest &getDefaultInstance();

private:

    inline void set_has_ecnrAppId ();

    inline void clear_has_ecnrAppId ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _ecnrAppId;

};

/**
 * If the meaning of "EcnrStartAudioExtRequest" isn't clear, then there should be a description here.
 */
class EcnrStartAudioExtRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  EcnrStartAudioExtRequest ();

    /**
     * Copy constructor
     */
    inline  EcnrStartAudioExtRequest (const EcnrStartAudioExtRequest &rhs);

    /**
     * All fields constructor
     */
    inline  EcnrStartAudioExtRequest (uint8 ecnrAppId_, uint8 StartMode_);

    /**
     * Destructor
     */
    inline virtual  ~EcnrStartAudioExtRequest();

    /**
     * Assignment operator
     */
    inline EcnrStartAudioExtRequest& operator = (const EcnrStartAudioExtRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const EcnrStartAudioExtRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const EcnrStartAudioExtRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const EcnrStartAudioExtRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const EcnrStartAudioExtRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ecnrAppId"

    static const int kEcnrAppId = 0;

    /**
     * Clears the field "ecnrAppId".
     *
     * The field will be set to its default value. The hasEcnrAppId()
     * method will return false.
     */
    inline void clearEcnrAppId();

    /**
     * Checks whether the field "ecnrAppId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEcnrAppId()). Otherwise it will return false.
     */
    inline bool hasEcnrAppId () const;

    /**
     * Returns the value of the member "ecnrAppId".
     *
     * If the meaning of "ecnrAppId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "ecnrAppId"
     */
    inline uint8 getEcnrAppId () const;

    /**
     * Sets the value of the member "ecnrAppId".
     *
     * If the meaning of "ecnrAppId" isn't clear, then there should be a description here.
     *
     * @param ecnrAppId The value which will be set
     */
    inline void setEcnrAppId (uint8 ecnrAppId_);

    // API of field "StartMode"

    static const int kStartMode = 1;

    /**
     * Clears the field "StartMode".
     *
     * The field will be set to its default value. The hasStartMode()
     * method will return false.
     */
    inline void clearStartMode();

    /**
     * Checks whether the field "StartMode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStartMode()). Otherwise it will return false.
     */
    inline bool hasStartMode () const;

    /**
     * Returns the value of the member "StartMode".
     *
     * If the meaning of "StartMode" isn't clear, then there should be a description here.
     *
     * @return The value of the field "StartMode"
     */
    inline uint8 getStartMode () const;

    /**
     * Sets the value of the member "StartMode".
     *
     * If the meaning of "StartMode" isn't clear, then there should be a description here.
     *
     * @param StartMode The value which will be set
     */
    inline void setStartMode (uint8 StartMode_);

    static const EcnrStartAudioExtRequest &getDefaultInstance();

private:

    inline void set_has_ecnrAppId ();

    inline void clear_has_ecnrAppId ();

    inline void set_has_StartMode ();

    inline void clear_has_StartMode ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint8 _ecnrAppId;

    uint8 _StartMode;

};

/**
 * If the meaning of "EcnrStopAudioRequest" isn't clear, then there should be a description here.
 */
class EcnrStopAudioRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  EcnrStopAudioRequest ();

    /**
     * Copy constructor
     */
    inline  EcnrStopAudioRequest (const EcnrStopAudioRequest &rhs);

    /**
     * All fields constructor
     */
    inline  EcnrStopAudioRequest (uint8 ecnrAppId_);

    /**
     * Destructor
     */
    inline virtual  ~EcnrStopAudioRequest();

    /**
     * Assignment operator
     */
    inline EcnrStopAudioRequest& operator = (const EcnrStopAudioRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const EcnrStopAudioRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const EcnrStopAudioRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const EcnrStopAudioRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const EcnrStopAudioRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ecnrAppId"

    static const int kEcnrAppId = 0;

    /**
     * Clears the field "ecnrAppId".
     *
     * The field will be set to its default value. The hasEcnrAppId()
     * method will return false.
     */
    inline void clearEcnrAppId();

    /**
     * Checks whether the field "ecnrAppId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEcnrAppId()). Otherwise it will return false.
     */
    inline bool hasEcnrAppId () const;

    /**
     * Returns the value of the member "ecnrAppId".
     *
     * If the meaning of "ecnrAppId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "ecnrAppId"
     */
    inline uint8 getEcnrAppId () const;

    /**
     * Sets the value of the member "ecnrAppId".
     *
     * If the meaning of "ecnrAppId" isn't clear, then there should be a description here.
     *
     * @param ecnrAppId The value which will be set
     */
    inline void setEcnrAppId (uint8 ecnrAppId_);

    static const EcnrStopAudioRequest &getDefaultInstance();

private:

    inline void set_has_ecnrAppId ();

    inline void clear_has_ecnrAppId ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _ecnrAppId;

};

/**
 * If the meaning of "EcnrFrameInfoResponse" isn't clear, then there should be a description here.
 */
class EcnrFrameInfoResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  EcnrFrameInfoResponse ();

    /**
     * Copy constructor
     */
    inline  EcnrFrameInfoResponse (const EcnrFrameInfoResponse &rhs);

    /**
     * All fields constructor
     */
    inline  EcnrFrameInfoResponse (uint32 FrameCounter_, int32 VoicePresent_, int32 AboveBackgroundNoise_, int32 PercentClipping_, int32 InstantaneousSNR_, int32 SmoothVNR_, int32 ValidOutputCountdown_);

    /**
     * Destructor
     */
    inline virtual  ~EcnrFrameInfoResponse();

    /**
     * Assignment operator
     */
    inline EcnrFrameInfoResponse& operator = (const EcnrFrameInfoResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const EcnrFrameInfoResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const EcnrFrameInfoResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const EcnrFrameInfoResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const EcnrFrameInfoResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "FrameCounter"

    static const int kFrameCounter = 0;

    /**
     * Clears the field "FrameCounter".
     *
     * The field will be set to its default value. The hasFrameCounter()
     * method will return false.
     */
    inline void clearFrameCounter();

    /**
     * Checks whether the field "FrameCounter" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFrameCounter()). Otherwise it will return false.
     */
    inline bool hasFrameCounter () const;

    /**
     * Returns the value of the member "FrameCounter".
     *
     * If the meaning of "FrameCounter" isn't clear, then there should be a description here.
     *
     * @return The value of the field "FrameCounter"
     */
    inline uint32 getFrameCounter () const;

    /**
     * Sets the value of the member "FrameCounter".
     *
     * If the meaning of "FrameCounter" isn't clear, then there should be a description here.
     *
     * @param FrameCounter The value which will be set
     */
    inline void setFrameCounter (uint32 FrameCounter_);

    // API of field "VoicePresent"

    static const int kVoicePresent = 1;

    /**
     * Clears the field "VoicePresent".
     *
     * The field will be set to its default value. The hasVoicePresent()
     * method will return false.
     */
    inline void clearVoicePresent();

    /**
     * Checks whether the field "VoicePresent" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setVoicePresent()). Otherwise it will return false.
     */
    inline bool hasVoicePresent () const;

    /**
     * Returns the value of the member "VoicePresent".
     *
     * If the meaning of "VoicePresent" isn't clear, then there should be a description here.
     *
     * @return The value of the field "VoicePresent"
     */
    inline int32 getVoicePresent () const;

    /**
     * Sets the value of the member "VoicePresent".
     *
     * If the meaning of "VoicePresent" isn't clear, then there should be a description here.
     *
     * @param VoicePresent The value which will be set
     */
    inline void setVoicePresent (int32 VoicePresent_);

    // API of field "AboveBackgroundNoise"

    static const int kAboveBackgroundNoise = 2;

    /**
     * Clears the field "AboveBackgroundNoise".
     *
     * The field will be set to its default value. The hasAboveBackgroundNoise()
     * method will return false.
     */
    inline void clearAboveBackgroundNoise();

    /**
     * Checks whether the field "AboveBackgroundNoise" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAboveBackgroundNoise()). Otherwise it will return false.
     */
    inline bool hasAboveBackgroundNoise () const;

    /**
     * Returns the value of the member "AboveBackgroundNoise".
     *
     * If the meaning of "AboveBackgroundNoise" isn't clear, then there should be a description here.
     *
     * @return The value of the field "AboveBackgroundNoise"
     */
    inline int32 getAboveBackgroundNoise () const;

    /**
     * Sets the value of the member "AboveBackgroundNoise".
     *
     * If the meaning of "AboveBackgroundNoise" isn't clear, then there should be a description here.
     *
     * @param AboveBackgroundNoise The value which will be set
     */
    inline void setAboveBackgroundNoise (int32 AboveBackgroundNoise_);

    // API of field "PercentClipping"

    static const int kPercentClipping = 3;

    /**
     * Clears the field "PercentClipping".
     *
     * The field will be set to its default value. The hasPercentClipping()
     * method will return false.
     */
    inline void clearPercentClipping();

    /**
     * Checks whether the field "PercentClipping" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPercentClipping()). Otherwise it will return false.
     */
    inline bool hasPercentClipping () const;

    /**
     * Returns the value of the member "PercentClipping".
     *
     * If the meaning of "PercentClipping" isn't clear, then there should be a description here.
     *
     * @return The value of the field "PercentClipping"
     */
    inline int32 getPercentClipping () const;

    /**
     * Sets the value of the member "PercentClipping".
     *
     * If the meaning of "PercentClipping" isn't clear, then there should be a description here.
     *
     * @param PercentClipping The value which will be set
     */
    inline void setPercentClipping (int32 PercentClipping_);

    // API of field "InstantaneousSNR"

    static const int kInstantaneousSNR = 4;

    /**
     * Clears the field "InstantaneousSNR".
     *
     * The field will be set to its default value. The hasInstantaneousSNR()
     * method will return false.
     */
    inline void clearInstantaneousSNR();

    /**
     * Checks whether the field "InstantaneousSNR" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setInstantaneousSNR()). Otherwise it will return false.
     */
    inline bool hasInstantaneousSNR () const;

    /**
     * Returns the value of the member "InstantaneousSNR".
     *
     * If the meaning of "InstantaneousSNR" isn't clear, then there should be a description here.
     *
     * @return The value of the field "InstantaneousSNR"
     */
    inline int32 getInstantaneousSNR () const;

    /**
     * Sets the value of the member "InstantaneousSNR".
     *
     * If the meaning of "InstantaneousSNR" isn't clear, then there should be a description here.
     *
     * @param InstantaneousSNR The value which will be set
     */
    inline void setInstantaneousSNR (int32 InstantaneousSNR_);

    // API of field "SmoothVNR"

    static const int kSmoothVNR = 5;

    /**
     * Clears the field "SmoothVNR".
     *
     * The field will be set to its default value. The hasSmoothVNR()
     * method will return false.
     */
    inline void clearSmoothVNR();

    /**
     * Checks whether the field "SmoothVNR" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSmoothVNR()). Otherwise it will return false.
     */
    inline bool hasSmoothVNR () const;

    /**
     * Returns the value of the member "SmoothVNR".
     *
     * If the meaning of "SmoothVNR" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SmoothVNR"
     */
    inline int32 getSmoothVNR () const;

    /**
     * Sets the value of the member "SmoothVNR".
     *
     * If the meaning of "SmoothVNR" isn't clear, then there should be a description here.
     *
     * @param SmoothVNR The value which will be set
     */
    inline void setSmoothVNR (int32 SmoothVNR_);

    // API of field "ValidOutputCountdown"

    static const int kValidOutputCountdown = 6;

    /**
     * Clears the field "ValidOutputCountdown".
     *
     * The field will be set to its default value. The hasValidOutputCountdown()
     * method will return false.
     */
    inline void clearValidOutputCountdown();

    /**
     * Checks whether the field "ValidOutputCountdown" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setValidOutputCountdown()). Otherwise it will return false.
     */
    inline bool hasValidOutputCountdown () const;

    /**
     * Returns the value of the member "ValidOutputCountdown".
     *
     * If the meaning of "ValidOutputCountdown" isn't clear, then there should be a description here.
     *
     * @return The value of the field "ValidOutputCountdown"
     */
    inline int32 getValidOutputCountdown () const;

    /**
     * Sets the value of the member "ValidOutputCountdown".
     *
     * If the meaning of "ValidOutputCountdown" isn't clear, then there should be a description here.
     *
     * @param ValidOutputCountdown The value which will be set
     */
    inline void setValidOutputCountdown (int32 ValidOutputCountdown_);

    static const EcnrFrameInfoResponse &getDefaultInstance();

private:

    inline void set_has_FrameCounter ();

    inline void clear_has_FrameCounter ();

    inline void set_has_VoicePresent ();

    inline void clear_has_VoicePresent ();

    inline void set_has_AboveBackgroundNoise ();

    inline void clear_has_AboveBackgroundNoise ();

    inline void set_has_PercentClipping ();

    inline void clear_has_PercentClipping ();

    inline void set_has_InstantaneousSNR ();

    inline void clear_has_InstantaneousSNR ();

    inline void set_has_SmoothVNR ();

    inline void clear_has_SmoothVNR ();

    inline void set_has_ValidOutputCountdown ();

    inline void clear_has_ValidOutputCountdown ();

    uint32 _has_bits_[ (7 + 31) / 32];

    uint32 _FrameCounter;

    int32 _VoicePresent;

    int32 _AboveBackgroundNoise;

    int32 _PercentClipping;

    int32 _InstantaneousSNR;

    int32 _SmoothVNR;

    int32 _ValidOutputCountdown;

};

/**
 * If the meaning of "EcnrMicClipStatsRequest" isn't clear, then there should be a description here.
 */
class EcnrMicClipStatsRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  EcnrMicClipStatsRequest ();

    /**
     * Copy constructor
     */
    inline  EcnrMicClipStatsRequest (const EcnrMicClipStatsRequest &rhs);

    /**
     * All fields constructor
     */
    inline  EcnrMicClipStatsRequest (int32 Channel_);

    /**
     * Destructor
     */
    inline virtual  ~EcnrMicClipStatsRequest();

    /**
     * Assignment operator
     */
    inline EcnrMicClipStatsRequest& operator = (const EcnrMicClipStatsRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const EcnrMicClipStatsRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const EcnrMicClipStatsRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const EcnrMicClipStatsRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const EcnrMicClipStatsRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Channel"

    static const int kChannel = 0;

    /**
     * Clears the field "Channel".
     *
     * The field will be set to its default value. The hasChannel()
     * method will return false.
     */
    inline void clearChannel();

    /**
     * Checks whether the field "Channel" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setChannel()). Otherwise it will return false.
     */
    inline bool hasChannel () const;

    /**
     * Returns the value of the member "Channel".
     *
     * If the meaning of "Channel" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Channel"
     */
    inline int32 getChannel () const;

    /**
     * Sets the value of the member "Channel".
     *
     * If the meaning of "Channel" isn't clear, then there should be a description here.
     *
     * @param Channel The value which will be set
     */
    inline void setChannel (int32 Channel_);

    static const EcnrMicClipStatsRequest &getDefaultInstance();

private:

    inline void set_has_Channel ();

    inline void clear_has_Channel ();

    uint32 _has_bits_[ (1 + 31) / 32];

    int32 _Channel;

};

/**
 * If the meaning of "EcnrMicClipStatsResponse" isn't clear, then there should be a description here.
 */
class EcnrMicClipStatsResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  EcnrMicClipStatsResponse ();

    /**
     * Copy constructor
     */
    inline  EcnrMicClipStatsResponse (const EcnrMicClipStatsResponse &rhs);

    /**
     * All fields constructor
     */
    inline  EcnrMicClipStatsResponse (uint32 ClipFrames_, uint32 ClipCount_, int32 MaxAmp_, int32 MinAmp_);

    /**
     * Destructor
     */
    inline virtual  ~EcnrMicClipStatsResponse();

    /**
     * Assignment operator
     */
    inline EcnrMicClipStatsResponse& operator = (const EcnrMicClipStatsResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const EcnrMicClipStatsResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const EcnrMicClipStatsResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const EcnrMicClipStatsResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const EcnrMicClipStatsResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ClipFrames"

    static const int kClipFrames = 0;

    /**
     * Clears the field "ClipFrames".
     *
     * The field will be set to its default value. The hasClipFrames()
     * method will return false.
     */
    inline void clearClipFrames();

    /**
     * Checks whether the field "ClipFrames" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setClipFrames()). Otherwise it will return false.
     */
    inline bool hasClipFrames () const;

    /**
     * Returns the value of the member "ClipFrames".
     *
     * If the meaning of "ClipFrames" isn't clear, then there should be a description here.
     *
     * @return The value of the field "ClipFrames"
     */
    inline uint32 getClipFrames () const;

    /**
     * Sets the value of the member "ClipFrames".
     *
     * If the meaning of "ClipFrames" isn't clear, then there should be a description here.
     *
     * @param ClipFrames The value which will be set
     */
    inline void setClipFrames (uint32 ClipFrames_);

    // API of field "ClipCount"

    static const int kClipCount = 1;

    /**
     * Clears the field "ClipCount".
     *
     * The field will be set to its default value. The hasClipCount()
     * method will return false.
     */
    inline void clearClipCount();

    /**
     * Checks whether the field "ClipCount" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setClipCount()). Otherwise it will return false.
     */
    inline bool hasClipCount () const;

    /**
     * Returns the value of the member "ClipCount".
     *
     * If the meaning of "ClipCount" isn't clear, then there should be a description here.
     *
     * @return The value of the field "ClipCount"
     */
    inline uint32 getClipCount () const;

    /**
     * Sets the value of the member "ClipCount".
     *
     * If the meaning of "ClipCount" isn't clear, then there should be a description here.
     *
     * @param ClipCount The value which will be set
     */
    inline void setClipCount (uint32 ClipCount_);

    // API of field "MaxAmp"

    static const int kMaxAmp = 2;

    /**
     * Clears the field "MaxAmp".
     *
     * The field will be set to its default value. The hasMaxAmp()
     * method will return false.
     */
    inline void clearMaxAmp();

    /**
     * Checks whether the field "MaxAmp" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMaxAmp()). Otherwise it will return false.
     */
    inline bool hasMaxAmp () const;

    /**
     * Returns the value of the member "MaxAmp".
     *
     * If the meaning of "MaxAmp" isn't clear, then there should be a description here.
     *
     * @return The value of the field "MaxAmp"
     */
    inline int32 getMaxAmp () const;

    /**
     * Sets the value of the member "MaxAmp".
     *
     * If the meaning of "MaxAmp" isn't clear, then there should be a description here.
     *
     * @param MaxAmp The value which will be set
     */
    inline void setMaxAmp (int32 MaxAmp_);

    // API of field "MinAmp"

    static const int kMinAmp = 3;

    /**
     * Clears the field "MinAmp".
     *
     * The field will be set to its default value. The hasMinAmp()
     * method will return false.
     */
    inline void clearMinAmp();

    /**
     * Checks whether the field "MinAmp" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMinAmp()). Otherwise it will return false.
     */
    inline bool hasMinAmp () const;

    /**
     * Returns the value of the member "MinAmp".
     *
     * If the meaning of "MinAmp" isn't clear, then there should be a description here.
     *
     * @return The value of the field "MinAmp"
     */
    inline int32 getMinAmp () const;

    /**
     * Sets the value of the member "MinAmp".
     *
     * If the meaning of "MinAmp" isn't clear, then there should be a description here.
     *
     * @param MinAmp The value which will be set
     */
    inline void setMinAmp (int32 MinAmp_);

    static const EcnrMicClipStatsResponse &getDefaultInstance();

private:

    inline void set_has_ClipFrames ();

    inline void clear_has_ClipFrames ();

    inline void set_has_ClipCount ();

    inline void clear_has_ClipCount ();

    inline void set_has_MaxAmp ();

    inline void clear_has_MaxAmp ();

    inline void set_has_MinAmp ();

    inline void clear_has_MinAmp ();

    uint32 _has_bits_[ (4 + 31) / 32];

    uint32 _ClipFrames;

    uint32 _ClipCount;

    int32 _MaxAmp;

    int32 _MinAmp;

};

/**
 * If the meaning of "EcnrRefClipStatsResponse" isn't clear, then there should be a description here.
 */
class EcnrRefClipStatsResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  EcnrRefClipStatsResponse ();

    /**
     * Copy constructor
     */
    inline  EcnrRefClipStatsResponse (const EcnrRefClipStatsResponse &rhs);

    /**
     * All fields constructor
     */
    inline  EcnrRefClipStatsResponse (uint32 ClipFrames_, uint32 ClipCount_, int32 MaxAmp_, int32 MinAmp_);

    /**
     * Destructor
     */
    inline virtual  ~EcnrRefClipStatsResponse();

    /**
     * Assignment operator
     */
    inline EcnrRefClipStatsResponse& operator = (const EcnrRefClipStatsResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const EcnrRefClipStatsResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const EcnrRefClipStatsResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const EcnrRefClipStatsResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const EcnrRefClipStatsResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ClipFrames"

    static const int kClipFrames = 0;

    /**
     * Clears the field "ClipFrames".
     *
     * The field will be set to its default value. The hasClipFrames()
     * method will return false.
     */
    inline void clearClipFrames();

    /**
     * Checks whether the field "ClipFrames" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setClipFrames()). Otherwise it will return false.
     */
    inline bool hasClipFrames () const;

    /**
     * Returns the value of the member "ClipFrames".
     *
     * If the meaning of "ClipFrames" isn't clear, then there should be a description here.
     *
     * @return The value of the field "ClipFrames"
     */
    inline uint32 getClipFrames () const;

    /**
     * Sets the value of the member "ClipFrames".
     *
     * If the meaning of "ClipFrames" isn't clear, then there should be a description here.
     *
     * @param ClipFrames The value which will be set
     */
    inline void setClipFrames (uint32 ClipFrames_);

    // API of field "ClipCount"

    static const int kClipCount = 1;

    /**
     * Clears the field "ClipCount".
     *
     * The field will be set to its default value. The hasClipCount()
     * method will return false.
     */
    inline void clearClipCount();

    /**
     * Checks whether the field "ClipCount" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setClipCount()). Otherwise it will return false.
     */
    inline bool hasClipCount () const;

    /**
     * Returns the value of the member "ClipCount".
     *
     * If the meaning of "ClipCount" isn't clear, then there should be a description here.
     *
     * @return The value of the field "ClipCount"
     */
    inline uint32 getClipCount () const;

    /**
     * Sets the value of the member "ClipCount".
     *
     * If the meaning of "ClipCount" isn't clear, then there should be a description here.
     *
     * @param ClipCount The value which will be set
     */
    inline void setClipCount (uint32 ClipCount_);

    // API of field "MaxAmp"

    static const int kMaxAmp = 2;

    /**
     * Clears the field "MaxAmp".
     *
     * The field will be set to its default value. The hasMaxAmp()
     * method will return false.
     */
    inline void clearMaxAmp();

    /**
     * Checks whether the field "MaxAmp" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMaxAmp()). Otherwise it will return false.
     */
    inline bool hasMaxAmp () const;

    /**
     * Returns the value of the member "MaxAmp".
     *
     * If the meaning of "MaxAmp" isn't clear, then there should be a description here.
     *
     * @return The value of the field "MaxAmp"
     */
    inline int32 getMaxAmp () const;

    /**
     * Sets the value of the member "MaxAmp".
     *
     * If the meaning of "MaxAmp" isn't clear, then there should be a description here.
     *
     * @param MaxAmp The value which will be set
     */
    inline void setMaxAmp (int32 MaxAmp_);

    // API of field "MinAmp"

    static const int kMinAmp = 3;

    /**
     * Clears the field "MinAmp".
     *
     * The field will be set to its default value. The hasMinAmp()
     * method will return false.
     */
    inline void clearMinAmp();

    /**
     * Checks whether the field "MinAmp" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMinAmp()). Otherwise it will return false.
     */
    inline bool hasMinAmp () const;

    /**
     * Returns the value of the member "MinAmp".
     *
     * If the meaning of "MinAmp" isn't clear, then there should be a description here.
     *
     * @return The value of the field "MinAmp"
     */
    inline int32 getMinAmp () const;

    /**
     * Sets the value of the member "MinAmp".
     *
     * If the meaning of "MinAmp" isn't clear, then there should be a description here.
     *
     * @param MinAmp The value which will be set
     */
    inline void setMinAmp (int32 MinAmp_);

    static const EcnrRefClipStatsResponse &getDefaultInstance();

private:

    inline void set_has_ClipFrames ();

    inline void clear_has_ClipFrames ();

    inline void set_has_ClipCount ();

    inline void clear_has_ClipCount ();

    inline void set_has_MaxAmp ();

    inline void clear_has_MaxAmp ();

    inline void set_has_MinAmp ();

    inline void clear_has_MinAmp ();

    uint32 _has_bits_[ (4 + 31) / 32];

    uint32 _ClipFrames;

    uint32 _ClipCount;

    int32 _MaxAmp;

    int32 _MinAmp;

};

/**
 * If the meaning of "EcnrRecvClipStatsResponse" isn't clear, then there should be a description here.
 */
class EcnrRecvClipStatsResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  EcnrRecvClipStatsResponse ();

    /**
     * Copy constructor
     */
    inline  EcnrRecvClipStatsResponse (const EcnrRecvClipStatsResponse &rhs);

    /**
     * All fields constructor
     */
    inline  EcnrRecvClipStatsResponse (uint32 ClipFrames_, uint32 ClipCount_, int32 MaxAmp_, int32 MinAmp_);

    /**
     * Destructor
     */
    inline virtual  ~EcnrRecvClipStatsResponse();

    /**
     * Assignment operator
     */
    inline EcnrRecvClipStatsResponse& operator = (const EcnrRecvClipStatsResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const EcnrRecvClipStatsResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const EcnrRecvClipStatsResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const EcnrRecvClipStatsResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const EcnrRecvClipStatsResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ClipFrames"

    static const int kClipFrames = 0;

    /**
     * Clears the field "ClipFrames".
     *
     * The field will be set to its default value. The hasClipFrames()
     * method will return false.
     */
    inline void clearClipFrames();

    /**
     * Checks whether the field "ClipFrames" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setClipFrames()). Otherwise it will return false.
     */
    inline bool hasClipFrames () const;

    /**
     * Returns the value of the member "ClipFrames".
     *
     * If the meaning of "ClipFrames" isn't clear, then there should be a description here.
     *
     * @return The value of the field "ClipFrames"
     */
    inline uint32 getClipFrames () const;

    /**
     * Sets the value of the member "ClipFrames".
     *
     * If the meaning of "ClipFrames" isn't clear, then there should be a description here.
     *
     * @param ClipFrames The value which will be set
     */
    inline void setClipFrames (uint32 ClipFrames_);

    // API of field "ClipCount"

    static const int kClipCount = 1;

    /**
     * Clears the field "ClipCount".
     *
     * The field will be set to its default value. The hasClipCount()
     * method will return false.
     */
    inline void clearClipCount();

    /**
     * Checks whether the field "ClipCount" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setClipCount()). Otherwise it will return false.
     */
    inline bool hasClipCount () const;

    /**
     * Returns the value of the member "ClipCount".
     *
     * If the meaning of "ClipCount" isn't clear, then there should be a description here.
     *
     * @return The value of the field "ClipCount"
     */
    inline uint32 getClipCount () const;

    /**
     * Sets the value of the member "ClipCount".
     *
     * If the meaning of "ClipCount" isn't clear, then there should be a description here.
     *
     * @param ClipCount The value which will be set
     */
    inline void setClipCount (uint32 ClipCount_);

    // API of field "MaxAmp"

    static const int kMaxAmp = 2;

    /**
     * Clears the field "MaxAmp".
     *
     * The field will be set to its default value. The hasMaxAmp()
     * method will return false.
     */
    inline void clearMaxAmp();

    /**
     * Checks whether the field "MaxAmp" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMaxAmp()). Otherwise it will return false.
     */
    inline bool hasMaxAmp () const;

    /**
     * Returns the value of the member "MaxAmp".
     *
     * If the meaning of "MaxAmp" isn't clear, then there should be a description here.
     *
     * @return The value of the field "MaxAmp"
     */
    inline int32 getMaxAmp () const;

    /**
     * Sets the value of the member "MaxAmp".
     *
     * If the meaning of "MaxAmp" isn't clear, then there should be a description here.
     *
     * @param MaxAmp The value which will be set
     */
    inline void setMaxAmp (int32 MaxAmp_);

    // API of field "MinAmp"

    static const int kMinAmp = 3;

    /**
     * Clears the field "MinAmp".
     *
     * The field will be set to its default value. The hasMinAmp()
     * method will return false.
     */
    inline void clearMinAmp();

    /**
     * Checks whether the field "MinAmp" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMinAmp()). Otherwise it will return false.
     */
    inline bool hasMinAmp () const;

    /**
     * Returns the value of the member "MinAmp".
     *
     * If the meaning of "MinAmp" isn't clear, then there should be a description here.
     *
     * @return The value of the field "MinAmp"
     */
    inline int32 getMinAmp () const;

    /**
     * Sets the value of the member "MinAmp".
     *
     * If the meaning of "MinAmp" isn't clear, then there should be a description here.
     *
     * @param MinAmp The value which will be set
     */
    inline void setMinAmp (int32 MinAmp_);

    static const EcnrRecvClipStatsResponse &getDefaultInstance();

private:

    inline void set_has_ClipFrames ();

    inline void clear_has_ClipFrames ();

    inline void set_has_ClipCount ();

    inline void clear_has_ClipCount ();

    inline void set_has_MaxAmp ();

    inline void clear_has_MaxAmp ();

    inline void set_has_MinAmp ();

    inline void clear_has_MinAmp ();

    uint32 _has_bits_[ (4 + 31) / 32];

    uint32 _ClipFrames;

    uint32 _ClipCount;

    int32 _MaxAmp;

    int32 _MinAmp;

};

/**
 * If the meaning of "EcnrMicOutClipStatsResponse" isn't clear, then there should be a description here.
 */
class EcnrMicOutClipStatsResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  EcnrMicOutClipStatsResponse ();

    /**
     * Copy constructor
     */
    inline  EcnrMicOutClipStatsResponse (const EcnrMicOutClipStatsResponse &rhs);

    /**
     * All fields constructor
     */
    inline  EcnrMicOutClipStatsResponse (uint32 ClipFrames_, uint32 ClipCount_, int32 MaxAmp_, int32 MinAmp_);

    /**
     * Destructor
     */
    inline virtual  ~EcnrMicOutClipStatsResponse();

    /**
     * Assignment operator
     */
    inline EcnrMicOutClipStatsResponse& operator = (const EcnrMicOutClipStatsResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const EcnrMicOutClipStatsResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const EcnrMicOutClipStatsResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const EcnrMicOutClipStatsResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const EcnrMicOutClipStatsResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ClipFrames"

    static const int kClipFrames = 0;

    /**
     * Clears the field "ClipFrames".
     *
     * The field will be set to its default value. The hasClipFrames()
     * method will return false.
     */
    inline void clearClipFrames();

    /**
     * Checks whether the field "ClipFrames" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setClipFrames()). Otherwise it will return false.
     */
    inline bool hasClipFrames () const;

    /**
     * Returns the value of the member "ClipFrames".
     *
     * If the meaning of "ClipFrames" isn't clear, then there should be a description here.
     *
     * @return The value of the field "ClipFrames"
     */
    inline uint32 getClipFrames () const;

    /**
     * Sets the value of the member "ClipFrames".
     *
     * If the meaning of "ClipFrames" isn't clear, then there should be a description here.
     *
     * @param ClipFrames The value which will be set
     */
    inline void setClipFrames (uint32 ClipFrames_);

    // API of field "ClipCount"

    static const int kClipCount = 1;

    /**
     * Clears the field "ClipCount".
     *
     * The field will be set to its default value. The hasClipCount()
     * method will return false.
     */
    inline void clearClipCount();

    /**
     * Checks whether the field "ClipCount" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setClipCount()). Otherwise it will return false.
     */
    inline bool hasClipCount () const;

    /**
     * Returns the value of the member "ClipCount".
     *
     * If the meaning of "ClipCount" isn't clear, then there should be a description here.
     *
     * @return The value of the field "ClipCount"
     */
    inline uint32 getClipCount () const;

    /**
     * Sets the value of the member "ClipCount".
     *
     * If the meaning of "ClipCount" isn't clear, then there should be a description here.
     *
     * @param ClipCount The value which will be set
     */
    inline void setClipCount (uint32 ClipCount_);

    // API of field "MaxAmp"

    static const int kMaxAmp = 2;

    /**
     * Clears the field "MaxAmp".
     *
     * The field will be set to its default value. The hasMaxAmp()
     * method will return false.
     */
    inline void clearMaxAmp();

    /**
     * Checks whether the field "MaxAmp" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMaxAmp()). Otherwise it will return false.
     */
    inline bool hasMaxAmp () const;

    /**
     * Returns the value of the member "MaxAmp".
     *
     * If the meaning of "MaxAmp" isn't clear, then there should be a description here.
     *
     * @return The value of the field "MaxAmp"
     */
    inline int32 getMaxAmp () const;

    /**
     * Sets the value of the member "MaxAmp".
     *
     * If the meaning of "MaxAmp" isn't clear, then there should be a description here.
     *
     * @param MaxAmp The value which will be set
     */
    inline void setMaxAmp (int32 MaxAmp_);

    // API of field "MinAmp"

    static const int kMinAmp = 3;

    /**
     * Clears the field "MinAmp".
     *
     * The field will be set to its default value. The hasMinAmp()
     * method will return false.
     */
    inline void clearMinAmp();

    /**
     * Checks whether the field "MinAmp" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMinAmp()). Otherwise it will return false.
     */
    inline bool hasMinAmp () const;

    /**
     * Returns the value of the member "MinAmp".
     *
     * If the meaning of "MinAmp" isn't clear, then there should be a description here.
     *
     * @return The value of the field "MinAmp"
     */
    inline int32 getMinAmp () const;

    /**
     * Sets the value of the member "MinAmp".
     *
     * If the meaning of "MinAmp" isn't clear, then there should be a description here.
     *
     * @param MinAmp The value which will be set
     */
    inline void setMinAmp (int32 MinAmp_);

    static const EcnrMicOutClipStatsResponse &getDefaultInstance();

private:

    inline void set_has_ClipFrames ();

    inline void clear_has_ClipFrames ();

    inline void set_has_ClipCount ();

    inline void clear_has_ClipCount ();

    inline void set_has_MaxAmp ();

    inline void clear_has_MaxAmp ();

    inline void set_has_MinAmp ();

    inline void clear_has_MinAmp ();

    uint32 _has_bits_[ (4 + 31) / 32];

    uint32 _ClipFrames;

    uint32 _ClipCount;

    int32 _MaxAmp;

    int32 _MinAmp;

};

/**
 * If the meaning of "EcnrRecvOutClipStatsResponse" isn't clear, then there should be a description here.
 */
class EcnrRecvOutClipStatsResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  EcnrRecvOutClipStatsResponse ();

    /**
     * Copy constructor
     */
    inline  EcnrRecvOutClipStatsResponse (const EcnrRecvOutClipStatsResponse &rhs);

    /**
     * All fields constructor
     */
    inline  EcnrRecvOutClipStatsResponse (uint32 ClipFrames_, uint32 ClipCount_, int32 MaxAmp_, int32 MinAmp_);

    /**
     * Destructor
     */
    inline virtual  ~EcnrRecvOutClipStatsResponse();

    /**
     * Assignment operator
     */
    inline EcnrRecvOutClipStatsResponse& operator = (const EcnrRecvOutClipStatsResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const EcnrRecvOutClipStatsResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const EcnrRecvOutClipStatsResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const EcnrRecvOutClipStatsResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const EcnrRecvOutClipStatsResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ClipFrames"

    static const int kClipFrames = 0;

    /**
     * Clears the field "ClipFrames".
     *
     * The field will be set to its default value. The hasClipFrames()
     * method will return false.
     */
    inline void clearClipFrames();

    /**
     * Checks whether the field "ClipFrames" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setClipFrames()). Otherwise it will return false.
     */
    inline bool hasClipFrames () const;

    /**
     * Returns the value of the member "ClipFrames".
     *
     * If the meaning of "ClipFrames" isn't clear, then there should be a description here.
     *
     * @return The value of the field "ClipFrames"
     */
    inline uint32 getClipFrames () const;

    /**
     * Sets the value of the member "ClipFrames".
     *
     * If the meaning of "ClipFrames" isn't clear, then there should be a description here.
     *
     * @param ClipFrames The value which will be set
     */
    inline void setClipFrames (uint32 ClipFrames_);

    // API of field "ClipCount"

    static const int kClipCount = 1;

    /**
     * Clears the field "ClipCount".
     *
     * The field will be set to its default value. The hasClipCount()
     * method will return false.
     */
    inline void clearClipCount();

    /**
     * Checks whether the field "ClipCount" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setClipCount()). Otherwise it will return false.
     */
    inline bool hasClipCount () const;

    /**
     * Returns the value of the member "ClipCount".
     *
     * If the meaning of "ClipCount" isn't clear, then there should be a description here.
     *
     * @return The value of the field "ClipCount"
     */
    inline uint32 getClipCount () const;

    /**
     * Sets the value of the member "ClipCount".
     *
     * If the meaning of "ClipCount" isn't clear, then there should be a description here.
     *
     * @param ClipCount The value which will be set
     */
    inline void setClipCount (uint32 ClipCount_);

    // API of field "MaxAmp"

    static const int kMaxAmp = 2;

    /**
     * Clears the field "MaxAmp".
     *
     * The field will be set to its default value. The hasMaxAmp()
     * method will return false.
     */
    inline void clearMaxAmp();

    /**
     * Checks whether the field "MaxAmp" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMaxAmp()). Otherwise it will return false.
     */
    inline bool hasMaxAmp () const;

    /**
     * Returns the value of the member "MaxAmp".
     *
     * If the meaning of "MaxAmp" isn't clear, then there should be a description here.
     *
     * @return The value of the field "MaxAmp"
     */
    inline int32 getMaxAmp () const;

    /**
     * Sets the value of the member "MaxAmp".
     *
     * If the meaning of "MaxAmp" isn't clear, then there should be a description here.
     *
     * @param MaxAmp The value which will be set
     */
    inline void setMaxAmp (int32 MaxAmp_);

    // API of field "MinAmp"

    static const int kMinAmp = 3;

    /**
     * Clears the field "MinAmp".
     *
     * The field will be set to its default value. The hasMinAmp()
     * method will return false.
     */
    inline void clearMinAmp();

    /**
     * Checks whether the field "MinAmp" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMinAmp()). Otherwise it will return false.
     */
    inline bool hasMinAmp () const;

    /**
     * Returns the value of the member "MinAmp".
     *
     * If the meaning of "MinAmp" isn't clear, then there should be a description here.
     *
     * @return The value of the field "MinAmp"
     */
    inline int32 getMinAmp () const;

    /**
     * Sets the value of the member "MinAmp".
     *
     * If the meaning of "MinAmp" isn't clear, then there should be a description here.
     *
     * @param MinAmp The value which will be set
     */
    inline void setMinAmp (int32 MinAmp_);

    static const EcnrRecvOutClipStatsResponse &getDefaultInstance();

private:

    inline void set_has_ClipFrames ();

    inline void clear_has_ClipFrames ();

    inline void set_has_ClipCount ();

    inline void clear_has_ClipCount ();

    inline void set_has_MaxAmp ();

    inline void clear_has_MaxAmp ();

    inline void set_has_MinAmp ();

    inline void clear_has_MinAmp ();

    uint32 _has_bits_[ (4 + 31) / 32];

    uint32 _ClipFrames;

    uint32 _ClipCount;

    int32 _MaxAmp;

    int32 _MinAmp;

};

/**
 * If the meaning of "EcnrSetSendMuteSwitchRequest" isn't clear, then there should be a description here.
 */
class EcnrSetSendMuteSwitchRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  EcnrSetSendMuteSwitchRequest ();

    /**
     * Copy constructor
     */
    inline  EcnrSetSendMuteSwitchRequest (const EcnrSetSendMuteSwitchRequest &rhs);

    /**
     * All fields constructor
     */
    inline  EcnrSetSendMuteSwitchRequest (uint8 ecnrAppId_, uint8 ecnrSendMuteSwitch_);

    /**
     * Destructor
     */
    inline virtual  ~EcnrSetSendMuteSwitchRequest();

    /**
     * Assignment operator
     */
    inline EcnrSetSendMuteSwitchRequest& operator = (const EcnrSetSendMuteSwitchRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const EcnrSetSendMuteSwitchRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const EcnrSetSendMuteSwitchRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const EcnrSetSendMuteSwitchRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const EcnrSetSendMuteSwitchRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ecnrAppId"

    static const int kEcnrAppId = 0;

    /**
     * Clears the field "ecnrAppId".
     *
     * The field will be set to its default value. The hasEcnrAppId()
     * method will return false.
     */
    inline void clearEcnrAppId();

    /**
     * Checks whether the field "ecnrAppId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEcnrAppId()). Otherwise it will return false.
     */
    inline bool hasEcnrAppId () const;

    /**
     * Returns the value of the member "ecnrAppId".
     *
     * If the meaning of "ecnrAppId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "ecnrAppId"
     */
    inline uint8 getEcnrAppId () const;

    /**
     * Sets the value of the member "ecnrAppId".
     *
     * If the meaning of "ecnrAppId" isn't clear, then there should be a description here.
     *
     * @param ecnrAppId The value which will be set
     */
    inline void setEcnrAppId (uint8 ecnrAppId_);

    // API of field "ecnrSendMuteSwitch"

    static const int kEcnrSendMuteSwitch = 1;

    /**
     * Clears the field "ecnrSendMuteSwitch".
     *
     * The field will be set to its default value. The hasEcnrSendMuteSwitch()
     * method will return false.
     */
    inline void clearEcnrSendMuteSwitch();

    /**
     * Checks whether the field "ecnrSendMuteSwitch" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEcnrSendMuteSwitch()). Otherwise it will return false.
     */
    inline bool hasEcnrSendMuteSwitch () const;

    /**
     * Returns the value of the member "ecnrSendMuteSwitch".
     *
     * If the meaning of "ecnrSendMuteSwitch" isn't clear, then there should be a description here.
     *
     * @return The value of the field "ecnrSendMuteSwitch"
     */
    inline uint8 getEcnrSendMuteSwitch () const;

    /**
     * Sets the value of the member "ecnrSendMuteSwitch".
     *
     * If the meaning of "ecnrSendMuteSwitch" isn't clear, then there should be a description here.
     *
     * @param ecnrSendMuteSwitch The value which will be set
     */
    inline void setEcnrSendMuteSwitch (uint8 ecnrSendMuteSwitch_);

    static const EcnrSetSendMuteSwitchRequest &getDefaultInstance();

private:

    inline void set_has_ecnrAppId ();

    inline void clear_has_ecnrAppId ();

    inline void set_has_ecnrSendMuteSwitch ();

    inline void clear_has_ecnrSendMuteSwitch ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint8 _ecnrAppId;

    uint8 _ecnrSendMuteSwitch;

};

/**
 * If the meaning of "EcnrSetSendGainDeltaRequest" isn't clear, then there should be a description here.
 */
class EcnrSetSendGainDeltaRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  EcnrSetSendGainDeltaRequest ();

    /**
     * Copy constructor
     */
    inline  EcnrSetSendGainDeltaRequest (const EcnrSetSendGainDeltaRequest &rhs);

    /**
     * All fields constructor
     */
    inline  EcnrSetSendGainDeltaRequest (uint8 ecnrAppId_, int16 ecnrLevel_);

    /**
     * Destructor
     */
    inline virtual  ~EcnrSetSendGainDeltaRequest();

    /**
     * Assignment operator
     */
    inline EcnrSetSendGainDeltaRequest& operator = (const EcnrSetSendGainDeltaRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const EcnrSetSendGainDeltaRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const EcnrSetSendGainDeltaRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const EcnrSetSendGainDeltaRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const EcnrSetSendGainDeltaRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ecnrAppId"

    static const int kEcnrAppId = 0;

    /**
     * Clears the field "ecnrAppId".
     *
     * The field will be set to its default value. The hasEcnrAppId()
     * method will return false.
     */
    inline void clearEcnrAppId();

    /**
     * Checks whether the field "ecnrAppId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEcnrAppId()). Otherwise it will return false.
     */
    inline bool hasEcnrAppId () const;

    /**
     * Returns the value of the member "ecnrAppId".
     *
     * If the meaning of "ecnrAppId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "ecnrAppId"
     */
    inline uint8 getEcnrAppId () const;

    /**
     * Sets the value of the member "ecnrAppId".
     *
     * If the meaning of "ecnrAppId" isn't clear, then there should be a description here.
     *
     * @param ecnrAppId The value which will be set
     */
    inline void setEcnrAppId (uint8 ecnrAppId_);

    // API of field "ecnrLevel"

    static const int kEcnrLevel = 1;

    /**
     * Clears the field "ecnrLevel".
     *
     * The field will be set to its default value. The hasEcnrLevel()
     * method will return false.
     */
    inline void clearEcnrLevel();

    /**
     * Checks whether the field "ecnrLevel" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEcnrLevel()). Otherwise it will return false.
     */
    inline bool hasEcnrLevel () const;

    /**
     * Returns the value of the member "ecnrLevel".
     *
     * If the meaning of "ecnrLevel" isn't clear, then there should be a description here.
     *
     * @return The value of the field "ecnrLevel"
     */
    inline int16 getEcnrLevel () const;

    /**
     * Sets the value of the member "ecnrLevel".
     *
     * If the meaning of "ecnrLevel" isn't clear, then there should be a description here.
     *
     * @param ecnrLevel The value which will be set
     */
    inline void setEcnrLevel (int16 ecnrLevel_);

    static const EcnrSetSendGainDeltaRequest &getDefaultInstance();

private:

    inline void set_has_ecnrAppId ();

    inline void clear_has_ecnrAppId ();

    inline void set_has_ecnrLevel ();

    inline void clear_has_ecnrLevel ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint8 _ecnrAppId;

    int16 _ecnrLevel;

};

/**
 * If the meaning of "EcnrSetMicGainRequest" isn't clear, then there should be a description here.
 */
class EcnrSetMicGainRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  EcnrSetMicGainRequest ();

    /**
     * Copy constructor
     */
    inline  EcnrSetMicGainRequest (const EcnrSetMicGainRequest &rhs);

    /**
     * All fields constructor
     */
    inline  EcnrSetMicGainRequest (int32 MicGainLevel_);

    /**
     * Destructor
     */
    inline virtual  ~EcnrSetMicGainRequest();

    /**
     * Assignment operator
     */
    inline EcnrSetMicGainRequest& operator = (const EcnrSetMicGainRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const EcnrSetMicGainRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const EcnrSetMicGainRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const EcnrSetMicGainRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const EcnrSetMicGainRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "MicGainLevel"

    static const int kMicGainLevel = 0;

    /**
     * Clears the field "MicGainLevel".
     *
     * The field will be set to its default value. The hasMicGainLevel()
     * method will return false.
     */
    inline void clearMicGainLevel();

    /**
     * Checks whether the field "MicGainLevel" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMicGainLevel()). Otherwise it will return false.
     */
    inline bool hasMicGainLevel () const;

    /**
     * Returns the value of the member "MicGainLevel".
     *
     * If the meaning of "MicGainLevel" isn't clear, then there should be a description here.
     *
     * @return The value of the field "MicGainLevel"
     */
    inline int32 getMicGainLevel () const;

    /**
     * Sets the value of the member "MicGainLevel".
     *
     * If the meaning of "MicGainLevel" isn't clear, then there should be a description here.
     *
     * @param MicGainLevel The value which will be set
     */
    inline void setMicGainLevel (int32 MicGainLevel_);

    static const EcnrSetMicGainRequest &getDefaultInstance();

private:

    inline void set_has_MicGainLevel ();

    inline void clear_has_MicGainLevel ();

    uint32 _has_bits_[ (1 + 31) / 32];

    int32 _MicGainLevel;

};

/**
 * If the meaning of "EcnrSetPassThroughModeRequest" isn't clear, then there should be a description here.
 */
class EcnrSetPassThroughModeRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  EcnrSetPassThroughModeRequest ();

    /**
     * Copy constructor
     */
    inline  EcnrSetPassThroughModeRequest (const EcnrSetPassThroughModeRequest &rhs);

    /**
     * All fields constructor
     */
    inline  EcnrSetPassThroughModeRequest (uint8 ecnrAppId_, uint8 ecnrPassThroughMode_);

    /**
     * Destructor
     */
    inline virtual  ~EcnrSetPassThroughModeRequest();

    /**
     * Assignment operator
     */
    inline EcnrSetPassThroughModeRequest& operator = (const EcnrSetPassThroughModeRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const EcnrSetPassThroughModeRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const EcnrSetPassThroughModeRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const EcnrSetPassThroughModeRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const EcnrSetPassThroughModeRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ecnrAppId"

    static const int kEcnrAppId = 0;

    /**
     * Clears the field "ecnrAppId".
     *
     * The field will be set to its default value. The hasEcnrAppId()
     * method will return false.
     */
    inline void clearEcnrAppId();

    /**
     * Checks whether the field "ecnrAppId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEcnrAppId()). Otherwise it will return false.
     */
    inline bool hasEcnrAppId () const;

    /**
     * Returns the value of the member "ecnrAppId".
     *
     * If the meaning of "ecnrAppId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "ecnrAppId"
     */
    inline uint8 getEcnrAppId () const;

    /**
     * Sets the value of the member "ecnrAppId".
     *
     * If the meaning of "ecnrAppId" isn't clear, then there should be a description here.
     *
     * @param ecnrAppId The value which will be set
     */
    inline void setEcnrAppId (uint8 ecnrAppId_);

    // API of field "ecnrPassThroughMode"

    static const int kEcnrPassThroughMode = 1;

    /**
     * Clears the field "ecnrPassThroughMode".
     *
     * The field will be set to its default value. The hasEcnrPassThroughMode()
     * method will return false.
     */
    inline void clearEcnrPassThroughMode();

    /**
     * Checks whether the field "ecnrPassThroughMode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEcnrPassThroughMode()). Otherwise it will return false.
     */
    inline bool hasEcnrPassThroughMode () const;

    /**
     * Returns the value of the member "ecnrPassThroughMode".
     *
     * If the meaning of "ecnrPassThroughMode" isn't clear, then there should be a description here.
     *
     * @return The value of the field "ecnrPassThroughMode"
     */
    inline uint8 getEcnrPassThroughMode () const;

    /**
     * Sets the value of the member "ecnrPassThroughMode".
     *
     * If the meaning of "ecnrPassThroughMode" isn't clear, then there should be a description here.
     *
     * @param ecnrPassThroughMode The value which will be set
     */
    inline void setEcnrPassThroughMode (uint8 ecnrPassThroughMode_);

    static const EcnrSetPassThroughModeRequest &getDefaultInstance();

private:

    inline void set_has_ecnrAppId ();

    inline void clear_has_ecnrAppId ();

    inline void set_has_ecnrPassThroughMode ();

    inline void clear_has_ecnrPassThroughMode ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint8 _ecnrAppId;

    uint8 _ecnrPassThroughMode;

};

/**
 * If the meaning of "EcnrSetNRCombFloorRequest" isn't clear, then there should be a description here.
 */
class EcnrSetNRCombFloorRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  EcnrSetNRCombFloorRequest ();

    /**
     * Copy constructor
     */
    inline  EcnrSetNRCombFloorRequest (const EcnrSetNRCombFloorRequest &rhs);

    /**
     * All fields constructor
     */
    inline  EcnrSetNRCombFloorRequest (uint8 ecnrAppId_, int16 ecnrNRCombFloor_);

    /**
     * Destructor
     */
    inline virtual  ~EcnrSetNRCombFloorRequest();

    /**
     * Assignment operator
     */
    inline EcnrSetNRCombFloorRequest& operator = (const EcnrSetNRCombFloorRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const EcnrSetNRCombFloorRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const EcnrSetNRCombFloorRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const EcnrSetNRCombFloorRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const EcnrSetNRCombFloorRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ecnrAppId"

    static const int kEcnrAppId = 0;

    /**
     * Clears the field "ecnrAppId".
     *
     * The field will be set to its default value. The hasEcnrAppId()
     * method will return false.
     */
    inline void clearEcnrAppId();

    /**
     * Checks whether the field "ecnrAppId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEcnrAppId()). Otherwise it will return false.
     */
    inline bool hasEcnrAppId () const;

    /**
     * Returns the value of the member "ecnrAppId".
     *
     * If the meaning of "ecnrAppId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "ecnrAppId"
     */
    inline uint8 getEcnrAppId () const;

    /**
     * Sets the value of the member "ecnrAppId".
     *
     * If the meaning of "ecnrAppId" isn't clear, then there should be a description here.
     *
     * @param ecnrAppId The value which will be set
     */
    inline void setEcnrAppId (uint8 ecnrAppId_);

    // API of field "ecnrNRCombFloor"

    static const int kEcnrNRCombFloor = 1;

    /**
     * Clears the field "ecnrNRCombFloor".
     *
     * The field will be set to its default value. The hasEcnrNRCombFloor()
     * method will return false.
     */
    inline void clearEcnrNRCombFloor();

    /**
     * Checks whether the field "ecnrNRCombFloor" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEcnrNRCombFloor()). Otherwise it will return false.
     */
    inline bool hasEcnrNRCombFloor () const;

    /**
     * Returns the value of the member "ecnrNRCombFloor".
     *
     * If the meaning of "ecnrNRCombFloor" isn't clear, then there should be a description here.
     *
     * @return The value of the field "ecnrNRCombFloor"
     */
    inline int16 getEcnrNRCombFloor () const;

    /**
     * Sets the value of the member "ecnrNRCombFloor".
     *
     * If the meaning of "ecnrNRCombFloor" isn't clear, then there should be a description here.
     *
     * @param ecnrNRCombFloor The value which will be set
     */
    inline void setEcnrNRCombFloor (int16 ecnrNRCombFloor_);

    static const EcnrSetNRCombFloorRequest &getDefaultInstance();

private:

    inline void set_has_ecnrAppId ();

    inline void clear_has_ecnrAppId ();

    inline void set_has_ecnrNRCombFloor ();

    inline void clear_has_ecnrNRCombFloor ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint8 _ecnrAppId;

    int16 _ecnrNRCombFloor;

};

/**
 * If the meaning of "EcnrSetEchoCancellationRequest" isn't clear, then there should be a description here.
 */
class EcnrSetEchoCancellationRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  EcnrSetEchoCancellationRequest ();

    /**
     * Copy constructor
     */
    inline  EcnrSetEchoCancellationRequest (const EcnrSetEchoCancellationRequest &rhs);

    /**
     * All fields constructor
     */
    inline  EcnrSetEchoCancellationRequest (uint8 ecnrAppId_, uint8 EcnrECState_);

    /**
     * Destructor
     */
    inline virtual  ~EcnrSetEchoCancellationRequest();

    /**
     * Assignment operator
     */
    inline EcnrSetEchoCancellationRequest& operator = (const EcnrSetEchoCancellationRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const EcnrSetEchoCancellationRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const EcnrSetEchoCancellationRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const EcnrSetEchoCancellationRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const EcnrSetEchoCancellationRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ecnrAppId"

    static const int kEcnrAppId = 0;

    /**
     * Clears the field "ecnrAppId".
     *
     * The field will be set to its default value. The hasEcnrAppId()
     * method will return false.
     */
    inline void clearEcnrAppId();

    /**
     * Checks whether the field "ecnrAppId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEcnrAppId()). Otherwise it will return false.
     */
    inline bool hasEcnrAppId () const;

    /**
     * Returns the value of the member "ecnrAppId".
     *
     * If the meaning of "ecnrAppId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "ecnrAppId"
     */
    inline uint8 getEcnrAppId () const;

    /**
     * Sets the value of the member "ecnrAppId".
     *
     * If the meaning of "ecnrAppId" isn't clear, then there should be a description here.
     *
     * @param ecnrAppId The value which will be set
     */
    inline void setEcnrAppId (uint8 ecnrAppId_);

    // API of field "EcnrECState"

    static const int kEcnrECState = 1;

    /**
     * Clears the field "EcnrECState".
     *
     * The field will be set to its default value. The hasEcnrECState()
     * method will return false.
     */
    inline void clearEcnrECState();

    /**
     * Checks whether the field "EcnrECState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEcnrECState()). Otherwise it will return false.
     */
    inline bool hasEcnrECState () const;

    /**
     * Returns the value of the member "EcnrECState".
     *
     * If the meaning of "EcnrECState" isn't clear, then there should be a description here.
     *
     * @return The value of the field "EcnrECState"
     */
    inline uint8 getEcnrECState () const;

    /**
     * Sets the value of the member "EcnrECState".
     *
     * If the meaning of "EcnrECState" isn't clear, then there should be a description here.
     *
     * @param EcnrECState The value which will be set
     */
    inline void setEcnrECState (uint8 EcnrECState_);

    static const EcnrSetEchoCancellationRequest &getDefaultInstance();

private:

    inline void set_has_ecnrAppId ();

    inline void clear_has_ecnrAppId ();

    inline void set_has_EcnrECState ();

    inline void clear_has_EcnrECState ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint8 _ecnrAppId;

    uint8 _EcnrECState;

};

/**
 * If the meaning of "EcnrSetNoiseReductionRequest" isn't clear, then there should be a description here.
 */
class EcnrSetNoiseReductionRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  EcnrSetNoiseReductionRequest ();

    /**
     * Copy constructor
     */
    inline  EcnrSetNoiseReductionRequest (const EcnrSetNoiseReductionRequest &rhs);

    /**
     * All fields constructor
     */
    inline  EcnrSetNoiseReductionRequest (uint8 ecnrAppId_, uint8 EcnrNRState_);

    /**
     * Destructor
     */
    inline virtual  ~EcnrSetNoiseReductionRequest();

    /**
     * Assignment operator
     */
    inline EcnrSetNoiseReductionRequest& operator = (const EcnrSetNoiseReductionRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const EcnrSetNoiseReductionRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const EcnrSetNoiseReductionRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const EcnrSetNoiseReductionRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const EcnrSetNoiseReductionRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ecnrAppId"

    static const int kEcnrAppId = 0;

    /**
     * Clears the field "ecnrAppId".
     *
     * The field will be set to its default value. The hasEcnrAppId()
     * method will return false.
     */
    inline void clearEcnrAppId();

    /**
     * Checks whether the field "ecnrAppId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEcnrAppId()). Otherwise it will return false.
     */
    inline bool hasEcnrAppId () const;

    /**
     * Returns the value of the member "ecnrAppId".
     *
     * If the meaning of "ecnrAppId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "ecnrAppId"
     */
    inline uint8 getEcnrAppId () const;

    /**
     * Sets the value of the member "ecnrAppId".
     *
     * If the meaning of "ecnrAppId" isn't clear, then there should be a description here.
     *
     * @param ecnrAppId The value which will be set
     */
    inline void setEcnrAppId (uint8 ecnrAppId_);

    // API of field "EcnrNRState"

    static const int kEcnrNRState = 1;

    /**
     * Clears the field "EcnrNRState".
     *
     * The field will be set to its default value. The hasEcnrNRState()
     * method will return false.
     */
    inline void clearEcnrNRState();

    /**
     * Checks whether the field "EcnrNRState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEcnrNRState()). Otherwise it will return false.
     */
    inline bool hasEcnrNRState () const;

    /**
     * Returns the value of the member "EcnrNRState".
     *
     * If the meaning of "EcnrNRState" isn't clear, then there should be a description here.
     *
     * @return The value of the field "EcnrNRState"
     */
    inline uint8 getEcnrNRState () const;

    /**
     * Sets the value of the member "EcnrNRState".
     *
     * If the meaning of "EcnrNRState" isn't clear, then there should be a description here.
     *
     * @param EcnrNRState The value which will be set
     */
    inline void setEcnrNRState (uint8 EcnrNRState_);

    static const EcnrSetNoiseReductionRequest &getDefaultInstance();

private:

    inline void set_has_ecnrAppId ();

    inline void clear_has_ecnrAppId ();

    inline void set_has_EcnrNRState ();

    inline void clear_has_EcnrNRState ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint8 _ecnrAppId;

    uint8 _EcnrNRState;

};

/**
 * If the meaning of "EcnrGetEngineParameterRequest" isn't clear, then there should be a description here.
 */
class EcnrGetEngineParameterRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  EcnrGetEngineParameterRequest ();

    /**
     * Copy constructor
     */
    inline  EcnrGetEngineParameterRequest (const EcnrGetEngineParameterRequest &rhs);

    /**
     * All fields constructor
     */
    inline  EcnrGetEngineParameterRequest (uint32 ecnrParameterId_);

    /**
     * Destructor
     */
    inline virtual  ~EcnrGetEngineParameterRequest();

    /**
     * Assignment operator
     */
    inline EcnrGetEngineParameterRequest& operator = (const EcnrGetEngineParameterRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const EcnrGetEngineParameterRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const EcnrGetEngineParameterRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const EcnrGetEngineParameterRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const EcnrGetEngineParameterRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ecnrParameterId"

    static const int kEcnrParameterId = 0;

    /**
     * Clears the field "ecnrParameterId".
     *
     * The field will be set to its default value. The hasEcnrParameterId()
     * method will return false.
     */
    inline void clearEcnrParameterId();

    /**
     * Checks whether the field "ecnrParameterId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEcnrParameterId()). Otherwise it will return false.
     */
    inline bool hasEcnrParameterId () const;

    /**
     * Returns the value of the member "ecnrParameterId".
     *
     * If the meaning of "ecnrParameterId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "ecnrParameterId"
     */
    inline uint32 getEcnrParameterId () const;

    /**
     * Sets the value of the member "ecnrParameterId".
     *
     * If the meaning of "ecnrParameterId" isn't clear, then there should be a description here.
     *
     * @param ecnrParameterId The value which will be set
     */
    inline void setEcnrParameterId (uint32 ecnrParameterId_);

    static const EcnrGetEngineParameterRequest &getDefaultInstance();

private:

    inline void set_has_ecnrParameterId ();

    inline void clear_has_ecnrParameterId ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _ecnrParameterId;

};

/**
 * If the meaning of "EcnrGetEngineParameterResponse" isn't clear, then there should be a description here.
 */
class EcnrGetEngineParameterResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  EcnrGetEngineParameterResponse ();

    /**
     * Copy constructor
     */
    inline  EcnrGetEngineParameterResponse (const EcnrGetEngineParameterResponse &rhs);

    /**
     * All fields constructor
     */
    inline  EcnrGetEngineParameterResponse (const ::std::vector< uint8 >& data_);

    /**
     * Destructor
     */
    inline virtual  ~EcnrGetEngineParameterResponse();

    /**
     * Assignment operator
     */
    inline EcnrGetEngineParameterResponse& operator = (const EcnrGetEngineParameterResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const EcnrGetEngineParameterResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const EcnrGetEngineParameterResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const EcnrGetEngineParameterResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const EcnrGetEngineParameterResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "data"

    static const int kData = 0;

    /**
     * Clears the field "data".
     *
     * The field will be set to its default value. The hasData()
     * method will return false.
     */
    inline void clearData();

    /**
     * Checks whether the field "data" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setData()). Otherwise it will return false.
     */
    inline bool hasData () const;

    /**
     * Returns the value of the member "data".
     *
     * If the meaning of "data" isn't clear, then there should be a description here.
     *
     * @return The value of the field "data"
     */
    inline const ::std::vector< uint8 >& getData () const;

    /**
     * Retrieves the value of the field "data" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "data".
     */
    inline ::std::vector< uint8 >& getDataMutable ();

    /**
     * Sets the value of the member "data".
     *
     * If the meaning of "data" isn't clear, then there should be a description here.
     *
     * @param data The value which will be set
     */
    inline void setData (const ::std::vector< uint8 >& data_);

    static const EcnrGetEngineParameterResponse &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_data ();

    inline void clear_has_data ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< uint8 > _data;

};

/**
 * If the meaning of "EcnrStartItcTestRequest" isn't clear, then there should be a description here.
 */
class EcnrStartItcTestRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  EcnrStartItcTestRequest ();

    /**
     * Copy constructor
     */
    inline  EcnrStartItcTestRequest (const EcnrStartItcTestRequest &rhs);

    /**
     * All fields constructor
     */
    inline  EcnrStartItcTestRequest (int32 ITCValue_);

    /**
     * Destructor
     */
    inline virtual  ~EcnrStartItcTestRequest();

    /**
     * Assignment operator
     */
    inline EcnrStartItcTestRequest& operator = (const EcnrStartItcTestRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const EcnrStartItcTestRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const EcnrStartItcTestRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const EcnrStartItcTestRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const EcnrStartItcTestRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ITCValue"

    static const int kITCValue = 0;

    /**
     * Clears the field "ITCValue".
     *
     * The field will be set to its default value. The hasITCValue()
     * method will return false.
     */
    inline void clearITCValue();

    /**
     * Checks whether the field "ITCValue" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setITCValue()). Otherwise it will return false.
     */
    inline bool hasITCValue () const;

    /**
     * Returns the value of the member "ITCValue".
     *
     * If the meaning of "ITCValue" isn't clear, then there should be a description here.
     *
     * @return The value of the field "ITCValue"
     */
    inline int32 getITCValue () const;

    /**
     * Sets the value of the member "ITCValue".
     *
     * If the meaning of "ITCValue" isn't clear, then there should be a description here.
     *
     * @param ITCValue The value which will be set
     */
    inline void setITCValue (int32 ITCValue_);

    static const EcnrStartItcTestRequest &getDefaultInstance();

private:

    inline void set_has_ITCValue ();

    inline void clear_has_ITCValue ();

    uint32 _has_bits_[ (1 + 31) / 32];

    int32 _ITCValue;

};

/**
 * If the meaning of "EcnrStartItcTestResponse" isn't clear, then there should be a description here.
 */
class EcnrStartItcTestResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  EcnrStartItcTestResponse ();

    /**
     * Copy constructor
     */
    inline  EcnrStartItcTestResponse (const EcnrStartItcTestResponse &rhs);

    /**
     * All fields constructor
     */
    inline  EcnrStartItcTestResponse (int32 rspITCValue_, uint8 TestResult_, int32 TestErrorCode_);

    /**
     * Destructor
     */
    inline virtual  ~EcnrStartItcTestResponse();

    /**
     * Assignment operator
     */
    inline EcnrStartItcTestResponse& operator = (const EcnrStartItcTestResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const EcnrStartItcTestResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const EcnrStartItcTestResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const EcnrStartItcTestResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const EcnrStartItcTestResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "rspITCValue"

    static const int kRspITCValue = 0;

    /**
     * Clears the field "rspITCValue".
     *
     * The field will be set to its default value. The hasRspITCValue()
     * method will return false.
     */
    inline void clearRspITCValue();

    /**
     * Checks whether the field "rspITCValue" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRspITCValue()). Otherwise it will return false.
     */
    inline bool hasRspITCValue () const;

    /**
     * Returns the value of the member "rspITCValue".
     *
     * If the meaning of "rspITCValue" isn't clear, then there should be a description here.
     *
     * @return The value of the field "rspITCValue"
     */
    inline int32 getRspITCValue () const;

    /**
     * Sets the value of the member "rspITCValue".
     *
     * If the meaning of "rspITCValue" isn't clear, then there should be a description here.
     *
     * @param rspITCValue The value which will be set
     */
    inline void setRspITCValue (int32 rspITCValue_);

    // API of field "TestResult"

    static const int kTestResult = 1;

    /**
     * Clears the field "TestResult".
     *
     * The field will be set to its default value. The hasTestResult()
     * method will return false.
     */
    inline void clearTestResult();

    /**
     * Checks whether the field "TestResult" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTestResult()). Otherwise it will return false.
     */
    inline bool hasTestResult () const;

    /**
     * Returns the value of the member "TestResult".
     *
     * If the meaning of "TestResult" isn't clear, then there should be a description here.
     *
     * @return The value of the field "TestResult"
     */
    inline uint8 getTestResult () const;

    /**
     * Sets the value of the member "TestResult".
     *
     * If the meaning of "TestResult" isn't clear, then there should be a description here.
     *
     * @param TestResult The value which will be set
     */
    inline void setTestResult (uint8 TestResult_);

    // API of field "TestErrorCode"

    static const int kTestErrorCode = 2;

    /**
     * Clears the field "TestErrorCode".
     *
     * The field will be set to its default value. The hasTestErrorCode()
     * method will return false.
     */
    inline void clearTestErrorCode();

    /**
     * Checks whether the field "TestErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTestErrorCode()). Otherwise it will return false.
     */
    inline bool hasTestErrorCode () const;

    /**
     * Returns the value of the member "TestErrorCode".
     *
     * If the meaning of "TestErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the field "TestErrorCode"
     */
    inline int32 getTestErrorCode () const;

    /**
     * Sets the value of the member "TestErrorCode".
     *
     * If the meaning of "TestErrorCode" isn't clear, then there should be a description here.
     *
     * @param TestErrorCode The value which will be set
     */
    inline void setTestErrorCode (int32 TestErrorCode_);

    static const EcnrStartItcTestResponse &getDefaultInstance();

private:

    inline void set_has_rspITCValue ();

    inline void clear_has_rspITCValue ();

    inline void set_has_TestResult ();

    inline void clear_has_TestResult ();

    inline void set_has_TestErrorCode ();

    inline void clear_has_TestErrorCode ();

    uint32 _has_bits_[ (3 + 31) / 32];

    int32 _rspITCValue;

    uint8 _TestResult;

    int32 _TestErrorCode;

};

/**
 * If the meaning of "EcnrMicLvlNtfyIntervalUpdate" isn't clear, then there should be a description here.
 */
class EcnrMicLvlNtfyIntervalUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  EcnrMicLvlNtfyIntervalUpdate ();

    /**
     * Copy constructor
     */
    inline  EcnrMicLvlNtfyIntervalUpdate (const EcnrMicLvlNtfyIntervalUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  EcnrMicLvlNtfyIntervalUpdate (uint32 ecnrMicLvlNtfyInterval_);

    /**
     * Destructor
     */
    inline virtual  ~EcnrMicLvlNtfyIntervalUpdate();

    /**
     * Assignment operator
     */
    inline EcnrMicLvlNtfyIntervalUpdate& operator = (const EcnrMicLvlNtfyIntervalUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const EcnrMicLvlNtfyIntervalUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const EcnrMicLvlNtfyIntervalUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const EcnrMicLvlNtfyIntervalUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const EcnrMicLvlNtfyIntervalUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ecnrMicLvlNtfyInterval"

    static const int kEcnrMicLvlNtfyInterval = 0;

    /**
     * Clears the field "ecnrMicLvlNtfyInterval".
     *
     * The field will be set to its default value. The hasEcnrMicLvlNtfyInterval()
     * method will return false.
     */
    inline void clearEcnrMicLvlNtfyInterval();

    /**
     * Checks whether the field "ecnrMicLvlNtfyInterval" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEcnrMicLvlNtfyInterval()). Otherwise it will return false.
     */
    inline bool hasEcnrMicLvlNtfyInterval () const;

    /**
     * Returns the value of the member "ecnrMicLvlNtfyInterval".
     *
     * If the meaning of "ecnrMicLvlNtfyInterval" isn't clear, then there should be a description here.
     *
     * @return The value of the field "ecnrMicLvlNtfyInterval"
     */
    inline uint32 getEcnrMicLvlNtfyInterval () const;

    /**
     * Sets the value of the member "ecnrMicLvlNtfyInterval".
     *
     * If the meaning of "ecnrMicLvlNtfyInterval" isn't clear, then there should be a description here.
     *
     * @param ecnrMicLvlNtfyInterval The value which will be set
     */
    inline void setEcnrMicLvlNtfyInterval (uint32 ecnrMicLvlNtfyInterval_);

    static const EcnrMicLvlNtfyIntervalUpdate &getDefaultInstance();

private:

    inline void set_has_ecnrMicLvlNtfyInterval ();

    inline void clear_has_ecnrMicLvlNtfyInterval ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _ecnrMicLvlNtfyInterval;

};

/**
 * If the meaning of "EcnrMicLvlNtfyIntervalRegister" isn't clear, then there should be a description here.
 */
class EcnrMicLvlNtfyIntervalRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  EcnrMicLvlNtfyIntervalRegister ();

    /**
     * Copy constructor
     */
    inline  EcnrMicLvlNtfyIntervalRegister (const EcnrMicLvlNtfyIntervalRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~EcnrMicLvlNtfyIntervalRegister();

    /**
     * Assignment operator
     */
    inline EcnrMicLvlNtfyIntervalRegister& operator = (const EcnrMicLvlNtfyIntervalRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const EcnrMicLvlNtfyIntervalRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const EcnrMicLvlNtfyIntervalRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const EcnrMicLvlNtfyIntervalRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const EcnrMicLvlNtfyIntervalRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const EcnrMicLvlNtfyIntervalRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "EcnrAsrModeUpdate" isn't clear, then there should be a description here.
 */
class EcnrAsrModeUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  EcnrAsrModeUpdate ();

    /**
     * Copy constructor
     */
    inline  EcnrAsrModeUpdate (const EcnrAsrModeUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  EcnrAsrModeUpdate (int32 ecnrAsrMode_);

    /**
     * Destructor
     */
    inline virtual  ~EcnrAsrModeUpdate();

    /**
     * Assignment operator
     */
    inline EcnrAsrModeUpdate& operator = (const EcnrAsrModeUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const EcnrAsrModeUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const EcnrAsrModeUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const EcnrAsrModeUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const EcnrAsrModeUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ecnrAsrMode"

    static const int kEcnrAsrMode = 0;

    /**
     * Clears the field "ecnrAsrMode".
     *
     * The field will be set to its default value. The hasEcnrAsrMode()
     * method will return false.
     */
    inline void clearEcnrAsrMode();

    /**
     * Checks whether the field "ecnrAsrMode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEcnrAsrMode()). Otherwise it will return false.
     */
    inline bool hasEcnrAsrMode () const;

    /**
     * Returns the value of the member "ecnrAsrMode".
     *
     * If the meaning of "ecnrAsrMode" isn't clear, then there should be a description here.
     *
     * @return The value of the field "ecnrAsrMode"
     */
    inline int32 getEcnrAsrMode () const;

    /**
     * Sets the value of the member "ecnrAsrMode".
     *
     * If the meaning of "ecnrAsrMode" isn't clear, then there should be a description here.
     *
     * @param ecnrAsrMode The value which will be set
     */
    inline void setEcnrAsrMode (int32 ecnrAsrMode_);

    static const EcnrAsrModeUpdate &getDefaultInstance();

private:

    inline void set_has_ecnrAsrMode ();

    inline void clear_has_ecnrAsrMode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    int32 _ecnrAsrMode;

};

/**
 * If the meaning of "EcnrAsrModeRegister" isn't clear, then there should be a description here.
 */
class EcnrAsrModeRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  EcnrAsrModeRegister ();

    /**
     * Copy constructor
     */
    inline  EcnrAsrModeRegister (const EcnrAsrModeRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~EcnrAsrModeRegister();

    /**
     * Assignment operator
     */
    inline EcnrAsrModeRegister& operator = (const EcnrAsrModeRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const EcnrAsrModeRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const EcnrAsrModeRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const EcnrAsrModeRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const EcnrAsrModeRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const EcnrAsrModeRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "EcnrAudioStateUpdate" isn't clear, then there should be a description here.
 */
class EcnrAudioStateUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  EcnrAudioStateUpdate ();

    /**
     * Copy constructor
     */
    inline  EcnrAudioStateUpdate (const EcnrAudioStateUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  EcnrAudioStateUpdate (int32 ecnrAudioState_);

    /**
     * Destructor
     */
    inline virtual  ~EcnrAudioStateUpdate();

    /**
     * Assignment operator
     */
    inline EcnrAudioStateUpdate& operator = (const EcnrAudioStateUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const EcnrAudioStateUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const EcnrAudioStateUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const EcnrAudioStateUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const EcnrAudioStateUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ecnrAudioState"

    static const int kEcnrAudioState = 0;

    /**
     * Clears the field "ecnrAudioState".
     *
     * The field will be set to its default value. The hasEcnrAudioState()
     * method will return false.
     */
    inline void clearEcnrAudioState();

    /**
     * Checks whether the field "ecnrAudioState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEcnrAudioState()). Otherwise it will return false.
     */
    inline bool hasEcnrAudioState () const;

    /**
     * Returns the value of the member "ecnrAudioState".
     *
     * If the meaning of "ecnrAudioState" isn't clear, then there should be a description here.
     *
     * @return The value of the field "ecnrAudioState"
     */
    inline int32 getEcnrAudioState () const;

    /**
     * Sets the value of the member "ecnrAudioState".
     *
     * If the meaning of "ecnrAudioState" isn't clear, then there should be a description here.
     *
     * @param ecnrAudioState The value which will be set
     */
    inline void setEcnrAudioState (int32 ecnrAudioState_);

    static const EcnrAudioStateUpdate &getDefaultInstance();

private:

    inline void set_has_ecnrAudioState ();

    inline void clear_has_ecnrAudioState ();

    uint32 _has_bits_[ (1 + 31) / 32];

    int32 _ecnrAudioState;

};

/**
 * If the meaning of "EcnrAudioStateRegister" isn't clear, then there should be a description here.
 */
class EcnrAudioStateRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  EcnrAudioStateRegister ();

    /**
     * Copy constructor
     */
    inline  EcnrAudioStateRegister (const EcnrAudioStateRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~EcnrAudioStateRegister();

    /**
     * Assignment operator
     */
    inline EcnrAudioStateRegister& operator = (const EcnrAudioStateRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const EcnrAudioStateRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const EcnrAudioStateRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const EcnrAudioStateRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const EcnrAudioStateRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const EcnrAudioStateRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "EcnrAsrDataTypeUpdate" isn't clear, then there should be a description here.
 */
class EcnrAsrDataTypeUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  EcnrAsrDataTypeUpdate ();

    /**
     * Copy constructor
     */
    inline  EcnrAsrDataTypeUpdate (const EcnrAsrDataTypeUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  EcnrAsrDataTypeUpdate (const ::std::vector< uint8 >& ecnrAsrDataType_);

    /**
     * Destructor
     */
    inline virtual  ~EcnrAsrDataTypeUpdate();

    /**
     * Assignment operator
     */
    inline EcnrAsrDataTypeUpdate& operator = (const EcnrAsrDataTypeUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const EcnrAsrDataTypeUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const EcnrAsrDataTypeUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const EcnrAsrDataTypeUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const EcnrAsrDataTypeUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ecnrAsrDataType"

    static const int kEcnrAsrDataType = 0;

    /**
     * Clears the field "ecnrAsrDataType".
     *
     * The field will be set to its default value. The hasEcnrAsrDataType()
     * method will return false.
     */
    inline void clearEcnrAsrDataType();

    /**
     * Checks whether the field "ecnrAsrDataType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEcnrAsrDataType()). Otherwise it will return false.
     */
    inline bool hasEcnrAsrDataType () const;

    /**
     * Returns the value of the member "ecnrAsrDataType".
     *
     * If the meaning of "ecnrAsrDataType" isn't clear, then there should be a description here.
     *
     * @return The value of the field "ecnrAsrDataType"
     */
    inline const ::std::vector< uint8 >& getEcnrAsrDataType () const;

    /**
     * Retrieves the value of the field "ecnrAsrDataType" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ecnrAsrDataType".
     */
    inline ::std::vector< uint8 >& getEcnrAsrDataTypeMutable ();

    /**
     * Sets the value of the member "ecnrAsrDataType".
     *
     * If the meaning of "ecnrAsrDataType" isn't clear, then there should be a description here.
     *
     * @param ecnrAsrDataType The value which will be set
     */
    inline void setEcnrAsrDataType (const ::std::vector< uint8 >& ecnrAsrDataType_);

    static const EcnrAsrDataTypeUpdate &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_ecnrAsrDataType ();

    inline void clear_has_ecnrAsrDataType ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< uint8 > _ecnrAsrDataType;

};

/**
 * If the meaning of "EcnrAsrDataTypeRegister" isn't clear, then there should be a description here.
 */
class EcnrAsrDataTypeRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  EcnrAsrDataTypeRegister ();

    /**
     * Copy constructor
     */
    inline  EcnrAsrDataTypeRegister (const EcnrAsrDataTypeRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~EcnrAsrDataTypeRegister();

    /**
     * Assignment operator
     */
    inline EcnrAsrDataTypeRegister& operator = (const EcnrAsrDataTypeRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const EcnrAsrDataTypeRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const EcnrAsrDataTypeRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const EcnrAsrDataTypeRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const EcnrAsrDataTypeRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const EcnrAsrDataTypeRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "EcnrAsrModeEnableSignal" isn't clear, then there should be a description here.
 */
class EcnrAsrModeEnableSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  EcnrAsrModeEnableSignal ();

    /**
     * Copy constructor
     */
    inline  EcnrAsrModeEnableSignal (const EcnrAsrModeEnableSignal &rhs);

    /**
     * All fields constructor
     */
    inline  EcnrAsrModeEnableSignal (int32 StatusAsrMode_);

    /**
     * Destructor
     */
    inline virtual  ~EcnrAsrModeEnableSignal();

    /**
     * Assignment operator
     */
    inline EcnrAsrModeEnableSignal& operator = (const EcnrAsrModeEnableSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const EcnrAsrModeEnableSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const EcnrAsrModeEnableSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const EcnrAsrModeEnableSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const EcnrAsrModeEnableSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "StatusAsrMode"

    static const int kStatusAsrMode = 0;

    /**
     * Clears the field "StatusAsrMode".
     *
     * The field will be set to its default value. The hasStatusAsrMode()
     * method will return false.
     */
    inline void clearStatusAsrMode();

    /**
     * Checks whether the field "StatusAsrMode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatusAsrMode()). Otherwise it will return false.
     */
    inline bool hasStatusAsrMode () const;

    /**
     * Returns the value of the member "StatusAsrMode".
     *
     * If the meaning of "StatusAsrMode" isn't clear, then there should be a description here.
     *
     * @return The value of the field "StatusAsrMode"
     */
    inline int32 getStatusAsrMode () const;

    /**
     * Sets the value of the member "StatusAsrMode".
     *
     * If the meaning of "StatusAsrMode" isn't clear, then there should be a description here.
     *
     * @param StatusAsrMode The value which will be set
     */
    inline void setStatusAsrMode (int32 StatusAsrMode_);

    static const EcnrAsrModeEnableSignal &getDefaultInstance();

private:

    inline void set_has_StatusAsrMode ();

    inline void clear_has_StatusAsrMode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    int32 _StatusAsrMode;

};

/**
 * If the meaning of "EcnrAudioStatusSignal" isn't clear, then there should be a description here.
 */
class EcnrAudioStatusSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  EcnrAudioStatusSignal ();

    /**
     * Copy constructor
     */
    inline  EcnrAudioStatusSignal (const EcnrAudioStatusSignal &rhs);

    /**
     * All fields constructor
     */
    inline  EcnrAudioStatusSignal (int32 AudioStatus_);

    /**
     * Destructor
     */
    inline virtual  ~EcnrAudioStatusSignal();

    /**
     * Assignment operator
     */
    inline EcnrAudioStatusSignal& operator = (const EcnrAudioStatusSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const EcnrAudioStatusSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const EcnrAudioStatusSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const EcnrAudioStatusSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const EcnrAudioStatusSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "AudioStatus"

    static const int kAudioStatus = 0;

    /**
     * Clears the field "AudioStatus".
     *
     * The field will be set to its default value. The hasAudioStatus()
     * method will return false.
     */
    inline void clearAudioStatus();

    /**
     * Checks whether the field "AudioStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAudioStatus()). Otherwise it will return false.
     */
    inline bool hasAudioStatus () const;

    /**
     * Returns the value of the member "AudioStatus".
     *
     * If the meaning of "AudioStatus" isn't clear, then there should be a description here.
     *
     * @return The value of the field "AudioStatus"
     */
    inline int32 getAudioStatus () const;

    /**
     * Sets the value of the member "AudioStatus".
     *
     * If the meaning of "AudioStatus" isn't clear, then there should be a description here.
     *
     * @param AudioStatus The value which will be set
     */
    inline void setAudioStatus (int32 AudioStatus_);

    static const EcnrAudioStatusSignal &getDefaultInstance();

private:

    inline void set_has_AudioStatus ();

    inline void clear_has_AudioStatus ();

    uint32 _has_bits_[ (1 + 31) / 32];

    int32 _AudioStatus;

};

/**
 * If the meaning of "EcnrMicroLevelStatusSignal" isn't clear, then there should be a description here.
 */
class EcnrMicroLevelStatusSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  EcnrMicroLevelStatusSignal ();

    /**
     * Copy constructor
     */
    inline  EcnrMicroLevelStatusSignal (const EcnrMicroLevelStatusSignal &rhs);

    /**
     * All fields constructor
     */
    inline  EcnrMicroLevelStatusSignal (uint32 StatusMicroLevel_);

    /**
     * Destructor
     */
    inline virtual  ~EcnrMicroLevelStatusSignal();

    /**
     * Assignment operator
     */
    inline EcnrMicroLevelStatusSignal& operator = (const EcnrMicroLevelStatusSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const EcnrMicroLevelStatusSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const EcnrMicroLevelStatusSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const EcnrMicroLevelStatusSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const EcnrMicroLevelStatusSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "StatusMicroLevel"

    static const int kStatusMicroLevel = 0;

    /**
     * Clears the field "StatusMicroLevel".
     *
     * The field will be set to its default value. The hasStatusMicroLevel()
     * method will return false.
     */
    inline void clearStatusMicroLevel();

    /**
     * Checks whether the field "StatusMicroLevel" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatusMicroLevel()). Otherwise it will return false.
     */
    inline bool hasStatusMicroLevel () const;

    /**
     * Returns the value of the member "StatusMicroLevel".
     *
     * If the meaning of "StatusMicroLevel" isn't clear, then there should be a description here.
     *
     * @return The value of the field "StatusMicroLevel"
     */
    inline uint32 getStatusMicroLevel () const;

    /**
     * Sets the value of the member "StatusMicroLevel".
     *
     * If the meaning of "StatusMicroLevel" isn't clear, then there should be a description here.
     *
     * @param StatusMicroLevel The value which will be set
     */
    inline void setStatusMicroLevel (uint32 StatusMicroLevel_);

    static const EcnrMicroLevelStatusSignal &getDefaultInstance();

private:

    inline void set_has_StatusMicroLevel ();

    inline void clear_has_StatusMicroLevel ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _StatusMicroLevel;

};

inline  EcnrGetVersionResponse::EcnrGetVersionResponse ()  :
    _Version (),
    _VersionString (),
    _VersionComment ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  EcnrGetVersionResponse::EcnrGetVersionResponse (const EcnrGetVersionResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _Version (),
    _VersionString (),
    _VersionComment ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  EcnrGetVersionResponse::EcnrGetVersionResponse (const ::std::vector< uint32 >& Version_, const ::std::string& VersionString_, const ::std::string& VersionComment_)  :
    _Version (Version_),
    _VersionString (VersionString_),
    _VersionComment (VersionComment_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (VersionString_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (VersionComment_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  EcnrGetVersionResponse::~EcnrGetVersionResponse() {
}

inline EcnrGetVersionResponse& EcnrGetVersionResponse::operator = (const EcnrGetVersionResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasVersion()) {
            setVersion(rhs.getVersion());
        } else {
            clearVersion();
        }
        if (rhs.hasVersionString()) {
            setVersionString(rhs.getVersionString());
        } else {
            clearVersionString();
        }
        if (rhs.hasVersionComment()) {
            setVersionComment(rhs.getVersionComment());
        } else {
            clearVersionComment();
        }
    }
    return *this;
}

inline bool EcnrGetVersionResponse::operator == (const EcnrGetVersionResponse& rhs) const {
    return (((!hasVersion() && !rhs.hasVersion()) || getVersion() == rhs.getVersion()) &&
        ((!hasVersionString() && !rhs.hasVersionString()) || getVersionString() == rhs.getVersionString()) &&
        ((!hasVersionComment() && !rhs.hasVersionComment()) || getVersionComment() == rhs.getVersionComment()));
}

inline bool EcnrGetVersionResponse::operator != (const EcnrGetVersionResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool EcnrGetVersionResponse::operator < (const EcnrGetVersionResponse& rhs) const {
    if (hasVersion() || rhs.hasVersion()) {
        if (getVersion() < rhs.getVersion()) return true;
        if (getVersion() > rhs.getVersion()) return false;
    }
    if (hasVersionString() || rhs.hasVersionString()) {
        if (getVersionString() < rhs.getVersionString()) return true;
        if (getVersionString() > rhs.getVersionString()) return false;
    }
    if (hasVersionComment() || rhs.hasVersionComment()) {
        if (getVersionComment() < rhs.getVersionComment()) return true;
        if (getVersionComment() > rhs.getVersionComment()) return false;
    }
    return false;
}

inline ::asf::core::Payload* EcnrGetVersionResponse::clone() {
    return new EcnrGetVersionResponse(*this);
}

inline bool EcnrGetVersionResponse::operator > (const EcnrGetVersionResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void EcnrGetVersionResponse::clear() {
    clearVersion();
    clearVersionString();
    clearVersionComment();
}

inline void EcnrGetVersionResponse::clearVersion() {
    if (hasVersion()) {
         clear_has_Version();
        _Version.clear();
     }
}

inline bool EcnrGetVersionResponse::hasVersion () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< uint32 >& EcnrGetVersionResponse::getVersion () const {
    return _Version;
}

inline ::std::vector< uint32 >& EcnrGetVersionResponse::getVersionMutable () {
    set_has_Version();
    return _Version;
}

inline void EcnrGetVersionResponse::setVersion (const ::std::vector< uint32 >& Version_) {
    set_has_Version();
    this->_Version = Version_;
}

inline void EcnrGetVersionResponse::clearVersionString() {
    if (hasVersionString()) {
         clear_has_VersionString();
        _VersionString.clear();
     }
}

inline bool EcnrGetVersionResponse::hasVersionString () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& EcnrGetVersionResponse::getVersionString () const {
    return _VersionString;
}

inline ::std::string& EcnrGetVersionResponse::getVersionStringMutable () {
    set_has_VersionString();
    return _VersionString;
}

inline void EcnrGetVersionResponse::setVersionString (const ::std::string& VersionString_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (VersionString_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_VersionString();
    this->_VersionString = VersionString_;
}

inline void EcnrGetVersionResponse::setVersionString (const char* VersionString_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (VersionString_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_VersionString();
    this->_VersionString.assign(VersionString_);
}

inline void EcnrGetVersionResponse::setVersionString (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_VersionString();
    this->_VersionString.assign(value, size);
}

inline void EcnrGetVersionResponse::clearVersionComment() {
    if (hasVersionComment()) {
         clear_has_VersionComment();
        _VersionComment.clear();
     }
}

inline bool EcnrGetVersionResponse::hasVersionComment () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::string& EcnrGetVersionResponse::getVersionComment () const {
    return _VersionComment;
}

inline ::std::string& EcnrGetVersionResponse::getVersionCommentMutable () {
    set_has_VersionComment();
    return _VersionComment;
}

inline void EcnrGetVersionResponse::setVersionComment (const ::std::string& VersionComment_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (VersionComment_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_VersionComment();
    this->_VersionComment = VersionComment_;
}

inline void EcnrGetVersionResponse::setVersionComment (const char* VersionComment_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (VersionComment_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_VersionComment();
    this->_VersionComment.assign(VersionComment_);
}

inline void EcnrGetVersionResponse::setVersionComment (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_VersionComment();
    this->_VersionComment.assign(value, size);
}

inline void EcnrGetVersionResponse::set_has_Version () {
    _has_bits_[0] |= 1u << 0;
}

inline void EcnrGetVersionResponse::clear_has_Version () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void EcnrGetVersionResponse::set_has_VersionString () {
    _has_bits_[0] |= 1u << 1;
}

inline void EcnrGetVersionResponse::clear_has_VersionString () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void EcnrGetVersionResponse::set_has_VersionComment () {
    _has_bits_[0] |= 1u << 2;
}

inline void EcnrGetVersionResponse::clear_has_VersionComment () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  EcnrGetStatusMessageRequest::EcnrGetStatusMessageRequest ()  :
    _ecnrAppId (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  EcnrGetStatusMessageRequest::EcnrGetStatusMessageRequest (const EcnrGetStatusMessageRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _ecnrAppId (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  EcnrGetStatusMessageRequest::EcnrGetStatusMessageRequest (uint8 ecnrAppId_)  :
    _ecnrAppId (ecnrAppId_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  EcnrGetStatusMessageRequest::~EcnrGetStatusMessageRequest() {
}

inline EcnrGetStatusMessageRequest& EcnrGetStatusMessageRequest::operator = (const EcnrGetStatusMessageRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasEcnrAppId()) {
            setEcnrAppId(rhs.getEcnrAppId());
        } else {
            clearEcnrAppId();
        }
    }
    return *this;
}

inline bool EcnrGetStatusMessageRequest::operator == (const EcnrGetStatusMessageRequest& rhs) const {
    return (((!hasEcnrAppId() && !rhs.hasEcnrAppId()) || getEcnrAppId() == rhs.getEcnrAppId()));
}

inline bool EcnrGetStatusMessageRequest::operator != (const EcnrGetStatusMessageRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool EcnrGetStatusMessageRequest::operator < (const EcnrGetStatusMessageRequest& rhs) const {
    if (hasEcnrAppId() || rhs.hasEcnrAppId()) {
        if (getEcnrAppId() < rhs.getEcnrAppId()) return true;
        if (getEcnrAppId() > rhs.getEcnrAppId()) return false;
    }
    return false;
}

inline ::asf::core::Payload* EcnrGetStatusMessageRequest::clone() {
    return new EcnrGetStatusMessageRequest(*this);
}

inline bool EcnrGetStatusMessageRequest::operator > (const EcnrGetStatusMessageRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void EcnrGetStatusMessageRequest::clear() {
    clearEcnrAppId();
}

inline void EcnrGetStatusMessageRequest::clearEcnrAppId() {
    if (hasEcnrAppId()) {
         clear_has_ecnrAppId();
        _ecnrAppId = 0u;
     }
}

inline bool EcnrGetStatusMessageRequest::hasEcnrAppId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 EcnrGetStatusMessageRequest::getEcnrAppId () const {
    return _ecnrAppId;
}

inline void EcnrGetStatusMessageRequest::setEcnrAppId (uint8 ecnrAppId_) {
    set_has_ecnrAppId();
    this->_ecnrAppId = ecnrAppId_;
}

inline void EcnrGetStatusMessageRequest::set_has_ecnrAppId () {
    _has_bits_[0] |= 1u << 0;
}

inline void EcnrGetStatusMessageRequest::clear_has_ecnrAppId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  EcnrGetStatusMessageResponse::EcnrGetStatusMessageResponse ()  :
    _StatusMessage ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  EcnrGetStatusMessageResponse::EcnrGetStatusMessageResponse (const EcnrGetStatusMessageResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _StatusMessage ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  EcnrGetStatusMessageResponse::EcnrGetStatusMessageResponse (const ::std::string& StatusMessage_)  :
    _StatusMessage (StatusMessage_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (StatusMessage_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  EcnrGetStatusMessageResponse::~EcnrGetStatusMessageResponse() {
}

inline EcnrGetStatusMessageResponse& EcnrGetStatusMessageResponse::operator = (const EcnrGetStatusMessageResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasStatusMessage()) {
            setStatusMessage(rhs.getStatusMessage());
        } else {
            clearStatusMessage();
        }
    }
    return *this;
}

inline bool EcnrGetStatusMessageResponse::operator == (const EcnrGetStatusMessageResponse& rhs) const {
    return (((!hasStatusMessage() && !rhs.hasStatusMessage()) || getStatusMessage() == rhs.getStatusMessage()));
}

inline bool EcnrGetStatusMessageResponse::operator != (const EcnrGetStatusMessageResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool EcnrGetStatusMessageResponse::operator < (const EcnrGetStatusMessageResponse& rhs) const {
    if (hasStatusMessage() || rhs.hasStatusMessage()) {
        if (getStatusMessage() < rhs.getStatusMessage()) return true;
        if (getStatusMessage() > rhs.getStatusMessage()) return false;
    }
    return false;
}

inline ::asf::core::Payload* EcnrGetStatusMessageResponse::clone() {
    return new EcnrGetStatusMessageResponse(*this);
}

inline bool EcnrGetStatusMessageResponse::operator > (const EcnrGetStatusMessageResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void EcnrGetStatusMessageResponse::clear() {
    clearStatusMessage();
}

inline void EcnrGetStatusMessageResponse::clearStatusMessage() {
    if (hasStatusMessage()) {
         clear_has_StatusMessage();
        _StatusMessage.clear();
     }
}

inline bool EcnrGetStatusMessageResponse::hasStatusMessage () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& EcnrGetStatusMessageResponse::getStatusMessage () const {
    return _StatusMessage;
}

inline ::std::string& EcnrGetStatusMessageResponse::getStatusMessageMutable () {
    set_has_StatusMessage();
    return _StatusMessage;
}

inline void EcnrGetStatusMessageResponse::setStatusMessage (const ::std::string& StatusMessage_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (StatusMessage_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_StatusMessage();
    this->_StatusMessage = StatusMessage_;
}

inline void EcnrGetStatusMessageResponse::setStatusMessage (const char* StatusMessage_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (StatusMessage_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_StatusMessage();
    this->_StatusMessage.assign(StatusMessage_);
}

inline void EcnrGetStatusMessageResponse::setStatusMessage (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_StatusMessage();
    this->_StatusMessage.assign(value, size);
}

inline void EcnrGetStatusMessageResponse::set_has_StatusMessage () {
    _has_bits_[0] |= 1u << 0;
}

inline void EcnrGetStatusMessageResponse::clear_has_StatusMessage () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  EcnrInitializeRequest::EcnrInitializeRequest ()  :
    _ecnrAppId (0u),
    _ecnrConfigurationId (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  EcnrInitializeRequest::EcnrInitializeRequest (const EcnrInitializeRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _ecnrAppId (0u),
    _ecnrConfigurationId (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  EcnrInitializeRequest::EcnrInitializeRequest (uint8 ecnrAppId_, uint32 ecnrConfigurationId_)  :
    _ecnrAppId (ecnrAppId_),
    _ecnrConfigurationId (ecnrConfigurationId_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  EcnrInitializeRequest::~EcnrInitializeRequest() {
}

inline EcnrInitializeRequest& EcnrInitializeRequest::operator = (const EcnrInitializeRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasEcnrAppId()) {
            setEcnrAppId(rhs.getEcnrAppId());
        } else {
            clearEcnrAppId();
        }
        if (rhs.hasEcnrConfigurationId()) {
            setEcnrConfigurationId(rhs.getEcnrConfigurationId());
        } else {
            clearEcnrConfigurationId();
        }
    }
    return *this;
}

inline bool EcnrInitializeRequest::operator == (const EcnrInitializeRequest& rhs) const {
    return (((!hasEcnrAppId() && !rhs.hasEcnrAppId()) || getEcnrAppId() == rhs.getEcnrAppId()) &&
        ((!hasEcnrConfigurationId() && !rhs.hasEcnrConfigurationId()) || getEcnrConfigurationId() == rhs.getEcnrConfigurationId()));
}

inline bool EcnrInitializeRequest::operator != (const EcnrInitializeRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool EcnrInitializeRequest::operator < (const EcnrInitializeRequest& rhs) const {
    if (hasEcnrAppId() || rhs.hasEcnrAppId()) {
        if (getEcnrAppId() < rhs.getEcnrAppId()) return true;
        if (getEcnrAppId() > rhs.getEcnrAppId()) return false;
    }
    if (hasEcnrConfigurationId() || rhs.hasEcnrConfigurationId()) {
        if (getEcnrConfigurationId() < rhs.getEcnrConfigurationId()) return true;
        if (getEcnrConfigurationId() > rhs.getEcnrConfigurationId()) return false;
    }
    return false;
}

inline ::asf::core::Payload* EcnrInitializeRequest::clone() {
    return new EcnrInitializeRequest(*this);
}

inline bool EcnrInitializeRequest::operator > (const EcnrInitializeRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void EcnrInitializeRequest::clear() {
    clearEcnrAppId();
    clearEcnrConfigurationId();
}

inline void EcnrInitializeRequest::clearEcnrAppId() {
    if (hasEcnrAppId()) {
         clear_has_ecnrAppId();
        _ecnrAppId = 0u;
     }
}

inline bool EcnrInitializeRequest::hasEcnrAppId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 EcnrInitializeRequest::getEcnrAppId () const {
    return _ecnrAppId;
}

inline void EcnrInitializeRequest::setEcnrAppId (uint8 ecnrAppId_) {
    set_has_ecnrAppId();
    this->_ecnrAppId = ecnrAppId_;
}

inline void EcnrInitializeRequest::clearEcnrConfigurationId() {
    if (hasEcnrConfigurationId()) {
         clear_has_ecnrConfigurationId();
        _ecnrConfigurationId = 0u;
     }
}

inline bool EcnrInitializeRequest::hasEcnrConfigurationId () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 EcnrInitializeRequest::getEcnrConfigurationId () const {
    return _ecnrConfigurationId;
}

inline void EcnrInitializeRequest::setEcnrConfigurationId (uint32 ecnrConfigurationId_) {
    set_has_ecnrConfigurationId();
    this->_ecnrConfigurationId = ecnrConfigurationId_;
}

inline void EcnrInitializeRequest::set_has_ecnrAppId () {
    _has_bits_[0] |= 1u << 0;
}

inline void EcnrInitializeRequest::clear_has_ecnrAppId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void EcnrInitializeRequest::set_has_ecnrConfigurationId () {
    _has_bits_[0] |= 1u << 1;
}

inline void EcnrInitializeRequest::clear_has_ecnrConfigurationId () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  EcnrInitializeSyncRequest::EcnrInitializeSyncRequest ()  :
    _ecnrAppId (0u),
    _ecnrConfigurationId (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  EcnrInitializeSyncRequest::EcnrInitializeSyncRequest (const EcnrInitializeSyncRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _ecnrAppId (0u),
    _ecnrConfigurationId (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  EcnrInitializeSyncRequest::EcnrInitializeSyncRequest (uint8 ecnrAppId_, uint32 ecnrConfigurationId_)  :
    _ecnrAppId (ecnrAppId_),
    _ecnrConfigurationId (ecnrConfigurationId_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  EcnrInitializeSyncRequest::~EcnrInitializeSyncRequest() {
}

inline EcnrInitializeSyncRequest& EcnrInitializeSyncRequest::operator = (const EcnrInitializeSyncRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasEcnrAppId()) {
            setEcnrAppId(rhs.getEcnrAppId());
        } else {
            clearEcnrAppId();
        }
        if (rhs.hasEcnrConfigurationId()) {
            setEcnrConfigurationId(rhs.getEcnrConfigurationId());
        } else {
            clearEcnrConfigurationId();
        }
    }
    return *this;
}

inline bool EcnrInitializeSyncRequest::operator == (const EcnrInitializeSyncRequest& rhs) const {
    return (((!hasEcnrAppId() && !rhs.hasEcnrAppId()) || getEcnrAppId() == rhs.getEcnrAppId()) &&
        ((!hasEcnrConfigurationId() && !rhs.hasEcnrConfigurationId()) || getEcnrConfigurationId() == rhs.getEcnrConfigurationId()));
}

inline bool EcnrInitializeSyncRequest::operator != (const EcnrInitializeSyncRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool EcnrInitializeSyncRequest::operator < (const EcnrInitializeSyncRequest& rhs) const {
    if (hasEcnrAppId() || rhs.hasEcnrAppId()) {
        if (getEcnrAppId() < rhs.getEcnrAppId()) return true;
        if (getEcnrAppId() > rhs.getEcnrAppId()) return false;
    }
    if (hasEcnrConfigurationId() || rhs.hasEcnrConfigurationId()) {
        if (getEcnrConfigurationId() < rhs.getEcnrConfigurationId()) return true;
        if (getEcnrConfigurationId() > rhs.getEcnrConfigurationId()) return false;
    }
    return false;
}

inline ::asf::core::Payload* EcnrInitializeSyncRequest::clone() {
    return new EcnrInitializeSyncRequest(*this);
}

inline bool EcnrInitializeSyncRequest::operator > (const EcnrInitializeSyncRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void EcnrInitializeSyncRequest::clear() {
    clearEcnrAppId();
    clearEcnrConfigurationId();
}

inline void EcnrInitializeSyncRequest::clearEcnrAppId() {
    if (hasEcnrAppId()) {
         clear_has_ecnrAppId();
        _ecnrAppId = 0u;
     }
}

inline bool EcnrInitializeSyncRequest::hasEcnrAppId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 EcnrInitializeSyncRequest::getEcnrAppId () const {
    return _ecnrAppId;
}

inline void EcnrInitializeSyncRequest::setEcnrAppId (uint8 ecnrAppId_) {
    set_has_ecnrAppId();
    this->_ecnrAppId = ecnrAppId_;
}

inline void EcnrInitializeSyncRequest::clearEcnrConfigurationId() {
    if (hasEcnrConfigurationId()) {
         clear_has_ecnrConfigurationId();
        _ecnrConfigurationId = 0u;
     }
}

inline bool EcnrInitializeSyncRequest::hasEcnrConfigurationId () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 EcnrInitializeSyncRequest::getEcnrConfigurationId () const {
    return _ecnrConfigurationId;
}

inline void EcnrInitializeSyncRequest::setEcnrConfigurationId (uint32 ecnrConfigurationId_) {
    set_has_ecnrConfigurationId();
    this->_ecnrConfigurationId = ecnrConfigurationId_;
}

inline void EcnrInitializeSyncRequest::set_has_ecnrAppId () {
    _has_bits_[0] |= 1u << 0;
}

inline void EcnrInitializeSyncRequest::clear_has_ecnrAppId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void EcnrInitializeSyncRequest::set_has_ecnrConfigurationId () {
    _has_bits_[0] |= 1u << 1;
}

inline void EcnrInitializeSyncRequest::clear_has_ecnrConfigurationId () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  EcnrInitializeSyncResponse::EcnrInitializeSyncResponse ()  :
    _InDevices (),
    _OutDevices (),
    _DeviceProperties ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  EcnrInitializeSyncResponse::EcnrInitializeSyncResponse (const EcnrInitializeSyncResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _InDevices (),
    _OutDevices (),
    _DeviceProperties ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  EcnrInitializeSyncResponse::EcnrInitializeSyncResponse (const ::std::vector< ::std::string >& InDevices_, const ::std::vector< ::std::string >& OutDevices_, const ::std::vector< uint32 >& DeviceProperties_)  :
    _InDevices (InDevices_),
    _OutDevices (OutDevices_),
    _DeviceProperties (DeviceProperties_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  EcnrInitializeSyncResponse::~EcnrInitializeSyncResponse() {
}

inline EcnrInitializeSyncResponse& EcnrInitializeSyncResponse::operator = (const EcnrInitializeSyncResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasInDevices()) {
            setInDevices(rhs.getInDevices());
        } else {
            clearInDevices();
        }
        if (rhs.hasOutDevices()) {
            setOutDevices(rhs.getOutDevices());
        } else {
            clearOutDevices();
        }
        if (rhs.hasDeviceProperties()) {
            setDeviceProperties(rhs.getDeviceProperties());
        } else {
            clearDeviceProperties();
        }
    }
    return *this;
}

inline bool EcnrInitializeSyncResponse::operator == (const EcnrInitializeSyncResponse& rhs) const {
    return (((!hasInDevices() && !rhs.hasInDevices()) || getInDevices() == rhs.getInDevices()) &&
        ((!hasOutDevices() && !rhs.hasOutDevices()) || getOutDevices() == rhs.getOutDevices()) &&
        ((!hasDeviceProperties() && !rhs.hasDeviceProperties()) || getDeviceProperties() == rhs.getDeviceProperties()));
}

inline bool EcnrInitializeSyncResponse::operator != (const EcnrInitializeSyncResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool EcnrInitializeSyncResponse::operator < (const EcnrInitializeSyncResponse& rhs) const {
    if (hasInDevices() || rhs.hasInDevices()) {
        if (getInDevices() < rhs.getInDevices()) return true;
        if (getInDevices() > rhs.getInDevices()) return false;
    }
    if (hasOutDevices() || rhs.hasOutDevices()) {
        if (getOutDevices() < rhs.getOutDevices()) return true;
        if (getOutDevices() > rhs.getOutDevices()) return false;
    }
    if (hasDeviceProperties() || rhs.hasDeviceProperties()) {
        if (getDeviceProperties() < rhs.getDeviceProperties()) return true;
        if (getDeviceProperties() > rhs.getDeviceProperties()) return false;
    }
    return false;
}

inline ::asf::core::Payload* EcnrInitializeSyncResponse::clone() {
    return new EcnrInitializeSyncResponse(*this);
}

inline bool EcnrInitializeSyncResponse::operator > (const EcnrInitializeSyncResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void EcnrInitializeSyncResponse::clear() {
    clearInDevices();
    clearOutDevices();
    clearDeviceProperties();
}

inline void EcnrInitializeSyncResponse::clearInDevices() {
    if (hasInDevices()) {
         clear_has_InDevices();
        _InDevices.clear();
     }
}

inline bool EcnrInitializeSyncResponse::hasInDevices () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< ::std::string >& EcnrInitializeSyncResponse::getInDevices () const {
    return _InDevices;
}

inline ::std::vector< ::std::string >& EcnrInitializeSyncResponse::getInDevicesMutable () {
    set_has_InDevices();
    return _InDevices;
}

inline void EcnrInitializeSyncResponse::setInDevices (const ::std::vector< ::std::string >& InDevices_) {
    set_has_InDevices();
    this->_InDevices = InDevices_;
}

inline void EcnrInitializeSyncResponse::clearOutDevices() {
    if (hasOutDevices()) {
         clear_has_OutDevices();
        _OutDevices.clear();
     }
}

inline bool EcnrInitializeSyncResponse::hasOutDevices () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::vector< ::std::string >& EcnrInitializeSyncResponse::getOutDevices () const {
    return _OutDevices;
}

inline ::std::vector< ::std::string >& EcnrInitializeSyncResponse::getOutDevicesMutable () {
    set_has_OutDevices();
    return _OutDevices;
}

inline void EcnrInitializeSyncResponse::setOutDevices (const ::std::vector< ::std::string >& OutDevices_) {
    set_has_OutDevices();
    this->_OutDevices = OutDevices_;
}

inline void EcnrInitializeSyncResponse::clearDeviceProperties() {
    if (hasDeviceProperties()) {
         clear_has_DeviceProperties();
        _DeviceProperties.clear();
     }
}

inline bool EcnrInitializeSyncResponse::hasDeviceProperties () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::vector< uint32 >& EcnrInitializeSyncResponse::getDeviceProperties () const {
    return _DeviceProperties;
}

inline ::std::vector< uint32 >& EcnrInitializeSyncResponse::getDevicePropertiesMutable () {
    set_has_DeviceProperties();
    return _DeviceProperties;
}

inline void EcnrInitializeSyncResponse::setDeviceProperties (const ::std::vector< uint32 >& DeviceProperties_) {
    set_has_DeviceProperties();
    this->_DeviceProperties = DeviceProperties_;
}

inline void EcnrInitializeSyncResponse::set_has_InDevices () {
    _has_bits_[0] |= 1u << 0;
}

inline void EcnrInitializeSyncResponse::clear_has_InDevices () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void EcnrInitializeSyncResponse::set_has_OutDevices () {
    _has_bits_[0] |= 1u << 1;
}

inline void EcnrInitializeSyncResponse::clear_has_OutDevices () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void EcnrInitializeSyncResponse::set_has_DeviceProperties () {
    _has_bits_[0] |= 1u << 2;
}

inline void EcnrInitializeSyncResponse::clear_has_DeviceProperties () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  EcnrResetRequest::EcnrResetRequest ()  :
    _ecnrAppId (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  EcnrResetRequest::EcnrResetRequest (const EcnrResetRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _ecnrAppId (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  EcnrResetRequest::EcnrResetRequest (uint8 ecnrAppId_)  :
    _ecnrAppId (ecnrAppId_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  EcnrResetRequest::~EcnrResetRequest() {
}

inline EcnrResetRequest& EcnrResetRequest::operator = (const EcnrResetRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasEcnrAppId()) {
            setEcnrAppId(rhs.getEcnrAppId());
        } else {
            clearEcnrAppId();
        }
    }
    return *this;
}

inline bool EcnrResetRequest::operator == (const EcnrResetRequest& rhs) const {
    return (((!hasEcnrAppId() && !rhs.hasEcnrAppId()) || getEcnrAppId() == rhs.getEcnrAppId()));
}

inline bool EcnrResetRequest::operator != (const EcnrResetRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool EcnrResetRequest::operator < (const EcnrResetRequest& rhs) const {
    if (hasEcnrAppId() || rhs.hasEcnrAppId()) {
        if (getEcnrAppId() < rhs.getEcnrAppId()) return true;
        if (getEcnrAppId() > rhs.getEcnrAppId()) return false;
    }
    return false;
}

inline ::asf::core::Payload* EcnrResetRequest::clone() {
    return new EcnrResetRequest(*this);
}

inline bool EcnrResetRequest::operator > (const EcnrResetRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void EcnrResetRequest::clear() {
    clearEcnrAppId();
}

inline void EcnrResetRequest::clearEcnrAppId() {
    if (hasEcnrAppId()) {
         clear_has_ecnrAppId();
        _ecnrAppId = 0u;
     }
}

inline bool EcnrResetRequest::hasEcnrAppId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 EcnrResetRequest::getEcnrAppId () const {
    return _ecnrAppId;
}

inline void EcnrResetRequest::setEcnrAppId (uint8 ecnrAppId_) {
    set_has_ecnrAppId();
    this->_ecnrAppId = ecnrAppId_;
}

inline void EcnrResetRequest::set_has_ecnrAppId () {
    _has_bits_[0] |= 1u << 0;
}

inline void EcnrResetRequest::clear_has_ecnrAppId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  EcnrDestroyRequest::EcnrDestroyRequest ()  :
    _ecnrAppId (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  EcnrDestroyRequest::EcnrDestroyRequest (const EcnrDestroyRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _ecnrAppId (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  EcnrDestroyRequest::EcnrDestroyRequest (uint8 ecnrAppId_)  :
    _ecnrAppId (ecnrAppId_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  EcnrDestroyRequest::~EcnrDestroyRequest() {
}

inline EcnrDestroyRequest& EcnrDestroyRequest::operator = (const EcnrDestroyRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasEcnrAppId()) {
            setEcnrAppId(rhs.getEcnrAppId());
        } else {
            clearEcnrAppId();
        }
    }
    return *this;
}

inline bool EcnrDestroyRequest::operator == (const EcnrDestroyRequest& rhs) const {
    return (((!hasEcnrAppId() && !rhs.hasEcnrAppId()) || getEcnrAppId() == rhs.getEcnrAppId()));
}

inline bool EcnrDestroyRequest::operator != (const EcnrDestroyRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool EcnrDestroyRequest::operator < (const EcnrDestroyRequest& rhs) const {
    if (hasEcnrAppId() || rhs.hasEcnrAppId()) {
        if (getEcnrAppId() < rhs.getEcnrAppId()) return true;
        if (getEcnrAppId() > rhs.getEcnrAppId()) return false;
    }
    return false;
}

inline ::asf::core::Payload* EcnrDestroyRequest::clone() {
    return new EcnrDestroyRequest(*this);
}

inline bool EcnrDestroyRequest::operator > (const EcnrDestroyRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void EcnrDestroyRequest::clear() {
    clearEcnrAppId();
}

inline void EcnrDestroyRequest::clearEcnrAppId() {
    if (hasEcnrAppId()) {
         clear_has_ecnrAppId();
        _ecnrAppId = 0u;
     }
}

inline bool EcnrDestroyRequest::hasEcnrAppId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 EcnrDestroyRequest::getEcnrAppId () const {
    return _ecnrAppId;
}

inline void EcnrDestroyRequest::setEcnrAppId (uint8 ecnrAppId_) {
    set_has_ecnrAppId();
    this->_ecnrAppId = ecnrAppId_;
}

inline void EcnrDestroyRequest::set_has_ecnrAppId () {
    _has_bits_[0] |= 1u << 0;
}

inline void EcnrDestroyRequest::clear_has_ecnrAppId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  EcnrTerminateRequest::EcnrTerminateRequest ()  :
    _ecnrAppId (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  EcnrTerminateRequest::EcnrTerminateRequest (const EcnrTerminateRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _ecnrAppId (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  EcnrTerminateRequest::EcnrTerminateRequest (uint8 ecnrAppId_)  :
    _ecnrAppId (ecnrAppId_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  EcnrTerminateRequest::~EcnrTerminateRequest() {
}

inline EcnrTerminateRequest& EcnrTerminateRequest::operator = (const EcnrTerminateRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasEcnrAppId()) {
            setEcnrAppId(rhs.getEcnrAppId());
        } else {
            clearEcnrAppId();
        }
    }
    return *this;
}

inline bool EcnrTerminateRequest::operator == (const EcnrTerminateRequest& rhs) const {
    return (((!hasEcnrAppId() && !rhs.hasEcnrAppId()) || getEcnrAppId() == rhs.getEcnrAppId()));
}

inline bool EcnrTerminateRequest::operator != (const EcnrTerminateRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool EcnrTerminateRequest::operator < (const EcnrTerminateRequest& rhs) const {
    if (hasEcnrAppId() || rhs.hasEcnrAppId()) {
        if (getEcnrAppId() < rhs.getEcnrAppId()) return true;
        if (getEcnrAppId() > rhs.getEcnrAppId()) return false;
    }
    return false;
}

inline ::asf::core::Payload* EcnrTerminateRequest::clone() {
    return new EcnrTerminateRequest(*this);
}

inline bool EcnrTerminateRequest::operator > (const EcnrTerminateRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void EcnrTerminateRequest::clear() {
    clearEcnrAppId();
}

inline void EcnrTerminateRequest::clearEcnrAppId() {
    if (hasEcnrAppId()) {
         clear_has_ecnrAppId();
        _ecnrAppId = 0u;
     }
}

inline bool EcnrTerminateRequest::hasEcnrAppId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 EcnrTerminateRequest::getEcnrAppId () const {
    return _ecnrAppId;
}

inline void EcnrTerminateRequest::setEcnrAppId (uint8 ecnrAppId_) {
    set_has_ecnrAppId();
    this->_ecnrAppId = ecnrAppId_;
}

inline void EcnrTerminateRequest::set_has_ecnrAppId () {
    _has_bits_[0] |= 1u << 0;
}

inline void EcnrTerminateRequest::clear_has_ecnrAppId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  EcnrSetConfigurationRequest::EcnrSetConfigurationRequest ()  :
    _ecnrAppId (0u),
    _ecnrConfigurationId (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  EcnrSetConfigurationRequest::EcnrSetConfigurationRequest (const EcnrSetConfigurationRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _ecnrAppId (0u),
    _ecnrConfigurationId (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  EcnrSetConfigurationRequest::EcnrSetConfigurationRequest (uint8 ecnrAppId_, uint32 ecnrConfigurationId_)  :
    _ecnrAppId (ecnrAppId_),
    _ecnrConfigurationId (ecnrConfigurationId_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  EcnrSetConfigurationRequest::~EcnrSetConfigurationRequest() {
}

inline EcnrSetConfigurationRequest& EcnrSetConfigurationRequest::operator = (const EcnrSetConfigurationRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasEcnrAppId()) {
            setEcnrAppId(rhs.getEcnrAppId());
        } else {
            clearEcnrAppId();
        }
        if (rhs.hasEcnrConfigurationId()) {
            setEcnrConfigurationId(rhs.getEcnrConfigurationId());
        } else {
            clearEcnrConfigurationId();
        }
    }
    return *this;
}

inline bool EcnrSetConfigurationRequest::operator == (const EcnrSetConfigurationRequest& rhs) const {
    return (((!hasEcnrAppId() && !rhs.hasEcnrAppId()) || getEcnrAppId() == rhs.getEcnrAppId()) &&
        ((!hasEcnrConfigurationId() && !rhs.hasEcnrConfigurationId()) || getEcnrConfigurationId() == rhs.getEcnrConfigurationId()));
}

inline bool EcnrSetConfigurationRequest::operator != (const EcnrSetConfigurationRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool EcnrSetConfigurationRequest::operator < (const EcnrSetConfigurationRequest& rhs) const {
    if (hasEcnrAppId() || rhs.hasEcnrAppId()) {
        if (getEcnrAppId() < rhs.getEcnrAppId()) return true;
        if (getEcnrAppId() > rhs.getEcnrAppId()) return false;
    }
    if (hasEcnrConfigurationId() || rhs.hasEcnrConfigurationId()) {
        if (getEcnrConfigurationId() < rhs.getEcnrConfigurationId()) return true;
        if (getEcnrConfigurationId() > rhs.getEcnrConfigurationId()) return false;
    }
    return false;
}

inline ::asf::core::Payload* EcnrSetConfigurationRequest::clone() {
    return new EcnrSetConfigurationRequest(*this);
}

inline bool EcnrSetConfigurationRequest::operator > (const EcnrSetConfigurationRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void EcnrSetConfigurationRequest::clear() {
    clearEcnrAppId();
    clearEcnrConfigurationId();
}

inline void EcnrSetConfigurationRequest::clearEcnrAppId() {
    if (hasEcnrAppId()) {
         clear_has_ecnrAppId();
        _ecnrAppId = 0u;
     }
}

inline bool EcnrSetConfigurationRequest::hasEcnrAppId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 EcnrSetConfigurationRequest::getEcnrAppId () const {
    return _ecnrAppId;
}

inline void EcnrSetConfigurationRequest::setEcnrAppId (uint8 ecnrAppId_) {
    set_has_ecnrAppId();
    this->_ecnrAppId = ecnrAppId_;
}

inline void EcnrSetConfigurationRequest::clearEcnrConfigurationId() {
    if (hasEcnrConfigurationId()) {
         clear_has_ecnrConfigurationId();
        _ecnrConfigurationId = 0u;
     }
}

inline bool EcnrSetConfigurationRequest::hasEcnrConfigurationId () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 EcnrSetConfigurationRequest::getEcnrConfigurationId () const {
    return _ecnrConfigurationId;
}

inline void EcnrSetConfigurationRequest::setEcnrConfigurationId (uint32 ecnrConfigurationId_) {
    set_has_ecnrConfigurationId();
    this->_ecnrConfigurationId = ecnrConfigurationId_;
}

inline void EcnrSetConfigurationRequest::set_has_ecnrAppId () {
    _has_bits_[0] |= 1u << 0;
}

inline void EcnrSetConfigurationRequest::clear_has_ecnrAppId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void EcnrSetConfigurationRequest::set_has_ecnrConfigurationId () {
    _has_bits_[0] |= 1u << 1;
}

inline void EcnrSetConfigurationRequest::clear_has_ecnrConfigurationId () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  EcnrSetConfigurationSyncRequest::EcnrSetConfigurationSyncRequest ()  :
    _ecnrAppId (0u),
    _ecnrConfigurationId (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  EcnrSetConfigurationSyncRequest::EcnrSetConfigurationSyncRequest (const EcnrSetConfigurationSyncRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _ecnrAppId (0u),
    _ecnrConfigurationId (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  EcnrSetConfigurationSyncRequest::EcnrSetConfigurationSyncRequest (uint8 ecnrAppId_, uint32 ecnrConfigurationId_)  :
    _ecnrAppId (ecnrAppId_),
    _ecnrConfigurationId (ecnrConfigurationId_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  EcnrSetConfigurationSyncRequest::~EcnrSetConfigurationSyncRequest() {
}

inline EcnrSetConfigurationSyncRequest& EcnrSetConfigurationSyncRequest::operator = (const EcnrSetConfigurationSyncRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasEcnrAppId()) {
            setEcnrAppId(rhs.getEcnrAppId());
        } else {
            clearEcnrAppId();
        }
        if (rhs.hasEcnrConfigurationId()) {
            setEcnrConfigurationId(rhs.getEcnrConfigurationId());
        } else {
            clearEcnrConfigurationId();
        }
    }
    return *this;
}

inline bool EcnrSetConfigurationSyncRequest::operator == (const EcnrSetConfigurationSyncRequest& rhs) const {
    return (((!hasEcnrAppId() && !rhs.hasEcnrAppId()) || getEcnrAppId() == rhs.getEcnrAppId()) &&
        ((!hasEcnrConfigurationId() && !rhs.hasEcnrConfigurationId()) || getEcnrConfigurationId() == rhs.getEcnrConfigurationId()));
}

inline bool EcnrSetConfigurationSyncRequest::operator != (const EcnrSetConfigurationSyncRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool EcnrSetConfigurationSyncRequest::operator < (const EcnrSetConfigurationSyncRequest& rhs) const {
    if (hasEcnrAppId() || rhs.hasEcnrAppId()) {
        if (getEcnrAppId() < rhs.getEcnrAppId()) return true;
        if (getEcnrAppId() > rhs.getEcnrAppId()) return false;
    }
    if (hasEcnrConfigurationId() || rhs.hasEcnrConfigurationId()) {
        if (getEcnrConfigurationId() < rhs.getEcnrConfigurationId()) return true;
        if (getEcnrConfigurationId() > rhs.getEcnrConfigurationId()) return false;
    }
    return false;
}

inline ::asf::core::Payload* EcnrSetConfigurationSyncRequest::clone() {
    return new EcnrSetConfigurationSyncRequest(*this);
}

inline bool EcnrSetConfigurationSyncRequest::operator > (const EcnrSetConfigurationSyncRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void EcnrSetConfigurationSyncRequest::clear() {
    clearEcnrAppId();
    clearEcnrConfigurationId();
}

inline void EcnrSetConfigurationSyncRequest::clearEcnrAppId() {
    if (hasEcnrAppId()) {
         clear_has_ecnrAppId();
        _ecnrAppId = 0u;
     }
}

inline bool EcnrSetConfigurationSyncRequest::hasEcnrAppId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 EcnrSetConfigurationSyncRequest::getEcnrAppId () const {
    return _ecnrAppId;
}

inline void EcnrSetConfigurationSyncRequest::setEcnrAppId (uint8 ecnrAppId_) {
    set_has_ecnrAppId();
    this->_ecnrAppId = ecnrAppId_;
}

inline void EcnrSetConfigurationSyncRequest::clearEcnrConfigurationId() {
    if (hasEcnrConfigurationId()) {
         clear_has_ecnrConfigurationId();
        _ecnrConfigurationId = 0u;
     }
}

inline bool EcnrSetConfigurationSyncRequest::hasEcnrConfigurationId () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 EcnrSetConfigurationSyncRequest::getEcnrConfigurationId () const {
    return _ecnrConfigurationId;
}

inline void EcnrSetConfigurationSyncRequest::setEcnrConfigurationId (uint32 ecnrConfigurationId_) {
    set_has_ecnrConfigurationId();
    this->_ecnrConfigurationId = ecnrConfigurationId_;
}

inline void EcnrSetConfigurationSyncRequest::set_has_ecnrAppId () {
    _has_bits_[0] |= 1u << 0;
}

inline void EcnrSetConfigurationSyncRequest::clear_has_ecnrAppId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void EcnrSetConfigurationSyncRequest::set_has_ecnrConfigurationId () {
    _has_bits_[0] |= 1u << 1;
}

inline void EcnrSetConfigurationSyncRequest::clear_has_ecnrConfigurationId () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  EcnrSetConfigurationSyncResponse::EcnrSetConfigurationSyncResponse ()  :
    _InDevices (),
    _OutDevices (),
    _DeviceProperties ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  EcnrSetConfigurationSyncResponse::EcnrSetConfigurationSyncResponse (const EcnrSetConfigurationSyncResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _InDevices (),
    _OutDevices (),
    _DeviceProperties ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  EcnrSetConfigurationSyncResponse::EcnrSetConfigurationSyncResponse (const ::std::vector< ::std::string >& InDevices_, const ::std::vector< ::std::string >& OutDevices_, const ::std::vector< uint32 >& DeviceProperties_)  :
    _InDevices (InDevices_),
    _OutDevices (OutDevices_),
    _DeviceProperties (DeviceProperties_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  EcnrSetConfigurationSyncResponse::~EcnrSetConfigurationSyncResponse() {
}

inline EcnrSetConfigurationSyncResponse& EcnrSetConfigurationSyncResponse::operator = (const EcnrSetConfigurationSyncResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasInDevices()) {
            setInDevices(rhs.getInDevices());
        } else {
            clearInDevices();
        }
        if (rhs.hasOutDevices()) {
            setOutDevices(rhs.getOutDevices());
        } else {
            clearOutDevices();
        }
        if (rhs.hasDeviceProperties()) {
            setDeviceProperties(rhs.getDeviceProperties());
        } else {
            clearDeviceProperties();
        }
    }
    return *this;
}

inline bool EcnrSetConfigurationSyncResponse::operator == (const EcnrSetConfigurationSyncResponse& rhs) const {
    return (((!hasInDevices() && !rhs.hasInDevices()) || getInDevices() == rhs.getInDevices()) &&
        ((!hasOutDevices() && !rhs.hasOutDevices()) || getOutDevices() == rhs.getOutDevices()) &&
        ((!hasDeviceProperties() && !rhs.hasDeviceProperties()) || getDeviceProperties() == rhs.getDeviceProperties()));
}

inline bool EcnrSetConfigurationSyncResponse::operator != (const EcnrSetConfigurationSyncResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool EcnrSetConfigurationSyncResponse::operator < (const EcnrSetConfigurationSyncResponse& rhs) const {
    if (hasInDevices() || rhs.hasInDevices()) {
        if (getInDevices() < rhs.getInDevices()) return true;
        if (getInDevices() > rhs.getInDevices()) return false;
    }
    if (hasOutDevices() || rhs.hasOutDevices()) {
        if (getOutDevices() < rhs.getOutDevices()) return true;
        if (getOutDevices() > rhs.getOutDevices()) return false;
    }
    if (hasDeviceProperties() || rhs.hasDeviceProperties()) {
        if (getDeviceProperties() < rhs.getDeviceProperties()) return true;
        if (getDeviceProperties() > rhs.getDeviceProperties()) return false;
    }
    return false;
}

inline ::asf::core::Payload* EcnrSetConfigurationSyncResponse::clone() {
    return new EcnrSetConfigurationSyncResponse(*this);
}

inline bool EcnrSetConfigurationSyncResponse::operator > (const EcnrSetConfigurationSyncResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void EcnrSetConfigurationSyncResponse::clear() {
    clearInDevices();
    clearOutDevices();
    clearDeviceProperties();
}

inline void EcnrSetConfigurationSyncResponse::clearInDevices() {
    if (hasInDevices()) {
         clear_has_InDevices();
        _InDevices.clear();
     }
}

inline bool EcnrSetConfigurationSyncResponse::hasInDevices () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< ::std::string >& EcnrSetConfigurationSyncResponse::getInDevices () const {
    return _InDevices;
}

inline ::std::vector< ::std::string >& EcnrSetConfigurationSyncResponse::getInDevicesMutable () {
    set_has_InDevices();
    return _InDevices;
}

inline void EcnrSetConfigurationSyncResponse::setInDevices (const ::std::vector< ::std::string >& InDevices_) {
    set_has_InDevices();
    this->_InDevices = InDevices_;
}

inline void EcnrSetConfigurationSyncResponse::clearOutDevices() {
    if (hasOutDevices()) {
         clear_has_OutDevices();
        _OutDevices.clear();
     }
}

inline bool EcnrSetConfigurationSyncResponse::hasOutDevices () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::vector< ::std::string >& EcnrSetConfigurationSyncResponse::getOutDevices () const {
    return _OutDevices;
}

inline ::std::vector< ::std::string >& EcnrSetConfigurationSyncResponse::getOutDevicesMutable () {
    set_has_OutDevices();
    return _OutDevices;
}

inline void EcnrSetConfigurationSyncResponse::setOutDevices (const ::std::vector< ::std::string >& OutDevices_) {
    set_has_OutDevices();
    this->_OutDevices = OutDevices_;
}

inline void EcnrSetConfigurationSyncResponse::clearDeviceProperties() {
    if (hasDeviceProperties()) {
         clear_has_DeviceProperties();
        _DeviceProperties.clear();
     }
}

inline bool EcnrSetConfigurationSyncResponse::hasDeviceProperties () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::vector< uint32 >& EcnrSetConfigurationSyncResponse::getDeviceProperties () const {
    return _DeviceProperties;
}

inline ::std::vector< uint32 >& EcnrSetConfigurationSyncResponse::getDevicePropertiesMutable () {
    set_has_DeviceProperties();
    return _DeviceProperties;
}

inline void EcnrSetConfigurationSyncResponse::setDeviceProperties (const ::std::vector< uint32 >& DeviceProperties_) {
    set_has_DeviceProperties();
    this->_DeviceProperties = DeviceProperties_;
}

inline void EcnrSetConfigurationSyncResponse::set_has_InDevices () {
    _has_bits_[0] |= 1u << 0;
}

inline void EcnrSetConfigurationSyncResponse::clear_has_InDevices () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void EcnrSetConfigurationSyncResponse::set_has_OutDevices () {
    _has_bits_[0] |= 1u << 1;
}

inline void EcnrSetConfigurationSyncResponse::clear_has_OutDevices () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void EcnrSetConfigurationSyncResponse::set_has_DeviceProperties () {
    _has_bits_[0] |= 1u << 2;
}

inline void EcnrSetConfigurationSyncResponse::clear_has_DeviceProperties () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  EcnrGetEcnrConfigurationResponse::EcnrGetEcnrConfigurationResponse ()  :
    _DatasetName (),
    _EcnrProperties ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  EcnrGetEcnrConfigurationResponse::EcnrGetEcnrConfigurationResponse (const EcnrGetEcnrConfigurationResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _DatasetName (),
    _EcnrProperties ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  EcnrGetEcnrConfigurationResponse::EcnrGetEcnrConfigurationResponse (const ::std::string& DatasetName_, const ::std::vector< uint32 >& EcnrProperties_)  :
    _DatasetName (DatasetName_),
    _EcnrProperties (EcnrProperties_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (DatasetName_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  EcnrGetEcnrConfigurationResponse::~EcnrGetEcnrConfigurationResponse() {
}

inline EcnrGetEcnrConfigurationResponse& EcnrGetEcnrConfigurationResponse::operator = (const EcnrGetEcnrConfigurationResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasDatasetName()) {
            setDatasetName(rhs.getDatasetName());
        } else {
            clearDatasetName();
        }
        if (rhs.hasEcnrProperties()) {
            setEcnrProperties(rhs.getEcnrProperties());
        } else {
            clearEcnrProperties();
        }
    }
    return *this;
}

inline bool EcnrGetEcnrConfigurationResponse::operator == (const EcnrGetEcnrConfigurationResponse& rhs) const {
    return (((!hasDatasetName() && !rhs.hasDatasetName()) || getDatasetName() == rhs.getDatasetName()) &&
        ((!hasEcnrProperties() && !rhs.hasEcnrProperties()) || getEcnrProperties() == rhs.getEcnrProperties()));
}

inline bool EcnrGetEcnrConfigurationResponse::operator != (const EcnrGetEcnrConfigurationResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool EcnrGetEcnrConfigurationResponse::operator < (const EcnrGetEcnrConfigurationResponse& rhs) const {
    if (hasDatasetName() || rhs.hasDatasetName()) {
        if (getDatasetName() < rhs.getDatasetName()) return true;
        if (getDatasetName() > rhs.getDatasetName()) return false;
    }
    if (hasEcnrProperties() || rhs.hasEcnrProperties()) {
        if (getEcnrProperties() < rhs.getEcnrProperties()) return true;
        if (getEcnrProperties() > rhs.getEcnrProperties()) return false;
    }
    return false;
}

inline ::asf::core::Payload* EcnrGetEcnrConfigurationResponse::clone() {
    return new EcnrGetEcnrConfigurationResponse(*this);
}

inline bool EcnrGetEcnrConfigurationResponse::operator > (const EcnrGetEcnrConfigurationResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void EcnrGetEcnrConfigurationResponse::clear() {
    clearDatasetName();
    clearEcnrProperties();
}

inline void EcnrGetEcnrConfigurationResponse::clearDatasetName() {
    if (hasDatasetName()) {
         clear_has_DatasetName();
        _DatasetName.clear();
     }
}

inline bool EcnrGetEcnrConfigurationResponse::hasDatasetName () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& EcnrGetEcnrConfigurationResponse::getDatasetName () const {
    return _DatasetName;
}

inline ::std::string& EcnrGetEcnrConfigurationResponse::getDatasetNameMutable () {
    set_has_DatasetName();
    return _DatasetName;
}

inline void EcnrGetEcnrConfigurationResponse::setDatasetName (const ::std::string& DatasetName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (DatasetName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_DatasetName();
    this->_DatasetName = DatasetName_;
}

inline void EcnrGetEcnrConfigurationResponse::setDatasetName (const char* DatasetName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (DatasetName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_DatasetName();
    this->_DatasetName.assign(DatasetName_);
}

inline void EcnrGetEcnrConfigurationResponse::setDatasetName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_DatasetName();
    this->_DatasetName.assign(value, size);
}

inline void EcnrGetEcnrConfigurationResponse::clearEcnrProperties() {
    if (hasEcnrProperties()) {
         clear_has_EcnrProperties();
        _EcnrProperties.clear();
     }
}

inline bool EcnrGetEcnrConfigurationResponse::hasEcnrProperties () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::vector< uint32 >& EcnrGetEcnrConfigurationResponse::getEcnrProperties () const {
    return _EcnrProperties;
}

inline ::std::vector< uint32 >& EcnrGetEcnrConfigurationResponse::getEcnrPropertiesMutable () {
    set_has_EcnrProperties();
    return _EcnrProperties;
}

inline void EcnrGetEcnrConfigurationResponse::setEcnrProperties (const ::std::vector< uint32 >& EcnrProperties_) {
    set_has_EcnrProperties();
    this->_EcnrProperties = EcnrProperties_;
}

inline void EcnrGetEcnrConfigurationResponse::set_has_DatasetName () {
    _has_bits_[0] |= 1u << 0;
}

inline void EcnrGetEcnrConfigurationResponse::clear_has_DatasetName () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void EcnrGetEcnrConfigurationResponse::set_has_EcnrProperties () {
    _has_bits_[0] |= 1u << 1;
}

inline void EcnrGetEcnrConfigurationResponse::clear_has_EcnrProperties () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  EcnrStartAudioRequest::EcnrStartAudioRequest ()  :
    _ecnrAppId (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  EcnrStartAudioRequest::EcnrStartAudioRequest (const EcnrStartAudioRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _ecnrAppId (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  EcnrStartAudioRequest::EcnrStartAudioRequest (uint8 ecnrAppId_)  :
    _ecnrAppId (ecnrAppId_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  EcnrStartAudioRequest::~EcnrStartAudioRequest() {
}

inline EcnrStartAudioRequest& EcnrStartAudioRequest::operator = (const EcnrStartAudioRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasEcnrAppId()) {
            setEcnrAppId(rhs.getEcnrAppId());
        } else {
            clearEcnrAppId();
        }
    }
    return *this;
}

inline bool EcnrStartAudioRequest::operator == (const EcnrStartAudioRequest& rhs) const {
    return (((!hasEcnrAppId() && !rhs.hasEcnrAppId()) || getEcnrAppId() == rhs.getEcnrAppId()));
}

inline bool EcnrStartAudioRequest::operator != (const EcnrStartAudioRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool EcnrStartAudioRequest::operator < (const EcnrStartAudioRequest& rhs) const {
    if (hasEcnrAppId() || rhs.hasEcnrAppId()) {
        if (getEcnrAppId() < rhs.getEcnrAppId()) return true;
        if (getEcnrAppId() > rhs.getEcnrAppId()) return false;
    }
    return false;
}

inline ::asf::core::Payload* EcnrStartAudioRequest::clone() {
    return new EcnrStartAudioRequest(*this);
}

inline bool EcnrStartAudioRequest::operator > (const EcnrStartAudioRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void EcnrStartAudioRequest::clear() {
    clearEcnrAppId();
}

inline void EcnrStartAudioRequest::clearEcnrAppId() {
    if (hasEcnrAppId()) {
         clear_has_ecnrAppId();
        _ecnrAppId = 0u;
     }
}

inline bool EcnrStartAudioRequest::hasEcnrAppId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 EcnrStartAudioRequest::getEcnrAppId () const {
    return _ecnrAppId;
}

inline void EcnrStartAudioRequest::setEcnrAppId (uint8 ecnrAppId_) {
    set_has_ecnrAppId();
    this->_ecnrAppId = ecnrAppId_;
}

inline void EcnrStartAudioRequest::set_has_ecnrAppId () {
    _has_bits_[0] |= 1u << 0;
}

inline void EcnrStartAudioRequest::clear_has_ecnrAppId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  EcnrStartAudioExtRequest::EcnrStartAudioExtRequest ()  :
    _ecnrAppId (0u),
    _StartMode (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  EcnrStartAudioExtRequest::EcnrStartAudioExtRequest (const EcnrStartAudioExtRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _ecnrAppId (0u),
    _StartMode (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  EcnrStartAudioExtRequest::EcnrStartAudioExtRequest (uint8 ecnrAppId_, uint8 StartMode_)  :
    _ecnrAppId (ecnrAppId_),
    _StartMode (StartMode_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  EcnrStartAudioExtRequest::~EcnrStartAudioExtRequest() {
}

inline EcnrStartAudioExtRequest& EcnrStartAudioExtRequest::operator = (const EcnrStartAudioExtRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasEcnrAppId()) {
            setEcnrAppId(rhs.getEcnrAppId());
        } else {
            clearEcnrAppId();
        }
        if (rhs.hasStartMode()) {
            setStartMode(rhs.getStartMode());
        } else {
            clearStartMode();
        }
    }
    return *this;
}

inline bool EcnrStartAudioExtRequest::operator == (const EcnrStartAudioExtRequest& rhs) const {
    return (((!hasEcnrAppId() && !rhs.hasEcnrAppId()) || getEcnrAppId() == rhs.getEcnrAppId()) &&
        ((!hasStartMode() && !rhs.hasStartMode()) || getStartMode() == rhs.getStartMode()));
}

inline bool EcnrStartAudioExtRequest::operator != (const EcnrStartAudioExtRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool EcnrStartAudioExtRequest::operator < (const EcnrStartAudioExtRequest& rhs) const {
    if (hasEcnrAppId() || rhs.hasEcnrAppId()) {
        if (getEcnrAppId() < rhs.getEcnrAppId()) return true;
        if (getEcnrAppId() > rhs.getEcnrAppId()) return false;
    }
    if (hasStartMode() || rhs.hasStartMode()) {
        if (getStartMode() < rhs.getStartMode()) return true;
        if (getStartMode() > rhs.getStartMode()) return false;
    }
    return false;
}

inline ::asf::core::Payload* EcnrStartAudioExtRequest::clone() {
    return new EcnrStartAudioExtRequest(*this);
}

inline bool EcnrStartAudioExtRequest::operator > (const EcnrStartAudioExtRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void EcnrStartAudioExtRequest::clear() {
    clearEcnrAppId();
    clearStartMode();
}

inline void EcnrStartAudioExtRequest::clearEcnrAppId() {
    if (hasEcnrAppId()) {
         clear_has_ecnrAppId();
        _ecnrAppId = 0u;
     }
}

inline bool EcnrStartAudioExtRequest::hasEcnrAppId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 EcnrStartAudioExtRequest::getEcnrAppId () const {
    return _ecnrAppId;
}

inline void EcnrStartAudioExtRequest::setEcnrAppId (uint8 ecnrAppId_) {
    set_has_ecnrAppId();
    this->_ecnrAppId = ecnrAppId_;
}

inline void EcnrStartAudioExtRequest::clearStartMode() {
    if (hasStartMode()) {
         clear_has_StartMode();
        _StartMode = 0u;
     }
}

inline bool EcnrStartAudioExtRequest::hasStartMode () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 EcnrStartAudioExtRequest::getStartMode () const {
    return _StartMode;
}

inline void EcnrStartAudioExtRequest::setStartMode (uint8 StartMode_) {
    set_has_StartMode();
    this->_StartMode = StartMode_;
}

inline void EcnrStartAudioExtRequest::set_has_ecnrAppId () {
    _has_bits_[0] |= 1u << 0;
}

inline void EcnrStartAudioExtRequest::clear_has_ecnrAppId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void EcnrStartAudioExtRequest::set_has_StartMode () {
    _has_bits_[0] |= 1u << 1;
}

inline void EcnrStartAudioExtRequest::clear_has_StartMode () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  EcnrStopAudioRequest::EcnrStopAudioRequest ()  :
    _ecnrAppId (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  EcnrStopAudioRequest::EcnrStopAudioRequest (const EcnrStopAudioRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _ecnrAppId (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  EcnrStopAudioRequest::EcnrStopAudioRequest (uint8 ecnrAppId_)  :
    _ecnrAppId (ecnrAppId_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  EcnrStopAudioRequest::~EcnrStopAudioRequest() {
}

inline EcnrStopAudioRequest& EcnrStopAudioRequest::operator = (const EcnrStopAudioRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasEcnrAppId()) {
            setEcnrAppId(rhs.getEcnrAppId());
        } else {
            clearEcnrAppId();
        }
    }
    return *this;
}

inline bool EcnrStopAudioRequest::operator == (const EcnrStopAudioRequest& rhs) const {
    return (((!hasEcnrAppId() && !rhs.hasEcnrAppId()) || getEcnrAppId() == rhs.getEcnrAppId()));
}

inline bool EcnrStopAudioRequest::operator != (const EcnrStopAudioRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool EcnrStopAudioRequest::operator < (const EcnrStopAudioRequest& rhs) const {
    if (hasEcnrAppId() || rhs.hasEcnrAppId()) {
        if (getEcnrAppId() < rhs.getEcnrAppId()) return true;
        if (getEcnrAppId() > rhs.getEcnrAppId()) return false;
    }
    return false;
}

inline ::asf::core::Payload* EcnrStopAudioRequest::clone() {
    return new EcnrStopAudioRequest(*this);
}

inline bool EcnrStopAudioRequest::operator > (const EcnrStopAudioRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void EcnrStopAudioRequest::clear() {
    clearEcnrAppId();
}

inline void EcnrStopAudioRequest::clearEcnrAppId() {
    if (hasEcnrAppId()) {
         clear_has_ecnrAppId();
        _ecnrAppId = 0u;
     }
}

inline bool EcnrStopAudioRequest::hasEcnrAppId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 EcnrStopAudioRequest::getEcnrAppId () const {
    return _ecnrAppId;
}

inline void EcnrStopAudioRequest::setEcnrAppId (uint8 ecnrAppId_) {
    set_has_ecnrAppId();
    this->_ecnrAppId = ecnrAppId_;
}

inline void EcnrStopAudioRequest::set_has_ecnrAppId () {
    _has_bits_[0] |= 1u << 0;
}

inline void EcnrStopAudioRequest::clear_has_ecnrAppId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  EcnrFrameInfoResponse::EcnrFrameInfoResponse ()  :
    _FrameCounter (0u),
    _VoicePresent (0),
    _AboveBackgroundNoise (0),
    _PercentClipping (0),
    _InstantaneousSNR (0),
    _SmoothVNR (0),
    _ValidOutputCountdown (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  EcnrFrameInfoResponse::EcnrFrameInfoResponse (const EcnrFrameInfoResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _FrameCounter (0u),
    _VoicePresent (0),
    _AboveBackgroundNoise (0),
    _PercentClipping (0),
    _InstantaneousSNR (0),
    _SmoothVNR (0),
    _ValidOutputCountdown (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  EcnrFrameInfoResponse::EcnrFrameInfoResponse (uint32 FrameCounter_, int32 VoicePresent_, int32 AboveBackgroundNoise_, int32 PercentClipping_, int32 InstantaneousSNR_, int32 SmoothVNR_, int32 ValidOutputCountdown_)  :
    _FrameCounter (FrameCounter_),
    _VoicePresent (VoicePresent_),
    _AboveBackgroundNoise (AboveBackgroundNoise_),
    _PercentClipping (PercentClipping_),
    _InstantaneousSNR (InstantaneousSNR_),
    _SmoothVNR (SmoothVNR_),
    _ValidOutputCountdown (ValidOutputCountdown_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  EcnrFrameInfoResponse::~EcnrFrameInfoResponse() {
}

inline EcnrFrameInfoResponse& EcnrFrameInfoResponse::operator = (const EcnrFrameInfoResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasFrameCounter()) {
            setFrameCounter(rhs.getFrameCounter());
        } else {
            clearFrameCounter();
        }
        if (rhs.hasVoicePresent()) {
            setVoicePresent(rhs.getVoicePresent());
        } else {
            clearVoicePresent();
        }
        if (rhs.hasAboveBackgroundNoise()) {
            setAboveBackgroundNoise(rhs.getAboveBackgroundNoise());
        } else {
            clearAboveBackgroundNoise();
        }
        if (rhs.hasPercentClipping()) {
            setPercentClipping(rhs.getPercentClipping());
        } else {
            clearPercentClipping();
        }
        if (rhs.hasInstantaneousSNR()) {
            setInstantaneousSNR(rhs.getInstantaneousSNR());
        } else {
            clearInstantaneousSNR();
        }
        if (rhs.hasSmoothVNR()) {
            setSmoothVNR(rhs.getSmoothVNR());
        } else {
            clearSmoothVNR();
        }
        if (rhs.hasValidOutputCountdown()) {
            setValidOutputCountdown(rhs.getValidOutputCountdown());
        } else {
            clearValidOutputCountdown();
        }
    }
    return *this;
}

inline bool EcnrFrameInfoResponse::operator == (const EcnrFrameInfoResponse& rhs) const {
    return (((!hasFrameCounter() && !rhs.hasFrameCounter()) || getFrameCounter() == rhs.getFrameCounter()) &&
        ((!hasVoicePresent() && !rhs.hasVoicePresent()) || getVoicePresent() == rhs.getVoicePresent()) &&
        ((!hasAboveBackgroundNoise() && !rhs.hasAboveBackgroundNoise()) || getAboveBackgroundNoise() == rhs.getAboveBackgroundNoise()) &&
        ((!hasPercentClipping() && !rhs.hasPercentClipping()) || getPercentClipping() == rhs.getPercentClipping()) &&
        ((!hasInstantaneousSNR() && !rhs.hasInstantaneousSNR()) || getInstantaneousSNR() == rhs.getInstantaneousSNR()) &&
        ((!hasSmoothVNR() && !rhs.hasSmoothVNR()) || getSmoothVNR() == rhs.getSmoothVNR()) &&
        ((!hasValidOutputCountdown() && !rhs.hasValidOutputCountdown()) || getValidOutputCountdown() == rhs.getValidOutputCountdown()));
}

inline bool EcnrFrameInfoResponse::operator != (const EcnrFrameInfoResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool EcnrFrameInfoResponse::operator < (const EcnrFrameInfoResponse& rhs) const {
    if (hasFrameCounter() || rhs.hasFrameCounter()) {
        if (getFrameCounter() < rhs.getFrameCounter()) return true;
        if (getFrameCounter() > rhs.getFrameCounter()) return false;
    }
    if (hasVoicePresent() || rhs.hasVoicePresent()) {
        if (getVoicePresent() < rhs.getVoicePresent()) return true;
        if (getVoicePresent() > rhs.getVoicePresent()) return false;
    }
    if (hasAboveBackgroundNoise() || rhs.hasAboveBackgroundNoise()) {
        if (getAboveBackgroundNoise() < rhs.getAboveBackgroundNoise()) return true;
        if (getAboveBackgroundNoise() > rhs.getAboveBackgroundNoise()) return false;
    }
    if (hasPercentClipping() || rhs.hasPercentClipping()) {
        if (getPercentClipping() < rhs.getPercentClipping()) return true;
        if (getPercentClipping() > rhs.getPercentClipping()) return false;
    }
    if (hasInstantaneousSNR() || rhs.hasInstantaneousSNR()) {
        if (getInstantaneousSNR() < rhs.getInstantaneousSNR()) return true;
        if (getInstantaneousSNR() > rhs.getInstantaneousSNR()) return false;
    }
    if (hasSmoothVNR() || rhs.hasSmoothVNR()) {
        if (getSmoothVNR() < rhs.getSmoothVNR()) return true;
        if (getSmoothVNR() > rhs.getSmoothVNR()) return false;
    }
    if (hasValidOutputCountdown() || rhs.hasValidOutputCountdown()) {
        if (getValidOutputCountdown() < rhs.getValidOutputCountdown()) return true;
        if (getValidOutputCountdown() > rhs.getValidOutputCountdown()) return false;
    }
    return false;
}

inline ::asf::core::Payload* EcnrFrameInfoResponse::clone() {
    return new EcnrFrameInfoResponse(*this);
}

inline bool EcnrFrameInfoResponse::operator > (const EcnrFrameInfoResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void EcnrFrameInfoResponse::clear() {
    clearFrameCounter();
    clearVoicePresent();
    clearAboveBackgroundNoise();
    clearPercentClipping();
    clearInstantaneousSNR();
    clearSmoothVNR();
    clearValidOutputCountdown();
}

inline void EcnrFrameInfoResponse::clearFrameCounter() {
    if (hasFrameCounter()) {
         clear_has_FrameCounter();
        _FrameCounter = 0u;
     }
}

inline bool EcnrFrameInfoResponse::hasFrameCounter () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 EcnrFrameInfoResponse::getFrameCounter () const {
    return _FrameCounter;
}

inline void EcnrFrameInfoResponse::setFrameCounter (uint32 FrameCounter_) {
    set_has_FrameCounter();
    this->_FrameCounter = FrameCounter_;
}

inline void EcnrFrameInfoResponse::clearVoicePresent() {
    if (hasVoicePresent()) {
         clear_has_VoicePresent();
        _VoicePresent = 0;
     }
}

inline bool EcnrFrameInfoResponse::hasVoicePresent () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline int32 EcnrFrameInfoResponse::getVoicePresent () const {
    return _VoicePresent;
}

inline void EcnrFrameInfoResponse::setVoicePresent (int32 VoicePresent_) {
    set_has_VoicePresent();
    this->_VoicePresent = VoicePresent_;
}

inline void EcnrFrameInfoResponse::clearAboveBackgroundNoise() {
    if (hasAboveBackgroundNoise()) {
         clear_has_AboveBackgroundNoise();
        _AboveBackgroundNoise = 0;
     }
}

inline bool EcnrFrameInfoResponse::hasAboveBackgroundNoise () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline int32 EcnrFrameInfoResponse::getAboveBackgroundNoise () const {
    return _AboveBackgroundNoise;
}

inline void EcnrFrameInfoResponse::setAboveBackgroundNoise (int32 AboveBackgroundNoise_) {
    set_has_AboveBackgroundNoise();
    this->_AboveBackgroundNoise = AboveBackgroundNoise_;
}

inline void EcnrFrameInfoResponse::clearPercentClipping() {
    if (hasPercentClipping()) {
         clear_has_PercentClipping();
        _PercentClipping = 0;
     }
}

inline bool EcnrFrameInfoResponse::hasPercentClipping () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline int32 EcnrFrameInfoResponse::getPercentClipping () const {
    return _PercentClipping;
}

inline void EcnrFrameInfoResponse::setPercentClipping (int32 PercentClipping_) {
    set_has_PercentClipping();
    this->_PercentClipping = PercentClipping_;
}

inline void EcnrFrameInfoResponse::clearInstantaneousSNR() {
    if (hasInstantaneousSNR()) {
         clear_has_InstantaneousSNR();
        _InstantaneousSNR = 0;
     }
}

inline bool EcnrFrameInfoResponse::hasInstantaneousSNR () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline int32 EcnrFrameInfoResponse::getInstantaneousSNR () const {
    return _InstantaneousSNR;
}

inline void EcnrFrameInfoResponse::setInstantaneousSNR (int32 InstantaneousSNR_) {
    set_has_InstantaneousSNR();
    this->_InstantaneousSNR = InstantaneousSNR_;
}

inline void EcnrFrameInfoResponse::clearSmoothVNR() {
    if (hasSmoothVNR()) {
         clear_has_SmoothVNR();
        _SmoothVNR = 0;
     }
}

inline bool EcnrFrameInfoResponse::hasSmoothVNR () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline int32 EcnrFrameInfoResponse::getSmoothVNR () const {
    return _SmoothVNR;
}

inline void EcnrFrameInfoResponse::setSmoothVNR (int32 SmoothVNR_) {
    set_has_SmoothVNR();
    this->_SmoothVNR = SmoothVNR_;
}

inline void EcnrFrameInfoResponse::clearValidOutputCountdown() {
    if (hasValidOutputCountdown()) {
         clear_has_ValidOutputCountdown();
        _ValidOutputCountdown = 0;
     }
}

inline bool EcnrFrameInfoResponse::hasValidOutputCountdown () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline int32 EcnrFrameInfoResponse::getValidOutputCountdown () const {
    return _ValidOutputCountdown;
}

inline void EcnrFrameInfoResponse::setValidOutputCountdown (int32 ValidOutputCountdown_) {
    set_has_ValidOutputCountdown();
    this->_ValidOutputCountdown = ValidOutputCountdown_;
}

inline void EcnrFrameInfoResponse::set_has_FrameCounter () {
    _has_bits_[0] |= 1u << 0;
}

inline void EcnrFrameInfoResponse::clear_has_FrameCounter () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void EcnrFrameInfoResponse::set_has_VoicePresent () {
    _has_bits_[0] |= 1u << 1;
}

inline void EcnrFrameInfoResponse::clear_has_VoicePresent () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void EcnrFrameInfoResponse::set_has_AboveBackgroundNoise () {
    _has_bits_[0] |= 1u << 2;
}

inline void EcnrFrameInfoResponse::clear_has_AboveBackgroundNoise () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void EcnrFrameInfoResponse::set_has_PercentClipping () {
    _has_bits_[0] |= 1u << 3;
}

inline void EcnrFrameInfoResponse::clear_has_PercentClipping () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void EcnrFrameInfoResponse::set_has_InstantaneousSNR () {
    _has_bits_[0] |= 1u << 4;
}

inline void EcnrFrameInfoResponse::clear_has_InstantaneousSNR () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void EcnrFrameInfoResponse::set_has_SmoothVNR () {
    _has_bits_[0] |= 1u << 5;
}

inline void EcnrFrameInfoResponse::clear_has_SmoothVNR () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void EcnrFrameInfoResponse::set_has_ValidOutputCountdown () {
    _has_bits_[0] |= 1u << 6;
}

inline void EcnrFrameInfoResponse::clear_has_ValidOutputCountdown () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline  EcnrMicClipStatsRequest::EcnrMicClipStatsRequest ()  :
    _Channel (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  EcnrMicClipStatsRequest::EcnrMicClipStatsRequest (const EcnrMicClipStatsRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _Channel (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  EcnrMicClipStatsRequest::EcnrMicClipStatsRequest (int32 Channel_)  :
    _Channel (Channel_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  EcnrMicClipStatsRequest::~EcnrMicClipStatsRequest() {
}

inline EcnrMicClipStatsRequest& EcnrMicClipStatsRequest::operator = (const EcnrMicClipStatsRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasChannel()) {
            setChannel(rhs.getChannel());
        } else {
            clearChannel();
        }
    }
    return *this;
}

inline bool EcnrMicClipStatsRequest::operator == (const EcnrMicClipStatsRequest& rhs) const {
    return (((!hasChannel() && !rhs.hasChannel()) || getChannel() == rhs.getChannel()));
}

inline bool EcnrMicClipStatsRequest::operator != (const EcnrMicClipStatsRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool EcnrMicClipStatsRequest::operator < (const EcnrMicClipStatsRequest& rhs) const {
    if (hasChannel() || rhs.hasChannel()) {
        if (getChannel() < rhs.getChannel()) return true;
        if (getChannel() > rhs.getChannel()) return false;
    }
    return false;
}

inline ::asf::core::Payload* EcnrMicClipStatsRequest::clone() {
    return new EcnrMicClipStatsRequest(*this);
}

inline bool EcnrMicClipStatsRequest::operator > (const EcnrMicClipStatsRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void EcnrMicClipStatsRequest::clear() {
    clearChannel();
}

inline void EcnrMicClipStatsRequest::clearChannel() {
    if (hasChannel()) {
         clear_has_Channel();
        _Channel = 0;
     }
}

inline bool EcnrMicClipStatsRequest::hasChannel () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline int32 EcnrMicClipStatsRequest::getChannel () const {
    return _Channel;
}

inline void EcnrMicClipStatsRequest::setChannel (int32 Channel_) {
    set_has_Channel();
    this->_Channel = Channel_;
}

inline void EcnrMicClipStatsRequest::set_has_Channel () {
    _has_bits_[0] |= 1u << 0;
}

inline void EcnrMicClipStatsRequest::clear_has_Channel () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  EcnrMicClipStatsResponse::EcnrMicClipStatsResponse ()  :
    _ClipFrames (0u),
    _ClipCount (0u),
    _MaxAmp (0),
    _MinAmp (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  EcnrMicClipStatsResponse::EcnrMicClipStatsResponse (const EcnrMicClipStatsResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _ClipFrames (0u),
    _ClipCount (0u),
    _MaxAmp (0),
    _MinAmp (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  EcnrMicClipStatsResponse::EcnrMicClipStatsResponse (uint32 ClipFrames_, uint32 ClipCount_, int32 MaxAmp_, int32 MinAmp_)  :
    _ClipFrames (ClipFrames_),
    _ClipCount (ClipCount_),
    _MaxAmp (MaxAmp_),
    _MinAmp (MinAmp_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  EcnrMicClipStatsResponse::~EcnrMicClipStatsResponse() {
}

inline EcnrMicClipStatsResponse& EcnrMicClipStatsResponse::operator = (const EcnrMicClipStatsResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasClipFrames()) {
            setClipFrames(rhs.getClipFrames());
        } else {
            clearClipFrames();
        }
        if (rhs.hasClipCount()) {
            setClipCount(rhs.getClipCount());
        } else {
            clearClipCount();
        }
        if (rhs.hasMaxAmp()) {
            setMaxAmp(rhs.getMaxAmp());
        } else {
            clearMaxAmp();
        }
        if (rhs.hasMinAmp()) {
            setMinAmp(rhs.getMinAmp());
        } else {
            clearMinAmp();
        }
    }
    return *this;
}

inline bool EcnrMicClipStatsResponse::operator == (const EcnrMicClipStatsResponse& rhs) const {
    return (((!hasClipFrames() && !rhs.hasClipFrames()) || getClipFrames() == rhs.getClipFrames()) &&
        ((!hasClipCount() && !rhs.hasClipCount()) || getClipCount() == rhs.getClipCount()) &&
        ((!hasMaxAmp() && !rhs.hasMaxAmp()) || getMaxAmp() == rhs.getMaxAmp()) &&
        ((!hasMinAmp() && !rhs.hasMinAmp()) || getMinAmp() == rhs.getMinAmp()));
}

inline bool EcnrMicClipStatsResponse::operator != (const EcnrMicClipStatsResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool EcnrMicClipStatsResponse::operator < (const EcnrMicClipStatsResponse& rhs) const {
    if (hasClipFrames() || rhs.hasClipFrames()) {
        if (getClipFrames() < rhs.getClipFrames()) return true;
        if (getClipFrames() > rhs.getClipFrames()) return false;
    }
    if (hasClipCount() || rhs.hasClipCount()) {
        if (getClipCount() < rhs.getClipCount()) return true;
        if (getClipCount() > rhs.getClipCount()) return false;
    }
    if (hasMaxAmp() || rhs.hasMaxAmp()) {
        if (getMaxAmp() < rhs.getMaxAmp()) return true;
        if (getMaxAmp() > rhs.getMaxAmp()) return false;
    }
    if (hasMinAmp() || rhs.hasMinAmp()) {
        if (getMinAmp() < rhs.getMinAmp()) return true;
        if (getMinAmp() > rhs.getMinAmp()) return false;
    }
    return false;
}

inline ::asf::core::Payload* EcnrMicClipStatsResponse::clone() {
    return new EcnrMicClipStatsResponse(*this);
}

inline bool EcnrMicClipStatsResponse::operator > (const EcnrMicClipStatsResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void EcnrMicClipStatsResponse::clear() {
    clearClipFrames();
    clearClipCount();
    clearMaxAmp();
    clearMinAmp();
}

inline void EcnrMicClipStatsResponse::clearClipFrames() {
    if (hasClipFrames()) {
         clear_has_ClipFrames();
        _ClipFrames = 0u;
     }
}

inline bool EcnrMicClipStatsResponse::hasClipFrames () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 EcnrMicClipStatsResponse::getClipFrames () const {
    return _ClipFrames;
}

inline void EcnrMicClipStatsResponse::setClipFrames (uint32 ClipFrames_) {
    set_has_ClipFrames();
    this->_ClipFrames = ClipFrames_;
}

inline void EcnrMicClipStatsResponse::clearClipCount() {
    if (hasClipCount()) {
         clear_has_ClipCount();
        _ClipCount = 0u;
     }
}

inline bool EcnrMicClipStatsResponse::hasClipCount () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 EcnrMicClipStatsResponse::getClipCount () const {
    return _ClipCount;
}

inline void EcnrMicClipStatsResponse::setClipCount (uint32 ClipCount_) {
    set_has_ClipCount();
    this->_ClipCount = ClipCount_;
}

inline void EcnrMicClipStatsResponse::clearMaxAmp() {
    if (hasMaxAmp()) {
         clear_has_MaxAmp();
        _MaxAmp = 0;
     }
}

inline bool EcnrMicClipStatsResponse::hasMaxAmp () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline int32 EcnrMicClipStatsResponse::getMaxAmp () const {
    return _MaxAmp;
}

inline void EcnrMicClipStatsResponse::setMaxAmp (int32 MaxAmp_) {
    set_has_MaxAmp();
    this->_MaxAmp = MaxAmp_;
}

inline void EcnrMicClipStatsResponse::clearMinAmp() {
    if (hasMinAmp()) {
         clear_has_MinAmp();
        _MinAmp = 0;
     }
}

inline bool EcnrMicClipStatsResponse::hasMinAmp () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline int32 EcnrMicClipStatsResponse::getMinAmp () const {
    return _MinAmp;
}

inline void EcnrMicClipStatsResponse::setMinAmp (int32 MinAmp_) {
    set_has_MinAmp();
    this->_MinAmp = MinAmp_;
}

inline void EcnrMicClipStatsResponse::set_has_ClipFrames () {
    _has_bits_[0] |= 1u << 0;
}

inline void EcnrMicClipStatsResponse::clear_has_ClipFrames () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void EcnrMicClipStatsResponse::set_has_ClipCount () {
    _has_bits_[0] |= 1u << 1;
}

inline void EcnrMicClipStatsResponse::clear_has_ClipCount () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void EcnrMicClipStatsResponse::set_has_MaxAmp () {
    _has_bits_[0] |= 1u << 2;
}

inline void EcnrMicClipStatsResponse::clear_has_MaxAmp () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void EcnrMicClipStatsResponse::set_has_MinAmp () {
    _has_bits_[0] |= 1u << 3;
}

inline void EcnrMicClipStatsResponse::clear_has_MinAmp () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  EcnrRefClipStatsResponse::EcnrRefClipStatsResponse ()  :
    _ClipFrames (0u),
    _ClipCount (0u),
    _MaxAmp (0),
    _MinAmp (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  EcnrRefClipStatsResponse::EcnrRefClipStatsResponse (const EcnrRefClipStatsResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _ClipFrames (0u),
    _ClipCount (0u),
    _MaxAmp (0),
    _MinAmp (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  EcnrRefClipStatsResponse::EcnrRefClipStatsResponse (uint32 ClipFrames_, uint32 ClipCount_, int32 MaxAmp_, int32 MinAmp_)  :
    _ClipFrames (ClipFrames_),
    _ClipCount (ClipCount_),
    _MaxAmp (MaxAmp_),
    _MinAmp (MinAmp_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  EcnrRefClipStatsResponse::~EcnrRefClipStatsResponse() {
}

inline EcnrRefClipStatsResponse& EcnrRefClipStatsResponse::operator = (const EcnrRefClipStatsResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasClipFrames()) {
            setClipFrames(rhs.getClipFrames());
        } else {
            clearClipFrames();
        }
        if (rhs.hasClipCount()) {
            setClipCount(rhs.getClipCount());
        } else {
            clearClipCount();
        }
        if (rhs.hasMaxAmp()) {
            setMaxAmp(rhs.getMaxAmp());
        } else {
            clearMaxAmp();
        }
        if (rhs.hasMinAmp()) {
            setMinAmp(rhs.getMinAmp());
        } else {
            clearMinAmp();
        }
    }
    return *this;
}

inline bool EcnrRefClipStatsResponse::operator == (const EcnrRefClipStatsResponse& rhs) const {
    return (((!hasClipFrames() && !rhs.hasClipFrames()) || getClipFrames() == rhs.getClipFrames()) &&
        ((!hasClipCount() && !rhs.hasClipCount()) || getClipCount() == rhs.getClipCount()) &&
        ((!hasMaxAmp() && !rhs.hasMaxAmp()) || getMaxAmp() == rhs.getMaxAmp()) &&
        ((!hasMinAmp() && !rhs.hasMinAmp()) || getMinAmp() == rhs.getMinAmp()));
}

inline bool EcnrRefClipStatsResponse::operator != (const EcnrRefClipStatsResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool EcnrRefClipStatsResponse::operator < (const EcnrRefClipStatsResponse& rhs) const {
    if (hasClipFrames() || rhs.hasClipFrames()) {
        if (getClipFrames() < rhs.getClipFrames()) return true;
        if (getClipFrames() > rhs.getClipFrames()) return false;
    }
    if (hasClipCount() || rhs.hasClipCount()) {
        if (getClipCount() < rhs.getClipCount()) return true;
        if (getClipCount() > rhs.getClipCount()) return false;
    }
    if (hasMaxAmp() || rhs.hasMaxAmp()) {
        if (getMaxAmp() < rhs.getMaxAmp()) return true;
        if (getMaxAmp() > rhs.getMaxAmp()) return false;
    }
    if (hasMinAmp() || rhs.hasMinAmp()) {
        if (getMinAmp() < rhs.getMinAmp()) return true;
        if (getMinAmp() > rhs.getMinAmp()) return false;
    }
    return false;
}

inline ::asf::core::Payload* EcnrRefClipStatsResponse::clone() {
    return new EcnrRefClipStatsResponse(*this);
}

inline bool EcnrRefClipStatsResponse::operator > (const EcnrRefClipStatsResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void EcnrRefClipStatsResponse::clear() {
    clearClipFrames();
    clearClipCount();
    clearMaxAmp();
    clearMinAmp();
}

inline void EcnrRefClipStatsResponse::clearClipFrames() {
    if (hasClipFrames()) {
         clear_has_ClipFrames();
        _ClipFrames = 0u;
     }
}

inline bool EcnrRefClipStatsResponse::hasClipFrames () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 EcnrRefClipStatsResponse::getClipFrames () const {
    return _ClipFrames;
}

inline void EcnrRefClipStatsResponse::setClipFrames (uint32 ClipFrames_) {
    set_has_ClipFrames();
    this->_ClipFrames = ClipFrames_;
}

inline void EcnrRefClipStatsResponse::clearClipCount() {
    if (hasClipCount()) {
         clear_has_ClipCount();
        _ClipCount = 0u;
     }
}

inline bool EcnrRefClipStatsResponse::hasClipCount () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 EcnrRefClipStatsResponse::getClipCount () const {
    return _ClipCount;
}

inline void EcnrRefClipStatsResponse::setClipCount (uint32 ClipCount_) {
    set_has_ClipCount();
    this->_ClipCount = ClipCount_;
}

inline void EcnrRefClipStatsResponse::clearMaxAmp() {
    if (hasMaxAmp()) {
         clear_has_MaxAmp();
        _MaxAmp = 0;
     }
}

inline bool EcnrRefClipStatsResponse::hasMaxAmp () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline int32 EcnrRefClipStatsResponse::getMaxAmp () const {
    return _MaxAmp;
}

inline void EcnrRefClipStatsResponse::setMaxAmp (int32 MaxAmp_) {
    set_has_MaxAmp();
    this->_MaxAmp = MaxAmp_;
}

inline void EcnrRefClipStatsResponse::clearMinAmp() {
    if (hasMinAmp()) {
         clear_has_MinAmp();
        _MinAmp = 0;
     }
}

inline bool EcnrRefClipStatsResponse::hasMinAmp () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline int32 EcnrRefClipStatsResponse::getMinAmp () const {
    return _MinAmp;
}

inline void EcnrRefClipStatsResponse::setMinAmp (int32 MinAmp_) {
    set_has_MinAmp();
    this->_MinAmp = MinAmp_;
}

inline void EcnrRefClipStatsResponse::set_has_ClipFrames () {
    _has_bits_[0] |= 1u << 0;
}

inline void EcnrRefClipStatsResponse::clear_has_ClipFrames () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void EcnrRefClipStatsResponse::set_has_ClipCount () {
    _has_bits_[0] |= 1u << 1;
}

inline void EcnrRefClipStatsResponse::clear_has_ClipCount () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void EcnrRefClipStatsResponse::set_has_MaxAmp () {
    _has_bits_[0] |= 1u << 2;
}

inline void EcnrRefClipStatsResponse::clear_has_MaxAmp () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void EcnrRefClipStatsResponse::set_has_MinAmp () {
    _has_bits_[0] |= 1u << 3;
}

inline void EcnrRefClipStatsResponse::clear_has_MinAmp () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  EcnrRecvClipStatsResponse::EcnrRecvClipStatsResponse ()  :
    _ClipFrames (0u),
    _ClipCount (0u),
    _MaxAmp (0),
    _MinAmp (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  EcnrRecvClipStatsResponse::EcnrRecvClipStatsResponse (const EcnrRecvClipStatsResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _ClipFrames (0u),
    _ClipCount (0u),
    _MaxAmp (0),
    _MinAmp (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  EcnrRecvClipStatsResponse::EcnrRecvClipStatsResponse (uint32 ClipFrames_, uint32 ClipCount_, int32 MaxAmp_, int32 MinAmp_)  :
    _ClipFrames (ClipFrames_),
    _ClipCount (ClipCount_),
    _MaxAmp (MaxAmp_),
    _MinAmp (MinAmp_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  EcnrRecvClipStatsResponse::~EcnrRecvClipStatsResponse() {
}

inline EcnrRecvClipStatsResponse& EcnrRecvClipStatsResponse::operator = (const EcnrRecvClipStatsResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasClipFrames()) {
            setClipFrames(rhs.getClipFrames());
        } else {
            clearClipFrames();
        }
        if (rhs.hasClipCount()) {
            setClipCount(rhs.getClipCount());
        } else {
            clearClipCount();
        }
        if (rhs.hasMaxAmp()) {
            setMaxAmp(rhs.getMaxAmp());
        } else {
            clearMaxAmp();
        }
        if (rhs.hasMinAmp()) {
            setMinAmp(rhs.getMinAmp());
        } else {
            clearMinAmp();
        }
    }
    return *this;
}

inline bool EcnrRecvClipStatsResponse::operator == (const EcnrRecvClipStatsResponse& rhs) const {
    return (((!hasClipFrames() && !rhs.hasClipFrames()) || getClipFrames() == rhs.getClipFrames()) &&
        ((!hasClipCount() && !rhs.hasClipCount()) || getClipCount() == rhs.getClipCount()) &&
        ((!hasMaxAmp() && !rhs.hasMaxAmp()) || getMaxAmp() == rhs.getMaxAmp()) &&
        ((!hasMinAmp() && !rhs.hasMinAmp()) || getMinAmp() == rhs.getMinAmp()));
}

inline bool EcnrRecvClipStatsResponse::operator != (const EcnrRecvClipStatsResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool EcnrRecvClipStatsResponse::operator < (const EcnrRecvClipStatsResponse& rhs) const {
    if (hasClipFrames() || rhs.hasClipFrames()) {
        if (getClipFrames() < rhs.getClipFrames()) return true;
        if (getClipFrames() > rhs.getClipFrames()) return false;
    }
    if (hasClipCount() || rhs.hasClipCount()) {
        if (getClipCount() < rhs.getClipCount()) return true;
        if (getClipCount() > rhs.getClipCount()) return false;
    }
    if (hasMaxAmp() || rhs.hasMaxAmp()) {
        if (getMaxAmp() < rhs.getMaxAmp()) return true;
        if (getMaxAmp() > rhs.getMaxAmp()) return false;
    }
    if (hasMinAmp() || rhs.hasMinAmp()) {
        if (getMinAmp() < rhs.getMinAmp()) return true;
        if (getMinAmp() > rhs.getMinAmp()) return false;
    }
    return false;
}

inline ::asf::core::Payload* EcnrRecvClipStatsResponse::clone() {
    return new EcnrRecvClipStatsResponse(*this);
}

inline bool EcnrRecvClipStatsResponse::operator > (const EcnrRecvClipStatsResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void EcnrRecvClipStatsResponse::clear() {
    clearClipFrames();
    clearClipCount();
    clearMaxAmp();
    clearMinAmp();
}

inline void EcnrRecvClipStatsResponse::clearClipFrames() {
    if (hasClipFrames()) {
         clear_has_ClipFrames();
        _ClipFrames = 0u;
     }
}

inline bool EcnrRecvClipStatsResponse::hasClipFrames () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 EcnrRecvClipStatsResponse::getClipFrames () const {
    return _ClipFrames;
}

inline void EcnrRecvClipStatsResponse::setClipFrames (uint32 ClipFrames_) {
    set_has_ClipFrames();
    this->_ClipFrames = ClipFrames_;
}

inline void EcnrRecvClipStatsResponse::clearClipCount() {
    if (hasClipCount()) {
         clear_has_ClipCount();
        _ClipCount = 0u;
     }
}

inline bool EcnrRecvClipStatsResponse::hasClipCount () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 EcnrRecvClipStatsResponse::getClipCount () const {
    return _ClipCount;
}

inline void EcnrRecvClipStatsResponse::setClipCount (uint32 ClipCount_) {
    set_has_ClipCount();
    this->_ClipCount = ClipCount_;
}

inline void EcnrRecvClipStatsResponse::clearMaxAmp() {
    if (hasMaxAmp()) {
         clear_has_MaxAmp();
        _MaxAmp = 0;
     }
}

inline bool EcnrRecvClipStatsResponse::hasMaxAmp () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline int32 EcnrRecvClipStatsResponse::getMaxAmp () const {
    return _MaxAmp;
}

inline void EcnrRecvClipStatsResponse::setMaxAmp (int32 MaxAmp_) {
    set_has_MaxAmp();
    this->_MaxAmp = MaxAmp_;
}

inline void EcnrRecvClipStatsResponse::clearMinAmp() {
    if (hasMinAmp()) {
         clear_has_MinAmp();
        _MinAmp = 0;
     }
}

inline bool EcnrRecvClipStatsResponse::hasMinAmp () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline int32 EcnrRecvClipStatsResponse::getMinAmp () const {
    return _MinAmp;
}

inline void EcnrRecvClipStatsResponse::setMinAmp (int32 MinAmp_) {
    set_has_MinAmp();
    this->_MinAmp = MinAmp_;
}

inline void EcnrRecvClipStatsResponse::set_has_ClipFrames () {
    _has_bits_[0] |= 1u << 0;
}

inline void EcnrRecvClipStatsResponse::clear_has_ClipFrames () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void EcnrRecvClipStatsResponse::set_has_ClipCount () {
    _has_bits_[0] |= 1u << 1;
}

inline void EcnrRecvClipStatsResponse::clear_has_ClipCount () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void EcnrRecvClipStatsResponse::set_has_MaxAmp () {
    _has_bits_[0] |= 1u << 2;
}

inline void EcnrRecvClipStatsResponse::clear_has_MaxAmp () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void EcnrRecvClipStatsResponse::set_has_MinAmp () {
    _has_bits_[0] |= 1u << 3;
}

inline void EcnrRecvClipStatsResponse::clear_has_MinAmp () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  EcnrMicOutClipStatsResponse::EcnrMicOutClipStatsResponse ()  :
    _ClipFrames (0u),
    _ClipCount (0u),
    _MaxAmp (0),
    _MinAmp (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  EcnrMicOutClipStatsResponse::EcnrMicOutClipStatsResponse (const EcnrMicOutClipStatsResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _ClipFrames (0u),
    _ClipCount (0u),
    _MaxAmp (0),
    _MinAmp (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  EcnrMicOutClipStatsResponse::EcnrMicOutClipStatsResponse (uint32 ClipFrames_, uint32 ClipCount_, int32 MaxAmp_, int32 MinAmp_)  :
    _ClipFrames (ClipFrames_),
    _ClipCount (ClipCount_),
    _MaxAmp (MaxAmp_),
    _MinAmp (MinAmp_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  EcnrMicOutClipStatsResponse::~EcnrMicOutClipStatsResponse() {
}

inline EcnrMicOutClipStatsResponse& EcnrMicOutClipStatsResponse::operator = (const EcnrMicOutClipStatsResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasClipFrames()) {
            setClipFrames(rhs.getClipFrames());
        } else {
            clearClipFrames();
        }
        if (rhs.hasClipCount()) {
            setClipCount(rhs.getClipCount());
        } else {
            clearClipCount();
        }
        if (rhs.hasMaxAmp()) {
            setMaxAmp(rhs.getMaxAmp());
        } else {
            clearMaxAmp();
        }
        if (rhs.hasMinAmp()) {
            setMinAmp(rhs.getMinAmp());
        } else {
            clearMinAmp();
        }
    }
    return *this;
}

inline bool EcnrMicOutClipStatsResponse::operator == (const EcnrMicOutClipStatsResponse& rhs) const {
    return (((!hasClipFrames() && !rhs.hasClipFrames()) || getClipFrames() == rhs.getClipFrames()) &&
        ((!hasClipCount() && !rhs.hasClipCount()) || getClipCount() == rhs.getClipCount()) &&
        ((!hasMaxAmp() && !rhs.hasMaxAmp()) || getMaxAmp() == rhs.getMaxAmp()) &&
        ((!hasMinAmp() && !rhs.hasMinAmp()) || getMinAmp() == rhs.getMinAmp()));
}

inline bool EcnrMicOutClipStatsResponse::operator != (const EcnrMicOutClipStatsResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool EcnrMicOutClipStatsResponse::operator < (const EcnrMicOutClipStatsResponse& rhs) const {
    if (hasClipFrames() || rhs.hasClipFrames()) {
        if (getClipFrames() < rhs.getClipFrames()) return true;
        if (getClipFrames() > rhs.getClipFrames()) return false;
    }
    if (hasClipCount() || rhs.hasClipCount()) {
        if (getClipCount() < rhs.getClipCount()) return true;
        if (getClipCount() > rhs.getClipCount()) return false;
    }
    if (hasMaxAmp() || rhs.hasMaxAmp()) {
        if (getMaxAmp() < rhs.getMaxAmp()) return true;
        if (getMaxAmp() > rhs.getMaxAmp()) return false;
    }
    if (hasMinAmp() || rhs.hasMinAmp()) {
        if (getMinAmp() < rhs.getMinAmp()) return true;
        if (getMinAmp() > rhs.getMinAmp()) return false;
    }
    return false;
}

inline ::asf::core::Payload* EcnrMicOutClipStatsResponse::clone() {
    return new EcnrMicOutClipStatsResponse(*this);
}

inline bool EcnrMicOutClipStatsResponse::operator > (const EcnrMicOutClipStatsResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void EcnrMicOutClipStatsResponse::clear() {
    clearClipFrames();
    clearClipCount();
    clearMaxAmp();
    clearMinAmp();
}

inline void EcnrMicOutClipStatsResponse::clearClipFrames() {
    if (hasClipFrames()) {
         clear_has_ClipFrames();
        _ClipFrames = 0u;
     }
}

inline bool EcnrMicOutClipStatsResponse::hasClipFrames () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 EcnrMicOutClipStatsResponse::getClipFrames () const {
    return _ClipFrames;
}

inline void EcnrMicOutClipStatsResponse::setClipFrames (uint32 ClipFrames_) {
    set_has_ClipFrames();
    this->_ClipFrames = ClipFrames_;
}

inline void EcnrMicOutClipStatsResponse::clearClipCount() {
    if (hasClipCount()) {
         clear_has_ClipCount();
        _ClipCount = 0u;
     }
}

inline bool EcnrMicOutClipStatsResponse::hasClipCount () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 EcnrMicOutClipStatsResponse::getClipCount () const {
    return _ClipCount;
}

inline void EcnrMicOutClipStatsResponse::setClipCount (uint32 ClipCount_) {
    set_has_ClipCount();
    this->_ClipCount = ClipCount_;
}

inline void EcnrMicOutClipStatsResponse::clearMaxAmp() {
    if (hasMaxAmp()) {
         clear_has_MaxAmp();
        _MaxAmp = 0;
     }
}

inline bool EcnrMicOutClipStatsResponse::hasMaxAmp () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline int32 EcnrMicOutClipStatsResponse::getMaxAmp () const {
    return _MaxAmp;
}

inline void EcnrMicOutClipStatsResponse::setMaxAmp (int32 MaxAmp_) {
    set_has_MaxAmp();
    this->_MaxAmp = MaxAmp_;
}

inline void EcnrMicOutClipStatsResponse::clearMinAmp() {
    if (hasMinAmp()) {
         clear_has_MinAmp();
        _MinAmp = 0;
     }
}

inline bool EcnrMicOutClipStatsResponse::hasMinAmp () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline int32 EcnrMicOutClipStatsResponse::getMinAmp () const {
    return _MinAmp;
}

inline void EcnrMicOutClipStatsResponse::setMinAmp (int32 MinAmp_) {
    set_has_MinAmp();
    this->_MinAmp = MinAmp_;
}

inline void EcnrMicOutClipStatsResponse::set_has_ClipFrames () {
    _has_bits_[0] |= 1u << 0;
}

inline void EcnrMicOutClipStatsResponse::clear_has_ClipFrames () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void EcnrMicOutClipStatsResponse::set_has_ClipCount () {
    _has_bits_[0] |= 1u << 1;
}

inline void EcnrMicOutClipStatsResponse::clear_has_ClipCount () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void EcnrMicOutClipStatsResponse::set_has_MaxAmp () {
    _has_bits_[0] |= 1u << 2;
}

inline void EcnrMicOutClipStatsResponse::clear_has_MaxAmp () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void EcnrMicOutClipStatsResponse::set_has_MinAmp () {
    _has_bits_[0] |= 1u << 3;
}

inline void EcnrMicOutClipStatsResponse::clear_has_MinAmp () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  EcnrRecvOutClipStatsResponse::EcnrRecvOutClipStatsResponse ()  :
    _ClipFrames (0u),
    _ClipCount (0u),
    _MaxAmp (0),
    _MinAmp (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  EcnrRecvOutClipStatsResponse::EcnrRecvOutClipStatsResponse (const EcnrRecvOutClipStatsResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _ClipFrames (0u),
    _ClipCount (0u),
    _MaxAmp (0),
    _MinAmp (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  EcnrRecvOutClipStatsResponse::EcnrRecvOutClipStatsResponse (uint32 ClipFrames_, uint32 ClipCount_, int32 MaxAmp_, int32 MinAmp_)  :
    _ClipFrames (ClipFrames_),
    _ClipCount (ClipCount_),
    _MaxAmp (MaxAmp_),
    _MinAmp (MinAmp_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  EcnrRecvOutClipStatsResponse::~EcnrRecvOutClipStatsResponse() {
}

inline EcnrRecvOutClipStatsResponse& EcnrRecvOutClipStatsResponse::operator = (const EcnrRecvOutClipStatsResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasClipFrames()) {
            setClipFrames(rhs.getClipFrames());
        } else {
            clearClipFrames();
        }
        if (rhs.hasClipCount()) {
            setClipCount(rhs.getClipCount());
        } else {
            clearClipCount();
        }
        if (rhs.hasMaxAmp()) {
            setMaxAmp(rhs.getMaxAmp());
        } else {
            clearMaxAmp();
        }
        if (rhs.hasMinAmp()) {
            setMinAmp(rhs.getMinAmp());
        } else {
            clearMinAmp();
        }
    }
    return *this;
}

inline bool EcnrRecvOutClipStatsResponse::operator == (const EcnrRecvOutClipStatsResponse& rhs) const {
    return (((!hasClipFrames() && !rhs.hasClipFrames()) || getClipFrames() == rhs.getClipFrames()) &&
        ((!hasClipCount() && !rhs.hasClipCount()) || getClipCount() == rhs.getClipCount()) &&
        ((!hasMaxAmp() && !rhs.hasMaxAmp()) || getMaxAmp() == rhs.getMaxAmp()) &&
        ((!hasMinAmp() && !rhs.hasMinAmp()) || getMinAmp() == rhs.getMinAmp()));
}

inline bool EcnrRecvOutClipStatsResponse::operator != (const EcnrRecvOutClipStatsResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool EcnrRecvOutClipStatsResponse::operator < (const EcnrRecvOutClipStatsResponse& rhs) const {
    if (hasClipFrames() || rhs.hasClipFrames()) {
        if (getClipFrames() < rhs.getClipFrames()) return true;
        if (getClipFrames() > rhs.getClipFrames()) return false;
    }
    if (hasClipCount() || rhs.hasClipCount()) {
        if (getClipCount() < rhs.getClipCount()) return true;
        if (getClipCount() > rhs.getClipCount()) return false;
    }
    if (hasMaxAmp() || rhs.hasMaxAmp()) {
        if (getMaxAmp() < rhs.getMaxAmp()) return true;
        if (getMaxAmp() > rhs.getMaxAmp()) return false;
    }
    if (hasMinAmp() || rhs.hasMinAmp()) {
        if (getMinAmp() < rhs.getMinAmp()) return true;
        if (getMinAmp() > rhs.getMinAmp()) return false;
    }
    return false;
}

inline ::asf::core::Payload* EcnrRecvOutClipStatsResponse::clone() {
    return new EcnrRecvOutClipStatsResponse(*this);
}

inline bool EcnrRecvOutClipStatsResponse::operator > (const EcnrRecvOutClipStatsResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void EcnrRecvOutClipStatsResponse::clear() {
    clearClipFrames();
    clearClipCount();
    clearMaxAmp();
    clearMinAmp();
}

inline void EcnrRecvOutClipStatsResponse::clearClipFrames() {
    if (hasClipFrames()) {
         clear_has_ClipFrames();
        _ClipFrames = 0u;
     }
}

inline bool EcnrRecvOutClipStatsResponse::hasClipFrames () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 EcnrRecvOutClipStatsResponse::getClipFrames () const {
    return _ClipFrames;
}

inline void EcnrRecvOutClipStatsResponse::setClipFrames (uint32 ClipFrames_) {
    set_has_ClipFrames();
    this->_ClipFrames = ClipFrames_;
}

inline void EcnrRecvOutClipStatsResponse::clearClipCount() {
    if (hasClipCount()) {
         clear_has_ClipCount();
        _ClipCount = 0u;
     }
}

inline bool EcnrRecvOutClipStatsResponse::hasClipCount () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 EcnrRecvOutClipStatsResponse::getClipCount () const {
    return _ClipCount;
}

inline void EcnrRecvOutClipStatsResponse::setClipCount (uint32 ClipCount_) {
    set_has_ClipCount();
    this->_ClipCount = ClipCount_;
}

inline void EcnrRecvOutClipStatsResponse::clearMaxAmp() {
    if (hasMaxAmp()) {
         clear_has_MaxAmp();
        _MaxAmp = 0;
     }
}

inline bool EcnrRecvOutClipStatsResponse::hasMaxAmp () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline int32 EcnrRecvOutClipStatsResponse::getMaxAmp () const {
    return _MaxAmp;
}

inline void EcnrRecvOutClipStatsResponse::setMaxAmp (int32 MaxAmp_) {
    set_has_MaxAmp();
    this->_MaxAmp = MaxAmp_;
}

inline void EcnrRecvOutClipStatsResponse::clearMinAmp() {
    if (hasMinAmp()) {
         clear_has_MinAmp();
        _MinAmp = 0;
     }
}

inline bool EcnrRecvOutClipStatsResponse::hasMinAmp () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline int32 EcnrRecvOutClipStatsResponse::getMinAmp () const {
    return _MinAmp;
}

inline void EcnrRecvOutClipStatsResponse::setMinAmp (int32 MinAmp_) {
    set_has_MinAmp();
    this->_MinAmp = MinAmp_;
}

inline void EcnrRecvOutClipStatsResponse::set_has_ClipFrames () {
    _has_bits_[0] |= 1u << 0;
}

inline void EcnrRecvOutClipStatsResponse::clear_has_ClipFrames () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void EcnrRecvOutClipStatsResponse::set_has_ClipCount () {
    _has_bits_[0] |= 1u << 1;
}

inline void EcnrRecvOutClipStatsResponse::clear_has_ClipCount () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void EcnrRecvOutClipStatsResponse::set_has_MaxAmp () {
    _has_bits_[0] |= 1u << 2;
}

inline void EcnrRecvOutClipStatsResponse::clear_has_MaxAmp () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void EcnrRecvOutClipStatsResponse::set_has_MinAmp () {
    _has_bits_[0] |= 1u << 3;
}

inline void EcnrRecvOutClipStatsResponse::clear_has_MinAmp () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  EcnrSetSendMuteSwitchRequest::EcnrSetSendMuteSwitchRequest ()  :
    _ecnrAppId (0u),
    _ecnrSendMuteSwitch (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  EcnrSetSendMuteSwitchRequest::EcnrSetSendMuteSwitchRequest (const EcnrSetSendMuteSwitchRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _ecnrAppId (0u),
    _ecnrSendMuteSwitch (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  EcnrSetSendMuteSwitchRequest::EcnrSetSendMuteSwitchRequest (uint8 ecnrAppId_, uint8 ecnrSendMuteSwitch_)  :
    _ecnrAppId (ecnrAppId_),
    _ecnrSendMuteSwitch (ecnrSendMuteSwitch_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  EcnrSetSendMuteSwitchRequest::~EcnrSetSendMuteSwitchRequest() {
}

inline EcnrSetSendMuteSwitchRequest& EcnrSetSendMuteSwitchRequest::operator = (const EcnrSetSendMuteSwitchRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasEcnrAppId()) {
            setEcnrAppId(rhs.getEcnrAppId());
        } else {
            clearEcnrAppId();
        }
        if (rhs.hasEcnrSendMuteSwitch()) {
            setEcnrSendMuteSwitch(rhs.getEcnrSendMuteSwitch());
        } else {
            clearEcnrSendMuteSwitch();
        }
    }
    return *this;
}

inline bool EcnrSetSendMuteSwitchRequest::operator == (const EcnrSetSendMuteSwitchRequest& rhs) const {
    return (((!hasEcnrAppId() && !rhs.hasEcnrAppId()) || getEcnrAppId() == rhs.getEcnrAppId()) &&
        ((!hasEcnrSendMuteSwitch() && !rhs.hasEcnrSendMuteSwitch()) || getEcnrSendMuteSwitch() == rhs.getEcnrSendMuteSwitch()));
}

inline bool EcnrSetSendMuteSwitchRequest::operator != (const EcnrSetSendMuteSwitchRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool EcnrSetSendMuteSwitchRequest::operator < (const EcnrSetSendMuteSwitchRequest& rhs) const {
    if (hasEcnrAppId() || rhs.hasEcnrAppId()) {
        if (getEcnrAppId() < rhs.getEcnrAppId()) return true;
        if (getEcnrAppId() > rhs.getEcnrAppId()) return false;
    }
    if (hasEcnrSendMuteSwitch() || rhs.hasEcnrSendMuteSwitch()) {
        if (getEcnrSendMuteSwitch() < rhs.getEcnrSendMuteSwitch()) return true;
        if (getEcnrSendMuteSwitch() > rhs.getEcnrSendMuteSwitch()) return false;
    }
    return false;
}

inline ::asf::core::Payload* EcnrSetSendMuteSwitchRequest::clone() {
    return new EcnrSetSendMuteSwitchRequest(*this);
}

inline bool EcnrSetSendMuteSwitchRequest::operator > (const EcnrSetSendMuteSwitchRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void EcnrSetSendMuteSwitchRequest::clear() {
    clearEcnrAppId();
    clearEcnrSendMuteSwitch();
}

inline void EcnrSetSendMuteSwitchRequest::clearEcnrAppId() {
    if (hasEcnrAppId()) {
         clear_has_ecnrAppId();
        _ecnrAppId = 0u;
     }
}

inline bool EcnrSetSendMuteSwitchRequest::hasEcnrAppId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 EcnrSetSendMuteSwitchRequest::getEcnrAppId () const {
    return _ecnrAppId;
}

inline void EcnrSetSendMuteSwitchRequest::setEcnrAppId (uint8 ecnrAppId_) {
    set_has_ecnrAppId();
    this->_ecnrAppId = ecnrAppId_;
}

inline void EcnrSetSendMuteSwitchRequest::clearEcnrSendMuteSwitch() {
    if (hasEcnrSendMuteSwitch()) {
         clear_has_ecnrSendMuteSwitch();
        _ecnrSendMuteSwitch = 0u;
     }
}

inline bool EcnrSetSendMuteSwitchRequest::hasEcnrSendMuteSwitch () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 EcnrSetSendMuteSwitchRequest::getEcnrSendMuteSwitch () const {
    return _ecnrSendMuteSwitch;
}

inline void EcnrSetSendMuteSwitchRequest::setEcnrSendMuteSwitch (uint8 ecnrSendMuteSwitch_) {
    set_has_ecnrSendMuteSwitch();
    this->_ecnrSendMuteSwitch = ecnrSendMuteSwitch_;
}

inline void EcnrSetSendMuteSwitchRequest::set_has_ecnrAppId () {
    _has_bits_[0] |= 1u << 0;
}

inline void EcnrSetSendMuteSwitchRequest::clear_has_ecnrAppId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void EcnrSetSendMuteSwitchRequest::set_has_ecnrSendMuteSwitch () {
    _has_bits_[0] |= 1u << 1;
}

inline void EcnrSetSendMuteSwitchRequest::clear_has_ecnrSendMuteSwitch () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  EcnrSetSendGainDeltaRequest::EcnrSetSendGainDeltaRequest ()  :
    _ecnrAppId (0u),
    _ecnrLevel (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  EcnrSetSendGainDeltaRequest::EcnrSetSendGainDeltaRequest (const EcnrSetSendGainDeltaRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _ecnrAppId (0u),
    _ecnrLevel (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  EcnrSetSendGainDeltaRequest::EcnrSetSendGainDeltaRequest (uint8 ecnrAppId_, int16 ecnrLevel_)  :
    _ecnrAppId (ecnrAppId_),
    _ecnrLevel (ecnrLevel_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  EcnrSetSendGainDeltaRequest::~EcnrSetSendGainDeltaRequest() {
}

inline EcnrSetSendGainDeltaRequest& EcnrSetSendGainDeltaRequest::operator = (const EcnrSetSendGainDeltaRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasEcnrAppId()) {
            setEcnrAppId(rhs.getEcnrAppId());
        } else {
            clearEcnrAppId();
        }
        if (rhs.hasEcnrLevel()) {
            setEcnrLevel(rhs.getEcnrLevel());
        } else {
            clearEcnrLevel();
        }
    }
    return *this;
}

inline bool EcnrSetSendGainDeltaRequest::operator == (const EcnrSetSendGainDeltaRequest& rhs) const {
    return (((!hasEcnrAppId() && !rhs.hasEcnrAppId()) || getEcnrAppId() == rhs.getEcnrAppId()) &&
        ((!hasEcnrLevel() && !rhs.hasEcnrLevel()) || getEcnrLevel() == rhs.getEcnrLevel()));
}

inline bool EcnrSetSendGainDeltaRequest::operator != (const EcnrSetSendGainDeltaRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool EcnrSetSendGainDeltaRequest::operator < (const EcnrSetSendGainDeltaRequest& rhs) const {
    if (hasEcnrAppId() || rhs.hasEcnrAppId()) {
        if (getEcnrAppId() < rhs.getEcnrAppId()) return true;
        if (getEcnrAppId() > rhs.getEcnrAppId()) return false;
    }
    if (hasEcnrLevel() || rhs.hasEcnrLevel()) {
        if (getEcnrLevel() < rhs.getEcnrLevel()) return true;
        if (getEcnrLevel() > rhs.getEcnrLevel()) return false;
    }
    return false;
}

inline ::asf::core::Payload* EcnrSetSendGainDeltaRequest::clone() {
    return new EcnrSetSendGainDeltaRequest(*this);
}

inline bool EcnrSetSendGainDeltaRequest::operator > (const EcnrSetSendGainDeltaRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void EcnrSetSendGainDeltaRequest::clear() {
    clearEcnrAppId();
    clearEcnrLevel();
}

inline void EcnrSetSendGainDeltaRequest::clearEcnrAppId() {
    if (hasEcnrAppId()) {
         clear_has_ecnrAppId();
        _ecnrAppId = 0u;
     }
}

inline bool EcnrSetSendGainDeltaRequest::hasEcnrAppId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 EcnrSetSendGainDeltaRequest::getEcnrAppId () const {
    return _ecnrAppId;
}

inline void EcnrSetSendGainDeltaRequest::setEcnrAppId (uint8 ecnrAppId_) {
    set_has_ecnrAppId();
    this->_ecnrAppId = ecnrAppId_;
}

inline void EcnrSetSendGainDeltaRequest::clearEcnrLevel() {
    if (hasEcnrLevel()) {
         clear_has_ecnrLevel();
        _ecnrLevel = 0;
     }
}

inline bool EcnrSetSendGainDeltaRequest::hasEcnrLevel () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline int16 EcnrSetSendGainDeltaRequest::getEcnrLevel () const {
    return _ecnrLevel;
}

inline void EcnrSetSendGainDeltaRequest::setEcnrLevel (int16 ecnrLevel_) {
    set_has_ecnrLevel();
    this->_ecnrLevel = ecnrLevel_;
}

inline void EcnrSetSendGainDeltaRequest::set_has_ecnrAppId () {
    _has_bits_[0] |= 1u << 0;
}

inline void EcnrSetSendGainDeltaRequest::clear_has_ecnrAppId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void EcnrSetSendGainDeltaRequest::set_has_ecnrLevel () {
    _has_bits_[0] |= 1u << 1;
}

inline void EcnrSetSendGainDeltaRequest::clear_has_ecnrLevel () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  EcnrSetMicGainRequest::EcnrSetMicGainRequest ()  :
    _MicGainLevel (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  EcnrSetMicGainRequest::EcnrSetMicGainRequest (const EcnrSetMicGainRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _MicGainLevel (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  EcnrSetMicGainRequest::EcnrSetMicGainRequest (int32 MicGainLevel_)  :
    _MicGainLevel (MicGainLevel_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  EcnrSetMicGainRequest::~EcnrSetMicGainRequest() {
}

inline EcnrSetMicGainRequest& EcnrSetMicGainRequest::operator = (const EcnrSetMicGainRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasMicGainLevel()) {
            setMicGainLevel(rhs.getMicGainLevel());
        } else {
            clearMicGainLevel();
        }
    }
    return *this;
}

inline bool EcnrSetMicGainRequest::operator == (const EcnrSetMicGainRequest& rhs) const {
    return (((!hasMicGainLevel() && !rhs.hasMicGainLevel()) || getMicGainLevel() == rhs.getMicGainLevel()));
}

inline bool EcnrSetMicGainRequest::operator != (const EcnrSetMicGainRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool EcnrSetMicGainRequest::operator < (const EcnrSetMicGainRequest& rhs) const {
    if (hasMicGainLevel() || rhs.hasMicGainLevel()) {
        if (getMicGainLevel() < rhs.getMicGainLevel()) return true;
        if (getMicGainLevel() > rhs.getMicGainLevel()) return false;
    }
    return false;
}

inline ::asf::core::Payload* EcnrSetMicGainRequest::clone() {
    return new EcnrSetMicGainRequest(*this);
}

inline bool EcnrSetMicGainRequest::operator > (const EcnrSetMicGainRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void EcnrSetMicGainRequest::clear() {
    clearMicGainLevel();
}

inline void EcnrSetMicGainRequest::clearMicGainLevel() {
    if (hasMicGainLevel()) {
         clear_has_MicGainLevel();
        _MicGainLevel = 0;
     }
}

inline bool EcnrSetMicGainRequest::hasMicGainLevel () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline int32 EcnrSetMicGainRequest::getMicGainLevel () const {
    return _MicGainLevel;
}

inline void EcnrSetMicGainRequest::setMicGainLevel (int32 MicGainLevel_) {
    set_has_MicGainLevel();
    this->_MicGainLevel = MicGainLevel_;
}

inline void EcnrSetMicGainRequest::set_has_MicGainLevel () {
    _has_bits_[0] |= 1u << 0;
}

inline void EcnrSetMicGainRequest::clear_has_MicGainLevel () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  EcnrSetPassThroughModeRequest::EcnrSetPassThroughModeRequest ()  :
    _ecnrAppId (0u),
    _ecnrPassThroughMode (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  EcnrSetPassThroughModeRequest::EcnrSetPassThroughModeRequest (const EcnrSetPassThroughModeRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _ecnrAppId (0u),
    _ecnrPassThroughMode (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  EcnrSetPassThroughModeRequest::EcnrSetPassThroughModeRequest (uint8 ecnrAppId_, uint8 ecnrPassThroughMode_)  :
    _ecnrAppId (ecnrAppId_),
    _ecnrPassThroughMode (ecnrPassThroughMode_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  EcnrSetPassThroughModeRequest::~EcnrSetPassThroughModeRequest() {
}

inline EcnrSetPassThroughModeRequest& EcnrSetPassThroughModeRequest::operator = (const EcnrSetPassThroughModeRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasEcnrAppId()) {
            setEcnrAppId(rhs.getEcnrAppId());
        } else {
            clearEcnrAppId();
        }
        if (rhs.hasEcnrPassThroughMode()) {
            setEcnrPassThroughMode(rhs.getEcnrPassThroughMode());
        } else {
            clearEcnrPassThroughMode();
        }
    }
    return *this;
}

inline bool EcnrSetPassThroughModeRequest::operator == (const EcnrSetPassThroughModeRequest& rhs) const {
    return (((!hasEcnrAppId() && !rhs.hasEcnrAppId()) || getEcnrAppId() == rhs.getEcnrAppId()) &&
        ((!hasEcnrPassThroughMode() && !rhs.hasEcnrPassThroughMode()) || getEcnrPassThroughMode() == rhs.getEcnrPassThroughMode()));
}

inline bool EcnrSetPassThroughModeRequest::operator != (const EcnrSetPassThroughModeRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool EcnrSetPassThroughModeRequest::operator < (const EcnrSetPassThroughModeRequest& rhs) const {
    if (hasEcnrAppId() || rhs.hasEcnrAppId()) {
        if (getEcnrAppId() < rhs.getEcnrAppId()) return true;
        if (getEcnrAppId() > rhs.getEcnrAppId()) return false;
    }
    if (hasEcnrPassThroughMode() || rhs.hasEcnrPassThroughMode()) {
        if (getEcnrPassThroughMode() < rhs.getEcnrPassThroughMode()) return true;
        if (getEcnrPassThroughMode() > rhs.getEcnrPassThroughMode()) return false;
    }
    return false;
}

inline ::asf::core::Payload* EcnrSetPassThroughModeRequest::clone() {
    return new EcnrSetPassThroughModeRequest(*this);
}

inline bool EcnrSetPassThroughModeRequest::operator > (const EcnrSetPassThroughModeRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void EcnrSetPassThroughModeRequest::clear() {
    clearEcnrAppId();
    clearEcnrPassThroughMode();
}

inline void EcnrSetPassThroughModeRequest::clearEcnrAppId() {
    if (hasEcnrAppId()) {
         clear_has_ecnrAppId();
        _ecnrAppId = 0u;
     }
}

inline bool EcnrSetPassThroughModeRequest::hasEcnrAppId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 EcnrSetPassThroughModeRequest::getEcnrAppId () const {
    return _ecnrAppId;
}

inline void EcnrSetPassThroughModeRequest::setEcnrAppId (uint8 ecnrAppId_) {
    set_has_ecnrAppId();
    this->_ecnrAppId = ecnrAppId_;
}

inline void EcnrSetPassThroughModeRequest::clearEcnrPassThroughMode() {
    if (hasEcnrPassThroughMode()) {
         clear_has_ecnrPassThroughMode();
        _ecnrPassThroughMode = 0u;
     }
}

inline bool EcnrSetPassThroughModeRequest::hasEcnrPassThroughMode () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 EcnrSetPassThroughModeRequest::getEcnrPassThroughMode () const {
    return _ecnrPassThroughMode;
}

inline void EcnrSetPassThroughModeRequest::setEcnrPassThroughMode (uint8 ecnrPassThroughMode_) {
    set_has_ecnrPassThroughMode();
    this->_ecnrPassThroughMode = ecnrPassThroughMode_;
}

inline void EcnrSetPassThroughModeRequest::set_has_ecnrAppId () {
    _has_bits_[0] |= 1u << 0;
}

inline void EcnrSetPassThroughModeRequest::clear_has_ecnrAppId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void EcnrSetPassThroughModeRequest::set_has_ecnrPassThroughMode () {
    _has_bits_[0] |= 1u << 1;
}

inline void EcnrSetPassThroughModeRequest::clear_has_ecnrPassThroughMode () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  EcnrSetNRCombFloorRequest::EcnrSetNRCombFloorRequest ()  :
    _ecnrAppId (0u),
    _ecnrNRCombFloor (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  EcnrSetNRCombFloorRequest::EcnrSetNRCombFloorRequest (const EcnrSetNRCombFloorRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _ecnrAppId (0u),
    _ecnrNRCombFloor (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  EcnrSetNRCombFloorRequest::EcnrSetNRCombFloorRequest (uint8 ecnrAppId_, int16 ecnrNRCombFloor_)  :
    _ecnrAppId (ecnrAppId_),
    _ecnrNRCombFloor (ecnrNRCombFloor_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  EcnrSetNRCombFloorRequest::~EcnrSetNRCombFloorRequest() {
}

inline EcnrSetNRCombFloorRequest& EcnrSetNRCombFloorRequest::operator = (const EcnrSetNRCombFloorRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasEcnrAppId()) {
            setEcnrAppId(rhs.getEcnrAppId());
        } else {
            clearEcnrAppId();
        }
        if (rhs.hasEcnrNRCombFloor()) {
            setEcnrNRCombFloor(rhs.getEcnrNRCombFloor());
        } else {
            clearEcnrNRCombFloor();
        }
    }
    return *this;
}

inline bool EcnrSetNRCombFloorRequest::operator == (const EcnrSetNRCombFloorRequest& rhs) const {
    return (((!hasEcnrAppId() && !rhs.hasEcnrAppId()) || getEcnrAppId() == rhs.getEcnrAppId()) &&
        ((!hasEcnrNRCombFloor() && !rhs.hasEcnrNRCombFloor()) || getEcnrNRCombFloor() == rhs.getEcnrNRCombFloor()));
}

inline bool EcnrSetNRCombFloorRequest::operator != (const EcnrSetNRCombFloorRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool EcnrSetNRCombFloorRequest::operator < (const EcnrSetNRCombFloorRequest& rhs) const {
    if (hasEcnrAppId() || rhs.hasEcnrAppId()) {
        if (getEcnrAppId() < rhs.getEcnrAppId()) return true;
        if (getEcnrAppId() > rhs.getEcnrAppId()) return false;
    }
    if (hasEcnrNRCombFloor() || rhs.hasEcnrNRCombFloor()) {
        if (getEcnrNRCombFloor() < rhs.getEcnrNRCombFloor()) return true;
        if (getEcnrNRCombFloor() > rhs.getEcnrNRCombFloor()) return false;
    }
    return false;
}

inline ::asf::core::Payload* EcnrSetNRCombFloorRequest::clone() {
    return new EcnrSetNRCombFloorRequest(*this);
}

inline bool EcnrSetNRCombFloorRequest::operator > (const EcnrSetNRCombFloorRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void EcnrSetNRCombFloorRequest::clear() {
    clearEcnrAppId();
    clearEcnrNRCombFloor();
}

inline void EcnrSetNRCombFloorRequest::clearEcnrAppId() {
    if (hasEcnrAppId()) {
         clear_has_ecnrAppId();
        _ecnrAppId = 0u;
     }
}

inline bool EcnrSetNRCombFloorRequest::hasEcnrAppId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 EcnrSetNRCombFloorRequest::getEcnrAppId () const {
    return _ecnrAppId;
}

inline void EcnrSetNRCombFloorRequest::setEcnrAppId (uint8 ecnrAppId_) {
    set_has_ecnrAppId();
    this->_ecnrAppId = ecnrAppId_;
}

inline void EcnrSetNRCombFloorRequest::clearEcnrNRCombFloor() {
    if (hasEcnrNRCombFloor()) {
         clear_has_ecnrNRCombFloor();
        _ecnrNRCombFloor = 0;
     }
}

inline bool EcnrSetNRCombFloorRequest::hasEcnrNRCombFloor () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline int16 EcnrSetNRCombFloorRequest::getEcnrNRCombFloor () const {
    return _ecnrNRCombFloor;
}

inline void EcnrSetNRCombFloorRequest::setEcnrNRCombFloor (int16 ecnrNRCombFloor_) {
    set_has_ecnrNRCombFloor();
    this->_ecnrNRCombFloor = ecnrNRCombFloor_;
}

inline void EcnrSetNRCombFloorRequest::set_has_ecnrAppId () {
    _has_bits_[0] |= 1u << 0;
}

inline void EcnrSetNRCombFloorRequest::clear_has_ecnrAppId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void EcnrSetNRCombFloorRequest::set_has_ecnrNRCombFloor () {
    _has_bits_[0] |= 1u << 1;
}

inline void EcnrSetNRCombFloorRequest::clear_has_ecnrNRCombFloor () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  EcnrSetEchoCancellationRequest::EcnrSetEchoCancellationRequest ()  :
    _ecnrAppId (0u),
    _EcnrECState (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  EcnrSetEchoCancellationRequest::EcnrSetEchoCancellationRequest (const EcnrSetEchoCancellationRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _ecnrAppId (0u),
    _EcnrECState (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  EcnrSetEchoCancellationRequest::EcnrSetEchoCancellationRequest (uint8 ecnrAppId_, uint8 EcnrECState_)  :
    _ecnrAppId (ecnrAppId_),
    _EcnrECState (EcnrECState_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  EcnrSetEchoCancellationRequest::~EcnrSetEchoCancellationRequest() {
}

inline EcnrSetEchoCancellationRequest& EcnrSetEchoCancellationRequest::operator = (const EcnrSetEchoCancellationRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasEcnrAppId()) {
            setEcnrAppId(rhs.getEcnrAppId());
        } else {
            clearEcnrAppId();
        }
        if (rhs.hasEcnrECState()) {
            setEcnrECState(rhs.getEcnrECState());
        } else {
            clearEcnrECState();
        }
    }
    return *this;
}

inline bool EcnrSetEchoCancellationRequest::operator == (const EcnrSetEchoCancellationRequest& rhs) const {
    return (((!hasEcnrAppId() && !rhs.hasEcnrAppId()) || getEcnrAppId() == rhs.getEcnrAppId()) &&
        ((!hasEcnrECState() && !rhs.hasEcnrECState()) || getEcnrECState() == rhs.getEcnrECState()));
}

inline bool EcnrSetEchoCancellationRequest::operator != (const EcnrSetEchoCancellationRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool EcnrSetEchoCancellationRequest::operator < (const EcnrSetEchoCancellationRequest& rhs) const {
    if (hasEcnrAppId() || rhs.hasEcnrAppId()) {
        if (getEcnrAppId() < rhs.getEcnrAppId()) return true;
        if (getEcnrAppId() > rhs.getEcnrAppId()) return false;
    }
    if (hasEcnrECState() || rhs.hasEcnrECState()) {
        if (getEcnrECState() < rhs.getEcnrECState()) return true;
        if (getEcnrECState() > rhs.getEcnrECState()) return false;
    }
    return false;
}

inline ::asf::core::Payload* EcnrSetEchoCancellationRequest::clone() {
    return new EcnrSetEchoCancellationRequest(*this);
}

inline bool EcnrSetEchoCancellationRequest::operator > (const EcnrSetEchoCancellationRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void EcnrSetEchoCancellationRequest::clear() {
    clearEcnrAppId();
    clearEcnrECState();
}

inline void EcnrSetEchoCancellationRequest::clearEcnrAppId() {
    if (hasEcnrAppId()) {
         clear_has_ecnrAppId();
        _ecnrAppId = 0u;
     }
}

inline bool EcnrSetEchoCancellationRequest::hasEcnrAppId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 EcnrSetEchoCancellationRequest::getEcnrAppId () const {
    return _ecnrAppId;
}

inline void EcnrSetEchoCancellationRequest::setEcnrAppId (uint8 ecnrAppId_) {
    set_has_ecnrAppId();
    this->_ecnrAppId = ecnrAppId_;
}

inline void EcnrSetEchoCancellationRequest::clearEcnrECState() {
    if (hasEcnrECState()) {
         clear_has_EcnrECState();
        _EcnrECState = 0u;
     }
}

inline bool EcnrSetEchoCancellationRequest::hasEcnrECState () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 EcnrSetEchoCancellationRequest::getEcnrECState () const {
    return _EcnrECState;
}

inline void EcnrSetEchoCancellationRequest::setEcnrECState (uint8 EcnrECState_) {
    set_has_EcnrECState();
    this->_EcnrECState = EcnrECState_;
}

inline void EcnrSetEchoCancellationRequest::set_has_ecnrAppId () {
    _has_bits_[0] |= 1u << 0;
}

inline void EcnrSetEchoCancellationRequest::clear_has_ecnrAppId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void EcnrSetEchoCancellationRequest::set_has_EcnrECState () {
    _has_bits_[0] |= 1u << 1;
}

inline void EcnrSetEchoCancellationRequest::clear_has_EcnrECState () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  EcnrSetNoiseReductionRequest::EcnrSetNoiseReductionRequest ()  :
    _ecnrAppId (0u),
    _EcnrNRState (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  EcnrSetNoiseReductionRequest::EcnrSetNoiseReductionRequest (const EcnrSetNoiseReductionRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _ecnrAppId (0u),
    _EcnrNRState (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  EcnrSetNoiseReductionRequest::EcnrSetNoiseReductionRequest (uint8 ecnrAppId_, uint8 EcnrNRState_)  :
    _ecnrAppId (ecnrAppId_),
    _EcnrNRState (EcnrNRState_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  EcnrSetNoiseReductionRequest::~EcnrSetNoiseReductionRequest() {
}

inline EcnrSetNoiseReductionRequest& EcnrSetNoiseReductionRequest::operator = (const EcnrSetNoiseReductionRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasEcnrAppId()) {
            setEcnrAppId(rhs.getEcnrAppId());
        } else {
            clearEcnrAppId();
        }
        if (rhs.hasEcnrNRState()) {
            setEcnrNRState(rhs.getEcnrNRState());
        } else {
            clearEcnrNRState();
        }
    }
    return *this;
}

inline bool EcnrSetNoiseReductionRequest::operator == (const EcnrSetNoiseReductionRequest& rhs) const {
    return (((!hasEcnrAppId() && !rhs.hasEcnrAppId()) || getEcnrAppId() == rhs.getEcnrAppId()) &&
        ((!hasEcnrNRState() && !rhs.hasEcnrNRState()) || getEcnrNRState() == rhs.getEcnrNRState()));
}

inline bool EcnrSetNoiseReductionRequest::operator != (const EcnrSetNoiseReductionRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool EcnrSetNoiseReductionRequest::operator < (const EcnrSetNoiseReductionRequest& rhs) const {
    if (hasEcnrAppId() || rhs.hasEcnrAppId()) {
        if (getEcnrAppId() < rhs.getEcnrAppId()) return true;
        if (getEcnrAppId() > rhs.getEcnrAppId()) return false;
    }
    if (hasEcnrNRState() || rhs.hasEcnrNRState()) {
        if (getEcnrNRState() < rhs.getEcnrNRState()) return true;
        if (getEcnrNRState() > rhs.getEcnrNRState()) return false;
    }
    return false;
}

inline ::asf::core::Payload* EcnrSetNoiseReductionRequest::clone() {
    return new EcnrSetNoiseReductionRequest(*this);
}

inline bool EcnrSetNoiseReductionRequest::operator > (const EcnrSetNoiseReductionRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void EcnrSetNoiseReductionRequest::clear() {
    clearEcnrAppId();
    clearEcnrNRState();
}

inline void EcnrSetNoiseReductionRequest::clearEcnrAppId() {
    if (hasEcnrAppId()) {
         clear_has_ecnrAppId();
        _ecnrAppId = 0u;
     }
}

inline bool EcnrSetNoiseReductionRequest::hasEcnrAppId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 EcnrSetNoiseReductionRequest::getEcnrAppId () const {
    return _ecnrAppId;
}

inline void EcnrSetNoiseReductionRequest::setEcnrAppId (uint8 ecnrAppId_) {
    set_has_ecnrAppId();
    this->_ecnrAppId = ecnrAppId_;
}

inline void EcnrSetNoiseReductionRequest::clearEcnrNRState() {
    if (hasEcnrNRState()) {
         clear_has_EcnrNRState();
        _EcnrNRState = 0u;
     }
}

inline bool EcnrSetNoiseReductionRequest::hasEcnrNRState () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 EcnrSetNoiseReductionRequest::getEcnrNRState () const {
    return _EcnrNRState;
}

inline void EcnrSetNoiseReductionRequest::setEcnrNRState (uint8 EcnrNRState_) {
    set_has_EcnrNRState();
    this->_EcnrNRState = EcnrNRState_;
}

inline void EcnrSetNoiseReductionRequest::set_has_ecnrAppId () {
    _has_bits_[0] |= 1u << 0;
}

inline void EcnrSetNoiseReductionRequest::clear_has_ecnrAppId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void EcnrSetNoiseReductionRequest::set_has_EcnrNRState () {
    _has_bits_[0] |= 1u << 1;
}

inline void EcnrSetNoiseReductionRequest::clear_has_EcnrNRState () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  EcnrGetEngineParameterRequest::EcnrGetEngineParameterRequest ()  :
    _ecnrParameterId (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  EcnrGetEngineParameterRequest::EcnrGetEngineParameterRequest (const EcnrGetEngineParameterRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _ecnrParameterId (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  EcnrGetEngineParameterRequest::EcnrGetEngineParameterRequest (uint32 ecnrParameterId_)  :
    _ecnrParameterId (ecnrParameterId_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  EcnrGetEngineParameterRequest::~EcnrGetEngineParameterRequest() {
}

inline EcnrGetEngineParameterRequest& EcnrGetEngineParameterRequest::operator = (const EcnrGetEngineParameterRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasEcnrParameterId()) {
            setEcnrParameterId(rhs.getEcnrParameterId());
        } else {
            clearEcnrParameterId();
        }
    }
    return *this;
}

inline bool EcnrGetEngineParameterRequest::operator == (const EcnrGetEngineParameterRequest& rhs) const {
    return (((!hasEcnrParameterId() && !rhs.hasEcnrParameterId()) || getEcnrParameterId() == rhs.getEcnrParameterId()));
}

inline bool EcnrGetEngineParameterRequest::operator != (const EcnrGetEngineParameterRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool EcnrGetEngineParameterRequest::operator < (const EcnrGetEngineParameterRequest& rhs) const {
    if (hasEcnrParameterId() || rhs.hasEcnrParameterId()) {
        if (getEcnrParameterId() < rhs.getEcnrParameterId()) return true;
        if (getEcnrParameterId() > rhs.getEcnrParameterId()) return false;
    }
    return false;
}

inline ::asf::core::Payload* EcnrGetEngineParameterRequest::clone() {
    return new EcnrGetEngineParameterRequest(*this);
}

inline bool EcnrGetEngineParameterRequest::operator > (const EcnrGetEngineParameterRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void EcnrGetEngineParameterRequest::clear() {
    clearEcnrParameterId();
}

inline void EcnrGetEngineParameterRequest::clearEcnrParameterId() {
    if (hasEcnrParameterId()) {
         clear_has_ecnrParameterId();
        _ecnrParameterId = 0u;
     }
}

inline bool EcnrGetEngineParameterRequest::hasEcnrParameterId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 EcnrGetEngineParameterRequest::getEcnrParameterId () const {
    return _ecnrParameterId;
}

inline void EcnrGetEngineParameterRequest::setEcnrParameterId (uint32 ecnrParameterId_) {
    set_has_ecnrParameterId();
    this->_ecnrParameterId = ecnrParameterId_;
}

inline void EcnrGetEngineParameterRequest::set_has_ecnrParameterId () {
    _has_bits_[0] |= 1u << 0;
}

inline void EcnrGetEngineParameterRequest::clear_has_ecnrParameterId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  EcnrGetEngineParameterResponse::EcnrGetEngineParameterResponse ()  :
    _data ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  EcnrGetEngineParameterResponse::EcnrGetEngineParameterResponse (const EcnrGetEngineParameterResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _data ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  EcnrGetEngineParameterResponse::EcnrGetEngineParameterResponse (const ::std::vector< uint8 >& data_)  :
    _data (data_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  EcnrGetEngineParameterResponse::~EcnrGetEngineParameterResponse() {
}

inline EcnrGetEngineParameterResponse& EcnrGetEngineParameterResponse::operator = (const EcnrGetEngineParameterResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasData()) {
            setData(rhs.getData());
        } else {
            clearData();
        }
    }
    return *this;
}

inline bool EcnrGetEngineParameterResponse::operator == (const EcnrGetEngineParameterResponse& rhs) const {
    return (((!hasData() && !rhs.hasData()) || getData() == rhs.getData()));
}

inline bool EcnrGetEngineParameterResponse::operator != (const EcnrGetEngineParameterResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool EcnrGetEngineParameterResponse::operator < (const EcnrGetEngineParameterResponse& rhs) const {
    if (hasData() || rhs.hasData()) {
        if (getData() < rhs.getData()) return true;
        if (getData() > rhs.getData()) return false;
    }
    return false;
}

inline ::asf::core::Payload* EcnrGetEngineParameterResponse::clone() {
    return new EcnrGetEngineParameterResponse(*this);
}

inline bool EcnrGetEngineParameterResponse::operator > (const EcnrGetEngineParameterResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void EcnrGetEngineParameterResponse::clear() {
    clearData();
}

inline void EcnrGetEngineParameterResponse::clearData() {
    if (hasData()) {
         clear_has_data();
        _data.clear();
     }
}

inline bool EcnrGetEngineParameterResponse::hasData () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< uint8 >& EcnrGetEngineParameterResponse::getData () const {
    return _data;
}

inline ::std::vector< uint8 >& EcnrGetEngineParameterResponse::getDataMutable () {
    set_has_data();
    return _data;
}

inline void EcnrGetEngineParameterResponse::setData (const ::std::vector< uint8 >& data_) {
    set_has_data();
    this->_data = data_;
}

inline void EcnrGetEngineParameterResponse::set_has_data () {
    _has_bits_[0] |= 1u << 0;
}

inline void EcnrGetEngineParameterResponse::clear_has_data () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  EcnrStartItcTestRequest::EcnrStartItcTestRequest ()  :
    _ITCValue (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  EcnrStartItcTestRequest::EcnrStartItcTestRequest (const EcnrStartItcTestRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _ITCValue (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  EcnrStartItcTestRequest::EcnrStartItcTestRequest (int32 ITCValue_)  :
    _ITCValue (ITCValue_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  EcnrStartItcTestRequest::~EcnrStartItcTestRequest() {
}

inline EcnrStartItcTestRequest& EcnrStartItcTestRequest::operator = (const EcnrStartItcTestRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasITCValue()) {
            setITCValue(rhs.getITCValue());
        } else {
            clearITCValue();
        }
    }
    return *this;
}

inline bool EcnrStartItcTestRequest::operator == (const EcnrStartItcTestRequest& rhs) const {
    return (((!hasITCValue() && !rhs.hasITCValue()) || getITCValue() == rhs.getITCValue()));
}

inline bool EcnrStartItcTestRequest::operator != (const EcnrStartItcTestRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool EcnrStartItcTestRequest::operator < (const EcnrStartItcTestRequest& rhs) const {
    if (hasITCValue() || rhs.hasITCValue()) {
        if (getITCValue() < rhs.getITCValue()) return true;
        if (getITCValue() > rhs.getITCValue()) return false;
    }
    return false;
}

inline ::asf::core::Payload* EcnrStartItcTestRequest::clone() {
    return new EcnrStartItcTestRequest(*this);
}

inline bool EcnrStartItcTestRequest::operator > (const EcnrStartItcTestRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void EcnrStartItcTestRequest::clear() {
    clearITCValue();
}

inline void EcnrStartItcTestRequest::clearITCValue() {
    if (hasITCValue()) {
         clear_has_ITCValue();
        _ITCValue = 0;
     }
}

inline bool EcnrStartItcTestRequest::hasITCValue () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline int32 EcnrStartItcTestRequest::getITCValue () const {
    return _ITCValue;
}

inline void EcnrStartItcTestRequest::setITCValue (int32 ITCValue_) {
    set_has_ITCValue();
    this->_ITCValue = ITCValue_;
}

inline void EcnrStartItcTestRequest::set_has_ITCValue () {
    _has_bits_[0] |= 1u << 0;
}

inline void EcnrStartItcTestRequest::clear_has_ITCValue () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  EcnrStartItcTestResponse::EcnrStartItcTestResponse ()  :
    _rspITCValue (0),
    _TestResult (0u),
    _TestErrorCode (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  EcnrStartItcTestResponse::EcnrStartItcTestResponse (const EcnrStartItcTestResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _rspITCValue (0),
    _TestResult (0u),
    _TestErrorCode (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  EcnrStartItcTestResponse::EcnrStartItcTestResponse (int32 rspITCValue_, uint8 TestResult_, int32 TestErrorCode_)  :
    _rspITCValue (rspITCValue_),
    _TestResult (TestResult_),
    _TestErrorCode (TestErrorCode_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  EcnrStartItcTestResponse::~EcnrStartItcTestResponse() {
}

inline EcnrStartItcTestResponse& EcnrStartItcTestResponse::operator = (const EcnrStartItcTestResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasRspITCValue()) {
            setRspITCValue(rhs.getRspITCValue());
        } else {
            clearRspITCValue();
        }
        if (rhs.hasTestResult()) {
            setTestResult(rhs.getTestResult());
        } else {
            clearTestResult();
        }
        if (rhs.hasTestErrorCode()) {
            setTestErrorCode(rhs.getTestErrorCode());
        } else {
            clearTestErrorCode();
        }
    }
    return *this;
}

inline bool EcnrStartItcTestResponse::operator == (const EcnrStartItcTestResponse& rhs) const {
    return (((!hasRspITCValue() && !rhs.hasRspITCValue()) || getRspITCValue() == rhs.getRspITCValue()) &&
        ((!hasTestResult() && !rhs.hasTestResult()) || getTestResult() == rhs.getTestResult()) &&
        ((!hasTestErrorCode() && !rhs.hasTestErrorCode()) || getTestErrorCode() == rhs.getTestErrorCode()));
}

inline bool EcnrStartItcTestResponse::operator != (const EcnrStartItcTestResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool EcnrStartItcTestResponse::operator < (const EcnrStartItcTestResponse& rhs) const {
    if (hasRspITCValue() || rhs.hasRspITCValue()) {
        if (getRspITCValue() < rhs.getRspITCValue()) return true;
        if (getRspITCValue() > rhs.getRspITCValue()) return false;
    }
    if (hasTestResult() || rhs.hasTestResult()) {
        if (getTestResult() < rhs.getTestResult()) return true;
        if (getTestResult() > rhs.getTestResult()) return false;
    }
    if (hasTestErrorCode() || rhs.hasTestErrorCode()) {
        if (getTestErrorCode() < rhs.getTestErrorCode()) return true;
        if (getTestErrorCode() > rhs.getTestErrorCode()) return false;
    }
    return false;
}

inline ::asf::core::Payload* EcnrStartItcTestResponse::clone() {
    return new EcnrStartItcTestResponse(*this);
}

inline bool EcnrStartItcTestResponse::operator > (const EcnrStartItcTestResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void EcnrStartItcTestResponse::clear() {
    clearRspITCValue();
    clearTestResult();
    clearTestErrorCode();
}

inline void EcnrStartItcTestResponse::clearRspITCValue() {
    if (hasRspITCValue()) {
         clear_has_rspITCValue();
        _rspITCValue = 0;
     }
}

inline bool EcnrStartItcTestResponse::hasRspITCValue () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline int32 EcnrStartItcTestResponse::getRspITCValue () const {
    return _rspITCValue;
}

inline void EcnrStartItcTestResponse::setRspITCValue (int32 rspITCValue_) {
    set_has_rspITCValue();
    this->_rspITCValue = rspITCValue_;
}

inline void EcnrStartItcTestResponse::clearTestResult() {
    if (hasTestResult()) {
         clear_has_TestResult();
        _TestResult = 0u;
     }
}

inline bool EcnrStartItcTestResponse::hasTestResult () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 EcnrStartItcTestResponse::getTestResult () const {
    return _TestResult;
}

inline void EcnrStartItcTestResponse::setTestResult (uint8 TestResult_) {
    set_has_TestResult();
    this->_TestResult = TestResult_;
}

inline void EcnrStartItcTestResponse::clearTestErrorCode() {
    if (hasTestErrorCode()) {
         clear_has_TestErrorCode();
        _TestErrorCode = 0;
     }
}

inline bool EcnrStartItcTestResponse::hasTestErrorCode () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline int32 EcnrStartItcTestResponse::getTestErrorCode () const {
    return _TestErrorCode;
}

inline void EcnrStartItcTestResponse::setTestErrorCode (int32 TestErrorCode_) {
    set_has_TestErrorCode();
    this->_TestErrorCode = TestErrorCode_;
}

inline void EcnrStartItcTestResponse::set_has_rspITCValue () {
    _has_bits_[0] |= 1u << 0;
}

inline void EcnrStartItcTestResponse::clear_has_rspITCValue () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void EcnrStartItcTestResponse::set_has_TestResult () {
    _has_bits_[0] |= 1u << 1;
}

inline void EcnrStartItcTestResponse::clear_has_TestResult () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void EcnrStartItcTestResponse::set_has_TestErrorCode () {
    _has_bits_[0] |= 1u << 2;
}

inline void EcnrStartItcTestResponse::clear_has_TestErrorCode () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  EcnrMicLvlNtfyIntervalUpdate::EcnrMicLvlNtfyIntervalUpdate ()  :
    _ecnrMicLvlNtfyInterval (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  EcnrMicLvlNtfyIntervalUpdate::EcnrMicLvlNtfyIntervalUpdate (const EcnrMicLvlNtfyIntervalUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _ecnrMicLvlNtfyInterval (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  EcnrMicLvlNtfyIntervalUpdate::EcnrMicLvlNtfyIntervalUpdate (uint32 ecnrMicLvlNtfyInterval_)  :
    _ecnrMicLvlNtfyInterval (ecnrMicLvlNtfyInterval_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  EcnrMicLvlNtfyIntervalUpdate::~EcnrMicLvlNtfyIntervalUpdate() {
}

inline EcnrMicLvlNtfyIntervalUpdate& EcnrMicLvlNtfyIntervalUpdate::operator = (const EcnrMicLvlNtfyIntervalUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasEcnrMicLvlNtfyInterval()) {
            setEcnrMicLvlNtfyInterval(rhs.getEcnrMicLvlNtfyInterval());
        } else {
            clearEcnrMicLvlNtfyInterval();
        }
    }
    return *this;
}

inline bool EcnrMicLvlNtfyIntervalUpdate::operator == (const EcnrMicLvlNtfyIntervalUpdate& rhs) const {
    return (((!hasEcnrMicLvlNtfyInterval() && !rhs.hasEcnrMicLvlNtfyInterval()) || getEcnrMicLvlNtfyInterval() == rhs.getEcnrMicLvlNtfyInterval()));
}

inline bool EcnrMicLvlNtfyIntervalUpdate::operator != (const EcnrMicLvlNtfyIntervalUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool EcnrMicLvlNtfyIntervalUpdate::operator < (const EcnrMicLvlNtfyIntervalUpdate& rhs) const {
    if (hasEcnrMicLvlNtfyInterval() || rhs.hasEcnrMicLvlNtfyInterval()) {
        if (getEcnrMicLvlNtfyInterval() < rhs.getEcnrMicLvlNtfyInterval()) return true;
        if (getEcnrMicLvlNtfyInterval() > rhs.getEcnrMicLvlNtfyInterval()) return false;
    }
    return false;
}

inline ::asf::core::Payload* EcnrMicLvlNtfyIntervalUpdate::clone() {
    return new EcnrMicLvlNtfyIntervalUpdate(*this);
}

inline bool EcnrMicLvlNtfyIntervalUpdate::operator > (const EcnrMicLvlNtfyIntervalUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void EcnrMicLvlNtfyIntervalUpdate::clear() {
    clearEcnrMicLvlNtfyInterval();
}

inline void EcnrMicLvlNtfyIntervalUpdate::clearEcnrMicLvlNtfyInterval() {
    if (hasEcnrMicLvlNtfyInterval()) {
         clear_has_ecnrMicLvlNtfyInterval();
        _ecnrMicLvlNtfyInterval = 0u;
     }
}

inline bool EcnrMicLvlNtfyIntervalUpdate::hasEcnrMicLvlNtfyInterval () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 EcnrMicLvlNtfyIntervalUpdate::getEcnrMicLvlNtfyInterval () const {
    return _ecnrMicLvlNtfyInterval;
}

inline void EcnrMicLvlNtfyIntervalUpdate::setEcnrMicLvlNtfyInterval (uint32 ecnrMicLvlNtfyInterval_) {
    set_has_ecnrMicLvlNtfyInterval();
    this->_ecnrMicLvlNtfyInterval = ecnrMicLvlNtfyInterval_;
}

inline void EcnrMicLvlNtfyIntervalUpdate::set_has_ecnrMicLvlNtfyInterval () {
    _has_bits_[0] |= 1u << 0;
}

inline void EcnrMicLvlNtfyIntervalUpdate::clear_has_ecnrMicLvlNtfyInterval () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  EcnrMicLvlNtfyIntervalRegister::EcnrMicLvlNtfyIntervalRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  EcnrMicLvlNtfyIntervalRegister::EcnrMicLvlNtfyIntervalRegister (const EcnrMicLvlNtfyIntervalRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  EcnrMicLvlNtfyIntervalRegister::~EcnrMicLvlNtfyIntervalRegister() {
}

inline EcnrMicLvlNtfyIntervalRegister& EcnrMicLvlNtfyIntervalRegister::operator = (const EcnrMicLvlNtfyIntervalRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool EcnrMicLvlNtfyIntervalRegister::operator == (const EcnrMicLvlNtfyIntervalRegister& ) const {
    return true;
}

inline bool EcnrMicLvlNtfyIntervalRegister::operator != (const EcnrMicLvlNtfyIntervalRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool EcnrMicLvlNtfyIntervalRegister::operator < (const EcnrMicLvlNtfyIntervalRegister& ) const {
    return false;
}

inline ::asf::core::Payload* EcnrMicLvlNtfyIntervalRegister::clone() {
    return new EcnrMicLvlNtfyIntervalRegister(*this);
}

inline bool EcnrMicLvlNtfyIntervalRegister::operator > (const EcnrMicLvlNtfyIntervalRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void EcnrMicLvlNtfyIntervalRegister::clear() {
}

inline  EcnrAsrModeUpdate::EcnrAsrModeUpdate ()  :
    _ecnrAsrMode (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  EcnrAsrModeUpdate::EcnrAsrModeUpdate (const EcnrAsrModeUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _ecnrAsrMode (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  EcnrAsrModeUpdate::EcnrAsrModeUpdate (int32 ecnrAsrMode_)  :
    _ecnrAsrMode (ecnrAsrMode_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  EcnrAsrModeUpdate::~EcnrAsrModeUpdate() {
}

inline EcnrAsrModeUpdate& EcnrAsrModeUpdate::operator = (const EcnrAsrModeUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasEcnrAsrMode()) {
            setEcnrAsrMode(rhs.getEcnrAsrMode());
        } else {
            clearEcnrAsrMode();
        }
    }
    return *this;
}

inline bool EcnrAsrModeUpdate::operator == (const EcnrAsrModeUpdate& rhs) const {
    return (((!hasEcnrAsrMode() && !rhs.hasEcnrAsrMode()) || getEcnrAsrMode() == rhs.getEcnrAsrMode()));
}

inline bool EcnrAsrModeUpdate::operator != (const EcnrAsrModeUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool EcnrAsrModeUpdate::operator < (const EcnrAsrModeUpdate& rhs) const {
    if (hasEcnrAsrMode() || rhs.hasEcnrAsrMode()) {
        if (getEcnrAsrMode() < rhs.getEcnrAsrMode()) return true;
        if (getEcnrAsrMode() > rhs.getEcnrAsrMode()) return false;
    }
    return false;
}

inline ::asf::core::Payload* EcnrAsrModeUpdate::clone() {
    return new EcnrAsrModeUpdate(*this);
}

inline bool EcnrAsrModeUpdate::operator > (const EcnrAsrModeUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void EcnrAsrModeUpdate::clear() {
    clearEcnrAsrMode();
}

inline void EcnrAsrModeUpdate::clearEcnrAsrMode() {
    if (hasEcnrAsrMode()) {
         clear_has_ecnrAsrMode();
        _ecnrAsrMode = 0;
     }
}

inline bool EcnrAsrModeUpdate::hasEcnrAsrMode () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline int32 EcnrAsrModeUpdate::getEcnrAsrMode () const {
    return _ecnrAsrMode;
}

inline void EcnrAsrModeUpdate::setEcnrAsrMode (int32 ecnrAsrMode_) {
    set_has_ecnrAsrMode();
    this->_ecnrAsrMode = ecnrAsrMode_;
}

inline void EcnrAsrModeUpdate::set_has_ecnrAsrMode () {
    _has_bits_[0] |= 1u << 0;
}

inline void EcnrAsrModeUpdate::clear_has_ecnrAsrMode () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  EcnrAsrModeRegister::EcnrAsrModeRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  EcnrAsrModeRegister::EcnrAsrModeRegister (const EcnrAsrModeRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  EcnrAsrModeRegister::~EcnrAsrModeRegister() {
}

inline EcnrAsrModeRegister& EcnrAsrModeRegister::operator = (const EcnrAsrModeRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool EcnrAsrModeRegister::operator == (const EcnrAsrModeRegister& ) const {
    return true;
}

inline bool EcnrAsrModeRegister::operator != (const EcnrAsrModeRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool EcnrAsrModeRegister::operator < (const EcnrAsrModeRegister& ) const {
    return false;
}

inline ::asf::core::Payload* EcnrAsrModeRegister::clone() {
    return new EcnrAsrModeRegister(*this);
}

inline bool EcnrAsrModeRegister::operator > (const EcnrAsrModeRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void EcnrAsrModeRegister::clear() {
}

inline  EcnrAudioStateUpdate::EcnrAudioStateUpdate ()  :
    _ecnrAudioState (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  EcnrAudioStateUpdate::EcnrAudioStateUpdate (const EcnrAudioStateUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _ecnrAudioState (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  EcnrAudioStateUpdate::EcnrAudioStateUpdate (int32 ecnrAudioState_)  :
    _ecnrAudioState (ecnrAudioState_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  EcnrAudioStateUpdate::~EcnrAudioStateUpdate() {
}

inline EcnrAudioStateUpdate& EcnrAudioStateUpdate::operator = (const EcnrAudioStateUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasEcnrAudioState()) {
            setEcnrAudioState(rhs.getEcnrAudioState());
        } else {
            clearEcnrAudioState();
        }
    }
    return *this;
}

inline bool EcnrAudioStateUpdate::operator == (const EcnrAudioStateUpdate& rhs) const {
    return (((!hasEcnrAudioState() && !rhs.hasEcnrAudioState()) || getEcnrAudioState() == rhs.getEcnrAudioState()));
}

inline bool EcnrAudioStateUpdate::operator != (const EcnrAudioStateUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool EcnrAudioStateUpdate::operator < (const EcnrAudioStateUpdate& rhs) const {
    if (hasEcnrAudioState() || rhs.hasEcnrAudioState()) {
        if (getEcnrAudioState() < rhs.getEcnrAudioState()) return true;
        if (getEcnrAudioState() > rhs.getEcnrAudioState()) return false;
    }
    return false;
}

inline ::asf::core::Payload* EcnrAudioStateUpdate::clone() {
    return new EcnrAudioStateUpdate(*this);
}

inline bool EcnrAudioStateUpdate::operator > (const EcnrAudioStateUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void EcnrAudioStateUpdate::clear() {
    clearEcnrAudioState();
}

inline void EcnrAudioStateUpdate::clearEcnrAudioState() {
    if (hasEcnrAudioState()) {
         clear_has_ecnrAudioState();
        _ecnrAudioState = 0;
     }
}

inline bool EcnrAudioStateUpdate::hasEcnrAudioState () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline int32 EcnrAudioStateUpdate::getEcnrAudioState () const {
    return _ecnrAudioState;
}

inline void EcnrAudioStateUpdate::setEcnrAudioState (int32 ecnrAudioState_) {
    set_has_ecnrAudioState();
    this->_ecnrAudioState = ecnrAudioState_;
}

inline void EcnrAudioStateUpdate::set_has_ecnrAudioState () {
    _has_bits_[0] |= 1u << 0;
}

inline void EcnrAudioStateUpdate::clear_has_ecnrAudioState () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  EcnrAudioStateRegister::EcnrAudioStateRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  EcnrAudioStateRegister::EcnrAudioStateRegister (const EcnrAudioStateRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  EcnrAudioStateRegister::~EcnrAudioStateRegister() {
}

inline EcnrAudioStateRegister& EcnrAudioStateRegister::operator = (const EcnrAudioStateRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool EcnrAudioStateRegister::operator == (const EcnrAudioStateRegister& ) const {
    return true;
}

inline bool EcnrAudioStateRegister::operator != (const EcnrAudioStateRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool EcnrAudioStateRegister::operator < (const EcnrAudioStateRegister& ) const {
    return false;
}

inline ::asf::core::Payload* EcnrAudioStateRegister::clone() {
    return new EcnrAudioStateRegister(*this);
}

inline bool EcnrAudioStateRegister::operator > (const EcnrAudioStateRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void EcnrAudioStateRegister::clear() {
}

inline  EcnrAsrDataTypeUpdate::EcnrAsrDataTypeUpdate ()  :
    _ecnrAsrDataType ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  EcnrAsrDataTypeUpdate::EcnrAsrDataTypeUpdate (const EcnrAsrDataTypeUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _ecnrAsrDataType ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  EcnrAsrDataTypeUpdate::EcnrAsrDataTypeUpdate (const ::std::vector< uint8 >& ecnrAsrDataType_)  :
    _ecnrAsrDataType (ecnrAsrDataType_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  EcnrAsrDataTypeUpdate::~EcnrAsrDataTypeUpdate() {
}

inline EcnrAsrDataTypeUpdate& EcnrAsrDataTypeUpdate::operator = (const EcnrAsrDataTypeUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasEcnrAsrDataType()) {
            setEcnrAsrDataType(rhs.getEcnrAsrDataType());
        } else {
            clearEcnrAsrDataType();
        }
    }
    return *this;
}

inline bool EcnrAsrDataTypeUpdate::operator == (const EcnrAsrDataTypeUpdate& rhs) const {
    return (((!hasEcnrAsrDataType() && !rhs.hasEcnrAsrDataType()) || getEcnrAsrDataType() == rhs.getEcnrAsrDataType()));
}

inline bool EcnrAsrDataTypeUpdate::operator != (const EcnrAsrDataTypeUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool EcnrAsrDataTypeUpdate::operator < (const EcnrAsrDataTypeUpdate& rhs) const {
    if (hasEcnrAsrDataType() || rhs.hasEcnrAsrDataType()) {
        if (getEcnrAsrDataType() < rhs.getEcnrAsrDataType()) return true;
        if (getEcnrAsrDataType() > rhs.getEcnrAsrDataType()) return false;
    }
    return false;
}

inline ::asf::core::Payload* EcnrAsrDataTypeUpdate::clone() {
    return new EcnrAsrDataTypeUpdate(*this);
}

inline bool EcnrAsrDataTypeUpdate::operator > (const EcnrAsrDataTypeUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void EcnrAsrDataTypeUpdate::clear() {
    clearEcnrAsrDataType();
}

inline void EcnrAsrDataTypeUpdate::clearEcnrAsrDataType() {
    if (hasEcnrAsrDataType()) {
         clear_has_ecnrAsrDataType();
        _ecnrAsrDataType.clear();
     }
}

inline bool EcnrAsrDataTypeUpdate::hasEcnrAsrDataType () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< uint8 >& EcnrAsrDataTypeUpdate::getEcnrAsrDataType () const {
    return _ecnrAsrDataType;
}

inline ::std::vector< uint8 >& EcnrAsrDataTypeUpdate::getEcnrAsrDataTypeMutable () {
    set_has_ecnrAsrDataType();
    return _ecnrAsrDataType;
}

inline void EcnrAsrDataTypeUpdate::setEcnrAsrDataType (const ::std::vector< uint8 >& ecnrAsrDataType_) {
    set_has_ecnrAsrDataType();
    this->_ecnrAsrDataType = ecnrAsrDataType_;
}

inline void EcnrAsrDataTypeUpdate::set_has_ecnrAsrDataType () {
    _has_bits_[0] |= 1u << 0;
}

inline void EcnrAsrDataTypeUpdate::clear_has_ecnrAsrDataType () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  EcnrAsrDataTypeRegister::EcnrAsrDataTypeRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  EcnrAsrDataTypeRegister::EcnrAsrDataTypeRegister (const EcnrAsrDataTypeRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  EcnrAsrDataTypeRegister::~EcnrAsrDataTypeRegister() {
}

inline EcnrAsrDataTypeRegister& EcnrAsrDataTypeRegister::operator = (const EcnrAsrDataTypeRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool EcnrAsrDataTypeRegister::operator == (const EcnrAsrDataTypeRegister& ) const {
    return true;
}

inline bool EcnrAsrDataTypeRegister::operator != (const EcnrAsrDataTypeRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool EcnrAsrDataTypeRegister::operator < (const EcnrAsrDataTypeRegister& ) const {
    return false;
}

inline ::asf::core::Payload* EcnrAsrDataTypeRegister::clone() {
    return new EcnrAsrDataTypeRegister(*this);
}

inline bool EcnrAsrDataTypeRegister::operator > (const EcnrAsrDataTypeRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void EcnrAsrDataTypeRegister::clear() {
}

inline  EcnrAsrModeEnableSignal::EcnrAsrModeEnableSignal ()  :
    _StatusAsrMode (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  EcnrAsrModeEnableSignal::EcnrAsrModeEnableSignal (const EcnrAsrModeEnableSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _StatusAsrMode (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  EcnrAsrModeEnableSignal::EcnrAsrModeEnableSignal (int32 StatusAsrMode_)  :
    _StatusAsrMode (StatusAsrMode_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  EcnrAsrModeEnableSignal::~EcnrAsrModeEnableSignal() {
}

inline EcnrAsrModeEnableSignal& EcnrAsrModeEnableSignal::operator = (const EcnrAsrModeEnableSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasStatusAsrMode()) {
            setStatusAsrMode(rhs.getStatusAsrMode());
        } else {
            clearStatusAsrMode();
        }
    }
    return *this;
}

inline bool EcnrAsrModeEnableSignal::operator == (const EcnrAsrModeEnableSignal& rhs) const {
    return (((!hasStatusAsrMode() && !rhs.hasStatusAsrMode()) || getStatusAsrMode() == rhs.getStatusAsrMode()));
}

inline bool EcnrAsrModeEnableSignal::operator != (const EcnrAsrModeEnableSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool EcnrAsrModeEnableSignal::operator < (const EcnrAsrModeEnableSignal& rhs) const {
    if (hasStatusAsrMode() || rhs.hasStatusAsrMode()) {
        if (getStatusAsrMode() < rhs.getStatusAsrMode()) return true;
        if (getStatusAsrMode() > rhs.getStatusAsrMode()) return false;
    }
    return false;
}

inline ::asf::core::Payload* EcnrAsrModeEnableSignal::clone() {
    return new EcnrAsrModeEnableSignal(*this);
}

inline bool EcnrAsrModeEnableSignal::operator > (const EcnrAsrModeEnableSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void EcnrAsrModeEnableSignal::clear() {
    clearStatusAsrMode();
}

inline void EcnrAsrModeEnableSignal::clearStatusAsrMode() {
    if (hasStatusAsrMode()) {
         clear_has_StatusAsrMode();
        _StatusAsrMode = 0;
     }
}

inline bool EcnrAsrModeEnableSignal::hasStatusAsrMode () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline int32 EcnrAsrModeEnableSignal::getStatusAsrMode () const {
    return _StatusAsrMode;
}

inline void EcnrAsrModeEnableSignal::setStatusAsrMode (int32 StatusAsrMode_) {
    set_has_StatusAsrMode();
    this->_StatusAsrMode = StatusAsrMode_;
}

inline void EcnrAsrModeEnableSignal::set_has_StatusAsrMode () {
    _has_bits_[0] |= 1u << 0;
}

inline void EcnrAsrModeEnableSignal::clear_has_StatusAsrMode () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  EcnrAudioStatusSignal::EcnrAudioStatusSignal ()  :
    _AudioStatus (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  EcnrAudioStatusSignal::EcnrAudioStatusSignal (const EcnrAudioStatusSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _AudioStatus (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  EcnrAudioStatusSignal::EcnrAudioStatusSignal (int32 AudioStatus_)  :
    _AudioStatus (AudioStatus_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  EcnrAudioStatusSignal::~EcnrAudioStatusSignal() {
}

inline EcnrAudioStatusSignal& EcnrAudioStatusSignal::operator = (const EcnrAudioStatusSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasAudioStatus()) {
            setAudioStatus(rhs.getAudioStatus());
        } else {
            clearAudioStatus();
        }
    }
    return *this;
}

inline bool EcnrAudioStatusSignal::operator == (const EcnrAudioStatusSignal& rhs) const {
    return (((!hasAudioStatus() && !rhs.hasAudioStatus()) || getAudioStatus() == rhs.getAudioStatus()));
}

inline bool EcnrAudioStatusSignal::operator != (const EcnrAudioStatusSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool EcnrAudioStatusSignal::operator < (const EcnrAudioStatusSignal& rhs) const {
    if (hasAudioStatus() || rhs.hasAudioStatus()) {
        if (getAudioStatus() < rhs.getAudioStatus()) return true;
        if (getAudioStatus() > rhs.getAudioStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* EcnrAudioStatusSignal::clone() {
    return new EcnrAudioStatusSignal(*this);
}

inline bool EcnrAudioStatusSignal::operator > (const EcnrAudioStatusSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void EcnrAudioStatusSignal::clear() {
    clearAudioStatus();
}

inline void EcnrAudioStatusSignal::clearAudioStatus() {
    if (hasAudioStatus()) {
         clear_has_AudioStatus();
        _AudioStatus = 0;
     }
}

inline bool EcnrAudioStatusSignal::hasAudioStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline int32 EcnrAudioStatusSignal::getAudioStatus () const {
    return _AudioStatus;
}

inline void EcnrAudioStatusSignal::setAudioStatus (int32 AudioStatus_) {
    set_has_AudioStatus();
    this->_AudioStatus = AudioStatus_;
}

inline void EcnrAudioStatusSignal::set_has_AudioStatus () {
    _has_bits_[0] |= 1u << 0;
}

inline void EcnrAudioStatusSignal::clear_has_AudioStatus () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  EcnrMicroLevelStatusSignal::EcnrMicroLevelStatusSignal ()  :
    _StatusMicroLevel (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  EcnrMicroLevelStatusSignal::EcnrMicroLevelStatusSignal (const EcnrMicroLevelStatusSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _StatusMicroLevel (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  EcnrMicroLevelStatusSignal::EcnrMicroLevelStatusSignal (uint32 StatusMicroLevel_)  :
    _StatusMicroLevel (StatusMicroLevel_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  EcnrMicroLevelStatusSignal::~EcnrMicroLevelStatusSignal() {
}

inline EcnrMicroLevelStatusSignal& EcnrMicroLevelStatusSignal::operator = (const EcnrMicroLevelStatusSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasStatusMicroLevel()) {
            setStatusMicroLevel(rhs.getStatusMicroLevel());
        } else {
            clearStatusMicroLevel();
        }
    }
    return *this;
}

inline bool EcnrMicroLevelStatusSignal::operator == (const EcnrMicroLevelStatusSignal& rhs) const {
    return (((!hasStatusMicroLevel() && !rhs.hasStatusMicroLevel()) || getStatusMicroLevel() == rhs.getStatusMicroLevel()));
}

inline bool EcnrMicroLevelStatusSignal::operator != (const EcnrMicroLevelStatusSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool EcnrMicroLevelStatusSignal::operator < (const EcnrMicroLevelStatusSignal& rhs) const {
    if (hasStatusMicroLevel() || rhs.hasStatusMicroLevel()) {
        if (getStatusMicroLevel() < rhs.getStatusMicroLevel()) return true;
        if (getStatusMicroLevel() > rhs.getStatusMicroLevel()) return false;
    }
    return false;
}

inline ::asf::core::Payload* EcnrMicroLevelStatusSignal::clone() {
    return new EcnrMicroLevelStatusSignal(*this);
}

inline bool EcnrMicroLevelStatusSignal::operator > (const EcnrMicroLevelStatusSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void EcnrMicroLevelStatusSignal::clear() {
    clearStatusMicroLevel();
}

inline void EcnrMicroLevelStatusSignal::clearStatusMicroLevel() {
    if (hasStatusMicroLevel()) {
         clear_has_StatusMicroLevel();
        _StatusMicroLevel = 0u;
     }
}

inline bool EcnrMicroLevelStatusSignal::hasStatusMicroLevel () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 EcnrMicroLevelStatusSignal::getStatusMicroLevel () const {
    return _StatusMicroLevel;
}

inline void EcnrMicroLevelStatusSignal::setStatusMicroLevel (uint32 StatusMicroLevel_) {
    set_has_StatusMicroLevel();
    this->_StatusMicroLevel = StatusMicroLevel_;
}

inline void EcnrMicroLevelStatusSignal::set_has_StatusMicroLevel () {
    _has_bits_[0] |= 1u << 0;
}

inline void EcnrMicroLevelStatusSignal::clear_has_StatusMicroLevel () {
    _has_bits_[0] &= ~ (1u << 0);
}

} // namespace service
} // namespace ecnr
} // namespace bosch
} // namespace org

#endif // ORG_BOSCH_ECNR_SERVICE_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
