/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "org/bosch/ecnr/dbug.h"
#include "org/bosch/ecnr/dbugDBus.h"
#include "org/bosch/ecnr/dbugJson.h"
#include "org/bosch/ecnr/dbugProxy.h"

#include "asf/dbus/DBusDaemonProxy.h"
#include "asf/dbus/DBusPropertiesProxyWrapper.h"
#include "asf/dbus/DBusProxyDelegate.h"
#include "asf/dbus/DBusMessage.h"

namespace org {
namespace bosch {
namespace ecnr {
namespace dbug {

DEFINE_CLASS_LOGGER("///org/bosch/ecnr/dbug", DbugProxy);

class DbugProxyCallback : public ::asf::dbus::DBusProxyCallback {
public:

    DbugProxyCallback(uint16 functionId, void* callback) :
        ::asf::dbus::DBusProxyCallback (functionId, callback)
    {}

    bool processMessage (::asf::dbus::DBusMessage &message) {
        const ::boost::shared_ptr< DbugProxy >& proxyShared = ::boost::static_pointer_cast< DbugProxy >(message.getDBusProxyShared()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        switch (_functionId) {
            case ID_ecnrStartDebugData:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), EcnrStartDebugDataError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "EcnrStartDebugData", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<EcnrStartDebugDataError> payload = ::boost::static_pointer_cast<EcnrStartDebugDataError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((EcnrStartDebugDataCallbackIF*) _callback)->onEcnrStartDebugDataError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), EcnrStartDebugDataResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "EcnrStartDebugData", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<EcnrStartDebugDataResponse> payload = ::boost::static_pointer_cast<EcnrStartDebugDataResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((EcnrStartDebugDataCallbackIF*) _callback)->onEcnrStartDebugDataResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_ecnrEndDebugData:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), EcnrEndDebugDataError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "EcnrEndDebugData", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<EcnrEndDebugDataError> payload = ::boost::static_pointer_cast<EcnrEndDebugDataError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((EcnrEndDebugDataCallbackIF*) _callback)->onEcnrEndDebugDataError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), EcnrEndDebugDataResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "EcnrEndDebugData", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<EcnrEndDebugDataResponse> payload = ::boost::static_pointer_cast<EcnrEndDebugDataResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((EcnrEndDebugDataCallbackIF*) _callback)->onEcnrEndDebugDataResponse (proxyShared, payload);
                        return true;
                    }
                }
            default:
            LOG_FATAL ("Received an invalid functionId, proxy=%p", message.getProxy());
        }
        LOG_FATAL("Receveid an invalid message, proxy=%p", message.getProxy());
        return false;
    }

    bool onServiceUnavailable (const ::boost::shared_ptr< ::asf::core::Proxy >& baseProxy) {
        switch (_functionId) {
            case ID_ecnrStartDebugData: {
                ::boost::shared_ptr< EcnrStartDebugDataError > payload = ::boost::shared_ptr< EcnrStartDebugDataError >
                (new EcnrStartDebugDataError(DBUS_ERROR_NO_SERVER, "The DBus service Dbug is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "EcnrStartDebugData", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<DbugProxy> proxyShared = ::boost::static_pointer_cast<DbugProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((EcnrStartDebugDataCallbackIF*) _callback)->onEcnrStartDebugDataError (proxyShared,payload);
                return true;
            }
            break;
            case ID_ecnrEndDebugData: {
                ::boost::shared_ptr< EcnrEndDebugDataError > payload = ::boost::shared_ptr< EcnrEndDebugDataError >
                (new EcnrEndDebugDataError(DBUS_ERROR_NO_SERVER, "The DBus service Dbug is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "EcnrEndDebugData", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<DbugProxy> proxyShared = ::boost::static_pointer_cast<DbugProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((EcnrEndDebugDataCallbackIF*) _callback)->onEcnrEndDebugDataError (proxyShared,payload);
                return true;
            }
            break;
            default:
                break;
        }
        return false;
    }

    static ::asf::core::Logger&_logger;
};

::asf::core::Logger& DbugProxyCallback::_logger (DbugProxy::_logger);

DbugProxy::DbugProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable) :
    ::asf::dbus::DBusProxy(portName, "org.bosch.ecnr.dbug", serviceAvailable, _logger) {
}

DbugProxy::~DbugProxy()
{
    ::asf::dbus::DBusConnector::getConnector(getConnectorOptions())->deregisterProxyDelegate(_dbusProxyDelegate);
}

// static
::boost::shared_ptr< DbugProxy > DbugProxy::createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable) {
    ::boost::shared_ptr< Proxy > proxyReuse = ::asf::dbus::DBusConnector::getProxy(portName, serviceAvailable);
    if(proxyReuse) {
        LOG_INFO_STATIC ("createProxy, reuse existing proxy");
        return ::boost::static_pointer_cast<DbugProxy>(proxyReuse); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
    }
    LOG_INFO_STATIC ("createProxy, create new proxy");
    ::boost::shared_ptr< DbugProxy > proxyNew(new DbugProxy(portName, serviceAvailable));
    ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew);
    proxyNew->createHelperProxies(false);
    return proxyNew;
}

act_t DbugProxy::addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const {
    DbugProxyCallback* callback = new DbugProxyCallback(methodId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->addMethodCallback (serial, memberName, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

act_t DbugProxy::addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const {
    DbugProxyCallback* callback = new DbugProxyCallback(signalId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->registerSignalCallback (signal, reinterpret_cast<act_t>(callback), ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}



act_t DbugProxy::sendEcnrStartDebugDataRequest(EcnrStartDebugDataCallbackIF& cb, uint8 ecnrDebugMode) const {
    EcnrStartDebugDataRequest* payload = new EcnrStartDebugDataRequest();
    CHECK_ALLOCATION(payload);
    payload->setEcnrDebugMode(ecnrDebugMode);
    DBUS_MESSAGE_CALL(dbusMessage, "ecnrStartDebugData", EcnrStartDebugDataRequest, payload, true)
    act_t act = addMethodCallback(ID_ecnrStartDebugData, dbusMessage.getUniqueSerial(), "ecnrStartDebugData", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "EcnrStartDebugData", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t DbugProxy::sendEcnrEndDebugDataRequest(EcnrEndDebugDataCallbackIF& cb, uint8 ecnrDebugMode) const {
    EcnrEndDebugDataRequest* payload = new EcnrEndDebugDataRequest();
    CHECK_ALLOCATION(payload);
    payload->setEcnrDebugMode(ecnrDebugMode);
    DBUS_MESSAGE_CALL(dbusMessage, "ecnrEndDebugData", EcnrEndDebugDataRequest, payload, true)
    act_t act = addMethodCallback(ID_ecnrEndDebugData, dbusMessage.getUniqueSerial(), "ecnrEndDebugData", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "EcnrEndDebugData", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

} // namespace dbug
} // namespace ecnr
} // namespace bosch
} // namespace org
