/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/dbus/DBusStubDelegate.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "org/bosch/ecnr/alsa.h"
#include "org/bosch/ecnr/alsaDBus.h"
#include "org/bosch/ecnr/alsaJson.h"
#include "org/bosch/ecnr/alsaStub.h"

#include "asf/dbus/DBusMessage.h"

namespace org {
namespace bosch {
namespace ecnr {
namespace alsa {

DEFINE_CLASS_LOGGER("///org/bosch/ecnr/alsa", AlsaStub);

static ::asf::dbus::DBusUtils::stringEntry methodsTable[] = {
    { 17, "ecnrAlsaSetDevice", 0 },
    { 19, "ecnrAlsaSetWideBand", 2 },
    { 25, "ecnrAlsaSetThreadPriority", 1 },
    { 27, "ecnrAlsaSetDeviceProperties", 3 },
};


class AlsaStubDelegate : public ::asf::dbus::DBusStubDelegate {
public:

    AlsaStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger) :
        ::asf::dbus::DBusStubDelegate( stub, logger),
        _logger(logger)
    {}

    AlsaStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger, const std::string& objectPath) :
        ::asf::dbus::DBusStubDelegate( stub, logger, objectPath),
        _logger(logger) {}

    AlsaStubDelegate(::asf::dbus::DBusStub* stub,
                               ::asf::core::Logger& logger,
                               ::asf::dbus::DBusConnector& connector,
                               const std::string& objectPath)
        : ::asf::dbus::DBusStubDelegate(
              stub, logger, connector, objectPath, "org.bosch.ecnr.alsa"),
          _logger(logger) {}

    virtual ~AlsaStubDelegate() {}

    virtual void process(::asf::core::ServiceMessage& msg);

    const char* introspect() const;

    virtual void getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties);

    virtual void setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act);

    virtual void getProperty(const ::std::string& property, const act_t& act);

private:

    ::asf::core::Logger& _logger;

};

void AlsaStubDelegate::process(::asf::core::ServiceMessage& msg) {
    ::asf::dbus::DBusMessage& message = static_cast< ::asf::dbus::DBusMessage& >(msg);
    LOG_DEBUG_STUB("Entering process(memberName='%s')", message.getMemberName().c_str());

    unsigned int methodIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (message.getMemberName().c_str(), message.getMemberName().length(), methodsTable, 4, methodIndex)) {
        switch (methodIndex) {
        case 0: {

            // method 'ecnrAlsaSetDevice'

            LOG_DEBUG_STUB("process method '%s'", "ecnrAlsaSetDevice");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), EcnrAlsaSetDeviceRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "EcnrAlsaSetDevice", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< EcnrAlsaSetDeviceRequest > payload = ::boost::static_pointer_cast<EcnrAlsaSetDeviceRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<AlsaStub*>(getStub())->onEcnrAlsaSetDeviceRequest(payload);
            return;
        }
        case 1: {

            // method 'ecnrAlsaSetThreadPriority'

            LOG_DEBUG_STUB("process method '%s'", "ecnrAlsaSetThreadPriority");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), EcnrAlsaSetThreadPriorityRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "EcnrAlsaSetThreadPriority", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< EcnrAlsaSetThreadPriorityRequest > payload = ::boost::static_pointer_cast<EcnrAlsaSetThreadPriorityRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<AlsaStub*>(getStub())->onEcnrAlsaSetThreadPriorityRequest(payload);
            return;
        }
        case 2: {

            // method 'ecnrAlsaSetWideBand'

            LOG_DEBUG_STUB("process method '%s'", "ecnrAlsaSetWideBand");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), EcnrAlsaSetWideBandRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "EcnrAlsaSetWideBand", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< EcnrAlsaSetWideBandRequest > payload = ::boost::static_pointer_cast<EcnrAlsaSetWideBandRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<AlsaStub*>(getStub())->onEcnrAlsaSetWideBandRequest(payload);
            return;
        }
        case 3: {

            // method 'ecnrAlsaSetDeviceProperties'

            LOG_DEBUG_STUB("process method '%s'", "ecnrAlsaSetDeviceProperties");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), EcnrAlsaSetDevicePropertiesRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "EcnrAlsaSetDeviceProperties", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< EcnrAlsaSetDevicePropertiesRequest > payload = ::boost::static_pointer_cast<EcnrAlsaSetDevicePropertiesRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<AlsaStub*>(getStub())->onEcnrAlsaSetDevicePropertiesRequest(payload);
            return;
        }
        default:
            break;
        }
    }
    LOG_FATAL_STUB("can't process message %s", message.getMemberName().c_str());
}

const char* AlsaStubDelegate::introspect() const {
    return     "<interface name=\"org.bosch.ecnr.alsa\">\n"
            "      <method name=\"ecnrAlsaSetDevice\">\n"
            "        <arg direction=\"in\" name=\"ecnrAppId\" type=\"y\"/>\n"
            "        <arg direction=\"in\" name=\"AlsaDeviceSelect\" type=\"u\"/>\n"
            "        <arg direction=\"in\" name=\"AlsaDeviceName\" type=\"s\"/>\n"
            "      </method>\n"
            "      <method name=\"ecnrAlsaSetThreadPriority\">\n"
            "        <arg direction=\"in\" name=\"ecnrAppId\" type=\"y\"/>\n"
            "        <arg direction=\"in\" name=\"priority\" type=\"u\"/>\n"
            "      </method>\n"
            "      <method name=\"ecnrAlsaSetWideBand\">\n"
            "        <arg direction=\"in\" name=\"ecnrAppId\" type=\"y\"/>\n"
            "      </method>\n"
            "      <method name=\"ecnrAlsaSetDeviceProperties\">\n"
            "        <arg direction=\"in\" name=\"ecnrAppId\" type=\"y\"/>\n"
            "        <arg direction=\"in\" name=\"AlsaDeviceSelect\" type=\"u\"/>\n"
            "        <arg direction=\"in\" name=\"AlsaDeviceProperty\" type=\"y\"/>\n"
            "        <arg direction=\"in\" name=\"PropertyValue\" type=\"u\"/>\n"
            "      </method>\n"
            "</interface>\n";
}

void AlsaStubDelegate::getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) {
    (static_cast<AlsaStub*>(getStub()))->onGetAll (properties);
}

void AlsaStubDelegate::setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act) {
    ((void)value);  // to get rid of unused variable warning
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendSetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

void AlsaStubDelegate::getProperty(const ::std::string& property, const act_t& act) {
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendGetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

AlsaStub::AlsaStub (const std::string& portName) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new AlsaStubDelegate(this, _logger);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

AlsaStub::AlsaStub (const std::string& portName, const std::string& objectPath) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new AlsaStubDelegate(this, _logger, objectPath);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

AlsaStub::~AlsaStub() {
    delete _stubDelegate;
}

void  AlsaStub::sendEcnrAlsaSetDeviceResponse (act_t act) {
    EcnrAlsaSetDeviceResponse* payload = new EcnrAlsaSetDeviceResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "ecnrAlsaSetDevice", EcnrAlsaSetDeviceResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "EcnrAlsaSetDevice", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  AlsaStub::sendEcnrAlsaSetDeviceError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    EcnrAlsaSetDeviceError* payload = new EcnrAlsaSetDeviceError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "ecnrAlsaSetDevice", EcnrAlsaSetDeviceError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "EcnrAlsaSetDevice", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  AlsaStub::sendEcnrAlsaSetThreadPriorityResponse (act_t act) {
    EcnrAlsaSetThreadPriorityResponse* payload = new EcnrAlsaSetThreadPriorityResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "ecnrAlsaSetThreadPriority", EcnrAlsaSetThreadPriorityResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "EcnrAlsaSetThreadPriority", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  AlsaStub::sendEcnrAlsaSetThreadPriorityError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    EcnrAlsaSetThreadPriorityError* payload = new EcnrAlsaSetThreadPriorityError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "ecnrAlsaSetThreadPriority", EcnrAlsaSetThreadPriorityError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "EcnrAlsaSetThreadPriority", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  AlsaStub::sendEcnrAlsaSetWideBandResponse (act_t act) {
    EcnrAlsaSetWideBandResponse* payload = new EcnrAlsaSetWideBandResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "ecnrAlsaSetWideBand", EcnrAlsaSetWideBandResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "EcnrAlsaSetWideBand", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  AlsaStub::sendEcnrAlsaSetWideBandError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    EcnrAlsaSetWideBandError* payload = new EcnrAlsaSetWideBandError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "ecnrAlsaSetWideBand", EcnrAlsaSetWideBandError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "EcnrAlsaSetWideBand", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  AlsaStub::sendEcnrAlsaSetDevicePropertiesResponse (act_t act) {
    EcnrAlsaSetDevicePropertiesResponse* payload = new EcnrAlsaSetDevicePropertiesResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "ecnrAlsaSetDeviceProperties", EcnrAlsaSetDevicePropertiesResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "EcnrAlsaSetDeviceProperties", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  AlsaStub::sendEcnrAlsaSetDevicePropertiesError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    EcnrAlsaSetDevicePropertiesError* payload = new EcnrAlsaSetDevicePropertiesError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "ecnrAlsaSetDeviceProperties", EcnrAlsaSetDevicePropertiesError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "EcnrAlsaSetDeviceProperties", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void AlsaStub::onGetAll(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) const {
    ((void)properties);  // to get rid of unused variable warning
}

} // namespace alsa
} // namespace ecnr
} // namespace bosch
} // namespace org
