/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef ORG_BOSCH_ECNR_ALSAPROXY_H
#define ORG_BOSCH_ECNR_ALSAPROXY_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusProxy.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "com/bosch/cm/asf/lang/dbus/Connectors.h"
#include "org/bosch/ecnr/alsa.h"
#include <dbus/dbus.h>
#include <string>

namespace org {
namespace bosch {
namespace ecnr {
namespace alsa {

class AlsaProxy;

class EcnrAlsaSetDeviceCallbackIF {
public:
    virtual ~EcnrAlsaSetDeviceCallbackIF() {}

    virtual void onEcnrAlsaSetDeviceError(const ::boost::shared_ptr< AlsaProxy >& proxy, const ::boost::shared_ptr< EcnrAlsaSetDeviceError >& error) = 0;

    virtual void onEcnrAlsaSetDeviceResponse(const ::boost::shared_ptr< AlsaProxy >& proxy, const ::boost::shared_ptr< EcnrAlsaSetDeviceResponse >& response) = 0;
};

class EcnrAlsaSetDevicePropertiesCallbackIF {
public:
    virtual ~EcnrAlsaSetDevicePropertiesCallbackIF() {}

    virtual void onEcnrAlsaSetDevicePropertiesError(const ::boost::shared_ptr< AlsaProxy >& proxy, const ::boost::shared_ptr< EcnrAlsaSetDevicePropertiesError >& error) = 0;

    virtual void onEcnrAlsaSetDevicePropertiesResponse(const ::boost::shared_ptr< AlsaProxy >& proxy, const ::boost::shared_ptr< EcnrAlsaSetDevicePropertiesResponse >& response) = 0;
};

class EcnrAlsaSetThreadPriorityCallbackIF {
public:
    virtual ~EcnrAlsaSetThreadPriorityCallbackIF() {}

    virtual void onEcnrAlsaSetThreadPriorityError(const ::boost::shared_ptr< AlsaProxy >& proxy, const ::boost::shared_ptr< EcnrAlsaSetThreadPriorityError >& error) = 0;

    virtual void onEcnrAlsaSetThreadPriorityResponse(const ::boost::shared_ptr< AlsaProxy >& proxy, const ::boost::shared_ptr< EcnrAlsaSetThreadPriorityResponse >& response) = 0;
};

class EcnrAlsaSetWideBandCallbackIF {
public:
    virtual ~EcnrAlsaSetWideBandCallbackIF() {}

    virtual void onEcnrAlsaSetWideBandError(const ::boost::shared_ptr< AlsaProxy >& proxy, const ::boost::shared_ptr< EcnrAlsaSetWideBandError >& error) = 0;

    virtual void onEcnrAlsaSetWideBandResponse(const ::boost::shared_ptr< AlsaProxy >& proxy, const ::boost::shared_ptr< EcnrAlsaSetWideBandResponse >& response) = 0;
};


/**
 * AlsaProxy is the client side representation of the D-Bus service
 * interface 'org.bosch.ecnr.alsa' (specified in file
 * ecnr-sse-introspection.xml).
 *
 * If the meaning of "org.bosch.ecnr.alsa" isn't clear, then there should be a description here.
 */
class AlsaProxy : public ::asf::dbus::DBusProxy
{
public:
    /**
     * Create a new instance of AlsaProxy.
     */
    static ::boost::shared_ptr< AlsaProxy > createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    /**
     * Create a new instance of AlsaProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @deprecated use the createProxy() method with the parameter
     * ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector instead.
     */
    static ::boost::shared_ptr< AlsaProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        ::DBusBusType busType,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector connectorOptions;
        connectorOptions.setBusType(::asf::dbus::DBusUtils::toOptions(busType).getBusType());
        return createProxy(portName, busName, objectPath, connectorOptions, serviceAvailable);
    }

    /**
     * Create a new instance of AlsaProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     */
    static ::boost::shared_ptr< AlsaProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        const ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector& connectorOptions,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        LOG_INFO_STATIC ("createProxy, create new proxy");
        ::boost::shared_ptr< AlsaProxy > proxyNew(new AlsaProxy(portName, serviceAvailable));
        ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew, busName, objectPath, connectorOptions);
        proxyNew->createHelperProxies(false);
        return proxyNew;
    }

    virtual ~AlsaProxy ();




    // Method 'ecnrAlsaSetDevice'

    /**
     * Call the method 'ecnrAlsaSetDevice'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'ecnrAlsaSetDevice'</b>:
     *
     * If the meaning of "ecnrAlsaSetDevice" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param ecnrAppId If the meaning of "ecnrAppId" isn't clear, then there should be a description here.
     *
     * @param AlsaDeviceSelect If the meaning of "AlsaDeviceSelect" isn't clear, then there should be a description here.
     *
     * @param AlsaDeviceName If the meaning of "AlsaDeviceName" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendEcnrAlsaSetDeviceRequest(EcnrAlsaSetDeviceCallbackIF& cb, uint8 ecnrAppId, uint32 alsaDeviceSelect, const ::std::string& alsaDeviceName) const;

    // Method 'ecnrAlsaSetThreadPriority'

    /**
     * Call the method 'ecnrAlsaSetThreadPriority'. This method sends a
     * message to the D-Bus server.
     *
     * <b>Documentation of 'ecnrAlsaSetThreadPriority'</b>:
     *
     * If the meaning of "ecnrAlsaSetThreadPriority" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param ecnrAppId If the meaning of "ecnrAppId" isn't clear, then there should be a description here.
     *
     * @param priority If the meaning of "priority" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendEcnrAlsaSetThreadPriorityRequest(EcnrAlsaSetThreadPriorityCallbackIF& cb, uint8 ecnrAppId, uint32 priority) const;

    // Method 'ecnrAlsaSetWideBand'

    /**
     * Call the method 'ecnrAlsaSetWideBand'. This method sends a message to
     * the D-Bus server.
     *
     * <b>Documentation of 'ecnrAlsaSetWideBand'</b>:
     *
     * If the meaning of "ecnrAlsaSetWideBand" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param ecnrAppId If the meaning of "ecnrAppId" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendEcnrAlsaSetWideBandRequest(EcnrAlsaSetWideBandCallbackIF& cb, uint8 ecnrAppId) const;

    // Method 'ecnrAlsaSetDeviceProperties'

    /**
     * Call the method 'ecnrAlsaSetDeviceProperties'. This method sends a
     * message to the D-Bus server.
     *
     * <b>Documentation of 'ecnrAlsaSetDeviceProperties'</b>:
     *
     * If the meaning of "ecnrAlsaSetDeviceProperties" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param ecnrAppId If the meaning of "ecnrAppId" isn't clear, then there should be a description here.
     *
     * @param AlsaDeviceSelect If the meaning of "AlsaDeviceSelect" isn't clear, then there should be a description here.
     *
     * @param AlsaDeviceProperty If the meaning of "AlsaDeviceProperty" isn't clear, then there should be a description here.
     *
     * @param PropertyValue If the meaning of "PropertyValue" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendEcnrAlsaSetDevicePropertiesRequest(EcnrAlsaSetDevicePropertiesCallbackIF& cb, uint8 ecnrAppId, uint32 alsaDeviceSelect, uint8 alsaDeviceProperty, uint32 propertyValue) const;


private:

    AlsaProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    act_t addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const;

    act_t addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const;


    DECLARE_CLASS_LOGGER();

    friend class AlsaProxyCallback;
};

} // namespace alsa
} // namespace ecnr
} // namespace bosch
} // namespace org

#endif // ORG_BOSCH_ECNR_ALSAPROXY_H
