/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "org/bosch/ecnr/alsa.h"
#include "org/bosch/ecnr/alsaDBus.h"
#include "org/bosch/ecnr/alsaJson.h"
#include "org/bosch/ecnr/alsaProxy.h"
#include <string>

#include "asf/dbus/DBusDaemonProxy.h"
#include "asf/dbus/DBusPropertiesProxyWrapper.h"
#include "asf/dbus/DBusProxyDelegate.h"
#include "asf/dbus/DBusMessage.h"

namespace org {
namespace bosch {
namespace ecnr {
namespace alsa {

DEFINE_CLASS_LOGGER("///org/bosch/ecnr/alsa", AlsaProxy);

class AlsaProxyCallback : public ::asf::dbus::DBusProxyCallback {
public:

    AlsaProxyCallback(uint16 functionId, void* callback) :
        ::asf::dbus::DBusProxyCallback (functionId, callback)
    {}

    bool processMessage (::asf::dbus::DBusMessage &message) {
        const ::boost::shared_ptr< AlsaProxy >& proxyShared = ::boost::static_pointer_cast< AlsaProxy >(message.getDBusProxyShared()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        switch (_functionId) {
            case ID_ecnrAlsaSetDevice:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), EcnrAlsaSetDeviceError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "EcnrAlsaSetDevice", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<EcnrAlsaSetDeviceError> payload = ::boost::static_pointer_cast<EcnrAlsaSetDeviceError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((EcnrAlsaSetDeviceCallbackIF*) _callback)->onEcnrAlsaSetDeviceError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), EcnrAlsaSetDeviceResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "EcnrAlsaSetDevice", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<EcnrAlsaSetDeviceResponse> payload = ::boost::static_pointer_cast<EcnrAlsaSetDeviceResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((EcnrAlsaSetDeviceCallbackIF*) _callback)->onEcnrAlsaSetDeviceResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_ecnrAlsaSetThreadPriority:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), EcnrAlsaSetThreadPriorityError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "EcnrAlsaSetThreadPriority", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<EcnrAlsaSetThreadPriorityError> payload = ::boost::static_pointer_cast<EcnrAlsaSetThreadPriorityError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((EcnrAlsaSetThreadPriorityCallbackIF*) _callback)->onEcnrAlsaSetThreadPriorityError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), EcnrAlsaSetThreadPriorityResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "EcnrAlsaSetThreadPriority", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<EcnrAlsaSetThreadPriorityResponse> payload = ::boost::static_pointer_cast<EcnrAlsaSetThreadPriorityResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((EcnrAlsaSetThreadPriorityCallbackIF*) _callback)->onEcnrAlsaSetThreadPriorityResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_ecnrAlsaSetWideBand:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), EcnrAlsaSetWideBandError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "EcnrAlsaSetWideBand", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<EcnrAlsaSetWideBandError> payload = ::boost::static_pointer_cast<EcnrAlsaSetWideBandError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((EcnrAlsaSetWideBandCallbackIF*) _callback)->onEcnrAlsaSetWideBandError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), EcnrAlsaSetWideBandResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "EcnrAlsaSetWideBand", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<EcnrAlsaSetWideBandResponse> payload = ::boost::static_pointer_cast<EcnrAlsaSetWideBandResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((EcnrAlsaSetWideBandCallbackIF*) _callback)->onEcnrAlsaSetWideBandResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_ecnrAlsaSetDeviceProperties:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), EcnrAlsaSetDevicePropertiesError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "EcnrAlsaSetDeviceProperties", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<EcnrAlsaSetDevicePropertiesError> payload = ::boost::static_pointer_cast<EcnrAlsaSetDevicePropertiesError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((EcnrAlsaSetDevicePropertiesCallbackIF*) _callback)->onEcnrAlsaSetDevicePropertiesError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), EcnrAlsaSetDevicePropertiesResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "EcnrAlsaSetDeviceProperties", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<EcnrAlsaSetDevicePropertiesResponse> payload = ::boost::static_pointer_cast<EcnrAlsaSetDevicePropertiesResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((EcnrAlsaSetDevicePropertiesCallbackIF*) _callback)->onEcnrAlsaSetDevicePropertiesResponse (proxyShared, payload);
                        return true;
                    }
                }
            default:
            LOG_FATAL ("Received an invalid functionId, proxy=%p", message.getProxy());
        }
        LOG_FATAL("Receveid an invalid message, proxy=%p", message.getProxy());
        return false;
    }

    bool onServiceUnavailable (const ::boost::shared_ptr< ::asf::core::Proxy >& baseProxy) {
        switch (_functionId) {
            case ID_ecnrAlsaSetDevice: {
                ::boost::shared_ptr< EcnrAlsaSetDeviceError > payload = ::boost::shared_ptr< EcnrAlsaSetDeviceError >
                (new EcnrAlsaSetDeviceError(DBUS_ERROR_NO_SERVER, "The DBus service Alsa is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "EcnrAlsaSetDevice", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<AlsaProxy> proxyShared = ::boost::static_pointer_cast<AlsaProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((EcnrAlsaSetDeviceCallbackIF*) _callback)->onEcnrAlsaSetDeviceError (proxyShared,payload);
                return true;
            }
            break;
            case ID_ecnrAlsaSetThreadPriority: {
                ::boost::shared_ptr< EcnrAlsaSetThreadPriorityError > payload = ::boost::shared_ptr< EcnrAlsaSetThreadPriorityError >
                (new EcnrAlsaSetThreadPriorityError(DBUS_ERROR_NO_SERVER, "The DBus service Alsa is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "EcnrAlsaSetThreadPriority", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<AlsaProxy> proxyShared = ::boost::static_pointer_cast<AlsaProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((EcnrAlsaSetThreadPriorityCallbackIF*) _callback)->onEcnrAlsaSetThreadPriorityError (proxyShared,payload);
                return true;
            }
            break;
            case ID_ecnrAlsaSetWideBand: {
                ::boost::shared_ptr< EcnrAlsaSetWideBandError > payload = ::boost::shared_ptr< EcnrAlsaSetWideBandError >
                (new EcnrAlsaSetWideBandError(DBUS_ERROR_NO_SERVER, "The DBus service Alsa is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "EcnrAlsaSetWideBand", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<AlsaProxy> proxyShared = ::boost::static_pointer_cast<AlsaProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((EcnrAlsaSetWideBandCallbackIF*) _callback)->onEcnrAlsaSetWideBandError (proxyShared,payload);
                return true;
            }
            break;
            case ID_ecnrAlsaSetDeviceProperties: {
                ::boost::shared_ptr< EcnrAlsaSetDevicePropertiesError > payload = ::boost::shared_ptr< EcnrAlsaSetDevicePropertiesError >
                (new EcnrAlsaSetDevicePropertiesError(DBUS_ERROR_NO_SERVER, "The DBus service Alsa is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "EcnrAlsaSetDeviceProperties", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<AlsaProxy> proxyShared = ::boost::static_pointer_cast<AlsaProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((EcnrAlsaSetDevicePropertiesCallbackIF*) _callback)->onEcnrAlsaSetDevicePropertiesError (proxyShared,payload);
                return true;
            }
            break;
            default:
                break;
        }
        return false;
    }

    static ::asf::core::Logger&_logger;
};

::asf::core::Logger& AlsaProxyCallback::_logger (AlsaProxy::_logger);

AlsaProxy::AlsaProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable) :
    ::asf::dbus::DBusProxy(portName, "org.bosch.ecnr.alsa", serviceAvailable, _logger) {
}

AlsaProxy::~AlsaProxy()
{
    ::asf::dbus::DBusConnector::getConnector(getConnectorOptions())->deregisterProxyDelegate(_dbusProxyDelegate);
}

// static
::boost::shared_ptr< AlsaProxy > AlsaProxy::createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable) {
    ::boost::shared_ptr< Proxy > proxyReuse = ::asf::dbus::DBusConnector::getProxy(portName, serviceAvailable);
    if(proxyReuse) {
        LOG_INFO_STATIC ("createProxy, reuse existing proxy");
        return ::boost::static_pointer_cast<AlsaProxy>(proxyReuse); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
    }
    LOG_INFO_STATIC ("createProxy, create new proxy");
    ::boost::shared_ptr< AlsaProxy > proxyNew(new AlsaProxy(portName, serviceAvailable));
    ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew);
    proxyNew->createHelperProxies(false);
    return proxyNew;
}

act_t AlsaProxy::addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const {
    AlsaProxyCallback* callback = new AlsaProxyCallback(methodId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->addMethodCallback (serial, memberName, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

act_t AlsaProxy::addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const {
    AlsaProxyCallback* callback = new AlsaProxyCallback(signalId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->registerSignalCallback (signal, reinterpret_cast<act_t>(callback), ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}



act_t AlsaProxy::sendEcnrAlsaSetDeviceRequest(EcnrAlsaSetDeviceCallbackIF& cb, uint8 ecnrAppId, uint32 alsaDeviceSelect, const ::std::string& alsaDeviceName) const {
    EcnrAlsaSetDeviceRequest* payload = new EcnrAlsaSetDeviceRequest();
    CHECK_ALLOCATION(payload);
    payload->setEcnrAppId(ecnrAppId);
    payload->setAlsaDeviceSelect(alsaDeviceSelect);
    payload->setAlsaDeviceName(alsaDeviceName);
    DBUS_MESSAGE_CALL(dbusMessage, "ecnrAlsaSetDevice", EcnrAlsaSetDeviceRequest, payload, true)
    act_t act = addMethodCallback(ID_ecnrAlsaSetDevice, dbusMessage.getUniqueSerial(), "ecnrAlsaSetDevice", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "EcnrAlsaSetDevice", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t AlsaProxy::sendEcnrAlsaSetThreadPriorityRequest(EcnrAlsaSetThreadPriorityCallbackIF& cb, uint8 ecnrAppId, uint32 priority) const {
    EcnrAlsaSetThreadPriorityRequest* payload = new EcnrAlsaSetThreadPriorityRequest();
    CHECK_ALLOCATION(payload);
    payload->setEcnrAppId(ecnrAppId);
    payload->setPriority(priority);
    DBUS_MESSAGE_CALL(dbusMessage, "ecnrAlsaSetThreadPriority", EcnrAlsaSetThreadPriorityRequest, payload, true)
    act_t act = addMethodCallback(ID_ecnrAlsaSetThreadPriority, dbusMessage.getUniqueSerial(), "ecnrAlsaSetThreadPriority", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "EcnrAlsaSetThreadPriority", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t AlsaProxy::sendEcnrAlsaSetWideBandRequest(EcnrAlsaSetWideBandCallbackIF& cb, uint8 ecnrAppId) const {
    EcnrAlsaSetWideBandRequest* payload = new EcnrAlsaSetWideBandRequest();
    CHECK_ALLOCATION(payload);
    payload->setEcnrAppId(ecnrAppId);
    DBUS_MESSAGE_CALL(dbusMessage, "ecnrAlsaSetWideBand", EcnrAlsaSetWideBandRequest, payload, true)
    act_t act = addMethodCallback(ID_ecnrAlsaSetWideBand, dbusMessage.getUniqueSerial(), "ecnrAlsaSetWideBand", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "EcnrAlsaSetWideBand", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t AlsaProxy::sendEcnrAlsaSetDevicePropertiesRequest(EcnrAlsaSetDevicePropertiesCallbackIF& cb, uint8 ecnrAppId, uint32 alsaDeviceSelect, uint8 alsaDeviceProperty, uint32 propertyValue) const {
    EcnrAlsaSetDevicePropertiesRequest* payload = new EcnrAlsaSetDevicePropertiesRequest();
    CHECK_ALLOCATION(payload);
    payload->setEcnrAppId(ecnrAppId);
    payload->setAlsaDeviceSelect(alsaDeviceSelect);
    payload->setAlsaDeviceProperty(alsaDeviceProperty);
    payload->setPropertyValue(propertyValue);
    DBUS_MESSAGE_CALL(dbusMessage, "ecnrAlsaSetDeviceProperties", EcnrAlsaSetDevicePropertiesRequest, payload, true)
    act_t act = addMethodCallback(ID_ecnrAlsaSetDeviceProperties, dbusMessage.getUniqueSerial(), "ecnrAlsaSetDeviceProperties", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "EcnrAlsaSetDeviceProperties", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

} // namespace alsa
} // namespace ecnr
} // namespace bosch
} // namespace org
