#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef ORG_BOSCH_ECNR_ALSA_H
#define ORG_BOSCH_ECNR_ALSA_H

#include "asf/core/Logger.h"
#include "asf/core/Payload.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "asf/core/VersionCheck.h"
#include "asf/dbus/DBusTypes.h"
#include <cstddef>
#include <cstring>
#include <string>

/**
 * If the meaning of "alsa" isn't clear, then there should be a description here.
 */

namespace org {
namespace bosch {
namespace ecnr {
namespace alsa {

// method IDs
static const uint16 ID_ecnrAlsaSetDevice = 0;
static const uint16 ID_ecnrAlsaSetThreadPriority = 1;
static const uint16 ID_ecnrAlsaSetWideBand = 2;
static const uint16 ID_ecnrAlsaSetDeviceProperties = 3;

// signal IDs

// property IDs

ASF_GENERATOR_VERSION_CHECK_DECLARE

// forward declarations
class EcnrAlsaSetDeviceRequest;

class EcnrAlsaSetThreadPriorityRequest;

class EcnrAlsaSetWideBandRequest;

class EcnrAlsaSetDevicePropertiesRequest;

// type definitions
/**
 * If the meaning of "EcnrAlsaSetDeviceResponse" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage EcnrAlsaSetDeviceResponse;

/**
 * If the meaning of "EcnrAlsaSetDeviceError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError EcnrAlsaSetDeviceError;

/**
 * If the meaning of "EcnrAlsaSetThreadPriorityResponse" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage EcnrAlsaSetThreadPriorityResponse;

/**
 * If the meaning of "EcnrAlsaSetThreadPriorityError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError EcnrAlsaSetThreadPriorityError;

/**
 * If the meaning of "EcnrAlsaSetWideBandResponse" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage EcnrAlsaSetWideBandResponse;

/**
 * If the meaning of "EcnrAlsaSetWideBandError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError EcnrAlsaSetWideBandError;

/**
 * If the meaning of "EcnrAlsaSetDevicePropertiesResponse" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage EcnrAlsaSetDevicePropertiesResponse;

/**
 * If the meaning of "EcnrAlsaSetDevicePropertiesError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError EcnrAlsaSetDevicePropertiesError;


/**
 * If the meaning of "EcnrAlsaSetDeviceRequest" isn't clear, then there should be a description here.
 */
class EcnrAlsaSetDeviceRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  EcnrAlsaSetDeviceRequest ();

    /**
     * Copy constructor
     */
    inline  EcnrAlsaSetDeviceRequest (const EcnrAlsaSetDeviceRequest &rhs);

    /**
     * All fields constructor
     */
    inline  EcnrAlsaSetDeviceRequest (uint8 ecnrAppId_, uint32 AlsaDeviceSelect_, const ::std::string& AlsaDeviceName_);

    /**
     * Destructor
     */
    inline virtual  ~EcnrAlsaSetDeviceRequest();

    /**
     * Assignment operator
     */
    inline EcnrAlsaSetDeviceRequest& operator = (const EcnrAlsaSetDeviceRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const EcnrAlsaSetDeviceRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const EcnrAlsaSetDeviceRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const EcnrAlsaSetDeviceRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const EcnrAlsaSetDeviceRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ecnrAppId"

    static const int kEcnrAppId = 0;

    /**
     * Clears the field "ecnrAppId".
     *
     * The field will be set to its default value. The hasEcnrAppId()
     * method will return false.
     */
    inline void clearEcnrAppId();

    /**
     * Checks whether the field "ecnrAppId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEcnrAppId()). Otherwise it will return false.
     */
    inline bool hasEcnrAppId () const;

    /**
     * Returns the value of the member "ecnrAppId".
     *
     * If the meaning of "ecnrAppId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "ecnrAppId"
     */
    inline uint8 getEcnrAppId () const;

    /**
     * Sets the value of the member "ecnrAppId".
     *
     * If the meaning of "ecnrAppId" isn't clear, then there should be a description here.
     *
     * @param ecnrAppId The value which will be set
     */
    inline void setEcnrAppId (uint8 ecnrAppId_);

    // API of field "AlsaDeviceSelect"

    static const int kAlsaDeviceSelect = 1;

    /**
     * Clears the field "AlsaDeviceSelect".
     *
     * The field will be set to its default value. The hasAlsaDeviceSelect()
     * method will return false.
     */
    inline void clearAlsaDeviceSelect();

    /**
     * Checks whether the field "AlsaDeviceSelect" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAlsaDeviceSelect()). Otherwise it will return false.
     */
    inline bool hasAlsaDeviceSelect () const;

    /**
     * Returns the value of the member "AlsaDeviceSelect".
     *
     * If the meaning of "AlsaDeviceSelect" isn't clear, then there should be a description here.
     *
     * @return The value of the field "AlsaDeviceSelect"
     */
    inline uint32 getAlsaDeviceSelect () const;

    /**
     * Sets the value of the member "AlsaDeviceSelect".
     *
     * If the meaning of "AlsaDeviceSelect" isn't clear, then there should be a description here.
     *
     * @param AlsaDeviceSelect The value which will be set
     */
    inline void setAlsaDeviceSelect (uint32 AlsaDeviceSelect_);

    // API of field "AlsaDeviceName"

    static const int kAlsaDeviceName = 2;

    /**
     * Clears the field "AlsaDeviceName".
     *
     * The field will be set to its default value. The hasAlsaDeviceName()
     * method will return false.
     */
    inline void clearAlsaDeviceName();

    /**
     * Checks whether the field "AlsaDeviceName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAlsaDeviceName()). Otherwise it will return false.
     */
    inline bool hasAlsaDeviceName () const;

    /**
     * Returns the value of the member "AlsaDeviceName".
     *
     * If the meaning of "AlsaDeviceName" isn't clear, then there should be a description here.
     *
     * @return The value of the field "AlsaDeviceName"
     */
    inline const ::std::string& getAlsaDeviceName () const;

    /**
     * Retrieves the value of the field "AlsaDeviceName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "AlsaDeviceName".
     */
    inline ::std::string& getAlsaDeviceNameMutable ();

    /**
     * Sets the value of the member "AlsaDeviceName".
     *
     * If the meaning of "AlsaDeviceName" isn't clear, then there should be a description here.
     *
     * @param AlsaDeviceName The value which will be set
     */
    inline void setAlsaDeviceName (const ::std::string& AlsaDeviceName_);

    /**
     * Sets the value of the member "AlsaDeviceName".
     *
     * If the meaning of "AlsaDeviceName" isn't clear, then there should be a description here.
     *
     * @param AlsaDeviceName The value which will be set
     */
    inline void setAlsaDeviceName (const char* AlsaDeviceName_);

    /**
     * Sets the value of the member "AlsaDeviceName".
     *
     * If the meaning of "AlsaDeviceName" isn't clear, then there should be a description here.
     *
     * @param AlsaDeviceName The value which will be set
     */
    inline void setAlsaDeviceName (const char* value, size_t size);

    static const EcnrAlsaSetDeviceRequest &getDefaultInstance();

private:

    inline void set_has_ecnrAppId ();

    inline void clear_has_ecnrAppId ();

    inline void set_has_AlsaDeviceSelect ();

    inline void clear_has_AlsaDeviceSelect ();

    inline void set_has_AlsaDeviceName ();

    inline void clear_has_AlsaDeviceName ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint8 _ecnrAppId;

    uint32 _AlsaDeviceSelect;

    ::std::string _AlsaDeviceName;

};

/**
 * If the meaning of "EcnrAlsaSetThreadPriorityRequest" isn't clear, then there should be a description here.
 */
class EcnrAlsaSetThreadPriorityRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  EcnrAlsaSetThreadPriorityRequest ();

    /**
     * Copy constructor
     */
    inline  EcnrAlsaSetThreadPriorityRequest (const EcnrAlsaSetThreadPriorityRequest &rhs);

    /**
     * All fields constructor
     */
    inline  EcnrAlsaSetThreadPriorityRequest (uint8 ecnrAppId_, uint32 priority_);

    /**
     * Destructor
     */
    inline virtual  ~EcnrAlsaSetThreadPriorityRequest();

    /**
     * Assignment operator
     */
    inline EcnrAlsaSetThreadPriorityRequest& operator = (const EcnrAlsaSetThreadPriorityRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const EcnrAlsaSetThreadPriorityRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const EcnrAlsaSetThreadPriorityRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const EcnrAlsaSetThreadPriorityRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const EcnrAlsaSetThreadPriorityRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ecnrAppId"

    static const int kEcnrAppId = 0;

    /**
     * Clears the field "ecnrAppId".
     *
     * The field will be set to its default value. The hasEcnrAppId()
     * method will return false.
     */
    inline void clearEcnrAppId();

    /**
     * Checks whether the field "ecnrAppId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEcnrAppId()). Otherwise it will return false.
     */
    inline bool hasEcnrAppId () const;

    /**
     * Returns the value of the member "ecnrAppId".
     *
     * If the meaning of "ecnrAppId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "ecnrAppId"
     */
    inline uint8 getEcnrAppId () const;

    /**
     * Sets the value of the member "ecnrAppId".
     *
     * If the meaning of "ecnrAppId" isn't clear, then there should be a description here.
     *
     * @param ecnrAppId The value which will be set
     */
    inline void setEcnrAppId (uint8 ecnrAppId_);

    // API of field "priority"

    static const int kPriority = 1;

    /**
     * Clears the field "priority".
     *
     * The field will be set to its default value. The hasPriority()
     * method will return false.
     */
    inline void clearPriority();

    /**
     * Checks whether the field "priority" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPriority()). Otherwise it will return false.
     */
    inline bool hasPriority () const;

    /**
     * Returns the value of the member "priority".
     *
     * If the meaning of "priority" isn't clear, then there should be a description here.
     *
     * @return The value of the field "priority"
     */
    inline uint32 getPriority () const;

    /**
     * Sets the value of the member "priority".
     *
     * If the meaning of "priority" isn't clear, then there should be a description here.
     *
     * @param priority The value which will be set
     */
    inline void setPriority (uint32 priority_);

    static const EcnrAlsaSetThreadPriorityRequest &getDefaultInstance();

private:

    inline void set_has_ecnrAppId ();

    inline void clear_has_ecnrAppId ();

    inline void set_has_priority ();

    inline void clear_has_priority ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint8 _ecnrAppId;

    uint32 _priority;

};

/**
 * If the meaning of "EcnrAlsaSetWideBandRequest" isn't clear, then there should be a description here.
 */
class EcnrAlsaSetWideBandRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  EcnrAlsaSetWideBandRequest ();

    /**
     * Copy constructor
     */
    inline  EcnrAlsaSetWideBandRequest (const EcnrAlsaSetWideBandRequest &rhs);

    /**
     * All fields constructor
     */
    inline  EcnrAlsaSetWideBandRequest (uint8 ecnrAppId_);

    /**
     * Destructor
     */
    inline virtual  ~EcnrAlsaSetWideBandRequest();

    /**
     * Assignment operator
     */
    inline EcnrAlsaSetWideBandRequest& operator = (const EcnrAlsaSetWideBandRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const EcnrAlsaSetWideBandRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const EcnrAlsaSetWideBandRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const EcnrAlsaSetWideBandRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const EcnrAlsaSetWideBandRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ecnrAppId"

    static const int kEcnrAppId = 0;

    /**
     * Clears the field "ecnrAppId".
     *
     * The field will be set to its default value. The hasEcnrAppId()
     * method will return false.
     */
    inline void clearEcnrAppId();

    /**
     * Checks whether the field "ecnrAppId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEcnrAppId()). Otherwise it will return false.
     */
    inline bool hasEcnrAppId () const;

    /**
     * Returns the value of the member "ecnrAppId".
     *
     * If the meaning of "ecnrAppId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "ecnrAppId"
     */
    inline uint8 getEcnrAppId () const;

    /**
     * Sets the value of the member "ecnrAppId".
     *
     * If the meaning of "ecnrAppId" isn't clear, then there should be a description here.
     *
     * @param ecnrAppId The value which will be set
     */
    inline void setEcnrAppId (uint8 ecnrAppId_);

    static const EcnrAlsaSetWideBandRequest &getDefaultInstance();

private:

    inline void set_has_ecnrAppId ();

    inline void clear_has_ecnrAppId ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _ecnrAppId;

};

/**
 * If the meaning of "EcnrAlsaSetDevicePropertiesRequest" isn't clear, then there should be a description here.
 */
class EcnrAlsaSetDevicePropertiesRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  EcnrAlsaSetDevicePropertiesRequest ();

    /**
     * Copy constructor
     */
    inline  EcnrAlsaSetDevicePropertiesRequest (const EcnrAlsaSetDevicePropertiesRequest &rhs);

    /**
     * All fields constructor
     */
    inline  EcnrAlsaSetDevicePropertiesRequest (uint8 ecnrAppId_, uint32 AlsaDeviceSelect_, uint8 AlsaDeviceProperty_, uint32 PropertyValue_);

    /**
     * Destructor
     */
    inline virtual  ~EcnrAlsaSetDevicePropertiesRequest();

    /**
     * Assignment operator
     */
    inline EcnrAlsaSetDevicePropertiesRequest& operator = (const EcnrAlsaSetDevicePropertiesRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const EcnrAlsaSetDevicePropertiesRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const EcnrAlsaSetDevicePropertiesRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const EcnrAlsaSetDevicePropertiesRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const EcnrAlsaSetDevicePropertiesRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ecnrAppId"

    static const int kEcnrAppId = 0;

    /**
     * Clears the field "ecnrAppId".
     *
     * The field will be set to its default value. The hasEcnrAppId()
     * method will return false.
     */
    inline void clearEcnrAppId();

    /**
     * Checks whether the field "ecnrAppId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEcnrAppId()). Otherwise it will return false.
     */
    inline bool hasEcnrAppId () const;

    /**
     * Returns the value of the member "ecnrAppId".
     *
     * If the meaning of "ecnrAppId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "ecnrAppId"
     */
    inline uint8 getEcnrAppId () const;

    /**
     * Sets the value of the member "ecnrAppId".
     *
     * If the meaning of "ecnrAppId" isn't clear, then there should be a description here.
     *
     * @param ecnrAppId The value which will be set
     */
    inline void setEcnrAppId (uint8 ecnrAppId_);

    // API of field "AlsaDeviceSelect"

    static const int kAlsaDeviceSelect = 1;

    /**
     * Clears the field "AlsaDeviceSelect".
     *
     * The field will be set to its default value. The hasAlsaDeviceSelect()
     * method will return false.
     */
    inline void clearAlsaDeviceSelect();

    /**
     * Checks whether the field "AlsaDeviceSelect" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAlsaDeviceSelect()). Otherwise it will return false.
     */
    inline bool hasAlsaDeviceSelect () const;

    /**
     * Returns the value of the member "AlsaDeviceSelect".
     *
     * If the meaning of "AlsaDeviceSelect" isn't clear, then there should be a description here.
     *
     * @return The value of the field "AlsaDeviceSelect"
     */
    inline uint32 getAlsaDeviceSelect () const;

    /**
     * Sets the value of the member "AlsaDeviceSelect".
     *
     * If the meaning of "AlsaDeviceSelect" isn't clear, then there should be a description here.
     *
     * @param AlsaDeviceSelect The value which will be set
     */
    inline void setAlsaDeviceSelect (uint32 AlsaDeviceSelect_);

    // API of field "AlsaDeviceProperty"

    static const int kAlsaDeviceProperty = 2;

    /**
     * Clears the field "AlsaDeviceProperty".
     *
     * The field will be set to its default value. The hasAlsaDeviceProperty()
     * method will return false.
     */
    inline void clearAlsaDeviceProperty();

    /**
     * Checks whether the field "AlsaDeviceProperty" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAlsaDeviceProperty()). Otherwise it will return false.
     */
    inline bool hasAlsaDeviceProperty () const;

    /**
     * Returns the value of the member "AlsaDeviceProperty".
     *
     * If the meaning of "AlsaDeviceProperty" isn't clear, then there should be a description here.
     *
     * @return The value of the field "AlsaDeviceProperty"
     */
    inline uint8 getAlsaDeviceProperty () const;

    /**
     * Sets the value of the member "AlsaDeviceProperty".
     *
     * If the meaning of "AlsaDeviceProperty" isn't clear, then there should be a description here.
     *
     * @param AlsaDeviceProperty The value which will be set
     */
    inline void setAlsaDeviceProperty (uint8 AlsaDeviceProperty_);

    // API of field "PropertyValue"

    static const int kPropertyValue = 3;

    /**
     * Clears the field "PropertyValue".
     *
     * The field will be set to its default value. The hasPropertyValue()
     * method will return false.
     */
    inline void clearPropertyValue();

    /**
     * Checks whether the field "PropertyValue" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPropertyValue()). Otherwise it will return false.
     */
    inline bool hasPropertyValue () const;

    /**
     * Returns the value of the member "PropertyValue".
     *
     * If the meaning of "PropertyValue" isn't clear, then there should be a description here.
     *
     * @return The value of the field "PropertyValue"
     */
    inline uint32 getPropertyValue () const;

    /**
     * Sets the value of the member "PropertyValue".
     *
     * If the meaning of "PropertyValue" isn't clear, then there should be a description here.
     *
     * @param PropertyValue The value which will be set
     */
    inline void setPropertyValue (uint32 PropertyValue_);

    static const EcnrAlsaSetDevicePropertiesRequest &getDefaultInstance();

private:

    inline void set_has_ecnrAppId ();

    inline void clear_has_ecnrAppId ();

    inline void set_has_AlsaDeviceSelect ();

    inline void clear_has_AlsaDeviceSelect ();

    inline void set_has_AlsaDeviceProperty ();

    inline void clear_has_AlsaDeviceProperty ();

    inline void set_has_PropertyValue ();

    inline void clear_has_PropertyValue ();

    uint32 _has_bits_[ (4 + 31) / 32];

    uint8 _ecnrAppId;

    uint32 _AlsaDeviceSelect;

    uint8 _AlsaDeviceProperty;

    uint32 _PropertyValue;

};

inline  EcnrAlsaSetDeviceRequest::EcnrAlsaSetDeviceRequest ()  :
    _ecnrAppId (0u),
    _AlsaDeviceSelect (0u),
    _AlsaDeviceName ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  EcnrAlsaSetDeviceRequest::EcnrAlsaSetDeviceRequest (const EcnrAlsaSetDeviceRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _ecnrAppId (0u),
    _AlsaDeviceSelect (0u),
    _AlsaDeviceName ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  EcnrAlsaSetDeviceRequest::EcnrAlsaSetDeviceRequest (uint8 ecnrAppId_, uint32 AlsaDeviceSelect_, const ::std::string& AlsaDeviceName_)  :
    _ecnrAppId (ecnrAppId_),
    _AlsaDeviceSelect (AlsaDeviceSelect_),
    _AlsaDeviceName (AlsaDeviceName_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (AlsaDeviceName_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  EcnrAlsaSetDeviceRequest::~EcnrAlsaSetDeviceRequest() {
}

inline EcnrAlsaSetDeviceRequest& EcnrAlsaSetDeviceRequest::operator = (const EcnrAlsaSetDeviceRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasEcnrAppId()) {
            setEcnrAppId(rhs.getEcnrAppId());
        } else {
            clearEcnrAppId();
        }
        if (rhs.hasAlsaDeviceSelect()) {
            setAlsaDeviceSelect(rhs.getAlsaDeviceSelect());
        } else {
            clearAlsaDeviceSelect();
        }
        if (rhs.hasAlsaDeviceName()) {
            setAlsaDeviceName(rhs.getAlsaDeviceName());
        } else {
            clearAlsaDeviceName();
        }
    }
    return *this;
}

inline bool EcnrAlsaSetDeviceRequest::operator == (const EcnrAlsaSetDeviceRequest& rhs) const {
    return (((!hasEcnrAppId() && !rhs.hasEcnrAppId()) || getEcnrAppId() == rhs.getEcnrAppId()) &&
        ((!hasAlsaDeviceSelect() && !rhs.hasAlsaDeviceSelect()) || getAlsaDeviceSelect() == rhs.getAlsaDeviceSelect()) &&
        ((!hasAlsaDeviceName() && !rhs.hasAlsaDeviceName()) || getAlsaDeviceName() == rhs.getAlsaDeviceName()));
}

inline bool EcnrAlsaSetDeviceRequest::operator != (const EcnrAlsaSetDeviceRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool EcnrAlsaSetDeviceRequest::operator < (const EcnrAlsaSetDeviceRequest& rhs) const {
    if (hasEcnrAppId() || rhs.hasEcnrAppId()) {
        if (getEcnrAppId() < rhs.getEcnrAppId()) return true;
        if (getEcnrAppId() > rhs.getEcnrAppId()) return false;
    }
    if (hasAlsaDeviceSelect() || rhs.hasAlsaDeviceSelect()) {
        if (getAlsaDeviceSelect() < rhs.getAlsaDeviceSelect()) return true;
        if (getAlsaDeviceSelect() > rhs.getAlsaDeviceSelect()) return false;
    }
    if (hasAlsaDeviceName() || rhs.hasAlsaDeviceName()) {
        if (getAlsaDeviceName() < rhs.getAlsaDeviceName()) return true;
        if (getAlsaDeviceName() > rhs.getAlsaDeviceName()) return false;
    }
    return false;
}

inline ::asf::core::Payload* EcnrAlsaSetDeviceRequest::clone() {
    return new EcnrAlsaSetDeviceRequest(*this);
}

inline bool EcnrAlsaSetDeviceRequest::operator > (const EcnrAlsaSetDeviceRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void EcnrAlsaSetDeviceRequest::clear() {
    clearEcnrAppId();
    clearAlsaDeviceSelect();
    clearAlsaDeviceName();
}

inline void EcnrAlsaSetDeviceRequest::clearEcnrAppId() {
    if (hasEcnrAppId()) {
         clear_has_ecnrAppId();
        _ecnrAppId = 0u;
     }
}

inline bool EcnrAlsaSetDeviceRequest::hasEcnrAppId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 EcnrAlsaSetDeviceRequest::getEcnrAppId () const {
    return _ecnrAppId;
}

inline void EcnrAlsaSetDeviceRequest::setEcnrAppId (uint8 ecnrAppId_) {
    set_has_ecnrAppId();
    this->_ecnrAppId = ecnrAppId_;
}

inline void EcnrAlsaSetDeviceRequest::clearAlsaDeviceSelect() {
    if (hasAlsaDeviceSelect()) {
         clear_has_AlsaDeviceSelect();
        _AlsaDeviceSelect = 0u;
     }
}

inline bool EcnrAlsaSetDeviceRequest::hasAlsaDeviceSelect () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 EcnrAlsaSetDeviceRequest::getAlsaDeviceSelect () const {
    return _AlsaDeviceSelect;
}

inline void EcnrAlsaSetDeviceRequest::setAlsaDeviceSelect (uint32 AlsaDeviceSelect_) {
    set_has_AlsaDeviceSelect();
    this->_AlsaDeviceSelect = AlsaDeviceSelect_;
}

inline void EcnrAlsaSetDeviceRequest::clearAlsaDeviceName() {
    if (hasAlsaDeviceName()) {
         clear_has_AlsaDeviceName();
        _AlsaDeviceName.clear();
     }
}

inline bool EcnrAlsaSetDeviceRequest::hasAlsaDeviceName () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::string& EcnrAlsaSetDeviceRequest::getAlsaDeviceName () const {
    return _AlsaDeviceName;
}

inline ::std::string& EcnrAlsaSetDeviceRequest::getAlsaDeviceNameMutable () {
    set_has_AlsaDeviceName();
    return _AlsaDeviceName;
}

inline void EcnrAlsaSetDeviceRequest::setAlsaDeviceName (const ::std::string& AlsaDeviceName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (AlsaDeviceName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_AlsaDeviceName();
    this->_AlsaDeviceName = AlsaDeviceName_;
}

inline void EcnrAlsaSetDeviceRequest::setAlsaDeviceName (const char* AlsaDeviceName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (AlsaDeviceName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_AlsaDeviceName();
    this->_AlsaDeviceName.assign(AlsaDeviceName_);
}

inline void EcnrAlsaSetDeviceRequest::setAlsaDeviceName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_AlsaDeviceName();
    this->_AlsaDeviceName.assign(value, size);
}

inline void EcnrAlsaSetDeviceRequest::set_has_ecnrAppId () {
    _has_bits_[0] |= 1u << 0;
}

inline void EcnrAlsaSetDeviceRequest::clear_has_ecnrAppId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void EcnrAlsaSetDeviceRequest::set_has_AlsaDeviceSelect () {
    _has_bits_[0] |= 1u << 1;
}

inline void EcnrAlsaSetDeviceRequest::clear_has_AlsaDeviceSelect () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void EcnrAlsaSetDeviceRequest::set_has_AlsaDeviceName () {
    _has_bits_[0] |= 1u << 2;
}

inline void EcnrAlsaSetDeviceRequest::clear_has_AlsaDeviceName () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  EcnrAlsaSetThreadPriorityRequest::EcnrAlsaSetThreadPriorityRequest ()  :
    _ecnrAppId (0u),
    _priority (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  EcnrAlsaSetThreadPriorityRequest::EcnrAlsaSetThreadPriorityRequest (const EcnrAlsaSetThreadPriorityRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _ecnrAppId (0u),
    _priority (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  EcnrAlsaSetThreadPriorityRequest::EcnrAlsaSetThreadPriorityRequest (uint8 ecnrAppId_, uint32 priority_)  :
    _ecnrAppId (ecnrAppId_),
    _priority (priority_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  EcnrAlsaSetThreadPriorityRequest::~EcnrAlsaSetThreadPriorityRequest() {
}

inline EcnrAlsaSetThreadPriorityRequest& EcnrAlsaSetThreadPriorityRequest::operator = (const EcnrAlsaSetThreadPriorityRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasEcnrAppId()) {
            setEcnrAppId(rhs.getEcnrAppId());
        } else {
            clearEcnrAppId();
        }
        if (rhs.hasPriority()) {
            setPriority(rhs.getPriority());
        } else {
            clearPriority();
        }
    }
    return *this;
}

inline bool EcnrAlsaSetThreadPriorityRequest::operator == (const EcnrAlsaSetThreadPriorityRequest& rhs) const {
    return (((!hasEcnrAppId() && !rhs.hasEcnrAppId()) || getEcnrAppId() == rhs.getEcnrAppId()) &&
        ((!hasPriority() && !rhs.hasPriority()) || getPriority() == rhs.getPriority()));
}

inline bool EcnrAlsaSetThreadPriorityRequest::operator != (const EcnrAlsaSetThreadPriorityRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool EcnrAlsaSetThreadPriorityRequest::operator < (const EcnrAlsaSetThreadPriorityRequest& rhs) const {
    if (hasEcnrAppId() || rhs.hasEcnrAppId()) {
        if (getEcnrAppId() < rhs.getEcnrAppId()) return true;
        if (getEcnrAppId() > rhs.getEcnrAppId()) return false;
    }
    if (hasPriority() || rhs.hasPriority()) {
        if (getPriority() < rhs.getPriority()) return true;
        if (getPriority() > rhs.getPriority()) return false;
    }
    return false;
}

inline ::asf::core::Payload* EcnrAlsaSetThreadPriorityRequest::clone() {
    return new EcnrAlsaSetThreadPriorityRequest(*this);
}

inline bool EcnrAlsaSetThreadPriorityRequest::operator > (const EcnrAlsaSetThreadPriorityRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void EcnrAlsaSetThreadPriorityRequest::clear() {
    clearEcnrAppId();
    clearPriority();
}

inline void EcnrAlsaSetThreadPriorityRequest::clearEcnrAppId() {
    if (hasEcnrAppId()) {
         clear_has_ecnrAppId();
        _ecnrAppId = 0u;
     }
}

inline bool EcnrAlsaSetThreadPriorityRequest::hasEcnrAppId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 EcnrAlsaSetThreadPriorityRequest::getEcnrAppId () const {
    return _ecnrAppId;
}

inline void EcnrAlsaSetThreadPriorityRequest::setEcnrAppId (uint8 ecnrAppId_) {
    set_has_ecnrAppId();
    this->_ecnrAppId = ecnrAppId_;
}

inline void EcnrAlsaSetThreadPriorityRequest::clearPriority() {
    if (hasPriority()) {
         clear_has_priority();
        _priority = 0u;
     }
}

inline bool EcnrAlsaSetThreadPriorityRequest::hasPriority () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 EcnrAlsaSetThreadPriorityRequest::getPriority () const {
    return _priority;
}

inline void EcnrAlsaSetThreadPriorityRequest::setPriority (uint32 priority_) {
    set_has_priority();
    this->_priority = priority_;
}

inline void EcnrAlsaSetThreadPriorityRequest::set_has_ecnrAppId () {
    _has_bits_[0] |= 1u << 0;
}

inline void EcnrAlsaSetThreadPriorityRequest::clear_has_ecnrAppId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void EcnrAlsaSetThreadPriorityRequest::set_has_priority () {
    _has_bits_[0] |= 1u << 1;
}

inline void EcnrAlsaSetThreadPriorityRequest::clear_has_priority () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  EcnrAlsaSetWideBandRequest::EcnrAlsaSetWideBandRequest ()  :
    _ecnrAppId (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  EcnrAlsaSetWideBandRequest::EcnrAlsaSetWideBandRequest (const EcnrAlsaSetWideBandRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _ecnrAppId (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  EcnrAlsaSetWideBandRequest::EcnrAlsaSetWideBandRequest (uint8 ecnrAppId_)  :
    _ecnrAppId (ecnrAppId_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  EcnrAlsaSetWideBandRequest::~EcnrAlsaSetWideBandRequest() {
}

inline EcnrAlsaSetWideBandRequest& EcnrAlsaSetWideBandRequest::operator = (const EcnrAlsaSetWideBandRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasEcnrAppId()) {
            setEcnrAppId(rhs.getEcnrAppId());
        } else {
            clearEcnrAppId();
        }
    }
    return *this;
}

inline bool EcnrAlsaSetWideBandRequest::operator == (const EcnrAlsaSetWideBandRequest& rhs) const {
    return (((!hasEcnrAppId() && !rhs.hasEcnrAppId()) || getEcnrAppId() == rhs.getEcnrAppId()));
}

inline bool EcnrAlsaSetWideBandRequest::operator != (const EcnrAlsaSetWideBandRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool EcnrAlsaSetWideBandRequest::operator < (const EcnrAlsaSetWideBandRequest& rhs) const {
    if (hasEcnrAppId() || rhs.hasEcnrAppId()) {
        if (getEcnrAppId() < rhs.getEcnrAppId()) return true;
        if (getEcnrAppId() > rhs.getEcnrAppId()) return false;
    }
    return false;
}

inline ::asf::core::Payload* EcnrAlsaSetWideBandRequest::clone() {
    return new EcnrAlsaSetWideBandRequest(*this);
}

inline bool EcnrAlsaSetWideBandRequest::operator > (const EcnrAlsaSetWideBandRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void EcnrAlsaSetWideBandRequest::clear() {
    clearEcnrAppId();
}

inline void EcnrAlsaSetWideBandRequest::clearEcnrAppId() {
    if (hasEcnrAppId()) {
         clear_has_ecnrAppId();
        _ecnrAppId = 0u;
     }
}

inline bool EcnrAlsaSetWideBandRequest::hasEcnrAppId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 EcnrAlsaSetWideBandRequest::getEcnrAppId () const {
    return _ecnrAppId;
}

inline void EcnrAlsaSetWideBandRequest::setEcnrAppId (uint8 ecnrAppId_) {
    set_has_ecnrAppId();
    this->_ecnrAppId = ecnrAppId_;
}

inline void EcnrAlsaSetWideBandRequest::set_has_ecnrAppId () {
    _has_bits_[0] |= 1u << 0;
}

inline void EcnrAlsaSetWideBandRequest::clear_has_ecnrAppId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  EcnrAlsaSetDevicePropertiesRequest::EcnrAlsaSetDevicePropertiesRequest ()  :
    _ecnrAppId (0u),
    _AlsaDeviceSelect (0u),
    _AlsaDeviceProperty (0u),
    _PropertyValue (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  EcnrAlsaSetDevicePropertiesRequest::EcnrAlsaSetDevicePropertiesRequest (const EcnrAlsaSetDevicePropertiesRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _ecnrAppId (0u),
    _AlsaDeviceSelect (0u),
    _AlsaDeviceProperty (0u),
    _PropertyValue (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  EcnrAlsaSetDevicePropertiesRequest::EcnrAlsaSetDevicePropertiesRequest (uint8 ecnrAppId_, uint32 AlsaDeviceSelect_, uint8 AlsaDeviceProperty_, uint32 PropertyValue_)  :
    _ecnrAppId (ecnrAppId_),
    _AlsaDeviceSelect (AlsaDeviceSelect_),
    _AlsaDeviceProperty (AlsaDeviceProperty_),
    _PropertyValue (PropertyValue_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  EcnrAlsaSetDevicePropertiesRequest::~EcnrAlsaSetDevicePropertiesRequest() {
}

inline EcnrAlsaSetDevicePropertiesRequest& EcnrAlsaSetDevicePropertiesRequest::operator = (const EcnrAlsaSetDevicePropertiesRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasEcnrAppId()) {
            setEcnrAppId(rhs.getEcnrAppId());
        } else {
            clearEcnrAppId();
        }
        if (rhs.hasAlsaDeviceSelect()) {
            setAlsaDeviceSelect(rhs.getAlsaDeviceSelect());
        } else {
            clearAlsaDeviceSelect();
        }
        if (rhs.hasAlsaDeviceProperty()) {
            setAlsaDeviceProperty(rhs.getAlsaDeviceProperty());
        } else {
            clearAlsaDeviceProperty();
        }
        if (rhs.hasPropertyValue()) {
            setPropertyValue(rhs.getPropertyValue());
        } else {
            clearPropertyValue();
        }
    }
    return *this;
}

inline bool EcnrAlsaSetDevicePropertiesRequest::operator == (const EcnrAlsaSetDevicePropertiesRequest& rhs) const {
    return (((!hasEcnrAppId() && !rhs.hasEcnrAppId()) || getEcnrAppId() == rhs.getEcnrAppId()) &&
        ((!hasAlsaDeviceSelect() && !rhs.hasAlsaDeviceSelect()) || getAlsaDeviceSelect() == rhs.getAlsaDeviceSelect()) &&
        ((!hasAlsaDeviceProperty() && !rhs.hasAlsaDeviceProperty()) || getAlsaDeviceProperty() == rhs.getAlsaDeviceProperty()) &&
        ((!hasPropertyValue() && !rhs.hasPropertyValue()) || getPropertyValue() == rhs.getPropertyValue()));
}

inline bool EcnrAlsaSetDevicePropertiesRequest::operator != (const EcnrAlsaSetDevicePropertiesRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool EcnrAlsaSetDevicePropertiesRequest::operator < (const EcnrAlsaSetDevicePropertiesRequest& rhs) const {
    if (hasEcnrAppId() || rhs.hasEcnrAppId()) {
        if (getEcnrAppId() < rhs.getEcnrAppId()) return true;
        if (getEcnrAppId() > rhs.getEcnrAppId()) return false;
    }
    if (hasAlsaDeviceSelect() || rhs.hasAlsaDeviceSelect()) {
        if (getAlsaDeviceSelect() < rhs.getAlsaDeviceSelect()) return true;
        if (getAlsaDeviceSelect() > rhs.getAlsaDeviceSelect()) return false;
    }
    if (hasAlsaDeviceProperty() || rhs.hasAlsaDeviceProperty()) {
        if (getAlsaDeviceProperty() < rhs.getAlsaDeviceProperty()) return true;
        if (getAlsaDeviceProperty() > rhs.getAlsaDeviceProperty()) return false;
    }
    if (hasPropertyValue() || rhs.hasPropertyValue()) {
        if (getPropertyValue() < rhs.getPropertyValue()) return true;
        if (getPropertyValue() > rhs.getPropertyValue()) return false;
    }
    return false;
}

inline ::asf::core::Payload* EcnrAlsaSetDevicePropertiesRequest::clone() {
    return new EcnrAlsaSetDevicePropertiesRequest(*this);
}

inline bool EcnrAlsaSetDevicePropertiesRequest::operator > (const EcnrAlsaSetDevicePropertiesRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void EcnrAlsaSetDevicePropertiesRequest::clear() {
    clearEcnrAppId();
    clearAlsaDeviceSelect();
    clearAlsaDeviceProperty();
    clearPropertyValue();
}

inline void EcnrAlsaSetDevicePropertiesRequest::clearEcnrAppId() {
    if (hasEcnrAppId()) {
         clear_has_ecnrAppId();
        _ecnrAppId = 0u;
     }
}

inline bool EcnrAlsaSetDevicePropertiesRequest::hasEcnrAppId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 EcnrAlsaSetDevicePropertiesRequest::getEcnrAppId () const {
    return _ecnrAppId;
}

inline void EcnrAlsaSetDevicePropertiesRequest::setEcnrAppId (uint8 ecnrAppId_) {
    set_has_ecnrAppId();
    this->_ecnrAppId = ecnrAppId_;
}

inline void EcnrAlsaSetDevicePropertiesRequest::clearAlsaDeviceSelect() {
    if (hasAlsaDeviceSelect()) {
         clear_has_AlsaDeviceSelect();
        _AlsaDeviceSelect = 0u;
     }
}

inline bool EcnrAlsaSetDevicePropertiesRequest::hasAlsaDeviceSelect () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 EcnrAlsaSetDevicePropertiesRequest::getAlsaDeviceSelect () const {
    return _AlsaDeviceSelect;
}

inline void EcnrAlsaSetDevicePropertiesRequest::setAlsaDeviceSelect (uint32 AlsaDeviceSelect_) {
    set_has_AlsaDeviceSelect();
    this->_AlsaDeviceSelect = AlsaDeviceSelect_;
}

inline void EcnrAlsaSetDevicePropertiesRequest::clearAlsaDeviceProperty() {
    if (hasAlsaDeviceProperty()) {
         clear_has_AlsaDeviceProperty();
        _AlsaDeviceProperty = 0u;
     }
}

inline bool EcnrAlsaSetDevicePropertiesRequest::hasAlsaDeviceProperty () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint8 EcnrAlsaSetDevicePropertiesRequest::getAlsaDeviceProperty () const {
    return _AlsaDeviceProperty;
}

inline void EcnrAlsaSetDevicePropertiesRequest::setAlsaDeviceProperty (uint8 AlsaDeviceProperty_) {
    set_has_AlsaDeviceProperty();
    this->_AlsaDeviceProperty = AlsaDeviceProperty_;
}

inline void EcnrAlsaSetDevicePropertiesRequest::clearPropertyValue() {
    if (hasPropertyValue()) {
         clear_has_PropertyValue();
        _PropertyValue = 0u;
     }
}

inline bool EcnrAlsaSetDevicePropertiesRequest::hasPropertyValue () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint32 EcnrAlsaSetDevicePropertiesRequest::getPropertyValue () const {
    return _PropertyValue;
}

inline void EcnrAlsaSetDevicePropertiesRequest::setPropertyValue (uint32 PropertyValue_) {
    set_has_PropertyValue();
    this->_PropertyValue = PropertyValue_;
}

inline void EcnrAlsaSetDevicePropertiesRequest::set_has_ecnrAppId () {
    _has_bits_[0] |= 1u << 0;
}

inline void EcnrAlsaSetDevicePropertiesRequest::clear_has_ecnrAppId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void EcnrAlsaSetDevicePropertiesRequest::set_has_AlsaDeviceSelect () {
    _has_bits_[0] |= 1u << 1;
}

inline void EcnrAlsaSetDevicePropertiesRequest::clear_has_AlsaDeviceSelect () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void EcnrAlsaSetDevicePropertiesRequest::set_has_AlsaDeviceProperty () {
    _has_bits_[0] |= 1u << 2;
}

inline void EcnrAlsaSetDevicePropertiesRequest::clear_has_AlsaDeviceProperty () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void EcnrAlsaSetDevicePropertiesRequest::set_has_PropertyValue () {
    _has_bits_[0] |= 1u << 3;
}

inline void EcnrAlsaSetDevicePropertiesRequest::clear_has_PropertyValue () {
    _has_bits_[0] &= ~ (1u << 3);
}

} // namespace alsa
} // namespace ecnr
} // namespace bosch
} // namespace org

#endif // ORG_BOSCH_ECNR_ALSA_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
