/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "org/bosch/audproc/service.h"
#include "org/bosch/audproc/serviceDBus.h"
#include "org/bosch/audproc/serviceJson.h"
#include "org/bosch/audproc/serviceProxy.h"
#include <string>
#include <vector>

#include "asf/dbus/DBusDaemonProxy.h"
#include "asf/dbus/DBusPropertiesProxyWrapper.h"
#include "asf/dbus/DBusProxyDelegate.h"
#include "asf/dbus/DBusMessage.h"

namespace org {
namespace bosch {
namespace audproc {
namespace service {

DEFINE_CLASS_LOGGER("///org/bosch/audproc/service", ServiceProxy);

class ServiceProxyCallback : public ::asf::dbus::DBusProxyCallback {
public:

    ServiceProxyCallback(uint16 functionId, void* callback) :
        ::asf::dbus::DBusProxyCallback (functionId, callback)
    {}

    bool processMessage (::asf::dbus::DBusMessage &message) {
        const ::boost::shared_ptr< ServiceProxy >& proxyShared = ::boost::static_pointer_cast< ServiceProxy >(message.getDBusProxyShared()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        switch (_functionId) {
            case ID_AudprocStatus:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), AudprocStatusSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "AudprocStatus", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<AudprocStatusSignal> payload = ::boost::static_pointer_cast<AudprocStatusSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((AudprocStatusCallbackIF*) _callback)->onAudprocStatusSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_AudprocMicrolevelStatus:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), AudprocMicrolevelStatusSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "AudprocMicrolevelStatus", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<AudprocMicrolevelStatusSignal> payload = ::boost::static_pointer_cast<AudprocMicrolevelStatusSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((AudprocMicrolevelStatusCallbackIF*) _callback)->onAudprocMicrolevelStatusSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_AudprocArkamysLevelLoss:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), AudprocArkamysLevelLossSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "AudprocArkamysLevelLoss", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<AudprocArkamysLevelLossSignal> payload = ::boost::static_pointer_cast<AudprocArkamysLevelLossSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((AudprocArkamysLevelLossCallbackIF*) _callback)->onAudprocArkamysLevelLossSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_aplArkamysAvcActivate:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), AplArkamysAvcActivateError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "AplArkamysAvcActivate", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<AplArkamysAvcActivateError> payload = ::boost::static_pointer_cast<AplArkamysAvcActivateError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((AplArkamysAvcActivateCallbackIF*) _callback)->onAplArkamysAvcActivateError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), AplArkamysAvcActivateUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "AplArkamysAvcActivate", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<AplArkamysAvcActivateUpdate> payload = ::boost::static_pointer_cast<AplArkamysAvcActivateUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((AplArkamysAvcActivateCallbackIF*) _callback)->onAplArkamysAvcActivateUpdate(proxyShared, payload);
                        proxyShared->_aplArkamysAvcActivate = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_aplArkamysByPassActivate:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), AplArkamysByPassActivateError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "AplArkamysByPassActivate", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<AplArkamysByPassActivateError> payload = ::boost::static_pointer_cast<AplArkamysByPassActivateError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((AplArkamysByPassActivateCallbackIF*) _callback)->onAplArkamysByPassActivateError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), AplArkamysByPassActivateUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "AplArkamysByPassActivate", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<AplArkamysByPassActivateUpdate> payload = ::boost::static_pointer_cast<AplArkamysByPassActivateUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((AplArkamysByPassActivateCallbackIF*) _callback)->onAplArkamysByPassActivateUpdate(proxyShared, payload);
                        proxyShared->_aplArkamysByPassActivate = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_aplArkamysInputLevelDeviation:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), AplArkamysInputLevelDeviationError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "AplArkamysInputLevelDeviation", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<AplArkamysInputLevelDeviationError> payload = ::boost::static_pointer_cast<AplArkamysInputLevelDeviationError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((AplArkamysInputLevelDeviationCallbackIF*) _callback)->onAplArkamysInputLevelDeviationError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), AplArkamysInputLevelDeviationUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "AplArkamysInputLevelDeviation", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<AplArkamysInputLevelDeviationUpdate> payload = ::boost::static_pointer_cast<AplArkamysInputLevelDeviationUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((AplArkamysInputLevelDeviationCallbackIF*) _callback)->onAplArkamysInputLevelDeviationUpdate(proxyShared, payload);
                        proxyShared->_aplArkamysInputLevelDeviation = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_aplArkamysCurrentSpeed:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), AplArkamysCurrentSpeedError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "AplArkamysCurrentSpeed", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<AplArkamysCurrentSpeedError> payload = ::boost::static_pointer_cast<AplArkamysCurrentSpeedError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((AplArkamysCurrentSpeedCallbackIF*) _callback)->onAplArkamysCurrentSpeedError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), AplArkamysCurrentSpeedUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "AplArkamysCurrentSpeed", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<AplArkamysCurrentSpeedUpdate> payload = ::boost::static_pointer_cast<AplArkamysCurrentSpeedUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((AplArkamysCurrentSpeedCallbackIF*) _callback)->onAplArkamysCurrentSpeedUpdate(proxyShared, payload);
                        proxyShared->_aplArkamysCurrentSpeed = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_aplArkamysCurrentVolumeStep:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), AplArkamysCurrentVolumeStepError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "AplArkamysCurrentVolumeStep", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<AplArkamysCurrentVolumeStepError> payload = ::boost::static_pointer_cast<AplArkamysCurrentVolumeStepError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((AplArkamysCurrentVolumeStepCallbackIF*) _callback)->onAplArkamysCurrentVolumeStepError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), AplArkamysCurrentVolumeStepUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "AplArkamysCurrentVolumeStep", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<AplArkamysCurrentVolumeStepUpdate> payload = ::boost::static_pointer_cast<AplArkamysCurrentVolumeStepUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((AplArkamysCurrentVolumeStepCallbackIF*) _callback)->onAplArkamysCurrentVolumeStepUpdate(proxyShared, payload);
                        proxyShared->_aplArkamysCurrentVolumeStep = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_aplArkamysAmbienceSelect:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), AplArkamysAmbienceSelectError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "AplArkamysAmbienceSelect", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<AplArkamysAmbienceSelectError> payload = ::boost::static_pointer_cast<AplArkamysAmbienceSelectError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((AplArkamysAmbienceSelectCallbackIF*) _callback)->onAplArkamysAmbienceSelectError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), AplArkamysAmbienceSelectUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "AplArkamysAmbienceSelect", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<AplArkamysAmbienceSelectUpdate> payload = ::boost::static_pointer_cast<AplArkamysAmbienceSelectUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((AplArkamysAmbienceSelectCallbackIF*) _callback)->onAplArkamysAmbienceSelectUpdate(proxyShared, payload);
                        proxyShared->_aplArkamysAmbienceSelect = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_aplArkamysLevelLoss:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), AplArkamysLevelLossError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "AplArkamysLevelLoss", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<AplArkamysLevelLossError> payload = ::boost::static_pointer_cast<AplArkamysLevelLossError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((AplArkamysLevelLossCallbackIF*) _callback)->onAplArkamysLevelLossError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), AplArkamysLevelLossUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "AplArkamysLevelLoss", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<AplArkamysLevelLossUpdate> payload = ::boost::static_pointer_cast<AplArkamysLevelLossUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((AplArkamysLevelLossCallbackIF*) _callback)->onAplArkamysLevelLossUpdate(proxyShared, payload);
                        proxyShared->_aplArkamysLevelLoss = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_aplArkamysLibraryVersion:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), AplArkamysLibraryVersionError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "AplArkamysLibraryVersion", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<AplArkamysLibraryVersionError> payload = ::boost::static_pointer_cast<AplArkamysLibraryVersionError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((AplArkamysLibraryVersionCallbackIF*) _callback)->onAplArkamysLibraryVersionError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), AplArkamysLibraryVersionUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "AplArkamysLibraryVersion", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<AplArkamysLibraryVersionUpdate> payload = ::boost::static_pointer_cast<AplArkamysLibraryVersionUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((AplArkamysLibraryVersionCallbackIF*) _callback)->onAplArkamysLibraryVersionUpdate(proxyShared, payload);
                        proxyShared->_aplArkamysLibraryVersion = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_aplArkamysCurrVolAttenuation:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), AplArkamysCurrVolAttenuationError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "AplArkamysCurrVolAttenuation", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<AplArkamysCurrVolAttenuationError> payload = ::boost::static_pointer_cast<AplArkamysCurrVolAttenuationError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((AplArkamysCurrVolAttenuationCallbackIF*) _callback)->onAplArkamysCurrVolAttenuationError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), AplArkamysCurrVolAttenuationUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "AplArkamysCurrVolAttenuation", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<AplArkamysCurrVolAttenuationUpdate> payload = ::boost::static_pointer_cast<AplArkamysCurrVolAttenuationUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((AplArkamysCurrVolAttenuationCallbackIF*) _callback)->onAplArkamysCurrVolAttenuationUpdate(proxyShared, payload);
                        proxyShared->_aplArkamysCurrVolAttenuation = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_aplArkamysFlush:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), AplArkamysFlushError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "AplArkamysFlush", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<AplArkamysFlushError> payload = ::boost::static_pointer_cast<AplArkamysFlushError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((AplArkamysFlushCallbackIF*) _callback)->onAplArkamysFlushError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), AplArkamysFlushUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "AplArkamysFlush", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<AplArkamysFlushUpdate> payload = ::boost::static_pointer_cast<AplArkamysFlushUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((AplArkamysFlushCallbackIF*) _callback)->onAplArkamysFlushUpdate(proxyShared, payload);
                        proxyShared->_aplArkamysFlush = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_aplMicLvlWatchRefInt:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), AplMicLvlWatchRefIntError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "AplMicLvlWatchRefInt", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<AplMicLvlWatchRefIntError> payload = ::boost::static_pointer_cast<AplMicLvlWatchRefIntError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((AplMicLvlWatchRefIntCallbackIF*) _callback)->onAplMicLvlWatchRefIntError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), AplMicLvlWatchRefIntUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "AplMicLvlWatchRefInt", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<AplMicLvlWatchRefIntUpdate> payload = ::boost::static_pointer_cast<AplMicLvlWatchRefIntUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((AplMicLvlWatchRefIntCallbackIF*) _callback)->onAplMicLvlWatchRefIntUpdate(proxyShared, payload);
                        proxyShared->_aplMicLvlWatchRefInt = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_aplMicLvl:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), AplMicLvlError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "AplMicLvl", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<AplMicLvlError> payload = ::boost::static_pointer_cast<AplMicLvlError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((AplMicLvlCallbackIF*) _callback)->onAplMicLvlError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), AplMicLvlUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "AplMicLvl", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<AplMicLvlUpdate> payload = ::boost::static_pointer_cast<AplMicLvlUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((AplMicLvlCallbackIF*) _callback)->onAplMicLvlUpdate(proxyShared, payload);
                        proxyShared->_aplMicLvl = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_aplAudioMode:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), AplAudioModeError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "AplAudioMode", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<AplAudioModeError> payload = ::boost::static_pointer_cast<AplAudioModeError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((AplAudioModeCallbackIF*) _callback)->onAplAudioModeError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), AplAudioModeUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "AplAudioMode", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<AplAudioModeUpdate> payload = ::boost::static_pointer_cast<AplAudioModeUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((AplAudioModeCallbackIF*) _callback)->onAplAudioModeUpdate(proxyShared, payload);
                        proxyShared->_aplAudioMode = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_aplLoopbackActivate:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), AplLoopbackActivateError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "AplLoopbackActivate", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<AplLoopbackActivateError> payload = ::boost::static_pointer_cast<AplLoopbackActivateError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((AplLoopbackActivateCallbackIF*) _callback)->onAplLoopbackActivateError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), AplLoopbackActivateUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "AplLoopbackActivate", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<AplLoopbackActivateUpdate> payload = ::boost::static_pointer_cast<AplLoopbackActivateUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((AplLoopbackActivateCallbackIF*) _callback)->onAplLoopbackActivateUpdate(proxyShared, payload);
                        proxyShared->_aplLoopbackActivate = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_AudprocGetVersion:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), AudprocGetVersionError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "AudprocGetVersion", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<AudprocGetVersionError> payload = ::boost::static_pointer_cast<AudprocGetVersionError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((AudprocGetVersionCallbackIF*) _callback)->onAudprocGetVersionError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), AudprocGetVersionResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "AudprocGetVersion", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<AudprocGetVersionResponse> payload = ::boost::static_pointer_cast<AudprocGetVersionResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((AudprocGetVersionCallbackIF*) _callback)->onAudprocGetVersionResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_AudprocGetStatus:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), AudprocGetStatusError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "AudprocGetStatus", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<AudprocGetStatusError> payload = ::boost::static_pointer_cast<AudprocGetStatusError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((AudprocGetStatusCallbackIF*) _callback)->onAudprocGetStatusError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), AudprocGetStatusResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "AudprocGetStatus", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<AudprocGetStatusResponse> payload = ::boost::static_pointer_cast<AudprocGetStatusResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((AudprocGetStatusCallbackIF*) _callback)->onAudprocGetStatusResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_AudprocTerminate:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), AudprocTerminateError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "AudprocTerminate", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<AudprocTerminateError> payload = ::boost::static_pointer_cast<AudprocTerminateError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((AudprocTerminateCallbackIF*) _callback)->onAudprocTerminateError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), AudprocTerminateResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "AudprocTerminate", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<AudprocTerminateResponse> payload = ::boost::static_pointer_cast<AudprocTerminateResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((AudprocTerminateCallbackIF*) _callback)->onAudprocTerminateResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_AudprocSetupDebug:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), AudprocSetupDebugError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "AudprocSetupDebug", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<AudprocSetupDebugError> payload = ::boost::static_pointer_cast<AudprocSetupDebugError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((AudprocSetupDebugCallbackIF*) _callback)->onAudprocSetupDebugError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), AudprocSetupDebugResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "AudprocSetupDebug", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<AudprocSetupDebugResponse> payload = ::boost::static_pointer_cast<AudprocSetupDebugResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((AudprocSetupDebugCallbackIF*) _callback)->onAudprocSetupDebugResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_AudprocCreate:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), AudprocCreateError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "AudprocCreate", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<AudprocCreateError> payload = ::boost::static_pointer_cast<AudprocCreateError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((AudprocCreateCallbackIF*) _callback)->onAudprocCreateError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), AudprocCreateResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "AudprocCreate", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<AudprocCreateResponse> payload = ::boost::static_pointer_cast<AudprocCreateResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((AudprocCreateCallbackIF*) _callback)->onAudprocCreateResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_AudprocInitialize:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), AudprocInitializeError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "AudprocInitialize", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<AudprocInitializeError> payload = ::boost::static_pointer_cast<AudprocInitializeError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((AudprocInitializeCallbackIF*) _callback)->onAudprocInitializeError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), AudprocInitializeResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "AudprocInitialize", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<AudprocInitializeResponse> payload = ::boost::static_pointer_cast<AudprocInitializeResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((AudprocInitializeCallbackIF*) _callback)->onAudprocInitializeResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_AudprocSetConfiguration:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), AudprocSetConfigurationError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "AudprocSetConfiguration", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<AudprocSetConfigurationError> payload = ::boost::static_pointer_cast<AudprocSetConfigurationError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((AudprocSetConfigurationCallbackIF*) _callback)->onAudprocSetConfigurationError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), AudprocSetConfigurationResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "AudprocSetConfiguration", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<AudprocSetConfigurationResponse> payload = ::boost::static_pointer_cast<AudprocSetConfigurationResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((AudprocSetConfigurationCallbackIF*) _callback)->onAudprocSetConfigurationResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_AudprocDestroy:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), AudprocDestroyError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "AudprocDestroy", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<AudprocDestroyError> payload = ::boost::static_pointer_cast<AudprocDestroyError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((AudprocDestroyCallbackIF*) _callback)->onAudprocDestroyError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), AudprocDestroyResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "AudprocDestroy", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<AudprocDestroyResponse> payload = ::boost::static_pointer_cast<AudprocDestroyResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((AudprocDestroyCallbackIF*) _callback)->onAudprocDestroyResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_AudprocSetParam:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), AudprocSetParamError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "AudprocSetParam", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<AudprocSetParamError> payload = ::boost::static_pointer_cast<AudprocSetParamError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((AudprocSetParamCallbackIF*) _callback)->onAudprocSetParamError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), AudprocSetParamResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "AudprocSetParam", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<AudprocSetParamResponse> payload = ::boost::static_pointer_cast<AudprocSetParamResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((AudprocSetParamCallbackIF*) _callback)->onAudprocSetParamResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_AudprocWriteData:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), AudprocWriteDataError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "AudprocWriteData", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<AudprocWriteDataError> payload = ::boost::static_pointer_cast<AudprocWriteDataError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((AudprocWriteDataCallbackIF*) _callback)->onAudprocWriteDataError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), AudprocWriteDataResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "AudprocWriteData", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<AudprocWriteDataResponse> payload = ::boost::static_pointer_cast<AudprocWriteDataResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((AudprocWriteDataCallbackIF*) _callback)->onAudprocWriteDataResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_AudprocReadData:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), AudprocReadDataError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "AudprocReadData", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<AudprocReadDataError> payload = ::boost::static_pointer_cast<AudprocReadDataError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((AudprocReadDataCallbackIF*) _callback)->onAudprocReadDataError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), AudprocReadDataResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "AudprocReadData", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<AudprocReadDataResponse> payload = ::boost::static_pointer_cast<AudprocReadDataResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((AudprocReadDataCallbackIF*) _callback)->onAudprocReadDataResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_AudprocGetAudprocConfiguration:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), AudprocGetAudprocConfigurationError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "AudprocGetAudprocConfiguration", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<AudprocGetAudprocConfigurationError> payload = ::boost::static_pointer_cast<AudprocGetAudprocConfigurationError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((AudprocGetAudprocConfigurationCallbackIF*) _callback)->onAudprocGetAudprocConfigurationError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), AudprocGetAudprocConfigurationResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "AudprocGetAudprocConfiguration", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<AudprocGetAudprocConfigurationResponse> payload = ::boost::static_pointer_cast<AudprocGetAudprocConfigurationResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((AudprocGetAudprocConfigurationCallbackIF*) _callback)->onAudprocGetAudprocConfigurationResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_AudprocStartAudio:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), AudprocStartAudioError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "AudprocStartAudio", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<AudprocStartAudioError> payload = ::boost::static_pointer_cast<AudprocStartAudioError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((AudprocStartAudioCallbackIF*) _callback)->onAudprocStartAudioError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), AudprocStartAudioResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "AudprocStartAudio", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<AudprocStartAudioResponse> payload = ::boost::static_pointer_cast<AudprocStartAudioResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((AudprocStartAudioCallbackIF*) _callback)->onAudprocStartAudioResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_AudprocStopAudio:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), AudprocStopAudioError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "AudprocStopAudio", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<AudprocStopAudioError> payload = ::boost::static_pointer_cast<AudprocStopAudioError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((AudprocStopAudioCallbackIF*) _callback)->onAudprocStopAudioError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), AudprocStopAudioResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "AudprocStopAudio", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<AudprocStopAudioResponse> payload = ::boost::static_pointer_cast<AudprocStopAudioResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((AudprocStopAudioCallbackIF*) _callback)->onAudprocStopAudioResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_AudprocMute:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), AudprocMuteError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "AudprocMute", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<AudprocMuteError> payload = ::boost::static_pointer_cast<AudprocMuteError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((AudprocMuteCallbackIF*) _callback)->onAudprocMuteError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), AudprocMuteResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "AudprocMute", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<AudprocMuteResponse> payload = ::boost::static_pointer_cast<AudprocMuteResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((AudprocMuteCallbackIF*) _callback)->onAudprocMuteResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_AudprocSourceActivity:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), AudprocSourceActivityError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "AudprocSourceActivity", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<AudprocSourceActivityError> payload = ::boost::static_pointer_cast<AudprocSourceActivityError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((AudprocSourceActivityCallbackIF*) _callback)->onAudprocSourceActivityError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), AudprocSourceActivityResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "AudprocSourceActivity", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<AudprocSourceActivityResponse> payload = ::boost::static_pointer_cast<AudprocSourceActivityResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((AudprocSourceActivityCallbackIF*) _callback)->onAudprocSourceActivityResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_AudprocSourceSelect:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), AudprocSourceSelectError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "AudprocSourceSelect", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<AudprocSourceSelectError> payload = ::boost::static_pointer_cast<AudprocSourceSelectError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((AudprocSourceSelectCallbackIF*) _callback)->onAudprocSourceSelectError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), AudprocSourceSelectResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "AudprocSourceSelect", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<AudprocSourceSelectResponse> payload = ::boost::static_pointer_cast<AudprocSourceSelectResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((AudprocSourceSelectCallbackIF*) _callback)->onAudprocSourceSelectResponse (proxyShared, payload);
                        return true;
                    }
                }
            default:
            LOG_FATAL ("Received an invalid functionId, proxy=%p", message.getProxy());
        }
        LOG_FATAL("Receveid an invalid message, proxy=%p", message.getProxy());
        return false;
    }

    bool onServiceUnavailable (const ::boost::shared_ptr< ::asf::core::Proxy >& baseProxy) {
        switch (_functionId) {
            case ID_AudprocStatus: {
                ::boost::shared_ptr< AudprocStatusError > payload = ::boost::shared_ptr< AudprocStatusError >
                (new AudprocStatusError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "AudprocStatus", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((AudprocStatusCallbackIF*) _callback)->onAudprocStatusError (proxyShared,payload);
                return true;
            }
            break;
            case ID_AudprocMicrolevelStatus: {
                ::boost::shared_ptr< AudprocMicrolevelStatusError > payload = ::boost::shared_ptr< AudprocMicrolevelStatusError >
                (new AudprocMicrolevelStatusError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "AudprocMicrolevelStatus", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((AudprocMicrolevelStatusCallbackIF*) _callback)->onAudprocMicrolevelStatusError (proxyShared,payload);
                return true;
            }
            break;
            case ID_AudprocArkamysLevelLoss: {
                ::boost::shared_ptr< AudprocArkamysLevelLossError > payload = ::boost::shared_ptr< AudprocArkamysLevelLossError >
                (new AudprocArkamysLevelLossError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "AudprocArkamysLevelLoss", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((AudprocArkamysLevelLossCallbackIF*) _callback)->onAudprocArkamysLevelLossError (proxyShared,payload);
                return true;
            }
            break;
            case ID_aplArkamysAvcActivate: {
                ::boost::shared_ptr< AplArkamysAvcActivateError > payload = ::boost::shared_ptr< AplArkamysAvcActivateError >
                (new AplArkamysAvcActivateError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "AplArkamysAvcActivate", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((AplArkamysAvcActivateCallbackIF*) _callback)->onAplArkamysAvcActivateError (proxyShared,payload);
                return true;
            }
            break;
            case ID_aplArkamysByPassActivate: {
                ::boost::shared_ptr< AplArkamysByPassActivateError > payload = ::boost::shared_ptr< AplArkamysByPassActivateError >
                (new AplArkamysByPassActivateError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "AplArkamysByPassActivate", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((AplArkamysByPassActivateCallbackIF*) _callback)->onAplArkamysByPassActivateError (proxyShared,payload);
                return true;
            }
            break;
            case ID_aplArkamysInputLevelDeviation: {
                ::boost::shared_ptr< AplArkamysInputLevelDeviationError > payload = ::boost::shared_ptr< AplArkamysInputLevelDeviationError >
                (new AplArkamysInputLevelDeviationError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "AplArkamysInputLevelDeviation", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((AplArkamysInputLevelDeviationCallbackIF*) _callback)->onAplArkamysInputLevelDeviationError (proxyShared,payload);
                return true;
            }
            break;
            case ID_aplArkamysCurrentSpeed: {
                ::boost::shared_ptr< AplArkamysCurrentSpeedError > payload = ::boost::shared_ptr< AplArkamysCurrentSpeedError >
                (new AplArkamysCurrentSpeedError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "AplArkamysCurrentSpeed", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((AplArkamysCurrentSpeedCallbackIF*) _callback)->onAplArkamysCurrentSpeedError (proxyShared,payload);
                return true;
            }
            break;
            case ID_aplArkamysCurrentVolumeStep: {
                ::boost::shared_ptr< AplArkamysCurrentVolumeStepError > payload = ::boost::shared_ptr< AplArkamysCurrentVolumeStepError >
                (new AplArkamysCurrentVolumeStepError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "AplArkamysCurrentVolumeStep", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((AplArkamysCurrentVolumeStepCallbackIF*) _callback)->onAplArkamysCurrentVolumeStepError (proxyShared,payload);
                return true;
            }
            break;
            case ID_aplArkamysAmbienceSelect: {
                ::boost::shared_ptr< AplArkamysAmbienceSelectError > payload = ::boost::shared_ptr< AplArkamysAmbienceSelectError >
                (new AplArkamysAmbienceSelectError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "AplArkamysAmbienceSelect", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((AplArkamysAmbienceSelectCallbackIF*) _callback)->onAplArkamysAmbienceSelectError (proxyShared,payload);
                return true;
            }
            break;
            case ID_aplArkamysLevelLoss: {
                ::boost::shared_ptr< AplArkamysLevelLossError > payload = ::boost::shared_ptr< AplArkamysLevelLossError >
                (new AplArkamysLevelLossError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "AplArkamysLevelLoss", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((AplArkamysLevelLossCallbackIF*) _callback)->onAplArkamysLevelLossError (proxyShared,payload);
                return true;
            }
            break;
            case ID_aplArkamysLibraryVersion: {
                ::boost::shared_ptr< AplArkamysLibraryVersionError > payload = ::boost::shared_ptr< AplArkamysLibraryVersionError >
                (new AplArkamysLibraryVersionError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "AplArkamysLibraryVersion", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((AplArkamysLibraryVersionCallbackIF*) _callback)->onAplArkamysLibraryVersionError (proxyShared,payload);
                return true;
            }
            break;
            case ID_aplArkamysCurrVolAttenuation: {
                ::boost::shared_ptr< AplArkamysCurrVolAttenuationError > payload = ::boost::shared_ptr< AplArkamysCurrVolAttenuationError >
                (new AplArkamysCurrVolAttenuationError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "AplArkamysCurrVolAttenuation", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((AplArkamysCurrVolAttenuationCallbackIF*) _callback)->onAplArkamysCurrVolAttenuationError (proxyShared,payload);
                return true;
            }
            break;
            case ID_aplArkamysFlush: {
                ::boost::shared_ptr< AplArkamysFlushError > payload = ::boost::shared_ptr< AplArkamysFlushError >
                (new AplArkamysFlushError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "AplArkamysFlush", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((AplArkamysFlushCallbackIF*) _callback)->onAplArkamysFlushError (proxyShared,payload);
                return true;
            }
            break;
            case ID_aplMicLvlWatchRefInt: {
                ::boost::shared_ptr< AplMicLvlWatchRefIntError > payload = ::boost::shared_ptr< AplMicLvlWatchRefIntError >
                (new AplMicLvlWatchRefIntError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "AplMicLvlWatchRefInt", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((AplMicLvlWatchRefIntCallbackIF*) _callback)->onAplMicLvlWatchRefIntError (proxyShared,payload);
                return true;
            }
            break;
            case ID_aplMicLvl: {
                ::boost::shared_ptr< AplMicLvlError > payload = ::boost::shared_ptr< AplMicLvlError >
                (new AplMicLvlError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "AplMicLvl", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((AplMicLvlCallbackIF*) _callback)->onAplMicLvlError (proxyShared,payload);
                return true;
            }
            break;
            case ID_aplAudioMode: {
                ::boost::shared_ptr< AplAudioModeError > payload = ::boost::shared_ptr< AplAudioModeError >
                (new AplAudioModeError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "AplAudioMode", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((AplAudioModeCallbackIF*) _callback)->onAplAudioModeError (proxyShared,payload);
                return true;
            }
            break;
            case ID_aplLoopbackActivate: {
                ::boost::shared_ptr< AplLoopbackActivateError > payload = ::boost::shared_ptr< AplLoopbackActivateError >
                (new AplLoopbackActivateError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "AplLoopbackActivate", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((AplLoopbackActivateCallbackIF*) _callback)->onAplLoopbackActivateError (proxyShared,payload);
                return true;
            }
            break;
            case ID_AudprocGetVersion: {
                ::boost::shared_ptr< AudprocGetVersionError > payload = ::boost::shared_ptr< AudprocGetVersionError >
                (new AudprocGetVersionError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "AudprocGetVersion", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((AudprocGetVersionCallbackIF*) _callback)->onAudprocGetVersionError (proxyShared,payload);
                return true;
            }
            break;
            case ID_AudprocGetStatus: {
                ::boost::shared_ptr< AudprocGetStatusError > payload = ::boost::shared_ptr< AudprocGetStatusError >
                (new AudprocGetStatusError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "AudprocGetStatus", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((AudprocGetStatusCallbackIF*) _callback)->onAudprocGetStatusError (proxyShared,payload);
                return true;
            }
            break;
            case ID_AudprocTerminate: {
                ::boost::shared_ptr< AudprocTerminateError > payload = ::boost::shared_ptr< AudprocTerminateError >
                (new AudprocTerminateError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "AudprocTerminate", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((AudprocTerminateCallbackIF*) _callback)->onAudprocTerminateError (proxyShared,payload);
                return true;
            }
            break;
            case ID_AudprocSetupDebug: {
                ::boost::shared_ptr< AudprocSetupDebugError > payload = ::boost::shared_ptr< AudprocSetupDebugError >
                (new AudprocSetupDebugError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "AudprocSetupDebug", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((AudprocSetupDebugCallbackIF*) _callback)->onAudprocSetupDebugError (proxyShared,payload);
                return true;
            }
            break;
            case ID_AudprocCreate: {
                ::boost::shared_ptr< AudprocCreateError > payload = ::boost::shared_ptr< AudprocCreateError >
                (new AudprocCreateError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "AudprocCreate", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((AudprocCreateCallbackIF*) _callback)->onAudprocCreateError (proxyShared,payload);
                return true;
            }
            break;
            case ID_AudprocInitialize: {
                ::boost::shared_ptr< AudprocInitializeError > payload = ::boost::shared_ptr< AudprocInitializeError >
                (new AudprocInitializeError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "AudprocInitialize", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((AudprocInitializeCallbackIF*) _callback)->onAudprocInitializeError (proxyShared,payload);
                return true;
            }
            break;
            case ID_AudprocSetConfiguration: {
                ::boost::shared_ptr< AudprocSetConfigurationError > payload = ::boost::shared_ptr< AudprocSetConfigurationError >
                (new AudprocSetConfigurationError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "AudprocSetConfiguration", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((AudprocSetConfigurationCallbackIF*) _callback)->onAudprocSetConfigurationError (proxyShared,payload);
                return true;
            }
            break;
            case ID_AudprocDestroy: {
                ::boost::shared_ptr< AudprocDestroyError > payload = ::boost::shared_ptr< AudprocDestroyError >
                (new AudprocDestroyError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "AudprocDestroy", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((AudprocDestroyCallbackIF*) _callback)->onAudprocDestroyError (proxyShared,payload);
                return true;
            }
            break;
            case ID_AudprocSetParam: {
                ::boost::shared_ptr< AudprocSetParamError > payload = ::boost::shared_ptr< AudprocSetParamError >
                (new AudprocSetParamError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "AudprocSetParam", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((AudprocSetParamCallbackIF*) _callback)->onAudprocSetParamError (proxyShared,payload);
                return true;
            }
            break;
            case ID_AudprocWriteData: {
                ::boost::shared_ptr< AudprocWriteDataError > payload = ::boost::shared_ptr< AudprocWriteDataError >
                (new AudprocWriteDataError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "AudprocWriteData", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((AudprocWriteDataCallbackIF*) _callback)->onAudprocWriteDataError (proxyShared,payload);
                return true;
            }
            break;
            case ID_AudprocReadData: {
                ::boost::shared_ptr< AudprocReadDataError > payload = ::boost::shared_ptr< AudprocReadDataError >
                (new AudprocReadDataError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "AudprocReadData", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((AudprocReadDataCallbackIF*) _callback)->onAudprocReadDataError (proxyShared,payload);
                return true;
            }
            break;
            case ID_AudprocGetAudprocConfiguration: {
                ::boost::shared_ptr< AudprocGetAudprocConfigurationError > payload = ::boost::shared_ptr< AudprocGetAudprocConfigurationError >
                (new AudprocGetAudprocConfigurationError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "AudprocGetAudprocConfiguration", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((AudprocGetAudprocConfigurationCallbackIF*) _callback)->onAudprocGetAudprocConfigurationError (proxyShared,payload);
                return true;
            }
            break;
            case ID_AudprocStartAudio: {
                ::boost::shared_ptr< AudprocStartAudioError > payload = ::boost::shared_ptr< AudprocStartAudioError >
                (new AudprocStartAudioError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "AudprocStartAudio", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((AudprocStartAudioCallbackIF*) _callback)->onAudprocStartAudioError (proxyShared,payload);
                return true;
            }
            break;
            case ID_AudprocStopAudio: {
                ::boost::shared_ptr< AudprocStopAudioError > payload = ::boost::shared_ptr< AudprocStopAudioError >
                (new AudprocStopAudioError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "AudprocStopAudio", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((AudprocStopAudioCallbackIF*) _callback)->onAudprocStopAudioError (proxyShared,payload);
                return true;
            }
            break;
            case ID_AudprocMute: {
                ::boost::shared_ptr< AudprocMuteError > payload = ::boost::shared_ptr< AudprocMuteError >
                (new AudprocMuteError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "AudprocMute", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((AudprocMuteCallbackIF*) _callback)->onAudprocMuteError (proxyShared,payload);
                return true;
            }
            break;
            case ID_AudprocSourceActivity: {
                ::boost::shared_ptr< AudprocSourceActivityError > payload = ::boost::shared_ptr< AudprocSourceActivityError >
                (new AudprocSourceActivityError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "AudprocSourceActivity", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((AudprocSourceActivityCallbackIF*) _callback)->onAudprocSourceActivityError (proxyShared,payload);
                return true;
            }
            break;
            case ID_AudprocSourceSelect: {
                ::boost::shared_ptr< AudprocSourceSelectError > payload = ::boost::shared_ptr< AudprocSourceSelectError >
                (new AudprocSourceSelectError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "AudprocSourceSelect", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((AudprocSourceSelectCallbackIF*) _callback)->onAudprocSourceSelectError (proxyShared,payload);
                return true;
            }
            break;
            default:
                break;
        }
        return false;
    }

    static ::asf::core::Logger&_logger;
};

::asf::core::Logger& ServiceProxyCallback::_logger (ServiceProxy::_logger);

ServiceProxy::ServiceProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable) :
    ::asf::dbus::DBusProxy(portName, "org.bosch.audproc.service", serviceAvailable, _logger) {
}

ServiceProxy::~ServiceProxy()
{
    sendDeregisterAll();
    ::asf::dbus::DBusConnector::getConnector(getConnectorOptions())->deregisterProxyDelegate(_dbusProxyDelegate);
}

// static
::boost::shared_ptr< ServiceProxy > ServiceProxy::createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable) {
    ::boost::shared_ptr< Proxy > proxyReuse = ::asf::dbus::DBusConnector::getProxy(portName, serviceAvailable);
    if(proxyReuse) {
        LOG_INFO_STATIC ("createProxy, reuse existing proxy");
        return ::boost::static_pointer_cast<ServiceProxy>(proxyReuse); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
    }
    LOG_INFO_STATIC ("createProxy, create new proxy");
    ::boost::shared_ptr< ServiceProxy > proxyNew(new ServiceProxy(portName, serviceAvailable));
    ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew);
    proxyNew->createHelperProxies(true);
    return proxyNew;
}

act_t ServiceProxy::addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const {
    ServiceProxyCallback* callback = new ServiceProxyCallback(methodId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->addMethodCallback (serial, memberName, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

act_t ServiceProxy::addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const {
    ServiceProxyCallback* callback = new ServiceProxyCallback(signalId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->registerSignalCallback (signal, reinterpret_cast<act_t>(callback), ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void ServiceProxy::clearAllProperties ()
{
    _aplArkamysAvcActivate = ::asf::core::nullable< AplArkamysAvcActivateUpdate >();
    _aplArkamysByPassActivate = ::asf::core::nullable< AplArkamysByPassActivateUpdate >();
    _aplArkamysInputLevelDeviation = ::asf::core::nullable< AplArkamysInputLevelDeviationUpdate >();
    _aplArkamysCurrentSpeed = ::asf::core::nullable< AplArkamysCurrentSpeedUpdate >();
    _aplArkamysCurrentVolumeStep = ::asf::core::nullable< AplArkamysCurrentVolumeStepUpdate >();
    _aplArkamysAmbienceSelect = ::asf::core::nullable< AplArkamysAmbienceSelectUpdate >();
    _aplArkamysLevelLoss = ::asf::core::nullable< AplArkamysLevelLossUpdate >();
    _aplArkamysLibraryVersion = ::asf::core::nullable< AplArkamysLibraryVersionUpdate >();
    _aplArkamysCurrVolAttenuation = ::asf::core::nullable< AplArkamysCurrVolAttenuationUpdate >();
    _aplArkamysFlush = ::asf::core::nullable< AplArkamysFlushUpdate >();
    _aplMicLvlWatchRefInt = ::asf::core::nullable< AplMicLvlWatchRefIntUpdate >();
    _aplMicLvl = ::asf::core::nullable< AplMicLvlUpdate >();
    _aplAudioMode = ::asf::core::nullable< AplAudioModeUpdate >();
    _aplLoopbackActivate = ::asf::core::nullable< AplLoopbackActivateUpdate >();
}

void ServiceProxy::sendDeregisterAll () const
{
    sendAplArkamysAvcActivateDeregisterAll();
    sendAplArkamysByPassActivateDeregisterAll();
    sendAplArkamysInputLevelDeviationDeregisterAll();
    sendAplArkamysCurrentSpeedDeregisterAll();
    sendAplArkamysCurrentVolumeStepDeregisterAll();
    sendAplArkamysAmbienceSelectDeregisterAll();
    sendAplArkamysLevelLossDeregisterAll();
    sendAplArkamysLibraryVersionDeregisterAll();
    sendAplArkamysCurrVolAttenuationDeregisterAll();
    sendAplArkamysFlushDeregisterAll();
    sendAplMicLvlWatchRefIntDeregisterAll();
    sendAplMicLvlDeregisterAll();
    sendAplAudioModeDeregisterAll();
    sendAplLoopbackActivateDeregisterAll();
    sendAudprocStatusDeregisterAll();
    sendAudprocMicrolevelStatusDeregisterAll();
    sendAudprocArkamysLevelLossDeregisterAll();
}

act_t ServiceProxy::sendAudprocStatusRegister(AudprocStatusCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "AudprocStatus");
    act_t act = addSignalCallback(ID_AudprocStatus, "AudprocStatus", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "AudprocStatus", &cb, act);
    return act;
}

bool ServiceProxy::sendAudprocStatusDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("AudprocStatus", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "AudprocStatus", act, static_cast<int>(rv));
    return rv;
}

void ServiceProxy::sendAudprocStatusDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "AudprocStatus");
    _dbusProxyDelegate->deregisterSignalCallback("AudprocStatus", 0, _dbusDaemonProxy.get(), false);
}

act_t ServiceProxy::sendAudprocMicrolevelStatusRegister(AudprocMicrolevelStatusCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "AudprocMicrolevelStatus");
    act_t act = addSignalCallback(ID_AudprocMicrolevelStatus, "AudprocMicrolevelStatus", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "AudprocMicrolevelStatus", &cb, act);
    return act;
}

bool ServiceProxy::sendAudprocMicrolevelStatusDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("AudprocMicrolevelStatus", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "AudprocMicrolevelStatus", act, static_cast<int>(rv));
    return rv;
}

void ServiceProxy::sendAudprocMicrolevelStatusDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "AudprocMicrolevelStatus");
    _dbusProxyDelegate->deregisterSignalCallback("AudprocMicrolevelStatus", 0, _dbusDaemonProxy.get(), false);
}

act_t ServiceProxy::sendAudprocArkamysLevelLossRegister(AudprocArkamysLevelLossCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "AudprocArkamysLevelLoss");
    act_t act = addSignalCallback(ID_AudprocArkamysLevelLoss, "AudprocArkamysLevelLoss", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "AudprocArkamysLevelLoss", &cb, act);
    return act;
}

bool ServiceProxy::sendAudprocArkamysLevelLossDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("AudprocArkamysLevelLoss", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "AudprocArkamysLevelLoss", act, static_cast<int>(rv));
    return rv;
}

void ServiceProxy::sendAudprocArkamysLevelLossDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "AudprocArkamysLevelLoss");
    _dbusProxyDelegate->deregisterSignalCallback("AudprocArkamysLevelLoss", 0, _dbusDaemonProxy.get(), false);
}

act_t ServiceProxy::sendAplArkamysAvcActivateRegister(AplArkamysAvcActivateCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_aplArkamysAvcActivate, "aplArkamysAvcActivate", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "AplArkamysAvcActivate", &cb, act);
    return act;
}

bool ServiceProxy::sendAplArkamysAvcActivateDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("aplArkamysAvcActivate", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "AplArkamysAvcActivate", act, static_cast<int>(rv));
    return rv;
}

act_t ServiceProxy::sendAplArkamysAvcActivateGet(AplArkamysAvcActivateCallbackIF& cb) {
    ServiceProxyCallback* callback = new ServiceProxyCallback(ID_aplArkamysAvcActivate, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "AplArkamysAvcActivate", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("aplArkamysAvcActivate", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void ServiceProxy::sendAplArkamysAvcActivateSet(int32 aplArkamysAvcActivate) {
    AplArkamysAvcActivateSet parameter(aplArkamysAvcActivate);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet()", "AplArkamysAvcActivate");
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "aplArkamysAvcActivate", propertyContent);
}

act_t ServiceProxy::sendAplArkamysAvcActivateSet(AplArkamysAvcActivateCallbackIF& cb, int32 aplArkamysAvcActivate) {
    ServiceProxyCallback* callback = new ServiceProxyCallback(ID_aplArkamysAvcActivate, &cb);
    AplArkamysAvcActivateSet parameter(aplArkamysAvcActivate);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet(cb=%p), returning act=%" PRIuPTR, "AplArkamysAvcActivate", &cb, reinterpret_cast<act_t>(callback));
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "aplArkamysAvcActivate", propertyContent, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

int32 ServiceProxy::getAplArkamysAvcActivate() const {
    return _aplArkamysAvcActivate.get().getAplArkamysAvcActivate();
}

bool ServiceProxy::hasAplArkamysAvcActivate() const {
    return _aplArkamysAvcActivate.hasValue();
}

void ServiceProxy::sendAplArkamysAvcActivateDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "AplArkamysAvcActivate");
    _dbusProxyDelegate->deregisterSignalCallback("aplArkamysAvcActivate", 0, _dbusDaemonProxy.get(), true);
}

act_t ServiceProxy::sendAplArkamysByPassActivateRegister(AplArkamysByPassActivateCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_aplArkamysByPassActivate, "aplArkamysByPassActivate", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "AplArkamysByPassActivate", &cb, act);
    return act;
}

bool ServiceProxy::sendAplArkamysByPassActivateDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("aplArkamysByPassActivate", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "AplArkamysByPassActivate", act, static_cast<int>(rv));
    return rv;
}

act_t ServiceProxy::sendAplArkamysByPassActivateGet(AplArkamysByPassActivateCallbackIF& cb) {
    ServiceProxyCallback* callback = new ServiceProxyCallback(ID_aplArkamysByPassActivate, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "AplArkamysByPassActivate", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("aplArkamysByPassActivate", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void ServiceProxy::sendAplArkamysByPassActivateSet(int32 aplArkamysByPassActivate) {
    AplArkamysByPassActivateSet parameter(aplArkamysByPassActivate);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet()", "AplArkamysByPassActivate");
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "aplArkamysByPassActivate", propertyContent);
}

act_t ServiceProxy::sendAplArkamysByPassActivateSet(AplArkamysByPassActivateCallbackIF& cb, int32 aplArkamysByPassActivate) {
    ServiceProxyCallback* callback = new ServiceProxyCallback(ID_aplArkamysByPassActivate, &cb);
    AplArkamysByPassActivateSet parameter(aplArkamysByPassActivate);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet(cb=%p), returning act=%" PRIuPTR, "AplArkamysByPassActivate", &cb, reinterpret_cast<act_t>(callback));
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "aplArkamysByPassActivate", propertyContent, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

int32 ServiceProxy::getAplArkamysByPassActivate() const {
    return _aplArkamysByPassActivate.get().getAplArkamysByPassActivate();
}

bool ServiceProxy::hasAplArkamysByPassActivate() const {
    return _aplArkamysByPassActivate.hasValue();
}

void ServiceProxy::sendAplArkamysByPassActivateDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "AplArkamysByPassActivate");
    _dbusProxyDelegate->deregisterSignalCallback("aplArkamysByPassActivate", 0, _dbusDaemonProxy.get(), true);
}

act_t ServiceProxy::sendAplArkamysInputLevelDeviationRegister(AplArkamysInputLevelDeviationCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_aplArkamysInputLevelDeviation, "aplArkamysInputLevelDeviation", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "AplArkamysInputLevelDeviation", &cb, act);
    return act;
}

bool ServiceProxy::sendAplArkamysInputLevelDeviationDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("aplArkamysInputLevelDeviation", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "AplArkamysInputLevelDeviation", act, static_cast<int>(rv));
    return rv;
}

act_t ServiceProxy::sendAplArkamysInputLevelDeviationGet(AplArkamysInputLevelDeviationCallbackIF& cb) {
    ServiceProxyCallback* callback = new ServiceProxyCallback(ID_aplArkamysInputLevelDeviation, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "AplArkamysInputLevelDeviation", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("aplArkamysInputLevelDeviation", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void ServiceProxy::sendAplArkamysInputLevelDeviationSet(int32 aplArkamysInputLevelDeviation) {
    AplArkamysInputLevelDeviationSet parameter(aplArkamysInputLevelDeviation);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet()", "AplArkamysInputLevelDeviation");
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "aplArkamysInputLevelDeviation", propertyContent);
}

act_t ServiceProxy::sendAplArkamysInputLevelDeviationSet(AplArkamysInputLevelDeviationCallbackIF& cb, int32 aplArkamysInputLevelDeviation) {
    ServiceProxyCallback* callback = new ServiceProxyCallback(ID_aplArkamysInputLevelDeviation, &cb);
    AplArkamysInputLevelDeviationSet parameter(aplArkamysInputLevelDeviation);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet(cb=%p), returning act=%" PRIuPTR, "AplArkamysInputLevelDeviation", &cb, reinterpret_cast<act_t>(callback));
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "aplArkamysInputLevelDeviation", propertyContent, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

int32 ServiceProxy::getAplArkamysInputLevelDeviation() const {
    return _aplArkamysInputLevelDeviation.get().getAplArkamysInputLevelDeviation();
}

bool ServiceProxy::hasAplArkamysInputLevelDeviation() const {
    return _aplArkamysInputLevelDeviation.hasValue();
}

void ServiceProxy::sendAplArkamysInputLevelDeviationDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "AplArkamysInputLevelDeviation");
    _dbusProxyDelegate->deregisterSignalCallback("aplArkamysInputLevelDeviation", 0, _dbusDaemonProxy.get(), true);
}

act_t ServiceProxy::sendAplArkamysCurrentSpeedRegister(AplArkamysCurrentSpeedCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_aplArkamysCurrentSpeed, "aplArkamysCurrentSpeed", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "AplArkamysCurrentSpeed", &cb, act);
    return act;
}

bool ServiceProxy::sendAplArkamysCurrentSpeedDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("aplArkamysCurrentSpeed", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "AplArkamysCurrentSpeed", act, static_cast<int>(rv));
    return rv;
}

act_t ServiceProxy::sendAplArkamysCurrentSpeedGet(AplArkamysCurrentSpeedCallbackIF& cb) {
    ServiceProxyCallback* callback = new ServiceProxyCallback(ID_aplArkamysCurrentSpeed, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "AplArkamysCurrentSpeed", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("aplArkamysCurrentSpeed", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void ServiceProxy::sendAplArkamysCurrentSpeedSet(int32 aplArkamysCurrentSpeed) {
    AplArkamysCurrentSpeedSet parameter(aplArkamysCurrentSpeed);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet()", "AplArkamysCurrentSpeed");
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "aplArkamysCurrentSpeed", propertyContent);
}

act_t ServiceProxy::sendAplArkamysCurrentSpeedSet(AplArkamysCurrentSpeedCallbackIF& cb, int32 aplArkamysCurrentSpeed) {
    ServiceProxyCallback* callback = new ServiceProxyCallback(ID_aplArkamysCurrentSpeed, &cb);
    AplArkamysCurrentSpeedSet parameter(aplArkamysCurrentSpeed);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet(cb=%p), returning act=%" PRIuPTR, "AplArkamysCurrentSpeed", &cb, reinterpret_cast<act_t>(callback));
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "aplArkamysCurrentSpeed", propertyContent, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

int32 ServiceProxy::getAplArkamysCurrentSpeed() const {
    return _aplArkamysCurrentSpeed.get().getAplArkamysCurrentSpeed();
}

bool ServiceProxy::hasAplArkamysCurrentSpeed() const {
    return _aplArkamysCurrentSpeed.hasValue();
}

void ServiceProxy::sendAplArkamysCurrentSpeedDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "AplArkamysCurrentSpeed");
    _dbusProxyDelegate->deregisterSignalCallback("aplArkamysCurrentSpeed", 0, _dbusDaemonProxy.get(), true);
}

act_t ServiceProxy::sendAplArkamysCurrentVolumeStepRegister(AplArkamysCurrentVolumeStepCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_aplArkamysCurrentVolumeStep, "aplArkamysCurrentVolumeStep", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "AplArkamysCurrentVolumeStep", &cb, act);
    return act;
}

bool ServiceProxy::sendAplArkamysCurrentVolumeStepDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("aplArkamysCurrentVolumeStep", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "AplArkamysCurrentVolumeStep", act, static_cast<int>(rv));
    return rv;
}

act_t ServiceProxy::sendAplArkamysCurrentVolumeStepGet(AplArkamysCurrentVolumeStepCallbackIF& cb) {
    ServiceProxyCallback* callback = new ServiceProxyCallback(ID_aplArkamysCurrentVolumeStep, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "AplArkamysCurrentVolumeStep", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("aplArkamysCurrentVolumeStep", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void ServiceProxy::sendAplArkamysCurrentVolumeStepSet(int32 aplArkamysCurrentVolumeStep) {
    AplArkamysCurrentVolumeStepSet parameter(aplArkamysCurrentVolumeStep);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet()", "AplArkamysCurrentVolumeStep");
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "aplArkamysCurrentVolumeStep", propertyContent);
}

act_t ServiceProxy::sendAplArkamysCurrentVolumeStepSet(AplArkamysCurrentVolumeStepCallbackIF& cb, int32 aplArkamysCurrentVolumeStep) {
    ServiceProxyCallback* callback = new ServiceProxyCallback(ID_aplArkamysCurrentVolumeStep, &cb);
    AplArkamysCurrentVolumeStepSet parameter(aplArkamysCurrentVolumeStep);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet(cb=%p), returning act=%" PRIuPTR, "AplArkamysCurrentVolumeStep", &cb, reinterpret_cast<act_t>(callback));
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "aplArkamysCurrentVolumeStep", propertyContent, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

int32 ServiceProxy::getAplArkamysCurrentVolumeStep() const {
    return _aplArkamysCurrentVolumeStep.get().getAplArkamysCurrentVolumeStep();
}

bool ServiceProxy::hasAplArkamysCurrentVolumeStep() const {
    return _aplArkamysCurrentVolumeStep.hasValue();
}

void ServiceProxy::sendAplArkamysCurrentVolumeStepDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "AplArkamysCurrentVolumeStep");
    _dbusProxyDelegate->deregisterSignalCallback("aplArkamysCurrentVolumeStep", 0, _dbusDaemonProxy.get(), true);
}

act_t ServiceProxy::sendAplArkamysAmbienceSelectRegister(AplArkamysAmbienceSelectCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_aplArkamysAmbienceSelect, "aplArkamysAmbienceSelect", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "AplArkamysAmbienceSelect", &cb, act);
    return act;
}

bool ServiceProxy::sendAplArkamysAmbienceSelectDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("aplArkamysAmbienceSelect", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "AplArkamysAmbienceSelect", act, static_cast<int>(rv));
    return rv;
}

act_t ServiceProxy::sendAplArkamysAmbienceSelectGet(AplArkamysAmbienceSelectCallbackIF& cb) {
    ServiceProxyCallback* callback = new ServiceProxyCallback(ID_aplArkamysAmbienceSelect, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "AplArkamysAmbienceSelect", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("aplArkamysAmbienceSelect", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void ServiceProxy::sendAplArkamysAmbienceSelectSet(int32 aplArkamysAmbienceSelect) {
    AplArkamysAmbienceSelectSet parameter(aplArkamysAmbienceSelect);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet()", "AplArkamysAmbienceSelect");
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "aplArkamysAmbienceSelect", propertyContent);
}

act_t ServiceProxy::sendAplArkamysAmbienceSelectSet(AplArkamysAmbienceSelectCallbackIF& cb, int32 aplArkamysAmbienceSelect) {
    ServiceProxyCallback* callback = new ServiceProxyCallback(ID_aplArkamysAmbienceSelect, &cb);
    AplArkamysAmbienceSelectSet parameter(aplArkamysAmbienceSelect);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet(cb=%p), returning act=%" PRIuPTR, "AplArkamysAmbienceSelect", &cb, reinterpret_cast<act_t>(callback));
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "aplArkamysAmbienceSelect", propertyContent, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

int32 ServiceProxy::getAplArkamysAmbienceSelect() const {
    return _aplArkamysAmbienceSelect.get().getAplArkamysAmbienceSelect();
}

bool ServiceProxy::hasAplArkamysAmbienceSelect() const {
    return _aplArkamysAmbienceSelect.hasValue();
}

void ServiceProxy::sendAplArkamysAmbienceSelectDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "AplArkamysAmbienceSelect");
    _dbusProxyDelegate->deregisterSignalCallback("aplArkamysAmbienceSelect", 0, _dbusDaemonProxy.get(), true);
}

act_t ServiceProxy::sendAplArkamysLevelLossRegister(AplArkamysLevelLossCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_aplArkamysLevelLoss, "aplArkamysLevelLoss", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "AplArkamysLevelLoss", &cb, act);
    return act;
}

bool ServiceProxy::sendAplArkamysLevelLossDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("aplArkamysLevelLoss", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "AplArkamysLevelLoss", act, static_cast<int>(rv));
    return rv;
}

act_t ServiceProxy::sendAplArkamysLevelLossGet(AplArkamysLevelLossCallbackIF& cb) {
    ServiceProxyCallback* callback = new ServiceProxyCallback(ID_aplArkamysLevelLoss, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "AplArkamysLevelLoss", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("aplArkamysLevelLoss", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void ServiceProxy::sendAplArkamysLevelLossSet(int32 aplArkamysLevelLoss) {
    AplArkamysLevelLossSet parameter(aplArkamysLevelLoss);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet()", "AplArkamysLevelLoss");
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "aplArkamysLevelLoss", propertyContent);
}

act_t ServiceProxy::sendAplArkamysLevelLossSet(AplArkamysLevelLossCallbackIF& cb, int32 aplArkamysLevelLoss) {
    ServiceProxyCallback* callback = new ServiceProxyCallback(ID_aplArkamysLevelLoss, &cb);
    AplArkamysLevelLossSet parameter(aplArkamysLevelLoss);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet(cb=%p), returning act=%" PRIuPTR, "AplArkamysLevelLoss", &cb, reinterpret_cast<act_t>(callback));
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "aplArkamysLevelLoss", propertyContent, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

int32 ServiceProxy::getAplArkamysLevelLoss() const {
    return _aplArkamysLevelLoss.get().getAplArkamysLevelLoss();
}

bool ServiceProxy::hasAplArkamysLevelLoss() const {
    return _aplArkamysLevelLoss.hasValue();
}

void ServiceProxy::sendAplArkamysLevelLossDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "AplArkamysLevelLoss");
    _dbusProxyDelegate->deregisterSignalCallback("aplArkamysLevelLoss", 0, _dbusDaemonProxy.get(), true);
}

act_t ServiceProxy::sendAplArkamysLibraryVersionRegister(AplArkamysLibraryVersionCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_aplArkamysLibraryVersion, "aplArkamysLibraryVersion", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "AplArkamysLibraryVersion", &cb, act);
    return act;
}

bool ServiceProxy::sendAplArkamysLibraryVersionDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("aplArkamysLibraryVersion", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "AplArkamysLibraryVersion", act, static_cast<int>(rv));
    return rv;
}

act_t ServiceProxy::sendAplArkamysLibraryVersionGet(AplArkamysLibraryVersionCallbackIF& cb) {
    ServiceProxyCallback* callback = new ServiceProxyCallback(ID_aplArkamysLibraryVersion, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "AplArkamysLibraryVersion", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("aplArkamysLibraryVersion", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void ServiceProxy::sendAplArkamysLibraryVersionSet(const ::std::vector< int32 >& aplArkamysLibraryVersion) {
    AplArkamysLibraryVersionSet parameter(aplArkamysLibraryVersion);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet()", "AplArkamysLibraryVersion");
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "aplArkamysLibraryVersion", propertyContent);
}

act_t ServiceProxy::sendAplArkamysLibraryVersionSet(AplArkamysLibraryVersionCallbackIF& cb, const ::std::vector< int32 >& aplArkamysLibraryVersion) {
    ServiceProxyCallback* callback = new ServiceProxyCallback(ID_aplArkamysLibraryVersion, &cb);
    AplArkamysLibraryVersionSet parameter(aplArkamysLibraryVersion);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet(cb=%p), returning act=%" PRIuPTR, "AplArkamysLibraryVersion", &cb, reinterpret_cast<act_t>(callback));
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "aplArkamysLibraryVersion", propertyContent, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

const ::std::vector< int32 >& ServiceProxy::getAplArkamysLibraryVersion() const {
    return _aplArkamysLibraryVersion.get().getAplArkamysLibraryVersion();
}

bool ServiceProxy::hasAplArkamysLibraryVersion() const {
    return _aplArkamysLibraryVersion.hasValue();
}

void ServiceProxy::sendAplArkamysLibraryVersionDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "AplArkamysLibraryVersion");
    _dbusProxyDelegate->deregisterSignalCallback("aplArkamysLibraryVersion", 0, _dbusDaemonProxy.get(), true);
}

act_t ServiceProxy::sendAplArkamysCurrVolAttenuationRegister(AplArkamysCurrVolAttenuationCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_aplArkamysCurrVolAttenuation, "aplArkamysCurrVolAttenuation", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "AplArkamysCurrVolAttenuation", &cb, act);
    return act;
}

bool ServiceProxy::sendAplArkamysCurrVolAttenuationDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("aplArkamysCurrVolAttenuation", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "AplArkamysCurrVolAttenuation", act, static_cast<int>(rv));
    return rv;
}

act_t ServiceProxy::sendAplArkamysCurrVolAttenuationGet(AplArkamysCurrVolAttenuationCallbackIF& cb) {
    ServiceProxyCallback* callback = new ServiceProxyCallback(ID_aplArkamysCurrVolAttenuation, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "AplArkamysCurrVolAttenuation", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("aplArkamysCurrVolAttenuation", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void ServiceProxy::sendAplArkamysCurrVolAttenuationSet(int32 aplArkamysCurrVolAttenuation) {
    AplArkamysCurrVolAttenuationSet parameter(aplArkamysCurrVolAttenuation);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet()", "AplArkamysCurrVolAttenuation");
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "aplArkamysCurrVolAttenuation", propertyContent);
}

act_t ServiceProxy::sendAplArkamysCurrVolAttenuationSet(AplArkamysCurrVolAttenuationCallbackIF& cb, int32 aplArkamysCurrVolAttenuation) {
    ServiceProxyCallback* callback = new ServiceProxyCallback(ID_aplArkamysCurrVolAttenuation, &cb);
    AplArkamysCurrVolAttenuationSet parameter(aplArkamysCurrVolAttenuation);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet(cb=%p), returning act=%" PRIuPTR, "AplArkamysCurrVolAttenuation", &cb, reinterpret_cast<act_t>(callback));
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "aplArkamysCurrVolAttenuation", propertyContent, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

int32 ServiceProxy::getAplArkamysCurrVolAttenuation() const {
    return _aplArkamysCurrVolAttenuation.get().getAplArkamysCurrVolAttenuation();
}

bool ServiceProxy::hasAplArkamysCurrVolAttenuation() const {
    return _aplArkamysCurrVolAttenuation.hasValue();
}

void ServiceProxy::sendAplArkamysCurrVolAttenuationDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "AplArkamysCurrVolAttenuation");
    _dbusProxyDelegate->deregisterSignalCallback("aplArkamysCurrVolAttenuation", 0, _dbusDaemonProxy.get(), true);
}

act_t ServiceProxy::sendAplArkamysFlushRegister(AplArkamysFlushCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_aplArkamysFlush, "aplArkamysFlush", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "AplArkamysFlush", &cb, act);
    return act;
}

bool ServiceProxy::sendAplArkamysFlushDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("aplArkamysFlush", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "AplArkamysFlush", act, static_cast<int>(rv));
    return rv;
}

act_t ServiceProxy::sendAplArkamysFlushGet(AplArkamysFlushCallbackIF& cb) {
    ServiceProxyCallback* callback = new ServiceProxyCallback(ID_aplArkamysFlush, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "AplArkamysFlush", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("aplArkamysFlush", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void ServiceProxy::sendAplArkamysFlushSet(int32 aplArkamysFlush) {
    AplArkamysFlushSet parameter(aplArkamysFlush);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet()", "AplArkamysFlush");
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "aplArkamysFlush", propertyContent);
}

act_t ServiceProxy::sendAplArkamysFlushSet(AplArkamysFlushCallbackIF& cb, int32 aplArkamysFlush) {
    ServiceProxyCallback* callback = new ServiceProxyCallback(ID_aplArkamysFlush, &cb);
    AplArkamysFlushSet parameter(aplArkamysFlush);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet(cb=%p), returning act=%" PRIuPTR, "AplArkamysFlush", &cb, reinterpret_cast<act_t>(callback));
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "aplArkamysFlush", propertyContent, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

int32 ServiceProxy::getAplArkamysFlush() const {
    return _aplArkamysFlush.get().getAplArkamysFlush();
}

bool ServiceProxy::hasAplArkamysFlush() const {
    return _aplArkamysFlush.hasValue();
}

void ServiceProxy::sendAplArkamysFlushDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "AplArkamysFlush");
    _dbusProxyDelegate->deregisterSignalCallback("aplArkamysFlush", 0, _dbusDaemonProxy.get(), true);
}

act_t ServiceProxy::sendAplMicLvlWatchRefIntRegister(AplMicLvlWatchRefIntCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_aplMicLvlWatchRefInt, "aplMicLvlWatchRefInt", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "AplMicLvlWatchRefInt", &cb, act);
    return act;
}

bool ServiceProxy::sendAplMicLvlWatchRefIntDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("aplMicLvlWatchRefInt", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "AplMicLvlWatchRefInt", act, static_cast<int>(rv));
    return rv;
}

act_t ServiceProxy::sendAplMicLvlWatchRefIntGet(AplMicLvlWatchRefIntCallbackIF& cb) {
    ServiceProxyCallback* callback = new ServiceProxyCallback(ID_aplMicLvlWatchRefInt, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "AplMicLvlWatchRefInt", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("aplMicLvlWatchRefInt", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void ServiceProxy::sendAplMicLvlWatchRefIntSet(uint32 aplMicLvlWatchRefInt) {
    AplMicLvlWatchRefIntSet parameter(aplMicLvlWatchRefInt);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet()", "AplMicLvlWatchRefInt");
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "aplMicLvlWatchRefInt", propertyContent);
}

act_t ServiceProxy::sendAplMicLvlWatchRefIntSet(AplMicLvlWatchRefIntCallbackIF& cb, uint32 aplMicLvlWatchRefInt) {
    ServiceProxyCallback* callback = new ServiceProxyCallback(ID_aplMicLvlWatchRefInt, &cb);
    AplMicLvlWatchRefIntSet parameter(aplMicLvlWatchRefInt);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet(cb=%p), returning act=%" PRIuPTR, "AplMicLvlWatchRefInt", &cb, reinterpret_cast<act_t>(callback));
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "aplMicLvlWatchRefInt", propertyContent, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

uint32 ServiceProxy::getAplMicLvlWatchRefInt() const {
    return _aplMicLvlWatchRefInt.get().getAplMicLvlWatchRefInt();
}

bool ServiceProxy::hasAplMicLvlWatchRefInt() const {
    return _aplMicLvlWatchRefInt.hasValue();
}

void ServiceProxy::sendAplMicLvlWatchRefIntDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "AplMicLvlWatchRefInt");
    _dbusProxyDelegate->deregisterSignalCallback("aplMicLvlWatchRefInt", 0, _dbusDaemonProxy.get(), true);
}

act_t ServiceProxy::sendAplMicLvlRegister(AplMicLvlCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_aplMicLvl, "aplMicLvl", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "AplMicLvl", &cb, act);
    return act;
}

bool ServiceProxy::sendAplMicLvlDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("aplMicLvl", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "AplMicLvl", act, static_cast<int>(rv));
    return rv;
}

act_t ServiceProxy::sendAplMicLvlGet(AplMicLvlCallbackIF& cb) {
    ServiceProxyCallback* callback = new ServiceProxyCallback(ID_aplMicLvl, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "AplMicLvl", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("aplMicLvl", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void ServiceProxy::sendAplMicLvlSet(int32 aplMicLvl) {
    AplMicLvlSet parameter(aplMicLvl);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet()", "AplMicLvl");
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "aplMicLvl", propertyContent);
}

act_t ServiceProxy::sendAplMicLvlSet(AplMicLvlCallbackIF& cb, int32 aplMicLvl) {
    ServiceProxyCallback* callback = new ServiceProxyCallback(ID_aplMicLvl, &cb);
    AplMicLvlSet parameter(aplMicLvl);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet(cb=%p), returning act=%" PRIuPTR, "AplMicLvl", &cb, reinterpret_cast<act_t>(callback));
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "aplMicLvl", propertyContent, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

int32 ServiceProxy::getAplMicLvl() const {
    return _aplMicLvl.get().getAplMicLvl();
}

bool ServiceProxy::hasAplMicLvl() const {
    return _aplMicLvl.hasValue();
}

void ServiceProxy::sendAplMicLvlDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "AplMicLvl");
    _dbusProxyDelegate->deregisterSignalCallback("aplMicLvl", 0, _dbusDaemonProxy.get(), true);
}

act_t ServiceProxy::sendAplAudioModeRegister(AplAudioModeCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_aplAudioMode, "aplAudioMode", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "AplAudioMode", &cb, act);
    return act;
}

bool ServiceProxy::sendAplAudioModeDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("aplAudioMode", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "AplAudioMode", act, static_cast<int>(rv));
    return rv;
}

act_t ServiceProxy::sendAplAudioModeGet(AplAudioModeCallbackIF& cb) {
    ServiceProxyCallback* callback = new ServiceProxyCallback(ID_aplAudioMode, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "AplAudioMode", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("aplAudioMode", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void ServiceProxy::sendAplAudioModeSet(int32 aplAudioMode) {
    AplAudioModeSet parameter(aplAudioMode);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet()", "AplAudioMode");
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "aplAudioMode", propertyContent);
}

act_t ServiceProxy::sendAplAudioModeSet(AplAudioModeCallbackIF& cb, int32 aplAudioMode) {
    ServiceProxyCallback* callback = new ServiceProxyCallback(ID_aplAudioMode, &cb);
    AplAudioModeSet parameter(aplAudioMode);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet(cb=%p), returning act=%" PRIuPTR, "AplAudioMode", &cb, reinterpret_cast<act_t>(callback));
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "aplAudioMode", propertyContent, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

int32 ServiceProxy::getAplAudioMode() const {
    return _aplAudioMode.get().getAplAudioMode();
}

bool ServiceProxy::hasAplAudioMode() const {
    return _aplAudioMode.hasValue();
}

void ServiceProxy::sendAplAudioModeDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "AplAudioMode");
    _dbusProxyDelegate->deregisterSignalCallback("aplAudioMode", 0, _dbusDaemonProxy.get(), true);
}

act_t ServiceProxy::sendAplLoopbackActivateRegister(AplLoopbackActivateCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_aplLoopbackActivate, "aplLoopbackActivate", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "AplLoopbackActivate", &cb, act);
    return act;
}

bool ServiceProxy::sendAplLoopbackActivateDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("aplLoopbackActivate", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "AplLoopbackActivate", act, static_cast<int>(rv));
    return rv;
}

act_t ServiceProxy::sendAplLoopbackActivateGet(AplLoopbackActivateCallbackIF& cb) {
    ServiceProxyCallback* callback = new ServiceProxyCallback(ID_aplLoopbackActivate, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "AplLoopbackActivate", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("aplLoopbackActivate", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void ServiceProxy::sendAplLoopbackActivateSet(int32 aplLoopbackActivate) {
    AplLoopbackActivateSet parameter(aplLoopbackActivate);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet()", "AplLoopbackActivate");
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "aplLoopbackActivate", propertyContent);
}

act_t ServiceProxy::sendAplLoopbackActivateSet(AplLoopbackActivateCallbackIF& cb, int32 aplLoopbackActivate) {
    ServiceProxyCallback* callback = new ServiceProxyCallback(ID_aplLoopbackActivate, &cb);
    AplLoopbackActivateSet parameter(aplLoopbackActivate);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet(cb=%p), returning act=%" PRIuPTR, "AplLoopbackActivate", &cb, reinterpret_cast<act_t>(callback));
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "aplLoopbackActivate", propertyContent, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

int32 ServiceProxy::getAplLoopbackActivate() const {
    return _aplLoopbackActivate.get().getAplLoopbackActivate();
}

bool ServiceProxy::hasAplLoopbackActivate() const {
    return _aplLoopbackActivate.hasValue();
}

void ServiceProxy::sendAplLoopbackActivateDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "AplLoopbackActivate");
    _dbusProxyDelegate->deregisterSignalCallback("aplLoopbackActivate", 0, _dbusDaemonProxy.get(), true);
}

act_t ServiceProxy::sendAudprocGetVersionRequest(AudprocGetVersionCallbackIF& cb) const {
    AudprocGetVersionRequest* payload = new AudprocGetVersionRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "AudprocGetVersion", AudprocGetVersionRequest, payload, true)
    act_t act = addMethodCallback(ID_AudprocGetVersion, dbusMessage.getUniqueSerial(), "AudprocGetVersion", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "AudprocGetVersion", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t ServiceProxy::sendAudprocGetStatusRequest(AudprocGetStatusCallbackIF& cb) const {
    AudprocGetStatusRequest* payload = new AudprocGetStatusRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "AudprocGetStatus", AudprocGetStatusRequest, payload, true)
    act_t act = addMethodCallback(ID_AudprocGetStatus, dbusMessage.getUniqueSerial(), "AudprocGetStatus", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "AudprocGetStatus", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t ServiceProxy::sendAudprocTerminateRequest(AudprocTerminateCallbackIF& cb) const {
    AudprocTerminateRequest* payload = new AudprocTerminateRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "AudprocTerminate", AudprocTerminateRequest, payload, true)
    act_t act = addMethodCallback(ID_AudprocTerminate, dbusMessage.getUniqueSerial(), "AudprocTerminate", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "AudprocTerminate", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t ServiceProxy::sendAudprocSetupDebugRequest(AudprocSetupDebugCallbackIF& cb, uint8 audprocSelectMode) const {
    AudprocSetupDebugRequest* payload = new AudprocSetupDebugRequest();
    CHECK_ALLOCATION(payload);
    payload->setAudprocSelectMode(audprocSelectMode);
    DBUS_MESSAGE_CALL(dbusMessage, "AudprocSetupDebug", AudprocSetupDebugRequest, payload, true)
    act_t act = addMethodCallback(ID_AudprocSetupDebug, dbusMessage.getUniqueSerial(), "AudprocSetupDebug", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "AudprocSetupDebug", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t ServiceProxy::sendAudprocCreateRequest(AudprocCreateCallbackIF& cb) const {
    AudprocCreateRequest* payload = new AudprocCreateRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "AudprocCreate", AudprocCreateRequest, payload, true)
    act_t act = addMethodCallback(ID_AudprocCreate, dbusMessage.getUniqueSerial(), "AudprocCreate", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "AudprocCreate", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t ServiceProxy::sendAudprocInitializeRequest(AudprocInitializeCallbackIF& cb, uint8 audprocSourceId, const ::std::string& audprocConfigurationFile) const {
    AudprocInitializeRequest* payload = new AudprocInitializeRequest();
    CHECK_ALLOCATION(payload);
    payload->setAudprocSourceId(audprocSourceId);
    payload->setAudprocConfigurationFile(audprocConfigurationFile);
    DBUS_MESSAGE_CALL(dbusMessage, "AudprocInitialize", AudprocInitializeRequest, payload, true)
    act_t act = addMethodCallback(ID_AudprocInitialize, dbusMessage.getUniqueSerial(), "AudprocInitialize", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "AudprocInitialize", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t ServiceProxy::sendAudprocSetConfigurationRequest(AudprocSetConfigurationCallbackIF& cb, uint8 audprocSourceId, const ::std::string& audprocConfigurationFile) const {
    AudprocSetConfigurationRequest* payload = new AudprocSetConfigurationRequest();
    CHECK_ALLOCATION(payload);
    payload->setAudprocSourceId(audprocSourceId);
    payload->setAudprocConfigurationFile(audprocConfigurationFile);
    DBUS_MESSAGE_CALL(dbusMessage, "AudprocSetConfiguration", AudprocSetConfigurationRequest, payload, true)
    act_t act = addMethodCallback(ID_AudprocSetConfiguration, dbusMessage.getUniqueSerial(), "AudprocSetConfiguration", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "AudprocSetConfiguration", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t ServiceProxy::sendAudprocDestroyRequest(AudprocDestroyCallbackIF& cb, uint8 audprocSourceId) const {
    AudprocDestroyRequest* payload = new AudprocDestroyRequest();
    CHECK_ALLOCATION(payload);
    payload->setAudprocSourceId(audprocSourceId);
    DBUS_MESSAGE_CALL(dbusMessage, "AudprocDestroy", AudprocDestroyRequest, payload, true)
    act_t act = addMethodCallback(ID_AudprocDestroy, dbusMessage.getUniqueSerial(), "AudprocDestroy", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "AudprocDestroy", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t ServiceProxy::sendAudprocSetParamRequest(AudprocSetParamCallbackIF& cb, uint8 audprocSourceId, uint32 parameterId, uint8 paramType, uint32 uParameter, int32 sParameter) const {
    AudprocSetParamRequest* payload = new AudprocSetParamRequest();
    CHECK_ALLOCATION(payload);
    payload->setAudprocSourceId(audprocSourceId);
    payload->setParameterId(parameterId);
    payload->setParamType(paramType);
    payload->setUParameter(uParameter);
    payload->setSParameter(sParameter);
    DBUS_MESSAGE_CALL(dbusMessage, "AudprocSetParam", AudprocSetParamRequest, payload, true)
    act_t act = addMethodCallback(ID_AudprocSetParam, dbusMessage.getUniqueSerial(), "AudprocSetParam", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "AudprocSetParam", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t ServiceProxy::sendAudprocWriteDataRequest(AudprocWriteDataCallbackIF& cb, uint8 audprocSourceId, uint32 parameterId, const ::std::vector< uint8 >& data) const {
    AudprocWriteDataRequest* payload = new AudprocWriteDataRequest();
    CHECK_ALLOCATION(payload);
    payload->setAudprocSourceId(audprocSourceId);
    payload->setParameterId(parameterId);
    payload->setData(data);
    DBUS_MESSAGE_CALL(dbusMessage, "AudprocWriteData", AudprocWriteDataRequest, payload, true)
    act_t act = addMethodCallback(ID_AudprocWriteData, dbusMessage.getUniqueSerial(), "AudprocWriteData", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "AudprocWriteData", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t ServiceProxy::sendAudprocReadDataRequest(AudprocReadDataCallbackIF& cb, uint8 audprocSourceId, uint32 parameterId, const ::std::vector< uint8 >& readInfos) const {
    AudprocReadDataRequest* payload = new AudprocReadDataRequest();
    CHECK_ALLOCATION(payload);
    payload->setAudprocSourceId(audprocSourceId);
    payload->setParameterId(parameterId);
    payload->setReadInfos(readInfos);
    DBUS_MESSAGE_CALL(dbusMessage, "AudprocReadData", AudprocReadDataRequest, payload, true)
    act_t act = addMethodCallback(ID_AudprocReadData, dbusMessage.getUniqueSerial(), "AudprocReadData", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "AudprocReadData", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t ServiceProxy::sendAudprocGetAudprocConfigurationRequest(AudprocGetAudprocConfigurationCallbackIF& cb) const {
    AudprocGetAudprocConfigurationRequest* payload = new AudprocGetAudprocConfigurationRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "AudprocGetAudprocConfiguration", AudprocGetAudprocConfigurationRequest, payload, true)
    act_t act = addMethodCallback(ID_AudprocGetAudprocConfiguration, dbusMessage.getUniqueSerial(), "AudprocGetAudprocConfiguration", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "AudprocGetAudprocConfiguration", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t ServiceProxy::sendAudprocStartAudioRequest(AudprocStartAudioCallbackIF& cb, uint8 audprocSourceId) const {
    AudprocStartAudioRequest* payload = new AudprocStartAudioRequest();
    CHECK_ALLOCATION(payload);
    payload->setAudprocSourceId(audprocSourceId);
    DBUS_MESSAGE_CALL(dbusMessage, "AudprocStartAudio", AudprocStartAudioRequest, payload, true)
    act_t act = addMethodCallback(ID_AudprocStartAudio, dbusMessage.getUniqueSerial(), "AudprocStartAudio", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "AudprocStartAudio", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t ServiceProxy::sendAudprocStopAudioRequest(AudprocStopAudioCallbackIF& cb, uint8 audprocSourceId) const {
    AudprocStopAudioRequest* payload = new AudprocStopAudioRequest();
    CHECK_ALLOCATION(payload);
    payload->setAudprocSourceId(audprocSourceId);
    DBUS_MESSAGE_CALL(dbusMessage, "AudprocStopAudio", AudprocStopAudioRequest, payload, true)
    act_t act = addMethodCallback(ID_AudprocStopAudio, dbusMessage.getUniqueSerial(), "AudprocStopAudio", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "AudprocStopAudio", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t ServiceProxy::sendAudprocMuteRequest(AudprocMuteCallbackIF& cb) const {
    AudprocMuteRequest* payload = new AudprocMuteRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "AudprocMute", AudprocMuteRequest, payload, true)
    act_t act = addMethodCallback(ID_AudprocMute, dbusMessage.getUniqueSerial(), "AudprocMute", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "AudprocMute", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t ServiceProxy::sendAudprocSourceActivityRequest(AudprocSourceActivityCallbackIF& cb, uint8 audprocSourceMapId, uint8 audprocSourceActivity) const {
    AudprocSourceActivityRequest* payload = new AudprocSourceActivityRequest();
    CHECK_ALLOCATION(payload);
    payload->setAudprocSourceMapId(audprocSourceMapId);
    payload->setAudprocSourceActivity(audprocSourceActivity);
    DBUS_MESSAGE_CALL(dbusMessage, "AudprocSourceActivity", AudprocSourceActivityRequest, payload, true)
    act_t act = addMethodCallback(ID_AudprocSourceActivity, dbusMessage.getUniqueSerial(), "AudprocSourceActivity", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "AudprocSourceActivity", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t ServiceProxy::sendAudprocSourceSelectRequest(AudprocSourceSelectCallbackIF& cb, uint8 audprocSourceSelectMode, uint8 audprocSourceId, const ::std::string& audprocAlsaDev) const {
    AudprocSourceSelectRequest* payload = new AudprocSourceSelectRequest();
    CHECK_ALLOCATION(payload);
    payload->setAudprocSourceSelectMode(audprocSourceSelectMode);
    payload->setAudprocSourceId(audprocSourceId);
    payload->setAudprocAlsaDev(audprocAlsaDev);
    DBUS_MESSAGE_CALL(dbusMessage, "AudprocSourceSelect", AudprocSourceSelectRequest, payload, true)
    act_t act = addMethodCallback(ID_AudprocSourceSelect, dbusMessage.getUniqueSerial(), "AudprocSourceSelect", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "AudprocSourceSelect", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

} // namespace service
} // namespace audproc
} // namespace bosch
} // namespace org
