/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/Types.h"
#include "asf/dbus/DBusAssert.h"
#include "org/bosch/audproc/service.h"
#include <dbus/dbus.h>
#include <string>
#include <vector>

static ::asf::core::Logger& _logger =  ::asf::core::Logger::_systemLogger;


// D-Bus serialize and deserialize functions of AudprocGetVersionResponse

void serializeDBus (const ::org::bosch::audproc::service::AudprocGetVersionResponse& in, DBusMessageIter* out) {
    DBusMessageIter o0ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "u", &o0ArrayIter));
    const ::std::vector< uint32 >* o1 = &in.getVersion();
    ::std::vector< uint32 >::const_iterator o2 = o1->end();
    for (::std::vector< uint32 >::const_iterator o3 = o1->begin(); o3 != o2; ++o3) {
        DBUS_ASSERT(dbus_message_iter_append_basic(&o0ArrayIter, DBUS_TYPE_UINT32, &(*o3)));
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o0ArrayIter));
    const char* o4 = in.getVersionString().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o4));
    const char* o5 = in.getVersionComment().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o5));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::audproc::service::AudprocGetVersionResponse& out) {
    {
        ::std::vector< uint32 > VersionValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o6ArrayIter;
            dbus_message_iter_recurse (in, &o6ArrayIter);

            if(dbus_message_iter_get_arg_type(&o6ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    uint32 o7;
                    dbus_message_iter_get_basic(&o6ArrayIter, &o7);
                    VersionValue.push_back(o7);
                } while (dbus_message_iter_next(&o6ArrayIter));
            }
        }
        out.setVersion(VersionValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::std::string VersionStringValue;
        ::std::string &VersionStringTmpValue = VersionStringValue;
        {
            char* o8 = 0;
            dbus_message_iter_get_basic(in, &o8);
            VersionStringTmpValue.assign (o8);
        }
        out.setVersionString(VersionStringValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::std::string VersionCommentValue;
        ::std::string &VersionCommentTmpValue = VersionCommentValue;
        {
            char* o9 = 0;
            dbus_message_iter_get_basic(in, &o9);
            VersionCommentTmpValue.assign (o9);
        }
        out.setVersionComment(VersionCommentValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of AudprocSetupDebugRequest

void serializeDBus (const ::org::bosch::audproc::service::AudprocSetupDebugRequest& in, DBusMessageIter* out) {
    uint8 o10 = in.getAudprocSelectMode();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BYTE, &o10));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::audproc::service::AudprocSetupDebugRequest& out) {
    {
        uint8 AudprocSelectModeValue;
        uint8 &AudprocSelectModeTmpValue = AudprocSelectModeValue;
        dbus_message_iter_get_basic(in, &AudprocSelectModeTmpValue);
        out.setAudprocSelectMode(AudprocSelectModeValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of AudprocInitializeRequest

void serializeDBus (const ::org::bosch::audproc::service::AudprocInitializeRequest& in, DBusMessageIter* out) {
    uint8 o11 = in.getAudprocSourceId();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BYTE, &o11));
    const char* o12 = in.getAudprocConfigurationFile().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o12));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::audproc::service::AudprocInitializeRequest& out) {
    {
        uint8 AudprocSourceIdValue;
        uint8 &AudprocSourceIdTmpValue = AudprocSourceIdValue;
        dbus_message_iter_get_basic(in, &AudprocSourceIdTmpValue);
        out.setAudprocSourceId(AudprocSourceIdValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::std::string AudprocConfigurationFileValue;
        ::std::string &AudprocConfigurationFileTmpValue = AudprocConfigurationFileValue;
        {
            char* o13 = 0;
            dbus_message_iter_get_basic(in, &o13);
            AudprocConfigurationFileTmpValue.assign (o13);
        }
        out.setAudprocConfigurationFile(AudprocConfigurationFileValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of AudprocSetConfigurationRequest

void serializeDBus (const ::org::bosch::audproc::service::AudprocSetConfigurationRequest& in, DBusMessageIter* out) {
    uint8 o14 = in.getAudprocSourceId();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BYTE, &o14));
    const char* o15 = in.getAudprocConfigurationFile().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o15));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::audproc::service::AudprocSetConfigurationRequest& out) {
    {
        uint8 AudprocSourceIdValue;
        uint8 &AudprocSourceIdTmpValue = AudprocSourceIdValue;
        dbus_message_iter_get_basic(in, &AudprocSourceIdTmpValue);
        out.setAudprocSourceId(AudprocSourceIdValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::std::string AudprocConfigurationFileValue;
        ::std::string &AudprocConfigurationFileTmpValue = AudprocConfigurationFileValue;
        {
            char* o16 = 0;
            dbus_message_iter_get_basic(in, &o16);
            AudprocConfigurationFileTmpValue.assign (o16);
        }
        out.setAudprocConfigurationFile(AudprocConfigurationFileValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of AudprocDestroyRequest

void serializeDBus (const ::org::bosch::audproc::service::AudprocDestroyRequest& in, DBusMessageIter* out) {
    uint8 o17 = in.getAudprocSourceId();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BYTE, &o17));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::audproc::service::AudprocDestroyRequest& out) {
    {
        uint8 AudprocSourceIdValue;
        uint8 &AudprocSourceIdTmpValue = AudprocSourceIdValue;
        dbus_message_iter_get_basic(in, &AudprocSourceIdTmpValue);
        out.setAudprocSourceId(AudprocSourceIdValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of AudprocSetParamRequest

void serializeDBus (const ::org::bosch::audproc::service::AudprocSetParamRequest& in, DBusMessageIter* out) {
    uint8 o18 = in.getAudprocSourceId();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BYTE, &o18));
    uint32 o19 = in.getParameterId();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o19));
    uint8 o20 = in.getParamType();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BYTE, &o20));
    uint32 o21 = in.getUParameter();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o21));
    int32 o22 = in.getSParameter();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT32, &o22));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::audproc::service::AudprocSetParamRequest& out) {
    {
        uint8 AudprocSourceIdValue;
        uint8 &AudprocSourceIdTmpValue = AudprocSourceIdValue;
        dbus_message_iter_get_basic(in, &AudprocSourceIdTmpValue);
        out.setAudprocSourceId(AudprocSourceIdValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint32 ParameterIdValue;
        uint32 &ParameterIdTmpValue = ParameterIdValue;
        dbus_message_iter_get_basic(in, &ParameterIdTmpValue);
        out.setParameterId(ParameterIdValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint8 ParamTypeValue;
        uint8 &ParamTypeTmpValue = ParamTypeValue;
        dbus_message_iter_get_basic(in, &ParamTypeTmpValue);
        out.setParamType(ParamTypeValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint32 uParameterValue;
        uint32 &uParameterTmpValue = uParameterValue;
        dbus_message_iter_get_basic(in, &uParameterTmpValue);
        out.setUParameter(uParameterValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        int32 sParameterValue;
        int32 &sParameterTmpValue = sParameterValue;
        dbus_message_iter_get_basic(in, &sParameterTmpValue);
        out.setSParameter(sParameterValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of AudprocWriteDataRequest

void serializeDBus (const ::org::bosch::audproc::service::AudprocWriteDataRequest& in, DBusMessageIter* out) {
    uint8 o23 = in.getAudprocSourceId();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BYTE, &o23));
    uint32 o24 = in.getParameterId();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o24));
    DBusMessageIter o25ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "y", &o25ArrayIter));
    const ::std::vector< uint8 >* o26 = &in.getData();
    ::std::vector< uint8 >::const_iterator o27 = o26->end();
    for (::std::vector< uint8 >::const_iterator o28 = o26->begin(); o28 != o27; ++o28) {
        DBUS_ASSERT(dbus_message_iter_append_basic(&o25ArrayIter, DBUS_TYPE_BYTE, &(*o28)));
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o25ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::audproc::service::AudprocWriteDataRequest& out) {
    {
        uint8 AudprocSourceIdValue;
        uint8 &AudprocSourceIdTmpValue = AudprocSourceIdValue;
        dbus_message_iter_get_basic(in, &AudprocSourceIdTmpValue);
        out.setAudprocSourceId(AudprocSourceIdValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint32 ParameterIdValue;
        uint32 &ParameterIdTmpValue = ParameterIdValue;
        dbus_message_iter_get_basic(in, &ParameterIdTmpValue);
        out.setParameterId(ParameterIdValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::std::vector< uint8 > dataValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o29ArrayIter;
            dbus_message_iter_recurse (in, &o29ArrayIter);

            if(dbus_message_iter_get_arg_type(&o29ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    uint8 o30;
                    dbus_message_iter_get_basic(&o29ArrayIter, &o30);
                    dataValue.push_back(o30);
                } while (dbus_message_iter_next(&o29ArrayIter));
            }
        }
        out.setData(dataValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of AudprocWriteDataResponse

void serializeDBus (const ::org::bosch::audproc::service::AudprocWriteDataResponse& in, DBusMessageIter* out) {
    DBusMessageIter o31ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "y", &o31ArrayIter));
    const ::std::vector< uint8 >* o32 = &in.getResult();
    ::std::vector< uint8 >::const_iterator o33 = o32->end();
    for (::std::vector< uint8 >::const_iterator o34 = o32->begin(); o34 != o33; ++o34) {
        DBUS_ASSERT(dbus_message_iter_append_basic(&o31ArrayIter, DBUS_TYPE_BYTE, &(*o34)));
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o31ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::audproc::service::AudprocWriteDataResponse& out) {
    {
        ::std::vector< uint8 > resultValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o35ArrayIter;
            dbus_message_iter_recurse (in, &o35ArrayIter);

            if(dbus_message_iter_get_arg_type(&o35ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    uint8 o36;
                    dbus_message_iter_get_basic(&o35ArrayIter, &o36);
                    resultValue.push_back(o36);
                } while (dbus_message_iter_next(&o35ArrayIter));
            }
        }
        out.setResult(resultValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of AudprocReadDataRequest

void serializeDBus (const ::org::bosch::audproc::service::AudprocReadDataRequest& in, DBusMessageIter* out) {
    uint8 o37 = in.getAudprocSourceId();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BYTE, &o37));
    uint32 o38 = in.getParameterId();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o38));
    DBusMessageIter o39ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "y", &o39ArrayIter));
    const ::std::vector< uint8 >* o40 = &in.getReadInfos();
    ::std::vector< uint8 >::const_iterator o41 = o40->end();
    for (::std::vector< uint8 >::const_iterator o42 = o40->begin(); o42 != o41; ++o42) {
        DBUS_ASSERT(dbus_message_iter_append_basic(&o39ArrayIter, DBUS_TYPE_BYTE, &(*o42)));
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o39ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::audproc::service::AudprocReadDataRequest& out) {
    {
        uint8 AudprocSourceIdValue;
        uint8 &AudprocSourceIdTmpValue = AudprocSourceIdValue;
        dbus_message_iter_get_basic(in, &AudprocSourceIdTmpValue);
        out.setAudprocSourceId(AudprocSourceIdValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint32 ParameterIdValue;
        uint32 &ParameterIdTmpValue = ParameterIdValue;
        dbus_message_iter_get_basic(in, &ParameterIdTmpValue);
        out.setParameterId(ParameterIdValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::std::vector< uint8 > ReadInfosValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o43ArrayIter;
            dbus_message_iter_recurse (in, &o43ArrayIter);

            if(dbus_message_iter_get_arg_type(&o43ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    uint8 o44;
                    dbus_message_iter_get_basic(&o43ArrayIter, &o44);
                    ReadInfosValue.push_back(o44);
                } while (dbus_message_iter_next(&o43ArrayIter));
            }
        }
        out.setReadInfos(ReadInfosValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of AudprocReadDataResponse

void serializeDBus (const ::org::bosch::audproc::service::AudprocReadDataResponse& in, DBusMessageIter* out) {
    DBusMessageIter o45ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "y", &o45ArrayIter));
    const ::std::vector< uint8 >* o46 = &in.getData();
    ::std::vector< uint8 >::const_iterator o47 = o46->end();
    for (::std::vector< uint8 >::const_iterator o48 = o46->begin(); o48 != o47; ++o48) {
        DBUS_ASSERT(dbus_message_iter_append_basic(&o45ArrayIter, DBUS_TYPE_BYTE, &(*o48)));
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o45ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::audproc::service::AudprocReadDataResponse& out) {
    {
        ::std::vector< uint8 > dataValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o49ArrayIter;
            dbus_message_iter_recurse (in, &o49ArrayIter);

            if(dbus_message_iter_get_arg_type(&o49ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    uint8 o50;
                    dbus_message_iter_get_basic(&o49ArrayIter, &o50);
                    dataValue.push_back(o50);
                } while (dbus_message_iter_next(&o49ArrayIter));
            }
        }
        out.setData(dataValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of AudprocGetAudprocConfigurationResponse

void serializeDBus (const ::org::bosch::audproc::service::AudprocGetAudprocConfigurationResponse& in, DBusMessageIter* out) {
    const char* o51 = in.getDatasetName().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o51));
    uint32 o52 = in.getAudprocProperties();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o52));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::audproc::service::AudprocGetAudprocConfigurationResponse& out) {
    {
        ::std::string DatasetNameValue;
        ::std::string &DatasetNameTmpValue = DatasetNameValue;
        {
            char* o53 = 0;
            dbus_message_iter_get_basic(in, &o53);
            DatasetNameTmpValue.assign (o53);
        }
        out.setDatasetName(DatasetNameValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint32 AudprocPropertiesValue;
        uint32 &AudprocPropertiesTmpValue = AudprocPropertiesValue;
        dbus_message_iter_get_basic(in, &AudprocPropertiesTmpValue);
        out.setAudprocProperties(AudprocPropertiesValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of AudprocStartAudioRequest

void serializeDBus (const ::org::bosch::audproc::service::AudprocStartAudioRequest& in, DBusMessageIter* out) {
    uint8 o54 = in.getAudprocSourceId();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BYTE, &o54));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::audproc::service::AudprocStartAudioRequest& out) {
    {
        uint8 AudprocSourceIdValue;
        uint8 &AudprocSourceIdTmpValue = AudprocSourceIdValue;
        dbus_message_iter_get_basic(in, &AudprocSourceIdTmpValue);
        out.setAudprocSourceId(AudprocSourceIdValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of AudprocStopAudioRequest

void serializeDBus (const ::org::bosch::audproc::service::AudprocStopAudioRequest& in, DBusMessageIter* out) {
    uint8 o55 = in.getAudprocSourceId();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BYTE, &o55));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::audproc::service::AudprocStopAudioRequest& out) {
    {
        uint8 AudprocSourceIdValue;
        uint8 &AudprocSourceIdTmpValue = AudprocSourceIdValue;
        dbus_message_iter_get_basic(in, &AudprocSourceIdTmpValue);
        out.setAudprocSourceId(AudprocSourceIdValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of AudprocSourceActivityRequest

void serializeDBus (const ::org::bosch::audproc::service::AudprocSourceActivityRequest& in, DBusMessageIter* out) {
    uint8 o56 = in.getAudprocSourceMapId();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BYTE, &o56));
    uint8 o57 = in.getAudprocSourceActivity();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BYTE, &o57));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::audproc::service::AudprocSourceActivityRequest& out) {
    {
        uint8 AudprocSourceMapIdValue;
        uint8 &AudprocSourceMapIdTmpValue = AudprocSourceMapIdValue;
        dbus_message_iter_get_basic(in, &AudprocSourceMapIdTmpValue);
        out.setAudprocSourceMapId(AudprocSourceMapIdValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint8 AudprocSourceActivityValue;
        uint8 &AudprocSourceActivityTmpValue = AudprocSourceActivityValue;
        dbus_message_iter_get_basic(in, &AudprocSourceActivityTmpValue);
        out.setAudprocSourceActivity(AudprocSourceActivityValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of AudprocSourceSelectRequest

void serializeDBus (const ::org::bosch::audproc::service::AudprocSourceSelectRequest& in, DBusMessageIter* out) {
    uint8 o58 = in.getAudprocSourceSelectMode();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BYTE, &o58));
    uint8 o59 = in.getAudprocSourceId();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BYTE, &o59));
    const char* o60 = in.getAudprocAlsaDev().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o60));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::audproc::service::AudprocSourceSelectRequest& out) {
    {
        uint8 AudprocSourceSelectModeValue;
        uint8 &AudprocSourceSelectModeTmpValue = AudprocSourceSelectModeValue;
        dbus_message_iter_get_basic(in, &AudprocSourceSelectModeTmpValue);
        out.setAudprocSourceSelectMode(AudprocSourceSelectModeValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint8 AudprocSourceIdValue;
        uint8 &AudprocSourceIdTmpValue = AudprocSourceIdValue;
        dbus_message_iter_get_basic(in, &AudprocSourceIdTmpValue);
        out.setAudprocSourceId(AudprocSourceIdValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::std::string AudprocAlsaDevValue;
        ::std::string &AudprocAlsaDevTmpValue = AudprocAlsaDevValue;
        {
            char* o61 = 0;
            dbus_message_iter_get_basic(in, &o61);
            AudprocAlsaDevTmpValue.assign (o61);
        }
        out.setAudprocAlsaDev(AudprocAlsaDevValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of AplArkamysAvcActivateUpdate

void serializeDBus (const ::org::bosch::audproc::service::AplArkamysAvcActivateUpdate& in, DBusMessageIter* out) {
    int32 o62 = in.getAplArkamysAvcActivate();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT32, &o62));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::audproc::service::AplArkamysAvcActivateUpdate& out) {
    {
        int32 aplArkamysAvcActivateValue;
        int32 &aplArkamysAvcActivateTmpValue = aplArkamysAvcActivateValue;
        dbus_message_iter_get_basic(in, &aplArkamysAvcActivateTmpValue);
        out.setAplArkamysAvcActivate(aplArkamysAvcActivateValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of AplArkamysAvcActivateRegister

void serializeDBus (const ::org::bosch::audproc::service::AplArkamysAvcActivateRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::bosch::audproc::service::AplArkamysAvcActivateRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of AplArkamysByPassActivateUpdate

void serializeDBus (const ::org::bosch::audproc::service::AplArkamysByPassActivateUpdate& in, DBusMessageIter* out) {
    int32 o63 = in.getAplArkamysByPassActivate();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT32, &o63));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::audproc::service::AplArkamysByPassActivateUpdate& out) {
    {
        int32 aplArkamysByPassActivateValue;
        int32 &aplArkamysByPassActivateTmpValue = aplArkamysByPassActivateValue;
        dbus_message_iter_get_basic(in, &aplArkamysByPassActivateTmpValue);
        out.setAplArkamysByPassActivate(aplArkamysByPassActivateValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of AplArkamysByPassActivateRegister

void serializeDBus (const ::org::bosch::audproc::service::AplArkamysByPassActivateRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::bosch::audproc::service::AplArkamysByPassActivateRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of AplArkamysInputLevelDeviationUpdate

void serializeDBus (const ::org::bosch::audproc::service::AplArkamysInputLevelDeviationUpdate& in, DBusMessageIter* out) {
    int32 o64 = in.getAplArkamysInputLevelDeviation();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT32, &o64));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::audproc::service::AplArkamysInputLevelDeviationUpdate& out) {
    {
        int32 aplArkamysInputLevelDeviationValue;
        int32 &aplArkamysInputLevelDeviationTmpValue = aplArkamysInputLevelDeviationValue;
        dbus_message_iter_get_basic(in, &aplArkamysInputLevelDeviationTmpValue);
        out.setAplArkamysInputLevelDeviation(aplArkamysInputLevelDeviationValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of AplArkamysInputLevelDeviationRegister

void serializeDBus (const ::org::bosch::audproc::service::AplArkamysInputLevelDeviationRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::bosch::audproc::service::AplArkamysInputLevelDeviationRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of AplArkamysCurrentSpeedUpdate

void serializeDBus (const ::org::bosch::audproc::service::AplArkamysCurrentSpeedUpdate& in, DBusMessageIter* out) {
    int32 o65 = in.getAplArkamysCurrentSpeed();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT32, &o65));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::audproc::service::AplArkamysCurrentSpeedUpdate& out) {
    {
        int32 aplArkamysCurrentSpeedValue;
        int32 &aplArkamysCurrentSpeedTmpValue = aplArkamysCurrentSpeedValue;
        dbus_message_iter_get_basic(in, &aplArkamysCurrentSpeedTmpValue);
        out.setAplArkamysCurrentSpeed(aplArkamysCurrentSpeedValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of AplArkamysCurrentSpeedRegister

void serializeDBus (const ::org::bosch::audproc::service::AplArkamysCurrentSpeedRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::bosch::audproc::service::AplArkamysCurrentSpeedRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of AplArkamysCurrentVolumeStepUpdate

void serializeDBus (const ::org::bosch::audproc::service::AplArkamysCurrentVolumeStepUpdate& in, DBusMessageIter* out) {
    int32 o66 = in.getAplArkamysCurrentVolumeStep();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT32, &o66));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::audproc::service::AplArkamysCurrentVolumeStepUpdate& out) {
    {
        int32 aplArkamysCurrentVolumeStepValue;
        int32 &aplArkamysCurrentVolumeStepTmpValue = aplArkamysCurrentVolumeStepValue;
        dbus_message_iter_get_basic(in, &aplArkamysCurrentVolumeStepTmpValue);
        out.setAplArkamysCurrentVolumeStep(aplArkamysCurrentVolumeStepValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of AplArkamysCurrentVolumeStepRegister

void serializeDBus (const ::org::bosch::audproc::service::AplArkamysCurrentVolumeStepRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::bosch::audproc::service::AplArkamysCurrentVolumeStepRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of AplArkamysAmbienceSelectUpdate

void serializeDBus (const ::org::bosch::audproc::service::AplArkamysAmbienceSelectUpdate& in, DBusMessageIter* out) {
    int32 o67 = in.getAplArkamysAmbienceSelect();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT32, &o67));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::audproc::service::AplArkamysAmbienceSelectUpdate& out) {
    {
        int32 aplArkamysAmbienceSelectValue;
        int32 &aplArkamysAmbienceSelectTmpValue = aplArkamysAmbienceSelectValue;
        dbus_message_iter_get_basic(in, &aplArkamysAmbienceSelectTmpValue);
        out.setAplArkamysAmbienceSelect(aplArkamysAmbienceSelectValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of AplArkamysAmbienceSelectRegister

void serializeDBus (const ::org::bosch::audproc::service::AplArkamysAmbienceSelectRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::bosch::audproc::service::AplArkamysAmbienceSelectRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of AplArkamysLevelLossUpdate

void serializeDBus (const ::org::bosch::audproc::service::AplArkamysLevelLossUpdate& in, DBusMessageIter* out) {
    int32 o68 = in.getAplArkamysLevelLoss();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT32, &o68));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::audproc::service::AplArkamysLevelLossUpdate& out) {
    {
        int32 aplArkamysLevelLossValue;
        int32 &aplArkamysLevelLossTmpValue = aplArkamysLevelLossValue;
        dbus_message_iter_get_basic(in, &aplArkamysLevelLossTmpValue);
        out.setAplArkamysLevelLoss(aplArkamysLevelLossValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of AplArkamysLevelLossRegister

void serializeDBus (const ::org::bosch::audproc::service::AplArkamysLevelLossRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::bosch::audproc::service::AplArkamysLevelLossRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of AplArkamysLibraryVersionUpdate

void serializeDBus (const ::org::bosch::audproc::service::AplArkamysLibraryVersionUpdate& in, DBusMessageIter* out) {
    DBusMessageIter o69ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "i", &o69ArrayIter));
    const ::std::vector< int32 >* o70 = &in.getAplArkamysLibraryVersion();
    ::std::vector< int32 >::const_iterator o71 = o70->end();
    for (::std::vector< int32 >::const_iterator o72 = o70->begin(); o72 != o71; ++o72) {
        DBUS_ASSERT(dbus_message_iter_append_basic(&o69ArrayIter, DBUS_TYPE_INT32, &(*o72)));
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o69ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::audproc::service::AplArkamysLibraryVersionUpdate& out) {
    {
        ::std::vector< int32 > aplArkamysLibraryVersionValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o73ArrayIter;
            dbus_message_iter_recurse (in, &o73ArrayIter);

            if(dbus_message_iter_get_arg_type(&o73ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    int32 o74;
                    dbus_message_iter_get_basic(&o73ArrayIter, &o74);
                    aplArkamysLibraryVersionValue.push_back(o74);
                } while (dbus_message_iter_next(&o73ArrayIter));
            }
        }
        out.setAplArkamysLibraryVersion(aplArkamysLibraryVersionValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of AplArkamysLibraryVersionRegister

void serializeDBus (const ::org::bosch::audproc::service::AplArkamysLibraryVersionRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::bosch::audproc::service::AplArkamysLibraryVersionRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of AplArkamysCurrVolAttenuationUpdate

void serializeDBus (const ::org::bosch::audproc::service::AplArkamysCurrVolAttenuationUpdate& in, DBusMessageIter* out) {
    int32 o75 = in.getAplArkamysCurrVolAttenuation();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT32, &o75));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::audproc::service::AplArkamysCurrVolAttenuationUpdate& out) {
    {
        int32 aplArkamysCurrVolAttenuationValue;
        int32 &aplArkamysCurrVolAttenuationTmpValue = aplArkamysCurrVolAttenuationValue;
        dbus_message_iter_get_basic(in, &aplArkamysCurrVolAttenuationTmpValue);
        out.setAplArkamysCurrVolAttenuation(aplArkamysCurrVolAttenuationValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of AplArkamysCurrVolAttenuationRegister

void serializeDBus (const ::org::bosch::audproc::service::AplArkamysCurrVolAttenuationRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::bosch::audproc::service::AplArkamysCurrVolAttenuationRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of AplArkamysFlushUpdate

void serializeDBus (const ::org::bosch::audproc::service::AplArkamysFlushUpdate& in, DBusMessageIter* out) {
    int32 o76 = in.getAplArkamysFlush();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT32, &o76));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::audproc::service::AplArkamysFlushUpdate& out) {
    {
        int32 aplArkamysFlushValue;
        int32 &aplArkamysFlushTmpValue = aplArkamysFlushValue;
        dbus_message_iter_get_basic(in, &aplArkamysFlushTmpValue);
        out.setAplArkamysFlush(aplArkamysFlushValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of AplArkamysFlushRegister

void serializeDBus (const ::org::bosch::audproc::service::AplArkamysFlushRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::bosch::audproc::service::AplArkamysFlushRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of AplMicLvlWatchRefIntUpdate

void serializeDBus (const ::org::bosch::audproc::service::AplMicLvlWatchRefIntUpdate& in, DBusMessageIter* out) {
    uint32 o77 = in.getAplMicLvlWatchRefInt();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o77));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::audproc::service::AplMicLvlWatchRefIntUpdate& out) {
    {
        uint32 aplMicLvlWatchRefIntValue;
        uint32 &aplMicLvlWatchRefIntTmpValue = aplMicLvlWatchRefIntValue;
        dbus_message_iter_get_basic(in, &aplMicLvlWatchRefIntTmpValue);
        out.setAplMicLvlWatchRefInt(aplMicLvlWatchRefIntValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of AplMicLvlWatchRefIntRegister

void serializeDBus (const ::org::bosch::audproc::service::AplMicLvlWatchRefIntRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::bosch::audproc::service::AplMicLvlWatchRefIntRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of AplMicLvlUpdate

void serializeDBus (const ::org::bosch::audproc::service::AplMicLvlUpdate& in, DBusMessageIter* out) {
    int32 o78 = in.getAplMicLvl();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT32, &o78));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::audproc::service::AplMicLvlUpdate& out) {
    {
        int32 aplMicLvlValue;
        int32 &aplMicLvlTmpValue = aplMicLvlValue;
        dbus_message_iter_get_basic(in, &aplMicLvlTmpValue);
        out.setAplMicLvl(aplMicLvlValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of AplMicLvlRegister

void serializeDBus (const ::org::bosch::audproc::service::AplMicLvlRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::bosch::audproc::service::AplMicLvlRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of AplAudioModeUpdate

void serializeDBus (const ::org::bosch::audproc::service::AplAudioModeUpdate& in, DBusMessageIter* out) {
    int32 o79 = in.getAplAudioMode();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT32, &o79));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::audproc::service::AplAudioModeUpdate& out) {
    {
        int32 aplAudioModeValue;
        int32 &aplAudioModeTmpValue = aplAudioModeValue;
        dbus_message_iter_get_basic(in, &aplAudioModeTmpValue);
        out.setAplAudioMode(aplAudioModeValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of AplAudioModeRegister

void serializeDBus (const ::org::bosch::audproc::service::AplAudioModeRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::bosch::audproc::service::AplAudioModeRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of AplLoopbackActivateUpdate

void serializeDBus (const ::org::bosch::audproc::service::AplLoopbackActivateUpdate& in, DBusMessageIter* out) {
    int32 o80 = in.getAplLoopbackActivate();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT32, &o80));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::audproc::service::AplLoopbackActivateUpdate& out) {
    {
        int32 aplLoopbackActivateValue;
        int32 &aplLoopbackActivateTmpValue = aplLoopbackActivateValue;
        dbus_message_iter_get_basic(in, &aplLoopbackActivateTmpValue);
        out.setAplLoopbackActivate(aplLoopbackActivateValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of AplLoopbackActivateRegister

void serializeDBus (const ::org::bosch::audproc::service::AplLoopbackActivateRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::bosch::audproc::service::AplLoopbackActivateRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of AudprocStatusSignal

void serializeDBus (const ::org::bosch::audproc::service::AudprocStatusSignal& in, DBusMessageIter* out) {
    uint8 o81 = in.getStatusEntSrcEnum();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BYTE, &o81));
    uint8 o82 = in.getStatusEntSrcActiveState();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BYTE, &o82));
    uint8 o83 = in.getStatusVoiceSrcEnum();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BYTE, &o83));
    uint8 o84 = in.getStatusVoiceSrcActiveState();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BYTE, &o84));
    uint8 o85 = in.getStatusInfoSrcEnum();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BYTE, &o85));
    uint8 o86 = in.getStatusinfoSrcActiveState();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BYTE, &o86));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::audproc::service::AudprocStatusSignal& out) {
    {
        uint8 statusEntSrcEnumValue;
        uint8 &statusEntSrcEnumTmpValue = statusEntSrcEnumValue;
        dbus_message_iter_get_basic(in, &statusEntSrcEnumTmpValue);
        out.setStatusEntSrcEnum(statusEntSrcEnumValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint8 statusEntSrcActiveStateValue;
        uint8 &statusEntSrcActiveStateTmpValue = statusEntSrcActiveStateValue;
        dbus_message_iter_get_basic(in, &statusEntSrcActiveStateTmpValue);
        out.setStatusEntSrcActiveState(statusEntSrcActiveStateValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint8 statusVoiceSrcEnumValue;
        uint8 &statusVoiceSrcEnumTmpValue = statusVoiceSrcEnumValue;
        dbus_message_iter_get_basic(in, &statusVoiceSrcEnumTmpValue);
        out.setStatusVoiceSrcEnum(statusVoiceSrcEnumValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint8 statusVoiceSrcActiveStateValue;
        uint8 &statusVoiceSrcActiveStateTmpValue = statusVoiceSrcActiveStateValue;
        dbus_message_iter_get_basic(in, &statusVoiceSrcActiveStateTmpValue);
        out.setStatusVoiceSrcActiveState(statusVoiceSrcActiveStateValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint8 statusInfoSrcEnumValue;
        uint8 &statusInfoSrcEnumTmpValue = statusInfoSrcEnumValue;
        dbus_message_iter_get_basic(in, &statusInfoSrcEnumTmpValue);
        out.setStatusInfoSrcEnum(statusInfoSrcEnumValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint8 statusinfoSrcActiveStateValue;
        uint8 &statusinfoSrcActiveStateTmpValue = statusinfoSrcActiveStateValue;
        dbus_message_iter_get_basic(in, &statusinfoSrcActiveStateTmpValue);
        out.setStatusinfoSrcActiveState(statusinfoSrcActiveStateValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of AudprocMicrolevelStatusSignal

void serializeDBus (const ::org::bosch::audproc::service::AudprocMicrolevelStatusSignal& in, DBusMessageIter* out) {
    int16 o87 = in.getStatusMicroLevel();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT16, &o87));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::audproc::service::AudprocMicrolevelStatusSignal& out) {
    {
        int16 StatusMicroLevelValue;
        int16 &StatusMicroLevelTmpValue = StatusMicroLevelValue;
        dbus_message_iter_get_basic(in, &StatusMicroLevelTmpValue);
        out.setStatusMicroLevel(StatusMicroLevelValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of AudprocArkamysLevelLossSignal

void serializeDBus (const ::org::bosch::audproc::service::AudprocArkamysLevelLossSignal& in, DBusMessageIter* out) {
    int32 o88 = in.getStatusArkamysLevelLoss();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT32, &o88));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::audproc::service::AudprocArkamysLevelLossSignal& out) {
    {
        int32 StatusArkamysLevelLossValue;
        int32 &StatusArkamysLevelLossTmpValue = StatusArkamysLevelLossValue;
        dbus_message_iter_get_basic(in, &StatusArkamysLevelLossTmpValue);
        out.setStatusArkamysLevelLoss(StatusArkamysLevelLossValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

