#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef ORG_BOSCH_AUDPROC_SERVICE_H
#define ORG_BOSCH_AUDPROC_SERVICE_H

#include "asf/core/Logger.h"
#include "asf/core/Payload.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "asf/core/VersionCheck.h"
#include "asf/dbus/DBusTypes.h"
#include <cstddef>
#include <cstring>
#include <string>
#include <vector>

/**
 * If the meaning of "service" isn't clear, then there should be a description here.
 */

namespace org {
namespace bosch {
namespace audproc {
namespace service {

// method IDs
static const uint16 ID_AudprocGetVersion = 0;
static const uint16 ID_AudprocGetStatus = 1;
static const uint16 ID_AudprocTerminate = 2;
static const uint16 ID_AudprocSetupDebug = 3;
static const uint16 ID_AudprocCreate = 4;
static const uint16 ID_AudprocInitialize = 5;
static const uint16 ID_AudprocSetConfiguration = 6;
static const uint16 ID_AudprocDestroy = 7;
static const uint16 ID_AudprocSetParam = 8;
static const uint16 ID_AudprocWriteData = 9;
static const uint16 ID_AudprocReadData = 10;
static const uint16 ID_AudprocGetAudprocConfiguration = 11;
static const uint16 ID_AudprocStartAudio = 12;
static const uint16 ID_AudprocStopAudio = 13;
static const uint16 ID_AudprocMute = 14;
static const uint16 ID_AudprocSourceActivity = 15;
static const uint16 ID_AudprocSourceSelect = 16;

// signal IDs
static const uint16 ID_AudprocStatus = 17;
static const uint16 ID_AudprocMicrolevelStatus = 18;
static const uint16 ID_AudprocArkamysLevelLoss = 19;

// property IDs
static const uint16 ID_aplArkamysAvcActivate = 20;
static const uint16 ID_aplArkamysByPassActivate = 21;
static const uint16 ID_aplArkamysInputLevelDeviation = 22;
static const uint16 ID_aplArkamysCurrentSpeed = 23;
static const uint16 ID_aplArkamysCurrentVolumeStep = 24;
static const uint16 ID_aplArkamysAmbienceSelect = 25;
static const uint16 ID_aplArkamysLevelLoss = 26;
static const uint16 ID_aplArkamysLibraryVersion = 27;
static const uint16 ID_aplArkamysCurrVolAttenuation = 28;
static const uint16 ID_aplArkamysFlush = 29;
static const uint16 ID_aplMicLvlWatchRefInt = 30;
static const uint16 ID_aplMicLvl = 31;
static const uint16 ID_aplAudioMode = 32;
static const uint16 ID_aplLoopbackActivate = 33;

ASF_GENERATOR_VERSION_CHECK_DECLARE

// forward declarations
class AudprocGetVersionResponse;

class AudprocSetupDebugRequest;

class AudprocInitializeRequest;

class AudprocSetConfigurationRequest;

class AudprocDestroyRequest;

class AudprocSetParamRequest;

class AudprocWriteDataRequest;

class AudprocWriteDataResponse;

class AudprocReadDataRequest;

class AudprocReadDataResponse;

class AudprocGetAudprocConfigurationResponse;

class AudprocStartAudioRequest;

class AudprocStopAudioRequest;

class AudprocSourceActivityRequest;

class AudprocSourceSelectRequest;

class AplArkamysAvcActivateUpdate;

class AplArkamysAvcActivateRegister;

class AplArkamysByPassActivateUpdate;

class AplArkamysByPassActivateRegister;

class AplArkamysInputLevelDeviationUpdate;

class AplArkamysInputLevelDeviationRegister;

class AplArkamysCurrentSpeedUpdate;

class AplArkamysCurrentSpeedRegister;

class AplArkamysCurrentVolumeStepUpdate;

class AplArkamysCurrentVolumeStepRegister;

class AplArkamysAmbienceSelectUpdate;

class AplArkamysAmbienceSelectRegister;

class AplArkamysLevelLossUpdate;

class AplArkamysLevelLossRegister;

class AplArkamysLibraryVersionUpdate;

class AplArkamysLibraryVersionRegister;

class AplArkamysCurrVolAttenuationUpdate;

class AplArkamysCurrVolAttenuationRegister;

class AplArkamysFlushUpdate;

class AplArkamysFlushRegister;

class AplMicLvlWatchRefIntUpdate;

class AplMicLvlWatchRefIntRegister;

class AplMicLvlUpdate;

class AplMicLvlRegister;

class AplAudioModeUpdate;

class AplAudioModeRegister;

class AplLoopbackActivateUpdate;

class AplLoopbackActivateRegister;

class AudprocStatusSignal;

class AudprocMicrolevelStatusSignal;

class AudprocArkamysLevelLossSignal;

// type definitions
/**
 * If the meaning of "AudprocGetVersionRequest" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage AudprocGetVersionRequest;

/**
 * If the meaning of "AudprocGetVersionError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError AudprocGetVersionError;

/**
 * If the meaning of "AudprocGetStatusRequest" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage AudprocGetStatusRequest;

/**
 * If the meaning of "AudprocGetStatusResponse" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage AudprocGetStatusResponse;

/**
 * If the meaning of "AudprocGetStatusError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError AudprocGetStatusError;

/**
 * If the meaning of "AudprocTerminateRequest" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage AudprocTerminateRequest;

/**
 * If the meaning of "AudprocTerminateResponse" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage AudprocTerminateResponse;

/**
 * If the meaning of "AudprocTerminateError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError AudprocTerminateError;

/**
 * If the meaning of "AudprocSetupDebugResponse" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage AudprocSetupDebugResponse;

/**
 * If the meaning of "AudprocSetupDebugError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError AudprocSetupDebugError;

/**
 * If the meaning of "AudprocCreateRequest" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage AudprocCreateRequest;

/**
 * If the meaning of "AudprocCreateResponse" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage AudprocCreateResponse;

/**
 * If the meaning of "AudprocCreateError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError AudprocCreateError;

/**
 * If the meaning of "AudprocInitializeResponse" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage AudprocInitializeResponse;

/**
 * If the meaning of "AudprocInitializeError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError AudprocInitializeError;

/**
 * If the meaning of "AudprocSetConfigurationResponse" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage AudprocSetConfigurationResponse;

/**
 * If the meaning of "AudprocSetConfigurationError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError AudprocSetConfigurationError;

/**
 * If the meaning of "AudprocDestroyResponse" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage AudprocDestroyResponse;

/**
 * If the meaning of "AudprocDestroyError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError AudprocDestroyError;

/**
 * If the meaning of "AudprocSetParamResponse" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage AudprocSetParamResponse;

/**
 * If the meaning of "AudprocSetParamError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError AudprocSetParamError;

/**
 * If the meaning of "AudprocWriteDataError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError AudprocWriteDataError;

/**
 * If the meaning of "AudprocReadDataError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError AudprocReadDataError;

/**
 * If the meaning of "AudprocGetAudprocConfigurationRequest" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage AudprocGetAudprocConfigurationRequest;

/**
 * If the meaning of "AudprocGetAudprocConfigurationError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError AudprocGetAudprocConfigurationError;

/**
 * If the meaning of "AudprocStartAudioResponse" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage AudprocStartAudioResponse;

/**
 * If the meaning of "AudprocStartAudioError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError AudprocStartAudioError;

/**
 * If the meaning of "AudprocStopAudioResponse" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage AudprocStopAudioResponse;

/**
 * If the meaning of "AudprocStopAudioError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError AudprocStopAudioError;

/**
 * If the meaning of "AudprocMuteRequest" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage AudprocMuteRequest;

/**
 * If the meaning of "AudprocMuteResponse" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage AudprocMuteResponse;

/**
 * If the meaning of "AudprocMuteError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError AudprocMuteError;

/**
 * If the meaning of "AudprocSourceActivityResponse" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage AudprocSourceActivityResponse;

/**
 * If the meaning of "AudprocSourceActivityError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError AudprocSourceActivityError;

/**
 * If the meaning of "AudprocSourceSelectResponse" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage AudprocSourceSelectResponse;

/**
 * If the meaning of "AudprocSourceSelectError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError AudprocSourceSelectError;

/**
 * If the meaning of "AplArkamysAvcActivateSet" isn't clear, then there should be a description here.
 */
typedef AplArkamysAvcActivateUpdate AplArkamysAvcActivateSet;

/**
 * If the meaning of "AplArkamysAvcActivateGet" isn't clear, then there should be a description here.
 */
typedef AplArkamysAvcActivateUpdate AplArkamysAvcActivateGet;

/**
 * If the meaning of "AplArkamysAvcActivateError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError AplArkamysAvcActivateError;

/**
 * If the meaning of "AplArkamysByPassActivateSet" isn't clear, then there should be a description here.
 */
typedef AplArkamysByPassActivateUpdate AplArkamysByPassActivateSet;

/**
 * If the meaning of "AplArkamysByPassActivateGet" isn't clear, then there should be a description here.
 */
typedef AplArkamysByPassActivateUpdate AplArkamysByPassActivateGet;

/**
 * If the meaning of "AplArkamysByPassActivateError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError AplArkamysByPassActivateError;

/**
 * If the meaning of "AplArkamysInputLevelDeviationSet" isn't clear, then there should be a description here.
 */
typedef AplArkamysInputLevelDeviationUpdate AplArkamysInputLevelDeviationSet;

/**
 * If the meaning of "AplArkamysInputLevelDeviationGet" isn't clear, then there should be a description here.
 */
typedef AplArkamysInputLevelDeviationUpdate AplArkamysInputLevelDeviationGet;

/**
 * If the meaning of "AplArkamysInputLevelDeviationError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError AplArkamysInputLevelDeviationError;

/**
 * If the meaning of "AplArkamysCurrentSpeedSet" isn't clear, then there should be a description here.
 */
typedef AplArkamysCurrentSpeedUpdate AplArkamysCurrentSpeedSet;

/**
 * If the meaning of "AplArkamysCurrentSpeedGet" isn't clear, then there should be a description here.
 */
typedef AplArkamysCurrentSpeedUpdate AplArkamysCurrentSpeedGet;

/**
 * If the meaning of "AplArkamysCurrentSpeedError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError AplArkamysCurrentSpeedError;

/**
 * If the meaning of "AplArkamysCurrentVolumeStepSet" isn't clear, then there should be a description here.
 */
typedef AplArkamysCurrentVolumeStepUpdate AplArkamysCurrentVolumeStepSet;

/**
 * If the meaning of "AplArkamysCurrentVolumeStepGet" isn't clear, then there should be a description here.
 */
typedef AplArkamysCurrentVolumeStepUpdate AplArkamysCurrentVolumeStepGet;

/**
 * If the meaning of "AplArkamysCurrentVolumeStepError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError AplArkamysCurrentVolumeStepError;

/**
 * If the meaning of "AplArkamysAmbienceSelectSet" isn't clear, then there should be a description here.
 */
typedef AplArkamysAmbienceSelectUpdate AplArkamysAmbienceSelectSet;

/**
 * If the meaning of "AplArkamysAmbienceSelectGet" isn't clear, then there should be a description here.
 */
typedef AplArkamysAmbienceSelectUpdate AplArkamysAmbienceSelectGet;

/**
 * If the meaning of "AplArkamysAmbienceSelectError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError AplArkamysAmbienceSelectError;

/**
 * If the meaning of "AplArkamysLevelLossSet" isn't clear, then there should be a description here.
 */
typedef AplArkamysLevelLossUpdate AplArkamysLevelLossSet;

/**
 * If the meaning of "AplArkamysLevelLossGet" isn't clear, then there should be a description here.
 */
typedef AplArkamysLevelLossUpdate AplArkamysLevelLossGet;

/**
 * If the meaning of "AplArkamysLevelLossError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError AplArkamysLevelLossError;

/**
 * If the meaning of "AplArkamysLibraryVersionSet" isn't clear, then there should be a description here.
 */
typedef AplArkamysLibraryVersionUpdate AplArkamysLibraryVersionSet;

/**
 * If the meaning of "AplArkamysLibraryVersionGet" isn't clear, then there should be a description here.
 */
typedef AplArkamysLibraryVersionUpdate AplArkamysLibraryVersionGet;

/**
 * If the meaning of "AplArkamysLibraryVersionError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError AplArkamysLibraryVersionError;

/**
 * If the meaning of "AplArkamysCurrVolAttenuationSet" isn't clear, then there should be a description here.
 */
typedef AplArkamysCurrVolAttenuationUpdate AplArkamysCurrVolAttenuationSet;

/**
 * If the meaning of "AplArkamysCurrVolAttenuationGet" isn't clear, then there should be a description here.
 */
typedef AplArkamysCurrVolAttenuationUpdate AplArkamysCurrVolAttenuationGet;

/**
 * If the meaning of "AplArkamysCurrVolAttenuationError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError AplArkamysCurrVolAttenuationError;

/**
 * If the meaning of "AplArkamysFlushSet" isn't clear, then there should be a description here.
 */
typedef AplArkamysFlushUpdate AplArkamysFlushSet;

/**
 * If the meaning of "AplArkamysFlushGet" isn't clear, then there should be a description here.
 */
typedef AplArkamysFlushUpdate AplArkamysFlushGet;

/**
 * If the meaning of "AplArkamysFlushError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError AplArkamysFlushError;

/**
 * If the meaning of "AplMicLvlWatchRefIntSet" isn't clear, then there should be a description here.
 */
typedef AplMicLvlWatchRefIntUpdate AplMicLvlWatchRefIntSet;

/**
 * If the meaning of "AplMicLvlWatchRefIntGet" isn't clear, then there should be a description here.
 */
typedef AplMicLvlWatchRefIntUpdate AplMicLvlWatchRefIntGet;

/**
 * If the meaning of "AplMicLvlWatchRefIntError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError AplMicLvlWatchRefIntError;

/**
 * If the meaning of "AplMicLvlSet" isn't clear, then there should be a description here.
 */
typedef AplMicLvlUpdate AplMicLvlSet;

/**
 * If the meaning of "AplMicLvlGet" isn't clear, then there should be a description here.
 */
typedef AplMicLvlUpdate AplMicLvlGet;

/**
 * If the meaning of "AplMicLvlError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError AplMicLvlError;

/**
 * If the meaning of "AplAudioModeSet" isn't clear, then there should be a description here.
 */
typedef AplAudioModeUpdate AplAudioModeSet;

/**
 * If the meaning of "AplAudioModeGet" isn't clear, then there should be a description here.
 */
typedef AplAudioModeUpdate AplAudioModeGet;

/**
 * If the meaning of "AplAudioModeError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError AplAudioModeError;

/**
 * If the meaning of "AplLoopbackActivateSet" isn't clear, then there should be a description here.
 */
typedef AplLoopbackActivateUpdate AplLoopbackActivateSet;

/**
 * If the meaning of "AplLoopbackActivateGet" isn't clear, then there should be a description here.
 */
typedef AplLoopbackActivateUpdate AplLoopbackActivateGet;

/**
 * If the meaning of "AplLoopbackActivateError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError AplLoopbackActivateError;

/**
 * If the meaning of "AudprocStatusError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError AudprocStatusError;

/**
 * If the meaning of "AudprocMicrolevelStatusError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError AudprocMicrolevelStatusError;

/**
 * If the meaning of "AudprocArkamysLevelLossError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError AudprocArkamysLevelLossError;


/**
 * If the meaning of "AudprocGetVersionResponse" isn't clear, then there should be a description here.
 */
class AudprocGetVersionResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AudprocGetVersionResponse ();

    /**
     * Copy constructor
     */
    inline  AudprocGetVersionResponse (const AudprocGetVersionResponse &rhs);

    /**
     * All fields constructor
     */
    inline  AudprocGetVersionResponse (const ::std::vector< uint32 >& Version_, const ::std::string& VersionString_, const ::std::string& VersionComment_);

    /**
     * Destructor
     */
    inline virtual  ~AudprocGetVersionResponse();

    /**
     * Assignment operator
     */
    inline AudprocGetVersionResponse& operator = (const AudprocGetVersionResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AudprocGetVersionResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AudprocGetVersionResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AudprocGetVersionResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AudprocGetVersionResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Version"

    static const int kVersion = 0;

    /**
     * Clears the field "Version".
     *
     * The field will be set to its default value. The hasVersion()
     * method will return false.
     */
    inline void clearVersion();

    /**
     * Checks whether the field "Version" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setVersion()). Otherwise it will return false.
     */
    inline bool hasVersion () const;

    /**
     * Returns the value of the member "Version".
     *
     * If the meaning of "Version" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Version"
     */
    inline const ::std::vector< uint32 >& getVersion () const;

    /**
     * Retrieves the value of the field "Version" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Version".
     */
    inline ::std::vector< uint32 >& getVersionMutable ();

    /**
     * Sets the value of the member "Version".
     *
     * If the meaning of "Version" isn't clear, then there should be a description here.
     *
     * @param Version The value which will be set
     */
    inline void setVersion (const ::std::vector< uint32 >& Version_);

    // API of field "VersionString"

    static const int kVersionString = 1;

    /**
     * Clears the field "VersionString".
     *
     * The field will be set to its default value. The hasVersionString()
     * method will return false.
     */
    inline void clearVersionString();

    /**
     * Checks whether the field "VersionString" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setVersionString()). Otherwise it will return false.
     */
    inline bool hasVersionString () const;

    /**
     * Returns the value of the member "VersionString".
     *
     * If the meaning of "VersionString" isn't clear, then there should be a description here.
     *
     * @return The value of the field "VersionString"
     */
    inline const ::std::string& getVersionString () const;

    /**
     * Retrieves the value of the field "VersionString" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "VersionString".
     */
    inline ::std::string& getVersionStringMutable ();

    /**
     * Sets the value of the member "VersionString".
     *
     * If the meaning of "VersionString" isn't clear, then there should be a description here.
     *
     * @param VersionString The value which will be set
     */
    inline void setVersionString (const ::std::string& VersionString_);

    /**
     * Sets the value of the member "VersionString".
     *
     * If the meaning of "VersionString" isn't clear, then there should be a description here.
     *
     * @param VersionString The value which will be set
     */
    inline void setVersionString (const char* VersionString_);

    /**
     * Sets the value of the member "VersionString".
     *
     * If the meaning of "VersionString" isn't clear, then there should be a description here.
     *
     * @param VersionString The value which will be set
     */
    inline void setVersionString (const char* value, size_t size);

    // API of field "VersionComment"

    static const int kVersionComment = 2;

    /**
     * Clears the field "VersionComment".
     *
     * The field will be set to its default value. The hasVersionComment()
     * method will return false.
     */
    inline void clearVersionComment();

    /**
     * Checks whether the field "VersionComment" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setVersionComment()). Otherwise it will return false.
     */
    inline bool hasVersionComment () const;

    /**
     * Returns the value of the member "VersionComment".
     *
     * If the meaning of "VersionComment" isn't clear, then there should be a description here.
     *
     * @return The value of the field "VersionComment"
     */
    inline const ::std::string& getVersionComment () const;

    /**
     * Retrieves the value of the field "VersionComment" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "VersionComment".
     */
    inline ::std::string& getVersionCommentMutable ();

    /**
     * Sets the value of the member "VersionComment".
     *
     * If the meaning of "VersionComment" isn't clear, then there should be a description here.
     *
     * @param VersionComment The value which will be set
     */
    inline void setVersionComment (const ::std::string& VersionComment_);

    /**
     * Sets the value of the member "VersionComment".
     *
     * If the meaning of "VersionComment" isn't clear, then there should be a description here.
     *
     * @param VersionComment The value which will be set
     */
    inline void setVersionComment (const char* VersionComment_);

    /**
     * Sets the value of the member "VersionComment".
     *
     * If the meaning of "VersionComment" isn't clear, then there should be a description here.
     *
     * @param VersionComment The value which will be set
     */
    inline void setVersionComment (const char* value, size_t size);

    static const AudprocGetVersionResponse &getDefaultInstance();

private:

    static const ::std::vector< uint32 >& getUint32List_DefaultInstance ();

    inline void set_has_Version ();

    inline void clear_has_Version ();

    inline void set_has_VersionString ();

    inline void clear_has_VersionString ();

    inline void set_has_VersionComment ();

    inline void clear_has_VersionComment ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::std::vector< uint32 > _Version;

    ::std::string _VersionString;

    ::std::string _VersionComment;

};

/**
 * If the meaning of "AudprocSetupDebugRequest" isn't clear, then there should be a description here.
 */
class AudprocSetupDebugRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AudprocSetupDebugRequest ();

    /**
     * Copy constructor
     */
    inline  AudprocSetupDebugRequest (const AudprocSetupDebugRequest &rhs);

    /**
     * All fields constructor
     */
    inline  AudprocSetupDebugRequest (uint8 AudprocSelectMode_);

    /**
     * Destructor
     */
    inline virtual  ~AudprocSetupDebugRequest();

    /**
     * Assignment operator
     */
    inline AudprocSetupDebugRequest& operator = (const AudprocSetupDebugRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AudprocSetupDebugRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AudprocSetupDebugRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AudprocSetupDebugRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AudprocSetupDebugRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "AudprocSelectMode"

    static const int kAudprocSelectMode = 0;

    /**
     * Clears the field "AudprocSelectMode".
     *
     * The field will be set to its default value. The hasAudprocSelectMode()
     * method will return false.
     */
    inline void clearAudprocSelectMode();

    /**
     * Checks whether the field "AudprocSelectMode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAudprocSelectMode()). Otherwise it will return false.
     */
    inline bool hasAudprocSelectMode () const;

    /**
     * Returns the value of the member "AudprocSelectMode".
     *
     * If the meaning of "AudprocSelectMode" isn't clear, then there should be a description here.
     *
     * @return The value of the field "AudprocSelectMode"
     */
    inline uint8 getAudprocSelectMode () const;

    /**
     * Sets the value of the member "AudprocSelectMode".
     *
     * If the meaning of "AudprocSelectMode" isn't clear, then there should be a description here.
     *
     * @param AudprocSelectMode The value which will be set
     */
    inline void setAudprocSelectMode (uint8 AudprocSelectMode_);

    static const AudprocSetupDebugRequest &getDefaultInstance();

private:

    inline void set_has_AudprocSelectMode ();

    inline void clear_has_AudprocSelectMode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _AudprocSelectMode;

};

/**
 * If the meaning of "AudprocInitializeRequest" isn't clear, then there should be a description here.
 */
class AudprocInitializeRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AudprocInitializeRequest ();

    /**
     * Copy constructor
     */
    inline  AudprocInitializeRequest (const AudprocInitializeRequest &rhs);

    /**
     * All fields constructor
     */
    inline  AudprocInitializeRequest (uint8 AudprocSourceId_, const ::std::string& AudprocConfigurationFile_);

    /**
     * Destructor
     */
    inline virtual  ~AudprocInitializeRequest();

    /**
     * Assignment operator
     */
    inline AudprocInitializeRequest& operator = (const AudprocInitializeRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AudprocInitializeRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AudprocInitializeRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AudprocInitializeRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AudprocInitializeRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "AudprocSourceId"

    static const int kAudprocSourceId = 0;

    /**
     * Clears the field "AudprocSourceId".
     *
     * The field will be set to its default value. The hasAudprocSourceId()
     * method will return false.
     */
    inline void clearAudprocSourceId();

    /**
     * Checks whether the field "AudprocSourceId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAudprocSourceId()). Otherwise it will return false.
     */
    inline bool hasAudprocSourceId () const;

    /**
     * Returns the value of the member "AudprocSourceId".
     *
     * If the meaning of "AudprocSourceId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "AudprocSourceId"
     */
    inline uint8 getAudprocSourceId () const;

    /**
     * Sets the value of the member "AudprocSourceId".
     *
     * If the meaning of "AudprocSourceId" isn't clear, then there should be a description here.
     *
     * @param AudprocSourceId The value which will be set
     */
    inline void setAudprocSourceId (uint8 AudprocSourceId_);

    // API of field "AudprocConfigurationFile"

    static const int kAudprocConfigurationFile = 1;

    /**
     * Clears the field "AudprocConfigurationFile".
     *
     * The field will be set to its default value. The hasAudprocConfigurationFile()
     * method will return false.
     */
    inline void clearAudprocConfigurationFile();

    /**
     * Checks whether the field "AudprocConfigurationFile" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAudprocConfigurationFile()). Otherwise it will return false.
     */
    inline bool hasAudprocConfigurationFile () const;

    /**
     * Returns the value of the member "AudprocConfigurationFile".
     *
     * If the meaning of "AudprocConfigurationFile" isn't clear, then there should be a description here.
     *
     * @return The value of the field "AudprocConfigurationFile"
     */
    inline const ::std::string& getAudprocConfigurationFile () const;

    /**
     * Retrieves the value of the field "AudprocConfigurationFile" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "AudprocConfigurationFile".
     */
    inline ::std::string& getAudprocConfigurationFileMutable ();

    /**
     * Sets the value of the member "AudprocConfigurationFile".
     *
     * If the meaning of "AudprocConfigurationFile" isn't clear, then there should be a description here.
     *
     * @param AudprocConfigurationFile The value which will be set
     */
    inline void setAudprocConfigurationFile (const ::std::string& AudprocConfigurationFile_);

    /**
     * Sets the value of the member "AudprocConfigurationFile".
     *
     * If the meaning of "AudprocConfigurationFile" isn't clear, then there should be a description here.
     *
     * @param AudprocConfigurationFile The value which will be set
     */
    inline void setAudprocConfigurationFile (const char* AudprocConfigurationFile_);

    /**
     * Sets the value of the member "AudprocConfigurationFile".
     *
     * If the meaning of "AudprocConfigurationFile" isn't clear, then there should be a description here.
     *
     * @param AudprocConfigurationFile The value which will be set
     */
    inline void setAudprocConfigurationFile (const char* value, size_t size);

    static const AudprocInitializeRequest &getDefaultInstance();

private:

    inline void set_has_AudprocSourceId ();

    inline void clear_has_AudprocSourceId ();

    inline void set_has_AudprocConfigurationFile ();

    inline void clear_has_AudprocConfigurationFile ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint8 _AudprocSourceId;

    ::std::string _AudprocConfigurationFile;

};

/**
 * If the meaning of "AudprocSetConfigurationRequest" isn't clear, then there should be a description here.
 */
class AudprocSetConfigurationRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AudprocSetConfigurationRequest ();

    /**
     * Copy constructor
     */
    inline  AudprocSetConfigurationRequest (const AudprocSetConfigurationRequest &rhs);

    /**
     * All fields constructor
     */
    inline  AudprocSetConfigurationRequest (uint8 AudprocSourceId_, const ::std::string& AudprocConfigurationFile_);

    /**
     * Destructor
     */
    inline virtual  ~AudprocSetConfigurationRequest();

    /**
     * Assignment operator
     */
    inline AudprocSetConfigurationRequest& operator = (const AudprocSetConfigurationRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AudprocSetConfigurationRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AudprocSetConfigurationRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AudprocSetConfigurationRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AudprocSetConfigurationRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "AudprocSourceId"

    static const int kAudprocSourceId = 0;

    /**
     * Clears the field "AudprocSourceId".
     *
     * The field will be set to its default value. The hasAudprocSourceId()
     * method will return false.
     */
    inline void clearAudprocSourceId();

    /**
     * Checks whether the field "AudprocSourceId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAudprocSourceId()). Otherwise it will return false.
     */
    inline bool hasAudprocSourceId () const;

    /**
     * Returns the value of the member "AudprocSourceId".
     *
     * If the meaning of "AudprocSourceId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "AudprocSourceId"
     */
    inline uint8 getAudprocSourceId () const;

    /**
     * Sets the value of the member "AudprocSourceId".
     *
     * If the meaning of "AudprocSourceId" isn't clear, then there should be a description here.
     *
     * @param AudprocSourceId The value which will be set
     */
    inline void setAudprocSourceId (uint8 AudprocSourceId_);

    // API of field "AudprocConfigurationFile"

    static const int kAudprocConfigurationFile = 1;

    /**
     * Clears the field "AudprocConfigurationFile".
     *
     * The field will be set to its default value. The hasAudprocConfigurationFile()
     * method will return false.
     */
    inline void clearAudprocConfigurationFile();

    /**
     * Checks whether the field "AudprocConfigurationFile" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAudprocConfigurationFile()). Otherwise it will return false.
     */
    inline bool hasAudprocConfigurationFile () const;

    /**
     * Returns the value of the member "AudprocConfigurationFile".
     *
     * If the meaning of "AudprocConfigurationFile" isn't clear, then there should be a description here.
     *
     * @return The value of the field "AudprocConfigurationFile"
     */
    inline const ::std::string& getAudprocConfigurationFile () const;

    /**
     * Retrieves the value of the field "AudprocConfigurationFile" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "AudprocConfigurationFile".
     */
    inline ::std::string& getAudprocConfigurationFileMutable ();

    /**
     * Sets the value of the member "AudprocConfigurationFile".
     *
     * If the meaning of "AudprocConfigurationFile" isn't clear, then there should be a description here.
     *
     * @param AudprocConfigurationFile The value which will be set
     */
    inline void setAudprocConfigurationFile (const ::std::string& AudprocConfigurationFile_);

    /**
     * Sets the value of the member "AudprocConfigurationFile".
     *
     * If the meaning of "AudprocConfigurationFile" isn't clear, then there should be a description here.
     *
     * @param AudprocConfigurationFile The value which will be set
     */
    inline void setAudprocConfigurationFile (const char* AudprocConfigurationFile_);

    /**
     * Sets the value of the member "AudprocConfigurationFile".
     *
     * If the meaning of "AudprocConfigurationFile" isn't clear, then there should be a description here.
     *
     * @param AudprocConfigurationFile The value which will be set
     */
    inline void setAudprocConfigurationFile (const char* value, size_t size);

    static const AudprocSetConfigurationRequest &getDefaultInstance();

private:

    inline void set_has_AudprocSourceId ();

    inline void clear_has_AudprocSourceId ();

    inline void set_has_AudprocConfigurationFile ();

    inline void clear_has_AudprocConfigurationFile ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint8 _AudprocSourceId;

    ::std::string _AudprocConfigurationFile;

};

/**
 * If the meaning of "AudprocDestroyRequest" isn't clear, then there should be a description here.
 */
class AudprocDestroyRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AudprocDestroyRequest ();

    /**
     * Copy constructor
     */
    inline  AudprocDestroyRequest (const AudprocDestroyRequest &rhs);

    /**
     * All fields constructor
     */
    inline  AudprocDestroyRequest (uint8 AudprocSourceId_);

    /**
     * Destructor
     */
    inline virtual  ~AudprocDestroyRequest();

    /**
     * Assignment operator
     */
    inline AudprocDestroyRequest& operator = (const AudprocDestroyRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AudprocDestroyRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AudprocDestroyRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AudprocDestroyRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AudprocDestroyRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "AudprocSourceId"

    static const int kAudprocSourceId = 0;

    /**
     * Clears the field "AudprocSourceId".
     *
     * The field will be set to its default value. The hasAudprocSourceId()
     * method will return false.
     */
    inline void clearAudprocSourceId();

    /**
     * Checks whether the field "AudprocSourceId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAudprocSourceId()). Otherwise it will return false.
     */
    inline bool hasAudprocSourceId () const;

    /**
     * Returns the value of the member "AudprocSourceId".
     *
     * If the meaning of "AudprocSourceId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "AudprocSourceId"
     */
    inline uint8 getAudprocSourceId () const;

    /**
     * Sets the value of the member "AudprocSourceId".
     *
     * If the meaning of "AudprocSourceId" isn't clear, then there should be a description here.
     *
     * @param AudprocSourceId The value which will be set
     */
    inline void setAudprocSourceId (uint8 AudprocSourceId_);

    static const AudprocDestroyRequest &getDefaultInstance();

private:

    inline void set_has_AudprocSourceId ();

    inline void clear_has_AudprocSourceId ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _AudprocSourceId;

};

/**
 * If the meaning of "AudprocSetParamRequest" isn't clear, then there should be a description here.
 */
class AudprocSetParamRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AudprocSetParamRequest ();

    /**
     * Copy constructor
     */
    inline  AudprocSetParamRequest (const AudprocSetParamRequest &rhs);

    /**
     * All fields constructor
     */
    inline  AudprocSetParamRequest (uint8 AudprocSourceId_, uint32 ParameterId_, uint8 ParamType_, uint32 uParameter_, int32 sParameter_);

    /**
     * Destructor
     */
    inline virtual  ~AudprocSetParamRequest();

    /**
     * Assignment operator
     */
    inline AudprocSetParamRequest& operator = (const AudprocSetParamRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AudprocSetParamRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AudprocSetParamRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AudprocSetParamRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AudprocSetParamRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "AudprocSourceId"

    static const int kAudprocSourceId = 0;

    /**
     * Clears the field "AudprocSourceId".
     *
     * The field will be set to its default value. The hasAudprocSourceId()
     * method will return false.
     */
    inline void clearAudprocSourceId();

    /**
     * Checks whether the field "AudprocSourceId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAudprocSourceId()). Otherwise it will return false.
     */
    inline bool hasAudprocSourceId () const;

    /**
     * Returns the value of the member "AudprocSourceId".
     *
     * If the meaning of "AudprocSourceId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "AudprocSourceId"
     */
    inline uint8 getAudprocSourceId () const;

    /**
     * Sets the value of the member "AudprocSourceId".
     *
     * If the meaning of "AudprocSourceId" isn't clear, then there should be a description here.
     *
     * @param AudprocSourceId The value which will be set
     */
    inline void setAudprocSourceId (uint8 AudprocSourceId_);

    // API of field "ParameterId"

    static const int kParameterId = 1;

    /**
     * Clears the field "ParameterId".
     *
     * The field will be set to its default value. The hasParameterId()
     * method will return false.
     */
    inline void clearParameterId();

    /**
     * Checks whether the field "ParameterId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setParameterId()). Otherwise it will return false.
     */
    inline bool hasParameterId () const;

    /**
     * Returns the value of the member "ParameterId".
     *
     * If the meaning of "ParameterId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "ParameterId"
     */
    inline uint32 getParameterId () const;

    /**
     * Sets the value of the member "ParameterId".
     *
     * If the meaning of "ParameterId" isn't clear, then there should be a description here.
     *
     * @param ParameterId The value which will be set
     */
    inline void setParameterId (uint32 ParameterId_);

    // API of field "ParamType"

    static const int kParamType = 2;

    /**
     * Clears the field "ParamType".
     *
     * The field will be set to its default value. The hasParamType()
     * method will return false.
     */
    inline void clearParamType();

    /**
     * Checks whether the field "ParamType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setParamType()). Otherwise it will return false.
     */
    inline bool hasParamType () const;

    /**
     * Returns the value of the member "ParamType".
     *
     * If the meaning of "ParamType" isn't clear, then there should be a description here.
     *
     * @return The value of the field "ParamType"
     */
    inline uint8 getParamType () const;

    /**
     * Sets the value of the member "ParamType".
     *
     * If the meaning of "ParamType" isn't clear, then there should be a description here.
     *
     * @param ParamType The value which will be set
     */
    inline void setParamType (uint8 ParamType_);

    // API of field "uParameter"

    static const int kUParameter = 3;

    /**
     * Clears the field "uParameter".
     *
     * The field will be set to its default value. The hasUParameter()
     * method will return false.
     */
    inline void clearUParameter();

    /**
     * Checks whether the field "uParameter" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setUParameter()). Otherwise it will return false.
     */
    inline bool hasUParameter () const;

    /**
     * Returns the value of the member "uParameter".
     *
     * If the meaning of "uParameter" isn't clear, then there should be a description here.
     *
     * @return The value of the field "uParameter"
     */
    inline uint32 getUParameter () const;

    /**
     * Sets the value of the member "uParameter".
     *
     * If the meaning of "uParameter" isn't clear, then there should be a description here.
     *
     * @param uParameter The value which will be set
     */
    inline void setUParameter (uint32 uParameter_);

    // API of field "sParameter"

    static const int kSParameter = 4;

    /**
     * Clears the field "sParameter".
     *
     * The field will be set to its default value. The hasSParameter()
     * method will return false.
     */
    inline void clearSParameter();

    /**
     * Checks whether the field "sParameter" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSParameter()). Otherwise it will return false.
     */
    inline bool hasSParameter () const;

    /**
     * Returns the value of the member "sParameter".
     *
     * If the meaning of "sParameter" isn't clear, then there should be a description here.
     *
     * @return The value of the field "sParameter"
     */
    inline int32 getSParameter () const;

    /**
     * Sets the value of the member "sParameter".
     *
     * If the meaning of "sParameter" isn't clear, then there should be a description here.
     *
     * @param sParameter The value which will be set
     */
    inline void setSParameter (int32 sParameter_);

    static const AudprocSetParamRequest &getDefaultInstance();

private:

    inline void set_has_AudprocSourceId ();

    inline void clear_has_AudprocSourceId ();

    inline void set_has_ParameterId ();

    inline void clear_has_ParameterId ();

    inline void set_has_ParamType ();

    inline void clear_has_ParamType ();

    inline void set_has_uParameter ();

    inline void clear_has_uParameter ();

    inline void set_has_sParameter ();

    inline void clear_has_sParameter ();

    uint32 _has_bits_[ (5 + 31) / 32];

    uint8 _AudprocSourceId;

    uint32 _ParameterId;

    uint8 _ParamType;

    uint32 _uParameter;

    int32 _sParameter;

};

/**
 * If the meaning of "AudprocWriteDataRequest" isn't clear, then there should be a description here.
 */
class AudprocWriteDataRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AudprocWriteDataRequest ();

    /**
     * Copy constructor
     */
    inline  AudprocWriteDataRequest (const AudprocWriteDataRequest &rhs);

    /**
     * All fields constructor
     */
    inline  AudprocWriteDataRequest (uint8 AudprocSourceId_, uint32 ParameterId_, const ::std::vector< uint8 >& data_);

    /**
     * Destructor
     */
    inline virtual  ~AudprocWriteDataRequest();

    /**
     * Assignment operator
     */
    inline AudprocWriteDataRequest& operator = (const AudprocWriteDataRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AudprocWriteDataRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AudprocWriteDataRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AudprocWriteDataRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AudprocWriteDataRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "AudprocSourceId"

    static const int kAudprocSourceId = 0;

    /**
     * Clears the field "AudprocSourceId".
     *
     * The field will be set to its default value. The hasAudprocSourceId()
     * method will return false.
     */
    inline void clearAudprocSourceId();

    /**
     * Checks whether the field "AudprocSourceId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAudprocSourceId()). Otherwise it will return false.
     */
    inline bool hasAudprocSourceId () const;

    /**
     * Returns the value of the member "AudprocSourceId".
     *
     * If the meaning of "AudprocSourceId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "AudprocSourceId"
     */
    inline uint8 getAudprocSourceId () const;

    /**
     * Sets the value of the member "AudprocSourceId".
     *
     * If the meaning of "AudprocSourceId" isn't clear, then there should be a description here.
     *
     * @param AudprocSourceId The value which will be set
     */
    inline void setAudprocSourceId (uint8 AudprocSourceId_);

    // API of field "ParameterId"

    static const int kParameterId = 1;

    /**
     * Clears the field "ParameterId".
     *
     * The field will be set to its default value. The hasParameterId()
     * method will return false.
     */
    inline void clearParameterId();

    /**
     * Checks whether the field "ParameterId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setParameterId()). Otherwise it will return false.
     */
    inline bool hasParameterId () const;

    /**
     * Returns the value of the member "ParameterId".
     *
     * If the meaning of "ParameterId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "ParameterId"
     */
    inline uint32 getParameterId () const;

    /**
     * Sets the value of the member "ParameterId".
     *
     * If the meaning of "ParameterId" isn't clear, then there should be a description here.
     *
     * @param ParameterId The value which will be set
     */
    inline void setParameterId (uint32 ParameterId_);

    // API of field "data"

    static const int kData = 2;

    /**
     * Clears the field "data".
     *
     * The field will be set to its default value. The hasData()
     * method will return false.
     */
    inline void clearData();

    /**
     * Checks whether the field "data" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setData()). Otherwise it will return false.
     */
    inline bool hasData () const;

    /**
     * Returns the value of the member "data".
     *
     * If the meaning of "data" isn't clear, then there should be a description here.
     *
     * @return The value of the field "data"
     */
    inline const ::std::vector< uint8 >& getData () const;

    /**
     * Retrieves the value of the field "data" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "data".
     */
    inline ::std::vector< uint8 >& getDataMutable ();

    /**
     * Sets the value of the member "data".
     *
     * If the meaning of "data" isn't clear, then there should be a description here.
     *
     * @param data The value which will be set
     */
    inline void setData (const ::std::vector< uint8 >& data_);

    static const AudprocWriteDataRequest &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_AudprocSourceId ();

    inline void clear_has_AudprocSourceId ();

    inline void set_has_ParameterId ();

    inline void clear_has_ParameterId ();

    inline void set_has_data ();

    inline void clear_has_data ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint8 _AudprocSourceId;

    uint32 _ParameterId;

    ::std::vector< uint8 > _data;

};

/**
 * If the meaning of "AudprocWriteDataResponse" isn't clear, then there should be a description here.
 */
class AudprocWriteDataResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AudprocWriteDataResponse ();

    /**
     * Copy constructor
     */
    inline  AudprocWriteDataResponse (const AudprocWriteDataResponse &rhs);

    /**
     * All fields constructor
     */
    inline  AudprocWriteDataResponse (const ::std::vector< uint8 >& result_);

    /**
     * Destructor
     */
    inline virtual  ~AudprocWriteDataResponse();

    /**
     * Assignment operator
     */
    inline AudprocWriteDataResponse& operator = (const AudprocWriteDataResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AudprocWriteDataResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AudprocWriteDataResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AudprocWriteDataResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AudprocWriteDataResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "result"

    static const int kResult = 0;

    /**
     * Clears the field "result".
     *
     * The field will be set to its default value. The hasResult()
     * method will return false.
     */
    inline void clearResult();

    /**
     * Checks whether the field "result" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResult()). Otherwise it will return false.
     */
    inline bool hasResult () const;

    /**
     * Returns the value of the member "result".
     *
     * If the meaning of "result" isn't clear, then there should be a description here.
     *
     * @return The value of the field "result"
     */
    inline const ::std::vector< uint8 >& getResult () const;

    /**
     * Retrieves the value of the field "result" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "result".
     */
    inline ::std::vector< uint8 >& getResultMutable ();

    /**
     * Sets the value of the member "result".
     *
     * If the meaning of "result" isn't clear, then there should be a description here.
     *
     * @param result The value which will be set
     */
    inline void setResult (const ::std::vector< uint8 >& result_);

    static const AudprocWriteDataResponse &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_result ();

    inline void clear_has_result ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< uint8 > _result;

};

/**
 * If the meaning of "AudprocReadDataRequest" isn't clear, then there should be a description here.
 */
class AudprocReadDataRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AudprocReadDataRequest ();

    /**
     * Copy constructor
     */
    inline  AudprocReadDataRequest (const AudprocReadDataRequest &rhs);

    /**
     * All fields constructor
     */
    inline  AudprocReadDataRequest (uint8 AudprocSourceId_, uint32 ParameterId_, const ::std::vector< uint8 >& ReadInfos_);

    /**
     * Destructor
     */
    inline virtual  ~AudprocReadDataRequest();

    /**
     * Assignment operator
     */
    inline AudprocReadDataRequest& operator = (const AudprocReadDataRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AudprocReadDataRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AudprocReadDataRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AudprocReadDataRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AudprocReadDataRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "AudprocSourceId"

    static const int kAudprocSourceId = 0;

    /**
     * Clears the field "AudprocSourceId".
     *
     * The field will be set to its default value. The hasAudprocSourceId()
     * method will return false.
     */
    inline void clearAudprocSourceId();

    /**
     * Checks whether the field "AudprocSourceId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAudprocSourceId()). Otherwise it will return false.
     */
    inline bool hasAudprocSourceId () const;

    /**
     * Returns the value of the member "AudprocSourceId".
     *
     * If the meaning of "AudprocSourceId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "AudprocSourceId"
     */
    inline uint8 getAudprocSourceId () const;

    /**
     * Sets the value of the member "AudprocSourceId".
     *
     * If the meaning of "AudprocSourceId" isn't clear, then there should be a description here.
     *
     * @param AudprocSourceId The value which will be set
     */
    inline void setAudprocSourceId (uint8 AudprocSourceId_);

    // API of field "ParameterId"

    static const int kParameterId = 1;

    /**
     * Clears the field "ParameterId".
     *
     * The field will be set to its default value. The hasParameterId()
     * method will return false.
     */
    inline void clearParameterId();

    /**
     * Checks whether the field "ParameterId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setParameterId()). Otherwise it will return false.
     */
    inline bool hasParameterId () const;

    /**
     * Returns the value of the member "ParameterId".
     *
     * If the meaning of "ParameterId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "ParameterId"
     */
    inline uint32 getParameterId () const;

    /**
     * Sets the value of the member "ParameterId".
     *
     * If the meaning of "ParameterId" isn't clear, then there should be a description here.
     *
     * @param ParameterId The value which will be set
     */
    inline void setParameterId (uint32 ParameterId_);

    // API of field "ReadInfos"

    static const int kReadInfos = 2;

    /**
     * Clears the field "ReadInfos".
     *
     * The field will be set to its default value. The hasReadInfos()
     * method will return false.
     */
    inline void clearReadInfos();

    /**
     * Checks whether the field "ReadInfos" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setReadInfos()). Otherwise it will return false.
     */
    inline bool hasReadInfos () const;

    /**
     * Returns the value of the member "ReadInfos".
     *
     * If the meaning of "ReadInfos" isn't clear, then there should be a description here.
     *
     * @return The value of the field "ReadInfos"
     */
    inline const ::std::vector< uint8 >& getReadInfos () const;

    /**
     * Retrieves the value of the field "ReadInfos" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ReadInfos".
     */
    inline ::std::vector< uint8 >& getReadInfosMutable ();

    /**
     * Sets the value of the member "ReadInfos".
     *
     * If the meaning of "ReadInfos" isn't clear, then there should be a description here.
     *
     * @param ReadInfos The value which will be set
     */
    inline void setReadInfos (const ::std::vector< uint8 >& ReadInfos_);

    static const AudprocReadDataRequest &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_AudprocSourceId ();

    inline void clear_has_AudprocSourceId ();

    inline void set_has_ParameterId ();

    inline void clear_has_ParameterId ();

    inline void set_has_ReadInfos ();

    inline void clear_has_ReadInfos ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint8 _AudprocSourceId;

    uint32 _ParameterId;

    ::std::vector< uint8 > _ReadInfos;

};

/**
 * If the meaning of "AudprocReadDataResponse" isn't clear, then there should be a description here.
 */
class AudprocReadDataResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AudprocReadDataResponse ();

    /**
     * Copy constructor
     */
    inline  AudprocReadDataResponse (const AudprocReadDataResponse &rhs);

    /**
     * All fields constructor
     */
    inline  AudprocReadDataResponse (const ::std::vector< uint8 >& data_);

    /**
     * Destructor
     */
    inline virtual  ~AudprocReadDataResponse();

    /**
     * Assignment operator
     */
    inline AudprocReadDataResponse& operator = (const AudprocReadDataResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AudprocReadDataResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AudprocReadDataResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AudprocReadDataResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AudprocReadDataResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "data"

    static const int kData = 0;

    /**
     * Clears the field "data".
     *
     * The field will be set to its default value. The hasData()
     * method will return false.
     */
    inline void clearData();

    /**
     * Checks whether the field "data" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setData()). Otherwise it will return false.
     */
    inline bool hasData () const;

    /**
     * Returns the value of the member "data".
     *
     * If the meaning of "data" isn't clear, then there should be a description here.
     *
     * @return The value of the field "data"
     */
    inline const ::std::vector< uint8 >& getData () const;

    /**
     * Retrieves the value of the field "data" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "data".
     */
    inline ::std::vector< uint8 >& getDataMutable ();

    /**
     * Sets the value of the member "data".
     *
     * If the meaning of "data" isn't clear, then there should be a description here.
     *
     * @param data The value which will be set
     */
    inline void setData (const ::std::vector< uint8 >& data_);

    static const AudprocReadDataResponse &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_data ();

    inline void clear_has_data ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< uint8 > _data;

};

/**
 * If the meaning of "AudprocGetAudprocConfigurationResponse" isn't clear, then there should be a description here.
 */
class AudprocGetAudprocConfigurationResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AudprocGetAudprocConfigurationResponse ();

    /**
     * Copy constructor
     */
    inline  AudprocGetAudprocConfigurationResponse (const AudprocGetAudprocConfigurationResponse &rhs);

    /**
     * All fields constructor
     */
    inline  AudprocGetAudprocConfigurationResponse (const ::std::string& DatasetName_, uint32 AudprocProperties_);

    /**
     * Destructor
     */
    inline virtual  ~AudprocGetAudprocConfigurationResponse();

    /**
     * Assignment operator
     */
    inline AudprocGetAudprocConfigurationResponse& operator = (const AudprocGetAudprocConfigurationResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AudprocGetAudprocConfigurationResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AudprocGetAudprocConfigurationResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AudprocGetAudprocConfigurationResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AudprocGetAudprocConfigurationResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DatasetName"

    static const int kDatasetName = 0;

    /**
     * Clears the field "DatasetName".
     *
     * The field will be set to its default value. The hasDatasetName()
     * method will return false.
     */
    inline void clearDatasetName();

    /**
     * Checks whether the field "DatasetName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDatasetName()). Otherwise it will return false.
     */
    inline bool hasDatasetName () const;

    /**
     * Returns the value of the member "DatasetName".
     *
     * If the meaning of "DatasetName" isn't clear, then there should be a description here.
     *
     * @return The value of the field "DatasetName"
     */
    inline const ::std::string& getDatasetName () const;

    /**
     * Retrieves the value of the field "DatasetName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "DatasetName".
     */
    inline ::std::string& getDatasetNameMutable ();

    /**
     * Sets the value of the member "DatasetName".
     *
     * If the meaning of "DatasetName" isn't clear, then there should be a description here.
     *
     * @param DatasetName The value which will be set
     */
    inline void setDatasetName (const ::std::string& DatasetName_);

    /**
     * Sets the value of the member "DatasetName".
     *
     * If the meaning of "DatasetName" isn't clear, then there should be a description here.
     *
     * @param DatasetName The value which will be set
     */
    inline void setDatasetName (const char* DatasetName_);

    /**
     * Sets the value of the member "DatasetName".
     *
     * If the meaning of "DatasetName" isn't clear, then there should be a description here.
     *
     * @param DatasetName The value which will be set
     */
    inline void setDatasetName (const char* value, size_t size);

    // API of field "AudprocProperties"

    static const int kAudprocProperties = 1;

    /**
     * Clears the field "AudprocProperties".
     *
     * The field will be set to its default value. The hasAudprocProperties()
     * method will return false.
     */
    inline void clearAudprocProperties();

    /**
     * Checks whether the field "AudprocProperties" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAudprocProperties()). Otherwise it will return false.
     */
    inline bool hasAudprocProperties () const;

    /**
     * Returns the value of the member "AudprocProperties".
     *
     * If the meaning of "AudprocProperties" isn't clear, then there should be a description here.
     *
     * @return The value of the field "AudprocProperties"
     */
    inline uint32 getAudprocProperties () const;

    /**
     * Sets the value of the member "AudprocProperties".
     *
     * If the meaning of "AudprocProperties" isn't clear, then there should be a description here.
     *
     * @param AudprocProperties The value which will be set
     */
    inline void setAudprocProperties (uint32 AudprocProperties_);

    static const AudprocGetAudprocConfigurationResponse &getDefaultInstance();

private:

    inline void set_has_DatasetName ();

    inline void clear_has_DatasetName ();

    inline void set_has_AudprocProperties ();

    inline void clear_has_AudprocProperties ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _DatasetName;

    uint32 _AudprocProperties;

};

/**
 * If the meaning of "AudprocStartAudioRequest" isn't clear, then there should be a description here.
 */
class AudprocStartAudioRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AudprocStartAudioRequest ();

    /**
     * Copy constructor
     */
    inline  AudprocStartAudioRequest (const AudprocStartAudioRequest &rhs);

    /**
     * All fields constructor
     */
    inline  AudprocStartAudioRequest (uint8 AudprocSourceId_);

    /**
     * Destructor
     */
    inline virtual  ~AudprocStartAudioRequest();

    /**
     * Assignment operator
     */
    inline AudprocStartAudioRequest& operator = (const AudprocStartAudioRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AudprocStartAudioRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AudprocStartAudioRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AudprocStartAudioRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AudprocStartAudioRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "AudprocSourceId"

    static const int kAudprocSourceId = 0;

    /**
     * Clears the field "AudprocSourceId".
     *
     * The field will be set to its default value. The hasAudprocSourceId()
     * method will return false.
     */
    inline void clearAudprocSourceId();

    /**
     * Checks whether the field "AudprocSourceId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAudprocSourceId()). Otherwise it will return false.
     */
    inline bool hasAudprocSourceId () const;

    /**
     * Returns the value of the member "AudprocSourceId".
     *
     * If the meaning of "AudprocSourceId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "AudprocSourceId"
     */
    inline uint8 getAudprocSourceId () const;

    /**
     * Sets the value of the member "AudprocSourceId".
     *
     * If the meaning of "AudprocSourceId" isn't clear, then there should be a description here.
     *
     * @param AudprocSourceId The value which will be set
     */
    inline void setAudprocSourceId (uint8 AudprocSourceId_);

    static const AudprocStartAudioRequest &getDefaultInstance();

private:

    inline void set_has_AudprocSourceId ();

    inline void clear_has_AudprocSourceId ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _AudprocSourceId;

};

/**
 * If the meaning of "AudprocStopAudioRequest" isn't clear, then there should be a description here.
 */
class AudprocStopAudioRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AudprocStopAudioRequest ();

    /**
     * Copy constructor
     */
    inline  AudprocStopAudioRequest (const AudprocStopAudioRequest &rhs);

    /**
     * All fields constructor
     */
    inline  AudprocStopAudioRequest (uint8 AudprocSourceId_);

    /**
     * Destructor
     */
    inline virtual  ~AudprocStopAudioRequest();

    /**
     * Assignment operator
     */
    inline AudprocStopAudioRequest& operator = (const AudprocStopAudioRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AudprocStopAudioRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AudprocStopAudioRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AudprocStopAudioRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AudprocStopAudioRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "AudprocSourceId"

    static const int kAudprocSourceId = 0;

    /**
     * Clears the field "AudprocSourceId".
     *
     * The field will be set to its default value. The hasAudprocSourceId()
     * method will return false.
     */
    inline void clearAudprocSourceId();

    /**
     * Checks whether the field "AudprocSourceId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAudprocSourceId()). Otherwise it will return false.
     */
    inline bool hasAudprocSourceId () const;

    /**
     * Returns the value of the member "AudprocSourceId".
     *
     * If the meaning of "AudprocSourceId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "AudprocSourceId"
     */
    inline uint8 getAudprocSourceId () const;

    /**
     * Sets the value of the member "AudprocSourceId".
     *
     * If the meaning of "AudprocSourceId" isn't clear, then there should be a description here.
     *
     * @param AudprocSourceId The value which will be set
     */
    inline void setAudprocSourceId (uint8 AudprocSourceId_);

    static const AudprocStopAudioRequest &getDefaultInstance();

private:

    inline void set_has_AudprocSourceId ();

    inline void clear_has_AudprocSourceId ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _AudprocSourceId;

};

/**
 * If the meaning of "AudprocSourceActivityRequest" isn't clear, then there should be a description here.
 */
class AudprocSourceActivityRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AudprocSourceActivityRequest ();

    /**
     * Copy constructor
     */
    inline  AudprocSourceActivityRequest (const AudprocSourceActivityRequest &rhs);

    /**
     * All fields constructor
     */
    inline  AudprocSourceActivityRequest (uint8 AudprocSourceMapId_, uint8 AudprocSourceActivity_);

    /**
     * Destructor
     */
    inline virtual  ~AudprocSourceActivityRequest();

    /**
     * Assignment operator
     */
    inline AudprocSourceActivityRequest& operator = (const AudprocSourceActivityRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AudprocSourceActivityRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AudprocSourceActivityRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AudprocSourceActivityRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AudprocSourceActivityRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "AudprocSourceMapId"

    static const int kAudprocSourceMapId = 0;

    /**
     * Clears the field "AudprocSourceMapId".
     *
     * The field will be set to its default value. The hasAudprocSourceMapId()
     * method will return false.
     */
    inline void clearAudprocSourceMapId();

    /**
     * Checks whether the field "AudprocSourceMapId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAudprocSourceMapId()). Otherwise it will return false.
     */
    inline bool hasAudprocSourceMapId () const;

    /**
     * Returns the value of the member "AudprocSourceMapId".
     *
     * If the meaning of "AudprocSourceMapId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "AudprocSourceMapId"
     */
    inline uint8 getAudprocSourceMapId () const;

    /**
     * Sets the value of the member "AudprocSourceMapId".
     *
     * If the meaning of "AudprocSourceMapId" isn't clear, then there should be a description here.
     *
     * @param AudprocSourceMapId The value which will be set
     */
    inline void setAudprocSourceMapId (uint8 AudprocSourceMapId_);

    // API of field "AudprocSourceActivity"

    static const int kAudprocSourceActivity = 1;

    /**
     * Clears the field "AudprocSourceActivity".
     *
     * The field will be set to its default value. The hasAudprocSourceActivity()
     * method will return false.
     */
    inline void clearAudprocSourceActivity();

    /**
     * Checks whether the field "AudprocSourceActivity" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAudprocSourceActivity()). Otherwise it will return false.
     */
    inline bool hasAudprocSourceActivity () const;

    /**
     * Returns the value of the member "AudprocSourceActivity".
     *
     * If the meaning of "AudprocSourceActivity" isn't clear, then there should be a description here.
     *
     * @return The value of the field "AudprocSourceActivity"
     */
    inline uint8 getAudprocSourceActivity () const;

    /**
     * Sets the value of the member "AudprocSourceActivity".
     *
     * If the meaning of "AudprocSourceActivity" isn't clear, then there should be a description here.
     *
     * @param AudprocSourceActivity The value which will be set
     */
    inline void setAudprocSourceActivity (uint8 AudprocSourceActivity_);

    static const AudprocSourceActivityRequest &getDefaultInstance();

private:

    inline void set_has_AudprocSourceMapId ();

    inline void clear_has_AudprocSourceMapId ();

    inline void set_has_AudprocSourceActivity ();

    inline void clear_has_AudprocSourceActivity ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint8 _AudprocSourceMapId;

    uint8 _AudprocSourceActivity;

};

/**
 * If the meaning of "AudprocSourceSelectRequest" isn't clear, then there should be a description here.
 */
class AudprocSourceSelectRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AudprocSourceSelectRequest ();

    /**
     * Copy constructor
     */
    inline  AudprocSourceSelectRequest (const AudprocSourceSelectRequest &rhs);

    /**
     * All fields constructor
     */
    inline  AudprocSourceSelectRequest (uint8 AudprocSourceSelectMode_, uint8 AudprocSourceId_, const ::std::string& AudprocAlsaDev_);

    /**
     * Destructor
     */
    inline virtual  ~AudprocSourceSelectRequest();

    /**
     * Assignment operator
     */
    inline AudprocSourceSelectRequest& operator = (const AudprocSourceSelectRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AudprocSourceSelectRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AudprocSourceSelectRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AudprocSourceSelectRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AudprocSourceSelectRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "AudprocSourceSelectMode"

    static const int kAudprocSourceSelectMode = 0;

    /**
     * Clears the field "AudprocSourceSelectMode".
     *
     * The field will be set to its default value. The hasAudprocSourceSelectMode()
     * method will return false.
     */
    inline void clearAudprocSourceSelectMode();

    /**
     * Checks whether the field "AudprocSourceSelectMode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAudprocSourceSelectMode()). Otherwise it will return false.
     */
    inline bool hasAudprocSourceSelectMode () const;

    /**
     * Returns the value of the member "AudprocSourceSelectMode".
     *
     * If the meaning of "AudprocSourceSelectMode" isn't clear, then there should be a description here.
     *
     * @return The value of the field "AudprocSourceSelectMode"
     */
    inline uint8 getAudprocSourceSelectMode () const;

    /**
     * Sets the value of the member "AudprocSourceSelectMode".
     *
     * If the meaning of "AudprocSourceSelectMode" isn't clear, then there should be a description here.
     *
     * @param AudprocSourceSelectMode The value which will be set
     */
    inline void setAudprocSourceSelectMode (uint8 AudprocSourceSelectMode_);

    // API of field "AudprocSourceId"

    static const int kAudprocSourceId = 1;

    /**
     * Clears the field "AudprocSourceId".
     *
     * The field will be set to its default value. The hasAudprocSourceId()
     * method will return false.
     */
    inline void clearAudprocSourceId();

    /**
     * Checks whether the field "AudprocSourceId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAudprocSourceId()). Otherwise it will return false.
     */
    inline bool hasAudprocSourceId () const;

    /**
     * Returns the value of the member "AudprocSourceId".
     *
     * If the meaning of "AudprocSourceId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "AudprocSourceId"
     */
    inline uint8 getAudprocSourceId () const;

    /**
     * Sets the value of the member "AudprocSourceId".
     *
     * If the meaning of "AudprocSourceId" isn't clear, then there should be a description here.
     *
     * @param AudprocSourceId The value which will be set
     */
    inline void setAudprocSourceId (uint8 AudprocSourceId_);

    // API of field "AudprocAlsaDev"

    static const int kAudprocAlsaDev = 2;

    /**
     * Clears the field "AudprocAlsaDev".
     *
     * The field will be set to its default value. The hasAudprocAlsaDev()
     * method will return false.
     */
    inline void clearAudprocAlsaDev();

    /**
     * Checks whether the field "AudprocAlsaDev" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAudprocAlsaDev()). Otherwise it will return false.
     */
    inline bool hasAudprocAlsaDev () const;

    /**
     * Returns the value of the member "AudprocAlsaDev".
     *
     * If the meaning of "AudprocAlsaDev" isn't clear, then there should be a description here.
     *
     * @return The value of the field "AudprocAlsaDev"
     */
    inline const ::std::string& getAudprocAlsaDev () const;

    /**
     * Retrieves the value of the field "AudprocAlsaDev" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "AudprocAlsaDev".
     */
    inline ::std::string& getAudprocAlsaDevMutable ();

    /**
     * Sets the value of the member "AudprocAlsaDev".
     *
     * If the meaning of "AudprocAlsaDev" isn't clear, then there should be a description here.
     *
     * @param AudprocAlsaDev The value which will be set
     */
    inline void setAudprocAlsaDev (const ::std::string& AudprocAlsaDev_);

    /**
     * Sets the value of the member "AudprocAlsaDev".
     *
     * If the meaning of "AudprocAlsaDev" isn't clear, then there should be a description here.
     *
     * @param AudprocAlsaDev The value which will be set
     */
    inline void setAudprocAlsaDev (const char* AudprocAlsaDev_);

    /**
     * Sets the value of the member "AudprocAlsaDev".
     *
     * If the meaning of "AudprocAlsaDev" isn't clear, then there should be a description here.
     *
     * @param AudprocAlsaDev The value which will be set
     */
    inline void setAudprocAlsaDev (const char* value, size_t size);

    static const AudprocSourceSelectRequest &getDefaultInstance();

private:

    inline void set_has_AudprocSourceSelectMode ();

    inline void clear_has_AudprocSourceSelectMode ();

    inline void set_has_AudprocSourceId ();

    inline void clear_has_AudprocSourceId ();

    inline void set_has_AudprocAlsaDev ();

    inline void clear_has_AudprocAlsaDev ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint8 _AudprocSourceSelectMode;

    uint8 _AudprocSourceId;

    ::std::string _AudprocAlsaDev;

};

/**
 * If the meaning of "AplArkamysAvcActivateUpdate" isn't clear, then there should be a description here.
 */
class AplArkamysAvcActivateUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AplArkamysAvcActivateUpdate ();

    /**
     * Copy constructor
     */
    inline  AplArkamysAvcActivateUpdate (const AplArkamysAvcActivateUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  AplArkamysAvcActivateUpdate (int32 aplArkamysAvcActivate_);

    /**
     * Destructor
     */
    inline virtual  ~AplArkamysAvcActivateUpdate();

    /**
     * Assignment operator
     */
    inline AplArkamysAvcActivateUpdate& operator = (const AplArkamysAvcActivateUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AplArkamysAvcActivateUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AplArkamysAvcActivateUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AplArkamysAvcActivateUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AplArkamysAvcActivateUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "aplArkamysAvcActivate"

    static const int kAplArkamysAvcActivate = 0;

    /**
     * Clears the field "aplArkamysAvcActivate".
     *
     * The field will be set to its default value. The hasAplArkamysAvcActivate()
     * method will return false.
     */
    inline void clearAplArkamysAvcActivate();

    /**
     * Checks whether the field "aplArkamysAvcActivate" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAplArkamysAvcActivate()). Otherwise it will return false.
     */
    inline bool hasAplArkamysAvcActivate () const;

    /**
     * Returns the value of the member "aplArkamysAvcActivate".
     *
     * If the meaning of "aplArkamysAvcActivate" isn't clear, then there should be a description here.
     *
     * @return The value of the field "aplArkamysAvcActivate"
     */
    inline int32 getAplArkamysAvcActivate () const;

    /**
     * Sets the value of the member "aplArkamysAvcActivate".
     *
     * If the meaning of "aplArkamysAvcActivate" isn't clear, then there should be a description here.
     *
     * @param aplArkamysAvcActivate The value which will be set
     */
    inline void setAplArkamysAvcActivate (int32 aplArkamysAvcActivate_);

    static const AplArkamysAvcActivateUpdate &getDefaultInstance();

private:

    inline void set_has_aplArkamysAvcActivate ();

    inline void clear_has_aplArkamysAvcActivate ();

    uint32 _has_bits_[ (1 + 31) / 32];

    int32 _aplArkamysAvcActivate;

};

/**
 * If the meaning of "AplArkamysAvcActivateRegister" isn't clear, then there should be a description here.
 */
class AplArkamysAvcActivateRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AplArkamysAvcActivateRegister ();

    /**
     * Copy constructor
     */
    inline  AplArkamysAvcActivateRegister (const AplArkamysAvcActivateRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~AplArkamysAvcActivateRegister();

    /**
     * Assignment operator
     */
    inline AplArkamysAvcActivateRegister& operator = (const AplArkamysAvcActivateRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AplArkamysAvcActivateRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AplArkamysAvcActivateRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AplArkamysAvcActivateRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AplArkamysAvcActivateRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const AplArkamysAvcActivateRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "AplArkamysByPassActivateUpdate" isn't clear, then there should be a description here.
 */
class AplArkamysByPassActivateUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AplArkamysByPassActivateUpdate ();

    /**
     * Copy constructor
     */
    inline  AplArkamysByPassActivateUpdate (const AplArkamysByPassActivateUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  AplArkamysByPassActivateUpdate (int32 aplArkamysByPassActivate_);

    /**
     * Destructor
     */
    inline virtual  ~AplArkamysByPassActivateUpdate();

    /**
     * Assignment operator
     */
    inline AplArkamysByPassActivateUpdate& operator = (const AplArkamysByPassActivateUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AplArkamysByPassActivateUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AplArkamysByPassActivateUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AplArkamysByPassActivateUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AplArkamysByPassActivateUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "aplArkamysByPassActivate"

    static const int kAplArkamysByPassActivate = 0;

    /**
     * Clears the field "aplArkamysByPassActivate".
     *
     * The field will be set to its default value. The hasAplArkamysByPassActivate()
     * method will return false.
     */
    inline void clearAplArkamysByPassActivate();

    /**
     * Checks whether the field "aplArkamysByPassActivate" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAplArkamysByPassActivate()). Otherwise it will return false.
     */
    inline bool hasAplArkamysByPassActivate () const;

    /**
     * Returns the value of the member "aplArkamysByPassActivate".
     *
     * If the meaning of "aplArkamysByPassActivate" isn't clear, then there should be a description here.
     *
     * @return The value of the field "aplArkamysByPassActivate"
     */
    inline int32 getAplArkamysByPassActivate () const;

    /**
     * Sets the value of the member "aplArkamysByPassActivate".
     *
     * If the meaning of "aplArkamysByPassActivate" isn't clear, then there should be a description here.
     *
     * @param aplArkamysByPassActivate The value which will be set
     */
    inline void setAplArkamysByPassActivate (int32 aplArkamysByPassActivate_);

    static const AplArkamysByPassActivateUpdate &getDefaultInstance();

private:

    inline void set_has_aplArkamysByPassActivate ();

    inline void clear_has_aplArkamysByPassActivate ();

    uint32 _has_bits_[ (1 + 31) / 32];

    int32 _aplArkamysByPassActivate;

};

/**
 * If the meaning of "AplArkamysByPassActivateRegister" isn't clear, then there should be a description here.
 */
class AplArkamysByPassActivateRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AplArkamysByPassActivateRegister ();

    /**
     * Copy constructor
     */
    inline  AplArkamysByPassActivateRegister (const AplArkamysByPassActivateRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~AplArkamysByPassActivateRegister();

    /**
     * Assignment operator
     */
    inline AplArkamysByPassActivateRegister& operator = (const AplArkamysByPassActivateRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AplArkamysByPassActivateRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AplArkamysByPassActivateRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AplArkamysByPassActivateRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AplArkamysByPassActivateRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const AplArkamysByPassActivateRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "AplArkamysInputLevelDeviationUpdate" isn't clear, then there should be a description here.
 */
class AplArkamysInputLevelDeviationUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AplArkamysInputLevelDeviationUpdate ();

    /**
     * Copy constructor
     */
    inline  AplArkamysInputLevelDeviationUpdate (const AplArkamysInputLevelDeviationUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  AplArkamysInputLevelDeviationUpdate (int32 aplArkamysInputLevelDeviation_);

    /**
     * Destructor
     */
    inline virtual  ~AplArkamysInputLevelDeviationUpdate();

    /**
     * Assignment operator
     */
    inline AplArkamysInputLevelDeviationUpdate& operator = (const AplArkamysInputLevelDeviationUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AplArkamysInputLevelDeviationUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AplArkamysInputLevelDeviationUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AplArkamysInputLevelDeviationUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AplArkamysInputLevelDeviationUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "aplArkamysInputLevelDeviation"

    static const int kAplArkamysInputLevelDeviation = 0;

    /**
     * Clears the field "aplArkamysInputLevelDeviation".
     *
     * The field will be set to its default value. The hasAplArkamysInputLevelDeviation()
     * method will return false.
     */
    inline void clearAplArkamysInputLevelDeviation();

    /**
     * Checks whether the field "aplArkamysInputLevelDeviation" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAplArkamysInputLevelDeviation()). Otherwise it will return false.
     */
    inline bool hasAplArkamysInputLevelDeviation () const;

    /**
     * Returns the value of the member "aplArkamysInputLevelDeviation".
     *
     * If the meaning of "aplArkamysInputLevelDeviation" isn't clear, then there should be a description here.
     *
     * @return The value of the field "aplArkamysInputLevelDeviation"
     */
    inline int32 getAplArkamysInputLevelDeviation () const;

    /**
     * Sets the value of the member "aplArkamysInputLevelDeviation".
     *
     * If the meaning of "aplArkamysInputLevelDeviation" isn't clear, then there should be a description here.
     *
     * @param aplArkamysInputLevelDeviation The value which will be set
     */
    inline void setAplArkamysInputLevelDeviation (int32 aplArkamysInputLevelDeviation_);

    static const AplArkamysInputLevelDeviationUpdate &getDefaultInstance();

private:

    inline void set_has_aplArkamysInputLevelDeviation ();

    inline void clear_has_aplArkamysInputLevelDeviation ();

    uint32 _has_bits_[ (1 + 31) / 32];

    int32 _aplArkamysInputLevelDeviation;

};

/**
 * If the meaning of "AplArkamysInputLevelDeviationRegister" isn't clear, then there should be a description here.
 */
class AplArkamysInputLevelDeviationRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AplArkamysInputLevelDeviationRegister ();

    /**
     * Copy constructor
     */
    inline  AplArkamysInputLevelDeviationRegister (const AplArkamysInputLevelDeviationRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~AplArkamysInputLevelDeviationRegister();

    /**
     * Assignment operator
     */
    inline AplArkamysInputLevelDeviationRegister& operator = (const AplArkamysInputLevelDeviationRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AplArkamysInputLevelDeviationRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AplArkamysInputLevelDeviationRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AplArkamysInputLevelDeviationRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AplArkamysInputLevelDeviationRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const AplArkamysInputLevelDeviationRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "AplArkamysCurrentSpeedUpdate" isn't clear, then there should be a description here.
 */
class AplArkamysCurrentSpeedUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AplArkamysCurrentSpeedUpdate ();

    /**
     * Copy constructor
     */
    inline  AplArkamysCurrentSpeedUpdate (const AplArkamysCurrentSpeedUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  AplArkamysCurrentSpeedUpdate (int32 aplArkamysCurrentSpeed_);

    /**
     * Destructor
     */
    inline virtual  ~AplArkamysCurrentSpeedUpdate();

    /**
     * Assignment operator
     */
    inline AplArkamysCurrentSpeedUpdate& operator = (const AplArkamysCurrentSpeedUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AplArkamysCurrentSpeedUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AplArkamysCurrentSpeedUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AplArkamysCurrentSpeedUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AplArkamysCurrentSpeedUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "aplArkamysCurrentSpeed"

    static const int kAplArkamysCurrentSpeed = 0;

    /**
     * Clears the field "aplArkamysCurrentSpeed".
     *
     * The field will be set to its default value. The hasAplArkamysCurrentSpeed()
     * method will return false.
     */
    inline void clearAplArkamysCurrentSpeed();

    /**
     * Checks whether the field "aplArkamysCurrentSpeed" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAplArkamysCurrentSpeed()). Otherwise it will return false.
     */
    inline bool hasAplArkamysCurrentSpeed () const;

    /**
     * Returns the value of the member "aplArkamysCurrentSpeed".
     *
     * If the meaning of "aplArkamysCurrentSpeed" isn't clear, then there should be a description here.
     *
     * @return The value of the field "aplArkamysCurrentSpeed"
     */
    inline int32 getAplArkamysCurrentSpeed () const;

    /**
     * Sets the value of the member "aplArkamysCurrentSpeed".
     *
     * If the meaning of "aplArkamysCurrentSpeed" isn't clear, then there should be a description here.
     *
     * @param aplArkamysCurrentSpeed The value which will be set
     */
    inline void setAplArkamysCurrentSpeed (int32 aplArkamysCurrentSpeed_);

    static const AplArkamysCurrentSpeedUpdate &getDefaultInstance();

private:

    inline void set_has_aplArkamysCurrentSpeed ();

    inline void clear_has_aplArkamysCurrentSpeed ();

    uint32 _has_bits_[ (1 + 31) / 32];

    int32 _aplArkamysCurrentSpeed;

};

/**
 * If the meaning of "AplArkamysCurrentSpeedRegister" isn't clear, then there should be a description here.
 */
class AplArkamysCurrentSpeedRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AplArkamysCurrentSpeedRegister ();

    /**
     * Copy constructor
     */
    inline  AplArkamysCurrentSpeedRegister (const AplArkamysCurrentSpeedRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~AplArkamysCurrentSpeedRegister();

    /**
     * Assignment operator
     */
    inline AplArkamysCurrentSpeedRegister& operator = (const AplArkamysCurrentSpeedRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AplArkamysCurrentSpeedRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AplArkamysCurrentSpeedRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AplArkamysCurrentSpeedRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AplArkamysCurrentSpeedRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const AplArkamysCurrentSpeedRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "AplArkamysCurrentVolumeStepUpdate" isn't clear, then there should be a description here.
 */
class AplArkamysCurrentVolumeStepUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AplArkamysCurrentVolumeStepUpdate ();

    /**
     * Copy constructor
     */
    inline  AplArkamysCurrentVolumeStepUpdate (const AplArkamysCurrentVolumeStepUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  AplArkamysCurrentVolumeStepUpdate (int32 aplArkamysCurrentVolumeStep_);

    /**
     * Destructor
     */
    inline virtual  ~AplArkamysCurrentVolumeStepUpdate();

    /**
     * Assignment operator
     */
    inline AplArkamysCurrentVolumeStepUpdate& operator = (const AplArkamysCurrentVolumeStepUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AplArkamysCurrentVolumeStepUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AplArkamysCurrentVolumeStepUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AplArkamysCurrentVolumeStepUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AplArkamysCurrentVolumeStepUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "aplArkamysCurrentVolumeStep"

    static const int kAplArkamysCurrentVolumeStep = 0;

    /**
     * Clears the field "aplArkamysCurrentVolumeStep".
     *
     * The field will be set to its default value. The hasAplArkamysCurrentVolumeStep()
     * method will return false.
     */
    inline void clearAplArkamysCurrentVolumeStep();

    /**
     * Checks whether the field "aplArkamysCurrentVolumeStep" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAplArkamysCurrentVolumeStep()). Otherwise it will return false.
     */
    inline bool hasAplArkamysCurrentVolumeStep () const;

    /**
     * Returns the value of the member "aplArkamysCurrentVolumeStep".
     *
     * If the meaning of "aplArkamysCurrentVolumeStep" isn't clear, then there should be a description here.
     *
     * @return The value of the field "aplArkamysCurrentVolumeStep"
     */
    inline int32 getAplArkamysCurrentVolumeStep () const;

    /**
     * Sets the value of the member "aplArkamysCurrentVolumeStep".
     *
     * If the meaning of "aplArkamysCurrentVolumeStep" isn't clear, then there should be a description here.
     *
     * @param aplArkamysCurrentVolumeStep The value which will be set
     */
    inline void setAplArkamysCurrentVolumeStep (int32 aplArkamysCurrentVolumeStep_);

    static const AplArkamysCurrentVolumeStepUpdate &getDefaultInstance();

private:

    inline void set_has_aplArkamysCurrentVolumeStep ();

    inline void clear_has_aplArkamysCurrentVolumeStep ();

    uint32 _has_bits_[ (1 + 31) / 32];

    int32 _aplArkamysCurrentVolumeStep;

};

/**
 * If the meaning of "AplArkamysCurrentVolumeStepRegister" isn't clear, then there should be a description here.
 */
class AplArkamysCurrentVolumeStepRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AplArkamysCurrentVolumeStepRegister ();

    /**
     * Copy constructor
     */
    inline  AplArkamysCurrentVolumeStepRegister (const AplArkamysCurrentVolumeStepRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~AplArkamysCurrentVolumeStepRegister();

    /**
     * Assignment operator
     */
    inline AplArkamysCurrentVolumeStepRegister& operator = (const AplArkamysCurrentVolumeStepRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AplArkamysCurrentVolumeStepRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AplArkamysCurrentVolumeStepRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AplArkamysCurrentVolumeStepRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AplArkamysCurrentVolumeStepRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const AplArkamysCurrentVolumeStepRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "AplArkamysAmbienceSelectUpdate" isn't clear, then there should be a description here.
 */
class AplArkamysAmbienceSelectUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AplArkamysAmbienceSelectUpdate ();

    /**
     * Copy constructor
     */
    inline  AplArkamysAmbienceSelectUpdate (const AplArkamysAmbienceSelectUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  AplArkamysAmbienceSelectUpdate (int32 aplArkamysAmbienceSelect_);

    /**
     * Destructor
     */
    inline virtual  ~AplArkamysAmbienceSelectUpdate();

    /**
     * Assignment operator
     */
    inline AplArkamysAmbienceSelectUpdate& operator = (const AplArkamysAmbienceSelectUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AplArkamysAmbienceSelectUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AplArkamysAmbienceSelectUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AplArkamysAmbienceSelectUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AplArkamysAmbienceSelectUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "aplArkamysAmbienceSelect"

    static const int kAplArkamysAmbienceSelect = 0;

    /**
     * Clears the field "aplArkamysAmbienceSelect".
     *
     * The field will be set to its default value. The hasAplArkamysAmbienceSelect()
     * method will return false.
     */
    inline void clearAplArkamysAmbienceSelect();

    /**
     * Checks whether the field "aplArkamysAmbienceSelect" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAplArkamysAmbienceSelect()). Otherwise it will return false.
     */
    inline bool hasAplArkamysAmbienceSelect () const;

    /**
     * Returns the value of the member "aplArkamysAmbienceSelect".
     *
     * If the meaning of "aplArkamysAmbienceSelect" isn't clear, then there should be a description here.
     *
     * @return The value of the field "aplArkamysAmbienceSelect"
     */
    inline int32 getAplArkamysAmbienceSelect () const;

    /**
     * Sets the value of the member "aplArkamysAmbienceSelect".
     *
     * If the meaning of "aplArkamysAmbienceSelect" isn't clear, then there should be a description here.
     *
     * @param aplArkamysAmbienceSelect The value which will be set
     */
    inline void setAplArkamysAmbienceSelect (int32 aplArkamysAmbienceSelect_);

    static const AplArkamysAmbienceSelectUpdate &getDefaultInstance();

private:

    inline void set_has_aplArkamysAmbienceSelect ();

    inline void clear_has_aplArkamysAmbienceSelect ();

    uint32 _has_bits_[ (1 + 31) / 32];

    int32 _aplArkamysAmbienceSelect;

};

/**
 * If the meaning of "AplArkamysAmbienceSelectRegister" isn't clear, then there should be a description here.
 */
class AplArkamysAmbienceSelectRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AplArkamysAmbienceSelectRegister ();

    /**
     * Copy constructor
     */
    inline  AplArkamysAmbienceSelectRegister (const AplArkamysAmbienceSelectRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~AplArkamysAmbienceSelectRegister();

    /**
     * Assignment operator
     */
    inline AplArkamysAmbienceSelectRegister& operator = (const AplArkamysAmbienceSelectRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AplArkamysAmbienceSelectRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AplArkamysAmbienceSelectRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AplArkamysAmbienceSelectRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AplArkamysAmbienceSelectRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const AplArkamysAmbienceSelectRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "AplArkamysLevelLossUpdate" isn't clear, then there should be a description here.
 */
class AplArkamysLevelLossUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AplArkamysLevelLossUpdate ();

    /**
     * Copy constructor
     */
    inline  AplArkamysLevelLossUpdate (const AplArkamysLevelLossUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  AplArkamysLevelLossUpdate (int32 aplArkamysLevelLoss_);

    /**
     * Destructor
     */
    inline virtual  ~AplArkamysLevelLossUpdate();

    /**
     * Assignment operator
     */
    inline AplArkamysLevelLossUpdate& operator = (const AplArkamysLevelLossUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AplArkamysLevelLossUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AplArkamysLevelLossUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AplArkamysLevelLossUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AplArkamysLevelLossUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "aplArkamysLevelLoss"

    static const int kAplArkamysLevelLoss = 0;

    /**
     * Clears the field "aplArkamysLevelLoss".
     *
     * The field will be set to its default value. The hasAplArkamysLevelLoss()
     * method will return false.
     */
    inline void clearAplArkamysLevelLoss();

    /**
     * Checks whether the field "aplArkamysLevelLoss" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAplArkamysLevelLoss()). Otherwise it will return false.
     */
    inline bool hasAplArkamysLevelLoss () const;

    /**
     * Returns the value of the member "aplArkamysLevelLoss".
     *
     * If the meaning of "aplArkamysLevelLoss" isn't clear, then there should be a description here.
     *
     * @return The value of the field "aplArkamysLevelLoss"
     */
    inline int32 getAplArkamysLevelLoss () const;

    /**
     * Sets the value of the member "aplArkamysLevelLoss".
     *
     * If the meaning of "aplArkamysLevelLoss" isn't clear, then there should be a description here.
     *
     * @param aplArkamysLevelLoss The value which will be set
     */
    inline void setAplArkamysLevelLoss (int32 aplArkamysLevelLoss_);

    static const AplArkamysLevelLossUpdate &getDefaultInstance();

private:

    inline void set_has_aplArkamysLevelLoss ();

    inline void clear_has_aplArkamysLevelLoss ();

    uint32 _has_bits_[ (1 + 31) / 32];

    int32 _aplArkamysLevelLoss;

};

/**
 * If the meaning of "AplArkamysLevelLossRegister" isn't clear, then there should be a description here.
 */
class AplArkamysLevelLossRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AplArkamysLevelLossRegister ();

    /**
     * Copy constructor
     */
    inline  AplArkamysLevelLossRegister (const AplArkamysLevelLossRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~AplArkamysLevelLossRegister();

    /**
     * Assignment operator
     */
    inline AplArkamysLevelLossRegister& operator = (const AplArkamysLevelLossRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AplArkamysLevelLossRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AplArkamysLevelLossRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AplArkamysLevelLossRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AplArkamysLevelLossRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const AplArkamysLevelLossRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "AplArkamysLibraryVersionUpdate" isn't clear, then there should be a description here.
 */
class AplArkamysLibraryVersionUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AplArkamysLibraryVersionUpdate ();

    /**
     * Copy constructor
     */
    inline  AplArkamysLibraryVersionUpdate (const AplArkamysLibraryVersionUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  AplArkamysLibraryVersionUpdate (const ::std::vector< int32 >& aplArkamysLibraryVersion_);

    /**
     * Destructor
     */
    inline virtual  ~AplArkamysLibraryVersionUpdate();

    /**
     * Assignment operator
     */
    inline AplArkamysLibraryVersionUpdate& operator = (const AplArkamysLibraryVersionUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AplArkamysLibraryVersionUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AplArkamysLibraryVersionUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AplArkamysLibraryVersionUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AplArkamysLibraryVersionUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "aplArkamysLibraryVersion"

    static const int kAplArkamysLibraryVersion = 0;

    /**
     * Clears the field "aplArkamysLibraryVersion".
     *
     * The field will be set to its default value. The hasAplArkamysLibraryVersion()
     * method will return false.
     */
    inline void clearAplArkamysLibraryVersion();

    /**
     * Checks whether the field "aplArkamysLibraryVersion" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAplArkamysLibraryVersion()). Otherwise it will return false.
     */
    inline bool hasAplArkamysLibraryVersion () const;

    /**
     * Returns the value of the member "aplArkamysLibraryVersion".
     *
     * If the meaning of "aplArkamysLibraryVersion" isn't clear, then there should be a description here.
     *
     * @return The value of the field "aplArkamysLibraryVersion"
     */
    inline const ::std::vector< int32 >& getAplArkamysLibraryVersion () const;

    /**
     * Retrieves the value of the field "aplArkamysLibraryVersion" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "aplArkamysLibraryVersion".
     */
    inline ::std::vector< int32 >& getAplArkamysLibraryVersionMutable ();

    /**
     * Sets the value of the member "aplArkamysLibraryVersion".
     *
     * If the meaning of "aplArkamysLibraryVersion" isn't clear, then there should be a description here.
     *
     * @param aplArkamysLibraryVersion The value which will be set
     */
    inline void setAplArkamysLibraryVersion (const ::std::vector< int32 >& aplArkamysLibraryVersion_);

    static const AplArkamysLibraryVersionUpdate &getDefaultInstance();

private:

    static const ::std::vector< int32 >& getInt32List_DefaultInstance ();

    inline void set_has_aplArkamysLibraryVersion ();

    inline void clear_has_aplArkamysLibraryVersion ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< int32 > _aplArkamysLibraryVersion;

};

/**
 * If the meaning of "AplArkamysLibraryVersionRegister" isn't clear, then there should be a description here.
 */
class AplArkamysLibraryVersionRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AplArkamysLibraryVersionRegister ();

    /**
     * Copy constructor
     */
    inline  AplArkamysLibraryVersionRegister (const AplArkamysLibraryVersionRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~AplArkamysLibraryVersionRegister();

    /**
     * Assignment operator
     */
    inline AplArkamysLibraryVersionRegister& operator = (const AplArkamysLibraryVersionRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AplArkamysLibraryVersionRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AplArkamysLibraryVersionRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AplArkamysLibraryVersionRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AplArkamysLibraryVersionRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const AplArkamysLibraryVersionRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "AplArkamysCurrVolAttenuationUpdate" isn't clear, then there should be a description here.
 */
class AplArkamysCurrVolAttenuationUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AplArkamysCurrVolAttenuationUpdate ();

    /**
     * Copy constructor
     */
    inline  AplArkamysCurrVolAttenuationUpdate (const AplArkamysCurrVolAttenuationUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  AplArkamysCurrVolAttenuationUpdate (int32 aplArkamysCurrVolAttenuation_);

    /**
     * Destructor
     */
    inline virtual  ~AplArkamysCurrVolAttenuationUpdate();

    /**
     * Assignment operator
     */
    inline AplArkamysCurrVolAttenuationUpdate& operator = (const AplArkamysCurrVolAttenuationUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AplArkamysCurrVolAttenuationUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AplArkamysCurrVolAttenuationUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AplArkamysCurrVolAttenuationUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AplArkamysCurrVolAttenuationUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "aplArkamysCurrVolAttenuation"

    static const int kAplArkamysCurrVolAttenuation = 0;

    /**
     * Clears the field "aplArkamysCurrVolAttenuation".
     *
     * The field will be set to its default value. The hasAplArkamysCurrVolAttenuation()
     * method will return false.
     */
    inline void clearAplArkamysCurrVolAttenuation();

    /**
     * Checks whether the field "aplArkamysCurrVolAttenuation" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAplArkamysCurrVolAttenuation()). Otherwise it will return false.
     */
    inline bool hasAplArkamysCurrVolAttenuation () const;

    /**
     * Returns the value of the member "aplArkamysCurrVolAttenuation".
     *
     * If the meaning of "aplArkamysCurrVolAttenuation" isn't clear, then there should be a description here.
     *
     * @return The value of the field "aplArkamysCurrVolAttenuation"
     */
    inline int32 getAplArkamysCurrVolAttenuation () const;

    /**
     * Sets the value of the member "aplArkamysCurrVolAttenuation".
     *
     * If the meaning of "aplArkamysCurrVolAttenuation" isn't clear, then there should be a description here.
     *
     * @param aplArkamysCurrVolAttenuation The value which will be set
     */
    inline void setAplArkamysCurrVolAttenuation (int32 aplArkamysCurrVolAttenuation_);

    static const AplArkamysCurrVolAttenuationUpdate &getDefaultInstance();

private:

    inline void set_has_aplArkamysCurrVolAttenuation ();

    inline void clear_has_aplArkamysCurrVolAttenuation ();

    uint32 _has_bits_[ (1 + 31) / 32];

    int32 _aplArkamysCurrVolAttenuation;

};

/**
 * If the meaning of "AplArkamysCurrVolAttenuationRegister" isn't clear, then there should be a description here.
 */
class AplArkamysCurrVolAttenuationRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AplArkamysCurrVolAttenuationRegister ();

    /**
     * Copy constructor
     */
    inline  AplArkamysCurrVolAttenuationRegister (const AplArkamysCurrVolAttenuationRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~AplArkamysCurrVolAttenuationRegister();

    /**
     * Assignment operator
     */
    inline AplArkamysCurrVolAttenuationRegister& operator = (const AplArkamysCurrVolAttenuationRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AplArkamysCurrVolAttenuationRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AplArkamysCurrVolAttenuationRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AplArkamysCurrVolAttenuationRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AplArkamysCurrVolAttenuationRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const AplArkamysCurrVolAttenuationRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "AplArkamysFlushUpdate" isn't clear, then there should be a description here.
 */
class AplArkamysFlushUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AplArkamysFlushUpdate ();

    /**
     * Copy constructor
     */
    inline  AplArkamysFlushUpdate (const AplArkamysFlushUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  AplArkamysFlushUpdate (int32 aplArkamysFlush_);

    /**
     * Destructor
     */
    inline virtual  ~AplArkamysFlushUpdate();

    /**
     * Assignment operator
     */
    inline AplArkamysFlushUpdate& operator = (const AplArkamysFlushUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AplArkamysFlushUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AplArkamysFlushUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AplArkamysFlushUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AplArkamysFlushUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "aplArkamysFlush"

    static const int kAplArkamysFlush = 0;

    /**
     * Clears the field "aplArkamysFlush".
     *
     * The field will be set to its default value. The hasAplArkamysFlush()
     * method will return false.
     */
    inline void clearAplArkamysFlush();

    /**
     * Checks whether the field "aplArkamysFlush" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAplArkamysFlush()). Otherwise it will return false.
     */
    inline bool hasAplArkamysFlush () const;

    /**
     * Returns the value of the member "aplArkamysFlush".
     *
     * If the meaning of "aplArkamysFlush" isn't clear, then there should be a description here.
     *
     * @return The value of the field "aplArkamysFlush"
     */
    inline int32 getAplArkamysFlush () const;

    /**
     * Sets the value of the member "aplArkamysFlush".
     *
     * If the meaning of "aplArkamysFlush" isn't clear, then there should be a description here.
     *
     * @param aplArkamysFlush The value which will be set
     */
    inline void setAplArkamysFlush (int32 aplArkamysFlush_);

    static const AplArkamysFlushUpdate &getDefaultInstance();

private:

    inline void set_has_aplArkamysFlush ();

    inline void clear_has_aplArkamysFlush ();

    uint32 _has_bits_[ (1 + 31) / 32];

    int32 _aplArkamysFlush;

};

/**
 * If the meaning of "AplArkamysFlushRegister" isn't clear, then there should be a description here.
 */
class AplArkamysFlushRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AplArkamysFlushRegister ();

    /**
     * Copy constructor
     */
    inline  AplArkamysFlushRegister (const AplArkamysFlushRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~AplArkamysFlushRegister();

    /**
     * Assignment operator
     */
    inline AplArkamysFlushRegister& operator = (const AplArkamysFlushRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AplArkamysFlushRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AplArkamysFlushRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AplArkamysFlushRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AplArkamysFlushRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const AplArkamysFlushRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "AplMicLvlWatchRefIntUpdate" isn't clear, then there should be a description here.
 */
class AplMicLvlWatchRefIntUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AplMicLvlWatchRefIntUpdate ();

    /**
     * Copy constructor
     */
    inline  AplMicLvlWatchRefIntUpdate (const AplMicLvlWatchRefIntUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  AplMicLvlWatchRefIntUpdate (uint32 aplMicLvlWatchRefInt_);

    /**
     * Destructor
     */
    inline virtual  ~AplMicLvlWatchRefIntUpdate();

    /**
     * Assignment operator
     */
    inline AplMicLvlWatchRefIntUpdate& operator = (const AplMicLvlWatchRefIntUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AplMicLvlWatchRefIntUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AplMicLvlWatchRefIntUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AplMicLvlWatchRefIntUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AplMicLvlWatchRefIntUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "aplMicLvlWatchRefInt"

    static const int kAplMicLvlWatchRefInt = 0;

    /**
     * Clears the field "aplMicLvlWatchRefInt".
     *
     * The field will be set to its default value. The hasAplMicLvlWatchRefInt()
     * method will return false.
     */
    inline void clearAplMicLvlWatchRefInt();

    /**
     * Checks whether the field "aplMicLvlWatchRefInt" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAplMicLvlWatchRefInt()). Otherwise it will return false.
     */
    inline bool hasAplMicLvlWatchRefInt () const;

    /**
     * Returns the value of the member "aplMicLvlWatchRefInt".
     *
     * If the meaning of "aplMicLvlWatchRefInt" isn't clear, then there should be a description here.
     *
     * @return The value of the field "aplMicLvlWatchRefInt"
     */
    inline uint32 getAplMicLvlWatchRefInt () const;

    /**
     * Sets the value of the member "aplMicLvlWatchRefInt".
     *
     * If the meaning of "aplMicLvlWatchRefInt" isn't clear, then there should be a description here.
     *
     * @param aplMicLvlWatchRefInt The value which will be set
     */
    inline void setAplMicLvlWatchRefInt (uint32 aplMicLvlWatchRefInt_);

    static const AplMicLvlWatchRefIntUpdate &getDefaultInstance();

private:

    inline void set_has_aplMicLvlWatchRefInt ();

    inline void clear_has_aplMicLvlWatchRefInt ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _aplMicLvlWatchRefInt;

};

/**
 * If the meaning of "AplMicLvlWatchRefIntRegister" isn't clear, then there should be a description here.
 */
class AplMicLvlWatchRefIntRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AplMicLvlWatchRefIntRegister ();

    /**
     * Copy constructor
     */
    inline  AplMicLvlWatchRefIntRegister (const AplMicLvlWatchRefIntRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~AplMicLvlWatchRefIntRegister();

    /**
     * Assignment operator
     */
    inline AplMicLvlWatchRefIntRegister& operator = (const AplMicLvlWatchRefIntRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AplMicLvlWatchRefIntRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AplMicLvlWatchRefIntRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AplMicLvlWatchRefIntRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AplMicLvlWatchRefIntRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const AplMicLvlWatchRefIntRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "AplMicLvlUpdate" isn't clear, then there should be a description here.
 */
class AplMicLvlUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AplMicLvlUpdate ();

    /**
     * Copy constructor
     */
    inline  AplMicLvlUpdate (const AplMicLvlUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  AplMicLvlUpdate (int32 aplMicLvl_);

    /**
     * Destructor
     */
    inline virtual  ~AplMicLvlUpdate();

    /**
     * Assignment operator
     */
    inline AplMicLvlUpdate& operator = (const AplMicLvlUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AplMicLvlUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AplMicLvlUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AplMicLvlUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AplMicLvlUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "aplMicLvl"

    static const int kAplMicLvl = 0;

    /**
     * Clears the field "aplMicLvl".
     *
     * The field will be set to its default value. The hasAplMicLvl()
     * method will return false.
     */
    inline void clearAplMicLvl();

    /**
     * Checks whether the field "aplMicLvl" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAplMicLvl()). Otherwise it will return false.
     */
    inline bool hasAplMicLvl () const;

    /**
     * Returns the value of the member "aplMicLvl".
     *
     * If the meaning of "aplMicLvl" isn't clear, then there should be a description here.
     *
     * @return The value of the field "aplMicLvl"
     */
    inline int32 getAplMicLvl () const;

    /**
     * Sets the value of the member "aplMicLvl".
     *
     * If the meaning of "aplMicLvl" isn't clear, then there should be a description here.
     *
     * @param aplMicLvl The value which will be set
     */
    inline void setAplMicLvl (int32 aplMicLvl_);

    static const AplMicLvlUpdate &getDefaultInstance();

private:

    inline void set_has_aplMicLvl ();

    inline void clear_has_aplMicLvl ();

    uint32 _has_bits_[ (1 + 31) / 32];

    int32 _aplMicLvl;

};

/**
 * If the meaning of "AplMicLvlRegister" isn't clear, then there should be a description here.
 */
class AplMicLvlRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AplMicLvlRegister ();

    /**
     * Copy constructor
     */
    inline  AplMicLvlRegister (const AplMicLvlRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~AplMicLvlRegister();

    /**
     * Assignment operator
     */
    inline AplMicLvlRegister& operator = (const AplMicLvlRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AplMicLvlRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AplMicLvlRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AplMicLvlRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AplMicLvlRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const AplMicLvlRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "AplAudioModeUpdate" isn't clear, then there should be a description here.
 */
class AplAudioModeUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AplAudioModeUpdate ();

    /**
     * Copy constructor
     */
    inline  AplAudioModeUpdate (const AplAudioModeUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  AplAudioModeUpdate (int32 aplAudioMode_);

    /**
     * Destructor
     */
    inline virtual  ~AplAudioModeUpdate();

    /**
     * Assignment operator
     */
    inline AplAudioModeUpdate& operator = (const AplAudioModeUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AplAudioModeUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AplAudioModeUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AplAudioModeUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AplAudioModeUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "aplAudioMode"

    static const int kAplAudioMode = 0;

    /**
     * Clears the field "aplAudioMode".
     *
     * The field will be set to its default value. The hasAplAudioMode()
     * method will return false.
     */
    inline void clearAplAudioMode();

    /**
     * Checks whether the field "aplAudioMode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAplAudioMode()). Otherwise it will return false.
     */
    inline bool hasAplAudioMode () const;

    /**
     * Returns the value of the member "aplAudioMode".
     *
     * If the meaning of "aplAudioMode" isn't clear, then there should be a description here.
     *
     * @return The value of the field "aplAudioMode"
     */
    inline int32 getAplAudioMode () const;

    /**
     * Sets the value of the member "aplAudioMode".
     *
     * If the meaning of "aplAudioMode" isn't clear, then there should be a description here.
     *
     * @param aplAudioMode The value which will be set
     */
    inline void setAplAudioMode (int32 aplAudioMode_);

    static const AplAudioModeUpdate &getDefaultInstance();

private:

    inline void set_has_aplAudioMode ();

    inline void clear_has_aplAudioMode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    int32 _aplAudioMode;

};

/**
 * If the meaning of "AplAudioModeRegister" isn't clear, then there should be a description here.
 */
class AplAudioModeRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AplAudioModeRegister ();

    /**
     * Copy constructor
     */
    inline  AplAudioModeRegister (const AplAudioModeRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~AplAudioModeRegister();

    /**
     * Assignment operator
     */
    inline AplAudioModeRegister& operator = (const AplAudioModeRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AplAudioModeRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AplAudioModeRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AplAudioModeRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AplAudioModeRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const AplAudioModeRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "AplLoopbackActivateUpdate" isn't clear, then there should be a description here.
 */
class AplLoopbackActivateUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AplLoopbackActivateUpdate ();

    /**
     * Copy constructor
     */
    inline  AplLoopbackActivateUpdate (const AplLoopbackActivateUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  AplLoopbackActivateUpdate (int32 aplLoopbackActivate_);

    /**
     * Destructor
     */
    inline virtual  ~AplLoopbackActivateUpdate();

    /**
     * Assignment operator
     */
    inline AplLoopbackActivateUpdate& operator = (const AplLoopbackActivateUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AplLoopbackActivateUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AplLoopbackActivateUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AplLoopbackActivateUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AplLoopbackActivateUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "aplLoopbackActivate"

    static const int kAplLoopbackActivate = 0;

    /**
     * Clears the field "aplLoopbackActivate".
     *
     * The field will be set to its default value. The hasAplLoopbackActivate()
     * method will return false.
     */
    inline void clearAplLoopbackActivate();

    /**
     * Checks whether the field "aplLoopbackActivate" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAplLoopbackActivate()). Otherwise it will return false.
     */
    inline bool hasAplLoopbackActivate () const;

    /**
     * Returns the value of the member "aplLoopbackActivate".
     *
     * If the meaning of "aplLoopbackActivate" isn't clear, then there should be a description here.
     *
     * @return The value of the field "aplLoopbackActivate"
     */
    inline int32 getAplLoopbackActivate () const;

    /**
     * Sets the value of the member "aplLoopbackActivate".
     *
     * If the meaning of "aplLoopbackActivate" isn't clear, then there should be a description here.
     *
     * @param aplLoopbackActivate The value which will be set
     */
    inline void setAplLoopbackActivate (int32 aplLoopbackActivate_);

    static const AplLoopbackActivateUpdate &getDefaultInstance();

private:

    inline void set_has_aplLoopbackActivate ();

    inline void clear_has_aplLoopbackActivate ();

    uint32 _has_bits_[ (1 + 31) / 32];

    int32 _aplLoopbackActivate;

};

/**
 * If the meaning of "AplLoopbackActivateRegister" isn't clear, then there should be a description here.
 */
class AplLoopbackActivateRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AplLoopbackActivateRegister ();

    /**
     * Copy constructor
     */
    inline  AplLoopbackActivateRegister (const AplLoopbackActivateRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~AplLoopbackActivateRegister();

    /**
     * Assignment operator
     */
    inline AplLoopbackActivateRegister& operator = (const AplLoopbackActivateRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AplLoopbackActivateRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AplLoopbackActivateRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AplLoopbackActivateRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AplLoopbackActivateRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const AplLoopbackActivateRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "AudprocStatusSignal" isn't clear, then there should be a description here.
 */
class AudprocStatusSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AudprocStatusSignal ();

    /**
     * Copy constructor
     */
    inline  AudprocStatusSignal (const AudprocStatusSignal &rhs);

    /**
     * All fields constructor
     */
    inline  AudprocStatusSignal (uint8 statusEntSrcEnum_, uint8 statusEntSrcActiveState_, uint8 statusVoiceSrcEnum_, uint8 statusVoiceSrcActiveState_, uint8 statusInfoSrcEnum_, uint8 statusinfoSrcActiveState_);

    /**
     * Destructor
     */
    inline virtual  ~AudprocStatusSignal();

    /**
     * Assignment operator
     */
    inline AudprocStatusSignal& operator = (const AudprocStatusSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AudprocStatusSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AudprocStatusSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AudprocStatusSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AudprocStatusSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "statusEntSrcEnum"

    static const int kStatusEntSrcEnum = 0;

    /**
     * Clears the field "statusEntSrcEnum".
     *
     * The field will be set to its default value. The hasStatusEntSrcEnum()
     * method will return false.
     */
    inline void clearStatusEntSrcEnum();

    /**
     * Checks whether the field "statusEntSrcEnum" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatusEntSrcEnum()). Otherwise it will return false.
     */
    inline bool hasStatusEntSrcEnum () const;

    /**
     * Returns the value of the member "statusEntSrcEnum".
     *
     * If the meaning of "statusEntSrcEnum" isn't clear, then there should be a description here.
     *
     * @return The value of the field "statusEntSrcEnum"
     */
    inline uint8 getStatusEntSrcEnum () const;

    /**
     * Sets the value of the member "statusEntSrcEnum".
     *
     * If the meaning of "statusEntSrcEnum" isn't clear, then there should be a description here.
     *
     * @param statusEntSrcEnum The value which will be set
     */
    inline void setStatusEntSrcEnum (uint8 statusEntSrcEnum_);

    // API of field "statusEntSrcActiveState"

    static const int kStatusEntSrcActiveState = 1;

    /**
     * Clears the field "statusEntSrcActiveState".
     *
     * The field will be set to its default value. The hasStatusEntSrcActiveState()
     * method will return false.
     */
    inline void clearStatusEntSrcActiveState();

    /**
     * Checks whether the field "statusEntSrcActiveState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatusEntSrcActiveState()). Otherwise it will return false.
     */
    inline bool hasStatusEntSrcActiveState () const;

    /**
     * Returns the value of the member "statusEntSrcActiveState".
     *
     * If the meaning of "statusEntSrcActiveState" isn't clear, then there should be a description here.
     *
     * @return The value of the field "statusEntSrcActiveState"
     */
    inline uint8 getStatusEntSrcActiveState () const;

    /**
     * Sets the value of the member "statusEntSrcActiveState".
     *
     * If the meaning of "statusEntSrcActiveState" isn't clear, then there should be a description here.
     *
     * @param statusEntSrcActiveState The value which will be set
     */
    inline void setStatusEntSrcActiveState (uint8 statusEntSrcActiveState_);

    // API of field "statusVoiceSrcEnum"

    static const int kStatusVoiceSrcEnum = 2;

    /**
     * Clears the field "statusVoiceSrcEnum".
     *
     * The field will be set to its default value. The hasStatusVoiceSrcEnum()
     * method will return false.
     */
    inline void clearStatusVoiceSrcEnum();

    /**
     * Checks whether the field "statusVoiceSrcEnum" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatusVoiceSrcEnum()). Otherwise it will return false.
     */
    inline bool hasStatusVoiceSrcEnum () const;

    /**
     * Returns the value of the member "statusVoiceSrcEnum".
     *
     * If the meaning of "statusVoiceSrcEnum" isn't clear, then there should be a description here.
     *
     * @return The value of the field "statusVoiceSrcEnum"
     */
    inline uint8 getStatusVoiceSrcEnum () const;

    /**
     * Sets the value of the member "statusVoiceSrcEnum".
     *
     * If the meaning of "statusVoiceSrcEnum" isn't clear, then there should be a description here.
     *
     * @param statusVoiceSrcEnum The value which will be set
     */
    inline void setStatusVoiceSrcEnum (uint8 statusVoiceSrcEnum_);

    // API of field "statusVoiceSrcActiveState"

    static const int kStatusVoiceSrcActiveState = 3;

    /**
     * Clears the field "statusVoiceSrcActiveState".
     *
     * The field will be set to its default value. The hasStatusVoiceSrcActiveState()
     * method will return false.
     */
    inline void clearStatusVoiceSrcActiveState();

    /**
     * Checks whether the field "statusVoiceSrcActiveState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatusVoiceSrcActiveState()). Otherwise it will return false.
     */
    inline bool hasStatusVoiceSrcActiveState () const;

    /**
     * Returns the value of the member "statusVoiceSrcActiveState".
     *
     * If the meaning of "statusVoiceSrcActiveState" isn't clear, then there should be a description here.
     *
     * @return The value of the field "statusVoiceSrcActiveState"
     */
    inline uint8 getStatusVoiceSrcActiveState () const;

    /**
     * Sets the value of the member "statusVoiceSrcActiveState".
     *
     * If the meaning of "statusVoiceSrcActiveState" isn't clear, then there should be a description here.
     *
     * @param statusVoiceSrcActiveState The value which will be set
     */
    inline void setStatusVoiceSrcActiveState (uint8 statusVoiceSrcActiveState_);

    // API of field "statusInfoSrcEnum"

    static const int kStatusInfoSrcEnum = 4;

    /**
     * Clears the field "statusInfoSrcEnum".
     *
     * The field will be set to its default value. The hasStatusInfoSrcEnum()
     * method will return false.
     */
    inline void clearStatusInfoSrcEnum();

    /**
     * Checks whether the field "statusInfoSrcEnum" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatusInfoSrcEnum()). Otherwise it will return false.
     */
    inline bool hasStatusInfoSrcEnum () const;

    /**
     * Returns the value of the member "statusInfoSrcEnum".
     *
     * If the meaning of "statusInfoSrcEnum" isn't clear, then there should be a description here.
     *
     * @return The value of the field "statusInfoSrcEnum"
     */
    inline uint8 getStatusInfoSrcEnum () const;

    /**
     * Sets the value of the member "statusInfoSrcEnum".
     *
     * If the meaning of "statusInfoSrcEnum" isn't clear, then there should be a description here.
     *
     * @param statusInfoSrcEnum The value which will be set
     */
    inline void setStatusInfoSrcEnum (uint8 statusInfoSrcEnum_);

    // API of field "statusinfoSrcActiveState"

    static const int kStatusinfoSrcActiveState = 5;

    /**
     * Clears the field "statusinfoSrcActiveState".
     *
     * The field will be set to its default value. The hasStatusinfoSrcActiveState()
     * method will return false.
     */
    inline void clearStatusinfoSrcActiveState();

    /**
     * Checks whether the field "statusinfoSrcActiveState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatusinfoSrcActiveState()). Otherwise it will return false.
     */
    inline bool hasStatusinfoSrcActiveState () const;

    /**
     * Returns the value of the member "statusinfoSrcActiveState".
     *
     * If the meaning of "statusinfoSrcActiveState" isn't clear, then there should be a description here.
     *
     * @return The value of the field "statusinfoSrcActiveState"
     */
    inline uint8 getStatusinfoSrcActiveState () const;

    /**
     * Sets the value of the member "statusinfoSrcActiveState".
     *
     * If the meaning of "statusinfoSrcActiveState" isn't clear, then there should be a description here.
     *
     * @param statusinfoSrcActiveState The value which will be set
     */
    inline void setStatusinfoSrcActiveState (uint8 statusinfoSrcActiveState_);

    static const AudprocStatusSignal &getDefaultInstance();

private:

    inline void set_has_statusEntSrcEnum ();

    inline void clear_has_statusEntSrcEnum ();

    inline void set_has_statusEntSrcActiveState ();

    inline void clear_has_statusEntSrcActiveState ();

    inline void set_has_statusVoiceSrcEnum ();

    inline void clear_has_statusVoiceSrcEnum ();

    inline void set_has_statusVoiceSrcActiveState ();

    inline void clear_has_statusVoiceSrcActiveState ();

    inline void set_has_statusInfoSrcEnum ();

    inline void clear_has_statusInfoSrcEnum ();

    inline void set_has_statusinfoSrcActiveState ();

    inline void clear_has_statusinfoSrcActiveState ();

    uint32 _has_bits_[ (6 + 31) / 32];

    uint8 _statusEntSrcEnum;

    uint8 _statusEntSrcActiveState;

    uint8 _statusVoiceSrcEnum;

    uint8 _statusVoiceSrcActiveState;

    uint8 _statusInfoSrcEnum;

    uint8 _statusinfoSrcActiveState;

};

/**
 * If the meaning of "AudprocMicrolevelStatusSignal" isn't clear, then there should be a description here.
 */
class AudprocMicrolevelStatusSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AudprocMicrolevelStatusSignal ();

    /**
     * Copy constructor
     */
    inline  AudprocMicrolevelStatusSignal (const AudprocMicrolevelStatusSignal &rhs);

    /**
     * All fields constructor
     */
    inline  AudprocMicrolevelStatusSignal (int16 StatusMicroLevel_);

    /**
     * Destructor
     */
    inline virtual  ~AudprocMicrolevelStatusSignal();

    /**
     * Assignment operator
     */
    inline AudprocMicrolevelStatusSignal& operator = (const AudprocMicrolevelStatusSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AudprocMicrolevelStatusSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AudprocMicrolevelStatusSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AudprocMicrolevelStatusSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AudprocMicrolevelStatusSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "StatusMicroLevel"

    static const int kStatusMicroLevel = 0;

    /**
     * Clears the field "StatusMicroLevel".
     *
     * The field will be set to its default value. The hasStatusMicroLevel()
     * method will return false.
     */
    inline void clearStatusMicroLevel();

    /**
     * Checks whether the field "StatusMicroLevel" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatusMicroLevel()). Otherwise it will return false.
     */
    inline bool hasStatusMicroLevel () const;

    /**
     * Returns the value of the member "StatusMicroLevel".
     *
     * If the meaning of "StatusMicroLevel" isn't clear, then there should be a description here.
     *
     * @return The value of the field "StatusMicroLevel"
     */
    inline int16 getStatusMicroLevel () const;

    /**
     * Sets the value of the member "StatusMicroLevel".
     *
     * If the meaning of "StatusMicroLevel" isn't clear, then there should be a description here.
     *
     * @param StatusMicroLevel The value which will be set
     */
    inline void setStatusMicroLevel (int16 StatusMicroLevel_);

    static const AudprocMicrolevelStatusSignal &getDefaultInstance();

private:

    inline void set_has_StatusMicroLevel ();

    inline void clear_has_StatusMicroLevel ();

    uint32 _has_bits_[ (1 + 31) / 32];

    int16 _StatusMicroLevel;

};

/**
 * If the meaning of "AudprocArkamysLevelLossSignal" isn't clear, then there should be a description here.
 */
class AudprocArkamysLevelLossSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AudprocArkamysLevelLossSignal ();

    /**
     * Copy constructor
     */
    inline  AudprocArkamysLevelLossSignal (const AudprocArkamysLevelLossSignal &rhs);

    /**
     * All fields constructor
     */
    inline  AudprocArkamysLevelLossSignal (int32 StatusArkamysLevelLoss_);

    /**
     * Destructor
     */
    inline virtual  ~AudprocArkamysLevelLossSignal();

    /**
     * Assignment operator
     */
    inline AudprocArkamysLevelLossSignal& operator = (const AudprocArkamysLevelLossSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AudprocArkamysLevelLossSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AudprocArkamysLevelLossSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AudprocArkamysLevelLossSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AudprocArkamysLevelLossSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "StatusArkamysLevelLoss"

    static const int kStatusArkamysLevelLoss = 0;

    /**
     * Clears the field "StatusArkamysLevelLoss".
     *
     * The field will be set to its default value. The hasStatusArkamysLevelLoss()
     * method will return false.
     */
    inline void clearStatusArkamysLevelLoss();

    /**
     * Checks whether the field "StatusArkamysLevelLoss" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatusArkamysLevelLoss()). Otherwise it will return false.
     */
    inline bool hasStatusArkamysLevelLoss () const;

    /**
     * Returns the value of the member "StatusArkamysLevelLoss".
     *
     * If the meaning of "StatusArkamysLevelLoss" isn't clear, then there should be a description here.
     *
     * @return The value of the field "StatusArkamysLevelLoss"
     */
    inline int32 getStatusArkamysLevelLoss () const;

    /**
     * Sets the value of the member "StatusArkamysLevelLoss".
     *
     * If the meaning of "StatusArkamysLevelLoss" isn't clear, then there should be a description here.
     *
     * @param StatusArkamysLevelLoss The value which will be set
     */
    inline void setStatusArkamysLevelLoss (int32 StatusArkamysLevelLoss_);

    static const AudprocArkamysLevelLossSignal &getDefaultInstance();

private:

    inline void set_has_StatusArkamysLevelLoss ();

    inline void clear_has_StatusArkamysLevelLoss ();

    uint32 _has_bits_[ (1 + 31) / 32];

    int32 _StatusArkamysLevelLoss;

};

inline  AudprocGetVersionResponse::AudprocGetVersionResponse ()  :
    _Version (),
    _VersionString (),
    _VersionComment ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  AudprocGetVersionResponse::AudprocGetVersionResponse (const AudprocGetVersionResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _Version (),
    _VersionString (),
    _VersionComment ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  AudprocGetVersionResponse::AudprocGetVersionResponse (const ::std::vector< uint32 >& Version_, const ::std::string& VersionString_, const ::std::string& VersionComment_)  :
    _Version (Version_),
    _VersionString (VersionString_),
    _VersionComment (VersionComment_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (VersionString_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (VersionComment_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  AudprocGetVersionResponse::~AudprocGetVersionResponse() {
}

inline AudprocGetVersionResponse& AudprocGetVersionResponse::operator = (const AudprocGetVersionResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasVersion()) {
            setVersion(rhs.getVersion());
        } else {
            clearVersion();
        }
        if (rhs.hasVersionString()) {
            setVersionString(rhs.getVersionString());
        } else {
            clearVersionString();
        }
        if (rhs.hasVersionComment()) {
            setVersionComment(rhs.getVersionComment());
        } else {
            clearVersionComment();
        }
    }
    return *this;
}

inline bool AudprocGetVersionResponse::operator == (const AudprocGetVersionResponse& rhs) const {
    return (((!hasVersion() && !rhs.hasVersion()) || getVersion() == rhs.getVersion()) &&
        ((!hasVersionString() && !rhs.hasVersionString()) || getVersionString() == rhs.getVersionString()) &&
        ((!hasVersionComment() && !rhs.hasVersionComment()) || getVersionComment() == rhs.getVersionComment()));
}

inline bool AudprocGetVersionResponse::operator != (const AudprocGetVersionResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool AudprocGetVersionResponse::operator < (const AudprocGetVersionResponse& rhs) const {
    if (hasVersion() || rhs.hasVersion()) {
        if (getVersion() < rhs.getVersion()) return true;
        if (getVersion() > rhs.getVersion()) return false;
    }
    if (hasVersionString() || rhs.hasVersionString()) {
        if (getVersionString() < rhs.getVersionString()) return true;
        if (getVersionString() > rhs.getVersionString()) return false;
    }
    if (hasVersionComment() || rhs.hasVersionComment()) {
        if (getVersionComment() < rhs.getVersionComment()) return true;
        if (getVersionComment() > rhs.getVersionComment()) return false;
    }
    return false;
}

inline ::asf::core::Payload* AudprocGetVersionResponse::clone() {
    return new AudprocGetVersionResponse(*this);
}

inline bool AudprocGetVersionResponse::operator > (const AudprocGetVersionResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void AudprocGetVersionResponse::clear() {
    clearVersion();
    clearVersionString();
    clearVersionComment();
}

inline void AudprocGetVersionResponse::clearVersion() {
    if (hasVersion()) {
         clear_has_Version();
        _Version.clear();
     }
}

inline bool AudprocGetVersionResponse::hasVersion () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< uint32 >& AudprocGetVersionResponse::getVersion () const {
    return _Version;
}

inline ::std::vector< uint32 >& AudprocGetVersionResponse::getVersionMutable () {
    set_has_Version();
    return _Version;
}

inline void AudprocGetVersionResponse::setVersion (const ::std::vector< uint32 >& Version_) {
    set_has_Version();
    this->_Version = Version_;
}

inline void AudprocGetVersionResponse::clearVersionString() {
    if (hasVersionString()) {
         clear_has_VersionString();
        _VersionString.clear();
     }
}

inline bool AudprocGetVersionResponse::hasVersionString () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& AudprocGetVersionResponse::getVersionString () const {
    return _VersionString;
}

inline ::std::string& AudprocGetVersionResponse::getVersionStringMutable () {
    set_has_VersionString();
    return _VersionString;
}

inline void AudprocGetVersionResponse::setVersionString (const ::std::string& VersionString_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (VersionString_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_VersionString();
    this->_VersionString = VersionString_;
}

inline void AudprocGetVersionResponse::setVersionString (const char* VersionString_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (VersionString_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_VersionString();
    this->_VersionString.assign(VersionString_);
}

inline void AudprocGetVersionResponse::setVersionString (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_VersionString();
    this->_VersionString.assign(value, size);
}

inline void AudprocGetVersionResponse::clearVersionComment() {
    if (hasVersionComment()) {
         clear_has_VersionComment();
        _VersionComment.clear();
     }
}

inline bool AudprocGetVersionResponse::hasVersionComment () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::string& AudprocGetVersionResponse::getVersionComment () const {
    return _VersionComment;
}

inline ::std::string& AudprocGetVersionResponse::getVersionCommentMutable () {
    set_has_VersionComment();
    return _VersionComment;
}

inline void AudprocGetVersionResponse::setVersionComment (const ::std::string& VersionComment_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (VersionComment_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_VersionComment();
    this->_VersionComment = VersionComment_;
}

inline void AudprocGetVersionResponse::setVersionComment (const char* VersionComment_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (VersionComment_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_VersionComment();
    this->_VersionComment.assign(VersionComment_);
}

inline void AudprocGetVersionResponse::setVersionComment (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_VersionComment();
    this->_VersionComment.assign(value, size);
}

inline void AudprocGetVersionResponse::set_has_Version () {
    _has_bits_[0] |= 1u << 0;
}

inline void AudprocGetVersionResponse::clear_has_Version () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void AudprocGetVersionResponse::set_has_VersionString () {
    _has_bits_[0] |= 1u << 1;
}

inline void AudprocGetVersionResponse::clear_has_VersionString () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void AudprocGetVersionResponse::set_has_VersionComment () {
    _has_bits_[0] |= 1u << 2;
}

inline void AudprocGetVersionResponse::clear_has_VersionComment () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  AudprocSetupDebugRequest::AudprocSetupDebugRequest ()  :
    _AudprocSelectMode (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  AudprocSetupDebugRequest::AudprocSetupDebugRequest (const AudprocSetupDebugRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _AudprocSelectMode (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  AudprocSetupDebugRequest::AudprocSetupDebugRequest (uint8 AudprocSelectMode_)  :
    _AudprocSelectMode (AudprocSelectMode_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  AudprocSetupDebugRequest::~AudprocSetupDebugRequest() {
}

inline AudprocSetupDebugRequest& AudprocSetupDebugRequest::operator = (const AudprocSetupDebugRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasAudprocSelectMode()) {
            setAudprocSelectMode(rhs.getAudprocSelectMode());
        } else {
            clearAudprocSelectMode();
        }
    }
    return *this;
}

inline bool AudprocSetupDebugRequest::operator == (const AudprocSetupDebugRequest& rhs) const {
    return (((!hasAudprocSelectMode() && !rhs.hasAudprocSelectMode()) || getAudprocSelectMode() == rhs.getAudprocSelectMode()));
}

inline bool AudprocSetupDebugRequest::operator != (const AudprocSetupDebugRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool AudprocSetupDebugRequest::operator < (const AudprocSetupDebugRequest& rhs) const {
    if (hasAudprocSelectMode() || rhs.hasAudprocSelectMode()) {
        if (getAudprocSelectMode() < rhs.getAudprocSelectMode()) return true;
        if (getAudprocSelectMode() > rhs.getAudprocSelectMode()) return false;
    }
    return false;
}

inline ::asf::core::Payload* AudprocSetupDebugRequest::clone() {
    return new AudprocSetupDebugRequest(*this);
}

inline bool AudprocSetupDebugRequest::operator > (const AudprocSetupDebugRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void AudprocSetupDebugRequest::clear() {
    clearAudprocSelectMode();
}

inline void AudprocSetupDebugRequest::clearAudprocSelectMode() {
    if (hasAudprocSelectMode()) {
         clear_has_AudprocSelectMode();
        _AudprocSelectMode = 0u;
     }
}

inline bool AudprocSetupDebugRequest::hasAudprocSelectMode () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 AudprocSetupDebugRequest::getAudprocSelectMode () const {
    return _AudprocSelectMode;
}

inline void AudprocSetupDebugRequest::setAudprocSelectMode (uint8 AudprocSelectMode_) {
    set_has_AudprocSelectMode();
    this->_AudprocSelectMode = AudprocSelectMode_;
}

inline void AudprocSetupDebugRequest::set_has_AudprocSelectMode () {
    _has_bits_[0] |= 1u << 0;
}

inline void AudprocSetupDebugRequest::clear_has_AudprocSelectMode () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  AudprocInitializeRequest::AudprocInitializeRequest ()  :
    _AudprocSourceId (0u),
    _AudprocConfigurationFile ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  AudprocInitializeRequest::AudprocInitializeRequest (const AudprocInitializeRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _AudprocSourceId (0u),
    _AudprocConfigurationFile ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  AudprocInitializeRequest::AudprocInitializeRequest (uint8 AudprocSourceId_, const ::std::string& AudprocConfigurationFile_)  :
    _AudprocSourceId (AudprocSourceId_),
    _AudprocConfigurationFile (AudprocConfigurationFile_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (AudprocConfigurationFile_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  AudprocInitializeRequest::~AudprocInitializeRequest() {
}

inline AudprocInitializeRequest& AudprocInitializeRequest::operator = (const AudprocInitializeRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasAudprocSourceId()) {
            setAudprocSourceId(rhs.getAudprocSourceId());
        } else {
            clearAudprocSourceId();
        }
        if (rhs.hasAudprocConfigurationFile()) {
            setAudprocConfigurationFile(rhs.getAudprocConfigurationFile());
        } else {
            clearAudprocConfigurationFile();
        }
    }
    return *this;
}

inline bool AudprocInitializeRequest::operator == (const AudprocInitializeRequest& rhs) const {
    return (((!hasAudprocSourceId() && !rhs.hasAudprocSourceId()) || getAudprocSourceId() == rhs.getAudprocSourceId()) &&
        ((!hasAudprocConfigurationFile() && !rhs.hasAudprocConfigurationFile()) || getAudprocConfigurationFile() == rhs.getAudprocConfigurationFile()));
}

inline bool AudprocInitializeRequest::operator != (const AudprocInitializeRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool AudprocInitializeRequest::operator < (const AudprocInitializeRequest& rhs) const {
    if (hasAudprocSourceId() || rhs.hasAudprocSourceId()) {
        if (getAudprocSourceId() < rhs.getAudprocSourceId()) return true;
        if (getAudprocSourceId() > rhs.getAudprocSourceId()) return false;
    }
    if (hasAudprocConfigurationFile() || rhs.hasAudprocConfigurationFile()) {
        if (getAudprocConfigurationFile() < rhs.getAudprocConfigurationFile()) return true;
        if (getAudprocConfigurationFile() > rhs.getAudprocConfigurationFile()) return false;
    }
    return false;
}

inline ::asf::core::Payload* AudprocInitializeRequest::clone() {
    return new AudprocInitializeRequest(*this);
}

inline bool AudprocInitializeRequest::operator > (const AudprocInitializeRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void AudprocInitializeRequest::clear() {
    clearAudprocSourceId();
    clearAudprocConfigurationFile();
}

inline void AudprocInitializeRequest::clearAudprocSourceId() {
    if (hasAudprocSourceId()) {
         clear_has_AudprocSourceId();
        _AudprocSourceId = 0u;
     }
}

inline bool AudprocInitializeRequest::hasAudprocSourceId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 AudprocInitializeRequest::getAudprocSourceId () const {
    return _AudprocSourceId;
}

inline void AudprocInitializeRequest::setAudprocSourceId (uint8 AudprocSourceId_) {
    set_has_AudprocSourceId();
    this->_AudprocSourceId = AudprocSourceId_;
}

inline void AudprocInitializeRequest::clearAudprocConfigurationFile() {
    if (hasAudprocConfigurationFile()) {
         clear_has_AudprocConfigurationFile();
        _AudprocConfigurationFile.clear();
     }
}

inline bool AudprocInitializeRequest::hasAudprocConfigurationFile () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& AudprocInitializeRequest::getAudprocConfigurationFile () const {
    return _AudprocConfigurationFile;
}

inline ::std::string& AudprocInitializeRequest::getAudprocConfigurationFileMutable () {
    set_has_AudprocConfigurationFile();
    return _AudprocConfigurationFile;
}

inline void AudprocInitializeRequest::setAudprocConfigurationFile (const ::std::string& AudprocConfigurationFile_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (AudprocConfigurationFile_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_AudprocConfigurationFile();
    this->_AudprocConfigurationFile = AudprocConfigurationFile_;
}

inline void AudprocInitializeRequest::setAudprocConfigurationFile (const char* AudprocConfigurationFile_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (AudprocConfigurationFile_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_AudprocConfigurationFile();
    this->_AudprocConfigurationFile.assign(AudprocConfigurationFile_);
}

inline void AudprocInitializeRequest::setAudprocConfigurationFile (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_AudprocConfigurationFile();
    this->_AudprocConfigurationFile.assign(value, size);
}

inline void AudprocInitializeRequest::set_has_AudprocSourceId () {
    _has_bits_[0] |= 1u << 0;
}

inline void AudprocInitializeRequest::clear_has_AudprocSourceId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void AudprocInitializeRequest::set_has_AudprocConfigurationFile () {
    _has_bits_[0] |= 1u << 1;
}

inline void AudprocInitializeRequest::clear_has_AudprocConfigurationFile () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  AudprocSetConfigurationRequest::AudprocSetConfigurationRequest ()  :
    _AudprocSourceId (0u),
    _AudprocConfigurationFile ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  AudprocSetConfigurationRequest::AudprocSetConfigurationRequest (const AudprocSetConfigurationRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _AudprocSourceId (0u),
    _AudprocConfigurationFile ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  AudprocSetConfigurationRequest::AudprocSetConfigurationRequest (uint8 AudprocSourceId_, const ::std::string& AudprocConfigurationFile_)  :
    _AudprocSourceId (AudprocSourceId_),
    _AudprocConfigurationFile (AudprocConfigurationFile_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (AudprocConfigurationFile_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  AudprocSetConfigurationRequest::~AudprocSetConfigurationRequest() {
}

inline AudprocSetConfigurationRequest& AudprocSetConfigurationRequest::operator = (const AudprocSetConfigurationRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasAudprocSourceId()) {
            setAudprocSourceId(rhs.getAudprocSourceId());
        } else {
            clearAudprocSourceId();
        }
        if (rhs.hasAudprocConfigurationFile()) {
            setAudprocConfigurationFile(rhs.getAudprocConfigurationFile());
        } else {
            clearAudprocConfigurationFile();
        }
    }
    return *this;
}

inline bool AudprocSetConfigurationRequest::operator == (const AudprocSetConfigurationRequest& rhs) const {
    return (((!hasAudprocSourceId() && !rhs.hasAudprocSourceId()) || getAudprocSourceId() == rhs.getAudprocSourceId()) &&
        ((!hasAudprocConfigurationFile() && !rhs.hasAudprocConfigurationFile()) || getAudprocConfigurationFile() == rhs.getAudprocConfigurationFile()));
}

inline bool AudprocSetConfigurationRequest::operator != (const AudprocSetConfigurationRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool AudprocSetConfigurationRequest::operator < (const AudprocSetConfigurationRequest& rhs) const {
    if (hasAudprocSourceId() || rhs.hasAudprocSourceId()) {
        if (getAudprocSourceId() < rhs.getAudprocSourceId()) return true;
        if (getAudprocSourceId() > rhs.getAudprocSourceId()) return false;
    }
    if (hasAudprocConfigurationFile() || rhs.hasAudprocConfigurationFile()) {
        if (getAudprocConfigurationFile() < rhs.getAudprocConfigurationFile()) return true;
        if (getAudprocConfigurationFile() > rhs.getAudprocConfigurationFile()) return false;
    }
    return false;
}

inline ::asf::core::Payload* AudprocSetConfigurationRequest::clone() {
    return new AudprocSetConfigurationRequest(*this);
}

inline bool AudprocSetConfigurationRequest::operator > (const AudprocSetConfigurationRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void AudprocSetConfigurationRequest::clear() {
    clearAudprocSourceId();
    clearAudprocConfigurationFile();
}

inline void AudprocSetConfigurationRequest::clearAudprocSourceId() {
    if (hasAudprocSourceId()) {
         clear_has_AudprocSourceId();
        _AudprocSourceId = 0u;
     }
}

inline bool AudprocSetConfigurationRequest::hasAudprocSourceId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 AudprocSetConfigurationRequest::getAudprocSourceId () const {
    return _AudprocSourceId;
}

inline void AudprocSetConfigurationRequest::setAudprocSourceId (uint8 AudprocSourceId_) {
    set_has_AudprocSourceId();
    this->_AudprocSourceId = AudprocSourceId_;
}

inline void AudprocSetConfigurationRequest::clearAudprocConfigurationFile() {
    if (hasAudprocConfigurationFile()) {
         clear_has_AudprocConfigurationFile();
        _AudprocConfigurationFile.clear();
     }
}

inline bool AudprocSetConfigurationRequest::hasAudprocConfigurationFile () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& AudprocSetConfigurationRequest::getAudprocConfigurationFile () const {
    return _AudprocConfigurationFile;
}

inline ::std::string& AudprocSetConfigurationRequest::getAudprocConfigurationFileMutable () {
    set_has_AudprocConfigurationFile();
    return _AudprocConfigurationFile;
}

inline void AudprocSetConfigurationRequest::setAudprocConfigurationFile (const ::std::string& AudprocConfigurationFile_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (AudprocConfigurationFile_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_AudprocConfigurationFile();
    this->_AudprocConfigurationFile = AudprocConfigurationFile_;
}

inline void AudprocSetConfigurationRequest::setAudprocConfigurationFile (const char* AudprocConfigurationFile_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (AudprocConfigurationFile_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_AudprocConfigurationFile();
    this->_AudprocConfigurationFile.assign(AudprocConfigurationFile_);
}

inline void AudprocSetConfigurationRequest::setAudprocConfigurationFile (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_AudprocConfigurationFile();
    this->_AudprocConfigurationFile.assign(value, size);
}

inline void AudprocSetConfigurationRequest::set_has_AudprocSourceId () {
    _has_bits_[0] |= 1u << 0;
}

inline void AudprocSetConfigurationRequest::clear_has_AudprocSourceId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void AudprocSetConfigurationRequest::set_has_AudprocConfigurationFile () {
    _has_bits_[0] |= 1u << 1;
}

inline void AudprocSetConfigurationRequest::clear_has_AudprocConfigurationFile () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  AudprocDestroyRequest::AudprocDestroyRequest ()  :
    _AudprocSourceId (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  AudprocDestroyRequest::AudprocDestroyRequest (const AudprocDestroyRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _AudprocSourceId (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  AudprocDestroyRequest::AudprocDestroyRequest (uint8 AudprocSourceId_)  :
    _AudprocSourceId (AudprocSourceId_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  AudprocDestroyRequest::~AudprocDestroyRequest() {
}

inline AudprocDestroyRequest& AudprocDestroyRequest::operator = (const AudprocDestroyRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasAudprocSourceId()) {
            setAudprocSourceId(rhs.getAudprocSourceId());
        } else {
            clearAudprocSourceId();
        }
    }
    return *this;
}

inline bool AudprocDestroyRequest::operator == (const AudprocDestroyRequest& rhs) const {
    return (((!hasAudprocSourceId() && !rhs.hasAudprocSourceId()) || getAudprocSourceId() == rhs.getAudprocSourceId()));
}

inline bool AudprocDestroyRequest::operator != (const AudprocDestroyRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool AudprocDestroyRequest::operator < (const AudprocDestroyRequest& rhs) const {
    if (hasAudprocSourceId() || rhs.hasAudprocSourceId()) {
        if (getAudprocSourceId() < rhs.getAudprocSourceId()) return true;
        if (getAudprocSourceId() > rhs.getAudprocSourceId()) return false;
    }
    return false;
}

inline ::asf::core::Payload* AudprocDestroyRequest::clone() {
    return new AudprocDestroyRequest(*this);
}

inline bool AudprocDestroyRequest::operator > (const AudprocDestroyRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void AudprocDestroyRequest::clear() {
    clearAudprocSourceId();
}

inline void AudprocDestroyRequest::clearAudprocSourceId() {
    if (hasAudprocSourceId()) {
         clear_has_AudprocSourceId();
        _AudprocSourceId = 0u;
     }
}

inline bool AudprocDestroyRequest::hasAudprocSourceId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 AudprocDestroyRequest::getAudprocSourceId () const {
    return _AudprocSourceId;
}

inline void AudprocDestroyRequest::setAudprocSourceId (uint8 AudprocSourceId_) {
    set_has_AudprocSourceId();
    this->_AudprocSourceId = AudprocSourceId_;
}

inline void AudprocDestroyRequest::set_has_AudprocSourceId () {
    _has_bits_[0] |= 1u << 0;
}

inline void AudprocDestroyRequest::clear_has_AudprocSourceId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  AudprocSetParamRequest::AudprocSetParamRequest ()  :
    _AudprocSourceId (0u),
    _ParameterId (0u),
    _ParamType (0u),
    _uParameter (0u),
    _sParameter (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  AudprocSetParamRequest::AudprocSetParamRequest (const AudprocSetParamRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _AudprocSourceId (0u),
    _ParameterId (0u),
    _ParamType (0u),
    _uParameter (0u),
    _sParameter (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  AudprocSetParamRequest::AudprocSetParamRequest (uint8 AudprocSourceId_, uint32 ParameterId_, uint8 ParamType_, uint32 uParameter_, int32 sParameter_)  :
    _AudprocSourceId (AudprocSourceId_),
    _ParameterId (ParameterId_),
    _ParamType (ParamType_),
    _uParameter (uParameter_),
    _sParameter (sParameter_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  AudprocSetParamRequest::~AudprocSetParamRequest() {
}

inline AudprocSetParamRequest& AudprocSetParamRequest::operator = (const AudprocSetParamRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasAudprocSourceId()) {
            setAudprocSourceId(rhs.getAudprocSourceId());
        } else {
            clearAudprocSourceId();
        }
        if (rhs.hasParameterId()) {
            setParameterId(rhs.getParameterId());
        } else {
            clearParameterId();
        }
        if (rhs.hasParamType()) {
            setParamType(rhs.getParamType());
        } else {
            clearParamType();
        }
        if (rhs.hasUParameter()) {
            setUParameter(rhs.getUParameter());
        } else {
            clearUParameter();
        }
        if (rhs.hasSParameter()) {
            setSParameter(rhs.getSParameter());
        } else {
            clearSParameter();
        }
    }
    return *this;
}

inline bool AudprocSetParamRequest::operator == (const AudprocSetParamRequest& rhs) const {
    return (((!hasAudprocSourceId() && !rhs.hasAudprocSourceId()) || getAudprocSourceId() == rhs.getAudprocSourceId()) &&
        ((!hasParameterId() && !rhs.hasParameterId()) || getParameterId() == rhs.getParameterId()) &&
        ((!hasParamType() && !rhs.hasParamType()) || getParamType() == rhs.getParamType()) &&
        ((!hasUParameter() && !rhs.hasUParameter()) || getUParameter() == rhs.getUParameter()) &&
        ((!hasSParameter() && !rhs.hasSParameter()) || getSParameter() == rhs.getSParameter()));
}

inline bool AudprocSetParamRequest::operator != (const AudprocSetParamRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool AudprocSetParamRequest::operator < (const AudprocSetParamRequest& rhs) const {
    if (hasAudprocSourceId() || rhs.hasAudprocSourceId()) {
        if (getAudprocSourceId() < rhs.getAudprocSourceId()) return true;
        if (getAudprocSourceId() > rhs.getAudprocSourceId()) return false;
    }
    if (hasParameterId() || rhs.hasParameterId()) {
        if (getParameterId() < rhs.getParameterId()) return true;
        if (getParameterId() > rhs.getParameterId()) return false;
    }
    if (hasParamType() || rhs.hasParamType()) {
        if (getParamType() < rhs.getParamType()) return true;
        if (getParamType() > rhs.getParamType()) return false;
    }
    if (hasUParameter() || rhs.hasUParameter()) {
        if (getUParameter() < rhs.getUParameter()) return true;
        if (getUParameter() > rhs.getUParameter()) return false;
    }
    if (hasSParameter() || rhs.hasSParameter()) {
        if (getSParameter() < rhs.getSParameter()) return true;
        if (getSParameter() > rhs.getSParameter()) return false;
    }
    return false;
}

inline ::asf::core::Payload* AudprocSetParamRequest::clone() {
    return new AudprocSetParamRequest(*this);
}

inline bool AudprocSetParamRequest::operator > (const AudprocSetParamRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void AudprocSetParamRequest::clear() {
    clearAudprocSourceId();
    clearParameterId();
    clearParamType();
    clearUParameter();
    clearSParameter();
}

inline void AudprocSetParamRequest::clearAudprocSourceId() {
    if (hasAudprocSourceId()) {
         clear_has_AudprocSourceId();
        _AudprocSourceId = 0u;
     }
}

inline bool AudprocSetParamRequest::hasAudprocSourceId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 AudprocSetParamRequest::getAudprocSourceId () const {
    return _AudprocSourceId;
}

inline void AudprocSetParamRequest::setAudprocSourceId (uint8 AudprocSourceId_) {
    set_has_AudprocSourceId();
    this->_AudprocSourceId = AudprocSourceId_;
}

inline void AudprocSetParamRequest::clearParameterId() {
    if (hasParameterId()) {
         clear_has_ParameterId();
        _ParameterId = 0u;
     }
}

inline bool AudprocSetParamRequest::hasParameterId () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 AudprocSetParamRequest::getParameterId () const {
    return _ParameterId;
}

inline void AudprocSetParamRequest::setParameterId (uint32 ParameterId_) {
    set_has_ParameterId();
    this->_ParameterId = ParameterId_;
}

inline void AudprocSetParamRequest::clearParamType() {
    if (hasParamType()) {
         clear_has_ParamType();
        _ParamType = 0u;
     }
}

inline bool AudprocSetParamRequest::hasParamType () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint8 AudprocSetParamRequest::getParamType () const {
    return _ParamType;
}

inline void AudprocSetParamRequest::setParamType (uint8 ParamType_) {
    set_has_ParamType();
    this->_ParamType = ParamType_;
}

inline void AudprocSetParamRequest::clearUParameter() {
    if (hasUParameter()) {
         clear_has_uParameter();
        _uParameter = 0u;
     }
}

inline bool AudprocSetParamRequest::hasUParameter () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint32 AudprocSetParamRequest::getUParameter () const {
    return _uParameter;
}

inline void AudprocSetParamRequest::setUParameter (uint32 uParameter_) {
    set_has_uParameter();
    this->_uParameter = uParameter_;
}

inline void AudprocSetParamRequest::clearSParameter() {
    if (hasSParameter()) {
         clear_has_sParameter();
        _sParameter = 0;
     }
}

inline bool AudprocSetParamRequest::hasSParameter () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline int32 AudprocSetParamRequest::getSParameter () const {
    return _sParameter;
}

inline void AudprocSetParamRequest::setSParameter (int32 sParameter_) {
    set_has_sParameter();
    this->_sParameter = sParameter_;
}

inline void AudprocSetParamRequest::set_has_AudprocSourceId () {
    _has_bits_[0] |= 1u << 0;
}

inline void AudprocSetParamRequest::clear_has_AudprocSourceId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void AudprocSetParamRequest::set_has_ParameterId () {
    _has_bits_[0] |= 1u << 1;
}

inline void AudprocSetParamRequest::clear_has_ParameterId () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void AudprocSetParamRequest::set_has_ParamType () {
    _has_bits_[0] |= 1u << 2;
}

inline void AudprocSetParamRequest::clear_has_ParamType () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void AudprocSetParamRequest::set_has_uParameter () {
    _has_bits_[0] |= 1u << 3;
}

inline void AudprocSetParamRequest::clear_has_uParameter () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void AudprocSetParamRequest::set_has_sParameter () {
    _has_bits_[0] |= 1u << 4;
}

inline void AudprocSetParamRequest::clear_has_sParameter () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline  AudprocWriteDataRequest::AudprocWriteDataRequest ()  :
    _AudprocSourceId (0u),
    _ParameterId (0u),
    _data ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  AudprocWriteDataRequest::AudprocWriteDataRequest (const AudprocWriteDataRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _AudprocSourceId (0u),
    _ParameterId (0u),
    _data ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  AudprocWriteDataRequest::AudprocWriteDataRequest (uint8 AudprocSourceId_, uint32 ParameterId_, const ::std::vector< uint8 >& data_)  :
    _AudprocSourceId (AudprocSourceId_),
    _ParameterId (ParameterId_),
    _data (data_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  AudprocWriteDataRequest::~AudprocWriteDataRequest() {
}

inline AudprocWriteDataRequest& AudprocWriteDataRequest::operator = (const AudprocWriteDataRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasAudprocSourceId()) {
            setAudprocSourceId(rhs.getAudprocSourceId());
        } else {
            clearAudprocSourceId();
        }
        if (rhs.hasParameterId()) {
            setParameterId(rhs.getParameterId());
        } else {
            clearParameterId();
        }
        if (rhs.hasData()) {
            setData(rhs.getData());
        } else {
            clearData();
        }
    }
    return *this;
}

inline bool AudprocWriteDataRequest::operator == (const AudprocWriteDataRequest& rhs) const {
    return (((!hasAudprocSourceId() && !rhs.hasAudprocSourceId()) || getAudprocSourceId() == rhs.getAudprocSourceId()) &&
        ((!hasParameterId() && !rhs.hasParameterId()) || getParameterId() == rhs.getParameterId()) &&
        ((!hasData() && !rhs.hasData()) || getData() == rhs.getData()));
}

inline bool AudprocWriteDataRequest::operator != (const AudprocWriteDataRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool AudprocWriteDataRequest::operator < (const AudprocWriteDataRequest& rhs) const {
    if (hasAudprocSourceId() || rhs.hasAudprocSourceId()) {
        if (getAudprocSourceId() < rhs.getAudprocSourceId()) return true;
        if (getAudprocSourceId() > rhs.getAudprocSourceId()) return false;
    }
    if (hasParameterId() || rhs.hasParameterId()) {
        if (getParameterId() < rhs.getParameterId()) return true;
        if (getParameterId() > rhs.getParameterId()) return false;
    }
    if (hasData() || rhs.hasData()) {
        if (getData() < rhs.getData()) return true;
        if (getData() > rhs.getData()) return false;
    }
    return false;
}

inline ::asf::core::Payload* AudprocWriteDataRequest::clone() {
    return new AudprocWriteDataRequest(*this);
}

inline bool AudprocWriteDataRequest::operator > (const AudprocWriteDataRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void AudprocWriteDataRequest::clear() {
    clearAudprocSourceId();
    clearParameterId();
    clearData();
}

inline void AudprocWriteDataRequest::clearAudprocSourceId() {
    if (hasAudprocSourceId()) {
         clear_has_AudprocSourceId();
        _AudprocSourceId = 0u;
     }
}

inline bool AudprocWriteDataRequest::hasAudprocSourceId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 AudprocWriteDataRequest::getAudprocSourceId () const {
    return _AudprocSourceId;
}

inline void AudprocWriteDataRequest::setAudprocSourceId (uint8 AudprocSourceId_) {
    set_has_AudprocSourceId();
    this->_AudprocSourceId = AudprocSourceId_;
}

inline void AudprocWriteDataRequest::clearParameterId() {
    if (hasParameterId()) {
         clear_has_ParameterId();
        _ParameterId = 0u;
     }
}

inline bool AudprocWriteDataRequest::hasParameterId () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 AudprocWriteDataRequest::getParameterId () const {
    return _ParameterId;
}

inline void AudprocWriteDataRequest::setParameterId (uint32 ParameterId_) {
    set_has_ParameterId();
    this->_ParameterId = ParameterId_;
}

inline void AudprocWriteDataRequest::clearData() {
    if (hasData()) {
         clear_has_data();
        _data.clear();
     }
}

inline bool AudprocWriteDataRequest::hasData () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::vector< uint8 >& AudprocWriteDataRequest::getData () const {
    return _data;
}

inline ::std::vector< uint8 >& AudprocWriteDataRequest::getDataMutable () {
    set_has_data();
    return _data;
}

inline void AudprocWriteDataRequest::setData (const ::std::vector< uint8 >& data_) {
    set_has_data();
    this->_data = data_;
}

inline void AudprocWriteDataRequest::set_has_AudprocSourceId () {
    _has_bits_[0] |= 1u << 0;
}

inline void AudprocWriteDataRequest::clear_has_AudprocSourceId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void AudprocWriteDataRequest::set_has_ParameterId () {
    _has_bits_[0] |= 1u << 1;
}

inline void AudprocWriteDataRequest::clear_has_ParameterId () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void AudprocWriteDataRequest::set_has_data () {
    _has_bits_[0] |= 1u << 2;
}

inline void AudprocWriteDataRequest::clear_has_data () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  AudprocWriteDataResponse::AudprocWriteDataResponse ()  :
    _result ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  AudprocWriteDataResponse::AudprocWriteDataResponse (const AudprocWriteDataResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _result ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  AudprocWriteDataResponse::AudprocWriteDataResponse (const ::std::vector< uint8 >& result_)  :
    _result (result_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  AudprocWriteDataResponse::~AudprocWriteDataResponse() {
}

inline AudprocWriteDataResponse& AudprocWriteDataResponse::operator = (const AudprocWriteDataResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasResult()) {
            setResult(rhs.getResult());
        } else {
            clearResult();
        }
    }
    return *this;
}

inline bool AudprocWriteDataResponse::operator == (const AudprocWriteDataResponse& rhs) const {
    return (((!hasResult() && !rhs.hasResult()) || getResult() == rhs.getResult()));
}

inline bool AudprocWriteDataResponse::operator != (const AudprocWriteDataResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool AudprocWriteDataResponse::operator < (const AudprocWriteDataResponse& rhs) const {
    if (hasResult() || rhs.hasResult()) {
        if (getResult() < rhs.getResult()) return true;
        if (getResult() > rhs.getResult()) return false;
    }
    return false;
}

inline ::asf::core::Payload* AudprocWriteDataResponse::clone() {
    return new AudprocWriteDataResponse(*this);
}

inline bool AudprocWriteDataResponse::operator > (const AudprocWriteDataResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void AudprocWriteDataResponse::clear() {
    clearResult();
}

inline void AudprocWriteDataResponse::clearResult() {
    if (hasResult()) {
         clear_has_result();
        _result.clear();
     }
}

inline bool AudprocWriteDataResponse::hasResult () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< uint8 >& AudprocWriteDataResponse::getResult () const {
    return _result;
}

inline ::std::vector< uint8 >& AudprocWriteDataResponse::getResultMutable () {
    set_has_result();
    return _result;
}

inline void AudprocWriteDataResponse::setResult (const ::std::vector< uint8 >& result_) {
    set_has_result();
    this->_result = result_;
}

inline void AudprocWriteDataResponse::set_has_result () {
    _has_bits_[0] |= 1u << 0;
}

inline void AudprocWriteDataResponse::clear_has_result () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  AudprocReadDataRequest::AudprocReadDataRequest ()  :
    _AudprocSourceId (0u),
    _ParameterId (0u),
    _ReadInfos ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  AudprocReadDataRequest::AudprocReadDataRequest (const AudprocReadDataRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _AudprocSourceId (0u),
    _ParameterId (0u),
    _ReadInfos ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  AudprocReadDataRequest::AudprocReadDataRequest (uint8 AudprocSourceId_, uint32 ParameterId_, const ::std::vector< uint8 >& ReadInfos_)  :
    _AudprocSourceId (AudprocSourceId_),
    _ParameterId (ParameterId_),
    _ReadInfos (ReadInfos_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  AudprocReadDataRequest::~AudprocReadDataRequest() {
}

inline AudprocReadDataRequest& AudprocReadDataRequest::operator = (const AudprocReadDataRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasAudprocSourceId()) {
            setAudprocSourceId(rhs.getAudprocSourceId());
        } else {
            clearAudprocSourceId();
        }
        if (rhs.hasParameterId()) {
            setParameterId(rhs.getParameterId());
        } else {
            clearParameterId();
        }
        if (rhs.hasReadInfos()) {
            setReadInfos(rhs.getReadInfos());
        } else {
            clearReadInfos();
        }
    }
    return *this;
}

inline bool AudprocReadDataRequest::operator == (const AudprocReadDataRequest& rhs) const {
    return (((!hasAudprocSourceId() && !rhs.hasAudprocSourceId()) || getAudprocSourceId() == rhs.getAudprocSourceId()) &&
        ((!hasParameterId() && !rhs.hasParameterId()) || getParameterId() == rhs.getParameterId()) &&
        ((!hasReadInfos() && !rhs.hasReadInfos()) || getReadInfos() == rhs.getReadInfos()));
}

inline bool AudprocReadDataRequest::operator != (const AudprocReadDataRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool AudprocReadDataRequest::operator < (const AudprocReadDataRequest& rhs) const {
    if (hasAudprocSourceId() || rhs.hasAudprocSourceId()) {
        if (getAudprocSourceId() < rhs.getAudprocSourceId()) return true;
        if (getAudprocSourceId() > rhs.getAudprocSourceId()) return false;
    }
    if (hasParameterId() || rhs.hasParameterId()) {
        if (getParameterId() < rhs.getParameterId()) return true;
        if (getParameterId() > rhs.getParameterId()) return false;
    }
    if (hasReadInfos() || rhs.hasReadInfos()) {
        if (getReadInfos() < rhs.getReadInfos()) return true;
        if (getReadInfos() > rhs.getReadInfos()) return false;
    }
    return false;
}

inline ::asf::core::Payload* AudprocReadDataRequest::clone() {
    return new AudprocReadDataRequest(*this);
}

inline bool AudprocReadDataRequest::operator > (const AudprocReadDataRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void AudprocReadDataRequest::clear() {
    clearAudprocSourceId();
    clearParameterId();
    clearReadInfos();
}

inline void AudprocReadDataRequest::clearAudprocSourceId() {
    if (hasAudprocSourceId()) {
         clear_has_AudprocSourceId();
        _AudprocSourceId = 0u;
     }
}

inline bool AudprocReadDataRequest::hasAudprocSourceId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 AudprocReadDataRequest::getAudprocSourceId () const {
    return _AudprocSourceId;
}

inline void AudprocReadDataRequest::setAudprocSourceId (uint8 AudprocSourceId_) {
    set_has_AudprocSourceId();
    this->_AudprocSourceId = AudprocSourceId_;
}

inline void AudprocReadDataRequest::clearParameterId() {
    if (hasParameterId()) {
         clear_has_ParameterId();
        _ParameterId = 0u;
     }
}

inline bool AudprocReadDataRequest::hasParameterId () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 AudprocReadDataRequest::getParameterId () const {
    return _ParameterId;
}

inline void AudprocReadDataRequest::setParameterId (uint32 ParameterId_) {
    set_has_ParameterId();
    this->_ParameterId = ParameterId_;
}

inline void AudprocReadDataRequest::clearReadInfos() {
    if (hasReadInfos()) {
         clear_has_ReadInfos();
        _ReadInfos.clear();
     }
}

inline bool AudprocReadDataRequest::hasReadInfos () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::vector< uint8 >& AudprocReadDataRequest::getReadInfos () const {
    return _ReadInfos;
}

inline ::std::vector< uint8 >& AudprocReadDataRequest::getReadInfosMutable () {
    set_has_ReadInfos();
    return _ReadInfos;
}

inline void AudprocReadDataRequest::setReadInfos (const ::std::vector< uint8 >& ReadInfos_) {
    set_has_ReadInfos();
    this->_ReadInfos = ReadInfos_;
}

inline void AudprocReadDataRequest::set_has_AudprocSourceId () {
    _has_bits_[0] |= 1u << 0;
}

inline void AudprocReadDataRequest::clear_has_AudprocSourceId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void AudprocReadDataRequest::set_has_ParameterId () {
    _has_bits_[0] |= 1u << 1;
}

inline void AudprocReadDataRequest::clear_has_ParameterId () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void AudprocReadDataRequest::set_has_ReadInfos () {
    _has_bits_[0] |= 1u << 2;
}

inline void AudprocReadDataRequest::clear_has_ReadInfos () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  AudprocReadDataResponse::AudprocReadDataResponse ()  :
    _data ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  AudprocReadDataResponse::AudprocReadDataResponse (const AudprocReadDataResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _data ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  AudprocReadDataResponse::AudprocReadDataResponse (const ::std::vector< uint8 >& data_)  :
    _data (data_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  AudprocReadDataResponse::~AudprocReadDataResponse() {
}

inline AudprocReadDataResponse& AudprocReadDataResponse::operator = (const AudprocReadDataResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasData()) {
            setData(rhs.getData());
        } else {
            clearData();
        }
    }
    return *this;
}

inline bool AudprocReadDataResponse::operator == (const AudprocReadDataResponse& rhs) const {
    return (((!hasData() && !rhs.hasData()) || getData() == rhs.getData()));
}

inline bool AudprocReadDataResponse::operator != (const AudprocReadDataResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool AudprocReadDataResponse::operator < (const AudprocReadDataResponse& rhs) const {
    if (hasData() || rhs.hasData()) {
        if (getData() < rhs.getData()) return true;
        if (getData() > rhs.getData()) return false;
    }
    return false;
}

inline ::asf::core::Payload* AudprocReadDataResponse::clone() {
    return new AudprocReadDataResponse(*this);
}

inline bool AudprocReadDataResponse::operator > (const AudprocReadDataResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void AudprocReadDataResponse::clear() {
    clearData();
}

inline void AudprocReadDataResponse::clearData() {
    if (hasData()) {
         clear_has_data();
        _data.clear();
     }
}

inline bool AudprocReadDataResponse::hasData () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< uint8 >& AudprocReadDataResponse::getData () const {
    return _data;
}

inline ::std::vector< uint8 >& AudprocReadDataResponse::getDataMutable () {
    set_has_data();
    return _data;
}

inline void AudprocReadDataResponse::setData (const ::std::vector< uint8 >& data_) {
    set_has_data();
    this->_data = data_;
}

inline void AudprocReadDataResponse::set_has_data () {
    _has_bits_[0] |= 1u << 0;
}

inline void AudprocReadDataResponse::clear_has_data () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  AudprocGetAudprocConfigurationResponse::AudprocGetAudprocConfigurationResponse ()  :
    _DatasetName (),
    _AudprocProperties (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  AudprocGetAudprocConfigurationResponse::AudprocGetAudprocConfigurationResponse (const AudprocGetAudprocConfigurationResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _DatasetName (),
    _AudprocProperties (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  AudprocGetAudprocConfigurationResponse::AudprocGetAudprocConfigurationResponse (const ::std::string& DatasetName_, uint32 AudprocProperties_)  :
    _DatasetName (DatasetName_),
    _AudprocProperties (AudprocProperties_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (DatasetName_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  AudprocGetAudprocConfigurationResponse::~AudprocGetAudprocConfigurationResponse() {
}

inline AudprocGetAudprocConfigurationResponse& AudprocGetAudprocConfigurationResponse::operator = (const AudprocGetAudprocConfigurationResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasDatasetName()) {
            setDatasetName(rhs.getDatasetName());
        } else {
            clearDatasetName();
        }
        if (rhs.hasAudprocProperties()) {
            setAudprocProperties(rhs.getAudprocProperties());
        } else {
            clearAudprocProperties();
        }
    }
    return *this;
}

inline bool AudprocGetAudprocConfigurationResponse::operator == (const AudprocGetAudprocConfigurationResponse& rhs) const {
    return (((!hasDatasetName() && !rhs.hasDatasetName()) || getDatasetName() == rhs.getDatasetName()) &&
        ((!hasAudprocProperties() && !rhs.hasAudprocProperties()) || getAudprocProperties() == rhs.getAudprocProperties()));
}

inline bool AudprocGetAudprocConfigurationResponse::operator != (const AudprocGetAudprocConfigurationResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool AudprocGetAudprocConfigurationResponse::operator < (const AudprocGetAudprocConfigurationResponse& rhs) const {
    if (hasDatasetName() || rhs.hasDatasetName()) {
        if (getDatasetName() < rhs.getDatasetName()) return true;
        if (getDatasetName() > rhs.getDatasetName()) return false;
    }
    if (hasAudprocProperties() || rhs.hasAudprocProperties()) {
        if (getAudprocProperties() < rhs.getAudprocProperties()) return true;
        if (getAudprocProperties() > rhs.getAudprocProperties()) return false;
    }
    return false;
}

inline ::asf::core::Payload* AudprocGetAudprocConfigurationResponse::clone() {
    return new AudprocGetAudprocConfigurationResponse(*this);
}

inline bool AudprocGetAudprocConfigurationResponse::operator > (const AudprocGetAudprocConfigurationResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void AudprocGetAudprocConfigurationResponse::clear() {
    clearDatasetName();
    clearAudprocProperties();
}

inline void AudprocGetAudprocConfigurationResponse::clearDatasetName() {
    if (hasDatasetName()) {
         clear_has_DatasetName();
        _DatasetName.clear();
     }
}

inline bool AudprocGetAudprocConfigurationResponse::hasDatasetName () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& AudprocGetAudprocConfigurationResponse::getDatasetName () const {
    return _DatasetName;
}

inline ::std::string& AudprocGetAudprocConfigurationResponse::getDatasetNameMutable () {
    set_has_DatasetName();
    return _DatasetName;
}

inline void AudprocGetAudprocConfigurationResponse::setDatasetName (const ::std::string& DatasetName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (DatasetName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_DatasetName();
    this->_DatasetName = DatasetName_;
}

inline void AudprocGetAudprocConfigurationResponse::setDatasetName (const char* DatasetName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (DatasetName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_DatasetName();
    this->_DatasetName.assign(DatasetName_);
}

inline void AudprocGetAudprocConfigurationResponse::setDatasetName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_DatasetName();
    this->_DatasetName.assign(value, size);
}

inline void AudprocGetAudprocConfigurationResponse::clearAudprocProperties() {
    if (hasAudprocProperties()) {
         clear_has_AudprocProperties();
        _AudprocProperties = 0u;
     }
}

inline bool AudprocGetAudprocConfigurationResponse::hasAudprocProperties () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 AudprocGetAudprocConfigurationResponse::getAudprocProperties () const {
    return _AudprocProperties;
}

inline void AudprocGetAudprocConfigurationResponse::setAudprocProperties (uint32 AudprocProperties_) {
    set_has_AudprocProperties();
    this->_AudprocProperties = AudprocProperties_;
}

inline void AudprocGetAudprocConfigurationResponse::set_has_DatasetName () {
    _has_bits_[0] |= 1u << 0;
}

inline void AudprocGetAudprocConfigurationResponse::clear_has_DatasetName () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void AudprocGetAudprocConfigurationResponse::set_has_AudprocProperties () {
    _has_bits_[0] |= 1u << 1;
}

inline void AudprocGetAudprocConfigurationResponse::clear_has_AudprocProperties () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  AudprocStartAudioRequest::AudprocStartAudioRequest ()  :
    _AudprocSourceId (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  AudprocStartAudioRequest::AudprocStartAudioRequest (const AudprocStartAudioRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _AudprocSourceId (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  AudprocStartAudioRequest::AudprocStartAudioRequest (uint8 AudprocSourceId_)  :
    _AudprocSourceId (AudprocSourceId_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  AudprocStartAudioRequest::~AudprocStartAudioRequest() {
}

inline AudprocStartAudioRequest& AudprocStartAudioRequest::operator = (const AudprocStartAudioRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasAudprocSourceId()) {
            setAudprocSourceId(rhs.getAudprocSourceId());
        } else {
            clearAudprocSourceId();
        }
    }
    return *this;
}

inline bool AudprocStartAudioRequest::operator == (const AudprocStartAudioRequest& rhs) const {
    return (((!hasAudprocSourceId() && !rhs.hasAudprocSourceId()) || getAudprocSourceId() == rhs.getAudprocSourceId()));
}

inline bool AudprocStartAudioRequest::operator != (const AudprocStartAudioRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool AudprocStartAudioRequest::operator < (const AudprocStartAudioRequest& rhs) const {
    if (hasAudprocSourceId() || rhs.hasAudprocSourceId()) {
        if (getAudprocSourceId() < rhs.getAudprocSourceId()) return true;
        if (getAudprocSourceId() > rhs.getAudprocSourceId()) return false;
    }
    return false;
}

inline ::asf::core::Payload* AudprocStartAudioRequest::clone() {
    return new AudprocStartAudioRequest(*this);
}

inline bool AudprocStartAudioRequest::operator > (const AudprocStartAudioRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void AudprocStartAudioRequest::clear() {
    clearAudprocSourceId();
}

inline void AudprocStartAudioRequest::clearAudprocSourceId() {
    if (hasAudprocSourceId()) {
         clear_has_AudprocSourceId();
        _AudprocSourceId = 0u;
     }
}

inline bool AudprocStartAudioRequest::hasAudprocSourceId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 AudprocStartAudioRequest::getAudprocSourceId () const {
    return _AudprocSourceId;
}

inline void AudprocStartAudioRequest::setAudprocSourceId (uint8 AudprocSourceId_) {
    set_has_AudprocSourceId();
    this->_AudprocSourceId = AudprocSourceId_;
}

inline void AudprocStartAudioRequest::set_has_AudprocSourceId () {
    _has_bits_[0] |= 1u << 0;
}

inline void AudprocStartAudioRequest::clear_has_AudprocSourceId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  AudprocStopAudioRequest::AudprocStopAudioRequest ()  :
    _AudprocSourceId (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  AudprocStopAudioRequest::AudprocStopAudioRequest (const AudprocStopAudioRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _AudprocSourceId (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  AudprocStopAudioRequest::AudprocStopAudioRequest (uint8 AudprocSourceId_)  :
    _AudprocSourceId (AudprocSourceId_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  AudprocStopAudioRequest::~AudprocStopAudioRequest() {
}

inline AudprocStopAudioRequest& AudprocStopAudioRequest::operator = (const AudprocStopAudioRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasAudprocSourceId()) {
            setAudprocSourceId(rhs.getAudprocSourceId());
        } else {
            clearAudprocSourceId();
        }
    }
    return *this;
}

inline bool AudprocStopAudioRequest::operator == (const AudprocStopAudioRequest& rhs) const {
    return (((!hasAudprocSourceId() && !rhs.hasAudprocSourceId()) || getAudprocSourceId() == rhs.getAudprocSourceId()));
}

inline bool AudprocStopAudioRequest::operator != (const AudprocStopAudioRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool AudprocStopAudioRequest::operator < (const AudprocStopAudioRequest& rhs) const {
    if (hasAudprocSourceId() || rhs.hasAudprocSourceId()) {
        if (getAudprocSourceId() < rhs.getAudprocSourceId()) return true;
        if (getAudprocSourceId() > rhs.getAudprocSourceId()) return false;
    }
    return false;
}

inline ::asf::core::Payload* AudprocStopAudioRequest::clone() {
    return new AudprocStopAudioRequest(*this);
}

inline bool AudprocStopAudioRequest::operator > (const AudprocStopAudioRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void AudprocStopAudioRequest::clear() {
    clearAudprocSourceId();
}

inline void AudprocStopAudioRequest::clearAudprocSourceId() {
    if (hasAudprocSourceId()) {
         clear_has_AudprocSourceId();
        _AudprocSourceId = 0u;
     }
}

inline bool AudprocStopAudioRequest::hasAudprocSourceId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 AudprocStopAudioRequest::getAudprocSourceId () const {
    return _AudprocSourceId;
}

inline void AudprocStopAudioRequest::setAudprocSourceId (uint8 AudprocSourceId_) {
    set_has_AudprocSourceId();
    this->_AudprocSourceId = AudprocSourceId_;
}

inline void AudprocStopAudioRequest::set_has_AudprocSourceId () {
    _has_bits_[0] |= 1u << 0;
}

inline void AudprocStopAudioRequest::clear_has_AudprocSourceId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  AudprocSourceActivityRequest::AudprocSourceActivityRequest ()  :
    _AudprocSourceMapId (0u),
    _AudprocSourceActivity (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  AudprocSourceActivityRequest::AudprocSourceActivityRequest (const AudprocSourceActivityRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _AudprocSourceMapId (0u),
    _AudprocSourceActivity (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  AudprocSourceActivityRequest::AudprocSourceActivityRequest (uint8 AudprocSourceMapId_, uint8 AudprocSourceActivity_)  :
    _AudprocSourceMapId (AudprocSourceMapId_),
    _AudprocSourceActivity (AudprocSourceActivity_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  AudprocSourceActivityRequest::~AudprocSourceActivityRequest() {
}

inline AudprocSourceActivityRequest& AudprocSourceActivityRequest::operator = (const AudprocSourceActivityRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasAudprocSourceMapId()) {
            setAudprocSourceMapId(rhs.getAudprocSourceMapId());
        } else {
            clearAudprocSourceMapId();
        }
        if (rhs.hasAudprocSourceActivity()) {
            setAudprocSourceActivity(rhs.getAudprocSourceActivity());
        } else {
            clearAudprocSourceActivity();
        }
    }
    return *this;
}

inline bool AudprocSourceActivityRequest::operator == (const AudprocSourceActivityRequest& rhs) const {
    return (((!hasAudprocSourceMapId() && !rhs.hasAudprocSourceMapId()) || getAudprocSourceMapId() == rhs.getAudprocSourceMapId()) &&
        ((!hasAudprocSourceActivity() && !rhs.hasAudprocSourceActivity()) || getAudprocSourceActivity() == rhs.getAudprocSourceActivity()));
}

inline bool AudprocSourceActivityRequest::operator != (const AudprocSourceActivityRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool AudprocSourceActivityRequest::operator < (const AudprocSourceActivityRequest& rhs) const {
    if (hasAudprocSourceMapId() || rhs.hasAudprocSourceMapId()) {
        if (getAudprocSourceMapId() < rhs.getAudprocSourceMapId()) return true;
        if (getAudprocSourceMapId() > rhs.getAudprocSourceMapId()) return false;
    }
    if (hasAudprocSourceActivity() || rhs.hasAudprocSourceActivity()) {
        if (getAudprocSourceActivity() < rhs.getAudprocSourceActivity()) return true;
        if (getAudprocSourceActivity() > rhs.getAudprocSourceActivity()) return false;
    }
    return false;
}

inline ::asf::core::Payload* AudprocSourceActivityRequest::clone() {
    return new AudprocSourceActivityRequest(*this);
}

inline bool AudprocSourceActivityRequest::operator > (const AudprocSourceActivityRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void AudprocSourceActivityRequest::clear() {
    clearAudprocSourceMapId();
    clearAudprocSourceActivity();
}

inline void AudprocSourceActivityRequest::clearAudprocSourceMapId() {
    if (hasAudprocSourceMapId()) {
         clear_has_AudprocSourceMapId();
        _AudprocSourceMapId = 0u;
     }
}

inline bool AudprocSourceActivityRequest::hasAudprocSourceMapId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 AudprocSourceActivityRequest::getAudprocSourceMapId () const {
    return _AudprocSourceMapId;
}

inline void AudprocSourceActivityRequest::setAudprocSourceMapId (uint8 AudprocSourceMapId_) {
    set_has_AudprocSourceMapId();
    this->_AudprocSourceMapId = AudprocSourceMapId_;
}

inline void AudprocSourceActivityRequest::clearAudprocSourceActivity() {
    if (hasAudprocSourceActivity()) {
         clear_has_AudprocSourceActivity();
        _AudprocSourceActivity = 0u;
     }
}

inline bool AudprocSourceActivityRequest::hasAudprocSourceActivity () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 AudprocSourceActivityRequest::getAudprocSourceActivity () const {
    return _AudprocSourceActivity;
}

inline void AudprocSourceActivityRequest::setAudprocSourceActivity (uint8 AudprocSourceActivity_) {
    set_has_AudprocSourceActivity();
    this->_AudprocSourceActivity = AudprocSourceActivity_;
}

inline void AudprocSourceActivityRequest::set_has_AudprocSourceMapId () {
    _has_bits_[0] |= 1u << 0;
}

inline void AudprocSourceActivityRequest::clear_has_AudprocSourceMapId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void AudprocSourceActivityRequest::set_has_AudprocSourceActivity () {
    _has_bits_[0] |= 1u << 1;
}

inline void AudprocSourceActivityRequest::clear_has_AudprocSourceActivity () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  AudprocSourceSelectRequest::AudprocSourceSelectRequest ()  :
    _AudprocSourceSelectMode (0u),
    _AudprocSourceId (0u),
    _AudprocAlsaDev ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  AudprocSourceSelectRequest::AudprocSourceSelectRequest (const AudprocSourceSelectRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _AudprocSourceSelectMode (0u),
    _AudprocSourceId (0u),
    _AudprocAlsaDev ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  AudprocSourceSelectRequest::AudprocSourceSelectRequest (uint8 AudprocSourceSelectMode_, uint8 AudprocSourceId_, const ::std::string& AudprocAlsaDev_)  :
    _AudprocSourceSelectMode (AudprocSourceSelectMode_),
    _AudprocSourceId (AudprocSourceId_),
    _AudprocAlsaDev (AudprocAlsaDev_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (AudprocAlsaDev_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  AudprocSourceSelectRequest::~AudprocSourceSelectRequest() {
}

inline AudprocSourceSelectRequest& AudprocSourceSelectRequest::operator = (const AudprocSourceSelectRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasAudprocSourceSelectMode()) {
            setAudprocSourceSelectMode(rhs.getAudprocSourceSelectMode());
        } else {
            clearAudprocSourceSelectMode();
        }
        if (rhs.hasAudprocSourceId()) {
            setAudprocSourceId(rhs.getAudprocSourceId());
        } else {
            clearAudprocSourceId();
        }
        if (rhs.hasAudprocAlsaDev()) {
            setAudprocAlsaDev(rhs.getAudprocAlsaDev());
        } else {
            clearAudprocAlsaDev();
        }
    }
    return *this;
}

inline bool AudprocSourceSelectRequest::operator == (const AudprocSourceSelectRequest& rhs) const {
    return (((!hasAudprocSourceSelectMode() && !rhs.hasAudprocSourceSelectMode()) || getAudprocSourceSelectMode() == rhs.getAudprocSourceSelectMode()) &&
        ((!hasAudprocSourceId() && !rhs.hasAudprocSourceId()) || getAudprocSourceId() == rhs.getAudprocSourceId()) &&
        ((!hasAudprocAlsaDev() && !rhs.hasAudprocAlsaDev()) || getAudprocAlsaDev() == rhs.getAudprocAlsaDev()));
}

inline bool AudprocSourceSelectRequest::operator != (const AudprocSourceSelectRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool AudprocSourceSelectRequest::operator < (const AudprocSourceSelectRequest& rhs) const {
    if (hasAudprocSourceSelectMode() || rhs.hasAudprocSourceSelectMode()) {
        if (getAudprocSourceSelectMode() < rhs.getAudprocSourceSelectMode()) return true;
        if (getAudprocSourceSelectMode() > rhs.getAudprocSourceSelectMode()) return false;
    }
    if (hasAudprocSourceId() || rhs.hasAudprocSourceId()) {
        if (getAudprocSourceId() < rhs.getAudprocSourceId()) return true;
        if (getAudprocSourceId() > rhs.getAudprocSourceId()) return false;
    }
    if (hasAudprocAlsaDev() || rhs.hasAudprocAlsaDev()) {
        if (getAudprocAlsaDev() < rhs.getAudprocAlsaDev()) return true;
        if (getAudprocAlsaDev() > rhs.getAudprocAlsaDev()) return false;
    }
    return false;
}

inline ::asf::core::Payload* AudprocSourceSelectRequest::clone() {
    return new AudprocSourceSelectRequest(*this);
}

inline bool AudprocSourceSelectRequest::operator > (const AudprocSourceSelectRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void AudprocSourceSelectRequest::clear() {
    clearAudprocSourceSelectMode();
    clearAudprocSourceId();
    clearAudprocAlsaDev();
}

inline void AudprocSourceSelectRequest::clearAudprocSourceSelectMode() {
    if (hasAudprocSourceSelectMode()) {
         clear_has_AudprocSourceSelectMode();
        _AudprocSourceSelectMode = 0u;
     }
}

inline bool AudprocSourceSelectRequest::hasAudprocSourceSelectMode () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 AudprocSourceSelectRequest::getAudprocSourceSelectMode () const {
    return _AudprocSourceSelectMode;
}

inline void AudprocSourceSelectRequest::setAudprocSourceSelectMode (uint8 AudprocSourceSelectMode_) {
    set_has_AudprocSourceSelectMode();
    this->_AudprocSourceSelectMode = AudprocSourceSelectMode_;
}

inline void AudprocSourceSelectRequest::clearAudprocSourceId() {
    if (hasAudprocSourceId()) {
         clear_has_AudprocSourceId();
        _AudprocSourceId = 0u;
     }
}

inline bool AudprocSourceSelectRequest::hasAudprocSourceId () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 AudprocSourceSelectRequest::getAudprocSourceId () const {
    return _AudprocSourceId;
}

inline void AudprocSourceSelectRequest::setAudprocSourceId (uint8 AudprocSourceId_) {
    set_has_AudprocSourceId();
    this->_AudprocSourceId = AudprocSourceId_;
}

inline void AudprocSourceSelectRequest::clearAudprocAlsaDev() {
    if (hasAudprocAlsaDev()) {
         clear_has_AudprocAlsaDev();
        _AudprocAlsaDev.clear();
     }
}

inline bool AudprocSourceSelectRequest::hasAudprocAlsaDev () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::string& AudprocSourceSelectRequest::getAudprocAlsaDev () const {
    return _AudprocAlsaDev;
}

inline ::std::string& AudprocSourceSelectRequest::getAudprocAlsaDevMutable () {
    set_has_AudprocAlsaDev();
    return _AudprocAlsaDev;
}

inline void AudprocSourceSelectRequest::setAudprocAlsaDev (const ::std::string& AudprocAlsaDev_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (AudprocAlsaDev_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_AudprocAlsaDev();
    this->_AudprocAlsaDev = AudprocAlsaDev_;
}

inline void AudprocSourceSelectRequest::setAudprocAlsaDev (const char* AudprocAlsaDev_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (AudprocAlsaDev_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_AudprocAlsaDev();
    this->_AudprocAlsaDev.assign(AudprocAlsaDev_);
}

inline void AudprocSourceSelectRequest::setAudprocAlsaDev (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_AudprocAlsaDev();
    this->_AudprocAlsaDev.assign(value, size);
}

inline void AudprocSourceSelectRequest::set_has_AudprocSourceSelectMode () {
    _has_bits_[0] |= 1u << 0;
}

inline void AudprocSourceSelectRequest::clear_has_AudprocSourceSelectMode () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void AudprocSourceSelectRequest::set_has_AudprocSourceId () {
    _has_bits_[0] |= 1u << 1;
}

inline void AudprocSourceSelectRequest::clear_has_AudprocSourceId () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void AudprocSourceSelectRequest::set_has_AudprocAlsaDev () {
    _has_bits_[0] |= 1u << 2;
}

inline void AudprocSourceSelectRequest::clear_has_AudprocAlsaDev () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  AplArkamysAvcActivateUpdate::AplArkamysAvcActivateUpdate ()  :
    _aplArkamysAvcActivate (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  AplArkamysAvcActivateUpdate::AplArkamysAvcActivateUpdate (const AplArkamysAvcActivateUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _aplArkamysAvcActivate (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  AplArkamysAvcActivateUpdate::AplArkamysAvcActivateUpdate (int32 aplArkamysAvcActivate_)  :
    _aplArkamysAvcActivate (aplArkamysAvcActivate_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  AplArkamysAvcActivateUpdate::~AplArkamysAvcActivateUpdate() {
}

inline AplArkamysAvcActivateUpdate& AplArkamysAvcActivateUpdate::operator = (const AplArkamysAvcActivateUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasAplArkamysAvcActivate()) {
            setAplArkamysAvcActivate(rhs.getAplArkamysAvcActivate());
        } else {
            clearAplArkamysAvcActivate();
        }
    }
    return *this;
}

inline bool AplArkamysAvcActivateUpdate::operator == (const AplArkamysAvcActivateUpdate& rhs) const {
    return (((!hasAplArkamysAvcActivate() && !rhs.hasAplArkamysAvcActivate()) || getAplArkamysAvcActivate() == rhs.getAplArkamysAvcActivate()));
}

inline bool AplArkamysAvcActivateUpdate::operator != (const AplArkamysAvcActivateUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool AplArkamysAvcActivateUpdate::operator < (const AplArkamysAvcActivateUpdate& rhs) const {
    if (hasAplArkamysAvcActivate() || rhs.hasAplArkamysAvcActivate()) {
        if (getAplArkamysAvcActivate() < rhs.getAplArkamysAvcActivate()) return true;
        if (getAplArkamysAvcActivate() > rhs.getAplArkamysAvcActivate()) return false;
    }
    return false;
}

inline ::asf::core::Payload* AplArkamysAvcActivateUpdate::clone() {
    return new AplArkamysAvcActivateUpdate(*this);
}

inline bool AplArkamysAvcActivateUpdate::operator > (const AplArkamysAvcActivateUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void AplArkamysAvcActivateUpdate::clear() {
    clearAplArkamysAvcActivate();
}

inline void AplArkamysAvcActivateUpdate::clearAplArkamysAvcActivate() {
    if (hasAplArkamysAvcActivate()) {
         clear_has_aplArkamysAvcActivate();
        _aplArkamysAvcActivate = 0;
     }
}

inline bool AplArkamysAvcActivateUpdate::hasAplArkamysAvcActivate () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline int32 AplArkamysAvcActivateUpdate::getAplArkamysAvcActivate () const {
    return _aplArkamysAvcActivate;
}

inline void AplArkamysAvcActivateUpdate::setAplArkamysAvcActivate (int32 aplArkamysAvcActivate_) {
    set_has_aplArkamysAvcActivate();
    this->_aplArkamysAvcActivate = aplArkamysAvcActivate_;
}

inline void AplArkamysAvcActivateUpdate::set_has_aplArkamysAvcActivate () {
    _has_bits_[0] |= 1u << 0;
}

inline void AplArkamysAvcActivateUpdate::clear_has_aplArkamysAvcActivate () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  AplArkamysAvcActivateRegister::AplArkamysAvcActivateRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  AplArkamysAvcActivateRegister::AplArkamysAvcActivateRegister (const AplArkamysAvcActivateRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  AplArkamysAvcActivateRegister::~AplArkamysAvcActivateRegister() {
}

inline AplArkamysAvcActivateRegister& AplArkamysAvcActivateRegister::operator = (const AplArkamysAvcActivateRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool AplArkamysAvcActivateRegister::operator == (const AplArkamysAvcActivateRegister& ) const {
    return true;
}

inline bool AplArkamysAvcActivateRegister::operator != (const AplArkamysAvcActivateRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool AplArkamysAvcActivateRegister::operator < (const AplArkamysAvcActivateRegister& ) const {
    return false;
}

inline ::asf::core::Payload* AplArkamysAvcActivateRegister::clone() {
    return new AplArkamysAvcActivateRegister(*this);
}

inline bool AplArkamysAvcActivateRegister::operator > (const AplArkamysAvcActivateRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void AplArkamysAvcActivateRegister::clear() {
}

inline  AplArkamysByPassActivateUpdate::AplArkamysByPassActivateUpdate ()  :
    _aplArkamysByPassActivate (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  AplArkamysByPassActivateUpdate::AplArkamysByPassActivateUpdate (const AplArkamysByPassActivateUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _aplArkamysByPassActivate (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  AplArkamysByPassActivateUpdate::AplArkamysByPassActivateUpdate (int32 aplArkamysByPassActivate_)  :
    _aplArkamysByPassActivate (aplArkamysByPassActivate_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  AplArkamysByPassActivateUpdate::~AplArkamysByPassActivateUpdate() {
}

inline AplArkamysByPassActivateUpdate& AplArkamysByPassActivateUpdate::operator = (const AplArkamysByPassActivateUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasAplArkamysByPassActivate()) {
            setAplArkamysByPassActivate(rhs.getAplArkamysByPassActivate());
        } else {
            clearAplArkamysByPassActivate();
        }
    }
    return *this;
}

inline bool AplArkamysByPassActivateUpdate::operator == (const AplArkamysByPassActivateUpdate& rhs) const {
    return (((!hasAplArkamysByPassActivate() && !rhs.hasAplArkamysByPassActivate()) || getAplArkamysByPassActivate() == rhs.getAplArkamysByPassActivate()));
}

inline bool AplArkamysByPassActivateUpdate::operator != (const AplArkamysByPassActivateUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool AplArkamysByPassActivateUpdate::operator < (const AplArkamysByPassActivateUpdate& rhs) const {
    if (hasAplArkamysByPassActivate() || rhs.hasAplArkamysByPassActivate()) {
        if (getAplArkamysByPassActivate() < rhs.getAplArkamysByPassActivate()) return true;
        if (getAplArkamysByPassActivate() > rhs.getAplArkamysByPassActivate()) return false;
    }
    return false;
}

inline ::asf::core::Payload* AplArkamysByPassActivateUpdate::clone() {
    return new AplArkamysByPassActivateUpdate(*this);
}

inline bool AplArkamysByPassActivateUpdate::operator > (const AplArkamysByPassActivateUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void AplArkamysByPassActivateUpdate::clear() {
    clearAplArkamysByPassActivate();
}

inline void AplArkamysByPassActivateUpdate::clearAplArkamysByPassActivate() {
    if (hasAplArkamysByPassActivate()) {
         clear_has_aplArkamysByPassActivate();
        _aplArkamysByPassActivate = 0;
     }
}

inline bool AplArkamysByPassActivateUpdate::hasAplArkamysByPassActivate () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline int32 AplArkamysByPassActivateUpdate::getAplArkamysByPassActivate () const {
    return _aplArkamysByPassActivate;
}

inline void AplArkamysByPassActivateUpdate::setAplArkamysByPassActivate (int32 aplArkamysByPassActivate_) {
    set_has_aplArkamysByPassActivate();
    this->_aplArkamysByPassActivate = aplArkamysByPassActivate_;
}

inline void AplArkamysByPassActivateUpdate::set_has_aplArkamysByPassActivate () {
    _has_bits_[0] |= 1u << 0;
}

inline void AplArkamysByPassActivateUpdate::clear_has_aplArkamysByPassActivate () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  AplArkamysByPassActivateRegister::AplArkamysByPassActivateRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  AplArkamysByPassActivateRegister::AplArkamysByPassActivateRegister (const AplArkamysByPassActivateRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  AplArkamysByPassActivateRegister::~AplArkamysByPassActivateRegister() {
}

inline AplArkamysByPassActivateRegister& AplArkamysByPassActivateRegister::operator = (const AplArkamysByPassActivateRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool AplArkamysByPassActivateRegister::operator == (const AplArkamysByPassActivateRegister& ) const {
    return true;
}

inline bool AplArkamysByPassActivateRegister::operator != (const AplArkamysByPassActivateRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool AplArkamysByPassActivateRegister::operator < (const AplArkamysByPassActivateRegister& ) const {
    return false;
}

inline ::asf::core::Payload* AplArkamysByPassActivateRegister::clone() {
    return new AplArkamysByPassActivateRegister(*this);
}

inline bool AplArkamysByPassActivateRegister::operator > (const AplArkamysByPassActivateRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void AplArkamysByPassActivateRegister::clear() {
}

inline  AplArkamysInputLevelDeviationUpdate::AplArkamysInputLevelDeviationUpdate ()  :
    _aplArkamysInputLevelDeviation (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  AplArkamysInputLevelDeviationUpdate::AplArkamysInputLevelDeviationUpdate (const AplArkamysInputLevelDeviationUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _aplArkamysInputLevelDeviation (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  AplArkamysInputLevelDeviationUpdate::AplArkamysInputLevelDeviationUpdate (int32 aplArkamysInputLevelDeviation_)  :
    _aplArkamysInputLevelDeviation (aplArkamysInputLevelDeviation_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  AplArkamysInputLevelDeviationUpdate::~AplArkamysInputLevelDeviationUpdate() {
}

inline AplArkamysInputLevelDeviationUpdate& AplArkamysInputLevelDeviationUpdate::operator = (const AplArkamysInputLevelDeviationUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasAplArkamysInputLevelDeviation()) {
            setAplArkamysInputLevelDeviation(rhs.getAplArkamysInputLevelDeviation());
        } else {
            clearAplArkamysInputLevelDeviation();
        }
    }
    return *this;
}

inline bool AplArkamysInputLevelDeviationUpdate::operator == (const AplArkamysInputLevelDeviationUpdate& rhs) const {
    return (((!hasAplArkamysInputLevelDeviation() && !rhs.hasAplArkamysInputLevelDeviation()) || getAplArkamysInputLevelDeviation() == rhs.getAplArkamysInputLevelDeviation()));
}

inline bool AplArkamysInputLevelDeviationUpdate::operator != (const AplArkamysInputLevelDeviationUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool AplArkamysInputLevelDeviationUpdate::operator < (const AplArkamysInputLevelDeviationUpdate& rhs) const {
    if (hasAplArkamysInputLevelDeviation() || rhs.hasAplArkamysInputLevelDeviation()) {
        if (getAplArkamysInputLevelDeviation() < rhs.getAplArkamysInputLevelDeviation()) return true;
        if (getAplArkamysInputLevelDeviation() > rhs.getAplArkamysInputLevelDeviation()) return false;
    }
    return false;
}

inline ::asf::core::Payload* AplArkamysInputLevelDeviationUpdate::clone() {
    return new AplArkamysInputLevelDeviationUpdate(*this);
}

inline bool AplArkamysInputLevelDeviationUpdate::operator > (const AplArkamysInputLevelDeviationUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void AplArkamysInputLevelDeviationUpdate::clear() {
    clearAplArkamysInputLevelDeviation();
}

inline void AplArkamysInputLevelDeviationUpdate::clearAplArkamysInputLevelDeviation() {
    if (hasAplArkamysInputLevelDeviation()) {
         clear_has_aplArkamysInputLevelDeviation();
        _aplArkamysInputLevelDeviation = 0;
     }
}

inline bool AplArkamysInputLevelDeviationUpdate::hasAplArkamysInputLevelDeviation () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline int32 AplArkamysInputLevelDeviationUpdate::getAplArkamysInputLevelDeviation () const {
    return _aplArkamysInputLevelDeviation;
}

inline void AplArkamysInputLevelDeviationUpdate::setAplArkamysInputLevelDeviation (int32 aplArkamysInputLevelDeviation_) {
    set_has_aplArkamysInputLevelDeviation();
    this->_aplArkamysInputLevelDeviation = aplArkamysInputLevelDeviation_;
}

inline void AplArkamysInputLevelDeviationUpdate::set_has_aplArkamysInputLevelDeviation () {
    _has_bits_[0] |= 1u << 0;
}

inline void AplArkamysInputLevelDeviationUpdate::clear_has_aplArkamysInputLevelDeviation () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  AplArkamysInputLevelDeviationRegister::AplArkamysInputLevelDeviationRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  AplArkamysInputLevelDeviationRegister::AplArkamysInputLevelDeviationRegister (const AplArkamysInputLevelDeviationRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  AplArkamysInputLevelDeviationRegister::~AplArkamysInputLevelDeviationRegister() {
}

inline AplArkamysInputLevelDeviationRegister& AplArkamysInputLevelDeviationRegister::operator = (const AplArkamysInputLevelDeviationRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool AplArkamysInputLevelDeviationRegister::operator == (const AplArkamysInputLevelDeviationRegister& ) const {
    return true;
}

inline bool AplArkamysInputLevelDeviationRegister::operator != (const AplArkamysInputLevelDeviationRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool AplArkamysInputLevelDeviationRegister::operator < (const AplArkamysInputLevelDeviationRegister& ) const {
    return false;
}

inline ::asf::core::Payload* AplArkamysInputLevelDeviationRegister::clone() {
    return new AplArkamysInputLevelDeviationRegister(*this);
}

inline bool AplArkamysInputLevelDeviationRegister::operator > (const AplArkamysInputLevelDeviationRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void AplArkamysInputLevelDeviationRegister::clear() {
}

inline  AplArkamysCurrentSpeedUpdate::AplArkamysCurrentSpeedUpdate ()  :
    _aplArkamysCurrentSpeed (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  AplArkamysCurrentSpeedUpdate::AplArkamysCurrentSpeedUpdate (const AplArkamysCurrentSpeedUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _aplArkamysCurrentSpeed (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  AplArkamysCurrentSpeedUpdate::AplArkamysCurrentSpeedUpdate (int32 aplArkamysCurrentSpeed_)  :
    _aplArkamysCurrentSpeed (aplArkamysCurrentSpeed_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  AplArkamysCurrentSpeedUpdate::~AplArkamysCurrentSpeedUpdate() {
}

inline AplArkamysCurrentSpeedUpdate& AplArkamysCurrentSpeedUpdate::operator = (const AplArkamysCurrentSpeedUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasAplArkamysCurrentSpeed()) {
            setAplArkamysCurrentSpeed(rhs.getAplArkamysCurrentSpeed());
        } else {
            clearAplArkamysCurrentSpeed();
        }
    }
    return *this;
}

inline bool AplArkamysCurrentSpeedUpdate::operator == (const AplArkamysCurrentSpeedUpdate& rhs) const {
    return (((!hasAplArkamysCurrentSpeed() && !rhs.hasAplArkamysCurrentSpeed()) || getAplArkamysCurrentSpeed() == rhs.getAplArkamysCurrentSpeed()));
}

inline bool AplArkamysCurrentSpeedUpdate::operator != (const AplArkamysCurrentSpeedUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool AplArkamysCurrentSpeedUpdate::operator < (const AplArkamysCurrentSpeedUpdate& rhs) const {
    if (hasAplArkamysCurrentSpeed() || rhs.hasAplArkamysCurrentSpeed()) {
        if (getAplArkamysCurrentSpeed() < rhs.getAplArkamysCurrentSpeed()) return true;
        if (getAplArkamysCurrentSpeed() > rhs.getAplArkamysCurrentSpeed()) return false;
    }
    return false;
}

inline ::asf::core::Payload* AplArkamysCurrentSpeedUpdate::clone() {
    return new AplArkamysCurrentSpeedUpdate(*this);
}

inline bool AplArkamysCurrentSpeedUpdate::operator > (const AplArkamysCurrentSpeedUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void AplArkamysCurrentSpeedUpdate::clear() {
    clearAplArkamysCurrentSpeed();
}

inline void AplArkamysCurrentSpeedUpdate::clearAplArkamysCurrentSpeed() {
    if (hasAplArkamysCurrentSpeed()) {
         clear_has_aplArkamysCurrentSpeed();
        _aplArkamysCurrentSpeed = 0;
     }
}

inline bool AplArkamysCurrentSpeedUpdate::hasAplArkamysCurrentSpeed () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline int32 AplArkamysCurrentSpeedUpdate::getAplArkamysCurrentSpeed () const {
    return _aplArkamysCurrentSpeed;
}

inline void AplArkamysCurrentSpeedUpdate::setAplArkamysCurrentSpeed (int32 aplArkamysCurrentSpeed_) {
    set_has_aplArkamysCurrentSpeed();
    this->_aplArkamysCurrentSpeed = aplArkamysCurrentSpeed_;
}

inline void AplArkamysCurrentSpeedUpdate::set_has_aplArkamysCurrentSpeed () {
    _has_bits_[0] |= 1u << 0;
}

inline void AplArkamysCurrentSpeedUpdate::clear_has_aplArkamysCurrentSpeed () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  AplArkamysCurrentSpeedRegister::AplArkamysCurrentSpeedRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  AplArkamysCurrentSpeedRegister::AplArkamysCurrentSpeedRegister (const AplArkamysCurrentSpeedRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  AplArkamysCurrentSpeedRegister::~AplArkamysCurrentSpeedRegister() {
}

inline AplArkamysCurrentSpeedRegister& AplArkamysCurrentSpeedRegister::operator = (const AplArkamysCurrentSpeedRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool AplArkamysCurrentSpeedRegister::operator == (const AplArkamysCurrentSpeedRegister& ) const {
    return true;
}

inline bool AplArkamysCurrentSpeedRegister::operator != (const AplArkamysCurrentSpeedRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool AplArkamysCurrentSpeedRegister::operator < (const AplArkamysCurrentSpeedRegister& ) const {
    return false;
}

inline ::asf::core::Payload* AplArkamysCurrentSpeedRegister::clone() {
    return new AplArkamysCurrentSpeedRegister(*this);
}

inline bool AplArkamysCurrentSpeedRegister::operator > (const AplArkamysCurrentSpeedRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void AplArkamysCurrentSpeedRegister::clear() {
}

inline  AplArkamysCurrentVolumeStepUpdate::AplArkamysCurrentVolumeStepUpdate ()  :
    _aplArkamysCurrentVolumeStep (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  AplArkamysCurrentVolumeStepUpdate::AplArkamysCurrentVolumeStepUpdate (const AplArkamysCurrentVolumeStepUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _aplArkamysCurrentVolumeStep (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  AplArkamysCurrentVolumeStepUpdate::AplArkamysCurrentVolumeStepUpdate (int32 aplArkamysCurrentVolumeStep_)  :
    _aplArkamysCurrentVolumeStep (aplArkamysCurrentVolumeStep_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  AplArkamysCurrentVolumeStepUpdate::~AplArkamysCurrentVolumeStepUpdate() {
}

inline AplArkamysCurrentVolumeStepUpdate& AplArkamysCurrentVolumeStepUpdate::operator = (const AplArkamysCurrentVolumeStepUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasAplArkamysCurrentVolumeStep()) {
            setAplArkamysCurrentVolumeStep(rhs.getAplArkamysCurrentVolumeStep());
        } else {
            clearAplArkamysCurrentVolumeStep();
        }
    }
    return *this;
}

inline bool AplArkamysCurrentVolumeStepUpdate::operator == (const AplArkamysCurrentVolumeStepUpdate& rhs) const {
    return (((!hasAplArkamysCurrentVolumeStep() && !rhs.hasAplArkamysCurrentVolumeStep()) || getAplArkamysCurrentVolumeStep() == rhs.getAplArkamysCurrentVolumeStep()));
}

inline bool AplArkamysCurrentVolumeStepUpdate::operator != (const AplArkamysCurrentVolumeStepUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool AplArkamysCurrentVolumeStepUpdate::operator < (const AplArkamysCurrentVolumeStepUpdate& rhs) const {
    if (hasAplArkamysCurrentVolumeStep() || rhs.hasAplArkamysCurrentVolumeStep()) {
        if (getAplArkamysCurrentVolumeStep() < rhs.getAplArkamysCurrentVolumeStep()) return true;
        if (getAplArkamysCurrentVolumeStep() > rhs.getAplArkamysCurrentVolumeStep()) return false;
    }
    return false;
}

inline ::asf::core::Payload* AplArkamysCurrentVolumeStepUpdate::clone() {
    return new AplArkamysCurrentVolumeStepUpdate(*this);
}

inline bool AplArkamysCurrentVolumeStepUpdate::operator > (const AplArkamysCurrentVolumeStepUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void AplArkamysCurrentVolumeStepUpdate::clear() {
    clearAplArkamysCurrentVolumeStep();
}

inline void AplArkamysCurrentVolumeStepUpdate::clearAplArkamysCurrentVolumeStep() {
    if (hasAplArkamysCurrentVolumeStep()) {
         clear_has_aplArkamysCurrentVolumeStep();
        _aplArkamysCurrentVolumeStep = 0;
     }
}

inline bool AplArkamysCurrentVolumeStepUpdate::hasAplArkamysCurrentVolumeStep () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline int32 AplArkamysCurrentVolumeStepUpdate::getAplArkamysCurrentVolumeStep () const {
    return _aplArkamysCurrentVolumeStep;
}

inline void AplArkamysCurrentVolumeStepUpdate::setAplArkamysCurrentVolumeStep (int32 aplArkamysCurrentVolumeStep_) {
    set_has_aplArkamysCurrentVolumeStep();
    this->_aplArkamysCurrentVolumeStep = aplArkamysCurrentVolumeStep_;
}

inline void AplArkamysCurrentVolumeStepUpdate::set_has_aplArkamysCurrentVolumeStep () {
    _has_bits_[0] |= 1u << 0;
}

inline void AplArkamysCurrentVolumeStepUpdate::clear_has_aplArkamysCurrentVolumeStep () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  AplArkamysCurrentVolumeStepRegister::AplArkamysCurrentVolumeStepRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  AplArkamysCurrentVolumeStepRegister::AplArkamysCurrentVolumeStepRegister (const AplArkamysCurrentVolumeStepRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  AplArkamysCurrentVolumeStepRegister::~AplArkamysCurrentVolumeStepRegister() {
}

inline AplArkamysCurrentVolumeStepRegister& AplArkamysCurrentVolumeStepRegister::operator = (const AplArkamysCurrentVolumeStepRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool AplArkamysCurrentVolumeStepRegister::operator == (const AplArkamysCurrentVolumeStepRegister& ) const {
    return true;
}

inline bool AplArkamysCurrentVolumeStepRegister::operator != (const AplArkamysCurrentVolumeStepRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool AplArkamysCurrentVolumeStepRegister::operator < (const AplArkamysCurrentVolumeStepRegister& ) const {
    return false;
}

inline ::asf::core::Payload* AplArkamysCurrentVolumeStepRegister::clone() {
    return new AplArkamysCurrentVolumeStepRegister(*this);
}

inline bool AplArkamysCurrentVolumeStepRegister::operator > (const AplArkamysCurrentVolumeStepRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void AplArkamysCurrentVolumeStepRegister::clear() {
}

inline  AplArkamysAmbienceSelectUpdate::AplArkamysAmbienceSelectUpdate ()  :
    _aplArkamysAmbienceSelect (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  AplArkamysAmbienceSelectUpdate::AplArkamysAmbienceSelectUpdate (const AplArkamysAmbienceSelectUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _aplArkamysAmbienceSelect (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  AplArkamysAmbienceSelectUpdate::AplArkamysAmbienceSelectUpdate (int32 aplArkamysAmbienceSelect_)  :
    _aplArkamysAmbienceSelect (aplArkamysAmbienceSelect_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  AplArkamysAmbienceSelectUpdate::~AplArkamysAmbienceSelectUpdate() {
}

inline AplArkamysAmbienceSelectUpdate& AplArkamysAmbienceSelectUpdate::operator = (const AplArkamysAmbienceSelectUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasAplArkamysAmbienceSelect()) {
            setAplArkamysAmbienceSelect(rhs.getAplArkamysAmbienceSelect());
        } else {
            clearAplArkamysAmbienceSelect();
        }
    }
    return *this;
}

inline bool AplArkamysAmbienceSelectUpdate::operator == (const AplArkamysAmbienceSelectUpdate& rhs) const {
    return (((!hasAplArkamysAmbienceSelect() && !rhs.hasAplArkamysAmbienceSelect()) || getAplArkamysAmbienceSelect() == rhs.getAplArkamysAmbienceSelect()));
}

inline bool AplArkamysAmbienceSelectUpdate::operator != (const AplArkamysAmbienceSelectUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool AplArkamysAmbienceSelectUpdate::operator < (const AplArkamysAmbienceSelectUpdate& rhs) const {
    if (hasAplArkamysAmbienceSelect() || rhs.hasAplArkamysAmbienceSelect()) {
        if (getAplArkamysAmbienceSelect() < rhs.getAplArkamysAmbienceSelect()) return true;
        if (getAplArkamysAmbienceSelect() > rhs.getAplArkamysAmbienceSelect()) return false;
    }
    return false;
}

inline ::asf::core::Payload* AplArkamysAmbienceSelectUpdate::clone() {
    return new AplArkamysAmbienceSelectUpdate(*this);
}

inline bool AplArkamysAmbienceSelectUpdate::operator > (const AplArkamysAmbienceSelectUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void AplArkamysAmbienceSelectUpdate::clear() {
    clearAplArkamysAmbienceSelect();
}

inline void AplArkamysAmbienceSelectUpdate::clearAplArkamysAmbienceSelect() {
    if (hasAplArkamysAmbienceSelect()) {
         clear_has_aplArkamysAmbienceSelect();
        _aplArkamysAmbienceSelect = 0;
     }
}

inline bool AplArkamysAmbienceSelectUpdate::hasAplArkamysAmbienceSelect () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline int32 AplArkamysAmbienceSelectUpdate::getAplArkamysAmbienceSelect () const {
    return _aplArkamysAmbienceSelect;
}

inline void AplArkamysAmbienceSelectUpdate::setAplArkamysAmbienceSelect (int32 aplArkamysAmbienceSelect_) {
    set_has_aplArkamysAmbienceSelect();
    this->_aplArkamysAmbienceSelect = aplArkamysAmbienceSelect_;
}

inline void AplArkamysAmbienceSelectUpdate::set_has_aplArkamysAmbienceSelect () {
    _has_bits_[0] |= 1u << 0;
}

inline void AplArkamysAmbienceSelectUpdate::clear_has_aplArkamysAmbienceSelect () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  AplArkamysAmbienceSelectRegister::AplArkamysAmbienceSelectRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  AplArkamysAmbienceSelectRegister::AplArkamysAmbienceSelectRegister (const AplArkamysAmbienceSelectRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  AplArkamysAmbienceSelectRegister::~AplArkamysAmbienceSelectRegister() {
}

inline AplArkamysAmbienceSelectRegister& AplArkamysAmbienceSelectRegister::operator = (const AplArkamysAmbienceSelectRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool AplArkamysAmbienceSelectRegister::operator == (const AplArkamysAmbienceSelectRegister& ) const {
    return true;
}

inline bool AplArkamysAmbienceSelectRegister::operator != (const AplArkamysAmbienceSelectRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool AplArkamysAmbienceSelectRegister::operator < (const AplArkamysAmbienceSelectRegister& ) const {
    return false;
}

inline ::asf::core::Payload* AplArkamysAmbienceSelectRegister::clone() {
    return new AplArkamysAmbienceSelectRegister(*this);
}

inline bool AplArkamysAmbienceSelectRegister::operator > (const AplArkamysAmbienceSelectRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void AplArkamysAmbienceSelectRegister::clear() {
}

inline  AplArkamysLevelLossUpdate::AplArkamysLevelLossUpdate ()  :
    _aplArkamysLevelLoss (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  AplArkamysLevelLossUpdate::AplArkamysLevelLossUpdate (const AplArkamysLevelLossUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _aplArkamysLevelLoss (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  AplArkamysLevelLossUpdate::AplArkamysLevelLossUpdate (int32 aplArkamysLevelLoss_)  :
    _aplArkamysLevelLoss (aplArkamysLevelLoss_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  AplArkamysLevelLossUpdate::~AplArkamysLevelLossUpdate() {
}

inline AplArkamysLevelLossUpdate& AplArkamysLevelLossUpdate::operator = (const AplArkamysLevelLossUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasAplArkamysLevelLoss()) {
            setAplArkamysLevelLoss(rhs.getAplArkamysLevelLoss());
        } else {
            clearAplArkamysLevelLoss();
        }
    }
    return *this;
}

inline bool AplArkamysLevelLossUpdate::operator == (const AplArkamysLevelLossUpdate& rhs) const {
    return (((!hasAplArkamysLevelLoss() && !rhs.hasAplArkamysLevelLoss()) || getAplArkamysLevelLoss() == rhs.getAplArkamysLevelLoss()));
}

inline bool AplArkamysLevelLossUpdate::operator != (const AplArkamysLevelLossUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool AplArkamysLevelLossUpdate::operator < (const AplArkamysLevelLossUpdate& rhs) const {
    if (hasAplArkamysLevelLoss() || rhs.hasAplArkamysLevelLoss()) {
        if (getAplArkamysLevelLoss() < rhs.getAplArkamysLevelLoss()) return true;
        if (getAplArkamysLevelLoss() > rhs.getAplArkamysLevelLoss()) return false;
    }
    return false;
}

inline ::asf::core::Payload* AplArkamysLevelLossUpdate::clone() {
    return new AplArkamysLevelLossUpdate(*this);
}

inline bool AplArkamysLevelLossUpdate::operator > (const AplArkamysLevelLossUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void AplArkamysLevelLossUpdate::clear() {
    clearAplArkamysLevelLoss();
}

inline void AplArkamysLevelLossUpdate::clearAplArkamysLevelLoss() {
    if (hasAplArkamysLevelLoss()) {
         clear_has_aplArkamysLevelLoss();
        _aplArkamysLevelLoss = 0;
     }
}

inline bool AplArkamysLevelLossUpdate::hasAplArkamysLevelLoss () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline int32 AplArkamysLevelLossUpdate::getAplArkamysLevelLoss () const {
    return _aplArkamysLevelLoss;
}

inline void AplArkamysLevelLossUpdate::setAplArkamysLevelLoss (int32 aplArkamysLevelLoss_) {
    set_has_aplArkamysLevelLoss();
    this->_aplArkamysLevelLoss = aplArkamysLevelLoss_;
}

inline void AplArkamysLevelLossUpdate::set_has_aplArkamysLevelLoss () {
    _has_bits_[0] |= 1u << 0;
}

inline void AplArkamysLevelLossUpdate::clear_has_aplArkamysLevelLoss () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  AplArkamysLevelLossRegister::AplArkamysLevelLossRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  AplArkamysLevelLossRegister::AplArkamysLevelLossRegister (const AplArkamysLevelLossRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  AplArkamysLevelLossRegister::~AplArkamysLevelLossRegister() {
}

inline AplArkamysLevelLossRegister& AplArkamysLevelLossRegister::operator = (const AplArkamysLevelLossRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool AplArkamysLevelLossRegister::operator == (const AplArkamysLevelLossRegister& ) const {
    return true;
}

inline bool AplArkamysLevelLossRegister::operator != (const AplArkamysLevelLossRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool AplArkamysLevelLossRegister::operator < (const AplArkamysLevelLossRegister& ) const {
    return false;
}

inline ::asf::core::Payload* AplArkamysLevelLossRegister::clone() {
    return new AplArkamysLevelLossRegister(*this);
}

inline bool AplArkamysLevelLossRegister::operator > (const AplArkamysLevelLossRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void AplArkamysLevelLossRegister::clear() {
}

inline  AplArkamysLibraryVersionUpdate::AplArkamysLibraryVersionUpdate ()  :
    _aplArkamysLibraryVersion ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  AplArkamysLibraryVersionUpdate::AplArkamysLibraryVersionUpdate (const AplArkamysLibraryVersionUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _aplArkamysLibraryVersion ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  AplArkamysLibraryVersionUpdate::AplArkamysLibraryVersionUpdate (const ::std::vector< int32 >& aplArkamysLibraryVersion_)  :
    _aplArkamysLibraryVersion (aplArkamysLibraryVersion_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  AplArkamysLibraryVersionUpdate::~AplArkamysLibraryVersionUpdate() {
}

inline AplArkamysLibraryVersionUpdate& AplArkamysLibraryVersionUpdate::operator = (const AplArkamysLibraryVersionUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasAplArkamysLibraryVersion()) {
            setAplArkamysLibraryVersion(rhs.getAplArkamysLibraryVersion());
        } else {
            clearAplArkamysLibraryVersion();
        }
    }
    return *this;
}

inline bool AplArkamysLibraryVersionUpdate::operator == (const AplArkamysLibraryVersionUpdate& rhs) const {
    return (((!hasAplArkamysLibraryVersion() && !rhs.hasAplArkamysLibraryVersion()) || getAplArkamysLibraryVersion() == rhs.getAplArkamysLibraryVersion()));
}

inline bool AplArkamysLibraryVersionUpdate::operator != (const AplArkamysLibraryVersionUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool AplArkamysLibraryVersionUpdate::operator < (const AplArkamysLibraryVersionUpdate& rhs) const {
    if (hasAplArkamysLibraryVersion() || rhs.hasAplArkamysLibraryVersion()) {
        if (getAplArkamysLibraryVersion() < rhs.getAplArkamysLibraryVersion()) return true;
        if (getAplArkamysLibraryVersion() > rhs.getAplArkamysLibraryVersion()) return false;
    }
    return false;
}

inline ::asf::core::Payload* AplArkamysLibraryVersionUpdate::clone() {
    return new AplArkamysLibraryVersionUpdate(*this);
}

inline bool AplArkamysLibraryVersionUpdate::operator > (const AplArkamysLibraryVersionUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void AplArkamysLibraryVersionUpdate::clear() {
    clearAplArkamysLibraryVersion();
}

inline void AplArkamysLibraryVersionUpdate::clearAplArkamysLibraryVersion() {
    if (hasAplArkamysLibraryVersion()) {
         clear_has_aplArkamysLibraryVersion();
        _aplArkamysLibraryVersion.clear();
     }
}

inline bool AplArkamysLibraryVersionUpdate::hasAplArkamysLibraryVersion () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< int32 >& AplArkamysLibraryVersionUpdate::getAplArkamysLibraryVersion () const {
    return _aplArkamysLibraryVersion;
}

inline ::std::vector< int32 >& AplArkamysLibraryVersionUpdate::getAplArkamysLibraryVersionMutable () {
    set_has_aplArkamysLibraryVersion();
    return _aplArkamysLibraryVersion;
}

inline void AplArkamysLibraryVersionUpdate::setAplArkamysLibraryVersion (const ::std::vector< int32 >& aplArkamysLibraryVersion_) {
    set_has_aplArkamysLibraryVersion();
    this->_aplArkamysLibraryVersion = aplArkamysLibraryVersion_;
}

inline void AplArkamysLibraryVersionUpdate::set_has_aplArkamysLibraryVersion () {
    _has_bits_[0] |= 1u << 0;
}

inline void AplArkamysLibraryVersionUpdate::clear_has_aplArkamysLibraryVersion () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  AplArkamysLibraryVersionRegister::AplArkamysLibraryVersionRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  AplArkamysLibraryVersionRegister::AplArkamysLibraryVersionRegister (const AplArkamysLibraryVersionRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  AplArkamysLibraryVersionRegister::~AplArkamysLibraryVersionRegister() {
}

inline AplArkamysLibraryVersionRegister& AplArkamysLibraryVersionRegister::operator = (const AplArkamysLibraryVersionRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool AplArkamysLibraryVersionRegister::operator == (const AplArkamysLibraryVersionRegister& ) const {
    return true;
}

inline bool AplArkamysLibraryVersionRegister::operator != (const AplArkamysLibraryVersionRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool AplArkamysLibraryVersionRegister::operator < (const AplArkamysLibraryVersionRegister& ) const {
    return false;
}

inline ::asf::core::Payload* AplArkamysLibraryVersionRegister::clone() {
    return new AplArkamysLibraryVersionRegister(*this);
}

inline bool AplArkamysLibraryVersionRegister::operator > (const AplArkamysLibraryVersionRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void AplArkamysLibraryVersionRegister::clear() {
}

inline  AplArkamysCurrVolAttenuationUpdate::AplArkamysCurrVolAttenuationUpdate ()  :
    _aplArkamysCurrVolAttenuation (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  AplArkamysCurrVolAttenuationUpdate::AplArkamysCurrVolAttenuationUpdate (const AplArkamysCurrVolAttenuationUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _aplArkamysCurrVolAttenuation (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  AplArkamysCurrVolAttenuationUpdate::AplArkamysCurrVolAttenuationUpdate (int32 aplArkamysCurrVolAttenuation_)  :
    _aplArkamysCurrVolAttenuation (aplArkamysCurrVolAttenuation_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  AplArkamysCurrVolAttenuationUpdate::~AplArkamysCurrVolAttenuationUpdate() {
}

inline AplArkamysCurrVolAttenuationUpdate& AplArkamysCurrVolAttenuationUpdate::operator = (const AplArkamysCurrVolAttenuationUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasAplArkamysCurrVolAttenuation()) {
            setAplArkamysCurrVolAttenuation(rhs.getAplArkamysCurrVolAttenuation());
        } else {
            clearAplArkamysCurrVolAttenuation();
        }
    }
    return *this;
}

inline bool AplArkamysCurrVolAttenuationUpdate::operator == (const AplArkamysCurrVolAttenuationUpdate& rhs) const {
    return (((!hasAplArkamysCurrVolAttenuation() && !rhs.hasAplArkamysCurrVolAttenuation()) || getAplArkamysCurrVolAttenuation() == rhs.getAplArkamysCurrVolAttenuation()));
}

inline bool AplArkamysCurrVolAttenuationUpdate::operator != (const AplArkamysCurrVolAttenuationUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool AplArkamysCurrVolAttenuationUpdate::operator < (const AplArkamysCurrVolAttenuationUpdate& rhs) const {
    if (hasAplArkamysCurrVolAttenuation() || rhs.hasAplArkamysCurrVolAttenuation()) {
        if (getAplArkamysCurrVolAttenuation() < rhs.getAplArkamysCurrVolAttenuation()) return true;
        if (getAplArkamysCurrVolAttenuation() > rhs.getAplArkamysCurrVolAttenuation()) return false;
    }
    return false;
}

inline ::asf::core::Payload* AplArkamysCurrVolAttenuationUpdate::clone() {
    return new AplArkamysCurrVolAttenuationUpdate(*this);
}

inline bool AplArkamysCurrVolAttenuationUpdate::operator > (const AplArkamysCurrVolAttenuationUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void AplArkamysCurrVolAttenuationUpdate::clear() {
    clearAplArkamysCurrVolAttenuation();
}

inline void AplArkamysCurrVolAttenuationUpdate::clearAplArkamysCurrVolAttenuation() {
    if (hasAplArkamysCurrVolAttenuation()) {
         clear_has_aplArkamysCurrVolAttenuation();
        _aplArkamysCurrVolAttenuation = 0;
     }
}

inline bool AplArkamysCurrVolAttenuationUpdate::hasAplArkamysCurrVolAttenuation () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline int32 AplArkamysCurrVolAttenuationUpdate::getAplArkamysCurrVolAttenuation () const {
    return _aplArkamysCurrVolAttenuation;
}

inline void AplArkamysCurrVolAttenuationUpdate::setAplArkamysCurrVolAttenuation (int32 aplArkamysCurrVolAttenuation_) {
    set_has_aplArkamysCurrVolAttenuation();
    this->_aplArkamysCurrVolAttenuation = aplArkamysCurrVolAttenuation_;
}

inline void AplArkamysCurrVolAttenuationUpdate::set_has_aplArkamysCurrVolAttenuation () {
    _has_bits_[0] |= 1u << 0;
}

inline void AplArkamysCurrVolAttenuationUpdate::clear_has_aplArkamysCurrVolAttenuation () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  AplArkamysCurrVolAttenuationRegister::AplArkamysCurrVolAttenuationRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  AplArkamysCurrVolAttenuationRegister::AplArkamysCurrVolAttenuationRegister (const AplArkamysCurrVolAttenuationRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  AplArkamysCurrVolAttenuationRegister::~AplArkamysCurrVolAttenuationRegister() {
}

inline AplArkamysCurrVolAttenuationRegister& AplArkamysCurrVolAttenuationRegister::operator = (const AplArkamysCurrVolAttenuationRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool AplArkamysCurrVolAttenuationRegister::operator == (const AplArkamysCurrVolAttenuationRegister& ) const {
    return true;
}

inline bool AplArkamysCurrVolAttenuationRegister::operator != (const AplArkamysCurrVolAttenuationRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool AplArkamysCurrVolAttenuationRegister::operator < (const AplArkamysCurrVolAttenuationRegister& ) const {
    return false;
}

inline ::asf::core::Payload* AplArkamysCurrVolAttenuationRegister::clone() {
    return new AplArkamysCurrVolAttenuationRegister(*this);
}

inline bool AplArkamysCurrVolAttenuationRegister::operator > (const AplArkamysCurrVolAttenuationRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void AplArkamysCurrVolAttenuationRegister::clear() {
}

inline  AplArkamysFlushUpdate::AplArkamysFlushUpdate ()  :
    _aplArkamysFlush (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  AplArkamysFlushUpdate::AplArkamysFlushUpdate (const AplArkamysFlushUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _aplArkamysFlush (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  AplArkamysFlushUpdate::AplArkamysFlushUpdate (int32 aplArkamysFlush_)  :
    _aplArkamysFlush (aplArkamysFlush_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  AplArkamysFlushUpdate::~AplArkamysFlushUpdate() {
}

inline AplArkamysFlushUpdate& AplArkamysFlushUpdate::operator = (const AplArkamysFlushUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasAplArkamysFlush()) {
            setAplArkamysFlush(rhs.getAplArkamysFlush());
        } else {
            clearAplArkamysFlush();
        }
    }
    return *this;
}

inline bool AplArkamysFlushUpdate::operator == (const AplArkamysFlushUpdate& rhs) const {
    return (((!hasAplArkamysFlush() && !rhs.hasAplArkamysFlush()) || getAplArkamysFlush() == rhs.getAplArkamysFlush()));
}

inline bool AplArkamysFlushUpdate::operator != (const AplArkamysFlushUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool AplArkamysFlushUpdate::operator < (const AplArkamysFlushUpdate& rhs) const {
    if (hasAplArkamysFlush() || rhs.hasAplArkamysFlush()) {
        if (getAplArkamysFlush() < rhs.getAplArkamysFlush()) return true;
        if (getAplArkamysFlush() > rhs.getAplArkamysFlush()) return false;
    }
    return false;
}

inline ::asf::core::Payload* AplArkamysFlushUpdate::clone() {
    return new AplArkamysFlushUpdate(*this);
}

inline bool AplArkamysFlushUpdate::operator > (const AplArkamysFlushUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void AplArkamysFlushUpdate::clear() {
    clearAplArkamysFlush();
}

inline void AplArkamysFlushUpdate::clearAplArkamysFlush() {
    if (hasAplArkamysFlush()) {
         clear_has_aplArkamysFlush();
        _aplArkamysFlush = 0;
     }
}

inline bool AplArkamysFlushUpdate::hasAplArkamysFlush () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline int32 AplArkamysFlushUpdate::getAplArkamysFlush () const {
    return _aplArkamysFlush;
}

inline void AplArkamysFlushUpdate::setAplArkamysFlush (int32 aplArkamysFlush_) {
    set_has_aplArkamysFlush();
    this->_aplArkamysFlush = aplArkamysFlush_;
}

inline void AplArkamysFlushUpdate::set_has_aplArkamysFlush () {
    _has_bits_[0] |= 1u << 0;
}

inline void AplArkamysFlushUpdate::clear_has_aplArkamysFlush () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  AplArkamysFlushRegister::AplArkamysFlushRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  AplArkamysFlushRegister::AplArkamysFlushRegister (const AplArkamysFlushRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  AplArkamysFlushRegister::~AplArkamysFlushRegister() {
}

inline AplArkamysFlushRegister& AplArkamysFlushRegister::operator = (const AplArkamysFlushRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool AplArkamysFlushRegister::operator == (const AplArkamysFlushRegister& ) const {
    return true;
}

inline bool AplArkamysFlushRegister::operator != (const AplArkamysFlushRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool AplArkamysFlushRegister::operator < (const AplArkamysFlushRegister& ) const {
    return false;
}

inline ::asf::core::Payload* AplArkamysFlushRegister::clone() {
    return new AplArkamysFlushRegister(*this);
}

inline bool AplArkamysFlushRegister::operator > (const AplArkamysFlushRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void AplArkamysFlushRegister::clear() {
}

inline  AplMicLvlWatchRefIntUpdate::AplMicLvlWatchRefIntUpdate ()  :
    _aplMicLvlWatchRefInt (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  AplMicLvlWatchRefIntUpdate::AplMicLvlWatchRefIntUpdate (const AplMicLvlWatchRefIntUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _aplMicLvlWatchRefInt (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  AplMicLvlWatchRefIntUpdate::AplMicLvlWatchRefIntUpdate (uint32 aplMicLvlWatchRefInt_)  :
    _aplMicLvlWatchRefInt (aplMicLvlWatchRefInt_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  AplMicLvlWatchRefIntUpdate::~AplMicLvlWatchRefIntUpdate() {
}

inline AplMicLvlWatchRefIntUpdate& AplMicLvlWatchRefIntUpdate::operator = (const AplMicLvlWatchRefIntUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasAplMicLvlWatchRefInt()) {
            setAplMicLvlWatchRefInt(rhs.getAplMicLvlWatchRefInt());
        } else {
            clearAplMicLvlWatchRefInt();
        }
    }
    return *this;
}

inline bool AplMicLvlWatchRefIntUpdate::operator == (const AplMicLvlWatchRefIntUpdate& rhs) const {
    return (((!hasAplMicLvlWatchRefInt() && !rhs.hasAplMicLvlWatchRefInt()) || getAplMicLvlWatchRefInt() == rhs.getAplMicLvlWatchRefInt()));
}

inline bool AplMicLvlWatchRefIntUpdate::operator != (const AplMicLvlWatchRefIntUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool AplMicLvlWatchRefIntUpdate::operator < (const AplMicLvlWatchRefIntUpdate& rhs) const {
    if (hasAplMicLvlWatchRefInt() || rhs.hasAplMicLvlWatchRefInt()) {
        if (getAplMicLvlWatchRefInt() < rhs.getAplMicLvlWatchRefInt()) return true;
        if (getAplMicLvlWatchRefInt() > rhs.getAplMicLvlWatchRefInt()) return false;
    }
    return false;
}

inline ::asf::core::Payload* AplMicLvlWatchRefIntUpdate::clone() {
    return new AplMicLvlWatchRefIntUpdate(*this);
}

inline bool AplMicLvlWatchRefIntUpdate::operator > (const AplMicLvlWatchRefIntUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void AplMicLvlWatchRefIntUpdate::clear() {
    clearAplMicLvlWatchRefInt();
}

inline void AplMicLvlWatchRefIntUpdate::clearAplMicLvlWatchRefInt() {
    if (hasAplMicLvlWatchRefInt()) {
         clear_has_aplMicLvlWatchRefInt();
        _aplMicLvlWatchRefInt = 0u;
     }
}

inline bool AplMicLvlWatchRefIntUpdate::hasAplMicLvlWatchRefInt () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 AplMicLvlWatchRefIntUpdate::getAplMicLvlWatchRefInt () const {
    return _aplMicLvlWatchRefInt;
}

inline void AplMicLvlWatchRefIntUpdate::setAplMicLvlWatchRefInt (uint32 aplMicLvlWatchRefInt_) {
    set_has_aplMicLvlWatchRefInt();
    this->_aplMicLvlWatchRefInt = aplMicLvlWatchRefInt_;
}

inline void AplMicLvlWatchRefIntUpdate::set_has_aplMicLvlWatchRefInt () {
    _has_bits_[0] |= 1u << 0;
}

inline void AplMicLvlWatchRefIntUpdate::clear_has_aplMicLvlWatchRefInt () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  AplMicLvlWatchRefIntRegister::AplMicLvlWatchRefIntRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  AplMicLvlWatchRefIntRegister::AplMicLvlWatchRefIntRegister (const AplMicLvlWatchRefIntRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  AplMicLvlWatchRefIntRegister::~AplMicLvlWatchRefIntRegister() {
}

inline AplMicLvlWatchRefIntRegister& AplMicLvlWatchRefIntRegister::operator = (const AplMicLvlWatchRefIntRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool AplMicLvlWatchRefIntRegister::operator == (const AplMicLvlWatchRefIntRegister& ) const {
    return true;
}

inline bool AplMicLvlWatchRefIntRegister::operator != (const AplMicLvlWatchRefIntRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool AplMicLvlWatchRefIntRegister::operator < (const AplMicLvlWatchRefIntRegister& ) const {
    return false;
}

inline ::asf::core::Payload* AplMicLvlWatchRefIntRegister::clone() {
    return new AplMicLvlWatchRefIntRegister(*this);
}

inline bool AplMicLvlWatchRefIntRegister::operator > (const AplMicLvlWatchRefIntRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void AplMicLvlWatchRefIntRegister::clear() {
}

inline  AplMicLvlUpdate::AplMicLvlUpdate ()  :
    _aplMicLvl (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  AplMicLvlUpdate::AplMicLvlUpdate (const AplMicLvlUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _aplMicLvl (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  AplMicLvlUpdate::AplMicLvlUpdate (int32 aplMicLvl_)  :
    _aplMicLvl (aplMicLvl_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  AplMicLvlUpdate::~AplMicLvlUpdate() {
}

inline AplMicLvlUpdate& AplMicLvlUpdate::operator = (const AplMicLvlUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasAplMicLvl()) {
            setAplMicLvl(rhs.getAplMicLvl());
        } else {
            clearAplMicLvl();
        }
    }
    return *this;
}

inline bool AplMicLvlUpdate::operator == (const AplMicLvlUpdate& rhs) const {
    return (((!hasAplMicLvl() && !rhs.hasAplMicLvl()) || getAplMicLvl() == rhs.getAplMicLvl()));
}

inline bool AplMicLvlUpdate::operator != (const AplMicLvlUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool AplMicLvlUpdate::operator < (const AplMicLvlUpdate& rhs) const {
    if (hasAplMicLvl() || rhs.hasAplMicLvl()) {
        if (getAplMicLvl() < rhs.getAplMicLvl()) return true;
        if (getAplMicLvl() > rhs.getAplMicLvl()) return false;
    }
    return false;
}

inline ::asf::core::Payload* AplMicLvlUpdate::clone() {
    return new AplMicLvlUpdate(*this);
}

inline bool AplMicLvlUpdate::operator > (const AplMicLvlUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void AplMicLvlUpdate::clear() {
    clearAplMicLvl();
}

inline void AplMicLvlUpdate::clearAplMicLvl() {
    if (hasAplMicLvl()) {
         clear_has_aplMicLvl();
        _aplMicLvl = 0;
     }
}

inline bool AplMicLvlUpdate::hasAplMicLvl () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline int32 AplMicLvlUpdate::getAplMicLvl () const {
    return _aplMicLvl;
}

inline void AplMicLvlUpdate::setAplMicLvl (int32 aplMicLvl_) {
    set_has_aplMicLvl();
    this->_aplMicLvl = aplMicLvl_;
}

inline void AplMicLvlUpdate::set_has_aplMicLvl () {
    _has_bits_[0] |= 1u << 0;
}

inline void AplMicLvlUpdate::clear_has_aplMicLvl () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  AplMicLvlRegister::AplMicLvlRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  AplMicLvlRegister::AplMicLvlRegister (const AplMicLvlRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  AplMicLvlRegister::~AplMicLvlRegister() {
}

inline AplMicLvlRegister& AplMicLvlRegister::operator = (const AplMicLvlRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool AplMicLvlRegister::operator == (const AplMicLvlRegister& ) const {
    return true;
}

inline bool AplMicLvlRegister::operator != (const AplMicLvlRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool AplMicLvlRegister::operator < (const AplMicLvlRegister& ) const {
    return false;
}

inline ::asf::core::Payload* AplMicLvlRegister::clone() {
    return new AplMicLvlRegister(*this);
}

inline bool AplMicLvlRegister::operator > (const AplMicLvlRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void AplMicLvlRegister::clear() {
}

inline  AplAudioModeUpdate::AplAudioModeUpdate ()  :
    _aplAudioMode (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  AplAudioModeUpdate::AplAudioModeUpdate (const AplAudioModeUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _aplAudioMode (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  AplAudioModeUpdate::AplAudioModeUpdate (int32 aplAudioMode_)  :
    _aplAudioMode (aplAudioMode_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  AplAudioModeUpdate::~AplAudioModeUpdate() {
}

inline AplAudioModeUpdate& AplAudioModeUpdate::operator = (const AplAudioModeUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasAplAudioMode()) {
            setAplAudioMode(rhs.getAplAudioMode());
        } else {
            clearAplAudioMode();
        }
    }
    return *this;
}

inline bool AplAudioModeUpdate::operator == (const AplAudioModeUpdate& rhs) const {
    return (((!hasAplAudioMode() && !rhs.hasAplAudioMode()) || getAplAudioMode() == rhs.getAplAudioMode()));
}

inline bool AplAudioModeUpdate::operator != (const AplAudioModeUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool AplAudioModeUpdate::operator < (const AplAudioModeUpdate& rhs) const {
    if (hasAplAudioMode() || rhs.hasAplAudioMode()) {
        if (getAplAudioMode() < rhs.getAplAudioMode()) return true;
        if (getAplAudioMode() > rhs.getAplAudioMode()) return false;
    }
    return false;
}

inline ::asf::core::Payload* AplAudioModeUpdate::clone() {
    return new AplAudioModeUpdate(*this);
}

inline bool AplAudioModeUpdate::operator > (const AplAudioModeUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void AplAudioModeUpdate::clear() {
    clearAplAudioMode();
}

inline void AplAudioModeUpdate::clearAplAudioMode() {
    if (hasAplAudioMode()) {
         clear_has_aplAudioMode();
        _aplAudioMode = 0;
     }
}

inline bool AplAudioModeUpdate::hasAplAudioMode () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline int32 AplAudioModeUpdate::getAplAudioMode () const {
    return _aplAudioMode;
}

inline void AplAudioModeUpdate::setAplAudioMode (int32 aplAudioMode_) {
    set_has_aplAudioMode();
    this->_aplAudioMode = aplAudioMode_;
}

inline void AplAudioModeUpdate::set_has_aplAudioMode () {
    _has_bits_[0] |= 1u << 0;
}

inline void AplAudioModeUpdate::clear_has_aplAudioMode () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  AplAudioModeRegister::AplAudioModeRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  AplAudioModeRegister::AplAudioModeRegister (const AplAudioModeRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  AplAudioModeRegister::~AplAudioModeRegister() {
}

inline AplAudioModeRegister& AplAudioModeRegister::operator = (const AplAudioModeRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool AplAudioModeRegister::operator == (const AplAudioModeRegister& ) const {
    return true;
}

inline bool AplAudioModeRegister::operator != (const AplAudioModeRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool AplAudioModeRegister::operator < (const AplAudioModeRegister& ) const {
    return false;
}

inline ::asf::core::Payload* AplAudioModeRegister::clone() {
    return new AplAudioModeRegister(*this);
}

inline bool AplAudioModeRegister::operator > (const AplAudioModeRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void AplAudioModeRegister::clear() {
}

inline  AplLoopbackActivateUpdate::AplLoopbackActivateUpdate ()  :
    _aplLoopbackActivate (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  AplLoopbackActivateUpdate::AplLoopbackActivateUpdate (const AplLoopbackActivateUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _aplLoopbackActivate (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  AplLoopbackActivateUpdate::AplLoopbackActivateUpdate (int32 aplLoopbackActivate_)  :
    _aplLoopbackActivate (aplLoopbackActivate_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  AplLoopbackActivateUpdate::~AplLoopbackActivateUpdate() {
}

inline AplLoopbackActivateUpdate& AplLoopbackActivateUpdate::operator = (const AplLoopbackActivateUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasAplLoopbackActivate()) {
            setAplLoopbackActivate(rhs.getAplLoopbackActivate());
        } else {
            clearAplLoopbackActivate();
        }
    }
    return *this;
}

inline bool AplLoopbackActivateUpdate::operator == (const AplLoopbackActivateUpdate& rhs) const {
    return (((!hasAplLoopbackActivate() && !rhs.hasAplLoopbackActivate()) || getAplLoopbackActivate() == rhs.getAplLoopbackActivate()));
}

inline bool AplLoopbackActivateUpdate::operator != (const AplLoopbackActivateUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool AplLoopbackActivateUpdate::operator < (const AplLoopbackActivateUpdate& rhs) const {
    if (hasAplLoopbackActivate() || rhs.hasAplLoopbackActivate()) {
        if (getAplLoopbackActivate() < rhs.getAplLoopbackActivate()) return true;
        if (getAplLoopbackActivate() > rhs.getAplLoopbackActivate()) return false;
    }
    return false;
}

inline ::asf::core::Payload* AplLoopbackActivateUpdate::clone() {
    return new AplLoopbackActivateUpdate(*this);
}

inline bool AplLoopbackActivateUpdate::operator > (const AplLoopbackActivateUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void AplLoopbackActivateUpdate::clear() {
    clearAplLoopbackActivate();
}

inline void AplLoopbackActivateUpdate::clearAplLoopbackActivate() {
    if (hasAplLoopbackActivate()) {
         clear_has_aplLoopbackActivate();
        _aplLoopbackActivate = 0;
     }
}

inline bool AplLoopbackActivateUpdate::hasAplLoopbackActivate () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline int32 AplLoopbackActivateUpdate::getAplLoopbackActivate () const {
    return _aplLoopbackActivate;
}

inline void AplLoopbackActivateUpdate::setAplLoopbackActivate (int32 aplLoopbackActivate_) {
    set_has_aplLoopbackActivate();
    this->_aplLoopbackActivate = aplLoopbackActivate_;
}

inline void AplLoopbackActivateUpdate::set_has_aplLoopbackActivate () {
    _has_bits_[0] |= 1u << 0;
}

inline void AplLoopbackActivateUpdate::clear_has_aplLoopbackActivate () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  AplLoopbackActivateRegister::AplLoopbackActivateRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  AplLoopbackActivateRegister::AplLoopbackActivateRegister (const AplLoopbackActivateRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  AplLoopbackActivateRegister::~AplLoopbackActivateRegister() {
}

inline AplLoopbackActivateRegister& AplLoopbackActivateRegister::operator = (const AplLoopbackActivateRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool AplLoopbackActivateRegister::operator == (const AplLoopbackActivateRegister& ) const {
    return true;
}

inline bool AplLoopbackActivateRegister::operator != (const AplLoopbackActivateRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool AplLoopbackActivateRegister::operator < (const AplLoopbackActivateRegister& ) const {
    return false;
}

inline ::asf::core::Payload* AplLoopbackActivateRegister::clone() {
    return new AplLoopbackActivateRegister(*this);
}

inline bool AplLoopbackActivateRegister::operator > (const AplLoopbackActivateRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void AplLoopbackActivateRegister::clear() {
}

inline  AudprocStatusSignal::AudprocStatusSignal ()  :
    _statusEntSrcEnum (0u),
    _statusEntSrcActiveState (0u),
    _statusVoiceSrcEnum (0u),
    _statusVoiceSrcActiveState (0u),
    _statusInfoSrcEnum (0u),
    _statusinfoSrcActiveState (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  AudprocStatusSignal::AudprocStatusSignal (const AudprocStatusSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _statusEntSrcEnum (0u),
    _statusEntSrcActiveState (0u),
    _statusVoiceSrcEnum (0u),
    _statusVoiceSrcActiveState (0u),
    _statusInfoSrcEnum (0u),
    _statusinfoSrcActiveState (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  AudprocStatusSignal::AudprocStatusSignal (uint8 statusEntSrcEnum_, uint8 statusEntSrcActiveState_, uint8 statusVoiceSrcEnum_, uint8 statusVoiceSrcActiveState_, uint8 statusInfoSrcEnum_, uint8 statusinfoSrcActiveState_)  :
    _statusEntSrcEnum (statusEntSrcEnum_),
    _statusEntSrcActiveState (statusEntSrcActiveState_),
    _statusVoiceSrcEnum (statusVoiceSrcEnum_),
    _statusVoiceSrcActiveState (statusVoiceSrcActiveState_),
    _statusInfoSrcEnum (statusInfoSrcEnum_),
    _statusinfoSrcActiveState (statusinfoSrcActiveState_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  AudprocStatusSignal::~AudprocStatusSignal() {
}

inline AudprocStatusSignal& AudprocStatusSignal::operator = (const AudprocStatusSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasStatusEntSrcEnum()) {
            setStatusEntSrcEnum(rhs.getStatusEntSrcEnum());
        } else {
            clearStatusEntSrcEnum();
        }
        if (rhs.hasStatusEntSrcActiveState()) {
            setStatusEntSrcActiveState(rhs.getStatusEntSrcActiveState());
        } else {
            clearStatusEntSrcActiveState();
        }
        if (rhs.hasStatusVoiceSrcEnum()) {
            setStatusVoiceSrcEnum(rhs.getStatusVoiceSrcEnum());
        } else {
            clearStatusVoiceSrcEnum();
        }
        if (rhs.hasStatusVoiceSrcActiveState()) {
            setStatusVoiceSrcActiveState(rhs.getStatusVoiceSrcActiveState());
        } else {
            clearStatusVoiceSrcActiveState();
        }
        if (rhs.hasStatusInfoSrcEnum()) {
            setStatusInfoSrcEnum(rhs.getStatusInfoSrcEnum());
        } else {
            clearStatusInfoSrcEnum();
        }
        if (rhs.hasStatusinfoSrcActiveState()) {
            setStatusinfoSrcActiveState(rhs.getStatusinfoSrcActiveState());
        } else {
            clearStatusinfoSrcActiveState();
        }
    }
    return *this;
}

inline bool AudprocStatusSignal::operator == (const AudprocStatusSignal& rhs) const {
    return (((!hasStatusEntSrcEnum() && !rhs.hasStatusEntSrcEnum()) || getStatusEntSrcEnum() == rhs.getStatusEntSrcEnum()) &&
        ((!hasStatusEntSrcActiveState() && !rhs.hasStatusEntSrcActiveState()) || getStatusEntSrcActiveState() == rhs.getStatusEntSrcActiveState()) &&
        ((!hasStatusVoiceSrcEnum() && !rhs.hasStatusVoiceSrcEnum()) || getStatusVoiceSrcEnum() == rhs.getStatusVoiceSrcEnum()) &&
        ((!hasStatusVoiceSrcActiveState() && !rhs.hasStatusVoiceSrcActiveState()) || getStatusVoiceSrcActiveState() == rhs.getStatusVoiceSrcActiveState()) &&
        ((!hasStatusInfoSrcEnum() && !rhs.hasStatusInfoSrcEnum()) || getStatusInfoSrcEnum() == rhs.getStatusInfoSrcEnum()) &&
        ((!hasStatusinfoSrcActiveState() && !rhs.hasStatusinfoSrcActiveState()) || getStatusinfoSrcActiveState() == rhs.getStatusinfoSrcActiveState()));
}

inline bool AudprocStatusSignal::operator != (const AudprocStatusSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool AudprocStatusSignal::operator < (const AudprocStatusSignal& rhs) const {
    if (hasStatusEntSrcEnum() || rhs.hasStatusEntSrcEnum()) {
        if (getStatusEntSrcEnum() < rhs.getStatusEntSrcEnum()) return true;
        if (getStatusEntSrcEnum() > rhs.getStatusEntSrcEnum()) return false;
    }
    if (hasStatusEntSrcActiveState() || rhs.hasStatusEntSrcActiveState()) {
        if (getStatusEntSrcActiveState() < rhs.getStatusEntSrcActiveState()) return true;
        if (getStatusEntSrcActiveState() > rhs.getStatusEntSrcActiveState()) return false;
    }
    if (hasStatusVoiceSrcEnum() || rhs.hasStatusVoiceSrcEnum()) {
        if (getStatusVoiceSrcEnum() < rhs.getStatusVoiceSrcEnum()) return true;
        if (getStatusVoiceSrcEnum() > rhs.getStatusVoiceSrcEnum()) return false;
    }
    if (hasStatusVoiceSrcActiveState() || rhs.hasStatusVoiceSrcActiveState()) {
        if (getStatusVoiceSrcActiveState() < rhs.getStatusVoiceSrcActiveState()) return true;
        if (getStatusVoiceSrcActiveState() > rhs.getStatusVoiceSrcActiveState()) return false;
    }
    if (hasStatusInfoSrcEnum() || rhs.hasStatusInfoSrcEnum()) {
        if (getStatusInfoSrcEnum() < rhs.getStatusInfoSrcEnum()) return true;
        if (getStatusInfoSrcEnum() > rhs.getStatusInfoSrcEnum()) return false;
    }
    if (hasStatusinfoSrcActiveState() || rhs.hasStatusinfoSrcActiveState()) {
        if (getStatusinfoSrcActiveState() < rhs.getStatusinfoSrcActiveState()) return true;
        if (getStatusinfoSrcActiveState() > rhs.getStatusinfoSrcActiveState()) return false;
    }
    return false;
}

inline ::asf::core::Payload* AudprocStatusSignal::clone() {
    return new AudprocStatusSignal(*this);
}

inline bool AudprocStatusSignal::operator > (const AudprocStatusSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void AudprocStatusSignal::clear() {
    clearStatusEntSrcEnum();
    clearStatusEntSrcActiveState();
    clearStatusVoiceSrcEnum();
    clearStatusVoiceSrcActiveState();
    clearStatusInfoSrcEnum();
    clearStatusinfoSrcActiveState();
}

inline void AudprocStatusSignal::clearStatusEntSrcEnum() {
    if (hasStatusEntSrcEnum()) {
         clear_has_statusEntSrcEnum();
        _statusEntSrcEnum = 0u;
     }
}

inline bool AudprocStatusSignal::hasStatusEntSrcEnum () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 AudprocStatusSignal::getStatusEntSrcEnum () const {
    return _statusEntSrcEnum;
}

inline void AudprocStatusSignal::setStatusEntSrcEnum (uint8 statusEntSrcEnum_) {
    set_has_statusEntSrcEnum();
    this->_statusEntSrcEnum = statusEntSrcEnum_;
}

inline void AudprocStatusSignal::clearStatusEntSrcActiveState() {
    if (hasStatusEntSrcActiveState()) {
         clear_has_statusEntSrcActiveState();
        _statusEntSrcActiveState = 0u;
     }
}

inline bool AudprocStatusSignal::hasStatusEntSrcActiveState () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 AudprocStatusSignal::getStatusEntSrcActiveState () const {
    return _statusEntSrcActiveState;
}

inline void AudprocStatusSignal::setStatusEntSrcActiveState (uint8 statusEntSrcActiveState_) {
    set_has_statusEntSrcActiveState();
    this->_statusEntSrcActiveState = statusEntSrcActiveState_;
}

inline void AudprocStatusSignal::clearStatusVoiceSrcEnum() {
    if (hasStatusVoiceSrcEnum()) {
         clear_has_statusVoiceSrcEnum();
        _statusVoiceSrcEnum = 0u;
     }
}

inline bool AudprocStatusSignal::hasStatusVoiceSrcEnum () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint8 AudprocStatusSignal::getStatusVoiceSrcEnum () const {
    return _statusVoiceSrcEnum;
}

inline void AudprocStatusSignal::setStatusVoiceSrcEnum (uint8 statusVoiceSrcEnum_) {
    set_has_statusVoiceSrcEnum();
    this->_statusVoiceSrcEnum = statusVoiceSrcEnum_;
}

inline void AudprocStatusSignal::clearStatusVoiceSrcActiveState() {
    if (hasStatusVoiceSrcActiveState()) {
         clear_has_statusVoiceSrcActiveState();
        _statusVoiceSrcActiveState = 0u;
     }
}

inline bool AudprocStatusSignal::hasStatusVoiceSrcActiveState () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint8 AudprocStatusSignal::getStatusVoiceSrcActiveState () const {
    return _statusVoiceSrcActiveState;
}

inline void AudprocStatusSignal::setStatusVoiceSrcActiveState (uint8 statusVoiceSrcActiveState_) {
    set_has_statusVoiceSrcActiveState();
    this->_statusVoiceSrcActiveState = statusVoiceSrcActiveState_;
}

inline void AudprocStatusSignal::clearStatusInfoSrcEnum() {
    if (hasStatusInfoSrcEnum()) {
         clear_has_statusInfoSrcEnum();
        _statusInfoSrcEnum = 0u;
     }
}

inline bool AudprocStatusSignal::hasStatusInfoSrcEnum () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline uint8 AudprocStatusSignal::getStatusInfoSrcEnum () const {
    return _statusInfoSrcEnum;
}

inline void AudprocStatusSignal::setStatusInfoSrcEnum (uint8 statusInfoSrcEnum_) {
    set_has_statusInfoSrcEnum();
    this->_statusInfoSrcEnum = statusInfoSrcEnum_;
}

inline void AudprocStatusSignal::clearStatusinfoSrcActiveState() {
    if (hasStatusinfoSrcActiveState()) {
         clear_has_statusinfoSrcActiveState();
        _statusinfoSrcActiveState = 0u;
     }
}

inline bool AudprocStatusSignal::hasStatusinfoSrcActiveState () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline uint8 AudprocStatusSignal::getStatusinfoSrcActiveState () const {
    return _statusinfoSrcActiveState;
}

inline void AudprocStatusSignal::setStatusinfoSrcActiveState (uint8 statusinfoSrcActiveState_) {
    set_has_statusinfoSrcActiveState();
    this->_statusinfoSrcActiveState = statusinfoSrcActiveState_;
}

inline void AudprocStatusSignal::set_has_statusEntSrcEnum () {
    _has_bits_[0] |= 1u << 0;
}

inline void AudprocStatusSignal::clear_has_statusEntSrcEnum () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void AudprocStatusSignal::set_has_statusEntSrcActiveState () {
    _has_bits_[0] |= 1u << 1;
}

inline void AudprocStatusSignal::clear_has_statusEntSrcActiveState () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void AudprocStatusSignal::set_has_statusVoiceSrcEnum () {
    _has_bits_[0] |= 1u << 2;
}

inline void AudprocStatusSignal::clear_has_statusVoiceSrcEnum () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void AudprocStatusSignal::set_has_statusVoiceSrcActiveState () {
    _has_bits_[0] |= 1u << 3;
}

inline void AudprocStatusSignal::clear_has_statusVoiceSrcActiveState () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void AudprocStatusSignal::set_has_statusInfoSrcEnum () {
    _has_bits_[0] |= 1u << 4;
}

inline void AudprocStatusSignal::clear_has_statusInfoSrcEnum () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void AudprocStatusSignal::set_has_statusinfoSrcActiveState () {
    _has_bits_[0] |= 1u << 5;
}

inline void AudprocStatusSignal::clear_has_statusinfoSrcActiveState () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline  AudprocMicrolevelStatusSignal::AudprocMicrolevelStatusSignal ()  :
    _StatusMicroLevel (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  AudprocMicrolevelStatusSignal::AudprocMicrolevelStatusSignal (const AudprocMicrolevelStatusSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _StatusMicroLevel (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  AudprocMicrolevelStatusSignal::AudprocMicrolevelStatusSignal (int16 StatusMicroLevel_)  :
    _StatusMicroLevel (StatusMicroLevel_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  AudprocMicrolevelStatusSignal::~AudprocMicrolevelStatusSignal() {
}

inline AudprocMicrolevelStatusSignal& AudprocMicrolevelStatusSignal::operator = (const AudprocMicrolevelStatusSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasStatusMicroLevel()) {
            setStatusMicroLevel(rhs.getStatusMicroLevel());
        } else {
            clearStatusMicroLevel();
        }
    }
    return *this;
}

inline bool AudprocMicrolevelStatusSignal::operator == (const AudprocMicrolevelStatusSignal& rhs) const {
    return (((!hasStatusMicroLevel() && !rhs.hasStatusMicroLevel()) || getStatusMicroLevel() == rhs.getStatusMicroLevel()));
}

inline bool AudprocMicrolevelStatusSignal::operator != (const AudprocMicrolevelStatusSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool AudprocMicrolevelStatusSignal::operator < (const AudprocMicrolevelStatusSignal& rhs) const {
    if (hasStatusMicroLevel() || rhs.hasStatusMicroLevel()) {
        if (getStatusMicroLevel() < rhs.getStatusMicroLevel()) return true;
        if (getStatusMicroLevel() > rhs.getStatusMicroLevel()) return false;
    }
    return false;
}

inline ::asf::core::Payload* AudprocMicrolevelStatusSignal::clone() {
    return new AudprocMicrolevelStatusSignal(*this);
}

inline bool AudprocMicrolevelStatusSignal::operator > (const AudprocMicrolevelStatusSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void AudprocMicrolevelStatusSignal::clear() {
    clearStatusMicroLevel();
}

inline void AudprocMicrolevelStatusSignal::clearStatusMicroLevel() {
    if (hasStatusMicroLevel()) {
         clear_has_StatusMicroLevel();
        _StatusMicroLevel = 0;
     }
}

inline bool AudprocMicrolevelStatusSignal::hasStatusMicroLevel () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline int16 AudprocMicrolevelStatusSignal::getStatusMicroLevel () const {
    return _StatusMicroLevel;
}

inline void AudprocMicrolevelStatusSignal::setStatusMicroLevel (int16 StatusMicroLevel_) {
    set_has_StatusMicroLevel();
    this->_StatusMicroLevel = StatusMicroLevel_;
}

inline void AudprocMicrolevelStatusSignal::set_has_StatusMicroLevel () {
    _has_bits_[0] |= 1u << 0;
}

inline void AudprocMicrolevelStatusSignal::clear_has_StatusMicroLevel () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  AudprocArkamysLevelLossSignal::AudprocArkamysLevelLossSignal ()  :
    _StatusArkamysLevelLoss (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  AudprocArkamysLevelLossSignal::AudprocArkamysLevelLossSignal (const AudprocArkamysLevelLossSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _StatusArkamysLevelLoss (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  AudprocArkamysLevelLossSignal::AudprocArkamysLevelLossSignal (int32 StatusArkamysLevelLoss_)  :
    _StatusArkamysLevelLoss (StatusArkamysLevelLoss_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  AudprocArkamysLevelLossSignal::~AudprocArkamysLevelLossSignal() {
}

inline AudprocArkamysLevelLossSignal& AudprocArkamysLevelLossSignal::operator = (const AudprocArkamysLevelLossSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasStatusArkamysLevelLoss()) {
            setStatusArkamysLevelLoss(rhs.getStatusArkamysLevelLoss());
        } else {
            clearStatusArkamysLevelLoss();
        }
    }
    return *this;
}

inline bool AudprocArkamysLevelLossSignal::operator == (const AudprocArkamysLevelLossSignal& rhs) const {
    return (((!hasStatusArkamysLevelLoss() && !rhs.hasStatusArkamysLevelLoss()) || getStatusArkamysLevelLoss() == rhs.getStatusArkamysLevelLoss()));
}

inline bool AudprocArkamysLevelLossSignal::operator != (const AudprocArkamysLevelLossSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool AudprocArkamysLevelLossSignal::operator < (const AudprocArkamysLevelLossSignal& rhs) const {
    if (hasStatusArkamysLevelLoss() || rhs.hasStatusArkamysLevelLoss()) {
        if (getStatusArkamysLevelLoss() < rhs.getStatusArkamysLevelLoss()) return true;
        if (getStatusArkamysLevelLoss() > rhs.getStatusArkamysLevelLoss()) return false;
    }
    return false;
}

inline ::asf::core::Payload* AudprocArkamysLevelLossSignal::clone() {
    return new AudprocArkamysLevelLossSignal(*this);
}

inline bool AudprocArkamysLevelLossSignal::operator > (const AudprocArkamysLevelLossSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void AudprocArkamysLevelLossSignal::clear() {
    clearStatusArkamysLevelLoss();
}

inline void AudprocArkamysLevelLossSignal::clearStatusArkamysLevelLoss() {
    if (hasStatusArkamysLevelLoss()) {
         clear_has_StatusArkamysLevelLoss();
        _StatusArkamysLevelLoss = 0;
     }
}

inline bool AudprocArkamysLevelLossSignal::hasStatusArkamysLevelLoss () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline int32 AudprocArkamysLevelLossSignal::getStatusArkamysLevelLoss () const {
    return _StatusArkamysLevelLoss;
}

inline void AudprocArkamysLevelLossSignal::setStatusArkamysLevelLoss (int32 StatusArkamysLevelLoss_) {
    set_has_StatusArkamysLevelLoss();
    this->_StatusArkamysLevelLoss = StatusArkamysLevelLoss_;
}

inline void AudprocArkamysLevelLossSignal::set_has_StatusArkamysLevelLoss () {
    _has_bits_[0] |= 1u << 0;
}

inline void AudprocArkamysLevelLossSignal::clear_has_StatusArkamysLevelLoss () {
    _has_bits_[0] &= ~ (1u << 0);
}

} // namespace service
} // namespace audproc
} // namespace bosch
} // namespace org

#endif // ORG_BOSCH_AUDPROC_SERVICE_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
