#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef MOST_TEL_FI_TYPES_EXTENDED_H
#define MOST_TEL_FI_TYPES_EXTENDED_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "asf/core/VersionCheck.h"
#include "fi_basetypes_most.h"
#include "most_Tel_fi_typesConst.h"
#include <cstring>
#include <vector>

/**
 * Types most_Tel_fi_types_Extended
 */

namespace most_Tel_fi_types_Extended {

ASF_GENERATOR_VERSION_CHECK_DECLARE

// forward declarations
class T_TelCallStatusNoticeExtendedStreamItem;

class T_TelOutgoingCall_Failed;

class T_TelIncomingCall_Rejected;

class T_ListOfCallInstanceStreamItem;

// type definitions
/**
 * If the meaning of "T_TelCallStatusNoticeExtendedStream" isn't clear, then there should be a description here.
 */
typedef ::std::vector< T_TelCallStatusNoticeExtendedStreamItem > T_TelCallStatusNoticeExtendedStream;

/**
 * If the meaning of "T_ListOfCallInstanceStream" isn't clear, then there should be a description here.
 */
typedef ::std::vector< T_ListOfCallInstanceStreamItem > T_ListOfCallInstanceStream;


/**
 * If the meaning of "T_TelCallStatusNoticeExtendedStreamItem" isn't clear, then there should be a description here.
 */
class T_TelCallStatusNoticeExtendedStreamItem {
public:

    /**
     * Default constructor
     */
    inline  T_TelCallStatusNoticeExtendedStreamItem ();

    /**
     * Copy constructor
     */
    inline  T_TelCallStatusNoticeExtendedStreamItem (const T_TelCallStatusNoticeExtendedStreamItem &rhs);

    /**
     * All fields constructor
     */
    inline  T_TelCallStatusNoticeExtendedStreamItem (uint16 u16CallInstance_, ::most_Tel_fi_types::T_e8_TelCallStatus e8CallStatus_, bool bUsingVehicleAudio_, uint8 u8CallDurationHr_, uint8 u8CallDurationMin_, uint8 u8CallDurationSec_, uint8 u8DeviceHandle_, const ::fi_basetypes_most::T_String& sTelephoneNumber_, const ::fi_basetypes_most::T_String& sName_);

    /**
     * Destructor
     */
    inline  ~T_TelCallStatusNoticeExtendedStreamItem();

    /**
     * Assignment operator
     */
    inline T_TelCallStatusNoticeExtendedStreamItem& operator = (const T_TelCallStatusNoticeExtendedStreamItem& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_TelCallStatusNoticeExtendedStreamItem& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_TelCallStatusNoticeExtendedStreamItem& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_TelCallStatusNoticeExtendedStreamItem& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_TelCallStatusNoticeExtendedStreamItem& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u16CallInstance"

    static const int kU16CallInstance = 0;

    /**
     * Clears the field "u16CallInstance".
     *
     * The field will be set to its default value. The hasU16CallInstance()
     * method will return false.
     */
    inline void clearU16CallInstance();

    /**
     * Checks whether the field "u16CallInstance" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16CallInstance()). Otherwise it will return false.
     */
    inline bool hasU16CallInstance () const;

    /**
     * Returns the value of the member "u16CallInstance".
     *
     * Instance of one call from multiple call possible.
     * Call Instance FF means all call.  Like HangUp all calls.
     *
     * @return The value of the field "u16CallInstance"
     */
    inline uint16 getU16CallInstance () const;

    /**
     * Sets the value of the member "u16CallInstance".
     *
     * Instance of one call from multiple call possible.
     * Call Instance FF means all call.  Like HangUp all calls.
     *
     * @param u16CallInstance The value which will be set
     */
    inline void setU16CallInstance (uint16 u16CallInstance_);

    // API of field "e8CallStatus"

    static const int kE8CallStatus = 1;

    /**
     * Clears the field "e8CallStatus".
     *
     * The field will be set to its default value. The hasE8CallStatus()
     * method will return false.
     */
    inline void clearE8CallStatus();

    /**
     * Checks whether the field "e8CallStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8CallStatus()). Otherwise it will return false.
     */
    inline bool hasE8CallStatus () const;

    /**
     * Returns the value of the member "e8CallStatus".
     *
     * Status of a call
     *
     * @return The value of the field "e8CallStatus"
     */
    inline ::most_Tel_fi_types::T_e8_TelCallStatus getE8CallStatus () const;

    /**
     * Sets the value of the member "e8CallStatus".
     *
     * Status of a call
     *
     * @param e8CallStatus The value which will be set
     */
    inline void setE8CallStatus (::most_Tel_fi_types::T_e8_TelCallStatus e8CallStatus_);

    // API of field "bUsingVehicleAudio"

    static const int kBUsingVehicleAudio = 2;

    /**
     * Clears the field "bUsingVehicleAudio".
     *
     * The field will be set to its default value. The hasBUsingVehicleAudio()
     * method will return false.
     */
    inline void clearBUsingVehicleAudio();

    /**
     * Checks whether the field "bUsingVehicleAudio" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBUsingVehicleAudio()). Otherwise it will return false.
     */
    inline bool hasBUsingVehicleAudio () const;

    /**
     * Returns the value of the member "bUsingVehicleAudio".
     *
     * Is the call in handset or in vehicle
     *
     * @return The value of the field "bUsingVehicleAudio"
     */
    inline bool getBUsingVehicleAudio () const;

    /**
     * Sets the value of the member "bUsingVehicleAudio".
     *
     * Is the call in handset or in vehicle
     *
     * @param bUsingVehicleAudio The value which will be set
     */
    inline void setBUsingVehicleAudio (bool bUsingVehicleAudio_);

    // API of field "u8CallDurationHr"

    static const int kU8CallDurationHr = 3;

    /**
     * Clears the field "u8CallDurationHr".
     *
     * The field will be set to its default value. The hasU8CallDurationHr()
     * method will return false.
     */
    inline void clearU8CallDurationHr();

    /**
     * Checks whether the field "u8CallDurationHr" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8CallDurationHr()). Otherwise it will return false.
     */
    inline bool hasU8CallDurationHr () const;

    /**
     * Returns the value of the member "u8CallDurationHr".
     *
     * Hour Component of call duration,  call duration is from the call is RINGING or DIALING State till IDLE.
     *
     * @return The value of the field "u8CallDurationHr"
     */
    inline uint8 getU8CallDurationHr () const;

    /**
     * Sets the value of the member "u8CallDurationHr".
     *
     * Hour Component of call duration,  call duration is from the call is RINGING or DIALING State till IDLE.
     *
     * @param u8CallDurationHr The value which will be set
     */
    inline void setU8CallDurationHr (uint8 u8CallDurationHr_);

    // API of field "u8CallDurationMin"

    static const int kU8CallDurationMin = 4;

    /**
     * Clears the field "u8CallDurationMin".
     *
     * The field will be set to its default value. The hasU8CallDurationMin()
     * method will return false.
     */
    inline void clearU8CallDurationMin();

    /**
     * Checks whether the field "u8CallDurationMin" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8CallDurationMin()). Otherwise it will return false.
     */
    inline bool hasU8CallDurationMin () const;

    /**
     * Returns the value of the member "u8CallDurationMin".
     *
     * Minute Component of call duration,  call duration is from the call is RINGING or DIALING State till IDLE.
     *
     * @return The value of the field "u8CallDurationMin"
     */
    inline uint8 getU8CallDurationMin () const;

    /**
     * Sets the value of the member "u8CallDurationMin".
     *
     * Minute Component of call duration,  call duration is from the call is RINGING or DIALING State till IDLE.
     *
     * @param u8CallDurationMin The value which will be set
     */
    inline void setU8CallDurationMin (uint8 u8CallDurationMin_);

    // API of field "u8CallDurationSec"

    static const int kU8CallDurationSec = 5;

    /**
     * Clears the field "u8CallDurationSec".
     *
     * The field will be set to its default value. The hasU8CallDurationSec()
     * method will return false.
     */
    inline void clearU8CallDurationSec();

    /**
     * Checks whether the field "u8CallDurationSec" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8CallDurationSec()). Otherwise it will return false.
     */
    inline bool hasU8CallDurationSec () const;

    /**
     * Returns the value of the member "u8CallDurationSec".
     *
     * Seconds Component of call duration,  call duration is from the call is RINGING or DIALING State till IDLE.
     *
     * @return The value of the field "u8CallDurationSec"
     */
    inline uint8 getU8CallDurationSec () const;

    /**
     * Sets the value of the member "u8CallDurationSec".
     *
     * Seconds Component of call duration,  call duration is from the call is RINGING or DIALING State till IDLE.
     *
     * @param u8CallDurationSec The value which will be set
     */
    inline void setU8CallDurationSec (uint8 u8CallDurationSec_);

    // API of field "u8DeviceHandle"

    static const int kU8DeviceHandle = 6;

    /**
     * Clears the field "u8DeviceHandle".
     *
     * The field will be set to its default value. The hasU8DeviceHandle()
     * method will return false.
     */
    inline void clearU8DeviceHandle();

    /**
     * Checks whether the field "u8DeviceHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8DeviceHandle()). Otherwise it will return false.
     */
    inline bool hasU8DeviceHandle () const;

    /**
     * Returns the value of the member "u8DeviceHandle".
     *
     * Unique handle for each one of the up to 10 devices that can be paired.  Handles are maintained by FC_Bluetooth.  Valid handles are 2..11 inclusive.
     *
     * @return The value of the field "u8DeviceHandle"
     */
    inline uint8 getU8DeviceHandle () const;

    /**
     * Sets the value of the member "u8DeviceHandle".
     *
     * Unique handle for each one of the up to 10 devices that can be paired.  Handles are maintained by FC_Bluetooth.  Valid handles are 2..11 inclusive.
     *
     * @param u8DeviceHandle The value which will be set
     */
    inline void setU8DeviceHandle (uint8 u8DeviceHandle_);

    // API of field "sTelephoneNumber"

    static const int kSTelephoneNumber = 7;

    /**
     * Clears the field "sTelephoneNumber".
     *
     * The field will be set to its default value. The hasSTelephoneNumber()
     * method will return false.
     */
    inline void clearSTelephoneNumber();

    /**
     * Checks whether the field "sTelephoneNumber" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSTelephoneNumber()). Otherwise it will return false.
     */
    inline bool hasSTelephoneNumber () const;

    /**
     * Returns the value of the member "sTelephoneNumber".
     *
     * Phone number
     *
     * @return The value of the field "sTelephoneNumber"
     */
    inline const ::fi_basetypes_most::T_String& getSTelephoneNumber () const;

    /**
     * Retrieves the value of the field "sTelephoneNumber" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sTelephoneNumber".
     */
    inline ::fi_basetypes_most::T_String& getSTelephoneNumberMutable ();

    /**
     * Sets the value of the member "sTelephoneNumber".
     *
     * Phone number
     *
     * @param sTelephoneNumber The value which will be set
     */
    inline void setSTelephoneNumber (const ::fi_basetypes_most::T_String& sTelephoneNumber_);

    // API of field "sName"

    static const int kSName = 8;

    /**
     * Clears the field "sName".
     *
     * The field will be set to its default value. The hasSName()
     * method will return false.
     */
    inline void clearSName();

    /**
     * Checks whether the field "sName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSName()). Otherwise it will return false.
     */
    inline bool hasSName () const;

    /**
     * Returns the value of the member "sName".
     *
     * Name string associated with the telephone number:
     * * For outgoing calls this Name is the one which has been provided in method DialExtended.MethodStart as long as the phone number, reported from the phone device (CLIP information), still corresponds to the dialed one.
     * If the number has changed (e.g. in case of call redirection) the Name will become an empty string.
     * * For incoming calls this Name will be empty
     *
     * @return The value of the field "sName"
     */
    inline const ::fi_basetypes_most::T_String& getSName () const;

    /**
     * Retrieves the value of the field "sName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sName".
     */
    inline ::fi_basetypes_most::T_String& getSNameMutable ();

    /**
     * Sets the value of the member "sName".
     *
     * Name string associated with the telephone number:
     * * For outgoing calls this Name is the one which has been provided in method DialExtended.MethodStart as long as the phone number, reported from the phone device (CLIP information), still corresponds to the dialed one.
     * If the number has changed (e.g. in case of call redirection) the Name will become an empty string.
     * * For incoming calls this Name will be empty
     *
     * @param sName The value which will be set
     */
    inline void setSName (const ::fi_basetypes_most::T_String& sName_);

    static const T_TelCallStatusNoticeExtendedStreamItem &getDefaultInstance();

private:

    inline void set_has_u16CallInstance ();

    inline void clear_has_u16CallInstance ();

    inline void set_has_e8CallStatus ();

    inline void clear_has_e8CallStatus ();

    inline void set_has_bUsingVehicleAudio ();

    inline void clear_has_bUsingVehicleAudio ();

    inline void set_has_u8CallDurationHr ();

    inline void clear_has_u8CallDurationHr ();

    inline void set_has_u8CallDurationMin ();

    inline void clear_has_u8CallDurationMin ();

    inline void set_has_u8CallDurationSec ();

    inline void clear_has_u8CallDurationSec ();

    inline void set_has_u8DeviceHandle ();

    inline void clear_has_u8DeviceHandle ();

    inline void set_has_sTelephoneNumber ();

    inline void clear_has_sTelephoneNumber ();

    inline void set_has_sName ();

    inline void clear_has_sName ();

    uint32 _has_bits_[ (9 + 31) / 32];

    uint16 _u16CallInstance;

    ::most_Tel_fi_types::T_e8_TelCallStatus _e8CallStatus;

    bool _bUsingVehicleAudio;

    uint8 _u8CallDurationHr;

    uint8 _u8CallDurationMin;

    uint8 _u8CallDurationSec;

    uint8 _u8DeviceHandle;

    ::fi_basetypes_most::T_String _sTelephoneNumber;

    ::fi_basetypes_most::T_String _sName;

};

/**
 * If the meaning of "T_TelOutgoingCall_Failed" isn't clear, then there should be a description here.
 */
class T_TelOutgoingCall_Failed {
public:

    /**
     * Default constructor
     */
    inline  T_TelOutgoingCall_Failed ();

    /**
     * Copy constructor
     */
    inline  T_TelOutgoingCall_Failed (const T_TelOutgoingCall_Failed &rhs);

    /**
     * All fields constructor
     */
    inline  T_TelOutgoingCall_Failed (uint8 u8DeviceHandle_, const ::fi_basetypes_most::T_String& sTelephoneNumber_, const ::fi_basetypes_most::T_String& sName_, const ::fi_basetypes_most::T_String& sOutgoingCallFailedReason_);

    /**
     * Destructor
     */
    inline  ~T_TelOutgoingCall_Failed();

    /**
     * Assignment operator
     */
    inline T_TelOutgoingCall_Failed& operator = (const T_TelOutgoingCall_Failed& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_TelOutgoingCall_Failed& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_TelOutgoingCall_Failed& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_TelOutgoingCall_Failed& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_TelOutgoingCall_Failed& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8DeviceHandle"

    static const int kU8DeviceHandle = 0;

    /**
     * Clears the field "u8DeviceHandle".
     *
     * The field will be set to its default value. The hasU8DeviceHandle()
     * method will return false.
     */
    inline void clearU8DeviceHandle();

    /**
     * Checks whether the field "u8DeviceHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8DeviceHandle()). Otherwise it will return false.
     */
    inline bool hasU8DeviceHandle () const;

    /**
     * Returns the value of the member "u8DeviceHandle".
     *
     * The DeviceHandle of the Bluetooth device for which the Outgoing operation failed
     *
     * @return The value of the field "u8DeviceHandle"
     */
    inline uint8 getU8DeviceHandle () const;

    /**
     * Sets the value of the member "u8DeviceHandle".
     *
     * The DeviceHandle of the Bluetooth device for which the Outgoing operation failed
     *
     * @param u8DeviceHandle The value which will be set
     */
    inline void setU8DeviceHandle (uint8 u8DeviceHandle_);

    // API of field "sTelephoneNumber"

    static const int kSTelephoneNumber = 1;

    /**
     * Clears the field "sTelephoneNumber".
     *
     * The field will be set to its default value. The hasSTelephoneNumber()
     * method will return false.
     */
    inline void clearSTelephoneNumber();

    /**
     * Checks whether the field "sTelephoneNumber" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSTelephoneNumber()). Otherwise it will return false.
     */
    inline bool hasSTelephoneNumber () const;

    /**
     * Returns the value of the member "sTelephoneNumber".
     *
     * Phone number
     *
     * @return The value of the field "sTelephoneNumber"
     */
    inline const ::fi_basetypes_most::T_String& getSTelephoneNumber () const;

    /**
     * Retrieves the value of the field "sTelephoneNumber" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sTelephoneNumber".
     */
    inline ::fi_basetypes_most::T_String& getSTelephoneNumberMutable ();

    /**
     * Sets the value of the member "sTelephoneNumber".
     *
     * Phone number
     *
     * @param sTelephoneNumber The value which will be set
     */
    inline void setSTelephoneNumber (const ::fi_basetypes_most::T_String& sTelephoneNumber_);

    // API of field "sName"

    static const int kSName = 2;

    /**
     * Clears the field "sName".
     *
     * The field will be set to its default value. The hasSName()
     * method will return false.
     */
    inline void clearSName();

    /**
     * Checks whether the field "sName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSName()). Otherwise it will return false.
     */
    inline bool hasSName () const;

    /**
     * Returns the value of the member "sName".
     *
     * Name received as input from the Dial Extended interface. Will be empty in all other scenarios.
     *
     * @return The value of the field "sName"
     */
    inline const ::fi_basetypes_most::T_String& getSName () const;

    /**
     * Retrieves the value of the field "sName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sName".
     */
    inline ::fi_basetypes_most::T_String& getSNameMutable ();

    /**
     * Sets the value of the member "sName".
     *
     * Name received as input from the Dial Extended interface. Will be empty in all other scenarios.
     *
     * @param sName The value which will be set
     */
    inline void setSName (const ::fi_basetypes_most::T_String& sName_);

    // API of field "sOutgoingCallFailedReason"

    static const int kSOutgoingCallFailedReason = 3;

    /**
     * Clears the field "sOutgoingCallFailedReason".
     *
     * The field will be set to its default value. The hasSOutgoingCallFailedReason()
     * method will return false.
     */
    inline void clearSOutgoingCallFailedReason();

    /**
     * Checks whether the field "sOutgoingCallFailedReason" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSOutgoingCallFailedReason()). Otherwise it will return false.
     */
    inline bool hasSOutgoingCallFailedReason () const;

    /**
     * Returns the value of the member "sOutgoingCallFailedReason".
     *
     * Outgoing call Failed Reason
     * The error strings are the ones defined in BT stack under the ALPS specification table - "Extended Audio Gateway Error Result Codes".
     *
     * @return The value of the field "sOutgoingCallFailedReason"
     */
    inline const ::fi_basetypes_most::T_String& getSOutgoingCallFailedReason () const;

    /**
     * Retrieves the value of the field "sOutgoingCallFailedReason" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sOutgoingCallFailedReason".
     */
    inline ::fi_basetypes_most::T_String& getSOutgoingCallFailedReasonMutable ();

    /**
     * Sets the value of the member "sOutgoingCallFailedReason".
     *
     * Outgoing call Failed Reason
     * The error strings are the ones defined in BT stack under the ALPS specification table - "Extended Audio Gateway Error Result Codes".
     *
     * @param sOutgoingCallFailedReason The value which will be set
     */
    inline void setSOutgoingCallFailedReason (const ::fi_basetypes_most::T_String& sOutgoingCallFailedReason_);

    static const T_TelOutgoingCall_Failed &getDefaultInstance();

private:

    inline void set_has_u8DeviceHandle ();

    inline void clear_has_u8DeviceHandle ();

    inline void set_has_sTelephoneNumber ();

    inline void clear_has_sTelephoneNumber ();

    inline void set_has_sName ();

    inline void clear_has_sName ();

    inline void set_has_sOutgoingCallFailedReason ();

    inline void clear_has_sOutgoingCallFailedReason ();

    uint32 _has_bits_[ (4 + 31) / 32];

    uint8 _u8DeviceHandle;

    ::fi_basetypes_most::T_String _sTelephoneNumber;

    ::fi_basetypes_most::T_String _sName;

    ::fi_basetypes_most::T_String _sOutgoingCallFailedReason;

};

/**
 * If the meaning of "T_TelIncomingCall_Rejected" isn't clear, then there should be a description here.
 */
class T_TelIncomingCall_Rejected {
public:

    /**
     * Default constructor
     */
    inline  T_TelIncomingCall_Rejected ();

    /**
     * Copy constructor
     */
    inline  T_TelIncomingCall_Rejected (const T_TelIncomingCall_Rejected &rhs);

    /**
     * All fields constructor
     */
    inline  T_TelIncomingCall_Rejected (uint8 u8DeviceHandle_, const ::fi_basetypes_most::T_String& sTelephoneNumber_, const ::fi_basetypes_most::T_String& sIncomingCallRejectedReason_);

    /**
     * Destructor
     */
    inline  ~T_TelIncomingCall_Rejected();

    /**
     * Assignment operator
     */
    inline T_TelIncomingCall_Rejected& operator = (const T_TelIncomingCall_Rejected& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_TelIncomingCall_Rejected& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_TelIncomingCall_Rejected& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_TelIncomingCall_Rejected& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_TelIncomingCall_Rejected& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8DeviceHandle"

    static const int kU8DeviceHandle = 0;

    /**
     * Clears the field "u8DeviceHandle".
     *
     * The field will be set to its default value. The hasU8DeviceHandle()
     * method will return false.
     */
    inline void clearU8DeviceHandle();

    /**
     * Checks whether the field "u8DeviceHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8DeviceHandle()). Otherwise it will return false.
     */
    inline bool hasU8DeviceHandle () const;

    /**
     * Returns the value of the member "u8DeviceHandle".
     *
     * The DeviceHandle of the Bluetooth device for which the Incoming call was Rejected
     *
     * @return The value of the field "u8DeviceHandle"
     */
    inline uint8 getU8DeviceHandle () const;

    /**
     * Sets the value of the member "u8DeviceHandle".
     *
     * The DeviceHandle of the Bluetooth device for which the Incoming call was Rejected
     *
     * @param u8DeviceHandle The value which will be set
     */
    inline void setU8DeviceHandle (uint8 u8DeviceHandle_);

    // API of field "sTelephoneNumber"

    static const int kSTelephoneNumber = 1;

    /**
     * Clears the field "sTelephoneNumber".
     *
     * The field will be set to its default value. The hasSTelephoneNumber()
     * method will return false.
     */
    inline void clearSTelephoneNumber();

    /**
     * Checks whether the field "sTelephoneNumber" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSTelephoneNumber()). Otherwise it will return false.
     */
    inline bool hasSTelephoneNumber () const;

    /**
     * Returns the value of the member "sTelephoneNumber".
     *
     * Phone number
     *
     * @return The value of the field "sTelephoneNumber"
     */
    inline const ::fi_basetypes_most::T_String& getSTelephoneNumber () const;

    /**
     * Retrieves the value of the field "sTelephoneNumber" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sTelephoneNumber".
     */
    inline ::fi_basetypes_most::T_String& getSTelephoneNumberMutable ();

    /**
     * Sets the value of the member "sTelephoneNumber".
     *
     * Phone number
     *
     * @param sTelephoneNumber The value which will be set
     */
    inline void setSTelephoneNumber (const ::fi_basetypes_most::T_String& sTelephoneNumber_);

    // API of field "sIncomingCallRejectedReason"

    static const int kSIncomingCallRejectedReason = 2;

    /**
     * Clears the field "sIncomingCallRejectedReason".
     *
     * The field will be set to its default value. The hasSIncomingCallRejectedReason()
     * method will return false.
     */
    inline void clearSIncomingCallRejectedReason();

    /**
     * Checks whether the field "sIncomingCallRejectedReason" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSIncomingCallRejectedReason()). Otherwise it will return false.
     */
    inline bool hasSIncomingCallRejectedReason () const;

    /**
     * Returns the value of the member "sIncomingCallRejectedReason".
     *
     * Incoming call Rejected Reason
     * * Incoming call will be rejected when the Waiting Mode state is Active.
     * * Incoming call will be rejected for project related scenarios like:- When a three way call is active.
     *
     * @return The value of the field "sIncomingCallRejectedReason"
     */
    inline const ::fi_basetypes_most::T_String& getSIncomingCallRejectedReason () const;

    /**
     * Retrieves the value of the field "sIncomingCallRejectedReason" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sIncomingCallRejectedReason".
     */
    inline ::fi_basetypes_most::T_String& getSIncomingCallRejectedReasonMutable ();

    /**
     * Sets the value of the member "sIncomingCallRejectedReason".
     *
     * Incoming call Rejected Reason
     * * Incoming call will be rejected when the Waiting Mode state is Active.
     * * Incoming call will be rejected for project related scenarios like:- When a three way call is active.
     *
     * @param sIncomingCallRejectedReason The value which will be set
     */
    inline void setSIncomingCallRejectedReason (const ::fi_basetypes_most::T_String& sIncomingCallRejectedReason_);

    static const T_TelIncomingCall_Rejected &getDefaultInstance();

private:

    inline void set_has_u8DeviceHandle ();

    inline void clear_has_u8DeviceHandle ();

    inline void set_has_sTelephoneNumber ();

    inline void clear_has_sTelephoneNumber ();

    inline void set_has_sIncomingCallRejectedReason ();

    inline void clear_has_sIncomingCallRejectedReason ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint8 _u8DeviceHandle;

    ::fi_basetypes_most::T_String _sTelephoneNumber;

    ::fi_basetypes_most::T_String _sIncomingCallRejectedReason;

};

/**
 * If the meaning of "T_ListOfCallInstanceStreamItem" isn't clear, then there should be a description here.
 */
class T_ListOfCallInstanceStreamItem {
public:

    /**
     * Default constructor
     */
    inline  T_ListOfCallInstanceStreamItem ();

    /**
     * Copy constructor
     */
    inline  T_ListOfCallInstanceStreamItem (const T_ListOfCallInstanceStreamItem &rhs);

    /**
     * All fields constructor
     */
    inline  T_ListOfCallInstanceStreamItem (uint16 u16CallInstance_);

    /**
     * Destructor
     */
    inline  ~T_ListOfCallInstanceStreamItem();

    /**
     * Assignment operator
     */
    inline T_ListOfCallInstanceStreamItem& operator = (const T_ListOfCallInstanceStreamItem& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_ListOfCallInstanceStreamItem& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_ListOfCallInstanceStreamItem& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_ListOfCallInstanceStreamItem& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_ListOfCallInstanceStreamItem& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u16CallInstance"

    static const int kU16CallInstance = 0;

    /**
     * Clears the field "u16CallInstance".
     *
     * The field will be set to its default value. The hasU16CallInstance()
     * method will return false.
     */
    inline void clearU16CallInstance();

    /**
     * Checks whether the field "u16CallInstance" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16CallInstance()). Otherwise it will return false.
     */
    inline bool hasU16CallInstance () const;

    /**
     * Returns the value of the member "u16CallInstance".
     *
     * Instance of voice call
     *
     * @return The value of the field "u16CallInstance"
     */
    inline uint16 getU16CallInstance () const;

    /**
     * Sets the value of the member "u16CallInstance".
     *
     * Instance of voice call
     *
     * @param u16CallInstance The value which will be set
     */
    inline void setU16CallInstance (uint16 u16CallInstance_);

    static const T_ListOfCallInstanceStreamItem &getDefaultInstance();

private:

    inline void set_has_u16CallInstance ();

    inline void clear_has_u16CallInstance ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _u16CallInstance;

};

inline  T_TelCallStatusNoticeExtendedStreamItem::T_TelCallStatusNoticeExtendedStreamItem ()  :
    _u16CallInstance (0u),
    _e8CallStatus (::most_Tel_fi_types::T_e8_TelCallStatus__e8IDLE),
    _bUsingVehicleAudio (false),
    _u8CallDurationHr (0u),
    _u8CallDurationMin (0u),
    _u8CallDurationSec (0u),
    _u8DeviceHandle (0u),
    _sTelephoneNumber (),
    _sName ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_TelCallStatusNoticeExtendedStreamItem::T_TelCallStatusNoticeExtendedStreamItem (const T_TelCallStatusNoticeExtendedStreamItem &rhs)  :
    _u16CallInstance (0u),
    _e8CallStatus (::most_Tel_fi_types::T_e8_TelCallStatus__e8IDLE),
    _bUsingVehicleAudio (false),
    _u8CallDurationHr (0u),
    _u8CallDurationMin (0u),
    _u8CallDurationSec (0u),
    _u8DeviceHandle (0u),
    _sTelephoneNumber (),
    _sName ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_TelCallStatusNoticeExtendedStreamItem::T_TelCallStatusNoticeExtendedStreamItem (uint16 u16CallInstance_, ::most_Tel_fi_types::T_e8_TelCallStatus e8CallStatus_, bool bUsingVehicleAudio_, uint8 u8CallDurationHr_, uint8 u8CallDurationMin_, uint8 u8CallDurationSec_, uint8 u8DeviceHandle_, const ::fi_basetypes_most::T_String& sTelephoneNumber_, const ::fi_basetypes_most::T_String& sName_)  :
    _u16CallInstance (u16CallInstance_),
    _e8CallStatus (e8CallStatus_),
    _bUsingVehicleAudio (bUsingVehicleAudio_),
    _u8CallDurationHr (u8CallDurationHr_),
    _u8CallDurationMin (u8CallDurationMin_),
    _u8CallDurationSec (u8CallDurationSec_),
    _u8DeviceHandle (u8DeviceHandle_),
    _sTelephoneNumber (sTelephoneNumber_),
    _sName (sName_)
{
    #ifndef NDEBUG
    if (!(::most_Tel_fi_types::T_e8_TelCallStatus_IsValid(e8CallStatus_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8CallStatus_, "T_e8_TelCallStatus", "e8CallStatus", "T_TelCallStatusNoticeExtendedStreamItem");
    }
    #endif
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sTelephoneNumber_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sName_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_TelCallStatusNoticeExtendedStreamItem::~T_TelCallStatusNoticeExtendedStreamItem() {
}

inline T_TelCallStatusNoticeExtendedStreamItem& T_TelCallStatusNoticeExtendedStreamItem::operator = (const T_TelCallStatusNoticeExtendedStreamItem& rhs) {
    if( this != &rhs ) {
        if (rhs.hasU16CallInstance()) {
            setU16CallInstance(rhs.getU16CallInstance());
        } else {
            clearU16CallInstance();
        }
        if (rhs.hasE8CallStatus()) {
            setE8CallStatus(rhs.getE8CallStatus());
        } else {
            clearE8CallStatus();
        }
        if (rhs.hasBUsingVehicleAudio()) {
            setBUsingVehicleAudio(rhs.getBUsingVehicleAudio());
        } else {
            clearBUsingVehicleAudio();
        }
        if (rhs.hasU8CallDurationHr()) {
            setU8CallDurationHr(rhs.getU8CallDurationHr());
        } else {
            clearU8CallDurationHr();
        }
        if (rhs.hasU8CallDurationMin()) {
            setU8CallDurationMin(rhs.getU8CallDurationMin());
        } else {
            clearU8CallDurationMin();
        }
        if (rhs.hasU8CallDurationSec()) {
            setU8CallDurationSec(rhs.getU8CallDurationSec());
        } else {
            clearU8CallDurationSec();
        }
        if (rhs.hasU8DeviceHandle()) {
            setU8DeviceHandle(rhs.getU8DeviceHandle());
        } else {
            clearU8DeviceHandle();
        }
        if (rhs.hasSTelephoneNumber()) {
            setSTelephoneNumber(rhs.getSTelephoneNumber());
        } else {
            clearSTelephoneNumber();
        }
        if (rhs.hasSName()) {
            setSName(rhs.getSName());
        } else {
            clearSName();
        }
    }
    return *this;
}

inline bool T_TelCallStatusNoticeExtendedStreamItem::operator == (const T_TelCallStatusNoticeExtendedStreamItem& rhs) const {
    return (((!hasU16CallInstance() && !rhs.hasU16CallInstance()) || getU16CallInstance() == rhs.getU16CallInstance()) &&
        ((!hasE8CallStatus() && !rhs.hasE8CallStatus()) || getE8CallStatus() == rhs.getE8CallStatus()) &&
        ((!hasBUsingVehicleAudio() && !rhs.hasBUsingVehicleAudio()) || getBUsingVehicleAudio() == rhs.getBUsingVehicleAudio()) &&
        ((!hasU8CallDurationHr() && !rhs.hasU8CallDurationHr()) || getU8CallDurationHr() == rhs.getU8CallDurationHr()) &&
        ((!hasU8CallDurationMin() && !rhs.hasU8CallDurationMin()) || getU8CallDurationMin() == rhs.getU8CallDurationMin()) &&
        ((!hasU8CallDurationSec() && !rhs.hasU8CallDurationSec()) || getU8CallDurationSec() == rhs.getU8CallDurationSec()) &&
        ((!hasU8DeviceHandle() && !rhs.hasU8DeviceHandle()) || getU8DeviceHandle() == rhs.getU8DeviceHandle()) &&
        ((!hasSTelephoneNumber() && !rhs.hasSTelephoneNumber()) || getSTelephoneNumber() == rhs.getSTelephoneNumber()) &&
        ((!hasSName() && !rhs.hasSName()) || getSName() == rhs.getSName()));
}

inline bool T_TelCallStatusNoticeExtendedStreamItem::operator != (const T_TelCallStatusNoticeExtendedStreamItem& rhs) const {
    return ! (*this == rhs);
}

inline bool T_TelCallStatusNoticeExtendedStreamItem::operator < (const T_TelCallStatusNoticeExtendedStreamItem& rhs) const {
    if (hasU16CallInstance() || rhs.hasU16CallInstance()) {
        if (getU16CallInstance() < rhs.getU16CallInstance()) return true;
        if (getU16CallInstance() > rhs.getU16CallInstance()) return false;
    }
    if (hasE8CallStatus() || rhs.hasE8CallStatus()) {
        if ((uint32)getE8CallStatus() < (uint32)rhs.getE8CallStatus()) return true;
        if ((uint32)getE8CallStatus() > (uint32)rhs.getE8CallStatus()) return false;
    }
    if (hasBUsingVehicleAudio() || rhs.hasBUsingVehicleAudio()) {
        if (getBUsingVehicleAudio() < rhs.getBUsingVehicleAudio()) return true;
        if (getBUsingVehicleAudio() > rhs.getBUsingVehicleAudio()) return false;
    }
    if (hasU8CallDurationHr() || rhs.hasU8CallDurationHr()) {
        if (getU8CallDurationHr() < rhs.getU8CallDurationHr()) return true;
        if (getU8CallDurationHr() > rhs.getU8CallDurationHr()) return false;
    }
    if (hasU8CallDurationMin() || rhs.hasU8CallDurationMin()) {
        if (getU8CallDurationMin() < rhs.getU8CallDurationMin()) return true;
        if (getU8CallDurationMin() > rhs.getU8CallDurationMin()) return false;
    }
    if (hasU8CallDurationSec() || rhs.hasU8CallDurationSec()) {
        if (getU8CallDurationSec() < rhs.getU8CallDurationSec()) return true;
        if (getU8CallDurationSec() > rhs.getU8CallDurationSec()) return false;
    }
    if (hasU8DeviceHandle() || rhs.hasU8DeviceHandle()) {
        if (getU8DeviceHandle() < rhs.getU8DeviceHandle()) return true;
        if (getU8DeviceHandle() > rhs.getU8DeviceHandle()) return false;
    }
    if (hasSTelephoneNumber() || rhs.hasSTelephoneNumber()) {
        if (getSTelephoneNumber() < rhs.getSTelephoneNumber()) return true;
        if (getSTelephoneNumber() > rhs.getSTelephoneNumber()) return false;
    }
    if (hasSName() || rhs.hasSName()) {
        if (getSName() < rhs.getSName()) return true;
        if (getSName() > rhs.getSName()) return false;
    }
    return false;
}

inline bool T_TelCallStatusNoticeExtendedStreamItem::operator > (const T_TelCallStatusNoticeExtendedStreamItem& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_TelCallStatusNoticeExtendedStreamItem::clear() {
    clearU16CallInstance();
    clearE8CallStatus();
    clearBUsingVehicleAudio();
    clearU8CallDurationHr();
    clearU8CallDurationMin();
    clearU8CallDurationSec();
    clearU8DeviceHandle();
    clearSTelephoneNumber();
    clearSName();
}

inline void T_TelCallStatusNoticeExtendedStreamItem::clearU16CallInstance() {
    if (hasU16CallInstance()) {
         clear_has_u16CallInstance();
        _u16CallInstance = 0u;
     }
}

inline bool T_TelCallStatusNoticeExtendedStreamItem::hasU16CallInstance () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint16 T_TelCallStatusNoticeExtendedStreamItem::getU16CallInstance () const {
    return _u16CallInstance;
}

inline void T_TelCallStatusNoticeExtendedStreamItem::setU16CallInstance (uint16 u16CallInstance_) {
    set_has_u16CallInstance();
    this->_u16CallInstance = u16CallInstance_;
}

inline void T_TelCallStatusNoticeExtendedStreamItem::clearE8CallStatus() {
    if (hasE8CallStatus()) {
         clear_has_e8CallStatus();
        _e8CallStatus = ::most_Tel_fi_types::T_e8_TelCallStatus__e8IDLE;
     }
}

inline bool T_TelCallStatusNoticeExtendedStreamItem::hasE8CallStatus () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline ::most_Tel_fi_types::T_e8_TelCallStatus T_TelCallStatusNoticeExtendedStreamItem::getE8CallStatus () const {
    return _e8CallStatus;
}

inline void T_TelCallStatusNoticeExtendedStreamItem::setE8CallStatus (::most_Tel_fi_types::T_e8_TelCallStatus e8CallStatus_) {
    #ifndef NDEBUG
    if (!(::most_Tel_fi_types::T_e8_TelCallStatus_IsValid(e8CallStatus_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8CallStatus_, "T_e8_TelCallStatus", "e8CallStatus", "T_TelCallStatusNoticeExtendedStreamItem");
    }
    #endif
    set_has_e8CallStatus();
    this->_e8CallStatus = e8CallStatus_;
}

inline void T_TelCallStatusNoticeExtendedStreamItem::clearBUsingVehicleAudio() {
    if (hasBUsingVehicleAudio()) {
         clear_has_bUsingVehicleAudio();
        _bUsingVehicleAudio = false;
     }
}

inline bool T_TelCallStatusNoticeExtendedStreamItem::hasBUsingVehicleAudio () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline bool T_TelCallStatusNoticeExtendedStreamItem::getBUsingVehicleAudio () const {
    return _bUsingVehicleAudio;
}

inline void T_TelCallStatusNoticeExtendedStreamItem::setBUsingVehicleAudio (bool bUsingVehicleAudio_) {
    set_has_bUsingVehicleAudio();
    this->_bUsingVehicleAudio = bUsingVehicleAudio_;
}

inline void T_TelCallStatusNoticeExtendedStreamItem::clearU8CallDurationHr() {
    if (hasU8CallDurationHr()) {
         clear_has_u8CallDurationHr();
        _u8CallDurationHr = 0u;
     }
}

inline bool T_TelCallStatusNoticeExtendedStreamItem::hasU8CallDurationHr () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint8 T_TelCallStatusNoticeExtendedStreamItem::getU8CallDurationHr () const {
    return _u8CallDurationHr;
}

inline void T_TelCallStatusNoticeExtendedStreamItem::setU8CallDurationHr (uint8 u8CallDurationHr_) {
    set_has_u8CallDurationHr();
    this->_u8CallDurationHr = u8CallDurationHr_;
}

inline void T_TelCallStatusNoticeExtendedStreamItem::clearU8CallDurationMin() {
    if (hasU8CallDurationMin()) {
         clear_has_u8CallDurationMin();
        _u8CallDurationMin = 0u;
     }
}

inline bool T_TelCallStatusNoticeExtendedStreamItem::hasU8CallDurationMin () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline uint8 T_TelCallStatusNoticeExtendedStreamItem::getU8CallDurationMin () const {
    return _u8CallDurationMin;
}

inline void T_TelCallStatusNoticeExtendedStreamItem::setU8CallDurationMin (uint8 u8CallDurationMin_) {
    set_has_u8CallDurationMin();
    this->_u8CallDurationMin = u8CallDurationMin_;
}

inline void T_TelCallStatusNoticeExtendedStreamItem::clearU8CallDurationSec() {
    if (hasU8CallDurationSec()) {
         clear_has_u8CallDurationSec();
        _u8CallDurationSec = 0u;
     }
}

inline bool T_TelCallStatusNoticeExtendedStreamItem::hasU8CallDurationSec () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline uint8 T_TelCallStatusNoticeExtendedStreamItem::getU8CallDurationSec () const {
    return _u8CallDurationSec;
}

inline void T_TelCallStatusNoticeExtendedStreamItem::setU8CallDurationSec (uint8 u8CallDurationSec_) {
    set_has_u8CallDurationSec();
    this->_u8CallDurationSec = u8CallDurationSec_;
}

inline void T_TelCallStatusNoticeExtendedStreamItem::clearU8DeviceHandle() {
    if (hasU8DeviceHandle()) {
         clear_has_u8DeviceHandle();
        _u8DeviceHandle = 0u;
     }
}

inline bool T_TelCallStatusNoticeExtendedStreamItem::hasU8DeviceHandle () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline uint8 T_TelCallStatusNoticeExtendedStreamItem::getU8DeviceHandle () const {
    return _u8DeviceHandle;
}

inline void T_TelCallStatusNoticeExtendedStreamItem::setU8DeviceHandle (uint8 u8DeviceHandle_) {
    set_has_u8DeviceHandle();
    this->_u8DeviceHandle = u8DeviceHandle_;
}

inline void T_TelCallStatusNoticeExtendedStreamItem::clearSTelephoneNumber() {
    if (hasSTelephoneNumber()) {
         clear_has_sTelephoneNumber();
        _sTelephoneNumber.clear();
     }
}

inline bool T_TelCallStatusNoticeExtendedStreamItem::hasSTelephoneNumber () const {
    return (_has_bits_[0] & (1u << 7)) > 0;
}

inline const ::fi_basetypes_most::T_String& T_TelCallStatusNoticeExtendedStreamItem::getSTelephoneNumber () const {
    return _sTelephoneNumber;
}

inline ::fi_basetypes_most::T_String& T_TelCallStatusNoticeExtendedStreamItem::getSTelephoneNumberMutable () {
    set_has_sTelephoneNumber();
    return _sTelephoneNumber;
}

inline void T_TelCallStatusNoticeExtendedStreamItem::setSTelephoneNumber (const ::fi_basetypes_most::T_String& sTelephoneNumber_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sTelephoneNumber_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sTelephoneNumber();
    this->_sTelephoneNumber = sTelephoneNumber_;
}

inline void T_TelCallStatusNoticeExtendedStreamItem::clearSName() {
    if (hasSName()) {
         clear_has_sName();
        _sName.clear();
     }
}

inline bool T_TelCallStatusNoticeExtendedStreamItem::hasSName () const {
    return (_has_bits_[0] & (1u << 8)) > 0;
}

inline const ::fi_basetypes_most::T_String& T_TelCallStatusNoticeExtendedStreamItem::getSName () const {
    return _sName;
}

inline ::fi_basetypes_most::T_String& T_TelCallStatusNoticeExtendedStreamItem::getSNameMutable () {
    set_has_sName();
    return _sName;
}

inline void T_TelCallStatusNoticeExtendedStreamItem::setSName (const ::fi_basetypes_most::T_String& sName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sName();
    this->_sName = sName_;
}

inline void T_TelCallStatusNoticeExtendedStreamItem::set_has_u16CallInstance () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_TelCallStatusNoticeExtendedStreamItem::clear_has_u16CallInstance () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_TelCallStatusNoticeExtendedStreamItem::set_has_e8CallStatus () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_TelCallStatusNoticeExtendedStreamItem::clear_has_e8CallStatus () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_TelCallStatusNoticeExtendedStreamItem::set_has_bUsingVehicleAudio () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_TelCallStatusNoticeExtendedStreamItem::clear_has_bUsingVehicleAudio () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_TelCallStatusNoticeExtendedStreamItem::set_has_u8CallDurationHr () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_TelCallStatusNoticeExtendedStreamItem::clear_has_u8CallDurationHr () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_TelCallStatusNoticeExtendedStreamItem::set_has_u8CallDurationMin () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_TelCallStatusNoticeExtendedStreamItem::clear_has_u8CallDurationMin () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void T_TelCallStatusNoticeExtendedStreamItem::set_has_u8CallDurationSec () {
    _has_bits_[0] |= 1u << 5;
}

inline void T_TelCallStatusNoticeExtendedStreamItem::clear_has_u8CallDurationSec () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void T_TelCallStatusNoticeExtendedStreamItem::set_has_u8DeviceHandle () {
    _has_bits_[0] |= 1u << 6;
}

inline void T_TelCallStatusNoticeExtendedStreamItem::clear_has_u8DeviceHandle () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline void T_TelCallStatusNoticeExtendedStreamItem::set_has_sTelephoneNumber () {
    _has_bits_[0] |= 1u << 7;
}

inline void T_TelCallStatusNoticeExtendedStreamItem::clear_has_sTelephoneNumber () {
    _has_bits_[0] &= ~ (1u << 7);
}

inline void T_TelCallStatusNoticeExtendedStreamItem::set_has_sName () {
    _has_bits_[0] |= 1u << 8;
}

inline void T_TelCallStatusNoticeExtendedStreamItem::clear_has_sName () {
    _has_bits_[0] &= ~ (1u << 8);
}

inline  T_TelOutgoingCall_Failed::T_TelOutgoingCall_Failed ()  :
    _u8DeviceHandle (0u),
    _sTelephoneNumber (),
    _sName (),
    _sOutgoingCallFailedReason ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_TelOutgoingCall_Failed::T_TelOutgoingCall_Failed (const T_TelOutgoingCall_Failed &rhs)  :
    _u8DeviceHandle (0u),
    _sTelephoneNumber (),
    _sName (),
    _sOutgoingCallFailedReason ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_TelOutgoingCall_Failed::T_TelOutgoingCall_Failed (uint8 u8DeviceHandle_, const ::fi_basetypes_most::T_String& sTelephoneNumber_, const ::fi_basetypes_most::T_String& sName_, const ::fi_basetypes_most::T_String& sOutgoingCallFailedReason_)  :
    _u8DeviceHandle (u8DeviceHandle_),
    _sTelephoneNumber (sTelephoneNumber_),
    _sName (sName_),
    _sOutgoingCallFailedReason (sOutgoingCallFailedReason_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sTelephoneNumber_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sName_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sOutgoingCallFailedReason_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_TelOutgoingCall_Failed::~T_TelOutgoingCall_Failed() {
}

inline T_TelOutgoingCall_Failed& T_TelOutgoingCall_Failed::operator = (const T_TelOutgoingCall_Failed& rhs) {
    if( this != &rhs ) {
        if (rhs.hasU8DeviceHandle()) {
            setU8DeviceHandle(rhs.getU8DeviceHandle());
        } else {
            clearU8DeviceHandle();
        }
        if (rhs.hasSTelephoneNumber()) {
            setSTelephoneNumber(rhs.getSTelephoneNumber());
        } else {
            clearSTelephoneNumber();
        }
        if (rhs.hasSName()) {
            setSName(rhs.getSName());
        } else {
            clearSName();
        }
        if (rhs.hasSOutgoingCallFailedReason()) {
            setSOutgoingCallFailedReason(rhs.getSOutgoingCallFailedReason());
        } else {
            clearSOutgoingCallFailedReason();
        }
    }
    return *this;
}

inline bool T_TelOutgoingCall_Failed::operator == (const T_TelOutgoingCall_Failed& rhs) const {
    return (((!hasU8DeviceHandle() && !rhs.hasU8DeviceHandle()) || getU8DeviceHandle() == rhs.getU8DeviceHandle()) &&
        ((!hasSTelephoneNumber() && !rhs.hasSTelephoneNumber()) || getSTelephoneNumber() == rhs.getSTelephoneNumber()) &&
        ((!hasSName() && !rhs.hasSName()) || getSName() == rhs.getSName()) &&
        ((!hasSOutgoingCallFailedReason() && !rhs.hasSOutgoingCallFailedReason()) || getSOutgoingCallFailedReason() == rhs.getSOutgoingCallFailedReason()));
}

inline bool T_TelOutgoingCall_Failed::operator != (const T_TelOutgoingCall_Failed& rhs) const {
    return ! (*this == rhs);
}

inline bool T_TelOutgoingCall_Failed::operator < (const T_TelOutgoingCall_Failed& rhs) const {
    if (hasU8DeviceHandle() || rhs.hasU8DeviceHandle()) {
        if (getU8DeviceHandle() < rhs.getU8DeviceHandle()) return true;
        if (getU8DeviceHandle() > rhs.getU8DeviceHandle()) return false;
    }
    if (hasSTelephoneNumber() || rhs.hasSTelephoneNumber()) {
        if (getSTelephoneNumber() < rhs.getSTelephoneNumber()) return true;
        if (getSTelephoneNumber() > rhs.getSTelephoneNumber()) return false;
    }
    if (hasSName() || rhs.hasSName()) {
        if (getSName() < rhs.getSName()) return true;
        if (getSName() > rhs.getSName()) return false;
    }
    if (hasSOutgoingCallFailedReason() || rhs.hasSOutgoingCallFailedReason()) {
        if (getSOutgoingCallFailedReason() < rhs.getSOutgoingCallFailedReason()) return true;
        if (getSOutgoingCallFailedReason() > rhs.getSOutgoingCallFailedReason()) return false;
    }
    return false;
}

inline bool T_TelOutgoingCall_Failed::operator > (const T_TelOutgoingCall_Failed& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_TelOutgoingCall_Failed::clear() {
    clearU8DeviceHandle();
    clearSTelephoneNumber();
    clearSName();
    clearSOutgoingCallFailedReason();
}

inline void T_TelOutgoingCall_Failed::clearU8DeviceHandle() {
    if (hasU8DeviceHandle()) {
         clear_has_u8DeviceHandle();
        _u8DeviceHandle = 0u;
     }
}

inline bool T_TelOutgoingCall_Failed::hasU8DeviceHandle () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 T_TelOutgoingCall_Failed::getU8DeviceHandle () const {
    return _u8DeviceHandle;
}

inline void T_TelOutgoingCall_Failed::setU8DeviceHandle (uint8 u8DeviceHandle_) {
    set_has_u8DeviceHandle();
    this->_u8DeviceHandle = u8DeviceHandle_;
}

inline void T_TelOutgoingCall_Failed::clearSTelephoneNumber() {
    if (hasSTelephoneNumber()) {
         clear_has_sTelephoneNumber();
        _sTelephoneNumber.clear();
     }
}

inline bool T_TelOutgoingCall_Failed::hasSTelephoneNumber () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::fi_basetypes_most::T_String& T_TelOutgoingCall_Failed::getSTelephoneNumber () const {
    return _sTelephoneNumber;
}

inline ::fi_basetypes_most::T_String& T_TelOutgoingCall_Failed::getSTelephoneNumberMutable () {
    set_has_sTelephoneNumber();
    return _sTelephoneNumber;
}

inline void T_TelOutgoingCall_Failed::setSTelephoneNumber (const ::fi_basetypes_most::T_String& sTelephoneNumber_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sTelephoneNumber_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sTelephoneNumber();
    this->_sTelephoneNumber = sTelephoneNumber_;
}

inline void T_TelOutgoingCall_Failed::clearSName() {
    if (hasSName()) {
         clear_has_sName();
        _sName.clear();
     }
}

inline bool T_TelOutgoingCall_Failed::hasSName () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::fi_basetypes_most::T_String& T_TelOutgoingCall_Failed::getSName () const {
    return _sName;
}

inline ::fi_basetypes_most::T_String& T_TelOutgoingCall_Failed::getSNameMutable () {
    set_has_sName();
    return _sName;
}

inline void T_TelOutgoingCall_Failed::setSName (const ::fi_basetypes_most::T_String& sName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sName();
    this->_sName = sName_;
}

inline void T_TelOutgoingCall_Failed::clearSOutgoingCallFailedReason() {
    if (hasSOutgoingCallFailedReason()) {
         clear_has_sOutgoingCallFailedReason();
        _sOutgoingCallFailedReason.clear();
     }
}

inline bool T_TelOutgoingCall_Failed::hasSOutgoingCallFailedReason () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const ::fi_basetypes_most::T_String& T_TelOutgoingCall_Failed::getSOutgoingCallFailedReason () const {
    return _sOutgoingCallFailedReason;
}

inline ::fi_basetypes_most::T_String& T_TelOutgoingCall_Failed::getSOutgoingCallFailedReasonMutable () {
    set_has_sOutgoingCallFailedReason();
    return _sOutgoingCallFailedReason;
}

inline void T_TelOutgoingCall_Failed::setSOutgoingCallFailedReason (const ::fi_basetypes_most::T_String& sOutgoingCallFailedReason_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sOutgoingCallFailedReason_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sOutgoingCallFailedReason();
    this->_sOutgoingCallFailedReason = sOutgoingCallFailedReason_;
}

inline void T_TelOutgoingCall_Failed::set_has_u8DeviceHandle () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_TelOutgoingCall_Failed::clear_has_u8DeviceHandle () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_TelOutgoingCall_Failed::set_has_sTelephoneNumber () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_TelOutgoingCall_Failed::clear_has_sTelephoneNumber () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_TelOutgoingCall_Failed::set_has_sName () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_TelOutgoingCall_Failed::clear_has_sName () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_TelOutgoingCall_Failed::set_has_sOutgoingCallFailedReason () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_TelOutgoingCall_Failed::clear_has_sOutgoingCallFailedReason () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  T_TelIncomingCall_Rejected::T_TelIncomingCall_Rejected ()  :
    _u8DeviceHandle (0u),
    _sTelephoneNumber (),
    _sIncomingCallRejectedReason ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_TelIncomingCall_Rejected::T_TelIncomingCall_Rejected (const T_TelIncomingCall_Rejected &rhs)  :
    _u8DeviceHandle (0u),
    _sTelephoneNumber (),
    _sIncomingCallRejectedReason ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_TelIncomingCall_Rejected::T_TelIncomingCall_Rejected (uint8 u8DeviceHandle_, const ::fi_basetypes_most::T_String& sTelephoneNumber_, const ::fi_basetypes_most::T_String& sIncomingCallRejectedReason_)  :
    _u8DeviceHandle (u8DeviceHandle_),
    _sTelephoneNumber (sTelephoneNumber_),
    _sIncomingCallRejectedReason (sIncomingCallRejectedReason_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sTelephoneNumber_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sIncomingCallRejectedReason_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_TelIncomingCall_Rejected::~T_TelIncomingCall_Rejected() {
}

inline T_TelIncomingCall_Rejected& T_TelIncomingCall_Rejected::operator = (const T_TelIncomingCall_Rejected& rhs) {
    if( this != &rhs ) {
        if (rhs.hasU8DeviceHandle()) {
            setU8DeviceHandle(rhs.getU8DeviceHandle());
        } else {
            clearU8DeviceHandle();
        }
        if (rhs.hasSTelephoneNumber()) {
            setSTelephoneNumber(rhs.getSTelephoneNumber());
        } else {
            clearSTelephoneNumber();
        }
        if (rhs.hasSIncomingCallRejectedReason()) {
            setSIncomingCallRejectedReason(rhs.getSIncomingCallRejectedReason());
        } else {
            clearSIncomingCallRejectedReason();
        }
    }
    return *this;
}

inline bool T_TelIncomingCall_Rejected::operator == (const T_TelIncomingCall_Rejected& rhs) const {
    return (((!hasU8DeviceHandle() && !rhs.hasU8DeviceHandle()) || getU8DeviceHandle() == rhs.getU8DeviceHandle()) &&
        ((!hasSTelephoneNumber() && !rhs.hasSTelephoneNumber()) || getSTelephoneNumber() == rhs.getSTelephoneNumber()) &&
        ((!hasSIncomingCallRejectedReason() && !rhs.hasSIncomingCallRejectedReason()) || getSIncomingCallRejectedReason() == rhs.getSIncomingCallRejectedReason()));
}

inline bool T_TelIncomingCall_Rejected::operator != (const T_TelIncomingCall_Rejected& rhs) const {
    return ! (*this == rhs);
}

inline bool T_TelIncomingCall_Rejected::operator < (const T_TelIncomingCall_Rejected& rhs) const {
    if (hasU8DeviceHandle() || rhs.hasU8DeviceHandle()) {
        if (getU8DeviceHandle() < rhs.getU8DeviceHandle()) return true;
        if (getU8DeviceHandle() > rhs.getU8DeviceHandle()) return false;
    }
    if (hasSTelephoneNumber() || rhs.hasSTelephoneNumber()) {
        if (getSTelephoneNumber() < rhs.getSTelephoneNumber()) return true;
        if (getSTelephoneNumber() > rhs.getSTelephoneNumber()) return false;
    }
    if (hasSIncomingCallRejectedReason() || rhs.hasSIncomingCallRejectedReason()) {
        if (getSIncomingCallRejectedReason() < rhs.getSIncomingCallRejectedReason()) return true;
        if (getSIncomingCallRejectedReason() > rhs.getSIncomingCallRejectedReason()) return false;
    }
    return false;
}

inline bool T_TelIncomingCall_Rejected::operator > (const T_TelIncomingCall_Rejected& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_TelIncomingCall_Rejected::clear() {
    clearU8DeviceHandle();
    clearSTelephoneNumber();
    clearSIncomingCallRejectedReason();
}

inline void T_TelIncomingCall_Rejected::clearU8DeviceHandle() {
    if (hasU8DeviceHandle()) {
         clear_has_u8DeviceHandle();
        _u8DeviceHandle = 0u;
     }
}

inline bool T_TelIncomingCall_Rejected::hasU8DeviceHandle () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 T_TelIncomingCall_Rejected::getU8DeviceHandle () const {
    return _u8DeviceHandle;
}

inline void T_TelIncomingCall_Rejected::setU8DeviceHandle (uint8 u8DeviceHandle_) {
    set_has_u8DeviceHandle();
    this->_u8DeviceHandle = u8DeviceHandle_;
}

inline void T_TelIncomingCall_Rejected::clearSTelephoneNumber() {
    if (hasSTelephoneNumber()) {
         clear_has_sTelephoneNumber();
        _sTelephoneNumber.clear();
     }
}

inline bool T_TelIncomingCall_Rejected::hasSTelephoneNumber () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::fi_basetypes_most::T_String& T_TelIncomingCall_Rejected::getSTelephoneNumber () const {
    return _sTelephoneNumber;
}

inline ::fi_basetypes_most::T_String& T_TelIncomingCall_Rejected::getSTelephoneNumberMutable () {
    set_has_sTelephoneNumber();
    return _sTelephoneNumber;
}

inline void T_TelIncomingCall_Rejected::setSTelephoneNumber (const ::fi_basetypes_most::T_String& sTelephoneNumber_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sTelephoneNumber_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sTelephoneNumber();
    this->_sTelephoneNumber = sTelephoneNumber_;
}

inline void T_TelIncomingCall_Rejected::clearSIncomingCallRejectedReason() {
    if (hasSIncomingCallRejectedReason()) {
         clear_has_sIncomingCallRejectedReason();
        _sIncomingCallRejectedReason.clear();
     }
}

inline bool T_TelIncomingCall_Rejected::hasSIncomingCallRejectedReason () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::fi_basetypes_most::T_String& T_TelIncomingCall_Rejected::getSIncomingCallRejectedReason () const {
    return _sIncomingCallRejectedReason;
}

inline ::fi_basetypes_most::T_String& T_TelIncomingCall_Rejected::getSIncomingCallRejectedReasonMutable () {
    set_has_sIncomingCallRejectedReason();
    return _sIncomingCallRejectedReason;
}

inline void T_TelIncomingCall_Rejected::setSIncomingCallRejectedReason (const ::fi_basetypes_most::T_String& sIncomingCallRejectedReason_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sIncomingCallRejectedReason_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sIncomingCallRejectedReason();
    this->_sIncomingCallRejectedReason = sIncomingCallRejectedReason_;
}

inline void T_TelIncomingCall_Rejected::set_has_u8DeviceHandle () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_TelIncomingCall_Rejected::clear_has_u8DeviceHandle () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_TelIncomingCall_Rejected::set_has_sTelephoneNumber () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_TelIncomingCall_Rejected::clear_has_sTelephoneNumber () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_TelIncomingCall_Rejected::set_has_sIncomingCallRejectedReason () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_TelIncomingCall_Rejected::clear_has_sIncomingCallRejectedReason () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  T_ListOfCallInstanceStreamItem::T_ListOfCallInstanceStreamItem ()  :
    _u16CallInstance (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_ListOfCallInstanceStreamItem::T_ListOfCallInstanceStreamItem (const T_ListOfCallInstanceStreamItem &rhs)  :
    _u16CallInstance (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_ListOfCallInstanceStreamItem::T_ListOfCallInstanceStreamItem (uint16 u16CallInstance_)  :
    _u16CallInstance (u16CallInstance_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_ListOfCallInstanceStreamItem::~T_ListOfCallInstanceStreamItem() {
}

inline T_ListOfCallInstanceStreamItem& T_ListOfCallInstanceStreamItem::operator = (const T_ListOfCallInstanceStreamItem& rhs) {
    if( this != &rhs ) {
        if (rhs.hasU16CallInstance()) {
            setU16CallInstance(rhs.getU16CallInstance());
        } else {
            clearU16CallInstance();
        }
    }
    return *this;
}

inline bool T_ListOfCallInstanceStreamItem::operator == (const T_ListOfCallInstanceStreamItem& rhs) const {
    return (((!hasU16CallInstance() && !rhs.hasU16CallInstance()) || getU16CallInstance() == rhs.getU16CallInstance()));
}

inline bool T_ListOfCallInstanceStreamItem::operator != (const T_ListOfCallInstanceStreamItem& rhs) const {
    return ! (*this == rhs);
}

inline bool T_ListOfCallInstanceStreamItem::operator < (const T_ListOfCallInstanceStreamItem& rhs) const {
    if (hasU16CallInstance() || rhs.hasU16CallInstance()) {
        if (getU16CallInstance() < rhs.getU16CallInstance()) return true;
        if (getU16CallInstance() > rhs.getU16CallInstance()) return false;
    }
    return false;
}

inline bool T_ListOfCallInstanceStreamItem::operator > (const T_ListOfCallInstanceStreamItem& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_ListOfCallInstanceStreamItem::clear() {
    clearU16CallInstance();
}

inline void T_ListOfCallInstanceStreamItem::clearU16CallInstance() {
    if (hasU16CallInstance()) {
         clear_has_u16CallInstance();
        _u16CallInstance = 0u;
     }
}

inline bool T_ListOfCallInstanceStreamItem::hasU16CallInstance () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint16 T_ListOfCallInstanceStreamItem::getU16CallInstance () const {
    return _u16CallInstance;
}

inline void T_ListOfCallInstanceStreamItem::setU16CallInstance (uint16 u16CallInstance_) {
    set_has_u16CallInstance();
    this->_u16CallInstance = u16CallInstance_;
}

inline void T_ListOfCallInstanceStreamItem::set_has_u16CallInstance () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_ListOfCallInstanceStreamItem::clear_has_u16CallInstance () {
    _has_bits_[0] &= ~ (1u << 0);
}

} // namespace most_Tel_fi_types_Extended

#endif // MOST_TEL_FI_TYPES_EXTENDED_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
