#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef MOST_TEL_FI_TYPES_H
#define MOST_TEL_FI_TYPES_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "asf/core/VersionCheck.h"
#include "fi_basetypes_most.h"
#include "most_Tel_fi_typesConst.h"
#include <cstring>
#include <vector>

/**
 * Types most_Tel_fi_types
 */

namespace most_Tel_fi_types {

ASF_GENERATOR_VERSION_CHECK_DECLARE

// forward declarations
class T_TelActiveCallinHandsetStreamItem;

class T_TelCallStatusNoticeStreamItem;

class T_TelHFEnhancedCallControlStreamItem;

class T_TelDeviceRingtoneListResultItem;

class T_TelSystemWideRingtonesListResultItem;

class T_TelSuppressRingtoneOnOffListResultItem;

class T_TelAutoWaitingModeOnOffListResultItem;

// type definitions
/**
 * If the meaning of "T_TelActiveCallinHandsetStream" isn't clear, then there should be a description here.
 */
typedef ::std::vector< T_TelActiveCallinHandsetStreamItem > T_TelActiveCallinHandsetStream;

/**
 * If the meaning of "T_TelCallStatusNoticeStream" isn't clear, then there should be a description here.
 */
typedef ::std::vector< T_TelCallStatusNoticeStreamItem > T_TelCallStatusNoticeStream;

/**
 * If the meaning of "T_TelStreamOfCallInstances" isn't clear, then there should be a description here.
 */
typedef ::std::vector< uint16 > T_TelStreamOfCallInstances;

/**
 * If the meaning of "T_TelHFEnhancedCallControlStream" isn't clear, then there should be a description here.
 */
typedef ::std::vector< T_TelHFEnhancedCallControlStreamItem > T_TelHFEnhancedCallControlStream;

/**
 * If the meaning of "T_TelDeviceRingtoneListResult" isn't clear, then there should be a description here.
 */
typedef ::std::vector< T_TelDeviceRingtoneListResultItem > T_TelDeviceRingtoneListResult;

/**
 * If the meaning of "T_TelSystemWideRingtonesListResult" isn't clear, then there should be a description here.
 */
typedef ::std::vector< T_TelSystemWideRingtonesListResultItem > T_TelSystemWideRingtonesListResult;

/**
 * If the meaning of "T_TelSuppressRingtoneOnOffListResult" isn't clear, then there should be a description here.
 */
typedef ::std::vector< T_TelSuppressRingtoneOnOffListResultItem > T_TelSuppressRingtoneOnOffListResult;

/**
 * If the meaning of "T_TelAutoWaitingModeOnOffListResult" isn't clear, then there should be a description here.
 */
typedef ::std::vector< T_TelAutoWaitingModeOnOffListResultItem > T_TelAutoWaitingModeOnOffListResult;


class T_TelActiveCallinHandsetStreamItem {
public:

    /**
     * Default constructor
     */
    inline  T_TelActiveCallinHandsetStreamItem ();

    /**
     * Copy constructor
     */
    inline  T_TelActiveCallinHandsetStreamItem (const T_TelActiveCallinHandsetStreamItem &rhs);

    /**
     * All fields constructor
     */
    inline  T_TelActiveCallinHandsetStreamItem (T_e8_TelHandsetState e8HandsetState_, uint8 u8DeviceHandle_);

    /**
     * Destructor
     */
    inline  ~T_TelActiveCallinHandsetStreamItem();

    /**
     * Assignment operator
     */
    inline T_TelActiveCallinHandsetStreamItem& operator = (const T_TelActiveCallinHandsetStreamItem& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_TelActiveCallinHandsetStreamItem& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_TelActiveCallinHandsetStreamItem& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_TelActiveCallinHandsetStreamItem& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_TelActiveCallinHandsetStreamItem& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8HandsetState"

    static const int kE8HandsetState = 0;

    /**
     * Clears the field "e8HandsetState".
     *
     * The field will be set to its default value. The hasE8HandsetState()
     * method will return false.
     */
    inline void clearE8HandsetState();

    /**
     * Checks whether the field "e8HandsetState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8HandsetState()). Otherwise it will return false.
     */
    inline bool hasE8HandsetState () const;

    /**
     * Returns the value of the member "e8HandsetState".
     *
     * State of the BT handset
     *
     * @return The value of the field "e8HandsetState"
     */
    inline T_e8_TelHandsetState getE8HandsetState () const;

    /**
     * Sets the value of the member "e8HandsetState".
     *
     * State of the BT handset
     *
     * @param e8HandsetState The value which will be set
     */
    inline void setE8HandsetState (T_e8_TelHandsetState e8HandsetState_);

    // API of field "u8DeviceHandle"

    static const int kU8DeviceHandle = 1;

    /**
     * Clears the field "u8DeviceHandle".
     *
     * The field will be set to its default value. The hasU8DeviceHandle()
     * method will return false.
     */
    inline void clearU8DeviceHandle();

    /**
     * Checks whether the field "u8DeviceHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8DeviceHandle()). Otherwise it will return false.
     */
    inline bool hasU8DeviceHandle () const;

    /**
     * Returns the value of the member "u8DeviceHandle".
     *
     * Unique handle for each one of the up to 10 devices that can be paired.  Handles are maintained by BluetoothSettings FBlock.  0 is reserved as Null. Valid handles are 1..10 inclusive.
     *
     * @return The value of the field "u8DeviceHandle"
     */
    inline uint8 getU8DeviceHandle () const;

    /**
     * Sets the value of the member "u8DeviceHandle".
     *
     * Unique handle for each one of the up to 10 devices that can be paired.  Handles are maintained by BluetoothSettings FBlock.  0 is reserved as Null. Valid handles are 1..10 inclusive.
     *
     * @param u8DeviceHandle The value which will be set
     */
    inline void setU8DeviceHandle (uint8 u8DeviceHandle_);

    static const T_TelActiveCallinHandsetStreamItem &getDefaultInstance();

private:

    inline void set_has_e8HandsetState ();

    inline void clear_has_e8HandsetState ();

    inline void set_has_u8DeviceHandle ();

    inline void clear_has_u8DeviceHandle ();

    uint32 _has_bits_[ (2 + 31) / 32];

    T_e8_TelHandsetState _e8HandsetState;

    uint8 _u8DeviceHandle;

};

class T_TelCallStatusNoticeStreamItem {
public:

    /**
     * Default constructor
     */
    inline  T_TelCallStatusNoticeStreamItem ();

    /**
     * Copy constructor
     */
    inline  T_TelCallStatusNoticeStreamItem (const T_TelCallStatusNoticeStreamItem &rhs);

    /**
     * All fields constructor
     */
    inline  T_TelCallStatusNoticeStreamItem (uint16 u16CallInstance_, T_e8_TelCallStatus e8CallStatus_, bool bUsingVehicleAudio_, uint8 u8CallDurationHr_, uint8 u8CallDurationMin_, uint8 u8CallDurationSec_, uint8 u8DeviceHandle_);

    /**
     * Destructor
     */
    inline  ~T_TelCallStatusNoticeStreamItem();

    /**
     * Assignment operator
     */
    inline T_TelCallStatusNoticeStreamItem& operator = (const T_TelCallStatusNoticeStreamItem& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_TelCallStatusNoticeStreamItem& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_TelCallStatusNoticeStreamItem& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_TelCallStatusNoticeStreamItem& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_TelCallStatusNoticeStreamItem& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u16CallInstance"

    static const int kU16CallInstance = 0;

    /**
     * Clears the field "u16CallInstance".
     *
     * The field will be set to its default value. The hasU16CallInstance()
     * method will return false.
     */
    inline void clearU16CallInstance();

    /**
     * Checks whether the field "u16CallInstance" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16CallInstance()). Otherwise it will return false.
     */
    inline bool hasU16CallInstance () const;

    /**
     * Returns the value of the member "u16CallInstance".
     *
     * Instance of one call from multiple call possible.
     *
     * Call Instance FF means all call.  Like HangUp all calls.
     *
     * @return The value of the field "u16CallInstance"
     */
    inline uint16 getU16CallInstance () const;

    /**
     * Sets the value of the member "u16CallInstance".
     *
     * Instance of one call from multiple call possible.
     *
     * Call Instance FF means all call.  Like HangUp all calls.
     *
     * @param u16CallInstance The value which will be set
     */
    inline void setU16CallInstance (uint16 u16CallInstance_);

    // API of field "e8CallStatus"

    static const int kE8CallStatus = 1;

    /**
     * Clears the field "e8CallStatus".
     *
     * The field will be set to its default value. The hasE8CallStatus()
     * method will return false.
     */
    inline void clearE8CallStatus();

    /**
     * Checks whether the field "e8CallStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8CallStatus()). Otherwise it will return false.
     */
    inline bool hasE8CallStatus () const;

    /**
     * Returns the value of the member "e8CallStatus".
     *
     * Status of a call
     *
     * @return The value of the field "e8CallStatus"
     */
    inline T_e8_TelCallStatus getE8CallStatus () const;

    /**
     * Sets the value of the member "e8CallStatus".
     *
     * Status of a call
     *
     * @param e8CallStatus The value which will be set
     */
    inline void setE8CallStatus (T_e8_TelCallStatus e8CallStatus_);

    // API of field "bUsingVehicleAudio"

    static const int kBUsingVehicleAudio = 2;

    /**
     * Clears the field "bUsingVehicleAudio".
     *
     * The field will be set to its default value. The hasBUsingVehicleAudio()
     * method will return false.
     */
    inline void clearBUsingVehicleAudio();

    /**
     * Checks whether the field "bUsingVehicleAudio" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBUsingVehicleAudio()). Otherwise it will return false.
     */
    inline bool hasBUsingVehicleAudio () const;

    /**
     * Returns the value of the member "bUsingVehicleAudio".
     *
     * Is the call in handset or in vehicle
     *
     * @return The value of the field "bUsingVehicleAudio"
     */
    inline bool getBUsingVehicleAudio () const;

    /**
     * Sets the value of the member "bUsingVehicleAudio".
     *
     * Is the call in handset or in vehicle
     *
     * @param bUsingVehicleAudio The value which will be set
     */
    inline void setBUsingVehicleAudio (bool bUsingVehicleAudio_);

    // API of field "u8CallDurationHr"

    static const int kU8CallDurationHr = 3;

    /**
     * Clears the field "u8CallDurationHr".
     *
     * The field will be set to its default value. The hasU8CallDurationHr()
     * method will return false.
     */
    inline void clearU8CallDurationHr();

    /**
     * Checks whether the field "u8CallDurationHr" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8CallDurationHr()). Otherwise it will return false.
     */
    inline bool hasU8CallDurationHr () const;

    /**
     * Returns the value of the member "u8CallDurationHr".
     *
     * Hour Component of call duration,  call duration is from the call is RINGING or DIALING State till IDLE.
     *
     * @return The value of the field "u8CallDurationHr"
     */
    inline uint8 getU8CallDurationHr () const;

    /**
     * Sets the value of the member "u8CallDurationHr".
     *
     * Hour Component of call duration,  call duration is from the call is RINGING or DIALING State till IDLE.
     *
     * @param u8CallDurationHr The value which will be set
     */
    inline void setU8CallDurationHr (uint8 u8CallDurationHr_);

    // API of field "u8CallDurationMin"

    static const int kU8CallDurationMin = 4;

    /**
     * Clears the field "u8CallDurationMin".
     *
     * The field will be set to its default value. The hasU8CallDurationMin()
     * method will return false.
     */
    inline void clearU8CallDurationMin();

    /**
     * Checks whether the field "u8CallDurationMin" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8CallDurationMin()). Otherwise it will return false.
     */
    inline bool hasU8CallDurationMin () const;

    /**
     * Returns the value of the member "u8CallDurationMin".
     *
     * Minute Component of call duration,  call duration is from the call is RINGING or DIALING State till IDLE.
     *
     * @return The value of the field "u8CallDurationMin"
     */
    inline uint8 getU8CallDurationMin () const;

    /**
     * Sets the value of the member "u8CallDurationMin".
     *
     * Minute Component of call duration,  call duration is from the call is RINGING or DIALING State till IDLE.
     *
     * @param u8CallDurationMin The value which will be set
     */
    inline void setU8CallDurationMin (uint8 u8CallDurationMin_);

    // API of field "u8CallDurationSec"

    static const int kU8CallDurationSec = 5;

    /**
     * Clears the field "u8CallDurationSec".
     *
     * The field will be set to its default value. The hasU8CallDurationSec()
     * method will return false.
     */
    inline void clearU8CallDurationSec();

    /**
     * Checks whether the field "u8CallDurationSec" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8CallDurationSec()). Otherwise it will return false.
     */
    inline bool hasU8CallDurationSec () const;

    /**
     * Returns the value of the member "u8CallDurationSec".
     *
     * Seconds Component of call duration,  call duration is from the call is RINGING or DIALING State till IDLE.
     *
     * @return The value of the field "u8CallDurationSec"
     */
    inline uint8 getU8CallDurationSec () const;

    /**
     * Sets the value of the member "u8CallDurationSec".
     *
     * Seconds Component of call duration,  call duration is from the call is RINGING or DIALING State till IDLE.
     *
     * @param u8CallDurationSec The value which will be set
     */
    inline void setU8CallDurationSec (uint8 u8CallDurationSec_);

    // API of field "u8DeviceHandle"

    static const int kU8DeviceHandle = 6;

    /**
     * Clears the field "u8DeviceHandle".
     *
     * The field will be set to its default value. The hasU8DeviceHandle()
     * method will return false.
     */
    inline void clearU8DeviceHandle();

    /**
     * Checks whether the field "u8DeviceHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8DeviceHandle()). Otherwise it will return false.
     */
    inline bool hasU8DeviceHandle () const;

    /**
     * Returns the value of the member "u8DeviceHandle".
     *
     * Unique handle for each one of the up to 10 devices that can be paired.  Handles are maintained by BluetoothSettings FBlock.  0 is reserved as Null. Valid handles are 1..10 inclusive.
     *
     * @return The value of the field "u8DeviceHandle"
     */
    inline uint8 getU8DeviceHandle () const;

    /**
     * Sets the value of the member "u8DeviceHandle".
     *
     * Unique handle for each one of the up to 10 devices that can be paired.  Handles are maintained by BluetoothSettings FBlock.  0 is reserved as Null. Valid handles are 1..10 inclusive.
     *
     * @param u8DeviceHandle The value which will be set
     */
    inline void setU8DeviceHandle (uint8 u8DeviceHandle_);

    static const T_TelCallStatusNoticeStreamItem &getDefaultInstance();

private:

    inline void set_has_u16CallInstance ();

    inline void clear_has_u16CallInstance ();

    inline void set_has_e8CallStatus ();

    inline void clear_has_e8CallStatus ();

    inline void set_has_bUsingVehicleAudio ();

    inline void clear_has_bUsingVehicleAudio ();

    inline void set_has_u8CallDurationHr ();

    inline void clear_has_u8CallDurationHr ();

    inline void set_has_u8CallDurationMin ();

    inline void clear_has_u8CallDurationMin ();

    inline void set_has_u8CallDurationSec ();

    inline void clear_has_u8CallDurationSec ();

    inline void set_has_u8DeviceHandle ();

    inline void clear_has_u8DeviceHandle ();

    uint32 _has_bits_[ (7 + 31) / 32];

    uint16 _u16CallInstance;

    T_e8_TelCallStatus _e8CallStatus;

    bool _bUsingVehicleAudio;

    uint8 _u8CallDurationHr;

    uint8 _u8CallDurationMin;

    uint8 _u8CallDurationSec;

    uint8 _u8DeviceHandle;

};

class T_TelHFEnhancedCallControlStreamItem {
public:

    /**
     * Default constructor
     */
    inline  T_TelHFEnhancedCallControlStreamItem ();

    /**
     * Copy constructor
     */
    inline  T_TelHFEnhancedCallControlStreamItem (const T_TelHFEnhancedCallControlStreamItem &rhs);

    /**
     * All fields constructor
     */
    inline  T_TelHFEnhancedCallControlStreamItem (uint8 u8DeviceHandle_, bool bEndTargetCall_, bool bSplitMergedCalls_);

    /**
     * Destructor
     */
    inline  ~T_TelHFEnhancedCallControlStreamItem();

    /**
     * Assignment operator
     */
    inline T_TelHFEnhancedCallControlStreamItem& operator = (const T_TelHFEnhancedCallControlStreamItem& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_TelHFEnhancedCallControlStreamItem& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_TelHFEnhancedCallControlStreamItem& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_TelHFEnhancedCallControlStreamItem& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_TelHFEnhancedCallControlStreamItem& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8DeviceHandle"

    static const int kU8DeviceHandle = 0;

    /**
     * Clears the field "u8DeviceHandle".
     *
     * The field will be set to its default value. The hasU8DeviceHandle()
     * method will return false.
     */
    inline void clearU8DeviceHandle();

    /**
     * Checks whether the field "u8DeviceHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8DeviceHandle()). Otherwise it will return false.
     */
    inline bool hasU8DeviceHandle () const;

    /**
     * Returns the value of the member "u8DeviceHandle".
     *
     * Unique handle for each one of the up to 10 devices that can be paired.  Handles are maintained by BluetoothSettings FBlock.  0 is reserved as Null. Valid handles are 1..10 inclusive.
     *
     * @return The value of the field "u8DeviceHandle"
     */
    inline uint8 getU8DeviceHandle () const;

    /**
     * Sets the value of the member "u8DeviceHandle".
     *
     * Unique handle for each one of the up to 10 devices that can be paired.  Handles are maintained by BluetoothSettings FBlock.  0 is reserved as Null. Valid handles are 1..10 inclusive.
     *
     * @param u8DeviceHandle The value which will be set
     */
    inline void setU8DeviceHandle (uint8 u8DeviceHandle_);

    // API of field "bEndTargetCall"

    static const int kBEndTargetCall = 1;

    /**
     * Clears the field "bEndTargetCall".
     *
     * The field will be set to its default value. The hasBEndTargetCall()
     * method will return false.
     */
    inline void clearBEndTargetCall();

    /**
     * Checks whether the field "bEndTargetCall" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBEndTargetCall()). Otherwise it will return false.
     */
    inline bool hasBEndTargetCall () const;

    /**
     * Returns the value of the member "bEndTargetCall".
     *
     *
     *
     * @return The value of the field "bEndTargetCall"
     */
    inline bool getBEndTargetCall () const;

    /**
     * Sets the value of the member "bEndTargetCall".
     *
     *
     *
     * @param bEndTargetCall The value which will be set
     */
    inline void setBEndTargetCall (bool bEndTargetCall_);

    // API of field "bSplitMergedCalls"

    static const int kBSplitMergedCalls = 2;

    /**
     * Clears the field "bSplitMergedCalls".
     *
     * The field will be set to its default value. The hasBSplitMergedCalls()
     * method will return false.
     */
    inline void clearBSplitMergedCalls();

    /**
     * Checks whether the field "bSplitMergedCalls" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBSplitMergedCalls()). Otherwise it will return false.
     */
    inline bool hasBSplitMergedCalls () const;

    /**
     * Returns the value of the member "bSplitMergedCalls".
     *
     *
     *
     * @return The value of the field "bSplitMergedCalls"
     */
    inline bool getBSplitMergedCalls () const;

    /**
     * Sets the value of the member "bSplitMergedCalls".
     *
     *
     *
     * @param bSplitMergedCalls The value which will be set
     */
    inline void setBSplitMergedCalls (bool bSplitMergedCalls_);

    static const T_TelHFEnhancedCallControlStreamItem &getDefaultInstance();

private:

    inline void set_has_u8DeviceHandle ();

    inline void clear_has_u8DeviceHandle ();

    inline void set_has_bEndTargetCall ();

    inline void clear_has_bEndTargetCall ();

    inline void set_has_bSplitMergedCalls ();

    inline void clear_has_bSplitMergedCalls ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint8 _u8DeviceHandle;

    bool _bEndTargetCall;

    bool _bSplitMergedCalls;

};

class T_TelDeviceRingtoneListResultItem {
public:

    /**
     * Default constructor
     */
    inline  T_TelDeviceRingtoneListResultItem ();

    /**
     * Copy constructor
     */
    inline  T_TelDeviceRingtoneListResultItem (const T_TelDeviceRingtoneListResultItem &rhs);

    /**
     * All fields constructor
     */
    inline  T_TelDeviceRingtoneListResultItem (const ::fi_basetypes_most::T_String& sBdAddress_, uint8 u8RingtoneID_, const ::fi_basetypes_most::T_String& sRingtoneName_, T_e8_TelInbandRingingSupport e8InbandRingingSupport_);

    /**
     * Destructor
     */
    inline  ~T_TelDeviceRingtoneListResultItem();

    /**
     * Assignment operator
     */
    inline T_TelDeviceRingtoneListResultItem& operator = (const T_TelDeviceRingtoneListResultItem& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_TelDeviceRingtoneListResultItem& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_TelDeviceRingtoneListResultItem& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_TelDeviceRingtoneListResultItem& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_TelDeviceRingtoneListResultItem& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "sBdAddress"

    static const int kSBdAddress = 0;

    /**
     * Clears the field "sBdAddress".
     *
     * The field will be set to its default value. The hasSBdAddress()
     * method will return false.
     */
    inline void clearSBdAddress();

    /**
     * Checks whether the field "sBdAddress" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSBdAddress()). Otherwise it will return false.
     */
    inline bool hasSBdAddress () const;

    /**
     * Returns the value of the member "sBdAddress".
     *
     * Bluetooth device address.
     *
     * @return The value of the field "sBdAddress"
     */
    inline const ::fi_basetypes_most::T_String& getSBdAddress () const;

    /**
     * Retrieves the value of the field "sBdAddress" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sBdAddress".
     */
    inline ::fi_basetypes_most::T_String& getSBdAddressMutable ();

    /**
     * Sets the value of the member "sBdAddress".
     *
     * Bluetooth device address.
     *
     * @param sBdAddress The value which will be set
     */
    inline void setSBdAddress (const ::fi_basetypes_most::T_String& sBdAddress_);

    // API of field "u8RingtoneID"

    static const int kU8RingtoneID = 1;

    /**
     * Clears the field "u8RingtoneID".
     *
     * The field will be set to its default value. The hasU8RingtoneID()
     * method will return false.
     */
    inline void clearU8RingtoneID();

    /**
     * Checks whether the field "u8RingtoneID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8RingtoneID()). Otherwise it will return false.
     */
    inline bool hasU8RingtoneID () const;

    /**
     * Returns the value of the member "u8RingtoneID".
     *
     * The unique ID for each ringtone available. RingtoneID Range - 0x01 - 0xFF.
     * 0x00 - Reserved
     * 0x01 - InbandRingtone
     * 0x02 - 0xFF - SystemRingtones
     *
     * @return The value of the field "u8RingtoneID"
     */
    inline uint8 getU8RingtoneID () const;

    /**
     * Sets the value of the member "u8RingtoneID".
     *
     * The unique ID for each ringtone available. RingtoneID Range - 0x01 - 0xFF.
     * 0x00 - Reserved
     * 0x01 - InbandRingtone
     * 0x02 - 0xFF - SystemRingtones
     *
     * @param u8RingtoneID The value which will be set
     */
    inline void setU8RingtoneID (uint8 u8RingtoneID_);

    // API of field "sRingtoneName"

    static const int kSRingtoneName = 2;

    /**
     * Clears the field "sRingtoneName".
     *
     * The field will be set to its default value. The hasSRingtoneName()
     * method will return false.
     */
    inline void clearSRingtoneName();

    /**
     * Checks whether the field "sRingtoneName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSRingtoneName()). Otherwise it will return false.
     */
    inline bool hasSRingtoneName () const;

    /**
     * Returns the value of the member "sRingtoneName".
     *
     * The text of the name associated with each ringtone available.
     *
     * @return The value of the field "sRingtoneName"
     */
    inline const ::fi_basetypes_most::T_String& getSRingtoneName () const;

    /**
     * Retrieves the value of the field "sRingtoneName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sRingtoneName".
     */
    inline ::fi_basetypes_most::T_String& getSRingtoneNameMutable ();

    /**
     * Sets the value of the member "sRingtoneName".
     *
     * The text of the name associated with each ringtone available.
     *
     * @param sRingtoneName The value which will be set
     */
    inline void setSRingtoneName (const ::fi_basetypes_most::T_String& sRingtoneName_);

    // API of field "e8InbandRingingSupport"

    static const int kE8InbandRingingSupport = 3;

    /**
     * Clears the field "e8InbandRingingSupport".
     *
     * The field will be set to its default value. The hasE8InbandRingingSupport()
     * method will return false.
     */
    inline void clearE8InbandRingingSupport();

    /**
     * Checks whether the field "e8InbandRingingSupport" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8InbandRingingSupport()). Otherwise it will return false.
     */
    inline bool hasE8InbandRingingSupport () const;

    /**
     * Returns the value of the member "e8InbandRingingSupport".
     *
     * Provides the Inband Ringing support in Audio Gateway.
     *
     * @return The value of the field "e8InbandRingingSupport"
     */
    inline T_e8_TelInbandRingingSupport getE8InbandRingingSupport () const;

    /**
     * Sets the value of the member "e8InbandRingingSupport".
     *
     * Provides the Inband Ringing support in Audio Gateway.
     *
     * @param e8InbandRingingSupport The value which will be set
     */
    inline void setE8InbandRingingSupport (T_e8_TelInbandRingingSupport e8InbandRingingSupport_);

    static const T_TelDeviceRingtoneListResultItem &getDefaultInstance();

private:

    inline void set_has_sBdAddress ();

    inline void clear_has_sBdAddress ();

    inline void set_has_u8RingtoneID ();

    inline void clear_has_u8RingtoneID ();

    inline void set_has_sRingtoneName ();

    inline void clear_has_sRingtoneName ();

    inline void set_has_e8InbandRingingSupport ();

    inline void clear_has_e8InbandRingingSupport ();

    uint32 _has_bits_[ (4 + 31) / 32];

    ::fi_basetypes_most::T_String _sBdAddress;

    uint8 _u8RingtoneID;

    ::fi_basetypes_most::T_String _sRingtoneName;

    T_e8_TelInbandRingingSupport _e8InbandRingingSupport;

};

class T_TelSystemWideRingtonesListResultItem {
public:

    /**
     * Default constructor
     */
    inline  T_TelSystemWideRingtonesListResultItem ();

    /**
     * Copy constructor
     */
    inline  T_TelSystemWideRingtonesListResultItem (const T_TelSystemWideRingtonesListResultItem &rhs);

    /**
     * All fields constructor
     */
    inline  T_TelSystemWideRingtonesListResultItem (uint8 u8RingtoneID_, const ::fi_basetypes_most::T_String& sRingtoneName_);

    /**
     * Destructor
     */
    inline  ~T_TelSystemWideRingtonesListResultItem();

    /**
     * Assignment operator
     */
    inline T_TelSystemWideRingtonesListResultItem& operator = (const T_TelSystemWideRingtonesListResultItem& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_TelSystemWideRingtonesListResultItem& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_TelSystemWideRingtonesListResultItem& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_TelSystemWideRingtonesListResultItem& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_TelSystemWideRingtonesListResultItem& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8RingtoneID"

    static const int kU8RingtoneID = 0;

    /**
     * Clears the field "u8RingtoneID".
     *
     * The field will be set to its default value. The hasU8RingtoneID()
     * method will return false.
     */
    inline void clearU8RingtoneID();

    /**
     * Checks whether the field "u8RingtoneID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8RingtoneID()). Otherwise it will return false.
     */
    inline bool hasU8RingtoneID () const;

    /**
     * Returns the value of the member "u8RingtoneID".
     *
     * The unique ID for each ringtone available. RingtoneID Range - 0x01 - 0xFF.
     * 0x00 - Reserved
     * 0x01 - InbandRingtone
     * 0x02 - 0xFF - SystemRingtones
     *
     * @return The value of the field "u8RingtoneID"
     */
    inline uint8 getU8RingtoneID () const;

    /**
     * Sets the value of the member "u8RingtoneID".
     *
     * The unique ID for each ringtone available. RingtoneID Range - 0x01 - 0xFF.
     * 0x00 - Reserved
     * 0x01 - InbandRingtone
     * 0x02 - 0xFF - SystemRingtones
     *
     * @param u8RingtoneID The value which will be set
     */
    inline void setU8RingtoneID (uint8 u8RingtoneID_);

    // API of field "sRingtoneName"

    static const int kSRingtoneName = 1;

    /**
     * Clears the field "sRingtoneName".
     *
     * The field will be set to its default value. The hasSRingtoneName()
     * method will return false.
     */
    inline void clearSRingtoneName();

    /**
     * Checks whether the field "sRingtoneName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSRingtoneName()). Otherwise it will return false.
     */
    inline bool hasSRingtoneName () const;

    /**
     * Returns the value of the member "sRingtoneName".
     *
     * The text of the name associated with each ringtone available.
     *
     * @return The value of the field "sRingtoneName"
     */
    inline const ::fi_basetypes_most::T_String& getSRingtoneName () const;

    /**
     * Retrieves the value of the field "sRingtoneName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sRingtoneName".
     */
    inline ::fi_basetypes_most::T_String& getSRingtoneNameMutable ();

    /**
     * Sets the value of the member "sRingtoneName".
     *
     * The text of the name associated with each ringtone available.
     *
     * @param sRingtoneName The value which will be set
     */
    inline void setSRingtoneName (const ::fi_basetypes_most::T_String& sRingtoneName_);

    static const T_TelSystemWideRingtonesListResultItem &getDefaultInstance();

private:

    inline void set_has_u8RingtoneID ();

    inline void clear_has_u8RingtoneID ();

    inline void set_has_sRingtoneName ();

    inline void clear_has_sRingtoneName ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint8 _u8RingtoneID;

    ::fi_basetypes_most::T_String _sRingtoneName;

};

class T_TelSuppressRingtoneOnOffListResultItem {
public:

    /**
     * Default constructor
     */
    inline  T_TelSuppressRingtoneOnOffListResultItem ();

    /**
     * Copy constructor
     */
    inline  T_TelSuppressRingtoneOnOffListResultItem (const T_TelSuppressRingtoneOnOffListResultItem &rhs);

    /**
     * All fields constructor
     */
    inline  T_TelSuppressRingtoneOnOffListResultItem (const ::fi_basetypes_most::T_String& sBdAddress_, bool bSuppressRingtoneState_);

    /**
     * Destructor
     */
    inline  ~T_TelSuppressRingtoneOnOffListResultItem();

    /**
     * Assignment operator
     */
    inline T_TelSuppressRingtoneOnOffListResultItem& operator = (const T_TelSuppressRingtoneOnOffListResultItem& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_TelSuppressRingtoneOnOffListResultItem& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_TelSuppressRingtoneOnOffListResultItem& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_TelSuppressRingtoneOnOffListResultItem& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_TelSuppressRingtoneOnOffListResultItem& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "sBdAddress"

    static const int kSBdAddress = 0;

    /**
     * Clears the field "sBdAddress".
     *
     * The field will be set to its default value. The hasSBdAddress()
     * method will return false.
     */
    inline void clearSBdAddress();

    /**
     * Checks whether the field "sBdAddress" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSBdAddress()). Otherwise it will return false.
     */
    inline bool hasSBdAddress () const;

    /**
     * Returns the value of the member "sBdAddress".
     *
     * Bluetooth device address.
     *
     * @return The value of the field "sBdAddress"
     */
    inline const ::fi_basetypes_most::T_String& getSBdAddress () const;

    /**
     * Retrieves the value of the field "sBdAddress" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sBdAddress".
     */
    inline ::fi_basetypes_most::T_String& getSBdAddressMutable ();

    /**
     * Sets the value of the member "sBdAddress".
     *
     * Bluetooth device address.
     *
     * @param sBdAddress The value which will be set
     */
    inline void setSBdAddress (const ::fi_basetypes_most::T_String& sBdAddress_);

    // API of field "bSuppressRingtoneState"

    static const int kBSuppressRingtoneState = 1;

    /**
     * Clears the field "bSuppressRingtoneState".
     *
     * The field will be set to its default value. The hasBSuppressRingtoneState()
     * method will return false.
     */
    inline void clearBSuppressRingtoneState();

    /**
     * Checks whether the field "bSuppressRingtoneState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBSuppressRingtoneState()). Otherwise it will return false.
     */
    inline bool hasBSuppressRingtoneState () const;

    /**
     * Returns the value of the member "bSuppressRingtoneState".
     *
     * TRUE - suppress ringtone enabled, FALSE - suppress ringtone disabled.
     *
     * @return The value of the field "bSuppressRingtoneState"
     */
    inline bool getBSuppressRingtoneState () const;

    /**
     * Sets the value of the member "bSuppressRingtoneState".
     *
     * TRUE - suppress ringtone enabled, FALSE - suppress ringtone disabled.
     *
     * @param bSuppressRingtoneState The value which will be set
     */
    inline void setBSuppressRingtoneState (bool bSuppressRingtoneState_);

    static const T_TelSuppressRingtoneOnOffListResultItem &getDefaultInstance();

private:

    inline void set_has_sBdAddress ();

    inline void clear_has_sBdAddress ();

    inline void set_has_bSuppressRingtoneState ();

    inline void clear_has_bSuppressRingtoneState ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_String _sBdAddress;

    bool _bSuppressRingtoneState;

};

class T_TelAutoWaitingModeOnOffListResultItem {
public:

    /**
     * Default constructor
     */
    inline  T_TelAutoWaitingModeOnOffListResultItem ();

    /**
     * Copy constructor
     */
    inline  T_TelAutoWaitingModeOnOffListResultItem (const T_TelAutoWaitingModeOnOffListResultItem &rhs);

    /**
     * All fields constructor
     */
    inline  T_TelAutoWaitingModeOnOffListResultItem (const ::fi_basetypes_most::T_String& sBdAddress_, bool bAutoWaitingModeState_);

    /**
     * Destructor
     */
    inline  ~T_TelAutoWaitingModeOnOffListResultItem();

    /**
     * Assignment operator
     */
    inline T_TelAutoWaitingModeOnOffListResultItem& operator = (const T_TelAutoWaitingModeOnOffListResultItem& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_TelAutoWaitingModeOnOffListResultItem& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_TelAutoWaitingModeOnOffListResultItem& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_TelAutoWaitingModeOnOffListResultItem& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_TelAutoWaitingModeOnOffListResultItem& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "sBdAddress"

    static const int kSBdAddress = 0;

    /**
     * Clears the field "sBdAddress".
     *
     * The field will be set to its default value. The hasSBdAddress()
     * method will return false.
     */
    inline void clearSBdAddress();

    /**
     * Checks whether the field "sBdAddress" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSBdAddress()). Otherwise it will return false.
     */
    inline bool hasSBdAddress () const;

    /**
     * Returns the value of the member "sBdAddress".
     *
     * Bluetooth device address.
     *
     * @return The value of the field "sBdAddress"
     */
    inline const ::fi_basetypes_most::T_String& getSBdAddress () const;

    /**
     * Retrieves the value of the field "sBdAddress" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sBdAddress".
     */
    inline ::fi_basetypes_most::T_String& getSBdAddressMutable ();

    /**
     * Sets the value of the member "sBdAddress".
     *
     * Bluetooth device address.
     *
     * @param sBdAddress The value which will be set
     */
    inline void setSBdAddress (const ::fi_basetypes_most::T_String& sBdAddress_);

    // API of field "bAutoWaitingModeState"

    static const int kBAutoWaitingModeState = 1;

    /**
     * Clears the field "bAutoWaitingModeState".
     *
     * The field will be set to its default value. The hasBAutoWaitingModeState()
     * method will return false.
     */
    inline void clearBAutoWaitingModeState();

    /**
     * Checks whether the field "bAutoWaitingModeState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBAutoWaitingModeState()). Otherwise it will return false.
     */
    inline bool hasBAutoWaitingModeState () const;

    /**
     * Returns the value of the member "bAutoWaitingModeState".
     *
     * TRUE - auto waiting mode enabled, FALSE - auto waiting mode disabled.
     *
     * @return The value of the field "bAutoWaitingModeState"
     */
    inline bool getBAutoWaitingModeState () const;

    /**
     * Sets the value of the member "bAutoWaitingModeState".
     *
     * TRUE - auto waiting mode enabled, FALSE - auto waiting mode disabled.
     *
     * @param bAutoWaitingModeState The value which will be set
     */
    inline void setBAutoWaitingModeState (bool bAutoWaitingModeState_);

    static const T_TelAutoWaitingModeOnOffListResultItem &getDefaultInstance();

private:

    inline void set_has_sBdAddress ();

    inline void clear_has_sBdAddress ();

    inline void set_has_bAutoWaitingModeState ();

    inline void clear_has_bAutoWaitingModeState ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_String _sBdAddress;

    bool _bAutoWaitingModeState;

};

inline  T_TelActiveCallinHandsetStreamItem::T_TelActiveCallinHandsetStreamItem ()  :
    _e8HandsetState (::most_Tel_fi_types::T_e8_TelHandsetState__e8NO_CALL),
    _u8DeviceHandle (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_TelActiveCallinHandsetStreamItem::T_TelActiveCallinHandsetStreamItem (const T_TelActiveCallinHandsetStreamItem &rhs)  :
    _e8HandsetState (::most_Tel_fi_types::T_e8_TelHandsetState__e8NO_CALL),
    _u8DeviceHandle (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_TelActiveCallinHandsetStreamItem::T_TelActiveCallinHandsetStreamItem (T_e8_TelHandsetState e8HandsetState_, uint8 u8DeviceHandle_)  :
    _e8HandsetState (e8HandsetState_),
    _u8DeviceHandle (u8DeviceHandle_)
{
    #ifndef NDEBUG
    if (!(T_e8_TelHandsetState_IsValid(e8HandsetState_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8HandsetState_, "T_e8_TelHandsetState", "e8HandsetState", "T_TelActiveCallinHandsetStreamItem");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_TelActiveCallinHandsetStreamItem::~T_TelActiveCallinHandsetStreamItem() {
}

inline T_TelActiveCallinHandsetStreamItem& T_TelActiveCallinHandsetStreamItem::operator = (const T_TelActiveCallinHandsetStreamItem& rhs) {
    if( this != &rhs ) {
        if (rhs.hasE8HandsetState()) {
            setE8HandsetState(rhs.getE8HandsetState());
        } else {
            clearE8HandsetState();
        }
        if (rhs.hasU8DeviceHandle()) {
            setU8DeviceHandle(rhs.getU8DeviceHandle());
        } else {
            clearU8DeviceHandle();
        }
    }
    return *this;
}

inline bool T_TelActiveCallinHandsetStreamItem::operator == (const T_TelActiveCallinHandsetStreamItem& rhs) const {
    return (((!hasE8HandsetState() && !rhs.hasE8HandsetState()) || getE8HandsetState() == rhs.getE8HandsetState()) &&
        ((!hasU8DeviceHandle() && !rhs.hasU8DeviceHandle()) || getU8DeviceHandle() == rhs.getU8DeviceHandle()));
}

inline bool T_TelActiveCallinHandsetStreamItem::operator != (const T_TelActiveCallinHandsetStreamItem& rhs) const {
    return ! (*this == rhs);
}

inline bool T_TelActiveCallinHandsetStreamItem::operator < (const T_TelActiveCallinHandsetStreamItem& rhs) const {
    if (hasE8HandsetState() || rhs.hasE8HandsetState()) {
        if ((uint32)getE8HandsetState() < (uint32)rhs.getE8HandsetState()) return true;
        if ((uint32)getE8HandsetState() > (uint32)rhs.getE8HandsetState()) return false;
    }
    if (hasU8DeviceHandle() || rhs.hasU8DeviceHandle()) {
        if (getU8DeviceHandle() < rhs.getU8DeviceHandle()) return true;
        if (getU8DeviceHandle() > rhs.getU8DeviceHandle()) return false;
    }
    return false;
}

inline bool T_TelActiveCallinHandsetStreamItem::operator > (const T_TelActiveCallinHandsetStreamItem& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_TelActiveCallinHandsetStreamItem::clear() {
    clearE8HandsetState();
    clearU8DeviceHandle();
}

inline void T_TelActiveCallinHandsetStreamItem::clearE8HandsetState() {
    if (hasE8HandsetState()) {
         clear_has_e8HandsetState();
        _e8HandsetState = ::most_Tel_fi_types::T_e8_TelHandsetState__e8NO_CALL;
     }
}

inline bool T_TelActiveCallinHandsetStreamItem::hasE8HandsetState () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline T_e8_TelHandsetState T_TelActiveCallinHandsetStreamItem::getE8HandsetState () const {
    return _e8HandsetState;
}

inline void T_TelActiveCallinHandsetStreamItem::setE8HandsetState (T_e8_TelHandsetState e8HandsetState_) {
    #ifndef NDEBUG
    if (!(T_e8_TelHandsetState_IsValid(e8HandsetState_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8HandsetState_, "T_e8_TelHandsetState", "e8HandsetState", "T_TelActiveCallinHandsetStreamItem");
    }
    #endif
    set_has_e8HandsetState();
    this->_e8HandsetState = e8HandsetState_;
}

inline void T_TelActiveCallinHandsetStreamItem::clearU8DeviceHandle() {
    if (hasU8DeviceHandle()) {
         clear_has_u8DeviceHandle();
        _u8DeviceHandle = 0u;
     }
}

inline bool T_TelActiveCallinHandsetStreamItem::hasU8DeviceHandle () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 T_TelActiveCallinHandsetStreamItem::getU8DeviceHandle () const {
    return _u8DeviceHandle;
}

inline void T_TelActiveCallinHandsetStreamItem::setU8DeviceHandle (uint8 u8DeviceHandle_) {
    set_has_u8DeviceHandle();
    this->_u8DeviceHandle = u8DeviceHandle_;
}

inline void T_TelActiveCallinHandsetStreamItem::set_has_e8HandsetState () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_TelActiveCallinHandsetStreamItem::clear_has_e8HandsetState () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_TelActiveCallinHandsetStreamItem::set_has_u8DeviceHandle () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_TelActiveCallinHandsetStreamItem::clear_has_u8DeviceHandle () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  T_TelCallStatusNoticeStreamItem::T_TelCallStatusNoticeStreamItem ()  :
    _u16CallInstance (0u),
    _e8CallStatus (::most_Tel_fi_types::T_e8_TelCallStatus__e8IDLE),
    _bUsingVehicleAudio (false),
    _u8CallDurationHr (0u),
    _u8CallDurationMin (0u),
    _u8CallDurationSec (0u),
    _u8DeviceHandle (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_TelCallStatusNoticeStreamItem::T_TelCallStatusNoticeStreamItem (const T_TelCallStatusNoticeStreamItem &rhs)  :
    _u16CallInstance (0u),
    _e8CallStatus (::most_Tel_fi_types::T_e8_TelCallStatus__e8IDLE),
    _bUsingVehicleAudio (false),
    _u8CallDurationHr (0u),
    _u8CallDurationMin (0u),
    _u8CallDurationSec (0u),
    _u8DeviceHandle (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_TelCallStatusNoticeStreamItem::T_TelCallStatusNoticeStreamItem (uint16 u16CallInstance_, T_e8_TelCallStatus e8CallStatus_, bool bUsingVehicleAudio_, uint8 u8CallDurationHr_, uint8 u8CallDurationMin_, uint8 u8CallDurationSec_, uint8 u8DeviceHandle_)  :
    _u16CallInstance (u16CallInstance_),
    _e8CallStatus (e8CallStatus_),
    _bUsingVehicleAudio (bUsingVehicleAudio_),
    _u8CallDurationHr (u8CallDurationHr_),
    _u8CallDurationMin (u8CallDurationMin_),
    _u8CallDurationSec (u8CallDurationSec_),
    _u8DeviceHandle (u8DeviceHandle_)
{
    #ifndef NDEBUG
    if (!(T_e8_TelCallStatus_IsValid(e8CallStatus_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8CallStatus_, "T_e8_TelCallStatus", "e8CallStatus", "T_TelCallStatusNoticeStreamItem");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_TelCallStatusNoticeStreamItem::~T_TelCallStatusNoticeStreamItem() {
}

inline T_TelCallStatusNoticeStreamItem& T_TelCallStatusNoticeStreamItem::operator = (const T_TelCallStatusNoticeStreamItem& rhs) {
    if( this != &rhs ) {
        if (rhs.hasU16CallInstance()) {
            setU16CallInstance(rhs.getU16CallInstance());
        } else {
            clearU16CallInstance();
        }
        if (rhs.hasE8CallStatus()) {
            setE8CallStatus(rhs.getE8CallStatus());
        } else {
            clearE8CallStatus();
        }
        if (rhs.hasBUsingVehicleAudio()) {
            setBUsingVehicleAudio(rhs.getBUsingVehicleAudio());
        } else {
            clearBUsingVehicleAudio();
        }
        if (rhs.hasU8CallDurationHr()) {
            setU8CallDurationHr(rhs.getU8CallDurationHr());
        } else {
            clearU8CallDurationHr();
        }
        if (rhs.hasU8CallDurationMin()) {
            setU8CallDurationMin(rhs.getU8CallDurationMin());
        } else {
            clearU8CallDurationMin();
        }
        if (rhs.hasU8CallDurationSec()) {
            setU8CallDurationSec(rhs.getU8CallDurationSec());
        } else {
            clearU8CallDurationSec();
        }
        if (rhs.hasU8DeviceHandle()) {
            setU8DeviceHandle(rhs.getU8DeviceHandle());
        } else {
            clearU8DeviceHandle();
        }
    }
    return *this;
}

inline bool T_TelCallStatusNoticeStreamItem::operator == (const T_TelCallStatusNoticeStreamItem& rhs) const {
    return (((!hasU16CallInstance() && !rhs.hasU16CallInstance()) || getU16CallInstance() == rhs.getU16CallInstance()) &&
        ((!hasE8CallStatus() && !rhs.hasE8CallStatus()) || getE8CallStatus() == rhs.getE8CallStatus()) &&
        ((!hasBUsingVehicleAudio() && !rhs.hasBUsingVehicleAudio()) || getBUsingVehicleAudio() == rhs.getBUsingVehicleAudio()) &&
        ((!hasU8CallDurationHr() && !rhs.hasU8CallDurationHr()) || getU8CallDurationHr() == rhs.getU8CallDurationHr()) &&
        ((!hasU8CallDurationMin() && !rhs.hasU8CallDurationMin()) || getU8CallDurationMin() == rhs.getU8CallDurationMin()) &&
        ((!hasU8CallDurationSec() && !rhs.hasU8CallDurationSec()) || getU8CallDurationSec() == rhs.getU8CallDurationSec()) &&
        ((!hasU8DeviceHandle() && !rhs.hasU8DeviceHandle()) || getU8DeviceHandle() == rhs.getU8DeviceHandle()));
}

inline bool T_TelCallStatusNoticeStreamItem::operator != (const T_TelCallStatusNoticeStreamItem& rhs) const {
    return ! (*this == rhs);
}

inline bool T_TelCallStatusNoticeStreamItem::operator < (const T_TelCallStatusNoticeStreamItem& rhs) const {
    if (hasU16CallInstance() || rhs.hasU16CallInstance()) {
        if (getU16CallInstance() < rhs.getU16CallInstance()) return true;
        if (getU16CallInstance() > rhs.getU16CallInstance()) return false;
    }
    if (hasE8CallStatus() || rhs.hasE8CallStatus()) {
        if ((uint32)getE8CallStatus() < (uint32)rhs.getE8CallStatus()) return true;
        if ((uint32)getE8CallStatus() > (uint32)rhs.getE8CallStatus()) return false;
    }
    if (hasBUsingVehicleAudio() || rhs.hasBUsingVehicleAudio()) {
        if (getBUsingVehicleAudio() < rhs.getBUsingVehicleAudio()) return true;
        if (getBUsingVehicleAudio() > rhs.getBUsingVehicleAudio()) return false;
    }
    if (hasU8CallDurationHr() || rhs.hasU8CallDurationHr()) {
        if (getU8CallDurationHr() < rhs.getU8CallDurationHr()) return true;
        if (getU8CallDurationHr() > rhs.getU8CallDurationHr()) return false;
    }
    if (hasU8CallDurationMin() || rhs.hasU8CallDurationMin()) {
        if (getU8CallDurationMin() < rhs.getU8CallDurationMin()) return true;
        if (getU8CallDurationMin() > rhs.getU8CallDurationMin()) return false;
    }
    if (hasU8CallDurationSec() || rhs.hasU8CallDurationSec()) {
        if (getU8CallDurationSec() < rhs.getU8CallDurationSec()) return true;
        if (getU8CallDurationSec() > rhs.getU8CallDurationSec()) return false;
    }
    if (hasU8DeviceHandle() || rhs.hasU8DeviceHandle()) {
        if (getU8DeviceHandle() < rhs.getU8DeviceHandle()) return true;
        if (getU8DeviceHandle() > rhs.getU8DeviceHandle()) return false;
    }
    return false;
}

inline bool T_TelCallStatusNoticeStreamItem::operator > (const T_TelCallStatusNoticeStreamItem& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_TelCallStatusNoticeStreamItem::clear() {
    clearU16CallInstance();
    clearE8CallStatus();
    clearBUsingVehicleAudio();
    clearU8CallDurationHr();
    clearU8CallDurationMin();
    clearU8CallDurationSec();
    clearU8DeviceHandle();
}

inline void T_TelCallStatusNoticeStreamItem::clearU16CallInstance() {
    if (hasU16CallInstance()) {
         clear_has_u16CallInstance();
        _u16CallInstance = 0u;
     }
}

inline bool T_TelCallStatusNoticeStreamItem::hasU16CallInstance () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint16 T_TelCallStatusNoticeStreamItem::getU16CallInstance () const {
    return _u16CallInstance;
}

inline void T_TelCallStatusNoticeStreamItem::setU16CallInstance (uint16 u16CallInstance_) {
    set_has_u16CallInstance();
    this->_u16CallInstance = u16CallInstance_;
}

inline void T_TelCallStatusNoticeStreamItem::clearE8CallStatus() {
    if (hasE8CallStatus()) {
         clear_has_e8CallStatus();
        _e8CallStatus = ::most_Tel_fi_types::T_e8_TelCallStatus__e8IDLE;
     }
}

inline bool T_TelCallStatusNoticeStreamItem::hasE8CallStatus () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline T_e8_TelCallStatus T_TelCallStatusNoticeStreamItem::getE8CallStatus () const {
    return _e8CallStatus;
}

inline void T_TelCallStatusNoticeStreamItem::setE8CallStatus (T_e8_TelCallStatus e8CallStatus_) {
    #ifndef NDEBUG
    if (!(T_e8_TelCallStatus_IsValid(e8CallStatus_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8CallStatus_, "T_e8_TelCallStatus", "e8CallStatus", "T_TelCallStatusNoticeStreamItem");
    }
    #endif
    set_has_e8CallStatus();
    this->_e8CallStatus = e8CallStatus_;
}

inline void T_TelCallStatusNoticeStreamItem::clearBUsingVehicleAudio() {
    if (hasBUsingVehicleAudio()) {
         clear_has_bUsingVehicleAudio();
        _bUsingVehicleAudio = false;
     }
}

inline bool T_TelCallStatusNoticeStreamItem::hasBUsingVehicleAudio () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline bool T_TelCallStatusNoticeStreamItem::getBUsingVehicleAudio () const {
    return _bUsingVehicleAudio;
}

inline void T_TelCallStatusNoticeStreamItem::setBUsingVehicleAudio (bool bUsingVehicleAudio_) {
    set_has_bUsingVehicleAudio();
    this->_bUsingVehicleAudio = bUsingVehicleAudio_;
}

inline void T_TelCallStatusNoticeStreamItem::clearU8CallDurationHr() {
    if (hasU8CallDurationHr()) {
         clear_has_u8CallDurationHr();
        _u8CallDurationHr = 0u;
     }
}

inline bool T_TelCallStatusNoticeStreamItem::hasU8CallDurationHr () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint8 T_TelCallStatusNoticeStreamItem::getU8CallDurationHr () const {
    return _u8CallDurationHr;
}

inline void T_TelCallStatusNoticeStreamItem::setU8CallDurationHr (uint8 u8CallDurationHr_) {
    set_has_u8CallDurationHr();
    this->_u8CallDurationHr = u8CallDurationHr_;
}

inline void T_TelCallStatusNoticeStreamItem::clearU8CallDurationMin() {
    if (hasU8CallDurationMin()) {
         clear_has_u8CallDurationMin();
        _u8CallDurationMin = 0u;
     }
}

inline bool T_TelCallStatusNoticeStreamItem::hasU8CallDurationMin () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline uint8 T_TelCallStatusNoticeStreamItem::getU8CallDurationMin () const {
    return _u8CallDurationMin;
}

inline void T_TelCallStatusNoticeStreamItem::setU8CallDurationMin (uint8 u8CallDurationMin_) {
    set_has_u8CallDurationMin();
    this->_u8CallDurationMin = u8CallDurationMin_;
}

inline void T_TelCallStatusNoticeStreamItem::clearU8CallDurationSec() {
    if (hasU8CallDurationSec()) {
         clear_has_u8CallDurationSec();
        _u8CallDurationSec = 0u;
     }
}

inline bool T_TelCallStatusNoticeStreamItem::hasU8CallDurationSec () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline uint8 T_TelCallStatusNoticeStreamItem::getU8CallDurationSec () const {
    return _u8CallDurationSec;
}

inline void T_TelCallStatusNoticeStreamItem::setU8CallDurationSec (uint8 u8CallDurationSec_) {
    set_has_u8CallDurationSec();
    this->_u8CallDurationSec = u8CallDurationSec_;
}

inline void T_TelCallStatusNoticeStreamItem::clearU8DeviceHandle() {
    if (hasU8DeviceHandle()) {
         clear_has_u8DeviceHandle();
        _u8DeviceHandle = 0u;
     }
}

inline bool T_TelCallStatusNoticeStreamItem::hasU8DeviceHandle () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline uint8 T_TelCallStatusNoticeStreamItem::getU8DeviceHandle () const {
    return _u8DeviceHandle;
}

inline void T_TelCallStatusNoticeStreamItem::setU8DeviceHandle (uint8 u8DeviceHandle_) {
    set_has_u8DeviceHandle();
    this->_u8DeviceHandle = u8DeviceHandle_;
}

inline void T_TelCallStatusNoticeStreamItem::set_has_u16CallInstance () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_TelCallStatusNoticeStreamItem::clear_has_u16CallInstance () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_TelCallStatusNoticeStreamItem::set_has_e8CallStatus () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_TelCallStatusNoticeStreamItem::clear_has_e8CallStatus () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_TelCallStatusNoticeStreamItem::set_has_bUsingVehicleAudio () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_TelCallStatusNoticeStreamItem::clear_has_bUsingVehicleAudio () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_TelCallStatusNoticeStreamItem::set_has_u8CallDurationHr () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_TelCallStatusNoticeStreamItem::clear_has_u8CallDurationHr () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_TelCallStatusNoticeStreamItem::set_has_u8CallDurationMin () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_TelCallStatusNoticeStreamItem::clear_has_u8CallDurationMin () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void T_TelCallStatusNoticeStreamItem::set_has_u8CallDurationSec () {
    _has_bits_[0] |= 1u << 5;
}

inline void T_TelCallStatusNoticeStreamItem::clear_has_u8CallDurationSec () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void T_TelCallStatusNoticeStreamItem::set_has_u8DeviceHandle () {
    _has_bits_[0] |= 1u << 6;
}

inline void T_TelCallStatusNoticeStreamItem::clear_has_u8DeviceHandle () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline  T_TelHFEnhancedCallControlStreamItem::T_TelHFEnhancedCallControlStreamItem ()  :
    _u8DeviceHandle (0u),
    _bEndTargetCall (false),
    _bSplitMergedCalls (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_TelHFEnhancedCallControlStreamItem::T_TelHFEnhancedCallControlStreamItem (const T_TelHFEnhancedCallControlStreamItem &rhs)  :
    _u8DeviceHandle (0u),
    _bEndTargetCall (false),
    _bSplitMergedCalls (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_TelHFEnhancedCallControlStreamItem::T_TelHFEnhancedCallControlStreamItem (uint8 u8DeviceHandle_, bool bEndTargetCall_, bool bSplitMergedCalls_)  :
    _u8DeviceHandle (u8DeviceHandle_),
    _bEndTargetCall (bEndTargetCall_),
    _bSplitMergedCalls (bSplitMergedCalls_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_TelHFEnhancedCallControlStreamItem::~T_TelHFEnhancedCallControlStreamItem() {
}

inline T_TelHFEnhancedCallControlStreamItem& T_TelHFEnhancedCallControlStreamItem::operator = (const T_TelHFEnhancedCallControlStreamItem& rhs) {
    if( this != &rhs ) {
        if (rhs.hasU8DeviceHandle()) {
            setU8DeviceHandle(rhs.getU8DeviceHandle());
        } else {
            clearU8DeviceHandle();
        }
        if (rhs.hasBEndTargetCall()) {
            setBEndTargetCall(rhs.getBEndTargetCall());
        } else {
            clearBEndTargetCall();
        }
        if (rhs.hasBSplitMergedCalls()) {
            setBSplitMergedCalls(rhs.getBSplitMergedCalls());
        } else {
            clearBSplitMergedCalls();
        }
    }
    return *this;
}

inline bool T_TelHFEnhancedCallControlStreamItem::operator == (const T_TelHFEnhancedCallControlStreamItem& rhs) const {
    return (((!hasU8DeviceHandle() && !rhs.hasU8DeviceHandle()) || getU8DeviceHandle() == rhs.getU8DeviceHandle()) &&
        ((!hasBEndTargetCall() && !rhs.hasBEndTargetCall()) || getBEndTargetCall() == rhs.getBEndTargetCall()) &&
        ((!hasBSplitMergedCalls() && !rhs.hasBSplitMergedCalls()) || getBSplitMergedCalls() == rhs.getBSplitMergedCalls()));
}

inline bool T_TelHFEnhancedCallControlStreamItem::operator != (const T_TelHFEnhancedCallControlStreamItem& rhs) const {
    return ! (*this == rhs);
}

inline bool T_TelHFEnhancedCallControlStreamItem::operator < (const T_TelHFEnhancedCallControlStreamItem& rhs) const {
    if (hasU8DeviceHandle() || rhs.hasU8DeviceHandle()) {
        if (getU8DeviceHandle() < rhs.getU8DeviceHandle()) return true;
        if (getU8DeviceHandle() > rhs.getU8DeviceHandle()) return false;
    }
    if (hasBEndTargetCall() || rhs.hasBEndTargetCall()) {
        if (getBEndTargetCall() < rhs.getBEndTargetCall()) return true;
        if (getBEndTargetCall() > rhs.getBEndTargetCall()) return false;
    }
    if (hasBSplitMergedCalls() || rhs.hasBSplitMergedCalls()) {
        if (getBSplitMergedCalls() < rhs.getBSplitMergedCalls()) return true;
        if (getBSplitMergedCalls() > rhs.getBSplitMergedCalls()) return false;
    }
    return false;
}

inline bool T_TelHFEnhancedCallControlStreamItem::operator > (const T_TelHFEnhancedCallControlStreamItem& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_TelHFEnhancedCallControlStreamItem::clear() {
    clearU8DeviceHandle();
    clearBEndTargetCall();
    clearBSplitMergedCalls();
}

inline void T_TelHFEnhancedCallControlStreamItem::clearU8DeviceHandle() {
    if (hasU8DeviceHandle()) {
         clear_has_u8DeviceHandle();
        _u8DeviceHandle = 0u;
     }
}

inline bool T_TelHFEnhancedCallControlStreamItem::hasU8DeviceHandle () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 T_TelHFEnhancedCallControlStreamItem::getU8DeviceHandle () const {
    return _u8DeviceHandle;
}

inline void T_TelHFEnhancedCallControlStreamItem::setU8DeviceHandle (uint8 u8DeviceHandle_) {
    set_has_u8DeviceHandle();
    this->_u8DeviceHandle = u8DeviceHandle_;
}

inline void T_TelHFEnhancedCallControlStreamItem::clearBEndTargetCall() {
    if (hasBEndTargetCall()) {
         clear_has_bEndTargetCall();
        _bEndTargetCall = false;
     }
}

inline bool T_TelHFEnhancedCallControlStreamItem::hasBEndTargetCall () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline bool T_TelHFEnhancedCallControlStreamItem::getBEndTargetCall () const {
    return _bEndTargetCall;
}

inline void T_TelHFEnhancedCallControlStreamItem::setBEndTargetCall (bool bEndTargetCall_) {
    set_has_bEndTargetCall();
    this->_bEndTargetCall = bEndTargetCall_;
}

inline void T_TelHFEnhancedCallControlStreamItem::clearBSplitMergedCalls() {
    if (hasBSplitMergedCalls()) {
         clear_has_bSplitMergedCalls();
        _bSplitMergedCalls = false;
     }
}

inline bool T_TelHFEnhancedCallControlStreamItem::hasBSplitMergedCalls () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline bool T_TelHFEnhancedCallControlStreamItem::getBSplitMergedCalls () const {
    return _bSplitMergedCalls;
}

inline void T_TelHFEnhancedCallControlStreamItem::setBSplitMergedCalls (bool bSplitMergedCalls_) {
    set_has_bSplitMergedCalls();
    this->_bSplitMergedCalls = bSplitMergedCalls_;
}

inline void T_TelHFEnhancedCallControlStreamItem::set_has_u8DeviceHandle () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_TelHFEnhancedCallControlStreamItem::clear_has_u8DeviceHandle () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_TelHFEnhancedCallControlStreamItem::set_has_bEndTargetCall () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_TelHFEnhancedCallControlStreamItem::clear_has_bEndTargetCall () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_TelHFEnhancedCallControlStreamItem::set_has_bSplitMergedCalls () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_TelHFEnhancedCallControlStreamItem::clear_has_bSplitMergedCalls () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  T_TelDeviceRingtoneListResultItem::T_TelDeviceRingtoneListResultItem ()  :
    _sBdAddress (),
    _u8RingtoneID (0u),
    _sRingtoneName (),
    _e8InbandRingingSupport (::most_Tel_fi_types::T_e8_TelInbandRingingSupport__e8NOT_SUPPORTED)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_TelDeviceRingtoneListResultItem::T_TelDeviceRingtoneListResultItem (const T_TelDeviceRingtoneListResultItem &rhs)  :
    _sBdAddress (),
    _u8RingtoneID (0u),
    _sRingtoneName (),
    _e8InbandRingingSupport (::most_Tel_fi_types::T_e8_TelInbandRingingSupport__e8NOT_SUPPORTED)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_TelDeviceRingtoneListResultItem::T_TelDeviceRingtoneListResultItem (const ::fi_basetypes_most::T_String& sBdAddress_, uint8 u8RingtoneID_, const ::fi_basetypes_most::T_String& sRingtoneName_, T_e8_TelInbandRingingSupport e8InbandRingingSupport_)  :
    _sBdAddress (sBdAddress_),
    _u8RingtoneID (u8RingtoneID_),
    _sRingtoneName (sRingtoneName_),
    _e8InbandRingingSupport (e8InbandRingingSupport_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sBdAddress_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sRingtoneName_), "Detected invalid utf8 string (see above error messages)");
    }
    #ifndef NDEBUG
    if (!(T_e8_TelInbandRingingSupport_IsValid(e8InbandRingingSupport_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8InbandRingingSupport_, "T_e8_TelInbandRingingSupport", "e8InbandRingingSupport", "T_TelDeviceRingtoneListResultItem");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_TelDeviceRingtoneListResultItem::~T_TelDeviceRingtoneListResultItem() {
}

inline T_TelDeviceRingtoneListResultItem& T_TelDeviceRingtoneListResultItem::operator = (const T_TelDeviceRingtoneListResultItem& rhs) {
    if( this != &rhs ) {
        if (rhs.hasSBdAddress()) {
            setSBdAddress(rhs.getSBdAddress());
        } else {
            clearSBdAddress();
        }
        if (rhs.hasU8RingtoneID()) {
            setU8RingtoneID(rhs.getU8RingtoneID());
        } else {
            clearU8RingtoneID();
        }
        if (rhs.hasSRingtoneName()) {
            setSRingtoneName(rhs.getSRingtoneName());
        } else {
            clearSRingtoneName();
        }
        if (rhs.hasE8InbandRingingSupport()) {
            setE8InbandRingingSupport(rhs.getE8InbandRingingSupport());
        } else {
            clearE8InbandRingingSupport();
        }
    }
    return *this;
}

inline bool T_TelDeviceRingtoneListResultItem::operator == (const T_TelDeviceRingtoneListResultItem& rhs) const {
    return (((!hasSBdAddress() && !rhs.hasSBdAddress()) || getSBdAddress() == rhs.getSBdAddress()) &&
        ((!hasU8RingtoneID() && !rhs.hasU8RingtoneID()) || getU8RingtoneID() == rhs.getU8RingtoneID()) &&
        ((!hasSRingtoneName() && !rhs.hasSRingtoneName()) || getSRingtoneName() == rhs.getSRingtoneName()) &&
        ((!hasE8InbandRingingSupport() && !rhs.hasE8InbandRingingSupport()) || getE8InbandRingingSupport() == rhs.getE8InbandRingingSupport()));
}

inline bool T_TelDeviceRingtoneListResultItem::operator != (const T_TelDeviceRingtoneListResultItem& rhs) const {
    return ! (*this == rhs);
}

inline bool T_TelDeviceRingtoneListResultItem::operator < (const T_TelDeviceRingtoneListResultItem& rhs) const {
    if (hasSBdAddress() || rhs.hasSBdAddress()) {
        if (getSBdAddress() < rhs.getSBdAddress()) return true;
        if (getSBdAddress() > rhs.getSBdAddress()) return false;
    }
    if (hasU8RingtoneID() || rhs.hasU8RingtoneID()) {
        if (getU8RingtoneID() < rhs.getU8RingtoneID()) return true;
        if (getU8RingtoneID() > rhs.getU8RingtoneID()) return false;
    }
    if (hasSRingtoneName() || rhs.hasSRingtoneName()) {
        if (getSRingtoneName() < rhs.getSRingtoneName()) return true;
        if (getSRingtoneName() > rhs.getSRingtoneName()) return false;
    }
    if (hasE8InbandRingingSupport() || rhs.hasE8InbandRingingSupport()) {
        if ((uint32)getE8InbandRingingSupport() < (uint32)rhs.getE8InbandRingingSupport()) return true;
        if ((uint32)getE8InbandRingingSupport() > (uint32)rhs.getE8InbandRingingSupport()) return false;
    }
    return false;
}

inline bool T_TelDeviceRingtoneListResultItem::operator > (const T_TelDeviceRingtoneListResultItem& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_TelDeviceRingtoneListResultItem::clear() {
    clearSBdAddress();
    clearU8RingtoneID();
    clearSRingtoneName();
    clearE8InbandRingingSupport();
}

inline void T_TelDeviceRingtoneListResultItem::clearSBdAddress() {
    if (hasSBdAddress()) {
         clear_has_sBdAddress();
        _sBdAddress.clear();
     }
}

inline bool T_TelDeviceRingtoneListResultItem::hasSBdAddress () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::fi_basetypes_most::T_String& T_TelDeviceRingtoneListResultItem::getSBdAddress () const {
    return _sBdAddress;
}

inline ::fi_basetypes_most::T_String& T_TelDeviceRingtoneListResultItem::getSBdAddressMutable () {
    set_has_sBdAddress();
    return _sBdAddress;
}

inline void T_TelDeviceRingtoneListResultItem::setSBdAddress (const ::fi_basetypes_most::T_String& sBdAddress_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sBdAddress_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sBdAddress();
    this->_sBdAddress = sBdAddress_;
}

inline void T_TelDeviceRingtoneListResultItem::clearU8RingtoneID() {
    if (hasU8RingtoneID()) {
         clear_has_u8RingtoneID();
        _u8RingtoneID = 0u;
     }
}

inline bool T_TelDeviceRingtoneListResultItem::hasU8RingtoneID () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 T_TelDeviceRingtoneListResultItem::getU8RingtoneID () const {
    return _u8RingtoneID;
}

inline void T_TelDeviceRingtoneListResultItem::setU8RingtoneID (uint8 u8RingtoneID_) {
    set_has_u8RingtoneID();
    this->_u8RingtoneID = u8RingtoneID_;
}

inline void T_TelDeviceRingtoneListResultItem::clearSRingtoneName() {
    if (hasSRingtoneName()) {
         clear_has_sRingtoneName();
        _sRingtoneName.clear();
     }
}

inline bool T_TelDeviceRingtoneListResultItem::hasSRingtoneName () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::fi_basetypes_most::T_String& T_TelDeviceRingtoneListResultItem::getSRingtoneName () const {
    return _sRingtoneName;
}

inline ::fi_basetypes_most::T_String& T_TelDeviceRingtoneListResultItem::getSRingtoneNameMutable () {
    set_has_sRingtoneName();
    return _sRingtoneName;
}

inline void T_TelDeviceRingtoneListResultItem::setSRingtoneName (const ::fi_basetypes_most::T_String& sRingtoneName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sRingtoneName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sRingtoneName();
    this->_sRingtoneName = sRingtoneName_;
}

inline void T_TelDeviceRingtoneListResultItem::clearE8InbandRingingSupport() {
    if (hasE8InbandRingingSupport()) {
         clear_has_e8InbandRingingSupport();
        _e8InbandRingingSupport = ::most_Tel_fi_types::T_e8_TelInbandRingingSupport__e8NOT_SUPPORTED;
     }
}

inline bool T_TelDeviceRingtoneListResultItem::hasE8InbandRingingSupport () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline T_e8_TelInbandRingingSupport T_TelDeviceRingtoneListResultItem::getE8InbandRingingSupport () const {
    return _e8InbandRingingSupport;
}

inline void T_TelDeviceRingtoneListResultItem::setE8InbandRingingSupport (T_e8_TelInbandRingingSupport e8InbandRingingSupport_) {
    #ifndef NDEBUG
    if (!(T_e8_TelInbandRingingSupport_IsValid(e8InbandRingingSupport_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8InbandRingingSupport_, "T_e8_TelInbandRingingSupport", "e8InbandRingingSupport", "T_TelDeviceRingtoneListResultItem");
    }
    #endif
    set_has_e8InbandRingingSupport();
    this->_e8InbandRingingSupport = e8InbandRingingSupport_;
}

inline void T_TelDeviceRingtoneListResultItem::set_has_sBdAddress () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_TelDeviceRingtoneListResultItem::clear_has_sBdAddress () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_TelDeviceRingtoneListResultItem::set_has_u8RingtoneID () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_TelDeviceRingtoneListResultItem::clear_has_u8RingtoneID () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_TelDeviceRingtoneListResultItem::set_has_sRingtoneName () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_TelDeviceRingtoneListResultItem::clear_has_sRingtoneName () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_TelDeviceRingtoneListResultItem::set_has_e8InbandRingingSupport () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_TelDeviceRingtoneListResultItem::clear_has_e8InbandRingingSupport () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  T_TelSystemWideRingtonesListResultItem::T_TelSystemWideRingtonesListResultItem ()  :
    _u8RingtoneID (0u),
    _sRingtoneName ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_TelSystemWideRingtonesListResultItem::T_TelSystemWideRingtonesListResultItem (const T_TelSystemWideRingtonesListResultItem &rhs)  :
    _u8RingtoneID (0u),
    _sRingtoneName ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_TelSystemWideRingtonesListResultItem::T_TelSystemWideRingtonesListResultItem (uint8 u8RingtoneID_, const ::fi_basetypes_most::T_String& sRingtoneName_)  :
    _u8RingtoneID (u8RingtoneID_),
    _sRingtoneName (sRingtoneName_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sRingtoneName_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_TelSystemWideRingtonesListResultItem::~T_TelSystemWideRingtonesListResultItem() {
}

inline T_TelSystemWideRingtonesListResultItem& T_TelSystemWideRingtonesListResultItem::operator = (const T_TelSystemWideRingtonesListResultItem& rhs) {
    if( this != &rhs ) {
        if (rhs.hasU8RingtoneID()) {
            setU8RingtoneID(rhs.getU8RingtoneID());
        } else {
            clearU8RingtoneID();
        }
        if (rhs.hasSRingtoneName()) {
            setSRingtoneName(rhs.getSRingtoneName());
        } else {
            clearSRingtoneName();
        }
    }
    return *this;
}

inline bool T_TelSystemWideRingtonesListResultItem::operator == (const T_TelSystemWideRingtonesListResultItem& rhs) const {
    return (((!hasU8RingtoneID() && !rhs.hasU8RingtoneID()) || getU8RingtoneID() == rhs.getU8RingtoneID()) &&
        ((!hasSRingtoneName() && !rhs.hasSRingtoneName()) || getSRingtoneName() == rhs.getSRingtoneName()));
}

inline bool T_TelSystemWideRingtonesListResultItem::operator != (const T_TelSystemWideRingtonesListResultItem& rhs) const {
    return ! (*this == rhs);
}

inline bool T_TelSystemWideRingtonesListResultItem::operator < (const T_TelSystemWideRingtonesListResultItem& rhs) const {
    if (hasU8RingtoneID() || rhs.hasU8RingtoneID()) {
        if (getU8RingtoneID() < rhs.getU8RingtoneID()) return true;
        if (getU8RingtoneID() > rhs.getU8RingtoneID()) return false;
    }
    if (hasSRingtoneName() || rhs.hasSRingtoneName()) {
        if (getSRingtoneName() < rhs.getSRingtoneName()) return true;
        if (getSRingtoneName() > rhs.getSRingtoneName()) return false;
    }
    return false;
}

inline bool T_TelSystemWideRingtonesListResultItem::operator > (const T_TelSystemWideRingtonesListResultItem& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_TelSystemWideRingtonesListResultItem::clear() {
    clearU8RingtoneID();
    clearSRingtoneName();
}

inline void T_TelSystemWideRingtonesListResultItem::clearU8RingtoneID() {
    if (hasU8RingtoneID()) {
         clear_has_u8RingtoneID();
        _u8RingtoneID = 0u;
     }
}

inline bool T_TelSystemWideRingtonesListResultItem::hasU8RingtoneID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 T_TelSystemWideRingtonesListResultItem::getU8RingtoneID () const {
    return _u8RingtoneID;
}

inline void T_TelSystemWideRingtonesListResultItem::setU8RingtoneID (uint8 u8RingtoneID_) {
    set_has_u8RingtoneID();
    this->_u8RingtoneID = u8RingtoneID_;
}

inline void T_TelSystemWideRingtonesListResultItem::clearSRingtoneName() {
    if (hasSRingtoneName()) {
         clear_has_sRingtoneName();
        _sRingtoneName.clear();
     }
}

inline bool T_TelSystemWideRingtonesListResultItem::hasSRingtoneName () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::fi_basetypes_most::T_String& T_TelSystemWideRingtonesListResultItem::getSRingtoneName () const {
    return _sRingtoneName;
}

inline ::fi_basetypes_most::T_String& T_TelSystemWideRingtonesListResultItem::getSRingtoneNameMutable () {
    set_has_sRingtoneName();
    return _sRingtoneName;
}

inline void T_TelSystemWideRingtonesListResultItem::setSRingtoneName (const ::fi_basetypes_most::T_String& sRingtoneName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sRingtoneName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sRingtoneName();
    this->_sRingtoneName = sRingtoneName_;
}

inline void T_TelSystemWideRingtonesListResultItem::set_has_u8RingtoneID () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_TelSystemWideRingtonesListResultItem::clear_has_u8RingtoneID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_TelSystemWideRingtonesListResultItem::set_has_sRingtoneName () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_TelSystemWideRingtonesListResultItem::clear_has_sRingtoneName () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  T_TelSuppressRingtoneOnOffListResultItem::T_TelSuppressRingtoneOnOffListResultItem ()  :
    _sBdAddress (),
    _bSuppressRingtoneState (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_TelSuppressRingtoneOnOffListResultItem::T_TelSuppressRingtoneOnOffListResultItem (const T_TelSuppressRingtoneOnOffListResultItem &rhs)  :
    _sBdAddress (),
    _bSuppressRingtoneState (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_TelSuppressRingtoneOnOffListResultItem::T_TelSuppressRingtoneOnOffListResultItem (const ::fi_basetypes_most::T_String& sBdAddress_, bool bSuppressRingtoneState_)  :
    _sBdAddress (sBdAddress_),
    _bSuppressRingtoneState (bSuppressRingtoneState_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sBdAddress_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_TelSuppressRingtoneOnOffListResultItem::~T_TelSuppressRingtoneOnOffListResultItem() {
}

inline T_TelSuppressRingtoneOnOffListResultItem& T_TelSuppressRingtoneOnOffListResultItem::operator = (const T_TelSuppressRingtoneOnOffListResultItem& rhs) {
    if( this != &rhs ) {
        if (rhs.hasSBdAddress()) {
            setSBdAddress(rhs.getSBdAddress());
        } else {
            clearSBdAddress();
        }
        if (rhs.hasBSuppressRingtoneState()) {
            setBSuppressRingtoneState(rhs.getBSuppressRingtoneState());
        } else {
            clearBSuppressRingtoneState();
        }
    }
    return *this;
}

inline bool T_TelSuppressRingtoneOnOffListResultItem::operator == (const T_TelSuppressRingtoneOnOffListResultItem& rhs) const {
    return (((!hasSBdAddress() && !rhs.hasSBdAddress()) || getSBdAddress() == rhs.getSBdAddress()) &&
        ((!hasBSuppressRingtoneState() && !rhs.hasBSuppressRingtoneState()) || getBSuppressRingtoneState() == rhs.getBSuppressRingtoneState()));
}

inline bool T_TelSuppressRingtoneOnOffListResultItem::operator != (const T_TelSuppressRingtoneOnOffListResultItem& rhs) const {
    return ! (*this == rhs);
}

inline bool T_TelSuppressRingtoneOnOffListResultItem::operator < (const T_TelSuppressRingtoneOnOffListResultItem& rhs) const {
    if (hasSBdAddress() || rhs.hasSBdAddress()) {
        if (getSBdAddress() < rhs.getSBdAddress()) return true;
        if (getSBdAddress() > rhs.getSBdAddress()) return false;
    }
    if (hasBSuppressRingtoneState() || rhs.hasBSuppressRingtoneState()) {
        if (getBSuppressRingtoneState() < rhs.getBSuppressRingtoneState()) return true;
        if (getBSuppressRingtoneState() > rhs.getBSuppressRingtoneState()) return false;
    }
    return false;
}

inline bool T_TelSuppressRingtoneOnOffListResultItem::operator > (const T_TelSuppressRingtoneOnOffListResultItem& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_TelSuppressRingtoneOnOffListResultItem::clear() {
    clearSBdAddress();
    clearBSuppressRingtoneState();
}

inline void T_TelSuppressRingtoneOnOffListResultItem::clearSBdAddress() {
    if (hasSBdAddress()) {
         clear_has_sBdAddress();
        _sBdAddress.clear();
     }
}

inline bool T_TelSuppressRingtoneOnOffListResultItem::hasSBdAddress () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::fi_basetypes_most::T_String& T_TelSuppressRingtoneOnOffListResultItem::getSBdAddress () const {
    return _sBdAddress;
}

inline ::fi_basetypes_most::T_String& T_TelSuppressRingtoneOnOffListResultItem::getSBdAddressMutable () {
    set_has_sBdAddress();
    return _sBdAddress;
}

inline void T_TelSuppressRingtoneOnOffListResultItem::setSBdAddress (const ::fi_basetypes_most::T_String& sBdAddress_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sBdAddress_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sBdAddress();
    this->_sBdAddress = sBdAddress_;
}

inline void T_TelSuppressRingtoneOnOffListResultItem::clearBSuppressRingtoneState() {
    if (hasBSuppressRingtoneState()) {
         clear_has_bSuppressRingtoneState();
        _bSuppressRingtoneState = false;
     }
}

inline bool T_TelSuppressRingtoneOnOffListResultItem::hasBSuppressRingtoneState () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline bool T_TelSuppressRingtoneOnOffListResultItem::getBSuppressRingtoneState () const {
    return _bSuppressRingtoneState;
}

inline void T_TelSuppressRingtoneOnOffListResultItem::setBSuppressRingtoneState (bool bSuppressRingtoneState_) {
    set_has_bSuppressRingtoneState();
    this->_bSuppressRingtoneState = bSuppressRingtoneState_;
}

inline void T_TelSuppressRingtoneOnOffListResultItem::set_has_sBdAddress () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_TelSuppressRingtoneOnOffListResultItem::clear_has_sBdAddress () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_TelSuppressRingtoneOnOffListResultItem::set_has_bSuppressRingtoneState () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_TelSuppressRingtoneOnOffListResultItem::clear_has_bSuppressRingtoneState () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  T_TelAutoWaitingModeOnOffListResultItem::T_TelAutoWaitingModeOnOffListResultItem ()  :
    _sBdAddress (),
    _bAutoWaitingModeState (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_TelAutoWaitingModeOnOffListResultItem::T_TelAutoWaitingModeOnOffListResultItem (const T_TelAutoWaitingModeOnOffListResultItem &rhs)  :
    _sBdAddress (),
    _bAutoWaitingModeState (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_TelAutoWaitingModeOnOffListResultItem::T_TelAutoWaitingModeOnOffListResultItem (const ::fi_basetypes_most::T_String& sBdAddress_, bool bAutoWaitingModeState_)  :
    _sBdAddress (sBdAddress_),
    _bAutoWaitingModeState (bAutoWaitingModeState_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sBdAddress_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_TelAutoWaitingModeOnOffListResultItem::~T_TelAutoWaitingModeOnOffListResultItem() {
}

inline T_TelAutoWaitingModeOnOffListResultItem& T_TelAutoWaitingModeOnOffListResultItem::operator = (const T_TelAutoWaitingModeOnOffListResultItem& rhs) {
    if( this != &rhs ) {
        if (rhs.hasSBdAddress()) {
            setSBdAddress(rhs.getSBdAddress());
        } else {
            clearSBdAddress();
        }
        if (rhs.hasBAutoWaitingModeState()) {
            setBAutoWaitingModeState(rhs.getBAutoWaitingModeState());
        } else {
            clearBAutoWaitingModeState();
        }
    }
    return *this;
}

inline bool T_TelAutoWaitingModeOnOffListResultItem::operator == (const T_TelAutoWaitingModeOnOffListResultItem& rhs) const {
    return (((!hasSBdAddress() && !rhs.hasSBdAddress()) || getSBdAddress() == rhs.getSBdAddress()) &&
        ((!hasBAutoWaitingModeState() && !rhs.hasBAutoWaitingModeState()) || getBAutoWaitingModeState() == rhs.getBAutoWaitingModeState()));
}

inline bool T_TelAutoWaitingModeOnOffListResultItem::operator != (const T_TelAutoWaitingModeOnOffListResultItem& rhs) const {
    return ! (*this == rhs);
}

inline bool T_TelAutoWaitingModeOnOffListResultItem::operator < (const T_TelAutoWaitingModeOnOffListResultItem& rhs) const {
    if (hasSBdAddress() || rhs.hasSBdAddress()) {
        if (getSBdAddress() < rhs.getSBdAddress()) return true;
        if (getSBdAddress() > rhs.getSBdAddress()) return false;
    }
    if (hasBAutoWaitingModeState() || rhs.hasBAutoWaitingModeState()) {
        if (getBAutoWaitingModeState() < rhs.getBAutoWaitingModeState()) return true;
        if (getBAutoWaitingModeState() > rhs.getBAutoWaitingModeState()) return false;
    }
    return false;
}

inline bool T_TelAutoWaitingModeOnOffListResultItem::operator > (const T_TelAutoWaitingModeOnOffListResultItem& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_TelAutoWaitingModeOnOffListResultItem::clear() {
    clearSBdAddress();
    clearBAutoWaitingModeState();
}

inline void T_TelAutoWaitingModeOnOffListResultItem::clearSBdAddress() {
    if (hasSBdAddress()) {
         clear_has_sBdAddress();
        _sBdAddress.clear();
     }
}

inline bool T_TelAutoWaitingModeOnOffListResultItem::hasSBdAddress () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::fi_basetypes_most::T_String& T_TelAutoWaitingModeOnOffListResultItem::getSBdAddress () const {
    return _sBdAddress;
}

inline ::fi_basetypes_most::T_String& T_TelAutoWaitingModeOnOffListResultItem::getSBdAddressMutable () {
    set_has_sBdAddress();
    return _sBdAddress;
}

inline void T_TelAutoWaitingModeOnOffListResultItem::setSBdAddress (const ::fi_basetypes_most::T_String& sBdAddress_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sBdAddress_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sBdAddress();
    this->_sBdAddress = sBdAddress_;
}

inline void T_TelAutoWaitingModeOnOffListResultItem::clearBAutoWaitingModeState() {
    if (hasBAutoWaitingModeState()) {
         clear_has_bAutoWaitingModeState();
        _bAutoWaitingModeState = false;
     }
}

inline bool T_TelAutoWaitingModeOnOffListResultItem::hasBAutoWaitingModeState () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline bool T_TelAutoWaitingModeOnOffListResultItem::getBAutoWaitingModeState () const {
    return _bAutoWaitingModeState;
}

inline void T_TelAutoWaitingModeOnOffListResultItem::setBAutoWaitingModeState (bool bAutoWaitingModeState_) {
    set_has_bAutoWaitingModeState();
    this->_bAutoWaitingModeState = bAutoWaitingModeState_;
}

inline void T_TelAutoWaitingModeOnOffListResultItem::set_has_sBdAddress () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_TelAutoWaitingModeOnOffListResultItem::clear_has_sBdAddress () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_TelAutoWaitingModeOnOffListResultItem::set_has_bAutoWaitingModeState () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_TelAutoWaitingModeOnOffListResultItem::clear_has_bAutoWaitingModeState () {
    _has_bits_[0] &= ~ (1u << 1);
}

} // namespace most_Tel_fi_types

#endif // MOST_TEL_FI_TYPES_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
