#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef MOST_SRC_FI_TYPES_H
#define MOST_SRC_FI_TYPES_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/core/VersionCheck.h"
#include "most_Src_fi_typesConst.h"
#include <cstring>
#include <vector>

/**
 * Types most_Src_fi_types
 */

namespace most_Src_fi_types {

ASF_GENERATOR_VERSION_CHECK_DECLARE

// forward declarations
class T_SrcAudioChannels_Resolution;

class T_SrcAudioChannelListItem;

class T_SrcAudioChannels_AudioChannelList;

class T_SrcContentDescription;

// type definitions
/**
 * If the meaning of "T_SrcAudioChannelList" isn't clear, then there should be a description here.
 */
typedef ::std::vector< T_SrcAudioChannelListItem > T_SrcAudioChannelList;


/**
 * AudioChannels, Resolution
 */
class T_SrcAudioChannels_Resolution {
public:

    /**
     * Default constructor
     */
    inline  T_SrcAudioChannels_Resolution ();

    /**
     * Copy constructor
     */
    inline  T_SrcAudioChannels_Resolution (const T_SrcAudioChannels_Resolution &rhs);

    /**
     * All fields constructor
     */
    inline  T_SrcAudioChannels_Resolution (uint8 u8AudioChannels_, uint8 u8Resolution_);

    /**
     * Destructor
     */
    inline  ~T_SrcAudioChannels_Resolution();

    /**
     * Assignment operator
     */
    inline T_SrcAudioChannels_Resolution& operator = (const T_SrcAudioChannels_Resolution& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_SrcAudioChannels_Resolution& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_SrcAudioChannels_Resolution& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_SrcAudioChannels_Resolution& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_SrcAudioChannels_Resolution& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8AudioChannels"

    static const int kU8AudioChannels = 0;

    /**
     * Clears the field "u8AudioChannels".
     *
     * The field will be set to its default value. The hasU8AudioChannels()
     * method will return false.
     */
    inline void clearU8AudioChannels();

    /**
     * Checks whether the field "u8AudioChannels" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8AudioChannels()). Otherwise it will return false.
     */
    inline bool hasU8AudioChannels () const;

    /**
     * Returns the value of the member "u8AudioChannels".
     *
     * Number of audio channels.  The maximum value is 8 for the Next Generation Architecture Infotainment Subsystem.  8 channes supports 7.1 surround sound.
     *
     * @return The value of the field "u8AudioChannels"
     */
    inline uint8 getU8AudioChannels () const;

    /**
     * Sets the value of the member "u8AudioChannels".
     *
     * Number of audio channels.  The maximum value is 8 for the Next Generation Architecture Infotainment Subsystem.  8 channes supports 7.1 surround sound.
     *
     * @param u8AudioChannels The value which will be set
     */
    inline void setU8AudioChannels (uint8 u8AudioChannels_);

    // API of field "u8Resolution"

    static const int kU8Resolution = 1;

    /**
     * Clears the field "u8Resolution".
     *
     * The field will be set to its default value. The hasU8Resolution()
     * method will return false.
     */
    inline void clearU8Resolution();

    /**
     * Checks whether the field "u8Resolution" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Resolution()). Otherwise it will return false.
     */
    inline bool hasU8Resolution () const;

    /**
     * Returns the value of the member "u8Resolution".
     *
     * Resolution of the audio samples in bytes.
     *
     * @return The value of the field "u8Resolution"
     */
    inline uint8 getU8Resolution () const;

    /**
     * Sets the value of the member "u8Resolution".
     *
     * Resolution of the audio samples in bytes.
     *
     * @param u8Resolution The value which will be set
     */
    inline void setU8Resolution (uint8 u8Resolution_);

    static const T_SrcAudioChannels_Resolution &getDefaultInstance();

private:

    inline void set_has_u8AudioChannels ();

    inline void clear_has_u8AudioChannels ();

    inline void set_has_u8Resolution ();

    inline void clear_has_u8Resolution ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint8 _u8AudioChannels;

    uint8 _u8Resolution;

};

class T_SrcAudioChannelListItem {
public:

    /**
     * Default constructor
     */
    inline  T_SrcAudioChannelListItem ();

    /**
     * Copy constructor
     */
    inline  T_SrcAudioChannelListItem (const T_SrcAudioChannelListItem &rhs);

    /**
     * All fields constructor
     */
    inline  T_SrcAudioChannelListItem (T_e8_SrcAudioChannelName e8AudioChannelName_, uint8 u8BitsPerSample_);

    /**
     * Destructor
     */
    inline  ~T_SrcAudioChannelListItem();

    /**
     * Assignment operator
     */
    inline T_SrcAudioChannelListItem& operator = (const T_SrcAudioChannelListItem& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_SrcAudioChannelListItem& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_SrcAudioChannelListItem& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_SrcAudioChannelListItem& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_SrcAudioChannelListItem& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8AudioChannelName"

    static const int kE8AudioChannelName = 0;

    /**
     * Clears the field "e8AudioChannelName".
     *
     * The field will be set to its default value. The hasE8AudioChannelName()
     * method will return false.
     */
    inline void clearE8AudioChannelName();

    /**
     * Checks whether the field "e8AudioChannelName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8AudioChannelName()). Otherwise it will return false.
     */
    inline bool hasE8AudioChannelName () const;

    /**
     * Returns the value of the member "e8AudioChannelName".
     *
     * Describe the channel name and determine the speaker position of the channel.
     *
     * @return The value of the field "e8AudioChannelName"
     */
    inline T_e8_SrcAudioChannelName getE8AudioChannelName () const;

    /**
     * Sets the value of the member "e8AudioChannelName".
     *
     * Describe the channel name and determine the speaker position of the channel.
     *
     * @param e8AudioChannelName The value which will be set
     */
    inline void setE8AudioChannelName (T_e8_SrcAudioChannelName e8AudioChannelName_);

    // API of field "u8BitsPerSample"

    static const int kU8BitsPerSample = 1;

    /**
     * Clears the field "u8BitsPerSample".
     *
     * The field will be set to its default value. The hasU8BitsPerSample()
     * method will return false.
     */
    inline void clearU8BitsPerSample();

    /**
     * Checks whether the field "u8BitsPerSample" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8BitsPerSample()). Otherwise it will return false.
     */
    inline bool hasU8BitsPerSample () const;

    /**
     * Returns the value of the member "u8BitsPerSample".
     *
     * Resolution of the audio samples in bits.
     *
     * @return The value of the field "u8BitsPerSample"
     */
    inline uint8 getU8BitsPerSample () const;

    /**
     * Sets the value of the member "u8BitsPerSample".
     *
     * Resolution of the audio samples in bits.
     *
     * @param u8BitsPerSample The value which will be set
     */
    inline void setU8BitsPerSample (uint8 u8BitsPerSample_);

    static const T_SrcAudioChannelListItem &getDefaultInstance();

private:

    inline void set_has_e8AudioChannelName ();

    inline void clear_has_e8AudioChannelName ();

    inline void set_has_u8BitsPerSample ();

    inline void clear_has_u8BitsPerSample ();

    uint32 _has_bits_[ (2 + 31) / 32];

    T_e8_SrcAudioChannelName _e8AudioChannelName;

    uint8 _u8BitsPerSample;

};

/**
 * AudioChannels, AudioChannelList
 */
class T_SrcAudioChannels_AudioChannelList {
public:

    /**
     * Default constructor
     */
    inline  T_SrcAudioChannels_AudioChannelList ();

    /**
     * Copy constructor
     */
    inline  T_SrcAudioChannels_AudioChannelList (const T_SrcAudioChannels_AudioChannelList &rhs);

    /**
     * All fields constructor
     */
    inline  T_SrcAudioChannels_AudioChannelList (uint8 u8AudioChannels_, const T_SrcAudioChannelList& oAudioChannelList_);

    /**
     * Destructor
     */
    inline  ~T_SrcAudioChannels_AudioChannelList();

    /**
     * Assignment operator
     */
    inline T_SrcAudioChannels_AudioChannelList& operator = (const T_SrcAudioChannels_AudioChannelList& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_SrcAudioChannels_AudioChannelList& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_SrcAudioChannels_AudioChannelList& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_SrcAudioChannels_AudioChannelList& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_SrcAudioChannels_AudioChannelList& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8AudioChannels"

    static const int kU8AudioChannels = 0;

    /**
     * Clears the field "u8AudioChannels".
     *
     * The field will be set to its default value. The hasU8AudioChannels()
     * method will return false.
     */
    inline void clearU8AudioChannels();

    /**
     * Checks whether the field "u8AudioChannels" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8AudioChannels()). Otherwise it will return false.
     */
    inline bool hasU8AudioChannels () const;

    /**
     * Returns the value of the member "u8AudioChannels".
     *
     * Number of audio channels.  The maximum value is 8 for the Next Generation Architecture Infotainment Subsystem.  8 channes supports 7.1 surround sound.
     *
     * @return The value of the field "u8AudioChannels"
     */
    inline uint8 getU8AudioChannels () const;

    /**
     * Sets the value of the member "u8AudioChannels".
     *
     * Number of audio channels.  The maximum value is 8 for the Next Generation Architecture Infotainment Subsystem.  8 channes supports 7.1 surround sound.
     *
     * @param u8AudioChannels The value which will be set
     */
    inline void setU8AudioChannels (uint8 u8AudioChannels_);

    // API of field "oAudioChannelList"

    static const int kOAudioChannelList = 1;

    /**
     * Clears the field "oAudioChannelList".
     *
     * The field will be set to its default value. The hasOAudioChannelList()
     * method will return false.
     */
    inline void clearOAudioChannelList();

    /**
     * Checks whether the field "oAudioChannelList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOAudioChannelList()). Otherwise it will return false.
     */
    inline bool hasOAudioChannelList () const;

    /**
     * Returns the value of the member "oAudioChannelList".
     *
     * The AudioChannelList parameter is used when the ContentType is multi-channel audio (PCM).
     *
     * @return The value of the field "oAudioChannelList"
     */
    inline const T_SrcAudioChannelList& getOAudioChannelList () const;

    /**
     * Retrieves the value of the field "oAudioChannelList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oAudioChannelList".
     */
    inline T_SrcAudioChannelList& getOAudioChannelListMutable ();

    /**
     * Sets the value of the member "oAudioChannelList".
     *
     * The AudioChannelList parameter is used when the ContentType is multi-channel audio (PCM).
     *
     * @param oAudioChannelList The value which will be set
     */
    inline void setOAudioChannelList (const T_SrcAudioChannelList& oAudioChannelList_);

    static const T_SrcAudioChannels_AudioChannelList &getDefaultInstance();

private:

    static const ::std::vector< T_SrcAudioChannelListItem >& getT_SrcAudioChannelListItemList_DefaultInstance ();

    inline void set_has_u8AudioChannels ();

    inline void clear_has_u8AudioChannels ();

    inline void set_has_oAudioChannelList ();

    inline void clear_has_oAudioChannelList ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint8 _u8AudioChannels;

    T_SrcAudioChannelList _oAudioChannelList;

};

/**
 * The parameter depends on the ContentType.
 */
class T_SrcContentDescription {
public:

    enum T_SrcContentDescriptionField {
        E_O_AUDIO_CHANNELS_RESOLUTION = 0,
        E_O_AUDIO_CHANNELS_AUDIO_CHANNEL_LIST = 16
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "oAudioChannels_Resolution".
     */
    inline  T_SrcContentDescription ();

   /**
     * Copy constructor
     */
    inline  T_SrcContentDescription (const T_SrcContentDescription& rhs);

    /**
     * Destructor
     */
    inline  ~T_SrcContentDescription();

    /**
     * Assigns a new value to this object.
     */
    inline T_SrcContentDescription& operator = (const T_SrcContentDescription& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_SrcContentDescription& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_SrcContentDescription& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_SrcContentDescription& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_SrcContentDescription& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline T_SrcContentDescription::T_SrcContentDescriptionField getField () const;

    inline void setField(T_SrcContentDescription::T_SrcContentDescriptionField field);

    // ---- Field accessors -------------------------------------------

    // API of field "oAudioChannels_Resolution"

    static const int kOAudioChannels_Resolution = 0;

    /**
     * Returns true if the field "oAudioChannels_Resolution" has a value.
     *
     * If the meaning of "oAudioChannels_Resolution" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "oAudioChannels_Resolution", otherwise false
     */
    inline bool hasOAudioChannels_Resolution () const;

    /**
     * Returns the value of field "oAudioChannels_Resolution".It is only valid
     * to call this method if hasOAudioChannels_Resolution() returns true.
     * Otherwise the behavior is not specified.
     *
     * If the meaning of "oAudioChannels_Resolution" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const T_SrcAudioChannels_Resolution& getOAudioChannels_Resolution() const ;

    /**
     * Retrieves the value of the field "oAudioChannels_Resolution" as a
     * mutable object. Any modifications on the returned object will affect
     * the containing object.
     *
     * It is only valid to call this method if isOAudioChannels_Resolution()
     * returns true. Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline T_SrcAudioChannels_Resolution& getOAudioChannels_ResolutionMutable();

    /**
     * Release the object stored in the field "oAudioChannels_Resolution".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "oAudioChannels_Resolution" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "oAudioChannels_Resolution"
     */
    inline T_SrcAudioChannels_Resolution* releaseOAudioChannels_Resolution();

    /**
     * Replace the field "oAudioChannels_Resolution".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceOAudioChannels_Resolution (T_SrcAudioChannels_Resolution* oAudioChannels_Resolution);

    /**
     * Sets the value of the field "oAudioChannels_Resolution". A field which
     * was previously set will be cleared.
     *
     * If the meaning of "oAudioChannels_Resolution" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setOAudioChannels_Resolution (const T_SrcAudioChannels_Resolution& value);

    // API of field "oAudioChannels_AudioChannelList"

    static const int kOAudioChannels_AudioChannelList = 16;

    /**
     * Returns true if the field "oAudioChannels_AudioChannelList" has a value.
     *
     * If the meaning of "oAudioChannels_AudioChannelList" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "oAudioChannels_AudioChannelList", otherwise false
     */
    inline bool hasOAudioChannels_AudioChannelList () const;

    /**
     * Returns the value of field "oAudioChannels_AudioChannelList".It is only
     * valid to call this method if hasOAudioChannels_AudioChannelList()
     * returns true. Otherwise the behavior is not specified.
     *
     * If the meaning of "oAudioChannels_AudioChannelList" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const T_SrcAudioChannels_AudioChannelList& getOAudioChannels_AudioChannelList() const ;

    /**
     * Retrieves the value of the field "oAudioChannels_AudioChannelList" as a
     * mutable object. Any modifications on the returned object will affect
     * the containing object.
     *
     * It is only valid to call this method if
     * isOAudioChannels_AudioChannelList() returns true. Otherwise the
     * behavior is not specified.
     *
     * @return The value of the union
     */
    inline T_SrcAudioChannels_AudioChannelList& getOAudioChannels_AudioChannelListMutable();

    /**
     * Release the object stored in the field "oAudioChannels_AudioChannelList".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "oAudioChannels_AudioChannelList" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "oAudioChannels_AudioChannelList"
     */
    inline T_SrcAudioChannels_AudioChannelList* releaseOAudioChannels_AudioChannelList();

    /**
     * Replace the field "oAudioChannels_AudioChannelList".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceOAudioChannels_AudioChannelList (T_SrcAudioChannels_AudioChannelList* oAudioChannels_AudioChannelList);

    /**
     * Sets the value of the field "oAudioChannels_AudioChannelList". A field
     * which was previously set will be cleared.
     *
     * If the meaning of "oAudioChannels_AudioChannelList" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setOAudioChannels_AudioChannelList (const T_SrcAudioChannels_AudioChannelList& value);

    static const T_SrcContentDescription &getDefaultInstance();

private:

    inline void cloneData (const T_SrcContentDescription& rhs);

    inline void deleteData ();

    T_SrcContentDescriptionField __field;

    union {
        T_SrcAudioChannels_Resolution* oAudioChannels_Resolution_;
        T_SrcAudioChannels_AudioChannelList* oAudioChannels_AudioChannelList_;
    } _data;

};

inline  T_SrcAudioChannels_Resolution::T_SrcAudioChannels_Resolution ()  :
    _u8AudioChannels (0u),
    _u8Resolution (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_SrcAudioChannels_Resolution::T_SrcAudioChannels_Resolution (const T_SrcAudioChannels_Resolution &rhs)  :
    _u8AudioChannels (0u),
    _u8Resolution (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_SrcAudioChannels_Resolution::T_SrcAudioChannels_Resolution (uint8 u8AudioChannels_, uint8 u8Resolution_)  :
    _u8AudioChannels (u8AudioChannels_),
    _u8Resolution (u8Resolution_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_SrcAudioChannels_Resolution::~T_SrcAudioChannels_Resolution() {
}

inline T_SrcAudioChannels_Resolution& T_SrcAudioChannels_Resolution::operator = (const T_SrcAudioChannels_Resolution& rhs) {
    if( this != &rhs ) {
        if (rhs.hasU8AudioChannels()) {
            setU8AudioChannels(rhs.getU8AudioChannels());
        } else {
            clearU8AudioChannels();
        }
        if (rhs.hasU8Resolution()) {
            setU8Resolution(rhs.getU8Resolution());
        } else {
            clearU8Resolution();
        }
    }
    return *this;
}

inline bool T_SrcAudioChannels_Resolution::operator == (const T_SrcAudioChannels_Resolution& rhs) const {
    return (((!hasU8AudioChannels() && !rhs.hasU8AudioChannels()) || getU8AudioChannels() == rhs.getU8AudioChannels()) &&
        ((!hasU8Resolution() && !rhs.hasU8Resolution()) || getU8Resolution() == rhs.getU8Resolution()));
}

inline bool T_SrcAudioChannels_Resolution::operator != (const T_SrcAudioChannels_Resolution& rhs) const {
    return ! (*this == rhs);
}

inline bool T_SrcAudioChannels_Resolution::operator < (const T_SrcAudioChannels_Resolution& rhs) const {
    if (hasU8AudioChannels() || rhs.hasU8AudioChannels()) {
        if (getU8AudioChannels() < rhs.getU8AudioChannels()) return true;
        if (getU8AudioChannels() > rhs.getU8AudioChannels()) return false;
    }
    if (hasU8Resolution() || rhs.hasU8Resolution()) {
        if (getU8Resolution() < rhs.getU8Resolution()) return true;
        if (getU8Resolution() > rhs.getU8Resolution()) return false;
    }
    return false;
}

inline bool T_SrcAudioChannels_Resolution::operator > (const T_SrcAudioChannels_Resolution& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_SrcAudioChannels_Resolution::clear() {
    clearU8AudioChannels();
    clearU8Resolution();
}

inline void T_SrcAudioChannels_Resolution::clearU8AudioChannels() {
    if (hasU8AudioChannels()) {
         clear_has_u8AudioChannels();
        _u8AudioChannels = 0u;
     }
}

inline bool T_SrcAudioChannels_Resolution::hasU8AudioChannels () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 T_SrcAudioChannels_Resolution::getU8AudioChannels () const {
    return _u8AudioChannels;
}

inline void T_SrcAudioChannels_Resolution::setU8AudioChannels (uint8 u8AudioChannels_) {
    set_has_u8AudioChannels();
    this->_u8AudioChannels = u8AudioChannels_;
}

inline void T_SrcAudioChannels_Resolution::clearU8Resolution() {
    if (hasU8Resolution()) {
         clear_has_u8Resolution();
        _u8Resolution = 0u;
     }
}

inline bool T_SrcAudioChannels_Resolution::hasU8Resolution () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 T_SrcAudioChannels_Resolution::getU8Resolution () const {
    return _u8Resolution;
}

inline void T_SrcAudioChannels_Resolution::setU8Resolution (uint8 u8Resolution_) {
    set_has_u8Resolution();
    this->_u8Resolution = u8Resolution_;
}

inline void T_SrcAudioChannels_Resolution::set_has_u8AudioChannels () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_SrcAudioChannels_Resolution::clear_has_u8AudioChannels () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_SrcAudioChannels_Resolution::set_has_u8Resolution () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_SrcAudioChannels_Resolution::clear_has_u8Resolution () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  T_SrcAudioChannelListItem::T_SrcAudioChannelListItem ()  :
    _e8AudioChannelName (::most_Src_fi_types::T_e8_SrcAudioChannelName__e8AUDIO_CHANNEL_NOT_IN_USE),
    _u8BitsPerSample (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_SrcAudioChannelListItem::T_SrcAudioChannelListItem (const T_SrcAudioChannelListItem &rhs)  :
    _e8AudioChannelName (::most_Src_fi_types::T_e8_SrcAudioChannelName__e8AUDIO_CHANNEL_NOT_IN_USE),
    _u8BitsPerSample (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_SrcAudioChannelListItem::T_SrcAudioChannelListItem (T_e8_SrcAudioChannelName e8AudioChannelName_, uint8 u8BitsPerSample_)  :
    _e8AudioChannelName (e8AudioChannelName_),
    _u8BitsPerSample (u8BitsPerSample_)
{
    #ifndef NDEBUG
    if (!(T_e8_SrcAudioChannelName_IsValid(e8AudioChannelName_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8AudioChannelName_, "T_e8_SrcAudioChannelName", "e8AudioChannelName", "T_SrcAudioChannelListItem");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_SrcAudioChannelListItem::~T_SrcAudioChannelListItem() {
}

inline T_SrcAudioChannelListItem& T_SrcAudioChannelListItem::operator = (const T_SrcAudioChannelListItem& rhs) {
    if( this != &rhs ) {
        if (rhs.hasE8AudioChannelName()) {
            setE8AudioChannelName(rhs.getE8AudioChannelName());
        } else {
            clearE8AudioChannelName();
        }
        if (rhs.hasU8BitsPerSample()) {
            setU8BitsPerSample(rhs.getU8BitsPerSample());
        } else {
            clearU8BitsPerSample();
        }
    }
    return *this;
}

inline bool T_SrcAudioChannelListItem::operator == (const T_SrcAudioChannelListItem& rhs) const {
    return (((!hasE8AudioChannelName() && !rhs.hasE8AudioChannelName()) || getE8AudioChannelName() == rhs.getE8AudioChannelName()) &&
        ((!hasU8BitsPerSample() && !rhs.hasU8BitsPerSample()) || getU8BitsPerSample() == rhs.getU8BitsPerSample()));
}

inline bool T_SrcAudioChannelListItem::operator != (const T_SrcAudioChannelListItem& rhs) const {
    return ! (*this == rhs);
}

inline bool T_SrcAudioChannelListItem::operator < (const T_SrcAudioChannelListItem& rhs) const {
    if (hasE8AudioChannelName() || rhs.hasE8AudioChannelName()) {
        if ((uint32)getE8AudioChannelName() < (uint32)rhs.getE8AudioChannelName()) return true;
        if ((uint32)getE8AudioChannelName() > (uint32)rhs.getE8AudioChannelName()) return false;
    }
    if (hasU8BitsPerSample() || rhs.hasU8BitsPerSample()) {
        if (getU8BitsPerSample() < rhs.getU8BitsPerSample()) return true;
        if (getU8BitsPerSample() > rhs.getU8BitsPerSample()) return false;
    }
    return false;
}

inline bool T_SrcAudioChannelListItem::operator > (const T_SrcAudioChannelListItem& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_SrcAudioChannelListItem::clear() {
    clearE8AudioChannelName();
    clearU8BitsPerSample();
}

inline void T_SrcAudioChannelListItem::clearE8AudioChannelName() {
    if (hasE8AudioChannelName()) {
         clear_has_e8AudioChannelName();
        _e8AudioChannelName = ::most_Src_fi_types::T_e8_SrcAudioChannelName__e8AUDIO_CHANNEL_NOT_IN_USE;
     }
}

inline bool T_SrcAudioChannelListItem::hasE8AudioChannelName () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline T_e8_SrcAudioChannelName T_SrcAudioChannelListItem::getE8AudioChannelName () const {
    return _e8AudioChannelName;
}

inline void T_SrcAudioChannelListItem::setE8AudioChannelName (T_e8_SrcAudioChannelName e8AudioChannelName_) {
    #ifndef NDEBUG
    if (!(T_e8_SrcAudioChannelName_IsValid(e8AudioChannelName_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8AudioChannelName_, "T_e8_SrcAudioChannelName", "e8AudioChannelName", "T_SrcAudioChannelListItem");
    }
    #endif
    set_has_e8AudioChannelName();
    this->_e8AudioChannelName = e8AudioChannelName_;
}

inline void T_SrcAudioChannelListItem::clearU8BitsPerSample() {
    if (hasU8BitsPerSample()) {
         clear_has_u8BitsPerSample();
        _u8BitsPerSample = 0u;
     }
}

inline bool T_SrcAudioChannelListItem::hasU8BitsPerSample () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 T_SrcAudioChannelListItem::getU8BitsPerSample () const {
    return _u8BitsPerSample;
}

inline void T_SrcAudioChannelListItem::setU8BitsPerSample (uint8 u8BitsPerSample_) {
    set_has_u8BitsPerSample();
    this->_u8BitsPerSample = u8BitsPerSample_;
}

inline void T_SrcAudioChannelListItem::set_has_e8AudioChannelName () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_SrcAudioChannelListItem::clear_has_e8AudioChannelName () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_SrcAudioChannelListItem::set_has_u8BitsPerSample () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_SrcAudioChannelListItem::clear_has_u8BitsPerSample () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  T_SrcAudioChannels_AudioChannelList::T_SrcAudioChannels_AudioChannelList ()  :
    _u8AudioChannels (0u),
    _oAudioChannelList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_SrcAudioChannels_AudioChannelList::T_SrcAudioChannels_AudioChannelList (const T_SrcAudioChannels_AudioChannelList &rhs)  :
    _u8AudioChannels (0u),
    _oAudioChannelList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_SrcAudioChannels_AudioChannelList::T_SrcAudioChannels_AudioChannelList (uint8 u8AudioChannels_, const T_SrcAudioChannelList& oAudioChannelList_)  :
    _u8AudioChannels (u8AudioChannels_),
    _oAudioChannelList (oAudioChannelList_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_SrcAudioChannels_AudioChannelList::~T_SrcAudioChannels_AudioChannelList() {
}

inline T_SrcAudioChannels_AudioChannelList& T_SrcAudioChannels_AudioChannelList::operator = (const T_SrcAudioChannels_AudioChannelList& rhs) {
    if( this != &rhs ) {
        if (rhs.hasU8AudioChannels()) {
            setU8AudioChannels(rhs.getU8AudioChannels());
        } else {
            clearU8AudioChannels();
        }
        if (rhs.hasOAudioChannelList()) {
            setOAudioChannelList(rhs.getOAudioChannelList());
        } else {
            clearOAudioChannelList();
        }
    }
    return *this;
}

inline bool T_SrcAudioChannels_AudioChannelList::operator == (const T_SrcAudioChannels_AudioChannelList& rhs) const {
    return (((!hasU8AudioChannels() && !rhs.hasU8AudioChannels()) || getU8AudioChannels() == rhs.getU8AudioChannels()) &&
        ((!hasOAudioChannelList() && !rhs.hasOAudioChannelList()) || getOAudioChannelList() == rhs.getOAudioChannelList()));
}

inline bool T_SrcAudioChannels_AudioChannelList::operator != (const T_SrcAudioChannels_AudioChannelList& rhs) const {
    return ! (*this == rhs);
}

inline bool T_SrcAudioChannels_AudioChannelList::operator < (const T_SrcAudioChannels_AudioChannelList& rhs) const {
    if (hasU8AudioChannels() || rhs.hasU8AudioChannels()) {
        if (getU8AudioChannels() < rhs.getU8AudioChannels()) return true;
        if (getU8AudioChannels() > rhs.getU8AudioChannels()) return false;
    }
    if (hasOAudioChannelList() || rhs.hasOAudioChannelList()) {
        if (getOAudioChannelList() < rhs.getOAudioChannelList()) return true;
        if (getOAudioChannelList() > rhs.getOAudioChannelList()) return false;
    }
    return false;
}

inline bool T_SrcAudioChannels_AudioChannelList::operator > (const T_SrcAudioChannels_AudioChannelList& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_SrcAudioChannels_AudioChannelList::clear() {
    clearU8AudioChannels();
    clearOAudioChannelList();
}

inline void T_SrcAudioChannels_AudioChannelList::clearU8AudioChannels() {
    if (hasU8AudioChannels()) {
         clear_has_u8AudioChannels();
        _u8AudioChannels = 0u;
     }
}

inline bool T_SrcAudioChannels_AudioChannelList::hasU8AudioChannels () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 T_SrcAudioChannels_AudioChannelList::getU8AudioChannels () const {
    return _u8AudioChannels;
}

inline void T_SrcAudioChannels_AudioChannelList::setU8AudioChannels (uint8 u8AudioChannels_) {
    set_has_u8AudioChannels();
    this->_u8AudioChannels = u8AudioChannels_;
}

inline void T_SrcAudioChannels_AudioChannelList::clearOAudioChannelList() {
    if (hasOAudioChannelList()) {
         clear_has_oAudioChannelList();
        _oAudioChannelList.clear();
     }
}

inline bool T_SrcAudioChannels_AudioChannelList::hasOAudioChannelList () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const T_SrcAudioChannelList& T_SrcAudioChannels_AudioChannelList::getOAudioChannelList () const {
    return _oAudioChannelList;
}

inline T_SrcAudioChannelList& T_SrcAudioChannels_AudioChannelList::getOAudioChannelListMutable () {
    set_has_oAudioChannelList();
    return _oAudioChannelList;
}

inline void T_SrcAudioChannels_AudioChannelList::setOAudioChannelList (const T_SrcAudioChannelList& oAudioChannelList_) {
    set_has_oAudioChannelList();
    this->_oAudioChannelList = oAudioChannelList_;
}

inline void T_SrcAudioChannels_AudioChannelList::set_has_u8AudioChannels () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_SrcAudioChannels_AudioChannelList::clear_has_u8AudioChannels () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_SrcAudioChannels_AudioChannelList::set_has_oAudioChannelList () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_SrcAudioChannels_AudioChannelList::clear_has_oAudioChannelList () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  T_SrcContentDescription::T_SrcContentDescription () :
    __field (E_O_AUDIO_CHANNELS_RESOLUTION),
    _data()
{
    _data.oAudioChannels_Resolution_ = NULL;
}

inline  T_SrcContentDescription::T_SrcContentDescription (const T_SrcContentDescription& rhs) :
    __field (E_O_AUDIO_CHANNELS_RESOLUTION),
    _data()
{
    _data.oAudioChannels_Resolution_ = NULL;
    *this = rhs;
}

inline  T_SrcContentDescription::~T_SrcContentDescription() {
    deleteData ();
}

inline T_SrcContentDescription& T_SrcContentDescription::operator = (const T_SrcContentDescription& rhs) {
    if( this != &rhs ) {
        if (__field == rhs.__field) {
            cloneData (rhs);
        } else {
            deleteData ();
            cloneData (rhs);
        }
    }
    return *this;
}

inline bool T_SrcContentDescription::operator == (const T_SrcContentDescription& rhs) const {
    if (__field == rhs.__field) {
        switch (__field) {
        case E_O_AUDIO_CHANNELS_RESOLUTION:
            if (_data.oAudioChannels_Resolution_ == NULL && rhs._data.oAudioChannels_Resolution_ == NULL) {
                return true;
            }
            return (getOAudioChannels_Resolution() == rhs.getOAudioChannels_Resolution());
        case E_O_AUDIO_CHANNELS_AUDIO_CHANNEL_LIST:
            if (_data.oAudioChannels_AudioChannelList_ == NULL && rhs._data.oAudioChannels_AudioChannelList_ == NULL) {
                return true;
            }
            return (getOAudioChannels_AudioChannelList() == rhs.getOAudioChannels_AudioChannelList());
        default:
            return false;
        }
    }
    return false;
}

inline bool T_SrcContentDescription::operator != (const T_SrcContentDescription& rhs) const {
    return ! (*this == rhs);
}

inline bool T_SrcContentDescription::operator < (const T_SrcContentDescription& rhs) const  {
    if (hasOAudioChannels_Resolution() && rhs.hasOAudioChannels_Resolution()) {
        if (getOAudioChannels_Resolution() < rhs.getOAudioChannels_Resolution()) return true;
        if (getOAudioChannels_Resolution() > rhs.getOAudioChannels_Resolution()) return false;
    } else {
        if (hasOAudioChannels_Resolution() && !rhs.hasOAudioChannels_Resolution())
            return true;
        else if (!hasOAudioChannels_Resolution() && rhs.hasOAudioChannels_Resolution())
            return false;
    }

    if (hasOAudioChannels_AudioChannelList() && rhs.hasOAudioChannels_AudioChannelList()) {
        if (getOAudioChannels_AudioChannelList() < rhs.getOAudioChannels_AudioChannelList()) return true;
        if (getOAudioChannels_AudioChannelList() > rhs.getOAudioChannels_AudioChannelList()) return false;
    } else {
        if (hasOAudioChannels_AudioChannelList() && !rhs.hasOAudioChannels_AudioChannelList())
            return true;
        else if (!hasOAudioChannels_AudioChannelList() && rhs.hasOAudioChannels_AudioChannelList())
            return false;
    }

    return false;
}

inline bool T_SrcContentDescription::operator > (const T_SrcContentDescription& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline T_SrcContentDescription::T_SrcContentDescriptionField T_SrcContentDescription::getField () const {
    return __field;
}

inline void T_SrcContentDescription::setField(T_SrcContentDescription::T_SrcContentDescriptionField field) {
    deleteData();
    __field = field;
}

inline bool T_SrcContentDescription::hasOAudioChannels_Resolution () const {
    return __field == E_O_AUDIO_CHANNELS_RESOLUTION;
}

inline const T_SrcAudioChannels_Resolution& T_SrcContentDescription::getOAudioChannels_Resolution() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasOAudioChannels_Resolution(), "Can't provide value for union field '%s' of union '%s', have field %d", "oAudioChannels_Resolution", "T_SrcContentDescription", getField());
    }
    if (hasOAudioChannels_Resolution()) {
        if (_data.oAudioChannels_Resolution_ == NULL) {
            return T_SrcAudioChannels_Resolution::getDefaultInstance();
        }
        return *_data.oAudioChannels_Resolution_;
    }
    abort();
}

inline T_SrcAudioChannels_Resolution& T_SrcContentDescription::getOAudioChannels_ResolutionMutable() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasOAudioChannels_Resolution(), "Can't provide value for union field '%s' of union '%s', have field %d", "oAudioChannels_Resolution", "T_SrcContentDescription", getField());
    }
    if (hasOAudioChannels_Resolution()) {
        if (_data.oAudioChannels_Resolution_ == NULL) {
            _data.oAudioChannels_Resolution_ = new T_SrcAudioChannels_Resolution();
            CHECK_ALLOCATION( _data.oAudioChannels_Resolution_ );
        }
        return *_data.oAudioChannels_Resolution_;
    }
    abort();
}

inline T_SrcAudioChannels_Resolution* T_SrcContentDescription::releaseOAudioChannels_Resolution() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(hasOAudioChannels_Resolution(), "Can't release value for field 'T_SrcContentDescription', have field %d", getField());
    }
    if (hasOAudioChannels_Resolution()) {
        if (_data.oAudioChannels_Resolution_ == NULL) {
            _data.oAudioChannels_Resolution_ = new T_SrcAudioChannels_Resolution();
            CHECK_ALLOCATION( _data.oAudioChannels_Resolution_ );
        }
        T_SrcAudioChannels_Resolution* temp = _data.oAudioChannels_Resolution_;
        _data.oAudioChannels_Resolution_ = NULL;
        return temp;
    }
    return 0;
}

inline void T_SrcContentDescription::replaceOAudioChannels_Resolution (T_SrcAudioChannels_Resolution* oAudioChannels_Resolution) {
    if (__field != E_O_AUDIO_CHANNELS_RESOLUTION || _data.oAudioChannels_Resolution_ != oAudioChannels_Resolution) {
        deleteData ();
        __field = E_O_AUDIO_CHANNELS_RESOLUTION;
        _data.oAudioChannels_Resolution_ = oAudioChannels_Resolution;
    }
}

inline void T_SrcContentDescription::setOAudioChannels_Resolution (const T_SrcAudioChannels_Resolution& value) {
    if (__field == E_O_AUDIO_CHANNELS_RESOLUTION && _data.oAudioChannels_Resolution_ != NULL) {
        *_data.oAudioChannels_Resolution_ = value;
    } else {
        deleteData ();
        __field = E_O_AUDIO_CHANNELS_RESOLUTION;
        _data.oAudioChannels_Resolution_ = new T_SrcAudioChannels_Resolution(value);
    }
}

inline bool T_SrcContentDescription::hasOAudioChannels_AudioChannelList () const {
    return __field == E_O_AUDIO_CHANNELS_AUDIO_CHANNEL_LIST;
}

inline const T_SrcAudioChannels_AudioChannelList& T_SrcContentDescription::getOAudioChannels_AudioChannelList() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasOAudioChannels_AudioChannelList(), "Can't provide value for union field '%s' of union '%s', have field %d", "oAudioChannels_AudioChannelList", "T_SrcContentDescription", getField());
    }
    if (hasOAudioChannels_AudioChannelList()) {
        if (_data.oAudioChannels_AudioChannelList_ == NULL) {
            return T_SrcAudioChannels_AudioChannelList::getDefaultInstance();
        }
        return *_data.oAudioChannels_AudioChannelList_;
    }
    abort();
}

inline T_SrcAudioChannels_AudioChannelList& T_SrcContentDescription::getOAudioChannels_AudioChannelListMutable() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasOAudioChannels_AudioChannelList(), "Can't provide value for union field '%s' of union '%s', have field %d", "oAudioChannels_AudioChannelList", "T_SrcContentDescription", getField());
    }
    if (hasOAudioChannels_AudioChannelList()) {
        if (_data.oAudioChannels_AudioChannelList_ == NULL) {
            _data.oAudioChannels_AudioChannelList_ = new T_SrcAudioChannels_AudioChannelList();
            CHECK_ALLOCATION( _data.oAudioChannels_AudioChannelList_ );
        }
        return *_data.oAudioChannels_AudioChannelList_;
    }
    abort();
}

inline T_SrcAudioChannels_AudioChannelList* T_SrcContentDescription::releaseOAudioChannels_AudioChannelList() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(hasOAudioChannels_AudioChannelList(), "Can't release value for field 'T_SrcContentDescription', have field %d", getField());
    }
    if (hasOAudioChannels_AudioChannelList()) {
        if (_data.oAudioChannels_AudioChannelList_ == NULL) {
            _data.oAudioChannels_AudioChannelList_ = new T_SrcAudioChannels_AudioChannelList();
            CHECK_ALLOCATION( _data.oAudioChannels_AudioChannelList_ );
        }
        T_SrcAudioChannels_AudioChannelList* temp = _data.oAudioChannels_AudioChannelList_;
        _data.oAudioChannels_AudioChannelList_ = NULL;
        return temp;
    }
    return 0;
}

inline void T_SrcContentDescription::replaceOAudioChannels_AudioChannelList (T_SrcAudioChannels_AudioChannelList* oAudioChannels_AudioChannelList) {
    if (__field != E_O_AUDIO_CHANNELS_AUDIO_CHANNEL_LIST || _data.oAudioChannels_AudioChannelList_ != oAudioChannels_AudioChannelList) {
        deleteData ();
        __field = E_O_AUDIO_CHANNELS_AUDIO_CHANNEL_LIST;
        _data.oAudioChannels_AudioChannelList_ = oAudioChannels_AudioChannelList;
    }
}

inline void T_SrcContentDescription::setOAudioChannels_AudioChannelList (const T_SrcAudioChannels_AudioChannelList& value) {
    if (__field == E_O_AUDIO_CHANNELS_AUDIO_CHANNEL_LIST && _data.oAudioChannels_AudioChannelList_ != NULL) {
        *_data.oAudioChannels_AudioChannelList_ = value;
    } else {
        deleteData ();
        __field = E_O_AUDIO_CHANNELS_AUDIO_CHANNEL_LIST;
        _data.oAudioChannels_AudioChannelList_ = new T_SrcAudioChannels_AudioChannelList(value);
    }
}

inline void T_SrcContentDescription::cloneData (const T_SrcContentDescription& rhs) {
    switch (rhs.__field) {
    case E_O_AUDIO_CHANNELS_RESOLUTION:
        if (__field == E_O_AUDIO_CHANNELS_RESOLUTION) {
            if (rhs._data.oAudioChannels_Resolution_ == NULL)
                deleteData ();
            else {
                if (_data.oAudioChannels_Resolution_ != NULL) {
                    *_data.oAudioChannels_Resolution_ =  *rhs._data.oAudioChannels_Resolution_;
                } else {
                    _data.oAudioChannels_Resolution_ = new T_SrcAudioChannels_Resolution(*rhs._data.oAudioChannels_Resolution_);
                }
            }
        } else {
            if (_data.oAudioChannels_Resolution_ != 0) deleteData ();
            if (rhs._data.oAudioChannels_Resolution_ != NULL) {
                _data.oAudioChannels_Resolution_ = new T_SrcAudioChannels_Resolution(*rhs._data.oAudioChannels_Resolution_);
            }
        }
        break;
    case E_O_AUDIO_CHANNELS_AUDIO_CHANNEL_LIST:
        if (__field == E_O_AUDIO_CHANNELS_AUDIO_CHANNEL_LIST) {
            if (rhs._data.oAudioChannels_AudioChannelList_ == NULL)
                deleteData ();
            else {
                if (_data.oAudioChannels_AudioChannelList_ != NULL) {
                    *_data.oAudioChannels_AudioChannelList_ =  *rhs._data.oAudioChannels_AudioChannelList_;
                } else {
                    _data.oAudioChannels_AudioChannelList_ = new T_SrcAudioChannels_AudioChannelList(*rhs._data.oAudioChannels_AudioChannelList_);
                }
            }
        } else {
            if (_data.oAudioChannels_AudioChannelList_ != 0) deleteData ();
            if (rhs._data.oAudioChannels_AudioChannelList_ != NULL) {
                _data.oAudioChannels_AudioChannelList_ = new T_SrcAudioChannels_AudioChannelList(*rhs._data.oAudioChannels_AudioChannelList_);
            }
        }
        break;
    default:
        break;
    }
    __field = rhs.__field;
}

inline void T_SrcContentDescription::deleteData () {
    switch (__field) {
    case E_O_AUDIO_CHANNELS_RESOLUTION:
        delete _data.oAudioChannels_Resolution_;
        _data.oAudioChannels_Resolution_ = NULL;
        break;
    case E_O_AUDIO_CHANNELS_AUDIO_CHANNEL_LIST:
        delete _data.oAudioChannels_AudioChannelList_;
        _data.oAudioChannels_AudioChannelList_ = NULL;
        break;
    default:
        break;
    }
}

} // namespace most_Src_fi_types

#endif // MOST_SRC_FI_TYPES_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
