/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef MOST_TEL_FIPROXY_H
#define MOST_TEL_FIPROXY_H

#include "MOST_Tel_FI.h"
#include "asf/cca/CcaProxy.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/core/nullable.h"
#include "fi_basetypes_most.h"
#include "most_Src_fi_typesConst.h"
#include "most_Tel_fi_types.h"
#include "most_Tel_fi_typesConst.h"
#include "most_Tel_fi_types_ExtendedConst.h"

namespace MOST_Tel_FI {

class MOST_Tel_FIProxy;

class AcceptCallCallbackIF {
public:
    virtual ~AcceptCallCallbackIF() {}

    virtual void onAcceptCallError(const ::boost::shared_ptr< MOST_Tel_FIProxy >& proxy, const ::boost::shared_ptr< AcceptCallError >& error) = 0;

    virtual void onAcceptCallResult(const ::boost::shared_ptr< MOST_Tel_FIProxy >& proxy, const ::boost::shared_ptr< AcceptCallResult >& result) = 0;
};

class AcquireTelephoneNumberCallbackIF {
public:
    virtual ~AcquireTelephoneNumberCallbackIF() {}

    virtual void onAcquireTelephoneNumberError(const ::boost::shared_ptr< MOST_Tel_FIProxy >& proxy, const ::boost::shared_ptr< AcquireTelephoneNumberError >& error) = 0;

    virtual void onAcquireTelephoneNumberResult(const ::boost::shared_ptr< MOST_Tel_FIProxy >& proxy, const ::boost::shared_ptr< AcquireTelephoneNumberResult >& result) = 0;
};

class ActivateExternalVRCallbackIF {
public:
    virtual ~ActivateExternalVRCallbackIF() {}

    virtual void onActivateExternalVRError(const ::boost::shared_ptr< MOST_Tel_FIProxy >& proxy, const ::boost::shared_ptr< ActivateExternalVRError >& error) = 0;

    virtual void onActivateExternalVRResult(const ::boost::shared_ptr< MOST_Tel_FIProxy >& proxy, const ::boost::shared_ptr< ActivateExternalVRResult >& result) = 0;
};

class ActiveCallinHandsetCallbackIF {
public:
    virtual ~ActiveCallinHandsetCallbackIF() {}

    virtual void onActiveCallinHandsetError(const ::boost::shared_ptr< MOST_Tel_FIProxy >& proxy, const ::boost::shared_ptr< ActiveCallinHandsetError >& error) = 0;

    virtual void onActiveCallinHandsetStatus(const ::boost::shared_ptr< MOST_Tel_FIProxy >& proxy, const ::boost::shared_ptr< ActiveCallinHandsetStatus >& status) = 0;
};

class ActivePhoneDeviceCallbackIF {
public:
    virtual ~ActivePhoneDeviceCallbackIF() {}

    virtual void onActivePhoneDeviceError(const ::boost::shared_ptr< MOST_Tel_FIProxy >& proxy, const ::boost::shared_ptr< ActivePhoneDeviceError >& error) = 0;

    virtual void onActivePhoneDeviceStatus(const ::boost::shared_ptr< MOST_Tel_FIProxy >& proxy, const ::boost::shared_ptr< ActivePhoneDeviceStatus >& status) = 0;
};

class AllocateCallbackIF {
public:
    virtual ~AllocateCallbackIF() {}

    virtual void onAllocateError(const ::boost::shared_ptr< MOST_Tel_FIProxy >& proxy, const ::boost::shared_ptr< AllocateError >& error) = 0;

    virtual void onAllocateResult(const ::boost::shared_ptr< MOST_Tel_FIProxy >& proxy, const ::boost::shared_ptr< AllocateResult >& result) = 0;
};

class AudioTransferFailedEventCallbackIF {
public:
    virtual ~AudioTransferFailedEventCallbackIF() {}

    virtual void onAudioTransferFailedEventError(const ::boost::shared_ptr< MOST_Tel_FIProxy >& proxy, const ::boost::shared_ptr< AudioTransferFailedEventError >& error) = 0;

    virtual void onAudioTransferFailedEventStatus(const ::boost::shared_ptr< MOST_Tel_FIProxy >& proxy, const ::boost::shared_ptr< AudioTransferFailedEventStatus >& status) = 0;
};

class AutoWaitingModeOnOffCallbackIF {
public:
    virtual ~AutoWaitingModeOnOffCallbackIF() {}

    virtual void onAutoWaitingModeOnOffError(const ::boost::shared_ptr< MOST_Tel_FIProxy >& proxy, const ::boost::shared_ptr< AutoWaitingModeOnOffError >& error) = 0;

    virtual void onAutoWaitingModeOnOffResult(const ::boost::shared_ptr< MOST_Tel_FIProxy >& proxy, const ::boost::shared_ptr< AutoWaitingModeOnOffResult >& result) = 0;
};

class AutoWaitingModeOnOffListCallbackIF {
public:
    virtual ~AutoWaitingModeOnOffListCallbackIF() {}

    virtual void onAutoWaitingModeOnOffListError(const ::boost::shared_ptr< MOST_Tel_FIProxy >& proxy, const ::boost::shared_ptr< AutoWaitingModeOnOffListError >& error) = 0;

    virtual void onAutoWaitingModeOnOffListStatus(const ::boost::shared_ptr< MOST_Tel_FIProxy >& proxy, const ::boost::shared_ptr< AutoWaitingModeOnOffListStatus >& status) = 0;
};

class BTDeviceVoiceRecognitionCallbackIF {
public:
    virtual ~BTDeviceVoiceRecognitionCallbackIF() {}

    virtual void onBTDeviceVoiceRecognitionError(const ::boost::shared_ptr< MOST_Tel_FIProxy >& proxy, const ::boost::shared_ptr< BTDeviceVoiceRecognitionError >& error) = 0;

    virtual void onBTDeviceVoiceRecognitionStatus(const ::boost::shared_ptr< MOST_Tel_FIProxy >& proxy, const ::boost::shared_ptr< BTDeviceVoiceRecognitionStatus >& status) = 0;
};

class BTDeviceVoiceRecognitionExtendedCallbackIF {
public:
    virtual ~BTDeviceVoiceRecognitionExtendedCallbackIF() {}

    virtual void onBTDeviceVoiceRecognitionExtendedError(const ::boost::shared_ptr< MOST_Tel_FIProxy >& proxy, const ::boost::shared_ptr< BTDeviceVoiceRecognitionExtendedError >& error) = 0;

    virtual void onBTDeviceVoiceRecognitionExtendedStatus(const ::boost::shared_ptr< MOST_Tel_FIProxy >& proxy, const ::boost::shared_ptr< BTDeviceVoiceRecognitionExtendedStatus >& status) = 0;
};

class CallOperationFailedEventCallbackIF {
public:
    virtual ~CallOperationFailedEventCallbackIF() {}

    virtual void onCallOperationFailedEventError(const ::boost::shared_ptr< MOST_Tel_FIProxy >& proxy, const ::boost::shared_ptr< CallOperationFailedEventError >& error) = 0;

    virtual void onCallOperationFailedEventStatus(const ::boost::shared_ptr< MOST_Tel_FIProxy >& proxy, const ::boost::shared_ptr< CallOperationFailedEventStatus >& status) = 0;
};

class CallStatusNoticeCallbackIF {
public:
    virtual ~CallStatusNoticeCallbackIF() {}

    virtual void onCallStatusNoticeError(const ::boost::shared_ptr< MOST_Tel_FIProxy >& proxy, const ::boost::shared_ptr< CallStatusNoticeError >& error) = 0;

    virtual void onCallStatusNoticeStatus(const ::boost::shared_ptr< MOST_Tel_FIProxy >& proxy, const ::boost::shared_ptr< CallStatusNoticeStatus >& status) = 0;
};

class CallStatusNoticeExtendedCallbackIF {
public:
    virtual ~CallStatusNoticeExtendedCallbackIF() {}

    virtual void onCallStatusNoticeExtendedError(const ::boost::shared_ptr< MOST_Tel_FIProxy >& proxy, const ::boost::shared_ptr< CallStatusNoticeExtendedError >& error) = 0;

    virtual void onCallStatusNoticeExtendedStatus(const ::boost::shared_ptr< MOST_Tel_FIProxy >& proxy, const ::boost::shared_ptr< CallStatusNoticeExtendedStatus >& status) = 0;
};

class CancelOutgoingCallCallbackIF {
public:
    virtual ~CancelOutgoingCallCallbackIF() {}

    virtual void onCancelOutgoingCallError(const ::boost::shared_ptr< MOST_Tel_FIProxy >& proxy, const ::boost::shared_ptr< CancelOutgoingCallError >& error) = 0;

    virtual void onCancelOutgoingCallResult(const ::boost::shared_ptr< MOST_Tel_FIProxy >& proxy, const ::boost::shared_ptr< CancelOutgoingCallResult >& result) = 0;
};

class CellDeviceNameCallbackIF {
public:
    virtual ~CellDeviceNameCallbackIF() {}

    virtual void onCellDeviceNameError(const ::boost::shared_ptr< MOST_Tel_FIProxy >& proxy, const ::boost::shared_ptr< CellDeviceNameError >& error) = 0;

    virtual void onCellDeviceNameStatus(const ::boost::shared_ptr< MOST_Tel_FIProxy >& proxy, const ::boost::shared_ptr< CellDeviceNameStatus >& status) = 0;
};

class CellNetworkStatusCallbackIF {
public:
    virtual ~CellNetworkStatusCallbackIF() {}

    virtual void onCellNetworkStatusError(const ::boost::shared_ptr< MOST_Tel_FIProxy >& proxy, const ::boost::shared_ptr< CellNetworkStatusError >& error) = 0;

    virtual void onCellNetworkStatusStatus(const ::boost::shared_ptr< MOST_Tel_FIProxy >& proxy, const ::boost::shared_ptr< CellNetworkStatusStatus >& status) = 0;
};

class CellSignalStrengthCallbackIF {
public:
    virtual ~CellSignalStrengthCallbackIF() {}

    virtual void onCellSignalStrengthError(const ::boost::shared_ptr< MOST_Tel_FIProxy >& proxy, const ::boost::shared_ptr< CellSignalStrengthError >& error) = 0;

    virtual void onCellSignalStrengthStatus(const ::boost::shared_ptr< MOST_Tel_FIProxy >& proxy, const ::boost::shared_ptr< CellSignalStrengthStatus >& status) = 0;
};

class CellStateofChargeCallbackIF {
public:
    virtual ~CellStateofChargeCallbackIF() {}

    virtual void onCellStateofChargeError(const ::boost::shared_ptr< MOST_Tel_FIProxy >& proxy, const ::boost::shared_ptr< CellStateofChargeError >& error) = 0;

    virtual void onCellStateofChargeStatus(const ::boost::shared_ptr< MOST_Tel_FIProxy >& proxy, const ::boost::shared_ptr< CellStateofChargeStatus >& status) = 0;
};

class ConferenceInCallbackIF {
public:
    virtual ~ConferenceInCallbackIF() {}

    virtual void onConferenceInError(const ::boost::shared_ptr< MOST_Tel_FIProxy >& proxy, const ::boost::shared_ptr< ConferenceInError >& error) = 0;

    virtual void onConferenceInResult(const ::boost::shared_ptr< MOST_Tel_FIProxy >& proxy, const ::boost::shared_ptr< ConferenceInResult >& result) = 0;
};

class DeActivateExternalVRCallbackIF {
public:
    virtual ~DeActivateExternalVRCallbackIF() {}

    virtual void onDeActivateExternalVRError(const ::boost::shared_ptr< MOST_Tel_FIProxy >& proxy, const ::boost::shared_ptr< DeActivateExternalVRError >& error) = 0;

    virtual void onDeActivateExternalVRResult(const ::boost::shared_ptr< MOST_Tel_FIProxy >& proxy, const ::boost::shared_ptr< DeActivateExternalVRResult >& result) = 0;
};

class DeAllocateCallbackIF {
public:
    virtual ~DeAllocateCallbackIF() {}

    virtual void onDeAllocateError(const ::boost::shared_ptr< MOST_Tel_FIProxy >& proxy, const ::boost::shared_ptr< DeAllocateError >& error) = 0;

    virtual void onDeAllocateResult(const ::boost::shared_ptr< MOST_Tel_FIProxy >& proxy, const ::boost::shared_ptr< DeAllocateResult >& result) = 0;
};

class DeviceRingtoneListCallbackIF {
public:
    virtual ~DeviceRingtoneListCallbackIF() {}

    virtual void onDeviceRingtoneListError(const ::boost::shared_ptr< MOST_Tel_FIProxy >& proxy, const ::boost::shared_ptr< DeviceRingtoneListError >& error) = 0;

    virtual void onDeviceRingtoneListStatus(const ::boost::shared_ptr< MOST_Tel_FIProxy >& proxy, const ::boost::shared_ptr< DeviceRingtoneListStatus >& status) = 0;
};

class DialCallbackIF {
public:
    virtual ~DialCallbackIF() {}

    virtual void onDialError(const ::boost::shared_ptr< MOST_Tel_FIProxy >& proxy, const ::boost::shared_ptr< DialError >& error) = 0;

    virtual void onDialResult(const ::boost::shared_ptr< MOST_Tel_FIProxy >& proxy, const ::boost::shared_ptr< DialResult >& result) = 0;
};

class DialExtendedCallbackIF {
public:
    virtual ~DialExtendedCallbackIF() {}

    virtual void onDialExtendedError(const ::boost::shared_ptr< MOST_Tel_FIProxy >& proxy, const ::boost::shared_ptr< DialExtendedError >& error) = 0;

    virtual void onDialExtendedResult(const ::boost::shared_ptr< MOST_Tel_FIProxy >& proxy, const ::boost::shared_ptr< DialExtendedResult >& result) = 0;
};

class ExternalVRStateCallbackIF {
public:
    virtual ~ExternalVRStateCallbackIF() {}

    virtual void onExternalVRStateError(const ::boost::shared_ptr< MOST_Tel_FIProxy >& proxy, const ::boost::shared_ptr< ExternalVRStateError >& error) = 0;

    virtual void onExternalVRStateStatus(const ::boost::shared_ptr< MOST_Tel_FIProxy >& proxy, const ::boost::shared_ptr< ExternalVRStateStatus >& status) = 0;
};

class HFServiceCallbackIF {
public:
    virtual ~HFServiceCallbackIF() {}

    virtual void onHFServiceError(const ::boost::shared_ptr< MOST_Tel_FIProxy >& proxy, const ::boost::shared_ptr< HFServiceError >& error) = 0;

    virtual void onHFServiceStatus(const ::boost::shared_ptr< MOST_Tel_FIProxy >& proxy, const ::boost::shared_ptr< HFServiceStatus >& status) = 0;
};

class HandsFreeEnhancedCallControlCallbackIF {
public:
    virtual ~HandsFreeEnhancedCallControlCallbackIF() {}

    virtual void onHandsFreeEnhancedCallControlError(const ::boost::shared_ptr< MOST_Tel_FIProxy >& proxy, const ::boost::shared_ptr< HandsFreeEnhancedCallControlError >& error) = 0;

    virtual void onHandsFreeEnhancedCallControlStatus(const ::boost::shared_ptr< MOST_Tel_FIProxy >& proxy, const ::boost::shared_ptr< HandsFreeEnhancedCallControlStatus >& status) = 0;
};

class HangUpCallCallbackIF {
public:
    virtual ~HangUpCallCallbackIF() {}

    virtual void onHangUpCallError(const ::boost::shared_ptr< MOST_Tel_FIProxy >& proxy, const ::boost::shared_ptr< HangUpCallError >& error) = 0;

    virtual void onHangUpCallResult(const ::boost::shared_ptr< MOST_Tel_FIProxy >& proxy, const ::boost::shared_ptr< HangUpCallResult >& result) = 0;
};

class HoldCallCallbackIF {
public:
    virtual ~HoldCallCallbackIF() {}

    virtual void onHoldCallError(const ::boost::shared_ptr< MOST_Tel_FIProxy >& proxy, const ::boost::shared_ptr< HoldCallError >& error) = 0;

    virtual void onHoldCallResult(const ::boost::shared_ptr< MOST_Tel_FIProxy >& proxy, const ::boost::shared_ptr< HoldCallResult >& result) = 0;
};

class IgnoreCallCallbackIF {
public:
    virtual ~IgnoreCallCallbackIF() {}

    virtual void onIgnoreCallError(const ::boost::shared_ptr< MOST_Tel_FIProxy >& proxy, const ::boost::shared_ptr< IgnoreCallError >& error) = 0;

    virtual void onIgnoreCallResult(const ::boost::shared_ptr< MOST_Tel_FIProxy >& proxy, const ::boost::shared_ptr< IgnoreCallResult >& result) = 0;
};

class InComingCallEventCallbackIF {
public:
    virtual ~InComingCallEventCallbackIF() {}

    virtual void onInComingCallEventError(const ::boost::shared_ptr< MOST_Tel_FIProxy >& proxy, const ::boost::shared_ptr< InComingCallEventError >& error) = 0;

    virtual void onInComingCallEventStatus(const ::boost::shared_ptr< MOST_Tel_FIProxy >& proxy, const ::boost::shared_ptr< InComingCallEventStatus >& status) = 0;
};

class IncomingCallRejectedEventCallbackIF {
public:
    virtual ~IncomingCallRejectedEventCallbackIF() {}

    virtual void onIncomingCallRejectedEventError(const ::boost::shared_ptr< MOST_Tel_FIProxy >& proxy, const ::boost::shared_ptr< IncomingCallRejectedEventError >& error) = 0;

    virtual void onIncomingCallRejectedEventStatus(const ::boost::shared_ptr< MOST_Tel_FIProxy >& proxy, const ::boost::shared_ptr< IncomingCallRejectedEventStatus >& status) = 0;
};

class MicrophoneMuteStateCallbackIF {
public:
    virtual ~MicrophoneMuteStateCallbackIF() {}

    virtual void onMicrophoneMuteStateError(const ::boost::shared_ptr< MOST_Tel_FIProxy >& proxy, const ::boost::shared_ptr< MicrophoneMuteStateError >& error) = 0;

    virtual void onMicrophoneMuteStateStatus(const ::boost::shared_ptr< MOST_Tel_FIProxy >& proxy, const ::boost::shared_ptr< MicrophoneMuteStateStatus >& status) = 0;
};

class NetworkOperatorCallbackIF {
public:
    virtual ~NetworkOperatorCallbackIF() {}

    virtual void onNetworkOperatorError(const ::boost::shared_ptr< MOST_Tel_FIProxy >& proxy, const ::boost::shared_ptr< NetworkOperatorError >& error) = 0;

    virtual void onNetworkOperatorStatus(const ::boost::shared_ptr< MOST_Tel_FIProxy >& proxy, const ::boost::shared_ptr< NetworkOperatorStatus >& status) = 0;
};

class OutgoingCallFailedEventCallbackIF {
public:
    virtual ~OutgoingCallFailedEventCallbackIF() {}

    virtual void onOutgoingCallFailedEventError(const ::boost::shared_ptr< MOST_Tel_FIProxy >& proxy, const ::boost::shared_ptr< OutgoingCallFailedEventError >& error) = 0;

    virtual void onOutgoingCallFailedEventStatus(const ::boost::shared_ptr< MOST_Tel_FIProxy >& proxy, const ::boost::shared_ptr< OutgoingCallFailedEventStatus >& status) = 0;
};

class PlayRingtoneCallbackIF {
public:
    virtual ~PlayRingtoneCallbackIF() {}

    virtual void onPlayRingtoneError(const ::boost::shared_ptr< MOST_Tel_FIProxy >& proxy, const ::boost::shared_ptr< PlayRingtoneError >& error) = 0;

    virtual void onPlayRingtoneResult(const ::boost::shared_ptr< MOST_Tel_FIProxy >& proxy, const ::boost::shared_ptr< PlayRingtoneResult >& result) = 0;
};

class QueryTelephoneNumberCallbackIF {
public:
    virtual ~QueryTelephoneNumberCallbackIF() {}

    virtual void onQueryTelephoneNumberError(const ::boost::shared_ptr< MOST_Tel_FIProxy >& proxy, const ::boost::shared_ptr< QueryTelephoneNumberError >& error) = 0;

    virtual void onQueryTelephoneNumberResult(const ::boost::shared_ptr< MOST_Tel_FIProxy >& proxy, const ::boost::shared_ptr< QueryTelephoneNumberResult >& result) = 0;
};

class RedialCallbackIF {
public:
    virtual ~RedialCallbackIF() {}

    virtual void onRedialError(const ::boost::shared_ptr< MOST_Tel_FIProxy >& proxy, const ::boost::shared_ptr< RedialError >& error) = 0;

    virtual void onRedialResult(const ::boost::shared_ptr< MOST_Tel_FIProxy >& proxy, const ::boost::shared_ptr< RedialResult >& result) = 0;
};

class RejectCallCallbackIF {
public:
    virtual ~RejectCallCallbackIF() {}

    virtual void onRejectCallError(const ::boost::shared_ptr< MOST_Tel_FIProxy >& proxy, const ::boost::shared_ptr< RejectCallError >& error) = 0;

    virtual void onRejectCallResult(const ::boost::shared_ptr< MOST_Tel_FIProxy >& proxy, const ::boost::shared_ptr< RejectCallResult >& result) = 0;
};

class ResumeCallCallbackIF {
public:
    virtual ~ResumeCallCallbackIF() {}

    virtual void onResumeCallError(const ::boost::shared_ptr< MOST_Tel_FIProxy >& proxy, const ::boost::shared_ptr< ResumeCallError >& error) = 0;

    virtual void onResumeCallResult(const ::boost::shared_ptr< MOST_Tel_FIProxy >& proxy, const ::boost::shared_ptr< ResumeCallResult >& result) = 0;
};

class RingtoneMuteStateCallbackIF {
public:
    virtual ~RingtoneMuteStateCallbackIF() {}

    virtual void onRingtoneMuteStateError(const ::boost::shared_ptr< MOST_Tel_FIProxy >& proxy, const ::boost::shared_ptr< RingtoneMuteStateError >& error) = 0;

    virtual void onRingtoneMuteStateStatus(const ::boost::shared_ptr< MOST_Tel_FIProxy >& proxy, const ::boost::shared_ptr< RingtoneMuteStateStatus >& status) = 0;
};

class RingtonePlaybackStatusCallbackIF {
public:
    virtual ~RingtonePlaybackStatusCallbackIF() {}

    virtual void onRingtonePlaybackStatusError(const ::boost::shared_ptr< MOST_Tel_FIProxy >& proxy, const ::boost::shared_ptr< RingtonePlaybackStatusError >& error) = 0;

    virtual void onRingtonePlaybackStatusStatus(const ::boost::shared_ptr< MOST_Tel_FIProxy >& proxy, const ::boost::shared_ptr< RingtonePlaybackStatusStatus >& status) = 0;
};

class SLCStatusCallbackIF {
public:
    virtual ~SLCStatusCallbackIF() {}

    virtual void onSLCStatusError(const ::boost::shared_ptr< MOST_Tel_FIProxy >& proxy, const ::boost::shared_ptr< SLCStatusError >& error) = 0;

    virtual void onSLCStatusStatus(const ::boost::shared_ptr< MOST_Tel_FIProxy >& proxy, const ::boost::shared_ptr< SLCStatusStatus >& status) = 0;
};

class SendDTMFCallbackIF {
public:
    virtual ~SendDTMFCallbackIF() {}

    virtual void onSendDTMFError(const ::boost::shared_ptr< MOST_Tel_FIProxy >& proxy, const ::boost::shared_ptr< SendDTMFError >& error) = 0;

    virtual void onSendDTMFResult(const ::boost::shared_ptr< MOST_Tel_FIProxy >& proxy, const ::boost::shared_ptr< SendDTMFResult >& result) = 0;
};

class SendDTMFFailedEventCallbackIF {
public:
    virtual ~SendDTMFFailedEventCallbackIF() {}

    virtual void onSendDTMFFailedEventError(const ::boost::shared_ptr< MOST_Tel_FIProxy >& proxy, const ::boost::shared_ptr< SendDTMFFailedEventError >& error) = 0;

    virtual void onSendDTMFFailedEventStatus(const ::boost::shared_ptr< MOST_Tel_FIProxy >& proxy, const ::boost::shared_ptr< SendDTMFFailedEventStatus >& status) = 0;
};

class SetActivePhoneCallbackIF {
public:
    virtual ~SetActivePhoneCallbackIF() {}

    virtual void onSetActivePhoneError(const ::boost::shared_ptr< MOST_Tel_FIProxy >& proxy, const ::boost::shared_ptr< SetActivePhoneError >& error) = 0;

    virtual void onSetActivePhoneResult(const ::boost::shared_ptr< MOST_Tel_FIProxy >& proxy, const ::boost::shared_ptr< SetActivePhoneResult >& result) = 0;
};

class SetRingtoneCallbackIF {
public:
    virtual ~SetRingtoneCallbackIF() {}

    virtual void onSetRingtoneError(const ::boost::shared_ptr< MOST_Tel_FIProxy >& proxy, const ::boost::shared_ptr< SetRingtoneError >& error) = 0;

    virtual void onSetRingtoneResult(const ::boost::shared_ptr< MOST_Tel_FIProxy >& proxy, const ::boost::shared_ptr< SetRingtoneResult >& result) = 0;
};

class SourceActivityCallbackIF {
public:
    virtual ~SourceActivityCallbackIF() {}

    virtual void onSourceActivityError(const ::boost::shared_ptr< MOST_Tel_FIProxy >& proxy, const ::boost::shared_ptr< SourceActivityError >& error) = 0;

    virtual void onSourceActivityResult(const ::boost::shared_ptr< MOST_Tel_FIProxy >& proxy, const ::boost::shared_ptr< SourceActivityResult >& result) = 0;
};

class SourceAvailableCallbackIF {
public:
    virtual ~SourceAvailableCallbackIF() {}

    virtual void onSourceAvailableError(const ::boost::shared_ptr< MOST_Tel_FIProxy >& proxy, const ::boost::shared_ptr< SourceAvailableError >& error) = 0;

    virtual void onSourceAvailableStatus(const ::boost::shared_ptr< MOST_Tel_FIProxy >& proxy, const ::boost::shared_ptr< SourceAvailableStatus >& status) = 0;
};

class SourceInfoCallbackIF {
public:
    virtual ~SourceInfoCallbackIF() {}

    virtual void onSourceInfoError(const ::boost::shared_ptr< MOST_Tel_FIProxy >& proxy, const ::boost::shared_ptr< SourceInfoError >& error) = 0;

    virtual void onSourceInfoStatus(const ::boost::shared_ptr< MOST_Tel_FIProxy >& proxy, const ::boost::shared_ptr< SourceInfoStatus >& status) = 0;
};

class SpeedDialCallbackIF {
public:
    virtual ~SpeedDialCallbackIF() {}

    virtual void onSpeedDialError(const ::boost::shared_ptr< MOST_Tel_FIProxy >& proxy, const ::boost::shared_ptr< SpeedDialError >& error) = 0;

    virtual void onSpeedDialResult(const ::boost::shared_ptr< MOST_Tel_FIProxy >& proxy, const ::boost::shared_ptr< SpeedDialResult >& result) = 0;
};

class SplitCallCallbackIF {
public:
    virtual ~SplitCallCallbackIF() {}

    virtual void onSplitCallError(const ::boost::shared_ptr< MOST_Tel_FIProxy >& proxy, const ::boost::shared_ptr< SplitCallError >& error) = 0;

    virtual void onSplitCallResult(const ::boost::shared_ptr< MOST_Tel_FIProxy >& proxy, const ::boost::shared_ptr< SplitCallResult >& result) = 0;
};

class StartStopWaitingModeCallbackIF {
public:
    virtual ~StartStopWaitingModeCallbackIF() {}

    virtual void onStartStopWaitingModeError(const ::boost::shared_ptr< MOST_Tel_FIProxy >& proxy, const ::boost::shared_ptr< StartStopWaitingModeError >& error) = 0;

    virtual void onStartStopWaitingModeResult(const ::boost::shared_ptr< MOST_Tel_FIProxy >& proxy, const ::boost::shared_ptr< StartStopWaitingModeResult >& result) = 0;
};

class StopRingtoneCallbackIF {
public:
    virtual ~StopRingtoneCallbackIF() {}

    virtual void onStopRingtoneError(const ::boost::shared_ptr< MOST_Tel_FIProxy >& proxy, const ::boost::shared_ptr< StopRingtoneError >& error) = 0;

    virtual void onStopRingtoneResult(const ::boost::shared_ptr< MOST_Tel_FIProxy >& proxy, const ::boost::shared_ptr< StopRingtoneResult >& result) = 0;
};

class SuppressRingtoneOnOffCallbackIF {
public:
    virtual ~SuppressRingtoneOnOffCallbackIF() {}

    virtual void onSuppressRingtoneOnOffError(const ::boost::shared_ptr< MOST_Tel_FIProxy >& proxy, const ::boost::shared_ptr< SuppressRingtoneOnOffError >& error) = 0;

    virtual void onSuppressRingtoneOnOffResult(const ::boost::shared_ptr< MOST_Tel_FIProxy >& proxy, const ::boost::shared_ptr< SuppressRingtoneOnOffResult >& result) = 0;
};

class SuppressRingtoneOnOffListCallbackIF {
public:
    virtual ~SuppressRingtoneOnOffListCallbackIF() {}

    virtual void onSuppressRingtoneOnOffListError(const ::boost::shared_ptr< MOST_Tel_FIProxy >& proxy, const ::boost::shared_ptr< SuppressRingtoneOnOffListError >& error) = 0;

    virtual void onSuppressRingtoneOnOffListStatus(const ::boost::shared_ptr< MOST_Tel_FIProxy >& proxy, const ::boost::shared_ptr< SuppressRingtoneOnOffListStatus >& status) = 0;
};

class SwapCallCallbackIF {
public:
    virtual ~SwapCallCallbackIF() {}

    virtual void onSwapCallError(const ::boost::shared_ptr< MOST_Tel_FIProxy >& proxy, const ::boost::shared_ptr< SwapCallError >& error) = 0;

    virtual void onSwapCallResult(const ::boost::shared_ptr< MOST_Tel_FIProxy >& proxy, const ::boost::shared_ptr< SwapCallResult >& result) = 0;
};

class SystemWideRingtonesListCallbackIF {
public:
    virtual ~SystemWideRingtonesListCallbackIF() {}

    virtual void onSystemWideRingtonesListError(const ::boost::shared_ptr< MOST_Tel_FIProxy >& proxy, const ::boost::shared_ptr< SystemWideRingtonesListError >& error) = 0;

    virtual void onSystemWideRingtonesListStatus(const ::boost::shared_ptr< MOST_Tel_FIProxy >& proxy, const ::boost::shared_ptr< SystemWideRingtonesListStatus >& status) = 0;
};

class TransferCallToHandsetCallbackIF {
public:
    virtual ~TransferCallToHandsetCallbackIF() {}

    virtual void onTransferCallToHandsetError(const ::boost::shared_ptr< MOST_Tel_FIProxy >& proxy, const ::boost::shared_ptr< TransferCallToHandsetError >& error) = 0;

    virtual void onTransferCallToHandsetResult(const ::boost::shared_ptr< MOST_Tel_FIProxy >& proxy, const ::boost::shared_ptr< TransferCallToHandsetResult >& result) = 0;
};

class TransferCallToVehicleCallbackIF {
public:
    virtual ~TransferCallToVehicleCallbackIF() {}

    virtual void onTransferCallToVehicleError(const ::boost::shared_ptr< MOST_Tel_FIProxy >& proxy, const ::boost::shared_ptr< TransferCallToVehicleError >& error) = 0;

    virtual void onTransferCallToVehicleResult(const ::boost::shared_ptr< MOST_Tel_FIProxy >& proxy, const ::boost::shared_ptr< TransferCallToVehicleResult >& result) = 0;
};

class VehicleAudioCallbackIF {
public:
    virtual ~VehicleAudioCallbackIF() {}

    virtual void onVehicleAudioError(const ::boost::shared_ptr< MOST_Tel_FIProxy >& proxy, const ::boost::shared_ptr< VehicleAudioError >& error) = 0;

    virtual void onVehicleAudioStatus(const ::boost::shared_ptr< MOST_Tel_FIProxy >& proxy, const ::boost::shared_ptr< VehicleAudioStatus >& status) = 0;
};

class VoiceMailCallbackIF {
public:
    virtual ~VoiceMailCallbackIF() {}

    virtual void onVoiceMailError(const ::boost::shared_ptr< MOST_Tel_FIProxy >& proxy, const ::boost::shared_ptr< VoiceMailError >& error) = 0;

    virtual void onVoiceMailResult(const ::boost::shared_ptr< MOST_Tel_FIProxy >& proxy, const ::boost::shared_ptr< VoiceMailResult >& result) = 0;
};

class WaitingModeFilePathCallbackIF {
public:
    virtual ~WaitingModeFilePathCallbackIF() {}

    virtual void onWaitingModeFilePathError(const ::boost::shared_ptr< MOST_Tel_FIProxy >& proxy, const ::boost::shared_ptr< WaitingModeFilePathError >& error) = 0;

    virtual void onWaitingModeFilePathStatus(const ::boost::shared_ptr< MOST_Tel_FIProxy >& proxy, const ::boost::shared_ptr< WaitingModeFilePathStatus >& status) = 0;
};

class WaitingModeStateCallbackIF {
public:
    virtual ~WaitingModeStateCallbackIF() {}

    virtual void onWaitingModeStateError(const ::boost::shared_ptr< MOST_Tel_FIProxy >& proxy, const ::boost::shared_ptr< WaitingModeStateError >& error) = 0;

    virtual void onWaitingModeStateStatus(const ::boost::shared_ptr< MOST_Tel_FIProxy >& proxy, const ::boost::shared_ptr< WaitingModeStateStatus >& status) = 0;
};

class MOST_Tel_FIProxyCallback;

/**
 * MOST_Tel_FIProxy is the client side representation of the CCA
 * Functional Interface 'MOST_Tel_FI' (specified in file most_Tel_fi.xml).
 *
 * CCA Functional Interface 'MOST_Tel_FI'
 *
 * Fullname: Proprietary - Telephone
 *
 * Version: 4.3
 *
 * Author: Scott Rush, General Motors
 *
 * Date: 2013-05-31
 *
 * Department:
 *
 * Title:
 *             MOST_Telephone_FI
 *
 * <b>Description of 'MOST_Tel_FI':</b>
 *
 * <p>This FBlock was assembled from FBlockManifest file: Telephone.fblockman, Please consult individual interface files for interface-specific change history.</p>
 * The Telephone FBlock encapsulates hands free calling functions for the
 * Bluetooth portable phones. The Telephone FBlock implements ITelephone,
 * ISink, and ISource interfaces. ITelephone contains the functions that an
 * HMI Controller uses to control the Telephone FBlock. ISource/ISink
 * provides the interaction with the Audio Video Manager.See GIS-327
 * Bluetooth Settings Requirements Specification for hands-free profile
 * feature requirements and GIS-366 Telephone FBlock Specification for
 * detailed interface requirements.
 */
class MOST_Tel_FIProxy : public ::asf::cca::CcaProxy
{
public:

    /**
     * Create a new instance of MOST_Tel_FIProxy. The caller has to pass the
     * port name and the service information. It is only possible to use this
     * function if the port is defined in the CMC model as "wired at
     * runtime"-port. The application id of the CCA Server will be determined
     * with help of the CCA SrvSupplier messages. It's guranteed that the
     * corresponding CCA server will have the specified major version and at
     * least the specified minor version of that interface.
     */
    static ::boost::shared_ptr< MOST_Tel_FIProxy > createProxy(const std::string& portName, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags = ::asf::cca::CcaProxy::SERVICE_REGISTER);

    /**
     * Create a new instance of MOST_Tel_FIProxy. The caller has to pass the
     * port name and the service information. It is only possible to use this
     * function if the port is defined in the CMC model as "wired at
     * runtime"-port. The proxy will connect to the CCA application specified
     * by appId. The CCA SrvSupplier messages will be used to determine the
     * availability of this application and the service. It's guranteed that
     * the corresponding CCA server will have the specified major version and
     * at least the specified minor version of that interface.
     */
    static ::boost::shared_ptr< MOST_Tel_FIProxy > createProxy(const std::string& portName, uint16 appId, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags = ::asf::cca::CcaProxy::SERVICE_REGISTER);

    /**
     * Create a new instance of MOST_Tel_FIProxy. The caller has to pass the
     * port name. The port name is defined in the "Car Multimedia Component"
     * model. With the help of the port name it is possible to address the
     * concrete proxy, which is defined in the CMC model description.
     */
    static ::boost::shared_ptr< MOST_Tel_FIProxy > createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    /**
     * Destructor of MOST_Tel_FIProxy. The destructor will send RelUpReg
     * messages for all property notifications and call the error callback of
     * all pending method invocations.
     */
    ~MOST_Tel_FIProxy();

    // Method 'Allocate'

    /**
     * Call the method 'Allocate'. This method sends a MethodStart message to
     * the CCA server.
     *
     * <b>Documentation of 'Allocate'</b>:
     *
     * The Allocate method causes the source to occupy bandwidth for streaming data.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param u8SourceNr Number of a data source (within one FBlock there can be more than one), for example, 0x01 for the first source.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAllocateStart(AllocateCallbackIF& cb, uint8 u8SourceNr);

    // Method 'DeAllocate'

    /**
     * Call the method 'DeAllocate'. This method sends a MethodStart message
     * to the CCA server.
     *
     * <b>Documentation of 'DeAllocate'</b>:
     *
     * The method DeAllocate causes the source to free occupied Streaming bandwidth.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param u8SourceNr Number of a data source (within one FBlock there can be more than one), for example, 0x01 for the first source.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDeAllocateStart(DeAllocateCallbackIF& cb, uint8 u8SourceNr);

    // Method 'SourceActivity'

    /**
     * Call the method 'SourceActivity'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'SourceActivity'</b>:
     *
     * This method controls the activity of a source.
     *
     * Note that the PAUSE state is not allowed for the General Motors implementation and is thus not defined as an allowed state within the enumeration.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param u8SourceNr Number of a data source (within one FBlock there can be more than one), for example, 0x01 for the first source.
     *
     * @param e8Activity Through parameter Activity, streaming data transfer can be started or stopped. Note that the paused state is not allowed in the General Motors MOST implementation.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSourceActivityStart(SourceActivityCallbackIF& cb, uint8 u8SourceNr, ::most_Src_fi_types::T_e8_SrcActivity e8Activity);

    // Method 'AcceptCall'

    /**
     * Call the method 'AcceptCall'. This method sends a MethodStart message
     * to the CCA server.
     *
     * <b>Documentation of 'AcceptCall'</b>:
     *
     * Accepts an Incoming call - for single or multiple call.  Does not Block.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param u16CallInstance Instance of one call from multiple call possible.
     *
     * Call Instance FF means all call.  Like HangUp all calls.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAcceptCallStart(AcceptCallCallbackIF& cb, uint16 u16CallInstance);

    // Method 'CancelOutgoingCall'

    /**
     * Call the method 'CancelOutgoingCall'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'CancelOutgoingCall'</b>:
     *
     * Used to cancel an outgoing call that is not connected.  Notifications are no longer sent once a call becomes IDLE..
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param u16CallInstance Instance of one call from multiple call possible.
     *
     * Call Instance FF means all call.  Like HangUp all calls.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendCancelOutgoingCallStart(CancelOutgoingCallCallbackIF& cb, uint16 u16CallInstance);

    // Method 'ConferenceIn'

    /**
     * Call the method 'ConferenceIn'. This method sends a MethodStart message
     * to the CCA server.
     *
     * <b>Documentation of 'ConferenceIn'</b>:
     *
     * Joins or conferences in all ACTIVE, ONHOLD, and WAITING calls.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param oStreamOfCallInstances an stream of call instances , in lieu of an array
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendConferenceInStart(ConferenceInCallbackIF& cb, const ::most_Tel_fi_types::T_TelStreamOfCallInstances& oStreamOfCallInstances);

    // Method 'HangUpCall'

    /**
     * Call the method 'HangUpCall'. This method sends a MethodStart message
     * to the CCA server.
     *
     * <b>Documentation of 'HangUpCall'</b>:
     *
     * Request Termination of a call.  Also can be used iteratively for Multiple call situation.  Returns CallStatus when call is relesed from network.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param u16CallInstance Instance of one call from multiple call possible.
     * Call Instance FF means all call.  Like HangUp all calls.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendHangUpCallStart(HangUpCallCallbackIF& cb, uint16 u16CallInstance);

    // Method 'HoldCall'

    /**
     * Call the method 'HoldCall'. This method sends a MethodStart message to
     * the CCA server.
     *
     * <b>Documentation of 'HoldCall'</b>:
     *
     * Holds a voice call.  Also, Can be used  prior to ConferenceIn method.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param u16CallInstance Instance of one call from multiple call possible.
     *
     * Call Instance FF means all call.  Like HangUp all calls.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendHoldCallStart(HoldCallCallbackIF& cb, uint16 u16CallInstance);

    // Method 'IgnoreCall'

    /**
     * Call the method 'IgnoreCall'. This method sends a MethodStart message
     * to the CCA server.
     *
     * <b>Documentation of 'IgnoreCall'</b>:
     *
     * Used in F&B to send incoming call to voice mail.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param u16CallInstance Instance of one call from multiple call possible.
     *
     * Call Instance FF means all call.  Like HangUp all calls.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendIgnoreCallStart(IgnoreCallCallbackIF& cb, uint16 u16CallInstance);

    // Method 'RejectCall'

    /**
     * Call the method 'RejectCall'. This method sends a MethodStart message
     * to the CCA server.
     *
     * <b>Documentation of 'RejectCall'</b>:
     *
     * Reject an Incoming call.  Does not accept the call or sends to voice mail, request disconnection to the network. This is currently not required by HMI.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param u16CallInstance Instance of one call from multiple call possible.
     *
     * Call Instance FF means all call.  Like HangUp all calls.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendRejectCallStart(RejectCallCallbackIF& cb, uint16 u16CallInstance);

    // Method 'ResumeCall'

    /**
     * Call the method 'ResumeCall'. This method sends a MethodStart message
     * to the CCA server.
     *
     * <b>Documentation of 'ResumeCall'</b>:
     *
     * Resume a  Call on hold.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param u16CallInstance Instance of one call from multiple call possible.
     *
     * Call Instance FF means all call.  Like HangUp all calls.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendResumeCallStart(ResumeCallCallbackIF& cb, uint16 u16CallInstance);

    // Method 'SendDTMF'

    /**
     * Call the method 'SendDTMF'. This method sends a MethodStart message to
     * the CCA server.
     *
     * <b>Documentation of 'SendDTMF'</b>:
     *
     * Sends DTMF tones to the network.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param u16CallInstance Instance of one call from multiple call possible.
     *
     * Call Instance FF means all call.  Like HangUp all calls.
     *
     * @param sDTMFChar Defined as single chracter.  Restrictions of this within 0-9, and *,#, and + needs to be enforced in implementation.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSendDTMFStart(SendDTMFCallbackIF& cb, uint16 u16CallInstance, const ::fi_basetypes_most::T_String& sDTMFChar);

    // Method 'SpeedDial'

    /**
     * Call the method 'SpeedDial'. This method sends a MethodStart message to
     * the CCA server.
     *
     * <b>Documentation of 'SpeedDial'</b>:
     *
     * Dials using data from a specific location from the BT AG device.  Telephone uses ATD (number) command to originate call.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param s8MemoryDialParam digit string designating a favorite call in number
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSpeedDialStart(SpeedDialCallbackIF& cb, int8 s8MemoryDialParam);

    // Method 'SplitCall'

    /**
     * Call the method 'SplitCall'. This method sends a MethodStart message to
     * the CCA server.
     *
     * <b>Documentation of 'SplitCall'</b>:
     *
     * Separates (un_merges) call from the conference call and makes it the ACTIVE call, all calls in the conference are put on ON HOLD.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param u16CallInstance Instance of one call from multiple call possible.
     *
     * Call Instance FF means all call.  Like HangUp all calls.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSplitCallStart(SplitCallCallbackIF& cb, uint16 u16CallInstance);

    // Method 'SwapCall'

    /**
     * Call the method 'SwapCall'. This method sends a MethodStart message to
     * the CCA server.
     *
     * <b>Documentation of 'SwapCall'</b>:
     *
     * If there is an ACTIVE ( call 1)  call and a call ON HOLD ( call 2) , calls are exchanged.  After successful execution Call 1 will be ON HOLD and call 2 will be ACTIVE.  Success returns status of ACTIVE call instance.s
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param oStreamOfCallInstances an stream of call instances , in lieu of an array
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSwapCallStart(SwapCallCallbackIF& cb, const ::most_Tel_fi_types::T_TelStreamOfCallInstances& oStreamOfCallInstances);

    // Method 'TransferCallToHandset'

    /**
     * Call the method 'TransferCallToHandset'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'TransferCallToHandset'</b>:
     *
     * Called by HMI controllers to transfer all calls, ACTIVE, ON HOLD, or CONFERENCE are sent to the currently active handset device.  No call instance is used as could be multiple calls could be moved to handset.  Essentially transferring audio rather than individual call.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendTransferCallToHandsetStart(TransferCallToHandsetCallbackIF& cb);

    // Method 'TransferCallToVehicle'

    /**
     * Call the method 'TransferCallToVehicle'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'TransferCallToVehicle'</b>:
     *
     * This Method is called by HMI controllers to transfer the call from a particular device to the Vehicle.  The DeviceHandle must be a valid device handle for one of the paired phones within the Bluetooth Settings FBlock.  It may not be the protected 0=Null value.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param u8DeviceHandle Unique handle for each one of the up to 10 devices that can be paired.  Handles are maintained by BluetoothSettings FBlock.  0 is reserved as Null. Valid handles are 1..10 inclusive.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendTransferCallToVehicleStart(TransferCallToVehicleCallbackIF& cb, uint8 u8DeviceHandle);

    // Method 'VoiceMail'

    /**
     * Call the method 'VoiceMail'. This method sends a MethodStart message to
     * the CCA server.
     *
     * <b>Documentation of 'VoiceMail'</b>:
     *
     * HMI needs to know the voice mail number of the currently connected Phone.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param sDeviceName Name of the BT phone
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendVoiceMailStart(VoiceMailCallbackIF& cb, const ::fi_basetypes_most::T_String& sDeviceName);

    // Method 'Dial'

    /**
     * Call the method 'Dial'. This method sends a MethodStart message to the
     * CCA server.
     *
     * <b>Documentation of 'Dial'</b>:
     *
     * Start an outgoing call.Controllers use the CallInstance parameter
     * in the ResultAck to track the status of the call via
     * CallStatusNotice.Status notifications.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param sTelephoneNumber Phone number
     *
     * @param e8EchoCancellationNoiseReductionSetting This parameter in Dial () interface, used to set voice or server echo cancellation and noise reduction settings.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDialStart(DialCallbackIF& cb, const ::fi_basetypes_most::T_String& sTelephoneNumber, ::most_Tel_fi_types::T_e8_TelEchoCancellationNoiseReductionSetting e8EchoCancellationNoiseReductionSetting);

    // Method 'QueryTelephoneNumber'

    /**
     * Call the method 'QueryTelephoneNumber'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'QueryTelephoneNumber'</b>:
     *
     * Returns Telephone Number give a call instance.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param u16CallInstance Instance of one call from multiple call possible.
     *
     * Call Instance FF means all call.  Like HangUp all calls.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendQueryTelephoneNumberStart(QueryTelephoneNumberCallbackIF& cb, uint16 u16CallInstance);

    // Method 'AcquireTelephoneNumber'

    /**
     * Call the method 'AcquireTelephoneNumber'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'AcquireTelephoneNumber'</b>:
     *
     * The AcquireTelephoneNumber method is defined in order to allow HMI
     * controllers to receive the telephone number of a device as follows:
     *
     *
     * <item>
     * The DeviceHandle parameter in the StartResultAck contains the
     * DeviceHandle of the device for which the telephone number is requested.
     * </item>
     * <item>
     * The telephone number acquired from the device is reported as a string
     * in the TelephoneNumber parameter.
     * </item>
     * <item>
     * If the DeviceHandle is invalid or the telephone number cannot be
     * acquired from the requested device for any reason, the FBlock shall
     * respond with a ResultAck(TelephoneNumber == NULL, zero-length string).
     * HMI controllers can use the NULL TelephoneNumber in order to report to
     * the user that the telephone number could not be acquired
     * </item>
     * <item>
     * Note that the VoiceMail 0x21C function cannot be reliably used to
     * acquire the device telephone number because the user can change their
     * voice mail number to another seqence. AcquireTelephoneNumber returns,
     * if successful, the telephone number of the device.
     * </item>
     * <item>
     * This method is used, for example, to allow the HMI to automatically
     * send a text message to the outgoing source device with the ValetMode
     * PIN. However, in order to do this, the HMI needs the telephone number
     * of the device.
     * </item>
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param u8DeviceHandle Unique handle for each one of the up to 10 devices that can be paired.  Handles are maintained by BluetoothSettings FBlock.  0 is reserved as Null. Valid handles are 1..10 inclusive.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAcquireTelephoneNumberStart(AcquireTelephoneNumberCallbackIF& cb, uint8 u8DeviceHandle);

    // Method 'Redial'

    /**
     * Call the method 'Redial'. This method sends a MethodStart message to
     * the CCA server.
     *
     * <b>Documentation of 'Redial'</b>:
     *
     * deprecated
     * As of V4.3, this function is permanently deprecated and will not be supported by the Telephone FBlock by any device for the life of Next-Gen Infotainment architecture.
     *
     * For documentation purposes, this is the description from the last revision, 3.0.
     *
     * Redials the last dialed in the currently selected outgoing call device.
     * Note that this function relies on the device to choose the last dialed
     * number in that device.Controllers use the CallInstance parameter
     * in the ResultAck to track the status of the call via
     * CallStatusNotice.Status notifications.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param e8EchoCancellationNoiseReductionSetting This parameter in Dial () interface, used to set voice or server echo cancellation and noise reduction settings.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendRedialStart(RedialCallbackIF& cb, ::most_Tel_fi_types::T_e8_TelEchoCancellationNoiseReductionSetting e8EchoCancellationNoiseReductionSetting);

    // Method 'SetRingtone'

    /**
     * Call the method 'SetRingtone'. This method sends a MethodStart message
     * to the CCA server.
     *
     * <b>Documentation of 'SetRingtone'</b>:
     *
     * Set the active ringtone for system wide or device specific.
     * If the DeviceAddress string is ALL, then the received RingtoneID is set for all the paired devices
     * treating it as a system wide ringtone. The setting will be applicable also for the devices that are
     * paired after the API is invoked.
     *
     * The updated system wide ringtone will be available in the SystemWideRingtonesList property.
     * The updated device specific ringtone will be available in the DeviceRingtoneList property.
     *
     * Note: - The setting will be retained persistently by Phone F-Block
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param sBdAddress Bluetooth device address.
     *
     * @param u8RingtoneID The unique ID for each ringtone available.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSetRingtoneStart(SetRingtoneCallbackIF& cb, const ::fi_basetypes_most::T_String& sBdAddress, uint8 u8RingtoneID);

    // Method 'PlayRingtone'

    /**
     * Call the method 'PlayRingtone'. This method sends a MethodStart message
     * to the CCA server.
     *
     * <b>Documentation of 'PlayRingtone'</b>:
     *
     * Plays the selected ringtone.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param u8RingtoneID The unique ID for each ringtone available.
     *
     * @param u8PlayCount Denotes the number of times the file has to be played. When the value is set to FF, the ringtone will be played continuously.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendPlayRingtoneStart(PlayRingtoneCallbackIF& cb, uint8 u8RingtoneID, uint8 u8PlayCount);

    // Method 'StopRingtone'

    /**
     * Call the method 'StopRingtone'. This method sends a MethodStart message
     * to the CCA server.
     *
     * <b>Documentation of 'StopRingtone'</b>:
     *
     * Stops the ringtone that is currently being played.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendStopRingtoneStart(StopRingtoneCallbackIF& cb);

    // Method 'SuppressRingtoneOnOff'

    /**
     * Call the method 'SuppressRingtoneOnOff'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'SuppressRingtoneOnOff'</b>:
     *
     * Provides the ability to set the ringtone on or off in the vehicle when an incoming call is received.
     * If the DeviceAddress string is ALL, then the received setting is set for all the paired devices treating it as a system wide setting.
     * The same will be applicable also for the devices that are paired after the API is invoked.
     *
     * The updated changes will be available in the SuppressRingtoneOnOffList property.
     *
     * Note: - The setting will be retained persistently by PM
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param sBdAddress Bluetooth device address.
     *
     * @param bSuppressRingtoneState TRUE - enable suppress ringtone, FALSE - disable suppress ringtone.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSuppressRingtoneOnOffStart(SuppressRingtoneOnOffCallbackIF& cb, const ::fi_basetypes_most::T_String& sBdAddress, bool bSuppressRingtoneState);

    // Method 'AutoWaitingModeOnOff'

    /**
     * Call the method 'AutoWaitingModeOnOff'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'AutoWaitingModeOnOff'</b>:
     *
     * Provides the ability to enable or disable the auto waiting mode when an incoming call is received. When the setting is enabled,
     * an incoming call will be automatically put on waiting mode and the waiting mode tone will be heard in the far end.
     *
     * If the DeviceAddress string is ALL, then the setting is set for all the paired devices treating it as a system wide setting.
     * The setting will be applicable for the devices that are paired after the API is invoked.
     *
     * The updated changes will be available in the AutoWaitingModeOnOffList property.
     *
     * Note: - The setting will be retained persistently by PM
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param sBdAddress Bluetooth device address.
     *
     * @param bAutoWaitingModeState TRUE - enable auto waiting mode, FALSE - disable auto waiting mode.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAutoWaitingModeOnOffStart(AutoWaitingModeOnOffCallbackIF& cb, const ::fi_basetypes_most::T_String& sBdAddress, bool bAutoWaitingModeState);

    // Method 'StartStopWaitingMode'

    /**
     * Call the method 'StartStopWaitingMode'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'StartStopWaitingMode'</b>:
     *
     * This Method is used to start or stop the waiting mode.
     * Waiting mode is similar to Active call except that waiting message
     * from the provide file path is played to the remote end caller
     * instead of the Mic output.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param e8WaitingModeAction Specifies the action related to the Waiting Mode.
     * The Action can be either START or STOP.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendStartStopWaitingModeStart(StartStopWaitingModeCallbackIF& cb, ::most_Tel_fi_types_Extended::T_e8_TelWaitingModeAction e8WaitingModeAction);

    // Method 'DialExtended'

    /**
     * Call the method 'DialExtended'. This method sends a MethodStart message
     * to the CCA server.
     *
     * <b>Documentation of 'DialExtended'</b>:
     *
     * This method extends the original method Dial by the additional parameter Name. This Name can be set by the client according to its needs or can be left empty. The Name will be reported in the property CallStatusNoticeExtended beside the TelephoneNumber and the call status information.
     *
     * Start an outgoing call to the given number.
     * - The call will be started on the connected OSD phone device (Outgoing Source Device).
     * - Clients track the status of the call via CallStatusNoticeExtended.Status notifications.
     * - The provided Name will occur in the CallStatusNoticeExtended.Status notifications for the related call instance as long as the received phone number, reported from the phone device (CLIP information) still corresponds to the dialed one.
     *
     * - An Error message might be returned, if a provided parameter is invalid or similar or if the phone device does not accept the dial request.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param sTelephoneNumber Phone number
     *
     * @param sName This parameter in Dial () interface, used to set default name of the dialled phone number.
     *
     * @param e8EchoCancellationNoiseReductionSetting This parameter in Dial () interface, used to set voice or server echo cancellation and noise reduction settings.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDialExtendedStart(DialExtendedCallbackIF& cb, const ::fi_basetypes_most::T_String& sTelephoneNumber, const ::fi_basetypes_most::T_String& sName, ::most_Tel_fi_types::T_e8_TelEchoCancellationNoiseReductionSetting e8EchoCancellationNoiseReductionSetting);

    // Method 'SetActivePhone'

    /**
     * Call the method 'SetActivePhone'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'SetActivePhone'</b>:
     *
     * Method to set a device as an Active device and subsequently the active device will be made Passive.
     * After switching, ActivePhoneDevice property is updated with the Device handle of the current Active device.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param u8DeviceHandle Unique handle for each one of the up to 10 devices that can be paired.
     * Handles are maintained by BluetoothSettings FBlock.
     * 0 is reserved as Null. Valid handles are 1..10 inclusive.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSetActivePhoneStart(SetActivePhoneCallbackIF& cb, uint8 u8DeviceHandle);

    // Method 'ActivateExternalVR'

    /**
     * Call the method 'ActivateExternalVR'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'ActivateExternalVR'</b>:
     *
     * The method ActivateExternalVR would be used to activate the external VR session. The responsibilities of Phone Middleware is to:
     * a.    Allocate the VR channel.
     * b.    Stream the VR audio when the SCO channel is established.
     * The External VR state are updated to clients through the interface "ExternalVRState"
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param sBdAddress The BdAddress for which the the external voice recognition request is set.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendActivateExternalVRStart(ActivateExternalVRCallbackIF& cb, const ::fi_basetypes_most::T_String& sBdAddress);

    // Method 'DeActivateExternalVR'

    /**
     * Call the method 'DeActivateExternalVR'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'DeActivateExternalVR'</b>:
     *
     * The method DeActivateExternalVR would be used to De-activate the external VR session. The responsibilities of Phone Middleware is to:
     * a. Stop streaming the VR audio when the SCO channel is disconnected
     * b. Deallocate the VR channel.
     * The External VR state are updated to clients through the interface "ExternalVRState"
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param sBdAddress The BdAddress for which the the external voice recognition request is re-set.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDeActivateExternalVRStart(DeActivateExternalVRCallbackIF& cb, const ::fi_basetypes_most::T_String& sBdAddress);

    // Property 'SourceInfo'

    /**
     * Notify on the property 'SourceInfo'. This method sends a UpReg message
     * to the CCA server.
     *
     * <b>Documentation of 'SourceInfo'</b>:
     *
     * This property gives particulars about the type of streaming data a source can handle. If notification is used for an FBlock with multiple sources, multiple notifications will be sent when the status changes for more than one source.For further information please refer to the MOST Stream Transmission Specification Rev 3.0.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSourceInfoUpReg(SourceInfoCallbackIF& cb);

    /**
     * Remove the notifcation on property 'SourceInfo'. This method sends a
     * RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'SourceInfo'</b>:
     *
     * This property gives particulars about the type of streaming data a source can handle. If notification is used for an FBlock with multiple sources, multiple notifications will be sent when the status changes for more than one source.For further information please refer to the MOST Stream Transmission Specification Rev 3.0.
     *
     * @param act The act which was previously returned by the
     * sendSourceInfoUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendSourceInfoRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'SourceInfo'.
     */
    void sendSourceInfoRelUpRegAll ();

    /**
     * Returns the current value of the property 'SourceInfo' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when
     * hasSourceInfo() returns true.
     *
     * @return the previously received value of the property 'SourceInfo'.
     */
    const SourceInfoStatus& getSourceInfo() const;

    /**
     * Determines whether a status message for the property 'SourceInfo' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasSourceInfo() const;

    /**
     * Request the value of the property 'SourceInfo' from the CCA server.
     * This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'SourceInfo'</b>:
     *
     * This property gives particulars about the type of streaming data a source can handle. If notification is used for an FBlock with multiple sources, multiple notifications will be sent when the status changes for more than one source.For further information please refer to the MOST Stream Transmission Specification Rev 3.0.
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     * @param u8SourceNr Number of a data source (within one FBlock there can be more than one), for example, 0x01 for the first source.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSourceInfoGet(SourceInfoCallbackIF& cb, uint8 u8SourceNr);

    // Property 'SourceAvailable'

    /**
     * Notify on the property 'SourceAvailable'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'SourceAvailable'</b>:
     *
     * The SourceAvailable property can be queried by a controller to determine whether a Source is initialized and ready to produce audio or video.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSourceAvailableUpReg(SourceAvailableCallbackIF& cb);

    /**
     * Remove the notifcation on property 'SourceAvailable'. This method sends
     * a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'SourceAvailable'</b>:
     *
     * The SourceAvailable property can be queried by a controller to determine whether a Source is initialized and ready to produce audio or video.
     *
     * @param act The act which was previously returned by the
     * sendSourceAvailableUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendSourceAvailableRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'SourceAvailable'.
     */
    void sendSourceAvailableRelUpRegAll ();

    /**
     * Returns the current value of the property 'SourceAvailable' (as known
     * by the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasSourceAvailable() returns true.
     *
     * @return the previously received value of the property 'SourceAvailable'.
     */
    const SourceAvailableStatus& getSourceAvailable() const;

    /**
     * Determines whether a status message for the property 'SourceAvailable' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasSourceAvailable() const;

    /**
     * Request the value of the property 'SourceAvailable' from the CCA
     * server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'SourceAvailable'</b>:
     *
     * The SourceAvailable property can be queried by a controller to determine whether a Source is initialized and ready to produce audio or video.
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSourceAvailableGet(SourceAvailableCallbackIF& cb);

    // Property 'ActiveCallinHandset'

    /**
     * Notify on the property 'ActiveCallinHandset'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'ActiveCallinHandset'</b>:
     *
     * This Property reports whether or not there is an active call in a handset detected.  The state of the handset and its DeviceHandle (within the BluetoothSettings FBlock) are reported.  HMI controllers use the DeviceHandle to query the BluetoothSettings FBlock for additional information about the device and to potentially call the TransferCallToVehicle method to transfer the particular device's active call to the vehicle hands-free system.
     *
     * Note that it is possible that two different calls on two connected phones could be active on entry to the vehicle so this property has been defined as a Container with a ShortStream carrying the information for up to two devices.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendActiveCallinHandsetUpReg(ActiveCallinHandsetCallbackIF& cb);

    /**
     * Remove the notifcation on property 'ActiveCallinHandset'. This method
     * sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'ActiveCallinHandset'</b>:
     *
     * This Property reports whether or not there is an active call in a handset detected.  The state of the handset and its DeviceHandle (within the BluetoothSettings FBlock) are reported.  HMI controllers use the DeviceHandle to query the BluetoothSettings FBlock for additional information about the device and to potentially call the TransferCallToVehicle method to transfer the particular device's active call to the vehicle hands-free system.
     *
     * Note that it is possible that two different calls on two connected phones could be active on entry to the vehicle so this property has been defined as a Container with a ShortStream carrying the information for up to two devices.
     *
     * @param act The act which was previously returned by the
     * sendActiveCallinHandsetUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendActiveCallinHandsetRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'ActiveCallinHandset'.
     */
    void sendActiveCallinHandsetRelUpRegAll ();

    /**
     * Returns the current value of the property 'ActiveCallinHandset' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasActiveCallinHandset() returns true.
     *
     * @return the previously received value of the property 'ActiveCallinHandset'.
     */
    const ActiveCallinHandsetStatus& getActiveCallinHandset() const;

    /**
     * Determines whether a status message for the property 'ActiveCallinHandset' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasActiveCallinHandset() const;

    /**
     * Request the value of the property 'ActiveCallinHandset' from the CCA
     * server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'ActiveCallinHandset'</b>:
     *
     * This Property reports whether or not there is an active call in a handset detected.  The state of the handset and its DeviceHandle (within the BluetoothSettings FBlock) are reported.  HMI controllers use the DeviceHandle to query the BluetoothSettings FBlock for additional information about the device and to potentially call the TransferCallToVehicle method to transfer the particular device's active call to the vehicle hands-free system.
     *
     * Note that it is possible that two different calls on two connected phones could be active on entry to the vehicle so this property has been defined as a Container with a ShortStream carrying the information for up to two devices.
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendActiveCallinHandsetGet(ActiveCallinHandsetCallbackIF& cb);

    // Property 'CallStatusNotice'

    /**
     * Notify on the property 'CallStatusNotice'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'CallStatusNotice'</b>:
     *
     * Other component can get status of a CallInstance using this notification.
     * Telephone component notifies when a status changes , and ends status
     * update when the CallStatus becomes IDLE. Needs valid Callinstance.
     * Callinstances are created on an incoming call event or an outgoing call
     * request.IMPORTANT: When there are no calls currently active, the
     * Status response of this property cannot be an empty stream as an empty
     * payload MHP message is incompatible with the current (as of this release)
     * implemenation of NetServices. Instead, when no calls are active, the
     * following &quot;null&quot; Status response shall be returned:
     *
     *
     * <item>
     * CallInstance = 0xFF
     * </item>
     * <item>
     * CallStatus = IDLE
     * </item>
     * <item>
     * UsingVehicleAudio = False
     * </item>
     * <item>
     * CallDurationXX = 0
     * </item>
     * <item>
     * DeviceHandle=0xFF
     * </item>
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendCallStatusNoticeUpReg(CallStatusNoticeCallbackIF& cb);

    /**
     * Remove the notifcation on property 'CallStatusNotice'. This method
     * sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'CallStatusNotice'</b>:
     *
     * Other component can get status of a CallInstance using this notification.
     * Telephone component notifies when a status changes , and ends status
     * update when the CallStatus becomes IDLE. Needs valid Callinstance.
     * Callinstances are created on an incoming call event or an outgoing call
     * request.IMPORTANT: When there are no calls currently active, the
     * Status response of this property cannot be an empty stream as an empty
     * payload MHP message is incompatible with the current (as of this release)
     * implemenation of NetServices. Instead, when no calls are active, the
     * following &quot;null&quot; Status response shall be returned:
     *
     *
     * <item>
     * CallInstance = 0xFF
     * </item>
     * <item>
     * CallStatus = IDLE
     * </item>
     * <item>
     * UsingVehicleAudio = False
     * </item>
     * <item>
     * CallDurationXX = 0
     * </item>
     * <item>
     * DeviceHandle=0xFF
     * </item>
     *
     * @param act The act which was previously returned by the
     * sendCallStatusNoticeUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendCallStatusNoticeRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'CallStatusNotice'.
     */
    void sendCallStatusNoticeRelUpRegAll ();

    /**
     * Returns the current value of the property 'CallStatusNotice' (as known
     * by the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasCallStatusNotice() returns true.
     *
     * @return the previously received value of the property 'CallStatusNotice'.
     */
    const CallStatusNoticeStatus& getCallStatusNotice() const;

    /**
     * Determines whether a status message for the property 'CallStatusNotice' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasCallStatusNotice() const;

    /**
     * Request the value of the property 'CallStatusNotice' from the CCA
     * server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'CallStatusNotice'</b>:
     *
     * Other component can get status of a CallInstance using this notification.
     * Telephone component notifies when a status changes , and ends status
     * update when the CallStatus becomes IDLE. Needs valid Callinstance.
     * Callinstances are created on an incoming call event or an outgoing call
     * request.IMPORTANT: When there are no calls currently active, the
     * Status response of this property cannot be an empty stream as an empty
     * payload MHP message is incompatible with the current (as of this release)
     * implemenation of NetServices. Instead, when no calls are active, the
     * following &quot;null&quot; Status response shall be returned:
     *
     *
     * <item>
     * CallInstance = 0xFF
     * </item>
     * <item>
     * CallStatus = IDLE
     * </item>
     * <item>
     * UsingVehicleAudio = False
     * </item>
     * <item>
     * CallDurationXX = 0
     * </item>
     * <item>
     * DeviceHandle=0xFF
     * </item>
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendCallStatusNoticeGet(CallStatusNoticeCallbackIF& cb);

    // Property 'CellDeviceName'

    /**
     * Notify on the property 'CellDeviceName'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'CellDeviceName'</b>:
     *
     * Returns Device name of the current active hands free device.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendCellDeviceNameUpReg(CellDeviceNameCallbackIF& cb);

    /**
     * Remove the notifcation on property 'CellDeviceName'. This method sends
     * a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'CellDeviceName'</b>:
     *
     * Returns Device name of the current active hands free device.
     *
     * @param act The act which was previously returned by the
     * sendCellDeviceNameUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendCellDeviceNameRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'CellDeviceName'.
     */
    void sendCellDeviceNameRelUpRegAll ();

    /**
     * Returns the current value of the property 'CellDeviceName' (as known by
     * the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasCellDeviceName() returns true.
     *
     * @return the previously received value of the property 'CellDeviceName'.
     */
    const CellDeviceNameStatus& getCellDeviceName() const;

    /**
     * Determines whether a status message for the property 'CellDeviceName' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasCellDeviceName() const;

    /**
     * Request the value of the property 'CellDeviceName' from the CCA server.
     * This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'CellDeviceName'</b>:
     *
     * Returns Device name of the current active hands free device.
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendCellDeviceNameGet(CellDeviceNameCallbackIF& cb);

    // Property 'CellNetworkStatus'

    /**
     * Notify on the property 'CellNetworkStatus'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'CellNetworkStatus'</b>:
     *
     * Connectivity status of the cell network.  This is a notification since, network could be lost anytime.  Includes roaming true or false.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendCellNetworkStatusUpReg(CellNetworkStatusCallbackIF& cb);

    /**
     * Remove the notifcation on property 'CellNetworkStatus'. This method
     * sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'CellNetworkStatus'</b>:
     *
     * Connectivity status of the cell network.  This is a notification since, network could be lost anytime.  Includes roaming true or false.
     *
     * @param act The act which was previously returned by the
     * sendCellNetworkStatusUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendCellNetworkStatusRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'CellNetworkStatus'.
     */
    void sendCellNetworkStatusRelUpRegAll ();

    /**
     * Returns the current value of the property 'CellNetworkStatus' (as known
     * by the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasCellNetworkStatus() returns true.
     *
     * @return the previously received value of the property 'CellNetworkStatus'.
     */
    const CellNetworkStatusStatus& getCellNetworkStatus() const;

    /**
     * Determines whether a status message for the property 'CellNetworkStatus' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasCellNetworkStatus() const;

    /**
     * Request the value of the property 'CellNetworkStatus' from the CCA
     * server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'CellNetworkStatus'</b>:
     *
     * Connectivity status of the cell network.  This is a notification since, network could be lost anytime.  Includes roaming true or false.
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendCellNetworkStatusGet(CellNetworkStatusCallbackIF& cb);

    // Property 'CellSignalStrength'

    /**
     * Notify on the property 'CellSignalStrength'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'CellSignalStrength'</b>:
     *
     * Even though this changes continually, it is exchanged as discrete parameters. Divide range to 5 indents.This is a notification since the signal strength can change.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendCellSignalStrengthUpReg(CellSignalStrengthCallbackIF& cb);

    /**
     * Remove the notifcation on property 'CellSignalStrength'. This method
     * sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'CellSignalStrength'</b>:
     *
     * Even though this changes continually, it is exchanged as discrete parameters. Divide range to 5 indents.This is a notification since the signal strength can change.
     *
     * @param act The act which was previously returned by the
     * sendCellSignalStrengthUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendCellSignalStrengthRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'CellSignalStrength'.
     */
    void sendCellSignalStrengthRelUpRegAll ();

    /**
     * Returns the current value of the property 'CellSignalStrength' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasCellSignalStrength() returns true.
     *
     * @return the previously received value of the property 'CellSignalStrength'.
     */
    const CellSignalStrengthStatus& getCellSignalStrength() const;

    /**
     * Determines whether a status message for the property 'CellSignalStrength' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasCellSignalStrength() const;

    /**
     * Request the value of the property 'CellSignalStrength' from the CCA
     * server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'CellSignalStrength'</b>:
     *
     * Even though this changes continually, it is exchanged as discrete parameters. Divide range to 5 indents.This is a notification since the signal strength can change.
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendCellSignalStrengthGet(CellSignalStrengthCallbackIF& cb);

    // Property 'CellStateofCharge'

    /**
     * Notify on the property 'CellStateofCharge'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'CellStateofCharge'</b>:
     *
     * The CellStateOfCharge Property contains the current cell phone charge status from 1 to 5.  HMI controllers register for notification on this property to receive changes in the cell phone state of charge.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendCellStateofChargeUpReg(CellStateofChargeCallbackIF& cb);

    /**
     * Remove the notifcation on property 'CellStateofCharge'. This method
     * sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'CellStateofCharge'</b>:
     *
     * The CellStateOfCharge Property contains the current cell phone charge status from 1 to 5.  HMI controllers register for notification on this property to receive changes in the cell phone state of charge.
     *
     * @param act The act which was previously returned by the
     * sendCellStateofChargeUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendCellStateofChargeRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'CellStateofCharge'.
     */
    void sendCellStateofChargeRelUpRegAll ();

    /**
     * Returns the current value of the property 'CellStateofCharge' (as known
     * by the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasCellStateofCharge() returns true.
     *
     * @return the previously received value of the property 'CellStateofCharge'.
     */
    const CellStateofChargeStatus& getCellStateofCharge() const;

    /**
     * Determines whether a status message for the property 'CellStateofCharge' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasCellStateofCharge() const;

    /**
     * Request the value of the property 'CellStateofCharge' from the CCA
     * server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'CellStateofCharge'</b>:
     *
     * The CellStateOfCharge Property contains the current cell phone charge status from 1 to 5.  HMI controllers register for notification on this property to receive changes in the cell phone state of charge.
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendCellStateofChargeGet(CellStateofChargeCallbackIF& cb);

    // Property 'InComingCallEvent'

    /**
     * Notify on the property 'InComingCallEvent'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'InComingCallEvent'</b>:
     *
     * This notifies HMI when an incoming call arrives.  HMI needs to subscribe on this interface during initialization.  Once subscribed it does not expire untill cleared using notification interface..
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendInComingCallEventUpReg(InComingCallEventCallbackIF& cb);

    /**
     * Remove the notifcation on property 'InComingCallEvent'. This method
     * sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'InComingCallEvent'</b>:
     *
     * This notifies HMI when an incoming call arrives.  HMI needs to subscribe on this interface during initialization.  Once subscribed it does not expire untill cleared using notification interface..
     *
     * @param act The act which was previously returned by the
     * sendInComingCallEventUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendInComingCallEventRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'InComingCallEvent'.
     */
    void sendInComingCallEventRelUpRegAll ();

    /**
     * Returns the current value of the property 'InComingCallEvent' (as known
     * by the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasInComingCallEvent() returns true.
     *
     * @return the previously received value of the property 'InComingCallEvent'.
     */
    const InComingCallEventStatus& getInComingCallEvent() const;

    /**
     * Determines whether a status message for the property 'InComingCallEvent' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasInComingCallEvent() const;

    /**
     * Request the value of the property 'InComingCallEvent' from the CCA
     * server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'InComingCallEvent'</b>:
     *
     * This notifies HMI when an incoming call arrives.  HMI needs to subscribe on this interface during initialization.  Once subscribed it does not expire untill cleared using notification interface..
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendInComingCallEventGet(InComingCallEventCallbackIF& cb);

    // Property 'NetworkOperator'

    /**
     * Notify on the property 'NetworkOperator'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'NetworkOperator'</b>:
     *
     * Used by HMI to get the name of the cell network operator.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendNetworkOperatorUpReg(NetworkOperatorCallbackIF& cb);

    /**
     * Remove the notifcation on property 'NetworkOperator'. This method sends
     * a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'NetworkOperator'</b>:
     *
     * Used by HMI to get the name of the cell network operator.
     *
     * @param act The act which was previously returned by the
     * sendNetworkOperatorUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendNetworkOperatorRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'NetworkOperator'.
     */
    void sendNetworkOperatorRelUpRegAll ();

    /**
     * Returns the current value of the property 'NetworkOperator' (as known
     * by the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasNetworkOperator() returns true.
     *
     * @return the previously received value of the property 'NetworkOperator'.
     */
    const NetworkOperatorStatus& getNetworkOperator() const;

    /**
     * Determines whether a status message for the property 'NetworkOperator' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasNetworkOperator() const;

    /**
     * Request the value of the property 'NetworkOperator' from the CCA
     * server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'NetworkOperator'</b>:
     *
     * Used by HMI to get the name of the cell network operator.
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendNetworkOperatorGet(NetworkOperatorCallbackIF& cb);

    // Property 'SLCStatus'

    /**
     * Notify on the property 'SLCStatus'. This method sends a UpReg message
     * to the CCA server.
     *
     * <b>Documentation of 'SLCStatus'</b>:
     *
     * Returns Blue tooth Serial Link Connection status.  HMI needs to to tell if call dropped due to SLC lost.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSLCStatusUpReg(SLCStatusCallbackIF& cb);

    /**
     * Remove the notifcation on property 'SLCStatus'. This method sends a
     * RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'SLCStatus'</b>:
     *
     * Returns Blue tooth Serial Link Connection status.  HMI needs to to tell if call dropped due to SLC lost.
     *
     * @param act The act which was previously returned by the
     * sendSLCStatusUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendSLCStatusRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'SLCStatus'.
     */
    void sendSLCStatusRelUpRegAll ();

    /**
     * Returns the current value of the property 'SLCStatus' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when hasSLCStatus()
     * returns true.
     *
     * @return the previously received value of the property 'SLCStatus'.
     */
    const SLCStatusStatus& getSLCStatus() const;

    /**
     * Determines whether a status message for the property 'SLCStatus' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasSLCStatus() const;

    /**
     * Request the value of the property 'SLCStatus' from the CCA server. This
     * method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'SLCStatus'</b>:
     *
     * Returns Blue tooth Serial Link Connection status.  HMI needs to to tell if call dropped due to SLC lost.
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSLCStatusGet(SLCStatusCallbackIF& cb);

    // Property 'VehicleAudio'

    /**
     * Notify on the property 'VehicleAudio'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'VehicleAudio'</b>:
     *
     * May be needed by Audio Video, who is using Audio.  If the Telephone FBlock does not hold any Audio channel set it to FALSE,  If it holds an audio channel, set it to TRUE.
     * in 1.4.1 made it a notification
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendVehicleAudioUpReg(VehicleAudioCallbackIF& cb);

    /**
     * Remove the notifcation on property 'VehicleAudio'. This method sends a
     * RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'VehicleAudio'</b>:
     *
     * May be needed by Audio Video, who is using Audio.  If the Telephone FBlock does not hold any Audio channel set it to FALSE,  If it holds an audio channel, set it to TRUE.
     * in 1.4.1 made it a notification
     *
     * @param act The act which was previously returned by the
     * sendVehicleAudioUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendVehicleAudioRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'VehicleAudio'.
     */
    void sendVehicleAudioRelUpRegAll ();

    /**
     * Returns the current value of the property 'VehicleAudio' (as known by
     * the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasVehicleAudio() returns true.
     *
     * @return the previously received value of the property 'VehicleAudio'.
     */
    const VehicleAudioStatus& getVehicleAudio() const;

    /**
     * Determines whether a status message for the property 'VehicleAudio' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasVehicleAudio() const;

    /**
     * Request the value of the property 'VehicleAudio' from the CCA server.
     * This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'VehicleAudio'</b>:
     *
     * May be needed by Audio Video, who is using Audio.  If the Telephone FBlock does not hold any Audio channel set it to FALSE,  If it holds an audio channel, set it to TRUE.
     * in 1.4.1 made it a notification
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendVehicleAudioGet(VehicleAudioCallbackIF& cb);

    // Property 'MicrophoneMuteState'

    /**
     * Notify on the property 'MicrophoneMuteState'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'MicrophoneMuteState'</b>:
     *
     * The MicrophoneMuteState Property allows HMI controllers to mute the Telephone microphone and synchronize HMI presentation to the mute state.  Note that although this function may seem to be redundant to the ISink.Mute function also on the Telphone FBlock, ISink.Mute is not intended to be manipulated by HMI controllers.  HMI controllers should use MicrophoneMuteState instead.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendMicrophoneMuteStateUpReg(MicrophoneMuteStateCallbackIF& cb);

    /**
     * Remove the notifcation on property 'MicrophoneMuteState'. This method
     * sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'MicrophoneMuteState'</b>:
     *
     * The MicrophoneMuteState Property allows HMI controllers to mute the Telephone microphone and synchronize HMI presentation to the mute state.  Note that although this function may seem to be redundant to the ISink.Mute function also on the Telphone FBlock, ISink.Mute is not intended to be manipulated by HMI controllers.  HMI controllers should use MicrophoneMuteState instead.
     *
     * @param act The act which was previously returned by the
     * sendMicrophoneMuteStateUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendMicrophoneMuteStateRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'MicrophoneMuteState'.
     */
    void sendMicrophoneMuteStateRelUpRegAll ();

    /**
     * Returns the current value of the property 'MicrophoneMuteState' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasMicrophoneMuteState() returns true.
     *
     * @return the previously received value of the property 'MicrophoneMuteState'.
     */
    const MicrophoneMuteStateStatus& getMicrophoneMuteState() const;

    /**
     * Determines whether a status message for the property 'MicrophoneMuteState' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasMicrophoneMuteState() const;

    /**
     * Request the value of the property 'MicrophoneMuteState' from the CCA
     * server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'MicrophoneMuteState'</b>:
     *
     * The MicrophoneMuteState Property allows HMI controllers to mute the Telephone microphone and synchronize HMI presentation to the mute state.  Note that although this function may seem to be redundant to the ISink.Mute function also on the Telphone FBlock, ISink.Mute is not intended to be manipulated by HMI controllers.  HMI controllers should use MicrophoneMuteState instead.
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendMicrophoneMuteStateGet(MicrophoneMuteStateCallbackIF& cb);

    /**
     * Set the value of the property 'MicrophoneMuteState'. This method sends
     * a PureSet message to the CCA server.
     *
     * <b>Documentation of 'MicrophoneMuteState'</b>:
     *
     * The MicrophoneMuteState Property allows HMI controllers to mute the Telephone microphone and synchronize HMI presentation to the mute state.  Note that although this function may seem to be redundant to the ISink.Mute function also on the Telphone FBlock, ISink.Mute is not intended to be manipulated by HMI controllers.  HMI controllers should use MicrophoneMuteState instead.
     *
     * @param bEnable Service enanble flag.
     */

    void sendMicrophoneMuteStatePureSet(bool bEnable);

    // Property 'RingtoneMuteState'

    /**
     * Notify on the property 'RingtoneMuteState'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'RingtoneMuteState'</b>:
     *
     * The RingtoneMuteState Property allows HMI controllers to mute the ring tone from the telephone synchronize ther HMI presentation to the mute state.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendRingtoneMuteStateUpReg(RingtoneMuteStateCallbackIF& cb);

    /**
     * Remove the notifcation on property 'RingtoneMuteState'. This method
     * sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'RingtoneMuteState'</b>:
     *
     * The RingtoneMuteState Property allows HMI controllers to mute the ring tone from the telephone synchronize ther HMI presentation to the mute state.
     *
     * @param act The act which was previously returned by the
     * sendRingtoneMuteStateUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendRingtoneMuteStateRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'RingtoneMuteState'.
     */
    void sendRingtoneMuteStateRelUpRegAll ();

    /**
     * Returns the current value of the property 'RingtoneMuteState' (as known
     * by the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasRingtoneMuteState() returns true.
     *
     * @return the previously received value of the property 'RingtoneMuteState'.
     */
    const RingtoneMuteStateStatus& getRingtoneMuteState() const;

    /**
     * Determines whether a status message for the property 'RingtoneMuteState' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasRingtoneMuteState() const;

    /**
     * Request the value of the property 'RingtoneMuteState' from the CCA
     * server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'RingtoneMuteState'</b>:
     *
     * The RingtoneMuteState Property allows HMI controllers to mute the ring tone from the telephone synchronize ther HMI presentation to the mute state.
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendRingtoneMuteStateGet(RingtoneMuteStateCallbackIF& cb);

    /**
     * Set the value of the property 'RingtoneMuteState'. This method sends a
     * PureSet message to the CCA server.
     *
     * <b>Documentation of 'RingtoneMuteState'</b>:
     *
     * The RingtoneMuteState Property allows HMI controllers to mute the ring tone from the telephone synchronize ther HMI presentation to the mute state.
     *
     * @param bEnable Service enanble flag.
     */

    void sendRingtoneMuteStatePureSet(bool bEnable);

    // Property 'HFService'

    /**
     * Notify on the property 'HFService'. This method sends a UpReg message
     * to the CCA server.
     *
     * <b>Documentation of 'HFService'</b>:
     *
     * This property is fetched from AG and notified upon connection to a phone device so that HMI could properly display Call waiting and Three way calling service availability.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendHFServiceUpReg(HFServiceCallbackIF& cb);

    /**
     * Remove the notifcation on property 'HFService'. This method sends a
     * RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'HFService'</b>:
     *
     * This property is fetched from AG and notified upon connection to a phone device so that HMI could properly display Call waiting and Three way calling service availability.
     *
     * @param act The act which was previously returned by the
     * sendHFServiceUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendHFServiceRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'HFService'.
     */
    void sendHFServiceRelUpRegAll ();

    /**
     * Returns the current value of the property 'HFService' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when hasHFService()
     * returns true.
     *
     * @return the previously received value of the property 'HFService'.
     */
    const HFServiceStatus& getHFService() const;

    /**
     * Determines whether a status message for the property 'HFService' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasHFService() const;

    /**
     * Request the value of the property 'HFService' from the CCA server. This
     * method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'HFService'</b>:
     *
     * This property is fetched from AG and notified upon connection to a phone device so that HMI could properly display Call waiting and Three way calling service availability.
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendHFServiceGet(HFServiceCallbackIF& cb);

    // Property 'BTDeviceVoiceRecognition'

    /**
     * Notify on the property 'BTDeviceVoiceRecognition'. This method sends a
     * UpReg message to the CCA server.
     *
     * <b>Documentation of 'BTDeviceVoiceRecognition'</b>:
     *
     * This property is used to activate and deactive the remote device's
     * internal voice recognition that may be used, for example, to also perform
     * 'cloud-based' voice recognition on the Internet as follows:
     *
     *
     * <item>
     * HMI controllers register for notification on this property at
     * initialization.
     * </item>
     * <item>
     * HMI controllers activate this property via a Set(ACTIVE) message.
     * </item>
     * <item>
     * Upon receipt of a Set(ACTIVE), the FBlock either:
     *
     *
     * </item><item>
     * Activates the remote device VR if supported by the device and
     * responds with a Status(ACTIVE) notification to all registered
     * controllers, or
     * </item>
     * <item>
     * If for any reason, the remote device VR cannot be activated in
     * response to the Set, the FBlock issues another Status(INACTIVE) to
     * all registered controllers. Note that the FBlock does NOT issue an
     * Error message if remote VR is not supported by the device.
     * </item>
     *
     * <item>The BTDeviceVoiceRecSupported flag reports whether or not the current outgoing source device supports remote Bluetooth device voice rec or not.
     * </item>
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendBTDeviceVoiceRecognitionUpReg(BTDeviceVoiceRecognitionCallbackIF& cb);

    /**
     * Remove the notifcation on property 'BTDeviceVoiceRecognition'. This
     * method sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'BTDeviceVoiceRecognition'</b>:
     *
     * This property is used to activate and deactive the remote device's
     * internal voice recognition that may be used, for example, to also perform
     * 'cloud-based' voice recognition on the Internet as follows:
     *
     *
     * <item>
     * HMI controllers register for notification on this property at
     * initialization.
     * </item>
     * <item>
     * HMI controllers activate this property via a Set(ACTIVE) message.
     * </item>
     * <item>
     * Upon receipt of a Set(ACTIVE), the FBlock either:
     *
     *
     * </item><item>
     * Activates the remote device VR if supported by the device and
     * responds with a Status(ACTIVE) notification to all registered
     * controllers, or
     * </item>
     * <item>
     * If for any reason, the remote device VR cannot be activated in
     * response to the Set, the FBlock issues another Status(INACTIVE) to
     * all registered controllers. Note that the FBlock does NOT issue an
     * Error message if remote VR is not supported by the device.
     * </item>
     *
     * <item>The BTDeviceVoiceRecSupported flag reports whether or not the current outgoing source device supports remote Bluetooth device voice rec or not.
     * </item>
     *
     * @param act The act which was previously returned by the
     * sendBTDeviceVoiceRecognitionUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendBTDeviceVoiceRecognitionRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'BTDeviceVoiceRecognition'.
     */
    void sendBTDeviceVoiceRecognitionRelUpRegAll ();

    /**
     * Returns the current value of the property 'BTDeviceVoiceRecognition'
     * (as known by the proxy). This method is only allowed to be called when
     * a status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasBTDeviceVoiceRecognition() returns true.
     *
     * @return the previously received value of the property 'BTDeviceVoiceRecognition'.
     */
    const BTDeviceVoiceRecognitionStatus& getBTDeviceVoiceRecognition() const;

    /**
     * Determines whether a status message for the property 'BTDeviceVoiceRecognition' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasBTDeviceVoiceRecognition() const;

    /**
     * Request the value of the property 'BTDeviceVoiceRecognition' from the
     * CCA server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'BTDeviceVoiceRecognition'</b>:
     *
     * This property is used to activate and deactive the remote device's
     * internal voice recognition that may be used, for example, to also perform
     * 'cloud-based' voice recognition on the Internet as follows:
     *
     *
     * <item>
     * HMI controllers register for notification on this property at
     * initialization.
     * </item>
     * <item>
     * HMI controllers activate this property via a Set(ACTIVE) message.
     * </item>
     * <item>
     * Upon receipt of a Set(ACTIVE), the FBlock either:
     *
     *
     * </item><item>
     * Activates the remote device VR if supported by the device and
     * responds with a Status(ACTIVE) notification to all registered
     * controllers, or
     * </item>
     * <item>
     * If for any reason, the remote device VR cannot be activated in
     * response to the Set, the FBlock issues another Status(INACTIVE) to
     * all registered controllers. Note that the FBlock does NOT issue an
     * Error message if remote VR is not supported by the device.
     * </item>
     *
     * <item>The BTDeviceVoiceRecSupported flag reports whether or not the current outgoing source device supports remote Bluetooth device voice rec or not.
     * </item>
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendBTDeviceVoiceRecognitionGet(BTDeviceVoiceRecognitionCallbackIF& cb);

    /**
     * Set the value of the property 'BTDeviceVoiceRecognition'. This method
     * sends a PureSet message to the CCA server.
     *
     * <b>Documentation of 'BTDeviceVoiceRecognition'</b>:
     *
     * This property is used to activate and deactive the remote device's
     * internal voice recognition that may be used, for example, to also perform
     * 'cloud-based' voice recognition on the Internet as follows:
     *
     *
     * <item>
     * HMI controllers register for notification on this property at
     * initialization.
     * </item>
     * <item>
     * HMI controllers activate this property via a Set(ACTIVE) message.
     * </item>
     * <item>
     * Upon receipt of a Set(ACTIVE), the FBlock either:
     *
     *
     * </item><item>
     * Activates the remote device VR if supported by the device and
     * responds with a Status(ACTIVE) notification to all registered
     * controllers, or
     * </item>
     * <item>
     * If for any reason, the remote device VR cannot be activated in
     * response to the Set, the FBlock issues another Status(INACTIVE) to
     * all registered controllers. Note that the FBlock does NOT issue an
     * Error message if remote VR is not supported by the device.
     * </item>
     *
     * <item>The BTDeviceVoiceRecSupported flag reports whether or not the current outgoing source device supports remote Bluetooth device voice rec or not.
     * </item>
     *
     * @param bBTDeviceVoiceRecActive The state of the remote Bluetooth device voice recognition.  This parameter shall be set to False at initialization default.
     */

    void sendBTDeviceVoiceRecognitionPureSet(bool bBTDeviceVoiceRecActive);

    // Property 'HandsFreeEnhancedCallControl'

    /**
     * Notify on the property 'HandsFreeEnhancedCallControl'. This method
     * sends a UpReg message to the CCA server.
     *
     * <b>Documentation of 'HandsFreeEnhancedCallControl'</b>:
     *
     * The HandsFreeEnhancedCallControl property is defined in order to allow HMI
     * controllers to know whether or not a particular phone device supports
     * enhanced call control features such as unmerging a conference call or
     * ending an individual call within a conference call as follows:
     *
     *
     * <item>
     * HMI controllers shall register for notification of the
     * HFEnhancedCallControl property at initialization.
     * </item>
     * <item>
     * The HFEnhancedCallControl property shall support two Boolean
     * parameters, EndTargetCall and SplitMergeCalls that shall be set
     * according to the following table:
     *
     * </item>
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendHandsFreeEnhancedCallControlUpReg(HandsFreeEnhancedCallControlCallbackIF& cb);

    /**
     * Remove the notifcation on property 'HandsFreeEnhancedCallControl'. This
     * method sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'HandsFreeEnhancedCallControl'</b>:
     *
     * The HandsFreeEnhancedCallControl property is defined in order to allow HMI
     * controllers to know whether or not a particular phone device supports
     * enhanced call control features such as unmerging a conference call or
     * ending an individual call within a conference call as follows:
     *
     *
     * <item>
     * HMI controllers shall register for notification of the
     * HFEnhancedCallControl property at initialization.
     * </item>
     * <item>
     * The HFEnhancedCallControl property shall support two Boolean
     * parameters, EndTargetCall and SplitMergeCalls that shall be set
     * according to the following table:
     *
     * </item>
     *
     * @param act The act which was previously returned by the
     * sendHandsFreeEnhancedCallControlUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendHandsFreeEnhancedCallControlRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'HandsFreeEnhancedCallControl'.
     */
    void sendHandsFreeEnhancedCallControlRelUpRegAll ();

    /**
     * Returns the current value of the property
     * 'HandsFreeEnhancedCallControl' (as known by the proxy). This method is
     * only allowed to be called when a status message for this property was
     * received before. Otherwise the behavior of this method is undefined. It
     * is safe to call this method when hasHandsFreeEnhancedCallControl()
     * returns true.
     *
     * @return the previously received value of the property 'HandsFreeEnhancedCallControl'.
     */
    const HandsFreeEnhancedCallControlStatus& getHandsFreeEnhancedCallControl() const;

    /**
     * Determines whether a status message for the property 'HandsFreeEnhancedCallControl' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasHandsFreeEnhancedCallControl() const;

    /**
     * Request the value of the property 'HandsFreeEnhancedCallControl' from
     * the CCA server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'HandsFreeEnhancedCallControl'</b>:
     *
     * The HandsFreeEnhancedCallControl property is defined in order to allow HMI
     * controllers to know whether or not a particular phone device supports
     * enhanced call control features such as unmerging a conference call or
     * ending an individual call within a conference call as follows:
     *
     *
     * <item>
     * HMI controllers shall register for notification of the
     * HFEnhancedCallControl property at initialization.
     * </item>
     * <item>
     * The HFEnhancedCallControl property shall support two Boolean
     * parameters, EndTargetCall and SplitMergeCalls that shall be set
     * according to the following table:
     *
     * </item>
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendHandsFreeEnhancedCallControlGet(HandsFreeEnhancedCallControlCallbackIF& cb);

    // Property 'SystemWideRingtonesList'

    /**
     * Notify on the property 'SystemWideRingtonesList'. This method sends a
     * UpReg message to the CCA server.
     *
     * <b>Documentation of 'SystemWideRingtonesList'</b>:
     *
     * Provides the system wide ringtone list with the currently selected ringtone.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSystemWideRingtonesListUpReg(SystemWideRingtonesListCallbackIF& cb);

    /**
     * Remove the notifcation on property 'SystemWideRingtonesList'. This
     * method sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'SystemWideRingtonesList'</b>:
     *
     * Provides the system wide ringtone list with the currently selected ringtone.
     *
     * @param act The act which was previously returned by the
     * sendSystemWideRingtonesListUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendSystemWideRingtonesListRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'SystemWideRingtonesList'.
     */
    void sendSystemWideRingtonesListRelUpRegAll ();

    /**
     * Returns the current value of the property 'SystemWideRingtonesList' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasSystemWideRingtonesList() returns true.
     *
     * @return the previously received value of the property 'SystemWideRingtonesList'.
     */
    const SystemWideRingtonesListStatus& getSystemWideRingtonesList() const;

    /**
     * Determines whether a status message for the property 'SystemWideRingtonesList' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasSystemWideRingtonesList() const;

    /**
     * Request the value of the property 'SystemWideRingtonesList' from the
     * CCA server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'SystemWideRingtonesList'</b>:
     *
     * Provides the system wide ringtone list with the currently selected ringtone.
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSystemWideRingtonesListGet(SystemWideRingtonesListCallbackIF& cb);

    // Property 'DeviceRingtoneList'

    /**
     * Notify on the property 'DeviceRingtoneList'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'DeviceRingtoneList'</b>:
     *
     * Provides a list of each paired phones with its currently selected ringtone.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDeviceRingtoneListUpReg(DeviceRingtoneListCallbackIF& cb);

    /**
     * Remove the notifcation on property 'DeviceRingtoneList'. This method
     * sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'DeviceRingtoneList'</b>:
     *
     * Provides a list of each paired phones with its currently selected ringtone.
     *
     * @param act The act which was previously returned by the
     * sendDeviceRingtoneListUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendDeviceRingtoneListRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'DeviceRingtoneList'.
     */
    void sendDeviceRingtoneListRelUpRegAll ();

    /**
     * Returns the current value of the property 'DeviceRingtoneList' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasDeviceRingtoneList() returns true.
     *
     * @return the previously received value of the property 'DeviceRingtoneList'.
     */
    const DeviceRingtoneListStatus& getDeviceRingtoneList() const;

    /**
     * Determines whether a status message for the property 'DeviceRingtoneList' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasDeviceRingtoneList() const;

    /**
     * Request the value of the property 'DeviceRingtoneList' from the CCA
     * server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'DeviceRingtoneList'</b>:
     *
     * Provides a list of each paired phones with its currently selected ringtone.
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDeviceRingtoneListGet(DeviceRingtoneListCallbackIF& cb);

    // Property 'SuppressRingtoneOnOffList'

    /**
     * Notify on the property 'SuppressRingtoneOnOffList'. This method sends a
     * UpReg message to the CCA server.
     *
     * <b>Documentation of 'SuppressRingtoneOnOffList'</b>:
     *
     * Provides a list of each paired phones with its current suppress ringtone state.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSuppressRingtoneOnOffListUpReg(SuppressRingtoneOnOffListCallbackIF& cb);

    /**
     * Remove the notifcation on property 'SuppressRingtoneOnOffList'. This
     * method sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'SuppressRingtoneOnOffList'</b>:
     *
     * Provides a list of each paired phones with its current suppress ringtone state.
     *
     * @param act The act which was previously returned by the
     * sendSuppressRingtoneOnOffListUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendSuppressRingtoneOnOffListRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'SuppressRingtoneOnOffList'.
     */
    void sendSuppressRingtoneOnOffListRelUpRegAll ();

    /**
     * Returns the current value of the property 'SuppressRingtoneOnOffList'
     * (as known by the proxy). This method is only allowed to be called when
     * a status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasSuppressRingtoneOnOffList() returns true.
     *
     * @return the previously received value of the property 'SuppressRingtoneOnOffList'.
     */
    const SuppressRingtoneOnOffListStatus& getSuppressRingtoneOnOffList() const;

    /**
     * Determines whether a status message for the property 'SuppressRingtoneOnOffList' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasSuppressRingtoneOnOffList() const;

    /**
     * Request the value of the property 'SuppressRingtoneOnOffList' from the
     * CCA server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'SuppressRingtoneOnOffList'</b>:
     *
     * Provides a list of each paired phones with its current suppress ringtone state.
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSuppressRingtoneOnOffListGet(SuppressRingtoneOnOffListCallbackIF& cb);

    // Property 'AutoWaitingModeOnOffList'

    /**
     * Notify on the property 'AutoWaitingModeOnOffList'. This method sends a
     * UpReg message to the CCA server.
     *
     * <b>Documentation of 'AutoWaitingModeOnOffList'</b>:
     *
     * Provides a list of each paired phones with its current auto waiting mode state.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAutoWaitingModeOnOffListUpReg(AutoWaitingModeOnOffListCallbackIF& cb);

    /**
     * Remove the notifcation on property 'AutoWaitingModeOnOffList'. This
     * method sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'AutoWaitingModeOnOffList'</b>:
     *
     * Provides a list of each paired phones with its current auto waiting mode state.
     *
     * @param act The act which was previously returned by the
     * sendAutoWaitingModeOnOffListUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendAutoWaitingModeOnOffListRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'AutoWaitingModeOnOffList'.
     */
    void sendAutoWaitingModeOnOffListRelUpRegAll ();

    /**
     * Returns the current value of the property 'AutoWaitingModeOnOffList'
     * (as known by the proxy). This method is only allowed to be called when
     * a status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasAutoWaitingModeOnOffList() returns true.
     *
     * @return the previously received value of the property 'AutoWaitingModeOnOffList'.
     */
    const AutoWaitingModeOnOffListStatus& getAutoWaitingModeOnOffList() const;

    /**
     * Determines whether a status message for the property 'AutoWaitingModeOnOffList' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasAutoWaitingModeOnOffList() const;

    /**
     * Request the value of the property 'AutoWaitingModeOnOffList' from the
     * CCA server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'AutoWaitingModeOnOffList'</b>:
     *
     * Provides a list of each paired phones with its current auto waiting mode state.
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAutoWaitingModeOnOffListGet(AutoWaitingModeOnOffListCallbackIF& cb);

    // Property 'RingtonePlaybackStatus'

    /**
     * Notify on the property 'RingtonePlaybackStatus'. This method sends a
     * UpReg message to the CCA server.
     *
     * <b>Documentation of 'RingtonePlaybackStatus'</b>:
     *
     * Provides the vehicle ringtone playback state. This property is applicable only for the Play and Stop ringtone
     * requests from clients and not applicable for playing vehicle ringtone for an incoming call.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendRingtonePlaybackStatusUpReg(RingtonePlaybackStatusCallbackIF& cb);

    /**
     * Remove the notifcation on property 'RingtonePlaybackStatus'. This
     * method sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'RingtonePlaybackStatus'</b>:
     *
     * Provides the vehicle ringtone playback state. This property is applicable only for the Play and Stop ringtone
     * requests from clients and not applicable for playing vehicle ringtone for an incoming call.
     *
     * @param act The act which was previously returned by the
     * sendRingtonePlaybackStatusUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendRingtonePlaybackStatusRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'RingtonePlaybackStatus'.
     */
    void sendRingtonePlaybackStatusRelUpRegAll ();

    /**
     * Returns the current value of the property 'RingtonePlaybackStatus' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasRingtonePlaybackStatus() returns true.
     *
     * @return the previously received value of the property 'RingtonePlaybackStatus'.
     */
    const RingtonePlaybackStatusStatus& getRingtonePlaybackStatus() const;

    /**
     * Determines whether a status message for the property 'RingtonePlaybackStatus' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasRingtonePlaybackStatus() const;

    /**
     * Request the value of the property 'RingtonePlaybackStatus' from the CCA
     * server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'RingtonePlaybackStatus'</b>:
     *
     * Provides the vehicle ringtone playback state. This property is applicable only for the Play and Stop ringtone
     * requests from clients and not applicable for playing vehicle ringtone for an incoming call.
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendRingtonePlaybackStatusGet(RingtonePlaybackStatusCallbackIF& cb);

    // Property 'WaitingModeFilePath'

    /**
     * Notify on the property 'WaitingModeFilePath'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'WaitingModeFilePath'</b>:
     *
     * This interface is used to Set and Get the filepath of NarrowBand and WideBand audio files.
     * One of these files will be played by the Phone F-Block during active waiting mode state based on the
     * audio codec (NarrowBand/Wideband) supported by the connected Bluetooth Phone device.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendWaitingModeFilePathUpReg(WaitingModeFilePathCallbackIF& cb);

    /**
     * Remove the notifcation on property 'WaitingModeFilePath'. This method
     * sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'WaitingModeFilePath'</b>:
     *
     * This interface is used to Set and Get the filepath of NarrowBand and WideBand audio files.
     * One of these files will be played by the Phone F-Block during active waiting mode state based on the
     * audio codec (NarrowBand/Wideband) supported by the connected Bluetooth Phone device.
     *
     * @param act The act which was previously returned by the
     * sendWaitingModeFilePathUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendWaitingModeFilePathRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'WaitingModeFilePath'.
     */
    void sendWaitingModeFilePathRelUpRegAll ();

    /**
     * Returns the current value of the property 'WaitingModeFilePath' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasWaitingModeFilePath() returns true.
     *
     * @return the previously received value of the property 'WaitingModeFilePath'.
     */
    const WaitingModeFilePathStatus& getWaitingModeFilePath() const;

    /**
     * Determines whether a status message for the property 'WaitingModeFilePath' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasWaitingModeFilePath() const;

    /**
     * Request the value of the property 'WaitingModeFilePath' from the CCA
     * server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'WaitingModeFilePath'</b>:
     *
     * This interface is used to Set and Get the filepath of NarrowBand and WideBand audio files.
     * One of these files will be played by the Phone F-Block during active waiting mode state based on the
     * audio codec (NarrowBand/Wideband) supported by the connected Bluetooth Phone device.
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendWaitingModeFilePathGet(WaitingModeFilePathCallbackIF& cb);

    /**
     * Set the value of the property 'WaitingModeFilePath'. This method sends
     * a PureSet message to the CCA server.
     *
     * <b>Documentation of 'WaitingModeFilePath'</b>:
     *
     * This interface is used to Set and Get the filepath of NarrowBand and WideBand audio files.
     * One of these files will be played by the Phone F-Block during active waiting mode state based on the
     * audio codec (NarrowBand/Wideband) supported by the connected Bluetooth Phone device.
     *
     * @param sFilePathNB File path to 8 KHz .wav file. This file will be played by the Phone F-Block
     * during active waiting mode state if audio codec supported by the connected Bluetooth Phone
     * device is NarrowBand.
     *
     * @param sFilePathWB File path to 16 KHz .wav file. This file will be played by the Phone F-Block
     * during active waiting mode state if audio codec supported by the connected Bluetooth Phone
     * device is WideBand.
     */

    void sendWaitingModeFilePathPureSet(const ::fi_basetypes_most::T_String& sFilePathNB, const ::fi_basetypes_most::T_String& sFilePathWB);

    // Property 'BTDeviceVoiceRecognitionExtended'

    /**
     * Notify on the property 'BTDeviceVoiceRecognitionExtended'. This method
     * sends a UpReg message to the CCA server.
     *
     * <b>Documentation of 'BTDeviceVoiceRecognitionExtended'</b>:
     *
     * This is the extension of the Property "BTDeviceVoiceRecognition" with the new parameter e8SiriAvailabilityState.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendBTDeviceVoiceRecognitionExtendedUpReg(BTDeviceVoiceRecognitionExtendedCallbackIF& cb);

    /**
     * Remove the notifcation on property 'BTDeviceVoiceRecognitionExtended'.
     * This method sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'BTDeviceVoiceRecognitionExtended'</b>:
     *
     * This is the extension of the Property "BTDeviceVoiceRecognition" with the new parameter e8SiriAvailabilityState.
     *
     * @param act The act which was previously returned by the
     * sendBTDeviceVoiceRecognitionExtendedUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendBTDeviceVoiceRecognitionExtendedRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'BTDeviceVoiceRecognitionExtended'.
     */
    void sendBTDeviceVoiceRecognitionExtendedRelUpRegAll ();

    /**
     * Returns the current value of the property
     * 'BTDeviceVoiceRecognitionExtended' (as known by the proxy). This method
     * is only allowed to be called when a status message for this property
     * was received before. Otherwise the behavior of this method is
     * undefined. It is safe to call this method when
     * hasBTDeviceVoiceRecognitionExtended() returns true.
     *
     * @return the previously received value of the property 'BTDeviceVoiceRecognitionExtended'.
     */
    const BTDeviceVoiceRecognitionExtendedStatus& getBTDeviceVoiceRecognitionExtended() const;

    /**
     * Determines whether a status message for the property 'BTDeviceVoiceRecognitionExtended' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasBTDeviceVoiceRecognitionExtended() const;

    /**
     * Request the value of the property 'BTDeviceVoiceRecognitionExtended'
     * from the CCA server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'BTDeviceVoiceRecognitionExtended'</b>:
     *
     * This is the extension of the Property "BTDeviceVoiceRecognition" with the new parameter e8SiriAvailabilityState.
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendBTDeviceVoiceRecognitionExtendedGet(BTDeviceVoiceRecognitionExtendedCallbackIF& cb);

    /**
     * Set the value of the property 'BTDeviceVoiceRecognitionExtended'. This
     * method sends a PureSet message to the CCA server.
     *
     * <b>Documentation of 'BTDeviceVoiceRecognitionExtended'</b>:
     *
     * This is the extension of the Property "BTDeviceVoiceRecognition" with the new parameter e8SiriAvailabilityState.
     *
     * @param u8DeviceHandle Device handle for which the VR session has to be triggered.
     * Device Handles are maintained by BluetoothSettings FBlock.
     *
     * @param bBTDeviceVoiceRecActive The state of the remote Bluetooth device voice recognition.
     * This parameter shall be set to False at initialization default.
     */

    void sendBTDeviceVoiceRecognitionExtendedPureSet(uint8 u8DeviceHandle, bool bBTDeviceVoiceRecActive);

    // Property 'CallStatusNoticeExtended'

    /**
     * Notify on the property 'CallStatusNoticeExtended'. This method sends a
     * UpReg message to the CCA server.
     *
     * <b>Documentation of 'CallStatusNoticeExtended'</b>:
     *
     * Other component can get status of a CallInstance using this notification.
     * Telephone component notifies when a status changes , and ends status
     * update when the CallStatus becomes IDLE. Needs valid Callinstance.
     * Callinstances are created on an incoming call event or an outgoing call
     * request.IMPORTANT: When there are no calls currently active, the
     * Status response of this property cannot be an empty stream as an empty
     * payload MHP message is incompatible with the current (as of this release)
     * implemenation of NetServices. Instead, when no calls are active, the
     * following &quot;null&quot; Status response shall be returned:
     *
     *
     * <item>
     * CallInstance = 0xFF
     * </item>
     * <item>
     * CallStatus = IDLE
     * </item>
     * <item>
     * UsingVehicleAudio = False
     * </item>
     * <item>
     * CallDurationXX = 0
     * </item>
     * <item>
     * DeviceHandle=0xFF
     * </item>
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendCallStatusNoticeExtendedUpReg(CallStatusNoticeExtendedCallbackIF& cb);

    /**
     * Remove the notifcation on property 'CallStatusNoticeExtended'. This
     * method sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'CallStatusNoticeExtended'</b>:
     *
     * Other component can get status of a CallInstance using this notification.
     * Telephone component notifies when a status changes , and ends status
     * update when the CallStatus becomes IDLE. Needs valid Callinstance.
     * Callinstances are created on an incoming call event or an outgoing call
     * request.IMPORTANT: When there are no calls currently active, the
     * Status response of this property cannot be an empty stream as an empty
     * payload MHP message is incompatible with the current (as of this release)
     * implemenation of NetServices. Instead, when no calls are active, the
     * following &quot;null&quot; Status response shall be returned:
     *
     *
     * <item>
     * CallInstance = 0xFF
     * </item>
     * <item>
     * CallStatus = IDLE
     * </item>
     * <item>
     * UsingVehicleAudio = False
     * </item>
     * <item>
     * CallDurationXX = 0
     * </item>
     * <item>
     * DeviceHandle=0xFF
     * </item>
     *
     * @param act The act which was previously returned by the
     * sendCallStatusNoticeExtendedUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendCallStatusNoticeExtendedRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'CallStatusNoticeExtended'.
     */
    void sendCallStatusNoticeExtendedRelUpRegAll ();

    /**
     * Returns the current value of the property 'CallStatusNoticeExtended'
     * (as known by the proxy). This method is only allowed to be called when
     * a status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasCallStatusNoticeExtended() returns true.
     *
     * @return the previously received value of the property 'CallStatusNoticeExtended'.
     */
    const CallStatusNoticeExtendedStatus& getCallStatusNoticeExtended() const;

    /**
     * Determines whether a status message for the property 'CallStatusNoticeExtended' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasCallStatusNoticeExtended() const;

    /**
     * Request the value of the property 'CallStatusNoticeExtended' from the
     * CCA server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'CallStatusNoticeExtended'</b>:
     *
     * Other component can get status of a CallInstance using this notification.
     * Telephone component notifies when a status changes , and ends status
     * update when the CallStatus becomes IDLE. Needs valid Callinstance.
     * Callinstances are created on an incoming call event or an outgoing call
     * request.IMPORTANT: When there are no calls currently active, the
     * Status response of this property cannot be an empty stream as an empty
     * payload MHP message is incompatible with the current (as of this release)
     * implemenation of NetServices. Instead, when no calls are active, the
     * following &quot;null&quot; Status response shall be returned:
     *
     *
     * <item>
     * CallInstance = 0xFF
     * </item>
     * <item>
     * CallStatus = IDLE
     * </item>
     * <item>
     * UsingVehicleAudio = False
     * </item>
     * <item>
     * CallDurationXX = 0
     * </item>
     * <item>
     * DeviceHandle=0xFF
     * </item>
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendCallStatusNoticeExtendedGet(CallStatusNoticeExtendedCallbackIF& cb);

    // Property 'ActivePhoneDevice'

    /**
     * Notify on the property 'ActivePhoneDevice'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'ActivePhoneDevice'</b>:
     *
     * This property gives the device handle of the current active device.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendActivePhoneDeviceUpReg(ActivePhoneDeviceCallbackIF& cb);

    /**
     * Remove the notifcation on property 'ActivePhoneDevice'. This method
     * sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'ActivePhoneDevice'</b>:
     *
     * This property gives the device handle of the current active device.
     *
     * @param act The act which was previously returned by the
     * sendActivePhoneDeviceUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendActivePhoneDeviceRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'ActivePhoneDevice'.
     */
    void sendActivePhoneDeviceRelUpRegAll ();

    /**
     * Returns the current value of the property 'ActivePhoneDevice' (as known
     * by the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasActivePhoneDevice() returns true.
     *
     * @return the previously received value of the property 'ActivePhoneDevice'.
     */
    const ActivePhoneDeviceStatus& getActivePhoneDevice() const;

    /**
     * Determines whether a status message for the property 'ActivePhoneDevice' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasActivePhoneDevice() const;

    /**
     * Request the value of the property 'ActivePhoneDevice' from the CCA
     * server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'ActivePhoneDevice'</b>:
     *
     * This property gives the device handle of the current active device.
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendActivePhoneDeviceGet(ActivePhoneDeviceCallbackIF& cb);

    // Property 'OutgoingCallFailedEvent'

    /**
     * Notify on the property 'OutgoingCallFailedEvent'. This method sends a
     * UpReg message to the CCA server.
     *
     * <b>Documentation of 'OutgoingCallFailedEvent'</b>:
     *
     * This property updates the Outgoing call Failed Events
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendOutgoingCallFailedEventUpReg(OutgoingCallFailedEventCallbackIF& cb);

    /**
     * Remove the notifcation on property 'OutgoingCallFailedEvent'. This
     * method sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'OutgoingCallFailedEvent'</b>:
     *
     * This property updates the Outgoing call Failed Events
     *
     * @param act The act which was previously returned by the
     * sendOutgoingCallFailedEventUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendOutgoingCallFailedEventRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'OutgoingCallFailedEvent'.
     */
    void sendOutgoingCallFailedEventRelUpRegAll ();

    /**
     * Returns the current value of the property 'OutgoingCallFailedEvent' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasOutgoingCallFailedEvent() returns true.
     *
     * @return the previously received value of the property 'OutgoingCallFailedEvent'.
     */
    const OutgoingCallFailedEventStatus& getOutgoingCallFailedEvent() const;

    /**
     * Determines whether a status message for the property 'OutgoingCallFailedEvent' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasOutgoingCallFailedEvent() const;

    // Property 'IncomingCallRejectedEvent'

    /**
     * Notify on the property 'IncomingCallRejectedEvent'. This method sends a
     * UpReg message to the CCA server.
     *
     * <b>Documentation of 'IncomingCallRejectedEvent'</b>:
     *
     * This property updates the Incoming call Rejected Events
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendIncomingCallRejectedEventUpReg(IncomingCallRejectedEventCallbackIF& cb);

    /**
     * Remove the notifcation on property 'IncomingCallRejectedEvent'. This
     * method sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'IncomingCallRejectedEvent'</b>:
     *
     * This property updates the Incoming call Rejected Events
     *
     * @param act The act which was previously returned by the
     * sendIncomingCallRejectedEventUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendIncomingCallRejectedEventRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'IncomingCallRejectedEvent'.
     */
    void sendIncomingCallRejectedEventRelUpRegAll ();

    /**
     * Returns the current value of the property 'IncomingCallRejectedEvent'
     * (as known by the proxy). This method is only allowed to be called when
     * a status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasIncomingCallRejectedEvent() returns true.
     *
     * @return the previously received value of the property 'IncomingCallRejectedEvent'.
     */
    const IncomingCallRejectedEventStatus& getIncomingCallRejectedEvent() const;

    /**
     * Determines whether a status message for the property 'IncomingCallRejectedEvent' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasIncomingCallRejectedEvent() const;

    // Property 'WaitingModeState'

    /**
     * Notify on the property 'WaitingModeState'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'WaitingModeState'</b>:
     *
     * This property provides the waiting mode status.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendWaitingModeStateUpReg(WaitingModeStateCallbackIF& cb);

    /**
     * Remove the notifcation on property 'WaitingModeState'. This method
     * sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'WaitingModeState'</b>:
     *
     * This property provides the waiting mode status.
     *
     * @param act The act which was previously returned by the
     * sendWaitingModeStateUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendWaitingModeStateRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'WaitingModeState'.
     */
    void sendWaitingModeStateRelUpRegAll ();

    /**
     * Returns the current value of the property 'WaitingModeState' (as known
     * by the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasWaitingModeState() returns true.
     *
     * @return the previously received value of the property 'WaitingModeState'.
     */
    const WaitingModeStateStatus& getWaitingModeState() const;

    /**
     * Determines whether a status message for the property 'WaitingModeState' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasWaitingModeState() const;

    /**
     * Request the value of the property 'WaitingModeState' from the CCA
     * server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'WaitingModeState'</b>:
     *
     * This property provides the waiting mode status.
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendWaitingModeStateGet(WaitingModeStateCallbackIF& cb);

    // Property 'ExternalVRState'

    /**
     * Notify on the property 'ExternalVRState'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'ExternalVRState'</b>:
     *
     * This property shall update the state of External VR session to the clients
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendExternalVRStateUpReg(ExternalVRStateCallbackIF& cb);

    /**
     * Remove the notifcation on property 'ExternalVRState'. This method sends
     * a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'ExternalVRState'</b>:
     *
     * This property shall update the state of External VR session to the clients
     *
     * @param act The act which was previously returned by the
     * sendExternalVRStateUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendExternalVRStateRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'ExternalVRState'.
     */
    void sendExternalVRStateRelUpRegAll ();

    /**
     * Returns the current value of the property 'ExternalVRState' (as known
     * by the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasExternalVRState() returns true.
     *
     * @return the previously received value of the property 'ExternalVRState'.
     */
    const ExternalVRStateStatus& getExternalVRState() const;

    /**
     * Determines whether a status message for the property 'ExternalVRState' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasExternalVRState() const;

    /**
     * Request the value of the property 'ExternalVRState' from the CCA
     * server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'ExternalVRState'</b>:
     *
     * This property shall update the state of External VR session to the clients
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendExternalVRStateGet(ExternalVRStateCallbackIF& cb);

    // Property 'CallOperationFailedEvent'

    /**
     * Notify on the property 'CallOperationFailedEvent'. This method sends a
     * UpReg message to the CCA server.
     *
     * <b>Documentation of 'CallOperationFailedEvent'</b>:
     *
     * This property is updated when any of the below mentioned call operation fails:
     * 1. Accept Call
     * 2. Hangup Call
     * 3. Swap Call
     * 4. Conference Call
     * 5. Split call
     * Hint:- The error notifications shall be reported to the clients only when the call operations are triggered from the HU.
     * This property is updated only in the redesign component - PM, Legacy phone component does not support this property.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendCallOperationFailedEventUpReg(CallOperationFailedEventCallbackIF& cb);

    /**
     * Remove the notifcation on property 'CallOperationFailedEvent'. This
     * method sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'CallOperationFailedEvent'</b>:
     *
     * This property is updated when any of the below mentioned call operation fails:
     * 1. Accept Call
     * 2. Hangup Call
     * 3. Swap Call
     * 4. Conference Call
     * 5. Split call
     * Hint:- The error notifications shall be reported to the clients only when the call operations are triggered from the HU.
     * This property is updated only in the redesign component - PM, Legacy phone component does not support this property.
     *
     * @param act The act which was previously returned by the
     * sendCallOperationFailedEventUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendCallOperationFailedEventRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'CallOperationFailedEvent'.
     */
    void sendCallOperationFailedEventRelUpRegAll ();

    /**
     * Returns the current value of the property 'CallOperationFailedEvent'
     * (as known by the proxy). This method is only allowed to be called when
     * a status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasCallOperationFailedEvent() returns true.
     *
     * @return the previously received value of the property 'CallOperationFailedEvent'.
     */
    const CallOperationFailedEventStatus& getCallOperationFailedEvent() const;

    /**
     * Determines whether a status message for the property 'CallOperationFailedEvent' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasCallOperationFailedEvent() const;

    // Property 'SendDTMFFailedEvent'

    /**
     * Notify on the property 'SendDTMFFailedEvent'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'SendDTMFFailedEvent'</b>:
     *
     * This property updates the DTMF Failed Events.
     * This property is updated only in the redesign component - PM, Legacy phone component does not support this property.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSendDTMFFailedEventUpReg(SendDTMFFailedEventCallbackIF& cb);

    /**
     * Remove the notifcation on property 'SendDTMFFailedEvent'. This method
     * sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'SendDTMFFailedEvent'</b>:
     *
     * This property updates the DTMF Failed Events.
     * This property is updated only in the redesign component - PM, Legacy phone component does not support this property.
     *
     * @param act The act which was previously returned by the
     * sendSendDTMFFailedEventUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendSendDTMFFailedEventRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'SendDTMFFailedEvent'.
     */
    void sendSendDTMFFailedEventRelUpRegAll ();

    /**
     * Returns the current value of the property 'SendDTMFFailedEvent' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasSendDTMFFailedEvent() returns true.
     *
     * @return the previously received value of the property 'SendDTMFFailedEvent'.
     */
    const SendDTMFFailedEventStatus& getSendDTMFFailedEvent() const;

    /**
     * Determines whether a status message for the property 'SendDTMFFailedEvent' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasSendDTMFFailedEvent() const;

    // Property 'AudioTransferFailedEvent'

    /**
     * Notify on the property 'AudioTransferFailedEvent'. This method sends a
     * UpReg message to the CCA server.
     *
     * <b>Documentation of 'AudioTransferFailedEvent'</b>:
     *
     * This property updates the Audio Transfer Failed Events.
     * This property is updated only in the redesign component - PM, Legacy phone component does not support this property.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAudioTransferFailedEventUpReg(AudioTransferFailedEventCallbackIF& cb);

    /**
     * Remove the notifcation on property 'AudioTransferFailedEvent'. This
     * method sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'AudioTransferFailedEvent'</b>:
     *
     * This property updates the Audio Transfer Failed Events.
     * This property is updated only in the redesign component - PM, Legacy phone component does not support this property.
     *
     * @param act The act which was previously returned by the
     * sendAudioTransferFailedEventUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendAudioTransferFailedEventRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'AudioTransferFailedEvent'.
     */
    void sendAudioTransferFailedEventRelUpRegAll ();

    /**
     * Returns the current value of the property 'AudioTransferFailedEvent'
     * (as known by the proxy). This method is only allowed to be called when
     * a status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasAudioTransferFailedEvent() returns true.
     *
     * @return the previously received value of the property 'AudioTransferFailedEvent'.
     */
    const AudioTransferFailedEventStatus& getAudioTransferFailedEvent() const;

    /**
     * Determines whether a status message for the property 'AudioTransferFailedEvent' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasAudioTransferFailedEvent() const;

    /**
     * Release all property notifications (on all properties).
     */
    void sendRelUpRegAll ();

private:

    MOST_Tel_FIProxy (const std::string& portName, uint16 appId, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags);

    virtual void clearAllProperties ();

    ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > createCallback (uint16 fid, ::asf::cca::CcaTypes::ServiceData::OpCode opCode, uint16 commandCounter, void* cb);

    // Property 'SourceInfo'

    ::asf::core::nullable< SourceInfoStatus > _sourceInfo;

    // Property 'SourceAvailable'

    ::asf::core::nullable< SourceAvailableStatus > _sourceAvailable;

    // Property 'ActiveCallinHandset'

    ::asf::core::nullable< ActiveCallinHandsetStatus > _activeCallinHandset;

    // Property 'CallStatusNotice'

    ::asf::core::nullable< CallStatusNoticeStatus > _callStatusNotice;

    // Property 'CellDeviceName'

    ::asf::core::nullable< CellDeviceNameStatus > _cellDeviceName;

    // Property 'CellNetworkStatus'

    ::asf::core::nullable< CellNetworkStatusStatus > _cellNetworkStatus;

    // Property 'CellSignalStrength'

    ::asf::core::nullable< CellSignalStrengthStatus > _cellSignalStrength;

    // Property 'CellStateofCharge'

    ::asf::core::nullable< CellStateofChargeStatus > _cellStateofCharge;

    // Property 'InComingCallEvent'

    ::asf::core::nullable< InComingCallEventStatus > _inComingCallEvent;

    // Property 'NetworkOperator'

    ::asf::core::nullable< NetworkOperatorStatus > _networkOperator;

    // Property 'SLCStatus'

    ::asf::core::nullable< SLCStatusStatus > _sLCStatus;

    // Property 'VehicleAudio'

    ::asf::core::nullable< VehicleAudioStatus > _vehicleAudio;

    // Property 'MicrophoneMuteState'

    ::asf::core::nullable< MicrophoneMuteStateStatus > _microphoneMuteState;

    // Property 'RingtoneMuteState'

    ::asf::core::nullable< RingtoneMuteStateStatus > _ringtoneMuteState;

    // Property 'HFService'

    ::asf::core::nullable< HFServiceStatus > _hFService;

    // Property 'BTDeviceVoiceRecognition'

    ::asf::core::nullable< BTDeviceVoiceRecognitionStatus > _bTDeviceVoiceRecognition;

    // Property 'HandsFreeEnhancedCallControl'

    ::asf::core::nullable< HandsFreeEnhancedCallControlStatus > _handsFreeEnhancedCallControl;

    // Property 'SystemWideRingtonesList'

    ::asf::core::nullable< SystemWideRingtonesListStatus > _systemWideRingtonesList;

    // Property 'DeviceRingtoneList'

    ::asf::core::nullable< DeviceRingtoneListStatus > _deviceRingtoneList;

    // Property 'SuppressRingtoneOnOffList'

    ::asf::core::nullable< SuppressRingtoneOnOffListStatus > _suppressRingtoneOnOffList;

    // Property 'AutoWaitingModeOnOffList'

    ::asf::core::nullable< AutoWaitingModeOnOffListStatus > _autoWaitingModeOnOffList;

    // Property 'RingtonePlaybackStatus'

    ::asf::core::nullable< RingtonePlaybackStatusStatus > _ringtonePlaybackStatus;

    // Property 'WaitingModeFilePath'

    ::asf::core::nullable< WaitingModeFilePathStatus > _waitingModeFilePath;

    // Property 'BTDeviceVoiceRecognitionExtended'

    ::asf::core::nullable< BTDeviceVoiceRecognitionExtendedStatus > _bTDeviceVoiceRecognitionExtended;

    // Property 'CallStatusNoticeExtended'

    ::asf::core::nullable< CallStatusNoticeExtendedStatus > _callStatusNoticeExtended;

    // Property 'ActivePhoneDevice'

    ::asf::core::nullable< ActivePhoneDeviceStatus > _activePhoneDevice;

    // Property 'OutgoingCallFailedEvent'

    ::asf::core::nullable< OutgoingCallFailedEventStatus > _outgoingCallFailedEvent;

    // Property 'IncomingCallRejectedEvent'

    ::asf::core::nullable< IncomingCallRejectedEventStatus > _incomingCallRejectedEvent;

    // Property 'WaitingModeState'

    ::asf::core::nullable< WaitingModeStateStatus > _waitingModeState;

    // Property 'ExternalVRState'

    ::asf::core::nullable< ExternalVRStateStatus > _externalVRState;

    // Property 'CallOperationFailedEvent'

    ::asf::core::nullable< CallOperationFailedEventStatus > _callOperationFailedEvent;

    // Property 'SendDTMFFailedEvent'

    ::asf::core::nullable< SendDTMFFailedEventStatus > _sendDTMFFailedEvent;

    // Property 'AudioTransferFailedEvent'

    ::asf::core::nullable< AudioTransferFailedEventStatus > _audioTransferFailedEvent;

    DECLARE_CLASS_LOGGER();

    friend class MOST_Tel_FIProxyCallback;
};

} // namespace MOST_Tel_FI

#endif // MOST_TEL_FIPROXY_H
