#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef MOST_TEL_FI_H
#define MOST_TEL_FI_H

#include "asf/cca/CcaTypes.h"
#include "asf/cca/CcaTypesConst.h"
#include "asf/core/Logger.h"
#include "asf/core/Payload.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "asf/core/VersionCheck.h"
#include "fi_basetypes_most.h"
#include "fi_basetypes_mostConst.h"
#include "most_Src_fi_types.h"
#include "most_Src_fi_typesConst.h"
#include "most_Tel_fi_types.h"
#include "most_Tel_fi_typesConst.h"
#include "most_Tel_fi_types_Extended.h"
#include "most_Tel_fi_types_ExtendedConst.h"
#include <cstring>
#include <vector>

/**
 * CCA Functional Interface 'MOST_Tel_FI'
 *
 * Fullname: Proprietary - Telephone
 *
 * Version: 4.3
 *
 * Author: Scott Rush, General Motors
 *
 * Date: 2013-05-31
 *
 * Department:
 *
 * Title:
 *             MOST_Telephone_FI
 *
 * <b>Description of 'MOST_Tel_FI':</b>
 *
 * <p>This FBlock was assembled from FBlockManifest file: Telephone.fblockman, Please consult individual interface files for interface-specific change history.</p>
 * The Telephone FBlock encapsulates hands free calling functions for the
 * Bluetooth portable phones. The Telephone FBlock implements ITelephone,
 * ISink, and ISource interfaces. ITelephone contains the functions that an
 * HMI Controller uses to control the Telephone FBlock. ISource/ISink
 * provides the interaction with the Audio Video Manager.See GIS-327
 * Bluetooth Settings Requirements Specification for hands-free profile
 * feature requirements and GIS-366 Telephone FBlock Specification for
 * detailed interface requirements.
 */

namespace MOST_Tel_FI {

static const int SERVICE_ID = 574;

static const int FID_SourceInfo = 256;

static const int FID_SourceAvailable = 3120;

static const int FID_ActiveCallinHandset = 513;

static const int FID_CallStatusNotice = 514;

static const int FID_CellDeviceName = 517;

static const int FID_CellNetworkStatus = 518;

static const int FID_CellSignalStrength = 519;

static const int FID_CellStateofCharge = 520;

static const int FID_InComingCallEvent = 525;

static const int FID_NetworkOperator = 527;

static const int FID_SLCStatus = 530;

static const int FID_VehicleAudio = 539;

static const int FID_MicrophoneMuteState = 544;

static const int FID_RingtoneMuteState = 545;

static const int FID_HFService = 546;

static const int FID_BTDeviceVoiceRecognition = 549;

static const int FID_HandsFreeEnhancedCallControl = 550;

static const int FID_SystemWideRingtonesList = 3854;

static const int FID_DeviceRingtoneList = 3855;

static const int FID_SuppressRingtoneOnOffList = 3856;

static const int FID_AutoWaitingModeOnOffList = 3857;

static const int FID_RingtonePlaybackStatus = 3866;

static const int FID_Allocate = 257;

static const int FID_DeAllocate = 258;

static const int FID_SourceActivity = 259;

static const int FID_AcceptCall = 512;

static const int FID_CancelOutgoingCall = 516;

static const int FID_ConferenceIn = 521;

static const int FID_HangUpCall = 522;

static const int FID_HoldCall = 523;

static const int FID_IgnoreCall = 524;

static const int FID_RejectCall = 528;

static const int FID_ResumeCall = 529;

static const int FID_SendDTMF = 531;

static const int FID_SpeedDial = 532;

static const int FID_SplitCall = 533;

static const int FID_SwapCall = 535;

static const int FID_TransferCallToHandset = 536;

static const int FID_TransferCallToVehicle = 537;

static const int FID_VoiceMail = 540;

static const int FID_Dial = 541;

static const int FID_QueryTelephoneNumber = 543;

static const int FID_AcquireTelephoneNumber = 547;

static const int FID_Redial = 548;

static const int FID_SetRingtone = 3858;

static const int FID_PlayRingtone = 3859;

static const int FID_StopRingtone = 3860;

static const int FID_SuppressRingtoneOnOff = 3861;

static const int FID_AutoWaitingModeOnOff = 3862;

static const int FID_WaitingModeFilePath = 3841;

static const int FID_BTDeviceVoiceRecognitionExtended = 3843;

static const int FID_CallStatusNoticeExtended = 3845;

static const int FID_ActivePhoneDevice = 3846;

static const int FID_OutgoingCallFailedEvent = 3848;

static const int FID_IncomingCallRejectedEvent = 3849;

static const int FID_WaitingModeState = 3850;

static const int FID_ExternalVRState = 3851;

static const int FID_CallOperationFailedEvent = 3863;

static const int FID_SendDTMFFailedEvent = 3864;

static const int FID_AudioTransferFailedEvent = 3865;

static const int FID_StartStopWaitingMode = 3842;

static const int FID_DialExtended = 3844;

static const int FID_SetActivePhone = 3847;

static const int FID_ActivateExternalVR = 3852;

static const int FID_DeActivateExternalVR = 3853;


ASF_GENERATOR_VERSION_CHECK_DECLARE

static const int VERSION_MAJOR = 4;

static const int VERSION_MINOR = 3;

static const int VERSION_PATCH = 0;

// forward declarations
class SourceInfoStatus;

class SourceInfoGet;

class SourceInfoErrorStructure;

class SourceInfoError;

class SourceAvailableStatus;

class SourceAvailableErrorStructure;

class SourceAvailableError;

class ActiveCallinHandsetStatus;

class ActiveCallinHandsetErrorStructure;

class ActiveCallinHandsetError;

class CallStatusNoticeStatus;

class CallStatusNoticeErrorStructure;

class CallStatusNoticeError;

class CellDeviceNameStatus;

class CellDeviceNameErrorStructure;

class CellDeviceNameError;

class CellNetworkStatusStatus;

class CellNetworkStatusErrorStructure;

class CellNetworkStatusError;

class CellSignalStrengthStatus;

class CellSignalStrengthErrorStructure;

class CellSignalStrengthError;

class CellStateofChargeStatus;

class CellStateofChargeErrorStructure;

class CellStateofChargeError;

class InComingCallEventStatus;

class InComingCallEventErrorStructure;

class InComingCallEventError;

class NetworkOperatorStatus;

class NetworkOperatorErrorStructure;

class NetworkOperatorError;

class SLCStatusStatus;

class SLCStatusErrorStructure;

class SLCStatusError;

class VehicleAudioStatus;

class VehicleAudioErrorStructure;

class VehicleAudioError;

class MicrophoneMuteStateStatus;

class MicrophoneMuteStatePureSet;

class MicrophoneMuteStateErrorStructure;

class MicrophoneMuteStateError;

class RingtoneMuteStateStatus;

class RingtoneMuteStatePureSet;

class RingtoneMuteStateErrorStructure;

class RingtoneMuteStateError;

class HFServiceStatus;

class HFServiceErrorStructure;

class HFServiceError;

class BTDeviceVoiceRecognitionStatus;

class BTDeviceVoiceRecognitionPureSet;

class BTDeviceVoiceRecognitionErrorStructure;

class BTDeviceVoiceRecognitionError;

class HandsFreeEnhancedCallControlStatus;

class HandsFreeEnhancedCallControlErrorStructure;

class HandsFreeEnhancedCallControlError;

class SystemWideRingtonesListStatus;

class DeviceRingtoneListStatus;

class SuppressRingtoneOnOffListStatus;

class AutoWaitingModeOnOffListStatus;

class RingtonePlaybackStatusStatus;

class AllocateStart;

class AllocateResult;

class AllocateErrorStructure;

class AllocateError;

class DeAllocateStart;

class DeAllocateResult;

class DeAllocateErrorStructure;

class DeAllocateError;

class SourceActivityStart;

class SourceActivityResult;

class SourceActivityErrorStructure;

class SourceActivityError;

class AcceptCallStart;

class AcceptCallResult;

class AcceptCallErrorStructure;

class AcceptCallError;

class CancelOutgoingCallStart;

class CancelOutgoingCallResult;

class CancelOutgoingCallErrorStructure;

class CancelOutgoingCallError;

class ConferenceInStart;

class ConferenceInResult;

class ConferenceInErrorStructure;

class ConferenceInError;

class HangUpCallStart;

class HangUpCallResult;

class HangUpCallErrorStructure;

class HangUpCallError;

class HoldCallStart;

class HoldCallResult;

class HoldCallErrorStructure;

class HoldCallError;

class IgnoreCallStart;

class IgnoreCallResult;

class IgnoreCallErrorStructure;

class IgnoreCallError;

class RejectCallStart;

class RejectCallResult;

class RejectCallErrorStructure;

class RejectCallError;

class ResumeCallStart;

class ResumeCallResult;

class ResumeCallErrorStructure;

class ResumeCallError;

class SendDTMFStart;

class SendDTMFResult;

class SendDTMFErrorStructure;

class SendDTMFError;

class SpeedDialStart;

class SpeedDialResult;

class SpeedDialErrorStructure;

class SpeedDialError;

class SplitCallStart;

class SplitCallResult;

class SplitCallErrorStructure;

class SplitCallError;

class SwapCallStart;

class SwapCallResult;

class SwapCallErrorStructure;

class SwapCallError;

class TransferCallToHandsetErrorStructure;

class TransferCallToHandsetError;

class TransferCallToVehicleStart;

class TransferCallToVehicleResult;

class TransferCallToVehicleErrorStructure;

class TransferCallToVehicleError;

class VoiceMailStart;

class VoiceMailResult;

class VoiceMailErrorStructure;

class VoiceMailError;

class DialStart;

class DialResult;

class DialErrorStructure;

class DialError;

class QueryTelephoneNumberStart;

class QueryTelephoneNumberResult;

class QueryTelephoneNumberErrorStructure;

class QueryTelephoneNumberError;

class AcquireTelephoneNumberStart;

class AcquireTelephoneNumberResult;

class AcquireTelephoneNumberErrorStructure;

class AcquireTelephoneNumberError;

class RedialStart;

class RedialResult;

class RedialErrorStructure;

class RedialError;

class SetRingtoneStart;

class SetRingtoneErrorStructure;

class SetRingtoneError;

class PlayRingtoneStart;

class PlayRingtoneErrorStructure;

class PlayRingtoneError;

class StopRingtoneErrorStructure;

class StopRingtoneError;

class SuppressRingtoneOnOffStart;

class SuppressRingtoneOnOffErrorStructure;

class SuppressRingtoneOnOffError;

class AutoWaitingModeOnOffStart;

class AutoWaitingModeOnOffErrorStructure;

class AutoWaitingModeOnOffError;

class WaitingModeFilePathStatus;

class WaitingModeFilePathPureSet;

class WaitingModeFilePathErrorStructure;

class WaitingModeFilePathError;

class BTDeviceVoiceRecognitionExtendedStatus;

class BTDeviceVoiceRecognitionExtendedPureSet;

class BTDeviceVoiceRecognitionExtendedErrorStructure;

class BTDeviceVoiceRecognitionExtendedError;

class CallStatusNoticeExtendedStatus;

class CallStatusNoticeExtendedErrorStructure;

class CallStatusNoticeExtendedError;

class ActivePhoneDeviceStatus;

class OutgoingCallFailedEventStatus;

class IncomingCallRejectedEventStatus;

class WaitingModeStateStatus;

class ExternalVRStateStatus;

class CallOperationFailedEventStatus;

class SendDTMFFailedEventStatus;

class AudioTransferFailedEventStatus;

class StartStopWaitingModeStart;

class StartStopWaitingModeResult;

class StartStopWaitingModeErrorStructure;

class StartStopWaitingModeError;

class DialExtendedStart;

class DialExtendedResult;

class DialExtendedErrorStructure;

class DialExtendedError;

class SetActivePhoneStart;

class SetActivePhoneErrorStructure;

class SetActivePhoneError;

class ActivateExternalVRStart;

class ActivateExternalVRErrorStructure;

class ActivateExternalVRError;

class DeActivateExternalVRStart;

class DeActivateExternalVRErrorStructure;

class DeActivateExternalVRError;

// type definitions
/**
 * The upreg message of the property "SourceInfo"
 * This property gives particulars about the type of streaming data a source can handle. If notification is used for an FBlock with multiple sources, multiple notifications will be sent when the status changes for more than one source.For further information please refer to the MOST Stream Transmission Specification Rev 3.0.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SourceInfoUpReg;

/**
 * The relUpReg message of the property "SourceInfo"
 * This property gives particulars about the type of streaming data a source can handle. If notification is used for an FBlock with multiple sources, multiple notifications will be sent when the status changes for more than one source.For further information please refer to the MOST Stream Transmission Specification Rev 3.0.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SourceInfoRelUpReg;

/**
 * The get message of the property "SourceAvailable"
 * The SourceAvailable property can be queried by a controller to determine whether a Source is initialized and ready to produce audio or video.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SourceAvailableGet;

/**
 * The upreg message of the property "SourceAvailable"
 * The SourceAvailable property can be queried by a controller to determine whether a Source is initialized and ready to produce audio or video.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SourceAvailableUpReg;

/**
 * The relUpReg message of the property "SourceAvailable"
 * The SourceAvailable property can be queried by a controller to determine whether a Source is initialized and ready to produce audio or video.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SourceAvailableRelUpReg;

/**
 * The get message of the property "ActiveCallinHandset"
 * This Property reports whether or not there is an active call in a handset detected.  The state of the handset and its DeviceHandle (within the BluetoothSettings FBlock) are reported.  HMI controllers use the DeviceHandle to query the BluetoothSettings FBlock for additional information about the device and to potentially call the TransferCallToVehicle method to transfer the particular device's active call to the vehicle hands-free system.
 *
 * Note that it is possible that two different calls on two connected phones could be active on entry to the vehicle so this property has been defined as a Container with a ShortStream carrying the information for up to two devices.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ActiveCallinHandsetGet;

/**
 * The upreg message of the property "ActiveCallinHandset"
 * This Property reports whether or not there is an active call in a handset detected.  The state of the handset and its DeviceHandle (within the BluetoothSettings FBlock) are reported.  HMI controllers use the DeviceHandle to query the BluetoothSettings FBlock for additional information about the device and to potentially call the TransferCallToVehicle method to transfer the particular device's active call to the vehicle hands-free system.
 *
 * Note that it is possible that two different calls on two connected phones could be active on entry to the vehicle so this property has been defined as a Container with a ShortStream carrying the information for up to two devices.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ActiveCallinHandsetUpReg;

/**
 * The relUpReg message of the property "ActiveCallinHandset"
 * This Property reports whether or not there is an active call in a handset detected.  The state of the handset and its DeviceHandle (within the BluetoothSettings FBlock) are reported.  HMI controllers use the DeviceHandle to query the BluetoothSettings FBlock for additional information about the device and to potentially call the TransferCallToVehicle method to transfer the particular device's active call to the vehicle hands-free system.
 *
 * Note that it is possible that two different calls on two connected phones could be active on entry to the vehicle so this property has been defined as a Container with a ShortStream carrying the information for up to two devices.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ActiveCallinHandsetRelUpReg;

/**
 * The get message of the property "CallStatusNotice"
 * Other component can get status of a CallInstance using this notification.
 * Telephone component notifies when a status changes , and ends status
 * update when the CallStatus becomes IDLE. Needs valid Callinstance.
 * Callinstances are created on an incoming call event or an outgoing call
 * request.IMPORTANT: When there are no calls currently active, the
 * Status response of this property cannot be an empty stream as an empty
 * payload MHP message is incompatible with the current (as of this release)
 * implemenation of NetServices. Instead, when no calls are active, the
 * following &quot;null&quot; Status response shall be returned:
 *
 *
 * <item>
 * CallInstance = 0xFF
 * </item>
 * <item>
 * CallStatus = IDLE
 * </item>
 * <item>
 * UsingVehicleAudio = False
 * </item>
 * <item>
 * CallDurationXX = 0
 * </item>
 * <item>
 * DeviceHandle=0xFF
 * </item>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage CallStatusNoticeGet;

/**
 * The upreg message of the property "CallStatusNotice"
 * Other component can get status of a CallInstance using this notification.
 * Telephone component notifies when a status changes , and ends status
 * update when the CallStatus becomes IDLE. Needs valid Callinstance.
 * Callinstances are created on an incoming call event or an outgoing call
 * request.IMPORTANT: When there are no calls currently active, the
 * Status response of this property cannot be an empty stream as an empty
 * payload MHP message is incompatible with the current (as of this release)
 * implemenation of NetServices. Instead, when no calls are active, the
 * following &quot;null&quot; Status response shall be returned:
 *
 *
 * <item>
 * CallInstance = 0xFF
 * </item>
 * <item>
 * CallStatus = IDLE
 * </item>
 * <item>
 * UsingVehicleAudio = False
 * </item>
 * <item>
 * CallDurationXX = 0
 * </item>
 * <item>
 * DeviceHandle=0xFF
 * </item>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage CallStatusNoticeUpReg;

/**
 * The relUpReg message of the property "CallStatusNotice"
 * Other component can get status of a CallInstance using this notification.
 * Telephone component notifies when a status changes , and ends status
 * update when the CallStatus becomes IDLE. Needs valid Callinstance.
 * Callinstances are created on an incoming call event or an outgoing call
 * request.IMPORTANT: When there are no calls currently active, the
 * Status response of this property cannot be an empty stream as an empty
 * payload MHP message is incompatible with the current (as of this release)
 * implemenation of NetServices. Instead, when no calls are active, the
 * following &quot;null&quot; Status response shall be returned:
 *
 *
 * <item>
 * CallInstance = 0xFF
 * </item>
 * <item>
 * CallStatus = IDLE
 * </item>
 * <item>
 * UsingVehicleAudio = False
 * </item>
 * <item>
 * CallDurationXX = 0
 * </item>
 * <item>
 * DeviceHandle=0xFF
 * </item>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage CallStatusNoticeRelUpReg;

/**
 * The get message of the property "CellDeviceName"
 * Returns Device name of the current active hands free device.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage CellDeviceNameGet;

/**
 * The upreg message of the property "CellDeviceName"
 * Returns Device name of the current active hands free device.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage CellDeviceNameUpReg;

/**
 * The relUpReg message of the property "CellDeviceName"
 * Returns Device name of the current active hands free device.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage CellDeviceNameRelUpReg;

/**
 * The get message of the property "CellNetworkStatus"
 * Connectivity status of the cell network.  This is a notification since, network could be lost anytime.  Includes roaming true or false.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage CellNetworkStatusGet;

/**
 * The upreg message of the property "CellNetworkStatus"
 * Connectivity status of the cell network.  This is a notification since, network could be lost anytime.  Includes roaming true or false.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage CellNetworkStatusUpReg;

/**
 * The relUpReg message of the property "CellNetworkStatus"
 * Connectivity status of the cell network.  This is a notification since, network could be lost anytime.  Includes roaming true or false.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage CellNetworkStatusRelUpReg;

/**
 * The get message of the property "CellSignalStrength"
 * Even though this changes continually, it is exchanged as discrete parameters. Divide range to 5 indents.This is a notification since the signal strength can change.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage CellSignalStrengthGet;

/**
 * The upreg message of the property "CellSignalStrength"
 * Even though this changes continually, it is exchanged as discrete parameters. Divide range to 5 indents.This is a notification since the signal strength can change.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage CellSignalStrengthUpReg;

/**
 * The relUpReg message of the property "CellSignalStrength"
 * Even though this changes continually, it is exchanged as discrete parameters. Divide range to 5 indents.This is a notification since the signal strength can change.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage CellSignalStrengthRelUpReg;

/**
 * The get message of the property "CellStateofCharge"
 * The CellStateOfCharge Property contains the current cell phone charge status from 1 to 5.  HMI controllers register for notification on this property to receive changes in the cell phone state of charge.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage CellStateofChargeGet;

/**
 * The upreg message of the property "CellStateofCharge"
 * The CellStateOfCharge Property contains the current cell phone charge status from 1 to 5.  HMI controllers register for notification on this property to receive changes in the cell phone state of charge.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage CellStateofChargeUpReg;

/**
 * The relUpReg message of the property "CellStateofCharge"
 * The CellStateOfCharge Property contains the current cell phone charge status from 1 to 5.  HMI controllers register for notification on this property to receive changes in the cell phone state of charge.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage CellStateofChargeRelUpReg;

/**
 * The get message of the property "InComingCallEvent"
 * This notifies HMI when an incoming call arrives.  HMI needs to subscribe on this interface during initialization.  Once subscribed it does not expire untill cleared using notification interface..
 */
typedef ::asf::cca::CcaTypes::DefaultMessage InComingCallEventGet;

/**
 * The upreg message of the property "InComingCallEvent"
 * This notifies HMI when an incoming call arrives.  HMI needs to subscribe on this interface during initialization.  Once subscribed it does not expire untill cleared using notification interface..
 */
typedef ::asf::cca::CcaTypes::DefaultMessage InComingCallEventUpReg;

/**
 * The relUpReg message of the property "InComingCallEvent"
 * This notifies HMI when an incoming call arrives.  HMI needs to subscribe on this interface during initialization.  Once subscribed it does not expire untill cleared using notification interface..
 */
typedef ::asf::cca::CcaTypes::DefaultMessage InComingCallEventRelUpReg;

/**
 * The get message of the property "NetworkOperator"
 * Used by HMI to get the name of the cell network operator.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage NetworkOperatorGet;

/**
 * The upreg message of the property "NetworkOperator"
 * Used by HMI to get the name of the cell network operator.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage NetworkOperatorUpReg;

/**
 * The relUpReg message of the property "NetworkOperator"
 * Used by HMI to get the name of the cell network operator.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage NetworkOperatorRelUpReg;

/**
 * The get message of the property "SLCStatus"
 * Returns Blue tooth Serial Link Connection status.  HMI needs to to tell if call dropped due to SLC lost.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SLCStatusGet;

/**
 * The upreg message of the property "SLCStatus"
 * Returns Blue tooth Serial Link Connection status.  HMI needs to to tell if call dropped due to SLC lost.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SLCStatusUpReg;

/**
 * The relUpReg message of the property "SLCStatus"
 * Returns Blue tooth Serial Link Connection status.  HMI needs to to tell if call dropped due to SLC lost.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SLCStatusRelUpReg;

/**
 * The get message of the property "VehicleAudio"
 * May be needed by Audio Video, who is using Audio.  If the Telephone FBlock does not hold any Audio channel set it to FALSE,  If it holds an audio channel, set it to TRUE.
 * in 1.4.1 made it a notification
 */
typedef ::asf::cca::CcaTypes::DefaultMessage VehicleAudioGet;

/**
 * The upreg message of the property "VehicleAudio"
 * May be needed by Audio Video, who is using Audio.  If the Telephone FBlock does not hold any Audio channel set it to FALSE,  If it holds an audio channel, set it to TRUE.
 * in 1.4.1 made it a notification
 */
typedef ::asf::cca::CcaTypes::DefaultMessage VehicleAudioUpReg;

/**
 * The relUpReg message of the property "VehicleAudio"
 * May be needed by Audio Video, who is using Audio.  If the Telephone FBlock does not hold any Audio channel set it to FALSE,  If it holds an audio channel, set it to TRUE.
 * in 1.4.1 made it a notification
 */
typedef ::asf::cca::CcaTypes::DefaultMessage VehicleAudioRelUpReg;

/**
 * The get message of the property "MicrophoneMuteState"
 * The MicrophoneMuteState Property allows HMI controllers to mute the Telephone microphone and synchronize HMI presentation to the mute state.  Note that although this function may seem to be redundant to the ISink.Mute function also on the Telphone FBlock, ISink.Mute is not intended to be manipulated by HMI controllers.  HMI controllers should use MicrophoneMuteState instead.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage MicrophoneMuteStateGet;

/**
 * The upreg message of the property "MicrophoneMuteState"
 * The MicrophoneMuteState Property allows HMI controllers to mute the Telephone microphone and synchronize HMI presentation to the mute state.  Note that although this function may seem to be redundant to the ISink.Mute function also on the Telphone FBlock, ISink.Mute is not intended to be manipulated by HMI controllers.  HMI controllers should use MicrophoneMuteState instead.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage MicrophoneMuteStateUpReg;

/**
 * The relUpReg message of the property "MicrophoneMuteState"
 * The MicrophoneMuteState Property allows HMI controllers to mute the Telephone microphone and synchronize HMI presentation to the mute state.  Note that although this function may seem to be redundant to the ISink.Mute function also on the Telphone FBlock, ISink.Mute is not intended to be manipulated by HMI controllers.  HMI controllers should use MicrophoneMuteState instead.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage MicrophoneMuteStateRelUpReg;

/**
 * The get message of the property "RingtoneMuteState"
 * The RingtoneMuteState Property allows HMI controllers to mute the ring tone from the telephone synchronize ther HMI presentation to the mute state.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage RingtoneMuteStateGet;

/**
 * The upreg message of the property "RingtoneMuteState"
 * The RingtoneMuteState Property allows HMI controllers to mute the ring tone from the telephone synchronize ther HMI presentation to the mute state.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage RingtoneMuteStateUpReg;

/**
 * The relUpReg message of the property "RingtoneMuteState"
 * The RingtoneMuteState Property allows HMI controllers to mute the ring tone from the telephone synchronize ther HMI presentation to the mute state.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage RingtoneMuteStateRelUpReg;

/**
 * The get message of the property "HFService"
 * This property is fetched from AG and notified upon connection to a phone device so that HMI could properly display Call waiting and Three way calling service availability.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage HFServiceGet;

/**
 * The upreg message of the property "HFService"
 * This property is fetched from AG and notified upon connection to a phone device so that HMI could properly display Call waiting and Three way calling service availability.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage HFServiceUpReg;

/**
 * The relUpReg message of the property "HFService"
 * This property is fetched from AG and notified upon connection to a phone device so that HMI could properly display Call waiting and Three way calling service availability.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage HFServiceRelUpReg;

/**
 * The get message of the property "BTDeviceVoiceRecognition"
 * This property is used to activate and deactive the remote device's
 * internal voice recognition that may be used, for example, to also perform
 * 'cloud-based' voice recognition on the Internet as follows:
 *
 *
 * <item>
 * HMI controllers register for notification on this property at
 * initialization.
 * </item>
 * <item>
 * HMI controllers activate this property via a Set(ACTIVE) message.
 * </item>
 * <item>
 * Upon receipt of a Set(ACTIVE), the FBlock either:
 *
 *
 * </item><item>
 * Activates the remote device VR if supported by the device and
 * responds with a Status(ACTIVE) notification to all registered
 * controllers, or
 * </item>
 * <item>
 * If for any reason, the remote device VR cannot be activated in
 * response to the Set, the FBlock issues another Status(INACTIVE) to
 * all registered controllers. Note that the FBlock does NOT issue an
 * Error message if remote VR is not supported by the device.
 * </item>
 *
 * <item>The BTDeviceVoiceRecSupported flag reports whether or not the current outgoing source device supports remote Bluetooth device voice rec or not.
 * </item>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage BTDeviceVoiceRecognitionGet;

/**
 * The upreg message of the property "BTDeviceVoiceRecognition"
 * This property is used to activate and deactive the remote device's
 * internal voice recognition that may be used, for example, to also perform
 * 'cloud-based' voice recognition on the Internet as follows:
 *
 *
 * <item>
 * HMI controllers register for notification on this property at
 * initialization.
 * </item>
 * <item>
 * HMI controllers activate this property via a Set(ACTIVE) message.
 * </item>
 * <item>
 * Upon receipt of a Set(ACTIVE), the FBlock either:
 *
 *
 * </item><item>
 * Activates the remote device VR if supported by the device and
 * responds with a Status(ACTIVE) notification to all registered
 * controllers, or
 * </item>
 * <item>
 * If for any reason, the remote device VR cannot be activated in
 * response to the Set, the FBlock issues another Status(INACTIVE) to
 * all registered controllers. Note that the FBlock does NOT issue an
 * Error message if remote VR is not supported by the device.
 * </item>
 *
 * <item>The BTDeviceVoiceRecSupported flag reports whether or not the current outgoing source device supports remote Bluetooth device voice rec or not.
 * </item>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage BTDeviceVoiceRecognitionUpReg;

/**
 * The relUpReg message of the property "BTDeviceVoiceRecognition"
 * This property is used to activate and deactive the remote device's
 * internal voice recognition that may be used, for example, to also perform
 * 'cloud-based' voice recognition on the Internet as follows:
 *
 *
 * <item>
 * HMI controllers register for notification on this property at
 * initialization.
 * </item>
 * <item>
 * HMI controllers activate this property via a Set(ACTIVE) message.
 * </item>
 * <item>
 * Upon receipt of a Set(ACTIVE), the FBlock either:
 *
 *
 * </item><item>
 * Activates the remote device VR if supported by the device and
 * responds with a Status(ACTIVE) notification to all registered
 * controllers, or
 * </item>
 * <item>
 * If for any reason, the remote device VR cannot be activated in
 * response to the Set, the FBlock issues another Status(INACTIVE) to
 * all registered controllers. Note that the FBlock does NOT issue an
 * Error message if remote VR is not supported by the device.
 * </item>
 *
 * <item>The BTDeviceVoiceRecSupported flag reports whether or not the current outgoing source device supports remote Bluetooth device voice rec or not.
 * </item>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage BTDeviceVoiceRecognitionRelUpReg;

/**
 * The get message of the property "HandsFreeEnhancedCallControl"
 * The HandsFreeEnhancedCallControl property is defined in order to allow HMI
 * controllers to know whether or not a particular phone device supports
 * enhanced call control features such as unmerging a conference call or
 * ending an individual call within a conference call as follows:
 *
 *
 * <item>
 * HMI controllers shall register for notification of the
 * HFEnhancedCallControl property at initialization.
 * </item>
 * <item>
 * The HFEnhancedCallControl property shall support two Boolean
 * parameters, EndTargetCall and SplitMergeCalls that shall be set
 * according to the following table:
 *
 * </item>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage HandsFreeEnhancedCallControlGet;

/**
 * The upreg message of the property "HandsFreeEnhancedCallControl"
 * The HandsFreeEnhancedCallControl property is defined in order to allow HMI
 * controllers to know whether or not a particular phone device supports
 * enhanced call control features such as unmerging a conference call or
 * ending an individual call within a conference call as follows:
 *
 *
 * <item>
 * HMI controllers shall register for notification of the
 * HFEnhancedCallControl property at initialization.
 * </item>
 * <item>
 * The HFEnhancedCallControl property shall support two Boolean
 * parameters, EndTargetCall and SplitMergeCalls that shall be set
 * according to the following table:
 *
 * </item>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage HandsFreeEnhancedCallControlUpReg;

/**
 * The relUpReg message of the property "HandsFreeEnhancedCallControl"
 * The HandsFreeEnhancedCallControl property is defined in order to allow HMI
 * controllers to know whether or not a particular phone device supports
 * enhanced call control features such as unmerging a conference call or
 * ending an individual call within a conference call as follows:
 *
 *
 * <item>
 * HMI controllers shall register for notification of the
 * HFEnhancedCallControl property at initialization.
 * </item>
 * <item>
 * The HFEnhancedCallControl property shall support two Boolean
 * parameters, EndTargetCall and SplitMergeCalls that shall be set
 * according to the following table:
 *
 * </item>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage HandsFreeEnhancedCallControlRelUpReg;

/**
 * The get message of the property "SystemWideRingtonesList"
 * Provides the system wide ringtone list with the currently selected ringtone.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SystemWideRingtonesListGet;

/**
 * The upreg message of the property "SystemWideRingtonesList"
 * Provides the system wide ringtone list with the currently selected ringtone.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SystemWideRingtonesListUpReg;

/**
 * The relUpReg message of the property "SystemWideRingtonesList"
 * Provides the system wide ringtone list with the currently selected ringtone.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SystemWideRingtonesListRelUpReg;

/**
 * The error message of 'SystemWideRingtonesList'
 */
typedef ::asf::cca::CcaTypes::DefaultError SystemWideRingtonesListError;

/**
 * The get message of the property "DeviceRingtoneList"
 * Provides a list of each paired phones with its currently selected ringtone.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DeviceRingtoneListGet;

/**
 * The upreg message of the property "DeviceRingtoneList"
 * Provides a list of each paired phones with its currently selected ringtone.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DeviceRingtoneListUpReg;

/**
 * The relUpReg message of the property "DeviceRingtoneList"
 * Provides a list of each paired phones with its currently selected ringtone.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DeviceRingtoneListRelUpReg;

/**
 * The error message of 'DeviceRingtoneList'
 */
typedef ::asf::cca::CcaTypes::DefaultError DeviceRingtoneListError;

/**
 * The get message of the property "SuppressRingtoneOnOffList"
 * Provides a list of each paired phones with its current suppress ringtone state.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SuppressRingtoneOnOffListGet;

/**
 * The upreg message of the property "SuppressRingtoneOnOffList"
 * Provides a list of each paired phones with its current suppress ringtone state.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SuppressRingtoneOnOffListUpReg;

/**
 * The relUpReg message of the property "SuppressRingtoneOnOffList"
 * Provides a list of each paired phones with its current suppress ringtone state.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SuppressRingtoneOnOffListRelUpReg;

/**
 * The error message of 'SuppressRingtoneOnOffList'
 */
typedef ::asf::cca::CcaTypes::DefaultError SuppressRingtoneOnOffListError;

/**
 * The get message of the property "AutoWaitingModeOnOffList"
 * Provides a list of each paired phones with its current auto waiting mode state.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage AutoWaitingModeOnOffListGet;

/**
 * The upreg message of the property "AutoWaitingModeOnOffList"
 * Provides a list of each paired phones with its current auto waiting mode state.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage AutoWaitingModeOnOffListUpReg;

/**
 * The relUpReg message of the property "AutoWaitingModeOnOffList"
 * Provides a list of each paired phones with its current auto waiting mode state.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage AutoWaitingModeOnOffListRelUpReg;

/**
 * The error message of 'AutoWaitingModeOnOffList'
 */
typedef ::asf::cca::CcaTypes::DefaultError AutoWaitingModeOnOffListError;

/**
 * The get message of the property "RingtonePlaybackStatus"
 * Provides the vehicle ringtone playback state. This property is applicable only for the Play and Stop ringtone
 * requests from clients and not applicable for playing vehicle ringtone for an incoming call.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage RingtonePlaybackStatusGet;

/**
 * The upreg message of the property "RingtonePlaybackStatus"
 * Provides the vehicle ringtone playback state. This property is applicable only for the Play and Stop ringtone
 * requests from clients and not applicable for playing vehicle ringtone for an incoming call.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage RingtonePlaybackStatusUpReg;

/**
 * The relUpReg message of the property "RingtonePlaybackStatus"
 * Provides the vehicle ringtone playback state. This property is applicable only for the Play and Stop ringtone
 * requests from clients and not applicable for playing vehicle ringtone for an incoming call.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage RingtonePlaybackStatusRelUpReg;

/**
 * The error message of 'RingtonePlaybackStatus'
 */
typedef ::asf::cca::CcaTypes::DefaultError RingtonePlaybackStatusError;

/**
 * The abort error message of the method "Allocate"
 * The Allocate method causes the source to occupy bandwidth for streaming data.
 */
typedef ::asf::cca::CcaTypes::DefaultError AllocateAbortError;

/**
 * The abort error message of the method "DeAllocate"
 * The method DeAllocate causes the source to free occupied Streaming bandwidth.
 */
typedef ::asf::cca::CcaTypes::DefaultError DeAllocateAbortError;

/**
 * The abort error message of the method "SourceActivity"
 * This method controls the activity of a source.
 *
 * Note that the PAUSE state is not allowed for the General Motors implementation and is thus not defined as an allowed state within the enumeration.
 */
typedef ::asf::cca::CcaTypes::DefaultError SourceActivityAbortError;

/**
 * The abort error message of the method "AcceptCall"
 * Accepts an Incoming call - for single or multiple call.  Does not Block.
 */
typedef ::asf::cca::CcaTypes::DefaultError AcceptCallAbortError;

/**
 * The abort error message of the method "CancelOutgoingCall"
 * Used to cancel an outgoing call that is not connected.  Notifications are no longer sent once a call becomes IDLE..
 */
typedef ::asf::cca::CcaTypes::DefaultError CancelOutgoingCallAbortError;

/**
 * The abort error message of the method "ConferenceIn"
 * Joins or conferences in all ACTIVE, ONHOLD, and WAITING calls.
 */
typedef ::asf::cca::CcaTypes::DefaultError ConferenceInAbortError;

/**
 * The abort error message of the method "HangUpCall"
 * Request Termination of a call.  Also can be used iteratively for Multiple call situation.  Returns CallStatus when call is relesed from network.
 */
typedef ::asf::cca::CcaTypes::DefaultError HangUpCallAbortError;

/**
 * The abort error message of the method "HoldCall"
 * Holds a voice call.  Also, Can be used  prior to ConferenceIn method.
 */
typedef ::asf::cca::CcaTypes::DefaultError HoldCallAbortError;

/**
 * The abort error message of the method "IgnoreCall"
 * Used in F&B to send incoming call to voice mail.
 */
typedef ::asf::cca::CcaTypes::DefaultError IgnoreCallAbortError;

/**
 * The abort error message of the method "RejectCall"
 * Reject an Incoming call.  Does not accept the call or sends to voice mail, request disconnection to the network. This is currently not required by HMI.
 */
typedef ::asf::cca::CcaTypes::DefaultError RejectCallAbortError;

/**
 * The abort error message of the method "ResumeCall"
 * Resume a  Call on hold.
 */
typedef ::asf::cca::CcaTypes::DefaultError ResumeCallAbortError;

/**
 * The abort error message of the method "SendDTMF"
 * Sends DTMF tones to the network.
 */
typedef ::asf::cca::CcaTypes::DefaultError SendDTMFAbortError;

/**
 * The abort error message of the method "SpeedDial"
 * Dials using data from a specific location from the BT AG device.  Telephone uses ATD (number) command to originate call.
 */
typedef ::asf::cca::CcaTypes::DefaultError SpeedDialAbortError;

/**
 * The abort error message of the method "SplitCall"
 * Separates (un_merges) call from the conference call and makes it the ACTIVE call, all calls in the conference are put on ON HOLD.
 */
typedef ::asf::cca::CcaTypes::DefaultError SplitCallAbortError;

/**
 * The abort error message of the method "SwapCall"
 * If there is an ACTIVE ( call 1)  call and a call ON HOLD ( call 2) , calls are exchanged.  After successful execution Call 1 will be ON HOLD and call 2 will be ACTIVE.  Success returns status of ACTIVE call instance.s
 */
typedef ::asf::cca::CcaTypes::DefaultError SwapCallAbortError;

/**
 * The start message of the method "TransferCallToHandset"
 * Called by HMI controllers to transfer all calls, ACTIVE, ON HOLD, or CONFERENCE are sent to the currently active handset device.  No call instance is used as could be multiple calls could be moved to handset.  Essentially transferring audio rather than individual call.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage TransferCallToHandsetStart;

/**
 * The result message of the method "TransferCallToHandset"
 * Called by HMI controllers to transfer all calls, ACTIVE, ON HOLD, or CONFERENCE are sent to the currently active handset device.  No call instance is used as could be multiple calls could be moved to handset.  Essentially transferring audio rather than individual call.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage TransferCallToHandsetResult;

/**
 * The abort error message of the method "TransferCallToHandset"
 * Called by HMI controllers to transfer all calls, ACTIVE, ON HOLD, or CONFERENCE are sent to the currently active handset device.  No call instance is used as could be multiple calls could be moved to handset.  Essentially transferring audio rather than individual call.
 */
typedef ::asf::cca::CcaTypes::DefaultError TransferCallToHandsetAbortError;

/**
 * The abort error message of the method "TransferCallToVehicle"
 * This Method is called by HMI controllers to transfer the call from a particular device to the Vehicle.  The DeviceHandle must be a valid device handle for one of the paired phones within the Bluetooth Settings FBlock.  It may not be the protected 0=Null value.
 */
typedef ::asf::cca::CcaTypes::DefaultError TransferCallToVehicleAbortError;

/**
 * The abort error message of the method "VoiceMail"
 * HMI needs to know the voice mail number of the currently connected Phone.
 */
typedef ::asf::cca::CcaTypes::DefaultError VoiceMailAbortError;

/**
 * The abort error message of the method "Dial"
 * Start an outgoing call.Controllers use the CallInstance parameter
 * in the ResultAck to track the status of the call via
 * CallStatusNotice.Status notifications.
 */
typedef ::asf::cca::CcaTypes::DefaultError DialAbortError;

/**
 * The abort error message of the method "QueryTelephoneNumber"
 * Returns Telephone Number give a call instance.
 */
typedef ::asf::cca::CcaTypes::DefaultError QueryTelephoneNumberAbortError;

/**
 * The abort error message of the method "AcquireTelephoneNumber"
 * The AcquireTelephoneNumber method is defined in order to allow HMI
 * controllers to receive the telephone number of a device as follows:
 *
 *
 * <item>
 * The DeviceHandle parameter in the StartResultAck contains the
 * DeviceHandle of the device for which the telephone number is requested.
 * </item>
 * <item>
 * The telephone number acquired from the device is reported as a string
 * in the TelephoneNumber parameter.
 * </item>
 * <item>
 * If the DeviceHandle is invalid or the telephone number cannot be
 * acquired from the requested device for any reason, the FBlock shall
 * respond with a ResultAck(TelephoneNumber == NULL, zero-length string).
 * HMI controllers can use the NULL TelephoneNumber in order to report to
 * the user that the telephone number could not be acquired
 * </item>
 * <item>
 * Note that the VoiceMail 0x21C function cannot be reliably used to
 * acquire the device telephone number because the user can change their
 * voice mail number to another seqence. AcquireTelephoneNumber returns,
 * if successful, the telephone number of the device.
 * </item>
 * <item>
 * This method is used, for example, to allow the HMI to automatically
 * send a text message to the outgoing source device with the ValetMode
 * PIN. However, in order to do this, the HMI needs the telephone number
 * of the device.
 * </item>
 */
typedef ::asf::cca::CcaTypes::DefaultError AcquireTelephoneNumberAbortError;

/**
 * The abort error message of the method "Redial"
 * deprecated
 * As of V4.3, this function is permanently deprecated and will not be supported by the Telephone FBlock by any device for the life of Next-Gen Infotainment architecture.
 *
 * For documentation purposes, this is the description from the last revision, 3.0.
 *
 * Redials the last dialed in the currently selected outgoing call device.
 * Note that this function relies on the device to choose the last dialed
 * number in that device.Controllers use the CallInstance parameter
 * in the ResultAck to track the status of the call via
 * CallStatusNotice.Status notifications.
 */
typedef ::asf::cca::CcaTypes::DefaultError RedialAbortError;

/**
 * The result message of the method "SetRingtone"
 * Set the active ringtone for system wide or device specific.
 * If the DeviceAddress string is ALL, then the received RingtoneID is set for all the paired devices
 * treating it as a system wide ringtone. The setting will be applicable also for the devices that are
 * paired after the API is invoked.
 *
 * The updated system wide ringtone will be available in the SystemWideRingtonesList property.
 * The updated device specific ringtone will be available in the DeviceRingtoneList property.
 *
 * Note: - The setting will be retained persistently by Phone F-Block
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SetRingtoneResult;

/**
 * The abort error message of the method "SetRingtone"
 * Set the active ringtone for system wide or device specific.
 * If the DeviceAddress string is ALL, then the received RingtoneID is set for all the paired devices
 * treating it as a system wide ringtone. The setting will be applicable also for the devices that are
 * paired after the API is invoked.
 *
 * The updated system wide ringtone will be available in the SystemWideRingtonesList property.
 * The updated device specific ringtone will be available in the DeviceRingtoneList property.
 *
 * Note: - The setting will be retained persistently by Phone F-Block
 */
typedef ::asf::cca::CcaTypes::DefaultError SetRingtoneAbortError;

/**
 * The result message of the method "PlayRingtone"
 * Plays the selected ringtone.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage PlayRingtoneResult;

/**
 * The abort error message of the method "PlayRingtone"
 * Plays the selected ringtone.
 */
typedef ::asf::cca::CcaTypes::DefaultError PlayRingtoneAbortError;

/**
 * The start message of the method "StopRingtone"
 * Stops the ringtone that is currently being played.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage StopRingtoneStart;

/**
 * The result message of the method "StopRingtone"
 * Stops the ringtone that is currently being played.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage StopRingtoneResult;

/**
 * The abort error message of the method "StopRingtone"
 * Stops the ringtone that is currently being played.
 */
typedef ::asf::cca::CcaTypes::DefaultError StopRingtoneAbortError;

/**
 * The result message of the method "SuppressRingtoneOnOff"
 * Provides the ability to set the ringtone on or off in the vehicle when an incoming call is received.
 * If the DeviceAddress string is ALL, then the received setting is set for all the paired devices treating it as a system wide setting.
 * The same will be applicable also for the devices that are paired after the API is invoked.
 *
 * The updated changes will be available in the SuppressRingtoneOnOffList property.
 *
 * Note: - The setting will be retained persistently by PM
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SuppressRingtoneOnOffResult;

/**
 * The abort error message of the method "SuppressRingtoneOnOff"
 * Provides the ability to set the ringtone on or off in the vehicle when an incoming call is received.
 * If the DeviceAddress string is ALL, then the received setting is set for all the paired devices treating it as a system wide setting.
 * The same will be applicable also for the devices that are paired after the API is invoked.
 *
 * The updated changes will be available in the SuppressRingtoneOnOffList property.
 *
 * Note: - The setting will be retained persistently by PM
 */
typedef ::asf::cca::CcaTypes::DefaultError SuppressRingtoneOnOffAbortError;

/**
 * The result message of the method "AutoWaitingModeOnOff"
 * Provides the ability to enable or disable the auto waiting mode when an incoming call is received. When the setting is enabled,
 * an incoming call will be automatically put on waiting mode and the waiting mode tone will be heard in the far end.
 *
 * If the DeviceAddress string is ALL, then the setting is set for all the paired devices treating it as a system wide setting.
 * The setting will be applicable for the devices that are paired after the API is invoked.
 *
 * The updated changes will be available in the AutoWaitingModeOnOffList property.
 *
 * Note: - The setting will be retained persistently by PM
 */
typedef ::asf::cca::CcaTypes::DefaultMessage AutoWaitingModeOnOffResult;

/**
 * The abort error message of the method "AutoWaitingModeOnOff"
 * Provides the ability to enable or disable the auto waiting mode when an incoming call is received. When the setting is enabled,
 * an incoming call will be automatically put on waiting mode and the waiting mode tone will be heard in the far end.
 *
 * If the DeviceAddress string is ALL, then the setting is set for all the paired devices treating it as a system wide setting.
 * The setting will be applicable for the devices that are paired after the API is invoked.
 *
 * The updated changes will be available in the AutoWaitingModeOnOffList property.
 *
 * Note: - The setting will be retained persistently by PM
 */
typedef ::asf::cca::CcaTypes::DefaultError AutoWaitingModeOnOffAbortError;

/**
 * The get message of the property "WaitingModeFilePath"
 * This interface is used to Set and Get the filepath of NarrowBand and WideBand audio files.
 * One of these files will be played by the Phone F-Block during active waiting mode state based on the
 * audio codec (NarrowBand/Wideband) supported by the connected Bluetooth Phone device.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage WaitingModeFilePathGet;

/**
 * The upreg message of the property "WaitingModeFilePath"
 * This interface is used to Set and Get the filepath of NarrowBand and WideBand audio files.
 * One of these files will be played by the Phone F-Block during active waiting mode state based on the
 * audio codec (NarrowBand/Wideband) supported by the connected Bluetooth Phone device.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage WaitingModeFilePathUpReg;

/**
 * The relUpReg message of the property "WaitingModeFilePath"
 * This interface is used to Set and Get the filepath of NarrowBand and WideBand audio files.
 * One of these files will be played by the Phone F-Block during active waiting mode state based on the
 * audio codec (NarrowBand/Wideband) supported by the connected Bluetooth Phone device.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage WaitingModeFilePathRelUpReg;

/**
 * The get message of the property "BTDeviceVoiceRecognitionExtended"
 * This is the extension of the Property "BTDeviceVoiceRecognition" with the new parameter e8SiriAvailabilityState.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage BTDeviceVoiceRecognitionExtendedGet;

/**
 * The upreg message of the property "BTDeviceVoiceRecognitionExtended"
 * This is the extension of the Property "BTDeviceVoiceRecognition" with the new parameter e8SiriAvailabilityState.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage BTDeviceVoiceRecognitionExtendedUpReg;

/**
 * The relUpReg message of the property "BTDeviceVoiceRecognitionExtended"
 * This is the extension of the Property "BTDeviceVoiceRecognition" with the new parameter e8SiriAvailabilityState.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage BTDeviceVoiceRecognitionExtendedRelUpReg;

/**
 * The get message of the property "CallStatusNoticeExtended"
 * Other component can get status of a CallInstance using this notification.
 * Telephone component notifies when a status changes , and ends status
 * update when the CallStatus becomes IDLE. Needs valid Callinstance.
 * Callinstances are created on an incoming call event or an outgoing call
 * request.IMPORTANT: When there are no calls currently active, the
 * Status response of this property cannot be an empty stream as an empty
 * payload MHP message is incompatible with the current (as of this release)
 * implemenation of NetServices. Instead, when no calls are active, the
 * following &quot;null&quot; Status response shall be returned:
 *
 *
 * <item>
 * CallInstance = 0xFF
 * </item>
 * <item>
 * CallStatus = IDLE
 * </item>
 * <item>
 * UsingVehicleAudio = False
 * </item>
 * <item>
 * CallDurationXX = 0
 * </item>
 * <item>
 * DeviceHandle=0xFF
 * </item>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage CallStatusNoticeExtendedGet;

/**
 * The upreg message of the property "CallStatusNoticeExtended"
 * Other component can get status of a CallInstance using this notification.
 * Telephone component notifies when a status changes , and ends status
 * update when the CallStatus becomes IDLE. Needs valid Callinstance.
 * Callinstances are created on an incoming call event or an outgoing call
 * request.IMPORTANT: When there are no calls currently active, the
 * Status response of this property cannot be an empty stream as an empty
 * payload MHP message is incompatible with the current (as of this release)
 * implemenation of NetServices. Instead, when no calls are active, the
 * following &quot;null&quot; Status response shall be returned:
 *
 *
 * <item>
 * CallInstance = 0xFF
 * </item>
 * <item>
 * CallStatus = IDLE
 * </item>
 * <item>
 * UsingVehicleAudio = False
 * </item>
 * <item>
 * CallDurationXX = 0
 * </item>
 * <item>
 * DeviceHandle=0xFF
 * </item>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage CallStatusNoticeExtendedUpReg;

/**
 * The relUpReg message of the property "CallStatusNoticeExtended"
 * Other component can get status of a CallInstance using this notification.
 * Telephone component notifies when a status changes , and ends status
 * update when the CallStatus becomes IDLE. Needs valid Callinstance.
 * Callinstances are created on an incoming call event or an outgoing call
 * request.IMPORTANT: When there are no calls currently active, the
 * Status response of this property cannot be an empty stream as an empty
 * payload MHP message is incompatible with the current (as of this release)
 * implemenation of NetServices. Instead, when no calls are active, the
 * following &quot;null&quot; Status response shall be returned:
 *
 *
 * <item>
 * CallInstance = 0xFF
 * </item>
 * <item>
 * CallStatus = IDLE
 * </item>
 * <item>
 * UsingVehicleAudio = False
 * </item>
 * <item>
 * CallDurationXX = 0
 * </item>
 * <item>
 * DeviceHandle=0xFF
 * </item>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage CallStatusNoticeExtendedRelUpReg;

/**
 * The get message of the property "ActivePhoneDevice"
 * This property gives the device handle of the current active device.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ActivePhoneDeviceGet;

/**
 * The upreg message of the property "ActivePhoneDevice"
 * This property gives the device handle of the current active device.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ActivePhoneDeviceUpReg;

/**
 * The relUpReg message of the property "ActivePhoneDevice"
 * This property gives the device handle of the current active device.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ActivePhoneDeviceRelUpReg;

/**
 * The error message of 'ActivePhoneDevice'
 */
typedef ::asf::cca::CcaTypes::DefaultError ActivePhoneDeviceError;

/**
 * The upreg message of the property "OutgoingCallFailedEvent"
 * This property updates the Outgoing call Failed Events
 */
typedef ::asf::cca::CcaTypes::DefaultMessage OutgoingCallFailedEventUpReg;

/**
 * The relUpReg message of the property "OutgoingCallFailedEvent"
 * This property updates the Outgoing call Failed Events
 */
typedef ::asf::cca::CcaTypes::DefaultMessage OutgoingCallFailedEventRelUpReg;

/**
 * The error message of 'OutgoingCallFailedEvent'
 */
typedef ::asf::cca::CcaTypes::DefaultError OutgoingCallFailedEventError;

/**
 * The upreg message of the property "IncomingCallRejectedEvent"
 * This property updates the Incoming call Rejected Events
 */
typedef ::asf::cca::CcaTypes::DefaultMessage IncomingCallRejectedEventUpReg;

/**
 * The relUpReg message of the property "IncomingCallRejectedEvent"
 * This property updates the Incoming call Rejected Events
 */
typedef ::asf::cca::CcaTypes::DefaultMessage IncomingCallRejectedEventRelUpReg;

/**
 * The error message of 'IncomingCallRejectedEvent'
 */
typedef ::asf::cca::CcaTypes::DefaultError IncomingCallRejectedEventError;

/**
 * The get message of the property "WaitingModeState"
 * This property provides the waiting mode status.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage WaitingModeStateGet;

/**
 * The upreg message of the property "WaitingModeState"
 * This property provides the waiting mode status.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage WaitingModeStateUpReg;

/**
 * The relUpReg message of the property "WaitingModeState"
 * This property provides the waiting mode status.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage WaitingModeStateRelUpReg;

/**
 * The error message of 'WaitingModeState'
 */
typedef ::asf::cca::CcaTypes::DefaultError WaitingModeStateError;

/**
 * The get message of the property "ExternalVRState"
 * This property shall update the state of External VR session to the clients
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ExternalVRStateGet;

/**
 * The upreg message of the property "ExternalVRState"
 * This property shall update the state of External VR session to the clients
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ExternalVRStateUpReg;

/**
 * The relUpReg message of the property "ExternalVRState"
 * This property shall update the state of External VR session to the clients
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ExternalVRStateRelUpReg;

/**
 * The error message of 'ExternalVRState'
 */
typedef ::asf::cca::CcaTypes::DefaultError ExternalVRStateError;

/**
 * The upreg message of the property "CallOperationFailedEvent"
 * This property is updated when any of the below mentioned call operation fails:
 * 1. Accept Call
 * 2. Hangup Call
 * 3. Swap Call
 * 4. Conference Call
 * 5. Split call
 * Hint:- The error notifications shall be reported to the clients only when the call operations are triggered from the HU.
 * This property is updated only in the redesign component - PM, Legacy phone component does not support this property.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage CallOperationFailedEventUpReg;

/**
 * The relUpReg message of the property "CallOperationFailedEvent"
 * This property is updated when any of the below mentioned call operation fails:
 * 1. Accept Call
 * 2. Hangup Call
 * 3. Swap Call
 * 4. Conference Call
 * 5. Split call
 * Hint:- The error notifications shall be reported to the clients only when the call operations are triggered from the HU.
 * This property is updated only in the redesign component - PM, Legacy phone component does not support this property.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage CallOperationFailedEventRelUpReg;

/**
 * The error message of 'CallOperationFailedEvent'
 */
typedef ::asf::cca::CcaTypes::DefaultError CallOperationFailedEventError;

/**
 * The upreg message of the property "SendDTMFFailedEvent"
 * This property updates the DTMF Failed Events.
 * This property is updated only in the redesign component - PM, Legacy phone component does not support this property.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SendDTMFFailedEventUpReg;

/**
 * The relUpReg message of the property "SendDTMFFailedEvent"
 * This property updates the DTMF Failed Events.
 * This property is updated only in the redesign component - PM, Legacy phone component does not support this property.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SendDTMFFailedEventRelUpReg;

/**
 * The error message of 'SendDTMFFailedEvent'
 */
typedef ::asf::cca::CcaTypes::DefaultError SendDTMFFailedEventError;

/**
 * The upreg message of the property "AudioTransferFailedEvent"
 * This property updates the Audio Transfer Failed Events.
 * This property is updated only in the redesign component - PM, Legacy phone component does not support this property.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage AudioTransferFailedEventUpReg;

/**
 * The relUpReg message of the property "AudioTransferFailedEvent"
 * This property updates the Audio Transfer Failed Events.
 * This property is updated only in the redesign component - PM, Legacy phone component does not support this property.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage AudioTransferFailedEventRelUpReg;

/**
 * The error message of 'AudioTransferFailedEvent'
 */
typedef ::asf::cca::CcaTypes::DefaultError AudioTransferFailedEventError;

/**
 * The abort error message of the method "StartStopWaitingMode"
 * This Method is used to start or stop the waiting mode.
 * Waiting mode is similar to Active call except that waiting message
 * from the provide file path is played to the remote end caller
 * instead of the Mic output.
 */
typedef ::asf::cca::CcaTypes::DefaultError StartStopWaitingModeAbortError;

/**
 * The abort error message of the method "DialExtended"
 * This method extends the original method Dial by the additional parameter Name. This Name can be set by the client according to its needs or can be left empty. The Name will be reported in the property CallStatusNoticeExtended beside the TelephoneNumber and the call status information.
 *
 * Start an outgoing call to the given number.
 * - The call will be started on the connected OSD phone device (Outgoing Source Device).
 * - Clients track the status of the call via CallStatusNoticeExtended.Status notifications.
 * - The provided Name will occur in the CallStatusNoticeExtended.Status notifications for the related call instance as long as the received phone number, reported from the phone device (CLIP information) still corresponds to the dialed one.
 *
 * - An Error message might be returned, if a provided parameter is invalid or similar or if the phone device does not accept the dial request.
 */
typedef ::asf::cca::CcaTypes::DefaultError DialExtendedAbortError;

/**
 * The result message of the method "SetActivePhone"
 * Method to set a device as an Active device and subsequently the active device will be made Passive.
 * After switching, ActivePhoneDevice property is updated with the Device handle of the current Active device.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SetActivePhoneResult;

/**
 * The abort error message of the method "SetActivePhone"
 * Method to set a device as an Active device and subsequently the active device will be made Passive.
 * After switching, ActivePhoneDevice property is updated with the Device handle of the current Active device.
 */
typedef ::asf::cca::CcaTypes::DefaultError SetActivePhoneAbortError;

/**
 * The result message of the method "ActivateExternalVR"
 * The method ActivateExternalVR would be used to activate the external VR session. The responsibilities of Phone Middleware is to:
 * a.    Allocate the VR channel.
 * b.    Stream the VR audio when the SCO channel is established.
 * The External VR state are updated to clients through the interface "ExternalVRState"
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ActivateExternalVRResult;

/**
 * The abort error message of the method "ActivateExternalVR"
 * The method ActivateExternalVR would be used to activate the external VR session. The responsibilities of Phone Middleware is to:
 * a.    Allocate the VR channel.
 * b.    Stream the VR audio when the SCO channel is established.
 * The External VR state are updated to clients through the interface "ExternalVRState"
 */
typedef ::asf::cca::CcaTypes::DefaultError ActivateExternalVRAbortError;

/**
 * The result message of the method "DeActivateExternalVR"
 * The method DeActivateExternalVR would be used to De-activate the external VR session. The responsibilities of Phone Middleware is to:
 * a. Stop streaming the VR audio when the SCO channel is disconnected
 * b. Deallocate the VR channel.
 * The External VR state are updated to clients through the interface "ExternalVRState"
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DeActivateExternalVRResult;

/**
 * The abort error message of the method "DeActivateExternalVR"
 * The method DeActivateExternalVR would be used to De-activate the external VR session. The responsibilities of Phone Middleware is to:
 * a. Stop streaming the VR audio when the SCO channel is disconnected
 * b. Deallocate the VR channel.
 * The External VR state are updated to clients through the interface "ExternalVRState"
 */
typedef ::asf::cca::CcaTypes::DefaultError DeActivateExternalVRAbortError;


/**
 * The status message of the property "SourceInfo"
 * This property gives particulars about the type of streaming data a source can handle. If notification is used for an FBlock with multiple sources, multiple notifications will be sent when the status changes for more than one source.For further information please refer to the MOST Stream Transmission Specification Rev 3.0.
 */
class SourceInfoStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SourceInfoStatus ();

    /**
     * Copy constructor
     */
    inline  SourceInfoStatus (const SourceInfoStatus &rhs);

    /**
     * All fields constructor
     */
    inline  SourceInfoStatus (uint8 u8SourceNr_, uint16 u16BlockWidth_, uint16 u16ConnectionLabel_, ::most_Src_fi_types::T_e8_SrcTransmissionClass e8TransmissionClass_, ::most_Src_fi_types::T_e8_SrcContentProtection e8ContentProtection_, const ::most_Src_fi_types::T_SrcContentDescription& oContentDescription_, const ::fi_basetypes_most::T_TrailingStream& oTransmissionParameter_);

    /**
     * Destructor
     */
    inline virtual  ~SourceInfoStatus();

    /**
     * Assignment operator
     */
    inline SourceInfoStatus& operator = (const SourceInfoStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SourceInfoStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SourceInfoStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SourceInfoStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SourceInfoStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8SourceNr"

    static const int kU8SourceNr = 0;

    /**
     * Clears the field "u8SourceNr".
     *
     * The field will be set to its default value. The hasU8SourceNr()
     * method will return false.
     */
    inline void clearU8SourceNr();

    /**
     * Checks whether the field "u8SourceNr" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8SourceNr()). Otherwise it will return false.
     */
    inline bool hasU8SourceNr () const;

    /**
     * Returns the value of the member "u8SourceNr".
     *
     * Number of a data source (within one FBlock there can be more than one), for example, 0x01 for the first source.
     *
     * @return The value of the field "u8SourceNr"
     */
    inline uint8 getU8SourceNr () const;

    /**
     * Sets the value of the member "u8SourceNr".
     *
     * Number of a data source (within one FBlock there can be more than one), for example, 0x01 for the first source.
     *
     * @param u8SourceNr The value which will be set
     */
    inline void setU8SourceNr (uint8 u8SourceNr_);

    // API of field "u16BlockWidth"

    static const int kU16BlockWidth = 1;

    /**
     * Clears the field "u16BlockWidth".
     *
     * The field will be set to its default value. The hasU16BlockWidth()
     * method will return false.
     */
    inline void clearU16BlockWidth();

    /**
     * Checks whether the field "u16BlockWidth" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16BlockWidth()). Otherwise it will return false.
     */
    inline bool hasU16BlockWidth () const;

    /**
     * Returns the value of the member "u16BlockWidth".
     *
     * Number of transferred bytes per MOST frame.  If no bandwidth was allocated yet, 0x0000 must be used.  Otherwise, 0x0001 - 0x0075 is used as specified by MOST50.
     *
     * @return The value of the field "u16BlockWidth"
     */
    inline uint16 getU16BlockWidth () const;

    /**
     * Sets the value of the member "u16BlockWidth".
     *
     * Number of transferred bytes per MOST frame.  If no bandwidth was allocated yet, 0x0000 must be used.  Otherwise, 0x0001 - 0x0075 is used as specified by MOST50.
     *
     * @param u16BlockWidth The value which will be set
     */
    inline void setU16BlockWidth (uint16 u16BlockWidth_);

    // API of field "u16ConnectionLabel"

    static const int kU16ConnectionLabel = 2;

    /**
     * Clears the field "u16ConnectionLabel".
     *
     * The field will be set to its default value. The hasU16ConnectionLabel()
     * method will return false.
     */
    inline void clearU16ConnectionLabel();

    /**
     * Checks whether the field "u16ConnectionLabel" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16ConnectionLabel()). Otherwise it will return false.
     */
    inline bool hasU16ConnectionLabel () const;

    /**
     * Returns the value of the member "u16ConnectionLabel".
     *
     * Connection identifier. If no bandwidth is allocated, 0x0000 must be used.  Otherwise, 0x000B - 0x007F is used as specified by MOST50.
     *
     * @return The value of the field "u16ConnectionLabel"
     */
    inline uint16 getU16ConnectionLabel () const;

    /**
     * Sets the value of the member "u16ConnectionLabel".
     *
     * Connection identifier. If no bandwidth is allocated, 0x0000 must be used.  Otherwise, 0x000B - 0x007F is used as specified by MOST50.
     *
     * @param u16ConnectionLabel The value which will be set
     */
    inline void setU16ConnectionLabel (uint16 u16ConnectionLabel_);

    // API of field "e8TransmissionClass"

    static const int kE8TransmissionClass = 3;

    /**
     * Clears the field "e8TransmissionClass".
     *
     * The field will be set to its default value. The hasE8TransmissionClass()
     * method will return false.
     */
    inline void clearE8TransmissionClass();

    /**
     * Checks whether the field "e8TransmissionClass" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8TransmissionClass()). Otherwise it will return false.
     */
    inline bool hasE8TransmissionClass () const;

    /**
     * Returns the value of the member "e8TransmissionClass".
     *
     * Describe the used MOST transmission type.
     *
     * Note:  Next Gen is only using the Synchronous transmission type for streaming audio and video.
     *
     * @return The value of the field "e8TransmissionClass"
     */
    inline ::most_Src_fi_types::T_e8_SrcTransmissionClass getE8TransmissionClass () const;

    /**
     * Sets the value of the member "e8TransmissionClass".
     *
     * Describe the used MOST transmission type.
     *
     * Note:  Next Gen is only using the Synchronous transmission type for streaming audio and video.
     *
     * @param e8TransmissionClass The value which will be set
     */
    inline void setE8TransmissionClass (::most_Src_fi_types::T_e8_SrcTransmissionClass e8TransmissionClass_);

    // API of field "e8ContentProtection"

    static const int kE8ContentProtection = 4;

    /**
     * Clears the field "e8ContentProtection".
     *
     * The field will be set to its default value. The hasE8ContentProtection()
     * method will return false.
     */
    inline void clearE8ContentProtection();

    /**
     * Checks whether the field "e8ContentProtection" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ContentProtection()). Otherwise it will return false.
     */
    inline bool hasE8ContentProtection () const;

    /**
     * Returns the value of the member "e8ContentProtection".
     *
     * Type of Content Protection used.
     *
     * @return The value of the field "e8ContentProtection"
     */
    inline ::most_Src_fi_types::T_e8_SrcContentProtection getE8ContentProtection () const;

    /**
     * Sets the value of the member "e8ContentProtection".
     *
     * Type of Content Protection used.
     *
     * @param e8ContentProtection The value which will be set
     */
    inline void setE8ContentProtection (::most_Src_fi_types::T_e8_SrcContentProtection e8ContentProtection_);

    // API of field "oContentDescription"

    static const int kOContentDescription = 5;

    /**
     * Clears the field "oContentDescription".
     *
     * The field will be set to its default value. The hasOContentDescription()
     * method will return false.
     */
    inline void clearOContentDescription();

    /**
     * Checks whether the field "oContentDescription" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOContentDescription()). Otherwise it will return false.
     */
    inline bool hasOContentDescription () const;

    /**
     * Returns the value of the member "oContentDescription".
     *
     * The parameter depends on the ContentType.
     *
     * @return The value of the field "oContentDescription"
     */
    inline const ::most_Src_fi_types::T_SrcContentDescription& getOContentDescription () const;

    /**
     * Retrieves the value of the field "oContentDescription" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oContentDescription".
     */
    inline ::most_Src_fi_types::T_SrcContentDescription& getOContentDescriptionMutable ();

    /**
     * Sets the value of the member "oContentDescription".
     *
     * The parameter depends on the ContentType.
     *
     * @param oContentDescription The value which will be set
     */
    inline void setOContentDescription (const ::most_Src_fi_types::T_SrcContentDescription& oContentDescription_);

    // API of field "oTransmissionParameter"

    static const int kOTransmissionParameter = 6;

    /**
     * Clears the field "oTransmissionParameter".
     *
     * The field will be set to its default value. The hasOTransmissionParameter()
     * method will return false.
     */
    inline void clearOTransmissionParameter();

    /**
     * Checks whether the field "oTransmissionParameter" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOTransmissionParameter()). Otherwise it will return false.
     */
    inline bool hasOTransmissionParameter () const;

    /**
     * Returns the value of the member "oTransmissionParameter".
     *
     * The TransmiissionParameter contents depends on the TransmissionClass.  Since only the synchronous transmission class is used in the Next GenerationArchitecture Infotainment Subsystem, the TransmissionParameter is an empty stream.
     *
     * @return The value of the field "oTransmissionParameter"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOTransmissionParameter () const;

    /**
     * Retrieves the value of the field "oTransmissionParameter" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oTransmissionParameter".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOTransmissionParameterMutable ();

    /**
     * Sets the value of the member "oTransmissionParameter".
     *
     * The TransmiissionParameter contents depends on the TransmissionClass.  Since only the synchronous transmission class is used in the Next GenerationArchitecture Infotainment Subsystem, the TransmissionParameter is an empty stream.
     *
     * @param oTransmissionParameter The value which will be set
     */
    inline void setOTransmissionParameter (const ::fi_basetypes_most::T_TrailingStream& oTransmissionParameter_);

    static const SourceInfoStatus &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_u8SourceNr ();

    inline void clear_has_u8SourceNr ();

    inline void set_has_u16BlockWidth ();

    inline void clear_has_u16BlockWidth ();

    inline void set_has_u16ConnectionLabel ();

    inline void clear_has_u16ConnectionLabel ();

    inline void set_has_e8TransmissionClass ();

    inline void clear_has_e8TransmissionClass ();

    inline void set_has_e8ContentProtection ();

    inline void clear_has_e8ContentProtection ();

    inline void set_has_oContentDescription ();

    inline void clear_has_oContentDescription ();

    inline void set_has_oTransmissionParameter ();

    inline void clear_has_oTransmissionParameter ();

    uint32 _has_bits_[ (7 + 31) / 32];

    uint8 _u8SourceNr;

    uint16 _u16BlockWidth;

    uint16 _u16ConnectionLabel;

    ::most_Src_fi_types::T_e8_SrcTransmissionClass _e8TransmissionClass;

    ::most_Src_fi_types::T_e8_SrcContentProtection _e8ContentProtection;

    ::most_Src_fi_types::T_SrcContentDescription _oContentDescription;

    ::fi_basetypes_most::T_TrailingStream _oTransmissionParameter;

};

/**
 * The get message of the property "SourceInfo"
 * This property gives particulars about the type of streaming data a source can handle. If notification is used for an FBlock with multiple sources, multiple notifications will be sent when the status changes for more than one source.For further information please refer to the MOST Stream Transmission Specification Rev 3.0.
 */
class SourceInfoGet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SourceInfoGet ();

    /**
     * Copy constructor
     */
    inline  SourceInfoGet (const SourceInfoGet &rhs);

    /**
     * All fields constructor
     */
    inline  SourceInfoGet (uint8 u8SourceNr_);

    /**
     * Destructor
     */
    inline virtual  ~SourceInfoGet();

    /**
     * Assignment operator
     */
    inline SourceInfoGet& operator = (const SourceInfoGet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SourceInfoGet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SourceInfoGet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SourceInfoGet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SourceInfoGet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8SourceNr"

    static const int kU8SourceNr = 0;

    /**
     * Clears the field "u8SourceNr".
     *
     * The field will be set to its default value. The hasU8SourceNr()
     * method will return false.
     */
    inline void clearU8SourceNr();

    /**
     * Checks whether the field "u8SourceNr" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8SourceNr()). Otherwise it will return false.
     */
    inline bool hasU8SourceNr () const;

    /**
     * Returns the value of the member "u8SourceNr".
     *
     * Number of a data source (within one FBlock there can be more than one), for example, 0x01 for the first source.
     *
     * @return The value of the field "u8SourceNr"
     */
    inline uint8 getU8SourceNr () const;

    /**
     * Sets the value of the member "u8SourceNr".
     *
     * Number of a data source (within one FBlock there can be more than one), for example, 0x01 for the first source.
     *
     * @param u8SourceNr The value which will be set
     */
    inline void setU8SourceNr (uint8 u8SourceNr_);

    static const SourceInfoGet &getDefaultInstance();

private:

    inline void set_has_u8SourceNr ();

    inline void clear_has_u8SourceNr ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _u8SourceNr;

};

/**
 * The error message of 'SourceInfo'
 */
class SourceInfoErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  SourceInfoErrorStructure ();

    /**
     * Copy constructor
     */
    inline  SourceInfoErrorStructure (const SourceInfoErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  SourceInfoErrorStructure (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline  ~SourceInfoErrorStructure();

    /**
     * Assignment operator
     */
    inline SourceInfoErrorStructure& operator = (const SourceInfoErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SourceInfoErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SourceInfoErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SourceInfoErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SourceInfoErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     * (Refer to the MOST Specification, section "Structure of MOST Messages: OPType")
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     * (Refer to the MOST Specification, section "Structure of MOST Messages: OPType")
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 1;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     * (Refer to the MOST Specification, section "Structure of MOST Messages: OPType")
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     * (Refer to the MOST Specification, section "Structure of MOST Messages: OPType")
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    static const SourceInfoErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

};

/**
 * The error message of 'SourceInfo'
 */
class SourceInfoError  : public ::asf::core::Payload {
public:

    enum SourceInfoErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  SourceInfoError ();

   /**
     * Copy constructor
     */
    inline  SourceInfoError (const SourceInfoError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~SourceInfoError();

    /**
     * Assigns a new value to this object.
     */
    inline SourceInfoError& operator = (const SourceInfoError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SourceInfoError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SourceInfoError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SourceInfoError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SourceInfoError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline SourceInfoError::SourceInfoErrorField getField () const;

    inline void setField(SourceInfoError::SourceInfoErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "SourceInfoErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "SourceInfoErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const SourceInfoErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline SourceInfoErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline SourceInfoErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (SourceInfoErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "SourceInfoErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const SourceInfoErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const SourceInfoError &getDefaultInstance();

private:

    inline void cloneData (const SourceInfoError& rhs);

    inline void deleteData ();

    SourceInfoErrorField __field;

    union {
        SourceInfoErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "SourceAvailable"
 * The SourceAvailable property can be queried by a controller to determine whether a Source is initialized and ready to produce audio or video.
 */
class SourceAvailableStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SourceAvailableStatus ();

    /**
     * Copy constructor
     */
    inline  SourceAvailableStatus (const SourceAvailableStatus &rhs);

    /**
     * All fields constructor
     */
    inline  SourceAvailableStatus (bool bSourceAvailable_);

    /**
     * Destructor
     */
    inline virtual  ~SourceAvailableStatus();

    /**
     * Assignment operator
     */
    inline SourceAvailableStatus& operator = (const SourceAvailableStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SourceAvailableStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SourceAvailableStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SourceAvailableStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SourceAvailableStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bSourceAvailable"

    static const int kBSourceAvailable = 0;

    /**
     * Clears the field "bSourceAvailable".
     *
     * The field will be set to its default value. The hasBSourceAvailable()
     * method will return false.
     */
    inline void clearBSourceAvailable();

    /**
     * Checks whether the field "bSourceAvailable" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBSourceAvailable()). Otherwise it will return false.
     */
    inline bool hasBSourceAvailable () const;

    /**
     * Returns the value of the member "bSourceAvailable".
     *
     * The SourceAvailable parameter indicates whether a Source is initialized and ready to produce audio.  Upon transition of SystemState out of SYS_SLEEP_STATE SourceAvailable is set to SOURCE_NOT_AVAILABLE.  After the Source is initialized and ready to produce audio or vidoe SoureceAvailable is set to SOURCE_AVAILABLE.
     *
     * @return The value of the field "bSourceAvailable"
     */
    inline bool getBSourceAvailable () const;

    /**
     * Sets the value of the member "bSourceAvailable".
     *
     * The SourceAvailable parameter indicates whether a Source is initialized and ready to produce audio.  Upon transition of SystemState out of SYS_SLEEP_STATE SourceAvailable is set to SOURCE_NOT_AVAILABLE.  After the Source is initialized and ready to produce audio or vidoe SoureceAvailable is set to SOURCE_AVAILABLE.
     *
     * @param bSourceAvailable The value which will be set
     */
    inline void setBSourceAvailable (bool bSourceAvailable_);

    static const SourceAvailableStatus &getDefaultInstance();

private:

    inline void set_has_bSourceAvailable ();

    inline void clear_has_bSourceAvailable ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _bSourceAvailable;

};

/**
 * The error message of 'SourceAvailable'
 */
class SourceAvailableErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  SourceAvailableErrorStructure ();

    /**
     * Copy constructor
     */
    inline  SourceAvailableErrorStructure (const SourceAvailableErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  SourceAvailableErrorStructure (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline  ~SourceAvailableErrorStructure();

    /**
     * Assignment operator
     */
    inline SourceAvailableErrorStructure& operator = (const SourceAvailableErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SourceAvailableErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SourceAvailableErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SourceAvailableErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SourceAvailableErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     * (Refer to the MOST Specification, section "Structure of MOST Messages: OPType")
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     * (Refer to the MOST Specification, section "Structure of MOST Messages: OPType")
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 1;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     * (Refer to the MOST Specification, section "Structure of MOST Messages: OPType")
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     * (Refer to the MOST Specification, section "Structure of MOST Messages: OPType")
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    static const SourceAvailableErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

};

/**
 * The error message of 'SourceAvailable'
 */
class SourceAvailableError  : public ::asf::core::Payload {
public:

    enum SourceAvailableErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  SourceAvailableError ();

   /**
     * Copy constructor
     */
    inline  SourceAvailableError (const SourceAvailableError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~SourceAvailableError();

    /**
     * Assigns a new value to this object.
     */
    inline SourceAvailableError& operator = (const SourceAvailableError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SourceAvailableError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SourceAvailableError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SourceAvailableError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SourceAvailableError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline SourceAvailableError::SourceAvailableErrorField getField () const;

    inline void setField(SourceAvailableError::SourceAvailableErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "SourceAvailableErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "SourceAvailableErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const SourceAvailableErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline SourceAvailableErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline SourceAvailableErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (SourceAvailableErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "SourceAvailableErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const SourceAvailableErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const SourceAvailableError &getDefaultInstance();

private:

    inline void cloneData (const SourceAvailableError& rhs);

    inline void deleteData ();

    SourceAvailableErrorField __field;

    union {
        SourceAvailableErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "ActiveCallinHandset"
 * This Property reports whether or not there is an active call in a handset detected.  The state of the handset and its DeviceHandle (within the BluetoothSettings FBlock) are reported.  HMI controllers use the DeviceHandle to query the BluetoothSettings FBlock for additional information about the device and to potentially call the TransferCallToVehicle method to transfer the particular device's active call to the vehicle hands-free system.
 *
 * Note that it is possible that two different calls on two connected phones could be active on entry to the vehicle so this property has been defined as a Container with a ShortStream carrying the information for up to two devices.
 */
class ActiveCallinHandsetStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ActiveCallinHandsetStatus ();

    /**
     * Copy constructor
     */
    inline  ActiveCallinHandsetStatus (const ActiveCallinHandsetStatus &rhs);

    /**
     * All fields constructor
     */
    inline  ActiveCallinHandsetStatus (const ::most_Tel_fi_types::T_TelActiveCallinHandsetStream& oActiveCallinHandsetStream_);

    /**
     * Destructor
     */
    inline virtual  ~ActiveCallinHandsetStatus();

    /**
     * Assignment operator
     */
    inline ActiveCallinHandsetStatus& operator = (const ActiveCallinHandsetStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ActiveCallinHandsetStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ActiveCallinHandsetStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ActiveCallinHandsetStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ActiveCallinHandsetStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "oActiveCallinHandsetStream"

    static const int kOActiveCallinHandsetStream = 0;

    /**
     * Clears the field "oActiveCallinHandsetStream".
     *
     * The field will be set to its default value. The hasOActiveCallinHandsetStream()
     * method will return false.
     */
    inline void clearOActiveCallinHandsetStream();

    /**
     * Checks whether the field "oActiveCallinHandsetStream" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOActiveCallinHandsetStream()). Otherwise it will return false.
     */
    inline bool hasOActiveCallinHandsetStream () const;

    /**
     * Returns the value of the member "oActiveCallinHandsetStream".
     *
     * This stream contains the HandsetState and DeviceHandle for devices that may be connected with active calls that are detected upon entry to the vehicle.   Per the GIS-327 Bluetooth Requirements specification only two devices may be connected at the same time so this stream is limited to the information for two devices.
     *
     * @return The value of the field "oActiveCallinHandsetStream"
     */
    inline const ::most_Tel_fi_types::T_TelActiveCallinHandsetStream& getOActiveCallinHandsetStream () const;

    /**
     * Retrieves the value of the field "oActiveCallinHandsetStream" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oActiveCallinHandsetStream".
     */
    inline ::most_Tel_fi_types::T_TelActiveCallinHandsetStream& getOActiveCallinHandsetStreamMutable ();

    /**
     * Sets the value of the member "oActiveCallinHandsetStream".
     *
     * This stream contains the HandsetState and DeviceHandle for devices that may be connected with active calls that are detected upon entry to the vehicle.   Per the GIS-327 Bluetooth Requirements specification only two devices may be connected at the same time so this stream is limited to the information for two devices.
     *
     * @param oActiveCallinHandsetStream The value which will be set
     */
    inline void setOActiveCallinHandsetStream (const ::most_Tel_fi_types::T_TelActiveCallinHandsetStream& oActiveCallinHandsetStream_);

    static const ActiveCallinHandsetStatus &getDefaultInstance();

private:

    static const ::std::vector< ::most_Tel_fi_types::T_TelActiveCallinHandsetStreamItem >& getT_TelActiveCallinHandsetStreamItemList_DefaultInstance ();

    inline void set_has_oActiveCallinHandsetStream ();

    inline void clear_has_oActiveCallinHandsetStream ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::most_Tel_fi_types::T_TelActiveCallinHandsetStream _oActiveCallinHandsetStream;

};

/**
 * The error message of 'ActiveCallinHandset'
 */
class ActiveCallinHandsetErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  ActiveCallinHandsetErrorStructure ();

    /**
     * Copy constructor
     */
    inline  ActiveCallinHandsetErrorStructure (const ActiveCallinHandsetErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  ActiveCallinHandsetErrorStructure (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline  ~ActiveCallinHandsetErrorStructure();

    /**
     * Assignment operator
     */
    inline ActiveCallinHandsetErrorStructure& operator = (const ActiveCallinHandsetErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ActiveCallinHandsetErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ActiveCallinHandsetErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ActiveCallinHandsetErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ActiveCallinHandsetErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     * Error codes outlined in MOST standard, e.g.:
     * $01 Syntax error: F Block does not exist,
     * $02 Syntax error: Instance does not exist,
     * $03 Syntax error: Function does not exist,
     * $04 Syntax error: Operations does not exist,etc.
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     * Error codes outlined in MOST standard, e.g.:
     * $01 Syntax error: F Block does not exist,
     * $02 Syntax error: Instance does not exist,
     * $03 Syntax error: Function does not exist,
     * $04 Syntax error: Operations does not exist,etc.
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 1;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     * This is for error code $20, function specific error information.  Allowed range $01 - $BF.
     *
     * The first byte is the enumeration of error codes as follows:
     * 0x01:  ERR_NOT_AVAILABLE
     * 0x02:  ERR_NOSERVICE
     * 0x03:  ERR_NO_CALL
     * 0x04:  ERR_NETWORK_DENY
     * 0x05:  ERR_NO_AUDIO_CHANNEL
     * 0xD8:  ERR_OTHER
     *
     * The 2nd byte, if present, is the CallInstance of the function that generated the error.
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     * This is for error code $20, function specific error information.  Allowed range $01 - $BF.
     *
     * The first byte is the enumeration of error codes as follows:
     * 0x01:  ERR_NOT_AVAILABLE
     * 0x02:  ERR_NOSERVICE
     * 0x03:  ERR_NO_CALL
     * 0x04:  ERR_NETWORK_DENY
     * 0x05:  ERR_NO_AUDIO_CHANNEL
     * 0xD8:  ERR_OTHER
     *
     * The 2nd byte, if present, is the CallInstance of the function that generated the error.
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    static const ActiveCallinHandsetErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

};

/**
 * The error message of 'ActiveCallinHandset'
 */
class ActiveCallinHandsetError  : public ::asf::core::Payload {
public:

    enum ActiveCallinHandsetErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  ActiveCallinHandsetError ();

   /**
     * Copy constructor
     */
    inline  ActiveCallinHandsetError (const ActiveCallinHandsetError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~ActiveCallinHandsetError();

    /**
     * Assigns a new value to this object.
     */
    inline ActiveCallinHandsetError& operator = (const ActiveCallinHandsetError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ActiveCallinHandsetError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ActiveCallinHandsetError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ActiveCallinHandsetError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ActiveCallinHandsetError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline ActiveCallinHandsetError::ActiveCallinHandsetErrorField getField () const;

    inline void setField(ActiveCallinHandsetError::ActiveCallinHandsetErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "ActiveCallinHandsetErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "ActiveCallinHandsetErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const ActiveCallinHandsetErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline ActiveCallinHandsetErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline ActiveCallinHandsetErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (ActiveCallinHandsetErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "ActiveCallinHandsetErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const ActiveCallinHandsetErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const ActiveCallinHandsetError &getDefaultInstance();

private:

    inline void cloneData (const ActiveCallinHandsetError& rhs);

    inline void deleteData ();

    ActiveCallinHandsetErrorField __field;

    union {
        ActiveCallinHandsetErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "CallStatusNotice"
 * Other component can get status of a CallInstance using this notification.
 * Telephone component notifies when a status changes , and ends status
 * update when the CallStatus becomes IDLE. Needs valid Callinstance.
 * Callinstances are created on an incoming call event or an outgoing call
 * request.IMPORTANT: When there are no calls currently active, the
 * Status response of this property cannot be an empty stream as an empty
 * payload MHP message is incompatible with the current (as of this release)
 * implemenation of NetServices. Instead, when no calls are active, the
 * following &quot;null&quot; Status response shall be returned:
 *
 *
 * <item>
 * CallInstance = 0xFF
 * </item>
 * <item>
 * CallStatus = IDLE
 * </item>
 * <item>
 * UsingVehicleAudio = False
 * </item>
 * <item>
 * CallDurationXX = 0
 * </item>
 * <item>
 * DeviceHandle=0xFF
 * </item>
 */
class CallStatusNoticeStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CallStatusNoticeStatus ();

    /**
     * Copy constructor
     */
    inline  CallStatusNoticeStatus (const CallStatusNoticeStatus &rhs);

    /**
     * All fields constructor
     */
    inline  CallStatusNoticeStatus (const ::most_Tel_fi_types::T_TelCallStatusNoticeStream& oCallStatusNoticeStream_);

    /**
     * Destructor
     */
    inline virtual  ~CallStatusNoticeStatus();

    /**
     * Assignment operator
     */
    inline CallStatusNoticeStatus& operator = (const CallStatusNoticeStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CallStatusNoticeStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CallStatusNoticeStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CallStatusNoticeStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CallStatusNoticeStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "oCallStatusNoticeStream"

    static const int kOCallStatusNoticeStream = 0;

    /**
     * Clears the field "oCallStatusNoticeStream".
     *
     * The field will be set to its default value. The hasOCallStatusNoticeStream()
     * method will return false.
     */
    inline void clearOCallStatusNoticeStream();

    /**
     * Checks whether the field "oCallStatusNoticeStream" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOCallStatusNoticeStream()). Otherwise it will return false.
     */
    inline bool hasOCallStatusNoticeStream () const;

    /**
     * Returns the value of the member "oCallStatusNoticeStream".
     *
     * This is the stream of CallStatus used in the CallStatusNotice property. It
     * is defined as a stream so that the Get operator can return the status of
     * all CallInstances (if needed by a particular controller).
     *
     * @return The value of the field "oCallStatusNoticeStream"
     */
    inline const ::most_Tel_fi_types::T_TelCallStatusNoticeStream& getOCallStatusNoticeStream () const;

    /**
     * Retrieves the value of the field "oCallStatusNoticeStream" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oCallStatusNoticeStream".
     */
    inline ::most_Tel_fi_types::T_TelCallStatusNoticeStream& getOCallStatusNoticeStreamMutable ();

    /**
     * Sets the value of the member "oCallStatusNoticeStream".
     *
     * This is the stream of CallStatus used in the CallStatusNotice property. It
     * is defined as a stream so that the Get operator can return the status of
     * all CallInstances (if needed by a particular controller).
     *
     * @param oCallStatusNoticeStream The value which will be set
     */
    inline void setOCallStatusNoticeStream (const ::most_Tel_fi_types::T_TelCallStatusNoticeStream& oCallStatusNoticeStream_);

    static const CallStatusNoticeStatus &getDefaultInstance();

private:

    static const ::std::vector< ::most_Tel_fi_types::T_TelCallStatusNoticeStreamItem >& getT_TelCallStatusNoticeStreamItemList_DefaultInstance ();

    inline void set_has_oCallStatusNoticeStream ();

    inline void clear_has_oCallStatusNoticeStream ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::most_Tel_fi_types::T_TelCallStatusNoticeStream _oCallStatusNoticeStream;

};

/**
 * The error message of 'CallStatusNotice'
 */
class CallStatusNoticeErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  CallStatusNoticeErrorStructure ();

    /**
     * Copy constructor
     */
    inline  CallStatusNoticeErrorStructure (const CallStatusNoticeErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  CallStatusNoticeErrorStructure (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline  ~CallStatusNoticeErrorStructure();

    /**
     * Assignment operator
     */
    inline CallStatusNoticeErrorStructure& operator = (const CallStatusNoticeErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CallStatusNoticeErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CallStatusNoticeErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CallStatusNoticeErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CallStatusNoticeErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     * Error codes outlined in MOST standard, e.g.:
     * $01 Syntax error: F Block does not exist,
     * $02 Syntax error: Instance does not exist,
     * $03 Syntax error: Function does not exist,
     * $04 Syntax error: Operations does not exist,etc.
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     * Error codes outlined in MOST standard, e.g.:
     * $01 Syntax error: F Block does not exist,
     * $02 Syntax error: Instance does not exist,
     * $03 Syntax error: Function does not exist,
     * $04 Syntax error: Operations does not exist,etc.
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 1;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     * This is for error code $20, function specific error information.  Allowed range $01 - $BF.
     *
     * The first byte is the enumeration of error codes as follows:
     * 0x01:  ERR_NOT_AVAILABLE
     * 0x02:  ERR_NOSERVICE
     * 0x03:  ERR_NO_CALL
     * 0x04:  ERR_NETWORK_DENY
     * 0x05:  ERR_NO_AUDIO_CHANNEL
     * 0xD8:  ERR_OTHER
     *
     * The 2nd byte, if present, is the CallInstance of the function that generated the error.
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     * This is for error code $20, function specific error information.  Allowed range $01 - $BF.
     *
     * The first byte is the enumeration of error codes as follows:
     * 0x01:  ERR_NOT_AVAILABLE
     * 0x02:  ERR_NOSERVICE
     * 0x03:  ERR_NO_CALL
     * 0x04:  ERR_NETWORK_DENY
     * 0x05:  ERR_NO_AUDIO_CHANNEL
     * 0xD8:  ERR_OTHER
     *
     * The 2nd byte, if present, is the CallInstance of the function that generated the error.
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    static const CallStatusNoticeErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

};

/**
 * The error message of 'CallStatusNotice'
 */
class CallStatusNoticeError  : public ::asf::core::Payload {
public:

    enum CallStatusNoticeErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  CallStatusNoticeError ();

   /**
     * Copy constructor
     */
    inline  CallStatusNoticeError (const CallStatusNoticeError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~CallStatusNoticeError();

    /**
     * Assigns a new value to this object.
     */
    inline CallStatusNoticeError& operator = (const CallStatusNoticeError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CallStatusNoticeError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CallStatusNoticeError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CallStatusNoticeError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CallStatusNoticeError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline CallStatusNoticeError::CallStatusNoticeErrorField getField () const;

    inline void setField(CallStatusNoticeError::CallStatusNoticeErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "CallStatusNoticeErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "CallStatusNoticeErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const CallStatusNoticeErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline CallStatusNoticeErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline CallStatusNoticeErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (CallStatusNoticeErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "CallStatusNoticeErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const CallStatusNoticeErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const CallStatusNoticeError &getDefaultInstance();

private:

    inline void cloneData (const CallStatusNoticeError& rhs);

    inline void deleteData ();

    CallStatusNoticeErrorField __field;

    union {
        CallStatusNoticeErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "CellDeviceName"
 * Returns Device name of the current active hands free device.
 */
class CellDeviceNameStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CellDeviceNameStatus ();

    /**
     * Copy constructor
     */
    inline  CellDeviceNameStatus (const CellDeviceNameStatus &rhs);

    /**
     * All fields constructor
     */
    inline  CellDeviceNameStatus (const ::fi_basetypes_most::T_String& sDeviceName_, uint8 u8DeviceHandle_);

    /**
     * Destructor
     */
    inline virtual  ~CellDeviceNameStatus();

    /**
     * Assignment operator
     */
    inline CellDeviceNameStatus& operator = (const CellDeviceNameStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CellDeviceNameStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CellDeviceNameStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CellDeviceNameStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CellDeviceNameStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "sDeviceName"

    static const int kSDeviceName = 0;

    /**
     * Clears the field "sDeviceName".
     *
     * The field will be set to its default value. The hasSDeviceName()
     * method will return false.
     */
    inline void clearSDeviceName();

    /**
     * Checks whether the field "sDeviceName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSDeviceName()). Otherwise it will return false.
     */
    inline bool hasSDeviceName () const;

    /**
     * Returns the value of the member "sDeviceName".
     *
     * Name of the BT phone
     *
     * @return The value of the field "sDeviceName"
     */
    inline const ::fi_basetypes_most::T_String& getSDeviceName () const;

    /**
     * Retrieves the value of the field "sDeviceName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sDeviceName".
     */
    inline ::fi_basetypes_most::T_String& getSDeviceNameMutable ();

    /**
     * Sets the value of the member "sDeviceName".
     *
     * Name of the BT phone
     *
     * @param sDeviceName The value which will be set
     */
    inline void setSDeviceName (const ::fi_basetypes_most::T_String& sDeviceName_);

    // API of field "u8DeviceHandle"

    static const int kU8DeviceHandle = 1;

    /**
     * Clears the field "u8DeviceHandle".
     *
     * The field will be set to its default value. The hasU8DeviceHandle()
     * method will return false.
     */
    inline void clearU8DeviceHandle();

    /**
     * Checks whether the field "u8DeviceHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8DeviceHandle()). Otherwise it will return false.
     */
    inline bool hasU8DeviceHandle () const;

    /**
     * Returns the value of the member "u8DeviceHandle".
     *
     * Unique handle for each one of the up to 10 devices that can be paired.  Handles are maintained by BluetoothSettings FBlock.  0 is reserved as Null. Valid handles are 1..10 inclusive.
     *
     * @return The value of the field "u8DeviceHandle"
     */
    inline uint8 getU8DeviceHandle () const;

    /**
     * Sets the value of the member "u8DeviceHandle".
     *
     * Unique handle for each one of the up to 10 devices that can be paired.  Handles are maintained by BluetoothSettings FBlock.  0 is reserved as Null. Valid handles are 1..10 inclusive.
     *
     * @param u8DeviceHandle The value which will be set
     */
    inline void setU8DeviceHandle (uint8 u8DeviceHandle_);

    static const CellDeviceNameStatus &getDefaultInstance();

private:

    inline void set_has_sDeviceName ();

    inline void clear_has_sDeviceName ();

    inline void set_has_u8DeviceHandle ();

    inline void clear_has_u8DeviceHandle ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_String _sDeviceName;

    uint8 _u8DeviceHandle;

};

/**
 * The error message of 'CellDeviceName'
 */
class CellDeviceNameErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  CellDeviceNameErrorStructure ();

    /**
     * Copy constructor
     */
    inline  CellDeviceNameErrorStructure (const CellDeviceNameErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  CellDeviceNameErrorStructure (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline  ~CellDeviceNameErrorStructure();

    /**
     * Assignment operator
     */
    inline CellDeviceNameErrorStructure& operator = (const CellDeviceNameErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CellDeviceNameErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CellDeviceNameErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CellDeviceNameErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CellDeviceNameErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     * Error codes outlined in MOST standard, e.g.:
     * $01 Syntax error: F Block does not exist,
     * $02 Syntax error: Instance does not exist,
     * $03 Syntax error: Function does not exist,
     * $04 Syntax error: Operations does not exist,etc.
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     * Error codes outlined in MOST standard, e.g.:
     * $01 Syntax error: F Block does not exist,
     * $02 Syntax error: Instance does not exist,
     * $03 Syntax error: Function does not exist,
     * $04 Syntax error: Operations does not exist,etc.
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 1;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     * This is for error code $20, function specific error information.  Allowed range $01 - $BF.
     *
     * The first byte is the enumeration of error codes as follows:
     * 0x01:  ERR_NOT_AVAILABLE
     * 0x02:  ERR_NOSERVICE
     * 0x03:  ERR_NO_CALL
     * 0x04:  ERR_NETWORK_DENY
     * 0x05:  ERR_NO_AUDIO_CHANNEL
     * 0xD8:  ERR_OTHER
     *
     * The 2nd byte, if present, is the CallInstance of the function that generated the error.
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     * This is for error code $20, function specific error information.  Allowed range $01 - $BF.
     *
     * The first byte is the enumeration of error codes as follows:
     * 0x01:  ERR_NOT_AVAILABLE
     * 0x02:  ERR_NOSERVICE
     * 0x03:  ERR_NO_CALL
     * 0x04:  ERR_NETWORK_DENY
     * 0x05:  ERR_NO_AUDIO_CHANNEL
     * 0xD8:  ERR_OTHER
     *
     * The 2nd byte, if present, is the CallInstance of the function that generated the error.
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    static const CellDeviceNameErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

};

/**
 * The error message of 'CellDeviceName'
 */
class CellDeviceNameError  : public ::asf::core::Payload {
public:

    enum CellDeviceNameErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  CellDeviceNameError ();

   /**
     * Copy constructor
     */
    inline  CellDeviceNameError (const CellDeviceNameError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~CellDeviceNameError();

    /**
     * Assigns a new value to this object.
     */
    inline CellDeviceNameError& operator = (const CellDeviceNameError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CellDeviceNameError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CellDeviceNameError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CellDeviceNameError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CellDeviceNameError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline CellDeviceNameError::CellDeviceNameErrorField getField () const;

    inline void setField(CellDeviceNameError::CellDeviceNameErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "CellDeviceNameErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "CellDeviceNameErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const CellDeviceNameErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline CellDeviceNameErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline CellDeviceNameErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (CellDeviceNameErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "CellDeviceNameErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const CellDeviceNameErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const CellDeviceNameError &getDefaultInstance();

private:

    inline void cloneData (const CellDeviceNameError& rhs);

    inline void deleteData ();

    CellDeviceNameErrorField __field;

    union {
        CellDeviceNameErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "CellNetworkStatus"
 * Connectivity status of the cell network.  This is a notification since, network could be lost anytime.  Includes roaming true or false.
 */
class CellNetworkStatusStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CellNetworkStatusStatus ();

    /**
     * Copy constructor
     */
    inline  CellNetworkStatusStatus (const CellNetworkStatusStatus &rhs);

    /**
     * All fields constructor
     */
    inline  CellNetworkStatusStatus (::most_Tel_fi_types::T_e8_TelCellService e8CellService_, bool bRoamingStatus_, uint8 u8DeviceHandle_);

    /**
     * Destructor
     */
    inline virtual  ~CellNetworkStatusStatus();

    /**
     * Assignment operator
     */
    inline CellNetworkStatusStatus& operator = (const CellNetworkStatusStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CellNetworkStatusStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CellNetworkStatusStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CellNetworkStatusStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CellNetworkStatusStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8CellService"

    static const int kE8CellService = 0;

    /**
     * Clears the field "e8CellService".
     *
     * The field will be set to its default value. The hasE8CellService()
     * method will return false.
     */
    inline void clearE8CellService();

    /**
     * Checks whether the field "e8CellService" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8CellService()). Otherwise it will return false.
     */
    inline bool hasE8CellService () const;

    /**
     * Returns the value of the member "e8CellService".
     *
     * Cellular service
     *
     * @return The value of the field "e8CellService"
     */
    inline ::most_Tel_fi_types::T_e8_TelCellService getE8CellService () const;

    /**
     * Sets the value of the member "e8CellService".
     *
     * Cellular service
     *
     * @param e8CellService The value which will be set
     */
    inline void setE8CellService (::most_Tel_fi_types::T_e8_TelCellService e8CellService_);

    // API of field "bRoamingStatus"

    static const int kBRoamingStatus = 1;

    /**
     * Clears the field "bRoamingStatus".
     *
     * The field will be set to its default value. The hasBRoamingStatus()
     * method will return false.
     */
    inline void clearBRoamingStatus();

    /**
     * Checks whether the field "bRoamingStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBRoamingStatus()). Otherwise it will return false.
     */
    inline bool hasBRoamingStatus () const;

    /**
     * Returns the value of the member "bRoamingStatus".
     *
     * In Home or other cell network.
     *
     * @return The value of the field "bRoamingStatus"
     */
    inline bool getBRoamingStatus () const;

    /**
     * Sets the value of the member "bRoamingStatus".
     *
     * In Home or other cell network.
     *
     * @param bRoamingStatus The value which will be set
     */
    inline void setBRoamingStatus (bool bRoamingStatus_);

    // API of field "u8DeviceHandle"

    static const int kU8DeviceHandle = 2;

    /**
     * Clears the field "u8DeviceHandle".
     *
     * The field will be set to its default value. The hasU8DeviceHandle()
     * method will return false.
     */
    inline void clearU8DeviceHandle();

    /**
     * Checks whether the field "u8DeviceHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8DeviceHandle()). Otherwise it will return false.
     */
    inline bool hasU8DeviceHandle () const;

    /**
     * Returns the value of the member "u8DeviceHandle".
     *
     * Unique handle for each one of the up to 10 devices that can be paired.  Handles are maintained by BluetoothSettings FBlock.  0 is reserved as Null. Valid handles are 1..10 inclusive.
     *
     * @return The value of the field "u8DeviceHandle"
     */
    inline uint8 getU8DeviceHandle () const;

    /**
     * Sets the value of the member "u8DeviceHandle".
     *
     * Unique handle for each one of the up to 10 devices that can be paired.  Handles are maintained by BluetoothSettings FBlock.  0 is reserved as Null. Valid handles are 1..10 inclusive.
     *
     * @param u8DeviceHandle The value which will be set
     */
    inline void setU8DeviceHandle (uint8 u8DeviceHandle_);

    static const CellNetworkStatusStatus &getDefaultInstance();

private:

    inline void set_has_e8CellService ();

    inline void clear_has_e8CellService ();

    inline void set_has_bRoamingStatus ();

    inline void clear_has_bRoamingStatus ();

    inline void set_has_u8DeviceHandle ();

    inline void clear_has_u8DeviceHandle ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::most_Tel_fi_types::T_e8_TelCellService _e8CellService;

    bool _bRoamingStatus;

    uint8 _u8DeviceHandle;

};

/**
 * The error message of 'CellNetworkStatus'
 */
class CellNetworkStatusErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  CellNetworkStatusErrorStructure ();

    /**
     * Copy constructor
     */
    inline  CellNetworkStatusErrorStructure (const CellNetworkStatusErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  CellNetworkStatusErrorStructure (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline  ~CellNetworkStatusErrorStructure();

    /**
     * Assignment operator
     */
    inline CellNetworkStatusErrorStructure& operator = (const CellNetworkStatusErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CellNetworkStatusErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CellNetworkStatusErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CellNetworkStatusErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CellNetworkStatusErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     * Error codes outlined in MOST standard, e.g.:
     * $01 Syntax error: F Block does not exist,
     * $02 Syntax error: Instance does not exist,
     * $03 Syntax error: Function does not exist,
     * $04 Syntax error: Operations does not exist,etc.
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     * Error codes outlined in MOST standard, e.g.:
     * $01 Syntax error: F Block does not exist,
     * $02 Syntax error: Instance does not exist,
     * $03 Syntax error: Function does not exist,
     * $04 Syntax error: Operations does not exist,etc.
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 1;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     * This is for error code $20, function specific error information.  Allowed range $01 - $BF.
     * The first byte is the enumeration of error codes as follows:
     * 0x01:  ERR_NOT_AVAILABLE
     * 0x02:  ERR_NOSERVICE
     * 0x03:  ERR_NO_CALL
     * 0x04:  ERR_NETWORK_DENY
     * 0x05:  ERR_NO_AUDIO_CHANNEL
     * 0xD8:  ERR_OTHER
     *
     * The 2nd byte, if present, is the CallInstance of the function that generated the error.
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     * This is for error code $20, function specific error information.  Allowed range $01 - $BF.
     * The first byte is the enumeration of error codes as follows:
     * 0x01:  ERR_NOT_AVAILABLE
     * 0x02:  ERR_NOSERVICE
     * 0x03:  ERR_NO_CALL
     * 0x04:  ERR_NETWORK_DENY
     * 0x05:  ERR_NO_AUDIO_CHANNEL
     * 0xD8:  ERR_OTHER
     *
     * The 2nd byte, if present, is the CallInstance of the function that generated the error.
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    static const CellNetworkStatusErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

};

/**
 * The error message of 'CellNetworkStatus'
 */
class CellNetworkStatusError  : public ::asf::core::Payload {
public:

    enum CellNetworkStatusErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  CellNetworkStatusError ();

   /**
     * Copy constructor
     */
    inline  CellNetworkStatusError (const CellNetworkStatusError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~CellNetworkStatusError();

    /**
     * Assigns a new value to this object.
     */
    inline CellNetworkStatusError& operator = (const CellNetworkStatusError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CellNetworkStatusError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CellNetworkStatusError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CellNetworkStatusError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CellNetworkStatusError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline CellNetworkStatusError::CellNetworkStatusErrorField getField () const;

    inline void setField(CellNetworkStatusError::CellNetworkStatusErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "CellNetworkStatusErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "CellNetworkStatusErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const CellNetworkStatusErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline CellNetworkStatusErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline CellNetworkStatusErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (CellNetworkStatusErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "CellNetworkStatusErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const CellNetworkStatusErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const CellNetworkStatusError &getDefaultInstance();

private:

    inline void cloneData (const CellNetworkStatusError& rhs);

    inline void deleteData ();

    CellNetworkStatusErrorField __field;

    union {
        CellNetworkStatusErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "CellSignalStrength"
 * Even though this changes continually, it is exchanged as discrete parameters. Divide range to 5 indents.This is a notification since the signal strength can change.
 */
class CellSignalStrengthStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CellSignalStrengthStatus ();

    /**
     * Copy constructor
     */
    inline  CellSignalStrengthStatus (const CellSignalStrengthStatus &rhs);

    /**
     * All fields constructor
     */
    inline  CellSignalStrengthStatus (uint8 u8SignalSrength_, uint8 u8DeviceHandle_);

    /**
     * Destructor
     */
    inline virtual  ~CellSignalStrengthStatus();

    /**
     * Assignment operator
     */
    inline CellSignalStrengthStatus& operator = (const CellSignalStrengthStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CellSignalStrengthStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CellSignalStrengthStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CellSignalStrengthStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CellSignalStrengthStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8SignalSrength"

    static const int kU8SignalSrength = 0;

    /**
     * Clears the field "u8SignalSrength".
     *
     * The field will be set to its default value. The hasU8SignalSrength()
     * method will return false.
     */
    inline void clearU8SignalSrength();

    /**
     * Checks whether the field "u8SignalSrength" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8SignalSrength()). Otherwise it will return false.
     */
    inline bool hasU8SignalSrength () const;

    /**
     * Returns the value of the member "u8SignalSrength".
     *
     * Cellular signal srength
     *
     * @return The value of the field "u8SignalSrength"
     */
    inline uint8 getU8SignalSrength () const;

    /**
     * Sets the value of the member "u8SignalSrength".
     *
     * Cellular signal srength
     *
     * @param u8SignalSrength The value which will be set
     */
    inline void setU8SignalSrength (uint8 u8SignalSrength_);

    // API of field "u8DeviceHandle"

    static const int kU8DeviceHandle = 1;

    /**
     * Clears the field "u8DeviceHandle".
     *
     * The field will be set to its default value. The hasU8DeviceHandle()
     * method will return false.
     */
    inline void clearU8DeviceHandle();

    /**
     * Checks whether the field "u8DeviceHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8DeviceHandle()). Otherwise it will return false.
     */
    inline bool hasU8DeviceHandle () const;

    /**
     * Returns the value of the member "u8DeviceHandle".
     *
     * Unique handle for each one of the up to 10 devices that can be paired.  Handles are maintained by BluetoothSettings FBlock.  0 is reserved as Null. Valid handles are 1..10 inclusive.
     *
     * @return The value of the field "u8DeviceHandle"
     */
    inline uint8 getU8DeviceHandle () const;

    /**
     * Sets the value of the member "u8DeviceHandle".
     *
     * Unique handle for each one of the up to 10 devices that can be paired.  Handles are maintained by BluetoothSettings FBlock.  0 is reserved as Null. Valid handles are 1..10 inclusive.
     *
     * @param u8DeviceHandle The value which will be set
     */
    inline void setU8DeviceHandle (uint8 u8DeviceHandle_);

    static const CellSignalStrengthStatus &getDefaultInstance();

private:

    inline void set_has_u8SignalSrength ();

    inline void clear_has_u8SignalSrength ();

    inline void set_has_u8DeviceHandle ();

    inline void clear_has_u8DeviceHandle ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint8 _u8SignalSrength;

    uint8 _u8DeviceHandle;

};

/**
 * The error message of 'CellSignalStrength'
 */
class CellSignalStrengthErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  CellSignalStrengthErrorStructure ();

    /**
     * Copy constructor
     */
    inline  CellSignalStrengthErrorStructure (const CellSignalStrengthErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  CellSignalStrengthErrorStructure (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline  ~CellSignalStrengthErrorStructure();

    /**
     * Assignment operator
     */
    inline CellSignalStrengthErrorStructure& operator = (const CellSignalStrengthErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CellSignalStrengthErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CellSignalStrengthErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CellSignalStrengthErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CellSignalStrengthErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     * Error codes outlined in MOST standard, e.g.:
     * $01 Syntax error: F Block does not exist,
     * $02 Syntax error: Instance does not exist,
     * $03 Syntax error: Function does not exist,
     * $04 Syntax error: Operations does not exist,etc.
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     * Error codes outlined in MOST standard, e.g.:
     * $01 Syntax error: F Block does not exist,
     * $02 Syntax error: Instance does not exist,
     * $03 Syntax error: Function does not exist,
     * $04 Syntax error: Operations does not exist,etc.
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 1;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     * This is for error code $20, function specific error information.  Allowed range $01 - $BF.
     *
     * The first byte is the enumeration of error codes as follows:
     * 0x01:  ERR_NOT_AVAILABLE
     * 0x02:  ERR_NOSERVICE
     * 0x03:  ERR_NO_CALL
     * 0x04:  ERR_NETWORK_DENY
     * 0x05:  ERR_NO_AUDIO_CHANNEL
     * 0xD8:  ERR_OTHER
     *
     * The 2nd byte, if present, is the CallInstance of the function that generated the error.
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     * This is for error code $20, function specific error information.  Allowed range $01 - $BF.
     *
     * The first byte is the enumeration of error codes as follows:
     * 0x01:  ERR_NOT_AVAILABLE
     * 0x02:  ERR_NOSERVICE
     * 0x03:  ERR_NO_CALL
     * 0x04:  ERR_NETWORK_DENY
     * 0x05:  ERR_NO_AUDIO_CHANNEL
     * 0xD8:  ERR_OTHER
     *
     * The 2nd byte, if present, is the CallInstance of the function that generated the error.
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    static const CellSignalStrengthErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

};

/**
 * The error message of 'CellSignalStrength'
 */
class CellSignalStrengthError  : public ::asf::core::Payload {
public:

    enum CellSignalStrengthErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  CellSignalStrengthError ();

   /**
     * Copy constructor
     */
    inline  CellSignalStrengthError (const CellSignalStrengthError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~CellSignalStrengthError();

    /**
     * Assigns a new value to this object.
     */
    inline CellSignalStrengthError& operator = (const CellSignalStrengthError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CellSignalStrengthError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CellSignalStrengthError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CellSignalStrengthError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CellSignalStrengthError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline CellSignalStrengthError::CellSignalStrengthErrorField getField () const;

    inline void setField(CellSignalStrengthError::CellSignalStrengthErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "CellSignalStrengthErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "CellSignalStrengthErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const CellSignalStrengthErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline CellSignalStrengthErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline CellSignalStrengthErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (CellSignalStrengthErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "CellSignalStrengthErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const CellSignalStrengthErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const CellSignalStrengthError &getDefaultInstance();

private:

    inline void cloneData (const CellSignalStrengthError& rhs);

    inline void deleteData ();

    CellSignalStrengthErrorField __field;

    union {
        CellSignalStrengthErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "CellStateofCharge"
 * The CellStateOfCharge Property contains the current cell phone charge status from 1 to 5.  HMI controllers register for notification on this property to receive changes in the cell phone state of charge.
 */
class CellStateofChargeStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CellStateofChargeStatus ();

    /**
     * Copy constructor
     */
    inline  CellStateofChargeStatus (const CellStateofChargeStatus &rhs);

    /**
     * All fields constructor
     */
    inline  CellStateofChargeStatus (uint8 u8StateofCharge_, uint8 u8DeviceHandle_);

    /**
     * Destructor
     */
    inline virtual  ~CellStateofChargeStatus();

    /**
     * Assignment operator
     */
    inline CellStateofChargeStatus& operator = (const CellStateofChargeStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CellStateofChargeStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CellStateofChargeStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CellStateofChargeStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CellStateofChargeStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8StateofCharge"

    static const int kU8StateofCharge = 0;

    /**
     * Clears the field "u8StateofCharge".
     *
     * The field will be set to its default value. The hasU8StateofCharge()
     * method will return false.
     */
    inline void clearU8StateofCharge();

    /**
     * Checks whether the field "u8StateofCharge" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8StateofCharge()). Otherwise it will return false.
     */
    inline bool hasU8StateofCharge () const;

    /**
     * Returns the value of the member "u8StateofCharge".
     *
     * State of charge of the handset from 1-5.
     *
     * @return The value of the field "u8StateofCharge"
     */
    inline uint8 getU8StateofCharge () const;

    /**
     * Sets the value of the member "u8StateofCharge".
     *
     * State of charge of the handset from 1-5.
     *
     * @param u8StateofCharge The value which will be set
     */
    inline void setU8StateofCharge (uint8 u8StateofCharge_);

    // API of field "u8DeviceHandle"

    static const int kU8DeviceHandle = 1;

    /**
     * Clears the field "u8DeviceHandle".
     *
     * The field will be set to its default value. The hasU8DeviceHandle()
     * method will return false.
     */
    inline void clearU8DeviceHandle();

    /**
     * Checks whether the field "u8DeviceHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8DeviceHandle()). Otherwise it will return false.
     */
    inline bool hasU8DeviceHandle () const;

    /**
     * Returns the value of the member "u8DeviceHandle".
     *
     * Unique handle for each one of the up to 10 devices that can be paired.  Handles are maintained by BluetoothSettings FBlock.  0 is reserved as Null. Valid handles are 1..10 inclusive.
     *
     * @return The value of the field "u8DeviceHandle"
     */
    inline uint8 getU8DeviceHandle () const;

    /**
     * Sets the value of the member "u8DeviceHandle".
     *
     * Unique handle for each one of the up to 10 devices that can be paired.  Handles are maintained by BluetoothSettings FBlock.  0 is reserved as Null. Valid handles are 1..10 inclusive.
     *
     * @param u8DeviceHandle The value which will be set
     */
    inline void setU8DeviceHandle (uint8 u8DeviceHandle_);

    static const CellStateofChargeStatus &getDefaultInstance();

private:

    inline void set_has_u8StateofCharge ();

    inline void clear_has_u8StateofCharge ();

    inline void set_has_u8DeviceHandle ();

    inline void clear_has_u8DeviceHandle ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint8 _u8StateofCharge;

    uint8 _u8DeviceHandle;

};

/**
 * The error message of 'CellStateofCharge'
 */
class CellStateofChargeErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  CellStateofChargeErrorStructure ();

    /**
     * Copy constructor
     */
    inline  CellStateofChargeErrorStructure (const CellStateofChargeErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  CellStateofChargeErrorStructure (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline  ~CellStateofChargeErrorStructure();

    /**
     * Assignment operator
     */
    inline CellStateofChargeErrorStructure& operator = (const CellStateofChargeErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CellStateofChargeErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CellStateofChargeErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CellStateofChargeErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CellStateofChargeErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     * Error codes outlined in MOST standard, e.g.:
     * $01 Syntax error: F Block does not exist,
     * $02 Syntax error: Instance does not exist,
     * $03 Syntax error: Function does not exist,
     * $04 Syntax error: Operations does not exist,etc.
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     * Error codes outlined in MOST standard, e.g.:
     * $01 Syntax error: F Block does not exist,
     * $02 Syntax error: Instance does not exist,
     * $03 Syntax error: Function does not exist,
     * $04 Syntax error: Operations does not exist,etc.
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 1;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     * This is for error code $20, function specific error information.  Allowed range $01 - $BF.
     *
     * The first byte is the enumeration of error codes as follows:
     * 0x01:  ERR_NOT_AVAILABLE
     * 0x02:  ERR_NOSERVICE
     * 0x03:  ERR_NO_CALL
     * 0x04:  ERR_NETWORK_DENY
     * 0x05:  ERR_NO_AUDIO_CHANNEL
     * 0xD8:  ERR_OTHER
     *
     * The 2nd byte, if present, is the CallInstance of the function that generated the error.
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     * This is for error code $20, function specific error information.  Allowed range $01 - $BF.
     *
     * The first byte is the enumeration of error codes as follows:
     * 0x01:  ERR_NOT_AVAILABLE
     * 0x02:  ERR_NOSERVICE
     * 0x03:  ERR_NO_CALL
     * 0x04:  ERR_NETWORK_DENY
     * 0x05:  ERR_NO_AUDIO_CHANNEL
     * 0xD8:  ERR_OTHER
     *
     * The 2nd byte, if present, is the CallInstance of the function that generated the error.
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    static const CellStateofChargeErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

};

/**
 * The error message of 'CellStateofCharge'
 */
class CellStateofChargeError  : public ::asf::core::Payload {
public:

    enum CellStateofChargeErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  CellStateofChargeError ();

   /**
     * Copy constructor
     */
    inline  CellStateofChargeError (const CellStateofChargeError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~CellStateofChargeError();

    /**
     * Assigns a new value to this object.
     */
    inline CellStateofChargeError& operator = (const CellStateofChargeError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CellStateofChargeError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CellStateofChargeError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CellStateofChargeError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CellStateofChargeError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline CellStateofChargeError::CellStateofChargeErrorField getField () const;

    inline void setField(CellStateofChargeError::CellStateofChargeErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "CellStateofChargeErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "CellStateofChargeErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const CellStateofChargeErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline CellStateofChargeErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline CellStateofChargeErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (CellStateofChargeErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "CellStateofChargeErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const CellStateofChargeErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const CellStateofChargeError &getDefaultInstance();

private:

    inline void cloneData (const CellStateofChargeError& rhs);

    inline void deleteData ();

    CellStateofChargeErrorField __field;

    union {
        CellStateofChargeErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "InComingCallEvent"
 * This notifies HMI when an incoming call arrives.  HMI needs to subscribe on this interface during initialization.  Once subscribed it does not expire untill cleared using notification interface..
 */
class InComingCallEventStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  InComingCallEventStatus ();

    /**
     * Copy constructor
     */
    inline  InComingCallEventStatus (const InComingCallEventStatus &rhs);

    /**
     * All fields constructor
     */
    inline  InComingCallEventStatus (::most_Tel_fi_types::T_e8_TelIncomingCallEventEnum e8IncomingCallEventEnum_, uint16 u16CallInstance_, const ::fi_basetypes_most::T_String& sTelephoneNumber_, const ::fi_basetypes_most::T_String& sFirstName_, const ::fi_basetypes_most::T_String& sLastName_, bool bCallWait_, uint8 u8DeviceHandle_);

    /**
     * Destructor
     */
    inline virtual  ~InComingCallEventStatus();

    /**
     * Assignment operator
     */
    inline InComingCallEventStatus& operator = (const InComingCallEventStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const InComingCallEventStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const InComingCallEventStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const InComingCallEventStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const InComingCallEventStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8IncomingCallEventEnum"

    static const int kE8IncomingCallEventEnum = 0;

    /**
     * Clears the field "e8IncomingCallEventEnum".
     *
     * The field will be set to its default value. The hasE8IncomingCallEventEnum()
     * method will return false.
     */
    inline void clearE8IncomingCallEventEnum();

    /**
     * Checks whether the field "e8IncomingCallEventEnum" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8IncomingCallEventEnum()). Otherwise it will return false.
     */
    inline bool hasE8IncomingCallEventEnum () const;

    /**
     * Returns the value of the member "e8IncomingCallEventEnum".
     *
     * State of incoming call
     *
     * @return The value of the field "e8IncomingCallEventEnum"
     */
    inline ::most_Tel_fi_types::T_e8_TelIncomingCallEventEnum getE8IncomingCallEventEnum () const;

    /**
     * Sets the value of the member "e8IncomingCallEventEnum".
     *
     * State of incoming call
     *
     * @param e8IncomingCallEventEnum The value which will be set
     */
    inline void setE8IncomingCallEventEnum (::most_Tel_fi_types::T_e8_TelIncomingCallEventEnum e8IncomingCallEventEnum_);

    // API of field "u16CallInstance"

    static const int kU16CallInstance = 1;

    /**
     * Clears the field "u16CallInstance".
     *
     * The field will be set to its default value. The hasU16CallInstance()
     * method will return false.
     */
    inline void clearU16CallInstance();

    /**
     * Checks whether the field "u16CallInstance" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16CallInstance()). Otherwise it will return false.
     */
    inline bool hasU16CallInstance () const;

    /**
     * Returns the value of the member "u16CallInstance".
     *
     * Instance of one call from multiple call possible.
     *
     * Call Instance FF means all call.  Like HangUp all calls.
     *
     * @return The value of the field "u16CallInstance"
     */
    inline uint16 getU16CallInstance () const;

    /**
     * Sets the value of the member "u16CallInstance".
     *
     * Instance of one call from multiple call possible.
     *
     * Call Instance FF means all call.  Like HangUp all calls.
     *
     * @param u16CallInstance The value which will be set
     */
    inline void setU16CallInstance (uint16 u16CallInstance_);

    // API of field "sTelephoneNumber"

    static const int kSTelephoneNumber = 2;

    /**
     * Clears the field "sTelephoneNumber".
     *
     * The field will be set to its default value. The hasSTelephoneNumber()
     * method will return false.
     */
    inline void clearSTelephoneNumber();

    /**
     * Checks whether the field "sTelephoneNumber" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSTelephoneNumber()). Otherwise it will return false.
     */
    inline bool hasSTelephoneNumber () const;

    /**
     * Returns the value of the member "sTelephoneNumber".
     *
     * Phone number
     *
     * @return The value of the field "sTelephoneNumber"
     */
    inline const ::fi_basetypes_most::T_String& getSTelephoneNumber () const;

    /**
     * Retrieves the value of the field "sTelephoneNumber" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sTelephoneNumber".
     */
    inline ::fi_basetypes_most::T_String& getSTelephoneNumberMutable ();

    /**
     * Sets the value of the member "sTelephoneNumber".
     *
     * Phone number
     *
     * @param sTelephoneNumber The value which will be set
     */
    inline void setSTelephoneNumber (const ::fi_basetypes_most::T_String& sTelephoneNumber_);

    // API of field "sFirstName"

    static const int kSFirstName = 3;

    /**
     * Clears the field "sFirstName".
     *
     * The field will be set to its default value. The hasSFirstName()
     * method will return false.
     */
    inline void clearSFirstName();

    /**
     * Checks whether the field "sFirstName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSFirstName()). Otherwise it will return false.
     */
    inline bool hasSFirstName () const;

    /**
     * Returns the value of the member "sFirstName".
     *
     * First Name of the caller
     *
     * @return The value of the field "sFirstName"
     */
    inline const ::fi_basetypes_most::T_String& getSFirstName () const;

    /**
     * Retrieves the value of the field "sFirstName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sFirstName".
     */
    inline ::fi_basetypes_most::T_String& getSFirstNameMutable ();

    /**
     * Sets the value of the member "sFirstName".
     *
     * First Name of the caller
     *
     * @param sFirstName The value which will be set
     */
    inline void setSFirstName (const ::fi_basetypes_most::T_String& sFirstName_);

    // API of field "sLastName"

    static const int kSLastName = 4;

    /**
     * Clears the field "sLastName".
     *
     * The field will be set to its default value. The hasSLastName()
     * method will return false.
     */
    inline void clearSLastName();

    /**
     * Checks whether the field "sLastName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSLastName()). Otherwise it will return false.
     */
    inline bool hasSLastName () const;

    /**
     * Returns the value of the member "sLastName".
     *
     * Last Name of the caller.
     *
     * @return The value of the field "sLastName"
     */
    inline const ::fi_basetypes_most::T_String& getSLastName () const;

    /**
     * Retrieves the value of the field "sLastName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sLastName".
     */
    inline ::fi_basetypes_most::T_String& getSLastNameMutable ();

    /**
     * Sets the value of the member "sLastName".
     *
     * Last Name of the caller.
     *
     * @param sLastName The value which will be set
     */
    inline void setSLastName (const ::fi_basetypes_most::T_String& sLastName_);

    // API of field "bCallWait"

    static const int kBCallWait = 5;

    /**
     * Clears the field "bCallWait".
     *
     * The field will be set to its default value. The hasBCallWait()
     * method will return false.
     */
    inline void clearBCallWait();

    /**
     * Checks whether the field "bCallWait" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBCallWait()). Otherwise it will return false.
     */
    inline bool hasBCallWait () const;

    /**
     * Returns the value of the member "bCallWait".
     *
     *
     *
     * @return The value of the field "bCallWait"
     */
    inline bool getBCallWait () const;

    /**
     * Sets the value of the member "bCallWait".
     *
     *
     *
     * @param bCallWait The value which will be set
     */
    inline void setBCallWait (bool bCallWait_);

    // API of field "u8DeviceHandle"

    static const int kU8DeviceHandle = 6;

    /**
     * Clears the field "u8DeviceHandle".
     *
     * The field will be set to its default value. The hasU8DeviceHandle()
     * method will return false.
     */
    inline void clearU8DeviceHandle();

    /**
     * Checks whether the field "u8DeviceHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8DeviceHandle()). Otherwise it will return false.
     */
    inline bool hasU8DeviceHandle () const;

    /**
     * Returns the value of the member "u8DeviceHandle".
     *
     * Unique handle for each one of the up to 10 devices that can be paired.  Handles are maintained by BluetoothSettings FBlock.  0 is reserved as Null. Valid handles are 1..10 inclusive.
     *
     * @return The value of the field "u8DeviceHandle"
     */
    inline uint8 getU8DeviceHandle () const;

    /**
     * Sets the value of the member "u8DeviceHandle".
     *
     * Unique handle for each one of the up to 10 devices that can be paired.  Handles are maintained by BluetoothSettings FBlock.  0 is reserved as Null. Valid handles are 1..10 inclusive.
     *
     * @param u8DeviceHandle The value which will be set
     */
    inline void setU8DeviceHandle (uint8 u8DeviceHandle_);

    static const InComingCallEventStatus &getDefaultInstance();

private:

    inline void set_has_e8IncomingCallEventEnum ();

    inline void clear_has_e8IncomingCallEventEnum ();

    inline void set_has_u16CallInstance ();

    inline void clear_has_u16CallInstance ();

    inline void set_has_sTelephoneNumber ();

    inline void clear_has_sTelephoneNumber ();

    inline void set_has_sFirstName ();

    inline void clear_has_sFirstName ();

    inline void set_has_sLastName ();

    inline void clear_has_sLastName ();

    inline void set_has_bCallWait ();

    inline void clear_has_bCallWait ();

    inline void set_has_u8DeviceHandle ();

    inline void clear_has_u8DeviceHandle ();

    uint32 _has_bits_[ (7 + 31) / 32];

    ::most_Tel_fi_types::T_e8_TelIncomingCallEventEnum _e8IncomingCallEventEnum;

    uint16 _u16CallInstance;

    ::fi_basetypes_most::T_String _sTelephoneNumber;

    ::fi_basetypes_most::T_String _sFirstName;

    ::fi_basetypes_most::T_String _sLastName;

    bool _bCallWait;

    uint8 _u8DeviceHandle;

};

/**
 * The error message of 'InComingCallEvent'
 */
class InComingCallEventErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  InComingCallEventErrorStructure ();

    /**
     * Copy constructor
     */
    inline  InComingCallEventErrorStructure (const InComingCallEventErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  InComingCallEventErrorStructure (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_, ::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    /**
     * Destructor
     */
    inline  ~InComingCallEventErrorStructure();

    /**
     * Assignment operator
     */
    inline InComingCallEventErrorStructure& operator = (const InComingCallEventErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const InComingCallEventErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const InComingCallEventErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const InComingCallEventErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const InComingCallEventErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 0;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     * This is for error code $20, function specific error information.  Allowed range $01 - $BF.
     *
     * The first byte is the enumeration of error codes as follows:
     * 0x01:  ERR_NOT_AVAILABLE
     * 0x02:  ERR_NOSERVICE
     * 0x03:  ERR_NO_CALL
     * 0x04:  ERR_NETWORK_DENY
     * 0x05:  ERR_NO_AUDIO_CHANNEL
     * 0xD8:  ERR_OTHER
     *
     * The 2nd byte, if present, is the CallInstance of the function that generated the error.
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     * This is for error code $20, function specific error information.  Allowed range $01 - $BF.
     *
     * The first byte is the enumeration of error codes as follows:
     * 0x01:  ERR_NOT_AVAILABLE
     * 0x02:  ERR_NOSERVICE
     * 0x03:  ERR_NO_CALL
     * 0x04:  ERR_NETWORK_DENY
     * 0x05:  ERR_NO_AUDIO_CHANNEL
     * 0xD8:  ERR_OTHER
     *
     * The 2nd byte, if present, is the CallInstance of the function that generated the error.
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 1;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     * Error codes outlined in MOST standard, e.g.:
     * $01 Syntax error: F Block does not exist,
     * $02 Syntax error: Instance does not exist,
     * $03 Syntax error: Function does not exist,
     * $04 Syntax error: Operations does not exist,etc.
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     * Error codes outlined in MOST standard, e.g.:
     * $01 Syntax error: F Block does not exist,
     * $02 Syntax error: Instance does not exist,
     * $03 Syntax error: Function does not exist,
     * $04 Syntax error: Operations does not exist,etc.
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    static const InComingCallEventErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

};

/**
 * The error message of 'InComingCallEvent'
 */
class InComingCallEventError  : public ::asf::core::Payload {
public:

    enum InComingCallEventErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  InComingCallEventError ();

   /**
     * Copy constructor
     */
    inline  InComingCallEventError (const InComingCallEventError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~InComingCallEventError();

    /**
     * Assigns a new value to this object.
     */
    inline InComingCallEventError& operator = (const InComingCallEventError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const InComingCallEventError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const InComingCallEventError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const InComingCallEventError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const InComingCallEventError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline InComingCallEventError::InComingCallEventErrorField getField () const;

    inline void setField(InComingCallEventError::InComingCallEventErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "InComingCallEventErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "InComingCallEventErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const InComingCallEventErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline InComingCallEventErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline InComingCallEventErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (InComingCallEventErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "InComingCallEventErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const InComingCallEventErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const InComingCallEventError &getDefaultInstance();

private:

    inline void cloneData (const InComingCallEventError& rhs);

    inline void deleteData ();

    InComingCallEventErrorField __field;

    union {
        InComingCallEventErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "NetworkOperator"
 * Used by HMI to get the name of the cell network operator.
 */
class NetworkOperatorStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  NetworkOperatorStatus ();

    /**
     * Copy constructor
     */
    inline  NetworkOperatorStatus (const NetworkOperatorStatus &rhs);

    /**
     * All fields constructor
     */
    inline  NetworkOperatorStatus (const ::fi_basetypes_most::T_String& sNetworkOperator_);

    /**
     * Destructor
     */
    inline virtual  ~NetworkOperatorStatus();

    /**
     * Assignment operator
     */
    inline NetworkOperatorStatus& operator = (const NetworkOperatorStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const NetworkOperatorStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const NetworkOperatorStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const NetworkOperatorStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const NetworkOperatorStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "sNetworkOperator"

    static const int kSNetworkOperator = 0;

    /**
     * Clears the field "sNetworkOperator".
     *
     * The field will be set to its default value. The hasSNetworkOperator()
     * method will return false.
     */
    inline void clearSNetworkOperator();

    /**
     * Checks whether the field "sNetworkOperator" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSNetworkOperator()). Otherwise it will return false.
     */
    inline bool hasSNetworkOperator () const;

    /**
     * Returns the value of the member "sNetworkOperator".
     *
     * Name of the cell network operator
     *
     * @return The value of the field "sNetworkOperator"
     */
    inline const ::fi_basetypes_most::T_String& getSNetworkOperator () const;

    /**
     * Retrieves the value of the field "sNetworkOperator" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sNetworkOperator".
     */
    inline ::fi_basetypes_most::T_String& getSNetworkOperatorMutable ();

    /**
     * Sets the value of the member "sNetworkOperator".
     *
     * Name of the cell network operator
     *
     * @param sNetworkOperator The value which will be set
     */
    inline void setSNetworkOperator (const ::fi_basetypes_most::T_String& sNetworkOperator_);

    static const NetworkOperatorStatus &getDefaultInstance();

private:

    inline void set_has_sNetworkOperator ();

    inline void clear_has_sNetworkOperator ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::fi_basetypes_most::T_String _sNetworkOperator;

};

/**
 * The error message of 'NetworkOperator'
 */
class NetworkOperatorErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  NetworkOperatorErrorStructure ();

    /**
     * Copy constructor
     */
    inline  NetworkOperatorErrorStructure (const NetworkOperatorErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  NetworkOperatorErrorStructure (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_, ::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    /**
     * Destructor
     */
    inline  ~NetworkOperatorErrorStructure();

    /**
     * Assignment operator
     */
    inline NetworkOperatorErrorStructure& operator = (const NetworkOperatorErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const NetworkOperatorErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const NetworkOperatorErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const NetworkOperatorErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const NetworkOperatorErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 0;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     * This is for error code $20, function specific error information.  Allowed range $01 - $BF.
     *
     * The first byte is the enumeration of error codes as follows:
     * 0x01:  ERR_NOT_AVAILABLE
     * 0x02:  ERR_NOSERVICE
     * 0x03:  ERR_NO_CALL
     * 0x04:  ERR_NETWORK_DENY
     * 0x05:  ERR_NO_AUDIO_CHANNEL
     * 0xD8:  ERR_OTHER
     * The 2nd byte, if present, is the CallInstance of the function that generated the error.
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     * This is for error code $20, function specific error information.  Allowed range $01 - $BF.
     *
     * The first byte is the enumeration of error codes as follows:
     * 0x01:  ERR_NOT_AVAILABLE
     * 0x02:  ERR_NOSERVICE
     * 0x03:  ERR_NO_CALL
     * 0x04:  ERR_NETWORK_DENY
     * 0x05:  ERR_NO_AUDIO_CHANNEL
     * 0xD8:  ERR_OTHER
     * The 2nd byte, if present, is the CallInstance of the function that generated the error.
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 1;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     * Error codes outlined in MOST standard, e.g.:
     * $01 Syntax error: F Block does not exist,
     * $02 Syntax error: Instance does not exist,
     * $03 Syntax error: Function does not exist,
     * $04 Syntax error: Operations does not exist,etc.
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     * Error codes outlined in MOST standard, e.g.:
     * $01 Syntax error: F Block does not exist,
     * $02 Syntax error: Instance does not exist,
     * $03 Syntax error: Function does not exist,
     * $04 Syntax error: Operations does not exist,etc.
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    static const NetworkOperatorErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

};

/**
 * The error message of 'NetworkOperator'
 */
class NetworkOperatorError  : public ::asf::core::Payload {
public:

    enum NetworkOperatorErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  NetworkOperatorError ();

   /**
     * Copy constructor
     */
    inline  NetworkOperatorError (const NetworkOperatorError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~NetworkOperatorError();

    /**
     * Assigns a new value to this object.
     */
    inline NetworkOperatorError& operator = (const NetworkOperatorError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const NetworkOperatorError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const NetworkOperatorError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const NetworkOperatorError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const NetworkOperatorError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline NetworkOperatorError::NetworkOperatorErrorField getField () const;

    inline void setField(NetworkOperatorError::NetworkOperatorErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "NetworkOperatorErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "NetworkOperatorErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const NetworkOperatorErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline NetworkOperatorErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline NetworkOperatorErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (NetworkOperatorErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "NetworkOperatorErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const NetworkOperatorErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const NetworkOperatorError &getDefaultInstance();

private:

    inline void cloneData (const NetworkOperatorError& rhs);

    inline void deleteData ();

    NetworkOperatorErrorField __field;

    union {
        NetworkOperatorErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "SLCStatus"
 * Returns Blue tooth Serial Link Connection status.  HMI needs to to tell if call dropped due to SLC lost.
 */
class SLCStatusStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SLCStatusStatus ();

    /**
     * Copy constructor
     */
    inline  SLCStatusStatus (const SLCStatusStatus &rhs);

    /**
     * All fields constructor
     */
    inline  SLCStatusStatus (bool bCommandStatus_);

    /**
     * Destructor
     */
    inline virtual  ~SLCStatusStatus();

    /**
     * Assignment operator
     */
    inline SLCStatusStatus& operator = (const SLCStatusStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SLCStatusStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SLCStatusStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SLCStatusStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SLCStatusStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bCommandStatus"

    static const int kBCommandStatus = 0;

    /**
     * Clears the field "bCommandStatus".
     *
     * The field will be set to its default value. The hasBCommandStatus()
     * method will return false.
     */
    inline void clearBCommandStatus();

    /**
     * Checks whether the field "bCommandStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBCommandStatus()). Otherwise it will return false.
     */
    inline bool hasBCommandStatus () const;

    /**
     * Returns the value of the member "bCommandStatus".
     *
     * Outcome of a command.  True is success.
     *
     * @return The value of the field "bCommandStatus"
     */
    inline bool getBCommandStatus () const;

    /**
     * Sets the value of the member "bCommandStatus".
     *
     * Outcome of a command.  True is success.
     *
     * @param bCommandStatus The value which will be set
     */
    inline void setBCommandStatus (bool bCommandStatus_);

    static const SLCStatusStatus &getDefaultInstance();

private:

    inline void set_has_bCommandStatus ();

    inline void clear_has_bCommandStatus ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _bCommandStatus;

};

/**
 * The error message of 'SLCStatus'
 */
class SLCStatusErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  SLCStatusErrorStructure ();

    /**
     * Copy constructor
     */
    inline  SLCStatusErrorStructure (const SLCStatusErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  SLCStatusErrorStructure (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_, ::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    /**
     * Destructor
     */
    inline  ~SLCStatusErrorStructure();

    /**
     * Assignment operator
     */
    inline SLCStatusErrorStructure& operator = (const SLCStatusErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SLCStatusErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SLCStatusErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SLCStatusErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SLCStatusErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 0;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     * This is for error code $20, function specific error information.  Allowed range $01 - $BF.
     *
     * The first byte is the enumeration of error codes as follows:
     * 0x01:  ERR_NOT_AVAILABLE
     * 0x02:  ERR_NOSERVICE
     * 0x03:  ERR_NO_CALL
     * 0x04:  ERR_NETWORK_DENY
     * 0x05:  ERR_NO_AUDIO_CHANNEL
     * 0xD8:  ERR_OTHER
     * The 2nd byte, if present, is the CallInstance of the function that generated the error.
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     * This is for error code $20, function specific error information.  Allowed range $01 - $BF.
     *
     * The first byte is the enumeration of error codes as follows:
     * 0x01:  ERR_NOT_AVAILABLE
     * 0x02:  ERR_NOSERVICE
     * 0x03:  ERR_NO_CALL
     * 0x04:  ERR_NETWORK_DENY
     * 0x05:  ERR_NO_AUDIO_CHANNEL
     * 0xD8:  ERR_OTHER
     * The 2nd byte, if present, is the CallInstance of the function that generated the error.
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 1;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     * Error codes outlined in MOST standard, e.g.:
     * $01 Syntax error: F Block does not exist,
     * $02 Syntax error: Instance does not exist,
     * $03 Syntax error: Function does not exist,
     * $04 Syntax error: Operations does not exist, etc.
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     * Error codes outlined in MOST standard, e.g.:
     * $01 Syntax error: F Block does not exist,
     * $02 Syntax error: Instance does not exist,
     * $03 Syntax error: Function does not exist,
     * $04 Syntax error: Operations does not exist, etc.
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    static const SLCStatusErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

};

/**
 * The error message of 'SLCStatus'
 */
class SLCStatusError  : public ::asf::core::Payload {
public:

    enum SLCStatusErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  SLCStatusError ();

   /**
     * Copy constructor
     */
    inline  SLCStatusError (const SLCStatusError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~SLCStatusError();

    /**
     * Assigns a new value to this object.
     */
    inline SLCStatusError& operator = (const SLCStatusError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SLCStatusError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SLCStatusError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SLCStatusError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SLCStatusError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline SLCStatusError::SLCStatusErrorField getField () const;

    inline void setField(SLCStatusError::SLCStatusErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "SLCStatusErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "SLCStatusErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const SLCStatusErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline SLCStatusErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline SLCStatusErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (SLCStatusErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "SLCStatusErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const SLCStatusErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const SLCStatusError &getDefaultInstance();

private:

    inline void cloneData (const SLCStatusError& rhs);

    inline void deleteData ();

    SLCStatusErrorField __field;

    union {
        SLCStatusErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "VehicleAudio"
 * May be needed by Audio Video, who is using Audio.  If the Telephone FBlock does not hold any Audio channel set it to FALSE,  If it holds an audio channel, set it to TRUE.
 * in 1.4.1 made it a notification
 */
class VehicleAudioStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  VehicleAudioStatus ();

    /**
     * Copy constructor
     */
    inline  VehicleAudioStatus (const VehicleAudioStatus &rhs);

    /**
     * All fields constructor
     */
    inline  VehicleAudioStatus (bool bUsingVehicleAudio_);

    /**
     * Destructor
     */
    inline virtual  ~VehicleAudioStatus();

    /**
     * Assignment operator
     */
    inline VehicleAudioStatus& operator = (const VehicleAudioStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const VehicleAudioStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const VehicleAudioStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const VehicleAudioStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const VehicleAudioStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bUsingVehicleAudio"

    static const int kBUsingVehicleAudio = 0;

    /**
     * Clears the field "bUsingVehicleAudio".
     *
     * The field will be set to its default value. The hasBUsingVehicleAudio()
     * method will return false.
     */
    inline void clearBUsingVehicleAudio();

    /**
     * Checks whether the field "bUsingVehicleAudio" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBUsingVehicleAudio()). Otherwise it will return false.
     */
    inline bool hasBUsingVehicleAudio () const;

    /**
     * Returns the value of the member "bUsingVehicleAudio".
     *
     * Is the call in handset or in vehicle
     *
     * @return The value of the field "bUsingVehicleAudio"
     */
    inline bool getBUsingVehicleAudio () const;

    /**
     * Sets the value of the member "bUsingVehicleAudio".
     *
     * Is the call in handset or in vehicle
     *
     * @param bUsingVehicleAudio The value which will be set
     */
    inline void setBUsingVehicleAudio (bool bUsingVehicleAudio_);

    static const VehicleAudioStatus &getDefaultInstance();

private:

    inline void set_has_bUsingVehicleAudio ();

    inline void clear_has_bUsingVehicleAudio ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _bUsingVehicleAudio;

};

/**
 * The error message of 'VehicleAudio'
 */
class VehicleAudioErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  VehicleAudioErrorStructure ();

    /**
     * Copy constructor
     */
    inline  VehicleAudioErrorStructure (const VehicleAudioErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  VehicleAudioErrorStructure (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_, ::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    /**
     * Destructor
     */
    inline  ~VehicleAudioErrorStructure();

    /**
     * Assignment operator
     */
    inline VehicleAudioErrorStructure& operator = (const VehicleAudioErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const VehicleAudioErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const VehicleAudioErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const VehicleAudioErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const VehicleAudioErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 0;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     * This is for error code $20, function specific error information.  Allowed range $01 - $BF.
     *
     * The first byte is the enumeration of error codes as follows:
     * 0x01:  ERR_NOT_AVAILABLE
     * 0x02:  ERR_NOSERVICE
     * 0x03:  ERR_NO_CALL
     * 0x04:  ERR_NETWORK_DENY
     * 0x05:  ERR_NO_AUDIO_CHANNEL
     * 0xD8:  ERR_OTHER
     *
     * The 2nd byte, if present, is the CallInstance of the function that generated the error.
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     * This is for error code $20, function specific error information.  Allowed range $01 - $BF.
     *
     * The first byte is the enumeration of error codes as follows:
     * 0x01:  ERR_NOT_AVAILABLE
     * 0x02:  ERR_NOSERVICE
     * 0x03:  ERR_NO_CALL
     * 0x04:  ERR_NETWORK_DENY
     * 0x05:  ERR_NO_AUDIO_CHANNEL
     * 0xD8:  ERR_OTHER
     *
     * The 2nd byte, if present, is the CallInstance of the function that generated the error.
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 1;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     * Error codes outlined in MOST standard, e.g.:
     * $01 Syntax error: F Block does not exist,
     * $02 Syntax error: Instance does not exist,
     * $03 Syntax error: Function does not exist,
     * $04 Syntax error: Operations does not exist,etc.
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     * Error codes outlined in MOST standard, e.g.:
     * $01 Syntax error: F Block does not exist,
     * $02 Syntax error: Instance does not exist,
     * $03 Syntax error: Function does not exist,
     * $04 Syntax error: Operations does not exist,etc.
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    static const VehicleAudioErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

};

/**
 * The error message of 'VehicleAudio'
 */
class VehicleAudioError  : public ::asf::core::Payload {
public:

    enum VehicleAudioErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  VehicleAudioError ();

   /**
     * Copy constructor
     */
    inline  VehicleAudioError (const VehicleAudioError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~VehicleAudioError();

    /**
     * Assigns a new value to this object.
     */
    inline VehicleAudioError& operator = (const VehicleAudioError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const VehicleAudioError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const VehicleAudioError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const VehicleAudioError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const VehicleAudioError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline VehicleAudioError::VehicleAudioErrorField getField () const;

    inline void setField(VehicleAudioError::VehicleAudioErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "VehicleAudioErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "VehicleAudioErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const VehicleAudioErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline VehicleAudioErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline VehicleAudioErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (VehicleAudioErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "VehicleAudioErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const VehicleAudioErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const VehicleAudioError &getDefaultInstance();

private:

    inline void cloneData (const VehicleAudioError& rhs);

    inline void deleteData ();

    VehicleAudioErrorField __field;

    union {
        VehicleAudioErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "MicrophoneMuteState"
 * The MicrophoneMuteState Property allows HMI controllers to mute the Telephone microphone and synchronize HMI presentation to the mute state.  Note that although this function may seem to be redundant to the ISink.Mute function also on the Telphone FBlock, ISink.Mute is not intended to be manipulated by HMI controllers.  HMI controllers should use MicrophoneMuteState instead.
 */
class MicrophoneMuteStateStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  MicrophoneMuteStateStatus ();

    /**
     * Copy constructor
     */
    inline  MicrophoneMuteStateStatus (const MicrophoneMuteStateStatus &rhs);

    /**
     * All fields constructor
     */
    inline  MicrophoneMuteStateStatus (bool bEnable_);

    /**
     * Destructor
     */
    inline virtual  ~MicrophoneMuteStateStatus();

    /**
     * Assignment operator
     */
    inline MicrophoneMuteStateStatus& operator = (const MicrophoneMuteStateStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const MicrophoneMuteStateStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const MicrophoneMuteStateStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const MicrophoneMuteStateStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const MicrophoneMuteStateStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bEnable"

    static const int kBEnable = 0;

    /**
     * Clears the field "bEnable".
     *
     * The field will be set to its default value. The hasBEnable()
     * method will return false.
     */
    inline void clearBEnable();

    /**
     * Checks whether the field "bEnable" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBEnable()). Otherwise it will return false.
     */
    inline bool hasBEnable () const;

    /**
     * Returns the value of the member "bEnable".
     *
     * Service enanble flag.
     *
     * @return The value of the field "bEnable"
     */
    inline bool getBEnable () const;

    /**
     * Sets the value of the member "bEnable".
     *
     * Service enanble flag.
     *
     * @param bEnable The value which will be set
     */
    inline void setBEnable (bool bEnable_);

    static const MicrophoneMuteStateStatus &getDefaultInstance();

private:

    inline void set_has_bEnable ();

    inline void clear_has_bEnable ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _bEnable;

};

/**
 * The pureSet message of the property "MicrophoneMuteState"
 * The MicrophoneMuteState Property allows HMI controllers to mute the Telephone microphone and synchronize HMI presentation to the mute state.  Note that although this function may seem to be redundant to the ISink.Mute function also on the Telphone FBlock, ISink.Mute is not intended to be manipulated by HMI controllers.  HMI controllers should use MicrophoneMuteState instead.
 */
class MicrophoneMuteStatePureSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  MicrophoneMuteStatePureSet ();

    /**
     * Copy constructor
     */
    inline  MicrophoneMuteStatePureSet (const MicrophoneMuteStatePureSet &rhs);

    /**
     * All fields constructor
     */
    inline  MicrophoneMuteStatePureSet (bool bEnable_);

    /**
     * Destructor
     */
    inline virtual  ~MicrophoneMuteStatePureSet();

    /**
     * Assignment operator
     */
    inline MicrophoneMuteStatePureSet& operator = (const MicrophoneMuteStatePureSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const MicrophoneMuteStatePureSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const MicrophoneMuteStatePureSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const MicrophoneMuteStatePureSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const MicrophoneMuteStatePureSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bEnable"

    static const int kBEnable = 0;

    /**
     * Clears the field "bEnable".
     *
     * The field will be set to its default value. The hasBEnable()
     * method will return false.
     */
    inline void clearBEnable();

    /**
     * Checks whether the field "bEnable" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBEnable()). Otherwise it will return false.
     */
    inline bool hasBEnable () const;

    /**
     * Returns the value of the member "bEnable".
     *
     * Service enanble flag.
     *
     * @return The value of the field "bEnable"
     */
    inline bool getBEnable () const;

    /**
     * Sets the value of the member "bEnable".
     *
     * Service enanble flag.
     *
     * @param bEnable The value which will be set
     */
    inline void setBEnable (bool bEnable_);

    static const MicrophoneMuteStatePureSet &getDefaultInstance();

private:

    inline void set_has_bEnable ();

    inline void clear_has_bEnable ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _bEnable;

};

/**
 * The error message of 'MicrophoneMuteState'
 */
class MicrophoneMuteStateErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  MicrophoneMuteStateErrorStructure ();

    /**
     * Copy constructor
     */
    inline  MicrophoneMuteStateErrorStructure (const MicrophoneMuteStateErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  MicrophoneMuteStateErrorStructure (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline  ~MicrophoneMuteStateErrorStructure();

    /**
     * Assignment operator
     */
    inline MicrophoneMuteStateErrorStructure& operator = (const MicrophoneMuteStateErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const MicrophoneMuteStateErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const MicrophoneMuteStateErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const MicrophoneMuteStateErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const MicrophoneMuteStateErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     * Error codes outlined in MOST standard, e.g.:
     * $01 Syntax error: F Block does not exist,
     * $02 Syntax error: Instance does not exist,
     * $03 Syntax error: Function does not exist,
     * $04 Syntax error: Operations does not exist,etc.
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     * Error codes outlined in MOST standard, e.g.:
     * $01 Syntax error: F Block does not exist,
     * $02 Syntax error: Instance does not exist,
     * $03 Syntax error: Function does not exist,
     * $04 Syntax error: Operations does not exist,etc.
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 1;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     * This is for error code $20, function specific error information.  Allowed range $01 - $BF.
     *
     * The first byte is the enumeration of error codes as follows:
     * 0x01:  ERR_NOT_AVAILABLE
     * 0x02:  ERR_NOSERVICE
     * 0x03:  ERR_NO_CALL
     * 0x04:  ERR_NETWORK_DENY
     * 0x05:  ERR_NO_AUDIO_CHANNEL
     * 0xD8:  ERR_OTHER
     *
     * The 2nd byte, if present, is the CallInstance of the function that generated the error.
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     * This is for error code $20, function specific error information.  Allowed range $01 - $BF.
     *
     * The first byte is the enumeration of error codes as follows:
     * 0x01:  ERR_NOT_AVAILABLE
     * 0x02:  ERR_NOSERVICE
     * 0x03:  ERR_NO_CALL
     * 0x04:  ERR_NETWORK_DENY
     * 0x05:  ERR_NO_AUDIO_CHANNEL
     * 0xD8:  ERR_OTHER
     *
     * The 2nd byte, if present, is the CallInstance of the function that generated the error.
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    static const MicrophoneMuteStateErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

};

/**
 * The error message of 'MicrophoneMuteState'
 */
class MicrophoneMuteStateError  : public ::asf::core::Payload {
public:

    enum MicrophoneMuteStateErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  MicrophoneMuteStateError ();

   /**
     * Copy constructor
     */
    inline  MicrophoneMuteStateError (const MicrophoneMuteStateError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~MicrophoneMuteStateError();

    /**
     * Assigns a new value to this object.
     */
    inline MicrophoneMuteStateError& operator = (const MicrophoneMuteStateError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const MicrophoneMuteStateError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const MicrophoneMuteStateError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const MicrophoneMuteStateError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const MicrophoneMuteStateError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline MicrophoneMuteStateError::MicrophoneMuteStateErrorField getField () const;

    inline void setField(MicrophoneMuteStateError::MicrophoneMuteStateErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "MicrophoneMuteStateErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "MicrophoneMuteStateErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const MicrophoneMuteStateErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline MicrophoneMuteStateErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline MicrophoneMuteStateErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (MicrophoneMuteStateErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "MicrophoneMuteStateErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const MicrophoneMuteStateErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const MicrophoneMuteStateError &getDefaultInstance();

private:

    inline void cloneData (const MicrophoneMuteStateError& rhs);

    inline void deleteData ();

    MicrophoneMuteStateErrorField __field;

    union {
        MicrophoneMuteStateErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "RingtoneMuteState"
 * The RingtoneMuteState Property allows HMI controllers to mute the ring tone from the telephone synchronize ther HMI presentation to the mute state.
 */
class RingtoneMuteStateStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RingtoneMuteStateStatus ();

    /**
     * Copy constructor
     */
    inline  RingtoneMuteStateStatus (const RingtoneMuteStateStatus &rhs);

    /**
     * All fields constructor
     */
    inline  RingtoneMuteStateStatus (bool bEnable_);

    /**
     * Destructor
     */
    inline virtual  ~RingtoneMuteStateStatus();

    /**
     * Assignment operator
     */
    inline RingtoneMuteStateStatus& operator = (const RingtoneMuteStateStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RingtoneMuteStateStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RingtoneMuteStateStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RingtoneMuteStateStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RingtoneMuteStateStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bEnable"

    static const int kBEnable = 0;

    /**
     * Clears the field "bEnable".
     *
     * The field will be set to its default value. The hasBEnable()
     * method will return false.
     */
    inline void clearBEnable();

    /**
     * Checks whether the field "bEnable" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBEnable()). Otherwise it will return false.
     */
    inline bool hasBEnable () const;

    /**
     * Returns the value of the member "bEnable".
     *
     * Service enanble flag.
     *
     * @return The value of the field "bEnable"
     */
    inline bool getBEnable () const;

    /**
     * Sets the value of the member "bEnable".
     *
     * Service enanble flag.
     *
     * @param bEnable The value which will be set
     */
    inline void setBEnable (bool bEnable_);

    static const RingtoneMuteStateStatus &getDefaultInstance();

private:

    inline void set_has_bEnable ();

    inline void clear_has_bEnable ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _bEnable;

};

/**
 * The pureSet message of the property "RingtoneMuteState"
 * The RingtoneMuteState Property allows HMI controllers to mute the ring tone from the telephone synchronize ther HMI presentation to the mute state.
 */
class RingtoneMuteStatePureSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RingtoneMuteStatePureSet ();

    /**
     * Copy constructor
     */
    inline  RingtoneMuteStatePureSet (const RingtoneMuteStatePureSet &rhs);

    /**
     * All fields constructor
     */
    inline  RingtoneMuteStatePureSet (bool bEnable_);

    /**
     * Destructor
     */
    inline virtual  ~RingtoneMuteStatePureSet();

    /**
     * Assignment operator
     */
    inline RingtoneMuteStatePureSet& operator = (const RingtoneMuteStatePureSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RingtoneMuteStatePureSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RingtoneMuteStatePureSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RingtoneMuteStatePureSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RingtoneMuteStatePureSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bEnable"

    static const int kBEnable = 0;

    /**
     * Clears the field "bEnable".
     *
     * The field will be set to its default value. The hasBEnable()
     * method will return false.
     */
    inline void clearBEnable();

    /**
     * Checks whether the field "bEnable" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBEnable()). Otherwise it will return false.
     */
    inline bool hasBEnable () const;

    /**
     * Returns the value of the member "bEnable".
     *
     * Service enanble flag.
     *
     * @return The value of the field "bEnable"
     */
    inline bool getBEnable () const;

    /**
     * Sets the value of the member "bEnable".
     *
     * Service enanble flag.
     *
     * @param bEnable The value which will be set
     */
    inline void setBEnable (bool bEnable_);

    static const RingtoneMuteStatePureSet &getDefaultInstance();

private:

    inline void set_has_bEnable ();

    inline void clear_has_bEnable ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _bEnable;

};

/**
 * The error message of 'RingtoneMuteState'
 */
class RingtoneMuteStateErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  RingtoneMuteStateErrorStructure ();

    /**
     * Copy constructor
     */
    inline  RingtoneMuteStateErrorStructure (const RingtoneMuteStateErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  RingtoneMuteStateErrorStructure (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline  ~RingtoneMuteStateErrorStructure();

    /**
     * Assignment operator
     */
    inline RingtoneMuteStateErrorStructure& operator = (const RingtoneMuteStateErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RingtoneMuteStateErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RingtoneMuteStateErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RingtoneMuteStateErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RingtoneMuteStateErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     * Error codes outlined in MOST standard, e.g.:
     * $01 Syntax error: F Block does not exist,
     * $02 Syntax error: Instance does not exist,
     * $03 Syntax error: Function does not exist,
     * $04 Syntax error: Operations does not exist,etc.
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     * Error codes outlined in MOST standard, e.g.:
     * $01 Syntax error: F Block does not exist,
     * $02 Syntax error: Instance does not exist,
     * $03 Syntax error: Function does not exist,
     * $04 Syntax error: Operations does not exist,etc.
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 1;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     * This is for error code $20, function specific error information.  Allowed range $01 - $BF.
     *
     * The first byte is the enumeration of error codes as follows:
     * 0x01:  ERR_NOT_AVAILABLE
     * 0x02:  ERR_NOSERVICE
     * 0x03:  ERR_NO_CALL
     * 0x04:  ERR_NETWORK_DENY
     * 0x05:  ERR_NO_AUDIO_CHANNEL
     * 0xD8:  ERR_OTHER
     *
     * The 2nd byte, if present, is the CallInstance of the function that generated the error.
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     * This is for error code $20, function specific error information.  Allowed range $01 - $BF.
     *
     * The first byte is the enumeration of error codes as follows:
     * 0x01:  ERR_NOT_AVAILABLE
     * 0x02:  ERR_NOSERVICE
     * 0x03:  ERR_NO_CALL
     * 0x04:  ERR_NETWORK_DENY
     * 0x05:  ERR_NO_AUDIO_CHANNEL
     * 0xD8:  ERR_OTHER
     *
     * The 2nd byte, if present, is the CallInstance of the function that generated the error.
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    static const RingtoneMuteStateErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

};

/**
 * The error message of 'RingtoneMuteState'
 */
class RingtoneMuteStateError  : public ::asf::core::Payload {
public:

    enum RingtoneMuteStateErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  RingtoneMuteStateError ();

   /**
     * Copy constructor
     */
    inline  RingtoneMuteStateError (const RingtoneMuteStateError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~RingtoneMuteStateError();

    /**
     * Assigns a new value to this object.
     */
    inline RingtoneMuteStateError& operator = (const RingtoneMuteStateError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RingtoneMuteStateError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RingtoneMuteStateError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RingtoneMuteStateError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RingtoneMuteStateError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline RingtoneMuteStateError::RingtoneMuteStateErrorField getField () const;

    inline void setField(RingtoneMuteStateError::RingtoneMuteStateErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "RingtoneMuteStateErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "RingtoneMuteStateErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const RingtoneMuteStateErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline RingtoneMuteStateErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline RingtoneMuteStateErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (RingtoneMuteStateErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "RingtoneMuteStateErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const RingtoneMuteStateErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const RingtoneMuteStateError &getDefaultInstance();

private:

    inline void cloneData (const RingtoneMuteStateError& rhs);

    inline void deleteData ();

    RingtoneMuteStateErrorField __field;

    union {
        RingtoneMuteStateErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "HFService"
 * This property is fetched from AG and notified upon connection to a phone device so that HMI could properly display Call waiting and Three way calling service availability.
 */
class HFServiceStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  HFServiceStatus ();

    /**
     * Copy constructor
     */
    inline  HFServiceStatus (const HFServiceStatus &rhs);

    /**
     * All fields constructor
     */
    inline  HFServiceStatus (bool bCallWaitAvail_, bool bThreeWayCallAvail_);

    /**
     * Destructor
     */
    inline virtual  ~HFServiceStatus();

    /**
     * Assignment operator
     */
    inline HFServiceStatus& operator = (const HFServiceStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const HFServiceStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const HFServiceStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const HFServiceStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const HFServiceStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bCallWaitAvail"

    static const int kBCallWaitAvail = 0;

    /**
     * Clears the field "bCallWaitAvail".
     *
     * The field will be set to its default value. The hasBCallWaitAvail()
     * method will return false.
     */
    inline void clearBCallWaitAvail();

    /**
     * Checks whether the field "bCallWaitAvail" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBCallWaitAvail()). Otherwise it will return false.
     */
    inline bool hasBCallWaitAvail () const;

    /**
     * Returns the value of the member "bCallWaitAvail".
     *
     * If call waiting is avaialble in the BT AG
     *
     * @return The value of the field "bCallWaitAvail"
     */
    inline bool getBCallWaitAvail () const;

    /**
     * Sets the value of the member "bCallWaitAvail".
     *
     * If call waiting is avaialble in the BT AG
     *
     * @param bCallWaitAvail The value which will be set
     */
    inline void setBCallWaitAvail (bool bCallWaitAvail_);

    // API of field "bThreeWayCallAvail"

    static const int kBThreeWayCallAvail = 1;

    /**
     * Clears the field "bThreeWayCallAvail".
     *
     * The field will be set to its default value. The hasBThreeWayCallAvail()
     * method will return false.
     */
    inline void clearBThreeWayCallAvail();

    /**
     * Checks whether the field "bThreeWayCallAvail" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBThreeWayCallAvail()). Otherwise it will return false.
     */
    inline bool hasBThreeWayCallAvail () const;

    /**
     * Returns the value of the member "bThreeWayCallAvail".
     *
     * Three Way call's availability in BT AG
     *
     * @return The value of the field "bThreeWayCallAvail"
     */
    inline bool getBThreeWayCallAvail () const;

    /**
     * Sets the value of the member "bThreeWayCallAvail".
     *
     * Three Way call's availability in BT AG
     *
     * @param bThreeWayCallAvail The value which will be set
     */
    inline void setBThreeWayCallAvail (bool bThreeWayCallAvail_);

    static const HFServiceStatus &getDefaultInstance();

private:

    inline void set_has_bCallWaitAvail ();

    inline void clear_has_bCallWaitAvail ();

    inline void set_has_bThreeWayCallAvail ();

    inline void clear_has_bThreeWayCallAvail ();

    uint32 _has_bits_[ (2 + 31) / 32];

    bool _bCallWaitAvail;

    bool _bThreeWayCallAvail;

};

/**
 * The error message of 'HFService'
 */
class HFServiceErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  HFServiceErrorStructure ();

    /**
     * Copy constructor
     */
    inline  HFServiceErrorStructure (const HFServiceErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  HFServiceErrorStructure (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline  ~HFServiceErrorStructure();

    /**
     * Assignment operator
     */
    inline HFServiceErrorStructure& operator = (const HFServiceErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const HFServiceErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const HFServiceErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const HFServiceErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const HFServiceErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     * Error codes outlined in MOST standard, e.g.:
     * $01 Syntax error: F Block does not exist,
     * $02 Syntax error: Instance does not exist,
     * $03 Syntax error: Function does not exist,
     * $04 Syntax error: Operations does not exist,etc.
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     * Error codes outlined in MOST standard, e.g.:
     * $01 Syntax error: F Block does not exist,
     * $02 Syntax error: Instance does not exist,
     * $03 Syntax error: Function does not exist,
     * $04 Syntax error: Operations does not exist,etc.
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 1;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     * This is for error code $20, function specific error information.  Allowed range $01 - $BF.
     *
     * The first byte is the enumeration of error codes as follows:
     * 0x01:  ERR_NOT_AVAILABLE
     * 0x02:  ERR_NOSERVICE
     * 0x03:  ERR_NO_CALL
     * 0x04:  ERR_NETWORK_DENY
     * 0x05:  ERR_NO_AUDIO_CHANNEL
     * 0xD8:  ERR_OTHER
     *
     * The 2nd byte, if present, is the CallInstance of the function that generated the error.
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     * This is for error code $20, function specific error information.  Allowed range $01 - $BF.
     *
     * The first byte is the enumeration of error codes as follows:
     * 0x01:  ERR_NOT_AVAILABLE
     * 0x02:  ERR_NOSERVICE
     * 0x03:  ERR_NO_CALL
     * 0x04:  ERR_NETWORK_DENY
     * 0x05:  ERR_NO_AUDIO_CHANNEL
     * 0xD8:  ERR_OTHER
     *
     * The 2nd byte, if present, is the CallInstance of the function that generated the error.
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    static const HFServiceErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

};

/**
 * The error message of 'HFService'
 */
class HFServiceError  : public ::asf::core::Payload {
public:

    enum HFServiceErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  HFServiceError ();

   /**
     * Copy constructor
     */
    inline  HFServiceError (const HFServiceError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~HFServiceError();

    /**
     * Assigns a new value to this object.
     */
    inline HFServiceError& operator = (const HFServiceError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const HFServiceError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const HFServiceError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const HFServiceError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const HFServiceError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline HFServiceError::HFServiceErrorField getField () const;

    inline void setField(HFServiceError::HFServiceErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "HFServiceErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "HFServiceErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const HFServiceErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline HFServiceErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline HFServiceErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (HFServiceErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "HFServiceErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const HFServiceErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const HFServiceError &getDefaultInstance();

private:

    inline void cloneData (const HFServiceError& rhs);

    inline void deleteData ();

    HFServiceErrorField __field;

    union {
        HFServiceErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "BTDeviceVoiceRecognition"
 * This property is used to activate and deactive the remote device's
 * internal voice recognition that may be used, for example, to also perform
 * 'cloud-based' voice recognition on the Internet as follows:
 *
 *
 * <item>
 * HMI controllers register for notification on this property at
 * initialization.
 * </item>
 * <item>
 * HMI controllers activate this property via a Set(ACTIVE) message.
 * </item>
 * <item>
 * Upon receipt of a Set(ACTIVE), the FBlock either:
 *
 *
 * </item><item>
 * Activates the remote device VR if supported by the device and
 * responds with a Status(ACTIVE) notification to all registered
 * controllers, or
 * </item>
 * <item>
 * If for any reason, the remote device VR cannot be activated in
 * response to the Set, the FBlock issues another Status(INACTIVE) to
 * all registered controllers. Note that the FBlock does NOT issue an
 * Error message if remote VR is not supported by the device.
 * </item>
 *
 * <item>The BTDeviceVoiceRecSupported flag reports whether or not the current outgoing source device supports remote Bluetooth device voice rec or not.
 * </item>
 */
class BTDeviceVoiceRecognitionStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  BTDeviceVoiceRecognitionStatus ();

    /**
     * Copy constructor
     */
    inline  BTDeviceVoiceRecognitionStatus (const BTDeviceVoiceRecognitionStatus &rhs);

    /**
     * All fields constructor
     */
    inline  BTDeviceVoiceRecognitionStatus (bool bBTDeviceVoiceRecActive_, bool bBTDeviceVoiceRecSupported_);

    /**
     * Destructor
     */
    inline virtual  ~BTDeviceVoiceRecognitionStatus();

    /**
     * Assignment operator
     */
    inline BTDeviceVoiceRecognitionStatus& operator = (const BTDeviceVoiceRecognitionStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const BTDeviceVoiceRecognitionStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const BTDeviceVoiceRecognitionStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const BTDeviceVoiceRecognitionStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const BTDeviceVoiceRecognitionStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bBTDeviceVoiceRecActive"

    static const int kBBTDeviceVoiceRecActive = 0;

    /**
     * Clears the field "bBTDeviceVoiceRecActive".
     *
     * The field will be set to its default value. The hasBBTDeviceVoiceRecActive()
     * method will return false.
     */
    inline void clearBBTDeviceVoiceRecActive();

    /**
     * Checks whether the field "bBTDeviceVoiceRecActive" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBBTDeviceVoiceRecActive()). Otherwise it will return false.
     */
    inline bool hasBBTDeviceVoiceRecActive () const;

    /**
     * Returns the value of the member "bBTDeviceVoiceRecActive".
     *
     * The state of the remote Bluetooth device voice recognition.  This parameter shall be set to False at initialization default.
     *
     * @return The value of the field "bBTDeviceVoiceRecActive"
     */
    inline bool getBBTDeviceVoiceRecActive () const;

    /**
     * Sets the value of the member "bBTDeviceVoiceRecActive".
     *
     * The state of the remote Bluetooth device voice recognition.  This parameter shall be set to False at initialization default.
     *
     * @param bBTDeviceVoiceRecActive The value which will be set
     */
    inline void setBBTDeviceVoiceRecActive (bool bBTDeviceVoiceRecActive_);

    // API of field "bBTDeviceVoiceRecSupported"

    static const int kBBTDeviceVoiceRecSupported = 1;

    /**
     * Clears the field "bBTDeviceVoiceRecSupported".
     *
     * The field will be set to its default value. The hasBBTDeviceVoiceRecSupported()
     * method will return false.
     */
    inline void clearBBTDeviceVoiceRecSupported();

    /**
     * Checks whether the field "bBTDeviceVoiceRecSupported" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBBTDeviceVoiceRecSupported()). Otherwise it will return false.
     */
    inline bool hasBBTDeviceVoiceRecSupported () const;

    /**
     * Returns the value of the member "bBTDeviceVoiceRecSupported".
     *
     * Reports whether or not the currently outgoing source device supports remote Bluetooth Device voice recognition or not.
     *
     * The default value at initialization is False, not supported.
     *
     * @return The value of the field "bBTDeviceVoiceRecSupported"
     */
    inline bool getBBTDeviceVoiceRecSupported () const;

    /**
     * Sets the value of the member "bBTDeviceVoiceRecSupported".
     *
     * Reports whether or not the currently outgoing source device supports remote Bluetooth Device voice recognition or not.
     *
     * The default value at initialization is False, not supported.
     *
     * @param bBTDeviceVoiceRecSupported The value which will be set
     */
    inline void setBBTDeviceVoiceRecSupported (bool bBTDeviceVoiceRecSupported_);

    static const BTDeviceVoiceRecognitionStatus &getDefaultInstance();

private:

    inline void set_has_bBTDeviceVoiceRecActive ();

    inline void clear_has_bBTDeviceVoiceRecActive ();

    inline void set_has_bBTDeviceVoiceRecSupported ();

    inline void clear_has_bBTDeviceVoiceRecSupported ();

    uint32 _has_bits_[ (2 + 31) / 32];

    bool _bBTDeviceVoiceRecActive;

    bool _bBTDeviceVoiceRecSupported;

};

/**
 * The pureSet message of the property "BTDeviceVoiceRecognition"
 * This property is used to activate and deactive the remote device's
 * internal voice recognition that may be used, for example, to also perform
 * 'cloud-based' voice recognition on the Internet as follows:
 *
 *
 * <item>
 * HMI controllers register for notification on this property at
 * initialization.
 * </item>
 * <item>
 * HMI controllers activate this property via a Set(ACTIVE) message.
 * </item>
 * <item>
 * Upon receipt of a Set(ACTIVE), the FBlock either:
 *
 *
 * </item><item>
 * Activates the remote device VR if supported by the device and
 * responds with a Status(ACTIVE) notification to all registered
 * controllers, or
 * </item>
 * <item>
 * If for any reason, the remote device VR cannot be activated in
 * response to the Set, the FBlock issues another Status(INACTIVE) to
 * all registered controllers. Note that the FBlock does NOT issue an
 * Error message if remote VR is not supported by the device.
 * </item>
 *
 * <item>The BTDeviceVoiceRecSupported flag reports whether or not the current outgoing source device supports remote Bluetooth device voice rec or not.
 * </item>
 */
class BTDeviceVoiceRecognitionPureSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  BTDeviceVoiceRecognitionPureSet ();

    /**
     * Copy constructor
     */
    inline  BTDeviceVoiceRecognitionPureSet (const BTDeviceVoiceRecognitionPureSet &rhs);

    /**
     * All fields constructor
     */
    inline  BTDeviceVoiceRecognitionPureSet (bool bBTDeviceVoiceRecActive_);

    /**
     * Destructor
     */
    inline virtual  ~BTDeviceVoiceRecognitionPureSet();

    /**
     * Assignment operator
     */
    inline BTDeviceVoiceRecognitionPureSet& operator = (const BTDeviceVoiceRecognitionPureSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const BTDeviceVoiceRecognitionPureSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const BTDeviceVoiceRecognitionPureSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const BTDeviceVoiceRecognitionPureSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const BTDeviceVoiceRecognitionPureSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bBTDeviceVoiceRecActive"

    static const int kBBTDeviceVoiceRecActive = 0;

    /**
     * Clears the field "bBTDeviceVoiceRecActive".
     *
     * The field will be set to its default value. The hasBBTDeviceVoiceRecActive()
     * method will return false.
     */
    inline void clearBBTDeviceVoiceRecActive();

    /**
     * Checks whether the field "bBTDeviceVoiceRecActive" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBBTDeviceVoiceRecActive()). Otherwise it will return false.
     */
    inline bool hasBBTDeviceVoiceRecActive () const;

    /**
     * Returns the value of the member "bBTDeviceVoiceRecActive".
     *
     * The state of the remote Bluetooth device voice recognition.  This parameter shall be set to False at initialization default.
     *
     * @return The value of the field "bBTDeviceVoiceRecActive"
     */
    inline bool getBBTDeviceVoiceRecActive () const;

    /**
     * Sets the value of the member "bBTDeviceVoiceRecActive".
     *
     * The state of the remote Bluetooth device voice recognition.  This parameter shall be set to False at initialization default.
     *
     * @param bBTDeviceVoiceRecActive The value which will be set
     */
    inline void setBBTDeviceVoiceRecActive (bool bBTDeviceVoiceRecActive_);

    static const BTDeviceVoiceRecognitionPureSet &getDefaultInstance();

private:

    inline void set_has_bBTDeviceVoiceRecActive ();

    inline void clear_has_bBTDeviceVoiceRecActive ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _bBTDeviceVoiceRecActive;

};

/**
 * The error message of 'BTDeviceVoiceRecognition'
 */
class BTDeviceVoiceRecognitionErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  BTDeviceVoiceRecognitionErrorStructure ();

    /**
     * Copy constructor
     */
    inline  BTDeviceVoiceRecognitionErrorStructure (const BTDeviceVoiceRecognitionErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  BTDeviceVoiceRecognitionErrorStructure (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline  ~BTDeviceVoiceRecognitionErrorStructure();

    /**
     * Assignment operator
     */
    inline BTDeviceVoiceRecognitionErrorStructure& operator = (const BTDeviceVoiceRecognitionErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const BTDeviceVoiceRecognitionErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const BTDeviceVoiceRecognitionErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const BTDeviceVoiceRecognitionErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const BTDeviceVoiceRecognitionErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     * Error codes outlined in MOST standard, e.g.:
     * $01 Syntax error: F Block does not exist,
     * $02 Syntax error: Instance does not exist,
     * $03 Syntax error: Function does not exist,
     * $04 Syntax error: Operations does not exist,etc.
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     * Error codes outlined in MOST standard, e.g.:
     * $01 Syntax error: F Block does not exist,
     * $02 Syntax error: Instance does not exist,
     * $03 Syntax error: Function does not exist,
     * $04 Syntax error: Operations does not exist,etc.
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 1;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     * This is for error code $20, function specific error information.  Allowed range $01 - $BF.
     *
     * The first byte is the enumeration of error codes as follows:
     * 0x01:  ERR_NOT_AVAILABLE
     * 0x02:  ERR_NOSERVICE
     * 0x03:  ERR_NO_CALL
     * 0x04:  ERR_NETWORK_DENY
     * 0x05:  ERR_NO_AUDIO_CHANNEL
     * 0xD8:  ERR_OTHER
     *
     * The 2nd byte, if present, is the CallInstance of the function that generated the error.
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     * This is for error code $20, function specific error information.  Allowed range $01 - $BF.
     *
     * The first byte is the enumeration of error codes as follows:
     * 0x01:  ERR_NOT_AVAILABLE
     * 0x02:  ERR_NOSERVICE
     * 0x03:  ERR_NO_CALL
     * 0x04:  ERR_NETWORK_DENY
     * 0x05:  ERR_NO_AUDIO_CHANNEL
     * 0xD8:  ERR_OTHER
     *
     * The 2nd byte, if present, is the CallInstance of the function that generated the error.
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    static const BTDeviceVoiceRecognitionErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

};

/**
 * The error message of 'BTDeviceVoiceRecognition'
 */
class BTDeviceVoiceRecognitionError  : public ::asf::core::Payload {
public:

    enum BTDeviceVoiceRecognitionErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  BTDeviceVoiceRecognitionError ();

   /**
     * Copy constructor
     */
    inline  BTDeviceVoiceRecognitionError (const BTDeviceVoiceRecognitionError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~BTDeviceVoiceRecognitionError();

    /**
     * Assigns a new value to this object.
     */
    inline BTDeviceVoiceRecognitionError& operator = (const BTDeviceVoiceRecognitionError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const BTDeviceVoiceRecognitionError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const BTDeviceVoiceRecognitionError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const BTDeviceVoiceRecognitionError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const BTDeviceVoiceRecognitionError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline BTDeviceVoiceRecognitionError::BTDeviceVoiceRecognitionErrorField getField () const;

    inline void setField(BTDeviceVoiceRecognitionError::BTDeviceVoiceRecognitionErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "BTDeviceVoiceRecognitionErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "BTDeviceVoiceRecognitionErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const BTDeviceVoiceRecognitionErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline BTDeviceVoiceRecognitionErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline BTDeviceVoiceRecognitionErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (BTDeviceVoiceRecognitionErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "BTDeviceVoiceRecognitionErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const BTDeviceVoiceRecognitionErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const BTDeviceVoiceRecognitionError &getDefaultInstance();

private:

    inline void cloneData (const BTDeviceVoiceRecognitionError& rhs);

    inline void deleteData ();

    BTDeviceVoiceRecognitionErrorField __field;

    union {
        BTDeviceVoiceRecognitionErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "HandsFreeEnhancedCallControl"
 * The HandsFreeEnhancedCallControl property is defined in order to allow HMI
 * controllers to know whether or not a particular phone device supports
 * enhanced call control features such as unmerging a conference call or
 * ending an individual call within a conference call as follows:
 *
 *
 * <item>
 * HMI controllers shall register for notification of the
 * HFEnhancedCallControl property at initialization.
 * </item>
 * <item>
 * The HFEnhancedCallControl property shall support two Boolean
 * parameters, EndTargetCall and SplitMergeCalls that shall be set
 * according to the following table:
 *
 * </item>
 */
class HandsFreeEnhancedCallControlStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  HandsFreeEnhancedCallControlStatus ();

    /**
     * Copy constructor
     */
    inline  HandsFreeEnhancedCallControlStatus (const HandsFreeEnhancedCallControlStatus &rhs);

    /**
     * All fields constructor
     */
    inline  HandsFreeEnhancedCallControlStatus (const ::most_Tel_fi_types::T_TelHFEnhancedCallControlStream& oHFEnhancedCallControlStream_);

    /**
     * Destructor
     */
    inline virtual  ~HandsFreeEnhancedCallControlStatus();

    /**
     * Assignment operator
     */
    inline HandsFreeEnhancedCallControlStatus& operator = (const HandsFreeEnhancedCallControlStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const HandsFreeEnhancedCallControlStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const HandsFreeEnhancedCallControlStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const HandsFreeEnhancedCallControlStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const HandsFreeEnhancedCallControlStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "oHFEnhancedCallControlStream"

    static const int kOHFEnhancedCallControlStream = 0;

    /**
     * Clears the field "oHFEnhancedCallControlStream".
     *
     * The field will be set to its default value. The hasOHFEnhancedCallControlStream()
     * method will return false.
     */
    inline void clearOHFEnhancedCallControlStream();

    /**
     * Checks whether the field "oHFEnhancedCallControlStream" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOHFEnhancedCallControlStream()). Otherwise it will return false.
     */
    inline bool hasOHFEnhancedCallControlStream () const;

    /**
     * Returns the value of the member "oHFEnhancedCallControlStream".
     *
     * Stream containing flags for enhanced call control support.  Length has been defined to allow for sending the capabilities for up to two simultaneously connected devices.  The values of the parameters following each DeviceHandle are the capabilities for that device.
     *
     * @return The value of the field "oHFEnhancedCallControlStream"
     */
    inline const ::most_Tel_fi_types::T_TelHFEnhancedCallControlStream& getOHFEnhancedCallControlStream () const;

    /**
     * Retrieves the value of the field "oHFEnhancedCallControlStream" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oHFEnhancedCallControlStream".
     */
    inline ::most_Tel_fi_types::T_TelHFEnhancedCallControlStream& getOHFEnhancedCallControlStreamMutable ();

    /**
     * Sets the value of the member "oHFEnhancedCallControlStream".
     *
     * Stream containing flags for enhanced call control support.  Length has been defined to allow for sending the capabilities for up to two simultaneously connected devices.  The values of the parameters following each DeviceHandle are the capabilities for that device.
     *
     * @param oHFEnhancedCallControlStream The value which will be set
     */
    inline void setOHFEnhancedCallControlStream (const ::most_Tel_fi_types::T_TelHFEnhancedCallControlStream& oHFEnhancedCallControlStream_);

    static const HandsFreeEnhancedCallControlStatus &getDefaultInstance();

private:

    static const ::std::vector< ::most_Tel_fi_types::T_TelHFEnhancedCallControlStreamItem >& getT_TelHFEnhancedCallControlStreamItemList_DefaultInstance ();

    inline void set_has_oHFEnhancedCallControlStream ();

    inline void clear_has_oHFEnhancedCallControlStream ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::most_Tel_fi_types::T_TelHFEnhancedCallControlStream _oHFEnhancedCallControlStream;

};

/**
 * The error message of 'HandsFreeEnhancedCallControl'
 */
class HandsFreeEnhancedCallControlErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  HandsFreeEnhancedCallControlErrorStructure ();

    /**
     * Copy constructor
     */
    inline  HandsFreeEnhancedCallControlErrorStructure (const HandsFreeEnhancedCallControlErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  HandsFreeEnhancedCallControlErrorStructure (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline  ~HandsFreeEnhancedCallControlErrorStructure();

    /**
     * Assignment operator
     */
    inline HandsFreeEnhancedCallControlErrorStructure& operator = (const HandsFreeEnhancedCallControlErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const HandsFreeEnhancedCallControlErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const HandsFreeEnhancedCallControlErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const HandsFreeEnhancedCallControlErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const HandsFreeEnhancedCallControlErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     * Error codes outlined in MOST standard, e.g.:
     * $01 Syntax error: F Block does not exist,
     * $02 Syntax error: Instance does not exist,
     * $03 Syntax error: Function does not exist,
     * $04 Syntax error: Operations does not exist,etc.
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     * Error codes outlined in MOST standard, e.g.:
     * $01 Syntax error: F Block does not exist,
     * $02 Syntax error: Instance does not exist,
     * $03 Syntax error: Function does not exist,
     * $04 Syntax error: Operations does not exist,etc.
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 1;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     * This is for error code $20, function specific error information.  Allowed range $01 - $BF.
     *
     * The first byte is the enumeration of error codes as follows:
     * 0x01:  ERR_NOT_AVAILABLE
     * 0x02:  ERR_NOSERVICE
     * 0x03:  ERR_NO_CALL
     * 0x04:  ERR_NETWORK_DENY
     * 0x05:  ERR_NO_AUDIO_CHANNEL
     * 0xD8:  ERR_OTHER
     *
     * The 2nd byte, if present, is the CallInstance of the function that generated the error.
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     * This is for error code $20, function specific error information.  Allowed range $01 - $BF.
     *
     * The first byte is the enumeration of error codes as follows:
     * 0x01:  ERR_NOT_AVAILABLE
     * 0x02:  ERR_NOSERVICE
     * 0x03:  ERR_NO_CALL
     * 0x04:  ERR_NETWORK_DENY
     * 0x05:  ERR_NO_AUDIO_CHANNEL
     * 0xD8:  ERR_OTHER
     *
     * The 2nd byte, if present, is the CallInstance of the function that generated the error.
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    static const HandsFreeEnhancedCallControlErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

};

/**
 * The error message of 'HandsFreeEnhancedCallControl'
 */
class HandsFreeEnhancedCallControlError  : public ::asf::core::Payload {
public:

    enum HandsFreeEnhancedCallControlErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  HandsFreeEnhancedCallControlError ();

   /**
     * Copy constructor
     */
    inline  HandsFreeEnhancedCallControlError (const HandsFreeEnhancedCallControlError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~HandsFreeEnhancedCallControlError();

    /**
     * Assigns a new value to this object.
     */
    inline HandsFreeEnhancedCallControlError& operator = (const HandsFreeEnhancedCallControlError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const HandsFreeEnhancedCallControlError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const HandsFreeEnhancedCallControlError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const HandsFreeEnhancedCallControlError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const HandsFreeEnhancedCallControlError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline HandsFreeEnhancedCallControlError::HandsFreeEnhancedCallControlErrorField getField () const;

    inline void setField(HandsFreeEnhancedCallControlError::HandsFreeEnhancedCallControlErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "HandsFreeEnhancedCallControlErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "HandsFreeEnhancedCallControlErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const HandsFreeEnhancedCallControlErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline HandsFreeEnhancedCallControlErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline HandsFreeEnhancedCallControlErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (HandsFreeEnhancedCallControlErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "HandsFreeEnhancedCallControlErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const HandsFreeEnhancedCallControlErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const HandsFreeEnhancedCallControlError &getDefaultInstance();

private:

    inline void cloneData (const HandsFreeEnhancedCallControlError& rhs);

    inline void deleteData ();

    HandsFreeEnhancedCallControlErrorField __field;

    union {
        HandsFreeEnhancedCallControlErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "SystemWideRingtonesList"
 * Provides the system wide ringtone list with the currently selected ringtone.
 */
class SystemWideRingtonesListStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SystemWideRingtonesListStatus ();

    /**
     * Copy constructor
     */
    inline  SystemWideRingtonesListStatus (const SystemWideRingtonesListStatus &rhs);

    /**
     * All fields constructor
     */
    inline  SystemWideRingtonesListStatus (uint8 u8ActiveSystemRingtoneID_, const ::most_Tel_fi_types::T_TelSystemWideRingtonesListResult& oSystemWideRingtonesListResult_);

    /**
     * Destructor
     */
    inline virtual  ~SystemWideRingtonesListStatus();

    /**
     * Assignment operator
     */
    inline SystemWideRingtonesListStatus& operator = (const SystemWideRingtonesListStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SystemWideRingtonesListStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SystemWideRingtonesListStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SystemWideRingtonesListStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SystemWideRingtonesListStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8ActiveSystemRingtoneID"

    static const int kU8ActiveSystemRingtoneID = 0;

    /**
     * Clears the field "u8ActiveSystemRingtoneID".
     *
     * The field will be set to its default value. The hasU8ActiveSystemRingtoneID()
     * method will return false.
     */
    inline void clearU8ActiveSystemRingtoneID();

    /**
     * Checks whether the field "u8ActiveSystemRingtoneID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8ActiveSystemRingtoneID()). Otherwise it will return false.
     */
    inline bool hasU8ActiveSystemRingtoneID () const;

    /**
     * Returns the value of the member "u8ActiveSystemRingtoneID".
     *
     * Ringtone which is set as system wide.
     *
     * @return The value of the field "u8ActiveSystemRingtoneID"
     */
    inline uint8 getU8ActiveSystemRingtoneID () const;

    /**
     * Sets the value of the member "u8ActiveSystemRingtoneID".
     *
     * Ringtone which is set as system wide.
     *
     * @param u8ActiveSystemRingtoneID The value which will be set
     */
    inline void setU8ActiveSystemRingtoneID (uint8 u8ActiveSystemRingtoneID_);

    // API of field "oSystemWideRingtonesListResult"

    static const int kOSystemWideRingtonesListResult = 1;

    /**
     * Clears the field "oSystemWideRingtonesListResult".
     *
     * The field will be set to its default value. The hasOSystemWideRingtonesListResult()
     * method will return false.
     */
    inline void clearOSystemWideRingtonesListResult();

    /**
     * Checks whether the field "oSystemWideRingtonesListResult" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOSystemWideRingtonesListResult()). Otherwise it will return false.
     */
    inline bool hasOSystemWideRingtonesListResult () const;

    /**
     * Returns the value of the member "oSystemWideRingtonesListResult".
     *
     * List of available system wide ringtones.
     *
     * @return The value of the field "oSystemWideRingtonesListResult"
     */
    inline const ::most_Tel_fi_types::T_TelSystemWideRingtonesListResult& getOSystemWideRingtonesListResult () const;

    /**
     * Retrieves the value of the field "oSystemWideRingtonesListResult" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oSystemWideRingtonesListResult".
     */
    inline ::most_Tel_fi_types::T_TelSystemWideRingtonesListResult& getOSystemWideRingtonesListResultMutable ();

    /**
     * Sets the value of the member "oSystemWideRingtonesListResult".
     *
     * List of available system wide ringtones.
     *
     * @param oSystemWideRingtonesListResult The value which will be set
     */
    inline void setOSystemWideRingtonesListResult (const ::most_Tel_fi_types::T_TelSystemWideRingtonesListResult& oSystemWideRingtonesListResult_);

    static const SystemWideRingtonesListStatus &getDefaultInstance();

private:

    static const ::std::vector< ::most_Tel_fi_types::T_TelSystemWideRingtonesListResultItem >& getT_TelSystemWideRingtonesListResultItemList_DefaultInstance ();

    inline void set_has_u8ActiveSystemRingtoneID ();

    inline void clear_has_u8ActiveSystemRingtoneID ();

    inline void set_has_oSystemWideRingtonesListResult ();

    inline void clear_has_oSystemWideRingtonesListResult ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint8 _u8ActiveSystemRingtoneID;

    ::most_Tel_fi_types::T_TelSystemWideRingtonesListResult _oSystemWideRingtonesListResult;

};

/**
 * The status message of the property "DeviceRingtoneList"
 * Provides a list of each paired phones with its currently selected ringtone.
 */
class DeviceRingtoneListStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DeviceRingtoneListStatus ();

    /**
     * Copy constructor
     */
    inline  DeviceRingtoneListStatus (const DeviceRingtoneListStatus &rhs);

    /**
     * All fields constructor
     */
    inline  DeviceRingtoneListStatus (const ::most_Tel_fi_types::T_TelDeviceRingtoneListResult& oDeviceRingtoneListResult_);

    /**
     * Destructor
     */
    inline virtual  ~DeviceRingtoneListStatus();

    /**
     * Assignment operator
     */
    inline DeviceRingtoneListStatus& operator = (const DeviceRingtoneListStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DeviceRingtoneListStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DeviceRingtoneListStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DeviceRingtoneListStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DeviceRingtoneListStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "oDeviceRingtoneListResult"

    static const int kODeviceRingtoneListResult = 0;

    /**
     * Clears the field "oDeviceRingtoneListResult".
     *
     * The field will be set to its default value. The hasODeviceRingtoneListResult()
     * method will return false.
     */
    inline void clearODeviceRingtoneListResult();

    /**
     * Checks whether the field "oDeviceRingtoneListResult" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setODeviceRingtoneListResult()). Otherwise it will return false.
     */
    inline bool hasODeviceRingtoneListResult () const;

    /**
     * Returns the value of the member "oDeviceRingtoneListResult".
     *
     * List of devices and their respective ringtones.
     *
     * @return The value of the field "oDeviceRingtoneListResult"
     */
    inline const ::most_Tel_fi_types::T_TelDeviceRingtoneListResult& getODeviceRingtoneListResult () const;

    /**
     * Retrieves the value of the field "oDeviceRingtoneListResult" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oDeviceRingtoneListResult".
     */
    inline ::most_Tel_fi_types::T_TelDeviceRingtoneListResult& getODeviceRingtoneListResultMutable ();

    /**
     * Sets the value of the member "oDeviceRingtoneListResult".
     *
     * List of devices and their respective ringtones.
     *
     * @param oDeviceRingtoneListResult The value which will be set
     */
    inline void setODeviceRingtoneListResult (const ::most_Tel_fi_types::T_TelDeviceRingtoneListResult& oDeviceRingtoneListResult_);

    static const DeviceRingtoneListStatus &getDefaultInstance();

private:

    static const ::std::vector< ::most_Tel_fi_types::T_TelDeviceRingtoneListResultItem >& getT_TelDeviceRingtoneListResultItemList_DefaultInstance ();

    inline void set_has_oDeviceRingtoneListResult ();

    inline void clear_has_oDeviceRingtoneListResult ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::most_Tel_fi_types::T_TelDeviceRingtoneListResult _oDeviceRingtoneListResult;

};

/**
 * The status message of the property "SuppressRingtoneOnOffList"
 * Provides a list of each paired phones with its current suppress ringtone state.
 */
class SuppressRingtoneOnOffListStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SuppressRingtoneOnOffListStatus ();

    /**
     * Copy constructor
     */
    inline  SuppressRingtoneOnOffListStatus (const SuppressRingtoneOnOffListStatus &rhs);

    /**
     * All fields constructor
     */
    inline  SuppressRingtoneOnOffListStatus (const ::most_Tel_fi_types::T_TelSuppressRingtoneOnOffListResult& oSuppressRingtoneOnOffListResult_);

    /**
     * Destructor
     */
    inline virtual  ~SuppressRingtoneOnOffListStatus();

    /**
     * Assignment operator
     */
    inline SuppressRingtoneOnOffListStatus& operator = (const SuppressRingtoneOnOffListStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SuppressRingtoneOnOffListStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SuppressRingtoneOnOffListStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SuppressRingtoneOnOffListStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SuppressRingtoneOnOffListStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "oSuppressRingtoneOnOffListResult"

    static const int kOSuppressRingtoneOnOffListResult = 0;

    /**
     * Clears the field "oSuppressRingtoneOnOffListResult".
     *
     * The field will be set to its default value. The hasOSuppressRingtoneOnOffListResult()
     * method will return false.
     */
    inline void clearOSuppressRingtoneOnOffListResult();

    /**
     * Checks whether the field "oSuppressRingtoneOnOffListResult" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOSuppressRingtoneOnOffListResult()). Otherwise it will return false.
     */
    inline bool hasOSuppressRingtoneOnOffListResult () const;

    /**
     * Returns the value of the member "oSuppressRingtoneOnOffListResult".
     *
     * List of devices and their suppress ringtone state.
     *
     * @return The value of the field "oSuppressRingtoneOnOffListResult"
     */
    inline const ::most_Tel_fi_types::T_TelSuppressRingtoneOnOffListResult& getOSuppressRingtoneOnOffListResult () const;

    /**
     * Retrieves the value of the field "oSuppressRingtoneOnOffListResult" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oSuppressRingtoneOnOffListResult".
     */
    inline ::most_Tel_fi_types::T_TelSuppressRingtoneOnOffListResult& getOSuppressRingtoneOnOffListResultMutable ();

    /**
     * Sets the value of the member "oSuppressRingtoneOnOffListResult".
     *
     * List of devices and their suppress ringtone state.
     *
     * @param oSuppressRingtoneOnOffListResult The value which will be set
     */
    inline void setOSuppressRingtoneOnOffListResult (const ::most_Tel_fi_types::T_TelSuppressRingtoneOnOffListResult& oSuppressRingtoneOnOffListResult_);

    static const SuppressRingtoneOnOffListStatus &getDefaultInstance();

private:

    static const ::std::vector< ::most_Tel_fi_types::T_TelSuppressRingtoneOnOffListResultItem >& getT_TelSuppressRingtoneOnOffListResultItemList_DefaultInstance ();

    inline void set_has_oSuppressRingtoneOnOffListResult ();

    inline void clear_has_oSuppressRingtoneOnOffListResult ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::most_Tel_fi_types::T_TelSuppressRingtoneOnOffListResult _oSuppressRingtoneOnOffListResult;

};

/**
 * The status message of the property "AutoWaitingModeOnOffList"
 * Provides a list of each paired phones with its current auto waiting mode state.
 */
class AutoWaitingModeOnOffListStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AutoWaitingModeOnOffListStatus ();

    /**
     * Copy constructor
     */
    inline  AutoWaitingModeOnOffListStatus (const AutoWaitingModeOnOffListStatus &rhs);

    /**
     * All fields constructor
     */
    inline  AutoWaitingModeOnOffListStatus (const ::most_Tel_fi_types::T_TelAutoWaitingModeOnOffListResult& oAutoWaitingModeOnOffListResult_);

    /**
     * Destructor
     */
    inline virtual  ~AutoWaitingModeOnOffListStatus();

    /**
     * Assignment operator
     */
    inline AutoWaitingModeOnOffListStatus& operator = (const AutoWaitingModeOnOffListStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AutoWaitingModeOnOffListStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AutoWaitingModeOnOffListStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AutoWaitingModeOnOffListStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AutoWaitingModeOnOffListStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "oAutoWaitingModeOnOffListResult"

    static const int kOAutoWaitingModeOnOffListResult = 0;

    /**
     * Clears the field "oAutoWaitingModeOnOffListResult".
     *
     * The field will be set to its default value. The hasOAutoWaitingModeOnOffListResult()
     * method will return false.
     */
    inline void clearOAutoWaitingModeOnOffListResult();

    /**
     * Checks whether the field "oAutoWaitingModeOnOffListResult" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOAutoWaitingModeOnOffListResult()). Otherwise it will return false.
     */
    inline bool hasOAutoWaitingModeOnOffListResult () const;

    /**
     * Returns the value of the member "oAutoWaitingModeOnOffListResult".
     *
     * List of devices and their respective auto waiting mode state.
     *
     * @return The value of the field "oAutoWaitingModeOnOffListResult"
     */
    inline const ::most_Tel_fi_types::T_TelAutoWaitingModeOnOffListResult& getOAutoWaitingModeOnOffListResult () const;

    /**
     * Retrieves the value of the field "oAutoWaitingModeOnOffListResult" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oAutoWaitingModeOnOffListResult".
     */
    inline ::most_Tel_fi_types::T_TelAutoWaitingModeOnOffListResult& getOAutoWaitingModeOnOffListResultMutable ();

    /**
     * Sets the value of the member "oAutoWaitingModeOnOffListResult".
     *
     * List of devices and their respective auto waiting mode state.
     *
     * @param oAutoWaitingModeOnOffListResult The value which will be set
     */
    inline void setOAutoWaitingModeOnOffListResult (const ::most_Tel_fi_types::T_TelAutoWaitingModeOnOffListResult& oAutoWaitingModeOnOffListResult_);

    static const AutoWaitingModeOnOffListStatus &getDefaultInstance();

private:

    static const ::std::vector< ::most_Tel_fi_types::T_TelAutoWaitingModeOnOffListResultItem >& getT_TelAutoWaitingModeOnOffListResultItemList_DefaultInstance ();

    inline void set_has_oAutoWaitingModeOnOffListResult ();

    inline void clear_has_oAutoWaitingModeOnOffListResult ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::most_Tel_fi_types::T_TelAutoWaitingModeOnOffListResult _oAutoWaitingModeOnOffListResult;

};

/**
 * The status message of the property "RingtonePlaybackStatus"
 * Provides the vehicle ringtone playback state. This property is applicable only for the Play and Stop ringtone
 * requests from clients and not applicable for playing vehicle ringtone for an incoming call.
 */
class RingtonePlaybackStatusStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RingtonePlaybackStatusStatus ();

    /**
     * Copy constructor
     */
    inline  RingtonePlaybackStatusStatus (const RingtonePlaybackStatusStatus &rhs);

    /**
     * All fields constructor
     */
    inline  RingtonePlaybackStatusStatus (::most_Tel_fi_types_Extended::T_e8_TelPlaybackState e8PlaybackState_);

    /**
     * Destructor
     */
    inline virtual  ~RingtonePlaybackStatusStatus();

    /**
     * Assignment operator
     */
    inline RingtonePlaybackStatusStatus& operator = (const RingtonePlaybackStatusStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RingtonePlaybackStatusStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RingtonePlaybackStatusStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RingtonePlaybackStatusStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RingtonePlaybackStatusStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8PlaybackState"

    static const int kE8PlaybackState = 0;

    /**
     * Clears the field "e8PlaybackState".
     *
     * The field will be set to its default value. The hasE8PlaybackState()
     * method will return false.
     */
    inline void clearE8PlaybackState();

    /**
     * Checks whether the field "e8PlaybackState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8PlaybackState()). Otherwise it will return false.
     */
    inline bool hasE8PlaybackState () const;

    /**
     * Returns the value of the member "e8PlaybackState".
     *
     * Defines the ringtone playback status.
     *
     * @return The value of the field "e8PlaybackState"
     */
    inline ::most_Tel_fi_types_Extended::T_e8_TelPlaybackState getE8PlaybackState () const;

    /**
     * Sets the value of the member "e8PlaybackState".
     *
     * Defines the ringtone playback status.
     *
     * @param e8PlaybackState The value which will be set
     */
    inline void setE8PlaybackState (::most_Tel_fi_types_Extended::T_e8_TelPlaybackState e8PlaybackState_);

    static const RingtonePlaybackStatusStatus &getDefaultInstance();

private:

    inline void set_has_e8PlaybackState ();

    inline void clear_has_e8PlaybackState ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::most_Tel_fi_types_Extended::T_e8_TelPlaybackState _e8PlaybackState;

};

/**
 * The start message of the method "Allocate"
 * The Allocate method causes the source to occupy bandwidth for streaming data.
 */
class AllocateStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AllocateStart ();

    /**
     * Copy constructor
     */
    inline  AllocateStart (const AllocateStart &rhs);

    /**
     * All fields constructor
     */
    inline  AllocateStart (uint8 u8SourceNr_);

    /**
     * Destructor
     */
    inline virtual  ~AllocateStart();

    /**
     * Assignment operator
     */
    inline AllocateStart& operator = (const AllocateStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AllocateStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AllocateStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AllocateStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AllocateStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8SourceNr"

    static const int kU8SourceNr = 0;

    /**
     * Clears the field "u8SourceNr".
     *
     * The field will be set to its default value. The hasU8SourceNr()
     * method will return false.
     */
    inline void clearU8SourceNr();

    /**
     * Checks whether the field "u8SourceNr" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8SourceNr()). Otherwise it will return false.
     */
    inline bool hasU8SourceNr () const;

    /**
     * Returns the value of the member "u8SourceNr".
     *
     * Number of a data source (within one FBlock there can be more than one), for example, 0x01 for the first source.
     *
     * @return The value of the field "u8SourceNr"
     */
    inline uint8 getU8SourceNr () const;

    /**
     * Sets the value of the member "u8SourceNr".
     *
     * Number of a data source (within one FBlock there can be more than one), for example, 0x01 for the first source.
     *
     * @param u8SourceNr The value which will be set
     */
    inline void setU8SourceNr (uint8 u8SourceNr_);

    static const AllocateStart &getDefaultInstance();

private:

    inline void set_has_u8SourceNr ();

    inline void clear_has_u8SourceNr ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _u8SourceNr;

};

/**
 * The result message of the method "Allocate"
 * The Allocate method causes the source to occupy bandwidth for streaming data.
 */
class AllocateResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AllocateResult ();

    /**
     * Copy constructor
     */
    inline  AllocateResult (const AllocateResult &rhs);

    /**
     * All fields constructor
     */
    inline  AllocateResult (uint8 u8SourceNr_, uint16 u16BlockWidth_, uint16 u16ConnectionLabel_);

    /**
     * Destructor
     */
    inline virtual  ~AllocateResult();

    /**
     * Assignment operator
     */
    inline AllocateResult& operator = (const AllocateResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AllocateResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AllocateResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AllocateResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AllocateResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8SourceNr"

    static const int kU8SourceNr = 0;

    /**
     * Clears the field "u8SourceNr".
     *
     * The field will be set to its default value. The hasU8SourceNr()
     * method will return false.
     */
    inline void clearU8SourceNr();

    /**
     * Checks whether the field "u8SourceNr" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8SourceNr()). Otherwise it will return false.
     */
    inline bool hasU8SourceNr () const;

    /**
     * Returns the value of the member "u8SourceNr".
     *
     * Number of a data source (within one FBlock there can be more than one), for example, 0x01 for the first source.
     *
     * @return The value of the field "u8SourceNr"
     */
    inline uint8 getU8SourceNr () const;

    /**
     * Sets the value of the member "u8SourceNr".
     *
     * Number of a data source (within one FBlock there can be more than one), for example, 0x01 for the first source.
     *
     * @param u8SourceNr The value which will be set
     */
    inline void setU8SourceNr (uint8 u8SourceNr_);

    // API of field "u16BlockWidth"

    static const int kU16BlockWidth = 1;

    /**
     * Clears the field "u16BlockWidth".
     *
     * The field will be set to its default value. The hasU16BlockWidth()
     * method will return false.
     */
    inline void clearU16BlockWidth();

    /**
     * Checks whether the field "u16BlockWidth" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16BlockWidth()). Otherwise it will return false.
     */
    inline bool hasU16BlockWidth () const;

    /**
     * Returns the value of the member "u16BlockWidth".
     *
     * Number of transferred bytes per MOST frame.  If no bandwidth was allocated yet, 0x0000 must be used.  Otherwise, 0x0001 - 0x0075 is used as specified by MOST50.
     *
     * @return The value of the field "u16BlockWidth"
     */
    inline uint16 getU16BlockWidth () const;

    /**
     * Sets the value of the member "u16BlockWidth".
     *
     * Number of transferred bytes per MOST frame.  If no bandwidth was allocated yet, 0x0000 must be used.  Otherwise, 0x0001 - 0x0075 is used as specified by MOST50.
     *
     * @param u16BlockWidth The value which will be set
     */
    inline void setU16BlockWidth (uint16 u16BlockWidth_);

    // API of field "u16ConnectionLabel"

    static const int kU16ConnectionLabel = 2;

    /**
     * Clears the field "u16ConnectionLabel".
     *
     * The field will be set to its default value. The hasU16ConnectionLabel()
     * method will return false.
     */
    inline void clearU16ConnectionLabel();

    /**
     * Checks whether the field "u16ConnectionLabel" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16ConnectionLabel()). Otherwise it will return false.
     */
    inline bool hasU16ConnectionLabel () const;

    /**
     * Returns the value of the member "u16ConnectionLabel".
     *
     * Connection identifier. If no bandwidth is allocated, 0x0000 must be used.  Otherwise, 0x000B - 0x007F is used as specified by MOST50.
     *
     * @return The value of the field "u16ConnectionLabel"
     */
    inline uint16 getU16ConnectionLabel () const;

    /**
     * Sets the value of the member "u16ConnectionLabel".
     *
     * Connection identifier. If no bandwidth is allocated, 0x0000 must be used.  Otherwise, 0x000B - 0x007F is used as specified by MOST50.
     *
     * @param u16ConnectionLabel The value which will be set
     */
    inline void setU16ConnectionLabel (uint16 u16ConnectionLabel_);

    static const AllocateResult &getDefaultInstance();

private:

    inline void set_has_u8SourceNr ();

    inline void clear_has_u8SourceNr ();

    inline void set_has_u16BlockWidth ();

    inline void clear_has_u16BlockWidth ();

    inline void set_has_u16ConnectionLabel ();

    inline void clear_has_u16ConnectionLabel ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint8 _u8SourceNr;

    uint16 _u16BlockWidth;

    uint16 _u16ConnectionLabel;

};

/**
 * The error message of 'Allocate'
 */
class AllocateErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  AllocateErrorStructure ();

    /**
     * Copy constructor
     */
    inline  AllocateErrorStructure (const AllocateErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  AllocateErrorStructure (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline  ~AllocateErrorStructure();

    /**
     * Assignment operator
     */
    inline AllocateErrorStructure& operator = (const AllocateErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AllocateErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AllocateErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AllocateErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AllocateErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     * (Refer to the MOST Specification, section "Structure of MOST Messages: OPType")
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     * (Refer to the MOST Specification, section "Structure of MOST Messages: OPType")
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 1;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     * (Refer to the MOST Specification, section "Structure of MOST Messages: OPType")
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     * (Refer to the MOST Specification, section "Structure of MOST Messages: OPType")
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    static const AllocateErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

};

/**
 * The error message of 'Allocate'
 */
class AllocateError  : public ::asf::core::Payload {
public:

    enum AllocateErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  AllocateError ();

   /**
     * Copy constructor
     */
    inline  AllocateError (const AllocateError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~AllocateError();

    /**
     * Assigns a new value to this object.
     */
    inline AllocateError& operator = (const AllocateError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AllocateError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AllocateError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AllocateError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AllocateError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline AllocateError::AllocateErrorField getField () const;

    inline void setField(AllocateError::AllocateErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "AllocateErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "AllocateErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const AllocateErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline AllocateErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline AllocateErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (AllocateErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "AllocateErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const AllocateErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const AllocateError &getDefaultInstance();

private:

    inline void cloneData (const AllocateError& rhs);

    inline void deleteData ();

    AllocateErrorField __field;

    union {
        AllocateErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "DeAllocate"
 * The method DeAllocate causes the source to free occupied Streaming bandwidth.
 */
class DeAllocateStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DeAllocateStart ();

    /**
     * Copy constructor
     */
    inline  DeAllocateStart (const DeAllocateStart &rhs);

    /**
     * All fields constructor
     */
    inline  DeAllocateStart (uint8 u8SourceNr_);

    /**
     * Destructor
     */
    inline virtual  ~DeAllocateStart();

    /**
     * Assignment operator
     */
    inline DeAllocateStart& operator = (const DeAllocateStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DeAllocateStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DeAllocateStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DeAllocateStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DeAllocateStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8SourceNr"

    static const int kU8SourceNr = 0;

    /**
     * Clears the field "u8SourceNr".
     *
     * The field will be set to its default value. The hasU8SourceNr()
     * method will return false.
     */
    inline void clearU8SourceNr();

    /**
     * Checks whether the field "u8SourceNr" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8SourceNr()). Otherwise it will return false.
     */
    inline bool hasU8SourceNr () const;

    /**
     * Returns the value of the member "u8SourceNr".
     *
     * Number of a data source (within one FBlock there can be more than one), for example, 0x01 for the first source.
     *
     * @return The value of the field "u8SourceNr"
     */
    inline uint8 getU8SourceNr () const;

    /**
     * Sets the value of the member "u8SourceNr".
     *
     * Number of a data source (within one FBlock there can be more than one), for example, 0x01 for the first source.
     *
     * @param u8SourceNr The value which will be set
     */
    inline void setU8SourceNr (uint8 u8SourceNr_);

    static const DeAllocateStart &getDefaultInstance();

private:

    inline void set_has_u8SourceNr ();

    inline void clear_has_u8SourceNr ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _u8SourceNr;

};

/**
 * The result message of the method "DeAllocate"
 * The method DeAllocate causes the source to free occupied Streaming bandwidth.
 */
class DeAllocateResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DeAllocateResult ();

    /**
     * Copy constructor
     */
    inline  DeAllocateResult (const DeAllocateResult &rhs);

    /**
     * All fields constructor
     */
    inline  DeAllocateResult (uint8 u8SourceNr_);

    /**
     * Destructor
     */
    inline virtual  ~DeAllocateResult();

    /**
     * Assignment operator
     */
    inline DeAllocateResult& operator = (const DeAllocateResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DeAllocateResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DeAllocateResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DeAllocateResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DeAllocateResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8SourceNr"

    static const int kU8SourceNr = 0;

    /**
     * Clears the field "u8SourceNr".
     *
     * The field will be set to its default value. The hasU8SourceNr()
     * method will return false.
     */
    inline void clearU8SourceNr();

    /**
     * Checks whether the field "u8SourceNr" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8SourceNr()). Otherwise it will return false.
     */
    inline bool hasU8SourceNr () const;

    /**
     * Returns the value of the member "u8SourceNr".
     *
     * Number of a data source (within one FBlock there can be more than one), for example, 0x01 for the first source.
     *
     * @return The value of the field "u8SourceNr"
     */
    inline uint8 getU8SourceNr () const;

    /**
     * Sets the value of the member "u8SourceNr".
     *
     * Number of a data source (within one FBlock there can be more than one), for example, 0x01 for the first source.
     *
     * @param u8SourceNr The value which will be set
     */
    inline void setU8SourceNr (uint8 u8SourceNr_);

    static const DeAllocateResult &getDefaultInstance();

private:

    inline void set_has_u8SourceNr ();

    inline void clear_has_u8SourceNr ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _u8SourceNr;

};

/**
 * The error message of 'DeAllocate'
 */
class DeAllocateErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  DeAllocateErrorStructure ();

    /**
     * Copy constructor
     */
    inline  DeAllocateErrorStructure (const DeAllocateErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  DeAllocateErrorStructure (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline  ~DeAllocateErrorStructure();

    /**
     * Assignment operator
     */
    inline DeAllocateErrorStructure& operator = (const DeAllocateErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DeAllocateErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DeAllocateErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DeAllocateErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DeAllocateErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     * (Refer to the MOST Specification, section "Structure of MOST Messages: OPType")
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     * (Refer to the MOST Specification, section "Structure of MOST Messages: OPType")
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 1;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     * (Refer to the MOST Specification, section "Structure of MOST Messages: OPType")
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     * (Refer to the MOST Specification, section "Structure of MOST Messages: OPType")
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    static const DeAllocateErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

};

/**
 * The error message of 'DeAllocate'
 */
class DeAllocateError  : public ::asf::core::Payload {
public:

    enum DeAllocateErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  DeAllocateError ();

   /**
     * Copy constructor
     */
    inline  DeAllocateError (const DeAllocateError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~DeAllocateError();

    /**
     * Assigns a new value to this object.
     */
    inline DeAllocateError& operator = (const DeAllocateError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DeAllocateError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DeAllocateError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DeAllocateError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DeAllocateError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline DeAllocateError::DeAllocateErrorField getField () const;

    inline void setField(DeAllocateError::DeAllocateErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "DeAllocateErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "DeAllocateErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const DeAllocateErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline DeAllocateErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline DeAllocateErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (DeAllocateErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "DeAllocateErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const DeAllocateErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const DeAllocateError &getDefaultInstance();

private:

    inline void cloneData (const DeAllocateError& rhs);

    inline void deleteData ();

    DeAllocateErrorField __field;

    union {
        DeAllocateErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "SourceActivity"
 * This method controls the activity of a source.
 *
 * Note that the PAUSE state is not allowed for the General Motors implementation and is thus not defined as an allowed state within the enumeration.
 */
class SourceActivityStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SourceActivityStart ();

    /**
     * Copy constructor
     */
    inline  SourceActivityStart (const SourceActivityStart &rhs);

    /**
     * All fields constructor
     */
    inline  SourceActivityStart (uint8 u8SourceNr_, ::most_Src_fi_types::T_e8_SrcActivity e8Activity_);

    /**
     * Destructor
     */
    inline virtual  ~SourceActivityStart();

    /**
     * Assignment operator
     */
    inline SourceActivityStart& operator = (const SourceActivityStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SourceActivityStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SourceActivityStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SourceActivityStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SourceActivityStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8SourceNr"

    static const int kU8SourceNr = 0;

    /**
     * Clears the field "u8SourceNr".
     *
     * The field will be set to its default value. The hasU8SourceNr()
     * method will return false.
     */
    inline void clearU8SourceNr();

    /**
     * Checks whether the field "u8SourceNr" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8SourceNr()). Otherwise it will return false.
     */
    inline bool hasU8SourceNr () const;

    /**
     * Returns the value of the member "u8SourceNr".
     *
     * Number of a data source (within one FBlock there can be more than one), for example, 0x01 for the first source.
     *
     * @return The value of the field "u8SourceNr"
     */
    inline uint8 getU8SourceNr () const;

    /**
     * Sets the value of the member "u8SourceNr".
     *
     * Number of a data source (within one FBlock there can be more than one), for example, 0x01 for the first source.
     *
     * @param u8SourceNr The value which will be set
     */
    inline void setU8SourceNr (uint8 u8SourceNr_);

    // API of field "e8Activity"

    static const int kE8Activity = 1;

    /**
     * Clears the field "e8Activity".
     *
     * The field will be set to its default value. The hasE8Activity()
     * method will return false.
     */
    inline void clearE8Activity();

    /**
     * Checks whether the field "e8Activity" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8Activity()). Otherwise it will return false.
     */
    inline bool hasE8Activity () const;

    /**
     * Returns the value of the member "e8Activity".
     *
     * Through parameter Activity, streaming data transfer can be started or stopped. Note that the paused state is not allowed in the General Motors MOST implementation.
     *
     * @return The value of the field "e8Activity"
     */
    inline ::most_Src_fi_types::T_e8_SrcActivity getE8Activity () const;

    /**
     * Sets the value of the member "e8Activity".
     *
     * Through parameter Activity, streaming data transfer can be started or stopped. Note that the paused state is not allowed in the General Motors MOST implementation.
     *
     * @param e8Activity The value which will be set
     */
    inline void setE8Activity (::most_Src_fi_types::T_e8_SrcActivity e8Activity_);

    static const SourceActivityStart &getDefaultInstance();

private:

    inline void set_has_u8SourceNr ();

    inline void clear_has_u8SourceNr ();

    inline void set_has_e8Activity ();

    inline void clear_has_e8Activity ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint8 _u8SourceNr;

    ::most_Src_fi_types::T_e8_SrcActivity _e8Activity;

};

/**
 * The result message of the method "SourceActivity"
 * This method controls the activity of a source.
 *
 * Note that the PAUSE state is not allowed for the General Motors implementation and is thus not defined as an allowed state within the enumeration.
 */
class SourceActivityResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SourceActivityResult ();

    /**
     * Copy constructor
     */
    inline  SourceActivityResult (const SourceActivityResult &rhs);

    /**
     * All fields constructor
     */
    inline  SourceActivityResult (uint8 u8SourceNr_, ::most_Src_fi_types::T_e8_SrcActivity e8Activity_);

    /**
     * Destructor
     */
    inline virtual  ~SourceActivityResult();

    /**
     * Assignment operator
     */
    inline SourceActivityResult& operator = (const SourceActivityResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SourceActivityResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SourceActivityResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SourceActivityResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SourceActivityResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8SourceNr"

    static const int kU8SourceNr = 0;

    /**
     * Clears the field "u8SourceNr".
     *
     * The field will be set to its default value. The hasU8SourceNr()
     * method will return false.
     */
    inline void clearU8SourceNr();

    /**
     * Checks whether the field "u8SourceNr" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8SourceNr()). Otherwise it will return false.
     */
    inline bool hasU8SourceNr () const;

    /**
     * Returns the value of the member "u8SourceNr".
     *
     * Number of a data source (within one FBlock there can be more than one), for example, 0x01 for the first source.
     *
     * @return The value of the field "u8SourceNr"
     */
    inline uint8 getU8SourceNr () const;

    /**
     * Sets the value of the member "u8SourceNr".
     *
     * Number of a data source (within one FBlock there can be more than one), for example, 0x01 for the first source.
     *
     * @param u8SourceNr The value which will be set
     */
    inline void setU8SourceNr (uint8 u8SourceNr_);

    // API of field "e8Activity"

    static const int kE8Activity = 1;

    /**
     * Clears the field "e8Activity".
     *
     * The field will be set to its default value. The hasE8Activity()
     * method will return false.
     */
    inline void clearE8Activity();

    /**
     * Checks whether the field "e8Activity" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8Activity()). Otherwise it will return false.
     */
    inline bool hasE8Activity () const;

    /**
     * Returns the value of the member "e8Activity".
     *
     * Through parameter Activity, streaming data transfer can be started or stopped. Note that the paused state is not allowed in the General Motors MOST implementation.
     *
     * @return The value of the field "e8Activity"
     */
    inline ::most_Src_fi_types::T_e8_SrcActivity getE8Activity () const;

    /**
     * Sets the value of the member "e8Activity".
     *
     * Through parameter Activity, streaming data transfer can be started or stopped. Note that the paused state is not allowed in the General Motors MOST implementation.
     *
     * @param e8Activity The value which will be set
     */
    inline void setE8Activity (::most_Src_fi_types::T_e8_SrcActivity e8Activity_);

    static const SourceActivityResult &getDefaultInstance();

private:

    inline void set_has_u8SourceNr ();

    inline void clear_has_u8SourceNr ();

    inline void set_has_e8Activity ();

    inline void clear_has_e8Activity ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint8 _u8SourceNr;

    ::most_Src_fi_types::T_e8_SrcActivity _e8Activity;

};

/**
 * The error message of 'SourceActivity'
 */
class SourceActivityErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  SourceActivityErrorStructure ();

    /**
     * Copy constructor
     */
    inline  SourceActivityErrorStructure (const SourceActivityErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  SourceActivityErrorStructure (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline  ~SourceActivityErrorStructure();

    /**
     * Assignment operator
     */
    inline SourceActivityErrorStructure& operator = (const SourceActivityErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SourceActivityErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SourceActivityErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SourceActivityErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SourceActivityErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     * (Refer to the MOST Specification, section "Structure of MOST Messages: OPType")
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     * (Refer to the MOST Specification, section "Structure of MOST Messages: OPType")
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 1;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     * (Refer to the MOST Specification, section "Structure of MOST Messages: OPType")
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     * (Refer to the MOST Specification, section "Structure of MOST Messages: OPType")
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    static const SourceActivityErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

};

/**
 * The error message of 'SourceActivity'
 */
class SourceActivityError  : public ::asf::core::Payload {
public:

    enum SourceActivityErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  SourceActivityError ();

   /**
     * Copy constructor
     */
    inline  SourceActivityError (const SourceActivityError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~SourceActivityError();

    /**
     * Assigns a new value to this object.
     */
    inline SourceActivityError& operator = (const SourceActivityError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SourceActivityError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SourceActivityError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SourceActivityError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SourceActivityError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline SourceActivityError::SourceActivityErrorField getField () const;

    inline void setField(SourceActivityError::SourceActivityErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "SourceActivityErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "SourceActivityErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const SourceActivityErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline SourceActivityErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline SourceActivityErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (SourceActivityErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "SourceActivityErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const SourceActivityErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const SourceActivityError &getDefaultInstance();

private:

    inline void cloneData (const SourceActivityError& rhs);

    inline void deleteData ();

    SourceActivityErrorField __field;

    union {
        SourceActivityErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "AcceptCall"
 * Accepts an Incoming call - for single or multiple call.  Does not Block.
 */
class AcceptCallStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AcceptCallStart ();

    /**
     * Copy constructor
     */
    inline  AcceptCallStart (const AcceptCallStart &rhs);

    /**
     * All fields constructor
     */
    inline  AcceptCallStart (uint16 u16CallInstance_);

    /**
     * Destructor
     */
    inline virtual  ~AcceptCallStart();

    /**
     * Assignment operator
     */
    inline AcceptCallStart& operator = (const AcceptCallStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AcceptCallStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AcceptCallStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AcceptCallStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AcceptCallStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u16CallInstance"

    static const int kU16CallInstance = 0;

    /**
     * Clears the field "u16CallInstance".
     *
     * The field will be set to its default value. The hasU16CallInstance()
     * method will return false.
     */
    inline void clearU16CallInstance();

    /**
     * Checks whether the field "u16CallInstance" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16CallInstance()). Otherwise it will return false.
     */
    inline bool hasU16CallInstance () const;

    /**
     * Returns the value of the member "u16CallInstance".
     *
     * Instance of one call from multiple call possible.
     *
     * Call Instance FF means all call.  Like HangUp all calls.
     *
     * @return The value of the field "u16CallInstance"
     */
    inline uint16 getU16CallInstance () const;

    /**
     * Sets the value of the member "u16CallInstance".
     *
     * Instance of one call from multiple call possible.
     *
     * Call Instance FF means all call.  Like HangUp all calls.
     *
     * @param u16CallInstance The value which will be set
     */
    inline void setU16CallInstance (uint16 u16CallInstance_);

    static const AcceptCallStart &getDefaultInstance();

private:

    inline void set_has_u16CallInstance ();

    inline void clear_has_u16CallInstance ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _u16CallInstance;

};

/**
 * The result message of the method "AcceptCall"
 * Accepts an Incoming call - for single or multiple call.  Does not Block.
 */
class AcceptCallResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AcceptCallResult ();

    /**
     * Copy constructor
     */
    inline  AcceptCallResult (const AcceptCallResult &rhs);

    /**
     * All fields constructor
     */
    inline  AcceptCallResult (uint16 u16CallInstance_, ::most_Tel_fi_types::T_e8_TelCallStatus e8CallStatus_, bool bUsingVehicleAudio_);

    /**
     * Destructor
     */
    inline virtual  ~AcceptCallResult();

    /**
     * Assignment operator
     */
    inline AcceptCallResult& operator = (const AcceptCallResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AcceptCallResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AcceptCallResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AcceptCallResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AcceptCallResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u16CallInstance"

    static const int kU16CallInstance = 0;

    /**
     * Clears the field "u16CallInstance".
     *
     * The field will be set to its default value. The hasU16CallInstance()
     * method will return false.
     */
    inline void clearU16CallInstance();

    /**
     * Checks whether the field "u16CallInstance" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16CallInstance()). Otherwise it will return false.
     */
    inline bool hasU16CallInstance () const;

    /**
     * Returns the value of the member "u16CallInstance".
     *
     * Instance of one call from multiple call possible.
     *
     * Call Instance FF means all call.  Like HangUp all calls.
     *
     * @return The value of the field "u16CallInstance"
     */
    inline uint16 getU16CallInstance () const;

    /**
     * Sets the value of the member "u16CallInstance".
     *
     * Instance of one call from multiple call possible.
     *
     * Call Instance FF means all call.  Like HangUp all calls.
     *
     * @param u16CallInstance The value which will be set
     */
    inline void setU16CallInstance (uint16 u16CallInstance_);

    // API of field "e8CallStatus"

    static const int kE8CallStatus = 1;

    /**
     * Clears the field "e8CallStatus".
     *
     * The field will be set to its default value. The hasE8CallStatus()
     * method will return false.
     */
    inline void clearE8CallStatus();

    /**
     * Checks whether the field "e8CallStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8CallStatus()). Otherwise it will return false.
     */
    inline bool hasE8CallStatus () const;

    /**
     * Returns the value of the member "e8CallStatus".
     *
     * Status of a call
     *
     * @return The value of the field "e8CallStatus"
     */
    inline ::most_Tel_fi_types::T_e8_TelCallStatus getE8CallStatus () const;

    /**
     * Sets the value of the member "e8CallStatus".
     *
     * Status of a call
     *
     * @param e8CallStatus The value which will be set
     */
    inline void setE8CallStatus (::most_Tel_fi_types::T_e8_TelCallStatus e8CallStatus_);

    // API of field "bUsingVehicleAudio"

    static const int kBUsingVehicleAudio = 2;

    /**
     * Clears the field "bUsingVehicleAudio".
     *
     * The field will be set to its default value. The hasBUsingVehicleAudio()
     * method will return false.
     */
    inline void clearBUsingVehicleAudio();

    /**
     * Checks whether the field "bUsingVehicleAudio" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBUsingVehicleAudio()). Otherwise it will return false.
     */
    inline bool hasBUsingVehicleAudio () const;

    /**
     * Returns the value of the member "bUsingVehicleAudio".
     *
     * Is the call in handset or in vehicle
     *
     * @return The value of the field "bUsingVehicleAudio"
     */
    inline bool getBUsingVehicleAudio () const;

    /**
     * Sets the value of the member "bUsingVehicleAudio".
     *
     * Is the call in handset or in vehicle
     *
     * @param bUsingVehicleAudio The value which will be set
     */
    inline void setBUsingVehicleAudio (bool bUsingVehicleAudio_);

    static const AcceptCallResult &getDefaultInstance();

private:

    inline void set_has_u16CallInstance ();

    inline void clear_has_u16CallInstance ();

    inline void set_has_e8CallStatus ();

    inline void clear_has_e8CallStatus ();

    inline void set_has_bUsingVehicleAudio ();

    inline void clear_has_bUsingVehicleAudio ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint16 _u16CallInstance;

    ::most_Tel_fi_types::T_e8_TelCallStatus _e8CallStatus;

    bool _bUsingVehicleAudio;

};

/**
 * The error message of 'AcceptCall'
 */
class AcceptCallErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  AcceptCallErrorStructure ();

    /**
     * Copy constructor
     */
    inline  AcceptCallErrorStructure (const AcceptCallErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  AcceptCallErrorStructure (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline  ~AcceptCallErrorStructure();

    /**
     * Assignment operator
     */
    inline AcceptCallErrorStructure& operator = (const AcceptCallErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AcceptCallErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AcceptCallErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AcceptCallErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AcceptCallErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     * Error codes outlined in MOST standard, e.g.:
     * $01 Syntax error: F Block does not exist,
     * $02 Syntax error: Instance does not exist,
     * $03 Syntax error: Function does not exist,
     * $04 Syntax error: Operations does not exist,etc.
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     * Error codes outlined in MOST standard, e.g.:
     * $01 Syntax error: F Block does not exist,
     * $02 Syntax error: Instance does not exist,
     * $03 Syntax error: Function does not exist,
     * $04 Syntax error: Operations does not exist,etc.
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 1;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     * This is for error code $20, function specific error information.  Allowed range $01 - $BF.
     *
     * The first byte is the enumeration of error codes as follows:
     * 0x01:  ERR_NOT_AVAILABLE
     * 0x02:  ERR_NOSERVICE
     * 0x03:  ERR_NO_CALL
     * 0x04:  ERR_NETWORK_DENY
     * 0x05:  ERR_NO_AUDIO_CHANNEL
     * 0xD8:  ERR_OTHER
     *
     * The 2nd byte, if present, is the CallInstance of the function that generated the error.
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     * This is for error code $20, function specific error information.  Allowed range $01 - $BF.
     *
     * The first byte is the enumeration of error codes as follows:
     * 0x01:  ERR_NOT_AVAILABLE
     * 0x02:  ERR_NOSERVICE
     * 0x03:  ERR_NO_CALL
     * 0x04:  ERR_NETWORK_DENY
     * 0x05:  ERR_NO_AUDIO_CHANNEL
     * 0xD8:  ERR_OTHER
     *
     * The 2nd byte, if present, is the CallInstance of the function that generated the error.
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    static const AcceptCallErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

};

/**
 * The error message of 'AcceptCall'
 */
class AcceptCallError  : public ::asf::core::Payload {
public:

    enum AcceptCallErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  AcceptCallError ();

   /**
     * Copy constructor
     */
    inline  AcceptCallError (const AcceptCallError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~AcceptCallError();

    /**
     * Assigns a new value to this object.
     */
    inline AcceptCallError& operator = (const AcceptCallError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AcceptCallError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AcceptCallError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AcceptCallError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AcceptCallError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline AcceptCallError::AcceptCallErrorField getField () const;

    inline void setField(AcceptCallError::AcceptCallErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "AcceptCallErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "AcceptCallErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const AcceptCallErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline AcceptCallErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline AcceptCallErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (AcceptCallErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "AcceptCallErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const AcceptCallErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const AcceptCallError &getDefaultInstance();

private:

    inline void cloneData (const AcceptCallError& rhs);

    inline void deleteData ();

    AcceptCallErrorField __field;

    union {
        AcceptCallErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "CancelOutgoingCall"
 * Used to cancel an outgoing call that is not connected.  Notifications are no longer sent once a call becomes IDLE..
 */
class CancelOutgoingCallStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CancelOutgoingCallStart ();

    /**
     * Copy constructor
     */
    inline  CancelOutgoingCallStart (const CancelOutgoingCallStart &rhs);

    /**
     * All fields constructor
     */
    inline  CancelOutgoingCallStart (uint16 u16CallInstance_);

    /**
     * Destructor
     */
    inline virtual  ~CancelOutgoingCallStart();

    /**
     * Assignment operator
     */
    inline CancelOutgoingCallStart& operator = (const CancelOutgoingCallStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CancelOutgoingCallStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CancelOutgoingCallStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CancelOutgoingCallStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CancelOutgoingCallStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u16CallInstance"

    static const int kU16CallInstance = 0;

    /**
     * Clears the field "u16CallInstance".
     *
     * The field will be set to its default value. The hasU16CallInstance()
     * method will return false.
     */
    inline void clearU16CallInstance();

    /**
     * Checks whether the field "u16CallInstance" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16CallInstance()). Otherwise it will return false.
     */
    inline bool hasU16CallInstance () const;

    /**
     * Returns the value of the member "u16CallInstance".
     *
     * Instance of one call from multiple call possible.
     *
     * Call Instance FF means all call.  Like HangUp all calls.
     *
     * @return The value of the field "u16CallInstance"
     */
    inline uint16 getU16CallInstance () const;

    /**
     * Sets the value of the member "u16CallInstance".
     *
     * Instance of one call from multiple call possible.
     *
     * Call Instance FF means all call.  Like HangUp all calls.
     *
     * @param u16CallInstance The value which will be set
     */
    inline void setU16CallInstance (uint16 u16CallInstance_);

    static const CancelOutgoingCallStart &getDefaultInstance();

private:

    inline void set_has_u16CallInstance ();

    inline void clear_has_u16CallInstance ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _u16CallInstance;

};

/**
 * The result message of the method "CancelOutgoingCall"
 * Used to cancel an outgoing call that is not connected.  Notifications are no longer sent once a call becomes IDLE..
 */
class CancelOutgoingCallResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CancelOutgoingCallResult ();

    /**
     * Copy constructor
     */
    inline  CancelOutgoingCallResult (const CancelOutgoingCallResult &rhs);

    /**
     * All fields constructor
     */
    inline  CancelOutgoingCallResult (uint16 u16CallInstance_, ::most_Tel_fi_types::T_e8_TelCallStatus e8CallStatus_, bool bUsingVehicleAudio_);

    /**
     * Destructor
     */
    inline virtual  ~CancelOutgoingCallResult();

    /**
     * Assignment operator
     */
    inline CancelOutgoingCallResult& operator = (const CancelOutgoingCallResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CancelOutgoingCallResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CancelOutgoingCallResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CancelOutgoingCallResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CancelOutgoingCallResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u16CallInstance"

    static const int kU16CallInstance = 0;

    /**
     * Clears the field "u16CallInstance".
     *
     * The field will be set to its default value. The hasU16CallInstance()
     * method will return false.
     */
    inline void clearU16CallInstance();

    /**
     * Checks whether the field "u16CallInstance" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16CallInstance()). Otherwise it will return false.
     */
    inline bool hasU16CallInstance () const;

    /**
     * Returns the value of the member "u16CallInstance".
     *
     * Instance of one call from multiple call possible.
     *
     * Call Instance FF means all call.  Like HangUp all calls.
     *
     * @return The value of the field "u16CallInstance"
     */
    inline uint16 getU16CallInstance () const;

    /**
     * Sets the value of the member "u16CallInstance".
     *
     * Instance of one call from multiple call possible.
     *
     * Call Instance FF means all call.  Like HangUp all calls.
     *
     * @param u16CallInstance The value which will be set
     */
    inline void setU16CallInstance (uint16 u16CallInstance_);

    // API of field "e8CallStatus"

    static const int kE8CallStatus = 1;

    /**
     * Clears the field "e8CallStatus".
     *
     * The field will be set to its default value. The hasE8CallStatus()
     * method will return false.
     */
    inline void clearE8CallStatus();

    /**
     * Checks whether the field "e8CallStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8CallStatus()). Otherwise it will return false.
     */
    inline bool hasE8CallStatus () const;

    /**
     * Returns the value of the member "e8CallStatus".
     *
     * Status of a call
     *
     * @return The value of the field "e8CallStatus"
     */
    inline ::most_Tel_fi_types::T_e8_TelCallStatus getE8CallStatus () const;

    /**
     * Sets the value of the member "e8CallStatus".
     *
     * Status of a call
     *
     * @param e8CallStatus The value which will be set
     */
    inline void setE8CallStatus (::most_Tel_fi_types::T_e8_TelCallStatus e8CallStatus_);

    // API of field "bUsingVehicleAudio"

    static const int kBUsingVehicleAudio = 2;

    /**
     * Clears the field "bUsingVehicleAudio".
     *
     * The field will be set to its default value. The hasBUsingVehicleAudio()
     * method will return false.
     */
    inline void clearBUsingVehicleAudio();

    /**
     * Checks whether the field "bUsingVehicleAudio" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBUsingVehicleAudio()). Otherwise it will return false.
     */
    inline bool hasBUsingVehicleAudio () const;

    /**
     * Returns the value of the member "bUsingVehicleAudio".
     *
     * Is the call in handset or in vehicle
     *
     * @return The value of the field "bUsingVehicleAudio"
     */
    inline bool getBUsingVehicleAudio () const;

    /**
     * Sets the value of the member "bUsingVehicleAudio".
     *
     * Is the call in handset or in vehicle
     *
     * @param bUsingVehicleAudio The value which will be set
     */
    inline void setBUsingVehicleAudio (bool bUsingVehicleAudio_);

    static const CancelOutgoingCallResult &getDefaultInstance();

private:

    inline void set_has_u16CallInstance ();

    inline void clear_has_u16CallInstance ();

    inline void set_has_e8CallStatus ();

    inline void clear_has_e8CallStatus ();

    inline void set_has_bUsingVehicleAudio ();

    inline void clear_has_bUsingVehicleAudio ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint16 _u16CallInstance;

    ::most_Tel_fi_types::T_e8_TelCallStatus _e8CallStatus;

    bool _bUsingVehicleAudio;

};

/**
 * The error message of 'CancelOutgoingCall'
 */
class CancelOutgoingCallErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  CancelOutgoingCallErrorStructure ();

    /**
     * Copy constructor
     */
    inline  CancelOutgoingCallErrorStructure (const CancelOutgoingCallErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  CancelOutgoingCallErrorStructure (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline  ~CancelOutgoingCallErrorStructure();

    /**
     * Assignment operator
     */
    inline CancelOutgoingCallErrorStructure& operator = (const CancelOutgoingCallErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CancelOutgoingCallErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CancelOutgoingCallErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CancelOutgoingCallErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CancelOutgoingCallErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     * Error codes outlined in MOST standard, e.g.:
     * $01 Syntax error: F Block does not exist,
     * $02 Syntax error: Instance does not exist,
     * $03 Syntax error: Function does not exist,
     * $04 Syntax error: Operations does not exist,etc.
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     * Error codes outlined in MOST standard, e.g.:
     * $01 Syntax error: F Block does not exist,
     * $02 Syntax error: Instance does not exist,
     * $03 Syntax error: Function does not exist,
     * $04 Syntax error: Operations does not exist,etc.
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 1;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     * This is for error code $20, function specific error information.  Allowed range $01 - $BF.
     *
     * The first byte is the enumeration of error codes as follows:
     * 0x01:  ERR_NOT_AVAILABLE
     * 0x02:  ERR_NOSERVICE
     * 0x03:  ERR_NO_CALL
     * 0x04:  ERR_NETWORK_DENY
     * 0x05:  ERR_NO_AUDIO_CHANNEL
     * 0xD8:  ERR_OTHER
     *
     * The 2nd byte, if present, is the CallInstance of the function that generated the error.
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     * This is for error code $20, function specific error information.  Allowed range $01 - $BF.
     *
     * The first byte is the enumeration of error codes as follows:
     * 0x01:  ERR_NOT_AVAILABLE
     * 0x02:  ERR_NOSERVICE
     * 0x03:  ERR_NO_CALL
     * 0x04:  ERR_NETWORK_DENY
     * 0x05:  ERR_NO_AUDIO_CHANNEL
     * 0xD8:  ERR_OTHER
     *
     * The 2nd byte, if present, is the CallInstance of the function that generated the error.
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    static const CancelOutgoingCallErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

};

/**
 * The error message of 'CancelOutgoingCall'
 */
class CancelOutgoingCallError  : public ::asf::core::Payload {
public:

    enum CancelOutgoingCallErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  CancelOutgoingCallError ();

   /**
     * Copy constructor
     */
    inline  CancelOutgoingCallError (const CancelOutgoingCallError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~CancelOutgoingCallError();

    /**
     * Assigns a new value to this object.
     */
    inline CancelOutgoingCallError& operator = (const CancelOutgoingCallError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CancelOutgoingCallError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CancelOutgoingCallError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CancelOutgoingCallError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CancelOutgoingCallError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline CancelOutgoingCallError::CancelOutgoingCallErrorField getField () const;

    inline void setField(CancelOutgoingCallError::CancelOutgoingCallErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "CancelOutgoingCallErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "CancelOutgoingCallErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const CancelOutgoingCallErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline CancelOutgoingCallErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline CancelOutgoingCallErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (CancelOutgoingCallErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "CancelOutgoingCallErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const CancelOutgoingCallErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const CancelOutgoingCallError &getDefaultInstance();

private:

    inline void cloneData (const CancelOutgoingCallError& rhs);

    inline void deleteData ();

    CancelOutgoingCallErrorField __field;

    union {
        CancelOutgoingCallErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "ConferenceIn"
 * Joins or conferences in all ACTIVE, ONHOLD, and WAITING calls.
 */
class ConferenceInStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ConferenceInStart ();

    /**
     * Copy constructor
     */
    inline  ConferenceInStart (const ConferenceInStart &rhs);

    /**
     * All fields constructor
     */
    inline  ConferenceInStart (const ::most_Tel_fi_types::T_TelStreamOfCallInstances& oStreamOfCallInstances_);

    /**
     * Destructor
     */
    inline virtual  ~ConferenceInStart();

    /**
     * Assignment operator
     */
    inline ConferenceInStart& operator = (const ConferenceInStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ConferenceInStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ConferenceInStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ConferenceInStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ConferenceInStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "oStreamOfCallInstances"

    static const int kOStreamOfCallInstances = 0;

    /**
     * Clears the field "oStreamOfCallInstances".
     *
     * The field will be set to its default value. The hasOStreamOfCallInstances()
     * method will return false.
     */
    inline void clearOStreamOfCallInstances();

    /**
     * Checks whether the field "oStreamOfCallInstances" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOStreamOfCallInstances()). Otherwise it will return false.
     */
    inline bool hasOStreamOfCallInstances () const;

    /**
     * Returns the value of the member "oStreamOfCallInstances".
     *
     * an stream of call instances , in lieu of an array
     *
     * @return The value of the field "oStreamOfCallInstances"
     */
    inline const ::most_Tel_fi_types::T_TelStreamOfCallInstances& getOStreamOfCallInstances () const;

    /**
     * Retrieves the value of the field "oStreamOfCallInstances" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oStreamOfCallInstances".
     */
    inline ::most_Tel_fi_types::T_TelStreamOfCallInstances& getOStreamOfCallInstancesMutable ();

    /**
     * Sets the value of the member "oStreamOfCallInstances".
     *
     * an stream of call instances , in lieu of an array
     *
     * @param oStreamOfCallInstances The value which will be set
     */
    inline void setOStreamOfCallInstances (const ::most_Tel_fi_types::T_TelStreamOfCallInstances& oStreamOfCallInstances_);

    static const ConferenceInStart &getDefaultInstance();

private:

    static const ::std::vector< uint16 >& getUint16List_DefaultInstance ();

    inline void set_has_oStreamOfCallInstances ();

    inline void clear_has_oStreamOfCallInstances ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::most_Tel_fi_types::T_TelStreamOfCallInstances _oStreamOfCallInstances;

};

/**
 * The result message of the method "ConferenceIn"
 * Joins or conferences in all ACTIVE, ONHOLD, and WAITING calls.
 */
class ConferenceInResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ConferenceInResult ();

    /**
     * Copy constructor
     */
    inline  ConferenceInResult (const ConferenceInResult &rhs);

    /**
     * All fields constructor
     */
    inline  ConferenceInResult (const ::most_Tel_fi_types::T_TelStreamOfCallInstances& oStreamOfCallInstances_);

    /**
     * Destructor
     */
    inline virtual  ~ConferenceInResult();

    /**
     * Assignment operator
     */
    inline ConferenceInResult& operator = (const ConferenceInResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ConferenceInResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ConferenceInResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ConferenceInResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ConferenceInResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "oStreamOfCallInstances"

    static const int kOStreamOfCallInstances = 0;

    /**
     * Clears the field "oStreamOfCallInstances".
     *
     * The field will be set to its default value. The hasOStreamOfCallInstances()
     * method will return false.
     */
    inline void clearOStreamOfCallInstances();

    /**
     * Checks whether the field "oStreamOfCallInstances" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOStreamOfCallInstances()). Otherwise it will return false.
     */
    inline bool hasOStreamOfCallInstances () const;

    /**
     * Returns the value of the member "oStreamOfCallInstances".
     *
     * an stream of call instances , in lieu of an array
     *
     * @return The value of the field "oStreamOfCallInstances"
     */
    inline const ::most_Tel_fi_types::T_TelStreamOfCallInstances& getOStreamOfCallInstances () const;

    /**
     * Retrieves the value of the field "oStreamOfCallInstances" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oStreamOfCallInstances".
     */
    inline ::most_Tel_fi_types::T_TelStreamOfCallInstances& getOStreamOfCallInstancesMutable ();

    /**
     * Sets the value of the member "oStreamOfCallInstances".
     *
     * an stream of call instances , in lieu of an array
     *
     * @param oStreamOfCallInstances The value which will be set
     */
    inline void setOStreamOfCallInstances (const ::most_Tel_fi_types::T_TelStreamOfCallInstances& oStreamOfCallInstances_);

    static const ConferenceInResult &getDefaultInstance();

private:

    static const ::std::vector< uint16 >& getUint16List_DefaultInstance ();

    inline void set_has_oStreamOfCallInstances ();

    inline void clear_has_oStreamOfCallInstances ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::most_Tel_fi_types::T_TelStreamOfCallInstances _oStreamOfCallInstances;

};

/**
 * The error message of 'ConferenceIn'
 */
class ConferenceInErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  ConferenceInErrorStructure ();

    /**
     * Copy constructor
     */
    inline  ConferenceInErrorStructure (const ConferenceInErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  ConferenceInErrorStructure (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline  ~ConferenceInErrorStructure();

    /**
     * Assignment operator
     */
    inline ConferenceInErrorStructure& operator = (const ConferenceInErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ConferenceInErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ConferenceInErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ConferenceInErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ConferenceInErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     * Error codes outlined in MOST standard, e.g.:
     * $01 Syntax error: F Block does not exist,
     * $02 Syntax error: Instance does not exist,
     * $03 Syntax error: Function does not exist,
     * $04 Syntax error: Operations does not exist,etc.
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     * Error codes outlined in MOST standard, e.g.:
     * $01 Syntax error: F Block does not exist,
     * $02 Syntax error: Instance does not exist,
     * $03 Syntax error: Function does not exist,
     * $04 Syntax error: Operations does not exist,etc.
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 1;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     * This is for error code $20, function specific error information.  Allowed range $01 - $BF.
     *
     * The first byte is the enumeration of error codes as follows:
     * 0x01:  ERR_NOT_AVAILABLE
     * 0x02:  ERR_NOSERVICE
     * 0x03:  ERR_NO_CALL
     * 0x04:  ERR_NETWORK_DENY
     * 0x05:  ERR_NO_AUDIO_CHANNEL
     * 0xD8:  ERR_OTHER
     *
     * The 2nd byte, if present, is the CallInstance of the function that generated the error.
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     * This is for error code $20, function specific error information.  Allowed range $01 - $BF.
     *
     * The first byte is the enumeration of error codes as follows:
     * 0x01:  ERR_NOT_AVAILABLE
     * 0x02:  ERR_NOSERVICE
     * 0x03:  ERR_NO_CALL
     * 0x04:  ERR_NETWORK_DENY
     * 0x05:  ERR_NO_AUDIO_CHANNEL
     * 0xD8:  ERR_OTHER
     *
     * The 2nd byte, if present, is the CallInstance of the function that generated the error.
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    static const ConferenceInErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

};

/**
 * The error message of 'ConferenceIn'
 */
class ConferenceInError  : public ::asf::core::Payload {
public:

    enum ConferenceInErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  ConferenceInError ();

   /**
     * Copy constructor
     */
    inline  ConferenceInError (const ConferenceInError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~ConferenceInError();

    /**
     * Assigns a new value to this object.
     */
    inline ConferenceInError& operator = (const ConferenceInError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ConferenceInError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ConferenceInError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ConferenceInError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ConferenceInError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline ConferenceInError::ConferenceInErrorField getField () const;

    inline void setField(ConferenceInError::ConferenceInErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "ConferenceInErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "ConferenceInErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const ConferenceInErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline ConferenceInErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline ConferenceInErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (ConferenceInErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "ConferenceInErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const ConferenceInErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const ConferenceInError &getDefaultInstance();

private:

    inline void cloneData (const ConferenceInError& rhs);

    inline void deleteData ();

    ConferenceInErrorField __field;

    union {
        ConferenceInErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "HangUpCall"
 * Request Termination of a call.  Also can be used iteratively for Multiple call situation.  Returns CallStatus when call is relesed from network.
 */
class HangUpCallStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  HangUpCallStart ();

    /**
     * Copy constructor
     */
    inline  HangUpCallStart (const HangUpCallStart &rhs);

    /**
     * All fields constructor
     */
    inline  HangUpCallStart (uint16 u16CallInstance_);

    /**
     * Destructor
     */
    inline virtual  ~HangUpCallStart();

    /**
     * Assignment operator
     */
    inline HangUpCallStart& operator = (const HangUpCallStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const HangUpCallStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const HangUpCallStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const HangUpCallStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const HangUpCallStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u16CallInstance"

    static const int kU16CallInstance = 0;

    /**
     * Clears the field "u16CallInstance".
     *
     * The field will be set to its default value. The hasU16CallInstance()
     * method will return false.
     */
    inline void clearU16CallInstance();

    /**
     * Checks whether the field "u16CallInstance" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16CallInstance()). Otherwise it will return false.
     */
    inline bool hasU16CallInstance () const;

    /**
     * Returns the value of the member "u16CallInstance".
     *
     * Instance of one call from multiple call possible.
     * Call Instance FF means all call.  Like HangUp all calls.
     *
     * @return The value of the field "u16CallInstance"
     */
    inline uint16 getU16CallInstance () const;

    /**
     * Sets the value of the member "u16CallInstance".
     *
     * Instance of one call from multiple call possible.
     * Call Instance FF means all call.  Like HangUp all calls.
     *
     * @param u16CallInstance The value which will be set
     */
    inline void setU16CallInstance (uint16 u16CallInstance_);

    static const HangUpCallStart &getDefaultInstance();

private:

    inline void set_has_u16CallInstance ();

    inline void clear_has_u16CallInstance ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _u16CallInstance;

};

/**
 * The result message of the method "HangUpCall"
 * Request Termination of a call.  Also can be used iteratively for Multiple call situation.  Returns CallStatus when call is relesed from network.
 */
class HangUpCallResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  HangUpCallResult ();

    /**
     * Copy constructor
     */
    inline  HangUpCallResult (const HangUpCallResult &rhs);

    /**
     * All fields constructor
     */
    inline  HangUpCallResult (uint16 u16CallInstance_, ::most_Tel_fi_types::T_e8_TelCallStatus e8CallStatus_, bool bUsingVehicleAudio_);

    /**
     * Destructor
     */
    inline virtual  ~HangUpCallResult();

    /**
     * Assignment operator
     */
    inline HangUpCallResult& operator = (const HangUpCallResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const HangUpCallResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const HangUpCallResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const HangUpCallResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const HangUpCallResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u16CallInstance"

    static const int kU16CallInstance = 0;

    /**
     * Clears the field "u16CallInstance".
     *
     * The field will be set to its default value. The hasU16CallInstance()
     * method will return false.
     */
    inline void clearU16CallInstance();

    /**
     * Checks whether the field "u16CallInstance" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16CallInstance()). Otherwise it will return false.
     */
    inline bool hasU16CallInstance () const;

    /**
     * Returns the value of the member "u16CallInstance".
     *
     * Instance of one call from multiple call possible.
     *
     * Call Instance FF means all call.  Like HangUp all calls.
     *
     * @return The value of the field "u16CallInstance"
     */
    inline uint16 getU16CallInstance () const;

    /**
     * Sets the value of the member "u16CallInstance".
     *
     * Instance of one call from multiple call possible.
     *
     * Call Instance FF means all call.  Like HangUp all calls.
     *
     * @param u16CallInstance The value which will be set
     */
    inline void setU16CallInstance (uint16 u16CallInstance_);

    // API of field "e8CallStatus"

    static const int kE8CallStatus = 1;

    /**
     * Clears the field "e8CallStatus".
     *
     * The field will be set to its default value. The hasE8CallStatus()
     * method will return false.
     */
    inline void clearE8CallStatus();

    /**
     * Checks whether the field "e8CallStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8CallStatus()). Otherwise it will return false.
     */
    inline bool hasE8CallStatus () const;

    /**
     * Returns the value of the member "e8CallStatus".
     *
     * Status of a call
     *
     * @return The value of the field "e8CallStatus"
     */
    inline ::most_Tel_fi_types::T_e8_TelCallStatus getE8CallStatus () const;

    /**
     * Sets the value of the member "e8CallStatus".
     *
     * Status of a call
     *
     * @param e8CallStatus The value which will be set
     */
    inline void setE8CallStatus (::most_Tel_fi_types::T_e8_TelCallStatus e8CallStatus_);

    // API of field "bUsingVehicleAudio"

    static const int kBUsingVehicleAudio = 2;

    /**
     * Clears the field "bUsingVehicleAudio".
     *
     * The field will be set to its default value. The hasBUsingVehicleAudio()
     * method will return false.
     */
    inline void clearBUsingVehicleAudio();

    /**
     * Checks whether the field "bUsingVehicleAudio" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBUsingVehicleAudio()). Otherwise it will return false.
     */
    inline bool hasBUsingVehicleAudio () const;

    /**
     * Returns the value of the member "bUsingVehicleAudio".
     *
     * Is the call in handset or in vehicle
     *
     * @return The value of the field "bUsingVehicleAudio"
     */
    inline bool getBUsingVehicleAudio () const;

    /**
     * Sets the value of the member "bUsingVehicleAudio".
     *
     * Is the call in handset or in vehicle
     *
     * @param bUsingVehicleAudio The value which will be set
     */
    inline void setBUsingVehicleAudio (bool bUsingVehicleAudio_);

    static const HangUpCallResult &getDefaultInstance();

private:

    inline void set_has_u16CallInstance ();

    inline void clear_has_u16CallInstance ();

    inline void set_has_e8CallStatus ();

    inline void clear_has_e8CallStatus ();

    inline void set_has_bUsingVehicleAudio ();

    inline void clear_has_bUsingVehicleAudio ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint16 _u16CallInstance;

    ::most_Tel_fi_types::T_e8_TelCallStatus _e8CallStatus;

    bool _bUsingVehicleAudio;

};

/**
 * The error message of 'HangUpCall'
 */
class HangUpCallErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  HangUpCallErrorStructure ();

    /**
     * Copy constructor
     */
    inline  HangUpCallErrorStructure (const HangUpCallErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  HangUpCallErrorStructure (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline  ~HangUpCallErrorStructure();

    /**
     * Assignment operator
     */
    inline HangUpCallErrorStructure& operator = (const HangUpCallErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const HangUpCallErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const HangUpCallErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const HangUpCallErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const HangUpCallErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     * Error codes outlined in MOST standard, e.g.:
     * $01 Syntax error: F Block does not exist,
     * $02 Syntax error: Instance does not exist,
     * $03 Syntax error: Function does not exist,
     * $04 Syntax error: Operations does not exist,etc.
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     * Error codes outlined in MOST standard, e.g.:
     * $01 Syntax error: F Block does not exist,
     * $02 Syntax error: Instance does not exist,
     * $03 Syntax error: Function does not exist,
     * $04 Syntax error: Operations does not exist,etc.
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 1;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     * This is for error code $20, function specific error information.  Allowed range $01 - $BF.
     *
     * The first byte is the enumeration of error codes as follows:
     * 0x01:  ERR_NOT_AVAILABLE
     * 0x02:  ERR_NOSERVICE
     * 0x03:  ERR_NO_CALL
     * 0x04:  ERR_NETWORK_DENY
     * 0x05:  ERR_NO_AUDIO_CHANNEL
     * 0xD8:  ERR_OTHER
     *
     * The 2nd byte, if present, is the CallInstance of the function that generated the error.
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     * This is for error code $20, function specific error information.  Allowed range $01 - $BF.
     *
     * The first byte is the enumeration of error codes as follows:
     * 0x01:  ERR_NOT_AVAILABLE
     * 0x02:  ERR_NOSERVICE
     * 0x03:  ERR_NO_CALL
     * 0x04:  ERR_NETWORK_DENY
     * 0x05:  ERR_NO_AUDIO_CHANNEL
     * 0xD8:  ERR_OTHER
     *
     * The 2nd byte, if present, is the CallInstance of the function that generated the error.
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    static const HangUpCallErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

};

/**
 * The error message of 'HangUpCall'
 */
class HangUpCallError  : public ::asf::core::Payload {
public:

    enum HangUpCallErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  HangUpCallError ();

   /**
     * Copy constructor
     */
    inline  HangUpCallError (const HangUpCallError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~HangUpCallError();

    /**
     * Assigns a new value to this object.
     */
    inline HangUpCallError& operator = (const HangUpCallError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const HangUpCallError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const HangUpCallError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const HangUpCallError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const HangUpCallError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline HangUpCallError::HangUpCallErrorField getField () const;

    inline void setField(HangUpCallError::HangUpCallErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "HangUpCallErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "HangUpCallErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const HangUpCallErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline HangUpCallErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline HangUpCallErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (HangUpCallErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "HangUpCallErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const HangUpCallErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const HangUpCallError &getDefaultInstance();

private:

    inline void cloneData (const HangUpCallError& rhs);

    inline void deleteData ();

    HangUpCallErrorField __field;

    union {
        HangUpCallErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "HoldCall"
 * Holds a voice call.  Also, Can be used  prior to ConferenceIn method.
 */
class HoldCallStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  HoldCallStart ();

    /**
     * Copy constructor
     */
    inline  HoldCallStart (const HoldCallStart &rhs);

    /**
     * All fields constructor
     */
    inline  HoldCallStart (uint16 u16CallInstance_);

    /**
     * Destructor
     */
    inline virtual  ~HoldCallStart();

    /**
     * Assignment operator
     */
    inline HoldCallStart& operator = (const HoldCallStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const HoldCallStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const HoldCallStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const HoldCallStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const HoldCallStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u16CallInstance"

    static const int kU16CallInstance = 0;

    /**
     * Clears the field "u16CallInstance".
     *
     * The field will be set to its default value. The hasU16CallInstance()
     * method will return false.
     */
    inline void clearU16CallInstance();

    /**
     * Checks whether the field "u16CallInstance" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16CallInstance()). Otherwise it will return false.
     */
    inline bool hasU16CallInstance () const;

    /**
     * Returns the value of the member "u16CallInstance".
     *
     * Instance of one call from multiple call possible.
     *
     * Call Instance FF means all call.  Like HangUp all calls.
     *
     * @return The value of the field "u16CallInstance"
     */
    inline uint16 getU16CallInstance () const;

    /**
     * Sets the value of the member "u16CallInstance".
     *
     * Instance of one call from multiple call possible.
     *
     * Call Instance FF means all call.  Like HangUp all calls.
     *
     * @param u16CallInstance The value which will be set
     */
    inline void setU16CallInstance (uint16 u16CallInstance_);

    static const HoldCallStart &getDefaultInstance();

private:

    inline void set_has_u16CallInstance ();

    inline void clear_has_u16CallInstance ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _u16CallInstance;

};

/**
 * The result message of the method "HoldCall"
 * Holds a voice call.  Also, Can be used  prior to ConferenceIn method.
 */
class HoldCallResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  HoldCallResult ();

    /**
     * Copy constructor
     */
    inline  HoldCallResult (const HoldCallResult &rhs);

    /**
     * All fields constructor
     */
    inline  HoldCallResult (uint16 u16CallInstance_, ::most_Tel_fi_types::T_e8_TelCallStatus e8CallStatus_, bool bUsingVehicleAudio_);

    /**
     * Destructor
     */
    inline virtual  ~HoldCallResult();

    /**
     * Assignment operator
     */
    inline HoldCallResult& operator = (const HoldCallResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const HoldCallResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const HoldCallResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const HoldCallResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const HoldCallResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u16CallInstance"

    static const int kU16CallInstance = 0;

    /**
     * Clears the field "u16CallInstance".
     *
     * The field will be set to its default value. The hasU16CallInstance()
     * method will return false.
     */
    inline void clearU16CallInstance();

    /**
     * Checks whether the field "u16CallInstance" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16CallInstance()). Otherwise it will return false.
     */
    inline bool hasU16CallInstance () const;

    /**
     * Returns the value of the member "u16CallInstance".
     *
     * Instance of one call from multiple call possible.
     *
     * Call Instance FF means all call.  Like HangUp all calls.
     *
     * @return The value of the field "u16CallInstance"
     */
    inline uint16 getU16CallInstance () const;

    /**
     * Sets the value of the member "u16CallInstance".
     *
     * Instance of one call from multiple call possible.
     *
     * Call Instance FF means all call.  Like HangUp all calls.
     *
     * @param u16CallInstance The value which will be set
     */
    inline void setU16CallInstance (uint16 u16CallInstance_);

    // API of field "e8CallStatus"

    static const int kE8CallStatus = 1;

    /**
     * Clears the field "e8CallStatus".
     *
     * The field will be set to its default value. The hasE8CallStatus()
     * method will return false.
     */
    inline void clearE8CallStatus();

    /**
     * Checks whether the field "e8CallStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8CallStatus()). Otherwise it will return false.
     */
    inline bool hasE8CallStatus () const;

    /**
     * Returns the value of the member "e8CallStatus".
     *
     * Status of a call
     *
     * @return The value of the field "e8CallStatus"
     */
    inline ::most_Tel_fi_types::T_e8_TelCallStatus getE8CallStatus () const;

    /**
     * Sets the value of the member "e8CallStatus".
     *
     * Status of a call
     *
     * @param e8CallStatus The value which will be set
     */
    inline void setE8CallStatus (::most_Tel_fi_types::T_e8_TelCallStatus e8CallStatus_);

    // API of field "bUsingVehicleAudio"

    static const int kBUsingVehicleAudio = 2;

    /**
     * Clears the field "bUsingVehicleAudio".
     *
     * The field will be set to its default value. The hasBUsingVehicleAudio()
     * method will return false.
     */
    inline void clearBUsingVehicleAudio();

    /**
     * Checks whether the field "bUsingVehicleAudio" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBUsingVehicleAudio()). Otherwise it will return false.
     */
    inline bool hasBUsingVehicleAudio () const;

    /**
     * Returns the value of the member "bUsingVehicleAudio".
     *
     * Is the call in handset or in vehicle
     *
     * @return The value of the field "bUsingVehicleAudio"
     */
    inline bool getBUsingVehicleAudio () const;

    /**
     * Sets the value of the member "bUsingVehicleAudio".
     *
     * Is the call in handset or in vehicle
     *
     * @param bUsingVehicleAudio The value which will be set
     */
    inline void setBUsingVehicleAudio (bool bUsingVehicleAudio_);

    static const HoldCallResult &getDefaultInstance();

private:

    inline void set_has_u16CallInstance ();

    inline void clear_has_u16CallInstance ();

    inline void set_has_e8CallStatus ();

    inline void clear_has_e8CallStatus ();

    inline void set_has_bUsingVehicleAudio ();

    inline void clear_has_bUsingVehicleAudio ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint16 _u16CallInstance;

    ::most_Tel_fi_types::T_e8_TelCallStatus _e8CallStatus;

    bool _bUsingVehicleAudio;

};

/**
 * The error message of 'HoldCall'
 */
class HoldCallErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  HoldCallErrorStructure ();

    /**
     * Copy constructor
     */
    inline  HoldCallErrorStructure (const HoldCallErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  HoldCallErrorStructure (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline  ~HoldCallErrorStructure();

    /**
     * Assignment operator
     */
    inline HoldCallErrorStructure& operator = (const HoldCallErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const HoldCallErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const HoldCallErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const HoldCallErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const HoldCallErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     * Error codes outlined in MOST standard, e.g.:
     * $01 Syntax error: F Block does not exist,
     * $02 Syntax error: Instance does not exist,
     * $03 Syntax error: Function does not exist,
     * $04 Syntax error: Operations does not exist,etc.
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     * Error codes outlined in MOST standard, e.g.:
     * $01 Syntax error: F Block does not exist,
     * $02 Syntax error: Instance does not exist,
     * $03 Syntax error: Function does not exist,
     * $04 Syntax error: Operations does not exist,etc.
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 1;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     * This is for error code $20, function specific error information.  Allowed range $01 - $BF.
     *
     * The first byte is the enumeration of error codes as follows:
     * 0x01:  ERR_NOT_AVAILABLE
     * 0x02:  ERR_NOSERVICE
     * 0x03:  ERR_NO_CALL
     * 0x04:  ERR_NETWORK_DENY
     * 0x05:  ERR_NO_AUDIO_CHANNEL
     * 0xD8:  ERR_OTHER
     *
     * The 2nd byte, if present, is the CallInstance of the function that generated the error.
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     * This is for error code $20, function specific error information.  Allowed range $01 - $BF.
     *
     * The first byte is the enumeration of error codes as follows:
     * 0x01:  ERR_NOT_AVAILABLE
     * 0x02:  ERR_NOSERVICE
     * 0x03:  ERR_NO_CALL
     * 0x04:  ERR_NETWORK_DENY
     * 0x05:  ERR_NO_AUDIO_CHANNEL
     * 0xD8:  ERR_OTHER
     *
     * The 2nd byte, if present, is the CallInstance of the function that generated the error.
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    static const HoldCallErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

};

/**
 * The error message of 'HoldCall'
 */
class HoldCallError  : public ::asf::core::Payload {
public:

    enum HoldCallErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  HoldCallError ();

   /**
     * Copy constructor
     */
    inline  HoldCallError (const HoldCallError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~HoldCallError();

    /**
     * Assigns a new value to this object.
     */
    inline HoldCallError& operator = (const HoldCallError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const HoldCallError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const HoldCallError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const HoldCallError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const HoldCallError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline HoldCallError::HoldCallErrorField getField () const;

    inline void setField(HoldCallError::HoldCallErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "HoldCallErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "HoldCallErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const HoldCallErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline HoldCallErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline HoldCallErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (HoldCallErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "HoldCallErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const HoldCallErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const HoldCallError &getDefaultInstance();

private:

    inline void cloneData (const HoldCallError& rhs);

    inline void deleteData ();

    HoldCallErrorField __field;

    union {
        HoldCallErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "IgnoreCall"
 * Used in F&B to send incoming call to voice mail.
 */
class IgnoreCallStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  IgnoreCallStart ();

    /**
     * Copy constructor
     */
    inline  IgnoreCallStart (const IgnoreCallStart &rhs);

    /**
     * All fields constructor
     */
    inline  IgnoreCallStart (uint16 u16CallInstance_);

    /**
     * Destructor
     */
    inline virtual  ~IgnoreCallStart();

    /**
     * Assignment operator
     */
    inline IgnoreCallStart& operator = (const IgnoreCallStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const IgnoreCallStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const IgnoreCallStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const IgnoreCallStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const IgnoreCallStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u16CallInstance"

    static const int kU16CallInstance = 0;

    /**
     * Clears the field "u16CallInstance".
     *
     * The field will be set to its default value. The hasU16CallInstance()
     * method will return false.
     */
    inline void clearU16CallInstance();

    /**
     * Checks whether the field "u16CallInstance" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16CallInstance()). Otherwise it will return false.
     */
    inline bool hasU16CallInstance () const;

    /**
     * Returns the value of the member "u16CallInstance".
     *
     * Instance of one call from multiple call possible.
     *
     * Call Instance FF means all call.  Like HangUp all calls.
     *
     * @return The value of the field "u16CallInstance"
     */
    inline uint16 getU16CallInstance () const;

    /**
     * Sets the value of the member "u16CallInstance".
     *
     * Instance of one call from multiple call possible.
     *
     * Call Instance FF means all call.  Like HangUp all calls.
     *
     * @param u16CallInstance The value which will be set
     */
    inline void setU16CallInstance (uint16 u16CallInstance_);

    static const IgnoreCallStart &getDefaultInstance();

private:

    inline void set_has_u16CallInstance ();

    inline void clear_has_u16CallInstance ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _u16CallInstance;

};

/**
 * The result message of the method "IgnoreCall"
 * Used in F&B to send incoming call to voice mail.
 */
class IgnoreCallResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  IgnoreCallResult ();

    /**
     * Copy constructor
     */
    inline  IgnoreCallResult (const IgnoreCallResult &rhs);

    /**
     * All fields constructor
     */
    inline  IgnoreCallResult (uint16 u16CallInstance_, ::most_Tel_fi_types::T_e8_TelCallStatus e8CallStatus_, bool bUsingVehicleAudio_);

    /**
     * Destructor
     */
    inline virtual  ~IgnoreCallResult();

    /**
     * Assignment operator
     */
    inline IgnoreCallResult& operator = (const IgnoreCallResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const IgnoreCallResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const IgnoreCallResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const IgnoreCallResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const IgnoreCallResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u16CallInstance"

    static const int kU16CallInstance = 0;

    /**
     * Clears the field "u16CallInstance".
     *
     * The field will be set to its default value. The hasU16CallInstance()
     * method will return false.
     */
    inline void clearU16CallInstance();

    /**
     * Checks whether the field "u16CallInstance" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16CallInstance()). Otherwise it will return false.
     */
    inline bool hasU16CallInstance () const;

    /**
     * Returns the value of the member "u16CallInstance".
     *
     * Instance of one call from multiple call possible.
     *
     * Call Instance FF means all call.  Like HangUp all calls.
     *
     * @return The value of the field "u16CallInstance"
     */
    inline uint16 getU16CallInstance () const;

    /**
     * Sets the value of the member "u16CallInstance".
     *
     * Instance of one call from multiple call possible.
     *
     * Call Instance FF means all call.  Like HangUp all calls.
     *
     * @param u16CallInstance The value which will be set
     */
    inline void setU16CallInstance (uint16 u16CallInstance_);

    // API of field "e8CallStatus"

    static const int kE8CallStatus = 1;

    /**
     * Clears the field "e8CallStatus".
     *
     * The field will be set to its default value. The hasE8CallStatus()
     * method will return false.
     */
    inline void clearE8CallStatus();

    /**
     * Checks whether the field "e8CallStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8CallStatus()). Otherwise it will return false.
     */
    inline bool hasE8CallStatus () const;

    /**
     * Returns the value of the member "e8CallStatus".
     *
     * Status of a call
     *
     * @return The value of the field "e8CallStatus"
     */
    inline ::most_Tel_fi_types::T_e8_TelCallStatus getE8CallStatus () const;

    /**
     * Sets the value of the member "e8CallStatus".
     *
     * Status of a call
     *
     * @param e8CallStatus The value which will be set
     */
    inline void setE8CallStatus (::most_Tel_fi_types::T_e8_TelCallStatus e8CallStatus_);

    // API of field "bUsingVehicleAudio"

    static const int kBUsingVehicleAudio = 2;

    /**
     * Clears the field "bUsingVehicleAudio".
     *
     * The field will be set to its default value. The hasBUsingVehicleAudio()
     * method will return false.
     */
    inline void clearBUsingVehicleAudio();

    /**
     * Checks whether the field "bUsingVehicleAudio" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBUsingVehicleAudio()). Otherwise it will return false.
     */
    inline bool hasBUsingVehicleAudio () const;

    /**
     * Returns the value of the member "bUsingVehicleAudio".
     *
     * Is the call in handset or in vehicle
     *
     * @return The value of the field "bUsingVehicleAudio"
     */
    inline bool getBUsingVehicleAudio () const;

    /**
     * Sets the value of the member "bUsingVehicleAudio".
     *
     * Is the call in handset or in vehicle
     *
     * @param bUsingVehicleAudio The value which will be set
     */
    inline void setBUsingVehicleAudio (bool bUsingVehicleAudio_);

    static const IgnoreCallResult &getDefaultInstance();

private:

    inline void set_has_u16CallInstance ();

    inline void clear_has_u16CallInstance ();

    inline void set_has_e8CallStatus ();

    inline void clear_has_e8CallStatus ();

    inline void set_has_bUsingVehicleAudio ();

    inline void clear_has_bUsingVehicleAudio ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint16 _u16CallInstance;

    ::most_Tel_fi_types::T_e8_TelCallStatus _e8CallStatus;

    bool _bUsingVehicleAudio;

};

/**
 * The error message of 'IgnoreCall'
 */
class IgnoreCallErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  IgnoreCallErrorStructure ();

    /**
     * Copy constructor
     */
    inline  IgnoreCallErrorStructure (const IgnoreCallErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  IgnoreCallErrorStructure (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline  ~IgnoreCallErrorStructure();

    /**
     * Assignment operator
     */
    inline IgnoreCallErrorStructure& operator = (const IgnoreCallErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const IgnoreCallErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const IgnoreCallErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const IgnoreCallErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const IgnoreCallErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     * Error codes outlined in MOST standard, e.g.:
     * $01 Syntax error: F Block does not exist,
     * $02 Syntax error: Instance does not exist,
     * $03 Syntax error: Function does not exist,
     * $04 Syntax error: Operations does not exist,etc.
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     * Error codes outlined in MOST standard, e.g.:
     * $01 Syntax error: F Block does not exist,
     * $02 Syntax error: Instance does not exist,
     * $03 Syntax error: Function does not exist,
     * $04 Syntax error: Operations does not exist,etc.
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 1;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     * This is for error code $20, function specific error information.  Allowed range $01 - $BF.
     *
     * The first byte is the enumeration of error codes as follows:
     * 0x01:  ERR_NOT_AVAILABLE
     * 0x02:  ERR_NOSERVICE
     * 0x03:  ERR_NO_CALL
     * 0x04:  ERR_NETWORK_DENY
     * 0x05:  ERR_NO_AUDIO_CHANNEL
     * 0xD8:  ERR_OTHER
     *
     * The 2nd byte, if present, is the CallInstance of the function that generated the error.
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     * This is for error code $20, function specific error information.  Allowed range $01 - $BF.
     *
     * The first byte is the enumeration of error codes as follows:
     * 0x01:  ERR_NOT_AVAILABLE
     * 0x02:  ERR_NOSERVICE
     * 0x03:  ERR_NO_CALL
     * 0x04:  ERR_NETWORK_DENY
     * 0x05:  ERR_NO_AUDIO_CHANNEL
     * 0xD8:  ERR_OTHER
     *
     * The 2nd byte, if present, is the CallInstance of the function that generated the error.
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    static const IgnoreCallErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

};

/**
 * The error message of 'IgnoreCall'
 */
class IgnoreCallError  : public ::asf::core::Payload {
public:

    enum IgnoreCallErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  IgnoreCallError ();

   /**
     * Copy constructor
     */
    inline  IgnoreCallError (const IgnoreCallError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~IgnoreCallError();

    /**
     * Assigns a new value to this object.
     */
    inline IgnoreCallError& operator = (const IgnoreCallError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const IgnoreCallError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const IgnoreCallError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const IgnoreCallError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const IgnoreCallError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline IgnoreCallError::IgnoreCallErrorField getField () const;

    inline void setField(IgnoreCallError::IgnoreCallErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "IgnoreCallErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "IgnoreCallErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const IgnoreCallErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline IgnoreCallErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline IgnoreCallErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (IgnoreCallErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "IgnoreCallErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const IgnoreCallErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const IgnoreCallError &getDefaultInstance();

private:

    inline void cloneData (const IgnoreCallError& rhs);

    inline void deleteData ();

    IgnoreCallErrorField __field;

    union {
        IgnoreCallErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "RejectCall"
 * Reject an Incoming call.  Does not accept the call or sends to voice mail, request disconnection to the network. This is currently not required by HMI.
 */
class RejectCallStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RejectCallStart ();

    /**
     * Copy constructor
     */
    inline  RejectCallStart (const RejectCallStart &rhs);

    /**
     * All fields constructor
     */
    inline  RejectCallStart (uint16 u16CallInstance_);

    /**
     * Destructor
     */
    inline virtual  ~RejectCallStart();

    /**
     * Assignment operator
     */
    inline RejectCallStart& operator = (const RejectCallStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RejectCallStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RejectCallStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RejectCallStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RejectCallStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u16CallInstance"

    static const int kU16CallInstance = 0;

    /**
     * Clears the field "u16CallInstance".
     *
     * The field will be set to its default value. The hasU16CallInstance()
     * method will return false.
     */
    inline void clearU16CallInstance();

    /**
     * Checks whether the field "u16CallInstance" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16CallInstance()). Otherwise it will return false.
     */
    inline bool hasU16CallInstance () const;

    /**
     * Returns the value of the member "u16CallInstance".
     *
     * Instance of one call from multiple call possible.
     *
     * Call Instance FF means all call.  Like HangUp all calls.
     *
     * @return The value of the field "u16CallInstance"
     */
    inline uint16 getU16CallInstance () const;

    /**
     * Sets the value of the member "u16CallInstance".
     *
     * Instance of one call from multiple call possible.
     *
     * Call Instance FF means all call.  Like HangUp all calls.
     *
     * @param u16CallInstance The value which will be set
     */
    inline void setU16CallInstance (uint16 u16CallInstance_);

    static const RejectCallStart &getDefaultInstance();

private:

    inline void set_has_u16CallInstance ();

    inline void clear_has_u16CallInstance ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _u16CallInstance;

};

/**
 * The result message of the method "RejectCall"
 * Reject an Incoming call.  Does not accept the call or sends to voice mail, request disconnection to the network. This is currently not required by HMI.
 */
class RejectCallResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RejectCallResult ();

    /**
     * Copy constructor
     */
    inline  RejectCallResult (const RejectCallResult &rhs);

    /**
     * All fields constructor
     */
    inline  RejectCallResult (uint16 u16CallInstance_, ::most_Tel_fi_types::T_e8_TelCallStatus e8CallStatus_, bool bUsingVehicleAudio_);

    /**
     * Destructor
     */
    inline virtual  ~RejectCallResult();

    /**
     * Assignment operator
     */
    inline RejectCallResult& operator = (const RejectCallResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RejectCallResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RejectCallResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RejectCallResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RejectCallResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u16CallInstance"

    static const int kU16CallInstance = 0;

    /**
     * Clears the field "u16CallInstance".
     *
     * The field will be set to its default value. The hasU16CallInstance()
     * method will return false.
     */
    inline void clearU16CallInstance();

    /**
     * Checks whether the field "u16CallInstance" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16CallInstance()). Otherwise it will return false.
     */
    inline bool hasU16CallInstance () const;

    /**
     * Returns the value of the member "u16CallInstance".
     *
     * Instance of one call from multiple call possible.
     *
     * Call Instance FF means all call.  Like HangUp all calls.
     *
     * @return The value of the field "u16CallInstance"
     */
    inline uint16 getU16CallInstance () const;

    /**
     * Sets the value of the member "u16CallInstance".
     *
     * Instance of one call from multiple call possible.
     *
     * Call Instance FF means all call.  Like HangUp all calls.
     *
     * @param u16CallInstance The value which will be set
     */
    inline void setU16CallInstance (uint16 u16CallInstance_);

    // API of field "e8CallStatus"

    static const int kE8CallStatus = 1;

    /**
     * Clears the field "e8CallStatus".
     *
     * The field will be set to its default value. The hasE8CallStatus()
     * method will return false.
     */
    inline void clearE8CallStatus();

    /**
     * Checks whether the field "e8CallStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8CallStatus()). Otherwise it will return false.
     */
    inline bool hasE8CallStatus () const;

    /**
     * Returns the value of the member "e8CallStatus".
     *
     * Status of a call
     *
     * @return The value of the field "e8CallStatus"
     */
    inline ::most_Tel_fi_types::T_e8_TelCallStatus getE8CallStatus () const;

    /**
     * Sets the value of the member "e8CallStatus".
     *
     * Status of a call
     *
     * @param e8CallStatus The value which will be set
     */
    inline void setE8CallStatus (::most_Tel_fi_types::T_e8_TelCallStatus e8CallStatus_);

    // API of field "bUsingVehicleAudio"

    static const int kBUsingVehicleAudio = 2;

    /**
     * Clears the field "bUsingVehicleAudio".
     *
     * The field will be set to its default value. The hasBUsingVehicleAudio()
     * method will return false.
     */
    inline void clearBUsingVehicleAudio();

    /**
     * Checks whether the field "bUsingVehicleAudio" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBUsingVehicleAudio()). Otherwise it will return false.
     */
    inline bool hasBUsingVehicleAudio () const;

    /**
     * Returns the value of the member "bUsingVehicleAudio".
     *
     * Is the call in handset or in vehicle
     *
     * @return The value of the field "bUsingVehicleAudio"
     */
    inline bool getBUsingVehicleAudio () const;

    /**
     * Sets the value of the member "bUsingVehicleAudio".
     *
     * Is the call in handset or in vehicle
     *
     * @param bUsingVehicleAudio The value which will be set
     */
    inline void setBUsingVehicleAudio (bool bUsingVehicleAudio_);

    static const RejectCallResult &getDefaultInstance();

private:

    inline void set_has_u16CallInstance ();

    inline void clear_has_u16CallInstance ();

    inline void set_has_e8CallStatus ();

    inline void clear_has_e8CallStatus ();

    inline void set_has_bUsingVehicleAudio ();

    inline void clear_has_bUsingVehicleAudio ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint16 _u16CallInstance;

    ::most_Tel_fi_types::T_e8_TelCallStatus _e8CallStatus;

    bool _bUsingVehicleAudio;

};

/**
 * The error message of 'RejectCall'
 */
class RejectCallErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  RejectCallErrorStructure ();

    /**
     * Copy constructor
     */
    inline  RejectCallErrorStructure (const RejectCallErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  RejectCallErrorStructure (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline  ~RejectCallErrorStructure();

    /**
     * Assignment operator
     */
    inline RejectCallErrorStructure& operator = (const RejectCallErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RejectCallErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RejectCallErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RejectCallErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RejectCallErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     * Error codes outlined in MOST standard, e.g.:
     * $01 Syntax error: F Block does not exist,
     * $02 Syntax error: Instance does not exist,
     * $03 Syntax error: Function does not exist,
     * $04 Syntax error: Operations does not exist,etc.
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     * Error codes outlined in MOST standard, e.g.:
     * $01 Syntax error: F Block does not exist,
     * $02 Syntax error: Instance does not exist,
     * $03 Syntax error: Function does not exist,
     * $04 Syntax error: Operations does not exist,etc.
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 1;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     * This is for error code $20, function specific error information.  Allowed range $01 - $BF.
     *
     * The first byte is the enumeration of error codes as follows:
     * 0x01:  ERR_NOT_AVAILABLE
     * 0x02:  ERR_NOSERVICE
     * 0x03:  ERR_NO_CALL
     * 0x04:  ERR_NETWORK_DENY
     * 0x05:  ERR_NO_AUDIO_CHANNEL
     * 0xD8:  ERR_OTHER
     *
     * The 2nd byte, if present, is the CallInstance of the function that generated the error.
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     * This is for error code $20, function specific error information.  Allowed range $01 - $BF.
     *
     * The first byte is the enumeration of error codes as follows:
     * 0x01:  ERR_NOT_AVAILABLE
     * 0x02:  ERR_NOSERVICE
     * 0x03:  ERR_NO_CALL
     * 0x04:  ERR_NETWORK_DENY
     * 0x05:  ERR_NO_AUDIO_CHANNEL
     * 0xD8:  ERR_OTHER
     *
     * The 2nd byte, if present, is the CallInstance of the function that generated the error.
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    static const RejectCallErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

};

/**
 * The error message of 'RejectCall'
 */
class RejectCallError  : public ::asf::core::Payload {
public:

    enum RejectCallErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  RejectCallError ();

   /**
     * Copy constructor
     */
    inline  RejectCallError (const RejectCallError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~RejectCallError();

    /**
     * Assigns a new value to this object.
     */
    inline RejectCallError& operator = (const RejectCallError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RejectCallError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RejectCallError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RejectCallError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RejectCallError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline RejectCallError::RejectCallErrorField getField () const;

    inline void setField(RejectCallError::RejectCallErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "RejectCallErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "RejectCallErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const RejectCallErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline RejectCallErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline RejectCallErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (RejectCallErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "RejectCallErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const RejectCallErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const RejectCallError &getDefaultInstance();

private:

    inline void cloneData (const RejectCallError& rhs);

    inline void deleteData ();

    RejectCallErrorField __field;

    union {
        RejectCallErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "ResumeCall"
 * Resume a  Call on hold.
 */
class ResumeCallStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ResumeCallStart ();

    /**
     * Copy constructor
     */
    inline  ResumeCallStart (const ResumeCallStart &rhs);

    /**
     * All fields constructor
     */
    inline  ResumeCallStart (uint16 u16CallInstance_);

    /**
     * Destructor
     */
    inline virtual  ~ResumeCallStart();

    /**
     * Assignment operator
     */
    inline ResumeCallStart& operator = (const ResumeCallStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ResumeCallStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ResumeCallStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ResumeCallStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ResumeCallStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u16CallInstance"

    static const int kU16CallInstance = 0;

    /**
     * Clears the field "u16CallInstance".
     *
     * The field will be set to its default value. The hasU16CallInstance()
     * method will return false.
     */
    inline void clearU16CallInstance();

    /**
     * Checks whether the field "u16CallInstance" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16CallInstance()). Otherwise it will return false.
     */
    inline bool hasU16CallInstance () const;

    /**
     * Returns the value of the member "u16CallInstance".
     *
     * Instance of one call from multiple call possible.
     *
     * Call Instance FF means all call.  Like HangUp all calls.
     *
     * @return The value of the field "u16CallInstance"
     */
    inline uint16 getU16CallInstance () const;

    /**
     * Sets the value of the member "u16CallInstance".
     *
     * Instance of one call from multiple call possible.
     *
     * Call Instance FF means all call.  Like HangUp all calls.
     *
     * @param u16CallInstance The value which will be set
     */
    inline void setU16CallInstance (uint16 u16CallInstance_);

    static const ResumeCallStart &getDefaultInstance();

private:

    inline void set_has_u16CallInstance ();

    inline void clear_has_u16CallInstance ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _u16CallInstance;

};

/**
 * The result message of the method "ResumeCall"
 * Resume a  Call on hold.
 */
class ResumeCallResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ResumeCallResult ();

    /**
     * Copy constructor
     */
    inline  ResumeCallResult (const ResumeCallResult &rhs);

    /**
     * All fields constructor
     */
    inline  ResumeCallResult (uint16 u16CallInstance_, ::most_Tel_fi_types::T_e8_TelCallStatus e8CallStatus_, bool bUsingVehicleAudio_);

    /**
     * Destructor
     */
    inline virtual  ~ResumeCallResult();

    /**
     * Assignment operator
     */
    inline ResumeCallResult& operator = (const ResumeCallResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ResumeCallResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ResumeCallResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ResumeCallResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ResumeCallResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u16CallInstance"

    static const int kU16CallInstance = 0;

    /**
     * Clears the field "u16CallInstance".
     *
     * The field will be set to its default value. The hasU16CallInstance()
     * method will return false.
     */
    inline void clearU16CallInstance();

    /**
     * Checks whether the field "u16CallInstance" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16CallInstance()). Otherwise it will return false.
     */
    inline bool hasU16CallInstance () const;

    /**
     * Returns the value of the member "u16CallInstance".
     *
     * Instance of one call from multiple call possible.
     *
     * Call Instance FF means all call.  Like HangUp all calls.
     *
     * @return The value of the field "u16CallInstance"
     */
    inline uint16 getU16CallInstance () const;

    /**
     * Sets the value of the member "u16CallInstance".
     *
     * Instance of one call from multiple call possible.
     *
     * Call Instance FF means all call.  Like HangUp all calls.
     *
     * @param u16CallInstance The value which will be set
     */
    inline void setU16CallInstance (uint16 u16CallInstance_);

    // API of field "e8CallStatus"

    static const int kE8CallStatus = 1;

    /**
     * Clears the field "e8CallStatus".
     *
     * The field will be set to its default value. The hasE8CallStatus()
     * method will return false.
     */
    inline void clearE8CallStatus();

    /**
     * Checks whether the field "e8CallStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8CallStatus()). Otherwise it will return false.
     */
    inline bool hasE8CallStatus () const;

    /**
     * Returns the value of the member "e8CallStatus".
     *
     * Status of a call
     *
     * @return The value of the field "e8CallStatus"
     */
    inline ::most_Tel_fi_types::T_e8_TelCallStatus getE8CallStatus () const;

    /**
     * Sets the value of the member "e8CallStatus".
     *
     * Status of a call
     *
     * @param e8CallStatus The value which will be set
     */
    inline void setE8CallStatus (::most_Tel_fi_types::T_e8_TelCallStatus e8CallStatus_);

    // API of field "bUsingVehicleAudio"

    static const int kBUsingVehicleAudio = 2;

    /**
     * Clears the field "bUsingVehicleAudio".
     *
     * The field will be set to its default value. The hasBUsingVehicleAudio()
     * method will return false.
     */
    inline void clearBUsingVehicleAudio();

    /**
     * Checks whether the field "bUsingVehicleAudio" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBUsingVehicleAudio()). Otherwise it will return false.
     */
    inline bool hasBUsingVehicleAudio () const;

    /**
     * Returns the value of the member "bUsingVehicleAudio".
     *
     * Is the call in handset or in vehicle
     *
     * @return The value of the field "bUsingVehicleAudio"
     */
    inline bool getBUsingVehicleAudio () const;

    /**
     * Sets the value of the member "bUsingVehicleAudio".
     *
     * Is the call in handset or in vehicle
     *
     * @param bUsingVehicleAudio The value which will be set
     */
    inline void setBUsingVehicleAudio (bool bUsingVehicleAudio_);

    static const ResumeCallResult &getDefaultInstance();

private:

    inline void set_has_u16CallInstance ();

    inline void clear_has_u16CallInstance ();

    inline void set_has_e8CallStatus ();

    inline void clear_has_e8CallStatus ();

    inline void set_has_bUsingVehicleAudio ();

    inline void clear_has_bUsingVehicleAudio ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint16 _u16CallInstance;

    ::most_Tel_fi_types::T_e8_TelCallStatus _e8CallStatus;

    bool _bUsingVehicleAudio;

};

/**
 * The error message of 'ResumeCall'
 */
class ResumeCallErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  ResumeCallErrorStructure ();

    /**
     * Copy constructor
     */
    inline  ResumeCallErrorStructure (const ResumeCallErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  ResumeCallErrorStructure (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline  ~ResumeCallErrorStructure();

    /**
     * Assignment operator
     */
    inline ResumeCallErrorStructure& operator = (const ResumeCallErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ResumeCallErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ResumeCallErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ResumeCallErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ResumeCallErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     * Error codes outlined in MOST standard, e.g.:
     * $01 Syntax error: F Block does not exist,
     * $02 Syntax error: Instance does not exist,
     * $03 Syntax error: Function does not exist,
     * $04 Syntax error: Operations does not exist,etc.
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     * Error codes outlined in MOST standard, e.g.:
     * $01 Syntax error: F Block does not exist,
     * $02 Syntax error: Instance does not exist,
     * $03 Syntax error: Function does not exist,
     * $04 Syntax error: Operations does not exist,etc.
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 1;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     * This is for error code $20, function specific error information.  Allowed range $01 - $BF.
     *
     * The first byte is the enumeration of error codes as follows:
     * 0x01:  ERR_NOT_AVAILABLE
     * 0x02:  ERR_NOSERVICE
     * 0x03:  ERR_NO_CALL
     * 0x04:  ERR_NETWORK_DENY
     * 0x05:  ERR_NO_AUDIO_CHANNEL
     * 0xD8:  ERR_OTHER
     *
     * The 2nd byte, if present, is the CallInstance of the function that generated the error.
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     * This is for error code $20, function specific error information.  Allowed range $01 - $BF.
     *
     * The first byte is the enumeration of error codes as follows:
     * 0x01:  ERR_NOT_AVAILABLE
     * 0x02:  ERR_NOSERVICE
     * 0x03:  ERR_NO_CALL
     * 0x04:  ERR_NETWORK_DENY
     * 0x05:  ERR_NO_AUDIO_CHANNEL
     * 0xD8:  ERR_OTHER
     *
     * The 2nd byte, if present, is the CallInstance of the function that generated the error.
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    static const ResumeCallErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

};

/**
 * The error message of 'ResumeCall'
 */
class ResumeCallError  : public ::asf::core::Payload {
public:

    enum ResumeCallErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  ResumeCallError ();

   /**
     * Copy constructor
     */
    inline  ResumeCallError (const ResumeCallError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~ResumeCallError();

    /**
     * Assigns a new value to this object.
     */
    inline ResumeCallError& operator = (const ResumeCallError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ResumeCallError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ResumeCallError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ResumeCallError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ResumeCallError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline ResumeCallError::ResumeCallErrorField getField () const;

    inline void setField(ResumeCallError::ResumeCallErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "ResumeCallErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "ResumeCallErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const ResumeCallErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline ResumeCallErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline ResumeCallErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (ResumeCallErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "ResumeCallErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const ResumeCallErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const ResumeCallError &getDefaultInstance();

private:

    inline void cloneData (const ResumeCallError& rhs);

    inline void deleteData ();

    ResumeCallErrorField __field;

    union {
        ResumeCallErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "SendDTMF"
 * Sends DTMF tones to the network.
 */
class SendDTMFStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SendDTMFStart ();

    /**
     * Copy constructor
     */
    inline  SendDTMFStart (const SendDTMFStart &rhs);

    /**
     * All fields constructor
     */
    inline  SendDTMFStart (uint16 u16CallInstance_, const ::fi_basetypes_most::T_String& sDTMFChar_);

    /**
     * Destructor
     */
    inline virtual  ~SendDTMFStart();

    /**
     * Assignment operator
     */
    inline SendDTMFStart& operator = (const SendDTMFStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SendDTMFStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SendDTMFStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SendDTMFStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SendDTMFStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u16CallInstance"

    static const int kU16CallInstance = 0;

    /**
     * Clears the field "u16CallInstance".
     *
     * The field will be set to its default value. The hasU16CallInstance()
     * method will return false.
     */
    inline void clearU16CallInstance();

    /**
     * Checks whether the field "u16CallInstance" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16CallInstance()). Otherwise it will return false.
     */
    inline bool hasU16CallInstance () const;

    /**
     * Returns the value of the member "u16CallInstance".
     *
     * Instance of one call from multiple call possible.
     *
     * Call Instance FF means all call.  Like HangUp all calls.
     *
     * @return The value of the field "u16CallInstance"
     */
    inline uint16 getU16CallInstance () const;

    /**
     * Sets the value of the member "u16CallInstance".
     *
     * Instance of one call from multiple call possible.
     *
     * Call Instance FF means all call.  Like HangUp all calls.
     *
     * @param u16CallInstance The value which will be set
     */
    inline void setU16CallInstance (uint16 u16CallInstance_);

    // API of field "sDTMFChar"

    static const int kSDTMFChar = 1;

    /**
     * Clears the field "sDTMFChar".
     *
     * The field will be set to its default value. The hasSDTMFChar()
     * method will return false.
     */
    inline void clearSDTMFChar();

    /**
     * Checks whether the field "sDTMFChar" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSDTMFChar()). Otherwise it will return false.
     */
    inline bool hasSDTMFChar () const;

    /**
     * Returns the value of the member "sDTMFChar".
     *
     * Defined as single chracter.  Restrictions of this within 0-9, and *,#, and + needs to be enforced in implementation.
     *
     * @return The value of the field "sDTMFChar"
     */
    inline const ::fi_basetypes_most::T_String& getSDTMFChar () const;

    /**
     * Retrieves the value of the field "sDTMFChar" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sDTMFChar".
     */
    inline ::fi_basetypes_most::T_String& getSDTMFCharMutable ();

    /**
     * Sets the value of the member "sDTMFChar".
     *
     * Defined as single chracter.  Restrictions of this within 0-9, and *,#, and + needs to be enforced in implementation.
     *
     * @param sDTMFChar The value which will be set
     */
    inline void setSDTMFChar (const ::fi_basetypes_most::T_String& sDTMFChar_);

    static const SendDTMFStart &getDefaultInstance();

private:

    inline void set_has_u16CallInstance ();

    inline void clear_has_u16CallInstance ();

    inline void set_has_sDTMFChar ();

    inline void clear_has_sDTMFChar ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint16 _u16CallInstance;

    ::fi_basetypes_most::T_String _sDTMFChar;

};

/**
 * The result message of the method "SendDTMF"
 * Sends DTMF tones to the network.
 */
class SendDTMFResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SendDTMFResult ();

    /**
     * Copy constructor
     */
    inline  SendDTMFResult (const SendDTMFResult &rhs);

    /**
     * All fields constructor
     */
    inline  SendDTMFResult (uint16 u16CallInstance_, bool bCommandStatus_);

    /**
     * Destructor
     */
    inline virtual  ~SendDTMFResult();

    /**
     * Assignment operator
     */
    inline SendDTMFResult& operator = (const SendDTMFResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SendDTMFResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SendDTMFResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SendDTMFResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SendDTMFResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u16CallInstance"

    static const int kU16CallInstance = 0;

    /**
     * Clears the field "u16CallInstance".
     *
     * The field will be set to its default value. The hasU16CallInstance()
     * method will return false.
     */
    inline void clearU16CallInstance();

    /**
     * Checks whether the field "u16CallInstance" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16CallInstance()). Otherwise it will return false.
     */
    inline bool hasU16CallInstance () const;

    /**
     * Returns the value of the member "u16CallInstance".
     *
     * Instance of one call from multiple call possible.
     *
     * Call Instance FF means all call.  Like HangUp all calls.
     *
     * @return The value of the field "u16CallInstance"
     */
    inline uint16 getU16CallInstance () const;

    /**
     * Sets the value of the member "u16CallInstance".
     *
     * Instance of one call from multiple call possible.
     *
     * Call Instance FF means all call.  Like HangUp all calls.
     *
     * @param u16CallInstance The value which will be set
     */
    inline void setU16CallInstance (uint16 u16CallInstance_);

    // API of field "bCommandStatus"

    static const int kBCommandStatus = 1;

    /**
     * Clears the field "bCommandStatus".
     *
     * The field will be set to its default value. The hasBCommandStatus()
     * method will return false.
     */
    inline void clearBCommandStatus();

    /**
     * Checks whether the field "bCommandStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBCommandStatus()). Otherwise it will return false.
     */
    inline bool hasBCommandStatus () const;

    /**
     * Returns the value of the member "bCommandStatus".
     *
     * Outcome of a command.  True is success.
     *
     * @return The value of the field "bCommandStatus"
     */
    inline bool getBCommandStatus () const;

    /**
     * Sets the value of the member "bCommandStatus".
     *
     * Outcome of a command.  True is success.
     *
     * @param bCommandStatus The value which will be set
     */
    inline void setBCommandStatus (bool bCommandStatus_);

    static const SendDTMFResult &getDefaultInstance();

private:

    inline void set_has_u16CallInstance ();

    inline void clear_has_u16CallInstance ();

    inline void set_has_bCommandStatus ();

    inline void clear_has_bCommandStatus ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint16 _u16CallInstance;

    bool _bCommandStatus;

};

/**
 * The error message of 'SendDTMF'
 */
class SendDTMFErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  SendDTMFErrorStructure ();

    /**
     * Copy constructor
     */
    inline  SendDTMFErrorStructure (const SendDTMFErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  SendDTMFErrorStructure (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline  ~SendDTMFErrorStructure();

    /**
     * Assignment operator
     */
    inline SendDTMFErrorStructure& operator = (const SendDTMFErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SendDTMFErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SendDTMFErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SendDTMFErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SendDTMFErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     * Error codes outlined in MOST standard, e.g.:
     * $01 Syntax error: F Block does not exist,
     * $02 Syntax error: Instance does not exist,
     * $03 Syntax error: Function does not exist,
     * $04 Syntax error: Operations does not exist,etc.
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     * Error codes outlined in MOST standard, e.g.:
     * $01 Syntax error: F Block does not exist,
     * $02 Syntax error: Instance does not exist,
     * $03 Syntax error: Function does not exist,
     * $04 Syntax error: Operations does not exist,etc.
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 1;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     * This is for error code $20, function specific error information.  Allowed range $01 - $BF.
     *
     * The first byte is the enumeration of error codes as follows:
     * 0x01:  ERR_NOT_AVAILABLE
     * 0x02:  ERR_NOSERVICE
     * 0x03:  ERR_NO_CALL
     * 0x04:  ERR_NETWORK_DENY
     * 0x05:  ERR_NO_AUDIO_CHANNEL
     * 0xD8:  ERR_OTHER
     *
     * The 2nd byte, if present, is the CallInstance of the function that generated the error.
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     * This is for error code $20, function specific error information.  Allowed range $01 - $BF.
     *
     * The first byte is the enumeration of error codes as follows:
     * 0x01:  ERR_NOT_AVAILABLE
     * 0x02:  ERR_NOSERVICE
     * 0x03:  ERR_NO_CALL
     * 0x04:  ERR_NETWORK_DENY
     * 0x05:  ERR_NO_AUDIO_CHANNEL
     * 0xD8:  ERR_OTHER
     *
     * The 2nd byte, if present, is the CallInstance of the function that generated the error.
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    static const SendDTMFErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

};

/**
 * The error message of 'SendDTMF'
 */
class SendDTMFError  : public ::asf::core::Payload {
public:

    enum SendDTMFErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  SendDTMFError ();

   /**
     * Copy constructor
     */
    inline  SendDTMFError (const SendDTMFError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~SendDTMFError();

    /**
     * Assigns a new value to this object.
     */
    inline SendDTMFError& operator = (const SendDTMFError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SendDTMFError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SendDTMFError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SendDTMFError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SendDTMFError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline SendDTMFError::SendDTMFErrorField getField () const;

    inline void setField(SendDTMFError::SendDTMFErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "SendDTMFErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "SendDTMFErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const SendDTMFErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline SendDTMFErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline SendDTMFErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (SendDTMFErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "SendDTMFErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const SendDTMFErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const SendDTMFError &getDefaultInstance();

private:

    inline void cloneData (const SendDTMFError& rhs);

    inline void deleteData ();

    SendDTMFErrorField __field;

    union {
        SendDTMFErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "SpeedDial"
 * Dials using data from a specific location from the BT AG device.  Telephone uses ATD (number) command to originate call.
 */
class SpeedDialStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SpeedDialStart ();

    /**
     * Copy constructor
     */
    inline  SpeedDialStart (const SpeedDialStart &rhs);

    /**
     * All fields constructor
     */
    inline  SpeedDialStart (int8 s8MemoryDialParam_);

    /**
     * Destructor
     */
    inline virtual  ~SpeedDialStart();

    /**
     * Assignment operator
     */
    inline SpeedDialStart& operator = (const SpeedDialStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SpeedDialStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SpeedDialStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SpeedDialStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SpeedDialStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "s8MemoryDialParam"

    static const int kS8MemoryDialParam = 0;

    /**
     * Clears the field "s8MemoryDialParam".
     *
     * The field will be set to its default value. The hasS8MemoryDialParam()
     * method will return false.
     */
    inline void clearS8MemoryDialParam();

    /**
     * Checks whether the field "s8MemoryDialParam" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setS8MemoryDialParam()). Otherwise it will return false.
     */
    inline bool hasS8MemoryDialParam () const;

    /**
     * Returns the value of the member "s8MemoryDialParam".
     *
     * digit string designating a favorite call in number
     *
     * @return The value of the field "s8MemoryDialParam"
     */
    inline int8 getS8MemoryDialParam () const;

    /**
     * Sets the value of the member "s8MemoryDialParam".
     *
     * digit string designating a favorite call in number
     *
     * @param s8MemoryDialParam The value which will be set
     */
    inline void setS8MemoryDialParam (int8 s8MemoryDialParam_);

    static const SpeedDialStart &getDefaultInstance();

private:

    inline void set_has_s8MemoryDialParam ();

    inline void clear_has_s8MemoryDialParam ();

    uint32 _has_bits_[ (1 + 31) / 32];

    int8 _s8MemoryDialParam;

};

/**
 * The result message of the method "SpeedDial"
 * Dials using data from a specific location from the BT AG device.  Telephone uses ATD (number) command to originate call.
 */
class SpeedDialResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SpeedDialResult ();

    /**
     * Copy constructor
     */
    inline  SpeedDialResult (const SpeedDialResult &rhs);

    /**
     * All fields constructor
     */
    inline  SpeedDialResult (uint16 u16CallInstance_, ::most_Tel_fi_types::T_e8_TelCallStatus e8CallStatus_, bool bUsingVehicleAudio_);

    /**
     * Destructor
     */
    inline virtual  ~SpeedDialResult();

    /**
     * Assignment operator
     */
    inline SpeedDialResult& operator = (const SpeedDialResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SpeedDialResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SpeedDialResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SpeedDialResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SpeedDialResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u16CallInstance"

    static const int kU16CallInstance = 0;

    /**
     * Clears the field "u16CallInstance".
     *
     * The field will be set to its default value. The hasU16CallInstance()
     * method will return false.
     */
    inline void clearU16CallInstance();

    /**
     * Checks whether the field "u16CallInstance" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16CallInstance()). Otherwise it will return false.
     */
    inline bool hasU16CallInstance () const;

    /**
     * Returns the value of the member "u16CallInstance".
     *
     * Instance of one call from multiple call possible.
     *
     * Call Instance FF means all call.  Like HangUp all calls.
     *
     * @return The value of the field "u16CallInstance"
     */
    inline uint16 getU16CallInstance () const;

    /**
     * Sets the value of the member "u16CallInstance".
     *
     * Instance of one call from multiple call possible.
     *
     * Call Instance FF means all call.  Like HangUp all calls.
     *
     * @param u16CallInstance The value which will be set
     */
    inline void setU16CallInstance (uint16 u16CallInstance_);

    // API of field "e8CallStatus"

    static const int kE8CallStatus = 1;

    /**
     * Clears the field "e8CallStatus".
     *
     * The field will be set to its default value. The hasE8CallStatus()
     * method will return false.
     */
    inline void clearE8CallStatus();

    /**
     * Checks whether the field "e8CallStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8CallStatus()). Otherwise it will return false.
     */
    inline bool hasE8CallStatus () const;

    /**
     * Returns the value of the member "e8CallStatus".
     *
     * Status of a call
     *
     * @return The value of the field "e8CallStatus"
     */
    inline ::most_Tel_fi_types::T_e8_TelCallStatus getE8CallStatus () const;

    /**
     * Sets the value of the member "e8CallStatus".
     *
     * Status of a call
     *
     * @param e8CallStatus The value which will be set
     */
    inline void setE8CallStatus (::most_Tel_fi_types::T_e8_TelCallStatus e8CallStatus_);

    // API of field "bUsingVehicleAudio"

    static const int kBUsingVehicleAudio = 2;

    /**
     * Clears the field "bUsingVehicleAudio".
     *
     * The field will be set to its default value. The hasBUsingVehicleAudio()
     * method will return false.
     */
    inline void clearBUsingVehicleAudio();

    /**
     * Checks whether the field "bUsingVehicleAudio" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBUsingVehicleAudio()). Otherwise it will return false.
     */
    inline bool hasBUsingVehicleAudio () const;

    /**
     * Returns the value of the member "bUsingVehicleAudio".
     *
     * Is the call in handset or in vehicle
     *
     * @return The value of the field "bUsingVehicleAudio"
     */
    inline bool getBUsingVehicleAudio () const;

    /**
     * Sets the value of the member "bUsingVehicleAudio".
     *
     * Is the call in handset or in vehicle
     *
     * @param bUsingVehicleAudio The value which will be set
     */
    inline void setBUsingVehicleAudio (bool bUsingVehicleAudio_);

    static const SpeedDialResult &getDefaultInstance();

private:

    inline void set_has_u16CallInstance ();

    inline void clear_has_u16CallInstance ();

    inline void set_has_e8CallStatus ();

    inline void clear_has_e8CallStatus ();

    inline void set_has_bUsingVehicleAudio ();

    inline void clear_has_bUsingVehicleAudio ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint16 _u16CallInstance;

    ::most_Tel_fi_types::T_e8_TelCallStatus _e8CallStatus;

    bool _bUsingVehicleAudio;

};

/**
 * The error message of 'SpeedDial'
 */
class SpeedDialErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  SpeedDialErrorStructure ();

    /**
     * Copy constructor
     */
    inline  SpeedDialErrorStructure (const SpeedDialErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  SpeedDialErrorStructure (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline  ~SpeedDialErrorStructure();

    /**
     * Assignment operator
     */
    inline SpeedDialErrorStructure& operator = (const SpeedDialErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SpeedDialErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SpeedDialErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SpeedDialErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SpeedDialErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     * Error codes outlined in MOST standard, e.g.:
     * $01 Syntax error: F Block does not exist,
     * $02 Syntax error: Instance does not exist,
     * $03 Syntax error: Function does not exist,
     * $04 Syntax error: Operations does not exist,etc.
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     * Error codes outlined in MOST standard, e.g.:
     * $01 Syntax error: F Block does not exist,
     * $02 Syntax error: Instance does not exist,
     * $03 Syntax error: Function does not exist,
     * $04 Syntax error: Operations does not exist,etc.
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 1;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     * This is for error code $20, function specific error information.  Allowed range $01 - $BF.
     *
     * The first byte is the enumeration of error codes as follows:
     * 0x01:  ERR_NOT_AVAILABLE
     * 0x02:  ERR_NOSERVICE
     * 0x03:  ERR_NO_CALL
     * 0x04:  ERR_NETWORK_DENY
     * 0x05:  ERR_NO_AUDIO_CHANNEL
     * 0xD8:  ERR_OTHER
     *
     * The 2nd byte, if present, is the CallInstance of the function that generated the error.
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     * This is for error code $20, function specific error information.  Allowed range $01 - $BF.
     *
     * The first byte is the enumeration of error codes as follows:
     * 0x01:  ERR_NOT_AVAILABLE
     * 0x02:  ERR_NOSERVICE
     * 0x03:  ERR_NO_CALL
     * 0x04:  ERR_NETWORK_DENY
     * 0x05:  ERR_NO_AUDIO_CHANNEL
     * 0xD8:  ERR_OTHER
     *
     * The 2nd byte, if present, is the CallInstance of the function that generated the error.
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    static const SpeedDialErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

};

/**
 * The error message of 'SpeedDial'
 */
class SpeedDialError  : public ::asf::core::Payload {
public:

    enum SpeedDialErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  SpeedDialError ();

   /**
     * Copy constructor
     */
    inline  SpeedDialError (const SpeedDialError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~SpeedDialError();

    /**
     * Assigns a new value to this object.
     */
    inline SpeedDialError& operator = (const SpeedDialError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SpeedDialError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SpeedDialError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SpeedDialError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SpeedDialError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline SpeedDialError::SpeedDialErrorField getField () const;

    inline void setField(SpeedDialError::SpeedDialErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "SpeedDialErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "SpeedDialErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const SpeedDialErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline SpeedDialErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline SpeedDialErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (SpeedDialErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "SpeedDialErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const SpeedDialErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const SpeedDialError &getDefaultInstance();

private:

    inline void cloneData (const SpeedDialError& rhs);

    inline void deleteData ();

    SpeedDialErrorField __field;

    union {
        SpeedDialErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "SplitCall"
 * Separates (un_merges) call from the conference call and makes it the ACTIVE call, all calls in the conference are put on ON HOLD.
 */
class SplitCallStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SplitCallStart ();

    /**
     * Copy constructor
     */
    inline  SplitCallStart (const SplitCallStart &rhs);

    /**
     * All fields constructor
     */
    inline  SplitCallStart (uint16 u16CallInstance_);

    /**
     * Destructor
     */
    inline virtual  ~SplitCallStart();

    /**
     * Assignment operator
     */
    inline SplitCallStart& operator = (const SplitCallStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SplitCallStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SplitCallStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SplitCallStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SplitCallStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u16CallInstance"

    static const int kU16CallInstance = 0;

    /**
     * Clears the field "u16CallInstance".
     *
     * The field will be set to its default value. The hasU16CallInstance()
     * method will return false.
     */
    inline void clearU16CallInstance();

    /**
     * Checks whether the field "u16CallInstance" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16CallInstance()). Otherwise it will return false.
     */
    inline bool hasU16CallInstance () const;

    /**
     * Returns the value of the member "u16CallInstance".
     *
     * Instance of one call from multiple call possible.
     *
     * Call Instance FF means all call.  Like HangUp all calls.
     *
     * @return The value of the field "u16CallInstance"
     */
    inline uint16 getU16CallInstance () const;

    /**
     * Sets the value of the member "u16CallInstance".
     *
     * Instance of one call from multiple call possible.
     *
     * Call Instance FF means all call.  Like HangUp all calls.
     *
     * @param u16CallInstance The value which will be set
     */
    inline void setU16CallInstance (uint16 u16CallInstance_);

    static const SplitCallStart &getDefaultInstance();

private:

    inline void set_has_u16CallInstance ();

    inline void clear_has_u16CallInstance ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _u16CallInstance;

};

/**
 * The result message of the method "SplitCall"
 * Separates (un_merges) call from the conference call and makes it the ACTIVE call, all calls in the conference are put on ON HOLD.
 */
class SplitCallResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SplitCallResult ();

    /**
     * Copy constructor
     */
    inline  SplitCallResult (const SplitCallResult &rhs);

    /**
     * All fields constructor
     */
    inline  SplitCallResult (::most_Tel_fi_types::T_e8_TelCallStatus e8CallStatus_, bool bUsingVehicleAudio_, uint16 u16CallInstance_);

    /**
     * Destructor
     */
    inline virtual  ~SplitCallResult();

    /**
     * Assignment operator
     */
    inline SplitCallResult& operator = (const SplitCallResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SplitCallResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SplitCallResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SplitCallResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SplitCallResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8CallStatus"

    static const int kE8CallStatus = 0;

    /**
     * Clears the field "e8CallStatus".
     *
     * The field will be set to its default value. The hasE8CallStatus()
     * method will return false.
     */
    inline void clearE8CallStatus();

    /**
     * Checks whether the field "e8CallStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8CallStatus()). Otherwise it will return false.
     */
    inline bool hasE8CallStatus () const;

    /**
     * Returns the value of the member "e8CallStatus".
     *
     * Status of a call
     *
     * @return The value of the field "e8CallStatus"
     */
    inline ::most_Tel_fi_types::T_e8_TelCallStatus getE8CallStatus () const;

    /**
     * Sets the value of the member "e8CallStatus".
     *
     * Status of a call
     *
     * @param e8CallStatus The value which will be set
     */
    inline void setE8CallStatus (::most_Tel_fi_types::T_e8_TelCallStatus e8CallStatus_);

    // API of field "bUsingVehicleAudio"

    static const int kBUsingVehicleAudio = 1;

    /**
     * Clears the field "bUsingVehicleAudio".
     *
     * The field will be set to its default value. The hasBUsingVehicleAudio()
     * method will return false.
     */
    inline void clearBUsingVehicleAudio();

    /**
     * Checks whether the field "bUsingVehicleAudio" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBUsingVehicleAudio()). Otherwise it will return false.
     */
    inline bool hasBUsingVehicleAudio () const;

    /**
     * Returns the value of the member "bUsingVehicleAudio".
     *
     * Is the call in handset or in vehicle
     *
     * @return The value of the field "bUsingVehicleAudio"
     */
    inline bool getBUsingVehicleAudio () const;

    /**
     * Sets the value of the member "bUsingVehicleAudio".
     *
     * Is the call in handset or in vehicle
     *
     * @param bUsingVehicleAudio The value which will be set
     */
    inline void setBUsingVehicleAudio (bool bUsingVehicleAudio_);

    // API of field "u16CallInstance"

    static const int kU16CallInstance = 2;

    /**
     * Clears the field "u16CallInstance".
     *
     * The field will be set to its default value. The hasU16CallInstance()
     * method will return false.
     */
    inline void clearU16CallInstance();

    /**
     * Checks whether the field "u16CallInstance" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16CallInstance()). Otherwise it will return false.
     */
    inline bool hasU16CallInstance () const;

    /**
     * Returns the value of the member "u16CallInstance".
     *
     * Instance of one call from multiple call possible.
     *
     * Call Instance FF means all call.  Like HangUp all calls.
     *
     * @return The value of the field "u16CallInstance"
     */
    inline uint16 getU16CallInstance () const;

    /**
     * Sets the value of the member "u16CallInstance".
     *
     * Instance of one call from multiple call possible.
     *
     * Call Instance FF means all call.  Like HangUp all calls.
     *
     * @param u16CallInstance The value which will be set
     */
    inline void setU16CallInstance (uint16 u16CallInstance_);

    static const SplitCallResult &getDefaultInstance();

private:

    inline void set_has_e8CallStatus ();

    inline void clear_has_e8CallStatus ();

    inline void set_has_bUsingVehicleAudio ();

    inline void clear_has_bUsingVehicleAudio ();

    inline void set_has_u16CallInstance ();

    inline void clear_has_u16CallInstance ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::most_Tel_fi_types::T_e8_TelCallStatus _e8CallStatus;

    bool _bUsingVehicleAudio;

    uint16 _u16CallInstance;

};

/**
 * The error message of 'SplitCall'
 */
class SplitCallErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  SplitCallErrorStructure ();

    /**
     * Copy constructor
     */
    inline  SplitCallErrorStructure (const SplitCallErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  SplitCallErrorStructure (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline  ~SplitCallErrorStructure();

    /**
     * Assignment operator
     */
    inline SplitCallErrorStructure& operator = (const SplitCallErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SplitCallErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SplitCallErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SplitCallErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SplitCallErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     * Error codes outlined in MOST standard, e.g.:
     * $01 Syntax error: F Block does not exist,
     * $02 Syntax error: Instance does not exist,
     * $03 Syntax error: Function does not exist,
     * $04 Syntax error: Operations does not exist,etc.
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     * Error codes outlined in MOST standard, e.g.:
     * $01 Syntax error: F Block does not exist,
     * $02 Syntax error: Instance does not exist,
     * $03 Syntax error: Function does not exist,
     * $04 Syntax error: Operations does not exist,etc.
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 1;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     * This is for error code $20, function specific error information.  Allowed range $01 - $BF.
     *
     * The first byte is the enumeration of error codes as follows:
     * 0x01:  ERR_NOT_AVAILABLE
     * 0x02:  ERR_NOSERVICE
     * 0x03:  ERR_NO_CALL
     * 0x04:  ERR_NETWORK_DENY
     * 0x05:  ERR_NO_AUDIO_CHANNEL
     * 0xD8:  ERR_OTHER
     *
     * The 2nd byte, if present, is the CallInstance of the function that generated the error.
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     * This is for error code $20, function specific error information.  Allowed range $01 - $BF.
     *
     * The first byte is the enumeration of error codes as follows:
     * 0x01:  ERR_NOT_AVAILABLE
     * 0x02:  ERR_NOSERVICE
     * 0x03:  ERR_NO_CALL
     * 0x04:  ERR_NETWORK_DENY
     * 0x05:  ERR_NO_AUDIO_CHANNEL
     * 0xD8:  ERR_OTHER
     *
     * The 2nd byte, if present, is the CallInstance of the function that generated the error.
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    static const SplitCallErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

};

/**
 * The error message of 'SplitCall'
 */
class SplitCallError  : public ::asf::core::Payload {
public:

    enum SplitCallErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  SplitCallError ();

   /**
     * Copy constructor
     */
    inline  SplitCallError (const SplitCallError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~SplitCallError();

    /**
     * Assigns a new value to this object.
     */
    inline SplitCallError& operator = (const SplitCallError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SplitCallError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SplitCallError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SplitCallError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SplitCallError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline SplitCallError::SplitCallErrorField getField () const;

    inline void setField(SplitCallError::SplitCallErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "SplitCallErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "SplitCallErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const SplitCallErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline SplitCallErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline SplitCallErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (SplitCallErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "SplitCallErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const SplitCallErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const SplitCallError &getDefaultInstance();

private:

    inline void cloneData (const SplitCallError& rhs);

    inline void deleteData ();

    SplitCallErrorField __field;

    union {
        SplitCallErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "SwapCall"
 * If there is an ACTIVE ( call 1)  call and a call ON HOLD ( call 2) , calls are exchanged.  After successful execution Call 1 will be ON HOLD and call 2 will be ACTIVE.  Success returns status of ACTIVE call instance.s
 */
class SwapCallStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SwapCallStart ();

    /**
     * Copy constructor
     */
    inline  SwapCallStart (const SwapCallStart &rhs);

    /**
     * All fields constructor
     */
    inline  SwapCallStart (const ::most_Tel_fi_types::T_TelStreamOfCallInstances& oStreamOfCallInstances_);

    /**
     * Destructor
     */
    inline virtual  ~SwapCallStart();

    /**
     * Assignment operator
     */
    inline SwapCallStart& operator = (const SwapCallStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SwapCallStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SwapCallStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SwapCallStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SwapCallStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "oStreamOfCallInstances"

    static const int kOStreamOfCallInstances = 0;

    /**
     * Clears the field "oStreamOfCallInstances".
     *
     * The field will be set to its default value. The hasOStreamOfCallInstances()
     * method will return false.
     */
    inline void clearOStreamOfCallInstances();

    /**
     * Checks whether the field "oStreamOfCallInstances" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOStreamOfCallInstances()). Otherwise it will return false.
     */
    inline bool hasOStreamOfCallInstances () const;

    /**
     * Returns the value of the member "oStreamOfCallInstances".
     *
     * an stream of call instances , in lieu of an array
     *
     * @return The value of the field "oStreamOfCallInstances"
     */
    inline const ::most_Tel_fi_types::T_TelStreamOfCallInstances& getOStreamOfCallInstances () const;

    /**
     * Retrieves the value of the field "oStreamOfCallInstances" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oStreamOfCallInstances".
     */
    inline ::most_Tel_fi_types::T_TelStreamOfCallInstances& getOStreamOfCallInstancesMutable ();

    /**
     * Sets the value of the member "oStreamOfCallInstances".
     *
     * an stream of call instances , in lieu of an array
     *
     * @param oStreamOfCallInstances The value which will be set
     */
    inline void setOStreamOfCallInstances (const ::most_Tel_fi_types::T_TelStreamOfCallInstances& oStreamOfCallInstances_);

    static const SwapCallStart &getDefaultInstance();

private:

    static const ::std::vector< uint16 >& getUint16List_DefaultInstance ();

    inline void set_has_oStreamOfCallInstances ();

    inline void clear_has_oStreamOfCallInstances ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::most_Tel_fi_types::T_TelStreamOfCallInstances _oStreamOfCallInstances;

};

/**
 * The result message of the method "SwapCall"
 * If there is an ACTIVE ( call 1)  call and a call ON HOLD ( call 2) , calls are exchanged.  After successful execution Call 1 will be ON HOLD and call 2 will be ACTIVE.  Success returns status of ACTIVE call instance.s
 */
class SwapCallResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SwapCallResult ();

    /**
     * Copy constructor
     */
    inline  SwapCallResult (const SwapCallResult &rhs);

    /**
     * All fields constructor
     */
    inline  SwapCallResult (uint16 u16CallInstance_, ::most_Tel_fi_types::T_e8_TelCallStatus e8CallStatus_);

    /**
     * Destructor
     */
    inline virtual  ~SwapCallResult();

    /**
     * Assignment operator
     */
    inline SwapCallResult& operator = (const SwapCallResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SwapCallResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SwapCallResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SwapCallResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SwapCallResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u16CallInstance"

    static const int kU16CallInstance = 0;

    /**
     * Clears the field "u16CallInstance".
     *
     * The field will be set to its default value. The hasU16CallInstance()
     * method will return false.
     */
    inline void clearU16CallInstance();

    /**
     * Checks whether the field "u16CallInstance" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16CallInstance()). Otherwise it will return false.
     */
    inline bool hasU16CallInstance () const;

    /**
     * Returns the value of the member "u16CallInstance".
     *
     * Instance of one call from multiple call possible.
     *
     * Call Instance FF means all call.  Like HangUp all calls.
     *
     * @return The value of the field "u16CallInstance"
     */
    inline uint16 getU16CallInstance () const;

    /**
     * Sets the value of the member "u16CallInstance".
     *
     * Instance of one call from multiple call possible.
     *
     * Call Instance FF means all call.  Like HangUp all calls.
     *
     * @param u16CallInstance The value which will be set
     */
    inline void setU16CallInstance (uint16 u16CallInstance_);

    // API of field "e8CallStatus"

    static const int kE8CallStatus = 1;

    /**
     * Clears the field "e8CallStatus".
     *
     * The field will be set to its default value. The hasE8CallStatus()
     * method will return false.
     */
    inline void clearE8CallStatus();

    /**
     * Checks whether the field "e8CallStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8CallStatus()). Otherwise it will return false.
     */
    inline bool hasE8CallStatus () const;

    /**
     * Returns the value of the member "e8CallStatus".
     *
     * Status of a call
     *
     * @return The value of the field "e8CallStatus"
     */
    inline ::most_Tel_fi_types::T_e8_TelCallStatus getE8CallStatus () const;

    /**
     * Sets the value of the member "e8CallStatus".
     *
     * Status of a call
     *
     * @param e8CallStatus The value which will be set
     */
    inline void setE8CallStatus (::most_Tel_fi_types::T_e8_TelCallStatus e8CallStatus_);

    static const SwapCallResult &getDefaultInstance();

private:

    inline void set_has_u16CallInstance ();

    inline void clear_has_u16CallInstance ();

    inline void set_has_e8CallStatus ();

    inline void clear_has_e8CallStatus ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint16 _u16CallInstance;

    ::most_Tel_fi_types::T_e8_TelCallStatus _e8CallStatus;

};

/**
 * The error message of 'SwapCall'
 */
class SwapCallErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  SwapCallErrorStructure ();

    /**
     * Copy constructor
     */
    inline  SwapCallErrorStructure (const SwapCallErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  SwapCallErrorStructure (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline  ~SwapCallErrorStructure();

    /**
     * Assignment operator
     */
    inline SwapCallErrorStructure& operator = (const SwapCallErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SwapCallErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SwapCallErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SwapCallErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SwapCallErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     * Error codes outlined in MOST standard, e.g.:
     * $01 Syntax error: F Block does not exist,
     * $02 Syntax error: Instance does not exist,
     * $03 Syntax error: Function does not exist,
     * $04 Syntax error: Operations does not exist,etc.
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     * Error codes outlined in MOST standard, e.g.:
     * $01 Syntax error: F Block does not exist,
     * $02 Syntax error: Instance does not exist,
     * $03 Syntax error: Function does not exist,
     * $04 Syntax error: Operations does not exist,etc.
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 1;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     * This is for error code $20, function specific error information.  Allowed range $01 - $BF.
     *
     * The first byte is the enumeration of error codes as follows:
     * 0x01:  ERR_NOT_AVAILABLE
     * 0x02:  ERR_NOSERVICE
     * 0x03:  ERR_NO_CALL
     * 0x04:  ERR_NETWORK_DENY
     * 0x05:  ERR_NO_AUDIO_CHANNEL
     * 0xD8:  ERR_OTHER
     *
     * The 2nd byte, if present, is the CallInstance of the function that generated the error.
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     * This is for error code $20, function specific error information.  Allowed range $01 - $BF.
     *
     * The first byte is the enumeration of error codes as follows:
     * 0x01:  ERR_NOT_AVAILABLE
     * 0x02:  ERR_NOSERVICE
     * 0x03:  ERR_NO_CALL
     * 0x04:  ERR_NETWORK_DENY
     * 0x05:  ERR_NO_AUDIO_CHANNEL
     * 0xD8:  ERR_OTHER
     *
     * The 2nd byte, if present, is the CallInstance of the function that generated the error.
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    static const SwapCallErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

};

/**
 * The error message of 'SwapCall'
 */
class SwapCallError  : public ::asf::core::Payload {
public:

    enum SwapCallErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  SwapCallError ();

   /**
     * Copy constructor
     */
    inline  SwapCallError (const SwapCallError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~SwapCallError();

    /**
     * Assigns a new value to this object.
     */
    inline SwapCallError& operator = (const SwapCallError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SwapCallError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SwapCallError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SwapCallError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SwapCallError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline SwapCallError::SwapCallErrorField getField () const;

    inline void setField(SwapCallError::SwapCallErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "SwapCallErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "SwapCallErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const SwapCallErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline SwapCallErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline SwapCallErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (SwapCallErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "SwapCallErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const SwapCallErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const SwapCallError &getDefaultInstance();

private:

    inline void cloneData (const SwapCallError& rhs);

    inline void deleteData ();

    SwapCallErrorField __field;

    union {
        SwapCallErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The error message of 'TransferCallToHandset'
 */
class TransferCallToHandsetErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  TransferCallToHandsetErrorStructure ();

    /**
     * Copy constructor
     */
    inline  TransferCallToHandsetErrorStructure (const TransferCallToHandsetErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  TransferCallToHandsetErrorStructure (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline  ~TransferCallToHandsetErrorStructure();

    /**
     * Assignment operator
     */
    inline TransferCallToHandsetErrorStructure& operator = (const TransferCallToHandsetErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TransferCallToHandsetErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TransferCallToHandsetErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TransferCallToHandsetErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TransferCallToHandsetErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     * Error codes outlined in MOST standard, e.g.:
     * $01 Syntax error: F Block does not exist,
     * $02 Syntax error: Instance does not exist,
     * $03 Syntax error: Function does not exist,
     * $04 Syntax error: Operations does not exist,etc.
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     * Error codes outlined in MOST standard, e.g.:
     * $01 Syntax error: F Block does not exist,
     * $02 Syntax error: Instance does not exist,
     * $03 Syntax error: Function does not exist,
     * $04 Syntax error: Operations does not exist,etc.
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 1;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     * This is for error code $20, function specific error information.  Allowed range $01 - $BF.
     *
     * The first byte is the enumeration of error codes as follows:
     * 0x01:  ERR_NOT_AVAILABLE
     * 0x02:  ERR_NOSERVICE
     * 0x03:  ERR_NO_CALL
     * 0x04:  ERR_NETWORK_DENY
     * 0x05:  ERR_NO_AUDIO_CHANNEL
     * 0xD8:  ERR_OTHER
     *
     * The 2nd byte, if present, is the CallInstance of the function that generated the error.
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     * This is for error code $20, function specific error information.  Allowed range $01 - $BF.
     *
     * The first byte is the enumeration of error codes as follows:
     * 0x01:  ERR_NOT_AVAILABLE
     * 0x02:  ERR_NOSERVICE
     * 0x03:  ERR_NO_CALL
     * 0x04:  ERR_NETWORK_DENY
     * 0x05:  ERR_NO_AUDIO_CHANNEL
     * 0xD8:  ERR_OTHER
     *
     * The 2nd byte, if present, is the CallInstance of the function that generated the error.
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    static const TransferCallToHandsetErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

};

/**
 * The error message of 'TransferCallToHandset'
 */
class TransferCallToHandsetError  : public ::asf::core::Payload {
public:

    enum TransferCallToHandsetErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  TransferCallToHandsetError ();

   /**
     * Copy constructor
     */
    inline  TransferCallToHandsetError (const TransferCallToHandsetError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~TransferCallToHandsetError();

    /**
     * Assigns a new value to this object.
     */
    inline TransferCallToHandsetError& operator = (const TransferCallToHandsetError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TransferCallToHandsetError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TransferCallToHandsetError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TransferCallToHandsetError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TransferCallToHandsetError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline TransferCallToHandsetError::TransferCallToHandsetErrorField getField () const;

    inline void setField(TransferCallToHandsetError::TransferCallToHandsetErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "TransferCallToHandsetErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "TransferCallToHandsetErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const TransferCallToHandsetErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline TransferCallToHandsetErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline TransferCallToHandsetErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (TransferCallToHandsetErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "TransferCallToHandsetErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const TransferCallToHandsetErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const TransferCallToHandsetError &getDefaultInstance();

private:

    inline void cloneData (const TransferCallToHandsetError& rhs);

    inline void deleteData ();

    TransferCallToHandsetErrorField __field;

    union {
        TransferCallToHandsetErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "TransferCallToVehicle"
 * This Method is called by HMI controllers to transfer the call from a particular device to the Vehicle.  The DeviceHandle must be a valid device handle for one of the paired phones within the Bluetooth Settings FBlock.  It may not be the protected 0=Null value.
 */
class TransferCallToVehicleStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  TransferCallToVehicleStart ();

    /**
     * Copy constructor
     */
    inline  TransferCallToVehicleStart (const TransferCallToVehicleStart &rhs);

    /**
     * All fields constructor
     */
    inline  TransferCallToVehicleStart (uint8 u8DeviceHandle_);

    /**
     * Destructor
     */
    inline virtual  ~TransferCallToVehicleStart();

    /**
     * Assignment operator
     */
    inline TransferCallToVehicleStart& operator = (const TransferCallToVehicleStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TransferCallToVehicleStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TransferCallToVehicleStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TransferCallToVehicleStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TransferCallToVehicleStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8DeviceHandle"

    static const int kU8DeviceHandle = 0;

    /**
     * Clears the field "u8DeviceHandle".
     *
     * The field will be set to its default value. The hasU8DeviceHandle()
     * method will return false.
     */
    inline void clearU8DeviceHandle();

    /**
     * Checks whether the field "u8DeviceHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8DeviceHandle()). Otherwise it will return false.
     */
    inline bool hasU8DeviceHandle () const;

    /**
     * Returns the value of the member "u8DeviceHandle".
     *
     * Unique handle for each one of the up to 10 devices that can be paired.  Handles are maintained by BluetoothSettings FBlock.  0 is reserved as Null. Valid handles are 1..10 inclusive.
     *
     * @return The value of the field "u8DeviceHandle"
     */
    inline uint8 getU8DeviceHandle () const;

    /**
     * Sets the value of the member "u8DeviceHandle".
     *
     * Unique handle for each one of the up to 10 devices that can be paired.  Handles are maintained by BluetoothSettings FBlock.  0 is reserved as Null. Valid handles are 1..10 inclusive.
     *
     * @param u8DeviceHandle The value which will be set
     */
    inline void setU8DeviceHandle (uint8 u8DeviceHandle_);

    static const TransferCallToVehicleStart &getDefaultInstance();

private:

    inline void set_has_u8DeviceHandle ();

    inline void clear_has_u8DeviceHandle ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _u8DeviceHandle;

};

/**
 * The result message of the method "TransferCallToVehicle"
 * This Method is called by HMI controllers to transfer the call from a particular device to the Vehicle.  The DeviceHandle must be a valid device handle for one of the paired phones within the Bluetooth Settings FBlock.  It may not be the protected 0=Null value.
 */
class TransferCallToVehicleResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  TransferCallToVehicleResult ();

    /**
     * Copy constructor
     */
    inline  TransferCallToVehicleResult (const TransferCallToVehicleResult &rhs);

    /**
     * All fields constructor
     */
    inline  TransferCallToVehicleResult (bool bUsingVehicleAudio_, uint8 u8DeviceHandle_);

    /**
     * Destructor
     */
    inline virtual  ~TransferCallToVehicleResult();

    /**
     * Assignment operator
     */
    inline TransferCallToVehicleResult& operator = (const TransferCallToVehicleResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TransferCallToVehicleResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TransferCallToVehicleResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TransferCallToVehicleResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TransferCallToVehicleResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bUsingVehicleAudio"

    static const int kBUsingVehicleAudio = 0;

    /**
     * Clears the field "bUsingVehicleAudio".
     *
     * The field will be set to its default value. The hasBUsingVehicleAudio()
     * method will return false.
     */
    inline void clearBUsingVehicleAudio();

    /**
     * Checks whether the field "bUsingVehicleAudio" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBUsingVehicleAudio()). Otherwise it will return false.
     */
    inline bool hasBUsingVehicleAudio () const;

    /**
     * Returns the value of the member "bUsingVehicleAudio".
     *
     * Is the call in handset or in vehicle
     *
     * @return The value of the field "bUsingVehicleAudio"
     */
    inline bool getBUsingVehicleAudio () const;

    /**
     * Sets the value of the member "bUsingVehicleAudio".
     *
     * Is the call in handset or in vehicle
     *
     * @param bUsingVehicleAudio The value which will be set
     */
    inline void setBUsingVehicleAudio (bool bUsingVehicleAudio_);

    // API of field "u8DeviceHandle"

    static const int kU8DeviceHandle = 1;

    /**
     * Clears the field "u8DeviceHandle".
     *
     * The field will be set to its default value. The hasU8DeviceHandle()
     * method will return false.
     */
    inline void clearU8DeviceHandle();

    /**
     * Checks whether the field "u8DeviceHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8DeviceHandle()). Otherwise it will return false.
     */
    inline bool hasU8DeviceHandle () const;

    /**
     * Returns the value of the member "u8DeviceHandle".
     *
     * Unique handle for each one of the up to 10 devices that can be paired.  Handles are maintained by BluetoothSettings FBlock.  0 is reserved as Null. Valid handles are 1..10 inclusive.
     *
     * @return The value of the field "u8DeviceHandle"
     */
    inline uint8 getU8DeviceHandle () const;

    /**
     * Sets the value of the member "u8DeviceHandle".
     *
     * Unique handle for each one of the up to 10 devices that can be paired.  Handles are maintained by BluetoothSettings FBlock.  0 is reserved as Null. Valid handles are 1..10 inclusive.
     *
     * @param u8DeviceHandle The value which will be set
     */
    inline void setU8DeviceHandle (uint8 u8DeviceHandle_);

    static const TransferCallToVehicleResult &getDefaultInstance();

private:

    inline void set_has_bUsingVehicleAudio ();

    inline void clear_has_bUsingVehicleAudio ();

    inline void set_has_u8DeviceHandle ();

    inline void clear_has_u8DeviceHandle ();

    uint32 _has_bits_[ (2 + 31) / 32];

    bool _bUsingVehicleAudio;

    uint8 _u8DeviceHandle;

};

/**
 * The error message of 'TransferCallToVehicle'
 */
class TransferCallToVehicleErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  TransferCallToVehicleErrorStructure ();

    /**
     * Copy constructor
     */
    inline  TransferCallToVehicleErrorStructure (const TransferCallToVehicleErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  TransferCallToVehicleErrorStructure (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_, ::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    /**
     * Destructor
     */
    inline  ~TransferCallToVehicleErrorStructure();

    /**
     * Assignment operator
     */
    inline TransferCallToVehicleErrorStructure& operator = (const TransferCallToVehicleErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TransferCallToVehicleErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TransferCallToVehicleErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TransferCallToVehicleErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TransferCallToVehicleErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 0;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     * This is for error code $20, function specific error information.  Allowed range $01 - $BF.
     *
     * The first byte is the enumeration of error codes as follows:
     * 0x01:  ERR_NOT_AVAILABLE
     * 0x02:  ERR_NOSERVICE
     * 0x03:  ERR_NO_CALL
     * 0x04:  ERR_NETWORK_DENY
     * 0x05:  ERR_NO_AUDIO_CHANNEL
     * 0xD8:  ERR_OTHER
     *
     * The 2nd byte, if present, is the CallInstance of the function that generated the error.
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     * This is for error code $20, function specific error information.  Allowed range $01 - $BF.
     *
     * The first byte is the enumeration of error codes as follows:
     * 0x01:  ERR_NOT_AVAILABLE
     * 0x02:  ERR_NOSERVICE
     * 0x03:  ERR_NO_CALL
     * 0x04:  ERR_NETWORK_DENY
     * 0x05:  ERR_NO_AUDIO_CHANNEL
     * 0xD8:  ERR_OTHER
     *
     * The 2nd byte, if present, is the CallInstance of the function that generated the error.
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 1;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     * Error codes outlined in MOST standard, e.g.:
     * $01 Syntax error: F Block does not exist,
     * $02 Syntax error: Instance does not exist,
     * $03 Syntax error: Function does not exist,
     * $04 Syntax error: Operations does not exist,etc.
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     * Error codes outlined in MOST standard, e.g.:
     * $01 Syntax error: F Block does not exist,
     * $02 Syntax error: Instance does not exist,
     * $03 Syntax error: Function does not exist,
     * $04 Syntax error: Operations does not exist,etc.
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    static const TransferCallToVehicleErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

};

/**
 * The error message of 'TransferCallToVehicle'
 */
class TransferCallToVehicleError  : public ::asf::core::Payload {
public:

    enum TransferCallToVehicleErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  TransferCallToVehicleError ();

   /**
     * Copy constructor
     */
    inline  TransferCallToVehicleError (const TransferCallToVehicleError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~TransferCallToVehicleError();

    /**
     * Assigns a new value to this object.
     */
    inline TransferCallToVehicleError& operator = (const TransferCallToVehicleError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TransferCallToVehicleError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TransferCallToVehicleError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TransferCallToVehicleError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TransferCallToVehicleError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline TransferCallToVehicleError::TransferCallToVehicleErrorField getField () const;

    inline void setField(TransferCallToVehicleError::TransferCallToVehicleErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "TransferCallToVehicleErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "TransferCallToVehicleErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const TransferCallToVehicleErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline TransferCallToVehicleErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline TransferCallToVehicleErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (TransferCallToVehicleErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "TransferCallToVehicleErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const TransferCallToVehicleErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const TransferCallToVehicleError &getDefaultInstance();

private:

    inline void cloneData (const TransferCallToVehicleError& rhs);

    inline void deleteData ();

    TransferCallToVehicleErrorField __field;

    union {
        TransferCallToVehicleErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "VoiceMail"
 * HMI needs to know the voice mail number of the currently connected Phone.
 */
class VoiceMailStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  VoiceMailStart ();

    /**
     * Copy constructor
     */
    inline  VoiceMailStart (const VoiceMailStart &rhs);

    /**
     * All fields constructor
     */
    inline  VoiceMailStart (const ::fi_basetypes_most::T_String& sDeviceName_);

    /**
     * Destructor
     */
    inline virtual  ~VoiceMailStart();

    /**
     * Assignment operator
     */
    inline VoiceMailStart& operator = (const VoiceMailStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const VoiceMailStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const VoiceMailStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const VoiceMailStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const VoiceMailStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "sDeviceName"

    static const int kSDeviceName = 0;

    /**
     * Clears the field "sDeviceName".
     *
     * The field will be set to its default value. The hasSDeviceName()
     * method will return false.
     */
    inline void clearSDeviceName();

    /**
     * Checks whether the field "sDeviceName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSDeviceName()). Otherwise it will return false.
     */
    inline bool hasSDeviceName () const;

    /**
     * Returns the value of the member "sDeviceName".
     *
     * Name of the BT phone
     *
     * @return The value of the field "sDeviceName"
     */
    inline const ::fi_basetypes_most::T_String& getSDeviceName () const;

    /**
     * Retrieves the value of the field "sDeviceName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sDeviceName".
     */
    inline ::fi_basetypes_most::T_String& getSDeviceNameMutable ();

    /**
     * Sets the value of the member "sDeviceName".
     *
     * Name of the BT phone
     *
     * @param sDeviceName The value which will be set
     */
    inline void setSDeviceName (const ::fi_basetypes_most::T_String& sDeviceName_);

    static const VoiceMailStart &getDefaultInstance();

private:

    inline void set_has_sDeviceName ();

    inline void clear_has_sDeviceName ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::fi_basetypes_most::T_String _sDeviceName;

};

/**
 * The result message of the method "VoiceMail"
 * HMI needs to know the voice mail number of the currently connected Phone.
 */
class VoiceMailResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  VoiceMailResult ();

    /**
     * Copy constructor
     */
    inline  VoiceMailResult (const VoiceMailResult &rhs);

    /**
     * All fields constructor
     */
    inline  VoiceMailResult (const ::fi_basetypes_most::T_String& sVoiceMailNumber_);

    /**
     * Destructor
     */
    inline virtual  ~VoiceMailResult();

    /**
     * Assignment operator
     */
    inline VoiceMailResult& operator = (const VoiceMailResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const VoiceMailResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const VoiceMailResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const VoiceMailResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const VoiceMailResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "sVoiceMailNumber"

    static const int kSVoiceMailNumber = 0;

    /**
     * Clears the field "sVoiceMailNumber".
     *
     * The field will be set to its default value. The hasSVoiceMailNumber()
     * method will return false.
     */
    inline void clearSVoiceMailNumber();

    /**
     * Checks whether the field "sVoiceMailNumber" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSVoiceMailNumber()). Otherwise it will return false.
     */
    inline bool hasSVoiceMailNumber () const;

    /**
     * Returns the value of the member "sVoiceMailNumber".
     *
     * Voice mail numberr of the handset
     *
     * @return The value of the field "sVoiceMailNumber"
     */
    inline const ::fi_basetypes_most::T_String& getSVoiceMailNumber () const;

    /**
     * Retrieves the value of the field "sVoiceMailNumber" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sVoiceMailNumber".
     */
    inline ::fi_basetypes_most::T_String& getSVoiceMailNumberMutable ();

    /**
     * Sets the value of the member "sVoiceMailNumber".
     *
     * Voice mail numberr of the handset
     *
     * @param sVoiceMailNumber The value which will be set
     */
    inline void setSVoiceMailNumber (const ::fi_basetypes_most::T_String& sVoiceMailNumber_);

    static const VoiceMailResult &getDefaultInstance();

private:

    inline void set_has_sVoiceMailNumber ();

    inline void clear_has_sVoiceMailNumber ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::fi_basetypes_most::T_String _sVoiceMailNumber;

};

/**
 * The error message of 'VoiceMail'
 */
class VoiceMailErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  VoiceMailErrorStructure ();

    /**
     * Copy constructor
     */
    inline  VoiceMailErrorStructure (const VoiceMailErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  VoiceMailErrorStructure (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline  ~VoiceMailErrorStructure();

    /**
     * Assignment operator
     */
    inline VoiceMailErrorStructure& operator = (const VoiceMailErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const VoiceMailErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const VoiceMailErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const VoiceMailErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const VoiceMailErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     * Error codes outlined in MOST standard, e.g.:
     * $01 Syntax error: F Block does not exist,
     * $02 Syntax error: Instance does not exist,
     * $03 Syntax error: Function does not exist,
     * $04 Syntax error: Operations does not exist,etc.
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     * Error codes outlined in MOST standard, e.g.:
     * $01 Syntax error: F Block does not exist,
     * $02 Syntax error: Instance does not exist,
     * $03 Syntax error: Function does not exist,
     * $04 Syntax error: Operations does not exist,etc.
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 1;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     * This is for error code $20, function specific error information.  Allowed range $01 - $BF.
     *
     * The first byte is the enumeration of error codes as follows:
     * 0x01:  ERR_NOT_AVAILABLE
     * 0x02:  ERR_NOSERVICE
     * 0x03:  ERR_NO_CALL
     * 0x04:  ERR_NETWORK_DENY
     * 0x05:  ERR_NO_AUDIO_CHANNEL
     * 0xD8:  ERR_OTHER
     *
     * The 2nd byte, if present, is the CallInstance of the function that generated the error.
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     * This is for error code $20, function specific error information.  Allowed range $01 - $BF.
     *
     * The first byte is the enumeration of error codes as follows:
     * 0x01:  ERR_NOT_AVAILABLE
     * 0x02:  ERR_NOSERVICE
     * 0x03:  ERR_NO_CALL
     * 0x04:  ERR_NETWORK_DENY
     * 0x05:  ERR_NO_AUDIO_CHANNEL
     * 0xD8:  ERR_OTHER
     *
     * The 2nd byte, if present, is the CallInstance of the function that generated the error.
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    static const VoiceMailErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

};

/**
 * The error message of 'VoiceMail'
 */
class VoiceMailError  : public ::asf::core::Payload {
public:

    enum VoiceMailErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  VoiceMailError ();

   /**
     * Copy constructor
     */
    inline  VoiceMailError (const VoiceMailError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~VoiceMailError();

    /**
     * Assigns a new value to this object.
     */
    inline VoiceMailError& operator = (const VoiceMailError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const VoiceMailError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const VoiceMailError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const VoiceMailError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const VoiceMailError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline VoiceMailError::VoiceMailErrorField getField () const;

    inline void setField(VoiceMailError::VoiceMailErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "VoiceMailErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "VoiceMailErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const VoiceMailErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline VoiceMailErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline VoiceMailErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (VoiceMailErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "VoiceMailErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const VoiceMailErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const VoiceMailError &getDefaultInstance();

private:

    inline void cloneData (const VoiceMailError& rhs);

    inline void deleteData ();

    VoiceMailErrorField __field;

    union {
        VoiceMailErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "Dial"
 * Start an outgoing call.Controllers use the CallInstance parameter
 * in the ResultAck to track the status of the call via
 * CallStatusNotice.Status notifications.
 */
class DialStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DialStart ();

    /**
     * Copy constructor
     */
    inline  DialStart (const DialStart &rhs);

    /**
     * All fields constructor
     */
    inline  DialStart (const ::fi_basetypes_most::T_String& sTelephoneNumber_, ::most_Tel_fi_types::T_e8_TelEchoCancellationNoiseReductionSetting e8EchoCancellationNoiseReductionSetting_);

    /**
     * Destructor
     */
    inline virtual  ~DialStart();

    /**
     * Assignment operator
     */
    inline DialStart& operator = (const DialStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DialStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DialStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DialStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DialStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "sTelephoneNumber"

    static const int kSTelephoneNumber = 0;

    /**
     * Clears the field "sTelephoneNumber".
     *
     * The field will be set to its default value. The hasSTelephoneNumber()
     * method will return false.
     */
    inline void clearSTelephoneNumber();

    /**
     * Checks whether the field "sTelephoneNumber" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSTelephoneNumber()). Otherwise it will return false.
     */
    inline bool hasSTelephoneNumber () const;

    /**
     * Returns the value of the member "sTelephoneNumber".
     *
     * Phone number
     *
     * @return The value of the field "sTelephoneNumber"
     */
    inline const ::fi_basetypes_most::T_String& getSTelephoneNumber () const;

    /**
     * Retrieves the value of the field "sTelephoneNumber" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sTelephoneNumber".
     */
    inline ::fi_basetypes_most::T_String& getSTelephoneNumberMutable ();

    /**
     * Sets the value of the member "sTelephoneNumber".
     *
     * Phone number
     *
     * @param sTelephoneNumber The value which will be set
     */
    inline void setSTelephoneNumber (const ::fi_basetypes_most::T_String& sTelephoneNumber_);

    // API of field "e8EchoCancellationNoiseReductionSetting"

    static const int kE8EchoCancellationNoiseReductionSetting = 1;

    /**
     * Clears the field "e8EchoCancellationNoiseReductionSetting".
     *
     * The field will be set to its default value. The hasE8EchoCancellationNoiseReductionSetting()
     * method will return false.
     */
    inline void clearE8EchoCancellationNoiseReductionSetting();

    /**
     * Checks whether the field "e8EchoCancellationNoiseReductionSetting" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8EchoCancellationNoiseReductionSetting()). Otherwise it will return false.
     */
    inline bool hasE8EchoCancellationNoiseReductionSetting () const;

    /**
     * Returns the value of the member "e8EchoCancellationNoiseReductionSetting".
     *
     * This parameter in Dial () interface, used to set voice or server echo cancellation and noise reduction settings.
     *
     * @return The value of the field "e8EchoCancellationNoiseReductionSetting"
     */
    inline ::most_Tel_fi_types::T_e8_TelEchoCancellationNoiseReductionSetting getE8EchoCancellationNoiseReductionSetting () const;

    /**
     * Sets the value of the member "e8EchoCancellationNoiseReductionSetting".
     *
     * This parameter in Dial () interface, used to set voice or server echo cancellation and noise reduction settings.
     *
     * @param e8EchoCancellationNoiseReductionSetting The value which will be set
     */
    inline void setE8EchoCancellationNoiseReductionSetting (::most_Tel_fi_types::T_e8_TelEchoCancellationNoiseReductionSetting e8EchoCancellationNoiseReductionSetting_);

    static const DialStart &getDefaultInstance();

private:

    inline void set_has_sTelephoneNumber ();

    inline void clear_has_sTelephoneNumber ();

    inline void set_has_e8EchoCancellationNoiseReductionSetting ();

    inline void clear_has_e8EchoCancellationNoiseReductionSetting ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_String _sTelephoneNumber;

    ::most_Tel_fi_types::T_e8_TelEchoCancellationNoiseReductionSetting _e8EchoCancellationNoiseReductionSetting;

};

/**
 * The result message of the method "Dial"
 * Start an outgoing call.Controllers use the CallInstance parameter
 * in the ResultAck to track the status of the call via
 * CallStatusNotice.Status notifications.
 */
class DialResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DialResult ();

    /**
     * Copy constructor
     */
    inline  DialResult (const DialResult &rhs);

    /**
     * All fields constructor
     */
    inline  DialResult (uint16 u16CallInstance_, ::most_Tel_fi_types::T_e8_TelCallStatus e8CallStatus_, bool bUsingVehicleAudio_);

    /**
     * Destructor
     */
    inline virtual  ~DialResult();

    /**
     * Assignment operator
     */
    inline DialResult& operator = (const DialResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DialResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DialResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DialResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DialResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u16CallInstance"

    static const int kU16CallInstance = 0;

    /**
     * Clears the field "u16CallInstance".
     *
     * The field will be set to its default value. The hasU16CallInstance()
     * method will return false.
     */
    inline void clearU16CallInstance();

    /**
     * Checks whether the field "u16CallInstance" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16CallInstance()). Otherwise it will return false.
     */
    inline bool hasU16CallInstance () const;

    /**
     * Returns the value of the member "u16CallInstance".
     *
     * Instance of one call from multiple call possible.
     *
     * Call Instance FF means all call.  Like HangUp all calls.
     *
     * @return The value of the field "u16CallInstance"
     */
    inline uint16 getU16CallInstance () const;

    /**
     * Sets the value of the member "u16CallInstance".
     *
     * Instance of one call from multiple call possible.
     *
     * Call Instance FF means all call.  Like HangUp all calls.
     *
     * @param u16CallInstance The value which will be set
     */
    inline void setU16CallInstance (uint16 u16CallInstance_);

    // API of field "e8CallStatus"

    static const int kE8CallStatus = 1;

    /**
     * Clears the field "e8CallStatus".
     *
     * The field will be set to its default value. The hasE8CallStatus()
     * method will return false.
     */
    inline void clearE8CallStatus();

    /**
     * Checks whether the field "e8CallStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8CallStatus()). Otherwise it will return false.
     */
    inline bool hasE8CallStatus () const;

    /**
     * Returns the value of the member "e8CallStatus".
     *
     * Status of a call
     *
     * @return The value of the field "e8CallStatus"
     */
    inline ::most_Tel_fi_types::T_e8_TelCallStatus getE8CallStatus () const;

    /**
     * Sets the value of the member "e8CallStatus".
     *
     * Status of a call
     *
     * @param e8CallStatus The value which will be set
     */
    inline void setE8CallStatus (::most_Tel_fi_types::T_e8_TelCallStatus e8CallStatus_);

    // API of field "bUsingVehicleAudio"

    static const int kBUsingVehicleAudio = 2;

    /**
     * Clears the field "bUsingVehicleAudio".
     *
     * The field will be set to its default value. The hasBUsingVehicleAudio()
     * method will return false.
     */
    inline void clearBUsingVehicleAudio();

    /**
     * Checks whether the field "bUsingVehicleAudio" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBUsingVehicleAudio()). Otherwise it will return false.
     */
    inline bool hasBUsingVehicleAudio () const;

    /**
     * Returns the value of the member "bUsingVehicleAudio".
     *
     * Is the call in handset or in vehicle
     *
     * @return The value of the field "bUsingVehicleAudio"
     */
    inline bool getBUsingVehicleAudio () const;

    /**
     * Sets the value of the member "bUsingVehicleAudio".
     *
     * Is the call in handset or in vehicle
     *
     * @param bUsingVehicleAudio The value which will be set
     */
    inline void setBUsingVehicleAudio (bool bUsingVehicleAudio_);

    static const DialResult &getDefaultInstance();

private:

    inline void set_has_u16CallInstance ();

    inline void clear_has_u16CallInstance ();

    inline void set_has_e8CallStatus ();

    inline void clear_has_e8CallStatus ();

    inline void set_has_bUsingVehicleAudio ();

    inline void clear_has_bUsingVehicleAudio ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint16 _u16CallInstance;

    ::most_Tel_fi_types::T_e8_TelCallStatus _e8CallStatus;

    bool _bUsingVehicleAudio;

};

/**
 * The error message of 'Dial'
 */
class DialErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  DialErrorStructure ();

    /**
     * Copy constructor
     */
    inline  DialErrorStructure (const DialErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  DialErrorStructure (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline  ~DialErrorStructure();

    /**
     * Assignment operator
     */
    inline DialErrorStructure& operator = (const DialErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DialErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DialErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DialErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DialErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     * Error codes outlined in MOST standard, e.g.:
     * $01 Syntax error: F Block does not exist,
     * $02 Syntax error: Instance does not exist,
     * $03 Syntax error: Function does not exist,
     * $04 Syntax error: Operations does not exist,etc.
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     * Error codes outlined in MOST standard, e.g.:
     * $01 Syntax error: F Block does not exist,
     * $02 Syntax error: Instance does not exist,
     * $03 Syntax error: Function does not exist,
     * $04 Syntax error: Operations does not exist,etc.
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 1;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     * This is for error code $20, function specific error information.  Allowed range $01 - $BF.
     *
     * The first byte is the enumeration of error codes as follows:
     * 0x01:  ERR_NOT_AVAILABLE
     * 0x02:  ERR_NOSERVICE
     * 0x03:  ERR_NO_CALL
     * 0x04:  ERR_NETWORK_DENY
     * 0x05:  ERR_NO_AUDIO_CHANNEL
     * 0xD8:  ERR_OTHER
     *
     * The 2nd byte, if present, is the CallInstance of the function that generated the error.
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     * This is for error code $20, function specific error information.  Allowed range $01 - $BF.
     *
     * The first byte is the enumeration of error codes as follows:
     * 0x01:  ERR_NOT_AVAILABLE
     * 0x02:  ERR_NOSERVICE
     * 0x03:  ERR_NO_CALL
     * 0x04:  ERR_NETWORK_DENY
     * 0x05:  ERR_NO_AUDIO_CHANNEL
     * 0xD8:  ERR_OTHER
     *
     * The 2nd byte, if present, is the CallInstance of the function that generated the error.
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    static const DialErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

};

/**
 * The error message of 'Dial'
 */
class DialError  : public ::asf::core::Payload {
public:

    enum DialErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  DialError ();

   /**
     * Copy constructor
     */
    inline  DialError (const DialError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~DialError();

    /**
     * Assigns a new value to this object.
     */
    inline DialError& operator = (const DialError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DialError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DialError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DialError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DialError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline DialError::DialErrorField getField () const;

    inline void setField(DialError::DialErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "DialErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "DialErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const DialErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline DialErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline DialErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (DialErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "DialErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const DialErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const DialError &getDefaultInstance();

private:

    inline void cloneData (const DialError& rhs);

    inline void deleteData ();

    DialErrorField __field;

    union {
        DialErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "QueryTelephoneNumber"
 * Returns Telephone Number give a call instance.
 */
class QueryTelephoneNumberStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  QueryTelephoneNumberStart ();

    /**
     * Copy constructor
     */
    inline  QueryTelephoneNumberStart (const QueryTelephoneNumberStart &rhs);

    /**
     * All fields constructor
     */
    inline  QueryTelephoneNumberStart (uint16 u16CallInstance_);

    /**
     * Destructor
     */
    inline virtual  ~QueryTelephoneNumberStart();

    /**
     * Assignment operator
     */
    inline QueryTelephoneNumberStart& operator = (const QueryTelephoneNumberStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const QueryTelephoneNumberStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const QueryTelephoneNumberStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const QueryTelephoneNumberStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const QueryTelephoneNumberStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u16CallInstance"

    static const int kU16CallInstance = 0;

    /**
     * Clears the field "u16CallInstance".
     *
     * The field will be set to its default value. The hasU16CallInstance()
     * method will return false.
     */
    inline void clearU16CallInstance();

    /**
     * Checks whether the field "u16CallInstance" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16CallInstance()). Otherwise it will return false.
     */
    inline bool hasU16CallInstance () const;

    /**
     * Returns the value of the member "u16CallInstance".
     *
     * Instance of one call from multiple call possible.
     *
     * Call Instance FF means all call.  Like HangUp all calls.
     *
     * @return The value of the field "u16CallInstance"
     */
    inline uint16 getU16CallInstance () const;

    /**
     * Sets the value of the member "u16CallInstance".
     *
     * Instance of one call from multiple call possible.
     *
     * Call Instance FF means all call.  Like HangUp all calls.
     *
     * @param u16CallInstance The value which will be set
     */
    inline void setU16CallInstance (uint16 u16CallInstance_);

    static const QueryTelephoneNumberStart &getDefaultInstance();

private:

    inline void set_has_u16CallInstance ();

    inline void clear_has_u16CallInstance ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _u16CallInstance;

};

/**
 * The result message of the method "QueryTelephoneNumber"
 * Returns Telephone Number give a call instance.
 */
class QueryTelephoneNumberResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  QueryTelephoneNumberResult ();

    /**
     * Copy constructor
     */
    inline  QueryTelephoneNumberResult (const QueryTelephoneNumberResult &rhs);

    /**
     * All fields constructor
     */
    inline  QueryTelephoneNumberResult (uint16 u16CallInstance_, const ::fi_basetypes_most::T_String& sTelephoneNumber_);

    /**
     * Destructor
     */
    inline virtual  ~QueryTelephoneNumberResult();

    /**
     * Assignment operator
     */
    inline QueryTelephoneNumberResult& operator = (const QueryTelephoneNumberResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const QueryTelephoneNumberResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const QueryTelephoneNumberResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const QueryTelephoneNumberResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const QueryTelephoneNumberResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u16CallInstance"

    static const int kU16CallInstance = 0;

    /**
     * Clears the field "u16CallInstance".
     *
     * The field will be set to its default value. The hasU16CallInstance()
     * method will return false.
     */
    inline void clearU16CallInstance();

    /**
     * Checks whether the field "u16CallInstance" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16CallInstance()). Otherwise it will return false.
     */
    inline bool hasU16CallInstance () const;

    /**
     * Returns the value of the member "u16CallInstance".
     *
     * Instance of one call from multiple call possible.
     * Call Instance FF means all call. Like HangUp all calls.
     *
     * @return The value of the field "u16CallInstance"
     */
    inline uint16 getU16CallInstance () const;

    /**
     * Sets the value of the member "u16CallInstance".
     *
     * Instance of one call from multiple call possible.
     * Call Instance FF means all call. Like HangUp all calls.
     *
     * @param u16CallInstance The value which will be set
     */
    inline void setU16CallInstance (uint16 u16CallInstance_);

    // API of field "sTelephoneNumber"

    static const int kSTelephoneNumber = 1;

    /**
     * Clears the field "sTelephoneNumber".
     *
     * The field will be set to its default value. The hasSTelephoneNumber()
     * method will return false.
     */
    inline void clearSTelephoneNumber();

    /**
     * Checks whether the field "sTelephoneNumber" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSTelephoneNumber()). Otherwise it will return false.
     */
    inline bool hasSTelephoneNumber () const;

    /**
     * Returns the value of the member "sTelephoneNumber".
     *
     * Phone number
     *
     * @return The value of the field "sTelephoneNumber"
     */
    inline const ::fi_basetypes_most::T_String& getSTelephoneNumber () const;

    /**
     * Retrieves the value of the field "sTelephoneNumber" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sTelephoneNumber".
     */
    inline ::fi_basetypes_most::T_String& getSTelephoneNumberMutable ();

    /**
     * Sets the value of the member "sTelephoneNumber".
     *
     * Phone number
     *
     * @param sTelephoneNumber The value which will be set
     */
    inline void setSTelephoneNumber (const ::fi_basetypes_most::T_String& sTelephoneNumber_);

    static const QueryTelephoneNumberResult &getDefaultInstance();

private:

    inline void set_has_u16CallInstance ();

    inline void clear_has_u16CallInstance ();

    inline void set_has_sTelephoneNumber ();

    inline void clear_has_sTelephoneNumber ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint16 _u16CallInstance;

    ::fi_basetypes_most::T_String _sTelephoneNumber;

};

/**
 * The error message of 'QueryTelephoneNumber'
 */
class QueryTelephoneNumberErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  QueryTelephoneNumberErrorStructure ();

    /**
     * Copy constructor
     */
    inline  QueryTelephoneNumberErrorStructure (const QueryTelephoneNumberErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  QueryTelephoneNumberErrorStructure (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline  ~QueryTelephoneNumberErrorStructure();

    /**
     * Assignment operator
     */
    inline QueryTelephoneNumberErrorStructure& operator = (const QueryTelephoneNumberErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const QueryTelephoneNumberErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const QueryTelephoneNumberErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const QueryTelephoneNumberErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const QueryTelephoneNumberErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     * Error codes outlined in MOST standard, e.g.:
     * $01 Syntax error: F Block does not exist,
     * $02 Syntax error: Instance does not exist,
     * $03 Syntax error: Function does not exist,
     * $04 Syntax error: Operations does not exist,etc.
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     * Error codes outlined in MOST standard, e.g.:
     * $01 Syntax error: F Block does not exist,
     * $02 Syntax error: Instance does not exist,
     * $03 Syntax error: Function does not exist,
     * $04 Syntax error: Operations does not exist,etc.
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 1;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     * This is for error code $20, function specific error information.  Allowed range $01 - $BF.
     *
     * The first byte is the enumeration of error codes as follows:
     * 0x01:  ERR_NOT_AVAILABLE
     * 0x02:  ERR_NOSERVICE
     * 0x03:  ERR_NO_CALL
     * 0x04:  ERR_NETWORK_DENY
     * 0x05:  ERR_NO_AUDIO_CHANNEL
     * 0xD8:  ERR_OTHER
     *
     * The 2nd byte, if present, is the CallInstance of the function that generated the error.
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     * This is for error code $20, function specific error information.  Allowed range $01 - $BF.
     *
     * The first byte is the enumeration of error codes as follows:
     * 0x01:  ERR_NOT_AVAILABLE
     * 0x02:  ERR_NOSERVICE
     * 0x03:  ERR_NO_CALL
     * 0x04:  ERR_NETWORK_DENY
     * 0x05:  ERR_NO_AUDIO_CHANNEL
     * 0xD8:  ERR_OTHER
     *
     * The 2nd byte, if present, is the CallInstance of the function that generated the error.
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    static const QueryTelephoneNumberErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

};

/**
 * The error message of 'QueryTelephoneNumber'
 */
class QueryTelephoneNumberError  : public ::asf::core::Payload {
public:

    enum QueryTelephoneNumberErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  QueryTelephoneNumberError ();

   /**
     * Copy constructor
     */
    inline  QueryTelephoneNumberError (const QueryTelephoneNumberError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~QueryTelephoneNumberError();

    /**
     * Assigns a new value to this object.
     */
    inline QueryTelephoneNumberError& operator = (const QueryTelephoneNumberError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const QueryTelephoneNumberError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const QueryTelephoneNumberError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const QueryTelephoneNumberError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const QueryTelephoneNumberError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline QueryTelephoneNumberError::QueryTelephoneNumberErrorField getField () const;

    inline void setField(QueryTelephoneNumberError::QueryTelephoneNumberErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "QueryTelephoneNumberErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "QueryTelephoneNumberErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const QueryTelephoneNumberErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline QueryTelephoneNumberErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline QueryTelephoneNumberErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (QueryTelephoneNumberErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "QueryTelephoneNumberErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const QueryTelephoneNumberErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const QueryTelephoneNumberError &getDefaultInstance();

private:

    inline void cloneData (const QueryTelephoneNumberError& rhs);

    inline void deleteData ();

    QueryTelephoneNumberErrorField __field;

    union {
        QueryTelephoneNumberErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "AcquireTelephoneNumber"
 * The AcquireTelephoneNumber method is defined in order to allow HMI
 * controllers to receive the telephone number of a device as follows:
 *
 *
 * <item>
 * The DeviceHandle parameter in the StartResultAck contains the
 * DeviceHandle of the device for which the telephone number is requested.
 * </item>
 * <item>
 * The telephone number acquired from the device is reported as a string
 * in the TelephoneNumber parameter.
 * </item>
 * <item>
 * If the DeviceHandle is invalid or the telephone number cannot be
 * acquired from the requested device for any reason, the FBlock shall
 * respond with a ResultAck(TelephoneNumber == NULL, zero-length string).
 * HMI controllers can use the NULL TelephoneNumber in order to report to
 * the user that the telephone number could not be acquired
 * </item>
 * <item>
 * Note that the VoiceMail 0x21C function cannot be reliably used to
 * acquire the device telephone number because the user can change their
 * voice mail number to another seqence. AcquireTelephoneNumber returns,
 * if successful, the telephone number of the device.
 * </item>
 * <item>
 * This method is used, for example, to allow the HMI to automatically
 * send a text message to the outgoing source device with the ValetMode
 * PIN. However, in order to do this, the HMI needs the telephone number
 * of the device.
 * </item>
 */
class AcquireTelephoneNumberStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AcquireTelephoneNumberStart ();

    /**
     * Copy constructor
     */
    inline  AcquireTelephoneNumberStart (const AcquireTelephoneNumberStart &rhs);

    /**
     * All fields constructor
     */
    inline  AcquireTelephoneNumberStart (uint8 u8DeviceHandle_);

    /**
     * Destructor
     */
    inline virtual  ~AcquireTelephoneNumberStart();

    /**
     * Assignment operator
     */
    inline AcquireTelephoneNumberStart& operator = (const AcquireTelephoneNumberStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AcquireTelephoneNumberStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AcquireTelephoneNumberStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AcquireTelephoneNumberStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AcquireTelephoneNumberStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8DeviceHandle"

    static const int kU8DeviceHandle = 0;

    /**
     * Clears the field "u8DeviceHandle".
     *
     * The field will be set to its default value. The hasU8DeviceHandle()
     * method will return false.
     */
    inline void clearU8DeviceHandle();

    /**
     * Checks whether the field "u8DeviceHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8DeviceHandle()). Otherwise it will return false.
     */
    inline bool hasU8DeviceHandle () const;

    /**
     * Returns the value of the member "u8DeviceHandle".
     *
     * Unique handle for each one of the up to 10 devices that can be paired.  Handles are maintained by BluetoothSettings FBlock.  0 is reserved as Null. Valid handles are 1..10 inclusive.
     *
     * @return The value of the field "u8DeviceHandle"
     */
    inline uint8 getU8DeviceHandle () const;

    /**
     * Sets the value of the member "u8DeviceHandle".
     *
     * Unique handle for each one of the up to 10 devices that can be paired.  Handles are maintained by BluetoothSettings FBlock.  0 is reserved as Null. Valid handles are 1..10 inclusive.
     *
     * @param u8DeviceHandle The value which will be set
     */
    inline void setU8DeviceHandle (uint8 u8DeviceHandle_);

    static const AcquireTelephoneNumberStart &getDefaultInstance();

private:

    inline void set_has_u8DeviceHandle ();

    inline void clear_has_u8DeviceHandle ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _u8DeviceHandle;

};

/**
 * The result message of the method "AcquireTelephoneNumber"
 * The AcquireTelephoneNumber method is defined in order to allow HMI
 * controllers to receive the telephone number of a device as follows:
 *
 *
 * <item>
 * The DeviceHandle parameter in the StartResultAck contains the
 * DeviceHandle of the device for which the telephone number is requested.
 * </item>
 * <item>
 * The telephone number acquired from the device is reported as a string
 * in the TelephoneNumber parameter.
 * </item>
 * <item>
 * If the DeviceHandle is invalid or the telephone number cannot be
 * acquired from the requested device for any reason, the FBlock shall
 * respond with a ResultAck(TelephoneNumber == NULL, zero-length string).
 * HMI controllers can use the NULL TelephoneNumber in order to report to
 * the user that the telephone number could not be acquired
 * </item>
 * <item>
 * Note that the VoiceMail 0x21C function cannot be reliably used to
 * acquire the device telephone number because the user can change their
 * voice mail number to another seqence. AcquireTelephoneNumber returns,
 * if successful, the telephone number of the device.
 * </item>
 * <item>
 * This method is used, for example, to allow the HMI to automatically
 * send a text message to the outgoing source device with the ValetMode
 * PIN. However, in order to do this, the HMI needs the telephone number
 * of the device.
 * </item>
 */
class AcquireTelephoneNumberResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AcquireTelephoneNumberResult ();

    /**
     * Copy constructor
     */
    inline  AcquireTelephoneNumberResult (const AcquireTelephoneNumberResult &rhs);

    /**
     * All fields constructor
     */
    inline  AcquireTelephoneNumberResult (const ::fi_basetypes_most::T_String& sTelephoneNumber_);

    /**
     * Destructor
     */
    inline virtual  ~AcquireTelephoneNumberResult();

    /**
     * Assignment operator
     */
    inline AcquireTelephoneNumberResult& operator = (const AcquireTelephoneNumberResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AcquireTelephoneNumberResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AcquireTelephoneNumberResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AcquireTelephoneNumberResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AcquireTelephoneNumberResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "sTelephoneNumber"

    static const int kSTelephoneNumber = 0;

    /**
     * Clears the field "sTelephoneNumber".
     *
     * The field will be set to its default value. The hasSTelephoneNumber()
     * method will return false.
     */
    inline void clearSTelephoneNumber();

    /**
     * Checks whether the field "sTelephoneNumber" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSTelephoneNumber()). Otherwise it will return false.
     */
    inline bool hasSTelephoneNumber () const;

    /**
     * Returns the value of the member "sTelephoneNumber".
     *
     * Phone number
     *
     * @return The value of the field "sTelephoneNumber"
     */
    inline const ::fi_basetypes_most::T_String& getSTelephoneNumber () const;

    /**
     * Retrieves the value of the field "sTelephoneNumber" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sTelephoneNumber".
     */
    inline ::fi_basetypes_most::T_String& getSTelephoneNumberMutable ();

    /**
     * Sets the value of the member "sTelephoneNumber".
     *
     * Phone number
     *
     * @param sTelephoneNumber The value which will be set
     */
    inline void setSTelephoneNumber (const ::fi_basetypes_most::T_String& sTelephoneNumber_);

    static const AcquireTelephoneNumberResult &getDefaultInstance();

private:

    inline void set_has_sTelephoneNumber ();

    inline void clear_has_sTelephoneNumber ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::fi_basetypes_most::T_String _sTelephoneNumber;

};

/**
 * The error message of 'AcquireTelephoneNumber'
 */
class AcquireTelephoneNumberErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  AcquireTelephoneNumberErrorStructure ();

    /**
     * Copy constructor
     */
    inline  AcquireTelephoneNumberErrorStructure (const AcquireTelephoneNumberErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  AcquireTelephoneNumberErrorStructure (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline  ~AcquireTelephoneNumberErrorStructure();

    /**
     * Assignment operator
     */
    inline AcquireTelephoneNumberErrorStructure& operator = (const AcquireTelephoneNumberErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AcquireTelephoneNumberErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AcquireTelephoneNumberErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AcquireTelephoneNumberErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AcquireTelephoneNumberErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     * Error codes outlined in MOST standard, e.g.:
     * $01 Syntax error: F Block does not exist,
     * $02 Syntax error: Instance does not exist,
     * $03 Syntax error: Function does not exist,
     * $04 Syntax error: Operations does not exist,etc.
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     * Error codes outlined in MOST standard, e.g.:
     * $01 Syntax error: F Block does not exist,
     * $02 Syntax error: Instance does not exist,
     * $03 Syntax error: Function does not exist,
     * $04 Syntax error: Operations does not exist,etc.
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 1;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     * This is for error code $20, function specific error information.  Allowed range $01 - $BF.
     *
     * The first byte is the enumeration of error codes as follows:
     * 0x01:  ERR_NOT_AVAILABLE
     * 0x02:  ERR_NOSERVICE
     * 0x03:  ERR_NO_CALL
     * 0x04:  ERR_NETWORK_DENY
     * 0x05:  ERR_NO_AUDIO_CHANNEL
     * 0xD8:  ERR_OTHER
     *
     * The 2nd byte, if present, is the CallInstance of the function that generated the error.
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     * This is for error code $20, function specific error information.  Allowed range $01 - $BF.
     *
     * The first byte is the enumeration of error codes as follows:
     * 0x01:  ERR_NOT_AVAILABLE
     * 0x02:  ERR_NOSERVICE
     * 0x03:  ERR_NO_CALL
     * 0x04:  ERR_NETWORK_DENY
     * 0x05:  ERR_NO_AUDIO_CHANNEL
     * 0xD8:  ERR_OTHER
     *
     * The 2nd byte, if present, is the CallInstance of the function that generated the error.
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    static const AcquireTelephoneNumberErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

};

/**
 * The error message of 'AcquireTelephoneNumber'
 */
class AcquireTelephoneNumberError  : public ::asf::core::Payload {
public:

    enum AcquireTelephoneNumberErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  AcquireTelephoneNumberError ();

   /**
     * Copy constructor
     */
    inline  AcquireTelephoneNumberError (const AcquireTelephoneNumberError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~AcquireTelephoneNumberError();

    /**
     * Assigns a new value to this object.
     */
    inline AcquireTelephoneNumberError& operator = (const AcquireTelephoneNumberError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AcquireTelephoneNumberError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AcquireTelephoneNumberError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AcquireTelephoneNumberError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AcquireTelephoneNumberError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline AcquireTelephoneNumberError::AcquireTelephoneNumberErrorField getField () const;

    inline void setField(AcquireTelephoneNumberError::AcquireTelephoneNumberErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "AcquireTelephoneNumberErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "AcquireTelephoneNumberErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const AcquireTelephoneNumberErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline AcquireTelephoneNumberErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline AcquireTelephoneNumberErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (AcquireTelephoneNumberErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "AcquireTelephoneNumberErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const AcquireTelephoneNumberErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const AcquireTelephoneNumberError &getDefaultInstance();

private:

    inline void cloneData (const AcquireTelephoneNumberError& rhs);

    inline void deleteData ();

    AcquireTelephoneNumberErrorField __field;

    union {
        AcquireTelephoneNumberErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "Redial"
 * deprecated
 * As of V4.3, this function is permanently deprecated and will not be supported by the Telephone FBlock by any device for the life of Next-Gen Infotainment architecture.
 *
 * For documentation purposes, this is the description from the last revision, 3.0.
 *
 * Redials the last dialed in the currently selected outgoing call device.
 * Note that this function relies on the device to choose the last dialed
 * number in that device.Controllers use the CallInstance parameter
 * in the ResultAck to track the status of the call via
 * CallStatusNotice.Status notifications.
 */
class RedialStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RedialStart ();

    /**
     * Copy constructor
     */
    inline  RedialStart (const RedialStart &rhs);

    /**
     * All fields constructor
     */
    inline  RedialStart (::most_Tel_fi_types::T_e8_TelEchoCancellationNoiseReductionSetting e8EchoCancellationNoiseReductionSetting_);

    /**
     * Destructor
     */
    inline virtual  ~RedialStart();

    /**
     * Assignment operator
     */
    inline RedialStart& operator = (const RedialStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RedialStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RedialStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RedialStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RedialStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8EchoCancellationNoiseReductionSetting"

    static const int kE8EchoCancellationNoiseReductionSetting = 0;

    /**
     * Clears the field "e8EchoCancellationNoiseReductionSetting".
     *
     * The field will be set to its default value. The hasE8EchoCancellationNoiseReductionSetting()
     * method will return false.
     */
    inline void clearE8EchoCancellationNoiseReductionSetting();

    /**
     * Checks whether the field "e8EchoCancellationNoiseReductionSetting" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8EchoCancellationNoiseReductionSetting()). Otherwise it will return false.
     */
    inline bool hasE8EchoCancellationNoiseReductionSetting () const;

    /**
     * Returns the value of the member "e8EchoCancellationNoiseReductionSetting".
     *
     * This parameter in Dial () interface, used to set voice or server echo cancellation and noise reduction settings.
     *
     * @return The value of the field "e8EchoCancellationNoiseReductionSetting"
     */
    inline ::most_Tel_fi_types::T_e8_TelEchoCancellationNoiseReductionSetting getE8EchoCancellationNoiseReductionSetting () const;

    /**
     * Sets the value of the member "e8EchoCancellationNoiseReductionSetting".
     *
     * This parameter in Dial () interface, used to set voice or server echo cancellation and noise reduction settings.
     *
     * @param e8EchoCancellationNoiseReductionSetting The value which will be set
     */
    inline void setE8EchoCancellationNoiseReductionSetting (::most_Tel_fi_types::T_e8_TelEchoCancellationNoiseReductionSetting e8EchoCancellationNoiseReductionSetting_);

    static const RedialStart &getDefaultInstance();

private:

    inline void set_has_e8EchoCancellationNoiseReductionSetting ();

    inline void clear_has_e8EchoCancellationNoiseReductionSetting ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::most_Tel_fi_types::T_e8_TelEchoCancellationNoiseReductionSetting _e8EchoCancellationNoiseReductionSetting;

};

/**
 * The result message of the method "Redial"
 * deprecated
 * As of V4.3, this function is permanently deprecated and will not be supported by the Telephone FBlock by any device for the life of Next-Gen Infotainment architecture.
 *
 * For documentation purposes, this is the description from the last revision, 3.0.
 *
 * Redials the last dialed in the currently selected outgoing call device.
 * Note that this function relies on the device to choose the last dialed
 * number in that device.Controllers use the CallInstance parameter
 * in the ResultAck to track the status of the call via
 * CallStatusNotice.Status notifications.
 */
class RedialResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RedialResult ();

    /**
     * Copy constructor
     */
    inline  RedialResult (const RedialResult &rhs);

    /**
     * All fields constructor
     */
    inline  RedialResult (uint16 u16CallInstance_, ::most_Tel_fi_types::T_e8_TelCallStatus e8CallStatus_, bool bUsingVehicleAudio_);

    /**
     * Destructor
     */
    inline virtual  ~RedialResult();

    /**
     * Assignment operator
     */
    inline RedialResult& operator = (const RedialResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RedialResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RedialResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RedialResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RedialResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u16CallInstance"

    static const int kU16CallInstance = 0;

    /**
     * Clears the field "u16CallInstance".
     *
     * The field will be set to its default value. The hasU16CallInstance()
     * method will return false.
     */
    inline void clearU16CallInstance();

    /**
     * Checks whether the field "u16CallInstance" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16CallInstance()). Otherwise it will return false.
     */
    inline bool hasU16CallInstance () const;

    /**
     * Returns the value of the member "u16CallInstance".
     *
     * Instance of one call from multiple call possible.
     * Call Instance FF means all call. Like HangUp all calls.
     *
     * @return The value of the field "u16CallInstance"
     */
    inline uint16 getU16CallInstance () const;

    /**
     * Sets the value of the member "u16CallInstance".
     *
     * Instance of one call from multiple call possible.
     * Call Instance FF means all call. Like HangUp all calls.
     *
     * @param u16CallInstance The value which will be set
     */
    inline void setU16CallInstance (uint16 u16CallInstance_);

    // API of field "e8CallStatus"

    static const int kE8CallStatus = 1;

    /**
     * Clears the field "e8CallStatus".
     *
     * The field will be set to its default value. The hasE8CallStatus()
     * method will return false.
     */
    inline void clearE8CallStatus();

    /**
     * Checks whether the field "e8CallStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8CallStatus()). Otherwise it will return false.
     */
    inline bool hasE8CallStatus () const;

    /**
     * Returns the value of the member "e8CallStatus".
     *
     * Status of a call
     *
     * @return The value of the field "e8CallStatus"
     */
    inline ::most_Tel_fi_types::T_e8_TelCallStatus getE8CallStatus () const;

    /**
     * Sets the value of the member "e8CallStatus".
     *
     * Status of a call
     *
     * @param e8CallStatus The value which will be set
     */
    inline void setE8CallStatus (::most_Tel_fi_types::T_e8_TelCallStatus e8CallStatus_);

    // API of field "bUsingVehicleAudio"

    static const int kBUsingVehicleAudio = 2;

    /**
     * Clears the field "bUsingVehicleAudio".
     *
     * The field will be set to its default value. The hasBUsingVehicleAudio()
     * method will return false.
     */
    inline void clearBUsingVehicleAudio();

    /**
     * Checks whether the field "bUsingVehicleAudio" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBUsingVehicleAudio()). Otherwise it will return false.
     */
    inline bool hasBUsingVehicleAudio () const;

    /**
     * Returns the value of the member "bUsingVehicleAudio".
     *
     * Is the call in handset or in vehicle
     *
     * @return The value of the field "bUsingVehicleAudio"
     */
    inline bool getBUsingVehicleAudio () const;

    /**
     * Sets the value of the member "bUsingVehicleAudio".
     *
     * Is the call in handset or in vehicle
     *
     * @param bUsingVehicleAudio The value which will be set
     */
    inline void setBUsingVehicleAudio (bool bUsingVehicleAudio_);

    static const RedialResult &getDefaultInstance();

private:

    inline void set_has_u16CallInstance ();

    inline void clear_has_u16CallInstance ();

    inline void set_has_e8CallStatus ();

    inline void clear_has_e8CallStatus ();

    inline void set_has_bUsingVehicleAudio ();

    inline void clear_has_bUsingVehicleAudio ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint16 _u16CallInstance;

    ::most_Tel_fi_types::T_e8_TelCallStatus _e8CallStatus;

    bool _bUsingVehicleAudio;

};

/**
 * The error message of 'Redial'
 */
class RedialErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  RedialErrorStructure ();

    /**
     * Copy constructor
     */
    inline  RedialErrorStructure (const RedialErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  RedialErrorStructure (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline  ~RedialErrorStructure();

    /**
     * Assignment operator
     */
    inline RedialErrorStructure& operator = (const RedialErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RedialErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RedialErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RedialErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RedialErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     * Error codes outlined in MOST standard, e.g.:
     * $01 Syntax error: F Block does not exist,
     * $02 Syntax error: Instance does not exist,
     * $03 Syntax error: Function does not exist,
     * $04 Syntax error: Operations does not exist,etc.
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     * Error codes outlined in MOST standard, e.g.:
     * $01 Syntax error: F Block does not exist,
     * $02 Syntax error: Instance does not exist,
     * $03 Syntax error: Function does not exist,
     * $04 Syntax error: Operations does not exist,etc.
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 1;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     * This is for error code $20, function specific error information.  Allowed range $01 - $BF.
     *
     * The first byte is the enumeration of error codes as follows:
     * 0x01:  ERR_NOT_AVAILABLE
     * 0x02:  ERR_NOSERVICE
     * 0x03:  ERR_NO_CALL
     * 0x04:  ERR_NETWORK_DENY
     * 0x05:  ERR_NO_AUDIO_CHANNEL
     * 0xD8:  ERR_OTHER
     *
     * The 2nd byte, if present, is the CallInstance of the function that generated the error.
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     * This is for error code $20, function specific error information.  Allowed range $01 - $BF.
     *
     * The first byte is the enumeration of error codes as follows:
     * 0x01:  ERR_NOT_AVAILABLE
     * 0x02:  ERR_NOSERVICE
     * 0x03:  ERR_NO_CALL
     * 0x04:  ERR_NETWORK_DENY
     * 0x05:  ERR_NO_AUDIO_CHANNEL
     * 0xD8:  ERR_OTHER
     *
     * The 2nd byte, if present, is the CallInstance of the function that generated the error.
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    static const RedialErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

};

/**
 * The error message of 'Redial'
 */
class RedialError  : public ::asf::core::Payload {
public:

    enum RedialErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  RedialError ();

   /**
     * Copy constructor
     */
    inline  RedialError (const RedialError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~RedialError();

    /**
     * Assigns a new value to this object.
     */
    inline RedialError& operator = (const RedialError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RedialError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RedialError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RedialError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RedialError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline RedialError::RedialErrorField getField () const;

    inline void setField(RedialError::RedialErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "RedialErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "RedialErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const RedialErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline RedialErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline RedialErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (RedialErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "RedialErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const RedialErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const RedialError &getDefaultInstance();

private:

    inline void cloneData (const RedialError& rhs);

    inline void deleteData ();

    RedialErrorField __field;

    union {
        RedialErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "SetRingtone"
 * Set the active ringtone for system wide or device specific.
 * If the DeviceAddress string is ALL, then the received RingtoneID is set for all the paired devices
 * treating it as a system wide ringtone. The setting will be applicable also for the devices that are
 * paired after the API is invoked.
 *
 * The updated system wide ringtone will be available in the SystemWideRingtonesList property.
 * The updated device specific ringtone will be available in the DeviceRingtoneList property.
 *
 * Note: - The setting will be retained persistently by Phone F-Block
 */
class SetRingtoneStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetRingtoneStart ();

    /**
     * Copy constructor
     */
    inline  SetRingtoneStart (const SetRingtoneStart &rhs);

    /**
     * All fields constructor
     */
    inline  SetRingtoneStart (const ::fi_basetypes_most::T_String& sBdAddress_, uint8 u8RingtoneID_);

    /**
     * Destructor
     */
    inline virtual  ~SetRingtoneStart();

    /**
     * Assignment operator
     */
    inline SetRingtoneStart& operator = (const SetRingtoneStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetRingtoneStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetRingtoneStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetRingtoneStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetRingtoneStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "sBdAddress"

    static const int kSBdAddress = 0;

    /**
     * Clears the field "sBdAddress".
     *
     * The field will be set to its default value. The hasSBdAddress()
     * method will return false.
     */
    inline void clearSBdAddress();

    /**
     * Checks whether the field "sBdAddress" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSBdAddress()). Otherwise it will return false.
     */
    inline bool hasSBdAddress () const;

    /**
     * Returns the value of the member "sBdAddress".
     *
     * Bluetooth device address.
     *
     * @return The value of the field "sBdAddress"
     */
    inline const ::fi_basetypes_most::T_String& getSBdAddress () const;

    /**
     * Retrieves the value of the field "sBdAddress" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sBdAddress".
     */
    inline ::fi_basetypes_most::T_String& getSBdAddressMutable ();

    /**
     * Sets the value of the member "sBdAddress".
     *
     * Bluetooth device address.
     *
     * @param sBdAddress The value which will be set
     */
    inline void setSBdAddress (const ::fi_basetypes_most::T_String& sBdAddress_);

    // API of field "u8RingtoneID"

    static const int kU8RingtoneID = 1;

    /**
     * Clears the field "u8RingtoneID".
     *
     * The field will be set to its default value. The hasU8RingtoneID()
     * method will return false.
     */
    inline void clearU8RingtoneID();

    /**
     * Checks whether the field "u8RingtoneID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8RingtoneID()). Otherwise it will return false.
     */
    inline bool hasU8RingtoneID () const;

    /**
     * Returns the value of the member "u8RingtoneID".
     *
     * The unique ID for each ringtone available.
     *
     * @return The value of the field "u8RingtoneID"
     */
    inline uint8 getU8RingtoneID () const;

    /**
     * Sets the value of the member "u8RingtoneID".
     *
     * The unique ID for each ringtone available.
     *
     * @param u8RingtoneID The value which will be set
     */
    inline void setU8RingtoneID (uint8 u8RingtoneID_);

    static const SetRingtoneStart &getDefaultInstance();

private:

    inline void set_has_sBdAddress ();

    inline void clear_has_sBdAddress ();

    inline void set_has_u8RingtoneID ();

    inline void clear_has_u8RingtoneID ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_String _sBdAddress;

    uint8 _u8RingtoneID;

};

/**
 * The error message of 'SetRingtone'
 */
class SetRingtoneErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  SetRingtoneErrorStructure ();

    /**
     * Copy constructor
     */
    inline  SetRingtoneErrorStructure (const SetRingtoneErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  SetRingtoneErrorStructure (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline  ~SetRingtoneErrorStructure();

    /**
     * Assignment operator
     */
    inline SetRingtoneErrorStructure& operator = (const SetRingtoneErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetRingtoneErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetRingtoneErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetRingtoneErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetRingtoneErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     * MOST Default ErrorCode.
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     * MOST Default ErrorCode.
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 1;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     * MOST Default ErrorInfo.
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     * MOST Default ErrorInfo.
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    static const SetRingtoneErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

};

/**
 * The error message of 'SetRingtone'
 */
class SetRingtoneError  : public ::asf::core::Payload {
public:

    enum SetRingtoneErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  SetRingtoneError ();

   /**
     * Copy constructor
     */
    inline  SetRingtoneError (const SetRingtoneError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~SetRingtoneError();

    /**
     * Assigns a new value to this object.
     */
    inline SetRingtoneError& operator = (const SetRingtoneError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetRingtoneError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetRingtoneError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetRingtoneError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetRingtoneError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline SetRingtoneError::SetRingtoneErrorField getField () const;

    inline void setField(SetRingtoneError::SetRingtoneErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "SetRingtoneErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "SetRingtoneErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const SetRingtoneErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline SetRingtoneErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline SetRingtoneErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (SetRingtoneErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "SetRingtoneErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const SetRingtoneErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const SetRingtoneError &getDefaultInstance();

private:

    inline void cloneData (const SetRingtoneError& rhs);

    inline void deleteData ();

    SetRingtoneErrorField __field;

    union {
        SetRingtoneErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "PlayRingtone"
 * Plays the selected ringtone.
 */
class PlayRingtoneStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  PlayRingtoneStart ();

    /**
     * Copy constructor
     */
    inline  PlayRingtoneStart (const PlayRingtoneStart &rhs);

    /**
     * All fields constructor
     */
    inline  PlayRingtoneStart (uint8 u8RingtoneID_, uint8 u8PlayCount_);

    /**
     * Destructor
     */
    inline virtual  ~PlayRingtoneStart();

    /**
     * Assignment operator
     */
    inline PlayRingtoneStart& operator = (const PlayRingtoneStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PlayRingtoneStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PlayRingtoneStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PlayRingtoneStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PlayRingtoneStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8RingtoneID"

    static const int kU8RingtoneID = 0;

    /**
     * Clears the field "u8RingtoneID".
     *
     * The field will be set to its default value. The hasU8RingtoneID()
     * method will return false.
     */
    inline void clearU8RingtoneID();

    /**
     * Checks whether the field "u8RingtoneID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8RingtoneID()). Otherwise it will return false.
     */
    inline bool hasU8RingtoneID () const;

    /**
     * Returns the value of the member "u8RingtoneID".
     *
     * The unique ID for each ringtone available.
     *
     * @return The value of the field "u8RingtoneID"
     */
    inline uint8 getU8RingtoneID () const;

    /**
     * Sets the value of the member "u8RingtoneID".
     *
     * The unique ID for each ringtone available.
     *
     * @param u8RingtoneID The value which will be set
     */
    inline void setU8RingtoneID (uint8 u8RingtoneID_);

    // API of field "u8PlayCount"

    static const int kU8PlayCount = 1;

    /**
     * Clears the field "u8PlayCount".
     *
     * The field will be set to its default value. The hasU8PlayCount()
     * method will return false.
     */
    inline void clearU8PlayCount();

    /**
     * Checks whether the field "u8PlayCount" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8PlayCount()). Otherwise it will return false.
     */
    inline bool hasU8PlayCount () const;

    /**
     * Returns the value of the member "u8PlayCount".
     *
     * Denotes the number of times the file has to be played. When the value is set to FF, the ringtone will be played continuously.
     *
     * @return The value of the field "u8PlayCount"
     */
    inline uint8 getU8PlayCount () const;

    /**
     * Sets the value of the member "u8PlayCount".
     *
     * Denotes the number of times the file has to be played. When the value is set to FF, the ringtone will be played continuously.
     *
     * @param u8PlayCount The value which will be set
     */
    inline void setU8PlayCount (uint8 u8PlayCount_);

    static const PlayRingtoneStart &getDefaultInstance();

private:

    inline void set_has_u8RingtoneID ();

    inline void clear_has_u8RingtoneID ();

    inline void set_has_u8PlayCount ();

    inline void clear_has_u8PlayCount ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint8 _u8RingtoneID;

    uint8 _u8PlayCount;

};

/**
 * The error message of 'PlayRingtone'
 */
class PlayRingtoneErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  PlayRingtoneErrorStructure ();

    /**
     * Copy constructor
     */
    inline  PlayRingtoneErrorStructure (const PlayRingtoneErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  PlayRingtoneErrorStructure (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline  ~PlayRingtoneErrorStructure();

    /**
     * Assignment operator
     */
    inline PlayRingtoneErrorStructure& operator = (const PlayRingtoneErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PlayRingtoneErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PlayRingtoneErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PlayRingtoneErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PlayRingtoneErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     * MOST Default ErrorCode.
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     * MOST Default ErrorCode.
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 1;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     * MOST Default ErrorInfo.
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     * MOST Default ErrorInfo.
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    static const PlayRingtoneErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

};

/**
 * The error message of 'PlayRingtone'
 */
class PlayRingtoneError  : public ::asf::core::Payload {
public:

    enum PlayRingtoneErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  PlayRingtoneError ();

   /**
     * Copy constructor
     */
    inline  PlayRingtoneError (const PlayRingtoneError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~PlayRingtoneError();

    /**
     * Assigns a new value to this object.
     */
    inline PlayRingtoneError& operator = (const PlayRingtoneError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PlayRingtoneError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PlayRingtoneError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PlayRingtoneError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PlayRingtoneError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline PlayRingtoneError::PlayRingtoneErrorField getField () const;

    inline void setField(PlayRingtoneError::PlayRingtoneErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "PlayRingtoneErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "PlayRingtoneErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const PlayRingtoneErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline PlayRingtoneErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline PlayRingtoneErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (PlayRingtoneErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "PlayRingtoneErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const PlayRingtoneErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const PlayRingtoneError &getDefaultInstance();

private:

    inline void cloneData (const PlayRingtoneError& rhs);

    inline void deleteData ();

    PlayRingtoneErrorField __field;

    union {
        PlayRingtoneErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The error message of 'StopRingtone'
 */
class StopRingtoneErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  StopRingtoneErrorStructure ();

    /**
     * Copy constructor
     */
    inline  StopRingtoneErrorStructure (const StopRingtoneErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  StopRingtoneErrorStructure (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline  ~StopRingtoneErrorStructure();

    /**
     * Assignment operator
     */
    inline StopRingtoneErrorStructure& operator = (const StopRingtoneErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const StopRingtoneErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const StopRingtoneErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const StopRingtoneErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const StopRingtoneErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     * MOST Default ErrorCode.
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     * MOST Default ErrorCode.
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 1;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     * MOST Default ErrorInfo.
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     * MOST Default ErrorInfo.
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    static const StopRingtoneErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

};

/**
 * The error message of 'StopRingtone'
 */
class StopRingtoneError  : public ::asf::core::Payload {
public:

    enum StopRingtoneErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  StopRingtoneError ();

   /**
     * Copy constructor
     */
    inline  StopRingtoneError (const StopRingtoneError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~StopRingtoneError();

    /**
     * Assigns a new value to this object.
     */
    inline StopRingtoneError& operator = (const StopRingtoneError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const StopRingtoneError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const StopRingtoneError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const StopRingtoneError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const StopRingtoneError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline StopRingtoneError::StopRingtoneErrorField getField () const;

    inline void setField(StopRingtoneError::StopRingtoneErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "StopRingtoneErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "StopRingtoneErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const StopRingtoneErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline StopRingtoneErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline StopRingtoneErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (StopRingtoneErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "StopRingtoneErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const StopRingtoneErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const StopRingtoneError &getDefaultInstance();

private:

    inline void cloneData (const StopRingtoneError& rhs);

    inline void deleteData ();

    StopRingtoneErrorField __field;

    union {
        StopRingtoneErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "SuppressRingtoneOnOff"
 * Provides the ability to set the ringtone on or off in the vehicle when an incoming call is received.
 * If the DeviceAddress string is ALL, then the received setting is set for all the paired devices treating it as a system wide setting.
 * The same will be applicable also for the devices that are paired after the API is invoked.
 *
 * The updated changes will be available in the SuppressRingtoneOnOffList property.
 *
 * Note: - The setting will be retained persistently by PM
 */
class SuppressRingtoneOnOffStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SuppressRingtoneOnOffStart ();

    /**
     * Copy constructor
     */
    inline  SuppressRingtoneOnOffStart (const SuppressRingtoneOnOffStart &rhs);

    /**
     * All fields constructor
     */
    inline  SuppressRingtoneOnOffStart (const ::fi_basetypes_most::T_String& sBdAddress_, bool bSuppressRingtoneState_);

    /**
     * Destructor
     */
    inline virtual  ~SuppressRingtoneOnOffStart();

    /**
     * Assignment operator
     */
    inline SuppressRingtoneOnOffStart& operator = (const SuppressRingtoneOnOffStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SuppressRingtoneOnOffStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SuppressRingtoneOnOffStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SuppressRingtoneOnOffStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SuppressRingtoneOnOffStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "sBdAddress"

    static const int kSBdAddress = 0;

    /**
     * Clears the field "sBdAddress".
     *
     * The field will be set to its default value. The hasSBdAddress()
     * method will return false.
     */
    inline void clearSBdAddress();

    /**
     * Checks whether the field "sBdAddress" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSBdAddress()). Otherwise it will return false.
     */
    inline bool hasSBdAddress () const;

    /**
     * Returns the value of the member "sBdAddress".
     *
     * Bluetooth device address.
     *
     * @return The value of the field "sBdAddress"
     */
    inline const ::fi_basetypes_most::T_String& getSBdAddress () const;

    /**
     * Retrieves the value of the field "sBdAddress" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sBdAddress".
     */
    inline ::fi_basetypes_most::T_String& getSBdAddressMutable ();

    /**
     * Sets the value of the member "sBdAddress".
     *
     * Bluetooth device address.
     *
     * @param sBdAddress The value which will be set
     */
    inline void setSBdAddress (const ::fi_basetypes_most::T_String& sBdAddress_);

    // API of field "bSuppressRingtoneState"

    static const int kBSuppressRingtoneState = 1;

    /**
     * Clears the field "bSuppressRingtoneState".
     *
     * The field will be set to its default value. The hasBSuppressRingtoneState()
     * method will return false.
     */
    inline void clearBSuppressRingtoneState();

    /**
     * Checks whether the field "bSuppressRingtoneState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBSuppressRingtoneState()). Otherwise it will return false.
     */
    inline bool hasBSuppressRingtoneState () const;

    /**
     * Returns the value of the member "bSuppressRingtoneState".
     *
     * TRUE - enable suppress ringtone, FALSE - disable suppress ringtone.
     *
     * @return The value of the field "bSuppressRingtoneState"
     */
    inline bool getBSuppressRingtoneState () const;

    /**
     * Sets the value of the member "bSuppressRingtoneState".
     *
     * TRUE - enable suppress ringtone, FALSE - disable suppress ringtone.
     *
     * @param bSuppressRingtoneState The value which will be set
     */
    inline void setBSuppressRingtoneState (bool bSuppressRingtoneState_);

    static const SuppressRingtoneOnOffStart &getDefaultInstance();

private:

    inline void set_has_sBdAddress ();

    inline void clear_has_sBdAddress ();

    inline void set_has_bSuppressRingtoneState ();

    inline void clear_has_bSuppressRingtoneState ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_String _sBdAddress;

    bool _bSuppressRingtoneState;

};

/**
 * The error message of 'SuppressRingtoneOnOff'
 */
class SuppressRingtoneOnOffErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  SuppressRingtoneOnOffErrorStructure ();

    /**
     * Copy constructor
     */
    inline  SuppressRingtoneOnOffErrorStructure (const SuppressRingtoneOnOffErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  SuppressRingtoneOnOffErrorStructure (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline  ~SuppressRingtoneOnOffErrorStructure();

    /**
     * Assignment operator
     */
    inline SuppressRingtoneOnOffErrorStructure& operator = (const SuppressRingtoneOnOffErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SuppressRingtoneOnOffErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SuppressRingtoneOnOffErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SuppressRingtoneOnOffErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SuppressRingtoneOnOffErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     * MOST Default ErrorCode.
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     * MOST Default ErrorCode.
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 1;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     * MOST Default ErrorInfo.
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     * MOST Default ErrorInfo.
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    static const SuppressRingtoneOnOffErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

};

/**
 * The error message of 'SuppressRingtoneOnOff'
 */
class SuppressRingtoneOnOffError  : public ::asf::core::Payload {
public:

    enum SuppressRingtoneOnOffErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  SuppressRingtoneOnOffError ();

   /**
     * Copy constructor
     */
    inline  SuppressRingtoneOnOffError (const SuppressRingtoneOnOffError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~SuppressRingtoneOnOffError();

    /**
     * Assigns a new value to this object.
     */
    inline SuppressRingtoneOnOffError& operator = (const SuppressRingtoneOnOffError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SuppressRingtoneOnOffError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SuppressRingtoneOnOffError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SuppressRingtoneOnOffError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SuppressRingtoneOnOffError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline SuppressRingtoneOnOffError::SuppressRingtoneOnOffErrorField getField () const;

    inline void setField(SuppressRingtoneOnOffError::SuppressRingtoneOnOffErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "SuppressRingtoneOnOffErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "SuppressRingtoneOnOffErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const SuppressRingtoneOnOffErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline SuppressRingtoneOnOffErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline SuppressRingtoneOnOffErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (SuppressRingtoneOnOffErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "SuppressRingtoneOnOffErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const SuppressRingtoneOnOffErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const SuppressRingtoneOnOffError &getDefaultInstance();

private:

    inline void cloneData (const SuppressRingtoneOnOffError& rhs);

    inline void deleteData ();

    SuppressRingtoneOnOffErrorField __field;

    union {
        SuppressRingtoneOnOffErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "AutoWaitingModeOnOff"
 * Provides the ability to enable or disable the auto waiting mode when an incoming call is received. When the setting is enabled,
 * an incoming call will be automatically put on waiting mode and the waiting mode tone will be heard in the far end.
 *
 * If the DeviceAddress string is ALL, then the setting is set for all the paired devices treating it as a system wide setting.
 * The setting will be applicable for the devices that are paired after the API is invoked.
 *
 * The updated changes will be available in the AutoWaitingModeOnOffList property.
 *
 * Note: - The setting will be retained persistently by PM
 */
class AutoWaitingModeOnOffStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AutoWaitingModeOnOffStart ();

    /**
     * Copy constructor
     */
    inline  AutoWaitingModeOnOffStart (const AutoWaitingModeOnOffStart &rhs);

    /**
     * All fields constructor
     */
    inline  AutoWaitingModeOnOffStart (const ::fi_basetypes_most::T_String& sBdAddress_, bool bAutoWaitingModeState_);

    /**
     * Destructor
     */
    inline virtual  ~AutoWaitingModeOnOffStart();

    /**
     * Assignment operator
     */
    inline AutoWaitingModeOnOffStart& operator = (const AutoWaitingModeOnOffStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AutoWaitingModeOnOffStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AutoWaitingModeOnOffStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AutoWaitingModeOnOffStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AutoWaitingModeOnOffStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "sBdAddress"

    static const int kSBdAddress = 0;

    /**
     * Clears the field "sBdAddress".
     *
     * The field will be set to its default value. The hasSBdAddress()
     * method will return false.
     */
    inline void clearSBdAddress();

    /**
     * Checks whether the field "sBdAddress" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSBdAddress()). Otherwise it will return false.
     */
    inline bool hasSBdAddress () const;

    /**
     * Returns the value of the member "sBdAddress".
     *
     * Bluetooth device address.
     *
     * @return The value of the field "sBdAddress"
     */
    inline const ::fi_basetypes_most::T_String& getSBdAddress () const;

    /**
     * Retrieves the value of the field "sBdAddress" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sBdAddress".
     */
    inline ::fi_basetypes_most::T_String& getSBdAddressMutable ();

    /**
     * Sets the value of the member "sBdAddress".
     *
     * Bluetooth device address.
     *
     * @param sBdAddress The value which will be set
     */
    inline void setSBdAddress (const ::fi_basetypes_most::T_String& sBdAddress_);

    // API of field "bAutoWaitingModeState"

    static const int kBAutoWaitingModeState = 1;

    /**
     * Clears the field "bAutoWaitingModeState".
     *
     * The field will be set to its default value. The hasBAutoWaitingModeState()
     * method will return false.
     */
    inline void clearBAutoWaitingModeState();

    /**
     * Checks whether the field "bAutoWaitingModeState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBAutoWaitingModeState()). Otherwise it will return false.
     */
    inline bool hasBAutoWaitingModeState () const;

    /**
     * Returns the value of the member "bAutoWaitingModeState".
     *
     * TRUE - enable auto waiting mode, FALSE - disable auto waiting mode.
     *
     * @return The value of the field "bAutoWaitingModeState"
     */
    inline bool getBAutoWaitingModeState () const;

    /**
     * Sets the value of the member "bAutoWaitingModeState".
     *
     * TRUE - enable auto waiting mode, FALSE - disable auto waiting mode.
     *
     * @param bAutoWaitingModeState The value which will be set
     */
    inline void setBAutoWaitingModeState (bool bAutoWaitingModeState_);

    static const AutoWaitingModeOnOffStart &getDefaultInstance();

private:

    inline void set_has_sBdAddress ();

    inline void clear_has_sBdAddress ();

    inline void set_has_bAutoWaitingModeState ();

    inline void clear_has_bAutoWaitingModeState ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_String _sBdAddress;

    bool _bAutoWaitingModeState;

};

/**
 * The error message of 'AutoWaitingModeOnOff'
 */
class AutoWaitingModeOnOffErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  AutoWaitingModeOnOffErrorStructure ();

    /**
     * Copy constructor
     */
    inline  AutoWaitingModeOnOffErrorStructure (const AutoWaitingModeOnOffErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  AutoWaitingModeOnOffErrorStructure (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline  ~AutoWaitingModeOnOffErrorStructure();

    /**
     * Assignment operator
     */
    inline AutoWaitingModeOnOffErrorStructure& operator = (const AutoWaitingModeOnOffErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AutoWaitingModeOnOffErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AutoWaitingModeOnOffErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AutoWaitingModeOnOffErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AutoWaitingModeOnOffErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     * MOST Default ErrorCode.
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     * MOST Default ErrorCode.
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 1;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     * MOST Default ErrorInfo.
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     * MOST Default ErrorInfo.
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    static const AutoWaitingModeOnOffErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

};

/**
 * The error message of 'AutoWaitingModeOnOff'
 */
class AutoWaitingModeOnOffError  : public ::asf::core::Payload {
public:

    enum AutoWaitingModeOnOffErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  AutoWaitingModeOnOffError ();

   /**
     * Copy constructor
     */
    inline  AutoWaitingModeOnOffError (const AutoWaitingModeOnOffError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~AutoWaitingModeOnOffError();

    /**
     * Assigns a new value to this object.
     */
    inline AutoWaitingModeOnOffError& operator = (const AutoWaitingModeOnOffError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AutoWaitingModeOnOffError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AutoWaitingModeOnOffError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AutoWaitingModeOnOffError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AutoWaitingModeOnOffError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline AutoWaitingModeOnOffError::AutoWaitingModeOnOffErrorField getField () const;

    inline void setField(AutoWaitingModeOnOffError::AutoWaitingModeOnOffErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "AutoWaitingModeOnOffErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "AutoWaitingModeOnOffErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const AutoWaitingModeOnOffErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline AutoWaitingModeOnOffErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline AutoWaitingModeOnOffErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (AutoWaitingModeOnOffErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "AutoWaitingModeOnOffErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const AutoWaitingModeOnOffErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const AutoWaitingModeOnOffError &getDefaultInstance();

private:

    inline void cloneData (const AutoWaitingModeOnOffError& rhs);

    inline void deleteData ();

    AutoWaitingModeOnOffErrorField __field;

    union {
        AutoWaitingModeOnOffErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "WaitingModeFilePath"
 * This interface is used to Set and Get the filepath of NarrowBand and WideBand audio files.
 * One of these files will be played by the Phone F-Block during active waiting mode state based on the
 * audio codec (NarrowBand/Wideband) supported by the connected Bluetooth Phone device.
 */
class WaitingModeFilePathStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  WaitingModeFilePathStatus ();

    /**
     * Copy constructor
     */
    inline  WaitingModeFilePathStatus (const WaitingModeFilePathStatus &rhs);

    /**
     * All fields constructor
     */
    inline  WaitingModeFilePathStatus (const ::fi_basetypes_most::T_String& sFilePathNB_, const ::fi_basetypes_most::T_String& sFilePathWB_);

    /**
     * Destructor
     */
    inline virtual  ~WaitingModeFilePathStatus();

    /**
     * Assignment operator
     */
    inline WaitingModeFilePathStatus& operator = (const WaitingModeFilePathStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const WaitingModeFilePathStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const WaitingModeFilePathStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const WaitingModeFilePathStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const WaitingModeFilePathStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "sFilePathNB"

    static const int kSFilePathNB = 0;

    /**
     * Clears the field "sFilePathNB".
     *
     * The field will be set to its default value. The hasSFilePathNB()
     * method will return false.
     */
    inline void clearSFilePathNB();

    /**
     * Checks whether the field "sFilePathNB" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSFilePathNB()). Otherwise it will return false.
     */
    inline bool hasSFilePathNB () const;

    /**
     * Returns the value of the member "sFilePathNB".
     *
     * File path to 8 KHz .wav file.
     *
     * @return The value of the field "sFilePathNB"
     */
    inline const ::fi_basetypes_most::T_String& getSFilePathNB () const;

    /**
     * Retrieves the value of the field "sFilePathNB" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sFilePathNB".
     */
    inline ::fi_basetypes_most::T_String& getSFilePathNBMutable ();

    /**
     * Sets the value of the member "sFilePathNB".
     *
     * File path to 8 KHz .wav file.
     *
     * @param sFilePathNB The value which will be set
     */
    inline void setSFilePathNB (const ::fi_basetypes_most::T_String& sFilePathNB_);

    // API of field "sFilePathWB"

    static const int kSFilePathWB = 1;

    /**
     * Clears the field "sFilePathWB".
     *
     * The field will be set to its default value. The hasSFilePathWB()
     * method will return false.
     */
    inline void clearSFilePathWB();

    /**
     * Checks whether the field "sFilePathWB" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSFilePathWB()). Otherwise it will return false.
     */
    inline bool hasSFilePathWB () const;

    /**
     * Returns the value of the member "sFilePathWB".
     *
     * File path to 16 KHz .wav file.
     *
     * @return The value of the field "sFilePathWB"
     */
    inline const ::fi_basetypes_most::T_String& getSFilePathWB () const;

    /**
     * Retrieves the value of the field "sFilePathWB" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sFilePathWB".
     */
    inline ::fi_basetypes_most::T_String& getSFilePathWBMutable ();

    /**
     * Sets the value of the member "sFilePathWB".
     *
     * File path to 16 KHz .wav file.
     *
     * @param sFilePathWB The value which will be set
     */
    inline void setSFilePathWB (const ::fi_basetypes_most::T_String& sFilePathWB_);

    static const Wait