#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef FI_BASETYPES_MOST_H
#define FI_BASETYPES_MOST_H

#include "asf/core/Blob.h"
#include "asf/core/Internal.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "asf/core/VersionCheck.h"
#include <cstddef>
#include <cstring>
#include <string>
#include <vector>

/**
 * Types fi_basetypes_most
 */

namespace fi_basetypes_most {

ASF_GENERATOR_VERSION_CHECK_DECLARE

// forward declarations
class T_ClassifiedStream;

// type definitions
/**
 * If the meaning of "T_TrailingStream" isn't clear, then there should be a description here.
 */
typedef ::std::vector< uint8 > T_TrailingStream;

/**
 * If the meaning of "T_ShortStream" isn't clear, then there should be a description here.
 */
typedef ::std::vector< uint8 > T_ShortStream;

/**
 * If the meaning of "T_String" isn't clear, then there should be a description here.
 */
typedef ::std::string T_String;


/**
 * Up to 65535 bytes of binary data, preceded by 2 bytes size information
 * and an ASCII string type classifier, matching the MOST type "cstream".
 */
class T_ClassifiedStream {
public:

    /**
     * Default constructor
     */
    inline  T_ClassifiedStream ();

    /**
     * Copy constructor
     */
    inline  T_ClassifiedStream (const T_ClassifiedStream &rhs);

    /**
     * All fields constructor
     */
    inline  T_ClassifiedStream (const ::std::string& mediaType_, const ::asf::core::Blob& content_);

    /**
     * Destructor
     */
    inline  ~T_ClassifiedStream();

    /**
     * Assignment operator
     */
    inline T_ClassifiedStream& operator = (const T_ClassifiedStream& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_ClassifiedStream& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_ClassifiedStream& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_ClassifiedStream& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_ClassifiedStream& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "mediaType"

    static const int kMediaType = 0;

    /**
     * Clears the field "mediaType".
     *
     * The field will be set to its default value. The hasMediaType()
     * method will return false.
     */
    inline void clearMediaType();

    /**
     * Checks whether the field "mediaType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMediaType()). Otherwise it will return false.
     */
    inline bool hasMediaType () const;

    /**
     * Returns the value of the member "mediaType".
     *
     * If the meaning of "mediaType" isn't clear, then there should be a description here.
     *
     * @return The value of the field "mediaType"
     */
    inline const ::std::string& getMediaType () const;

    /**
     * Retrieves the value of the field "mediaType" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "mediaType".
     */
    inline ::std::string& getMediaTypeMutable ();

    /**
     * Sets the value of the member "mediaType".
     *
     * If the meaning of "mediaType" isn't clear, then there should be a description here.
     *
     * @param mediaType The value which will be set
     */
    inline void setMediaType (const ::std::string& mediaType_);

    /**
     * Sets the value of the member "mediaType".
     *
     * If the meaning of "mediaType" isn't clear, then there should be a description here.
     *
     * @param mediaType The value which will be set
     */
    inline void setMediaType (const char* mediaType_);

    /**
     * Sets the value of the member "mediaType".
     *
     * If the meaning of "mediaType" isn't clear, then there should be a description here.
     *
     * @param mediaType The value which will be set
     */
    inline void setMediaType (const char* value, size_t size);

    // API of field "content"

    static const int kContent = 1;

    /**
     * Clears the field "content".
     *
     * The field will be set to its default value. The hasContent()
     * method will return false.
     */
    inline void clearContent();

    /**
     * Checks whether the field "content" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setContent()). Otherwise it will return false.
     */
    inline bool hasContent () const;

    /**
     * Returns the value of the member "content".
     *
     * If the meaning of "content" isn't clear, then there should be a description here.
     *
     * @return The value of the field "content"
     */
    inline const ::asf::core::Blob& getContent () const;

    /**
     * Retrieves the value of the field "content" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "content".
     */
    inline ::asf::core::Blob& getContentMutable ();

    /**
     * Sets the value of the member "content".
     *
     * If the meaning of "content" isn't clear, then there should be a description here.
     *
     * @param content The value which will be set
     */
    inline void setContent (const ::asf::core::Blob& content_);

    static const T_ClassifiedStream &getDefaultInstance();

private:

    inline void set_has_mediaType ();

    inline void clear_has_mediaType ();

    inline void set_has_content ();

    inline void clear_has_content ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _mediaType;

    ::asf::core::Blob _content;

};

inline  T_ClassifiedStream::T_ClassifiedStream ()  :
    _mediaType (),
    _content ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_ClassifiedStream::T_ClassifiedStream (const T_ClassifiedStream &rhs)  :
    _mediaType (),
    _content ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_ClassifiedStream::T_ClassifiedStream (const ::std::string& mediaType_, const ::asf::core::Blob& content_)  :
    _mediaType (mediaType_),
    _content (content_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (mediaType_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_ClassifiedStream::~T_ClassifiedStream() {
}

inline T_ClassifiedStream& T_ClassifiedStream::operator = (const T_ClassifiedStream& rhs) {
    if( this != &rhs ) {
        if (rhs.hasMediaType()) {
            setMediaType(rhs.getMediaType());
        } else {
            clearMediaType();
        }
        if (rhs.hasContent()) {
            setContent(rhs.getContent());
        } else {
            clearContent();
        }
    }
    return *this;
}

inline bool T_ClassifiedStream::operator == (const T_ClassifiedStream& rhs) const {
    return (((!hasMediaType() && !rhs.hasMediaType()) || getMediaType() == rhs.getMediaType()) &&
        ((!hasContent() && !rhs.hasContent()) || getContent() == rhs.getContent()));
}

inline bool T_ClassifiedStream::operator != (const T_ClassifiedStream& rhs) const {
    return ! (*this == rhs);
}

inline bool T_ClassifiedStream::operator < (const T_ClassifiedStream& rhs) const {
    if (hasMediaType() || rhs.hasMediaType()) {
        if (getMediaType() < rhs.getMediaType()) return true;
        if (getMediaType() > rhs.getMediaType()) return false;
    }
    if (hasContent() || rhs.hasContent()) {
        if (getContent() < rhs.getContent()) return true;
        if (getContent() > rhs.getContent()) return false;
    }
    return false;
}

inline bool T_ClassifiedStream::operator > (const T_ClassifiedStream& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_ClassifiedStream::clear() {
    clearMediaType();
    clearContent();
}

inline void T_ClassifiedStream::clearMediaType() {
    if (hasMediaType()) {
         clear_has_mediaType();
        _mediaType.clear();
     }
}

inline bool T_ClassifiedStream::hasMediaType () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& T_ClassifiedStream::getMediaType () const {
    return _mediaType;
}

inline ::std::string& T_ClassifiedStream::getMediaTypeMutable () {
    set_has_mediaType();
    return _mediaType;
}

inline void T_ClassifiedStream::setMediaType (const ::std::string& mediaType_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (mediaType_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_mediaType();
    this->_mediaType = mediaType_;
}

inline void T_ClassifiedStream::setMediaType (const char* mediaType_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (mediaType_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_mediaType();
    this->_mediaType.assign(mediaType_);
}

inline void T_ClassifiedStream::setMediaType (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_mediaType();
    this->_mediaType.assign(value, size);
}

inline void T_ClassifiedStream::clearContent() {
    if (hasContent()) {
         clear_has_content();
        _content = ::asf::core::theEmptyBlob;
     }
}

inline bool T_ClassifiedStream::hasContent () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::asf::core::Blob& T_ClassifiedStream::getContent () const {
    return _content;
}

inline ::asf::core::Blob& T_ClassifiedStream::getContentMutable () {
    set_has_content();
    return _content;
}

inline void T_ClassifiedStream::setContent (const ::asf::core::Blob& content_) {
    set_has_content();
    this->_content = content_;
}

inline void T_ClassifiedStream::set_has_mediaType () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_ClassifiedStream::clear_has_mediaType () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_ClassifiedStream::set_has_content () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_ClassifiedStream::clear_has_content () {
    _has_bits_[0] &= ~ (1u << 1);
}

} // namespace fi_basetypes_most

#endif // FI_BASETYPES_MOST_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
