/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef MOST_PHONBK_FIPROXY_H
#define MOST_PHONBK_FIPROXY_H

#include "MOST_PhonBk_FI.h"
#include "asf/cca/CcaProxy.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/core/nullable.h"
#include "fi_basetypes_most.h"
#include "most_FavPrv_fi_typesConst.h"
#include "most_PhonBk_fi_types.h"
#include "most_PhonBk_fi_typesConst.h"
#include "most_PhonBk_fi_types_Extended.h"
#include "most_PhonBk_fi_types_ExtendedConst.h"

namespace MOST_PhonBk_FI {

class MOST_PhonBk_FIProxy;

class ActivateFavoriteCallbackIF {
public:
    virtual ~ActivateFavoriteCallbackIF() {}

    virtual void onActivateFavoriteError(const ::boost::shared_ptr< MOST_PhonBk_FIProxy >& proxy, const ::boost::shared_ptr< ActivateFavoriteError >& error) = 0;

    virtual void onActivateFavoriteResult(const ::boost::shared_ptr< MOST_PhonBk_FIProxy >& proxy, const ::boost::shared_ptr< ActivateFavoriteResult >& result) = 0;
};

class AddContactCallbackIF {
public:
    virtual ~AddContactCallbackIF() {}

    virtual void onAddContactError(const ::boost::shared_ptr< MOST_PhonBk_FIProxy >& proxy, const ::boost::shared_ptr< AddContactError >& error) = 0;

    virtual void onAddContactResult(const ::boost::shared_ptr< MOST_PhonBk_FIProxy >& proxy, const ::boost::shared_ptr< AddContactResult >& result) = 0;
};

class AddContactExtendedCallbackIF {
public:
    virtual ~AddContactExtendedCallbackIF() {}

    virtual void onAddContactExtendedError(const ::boost::shared_ptr< MOST_PhonBk_FIProxy >& proxy, const ::boost::shared_ptr< AddContactExtendedError >& error) = 0;

    virtual void onAddContactExtendedResult(const ::boost::shared_ptr< MOST_PhonBk_FIProxy >& proxy, const ::boost::shared_ptr< AddContactExtendedResult >& result) = 0;
};

class AutocompletePhoneNumberEntryCallbackIF {
public:
    virtual ~AutocompletePhoneNumberEntryCallbackIF() {}

    virtual void onAutocompletePhoneNumberEntryError(const ::boost::shared_ptr< MOST_PhonBk_FIProxy >& proxy, const ::boost::shared_ptr< AutocompletePhoneNumberEntryError >& error) = 0;

    virtual void onAutocompletePhoneNumberEntryResult(const ::boost::shared_ptr< MOST_PhonBk_FIProxy >& proxy, const ::boost::shared_ptr< AutocompletePhoneNumberEntryResult >& result) = 0;
};

class AutomaticContactDownloadListCallbackIF {
public:
    virtual ~AutomaticContactDownloadListCallbackIF() {}

    virtual void onAutomaticContactDownloadListError(const ::boost::shared_ptr< MOST_PhonBk_FIProxy >& proxy, const ::boost::shared_ptr< AutomaticContactDownloadListError >& error) = 0;

    virtual void onAutomaticContactDownloadListStatus(const ::boost::shared_ptr< MOST_PhonBk_FIProxy >& proxy, const ::boost::shared_ptr< AutomaticContactDownloadListStatus >& status) = 0;
};

class CancelPbDownloadCallbackIF {
public:
    virtual ~CancelPbDownloadCallbackIF() {}

    virtual void onCancelPbDownloadError(const ::boost::shared_ptr< MOST_PhonBk_FIProxy >& proxy, const ::boost::shared_ptr< CancelPbDownloadError >& error) = 0;

    virtual void onCancelPbDownloadResult(const ::boost::shared_ptr< MOST_PhonBk_FIProxy >& proxy, const ::boost::shared_ptr< CancelPbDownloadResult >& result) = 0;
};

class ClearMissedCallIndicatorCallbackIF {
public:
    virtual ~ClearMissedCallIndicatorCallbackIF() {}

    virtual void onClearMissedCallIndicatorError(const ::boost::shared_ptr< MOST_PhonBk_FIProxy >& proxy, const ::boost::shared_ptr< ClearMissedCallIndicatorError >& error) = 0;

    virtual void onClearMissedCallIndicatorResult(const ::boost::shared_ptr< MOST_PhonBk_FIProxy >& proxy, const ::boost::shared_ptr< ClearMissedCallIndicatorResult >& result) = 0;
};

class ClearPhoneBookDataCallbackIF {
public:
    virtual ~ClearPhoneBookDataCallbackIF() {}

    virtual void onClearPhoneBookDataError(const ::boost::shared_ptr< MOST_PhonBk_FIProxy >& proxy, const ::boost::shared_ptr< ClearPhoneBookDataError >& error) = 0;

    virtual void onClearPhoneBookDataResult(const ::boost::shared_ptr< MOST_PhonBk_FIProxy >& proxy, const ::boost::shared_ptr< ClearPhoneBookDataResult >& result) = 0;
};

class ClearVehiclePhoneBookCallbackIF {
public:
    virtual ~ClearVehiclePhoneBookCallbackIF() {}

    virtual void onClearVehiclePhoneBookError(const ::boost::shared_ptr< MOST_PhonBk_FIProxy >& proxy, const ::boost::shared_ptr< ClearVehiclePhoneBookError >& error) = 0;

    virtual void onClearVehiclePhoneBookResult(const ::boost::shared_ptr< MOST_PhonBk_FIProxy >& proxy, const ::boost::shared_ptr< ClearVehiclePhoneBookResult >& result) = 0;
};

class ClearVehiclePhonebookExtendedCallbackIF {
public:
    virtual ~ClearVehiclePhonebookExtendedCallbackIF() {}

    virtual void onClearVehiclePhonebookExtendedError(const ::boost::shared_ptr< MOST_PhonBk_FIProxy >& proxy, const ::boost::shared_ptr< ClearVehiclePhonebookExtendedError >& error) = 0;

    virtual void onClearVehiclePhonebookExtendedResult(const ::boost::shared_ptr< MOST_PhonBk_FIProxy >& proxy, const ::boost::shared_ptr< ClearVehiclePhonebookExtendedResult >& result) = 0;
};

class CreateCallHistoryListCallbackIF {
public:
    virtual ~CreateCallHistoryListCallbackIF() {}

    virtual void onCreateCallHistoryListError(const ::boost::shared_ptr< MOST_PhonBk_FIProxy >& proxy, const ::boost::shared_ptr< CreateCallHistoryListError >& error) = 0;

    virtual void onCreateCallHistoryListResult(const ::boost::shared_ptr< MOST_PhonBk_FIProxy >& proxy, const ::boost::shared_ptr< CreateCallHistoryListResult >& result) = 0;
};

class CreateContactListCallbackIF {
public:
    virtual ~CreateContactListCallbackIF() {}

    virtual void onCreateContactListError(const ::boost::shared_ptr< MOST_PhonBk_FIProxy >& proxy, const ::boost::shared_ptr< CreateContactListError >& error) = 0;

    virtual void onCreateContactListResult(const ::boost::shared_ptr< MOST_PhonBk_FIProxy >& proxy, const ::boost::shared_ptr< CreateContactListResult >& result) = 0;
};

class CreatePhoneBookListCallbackIF {
public:
    virtual ~CreatePhoneBookListCallbackIF() {}

    virtual void onCreatePhoneBookListError(const ::boost::shared_ptr< MOST_PhonBk_FIProxy >& proxy, const ::boost::shared_ptr< CreatePhoneBookListError >& error) = 0;

    virtual void onCreatePhoneBookListResult(const ::boost::shared_ptr< MOST_PhonBk_FIProxy >& proxy, const ::boost::shared_ptr< CreatePhoneBookListResult >& result) = 0;
};

class DeleteContactCallbackIF {
public:
    virtual ~DeleteContactCallbackIF() {}

    virtual void onDeleteContactError(const ::boost::shared_ptr< MOST_PhonBk_FIProxy >& proxy, const ::boost::shared_ptr< DeleteContactError >& error) = 0;

    virtual void onDeleteContactResult(const ::boost::shared_ptr< MOST_PhonBk_FIProxy >& proxy, const ::boost::shared_ptr< DeleteContactResult >& result) = 0;
};

class DeleteFavoriteCallbackIF {
public:
    virtual ~DeleteFavoriteCallbackIF() {}

    virtual void onDeleteFavoriteError(const ::boost::shared_ptr< MOST_PhonBk_FIProxy >& proxy, const ::boost::shared_ptr< DeleteFavoriteError >& error) = 0;

    virtual void onDeleteFavoriteResult(const ::boost::shared_ptr< MOST_PhonBk_FIProxy >& proxy, const ::boost::shared_ptr< DeleteFavoriteResult >& result) = 0;
};

class DevicePhoneBookFeatureSupportCallbackIF {
public:
    virtual ~DevicePhoneBookFeatureSupportCallbackIF() {}

    virtual void onDevicePhoneBookFeatureSupportError(const ::boost::shared_ptr< MOST_PhonBk_FIProxy >& proxy, const ::boost::shared_ptr< DevicePhoneBookFeatureSupportError >& error) = 0;

    virtual void onDevicePhoneBookFeatureSupportStatus(const ::boost::shared_ptr< MOST_PhonBk_FIProxy >& proxy, const ::boost::shared_ptr< DevicePhoneBookFeatureSupportStatus >& status) = 0;
};

class DevicePhoneBookFeatureSupportExtendedCallbackIF {
public:
    virtual ~DevicePhoneBookFeatureSupportExtendedCallbackIF() {}

    virtual void onDevicePhoneBookFeatureSupportExtendedError(const ::boost::shared_ptr< MOST_PhonBk_FIProxy >& proxy, const ::boost::shared_ptr< DevicePhoneBookFeatureSupportExtendedError >& error) = 0;

    virtual void onDevicePhoneBookFeatureSupportExtendedStatus(const ::boost::shared_ptr< MOST_PhonBk_FIProxy >& proxy, const ::boost::shared_ptr< DevicePhoneBookFeatureSupportExtendedStatus >& status) = 0;
};

class DownloadOnOffListCallbackIF {
public:
    virtual ~DownloadOnOffListCallbackIF() {}

    virtual void onDownloadOnOffListError(const ::boost::shared_ptr< MOST_PhonBk_FIProxy >& proxy, const ::boost::shared_ptr< DownloadOnOffListError >& error) = 0;

    virtual void onDownloadOnOffListStatus(const ::boost::shared_ptr< MOST_PhonBk_FIProxy >& proxy, const ::boost::shared_ptr< DownloadOnOffListStatus >& status) = 0;
};

class DownloadProgressCallbackIF {
public:
    virtual ~DownloadProgressCallbackIF() {}

    virtual void onDownloadProgressError(const ::boost::shared_ptr< MOST_PhonBk_FIProxy >& proxy, const ::boost::shared_ptr< DownloadProgressError >& error) = 0;

    virtual void onDownloadProgressStatus(const ::boost::shared_ptr< MOST_PhonBk_FIProxy >& proxy, const ::boost::shared_ptr< DownloadProgressStatus >& status) = 0;
};

class DownloadProgressListCallbackIF {
public:
    virtual ~DownloadProgressListCallbackIF() {}

    virtual void onDownloadProgressListError(const ::boost::shared_ptr< MOST_PhonBk_FIProxy >& proxy, const ::boost::shared_ptr< DownloadProgressListError >& error) = 0;

    virtual void onDownloadProgressListStatus(const ::boost::shared_ptr< MOST_PhonBk_FIProxy >& proxy, const ::boost::shared_ptr< DownloadProgressListStatus >& status) = 0;
};

class DownloadStateCallbackIF {
public:
    virtual ~DownloadStateCallbackIF() {}

    virtual void onDownloadStateError(const ::boost::shared_ptr< MOST_PhonBk_FIProxy >& proxy, const ::boost::shared_ptr< DownloadStateError >& error) = 0;

    virtual void onDownloadStateStatus(const ::boost::shared_ptr< MOST_PhonBk_FIProxy >& proxy, const ::boost::shared_ptr< DownloadStateStatus >& status) = 0;
};

class DownloadStateExtendedCallbackIF {
public:
    virtual ~DownloadStateExtendedCallbackIF() {}

    virtual void onDownloadStateExtendedError(const ::boost::shared_ptr< MOST_PhonBk_FIProxy >& proxy, const ::boost::shared_ptr< DownloadStateExtendedError >& error) = 0;

    virtual void onDownloadStateExtendedStatus(const ::boost::shared_ptr< MOST_PhonBk_FIProxy >& proxy, const ::boost::shared_ptr< DownloadStateExtendedStatus >& status) = 0;
};

class EditContactCallbackIF {
public:
    virtual ~EditContactCallbackIF() {}

    virtual void onEditContactError(const ::boost::shared_ptr< MOST_PhonBk_FIProxy >& proxy, const ::boost::shared_ptr< EditContactError >& error) = 0;

    virtual void onEditContactResult(const ::boost::shared_ptr< MOST_PhonBk_FIProxy >& proxy, const ::boost::shared_ptr< EditContactResult >& result) = 0;
};

class EditContactExtendedCallbackIF {
public:
    virtual ~EditContactExtendedCallbackIF() {}

    virtual void onEditContactExtendedError(const ::boost::shared_ptr< MOST_PhonBk_FIProxy >& proxy, const ::boost::shared_ptr< EditContactExtendedError >& error) = 0;

    virtual void onEditContactExtendedResult(const ::boost::shared_ptr< MOST_PhonBk_FIProxy >& proxy, const ::boost::shared_ptr< EditContactExtendedResult >& result) = 0;
};

class FavoritesChangedCallbackIF {
public:
    virtual ~FavoritesChangedCallbackIF() {}

    virtual void onFavoritesChangedError(const ::boost::shared_ptr< MOST_PhonBk_FIProxy >& proxy, const ::boost::shared_ptr< FavoritesChangedError >& error) = 0;

    virtual void onFavoritesChangedStatus(const ::boost::shared_ptr< MOST_PhonBk_FIProxy >& proxy, const ::boost::shared_ptr< FavoritesChangedStatus >& status) = 0;
};

class GetContactDetailsCallbackIF {
public:
    virtual ~GetContactDetailsCallbackIF() {}

    virtual void onGetContactDetailsError(const ::boost::shared_ptr< MOST_PhonBk_FIProxy >& proxy, const ::boost::shared_ptr< GetContactDetailsError >& error) = 0;

    virtual void onGetContactDetailsResult(const ::boost::shared_ptr< MOST_PhonBk_FIProxy >& proxy, const ::boost::shared_ptr< GetContactDetailsResult >& result) = 0;
};

class GetContactDetailsExtendedCallbackIF {
public:
    virtual ~GetContactDetailsExtendedCallbackIF() {}

    virtual void onGetContactDetailsExtendedError(const ::boost::shared_ptr< MOST_PhonBk_FIProxy >& proxy, const ::boost::shared_ptr< GetContactDetailsExtendedError >& error) = 0;

    virtual void onGetContactDetailsExtendedResult(const ::boost::shared_ptr< MOST_PhonBk_FIProxy >& proxy, const ::boost::shared_ptr< GetContactDetailsExtendedResult >& result) = 0;
};

class GetContactPhotoCallbackIF {
public:
    virtual ~GetContactPhotoCallbackIF() {}

    virtual void onGetContactPhotoError(const ::boost::shared_ptr< MOST_PhonBk_FIProxy >& proxy, const ::boost::shared_ptr< GetContactPhotoError >& error) = 0;

    virtual void onGetContactPhotoResult(const ::boost::shared_ptr< MOST_PhonBk_FIProxy >& proxy, const ::boost::shared_ptr< GetContactPhotoResult >& result) = 0;
};

class GetContactPhotoInfoCallbackIF {
public:
    virtual ~GetContactPhotoInfoCallbackIF() {}

    virtual void onGetContactPhotoInfoError(const ::boost::shared_ptr< MOST_PhonBk_FIProxy >& proxy, const ::boost::shared_ptr< GetContactPhotoInfoError >& error) = 0;

    virtual void onGetContactPhotoInfoResult(const ::boost::shared_ptr< MOST_PhonBk_FIProxy >& proxy, const ::boost::shared_ptr< GetContactPhotoInfoResult >& result) = 0;
};

class GetDeviceCallHistorySupportCallbackIF {
public:
    virtual ~GetDeviceCallHistorySupportCallbackIF() {}

    virtual void onGetDeviceCallHistorySupportError(const ::boost::shared_ptr< MOST_PhonBk_FIProxy >& proxy, const ::boost::shared_ptr< GetDeviceCallHistorySupportError >& error) = 0;

    virtual void onGetDeviceCallHistorySupportResult(const ::boost::shared_ptr< MOST_PhonBk_FIProxy >& proxy, const ::boost::shared_ptr< GetDeviceCallHistorySupportResult >& result) = 0;
};

class GetFavoriteInfoCallbackIF {
public:
    virtual ~GetFavoriteInfoCallbackIF() {}

    virtual void onGetFavoriteInfoError(const ::boost::shared_ptr< MOST_PhonBk_FIProxy >& proxy, const ::boost::shared_ptr< GetFavoriteInfoError >& error) = 0;

    virtual void onGetFavoriteInfoResult(const ::boost::shared_ptr< MOST_PhonBk_FIProxy >& proxy, const ::boost::shared_ptr< GetFavoriteInfoResult >& result) = 0;
};

class GetPositionForContactHandleCallbackIF {
public:
    virtual ~GetPositionForContactHandleCallbackIF() {}

    virtual void onGetPositionForContactHandleError(const ::boost::shared_ptr< MOST_PhonBk_FIProxy >& proxy, const ::boost::shared_ptr< GetPositionForContactHandleError >& error) = 0;

    virtual void onGetPositionForContactHandleResult(const ::boost::shared_ptr< MOST_PhonBk_FIProxy >& proxy, const ::boost::shared_ptr< GetPositionForContactHandleResult >& result) = 0;
};

class ListChangeCallbackIF {
public:
    virtual ~ListChangeCallbackIF() {}

    virtual void onListChangeError(const ::boost::shared_ptr< MOST_PhonBk_FIProxy >& proxy, const ::boost::shared_ptr< ListChangeError >& error) = 0;

    virtual void onListChangeStatus(const ::boost::shared_ptr< MOST_PhonBk_FIProxy >& proxy, const ::boost::shared_ptr< ListChangeStatus >& status) = 0;
};

class MaxContactCountCallbackIF {
public:
    virtual ~MaxContactCountCallbackIF() {}

    virtual void onMaxContactCountError(const ::boost::shared_ptr< MOST_PhonBk_FIProxy >& proxy, const ::boost::shared_ptr< MaxContactCountError >& error) = 0;

    virtual void onMaxContactCountStatus(const ::boost::shared_ptr< MOST_PhonBk_FIProxy >& proxy, const ::boost::shared_ptr< MaxContactCountStatus >& status) = 0;
};

class MissedCallIndicatorCallbackIF {
public:
    virtual ~MissedCallIndicatorCallbackIF() {}

    virtual void onMissedCallIndicatorError(const ::boost::shared_ptr< MOST_PhonBk_FIProxy >& proxy, const ::boost::shared_ptr< MissedCallIndicatorError >& error) = 0;

    virtual void onMissedCallIndicatorStatus(const ::boost::shared_ptr< MOST_PhonBk_FIProxy >& proxy, const ::boost::shared_ptr< MissedCallIndicatorStatus >& status) = 0;
};

class MissedCallIndicatorListCallbackIF {
public:
    virtual ~MissedCallIndicatorListCallbackIF() {}

    virtual void onMissedCallIndicatorListError(const ::boost::shared_ptr< MOST_PhonBk_FIProxy >& proxy, const ::boost::shared_ptr< MissedCallIndicatorListError >& error) = 0;

    virtual void onMissedCallIndicatorListStatus(const ::boost::shared_ptr< MOST_PhonBk_FIProxy >& proxy, const ::boost::shared_ptr< MissedCallIndicatorListStatus >& status) = 0;
};

class PhonebookLanguageCallbackIF {
public:
    virtual ~PhonebookLanguageCallbackIF() {}

    virtual void onPhonebookLanguageError(const ::boost::shared_ptr< MOST_PhonBk_FIProxy >& proxy, const ::boost::shared_ptr< PhonebookLanguageError >& error) = 0;

    virtual void onPhonebookLanguageStatus(const ::boost::shared_ptr< MOST_PhonBk_FIProxy >& proxy, const ::boost::shared_ptr< PhonebookLanguageStatus >& status) = 0;
};

class PreferredPhoneBookSortOrderCallbackIF {
public:
    virtual ~PreferredPhoneBookSortOrderCallbackIF() {}

    virtual void onPreferredPhoneBookSortOrderError(const ::boost::shared_ptr< MOST_PhonBk_FIProxy >& proxy, const ::boost::shared_ptr< PreferredPhoneBookSortOrderError >& error) = 0;

    virtual void onPreferredPhoneBookSortOrderStatus(const ::boost::shared_ptr< MOST_PhonBk_FIProxy >& proxy, const ::boost::shared_ptr< PreferredPhoneBookSortOrderStatus >& status) = 0;
};

class PreferredSortOrderListCallbackIF {
public:
    virtual ~PreferredSortOrderListCallbackIF() {}

    virtual void onPreferredSortOrderListError(const ::boost::shared_ptr< MOST_PhonBk_FIProxy >& proxy, const ::boost::shared_ptr< PreferredSortOrderListError >& error) = 0;

    virtual void onPreferredSortOrderListStatus(const ::boost::shared_ptr< MOST_PhonBk_FIProxy >& proxy, const ::boost::shared_ptr< PreferredSortOrderListStatus >& status) = 0;
};

class ProbablyLockedDevicesCallbackIF {
public:
    virtual ~ProbablyLockedDevicesCallbackIF() {}

    virtual void onProbablyLockedDevicesError(const ::boost::shared_ptr< MOST_PhonBk_FIProxy >& proxy, const ::boost::shared_ptr< ProbablyLockedDevicesError >& error) = 0;

    virtual void onProbablyLockedDevicesStatus(const ::boost::shared_ptr< MOST_PhonBk_FIProxy >& proxy, const ::boost::shared_ptr< ProbablyLockedDevicesStatus >& status) = 0;
};

class ReleaseCallHistoryListCallbackIF {
public:
    virtual ~ReleaseCallHistoryListCallbackIF() {}

    virtual void onReleaseCallHistoryListError(const ::boost::shared_ptr< MOST_PhonBk_FIProxy >& proxy, const ::boost::shared_ptr< ReleaseCallHistoryListError >& error) = 0;

    virtual void onReleaseCallHistoryListResult(const ::boost::shared_ptr< MOST_PhonBk_FIProxy >& proxy, const ::boost::shared_ptr< ReleaseCallHistoryListResult >& result) = 0;
};

class ReleasePhoneBookListCallbackIF {
public:
    virtual ~ReleasePhoneBookListCallbackIF() {}

    virtual void onReleasePhoneBookListError(const ::boost::shared_ptr< MOST_PhonBk_FIProxy >& proxy, const ::boost::shared_ptr< ReleasePhoneBookListError >& error) = 0;

    virtual void onReleasePhoneBookListResult(const ::boost::shared_ptr< MOST_PhonBk_FIProxy >& proxy, const ::boost::shared_ptr< ReleasePhoneBookListResult >& result) = 0;
};

class RequestPhoneBookListSliceCallbackIF {
public:
    virtual ~RequestPhoneBookListSliceCallbackIF() {}

    virtual void onRequestPhoneBookListSliceError(const ::boost::shared_ptr< MOST_PhonBk_FIProxy >& proxy, const ::boost::shared_ptr< RequestPhoneBookListSliceError >& error) = 0;

    virtual void onRequestPhoneBookListSliceResult(const ::boost::shared_ptr< MOST_PhonBk_FIProxy >& proxy, const ::boost::shared_ptr< RequestPhoneBookListSliceResult >& result) = 0;
};

class RequestPhoneBookListSliceExtendedCallbackIF {
public:
    virtual ~RequestPhoneBookListSliceExtendedCallbackIF() {}

    virtual void onRequestPhoneBookListSliceExtendedError(const ::boost::shared_ptr< MOST_PhonBk_FIProxy >& proxy, const ::boost::shared_ptr< RequestPhoneBookListSliceExtendedError >& error) = 0;

    virtual void onRequestPhoneBookListSliceExtendedResult(const ::boost::shared_ptr< MOST_PhonBk_FIProxy >& proxy, const ::boost::shared_ptr< RequestPhoneBookListSliceExtendedResult >& result) = 0;
};

class RequestSliceCallHistoryListCallbackIF {
public:
    virtual ~RequestSliceCallHistoryListCallbackIF() {}

    virtual void onRequestSliceCallHistoryListError(const ::boost::shared_ptr< MOST_PhonBk_FIProxy >& proxy, const ::boost::shared_ptr< RequestSliceCallHistoryListError >& error) = 0;

    virtual void onRequestSliceCallHistoryListResult(const ::boost::shared_ptr< MOST_PhonBk_FIProxy >& proxy, const ::boost::shared_ptr< RequestSliceCallHistoryListResult >& result) = 0;
};

class RequestSliceCallHistoryListExtendedCallbackIF {
public:
    virtual ~RequestSliceCallHistoryListExtendedCallbackIF() {}

    virtual void onRequestSliceCallHistoryListExtendedError(const ::boost::shared_ptr< MOST_PhonBk_FIProxy >& proxy, const ::boost::shared_ptr< RequestSliceCallHistoryListExtendedError >& error) = 0;

    virtual void onRequestSliceCallHistoryListExtendedResult(const ::boost::shared_ptr< MOST_PhonBk_FIProxy >& proxy, const ::boost::shared_ptr< RequestSliceCallHistoryListExtendedResult >& result) = 0;
};

class ResetFavoritesCallbackIF {
public:
    virtual ~ResetFavoritesCallbackIF() {}

    virtual void onResetFavoritesError(const ::boost::shared_ptr< MOST_PhonBk_FIProxy >& proxy, const ::boost::shared_ptr< ResetFavoritesError >& error) = 0;

    virtual void onResetFavoritesResult(const ::boost::shared_ptr< MOST_PhonBk_FIProxy >& proxy, const ::boost::shared_ptr< ResetFavoritesResult >& result) = 0;
};

class SearchContactsCallbackIF {
public:
    virtual ~SearchContactsCallbackIF() {}

    virtual void onSearchContactsError(const ::boost::shared_ptr< MOST_PhonBk_FIProxy >& proxy, const ::boost::shared_ptr< SearchContactsError >& error) = 0;

    virtual void onSearchContactsResult(const ::boost::shared_ptr< MOST_PhonBk_FIProxy >& proxy, const ::boost::shared_ptr< SearchContactsResult >& result) = 0;
};

class SearchKeyboardPhoneBookListCallbackIF {
public:
    virtual ~SearchKeyboardPhoneBookListCallbackIF() {}

    virtual void onSearchKeyboardPhoneBookListError(const ::boost::shared_ptr< MOST_PhonBk_FIProxy >& proxy, const ::boost::shared_ptr< SearchKeyboardPhoneBookListError >& error) = 0;

    virtual void onSearchKeyboardPhoneBookListResult(const ::boost::shared_ptr< MOST_PhonBk_FIProxy >& proxy, const ::boost::shared_ptr< SearchKeyboardPhoneBookListResult >& result) = 0;
};

class SearchPhoneBookCallbackIF {
public:
    virtual ~SearchPhoneBookCallbackIF() {}

    virtual void onSearchPhoneBookError(const ::boost::shared_ptr< MOST_PhonBk_FIProxy >& proxy, const ::boost::shared_ptr< SearchPhoneBookError >& error) = 0;

    virtual void onSearchPhoneBookResult(const ::boost::shared_ptr< MOST_PhonBk_FIProxy >& proxy, const ::boost::shared_ptr< SearchPhoneBookResult >& result) = 0;
};

class SetAutomaticContactDownloadCallbackIF {
public:
    virtual ~SetAutomaticContactDownloadCallbackIF() {}

    virtual void onSetAutomaticContactDownloadError(const ::boost::shared_ptr< MOST_PhonBk_FIProxy >& proxy, const ::boost::shared_ptr< SetAutomaticContactDownloadError >& error) = 0;

    virtual void onSetAutomaticContactDownloadResult(const ::boost::shared_ptr< MOST_PhonBk_FIProxy >& proxy, const ::boost::shared_ptr< SetAutomaticContactDownloadResult >& result) = 0;
};

class SetContactPhotoCallbackIF {
public:
    virtual ~SetContactPhotoCallbackIF() {}

    virtual void onSetContactPhotoError(const ::boost::shared_ptr< MOST_PhonBk_FIProxy >& proxy, const ::boost::shared_ptr< SetContactPhotoError >& error) = 0;

    virtual void onSetContactPhotoResult(const ::boost::shared_ptr< MOST_PhonBk_FIProxy >& proxy, const ::boost::shared_ptr< SetContactPhotoResult >& result) = 0;
};

class SetContactPositionCallbackIF {
public:
    virtual ~SetContactPositionCallbackIF() {}

    virtual void onSetContactPositionError(const ::boost::shared_ptr< MOST_PhonBk_FIProxy >& proxy, const ::boost::shared_ptr< SetContactPositionError >& error) = 0;

    virtual void onSetContactPositionResult(const ::boost::shared_ptr< MOST_PhonBk_FIProxy >& proxy, const ::boost::shared_ptr< SetContactPositionResult >& result) = 0;
};

class StartPbDownloadCallbackIF {
public:
    virtual ~StartPbDownloadCallbackIF() {}

    virtual void onStartPbDownloadError(const ::boost::shared_ptr< MOST_PhonBk_FIProxy >& proxy, const ::boost::shared_ptr< StartPbDownloadError >& error) = 0;

    virtual void onStartPbDownloadResult(const ::boost::shared_ptr< MOST_PhonBk_FIProxy >& proxy, const ::boost::shared_ptr< StartPbDownloadResult >& result) = 0;
};

class StoreFavoriteCallbackIF {
public:
    virtual ~StoreFavoriteCallbackIF() {}

    virtual void onStoreFavoriteError(const ::boost::shared_ptr< MOST_PhonBk_FIProxy >& proxy, const ::boost::shared_ptr< StoreFavoriteError >& error) = 0;

    virtual void onStoreFavoriteResult(const ::boost::shared_ptr< MOST_PhonBk_FIProxy >& proxy, const ::boost::shared_ptr< StoreFavoriteResult >& result) = 0;
};

class SwitchDownloadOnOffStateCallbackIF {
public:
    virtual ~SwitchDownloadOnOffStateCallbackIF() {}

    virtual void onSwitchDownloadOnOffStateError(const ::boost::shared_ptr< MOST_PhonBk_FIProxy >& proxy, const ::boost::shared_ptr< SwitchDownloadOnOffStateError >& error) = 0;

    virtual void onSwitchDownloadOnOffStateResult(const ::boost::shared_ptr< MOST_PhonBk_FIProxy >& proxy, const ::boost::shared_ptr< SwitchDownloadOnOffStateResult >& result) = 0;
};

class MOST_PhonBk_FIProxyCallback;

/**
 * MOST_PhonBk_FIProxy is the client side representation of the CCA
 * Functional Interface 'MOST_PhonBk_FI' (specified in file
 * most_PhonBk_fi.xml).
 *
 * CCA Functional Interface 'MOST_PhonBk_FI'
 *
 * Fullname: Proprietary - PhoneBook
 *
 * Version: 3.0
 *
 * Author: Dave Pop, General Motors
 *
 * Date: 2012-04-04
 *
 * Department:
 *
 * Title:
 *             MOST_PhoneBook_FI
 *
 * <b>Description of 'MOST_PhonBk_FI':</b>
 *
 * <p>This FBlock was assembled from FBlockManifest file: PhoneBook.fblockman, Please consult individual interface files for interface-specific change history.</p>
 * The PhoneBook FBlock handles the contacts in customer portable devices, generally portable Bluetooth phones.  The PhoneBook contains functions for sorting, browsing, and retrieving contact information within the phone book of a portable device.
 * The PhoneBook FBlock implements the IPhoneBook and IFavoritesProvider interfaces.  IPhoneBook contains functions that are used by HMI controllers to control the PhoneBook and retrieve contact information.  IFavoritesProvider is implemented to support such favorites behaviors as speed dialing a particular contact or automatically routing to a contact address using the on-board navigation system.
 * See GIS-367 for detailed feature and dynamic requirements for the PhoneBook FBlock.
 */
class MOST_PhonBk_FIProxy : public ::asf::cca::CcaProxy
{
public:

    /**
     * Create a new instance of MOST_PhonBk_FIProxy. The caller has to pass
     * the port name and the service information. It is only possible to use
     * this function if the port is defined in the CMC model as "wired at
     * runtime"-port. The application id of the CCA Server will be determined
     * with help of the CCA SrvSupplier messages. It's guranteed that the
     * corresponding CCA server will have the specified major version and at
     * least the specified minor version of that interface.
     */
    static ::boost::shared_ptr< MOST_PhonBk_FIProxy > createProxy(const std::string& portName, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags = ::asf::cca::CcaProxy::SERVICE_REGISTER);

    /**
     * Create a new instance of MOST_PhonBk_FIProxy. The caller has to pass
     * the port name and the service information. It is only possible to use
     * this function if the port is defined in the CMC model as "wired at
     * runtime"-port. The proxy will connect to the CCA application specified
     * by appId. The CCA SrvSupplier messages will be used to determine the
     * availability of this application and the service. It's guranteed that
     * the corresponding CCA server will have the specified major version and
     * at least the specified minor version of that interface.
     */
    static ::boost::shared_ptr< MOST_PhonBk_FIProxy > createProxy(const std::string& portName, uint16 appId, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags = ::asf::cca::CcaProxy::SERVICE_REGISTER);

    /**
     * Create a new instance of MOST_PhonBk_FIProxy. The caller has to pass
     * the port name. The port name is defined in the "Car Multimedia
     * Component" model. With the help of the port name it is possible to
     * address the concrete proxy, which is defined in the CMC model
     * description.
     */
    static ::boost::shared_ptr< MOST_PhonBk_FIProxy > createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    /**
     * Destructor of MOST_PhonBk_FIProxy. The destructor will send RelUpReg
     * messages for all property notifications and call the error callback of
     * all pending method invocations.
     */
    ~MOST_PhonBk_FIProxy();

    // Method 'StoreFavorite'

    /**
     * Call the method 'StoreFavorite'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'StoreFavorite'</b>:
     *
     * <p>
     * The StoreFavorite function stores in persistent memory recall
     * information for the object identified by the ObjectID. The recall
     * information stored enables the following actions to be performed at a
     * later time:
     * </p>
     *
     * <item>
     * Activate the favorite
     * </item>
     * <item>
     * Determine if the favorite is currently active
     * </item>
     * <item>
     * Determine if the favorite is currently available
     * </item>
     * <item>
     * Determine the current LabelText and DescriptorText strings
     * </item>
     *
     * <p>
     * The StoreFavorite function assigns a locally-unique FavoriteID to the
     * new favorite. This FavoriteID and recall information are bound and
     * stored in persistent memory.
     * </p>
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param u32ObjectID <p>
     * The ObjectID parameter identifies the object, e.g. song, contact phone number or destination, to be added as a favorite.  The ObjectID is used by the Favorite Provider to determine what recall information to store.  The Favorite Provider is responsible for assigning an ObjectID to each object which can be stored as a favorite and passing this information to the HMI whenever the associated object is passed to the HMI.
     *
     * Note:  An ObjectID = 0 represents the currently playing object or current settings, e.g. the AM/FM frequency tuned to or the current HVAC settings.
     * </p>
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendStoreFavoriteStart(StoreFavoriteCallbackIF& cb, uint32 u32ObjectID);

    // Method 'ActivateFavorite'

    /**
     * Call the method 'ActivateFavorite'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'ActivateFavorite'</b>:
     *
     * <p>
     * The ActivateFavorite function activates the favorite identified by the
     * FavoriteID parameter if f the AudioChannel and VideoChannel are
     * appropriate for the favorite. If the AudioChannel or the VideoChannel
     * are not appropriate then an error is returned.
     * </p>
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param u16FavoriteID <p>
     * The FavoriteID uniquely identifies a stored favorite. The value of
     * 0x0000 is reserved for a special case. A FavoriteID = 0x0000 refers to
     * all favorites stored.
     * </p>
     *
     * @param e8AudioChannel <p>
     * The AudioChannel parameter specifies the channel to route the favorite's
     * audio to.
     * </p>
     *
     * @param e8VideoChannel <p>
     * The VideoChannel parameter specifies the channel to route the favorite's video to.
     * </p>
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendActivateFavoriteStart(ActivateFavoriteCallbackIF& cb, uint16 u16FavoriteID, ::most_FavPrv_fi_types::T_e8_FavPrvAudioChannel e8AudioChannel, ::most_FavPrv_fi_types::T_e8_FavPrvVideoChannel e8VideoChannel);

    // Method 'DeleteFavorite'

    /**
     * Call the method 'DeleteFavorite'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'DeleteFavorite'</b>:
     *
     * <p>
     * The DeleteFavorite function deletes the favorite identified by the FavoriteID parameter.
     *
     * If FavoriteID=0 then all favorites are to be deleted.
     * </p>
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param u16FavoriteID <p>
     * The FavoriteID uniquely identifies a stored favorite. The value of
     * 0x0000 is reserved for a special case. A FavoriteID = 0x0000 refers to
     * all favorites stored.
     * </p>
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDeleteFavoriteStart(DeleteFavoriteCallbackIF& cb, uint16 u16FavoriteID);

    // Method 'GetFavoriteInfo'

    /**
     * Call the method 'GetFavoriteInfo'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'GetFavoriteInfo'</b>:
     *
     * The GetFavoriteInfo function provides FavoriteInfo for 1 or all Favorites stored in the Favorite Provider.  If the FavoriteID parameter = 0 then FavoriteInfo constains data for all stored favorites.  Otherwise, only FavoriteInfo only contains data for FavoriteID.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param u16FavoriteID <p>
     * The FavoriteID uniquely identifies a stored favorite. The value of
     * 0x0000 is reserved for a special case. A FavoriteID = 0x0000 refers to
     * all favorites stored.
     * </p>
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGetFavoriteInfoStart(GetFavoriteInfoCallbackIF& cb, uint16 u16FavoriteID);

    // Method 'ResetFavorites'

    /**
     * Call the method 'ResetFavorites'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'ResetFavorites'</b>:
     *
     * The ResetFavorites function causes the Favorite Provider to remove all favorites from its Stored Favorites and then rebuild its Stored Favorites with its Default Favorites.   This function returns NumStoredFavorites which is the number of favorites in the Stored Favorites.
     *
     * Note:  Not all Favorites Providers will have Default Favorites to rebuild the Stored Favorites List with.  In this case, the Stored Favorites List will be empty as a result of this function and NumStoredFavorites will be 0.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendResetFavoritesStart(ResetFavoritesCallbackIF& cb);

    // Method 'CreatePhoneBookList'

    /**
     * Call the method 'CreatePhoneBookList'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'CreatePhoneBookList'</b>:
     *
     * Creates a Phone Book list of a particular type and returns a ListHandle to the caller.  Slices of the list can then be accessed via RequestPhoneBookListSlice.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param u8DeviceHandle Handle of the device for the phone book source. The vehicle phone book has a DeviceHandle = 1.
     *
     * @param e8PhoneBookSortType Passed in CreatePhoneBookList to set the sort order of a created list.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendCreatePhoneBookListStart(CreatePhoneBookListCallbackIF& cb, uint8 u8DeviceHandle, ::most_PhonBk_fi_types::T_e8_PhonBkPhoneBookSortType e8PhoneBookSortType);

    // Method 'SearchKeyboardPhoneBookList'

    /**
     * Call the method 'SearchKeyboardPhoneBookList'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'SearchKeyboardPhoneBookList'</b>:
     *
     * This function returns the search keyboard for a particular ListHandle. The
     * returned list identifies which letters of the Vertical Keyboard have at
     * least one Phone Book entry that starts with that letter. The index of the
     * first entry associated with the letter is also provided.If a
     * letter does not have an index then a Phone Book entry that starts with
     * that letter does not exist.Note that the returned search keyboard
     * list may no longer be valid if items in the underlying list have changed.
     * Thus, controllers shall re-request the search keyboard list upon a receipt
     * of MediaPlayerListChange for the ListHandle tied to the returned search
     * keyboard.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param u16ListHandle The ListHandle parameter is a unique handle for a created list. The handle is valid until the ReleaseList function is called with this handle or the system is shut down.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSearchKeyboardPhoneBookListStart(SearchKeyboardPhoneBookListCallbackIF& cb, uint16 u16ListHandle);

    // Method 'ReleasePhoneBookList'

    /**
     * Call the method 'ReleasePhoneBookList'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'ReleasePhoneBookList'</b>:
     *
     * The ReleasePhoneBookList function releases a list which has been created by the CreatePhoneBookList function.  The list to release is specified by the ListHandle parameter. The ListHandle becomes invalid by this function.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param u16ListHandle The ListHandle parameter is a unique handle for a created list. The handle is valid until the ReleaseList function is called with this handle or the system is shut down.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendReleasePhoneBookListStart(ReleasePhoneBookListCallbackIF& cb, uint16 u16ListHandle);

    // Method 'GetContactDetails'

    /**
     * Call the method 'GetContactDetails'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'GetContactDetails'</b>:
     *
     * Retrieves the detailed information for a particular contact based on filter type selected and identified by the supplied ContactHandle.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param u32ContactHandle This is the globally unique ID for a particular contact. The ID is unique across all currently connected devices.
     *
     * @param e8ContactDetailFilter Defines the filter types which can be applied when requesting contact details.  When a filter is applied only the types specified by the filter shall have data.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGetContactDetailsStart(GetContactDetailsCallbackIF& cb, uint32 u32ContactHandle, ::most_PhonBk_fi_types::T_e8_PhonBkContactDetailFilter e8ContactDetailFilter);

    // Method 'GetContactPhoto'

    /**
     * Call the method 'GetContactPhoto'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'GetContactPhoto'</b>:
     *
     * Acquires the photo associated with a contact. This function returns the
     * image encoded as it has been received by the phone device, typically
     * this will be JPEG or GIF or PNG.
     * HMI controllers should call this method without prior calling the method GetContactPhotoInfo.
     * The method GetContactPhotoInfo has become deprecated.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param u32ContactHandle This is the globally unique ID for a particular contact. The ID is unique across all currently connected devices.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGetContactPhotoStart(GetContactPhotoCallbackIF& cb, uint32 u32ContactHandle);

    // Method 'AddContact'

    /**
     * Call the method 'AddContact'. This method sends a MethodStart message
     * to the CCA server.
     *
     * <b>Documentation of 'AddContact'</b>:
     *
     * Adds new contact to the appropriate source phone book (i.e. Vehicle Contact List)
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param u8DeviceHandle Handle of the device for the phone book source. The vehicle phone book has a DeviceHandle = 1.
     *
     * @param oContactDetails If a type is empty then the type shall not be displayed
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAddContactStart(AddContactCallbackIF& cb, uint8 u8DeviceHandle, const ::most_PhonBk_fi_types::T_PhonBkContactDetails& oContactDetails);

    // Method 'DeleteContact'

    /**
     * Call the method 'DeleteContact'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'DeleteContact'</b>:
     *
     * Deletes a contact based on its ContactHandle. The Result response includes the ContactDeleteStatus and the ContactHandle of the message requested for deletion.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param u8DeviceHandle Handle of the device for the phone book source. The vehicle phone book has a DeviceHandle = 1.
     *
     * @param u32ContactHandle This is the globally unique ID for a particular contact. The ID is unique across all currently connected devices.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDeleteContactStart(DeleteContactCallbackIF& cb, uint8 u8DeviceHandle, uint32 u32ContactHandle);

    // Method 'EditContact'

    /**
     * Call the method 'EditContact'. This method sends a MethodStart message
     * to the CCA server.
     *
     * <b>Documentation of 'EditContact'</b>:
     *
     * Updates an existing contact with modifications and/or additions to the contact detail field(s) as entered by the user.
     *
     * The function is initiated upon the contact being saved.
     *
     * The Result response includes the ContactEditStatus and the ContactHandle of the contact requested for modification.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param u8DeviceHandle Handle of the device for the phone book source. The vehicle phone book has a DeviceHandle = 1.
     *
     * @param u32ContactHandle This is the globally unique ID for a particular contact. The ID is unique across all currently connected devices.
     *
     * @param oContactDetails If a type is empty then the type shall not be displayed
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendEditContactStart(EditContactCallbackIF& cb, uint8 u8DeviceHandle, uint32 u32ContactHandle, const ::most_PhonBk_fi_types::T_PhonBkContactDetails& oContactDetails);

    // Method 'CreateCallHistoryList'

    /**
     * Call the method 'CreateCallHistoryList'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'CreateCallHistoryList'</b>:
     *
     * Creates a Call History list of a particular type and returns a ListHandle to the caller.  Slices of the list can then be accessed via RequestCallHistoryListSlice.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param u8DeviceHandle Handle of the device for the phone book source. The vehicle phone book has a DeviceHandle = 1.
     *
     * @param e8CallHistoryType Type of recent call or call history list.
     *
     * @param e8CallHistorySortType Passed in CreateCallHistoryList to set the sort order of a created list.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendCreateCallHistoryListStart(CreateCallHistoryListCallbackIF& cb, uint8 u8DeviceHandle, ::most_PhonBk_fi_types::T_e8_PhonBkCallHistoryType e8CallHistoryType, ::most_PhonBk_fi_types::T_e8_PhonBkCallHistorySortType e8CallHistorySortType);

    // Method 'RequestSliceCallHistoryList'

    /**
     * Call the method 'RequestSliceCallHistoryList'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'RequestSliceCallHistoryList'</b>:
     *
     * The RequestSliceCallHistoryList method provides a slice of the sorted call history list type specified by the ListHandle parameter. The slice begins with the item at location WindowStart and includes in sequential order the number of items specified by the parameter WindowSize.  The RequestSliceCallHistoryList method returns the slice as a CallHistoryList stream.  If the number of items in the list starting at WindowStart is less than the WindowSize parameter then the number of items provided in the slice will be less than the WindowSize calling parameter.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param u16ListHandle The ListHandle parameter is a unique handle for a created list. The handle is valid until the ReleaseList function is called with this handle or the system is shut down.
     *
     * @param u32WindowStart Specifies the start index of the required section inside the total list.
     *
     * @param u16WindowSize Specifies the size of the required section inside the total list.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendRequestSliceCallHistoryListStart(RequestSliceCallHistoryListCallbackIF& cb, uint16 u16ListHandle, uint32 u32WindowStart, uint16 u16WindowSize);

    // Method 'ClearMissedCallIndicator'

    /**
     * Call the method 'ClearMissedCallIndicator'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'ClearMissedCallIndicator'</b>:
     *
     * This Method clears the missed called indicator on a particular device. It is initiated when the user selects to view Recent Calls. The FBlock shall also issue a Status notification update of the MissedCallIndicator property set to zero to registered controllers.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param u8DeviceHandle Handle of the device for the phone book source. The vehicle phone book has a DeviceHandle = 1.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendClearMissedCallIndicatorStart(ClearMissedCallIndicatorCallbackIF& cb, uint8 u8DeviceHandle);

    // Method 'SearchPhoneBook'

    /**
     * Call the method 'SearchPhoneBook'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'SearchPhoneBook'</b>:
     *
     * This is a request from the HMI to search the phone book for a contact name (first and last) and contact detail type that matches the phone number or email address received from the ITelephone or IMessaging FBlock.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param u8DeviceHandle Handle of the device for the phone book source. The vehicle phone book has a DeviceHandle = 1.
     *
     * @param sPhoneNumber
     *
     * @param sEmailAddress
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSearchPhoneBookStart(SearchPhoneBookCallbackIF& cb, uint8 u8DeviceHandle, const ::fi_basetypes_most::T_String& sPhoneNumber, const ::fi_basetypes_most::T_String& sEmailAddress);

    // Method 'ReleaseCallHistoryList'

    /**
     * Call the method 'ReleaseCallHistoryList'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'ReleaseCallHistoryList'</b>:
     *
     * The ReleaseCallHistoryList function releases a list which has been created by the CreateCallHistoryList function.  The list to release is specified by the ListHandle parameter. The ListHandle becomes invalid by this function.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param u16ListHandle The ListHandle parameter is a unique handle for a created list. The handle is valid until the ReleaseList function is called with this handle or the system is shut down.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendReleaseCallHistoryListStart(ReleaseCallHistoryListCallbackIF& cb, uint16 u16ListHandle);

    // Method 'GetContactPhotoInfo'

    /**
     * Call the method 'GetContactPhotoInfo'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'GetContactPhotoInfo'</b>:
     *
     * This method GetContactPhotoInfo has become DEPRECATED. HMI Controllers are recommended to call
     * the method GetContactPhoto directly without a prior call of GetContactPhotoInfo.
     *
     * Acquires the photo MIME image subtype and the size of the image. If the MIMEImageSubtype = NULL then there is no photo associated with the ContactHandle.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param u32ContactHandle This is the globally unique ID for a particular contact. The ID is unique across all currently connected devices.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGetContactPhotoInfoStart(GetContactPhotoInfoCallbackIF& cb, uint32 u32ContactHandle);

    // Method 'GetDeviceCallHistorySupport'

    /**
     * Call the method 'GetDeviceCallHistorySupport'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'GetDeviceCallHistorySupport'</b>:
     *
     * This Method identifies the device call history support. Specifically, it identifies the call history list types supported by the device and whether the lists support date/time.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param u8DeviceHandle Handle of the device for the phone book source. The vehicle phone book has a DeviceHandle = 1.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGetDeviceCallHistorySupportStart(GetDeviceCallHistorySupportCallbackIF& cb, uint8 u8DeviceHandle);

    // Method 'AutocompletePhoneNumberEntry'

    /**
     * Call the method 'AutocompletePhoneNumberEntry'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'AutocompletePhoneNumberEntry'</b>:
     *
     * This method is used to acquire the phone number match to the recent call history list as the user enters phone number digits. In addition, the PhoneBook identifies if a match exists using the AutocompleteMatch parameter, and also returns the number of matches (NumberOfMatches), and the ID of the list of multiple matches for the phone number digits provided (AutocompleteMultipleMatchListID). The AutocompleteMultipleMatchListID is used to display the list of multiple matches for the phone number digits provided.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param sPhoneNumberDigits The digits that make up the phone number as entered by the user.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAutocompletePhoneNumberEntryStart(AutocompletePhoneNumberEntryCallbackIF& cb, const ::fi_basetypes_most::T_String& sPhoneNumberDigits);

    // Method 'ClearPhoneBookData'

    /**
     * Call the method 'ClearPhoneBookData'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'ClearPhoneBookData'</b>:
     *
     * This function is called to clear out all contact and personal information from within the Phone Book as well as the Vehicle Phone Book identified by DeviceHandle = 1.  Upon receipt of the StartAck optype,the PhoneBook FBlock shall permanently delete all contact information from both temporary (e.g. DRAM) and permanent (Flash) memory.
     *
     * This function is used, for example, to delete all the phone book contacts when a vehicle is turned-in at the end of lease.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendClearPhoneBookDataStart(ClearPhoneBookDataCallbackIF& cb);

    // Method 'RequestPhoneBookListSlice'

    /**
     * Call the method 'RequestPhoneBookListSlice'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'RequestPhoneBookListSlice'</b>:
     *
     * The RequestPhoneBookListSlice method provides a slice of the filtered list specified by the ListHandle parameter. The slice begins with the item at location WindowStart and includes in sequential order the number of items specified by the parameter WindowSize.
     *
     * The RequestPhoneBookListSlice method returns the slice as a PhoneBookList stream.  If the number of items in the list starting at WindowStart is less than the WindowSize parameter then the number of items provided in the slice will be less than the WindowSize calling parameter.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param u16ListHandle The ListHandle parameter is a unique handle for a created list. The handle is valid until the ReleaseList function is called with this handle or the system is shut down.
     *
     * @param u32WindowStart Specifies the start index of the required section inside the total list.
     *
     * @param u16WindowSize Specifies the size of the required section inside the total list.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendRequestPhoneBookListSliceStart(RequestPhoneBookListSliceCallbackIF& cb, uint16 u16ListHandle, uint32 u32WindowStart, uint16 u16WindowSize);

    // Method 'ClearVehiclePhoneBook'

    /**
     * Call the method 'ClearVehiclePhoneBook'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'ClearVehiclePhoneBook'</b>:
     *
     * This Method deletes all information from the vehicle phone book
     * (DeviceHandle=1). Upon receipt of the StartAck optype, the FBlock shall
     * delete all entries within the phone and notify all controllers that have
     * created lists on the vehicle phone book via the ListChange property.Note
     * that this function is different from the ClearPhoneBookData method in that
     * only the vehicle phone book is cleared. ClearPhoneBookData clears BOTH the
     * vehicle phone book and all of the customer device phone book information.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendClearVehiclePhoneBookStart(ClearVehiclePhoneBookCallbackIF& cb);

    // Method 'RequestSliceCallHistoryListExtended'

    /**
     * Call the method 'RequestSliceCallHistoryListExtended'. This method
     * sends a MethodStart message to the CCA server.
     *
     * <b>Documentation of 'RequestSliceCallHistoryListExtended'</b>:
     *
     * The RequestSliceCallHistoryList method provides a slice of the sorted call history list type specified by the ListHandle parameter. The slice begins with the item at location WindowStart and includes in sequential order the number of items specified by the parameter WindowSize.  The RequestSliceCallHistoryList method returns the slice as a CallHistoryList stream.  If the number of items in the list starting at WindowStart is less than the WindowSize parameter then the number of items provided in the slice will be less than the WindowSize calling parameter.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param u16ListHandle The ListHandle parameter is a unique handle for a created list. The handle is valid until the ReleaseList function is called with this handle or the system is shut down.
     *
     * @param u32WindowStart Specifies the start index of the required section inside the total list.
     *
     * @param u16WindowSize Specifies the size of the required section inside the total list.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendRequestSliceCallHistoryListExtendedStart(RequestSliceCallHistoryListExtendedCallbackIF& cb, uint16 u16ListHandle, uint32 u32WindowStart, uint16 u16WindowSize);

    // Method 'RequestPhoneBookListSliceExtended'

    /**
     * Call the method 'RequestPhoneBookListSliceExtended'. This method sends
     * a MethodStart message to the CCA server.
     *
     * <b>Documentation of 'RequestPhoneBookListSliceExtended'</b>:
     *
     * The RequestPhoneBookListSlice method provides a slice of the filtered list specified by the ListHandle parameter. The slice begins with the item at location WindowStart and includes in sequential order the number of items specified by the parameter WindowSize.
     * The RequestPhoneBookListSlice method returns the slice as a PhoneBookList stream.  If the number of items in the list starting at WindowStart is less than the WindowSize parameter then the number of items provided in the slice will be less than the WindowSize calling parameter.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param u16ListHandle The ListHandle parameter is a unique handle for a created list. The handle is valid until the ReleaseList function is called with this handle or the system is shut down.
     *
     * @param u32WindowStart Specifies the start index of the required section inside the total list.
     *
     * @param u16WindowSize Specifies the size of the required section inside the total list.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendRequestPhoneBookListSliceExtendedStart(RequestPhoneBookListSliceExtendedCallbackIF& cb, uint16 u16ListHandle, uint32 u32WindowStart, uint16 u16WindowSize);

    // Method 'SearchContacts'

    /**
     * Call the method 'SearchContacts'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'SearchContacts'</b>:
     *
     * This method searches the contacts containing the given SearchString. The search can be configured as:
     * a. The search can be executed in one or more device lists (For instance Vehicle Contacts and Contacts of a connected phone device)
     * b. The fields(e.g. FirstName, LastName, Phone Number) in which search is done are selectable via a bit field FieldSelector
     * c. The search will be stopped when a number, of already found matches, has reached the given value of MaximumReportedMatches
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param oDeviceHandleList The DeviceHandleList parameter contains 1 or more DeviceHandle. The list needs to contain 1 DeviceHandle at minimum, thereby allowing search across several device lists in parallel. The order of a DeviceHandle in this list defines the priority for searching, e.g. [1, 2] would define to search in Vehicle-Contacts (DeviceHandle= 1) with first priority and in the Contact data of the phone device with handle 2 with second priority.
     *
     * @param u16FieldSelector The field selector defines the fields where search has to be done. Based on the bit set search will be performed in the corresponding field.
     * PB_FieldSelector_FirstName  = 0x0001
     * PB_FieldSelector_LastName   = 0x0002
     * PB_FieldSelector_PoiName    = 0x0004
     * PB_FieldSelector_Address    = 0x0008 (any of the address columns)
     * PB_FieldSelector_Email      = 0x0010 (any of the E-Mail columns)
     * PB_FieldSelector_Number     = 0x0020 (any of phone number columns)
     *
     * @param sSearchString The SearchString defines the search terms to be searched for. Maximum number of characters: 100.
     *
     * @param e8SearchSortType The SearchSortType defines the sorting order in which the search result has to be sorted.
     *
     * @param u16MaxReportedMatches The search will be stopped when the number of already found matches is reaching this value.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSearchContactsStart(SearchContactsCallbackIF& cb, const ::most_PhonBk_fi_types_Extended::T_PhonBkDeviceHandleList& oDeviceHandleList, uint16 u16FieldSelector, const ::fi_basetypes_most::T_String& sSearchString, ::most_PhonBk_fi_types_Extended::T_e8_PhonBkSearchSortType e8SearchSortType, uint16 u16MaxReportedMatches);

    // Method 'StartPbDownload'

    /**
     * Call the method 'StartPbDownload'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'StartPbDownload'</b>:
     *
     * This method will start the manual phonebook download for the given device
     * The given DeviceHandle shall correspond to the connected phone, which currently has the HFP connection (outgoing source device)
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param u8DeviceHandle Unique handle for each one of the devices(up to 10 external devices) that can be paired.  Handles are maintained by BluetoothSettings FBlock.  0 is reserved as Null. Valid handles are 1..11 inclusive. Where DeviceHandle 1 corresponds to VehiclePhoneBook
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendStartPbDownloadStart(StartPbDownloadCallbackIF& cb, uint8 u8DeviceHandle);

    // Method 'SwitchDownloadOnOffState'

    /**
     * Call the method 'SwitchDownloadOnOffState'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'SwitchDownloadOnOffState'</b>:
     *
     * This method will switch the  phonebook download status to on or off. Values should be 0x00 for PB_DL_ON 0x01 for PB_DL_OFF
     * Phonebook and call history download of each paired device depends on this method
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param u8DeviceHandle Unique handle for each one of the devices(up to 10 external devices) that can be paired.  Handles are maintained by BluetoothSettings FBlock.  0 is reserved as Null. Valid handles are 1..11 inclusive. Where DeviceHandle 1 corresponds to VehiclePhoneBook
     *
     * @param u8DownloadOnOffState DownloadOnOff state for the particular device handle selected
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSwitchDownloadOnOffStateStart(SwitchDownloadOnOffStateCallbackIF& cb, uint8 u8DeviceHandle, uint8 u8DownloadOnOffState);

    // Method 'CreateContactList'

    /**
     * Call the method 'CreateContactList'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'CreateContactList'</b>:
     *
     * Creates a contact list of a particular type and returns a ListHandle to the caller.
     * Slices of the list can then be accessed via RequestPhoneBookListSlice.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param u8DeviceHandle Handle of the device for the phone book source. The vehicle phone book has a DeviceHandle = 1.
     *
     * @param e8PhoneBkContactListType Passed in CreateContactList to set the sort order of a created list.
     *
     * @param e8PhoneBkContactSortType Passed in CreateContactList to set the type of list(Phone book,Favourite,vehilcePB type).
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendCreateContactListStart(CreateContactListCallbackIF& cb, uint8 u8DeviceHandle, ::most_PhonBk_fi_types_Extended::T_e8_PhonBkContactListType e8PhoneBkContactListType, ::most_PhonBk_fi_types_Extended::T_e8_PhonBkContactSortType e8PhoneBkContactSortType);

    // Method 'SetContactPhoto'

    /**
     * Call the method 'SetContactPhoto'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'SetContactPhoto'</b>:
     *
     * Sets photo for the given contact in vehicle phonebook. This function return with the requested values and confirms that job will be executed.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param u32ContactHandle This is the globally unique ID for a particular contact. The ID is unique across all currently connected devices.
     *
     * @param oVehicleContactPhoto
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSetContactPhotoStart(SetContactPhotoCallbackIF& cb, uint32 u32ContactHandle, const ::most_PhonBk_fi_types::T_PhonBkContactPhoto& oVehicleContactPhoto);

    // Method 'CancelPbDownload'

    /**
     * Call the method 'CancelPbDownload'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'CancelPbDownload'</b>:
     *
     * The user shall have possibility to cancel the ongoing phone book download but not the call history download
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param u8DeviceHandle Unique handle for each one of the devices(up to 10 external devices) that can be paired.  Handles are maintained by BluetoothSettings FBlock.  0 is reserved as Null. Valid handles are 1..11 inclusive. Where DeviceHandle 1 corresponds to VehiclePhoneBook
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendCancelPbDownloadStart(CancelPbDownloadCallbackIF& cb, uint8 u8DeviceHandle);

    // Method 'SetContactPosition'

    /**
     * Call the method 'SetContactPosition'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'SetContactPosition'</b>:
     *
     * Sets the contact postion for the given contacthandle and position in vehicle phonebook. This function return with the requested values and confirms that job will be executed.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param u32ContactHandle This is the globally unique ID for a particular contact. The ID is unique across all currently connected devices.
     *
     * @param u32ContactPosition
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSetContactPositionStart(SetContactPositionCallbackIF& cb, uint32 u32ContactHandle, uint32 u32ContactPosition);

    // Method 'AddContactExtended'

    /**
     * Call the method 'AddContactExtended'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'AddContactExtended'</b>:
     *
     * Adds new contact(Extended) to the vehicle phone book (i.e. Vehicle Contact List)
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param u8DeviceHandle Handle of the device for the phone book source.
     * The vehicle phone book has a DeviceHandle = 1.
     *
     * @param oContactDetailsExtended This is the type for Contact details(extended) with
     * option to add a maximum of 8 different phone numbers and their types.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAddContactExtendedStart(AddContactExtendedCallbackIF& cb, uint8 u8DeviceHandle, const ::most_PhonBk_fi_types_Extended::T_PhonBkContactDetailsExtended& oContactDetailsExtended);

    // Method 'EditContactExtended'

    /**
     * Call the method 'EditContactExtended'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'EditContactExtended'</b>:
     *
     * Updates an existing vehicle phonebook
     * contact with modifications and/or additions to the contact detail field(s) as entered by the user.
     *
     * The function is initiated upon the contact being saved.
     * The Result response includes the
     * ContactEditStatus and the ContactHandle
     * of the contact requested
     * for modification.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param u8DeviceHandle Handle of the device for the phone book source.
     * The vehicle phone book has a DeviceHandle = 1.
     *
     * @param u32ContactHandle This is the globally unique ID for a particular
     * contact. The ID is unique across all currently connected
     * devices.
     *
     * @param oContactDetailsExtended This is the type for Contact details(extended) with
     * option to add a maximum of 8 different phone numbers and their types.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendEditContactExtendedStart(EditContactExtendedCallbackIF& cb, uint8 u8DeviceHandle, uint32 u32ContactHandle, const ::most_PhonBk_fi_types_Extended::T_PhonBkContactDetailsExtended& oContactDetailsExtended);

    // Method 'GetContactDetailsExtended'

    /**
     * Call the method 'GetContactDetailsExtended'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'GetContactDetailsExtended'</b>:
     *
     * Retrieves the detailed information for a particular
     * vehicle contact (Extended) selected and identified by the
     * supplied ContactHandle.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param u32ContactHandle This is the globally unique ID for a particular
     * device specific vehicle contact. The ID is unique across all
     * currently connected devices.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGetContactDetailsExtendedStart(GetContactDetailsExtendedCallbackIF& cb, uint32 u32ContactHandle);

    // Method 'ClearVehiclePhonebookExtended'

    /**
     * Call the method 'ClearVehiclePhonebookExtended'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'ClearVehiclePhonebookExtended'</b>:
     *
     * This method clears all vehicle phonebook entries from a specific vehicle phonebook. [VPBx]
     * It can also clear all the entries from all the vehicle phonebooks at once [1-11] (For reset to factory default.)
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param u8DeviceHandle Unique handle for each one of the devices(up to 10 external devices) that can be paired. Valid handles are 1..11 inclusive, where DeviceHandle 1 corresponds to VehiclePhoneBook.
     * When Device handle is set to ZERO, this interface clears all the entries from the all the vehicle phonebooks [VPB1 to VPB11].
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendClearVehiclePhonebookExtendedStart(ClearVehiclePhonebookExtendedCallbackIF& cb, uint8 u8DeviceHandle);

    // Method 'SetAutomaticContactDownload'

    /**
     * Call the method 'SetAutomaticContactDownload'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'SetAutomaticContactDownload'</b>:
     *
     * This method allows to define individual for a paired phone device, if the phonebook contact data is synchronized or not synchronized, when a phone device gets re-connected.
     * This setting does not affect the call history download. The call history lists are still downloaded when a phone gets connected (or refreshed after a call has ended).
     * False: The automatic download is deactivated.
     * True : The automatic download is activated.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param u8DeviceHandle Handle of the Device.
     * DeviceHandle 2, .. 11 means the setting is individual for the given device handle.
     * DeviceHandle 1 will result in a success (MethodResult), but no dedicated action is done, as the VehicleContact list is never downloaded.
     * Devicehandle 0 means that the given AutomatciDownload setting is applied to all paired phones.
     *
     * @param bAutomaticDL True : The automatic download is activated.
     * False: The automatic download is deactivated.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSetAutomaticContactDownloadStart(SetAutomaticContactDownloadCallbackIF& cb, uint8 u8DeviceHandle, bool bAutomaticDL);

    // Method 'GetPositionForContactHandle'

    /**
     * Call the method 'GetPositionForContactHandle'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'GetPositionForContactHandle'</b>:
     *
     * This method can be called for a dedicated contact list (identified by the u16ListHandle) to find out at which position in this list a contact (identified via its u32ContactHandle) is located.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param u16ListHandle Identifies the contact list (which was created via method CreateContactList or CreatePhoneBookList)
     *
     * @param u32ContactHandle Identifies the contact for which the position in the contact list has to be returned.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGetPositionForContactHandleStart(GetPositionForContactHandleCallbackIF& cb, uint16 u16ListHandle, uint32 u32ContactHandle);

    // Property 'FavoritesChanged'

    /**
     * Notify on the property 'FavoritesChanged'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'FavoritesChanged'</b>:
     *
     * The FavoritesChanged property provides notification about changes that
     * occurred to the stored favorites. These changes include:
     *
     *
     * <item>
     * Addition of a new favorite
     * </item>
     * <item>
     * Deletion of a favorite
     * </item>
     * <item>
     * Change of any of the information in the FavoriteInfo record for a
     * favorite
     * </item>
     * <item>
     * Determination of all the FavoriteInfo for each stored favorite after
     * system initialization
     * </item>
     *
     * <p>
     * The ListChangeType = LCH_CONTENT_CHANGED when the FavoriteInfo record
     * elements have been determined for all stored favorites after system
     * initialization.
     * </p>
     * <p>
     * If the ListChangeType = LCH_CONTENT_CHANGED, i.e. the entire list
     * changed, then NumItems = 0 and the ChangedFavorites array is empty.
     * </p>
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendFavoritesChangedUpReg(FavoritesChangedCallbackIF& cb);

    /**
     * Remove the notifcation on property 'FavoritesChanged'. This method
     * sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'FavoritesChanged'</b>:
     *
     * The FavoritesChanged property provides notification about changes that
     * occurred to the stored favorites. These changes include:
     *
     *
     * <item>
     * Addition of a new favorite
     * </item>
     * <item>
     * Deletion of a favorite
     * </item>
     * <item>
     * Change of any of the information in the FavoriteInfo record for a
     * favorite
     * </item>
     * <item>
     * Determination of all the FavoriteInfo for each stored favorite after
     * system initialization
     * </item>
     *
     * <p>
     * The ListChangeType = LCH_CONTENT_CHANGED when the FavoriteInfo record
     * elements have been determined for all stored favorites after system
     * initialization.
     * </p>
     * <p>
     * If the ListChangeType = LCH_CONTENT_CHANGED, i.e. the entire list
     * changed, then NumItems = 0 and the ChangedFavorites array is empty.
     * </p>
     *
     * @param act The act which was previously returned by the
     * sendFavoritesChangedUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendFavoritesChangedRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'FavoritesChanged'.
     */
    void sendFavoritesChangedRelUpRegAll ();

    /**
     * Returns the current value of the property 'FavoritesChanged' (as known
     * by the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasFavoritesChanged() returns true.
     *
     * @return the previously received value of the property 'FavoritesChanged'.
     */
    const FavoritesChangedStatus& getFavoritesChanged() const;

    /**
     * Determines whether a status message for the property 'FavoritesChanged' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasFavoritesChanged() const;

    // Property 'ListChange'

    /**
     * Notify on the property 'ListChange'. This method sends a UpReg message
     * to the CCA server.
     *
     * <b>Documentation of 'ListChange'</b>:
     *
     * The ListChange property provides notifications about changes that occur in
     * a created list. These changes include:
     *
     *
     * <item>
     * Complete change in items
     * </item>
     * <item>
     * Items changed
     * </item>
     * <item>
     * Items added
     * </item>
     * <item>
     * Items deleted
     * </item>
     *
     * <p>
     * &#160;
     * </p>
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendListChangeUpReg(ListChangeCallbackIF& cb);

    /**
     * Remove the notifcation on property 'ListChange'. This method sends a
     * RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'ListChange'</b>:
     *
     * The ListChange property provides notifications about changes that occur in
     * a created list. These changes include:
     *
     *
     * <item>
     * Complete change in items
     * </item>
     * <item>
     * Items changed
     * </item>
     * <item>
     * Items added
     * </item>
     * <item>
     * Items deleted
     * </item>
     *
     * <p>
     * &#160;
     * </p>
     *
     * @param act The act which was previously returned by the
     * sendListChangeUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendListChangeRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'ListChange'.
     */
    void sendListChangeRelUpRegAll ();

    /**
     * Returns the current value of the property 'ListChange' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when
     * hasListChange() returns true.
     *
     * @return the previously received value of the property 'ListChange'.
     */
    const ListChangeStatus& getListChange() const;

    /**
     * Determines whether a status message for the property 'ListChange' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasListChange() const;

    // Property 'MissedCallIndicator'

    /**
     * Notify on the property 'MissedCallIndicator'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'MissedCallIndicator'</b>:
     *
     * Provides the number of missed calls that occur while the current Outgoing Source Device is connected in the vehicle. The number of missed calls is always zero upon connection to the Outgoing Source Device. As missed calls occur while the Outgoing Source Device is connected in the vehicle the NumMissedCalls is incremented to reflect the number of calls that have been missed.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendMissedCallIndicatorUpReg(MissedCallIndicatorCallbackIF& cb);

    /**
     * Remove the notifcation on property 'MissedCallIndicator'. This method
     * sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'MissedCallIndicator'</b>:
     *
     * Provides the number of missed calls that occur while the current Outgoing Source Device is connected in the vehicle. The number of missed calls is always zero upon connection to the Outgoing Source Device. As missed calls occur while the Outgoing Source Device is connected in the vehicle the NumMissedCalls is incremented to reflect the number of calls that have been missed.
     *
     * @param act The act which was previously returned by the
     * sendMissedCallIndicatorUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendMissedCallIndicatorRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'MissedCallIndicator'.
     */
    void sendMissedCallIndicatorRelUpRegAll ();

    /**
     * Returns the current value of the property 'MissedCallIndicator' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasMissedCallIndicator() returns true.
     *
     * @return the previously received value of the property 'MissedCallIndicator'.
     */
    const MissedCallIndicatorStatus& getMissedCallIndicator() const;

    /**
     * Determines whether a status message for the property 'MissedCallIndicator' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasMissedCallIndicator() const;

    // Property 'DevicePhoneBookFeatureSupport'

    /**
     * Notify on the property 'DevicePhoneBookFeatureSupport'. This method
     * sends a UpReg message to the CCA server.
     *
     * <b>Documentation of 'DevicePhoneBookFeatureSupport'</b>:
     *
     * Identifies support for the phone book list and call history list types for the connected device.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDevicePhoneBookFeatureSupportUpReg(DevicePhoneBookFeatureSupportCallbackIF& cb);

    /**
     * Remove the notifcation on property 'DevicePhoneBookFeatureSupport'.
     * This method sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'DevicePhoneBookFeatureSupport'</b>:
     *
     * Identifies support for the phone book list and call history list types for the connected device.
     *
     * @param act The act which was previously returned by the
     * sendDevicePhoneBookFeatureSupportUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendDevicePhoneBookFeatureSupportRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'DevicePhoneBookFeatureSupport'.
     */
    void sendDevicePhoneBookFeatureSupportRelUpRegAll ();

    /**
     * Returns the current value of the property
     * 'DevicePhoneBookFeatureSupport' (as known by the proxy). This method is
     * only allowed to be called when a status message for this property was
     * received before. Otherwise the behavior of this method is undefined. It
     * is safe to call this method when hasDevicePhoneBookFeatureSupport()
     * returns true.
     *
     * @return the previously received value of the property 'DevicePhoneBookFeatureSupport'.
     */
    const DevicePhoneBookFeatureSupportStatus& getDevicePhoneBookFeatureSupport() const;

    /**
     * Determines whether a status message for the property 'DevicePhoneBookFeatureSupport' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasDevicePhoneBookFeatureSupport() const;

    /**
     * Request the value of the property 'DevicePhoneBookFeatureSupport' from
     * the CCA server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'DevicePhoneBookFeatureSupport'</b>:
     *
     * Identifies support for the phone book list and call history list types for the connected device.
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDevicePhoneBookFeatureSupportGet(DevicePhoneBookFeatureSupportCallbackIF& cb);

    // Property 'PreferredPhoneBookSortOrder'

    /**
     * Notify on the property 'PreferredPhoneBookSortOrder'. This method sends
     * a UpReg message to the CCA server.
     *
     * <b>Documentation of 'PreferredPhoneBookSortOrder'</b>:
     *
     * The PreferredPhoneBookSortOrder property is defined so that all HMI
     * controllers can use the same sort order for phone book lists according to
     * a single user selected as follows:
     *
     *
     * <item>
     * An HMI controller implementing a sort order menu, issues a Set optype
     * to change the preferred sort order in response to a user menu input.
     * </item>
     * <item>
     * Upon receipt of a Set optype that changes the current preferred sort
     * order, the FBlock issues corresponding Status update(s) to all
     * registered HMI controllers.
     * </item>
     * <item>
     * Note that the PhoneBook FBlock does NOT change the sort order of
     * existing lists upon a change in this property. HMI controllers are
     * responsible for creating new lists with the new sort order. This is
     * done by discarding the controller's current PhoneBook list(s) and
     * replacing the displayed list with a new list created by a call to
     * CreatePhoneBookList.StartResultAck where the PhoneBookSortType is
     * seleted based upon this property.
     * </item>
     * <item>
     * In order to avoid flicker at network initialization, HMI controllers
     * using this property in order to determine the sort order in the
     * CreatePhoneBookList.StartResultAck call shall wait until they receive
     * a PreferredPhoneBookSortOrder.Status response prior to the initial
     * CreatePhoneBookList.StartResultAck.  This is necessary to avoid
     * display flicker where the initial created list is immediately replaced
     * by a new one if the controller happens to create a list with the wrong
     * sort order first.
     * </item>
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendPreferredPhoneBookSortOrderUpReg(PreferredPhoneBookSortOrderCallbackIF& cb);

    /**
     * Remove the notifcation on property 'PreferredPhoneBookSortOrder'. This
     * method sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'PreferredPhoneBookSortOrder'</b>:
     *
     * The PreferredPhoneBookSortOrder property is defined so that all HMI
     * controllers can use the same sort order for phone book lists according to
     * a single user selected as follows:
     *
     *
     * <item>
     * An HMI controller implementing a sort order menu, issues a Set optype
     * to change the preferred sort order in response to a user menu input.
     * </item>
     * <item>
     * Upon receipt of a Set optype that changes the current preferred sort
     * order, the FBlock issues corresponding Status update(s) to all
     * registered HMI controllers.
     * </item>
     * <item>
     * Note that the PhoneBook FBlock does NOT change the sort order of
     * existing lists upon a change in this property. HMI controllers are
     * responsible for creating new lists with the new sort order. This is
     * done by discarding the controller's current PhoneBook list(s) and
     * replacing the displayed list with a new list created by a call to
     * CreatePhoneBookList.StartResultAck where the PhoneBookSortType is
     * seleted based upon this property.
     * </item>
     * <item>
     * In order to avoid flicker at network initialization, HMI controllers
     * using this property in order to determine the sort order in the
     * CreatePhoneBookList.StartResultAck call shall wait until they receive
     * a PreferredPhoneBookSortOrder.Status response prior to the initial
     * CreatePhoneBookList.StartResultAck.  This is necessary to avoid
     * display flicker where the initial created list is immediately replaced
     * by a new one if the controller happens to create a list with the wrong
     * sort order first.
     * </item>
     *
     * @param act The act which was previously returned by the
     * sendPreferredPhoneBookSortOrderUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendPreferredPhoneBookSortOrderRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'PreferredPhoneBookSortOrder'.
     */
    void sendPreferredPhoneBookSortOrderRelUpRegAll ();

    /**
     * Returns the current value of the property 'PreferredPhoneBookSortOrder'
     * (as known by the proxy). This method is only allowed to be called when
     * a status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasPreferredPhoneBookSortOrder() returns true.
     *
     * @return the previously received value of the property 'PreferredPhoneBookSortOrder'.
     */
    const PreferredPhoneBookSortOrderStatus& getPreferredPhoneBookSortOrder() const;

    /**
     * Determines whether a status message for the property 'PreferredPhoneBookSortOrder' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasPreferredPhoneBookSortOrder() const;

    /**
     * Request the value of the property 'PreferredPhoneBookSortOrder' from
     * the CCA server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'PreferredPhoneBookSortOrder'</b>:
     *
     * The PreferredPhoneBookSortOrder property is defined so that all HMI
     * controllers can use the same sort order for phone book lists according to
     * a single user selected as follows:
     *
     *
     * <item>
     * An HMI controller implementing a sort order menu, issues a Set optype
     * to change the preferred sort order in response to a user menu input.
     * </item>
     * <item>
     * Upon receipt of a Set optype that changes the current preferred sort
     * order, the FBlock issues corresponding Status update(s) to all
     * registered HMI controllers.
     * </item>
     * <item>
     * Note that the PhoneBook FBlock does NOT change the sort order of
     * existing lists upon a change in this property. HMI controllers are
     * responsible for creating new lists with the new sort order. This is
     * done by discarding the controller's current PhoneBook list(s) and
     * replacing the displayed list with a new list created by a call to
     * CreatePhoneBookList.StartResultAck where the PhoneBookSortType is
     * seleted based upon this property.
     * </item>
     * <item>
     * In order to avoid flicker at network initialization, HMI controllers
     * using this property in order to determine the sort order in the
     * CreatePhoneBookList.StartResultAck call shall wait until they receive
     * a PreferredPhoneBookSortOrder.Status response prior to the initial
     * CreatePhoneBookList.StartResultAck.  This is necessary to avoid
     * display flicker where the initial created list is immediately replaced
     * by a new one if the controller happens to create a list with the wrong
     * sort order first.
     * </item>
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendPreferredPhoneBookSortOrderGet(PreferredPhoneBookSortOrderCallbackIF& cb);

    /**
     * Set the value of the property 'PreferredPhoneBookSortOrder'. This
     * method sends a PureSet message to the CCA server.
     *
     * <b>Documentation of 'PreferredPhoneBookSortOrder'</b>:
     *
     * The PreferredPhoneBookSortOrder property is defined so that all HMI
     * controllers can use the same sort order for phone book lists according to
     * a single user selected as follows:
     *
     *
     * <item>
     * An HMI controller implementing a sort order menu, issues a Set optype
     * to change the preferred sort order in response to a user menu input.
     * </item>
     * <item>
     * Upon receipt of a Set optype that changes the current preferred sort
     * order, the FBlock issues corresponding Status update(s) to all
     * registered HMI controllers.
     * </item>
     * <item>
     * Note that the PhoneBook FBlock does NOT change the sort order of
     * existing lists upon a change in this property. HMI controllers are
     * responsible for creating new lists with the new sort order. This is
     * done by discarding the controller's current PhoneBook list(s) and
     * replacing the displayed list with a new list created by a call to
     * CreatePhoneBookList.StartResultAck where the PhoneBookSortType is
     * seleted based upon this property.
     * </item>
     * <item>
     * In order to avoid flicker at network initialization, HMI controllers
     * using this property in order to determine the sort order in the
     * CreatePhoneBookList.StartResultAck call shall wait until they receive
     * a PreferredPhoneBookSortOrder.Status response prior to the initial
     * CreatePhoneBookList.StartResultAck.  This is necessary to avoid
     * display flicker where the initial created list is immediately replaced
     * by a new one if the controller happens to create a list with the wrong
     * sort order first.
     * </item>
     *
     * @param e8PreferredPhoneBookSortOrder This is the enumeration of allowed phone book sort orders.  HMI controllers should use this information to request the appropriate list order in the PhoneBookSortType enumeration within the CreatePhoneBookList.StartResultAck optype.
     */

    void sendPreferredPhoneBookSortOrderPureSet(::most_PhonBk_fi_types::T_e8_PhonBkPreferredPhoneBookSortOrder e8PreferredPhoneBookSortOrder);

    // Property 'DownloadState'

    /**
     * Notify on the property 'DownloadState'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'DownloadState'</b>:
     *
     * This is the state of the phone book and recent call list downloads from
     * each connected Bluetooth device as follows:
     *
     *
     * <item>
     * There is no Get optype. Controllers register for notification on this
     * function at intialization and receive updates as Bluetooth devices are
     * connected.
     * </item>
     * <item>
     * The stream contains a maximum of two repetitions corresponding to the
     * number of devices that may be simultaneously connected.
     * </item>
     * <item>
     * If no devices are currently connected, the FBlock shall respond to
     * status Notifications with a Null, zero-length stream as a default
     * response.
     * </item>
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDownloadStateUpReg(DownloadStateCallbackIF& cb);

    /**
     * Remove the notifcation on property 'DownloadState'. This method sends a
     * RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'DownloadState'</b>:
     *
     * This is the state of the phone book and recent call list downloads from
     * each connected Bluetooth device as follows:
     *
     *
     * <item>
     * There is no Get optype. Controllers register for notification on this
     * function at intialization and receive updates as Bluetooth devices are
     * connected.
     * </item>
     * <item>
     * The stream contains a maximum of two repetitions corresponding to the
     * number of devices that may be simultaneously connected.
     * </item>
     * <item>
     * If no devices are currently connected, the FBlock shall respond to
     * status Notifications with a Null, zero-length stream as a default
     * response.
     * </item>
     *
     * @param act The act which was previously returned by the
     * sendDownloadStateUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendDownloadStateRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'DownloadState'.
     */
    void sendDownloadStateRelUpRegAll ();

    /**
     * Returns the current value of the property 'DownloadState' (as known by
     * the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasDownloadState() returns true.
     *
     * @return the previously received value of the property 'DownloadState'.
     */
    const DownloadStateStatus& getDownloadState() const;

    /**
     * Determines whether a status message for the property 'DownloadState' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasDownloadState() const;

    // Property 'DownloadStateExtended'

    /**
     * Notify on the property 'DownloadStateExtended'. This method sends a
     * UpReg message to the CCA server.
     *
     * <b>Documentation of 'DownloadStateExtended'</b>:
     *
     * This is the state of the phone book and recent call list downloads from
     * each connected Bluetooth device as follows:
     *
     * <item>
     * There is no Get optype. Controllers register for notification on this
     * function at intialization and receive updates as Bluetooth devices are
     * connected.
     * </item>
     * <item>
     * The stream contains a maximum of two repetitions corresponding to the
     * number of devices that may be simultaneously connected.
     * </item>
     * <item>
     * If no devices are currently connected, the FBlock shall respond to
     * status Notifications with a Null, zero-length stream as a default
     * response.
     * </item>
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDownloadStateExtendedUpReg(DownloadStateExtendedCallbackIF& cb);

    /**
     * Remove the notifcation on property 'DownloadStateExtended'. This method
     * sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'DownloadStateExtended'</b>:
     *
     * This is the state of the phone book and recent call list downloads from
     * each connected Bluetooth device as follows:
     *
     * <item>
     * There is no Get optype. Controllers register for notification on this
     * function at intialization and receive updates as Bluetooth devices are
     * connected.
     * </item>
     * <item>
     * The stream contains a maximum of two repetitions corresponding to the
     * number of devices that may be simultaneously connected.
     * </item>
     * <item>
     * If no devices are currently connected, the FBlock shall respond to
     * status Notifications with a Null, zero-length stream as a default
     * response.
     * </item>
     *
     * @param act The act which was previously returned by the
     * sendDownloadStateExtendedUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendDownloadStateExtendedRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'DownloadStateExtended'.
     */
    void sendDownloadStateExtendedRelUpRegAll ();

    /**
     * Returns the current value of the property 'DownloadStateExtended' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasDownloadStateExtended() returns true.
     *
     * @return the previously received value of the property 'DownloadStateExtended'.
     */
    const DownloadStateExtendedStatus& getDownloadStateExtended() const;

    /**
     * Determines whether a status message for the property 'DownloadStateExtended' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasDownloadStateExtended() const;

    // Property 'DownloadProgress'

    /**
     * Notify on the property 'DownloadProgress'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'DownloadProgress'</b>:
     *
     * The DownloadProgress is sent out while a phonebook download is running. It informs the HMI about the number of contacts,
     * which have already been downloaded and have contributed to the database (either new inserted contacts or verified ones.
     * The property is updated after the next e.g. 100 contacts have been verified or added to the database.
     * (Double contacts do not count to the number of currently downloaded contacts.)
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDownloadProgressUpReg(DownloadProgressCallbackIF& cb);

    /**
     * Remove the notifcation on property 'DownloadProgress'. This method
     * sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'DownloadProgress'</b>:
     *
     * The DownloadProgress is sent out while a phonebook download is running. It informs the HMI about the number of contacts,
     * which have already been downloaded and have contributed to the database (either new inserted contacts or verified ones.
     * The property is updated after the next e.g. 100 contacts have been verified or added to the database.
     * (Double contacts do not count to the number of currently downloaded contacts.)
     *
     * @param act The act which was previously returned by the
     * sendDownloadProgressUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendDownloadProgressRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'DownloadProgress'.
     */
    void sendDownloadProgressRelUpRegAll ();

    /**
     * Returns the current value of the property 'DownloadProgress' (as known
     * by the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasDownloadProgress() returns true.
     *
     * @return the previously received value of the property 'DownloadProgress'.
     */
    const DownloadProgressStatus& getDownloadProgress() const;

    /**
     * Determines whether a status message for the property 'DownloadProgress' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasDownloadProgress() const;

    /**
     * Request the value of the property 'DownloadProgress' from the CCA
     * server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'DownloadProgress'</b>:
     *
     * The DownloadProgress is sent out while a phonebook download is running. It informs the HMI about the number of contacts,
     * which have already been downloaded and have contributed to the database (either new inserted contacts or verified ones.
     * The property is updated after the next e.g. 100 contacts have been verified or added to the database.
     * (Double contacts do not count to the number of currently downloaded contacts.)
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDownloadProgressGet(DownloadProgressCallbackIF& cb);

    // Property 'DownloadProgressList'

    /**
     * Notify on the property 'DownloadProgressList'. This method sends a
     * UpReg message to the CCA server.
     *
     * <b>Documentation of 'DownloadProgressList'</b>:
     *
     * This property is an extension to the DownloadProgress property. It updates the download progress for the list of devices connected via PBAP with the percentage value and the number of contacts downloaded.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDownloadProgressListUpReg(DownloadProgressListCallbackIF& cb);

    /**
     * Remove the notifcation on property 'DownloadProgressList'. This method
     * sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'DownloadProgressList'</b>:
     *
     * This property is an extension to the DownloadProgress property. It updates the download progress for the list of devices connected via PBAP with the percentage value and the number of contacts downloaded.
     *
     * @param act The act which was previously returned by the
     * sendDownloadProgressListUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendDownloadProgressListRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'DownloadProgressList'.
     */
    void sendDownloadProgressListRelUpRegAll ();

    /**
     * Returns the current value of the property 'DownloadProgressList' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasDownloadProgressList() returns true.
     *
     * @return the previously received value of the property 'DownloadProgressList'.
     */
    const DownloadProgressListStatus& getDownloadProgressList() const;

    /**
     * Determines whether a status message for the property 'DownloadProgressList' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasDownloadProgressList() const;

    /**
     * Request the value of the property 'DownloadProgressList' from the CCA
     * server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'DownloadProgressList'</b>:
     *
     * This property is an extension to the DownloadProgress property. It updates the download progress for the list of devices connected via PBAP with the percentage value and the number of contacts downloaded.
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDownloadProgressListGet(DownloadProgressListCallbackIF& cb);

    // Property 'DownloadOnOffList'

    /**
     * Notify on the property 'DownloadOnOffList'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'DownloadOnOffList'</b>:
     *
     * The stream of list which reports the status of this download OnOff setting for all paired phone devices is updated whenever there is a change in download on-off state, device is connected, device deleted and on startup.
     * Values will be like
     * 0x00   PB_DL_ON
     * 0x01   PB_DL_OFF
     * 0x02   PB_DL_IN_TRANSITION_TO_ON
     * 0x03   PB_DL_IN_TRANSITION_TO_OFF
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDownloadOnOffListUpReg(DownloadOnOffListCallbackIF& cb);

    /**
     * Remove the notifcation on property 'DownloadOnOffList'. This method
     * sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'DownloadOnOffList'</b>:
     *
     * The stream of list which reports the status of this download OnOff setting for all paired phone devices is updated whenever there is a change in download on-off state, device is connected, device deleted and on startup.
     * Values will be like
     * 0x00   PB_DL_ON
     * 0x01   PB_DL_OFF
     * 0x02   PB_DL_IN_TRANSITION_TO_ON
     * 0x03   PB_DL_IN_TRANSITION_TO_OFF
     *
     * @param act The act which was previously returned by the
     * sendDownloadOnOffListUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendDownloadOnOffListRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'DownloadOnOffList'.
     */
    void sendDownloadOnOffListRelUpRegAll ();

    /**
     * Returns the current value of the property 'DownloadOnOffList' (as known
     * by the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasDownloadOnOffList() returns true.
     *
     * @return the previously received value of the property 'DownloadOnOffList'.
     */
    const DownloadOnOffListStatus& getDownloadOnOffList() const;

    /**
     * Determines whether a status message for the property 'DownloadOnOffList' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasDownloadOnOffList() const;

    /**
     * Request the value of the property 'DownloadOnOffList' from the CCA
     * server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'DownloadOnOffList'</b>:
     *
     * The stream of list which reports the status of this download OnOff setting for all paired phone devices is updated whenever there is a change in download on-off state, device is connected, device deleted and on startup.
     * Values will be like
     * 0x00   PB_DL_ON
     * 0x01   PB_DL_OFF
     * 0x02   PB_DL_IN_TRANSITION_TO_ON
     * 0x03   PB_DL_IN_TRANSITION_TO_OFF
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDownloadOnOffListGet(DownloadOnOffListCallbackIF& cb);

    // Property 'AutomaticContactDownloadList'

    /**
     * Notify on the property 'AutomaticContactDownloadList'. This method
     * sends a UpReg message to the CCA server.
     *
     * <b>Documentation of 'AutomaticContactDownloadList'</b>:
     *
     * The stream of list which reports the status of this Automaticdownload state setting for all paired phone devices.
     * Values will be like
     * 0x00 The automatic download is deactivated.
     * 0x01 The automatic download is activated.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAutomaticContactDownloadListUpReg(AutomaticContactDownloadListCallbackIF& cb);

    /**
     * Remove the notifcation on property 'AutomaticContactDownloadList'. This
     * method sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'AutomaticContactDownloadList'</b>:
     *
     * The stream of list which reports the status of this Automaticdownload state setting for all paired phone devices.
     * Values will be like
     * 0x00 The automatic download is deactivated.
     * 0x01 The automatic download is activated.
     *
     * @param act The act which was previously returned by the
     * sendAutomaticContactDownloadListUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendAutomaticContactDownloadListRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'AutomaticContactDownloadList'.
     */
    void sendAutomaticContactDownloadListRelUpRegAll ();

    /**
     * Returns the current value of the property
     * 'AutomaticContactDownloadList' (as known by the proxy). This method is
     * only allowed to be called when a status message for this property was
     * received before. Otherwise the behavior of this method is undefined. It
     * is safe to call this method when hasAutomaticContactDownloadList()
     * returns true.
     *
     * @return the previously received value of the property 'AutomaticContactDownloadList'.
     */
    const AutomaticContactDownloadListStatus& getAutomaticContactDownloadList() const;

    /**
     * Determines whether a status message for the property 'AutomaticContactDownloadList' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasAutomaticContactDownloadList() const;

    /**
     * Request the value of the property 'AutomaticContactDownloadList' from
     * the CCA server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'AutomaticContactDownloadList'</b>:
     *
     * The stream of list which reports the status of this Automaticdownload state setting for all paired phone devices.
     * Values will be like
     * 0x00 The automatic download is deactivated.
     * 0x01 The automatic download is activated.
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAutomaticContactDownloadListGet(AutomaticContactDownloadListCallbackIF& cb);

    // Property 'DevicePhoneBookFeatureSupportExtended'

    /**
     * Notify on the property 'DevicePhoneBookFeatureSupportExtended'. This
     * method sends a UpReg message to the CCA server.
     *
     * <b>Documentation of 'DevicePhoneBookFeatureSupportExtended'</b>:
     *
     * Identifies support for the phone book list and call history list types for the connected devices.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDevicePhoneBookFeatureSupportExtendedUpReg(DevicePhoneBookFeatureSupportExtendedCallbackIF& cb);

    /**
     * Remove the notifcation on property
     * 'DevicePhoneBookFeatureSupportExtended'. This method sends a RelUpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'DevicePhoneBookFeatureSupportExtended'</b>:
     *
     * Identifies support for the phone book list and call history list types for the connected devices.
     *
     * @param act The act which was previously returned by the
     * sendDevicePhoneBookFeatureSupportExtendedUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendDevicePhoneBookFeatureSupportExtendedRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'DevicePhoneBookFeatureSupportExtended'.
     */
    void sendDevicePhoneBookFeatureSupportExtendedRelUpRegAll ();

    /**
     * Returns the current value of the property
     * 'DevicePhoneBookFeatureSupportExtended' (as known by the proxy). This
     * method is only allowed to be called when a status message for this
     * property was received before. Otherwise the behavior of this method is
     * undefined. It is safe to call this method when
     * hasDevicePhoneBookFeatureSupportExtended() returns true.
     *
     * @return the previously received value of the property 'DevicePhoneBookFeatureSupportExtended'.
     */
    const DevicePhoneBookFeatureSupportExtendedStatus& getDevicePhoneBookFeatureSupportExtended() const;

    /**
     * Determines whether a status message for the property 'DevicePhoneBookFeatureSupportExtended' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasDevicePhoneBookFeatureSupportExtended() const;

    /**
     * Request the value of the property
     * 'DevicePhoneBookFeatureSupportExtended' from the CCA server. This
     * method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'DevicePhoneBookFeatureSupportExtended'</b>:
     *
     * Identifies support for the phone book list and call history list types for the connected devices.
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDevicePhoneBookFeatureSupportExtendedGet(DevicePhoneBookFeatureSupportExtendedCallbackIF& cb);

    // Property 'ProbablyLockedDevices'

    /**
     * Notify on the property 'ProbablyLockedDevices'. This method sends a
     * UpReg message to the CCA server.
     *
     * <b>Documentation of 'ProbablyLockedDevices'</b>:
     *
     * This property lists the connected phone devices (DeviceHandles) for which a phonebook has been started at some time in
     * the current connection cycle and the phone device has reported (and still reports) all phonebook repositories as empty,
     * but the phone device is already known by FC_Phonebook and a contact set is available in FC_Phonebook's database.
     *
     * Such a situation does not seem to be consistent and therefore HMI should be informed, so it could interact with the
     * user on this. We will denote such situation as "phone probably locked" for a dedicated phone device (DeviceHandle)
     * in the following.
     *
     * A situation of "phone probably locked" can e.g. appear as follows:
     * - A phone device had an empty battery, then is charged in the car (e.g. via USB) and becomes "alive". It might get
     * reconnected via BT then and a phonebook download might be started by FC_Phonebook, but this download would not really
     * succeed as expected with iPhones as they have a special security feature, which then after the phone device becomes
     * connected via BT, allows a PBAP connection, but reports all phonebook repositories as empty as long the user has not
     * entered the "security code", if the security lock is activated on the phone device.
     *
     * If a "phone probably locked" has been detected for a phone device by FC_Phonebook,
     * - FC_Phonebook will keep the related contacts in its database, but will not provide them to HMI, i.e. on a related
     * request by HMI, FC_Phonebook will answer as if the related list is empty.
     * - I.e. FC_Phonebook will answer dedicated requests by HMI - e.g. CreatePhonebookListExtended or similar - with
     * success, but will provide no contact details in related API requests, e.g. a SliceListRequest will be answered with
     * an empty list, a request for a manual phonebook download is returned with ERROR, ..
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendProbablyLockedDevicesUpReg(ProbablyLockedDevicesCallbackIF& cb);

    /**
     * Remove the notifcation on property 'ProbablyLockedDevices'. This method
     * sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'ProbablyLockedDevices'</b>:
     *
     * This property lists the connected phone devices (DeviceHandles) for which a phonebook has been started at some time in
     * the current connection cycle and the phone device has reported (and still reports) all phonebook repositories as empty,
     * but the phone device is already known by FC_Phonebook and a contact set is available in FC_Phonebook's database.
     *
     * Such a situation does not seem to be consistent and therefore HMI should be informed, so it could interact with the
     * user on this. We will denote such situation as "phone probably locked" for a dedicated phone device (DeviceHandle)
     * in the following.
     *
     * A situation of "phone probably locked" can e.g. appear as follows:
     * - A phone device had an empty battery, then is charged in the car (e.g. via USB) and becomes "alive". It might get
     * reconnected via BT then and a phonebook download might be started by FC_Phonebook, but this download would not really
     * succeed as expected with iPhones as they have a special security feature, which then after the phone device becomes
     * connected via BT, allows a PBAP connection, but reports all phonebook repositories as empty as long the user has not
     * entered the "security code", if the security lock is activated on the phone device.
     *
     * If a "phone probably locked" has been detected for a phone device by FC_Phonebook,
     * - FC_Phonebook will keep the related contacts in its database, but will not provide them to HMI, i.e. on a related
     * request by HMI, FC_Phonebook will answer as if the related list is empty.
     * - I.e. FC_Phonebook will answer dedicated requests by HMI - e.g. CreatePhonebookListExtended or similar - with
     * success, but will provide no contact details in related API requests, e.g. a SliceListRequest will be answered with
     * an empty list, a request for a manual phonebook download is returned with ERROR, ..
     *
     * @param act The act which was previously returned by the
     * sendProbablyLockedDevicesUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendProbablyLockedDevicesRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'ProbablyLockedDevices'.
     */
    void sendProbablyLockedDevicesRelUpRegAll ();

    /**
     * Returns the current value of the property 'ProbablyLockedDevices' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasProbablyLockedDevices() returns true.
     *
     * @return the previously received value of the property 'ProbablyLockedDevices'.
     */
    const ProbablyLockedDevicesStatus& getProbablyLockedDevices() const;

    /**
     * Determines whether a status message for the property 'ProbablyLockedDevices' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasProbablyLockedDevices() const;

    /**
     * Request the value of the property 'ProbablyLockedDevices' from the CCA
     * server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'ProbablyLockedDevices'</b>:
     *
     * This property lists the connected phone devices (DeviceHandles) for which a phonebook has been started at some time in
     * the current connection cycle and the phone device has reported (and still reports) all phonebook repositories as empty,
     * but the phone device is already known by FC_Phonebook and a contact set is available in FC_Phonebook's database.
     *
     * Such a situation does not seem to be consistent and therefore HMI should be informed, so it could interact with the
     * user on this. We will denote such situation as "phone probably locked" for a dedicated phone device (DeviceHandle)
     * in the following.
     *
     * A situation of "phone probably locked" can e.g. appear as follows:
     * - A phone device had an empty battery, then is charged in the car (e.g. via USB) and becomes "alive". It might get
     * reconnected via BT then and a phonebook download might be started by FC_Phonebook, but this download would not really
     * succeed as expected with iPhones as they have a special security feature, which then after the phone device becomes
     * connected via BT, allows a PBAP connection, but reports all phonebook repositories as empty as long the user has not
     * entered the "security code", if the security lock is activated on the phone device.
     *
     * If a "phone probably locked" has been detected for a phone device by FC_Phonebook,
     * - FC_Phonebook will keep the related contacts in its database, but will not provide them to HMI, i.e. on a related
     * request by HMI, FC_Phonebook will answer as if the related list is empty.
     * - I.e. FC_Phonebook will answer dedicated requests by HMI - e.g. CreatePhonebookListExtended or similar - with
     * success, but will provide no contact details in related API requests, e.g. a SliceListRequest will be answered with
     * an empty list, a request for a manual phonebook download is returned with ERROR, ..
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendProbablyLockedDevicesGet(ProbablyLockedDevicesCallbackIF& cb);

    // Property 'MissedCallIndicatorList'

    /**
     * Notify on the property 'MissedCallIndicatorList'. This method sends a
     * UpReg message to the CCA server.
     *
     * <b>Documentation of 'MissedCallIndicatorList'</b>:
     *
     * This property is an extension to the MissedCallIndicator property. It updates the MissedcallIndication for the list of devices connected via PBAP.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendMissedCallIndicatorListUpReg(MissedCallIndicatorListCallbackIF& cb);

    /**
     * Remove the notifcation on property 'MissedCallIndicatorList'. This
     * method sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'MissedCallIndicatorList'</b>:
     *
     * This property is an extension to the MissedCallIndicator property. It updates the MissedcallIndication for the list of devices connected via PBAP.
     *
     * @param act The act which was previously returned by the
     * sendMissedCallIndicatorListUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendMissedCallIndicatorListRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'MissedCallIndicatorList'.
     */
    void sendMissedCallIndicatorListRelUpRegAll ();

    /**
     * Returns the current value of the property 'MissedCallIndicatorList' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasMissedCallIndicatorList() returns true.
     *
     * @return the previously received value of the property 'MissedCallIndicatorList'.
     */
    const MissedCallIndicatorListStatus& getMissedCallIndicatorList() const;

    /**
     * Determines whether a status message for the property 'MissedCallIndicatorList' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasMissedCallIndicatorList() const;

    /**
     * Request the value of the property 'MissedCallIndicatorList' from the
     * CCA server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'MissedCallIndicatorList'</b>:
     *
     * This property is an extension to the MissedCallIndicator property. It updates the MissedcallIndication for the list of devices connected via PBAP.
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendMissedCallIndicatorListGet(MissedCallIndicatorListCallbackIF& cb);

    // Property 'PreferredSortOrderList'

    /**
     * Notify on the property 'PreferredSortOrderList'. This method sends a
     * UpReg message to the CCA server.
     *
     * <b>Documentation of 'PreferredSortOrderList'</b>:
     *
     * This property is an extension to the PreferredPhoneBookSortOrder property. It updates the PreferredSortOrder for the list of devices connected.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendPreferredSortOrderListUpReg(PreferredSortOrderListCallbackIF& cb);

    /**
     * Remove the notifcation on property 'PreferredSortOrderList'. This
     * method sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'PreferredSortOrderList'</b>:
     *
     * This property is an extension to the PreferredPhoneBookSortOrder property. It updates the PreferredSortOrder for the list of devices connected.
     *
     * @param act The act which was previously returned by the
     * sendPreferredSortOrderListUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendPreferredSortOrderListRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'PreferredSortOrderList'.
     */
    void sendPreferredSortOrderListRelUpRegAll ();

    /**
     * Returns the current value of the property 'PreferredSortOrderList' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasPreferredSortOrderList() returns true.
     *
     * @return the previously received value of the property 'PreferredSortOrderList'.
     */
    const PreferredSortOrderListStatus& getPreferredSortOrderList() const;

    /**
     * Determines whether a status message for the property 'PreferredSortOrderList' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasPreferredSortOrderList() const;

    /**
     * Request the value of the property 'PreferredSortOrderList' from the CCA
     * server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'PreferredSortOrderList'</b>:
     *
     * This property is an extension to the PreferredPhoneBookSortOrder property. It updates the PreferredSortOrder for the list of devices connected.
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendPreferredSortOrderListGet(PreferredSortOrderListCallbackIF& cb);

    /**
     * Set the value of the property 'PreferredSortOrderList'. This method
     * sends a PureSet message to the CCA server.
     *
     * <b>Documentation of 'PreferredSortOrderList'</b>:
     *
     * This property is an extension to the PreferredPhoneBookSortOrder property. It updates the PreferredSortOrder for the list of devices connected.
     *
     * @param oPreferredSortOrderList This is the enumeration of allowed phone book sort orders for each connected device.
     * HMI controllers should use this information to request the appropriate list order in the PhoneBookSortType enumeration within the CreatePhoneBookList.StartResultAck optype.
     */

    void sendPreferredSortOrderListPureSet(const ::most_PhonBk_fi_types_Extended::T_PhonBkPreferredSortOrderList& oPreferredSortOrderList);

    // Property 'PhonebookLanguage'

    /**
     * Notify on the property 'PhonebookLanguage'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'PhonebookLanguage'</b>:
     *
     * This property will set the language to the Phonebook F-Block and based on the set language the pre-defined message list will be provided to HMI.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendPhonebookLanguageUpReg(PhonebookLanguageCallbackIF& cb);

    /**
     * Remove the notifcation on property 'PhonebookLanguage'. This method
     * sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'PhonebookLanguage'</b>:
     *
     * This property will set the language to the Phonebook F-Block and based on the set language the pre-defined message list will be provided to HMI.
     *
     * @param act The act which was previously returned by the
     * sendPhonebookLanguageUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendPhonebookLanguageRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'PhonebookLanguage'.
     */
    void sendPhonebookLanguageRelUpRegAll ();

    /**
     * Returns the current value of the property 'PhonebookLanguage' (as known
     * by the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasPhonebookLanguage() returns true.
     *
     * @return the previously received value of the property 'PhonebookLanguage'.
     */
    const PhonebookLanguageStatus& getPhonebookLanguage() const;

    /**
     * Determines whether a status message for the property 'PhonebookLanguage' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasPhonebookLanguage() const;

    /**
     * Request the value of the property 'PhonebookLanguage' from the CCA
     * server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'PhonebookLanguage'</b>:
     *
     * This property will set the language to the Phonebook F-Block and based on the set language the pre-defined message list will be provided to HMI.
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendPhonebookLanguageGet(PhonebookLanguageCallbackIF& cb);

    /**
     * Set the value of the property 'PhonebookLanguage'. This method sends a
     * Set message to the CCA server.
     *
     * <b>Documentation of 'PhonebookLanguage'</b>:
     *
     * This property will set the language to the Phonebook F-Block and based on the set language the pre-defined message list will be provided to HMI.
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Set message.
     *
     * @param e8Language This will report the current vehicle language set.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendPhonebookLanguageSet(PhonebookLanguageCallbackIF& cb, ::most_PhonBk_fi_types_Extended::T_e8_PbkLanguage e8Language);

    // Property 'MaxContactCount'

    /**
     * Notify on the property 'MaxContactCount'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'MaxContactCount'</b>:
     *
     * This interface shall provide the ever highest number of phone book entries from all ever connected phones over lifetime.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendMaxContactCountUpReg(MaxContactCountCallbackIF& cb);

    /**
     * Remove the notifcation on property 'MaxContactCount'. This method sends
     * a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'MaxContactCount'</b>:
     *
     * This interface shall provide the ever highest number of phone book entries from all ever connected phones over lifetime.
     *
     * @param act The act which was previously returned by the
     * sendMaxContactCountUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendMaxContactCountRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'MaxContactCount'.
     */
    void sendMaxContactCountRelUpRegAll ();

    /**
     * Returns the current value of the property 'MaxContactCount' (as known
     * by the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasMaxContactCount() returns true.
     *
     * @return the previously received value of the property 'MaxContactCount'.
     */
    const MaxContactCountStatus& getMaxContactCount() const;

    /**
     * Determines whether a status message for the property 'MaxContactCount' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasMaxContactCount() const;

    /**
     * Request the value of the property 'MaxContactCount' from the CCA
     * server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'MaxContactCount'</b>:
     *
     * This interface shall provide the ever highest number of phone book entries from all ever connected phones over lifetime.
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendMaxContactCountGet(MaxContactCountCallbackIF& cb);

    /**
     * Release all property notifications (on all properties).
     */
    void sendRelUpRegAll ();

private:

    MOST_PhonBk_FIProxy (const std::string& portName, uint16 appId, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags);

    virtual void clearAllProperties ();

    ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > createCallback (uint16 fid, ::asf::cca::CcaTypes::ServiceData::OpCode opCode, uint16 commandCounter, void* cb);

    // Property 'FavoritesChanged'

    ::asf::core::nullable< FavoritesChangedStatus > _favoritesChanged;

    // Property 'ListChange'

    ::asf::core::nullable< ListChangeStatus > _listChange;

    // Property 'MissedCallIndicator'

    ::asf::core::nullable< MissedCallIndicatorStatus > _missedCallIndicator;

    // Property 'DevicePhoneBookFeatureSupport'

    ::asf::core::nullable< DevicePhoneBookFeatureSupportStatus > _devicePhoneBookFeatureSupport;

    // Property 'PreferredPhoneBookSortOrder'

    ::asf::core::nullable< PreferredPhoneBookSortOrderStatus > _preferredPhoneBookSortOrder;

    // Property 'DownloadState'

    ::asf::core::nullable< DownloadStateStatus > _downloadState;

    // Property 'DownloadStateExtended'

    ::asf::core::nullable< DownloadStateExtendedStatus > _downloadStateExtended;

    // Property 'DownloadProgress'

    ::asf::core::nullable< DownloadProgressStatus > _downloadProgress;

    // Property 'DownloadProgressList'

    ::asf::core::nullable< DownloadProgressListStatus > _downloadProgressList;

    // Property 'DownloadOnOffList'

    ::asf::core::nullable< DownloadOnOffListStatus > _downloadOnOffList;

    // Property 'AutomaticContactDownloadList'

    ::asf::core::nullable< AutomaticContactDownloadListStatus > _automaticContactDownloadList;

    // Property 'DevicePhoneBookFeatureSupportExtended'

    ::asf::core::nullable< DevicePhoneBookFeatureSupportExtendedStatus > _devicePhoneBookFeatureSupportExtended;

    // Property 'ProbablyLockedDevices'

    ::asf::core::nullable< ProbablyLockedDevicesStatus > _probablyLockedDevices;

    // Property 'MissedCallIndicatorList'

    ::asf::core::nullable< MissedCallIndicatorListStatus > _missedCallIndicatorList;

    // Property 'PreferredSortOrderList'

    ::asf::core::nullable< PreferredSortOrderListStatus > _preferredSortOrderList;

    // Property 'PhonebookLanguage'

    ::asf::core::nullable< PhonebookLanguageStatus > _phonebookLanguage;

    // Property 'MaxContactCount'

    ::asf::core::nullable< MaxContactCountStatus > _maxContactCount;

    DECLARE_CLASS_LOGGER();

    friend class MOST_PhonBk_FIProxyCallback;
};

} // namespace MOST_PhonBk_FI

#endif // MOST_PHONBK_FIPROXY_H
